// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.global;

import org.bytedeco.flycapture.FlyCapture2.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class FlyCapture2 extends org.bytedeco.flycapture.presets.FlyCapture2 {
    static { Loader.load(); }

// Parsed from <FlyCapture2Platform.h>

//=============================================================================
// Copyright © 2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: FlyCapture2Platform.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_FLYCAPTURE2PLATFORM_H
// #define PGR_FC2_FLYCAPTURE2PLATFORM_H

//=============================================================================
// Platform-specific header file for FlyCapture2.
//
// All the platform-specific code that is required by individual compilers
// to produce the appropriate code for each platform.
//=============================================================================

// #if defined(_WIN32) || defined(_WIN64)

// Windows 32-bit and 64-bit
// #ifdef FLYCAPTURE2_EXPORT
// #define FLYCAPTURE2_API __declspec( dllexport )
// #elif defined(FLYCAPTURE2_STATIC)
// #define FLYCAPTURE2_API
// #else
// #define FLYCAPTURE2_API __declspec( dllimport )
// #endif

// #if _MSC_VER > 1000
// #pragma once
// #endif

// Provide a common naming scheme for fixed-width integer types
// #ifdef _MSC_VER
// #if _MSC_VER >= 1600
// #include <cstdint>
// #else
//typedef __int8				int8_t;
//typedef unsigned __int8		uint8_t;
// #endif
// #elif __GNUC__ >=3
// #include <cstdint>
// #endif

// #elif defined(MAC_OSX)

// Mac OSX

// #else
// Linux and all others

// Using GCC 4 where hiding attributes is possible
// #define FLYCAPTURE2_API __attribute__ ((visibility ("default")))
// #define FLYCAPTURE2_LOCAL  __attribute__ ((visibility ("hidden")))

// #endif

// #endif // PGR_FC2_FLYCAPTURE2PLATFORM_H



// Parsed from <FlyCapture2Defs.h>

//=============================================================================
// Copyright (c) 2001-2018 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_FC2_FLYCAPTURE2DEFS_H
// #define FLIR_FC2_FLYCAPTURE2DEFS_H

// #include <memory.h>

//=============================================================================
// Definitions file for FlyCapture2.
//
// Holds structures, enumerations and other global definitions that are used
// across the entire FlyCapture2 API.
//=============================================================================

// #ifndef NULL
public static final int NULL = 0;
// #endif

// #ifndef FULL_32BIT_VALUE
public static final int FULL_32BIT_VALUE = 0x7FFFFFFF;
// #endif
    /**
     * \defgroup GlobalConstants Global constants
     */

    /*@{*/

    /** The maximum length that is allocated for a string. */
    @Namespace("FlyCapture2") @MemberGetter public static native @Cast("const unsigned int") int sk_maxStringLength();
    public static final int sk_maxStringLength = sk_maxStringLength();

    /** The maximum number of ports one device can have. */
    @Namespace("FlyCapture2") @MemberGetter public static native @Cast("const unsigned int") int sk_maxNumPorts();
    public static final int sk_maxNumPorts = sk_maxNumPorts();

    /*@}*/

    /**
     * \defgroup Enumerations Enumerations
     */

    /*@{*/

    /** The error types returned by functions. */
    /** enum FlyCapture2::ErrorType */
    public static final int
        /** Undefined */
        PGRERROR_UNDEFINED = -1,
        /** Function returned with no errors. */
        PGRERROR_OK = 0,
        /** General failure. */
        PGRERROR_FAILED = 1,
        /** Function has not been implemented. */
        PGRERROR_NOT_IMPLEMENTED = 2,
        /** Could not connect to Bus Master. */
        PGRERROR_FAILED_BUS_MASTER_CONNECTION = 3,
        /** Camera has not been connected. */
        PGRERROR_NOT_CONNECTED = 4,
        /** Initialization failed. */
        PGRERROR_INIT_FAILED = 5,
        /** Camera has not been initialized. */
        PGRERROR_NOT_INTITIALIZED = 6,
        /** Invalid parameter passed to function. */
        PGRERROR_INVALID_PARAMETER = 7,
        /** Setting set to camera is invalid. */
        PGRERROR_INVALID_SETTINGS = 8,
        /** Invalid Bus Manager object. */
        PGRERROR_INVALID_BUS_MANAGER = 9,
        /** Could not allocate memory. */
        PGRERROR_MEMORY_ALLOCATION_FAILED = 10,
        /** Low level error. */
        PGRERROR_LOW_LEVEL_FAILURE = 11,
        /** Device not found. */
        PGRERROR_NOT_FOUND = 12,
        /** GUID failure. */
        PGRERROR_FAILED_GUID = 13,
        /** Packet size set to camera is invalid. */
        PGRERROR_INVALID_PACKET_SIZE = 14,
        /** Invalid mode has been passed to function. */
        PGRERROR_INVALID_MODE = 15,
        /** Error due to not being in Format7. */
        PGRERROR_NOT_IN_FORMAT7 = 16,
        /** This feature is unsupported. */
        PGRERROR_NOT_SUPPORTED = 17,
        /** Timeout error. */
        PGRERROR_TIMEOUT = 18,
        /** Bus Master Failure. */
        PGRERROR_BUS_MASTER_FAILED = 19,
        /** Generation Count Mismatch. */
        PGRERROR_INVALID_GENERATION = 20,
        /** Look Up Table failure. */
        PGRERROR_LUT_FAILED = 21,
        /** IIDC failure. */
        PGRERROR_IIDC_FAILED = 22,
        /** Strobe failure. */
        PGRERROR_STROBE_FAILED = 23,
        /** Trigger failure. */
        PGRERROR_TRIGGER_FAILED = 24,
        /** Property failure. */
        PGRERROR_PROPERTY_FAILED = 25,
        /** Property is not present. */
        PGRERROR_PROPERTY_NOT_PRESENT = 26,
        /** Register access failed. */
        PGRERROR_REGISTER_FAILED = 27,
        /** Register read failed. */
        PGRERROR_READ_REGISTER_FAILED = 28,
        /** Register write failed. */
        PGRERROR_WRITE_REGISTER_FAILED = 29,
        /** Isochronous failure. */
        PGRERROR_ISOCH_FAILED = 30,
        /** Isochronous transfer has already been started. */
        PGRERROR_ISOCH_ALREADY_STARTED = 31,
        /** Isochronous transfer has not been started. */
        PGRERROR_ISOCH_NOT_STARTED = 32,
        /** Isochronous start failed. */
        PGRERROR_ISOCH_START_FAILED = 33,
        /** Isochronous retrieve buffer failed. */
        PGRERROR_ISOCH_RETRIEVE_BUFFER_FAILED = 34,
        /** Isochronous stop failed. */
        PGRERROR_ISOCH_STOP_FAILED = 35,
        /** Isochronous image synchronization failed. */
        PGRERROR_ISOCH_SYNC_FAILED = 36,
        /** Isochronous bandwidth exceeded. */
        PGRERROR_ISOCH_BANDWIDTH_EXCEEDED = 37,
        /** Image conversion failed. */
        PGRERROR_IMAGE_CONVERSION_FAILED = 38,
        /** Image library failure. */
        PGRERROR_IMAGE_LIBRARY_FAILURE = 39,
        /** Buffer is too small. */
        PGRERROR_BUFFER_TOO_SMALL = 40,
        /** There is an image consistency error. */
        PGRERROR_IMAGE_CONSISTENCY_ERROR = 41,
        /** The installed driver is not compatible with the library. */
        PGRERROR_INCOMPATIBLE_DRIVER = 42,
        PGRERROR_FORCE_32BITS = FULL_32BIT_VALUE;

    /** The type of bus callback to register a callback function for. */
    /** enum FlyCapture2::BusCallbackType */
    public static final int
        /** Register for all bus events. */
        BUS_RESET = 0,
        /** Register for arrivals only. */
        ARRIVAL = 1,
        /** Register for removals only. */
        REMOVAL = 2,
        CALLBACK_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * The grab strategy employed during image transfer. This type controls
     * how images that stream off the camera accumulate in a user buffer
     * for handling.
     */
    /*
       @remark Unlike earlier versions of the FlyCapture SDK, it is no longer
     * necessary to explicitly start the image grabbing process before
     * specifying an image grabbing mode.
     */
    /** enum FlyCapture2::GrabMode */
    public static final int
        /**
         * Grabs the newest image in the user buffer each time the
         * RetrieveBuffer() function is called. Older images are dropped
         * instead of accumulating in the user buffer. Grabbing blocks if the
         * camera has not finished transmitting the next available image. If
         * the camera is transmitting images faster than the application can
         * grab them, images may be dropped and only the most recent image
         * is stored for grabbing. Note that this mode is the equivalent of
         * flycaptureLockLatest in earlier versions of the FlyCapture SDK.
         */
        DROP_FRAMES = 0,

        /**
         * Images accumulate in the user buffer, and the oldest image is
         * grabbed for handling before being discarded. This member can be
         * used to guarantee that each image is seen. However, image processing
         * time must not exceed transmission time from the camera to the
         * buffer. Grabbing blocks if the camera has not finished transmitting
         * the next available image. The buffer size is controlled by the
         * numBuffers parameter in the FC2Config struct. Note that this mode is
         * the equivalent of flycaptureLockNext in earlier versions of the
         * FlyCapture SDK.
         */
        BUFFER_FRAMES = 1,

        /**
         * Unspecified grab mode.
         */
        UNSPECIFIED_GRAB_MODE = 2,
        GRAB_MODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Timeout options for grabbing images. */
    /** enum FlyCapture2::GrabTimeout */
    public static final int
        /**  Non-blocking wait. */
        TIMEOUT_NONE = 0,
        /**  Wait indefinitely. */
        TIMEOUT_INFINITE = -1,
        /** Unspecified timeout setting. */
        TIMEOUT_UNSPECIFIED = -2,
        GRAB_TIMEOUT_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Bandwidth allocation options for 1394 devices. */
    /** enum FlyCapture2::BandwidthAllocation */
    public static final int
        /** Do not allocate bandwidth. */
        BANDWIDTH_ALLOCATION_OFF = 0,
        /** Allocate bandwidth. This is the default setting. */
        BANDWIDTH_ALLOCATION_ON = 1,
        /**
         * Bandwidth allocation is not supported by either the camera or
         * operating system.
         */
        BANDWIDTH_ALLOCATION_UNSUPPORTED = 2,
        /** Not specified. This leaves the current setting unchanged. */
        BANDWIDTH_ALLOCATION_UNSPECIFIED = 3,
        BANDWIDTH_ALLOCATION_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Interfaces that a camera may use to communicate with a host. */
    /** enum FlyCapture2::InterfaceType */
    public static final int
        /** IEEE-1394 (Includes 1394a and 1394b). */
        INTERFACE_IEEE1394 = 0,
        /** USB 2.0. */
        INTERFACE_USB2 = 1,
        /** USB 3.0. */
        INTERFACE_USB3 = 2,
        /** GigE. */
        INTERFACE_GIGE = 3,
        /** Unknown interface. */
        INTERFACE_UNKNOWN = 4,
        INTERFACE_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * Camera properties. Not all properties may be supported, depending
     * on the camera model.
     */
    /** enum FlyCapture2::PropertyType */
    public static final int
        /** Brightness. */
        BRIGHTNESS = 0,
        /** Auto exposure. */
        AUTO_EXPOSURE = 1,
        /** Sharpness */
        SHARPNESS = 2,
        /** White balance. */
        WHITE_BALANCE = 3,
        /** Hue. */
        HUE = 4,
        /** Saturation. */
        SATURATION = 5,
        /** Gamma. */
        GAMMA = 6,
        /** Iris. */
        IRIS = 7,
        /** Focus. */
        FOCUS = 8,
        /** Zoom. */
        ZOOM = 9,
        /** Pan. */
        PAN = 10,
        /** Tilt. */
        TILT = 11,
        /** Shutter. */
        SHUTTER = 12,
        /** Gain. */
        GAIN = 13,
        /** Trigger mode. */
        TRIGGER_MODE = 14,
        /** Trigger delay. */
        TRIGGER_DELAY = 15,
        /** Frame rate. */
        FRAME_RATE = 16,
        /** Temperature. */
        TEMPERATURE = 17,
        /** Unspecified property type. */
        UNSPECIFIED_PROPERTY_TYPE = 18,
        PROPERTY_TYPE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Frame rates in frames per second. */
    /** enum FlyCapture2::FrameRate */
    public static final int
        /** 1.875 fps. */
        FRAMERATE_1_875 = 0,
        /** 3.75 fps. */
        FRAMERATE_3_75 = 1,
        /** 7.5 fps. */
        FRAMERATE_7_5 = 2,
        /** 15 fps. */
        FRAMERATE_15 = 3,
        /** 30 fps. */
        FRAMERATE_30 = 4,
        /** 60 fps. */
        FRAMERATE_60 = 5,
        /** 120 fps. */
        FRAMERATE_120 = 6,
        /** 240 fps. */
        FRAMERATE_240 = 7,
        /** Custom frame rate for Format7 functionality. */
        FRAMERATE_FORMAT7 = 8,
        /** Number of possible camera frame rates. */
        NUM_FRAMERATES = 9,
        FRAMERATE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** DCAM video modes. */
    /** enum FlyCapture2::VideoMode */
    public static final int
        /** 160x120 YUV444. */
        VIDEOMODE_160x120YUV444 = 0,
        /** 320x240 YUV422. */
        VIDEOMODE_320x240YUV422 = 1,
        /** 640x480 YUV411. */
        VIDEOMODE_640x480YUV411 = 2,
        /** 640x480 YUV422. */
        VIDEOMODE_640x480YUV422 = 3,
        /** 640x480 24-bit RGB. */
        VIDEOMODE_640x480RGB = 4,
        /** 640x480 8-bit. */
        VIDEOMODE_640x480Y8 = 5,
        /** 640x480 16-bit. */
        VIDEOMODE_640x480Y16 = 6,
        /** 800x600 YUV422. */
        VIDEOMODE_800x600YUV422 = 7,
        /** 800x600 RGB. */
        VIDEOMODE_800x600RGB = 8,
        /** 800x600 8-bit. */
        VIDEOMODE_800x600Y8 = 9,
        /** 800x600 16-bit. */
        VIDEOMODE_800x600Y16 = 10,
        /** 1024x768 YUV422. */
        VIDEOMODE_1024x768YUV422 = 11,
        /** 1024x768 RGB. */
        VIDEOMODE_1024x768RGB = 12,
        /** 1024x768 8-bit. */
        VIDEOMODE_1024x768Y8 = 13,
        /** 1024x768 16-bit. */
        VIDEOMODE_1024x768Y16 = 14,
        /** 1280x960 YUV422. */
        VIDEOMODE_1280x960YUV422 = 15,
        /** 1280x960 RGB. */
        VIDEOMODE_1280x960RGB = 16,
        /** 1280x960 8-bit. */
        VIDEOMODE_1280x960Y8 = 17,
        /** 1280x960 16-bit. */
        VIDEOMODE_1280x960Y16 = 18,
        /** 1600x1200 YUV422. */
        VIDEOMODE_1600x1200YUV422 = 19,
        /** 1600x1200 RGB. */
        VIDEOMODE_1600x1200RGB = 20,
        /** 1600x1200 8-bit. */
        VIDEOMODE_1600x1200Y8 = 21,
        /** 1600x1200 16-bit. */
        VIDEOMODE_1600x1200Y16 = 22,
        /** Custom video mode for Format7 functionality. */
        VIDEOMODE_FORMAT7 = 23,
        /** Number of possible video modes. */
        NUM_VIDEOMODES = 24,
        VIDEOMODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Camera modes for DCAM formats as well as Format7. */
    /** enum FlyCapture2::Mode */
    public static final int
        MODE_0 = 0,
        MODE_1 = 1,
        MODE_2 = 2,
        MODE_3 = 3,
        MODE_4 = 4,
        MODE_5 = 5,
        MODE_6 = 6,
        MODE_7 = 7,
        MODE_8 = 8,
        MODE_9 = 9,
        MODE_10 = 10,
        MODE_11 = 11,
        MODE_12 = 12,
        MODE_13 = 13,
        MODE_14 = 14,
        MODE_15 = 15,
        MODE_16 = 16,
        MODE_17 = 17,
        MODE_18 = 18,
        MODE_19 = 19,
        MODE_20 = 20,
        MODE_21 = 21,
        MODE_22 = 22,
        MODE_23 = 23,
        MODE_24 = 24,
        MODE_25 = 25,
        MODE_26 = 26,
        MODE_27 = 27,
        MODE_28 = 28,
        MODE_29 = 29,
        MODE_30 = 30,
        MODE_31 = 31,
        /** Number of modes */
        NUM_MODES = 32,
        MODE_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Pixel formats available for Format7 modes. */
    /** enum FlyCapture2::PixelFormat */
    public static final int
        /** 8 bits of mono information. */
        PIXEL_FORMAT_MONO8     = 0x80000000,
        /** YUV 4:1:1. */
        PIXEL_FORMAT_411YUV8   = 0x40000000,
        /** YUV 4:2:2. */
        PIXEL_FORMAT_422YUV8   = 0x20000000,
        /** YUV 4:4:4. */
        PIXEL_FORMAT_444YUV8   = 0x10000000,
        /** R = G = B = 8 bits. */
        PIXEL_FORMAT_RGB8      = 0x08000000,
        /** 16 bits of mono information. */
        PIXEL_FORMAT_MONO16    = 0x04000000,
        /** R = G = B = 16 bits. */
        PIXEL_FORMAT_RGB16     = 0x02000000,
        /** 16 bits of signed mono information. */
        PIXEL_FORMAT_S_MONO16  = 0x01000000,
        /** R = G = B = 16 bits signed. */
        PIXEL_FORMAT_S_RGB16   = 0x00800000,
        /** 8 bit raw data output of sensor. */
        PIXEL_FORMAT_RAW8      = 0x00400000,
        /** 16 bit raw data output of sensor. */
        PIXEL_FORMAT_RAW16     = 0x00200000,
        /** 12 bits of mono information. */
        PIXEL_FORMAT_MONO12    = 0x00100000,
        /** 12 bit raw data output of sensor. */
        PIXEL_FORMAT_RAW12     = 0x00080000,
        /** 24 bit BGR. */
        PIXEL_FORMAT_BGR       = 0x80000008,
        /** 32 bit BGRU. */
        PIXEL_FORMAT_BGRU      = 0x40000008,
        /** 24 bit RGB. */
        PIXEL_FORMAT_RGB       = PIXEL_FORMAT_RGB8,
        /** 32 bit RGBU. */
        PIXEL_FORMAT_RGBU      = 0x40000002,
        /** R = G = B = 16 bits. */
        PIXEL_FORMAT_BGR16     = 0x02000001,
        /** 64 bit BGRU. */
        PIXEL_FORMAT_BGRU16    = 0x02000002,
        /** JPEG compressed stream. */
        PIXEL_FORMAT_422YUV8_JPEG      = 0x40000001,
        /** Number of pixel formats. */
        NUM_PIXEL_FORMATS      = 20,
        /** Unspecified pixel format. */
        UNSPECIFIED_PIXEL_FORMAT = 0;

    /** Bus speeds. */
    /** enum FlyCapture2::BusSpeed */
    public static final int
        /** 100Mbits/sec. */
        BUSSPEED_S100 = 0,
        /** 200Mbits/sec. */
        BUSSPEED_S200 = 1,
        /** 400Mbits/sec. */
        BUSSPEED_S400 = 2,
        /** 480Mbits/sec. Only for USB2 cameras. */
        BUSSPEED_S480 = 3,
        /** 800Mbits/sec. */
        BUSSPEED_S800 = 4,
        /** 1600Mbits/sec. */
        BUSSPEED_S1600 = 5,
        /** 3200Mbits/sec. */
        BUSSPEED_S3200 = 6,
        /** 5000Mbits/sec. Only for USB3 cameras. */
        BUSSPEED_S5000 = 7,
        /** 10Base-T. Only for GigE Vision cameras. */
        BUSSPEED_10BASE_T = 8,
        /** 100Base-T.  Only for GigE Vision cameras.*/
        BUSSPEED_100BASE_T = 9,
        /** 1000Base-T (Gigabit Ethernet).  Only for GigE Vision cameras. */
        BUSSPEED_1000BASE_T = 10,
        /** 10000Base-T.  Only for GigE Vision cameras. */
        BUSSPEED_10000BASE_T = 11,
        /** The fastest speed available. */
        BUSSPEED_S_FASTEST = 12,
        /** Any speed that is available. */
        BUSSPEED_ANY = 13,
        /** Unknown bus speed. */
        BUSSPEED_SPEED_UNKNOWN = -1,
        BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

    /** enum FlyCapture2::PCIeBusSpeed */
    public static final int
        PCIE_BUSSPEED_2_5 = 0, /** 2.5 Gb/s */
        PCIE_BUSSPEED_5_0 = 1, /** 5.0 Gb/s */
        PCIE_BUSSPEED_UNKNOWN = -1, /** Speed is unknown */
        PCIE_BUSSPEED_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Types of low level drivers that flycapture uses. */
    /** enum FlyCapture2::DriverType */
    public static final int
        /** PGRCam.sys. */
        DRIVER_1394_CAM = 0,
        /** PGR1394.sys. */
        DRIVER_1394_PRO = 1,
        /** firewire_core. */
        DRIVER_1394_JUJU = 2,
        /** video1394. */
        DRIVER_1394_VIDEO1394 = 3,
        /** raw1394. */
        DRIVER_1394_RAW1394 = 4,
        /** No usb driver used just BSD stack. (Linux only) */
        DRIVER_USB_NONE = 5,
        /** PGRUsbCam.sys. */
        DRIVER_USB_CAM = 6,
        /** PGRXHCI.sys. */
        DRIVER_USB3_PRO = 7,
        /** no gige drivers used,MS/BSD stack. */
        DRIVER_GIGE_NONE = 8,
        /** PGRGigE.sys. */
        DRIVER_GIGE_FILTER = 9,
        /** PGRGigEPro.sys. */
        DRIVER_GIGE_PRO = 10,
        /** PgrLwf.sys. */
        DRIVER_GIGE_LWF = 11,
        /** Unknown driver type. */
        DRIVER_UNKNOWN = -1,
        DRIVER_FORCE_32BITS = FULL_32BIT_VALUE;

    /**
     * Color processing algorithms. Please refer to our knowledge base at
     * article at http://www.ptgrey.com/support/kb/index.asp?a=4&q=33 for
     * complete details for each algorithm.
     */
    /** enum FlyCapture2::ColorProcessingAlgorithm */
    public static final int
        /** Default method. */
        DEFAULT = 0,
        /** No color processing. */
        NO_COLOR_PROCESSING = 1,
        /**
         * Fastest but lowest quality. Equivalent to
         * FLYCAPTURE_NEAREST_NEIGHBOR_FAST in FlyCapture.
         */
        NEAREST_NEIGHBOR = 2,
        /** Weights surrounding pixels based on localized edge orientation. */
        EDGE_SENSING = 3,
        /** Well-balanced speed and quality. */
        HQ_LINEAR = 4,
        /** Slowest but produces good results. */
        RIGOROUS = 5,
        /** Multithreaded with similar results to edge sensing. */
        IPP = 6,
        /** Best quality but much faster than rigorous. */
        DIRECTIONAL_FILTER = 7,
        /** Weighted pixel average from different directions*/
        WEIGHTED_DIRECTIONAL_FILTER = 8,

        COLOR_PROCESSING_ALGORITHM_FORCE_32BITS = FULL_32BIT_VALUE;

    /** Bayer tile formats. */
    /** enum FlyCapture2::BayerTileFormat */
    public static final int
        /** No bayer tile format. */
        NONE = 0,
        /** Red-Green-Green-Blue. */
        RGGB = 1,
        /** Green-Red-Blue-Green. */
        GRBG = 2,
        /** Green-Blue-Red-Green. */
        GBRG = 3,
        /** Blue-Green-Green-Red. */
        BGGR = 4,
        BT_FORCE_32BITS = FULL_32BIT_VALUE;

    /** File formats to be used for saving images to disk. */
    /** enum FlyCapture2::ImageFileFormat */
    public static final int
        /** Determine file format from file extension. */
        FROM_FILE_EXT = -1,
        /** Portable gray map. */
        PGM = 0,
        /** Portable pixmap. */
        PPM = 1,
        /** Bitmap. */
        BMP = 2,
        /** JPEG. */
        JPEG = 3,
        /** JPEG 2000. */
        JPEG2000 = 4,
        /** Tagged image file format. */
        TIFF = 5,
        /** Portable network graphics. */
        PNG = 6,
        /** Raw data. */
        RAW = 7,
        IMAGE_FILE_FORMAT_FORCE_32BITS = FULL_32BIT_VALUE;

    /*@}*/

    /**
     * \defgroup GigEEnums GigE specific enumerations
     *
     * These enumerations are specific to GigE camera operation only.
     */

    /*@{*/

    /** Possible properties that can be queried from the camera. */
    /** enum FlyCapture2::GigEPropertyType */
    public static final int
        HEARTBEAT = 0,
        HEARTBEAT_TIMEOUT = 1,
        PACKET_SIZE = 2,
        PACKET_DELAY = 3;
// Targeting ..\FlyCapture2\FC2Version.java


// Targeting ..\FlyCapture2\PGRGuid.java


// Targeting ..\FlyCapture2\IPAddress.java


// Targeting ..\FlyCapture2\MACAddress.java


// Targeting ..\FlyCapture2\GigEProperty.java


// Targeting ..\FlyCapture2\GigEStreamChannel.java


// Targeting ..\FlyCapture2\GigEConfig.java


// Targeting ..\FlyCapture2\GigEImageSettingsInfo.java


// Targeting ..\FlyCapture2\GigEImageSettings.java


// Targeting ..\FlyCapture2\Format7ImageSettings.java


// Targeting ..\FlyCapture2\Format7Info.java


// Targeting ..\FlyCapture2\Format7PacketInfo.java


// Targeting ..\FlyCapture2\FC2Config.java


// Targeting ..\FlyCapture2\PropertyInfo.java



    /** The TriggerDelayInfo structure is identical to PropertyInfo. */
// Targeting ..\FlyCapture2\Property.java



    /** The TriggerDelay structure is identical to Property. */
// Targeting ..\FlyCapture2\TriggerModeInfo.java


// Targeting ..\FlyCapture2\TriggerMode.java


// Targeting ..\FlyCapture2\StrobeInfo.java


// Targeting ..\FlyCapture2\StrobeControl.java


// Targeting ..\FlyCapture2\TimeStamp.java


// Targeting ..\FlyCapture2\ConfigROM.java


// Targeting ..\FlyCapture2\CameraInfo.java


// Targeting ..\FlyCapture2\EmbeddedImageInfoProperty.java


// Targeting ..\FlyCapture2\EmbeddedImageInfo.java


// Targeting ..\FlyCapture2\ImageMetadata.java


// Targeting ..\FlyCapture2\LUTData.java


// Targeting ..\FlyCapture2\CameraStats.java


// Targeting ..\FlyCapture2\PNGOption.java


// Targeting ..\FlyCapture2\PPMOption.java


// Targeting ..\FlyCapture2\PGMOption.java


// Targeting ..\FlyCapture2\TIFFOption.java


// Targeting ..\FlyCapture2\JPEGOption.java


// Targeting ..\FlyCapture2\JPG2Option.java


// Targeting ..\FlyCapture2\BMPOption.java


// Targeting ..\FlyCapture2\CameraEventCallback.java


// Targeting ..\FlyCapture2\EventOptions.java


// Targeting ..\FlyCapture2\EventCallbackData.java


    /*@}*/

    /*@}*/


// #endif // FLIR_FC2_FLYCAPTURE2DEFS_H



// Parsed from <Error.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: Error.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_ERROR_H
// #define PGR_FC2_ERROR_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// #include <stdio.h>
// Targeting ..\FlyCapture2\ErrorImpl.java


// Targeting ..\FlyCapture2\Error.java




// #endif // PGR_FC2_ERROR_H


// Parsed from <BusManager.h>

//=============================================================================
// Copyright © 2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef PGR_FC2_BUSMANAGER_H
// #define PGR_FC2_BUSMANAGER_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// Targeting ..\FlyCapture2\BusEventCallback.java


// Targeting ..\FlyCapture2\CallbackHandle.java


// Targeting ..\FlyCapture2\BusManager.java




// #endif //PGR_FC2_BUSMANAGER_H


// Parsed from <CameraBase.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: CameraBase.h 347612 2017-12-01 20:44:28Z wgallego $
//=============================================================================

// #ifndef PGR_FC2_CAMERABASE_H_
// #define PGR_FC2_CAMERABASE_H_

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// Targeting ..\FlyCapture2\ImageEventCallback.java


// Targeting ..\FlyCapture2\CameraBase.java




// #endif // PGR_FC2_CAMERABASE_H_


// Parsed from <Camera.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: Camera.h 347612 2017-12-01 20:44:28Z wgallego $
//=============================================================================

// #ifndef PGR_FC2_CAMERA_H_
// #define PGR_FC2_CAMERA_H_

// #include "CameraBase.h"
// Targeting ..\FlyCapture2\Camera.java




// #endif // PGR_FC2_CAMERA_H_


// Parsed from <GigECamera.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: GigECamera.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_GIGECAMERA_H_
// #define PGR_FC2_GIGECAMERA_H_

// #include "CameraBase.h"
// Targeting ..\FlyCapture2\GigECamera.java




// #endif // PGR_FC2_GIGECAMERA_H_


// Parsed from <Image.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: Image.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_IMAGE_H
// #define PGR_FC2_IMAGE_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// Targeting ..\FlyCapture2\Image.java




// #endif //PGR_FC2_IMAGE_H


// Parsed from <Utilities.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: Utilities.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_UTILITIES_H_
// #define PGR_FC2_UTILITIES_H_

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// #include <string>

	/** Possible operating systems. */
	/** enum FlyCapture2::OSType */
	public static final int
		/** All Windows 32-bit variants. */
		WINDOWS_X86 = 0,
		/** All Windows 64-bit variants. */
		WINDOWS_X64 = 1,
		/** All Linux 32-bit variants. */
		LINUX_X86 = 2,
		/** All Linux 32-bit variants. */
		LINUX_X64 = 3,
		/** Mac OSX. */
		MAC = 4,
		/** Unknown operating system. */
		UNKNOWN_OS = 5,
		OSTYPE_FORCE_32BITS = FULL_32BIT_VALUE;

	/** Possible byte orders. */
	/** enum FlyCapture2::ByteOrder */
	public static final int
		BYTE_ORDER_LITTLE_ENDIAN = 0,
		BYTE_ORDER_BIG_ENDIAN = 1,
		BYTE_ORDER_FORCE_32BITS = FULL_32BIT_VALUE;
// Targeting ..\FlyCapture2\SystemInfo.java


// Targeting ..\FlyCapture2\AsyncCommandCallback.java


// Targeting ..\FlyCapture2\Utilities.java





// #endif // PGR_FC2_UTILITIES_H_



// Parsed from <TopologyNode.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: TopologyNode.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_TOPOLOGYNODE_H
// #define PGR_FC2_TOPOLOGYNODE_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// Targeting ..\FlyCapture2\TopologyNode.java




// #endif


// Parsed from <ImageStatistics.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id: ImageStatistics.h 316355 2017-02-20 23:02:28Z alin $
//=============================================================================

// #ifndef PGR_FC2_IMAGESTATISTICS_H
// #define PGR_FC2_IMAGESTATISTICS_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2Defs.h"
// Targeting ..\FlyCapture2\ImageStatistics.java




// #endif


// Parsed from <FlyCapture2VideoDefs.h>

//=============================================================================
// Copyright (c) 2001-2018 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_FLYCAPTURE2VIDEODEFS_H
// #define FLIR_FLYCAPTURE2VIDEODEFS_H

// #include <memory.h>
// Targeting ..\FlyCapture2\MJPGOption.java


// Targeting ..\FlyCapture2\H264Option.java


// Targeting ..\FlyCapture2\AVIOption.java



    /*@}*/


// #endif // FLIR_FLYCAPTURE2VIDEODEFS_H

// Parsed from <FlyCapture2Video.h>

//=============================================================================
// Copyright (c) 2001-2018 FLIR Systems, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

// #ifndef FLIR_FLYCAPTURE2VIDEO_H
// #define FLIR_FLYCAPTURE2VIDEO_H

// #include "FlyCapture2Platform.h"
// #include "FlyCapture2VideoDefs.h"
// Targeting ..\FlyCapture2\FlyCapture2Video.java




// #endif // FLIR_FLYCAPTURE2VIDEO_H


// Parsed from <MultiSyncLibraryPlatform.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARYPLATFORM_H
// #define MULTISYNCLIBRARYPLATFORM_H

//=============================================================================
// Platform-specific header file for MultiSunc Library.
//
// All the platform-specific code that is required by individual compilers
// to produce the appropriate code for each platform.
//=============================================================================

// #if defined(_WIN32) || defined(_WIN64)

// Windows 32-bit and 64-bit
// #ifdef MULTISYNCLIBRARY_EXPORT
// #define MULTISYNCLIBRARY_API __declspec( dllexport )
// #elif defined(MULTISYNCLIBRARY_STATIC)
// #define MULTISYNCLIBRARY_API
// #else
// #define MULTISYNCLIBRARY_API __declspec( dllimport )
// #endif

// #if _MSC_VER > 1000
// #pragma once
// #endif

// #elif defined(MAC_OSX)

// Mac OSX

// #else
// Linux and all others

// Using GCC 4 where hiding attributes is possible
// #define MULTISYNCLIBRARY_API __attribute__ ((visibility ("default")))
// #define MULTISYNCLIBRARY_LOCAL  __attribute__ ((visibility ("hidden")))

// #endif

// #endif // MULTISYNCLIBRARYPLATFORM_H



// Parsed from <MultiSyncLibraryDefs.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================

//=============================================================================
// $Id:
//=============================================================================

// #ifndef MULTISYNCLIBRARYDEFS_H
// #define MULTISYNCLIBRARYDEFS_H

// #include <memory.h>

//=============================================================================
// Definitions file for MultiSync Library.
//
// Holds structures, enumerations and other global definitions that are used
// across the entire MultiSync API.
//=============================================================================
	/** enum MultiSyncLibrary::PGRSyncError */
	public static final int
		PGRSyncError_OK = 0,
		PGRSyncError_FAILED = 1,
		PGRSyncError_ALREADY_STARTED = 2,
		PGRSyncError_ALREADY_STOPPED = 3,
		PGRSyncError_CAMERA_NOT_FOUND = 4,
		PGRSyncError_UNKNOWN_ERROR = 5;

	/** enum MultiSyncLibrary::PGRSyncMessage */
	public static final int
		PGRSyncMessage_OK = 0,
		PGRSyncMessage_STARTED = 1,
		PGRSyncMessage_STOPPED = 2,
		PGRSyncMessage_SYNCING = 3,
		PGRSyncMessage_NOMASTER = 4,
		PGRSyncMessage_THREAD_ERROR = 5,
		PGRSyncMessage_DEVICE_ERROR = 6,
		PGRSyncMessage_NOT_ENOUGH_DEVICES = 7,
		PGRSyncMessage_BUS_RESET = 8,
		PGRSyncMessage_NOT_INITIALIZED = 9,
		PGRSyncMessage_UNKNOWN_ERROR = 10;
// Targeting ..\FlyCapture2\SyncManager.java




// #endif //MULTISYNCLIBRARYDEFS_H


// Parsed from <MultiSyncLibrary.h>

//=============================================================================
// Copyright  2017 FLIR Integrated Imaging Solutions, Inc. All Rights Reserved.
//
// This software is the confidential and proprietary information of FLIR
// Integrated Imaging Solutions, Inc. ("Confidential Information"). You
// shall not disclose such Confidential Information and shall use it only in
// accordance with the terms of the license agreement you entered into
// with FLIR Integrated Imaging Solutions, Inc. (FLIR).
//
// FLIR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT. FLIR SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
// THIS SOFTWARE OR ITS DERIVATIVES.
//=============================================================================
//=============================================================================
// $Id: $
//=============================================================================

// #ifndef MULTISYNCLIBRARY_H
// #define MULTISYNCLIBRARY_H

//=============================================================================
// Global header file for MultiSync Library.
//
// By including this file, all required header files for full MultiSync Library
// operation will be included automatically. It is recommended that this file
// be used instead of manually including individual header files.
//=============================================================================

//=============================================================================
// Platform-specific definitions
//=============================================================================
// #include "MultiSyncLibraryPlatform.h"

//=============================================================================
// Global definitions
//=============================================================================
// #include "MultiSyncLibraryDefs.h"

// #endif // MULTISYNCLIBRARY_H


}
