// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.flycapture.FlyCapture2;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.flycapture.global.FlyCapture2.*;


    /** Options for saving JPEG image. */
    @Namespace("FlyCapture2") @NoOffset @Properties(inherit = org.bytedeco.flycapture.presets.FlyCapture2.class)
public class JPEGOption extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public JPEGOption(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public JPEGOption(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public JPEGOption position(long position) {
            return (JPEGOption)super.position(position);
        }
        @Override public JPEGOption getPointer(long i) {
            return new JPEGOption((Pointer)this).offsetAddress(i);
        }
    
        /** Whether to save as a progressive JPEG file. */
        public native @Cast("bool") boolean progressive(); public native JPEGOption progressive(boolean setter);
        /**
         * JPEG image quality in range (0-100).
         * - 100 - Superb quality.
         * - 75  - Good quality.
         * - 50  - Normal quality.
         * - 10  - Poor quality.
         */
        public native @Cast("unsigned int") int quality(); public native JPEGOption quality(int setter);
        /** Reserved for future use. */
        public native @Cast("unsigned int") int reserved(int i); public native JPEGOption reserved(int i, int setter);
        @MemberGetter public native @Cast("unsigned int*") IntPointer reserved();

        public JPEGOption() { super((Pointer)null); allocate(); }
        private native void allocate();
    }
