// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.gsl.global;

import org.bytedeco.gsl.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

public class gsl extends org.bytedeco.gsl.presets.gsl {
    static { Loader.load(); }

// Parsed from gsl/gsl_types.h

/* gsl_types.h
 * 
 * Copyright (C) 2001, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_TYPES_H__
// #define __GSL_TYPES_H__

// #ifndef GSL_VAR

// #ifdef WIN32
// #  ifdef GSL_DLL
// #    ifdef DLL_EXPORT
// #      define GSL_VAR extern __declspec(dllexport)
// #    else
// #      define GSL_VAR extern __declspec(dllimport)
// #    endif
// #  else
// #    define GSL_VAR extern
// #  endif
// #else
// #  define GSL_VAR extern
// #endif

// #endif

// #endif /* __GSL_TYPES_H__ */


// Parsed from gsl/gsl_errno.h

/* err/gsl_errno.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_ERRNO_H__
// #define __GSL_ERRNO_H__

// #include <stdio.h>
// #include <errno.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/** enum  */
public static final int 
  GSL_SUCCESS  = 0, 
  GSL_FAILURE  = -1,
  GSL_CONTINUE = -2,  /* iteration has not converged */
  GSL_EDOM     = 1,   /* input domain error, e.g sqrt(-1) */
  GSL_ERANGE   = 2,   /* output range error, e.g. exp(1e100) */
  GSL_EFAULT   = 3,   /* invalid pointer */
  GSL_EINVAL   = 4,   /* invalid argument supplied by user */
  GSL_EFAILED  = 5,   /* generic failure */
  GSL_EFACTOR  = 6,   /* factorization failed */
  GSL_ESANITY  = 7,   /* sanity check failed - shouldn't happen */
  GSL_ENOMEM   = 8,   /* malloc failed */
  GSL_EBADFUNC = 9,   /* problem with user-supplied function */
  GSL_ERUNAWAY = 10,  /* iterative process is out of control */
  GSL_EMAXITER = 11,  /* exceeded max number of iterations */
  GSL_EZERODIV = 12,  /* tried to divide by zero */
  GSL_EBADTOL  = 13,  /* user specified an invalid tolerance */
  GSL_ETOL     = 14,  /* failed to reach the specified tolerance */
  GSL_EUNDRFLW = 15,  /* underflow */
  GSL_EOVRFLW  = 16,  /* overflow  */
  GSL_ELOSS    = 17,  /* loss of accuracy */
  GSL_EROUND   = 18,  /* failed because of roundoff error */
  GSL_EBADLEN  = 19,  /* matrix, vector lengths are not conformant */
  GSL_ENOTSQR  = 20,  /* matrix not square */
  GSL_ESING    = 21,  /* apparent singularity detected */
  GSL_EDIVERGE = 22,  /* integral or series is divergent */
  GSL_EUNSUP   = 23,  /* requested feature is not supported by the hardware */
  GSL_EUNIMPL  = 24,  /* requested feature not (yet) implemented */
  GSL_ECACHE   = 25,  /* cache limit exceeded */
  GSL_ETABLE   = 26,  /* table limit exceeded */
  GSL_ENOPROG  = 27,  /* iteration is not making progress towards solution */
  GSL_ENOPROGJ = 28,  /* jacobian evaluations are not improving the solution */
  GSL_ETOLF    = 29,  /* cannot reach the specified tolerance in F */
  GSL_ETOLX    = 30,  /* cannot reach the specified tolerance in X */
  GSL_ETOLG    = 31,  /* cannot reach the specified tolerance in gradient */
  GSL_EOF      = 32 ;   /* end of file */

public static native void gsl_error(@Cast("const char*") BytePointer reason, @Cast("const char*") BytePointer file, int line,
                int gsl_errno);
public static native void gsl_error(String reason, String file, int line,
                int gsl_errno);

public static native void gsl_stream_printf(@Cast("const char*") BytePointer label, @Cast("const char*") BytePointer file,
                        int line, @Cast("const char*") BytePointer reason);
public static native void gsl_stream_printf(String label, String file,
                        int line, String reason);

public static native @Cast("const char*") BytePointer gsl_strerror(int gsl_errno);
// Targeting ../gsl_error_handler_t.java


// Targeting ../gsl_stream_handler_t.java



public static native gsl_error_handler_t gsl_set_error_handler(gsl_error_handler_t new_handler);

public static native gsl_error_handler_t gsl_set_error_handler_off();

public static native gsl_stream_handler_t gsl_set_stream_handler(gsl_stream_handler_t new_handler);

public static native FILE gsl_set_stream(FILE new_stream);

/* GSL_ERROR: call the error handler, and return the error code */

// #define GSL_ERROR(reason, gsl_errno)
//        do {
//        gsl_error (reason, __FILE__, __LINE__, gsl_errno) ;
//        return gsl_errno ;
//        } while (0)

/* GSL_ERROR_VAL: call the error handler, and return the given value */

// #define GSL_ERROR_VAL(reason, gsl_errno, value)
//        do {
//        gsl_error (reason, __FILE__, __LINE__, gsl_errno) ;
//        return value ;
//        } while (0)

/* GSL_ERROR_VOID: call the error handler, and then return
   (for void functions which still need to generate an error) */

// #define GSL_ERROR_VOID(reason, gsl_errno)
//        do {
//        gsl_error (reason, __FILE__, __LINE__, gsl_errno) ;
//        return ;
//        } while (0)

/* GSL_ERROR_NULL suitable for out-of-memory conditions */

// #define GSL_ERROR_NULL(reason, gsl_errno) GSL_ERROR_VAL(reason, gsl_errno, 0)

/* Sometimes you have several status results returned from
 * function calls and you want to combine them in some sensible
 * way. You cannot produce a "total" status condition, but you can
 * pick one from a set of conditions based on an implied hierarchy.
 *
 * In other words:
 *    you have: status_a, status_b, ...
 *    you want: status = (status_a if it is bad, or status_b if it is bad,...)
 *
 * In this example you consider status_a to be more important and
 * it is checked first, followed by the others in the order specified.
 *
 * Here are some dumb macros to do this.
 */
// #define GSL_ERROR_SELECT_2(a,b)       ((a) != GSL_SUCCESS ? (a) : ((b) != GSL_SUCCESS ? (b) : GSL_SUCCESS))
// #define GSL_ERROR_SELECT_3(a,b,c)     ((a) != GSL_SUCCESS ? (a) : GSL_ERROR_SELECT_2(b,c))
// #define GSL_ERROR_SELECT_4(a,b,c,d)   ((a) != GSL_SUCCESS ? (a) : GSL_ERROR_SELECT_3(b,c,d))
// #define GSL_ERROR_SELECT_5(a,b,c,d,e) ((a) != GSL_SUCCESS ? (a) : GSL_ERROR_SELECT_4(b,c,d,e))

// #define GSL_STATUS_UPDATE(sp, s) do { if ((s) != GSL_SUCCESS) *(sp) = (s);} while(0)

// #endif /* __GSL_ERRNO_H__ */


// Parsed from gsl/gsl_ieee_utils.h

/* ieee-utils/gsl_ieee_utils.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_IEEE_UTILS_H__
// #define __GSL_IEEE_UTILS_H__
// #include <stdio.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/** enum  */
public static final int
  GSL_IEEE_TYPE_NAN = 1,
  GSL_IEEE_TYPE_INF = 2,
  GSL_IEEE_TYPE_NORMAL = 3,
  GSL_IEEE_TYPE_DENORMAL = 4,
  GSL_IEEE_TYPE_ZERO = 5 ;
// Targeting ../gsl_ieee_float_rep.java


// Targeting ../gsl_ieee_double_rep.java




public static native void gsl_ieee_printf_float(@Const FloatPointer x);
public static native void gsl_ieee_printf_float(@Const FloatBuffer x);
public static native void gsl_ieee_printf_float(@Const float[] x);
public static native void gsl_ieee_printf_double(@Const DoublePointer x);
public static native void gsl_ieee_printf_double(@Const DoubleBuffer x);
public static native void gsl_ieee_printf_double(@Const double[] x);

public static native void gsl_ieee_fprintf_float(FILE stream, @Const FloatPointer x);
public static native void gsl_ieee_fprintf_float(FILE stream, @Const FloatBuffer x);
public static native void gsl_ieee_fprintf_float(FILE stream, @Const float[] x);
public static native void gsl_ieee_fprintf_double(FILE stream, @Const DoublePointer x);
public static native void gsl_ieee_fprintf_double(FILE stream, @Const DoubleBuffer x);
public static native void gsl_ieee_fprintf_double(FILE stream, @Const double[] x);

public static native void gsl_ieee_float_to_rep(@Const FloatPointer x, gsl_ieee_float_rep r);
public static native void gsl_ieee_float_to_rep(@Const FloatBuffer x, gsl_ieee_float_rep r);
public static native void gsl_ieee_float_to_rep(@Const float[] x, gsl_ieee_float_rep r);
public static native void gsl_ieee_double_to_rep(@Const DoublePointer x, gsl_ieee_double_rep r);
public static native void gsl_ieee_double_to_rep(@Const DoubleBuffer x, gsl_ieee_double_rep r);
public static native void gsl_ieee_double_to_rep(@Const double[] x, gsl_ieee_double_rep r);

/** enum  */
public static final int
  GSL_IEEE_SINGLE_PRECISION = 1,
  GSL_IEEE_DOUBLE_PRECISION = 2,
  GSL_IEEE_EXTENDED_PRECISION = 3 ;

/** enum  */
public static final int
  GSL_IEEE_ROUND_TO_NEAREST = 1,
  GSL_IEEE_ROUND_DOWN = 2,
  GSL_IEEE_ROUND_UP = 3,
  GSL_IEEE_ROUND_TO_ZERO = 4 ;

/** enum  */
public static final int
  GSL_IEEE_MASK_INVALID = 1,
  GSL_IEEE_MASK_DENORMALIZED = 2,
  GSL_IEEE_MASK_DIVISION_BY_ZERO = 4,
  GSL_IEEE_MASK_OVERFLOW = 8,
  GSL_IEEE_MASK_UNDERFLOW = 16,
  GSL_IEEE_MASK_ALL = 31,
  GSL_IEEE_TRAP_INEXACT = 32 ;

public static native void gsl_ieee_env_setup();
public static native int gsl_ieee_read_mode_string(@Cast("const char*") BytePointer description, IntPointer precision,
                               IntPointer rounding, IntPointer exception_mask);
public static native int gsl_ieee_read_mode_string(String description, IntBuffer precision,
                               IntBuffer rounding, IntBuffer exception_mask);
public static native int gsl_ieee_read_mode_string(@Cast("const char*") BytePointer description, int[] precision,
                               int[] rounding, int[] exception_mask);
public static native int gsl_ieee_read_mode_string(String description, IntPointer precision,
                               IntPointer rounding, IntPointer exception_mask);
public static native int gsl_ieee_read_mode_string(@Cast("const char*") BytePointer description, IntBuffer precision,
                               IntBuffer rounding, IntBuffer exception_mask);
public static native int gsl_ieee_read_mode_string(String description, int[] precision,
                               int[] rounding, int[] exception_mask);
public static native int gsl_ieee_set_mode(int precision, int rounding, int exception_mask);

// #endif /* __GSL_IEEE_UTILS_H__ */



// Parsed from gsl/gsl_inline.h

/* gsl_inline.h
 * 
 * Copyright (C) 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_INLINE_H__
// #define __GSL_INLINE_H__

/* In recent versiions of GCC, the inline keyword has two different
   forms: GNU and C99.

   In GNU mode we can use 'extern inline' to make inline functions
   work like macros.  The function is only inlined--it is never output
   as a definition in an object file.

   In the new C99 mode 'extern inline' has a different meaning--it
   causes the definition of the function to be output in each object
   file where it is used.  This will result in multiple-definition
   errors on linking.  The 'inline' keyword on its own (without
   extern) has the same behavior as the original GNU 'extern inline'.

   The C99 style is the default with -std=c99 in GCC 4.3.  

   This header file allows either form of inline to be used by
   redefining the macros INLINE_DECL and INLINE_FUN.  These are used
   in the public header files as

        INLINE_DECL double gsl_foo (double x);
        #ifdef HAVE_INLINE
        INLINE_FUN double gsl_foo (double x) { return x+1.0; } ;
        #endif
   
*/

// #ifdef HAVE_INLINE
// #  if defined(__GNUC_STDC_INLINE__) || defined(GSL_C99_INLINE) || defined(HAVE_C99_INLINE)
// #    define INLINE_DECL inline  /* use C99 inline */
// #    define INLINE_FUN inline
// #  else
// #    define INLINE_DECL         /* use GNU extern inline */
// #    define INLINE_FUN extern inline
// #  endif
// #else
// #  define INLINE_DECL /* */
// #endif

/* Range checking conditions in headers do not require any run-time
   tests of the global variable gsl_check_range.  They are enabled or
   disabled in user code at compile time with GSL_RANGE_CHECK macro.
   See also build.h. */
// #define GSL_RANGE_COND(x) (x)

// #endif /* __GSL_INLINE_H__ */


// Parsed from gsl/gsl_message.h

/* err/gsl_message.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MESSAGE_H__
// #define __GSL_MESSAGE_H__
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/* Provide a general messaging service for client use.  Messages can
 * be selectively turned off at compile time by defining an
 * appropriate message mask. Client code which uses the GSL_MESSAGE()
 * macro must provide a mask which is or'ed with the GSL_MESSAGE_MASK.
 *
 * The messaging service can be completely turned off
 * by defining GSL_MESSAGING_OFF.  */

public static native void gsl_message(@Cast("const char*") BytePointer message, @Cast("const char*") BytePointer file, int line,
                 @Cast("unsigned int") int mask);
public static native void gsl_message(String message, String file, int line,
                 @Cast("unsigned int") int mask);

// #ifndef GSL_MESSAGE_MASK
public static final int GSL_MESSAGE_MASK = 0xffffffff; /* default all messages allowed */
// #endif

public static native @Cast("unsigned int") int gsl_message_mask(); public static native void gsl_message_mask(int setter);

/* Provide some symolic masks for client ease of use. */

/** enum  */
public static final int
  GSL_MESSAGE_MASK_A = 1,
  GSL_MESSAGE_MASK_B = 2,
  GSL_MESSAGE_MASK_C = 4,
  GSL_MESSAGE_MASK_D = 8,
  GSL_MESSAGE_MASK_E = 16,
  GSL_MESSAGE_MASK_F = 32,
  GSL_MESSAGE_MASK_G = 64,
  GSL_MESSAGE_MASK_H = 128 ;

// #ifdef GSL_MESSAGING_OFF        /* throw away messages */ 
// #define GSL_MESSAGE(message, mask) do { } while(0)
// #else                           /* output all messages */
// #define GSL_MESSAGE(message, mask)
//        do {
//        if (mask & GSL_MESSAGE_MASK)
//          gsl_message (message, __FILE__, __LINE__, mask) ;
//        } while (0)
// #endif

// #endif /* __GSL_MESSAGE_H__ */




// Parsed from gsl/gsl_complex.h

/* complex/gsl_complex.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * Copyright (C) 2020, 2021 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_COMPLEX_H__
// #define __GSL_COMPLEX_H__

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


/* two consecutive built-in types as a complex number */


/* 2N consecutive built-in types as N complex numbers */


/* Yes... this seems weird. Trust us. The point is just that
   sometimes you want to make it obvious that something is
   an output value. The fact that it lacks a 'const' may not
   be enough of a clue for people in some contexts.
 */

/*
 * If <complex.h> is included, use the C99 complex type.  Otherwise
 * define a type bit-compatible with C99 complex. The GSL_REAL and GSL_IMAG
 * macros require C11 functionality also (_Generic)
 */

/* older gcc compilers claim to be C11 compliant but do not support _Generic */
// #if defined(__GNUC__) && (__GNUC__ < 7)
public static final int GSL_COMPLEX_LEGACY = 1;
// #endif

// #if !defined(GSL_COMPLEX_LEGACY) &&
//      defined(_Complex_I) &&
//      defined(complex) &&
//      defined(I) &&
//      defined(__STDC__) && (__STDC__ == 1) &&
//      defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 201112L) /* C11 */

// #else /* legacy complex definitions */

/*
 * According to the C17 standard, 6.2.5 paragraph 13:
 *
 * "Each complex type has the same representation and alignment requirements
 * as an array type containing exactly two elements of the corresponding real
 * type; the first element is equal to the real part, and the second element to
 * the imaginary part, of the complex number."
 */

/*#  define GSL_COMPLEX_DEFINE(R, C) typedef R C[2]*/
// #  define GSL_COMPLEX_DEFINE(R, C) typedef struct { R dat[2]; } C ;

// #  define GSL_REAL(z)              ((z).dat[0])
// #  define GSL_IMAG(z)              ((z).dat[1])
// #  define GSL_COMPLEX_P(zp)        ((zp)->dat)
// #  define GSL_COMPLEX_P_REAL(zp)   ((zp)->dat[0])
// #  define GSL_COMPLEX_P_IMAG(zp)   ((zp)->dat[1])
// #  define GSL_COMPLEX_EQ(z1,z2)    (((z1).dat[0] == (z2).dat[0]) && ((z1).dat[1] == (z2).dat[1]))

// #  define GSL_SET_COMPLEX(zp,x,y)  do {(zp)->dat[0]=(x); (zp)->dat[1]=(y);} while(0)
// #  define GSL_SET_REAL(zp,x)       do {(zp)->dat[0]=(x);} while(0)
// #  define GSL_SET_IMAG(zp,y)       do {(zp)->dat[1]=(y);} while(0)
// Targeting ../gsl_complex.java


// Targeting ../gsl_complex_long_double.java


// Targeting ../gsl_complex_float.java



// #define GSL_SET_COMPLEX_PACKED(zp,n,x,y) do {*((zp)+2*(n))=(x); *((zp)+(2*(n)+1))=(y);} while(0)

// #endif /* __GSL_COMPLEX_H__ */


// Parsed from gsl/gsl_complex_math.h

/* complex/gsl_complex_math.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Jorma Olavi Thtinen, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_COMPLEX_MATH_H__
// #define __GSL_COMPLEX_MATH_H__
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_complex.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// #define __BEGIN_DECLS extern "C" {
// #define __END_DECLS }
// #else
// #endif

/* Complex numbers */

public static native @ByVal gsl_complex gsl_complex_polar(double r, double theta); /* r= r e^(i theta) */

/* */ public static native @ByVal gsl_complex gsl_complex_rect(double x, double y);  /* r= real+i*imag */

// #ifdef HAVE_INLINE
// #endif

public static native @MemberGetter @ByVal gsl_complex GSL_COMPLEX_ONE();
public static final gsl_complex GSL_COMPLEX_ONE = GSL_COMPLEX_ONE();
public static native @MemberGetter @ByVal gsl_complex GSL_COMPLEX_ZERO();
public static final gsl_complex GSL_COMPLEX_ZERO = GSL_COMPLEX_ZERO();
public static native @MemberGetter @ByVal gsl_complex GSL_COMPLEX_NEGONE();
public static final gsl_complex GSL_COMPLEX_NEGONE = GSL_COMPLEX_NEGONE();

/* Properties of complex numbers */

public static native double gsl_complex_arg(@ByVal gsl_complex z); /* return arg(z), -pi< arg(z) <=+pi */
public static native double gsl_complex_abs(@ByVal gsl_complex z);   /* return |z|   */
public static native double gsl_complex_abs2(@ByVal gsl_complex z);  /* return |z|^2 */
public static native double gsl_complex_logabs(@ByVal gsl_complex z); /* return log|z| */

/* Complex arithmetic operators */

public static native @ByVal gsl_complex gsl_complex_add(@ByVal gsl_complex a, @ByVal gsl_complex b);  /* r=a+b */
public static native @ByVal gsl_complex gsl_complex_sub(@ByVal gsl_complex a, @ByVal gsl_complex b);  /* r=a-b */
public static native @ByVal gsl_complex gsl_complex_mul(@ByVal gsl_complex a, @ByVal gsl_complex b);  /* r=a*b */
public static native @ByVal gsl_complex gsl_complex_div(@ByVal gsl_complex a, @ByVal gsl_complex b);  /* r=a/b */
                                                           
public static native @ByVal gsl_complex gsl_complex_add_real(@ByVal gsl_complex a, double x);  /* r=a+x */
public static native @ByVal gsl_complex gsl_complex_sub_real(@ByVal gsl_complex a, double x);  /* r=a-x */
public static native @ByVal gsl_complex gsl_complex_mul_real(@ByVal gsl_complex a, double x);  /* r=a*x */
public static native @ByVal gsl_complex gsl_complex_div_real(@ByVal gsl_complex a, double x);  /* r=a/x */

public static native @ByVal gsl_complex gsl_complex_add_imag(@ByVal gsl_complex a, double y);  /* r=a+iy */
public static native @ByVal gsl_complex gsl_complex_sub_imag(@ByVal gsl_complex a, double y);  /* r=a-iy */
public static native @ByVal gsl_complex gsl_complex_mul_imag(@ByVal gsl_complex a, double y);  /* r=a*iy */
public static native @ByVal gsl_complex gsl_complex_div_imag(@ByVal gsl_complex a, double y);  /* r=a/iy */

public static native @ByVal gsl_complex gsl_complex_conjugate(@ByVal gsl_complex z);  /* r=conj(z) */
public static native @ByVal gsl_complex gsl_complex_inverse(@ByVal gsl_complex a);    /* r=1/a */
public static native @ByVal gsl_complex gsl_complex_negative(@ByVal gsl_complex a);    /* r=-a */

/* Elementary Complex Functions */

public static native @ByVal gsl_complex gsl_complex_sqrt(@ByVal gsl_complex z);  /* r=sqrt(z) */
public static native @ByVal gsl_complex gsl_complex_sqrt_real(double x);  /* r=sqrt(x) (x<0 ok) */

public static native @ByVal gsl_complex gsl_complex_pow(@ByVal gsl_complex a, @ByVal gsl_complex b);  /* r=a^b */
public static native @ByVal gsl_complex gsl_complex_pow_real(@ByVal gsl_complex a, double b);  /* r=a^b */

public static native @ByVal gsl_complex gsl_complex_exp(@ByVal gsl_complex a);    /* r=exp(a) */
public static native @ByVal gsl_complex gsl_complex_log(@ByVal gsl_complex a);    /* r=log(a) (base e) */
public static native @ByVal gsl_complex gsl_complex_log10(@ByVal gsl_complex a);  /* r=log10(a) (base 10) */
public static native @ByVal gsl_complex gsl_complex_log_b(@ByVal gsl_complex a, @ByVal gsl_complex b);   /* r=log_b(a) (base=b) */

/* Complex Trigonometric Functions */

public static native @ByVal gsl_complex gsl_complex_sin(@ByVal gsl_complex a);  /* r=sin(a) */
public static native @ByVal gsl_complex gsl_complex_cos(@ByVal gsl_complex a);  /* r=cos(a) */
public static native @ByVal gsl_complex gsl_complex_sec(@ByVal gsl_complex a);  /* r=sec(a) */
public static native @ByVal gsl_complex gsl_complex_csc(@ByVal gsl_complex a);  /* r=csc(a) */
public static native @ByVal gsl_complex gsl_complex_tan(@ByVal gsl_complex a);  /* r=tan(a) */
public static native @ByVal gsl_complex gsl_complex_cot(@ByVal gsl_complex a);  /* r=cot(a) */

/* Inverse Complex Trigonometric Functions */

public static native @ByVal gsl_complex gsl_complex_arcsin(@ByVal gsl_complex a);  /* r=arcsin(a) */
public static native @ByVal gsl_complex gsl_complex_arcsin_real(double a);  /* r=arcsin(a) */
public static native @ByVal gsl_complex gsl_complex_arccos(@ByVal gsl_complex a);  /* r=arccos(a) */
public static native @ByVal gsl_complex gsl_complex_arccos_real(double a);  /* r=arccos(a) */
public static native @ByVal gsl_complex gsl_complex_arcsec(@ByVal gsl_complex a);  /* r=arcsec(a) */
public static native @ByVal gsl_complex gsl_complex_arcsec_real(double a);  /* r=arcsec(a) */
public static native @ByVal gsl_complex gsl_complex_arccsc(@ByVal gsl_complex a);  /* r=arccsc(a) */
public static native @ByVal gsl_complex gsl_complex_arccsc_real(double a);  /* r=arccsc(a) */
public static native @ByVal gsl_complex gsl_complex_arctan(@ByVal gsl_complex a);  /* r=arctan(a) */
public static native @ByVal gsl_complex gsl_complex_arccot(@ByVal gsl_complex a);  /* r=arccot(a) */

/* Complex Hyperbolic Functions */

public static native @ByVal gsl_complex gsl_complex_sinh(@ByVal gsl_complex a);  /* r=sinh(a) */
public static native @ByVal gsl_complex gsl_complex_cosh(@ByVal gsl_complex a);  /* r=coshh(a) */
public static native @ByVal gsl_complex gsl_complex_sech(@ByVal gsl_complex a);  /* r=sech(a) */
public static native @ByVal gsl_complex gsl_complex_csch(@ByVal gsl_complex a);  /* r=csch(a) */
public static native @ByVal gsl_complex gsl_complex_tanh(@ByVal gsl_complex a);  /* r=tanh(a) */
public static native @ByVal gsl_complex gsl_complex_coth(@ByVal gsl_complex a);  /* r=coth(a) */

/* Inverse Complex Hyperbolic Functions */

public static native @ByVal gsl_complex gsl_complex_arcsinh(@ByVal gsl_complex a);  /* r=arcsinh(a) */
public static native @ByVal gsl_complex gsl_complex_arccosh(@ByVal gsl_complex a);  /* r=arccosh(a) */
public static native @ByVal gsl_complex gsl_complex_arccosh_real(double a);  /* r=arccosh(a) */
public static native @ByVal gsl_complex gsl_complex_arcsech(@ByVal gsl_complex a);  /* r=arcsech(a) */
public static native @ByVal gsl_complex gsl_complex_arccsch(@ByVal gsl_complex a);  /* r=arccsch(a) */
public static native @ByVal gsl_complex gsl_complex_arctanh(@ByVal gsl_complex a);  /* r=arctanh(a) */
public static native @ByVal gsl_complex gsl_complex_arctanh_real(double a);  /* r=arctanh(a) */
public static native @ByVal gsl_complex gsl_complex_arccoth(@ByVal gsl_complex a);  /* r=arccoth(a) */

// #endif /* __GSL_COMPLEX_MATH_H__ */


// Parsed from gsl/gsl_check_range.h

/* vector/gsl_check_range.h
 * 
 * Copyright (C) 2003, 2004, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CHECK_RANGE_H__
// #define __GSL_CHECK_RANGE_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_check_range(); public static native void gsl_check_range(int setter);

/* Turn range checking on by default, unless the user defines
   GSL_RANGE_CHECK_OFF, or defines GSL_RANGE_CHECK to 0 explicitly */

// #ifdef GSL_RANGE_CHECK_OFF
// # ifndef GSL_RANGE_CHECK
// #  define GSL_RANGE_CHECK 0
// # else
// # endif
// #else
// # ifndef GSL_RANGE_CHECK
// #  define GSL_RANGE_CHECK 1
// # endif
// #endif

// #endif /* __GSL_CHECK_RANGE_H__ */


// Parsed from gsl/gsl_sys.h

/* sys/gsl_sys.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SYS_H__
// #define __GSL_SYS_H__

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native double gsl_log1p(double x);
public static native double gsl_expm1(double x);
public static native double gsl_hypot(double x, double y);
public static native double gsl_hypot3(double x, double y, double z);
public static native double gsl_acosh(double x);
public static native double gsl_asinh(double x);
public static native double gsl_atanh(double x);

public static native int gsl_isnan(double x);
public static native int gsl_isinf(double x);
public static native int gsl_finite(double x);

public static native double gsl_nan();
public static native double gsl_posinf();
public static native double gsl_neginf();
public static native double gsl_fdiv(double x, double y);

public static native double gsl_coerce_double(double x);
public static native float gsl_coerce_float(float x);
public static native @Cast("long double") double gsl_coerce_long_double(@Cast("const long double") double x);

public static native double gsl_ldexp(double x, int e);
public static native double gsl_frexp(double x, IntPointer e);
public static native double gsl_frexp(double x, IntBuffer e);
public static native double gsl_frexp(double x, int[] e);

public static native int gsl_fcmp(double x1, double x2, double epsilon);

// #endif /* __GSL_SYS_H__ */


// Parsed from gsl/gsl_machine.h

/* Author:  B. Gough and G. Jungman */
// #ifndef __GSL_MACHINE_H__
// #define __GSL_MACHINE_H__

// #include <limits.h>
// #include <float.h>

/* magic constants; mostly for the benefit of the implementation */

/* -*-MACHINE CONSTANTS-*-
 *
 * PLATFORM: Whiz-O-Matic 9000
 * FP_PLATFORM: IEEE-Virtual
 * HOSTNAME: nnn.lanl.gov
 * DATE: Fri Nov 20 17:53:26 MST 1998
 */
public static final double GSL_DBL_EPSILON =        2.2204460492503131e-16;
public static final double GSL_SQRT_DBL_EPSILON =   1.4901161193847656e-08;
public static final double GSL_ROOT3_DBL_EPSILON =  6.0554544523933429e-06;
public static final double GSL_ROOT4_DBL_EPSILON =  1.2207031250000000e-04;
public static final double GSL_ROOT5_DBL_EPSILON =  7.4009597974140505e-04;
public static final double GSL_ROOT6_DBL_EPSILON =  2.4607833005759251e-03;
public static final double GSL_LOG_DBL_EPSILON =   (-3.6043653389117154e+01);

public static final double GSL_DBL_MIN =        2.2250738585072014e-308;
public static final double GSL_SQRT_DBL_MIN =   1.4916681462400413e-154;
public static final double GSL_ROOT3_DBL_MIN =  2.8126442852362996e-103;
public static final double GSL_ROOT4_DBL_MIN =  1.2213386697554620e-77;
public static final double GSL_ROOT5_DBL_MIN =  2.9476022969691763e-62;
public static final double GSL_ROOT6_DBL_MIN =  5.3034368905798218e-52;
public static final double GSL_LOG_DBL_MIN =   (-7.0839641853226408e+02);

public static final double GSL_DBL_MAX =        1.7976931348623157e+308;
public static final double GSL_SQRT_DBL_MAX =   1.3407807929942596e+154;
public static final double GSL_ROOT3_DBL_MAX =  5.6438030941222897e+102;
public static final double GSL_ROOT4_DBL_MAX =  1.1579208923731620e+77;
public static final double GSL_ROOT5_DBL_MAX =  4.4765466227572707e+61;
public static final double GSL_ROOT6_DBL_MAX =  2.3756689782295612e+51;
public static final double GSL_LOG_DBL_MAX =    7.0978271289338397e+02;

public static final double GSL_FLT_EPSILON =        1.1920928955078125e-07;
public static final double GSL_SQRT_FLT_EPSILON =   3.4526698300124393e-04;
public static final double GSL_ROOT3_FLT_EPSILON =  4.9215666011518501e-03;
public static final double GSL_ROOT4_FLT_EPSILON =  1.8581361171917516e-02;
public static final double GSL_ROOT5_FLT_EPSILON =  4.1234622211652937e-02;
public static final double GSL_ROOT6_FLT_EPSILON =  7.0153878019335827e-02;
public static final double GSL_LOG_FLT_EPSILON =   (-1.5942385152878742e+01);

public static final double GSL_FLT_MIN =        1.1754943508222875e-38;
public static final double GSL_SQRT_FLT_MIN =   1.0842021724855044e-19;
public static final double GSL_ROOT3_FLT_MIN =  2.2737367544323241e-13;
public static final double GSL_ROOT4_FLT_MIN =  3.2927225399135965e-10;
public static final double GSL_ROOT5_FLT_MIN =  2.5944428542140822e-08;
public static final double GSL_ROOT6_FLT_MIN =  4.7683715820312542e-07;
public static final double GSL_LOG_FLT_MIN =   (-8.7336544750553102e+01);

public static final double GSL_FLT_MAX =        3.4028234663852886e+38;
public static final double GSL_SQRT_FLT_MAX =   1.8446743523953730e+19;
public static final double GSL_ROOT3_FLT_MAX =  6.9814635196223242e+12;
public static final double GSL_ROOT4_FLT_MAX =  4.2949672319999986e+09;
public static final double GSL_ROOT5_FLT_MAX =  5.0859007855960041e+07;
public static final double GSL_ROOT6_FLT_MAX =  2.6422459233807749e+06;
public static final double GSL_LOG_FLT_MAX =    8.8722839052068352e+01;

public static final double GSL_SFLT_EPSILON =        4.8828125000000000e-04;
public static final double GSL_SQRT_SFLT_EPSILON =   2.2097086912079612e-02;
public static final double GSL_ROOT3_SFLT_EPSILON =  7.8745065618429588e-02;
public static final double GSL_ROOT4_SFLT_EPSILON =  1.4865088937534013e-01;
public static final double GSL_ROOT5_SFLT_EPSILON =  2.1763764082403100e-01;
public static final double GSL_ROOT6_SFLT_EPSILON =  2.8061551207734325e-01;
public static final double GSL_LOG_SFLT_EPSILON =   (-7.6246189861593985e+00);

/* !MACHINE CONSTANTS! */


/* a little internal backwards compatibility */
public static final double GSL_MACH_EPS =  GSL_DBL_EPSILON;



/* Here are the constants related to or derived from
 * machine constants. These are not to be confused with
 * the constants that define various precision levels
 * for the precision/error system.
 *
 * This information is determined at configure time
 * and is platform dependent. Edit at your own risk.
 *
 * PLATFORM: WHIZ-O-MATIC
 * CONFIG-DATE: Thu Nov 19 19:27:18 MST 1998
 * CONFIG-HOST: nnn.lanl.gov
 */

/* machine precision constants */
/* #define GSL_MACH_EPS         1.0e-15 */
public static final double GSL_SQRT_MACH_EPS =       3.2e-08;
public static final double GSL_ROOT3_MACH_EPS =      1.0e-05;
public static final double GSL_ROOT4_MACH_EPS =      0.000178;
public static final double GSL_ROOT5_MACH_EPS =      0.00100;
public static final double GSL_ROOT6_MACH_EPS =      0.00316;
public static final double GSL_LOG_MACH_EPS =       (-34.54);


// #endif /* __GSL_MACHINE_H__ */


// Parsed from gsl/gsl_precision.h

/* gsl_precision.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  B. Gough and G. Jungman */

// #ifndef __GSL_PRECISION_H__
// #define __GSL_PRECISION_H__
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


/* A type for the precision indicator.
 * This is mainly for pedagogy.
 */


/* The number of precision types.
 * Remember that precision-mode
 * can index an array.
 */
public static final int _GSL_PREC_T_NUM = 3;


/* Arrays containing derived
 * precision constants for the
 * different precision levels.
 */
@MemberGetter public static native double gsl_prec_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_eps();
@MemberGetter public static native double gsl_prec_sqrt_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_sqrt_eps();
@MemberGetter public static native double gsl_prec_root3_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_root3_eps();
@MemberGetter public static native double gsl_prec_root4_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_root4_eps();
@MemberGetter public static native double gsl_prec_root5_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_root5_eps();
@MemberGetter public static native double gsl_prec_root6_eps(int i);
@MemberGetter public static native @Const DoublePointer gsl_prec_root6_eps();

// #endif /* __GSL_PRECISION_H__ */


// Parsed from gsl/gsl_nan.h

/* gsl_nan.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_NAN_H__
// #define __GSL_NAN_H__

// #ifdef INFINITY
// #elif defined(HUGE_VAL)
// #else
public static final double GSL_POSINF = (gsl_posinf());
public static final double GSL_NEGINF = (gsl_neginf());
// #endif

// #ifdef NAN
// #elif defined(INFINITY)
// #else
public static final double GSL_NAN = (gsl_nan());
// #endif

public static final double GSL_POSZERO = (+0.0);
public static final double GSL_NEGZERO = (-0.0);

// #endif /* __GSL_NAN_H__ */


// Parsed from gsl/gsl_pow_int.h

/* gsl_pow_int.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_POW_INT_H__
// #define __GSL_POW_INT_H__
// #include <gsl/gsl_inline.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/* */ public static native double gsl_pow_2(double x);
/* */ public static native double gsl_pow_3(double x);
/* */ public static native double gsl_pow_4(double x);
/* */ public static native double gsl_pow_5(double x);
/* */ public static native double gsl_pow_6(double x);
/* */ public static native double gsl_pow_7(double x);
/* */ public static native double gsl_pow_8(double x);
/* */ public static native double gsl_pow_9(double x);

// #ifdef HAVE_INLINE
// #endif

public static native double gsl_pow_int(double x, int n);
public static native double gsl_pow_uint(double x, @Cast("unsigned int") int n);

// #endif /* __GSL_POW_INT_H__ */


// Parsed from gsl/gsl_math.h

/* gsl_math.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATH_H__
// #define __GSL_MATH_H__
// #include <math.h>
// #include <gsl/gsl_sys.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_machine.h>
// #include <gsl/gsl_precision.h>
// #include <gsl/gsl_nan.h>
// #include <gsl/gsl_pow_int.h>
// #include <gsl/gsl_minmax.h>

// #ifndef M_E
public static final double M_E =        2.71828182845904523536028747135;      /* e */
// #endif

// #ifndef M_LOG2E
public static final double M_LOG2E =    1.44269504088896340735992468100;      /* log_2 (e) */
// #endif

// #ifndef M_LOG10E
public static final double M_LOG10E =   0.43429448190325182765112891892;      /* log_10 (e) */
// #endif

// #ifndef M_SQRT2
public static final double M_SQRT2 =    1.41421356237309504880168872421;      /* sqrt(2) */
// #endif

// #ifndef M_SQRT1_2
public static final double M_SQRT1_2 =  0.70710678118654752440084436210;      /* sqrt(1/2) */
// #endif


// #ifndef M_SQRT3
public static final double M_SQRT3 =    1.73205080756887729352744634151;      /* sqrt(3) */
// #endif

// #ifndef M_PI
public static final double M_PI =       3.14159265358979323846264338328;      /* pi */
// #endif

// #ifndef M_PI_2
public static final double M_PI_2 =     1.57079632679489661923132169164;      /* pi/2 */
// #endif

// #ifndef M_PI_4
public static final double M_PI_4 =     0.78539816339744830961566084582;     /* pi/4 */
// #endif

// #ifndef M_SQRTPI
public static final double M_SQRTPI =   1.77245385090551602729816748334;      /* sqrt(pi) */
// #endif

// #ifndef M_2_SQRTPI
public static final double M_2_SQRTPI = 1.12837916709551257389615890312;      /* 2/sqrt(pi) */
// #endif

// #ifndef M_1_PI
public static final double M_1_PI =     0.31830988618379067153776752675;      /* 1/pi */
// #endif

// #ifndef M_2_PI
public static final double M_2_PI =     0.63661977236758134307553505349;      /* 2/pi */
// #endif

// #ifndef M_LN10
public static final double M_LN10 =     2.30258509299404568401799145468;      /* ln(10) */
// #endif

// #ifndef M_LN2
public static final double M_LN2 =      0.69314718055994530941723212146;      /* ln(2) */
// #endif

// #ifndef M_LNPI
public static final double M_LNPI =     1.14472988584940017414342735135;      /* ln(pi) */
// #endif

// #ifndef M_EULER
public static final double M_EULER =    0.57721566490153286060651209008;      /* Euler constant */
// #endif

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/* other needlessly compulsive abstractions */

// #define GSL_IS_ODD(n)  ((n) & 1)
// #define GSL_IS_EVEN(n) (!(GSL_IS_ODD(n)))
// #define GSL_SIGN(x)    ((x) >= 0.0 ? 1 : -1)

/* Return nonzero if x is a real number, i.e. non NaN or infinite. */
// #define GSL_IS_REAL(x) (gsl_finite(x))
// Targeting ../gsl_function.java



// #define GSL_FN_EVAL(F,x) (*((F)->function))(x,(F)->params)
// Targeting ../gsl_function_fdf.java



// #define GSL_FN_FDF_EVAL_F(FDF,x) (*((FDF)->f))(x,(FDF)->params)
// #define GSL_FN_FDF_EVAL_DF(FDF,x) (*((FDF)->df))(x,(FDF)->params)
// #define GSL_FN_FDF_EVAL_F_DF(FDF,x,y,dy) (*((FDF)->fdf))(x,(FDF)->params,(y),(dy))
// Targeting ../gsl_function_vec.java



// #define GSL_FN_VEC_EVAL(F,x,y) (*((F)->function))(x,y,(F)->params)

// #endif /* __GSL_MATH_H__ */


// Parsed from gsl/gsl_min.h

/* min/gsl_min.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MIN_H__
// #define __GSL_MIN_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_min_fminimizer_type.java


// Targeting ../gsl_min_fminimizer.java



public static native gsl_min_fminimizer gsl_min_fminimizer_alloc(@Const gsl_min_fminimizer_type T);
                                      
public static native void gsl_min_fminimizer_free(gsl_min_fminimizer s);

public static native int gsl_min_fminimizer_set(gsl_min_fminimizer s, 
                            gsl_function f, double x_minimum, 
                            double x_lower, double x_upper);

public static native int gsl_min_fminimizer_set_with_values(gsl_min_fminimizer s, 
                                        gsl_function f, 
                                        double x_minimum, double f_minimum,
                                        double x_lower, double f_lower,
                                        double x_upper, double f_upper);

public static native int gsl_min_fminimizer_iterate(gsl_min_fminimizer s);

public static native @Cast("const char*") BytePointer gsl_min_fminimizer_name(@Const gsl_min_fminimizer s);

public static native double gsl_min_fminimizer_x_minimum(@Const gsl_min_fminimizer s);
public static native double gsl_min_fminimizer_x_lower(@Const gsl_min_fminimizer s);
public static native double gsl_min_fminimizer_x_upper(@Const gsl_min_fminimizer s);
public static native double gsl_min_fminimizer_f_minimum(@Const gsl_min_fminimizer s);
public static native double gsl_min_fminimizer_f_lower(@Const gsl_min_fminimizer s);
public static native double gsl_min_fminimizer_f_upper(@Const gsl_min_fminimizer s);

/* Deprecated, use x_minimum instead */
public static native double gsl_min_fminimizer_minimum(@Const gsl_min_fminimizer s);

public static native int gsl_min_test_interval(double x_lower, double x_upper, double epsabs, double epsrel);

public static native @Const gsl_min_fminimizer_type gsl_min_fminimizer_goldensection(); public static native void gsl_min_fminimizer_goldensection(gsl_min_fminimizer_type setter);
public static native @Const gsl_min_fminimizer_type gsl_min_fminimizer_brent(); public static native void gsl_min_fminimizer_brent(gsl_min_fminimizer_type setter);
public static native @Const gsl_min_fminimizer_type gsl_min_fminimizer_quad_golden(); public static native void gsl_min_fminimizer_quad_golden(gsl_min_fminimizer_type setter);
// Targeting ../gsl_min_bracketing_function.java



public static native int gsl_min_find_bracket(gsl_function f,DoublePointer x_minimum,DoublePointer f_minimum,
                     DoublePointer x_lower, DoublePointer f_lower,
                     DoublePointer x_upper, DoublePointer f_upper,
                     @Cast("size_t") long eval_max);
public static native int gsl_min_find_bracket(gsl_function f,DoubleBuffer x_minimum,DoubleBuffer f_minimum,
                     DoubleBuffer x_lower, DoubleBuffer f_lower,
                     DoubleBuffer x_upper, DoubleBuffer f_upper,
                     @Cast("size_t") long eval_max);
public static native int gsl_min_find_bracket(gsl_function f,double[] x_minimum,double[] f_minimum,
                     double[] x_lower, double[] f_lower,
                     double[] x_upper, double[] f_upper,
                     @Cast("size_t") long eval_max);

// #endif /* __GSL_MIN_H__ */


// Parsed from gsl/gsl_minmax.h

/* gsl_minmax.h
 * 
 * Copyright (C) 2008 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MINMAX_H__
// #define __GSL_MINMAX_H__
// #include <gsl/gsl_inline.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/* Define MAX and MIN macros/functions if they don't exist. */

/* plain old macros for general use */
// #define GSL_MAX(a,b) ((a) > (b) ? (a) : (b))
// #define GSL_MIN(a,b) ((a) < (b) ? (a) : (b))

/* function versions of the above, in case they are needed */
public static native double gsl_max(double a, double b);
public static native double gsl_min(double a, double b);

/* inline-friendly strongly typed versions */
// #ifdef HAVE_INLINE

public static native int GSL_MAX_INT(int a, int b);
public static native int GSL_MIN_INT(int a, int b);
public static native double GSL_MAX_DBL(double a, double b);
public static native double GSL_MIN_DBL(double a, double b);
public static native @Cast("long double") double GSL_MAX_LDBL(@Cast("long double") double a, @Cast("long double") double b);
public static native @Cast("long double") double GSL_MIN_LDBL(@Cast("long double") double a, @Cast("long double") double b);
// #else
// #define GSL_MAX_INT(a,b)   GSL_MAX(a,b)
// #define GSL_MIN_INT(a,b)   GSL_MIN(a,b)
// #define GSL_MAX_DBL(a,b)   GSL_MAX(a,b)
// #define GSL_MIN_DBL(a,b)   GSL_MIN(a,b)
// #define GSL_MAX_LDBL(a,b)  GSL_MAX(a,b)
// #define GSL_MIN_LDBL(a,b)  GSL_MIN(a,b)
// #endif /* HAVE_INLINE */

// #endif /* __GSL_POW_INT_H__ */


// Parsed from gsl/gsl_mode.h

/* gsl_mode.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  B. Gough and G. Jungman */

// #ifndef __GSL_MODE_H__
// #define __GSL_MODE_H__
// #include <gsl/gsl_inline.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


/* Some functions can take a mode argument. This
 * is a rough method to do things like control
 * the precision of the algorithm. This mainly
 * occurs in special functions, but we figured
 * it was ok to have a general facility.
 *
 * The mode type is 32-bit field. Most of
 * the fields are currently unused. Users
 * '|' various predefined constants to get
 * a desired mode.
 */


/* Here are the predefined constants.
 * Note that the precision constants
 * are special because they are used
 * to index arrays, so do not change
 * them. The precision information is
 * in the low order 3 bits of gsl_mode_t
 * (the third bit is currently unused).
 */

/* Note that "0" is double precision,
 * so that you get that by default if
 * you forget a flag.
 */
public static final int GSL_PREC_DOUBLE =  0;
public static final int GSL_PREC_SINGLE =  1;
public static final int GSL_PREC_APPROX =  2;

// #ifdef HAVE_INLINE
public static native @Cast("unsigned int") int GSL_MODE_PREC(@Cast("gsl_mode_t") int mt);
// #else  /* HAVE_INLINE */
// #define GSL_MODE_PREC(mt) ((mt) & (unsigned int)7)
// #endif /* HAVE_INLINE */


/* Here are some predefined generic modes.
 */
public static final int GSL_MODE_DEFAULT =  0;

// #endif /* __GSL_MODE_H__ */


// Parsed from gsl/gsl_test.h

/* err/gsl_test.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_TEST_H__
// #define __GSL_TEST_H__

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native void gsl_test(int status, @Cast("const char*") BytePointer test_description);
public static native void gsl_test(int status, String test_description);

public static native void gsl_test_rel(double result, double expected, double relative_error,
              @Cast("const char*") BytePointer test_description);
public static native void gsl_test_rel(double result, double expected, double relative_error,
              String test_description);

public static native void gsl_test_abs(double result, double expected, double absolute_error,
              @Cast("const char*") BytePointer test_description);
public static native void gsl_test_abs(double result, double expected, double absolute_error,
              String test_description);

public static native void gsl_test_factor(double result, double expected, double factor,
                 @Cast("const char*") BytePointer test_description);
public static native void gsl_test_factor(double result, double expected, double factor,
                 String test_description);

public static native void gsl_test_int(int result, int expected, @Cast("const char*") BytePointer test_description);
public static native void gsl_test_int(int result, int expected, String test_description);

public static native void gsl_test_str(@Cast("const char*") BytePointer result, @Cast("const char*") BytePointer expected, 
              @Cast("const char*") BytePointer test_description);
public static native void gsl_test_str(String result, String expected, 
              String test_description);

public static native void gsl_test_verbose(int verbose);

public static native int gsl_test_summary();

// #endif /* __GSL_TEST_H__ */


// Parsed from gsl/gsl_version.h

// #ifndef __GSL_VERSION_H__
// #define __GSL_VERSION_H__

// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


public static final String GSL_VERSION = "2.7";
public static final int GSL_MAJOR_VERSION = 2;
public static final int GSL_MINOR_VERSION = 7;

public static native @Cast("const char*") BytePointer gsl_version(); public static native void gsl_version(BytePointer setter);

// #endif /* __GSL_VERSION_H__ */


// Parsed from gsl/gsl_block.h

// #ifndef __GSL_BLOCK_H__
// #define __GSL_BLOCK_H__

// #include <gsl/gsl_block_complex_long_double.h>
// #include <gsl/gsl_block_complex_double.h>
// #include <gsl/gsl_block_complex_float.h>

// #include <gsl/gsl_block_long_double.h>
// #include <gsl/gsl_block_double.h>
// #include <gsl/gsl_block_float.h>

// #include <gsl/gsl_block_ulong.h>
// #include <gsl/gsl_block_long.h>

// #include <gsl/gsl_block_uint.h>
// #include <gsl/gsl_block_int.h>

// #include <gsl/gsl_block_ushort.h>
// #include <gsl/gsl_block_short.h>

// #include <gsl/gsl_block_uchar.h>
// #include <gsl/gsl_block_char.h>

// #endif /* __GSL_BLOCK_H__ */


// Parsed from gsl/gsl_block_complex_double.h

/* block/gsl_block_complex_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_COMPLEX_DOUBLE_H__
// #define __GSL_BLOCK_COMPLEX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_complex.java



public static native gsl_block_complex gsl_block_complex_alloc(@Cast("const size_t") long n);
public static native gsl_block_complex gsl_block_complex_calloc(@Cast("const size_t") long n);
public static native void gsl_block_complex_free(gsl_block_complex b);

public static native int gsl_block_complex_fread(FILE stream, gsl_block_complex b);
public static native int gsl_block_complex_fwrite(FILE stream, @Const gsl_block_complex b);
public static native int gsl_block_complex_fscanf(FILE stream, gsl_block_complex b);
public static native int gsl_block_complex_fprintf(FILE stream, @Const gsl_block_complex b, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_fprintf(FILE stream, @Const gsl_block_complex b, String format);

public static native int gsl_block_complex_raw_fread(FILE stream, DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fread(FILE stream, DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fread(FILE stream, double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fwrite(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fwrite(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fwrite(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fscanf(FILE stream, DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fscanf(FILE stream, DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fscanf(FILE stream, double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_raw_fprintf(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_complex_size(@Const gsl_block_complex b);
public static native DoublePointer gsl_block_complex_data(@Const gsl_block_complex b);

// #endif /* __GSL_BLOCK_COMPLEX_DOUBLE_H__ */


// Parsed from gsl/gsl_block_complex_float.h

/* block/gsl_block_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_COMPLEX_FLOAT_H__
// #define __GSL_BLOCK_COMPLEX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_complex_float.java



public static native gsl_block_complex_float gsl_block_complex_float_alloc(@Cast("const size_t") long n);
public static native gsl_block_complex_float gsl_block_complex_float_calloc(@Cast("const size_t") long n);
public static native void gsl_block_complex_float_free(gsl_block_complex_float b);

public static native int gsl_block_complex_float_fread(FILE stream, gsl_block_complex_float b);
public static native int gsl_block_complex_float_fwrite(FILE stream, @Const gsl_block_complex_float b);
public static native int gsl_block_complex_float_fscanf(FILE stream, gsl_block_complex_float b);
public static native int gsl_block_complex_float_fprintf(FILE stream, @Const gsl_block_complex_float b, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_float_fprintf(FILE stream, @Const gsl_block_complex_float b, String format);

public static native int gsl_block_complex_float_raw_fread(FILE stream, FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fread(FILE stream, FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fread(FILE stream, float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fwrite(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fwrite(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fwrite(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fscanf(FILE stream, FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fscanf(FILE stream, FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fscanf(FILE stream, float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_complex_float_raw_fprintf(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_complex_float_size(@Const gsl_block_complex_float b);
public static native FloatPointer gsl_block_complex_float_data(@Const gsl_block_complex_float b);

// #endif /* __GSL_BLOCK_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_block_double.h

/* block/gsl_block_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_DOUBLE_H__
// #define __GSL_BLOCK_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block.java



public static native gsl_block gsl_block_alloc(@Cast("const size_t") long n);
public static native gsl_block gsl_block_calloc(@Cast("const size_t") long n);
public static native void gsl_block_free(gsl_block b);

public static native int gsl_block_fread(FILE stream, gsl_block b);
public static native int gsl_block_fwrite(FILE stream, @Const gsl_block b);
public static native int gsl_block_fscanf(FILE stream, gsl_block b);
public static native int gsl_block_fprintf(FILE stream, @Const gsl_block b, @Cast("const char*") BytePointer format);
public static native int gsl_block_fprintf(FILE stream, @Const gsl_block b, String format);

public static native int gsl_block_raw_fread(FILE stream, DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fread(FILE stream, DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fread(FILE stream, double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fwrite(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fwrite(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fwrite(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fscanf(FILE stream, DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fscanf(FILE stream, DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fscanf(FILE stream, double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_raw_fprintf(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_raw_fprintf(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_raw_fprintf(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_raw_fprintf(FILE stream, @Const DoublePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_raw_fprintf(FILE stream, @Const DoubleBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_raw_fprintf(FILE stream, @Const double[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_size(@Const gsl_block b);
public static native DoublePointer gsl_block_data(@Const gsl_block b);

// #endif /* __GSL_BLOCK_DOUBLE_H__ */


// Parsed from gsl/gsl_block_float.h

/* block/gsl_block_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_FLOAT_H__
// #define __GSL_BLOCK_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_float.java



public static native gsl_block_float gsl_block_float_alloc(@Cast("const size_t") long n);
public static native gsl_block_float gsl_block_float_calloc(@Cast("const size_t") long n);
public static native void gsl_block_float_free(gsl_block_float b);

public static native int gsl_block_float_fread(FILE stream, gsl_block_float b);
public static native int gsl_block_float_fwrite(FILE stream, @Const gsl_block_float b);
public static native int gsl_block_float_fscanf(FILE stream, gsl_block_float b);
public static native int gsl_block_float_fprintf(FILE stream, @Const gsl_block_float b, @Cast("const char*") BytePointer format);
public static native int gsl_block_float_fprintf(FILE stream, @Const gsl_block_float b, String format);

public static native int gsl_block_float_raw_fread(FILE stream, FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fread(FILE stream, FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fread(FILE stream, float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fwrite(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fwrite(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fwrite(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fscanf(FILE stream, FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fscanf(FILE stream, FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fscanf(FILE stream, float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const FloatPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const FloatBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_float_raw_fprintf(FILE stream, @Const float[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_float_size(@Const gsl_block_float b);
public static native FloatPointer gsl_block_float_data(@Const gsl_block_float b);

// #endif /* __GSL_BLOCK_FLOAT_H__ */


// Parsed from gsl/gsl_block_ulong.h

/* block/gsl_block_ulong.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_ULONG_H__
// #define __GSL_BLOCK_ULONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_ulong.java



public static native gsl_block_ulong gsl_block_ulong_alloc(@Cast("const size_t") long n);
public static native gsl_block_ulong gsl_block_ulong_calloc(@Cast("const size_t") long n);
public static native void gsl_block_ulong_free(gsl_block_ulong b);

public static native int gsl_block_ulong_fread(FILE stream, gsl_block_ulong b);
public static native int gsl_block_ulong_fwrite(FILE stream, @Const gsl_block_ulong b);
public static native int gsl_block_ulong_fscanf(FILE stream, gsl_block_ulong b);
public static native int gsl_block_ulong_fprintf(FILE stream, @Const gsl_block_ulong b, @Cast("const char*") BytePointer format);
public static native int gsl_block_ulong_fprintf(FILE stream, @Const gsl_block_ulong b, String format);

public static native int gsl_block_ulong_raw_fread(FILE stream, @Cast("unsigned long*") CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ulong_raw_fwrite(FILE stream, @Cast("const unsigned long*") CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ulong_raw_fscanf(FILE stream, @Cast("unsigned long*") CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ulong_raw_fprintf(FILE stream, @Cast("const unsigned long*") CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_ulong_raw_fprintf(FILE stream, @Cast("const unsigned long*") CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_ulong_size(@Const gsl_block_ulong b);
public static native @Cast("unsigned long*") CLongPointer gsl_block_ulong_data(@Const gsl_block_ulong b);

// #endif /* __GSL_BLOCK_ULONG_H__ */


// Parsed from gsl/gsl_block_long.h

/* block/gsl_block_long.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_LONG_H__
// #define __GSL_BLOCK_LONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_long.java



public static native gsl_block_long gsl_block_long_alloc(@Cast("const size_t") long n);
public static native gsl_block_long gsl_block_long_calloc(@Cast("const size_t") long n);
public static native void gsl_block_long_free(gsl_block_long b);

public static native int gsl_block_long_fread(FILE stream, gsl_block_long b);
public static native int gsl_block_long_fwrite(FILE stream, @Const gsl_block_long b);
public static native int gsl_block_long_fscanf(FILE stream, gsl_block_long b);
public static native int gsl_block_long_fprintf(FILE stream, @Const gsl_block_long b, @Cast("const char*") BytePointer format);
public static native int gsl_block_long_fprintf(FILE stream, @Const gsl_block_long b, String format);

public static native int gsl_block_long_raw_fread(FILE stream, CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_long_raw_fwrite(FILE stream, @Const CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_long_raw_fscanf(FILE stream, CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_long_raw_fprintf(FILE stream, @Const CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_long_raw_fprintf(FILE stream, @Const CLongPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_long_size(@Const gsl_block_long b);
public static native CLongPointer gsl_block_long_data(@Const gsl_block_long b);

// #endif /* __GSL_BLOCK_LONG_H__ */


// Parsed from gsl/gsl_block_uint.h

/* block/gsl_block_uint.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_UINT_H__
// #define __GSL_BLOCK_UINT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_uint.java



public static native gsl_block_uint gsl_block_uint_alloc(@Cast("const size_t") long n);
public static native gsl_block_uint gsl_block_uint_calloc(@Cast("const size_t") long n);
public static native void gsl_block_uint_free(gsl_block_uint b);

public static native int gsl_block_uint_fread(FILE stream, gsl_block_uint b);
public static native int gsl_block_uint_fwrite(FILE stream, @Const gsl_block_uint b);
public static native int gsl_block_uint_fscanf(FILE stream, gsl_block_uint b);
public static native int gsl_block_uint_fprintf(FILE stream, @Const gsl_block_uint b, @Cast("const char*") BytePointer format);
public static native int gsl_block_uint_fprintf(FILE stream, @Const gsl_block_uint b, String format);

public static native int gsl_block_uint_raw_fread(FILE stream, @Cast("unsigned int*") IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fread(FILE stream, @Cast("unsigned int*") IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fread(FILE stream, @Cast("unsigned int*") int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fwrite(FILE stream, @Cast("const unsigned int*") IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fwrite(FILE stream, @Cast("const unsigned int*") IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fwrite(FILE stream, @Cast("const unsigned int*") int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fscanf(FILE stream, @Cast("unsigned int*") IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fscanf(FILE stream, @Cast("unsigned int*") IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fscanf(FILE stream, @Cast("unsigned int*") int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uint_raw_fprintf(FILE stream, @Cast("const unsigned int*") int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_uint_size(@Const gsl_block_uint b);
public static native @Cast("unsigned int*") IntPointer gsl_block_uint_data(@Const gsl_block_uint b);

// #endif /* __GSL_BLOCK_UINT_H__ */


// Parsed from gsl/gsl_block_int.h

/* block/gsl_block_int.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_INT_H__
// #define __GSL_BLOCK_INT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_int.java



public static native gsl_block_int gsl_block_int_alloc(@Cast("const size_t") long n);
public static native gsl_block_int gsl_block_int_calloc(@Cast("const size_t") long n);
public static native void gsl_block_int_free(gsl_block_int b);

public static native int gsl_block_int_fread(FILE stream, gsl_block_int b);
public static native int gsl_block_int_fwrite(FILE stream, @Const gsl_block_int b);
public static native int gsl_block_int_fscanf(FILE stream, gsl_block_int b);
public static native int gsl_block_int_fprintf(FILE stream, @Const gsl_block_int b, @Cast("const char*") BytePointer format);
public static native int gsl_block_int_fprintf(FILE stream, @Const gsl_block_int b, String format);

public static native int gsl_block_int_raw_fread(FILE stream, IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fread(FILE stream, IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fread(FILE stream, int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fwrite(FILE stream, @Const IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fwrite(FILE stream, @Const IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fwrite(FILE stream, @Const int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fscanf(FILE stream, IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fscanf(FILE stream, IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fscanf(FILE stream, int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const IntPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const IntBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_int_raw_fprintf(FILE stream, @Const int[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_int_size(@Const gsl_block_int b);
public static native IntPointer gsl_block_int_data(@Const gsl_block_int b);

// #endif /* __GSL_BLOCK_INT_H__ */


// Parsed from gsl/gsl_block_ushort.h

/* block/gsl_block_ushort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_USHORT_H__
// #define __GSL_BLOCK_USHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_ushort.java



public static native gsl_block_ushort gsl_block_ushort_alloc(@Cast("const size_t") long n);
public static native gsl_block_ushort gsl_block_ushort_calloc(@Cast("const size_t") long n);
public static native void gsl_block_ushort_free(gsl_block_ushort b);

public static native int gsl_block_ushort_fread(FILE stream, gsl_block_ushort b);
public static native int gsl_block_ushort_fwrite(FILE stream, @Const gsl_block_ushort b);
public static native int gsl_block_ushort_fscanf(FILE stream, gsl_block_ushort b);
public static native int gsl_block_ushort_fprintf(FILE stream, @Const gsl_block_ushort b, @Cast("const char*") BytePointer format);
public static native int gsl_block_ushort_fprintf(FILE stream, @Const gsl_block_ushort b, String format);

public static native int gsl_block_ushort_raw_fread(FILE stream, @Cast("unsigned short*") ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fread(FILE stream, @Cast("unsigned short*") ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fread(FILE stream, @Cast("unsigned short*") short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fwrite(FILE stream, @Cast("const unsigned short*") ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fwrite(FILE stream, @Cast("const unsigned short*") ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fwrite(FILE stream, @Cast("const unsigned short*") short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fscanf(FILE stream, @Cast("unsigned short*") ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fscanf(FILE stream, @Cast("unsigned short*") ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fscanf(FILE stream, @Cast("unsigned short*") short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_ushort_raw_fprintf(FILE stream, @Cast("const unsigned short*") short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_ushort_size(@Const gsl_block_ushort b);
public static native @Cast("unsigned short*") ShortPointer gsl_block_ushort_data(@Const gsl_block_ushort b);

// #endif /* __GSL_BLOCK_USHORT_H__ */


// Parsed from gsl/gsl_block_short.h

/* block/gsl_block_short.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_SHORT_H__
// #define __GSL_BLOCK_SHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_short.java



public static native gsl_block_short gsl_block_short_alloc(@Cast("const size_t") long n);
public static native gsl_block_short gsl_block_short_calloc(@Cast("const size_t") long n);
public static native void gsl_block_short_free(gsl_block_short b);

public static native int gsl_block_short_fread(FILE stream, gsl_block_short b);
public static native int gsl_block_short_fwrite(FILE stream, @Const gsl_block_short b);
public static native int gsl_block_short_fscanf(FILE stream, gsl_block_short b);
public static native int gsl_block_short_fprintf(FILE stream, @Const gsl_block_short b, @Cast("const char*") BytePointer format);
public static native int gsl_block_short_fprintf(FILE stream, @Const gsl_block_short b, String format);

public static native int gsl_block_short_raw_fread(FILE stream, ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fread(FILE stream, ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fread(FILE stream, short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fwrite(FILE stream, @Const ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fwrite(FILE stream, @Const ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fwrite(FILE stream, @Const short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fscanf(FILE stream, ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fscanf(FILE stream, ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fscanf(FILE stream, short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const ShortPointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const ShortBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_short_raw_fprintf(FILE stream, @Const short[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_short_size(@Const gsl_block_short b);
public static native ShortPointer gsl_block_short_data(@Const gsl_block_short b);

// #endif /* __GSL_BLOCK_SHORT_H__ */


// Parsed from gsl/gsl_block_uchar.h

/* block/gsl_block_uchar.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_UCHAR_H__
// #define __GSL_BLOCK_UCHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_uchar.java



public static native gsl_block_uchar gsl_block_uchar_alloc(@Cast("const size_t") long n);
public static native gsl_block_uchar gsl_block_uchar_calloc(@Cast("const size_t") long n);
public static native void gsl_block_uchar_free(gsl_block_uchar b);

public static native int gsl_block_uchar_fread(FILE stream, gsl_block_uchar b);
public static native int gsl_block_uchar_fwrite(FILE stream, @Const gsl_block_uchar b);
public static native int gsl_block_uchar_fscanf(FILE stream, gsl_block_uchar b);
public static native int gsl_block_uchar_fprintf(FILE stream, @Const gsl_block_uchar b, @Cast("const char*") BytePointer format);
public static native int gsl_block_uchar_fprintf(FILE stream, @Const gsl_block_uchar b, String format);

public static native int gsl_block_uchar_raw_fread(FILE stream, @Cast("unsigned char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fread(FILE stream, @Cast("unsigned char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fread(FILE stream, @Cast("unsigned char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fwrite(FILE stream, @Cast("const unsigned char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fwrite(FILE stream, @Cast("const unsigned char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fwrite(FILE stream, @Cast("const unsigned char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fscanf(FILE stream, @Cast("unsigned char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fscanf(FILE stream, @Cast("unsigned char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fscanf(FILE stream, @Cast("unsigned char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_uchar_raw_fprintf(FILE stream, @Cast("const unsigned char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_uchar_size(@Const gsl_block_uchar b);
public static native @Cast("unsigned char*") BytePointer gsl_block_uchar_data(@Const gsl_block_uchar b);

// #endif /* __GSL_BLOCK_UCHAR_H__ */


// Parsed from gsl/gsl_block_char.h

/* block/gsl_block_char.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BLOCK_CHAR_H__
// #define __GSL_BLOCK_CHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_block_char.java



public static native gsl_block_char gsl_block_char_alloc(@Cast("const size_t") long n);
public static native gsl_block_char gsl_block_char_calloc(@Cast("const size_t") long n);
public static native void gsl_block_char_free(gsl_block_char b);

public static native int gsl_block_char_fread(FILE stream, gsl_block_char b);
public static native int gsl_block_char_fwrite(FILE stream, @Const gsl_block_char b);
public static native int gsl_block_char_fscanf(FILE stream, gsl_block_char b);
public static native int gsl_block_char_fprintf(FILE stream, @Const gsl_block_char b, @Cast("const char*") BytePointer format);
public static native int gsl_block_char_fprintf(FILE stream, @Const gsl_block_char b, String format);

public static native int gsl_block_char_raw_fread(FILE stream, @Cast("char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fread(FILE stream, @Cast("char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fread(FILE stream, @Cast("char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fwrite(FILE stream, @Cast("const char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fwrite(FILE stream, String b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fscanf(FILE stream, @Cast("char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fscanf(FILE stream, @Cast("char*") ByteBuffer b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fscanf(FILE stream, @Cast("char*") byte[] b, @Cast("const size_t") long n, @Cast("const size_t") long stride);
public static native int gsl_block_char_raw_fprintf(FILE stream, @Cast("const char*") BytePointer b, @Cast("const size_t") long n, @Cast("const size_t") long stride, @Cast("const char*") BytePointer format);
public static native int gsl_block_char_raw_fprintf(FILE stream, String b, @Cast("const size_t") long n, @Cast("const size_t") long stride, String format);

public static native @Cast("size_t") long gsl_block_char_size(@Const gsl_block_char b);
public static native @Cast("char*") BytePointer gsl_block_char_data(@Const gsl_block_char b);

// #endif /* __GSL_BLOCK_CHAR_H__ */


// Parsed from gsl/gsl_vector_complex.h

// #ifndef __GSL_VECTOR_COMPLEX_H__
// #define __GSL_VECTOR_COMPLEX_H__

// #define  GSL_VECTOR_REAL(z, i)  ((z)->data[2*(i)*(z)->stride])
// #define  GSL_VECTOR_IMAG(z, i)  ((z)->data[2*(i)*(z)->stride + 1])

// #if GSL_RANGE_CHECK
// #else
// #define GSL_VECTOR_COMPLEX(zv, i) (*GSL_COMPLEX_AT((zv),(i)))
// #endif

// #define GSL_COMPLEX_AT(zv,i) ((gsl_complex*)&((zv)->data[2*(i)*(zv)->stride]))
// #define GSL_COMPLEX_FLOAT_AT(zv,i) ((gsl_complex_float*)&((zv)->data[2*(i)*(zv)->stride]))
// #define GSL_COMPLEX_LONG_DOUBLE_AT(zv,i) ((gsl_complex_long_double*)&((zv)->data[2*(i)*(zv)->stride]))

// #endif /* __GSL_VECTOR_COMPLEX_H__ */


// Parsed from gsl/gsl_vector.h

// #ifndef __GSL_VECTOR_H__
// #define __GSL_VECTOR_H__

// #include <gsl/gsl_vector_complex_long_double.h>
// #include <gsl/gsl_vector_complex_double.h>
// #include <gsl/gsl_vector_complex_float.h>

// #include <gsl/gsl_vector_long_double.h>
// #include <gsl/gsl_vector_double.h>
// #include <gsl/gsl_vector_float.h>

// #include <gsl/gsl_vector_ulong.h>
// #include <gsl/gsl_vector_long.h>

// #include <gsl/gsl_vector_uint.h>
// #include <gsl/gsl_vector_int.h>

// #include <gsl/gsl_vector_ushort.h>
// #include <gsl/gsl_vector_short.h>

// #include <gsl/gsl_vector_uchar.h>
// #include <gsl/gsl_vector_char.h>


// #endif /* __GSL_VECTOR_H__ */


// Parsed from gsl/gsl_vector_complex_double.h

/* vector/gsl_vector_complex_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_COMPLEX_DOUBLE_H__
// #define __GSL_VECTOR_COMPLEX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_double.h>
// #include <gsl/gsl_vector_complex.h>
// #include <gsl/gsl_block_complex_double.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_complex.java


// Targeting ../_gsl_vector_complex_view.java


// Targeting ../_gsl_vector_complex_const_view.java



/* Allocation */

public static native gsl_vector_complex gsl_vector_complex_alloc(@Cast("const size_t") long n);
public static native gsl_vector_complex gsl_vector_complex_calloc(@Cast("const size_t") long n);

public static native gsl_vector_complex gsl_vector_complex_alloc_from_block(gsl_block_complex b, 
                                           @Cast("const size_t") long offset, 
                                           @Cast("const size_t") long n, 
                                           @Cast("const size_t") long stride);

public static native gsl_vector_complex gsl_vector_complex_alloc_from_vector(gsl_vector_complex v, 
                                             @Cast("const size_t") long offset, 
                                             @Cast("const size_t") long n, 
                                             @Cast("const size_t") long stride);

public static native void gsl_vector_complex_free(gsl_vector_complex v);

/* Views */

public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array(DoublePointer base,
                                     @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array(DoubleBuffer base,
                                     @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array(double[] base,
                                     @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array_with_stride(DoublePointer base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array_with_stride(DoubleBuffer base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_view_array_with_stride(double[] base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array(@Const DoublePointer base,
                                           @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array(@Const DoubleBuffer base,
                                           @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array(@Const double[] base,
                                           @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array_with_stride(@Const DoublePointer base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array_with_stride(@Const DoubleBuffer base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_view_array_with_stride(@Const double[] base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_subvector(gsl_vector_complex base,
                                         @Cast("size_t") long i, 
                                         @Cast("size_t") long n);


public static native @ByVal _gsl_vector_complex_view gsl_vector_complex_subvector_with_stride(gsl_vector_complex v, 
                                                @Cast("size_t") long i, 
                                                @Cast("size_t") long stride, 
                                                @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_subvector(@Const gsl_vector_complex base,
                                               @Cast("size_t") long i, 
                                               @Cast("size_t") long n);


public static native @ByVal _gsl_vector_complex_const_view gsl_vector_complex_const_subvector_with_stride(@Const gsl_vector_complex v, 
                                                      @Cast("size_t") long i, 
                                                      @Cast("size_t") long stride, 
                                                      @Cast("size_t") long n);

public static native @ByVal _gsl_vector_view gsl_vector_complex_real(gsl_vector_complex v);

public static native @ByVal _gsl_vector_view gsl_vector_complex_imag(gsl_vector_complex v);

public static native @ByVal _gsl_vector_const_view gsl_vector_complex_const_real(@Const gsl_vector_complex v);

public static native @ByVal _gsl_vector_const_view gsl_vector_complex_const_imag(@Const gsl_vector_complex v);


/* Operations */

public static native void gsl_vector_complex_set_zero(gsl_vector_complex v);
public static native void gsl_vector_complex_set_all(gsl_vector_complex v,
                                       @ByVal gsl_complex z);
public static native int gsl_vector_complex_set_basis(gsl_vector_complex v, @Cast("size_t") long i);

public static native int gsl_vector_complex_fread(FILE stream,
                                    gsl_vector_complex v);
public static native int gsl_vector_complex_fwrite(FILE stream,
                                     @Const gsl_vector_complex v);
public static native int gsl_vector_complex_fscanf(FILE stream,
                                     gsl_vector_complex v);
public static native int gsl_vector_complex_fprintf(FILE stream,
                                      @Const gsl_vector_complex v,
                                      @Cast("const char*") BytePointer format);
public static native int gsl_vector_complex_fprintf(FILE stream,
                                      @Const gsl_vector_complex v,
                                      String format);

public static native int gsl_vector_complex_memcpy(gsl_vector_complex dest, @Const gsl_vector_complex src);

public static native int gsl_vector_complex_reverse(gsl_vector_complex v);

public static native int gsl_vector_complex_swap(gsl_vector_complex v, gsl_vector_complex w);
public static native int gsl_vector_complex_swap_elements(gsl_vector_complex v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_vector_complex_equal(@Const gsl_vector_complex u, 
                                    @Const gsl_vector_complex v);

public static native int gsl_vector_complex_isnull(@Const gsl_vector_complex v);
public static native int gsl_vector_complex_ispos(@Const gsl_vector_complex v);
public static native int gsl_vector_complex_isneg(@Const gsl_vector_complex v);
public static native int gsl_vector_complex_isnonneg(@Const gsl_vector_complex v);

public static native int gsl_vector_complex_add(gsl_vector_complex a, @Const gsl_vector_complex b);
public static native int gsl_vector_complex_sub(gsl_vector_complex a, @Const gsl_vector_complex b);
public static native int gsl_vector_complex_mul(gsl_vector_complex a, @Const gsl_vector_complex b);
public static native int gsl_vector_complex_div(gsl_vector_complex a, @Const gsl_vector_complex b);
public static native int gsl_vector_complex_scale(gsl_vector_complex a, @Const @ByVal gsl_complex x);
public static native int gsl_vector_complex_add_constant(gsl_vector_complex a, @Const @ByVal gsl_complex x);
public static native int gsl_vector_complex_axpby(@Const @ByVal gsl_complex alpha, @Const gsl_vector_complex x, @Const @ByVal gsl_complex beta, gsl_vector_complex y);

/* */ public static native @ByVal gsl_complex gsl_vector_complex_get(@Const gsl_vector_complex v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_complex_set(gsl_vector_complex v, @Cast("const size_t") long i, @ByVal gsl_complex z);
/* */ public static native gsl_complex gsl_vector_complex_ptr(gsl_vector_complex v, @Cast("const size_t") long i);
/* */ public static native @Const gsl_complex gsl_vector_complex_const_ptr(@Const gsl_vector_complex v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE


// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_COMPLEX_DOUBLE_H__ */


// Parsed from gsl/gsl_vector_complex_float.h

/* vector/gsl_vector_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_COMPLEX_FLOAT_H__
// #define __GSL_VECTOR_COMPLEX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_float.h>
// #include <gsl/gsl_vector_complex.h>
// #include <gsl/gsl_block_complex_float.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_complex_float.java


// Targeting ../_gsl_vector_complex_float_view.java


// Targeting ../_gsl_vector_complex_float_const_view.java



/* Allocation */

public static native gsl_vector_complex_float gsl_vector_complex_float_alloc(@Cast("const size_t") long n);
public static native gsl_vector_complex_float gsl_vector_complex_float_calloc(@Cast("const size_t") long n);

public static native gsl_vector_complex_float gsl_vector_complex_float_alloc_from_block(gsl_block_complex_float b, 
                                           @Cast("const size_t") long offset, 
                                           @Cast("const size_t") long n, 
                                           @Cast("const size_t") long stride);

public static native gsl_vector_complex_float gsl_vector_complex_float_alloc_from_vector(gsl_vector_complex_float v, 
                                             @Cast("const size_t") long offset, 
                                             @Cast("const size_t") long n, 
                                             @Cast("const size_t") long stride);

public static native void gsl_vector_complex_float_free(gsl_vector_complex_float v);

/* Views */

public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array(FloatPointer base,
                                     @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array(FloatBuffer base,
                                     @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array(float[] base,
                                     @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array_with_stride(FloatPointer base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array_with_stride(FloatBuffer base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_view_array_with_stride(float[] base,
                                                 @Cast("size_t") long stride,
                                                 @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array(@Const FloatPointer base,
                                           @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array(@Const FloatBuffer base,
                                           @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array(@Const float[] base,
                                           @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array_with_stride(@Const FloatPointer base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array_with_stride(@Const FloatBuffer base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);
public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_view_array_with_stride(@Const float[] base,
                                                       @Cast("size_t") long stride,
                                                       @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_subvector(gsl_vector_complex_float base,
                                         @Cast("size_t") long i, 
                                         @Cast("size_t") long n);


public static native @ByVal _gsl_vector_complex_float_view gsl_vector_complex_float_subvector_with_stride(gsl_vector_complex_float v, 
                                                @Cast("size_t") long i, 
                                                @Cast("size_t") long stride, 
                                                @Cast("size_t") long n);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_subvector(@Const gsl_vector_complex_float base,
                                               @Cast("size_t") long i, 
                                               @Cast("size_t") long n);


public static native @ByVal _gsl_vector_complex_float_const_view gsl_vector_complex_float_const_subvector_with_stride(@Const gsl_vector_complex_float v, 
                                                      @Cast("size_t") long i, 
                                                      @Cast("size_t") long stride, 
                                                      @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_view gsl_vector_complex_float_real(gsl_vector_complex_float v);

public static native @ByVal _gsl_vector_float_view gsl_vector_complex_float_imag(gsl_vector_complex_float v);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_complex_float_const_real(@Const gsl_vector_complex_float v);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_complex_float_const_imag(@Const gsl_vector_complex_float v);


/* Operations */

public static native void gsl_vector_complex_float_set_zero(gsl_vector_complex_float v);
public static native void gsl_vector_complex_float_set_all(gsl_vector_complex_float v,
                                       @ByVal gsl_complex_float z);
public static native int gsl_vector_complex_float_set_basis(gsl_vector_complex_float v, @Cast("size_t") long i);

public static native int gsl_vector_complex_float_fread(FILE stream,
                                    gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_fwrite(FILE stream,
                                     @Const gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_fscanf(FILE stream,
                                     gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_fprintf(FILE stream,
                                      @Const gsl_vector_complex_float v,
                                      @Cast("const char*") BytePointer format);
public static native int gsl_vector_complex_float_fprintf(FILE stream,
                                      @Const gsl_vector_complex_float v,
                                      String format);

public static native int gsl_vector_complex_float_memcpy(gsl_vector_complex_float dest, @Const gsl_vector_complex_float src);

public static native int gsl_vector_complex_float_reverse(gsl_vector_complex_float v);

public static native int gsl_vector_complex_float_swap(gsl_vector_complex_float v, gsl_vector_complex_float w);
public static native int gsl_vector_complex_float_swap_elements(gsl_vector_complex_float v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_vector_complex_float_equal(@Const gsl_vector_complex_float u, 
                                    @Const gsl_vector_complex_float v);

public static native int gsl_vector_complex_float_isnull(@Const gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_ispos(@Const gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_isneg(@Const gsl_vector_complex_float v);
public static native int gsl_vector_complex_float_isnonneg(@Const gsl_vector_complex_float v);

public static native int gsl_vector_complex_float_add(gsl_vector_complex_float a, @Const gsl_vector_complex_float b);
public static native int gsl_vector_complex_float_sub(gsl_vector_complex_float a, @Const gsl_vector_complex_float b);
public static native int gsl_vector_complex_float_mul(gsl_vector_complex_float a, @Const gsl_vector_complex_float b);
public static native int gsl_vector_complex_float_div(gsl_vector_complex_float a, @Const gsl_vector_complex_float b);
public static native int gsl_vector_complex_float_scale(gsl_vector_complex_float a, @Const @ByVal gsl_complex_float x);
public static native int gsl_vector_complex_float_add_constant(gsl_vector_complex_float a, @Const @ByVal gsl_complex_float x);
public static native int gsl_vector_complex_float_axpby(@Const @ByVal gsl_complex_float alpha, @Const gsl_vector_complex_float x, @Const @ByVal gsl_complex_float beta, gsl_vector_complex_float y);

/* */ public static native @ByVal gsl_complex_float gsl_vector_complex_float_get(@Const gsl_vector_complex_float v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_complex_float_set(gsl_vector_complex_float v, @Cast("const size_t") long i, @ByVal gsl_complex_float z);
/* */ public static native gsl_complex_float gsl_vector_complex_float_ptr(gsl_vector_complex_float v, @Cast("const size_t") long i);
/* */ public static native @Const gsl_complex_float gsl_vector_complex_float_const_ptr(@Const gsl_vector_complex_float v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE


// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_vector_double.h

/* vector/gsl_vector_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_DOUBLE_H__
// #define __GSL_VECTOR_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_double.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector.java


// Targeting ../_gsl_vector_view.java


// Targeting ../_gsl_vector_const_view.java




/* Allocation */

public static native gsl_vector gsl_vector_alloc(@Cast("const size_t") long n);
public static native gsl_vector gsl_vector_calloc(@Cast("const size_t") long n);

public static native gsl_vector gsl_vector_alloc_from_block(gsl_block b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector gsl_vector_alloc_from_vector(gsl_vector v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_free(gsl_vector v);

/* Views */

public static native @ByVal _gsl_vector_view gsl_vector_view_array(DoublePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_view gsl_vector_view_array(DoubleBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_view gsl_vector_view_array(double[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_view gsl_vector_view_array_with_stride(DoublePointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_view gsl_vector_view_array_with_stride(DoubleBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_view gsl_vector_view_array_with_stride(double[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array(@Const DoublePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array(@Const DoubleBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array(@Const double[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array_with_stride(@Const DoublePointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array_with_stride(@Const DoubleBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_const_view gsl_vector_const_view_array_with_stride(@Const double[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_view gsl_vector_subvector(gsl_vector v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_view gsl_vector_subvector_with_stride(gsl_vector v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_const_view gsl_vector_const_subvector(@Const gsl_vector v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_const_view gsl_vector_const_subvector_with_stride(@Const gsl_vector v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_set_zero(gsl_vector v);
public static native void gsl_vector_set_all(gsl_vector v, double x);
public static native int gsl_vector_set_basis(gsl_vector v, @Cast("size_t") long i);

public static native int gsl_vector_fread(FILE stream, gsl_vector v);
public static native int gsl_vector_fwrite(FILE stream, @Const gsl_vector v);
public static native int gsl_vector_fscanf(FILE stream, gsl_vector v);
public static native int gsl_vector_fprintf(FILE stream, @Const gsl_vector v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_fprintf(FILE stream, @Const gsl_vector v,
                              String format);

public static native int gsl_vector_memcpy(gsl_vector dest, @Const gsl_vector src);

public static native int gsl_vector_reverse(gsl_vector v);

public static native int gsl_vector_swap(gsl_vector v, gsl_vector w);
public static native int gsl_vector_swap_elements(gsl_vector v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native double gsl_vector_max(@Const gsl_vector v);
public static native double gsl_vector_min(@Const gsl_vector v);
public static native void gsl_vector_minmax(@Const gsl_vector v, DoublePointer min_out, DoublePointer max_out);
public static native void gsl_vector_minmax(@Const gsl_vector v, DoubleBuffer min_out, DoubleBuffer max_out);
public static native void gsl_vector_minmax(@Const gsl_vector v, double[] min_out, double[] max_out);

public static native @Cast("size_t") long gsl_vector_max_index(@Const gsl_vector v);
public static native @Cast("size_t") long gsl_vector_min_index(@Const gsl_vector v);
public static native void gsl_vector_minmax_index(@Const gsl_vector v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_add(gsl_vector a, @Const gsl_vector b);
public static native int gsl_vector_sub(gsl_vector a, @Const gsl_vector b);
public static native int gsl_vector_mul(gsl_vector a, @Const gsl_vector b);
public static native int gsl_vector_div(gsl_vector a, @Const gsl_vector b);
public static native int gsl_vector_scale(gsl_vector a, double x);
public static native int gsl_vector_add_constant(gsl_vector a, double x);
public static native int gsl_vector_axpby(double alpha, @Const gsl_vector x, double beta, gsl_vector y);
public static native double gsl_vector_sum(@Const gsl_vector a);

public static native int gsl_vector_equal(@Const gsl_vector u, 
                            @Const gsl_vector v);

public static native int gsl_vector_isnull(@Const gsl_vector v);
public static native int gsl_vector_ispos(@Const gsl_vector v);
public static native int gsl_vector_isneg(@Const gsl_vector v);
public static native int gsl_vector_isnonneg(@Const gsl_vector v);

/* */ public static native double gsl_vector_get(@Const gsl_vector v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_set(gsl_vector v, @Cast("const size_t") long i, double x);
/* */ public static native DoublePointer gsl_vector_ptr(gsl_vector v, @Cast("const size_t") long i);
/* */ public static native @Const DoublePointer gsl_vector_const_ptr(@Const gsl_vector v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_DOUBLE_H__ */




// Parsed from gsl/gsl_vector_float.h

/* vector/gsl_vector_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_FLOAT_H__
// #define __GSL_VECTOR_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_float.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_float.java


// Targeting ../_gsl_vector_float_view.java


// Targeting ../_gsl_vector_float_const_view.java




/* Allocation */

public static native gsl_vector_float gsl_vector_float_alloc(@Cast("const size_t") long n);
public static native gsl_vector_float gsl_vector_float_calloc(@Cast("const size_t") long n);

public static native gsl_vector_float gsl_vector_float_alloc_from_block(gsl_block_float b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_float gsl_vector_float_alloc_from_vector(gsl_vector_float v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_float_free(gsl_vector_float v);

/* Views */

public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array(FloatPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array(FloatBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array(float[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array_with_stride(FloatPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array_with_stride(FloatBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_view gsl_vector_float_view_array_with_stride(float[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array(@Const FloatPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array(@Const FloatBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array(@Const float[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array_with_stride(@Const FloatPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array_with_stride(@Const FloatBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_view_array_with_stride(@Const float[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_view gsl_vector_float_subvector(gsl_vector_float v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_view gsl_vector_float_subvector_with_stride(gsl_vector_float v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_subvector(@Const gsl_vector_float v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_float_const_view gsl_vector_float_const_subvector_with_stride(@Const gsl_vector_float v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_float_set_zero(gsl_vector_float v);
public static native void gsl_vector_float_set_all(gsl_vector_float v, float x);
public static native int gsl_vector_float_set_basis(gsl_vector_float v, @Cast("size_t") long i);

public static native int gsl_vector_float_fread(FILE stream, gsl_vector_float v);
public static native int gsl_vector_float_fwrite(FILE stream, @Const gsl_vector_float v);
public static native int gsl_vector_float_fscanf(FILE stream, gsl_vector_float v);
public static native int gsl_vector_float_fprintf(FILE stream, @Const gsl_vector_float v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_float_fprintf(FILE stream, @Const gsl_vector_float v,
                              String format);

public static native int gsl_vector_float_memcpy(gsl_vector_float dest, @Const gsl_vector_float src);

public static native int gsl_vector_float_reverse(gsl_vector_float v);

public static native int gsl_vector_float_swap(gsl_vector_float v, gsl_vector_float w);
public static native int gsl_vector_float_swap_elements(gsl_vector_float v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native float gsl_vector_float_max(@Const gsl_vector_float v);
public static native float gsl_vector_float_min(@Const gsl_vector_float v);
public static native void gsl_vector_float_minmax(@Const gsl_vector_float v, FloatPointer min_out, FloatPointer max_out);
public static native void gsl_vector_float_minmax(@Const gsl_vector_float v, FloatBuffer min_out, FloatBuffer max_out);
public static native void gsl_vector_float_minmax(@Const gsl_vector_float v, float[] min_out, float[] max_out);

public static native @Cast("size_t") long gsl_vector_float_max_index(@Const gsl_vector_float v);
public static native @Cast("size_t") long gsl_vector_float_min_index(@Const gsl_vector_float v);
public static native void gsl_vector_float_minmax_index(@Const gsl_vector_float v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_float_add(gsl_vector_float a, @Const gsl_vector_float b);
public static native int gsl_vector_float_sub(gsl_vector_float a, @Const gsl_vector_float b);
public static native int gsl_vector_float_mul(gsl_vector_float a, @Const gsl_vector_float b);
public static native int gsl_vector_float_div(gsl_vector_float a, @Const gsl_vector_float b);
public static native int gsl_vector_float_scale(gsl_vector_float a, float x);
public static native int gsl_vector_float_add_constant(gsl_vector_float a, float x);
public static native int gsl_vector_float_axpby(float alpha, @Const gsl_vector_float x, float beta, gsl_vector_float y);
public static native float gsl_vector_float_sum(@Const gsl_vector_float a);

public static native int gsl_vector_float_equal(@Const gsl_vector_float u, 
                            @Const gsl_vector_float v);

public static native int gsl_vector_float_isnull(@Const gsl_vector_float v);
public static native int gsl_vector_float_ispos(@Const gsl_vector_float v);
public static native int gsl_vector_float_isneg(@Const gsl_vector_float v);
public static native int gsl_vector_float_isnonneg(@Const gsl_vector_float v);

/* */ public static native float gsl_vector_float_get(@Const gsl_vector_float v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_float_set(gsl_vector_float v, @Cast("const size_t") long i, float x);
/* */ public static native FloatPointer gsl_vector_float_ptr(gsl_vector_float v, @Cast("const size_t") long i);
/* */ public static native @Const FloatPointer gsl_vector_float_const_ptr(@Const gsl_vector_float v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_FLOAT_H__ */




// Parsed from gsl/gsl_vector_ulong.h

/* vector/gsl_vector_ulong.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_ULONG_H__
// #define __GSL_VECTOR_ULONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_ulong.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_ulong.java


// Targeting ../_gsl_vector_ulong_view.java


// Targeting ../_gsl_vector_ulong_const_view.java




/* Allocation */

public static native gsl_vector_ulong gsl_vector_ulong_alloc(@Cast("const size_t") long n);
public static native gsl_vector_ulong gsl_vector_ulong_calloc(@Cast("const size_t") long n);

public static native gsl_vector_ulong gsl_vector_ulong_alloc_from_block(gsl_block_ulong b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_ulong gsl_vector_ulong_alloc_from_vector(gsl_vector_ulong v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_ulong_free(gsl_vector_ulong v);

/* Views */

public static native @ByVal _gsl_vector_ulong_view gsl_vector_ulong_view_array(@Cast("unsigned long*") CLongPointer v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_view gsl_vector_ulong_view_array_with_stride(@Cast("unsigned long*") CLongPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_const_view gsl_vector_ulong_const_view_array(@Cast("const unsigned long*") CLongPointer v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_const_view gsl_vector_ulong_const_view_array_with_stride(@Cast("const unsigned long*") CLongPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_view gsl_vector_ulong_subvector(gsl_vector_ulong v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_view gsl_vector_ulong_subvector_with_stride(gsl_vector_ulong v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_const_view gsl_vector_ulong_const_subvector(@Const gsl_vector_ulong v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ulong_const_view gsl_vector_ulong_const_subvector_with_stride(@Const gsl_vector_ulong v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_ulong_set_zero(gsl_vector_ulong v);
public static native void gsl_vector_ulong_set_all(gsl_vector_ulong v, @Cast("unsigned long") long x);
public static native int gsl_vector_ulong_set_basis(gsl_vector_ulong v, @Cast("size_t") long i);

public static native int gsl_vector_ulong_fread(FILE stream, gsl_vector_ulong v);
public static native int gsl_vector_ulong_fwrite(FILE stream, @Const gsl_vector_ulong v);
public static native int gsl_vector_ulong_fscanf(FILE stream, gsl_vector_ulong v);
public static native int gsl_vector_ulong_fprintf(FILE stream, @Const gsl_vector_ulong v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_ulong_fprintf(FILE stream, @Const gsl_vector_ulong v,
                              String format);

public static native int gsl_vector_ulong_memcpy(gsl_vector_ulong dest, @Const gsl_vector_ulong src);

public static native int gsl_vector_ulong_reverse(gsl_vector_ulong v);

public static native int gsl_vector_ulong_swap(gsl_vector_ulong v, gsl_vector_ulong w);
public static native int gsl_vector_ulong_swap_elements(gsl_vector_ulong v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native @Cast("unsigned long") long gsl_vector_ulong_max(@Const gsl_vector_ulong v);
public static native @Cast("unsigned long") long gsl_vector_ulong_min(@Const gsl_vector_ulong v);
public static native void gsl_vector_ulong_minmax(@Const gsl_vector_ulong v, @Cast("unsigned long*") CLongPointer min_out, @Cast("unsigned long*") CLongPointer max_out);

public static native @Cast("size_t") long gsl_vector_ulong_max_index(@Const gsl_vector_ulong v);
public static native @Cast("size_t") long gsl_vector_ulong_min_index(@Const gsl_vector_ulong v);
public static native void gsl_vector_ulong_minmax_index(@Const gsl_vector_ulong v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_ulong_add(gsl_vector_ulong a, @Const gsl_vector_ulong b);
public static native int gsl_vector_ulong_sub(gsl_vector_ulong a, @Const gsl_vector_ulong b);
public static native int gsl_vector_ulong_mul(gsl_vector_ulong a, @Const gsl_vector_ulong b);
public static native int gsl_vector_ulong_div(gsl_vector_ulong a, @Const gsl_vector_ulong b);
public static native int gsl_vector_ulong_scale(gsl_vector_ulong a, @Cast("const unsigned long") long x);
public static native int gsl_vector_ulong_add_constant(gsl_vector_ulong a, @Cast("const unsigned long") long x);
public static native int gsl_vector_ulong_axpby(@Cast("const unsigned long") long alpha, @Const gsl_vector_ulong x, @Cast("const unsigned long") long beta, gsl_vector_ulong y);
public static native @Cast("unsigned long") long gsl_vector_ulong_sum(@Const gsl_vector_ulong a);

public static native int gsl_vector_ulong_equal(@Const gsl_vector_ulong u, 
                            @Const gsl_vector_ulong v);

public static native int gsl_vector_ulong_isnull(@Const gsl_vector_ulong v);
public static native int gsl_vector_ulong_ispos(@Const gsl_vector_ulong v);
public static native int gsl_vector_ulong_isneg(@Const gsl_vector_ulong v);
public static native int gsl_vector_ulong_isnonneg(@Const gsl_vector_ulong v);

/* */ public static native @Cast("unsigned long") long gsl_vector_ulong_get(@Const gsl_vector_ulong v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_ulong_set(gsl_vector_ulong v, @Cast("const size_t") long i, @Cast("unsigned long") long x);
/* */ public static native @Cast("unsigned long*") CLongPointer gsl_vector_ulong_ptr(gsl_vector_ulong v, @Cast("const size_t") long i);
/* */ public static native @Cast("const unsigned long*") CLongPointer gsl_vector_ulong_const_ptr(@Const gsl_vector_ulong v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_ULONG_H__ */




// Parsed from gsl/gsl_vector_long.h

/* vector/gsl_vector_long.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_LONG_H__
// #define __GSL_VECTOR_LONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_long.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_long.java


// Targeting ../_gsl_vector_long_view.java


// Targeting ../_gsl_vector_long_const_view.java




/* Allocation */

public static native gsl_vector_long gsl_vector_long_alloc(@Cast("const size_t") long n);
public static native gsl_vector_long gsl_vector_long_calloc(@Cast("const size_t") long n);

public static native gsl_vector_long gsl_vector_long_alloc_from_block(gsl_block_long b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_long gsl_vector_long_alloc_from_vector(gsl_vector_long v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_long_free(gsl_vector_long v);

/* Views */

public static native @ByVal _gsl_vector_long_view gsl_vector_long_view_array(CLongPointer v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_view gsl_vector_long_view_array_with_stride(CLongPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_const_view gsl_vector_long_const_view_array(@Const CLongPointer v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_const_view gsl_vector_long_const_view_array_with_stride(@Const CLongPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_view gsl_vector_long_subvector(gsl_vector_long v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_view gsl_vector_long_subvector_with_stride(gsl_vector_long v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_const_view gsl_vector_long_const_subvector(@Const gsl_vector_long v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_long_const_view gsl_vector_long_const_subvector_with_stride(@Const gsl_vector_long v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_long_set_zero(gsl_vector_long v);
public static native void gsl_vector_long_set_all(gsl_vector_long v, long x);
public static native int gsl_vector_long_set_basis(gsl_vector_long v, @Cast("size_t") long i);

public static native int gsl_vector_long_fread(FILE stream, gsl_vector_long v);
public static native int gsl_vector_long_fwrite(FILE stream, @Const gsl_vector_long v);
public static native int gsl_vector_long_fscanf(FILE stream, gsl_vector_long v);
public static native int gsl_vector_long_fprintf(FILE stream, @Const gsl_vector_long v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_long_fprintf(FILE stream, @Const gsl_vector_long v,
                              String format);

public static native int gsl_vector_long_memcpy(gsl_vector_long dest, @Const gsl_vector_long src);

public static native int gsl_vector_long_reverse(gsl_vector_long v);

public static native int gsl_vector_long_swap(gsl_vector_long v, gsl_vector_long w);
public static native int gsl_vector_long_swap_elements(gsl_vector_long v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native long gsl_vector_long_max(@Const gsl_vector_long v);
public static native long gsl_vector_long_min(@Const gsl_vector_long v);
public static native void gsl_vector_long_minmax(@Const gsl_vector_long v, CLongPointer min_out, CLongPointer max_out);

public static native @Cast("size_t") long gsl_vector_long_max_index(@Const gsl_vector_long v);
public static native @Cast("size_t") long gsl_vector_long_min_index(@Const gsl_vector_long v);
public static native void gsl_vector_long_minmax_index(@Const gsl_vector_long v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_long_add(gsl_vector_long a, @Const gsl_vector_long b);
public static native int gsl_vector_long_sub(gsl_vector_long a, @Const gsl_vector_long b);
public static native int gsl_vector_long_mul(gsl_vector_long a, @Const gsl_vector_long b);
public static native int gsl_vector_long_div(gsl_vector_long a, @Const gsl_vector_long b);
public static native int gsl_vector_long_scale(gsl_vector_long a, long x);
public static native int gsl_vector_long_add_constant(gsl_vector_long a, long x);
public static native int gsl_vector_long_axpby(long alpha, @Const gsl_vector_long x, long beta, gsl_vector_long y);
public static native long gsl_vector_long_sum(@Const gsl_vector_long a);

public static native int gsl_vector_long_equal(@Const gsl_vector_long u, 
                            @Const gsl_vector_long v);

public static native int gsl_vector_long_isnull(@Const gsl_vector_long v);
public static native int gsl_vector_long_ispos(@Const gsl_vector_long v);
public static native int gsl_vector_long_isneg(@Const gsl_vector_long v);
public static native int gsl_vector_long_isnonneg(@Const gsl_vector_long v);

/* */ public static native long gsl_vector_long_get(@Const gsl_vector_long v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_long_set(gsl_vector_long v, @Cast("const size_t") long i, long x);
/* */ public static native CLongPointer gsl_vector_long_ptr(gsl_vector_long v, @Cast("const size_t") long i);
/* */ public static native @Const CLongPointer gsl_vector_long_const_ptr(@Const gsl_vector_long v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_LONG_H__ */




// Parsed from gsl/gsl_vector_uint.h

/* vector/gsl_vector_uint.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_UINT_H__
// #define __GSL_VECTOR_UINT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_uint.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_uint.java


// Targeting ../_gsl_vector_uint_view.java


// Targeting ../_gsl_vector_uint_const_view.java




/* Allocation */

public static native gsl_vector_uint gsl_vector_uint_alloc(@Cast("const size_t") long n);
public static native gsl_vector_uint gsl_vector_uint_calloc(@Cast("const size_t") long n);

public static native gsl_vector_uint gsl_vector_uint_alloc_from_block(gsl_block_uint b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_uint gsl_vector_uint_alloc_from_vector(gsl_vector_uint v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_uint_free(gsl_vector_uint v);

/* Views */

public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array(@Cast("unsigned int*") IntPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array(@Cast("unsigned int*") IntBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array(@Cast("unsigned int*") int[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array_with_stride(@Cast("unsigned int*") IntPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array_with_stride(@Cast("unsigned int*") IntBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_view_array_with_stride(@Cast("unsigned int*") int[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array(@Cast("const unsigned int*") IntPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array(@Cast("const unsigned int*") IntBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array(@Cast("const unsigned int*") int[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array_with_stride(@Cast("const unsigned int*") IntPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array_with_stride(@Cast("const unsigned int*") IntBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_view_array_with_stride(@Cast("const unsigned int*") int[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_subvector(gsl_vector_uint v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_view gsl_vector_uint_subvector_with_stride(gsl_vector_uint v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_subvector(@Const gsl_vector_uint v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uint_const_view gsl_vector_uint_const_subvector_with_stride(@Const gsl_vector_uint v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_uint_set_zero(gsl_vector_uint v);
public static native void gsl_vector_uint_set_all(gsl_vector_uint v, @Cast("unsigned int") int x);
public static native int gsl_vector_uint_set_basis(gsl_vector_uint v, @Cast("size_t") long i);

public static native int gsl_vector_uint_fread(FILE stream, gsl_vector_uint v);
public static native int gsl_vector_uint_fwrite(FILE stream, @Const gsl_vector_uint v);
public static native int gsl_vector_uint_fscanf(FILE stream, gsl_vector_uint v);
public static native int gsl_vector_uint_fprintf(FILE stream, @Const gsl_vector_uint v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_uint_fprintf(FILE stream, @Const gsl_vector_uint v,
                              String format);

public static native int gsl_vector_uint_memcpy(gsl_vector_uint dest, @Const gsl_vector_uint src);

public static native int gsl_vector_uint_reverse(gsl_vector_uint v);

public static native int gsl_vector_uint_swap(gsl_vector_uint v, gsl_vector_uint w);
public static native int gsl_vector_uint_swap_elements(gsl_vector_uint v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native @Cast("unsigned int") int gsl_vector_uint_max(@Const gsl_vector_uint v);
public static native @Cast("unsigned int") int gsl_vector_uint_min(@Const gsl_vector_uint v);
public static native void gsl_vector_uint_minmax(@Const gsl_vector_uint v, @Cast("unsigned int*") IntPointer min_out, @Cast("unsigned int*") IntPointer max_out);
public static native void gsl_vector_uint_minmax(@Const gsl_vector_uint v, @Cast("unsigned int*") IntBuffer min_out, @Cast("unsigned int*") IntBuffer max_out);
public static native void gsl_vector_uint_minmax(@Const gsl_vector_uint v, @Cast("unsigned int*") int[] min_out, @Cast("unsigned int*") int[] max_out);

public static native @Cast("size_t") long gsl_vector_uint_max_index(@Const gsl_vector_uint v);
public static native @Cast("size_t") long gsl_vector_uint_min_index(@Const gsl_vector_uint v);
public static native void gsl_vector_uint_minmax_index(@Const gsl_vector_uint v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_uint_add(gsl_vector_uint a, @Const gsl_vector_uint b);
public static native int gsl_vector_uint_sub(gsl_vector_uint a, @Const gsl_vector_uint b);
public static native int gsl_vector_uint_mul(gsl_vector_uint a, @Const gsl_vector_uint b);
public static native int gsl_vector_uint_div(gsl_vector_uint a, @Const gsl_vector_uint b);
public static native int gsl_vector_uint_scale(gsl_vector_uint a, @Cast("const unsigned int") int x);
public static native int gsl_vector_uint_add_constant(gsl_vector_uint a, @Cast("const unsigned int") int x);
public static native int gsl_vector_uint_axpby(@Cast("const unsigned int") int alpha, @Const gsl_vector_uint x, @Cast("const unsigned int") int beta, gsl_vector_uint y);
public static native @Cast("unsigned int") int gsl_vector_uint_sum(@Const gsl_vector_uint a);

public static native int gsl_vector_uint_equal(@Const gsl_vector_uint u, 
                            @Const gsl_vector_uint v);

public static native int gsl_vector_uint_isnull(@Const gsl_vector_uint v);
public static native int gsl_vector_uint_ispos(@Const gsl_vector_uint v);
public static native int gsl_vector_uint_isneg(@Const gsl_vector_uint v);
public static native int gsl_vector_uint_isnonneg(@Const gsl_vector_uint v);

/* */ public static native @Cast("unsigned int") int gsl_vector_uint_get(@Const gsl_vector_uint v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_uint_set(gsl_vector_uint v, @Cast("const size_t") long i, @Cast("unsigned int") int x);
/* */ public static native @Cast("unsigned int*") IntPointer gsl_vector_uint_ptr(gsl_vector_uint v, @Cast("const size_t") long i);
/* */ public static native @Cast("const unsigned int*") IntPointer gsl_vector_uint_const_ptr(@Const gsl_vector_uint v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_UINT_H__ */




// Parsed from gsl/gsl_vector_int.h

/* vector/gsl_vector_int.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_INT_H__
// #define __GSL_VECTOR_INT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_int.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_int.java


// Targeting ../_gsl_vector_int_view.java


// Targeting ../_gsl_vector_int_const_view.java




/* Allocation */

public static native gsl_vector_int gsl_vector_int_alloc(@Cast("const size_t") long n);
public static native gsl_vector_int gsl_vector_int_calloc(@Cast("const size_t") long n);

public static native gsl_vector_int gsl_vector_int_alloc_from_block(gsl_block_int b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_int gsl_vector_int_alloc_from_vector(gsl_vector_int v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_int_free(gsl_vector_int v);

/* Views */

public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array(IntPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array(IntBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array(int[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array_with_stride(IntPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array_with_stride(IntBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_view gsl_vector_int_view_array_with_stride(int[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array(@Const IntPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array(@Const IntBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array(@Const int[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array_with_stride(@Const IntPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array_with_stride(@Const IntBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_view_array_with_stride(@Const int[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_view gsl_vector_int_subvector(gsl_vector_int v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_view gsl_vector_int_subvector_with_stride(gsl_vector_int v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_subvector(@Const gsl_vector_int v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_int_const_view gsl_vector_int_const_subvector_with_stride(@Const gsl_vector_int v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_int_set_zero(gsl_vector_int v);
public static native void gsl_vector_int_set_all(gsl_vector_int v, int x);
public static native int gsl_vector_int_set_basis(gsl_vector_int v, @Cast("size_t") long i);

public static native int gsl_vector_int_fread(FILE stream, gsl_vector_int v);
public static native int gsl_vector_int_fwrite(FILE stream, @Const gsl_vector_int v);
public static native int gsl_vector_int_fscanf(FILE stream, gsl_vector_int v);
public static native int gsl_vector_int_fprintf(FILE stream, @Const gsl_vector_int v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_int_fprintf(FILE stream, @Const gsl_vector_int v,
                              String format);

public static native int gsl_vector_int_memcpy(gsl_vector_int dest, @Const gsl_vector_int src);

public static native int gsl_vector_int_reverse(gsl_vector_int v);

public static native int gsl_vector_int_swap(gsl_vector_int v, gsl_vector_int w);
public static native int gsl_vector_int_swap_elements(gsl_vector_int v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_vector_int_max(@Const gsl_vector_int v);
public static native int gsl_vector_int_min(@Const gsl_vector_int v);
public static native void gsl_vector_int_minmax(@Const gsl_vector_int v, IntPointer min_out, IntPointer max_out);
public static native void gsl_vector_int_minmax(@Const gsl_vector_int v, IntBuffer min_out, IntBuffer max_out);
public static native void gsl_vector_int_minmax(@Const gsl_vector_int v, int[] min_out, int[] max_out);

public static native @Cast("size_t") long gsl_vector_int_max_index(@Const gsl_vector_int v);
public static native @Cast("size_t") long gsl_vector_int_min_index(@Const gsl_vector_int v);
public static native void gsl_vector_int_minmax_index(@Const gsl_vector_int v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_int_add(gsl_vector_int a, @Const gsl_vector_int b);
public static native int gsl_vector_int_sub(gsl_vector_int a, @Const gsl_vector_int b);
public static native int gsl_vector_int_mul(gsl_vector_int a, @Const gsl_vector_int b);
public static native int gsl_vector_int_div(gsl_vector_int a, @Const gsl_vector_int b);
public static native int gsl_vector_int_scale(gsl_vector_int a, int x);
public static native int gsl_vector_int_add_constant(gsl_vector_int a, int x);
public static native int gsl_vector_int_axpby(int alpha, @Const gsl_vector_int x, int beta, gsl_vector_int y);
public static native int gsl_vector_int_sum(@Const gsl_vector_int a);

public static native int gsl_vector_int_equal(@Const gsl_vector_int u, 
                            @Const gsl_vector_int v);

public static native int gsl_vector_int_isnull(@Const gsl_vector_int v);
public static native int gsl_vector_int_ispos(@Const gsl_vector_int v);
public static native int gsl_vector_int_isneg(@Const gsl_vector_int v);
public static native int gsl_vector_int_isnonneg(@Const gsl_vector_int v);

/* */ public static native int gsl_vector_int_get(@Const gsl_vector_int v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_int_set(gsl_vector_int v, @Cast("const size_t") long i, int x);
/* */ public static native IntPointer gsl_vector_int_ptr(gsl_vector_int v, @Cast("const size_t") long i);
/* */ public static native @Const IntPointer gsl_vector_int_const_ptr(@Const gsl_vector_int v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_INT_H__ */




// Parsed from gsl/gsl_vector_ushort.h

/* vector/gsl_vector_ushort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_USHORT_H__
// #define __GSL_VECTOR_USHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_ushort.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_ushort.java


// Targeting ../_gsl_vector_ushort_view.java


// Targeting ../_gsl_vector_ushort_const_view.java




/* Allocation */

public static native gsl_vector_ushort gsl_vector_ushort_alloc(@Cast("const size_t") long n);
public static native gsl_vector_ushort gsl_vector_ushort_calloc(@Cast("const size_t") long n);

public static native gsl_vector_ushort gsl_vector_ushort_alloc_from_block(gsl_block_ushort b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_ushort gsl_vector_ushort_alloc_from_vector(gsl_vector_ushort v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_ushort_free(gsl_vector_ushort v);

/* Views */

public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array(@Cast("unsigned short*") ShortPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array(@Cast("unsigned short*") ShortBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array(@Cast("unsigned short*") short[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array_with_stride(@Cast("unsigned short*") ShortPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array_with_stride(@Cast("unsigned short*") ShortBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_view_array_with_stride(@Cast("unsigned short*") short[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array(@Cast("const unsigned short*") ShortPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array(@Cast("const unsigned short*") ShortBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array(@Cast("const unsigned short*") short[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array_with_stride(@Cast("const unsigned short*") ShortPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array_with_stride(@Cast("const unsigned short*") ShortBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_view_array_with_stride(@Cast("const unsigned short*") short[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_subvector(gsl_vector_ushort v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_view gsl_vector_ushort_subvector_with_stride(gsl_vector_ushort v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_subvector(@Const gsl_vector_ushort v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_ushort_const_view gsl_vector_ushort_const_subvector_with_stride(@Const gsl_vector_ushort v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_ushort_set_zero(gsl_vector_ushort v);
public static native void gsl_vector_ushort_set_all(gsl_vector_ushort v, @Cast("unsigned short") short x);
public static native int gsl_vector_ushort_set_basis(gsl_vector_ushort v, @Cast("size_t") long i);

public static native int gsl_vector_ushort_fread(FILE stream, gsl_vector_ushort v);
public static native int gsl_vector_ushort_fwrite(FILE stream, @Const gsl_vector_ushort v);
public static native int gsl_vector_ushort_fscanf(FILE stream, gsl_vector_ushort v);
public static native int gsl_vector_ushort_fprintf(FILE stream, @Const gsl_vector_ushort v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_ushort_fprintf(FILE stream, @Const gsl_vector_ushort v,
                              String format);

public static native int gsl_vector_ushort_memcpy(gsl_vector_ushort dest, @Const gsl_vector_ushort src);

public static native int gsl_vector_ushort_reverse(gsl_vector_ushort v);

public static native int gsl_vector_ushort_swap(gsl_vector_ushort v, gsl_vector_ushort w);
public static native int gsl_vector_ushort_swap_elements(gsl_vector_ushort v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native @Cast("unsigned short") short gsl_vector_ushort_max(@Const gsl_vector_ushort v);
public static native @Cast("unsigned short") short gsl_vector_ushort_min(@Const gsl_vector_ushort v);
public static native void gsl_vector_ushort_minmax(@Const gsl_vector_ushort v, @Cast("unsigned short*") ShortPointer min_out, @Cast("unsigned short*") ShortPointer max_out);
public static native void gsl_vector_ushort_minmax(@Const gsl_vector_ushort v, @Cast("unsigned short*") ShortBuffer min_out, @Cast("unsigned short*") ShortBuffer max_out);
public static native void gsl_vector_ushort_minmax(@Const gsl_vector_ushort v, @Cast("unsigned short*") short[] min_out, @Cast("unsigned short*") short[] max_out);

public static native @Cast("size_t") long gsl_vector_ushort_max_index(@Const gsl_vector_ushort v);
public static native @Cast("size_t") long gsl_vector_ushort_min_index(@Const gsl_vector_ushort v);
public static native void gsl_vector_ushort_minmax_index(@Const gsl_vector_ushort v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_ushort_add(gsl_vector_ushort a, @Const gsl_vector_ushort b);
public static native int gsl_vector_ushort_sub(gsl_vector_ushort a, @Const gsl_vector_ushort b);
public static native int gsl_vector_ushort_mul(gsl_vector_ushort a, @Const gsl_vector_ushort b);
public static native int gsl_vector_ushort_div(gsl_vector_ushort a, @Const gsl_vector_ushort b);
public static native int gsl_vector_ushort_scale(gsl_vector_ushort a, @Cast("const unsigned short") short x);
public static native int gsl_vector_ushort_add_constant(gsl_vector_ushort a, @Cast("const unsigned short") short x);
public static native int gsl_vector_ushort_axpby(@Cast("const unsigned short") short alpha, @Const gsl_vector_ushort x, @Cast("const unsigned short") short beta, gsl_vector_ushort y);
public static native @Cast("unsigned short") short gsl_vector_ushort_sum(@Const gsl_vector_ushort a);

public static native int gsl_vector_ushort_equal(@Const gsl_vector_ushort u, 
                            @Const gsl_vector_ushort v);

public static native int gsl_vector_ushort_isnull(@Const gsl_vector_ushort v);
public static native int gsl_vector_ushort_ispos(@Const gsl_vector_ushort v);
public static native int gsl_vector_ushort_isneg(@Const gsl_vector_ushort v);
public static native int gsl_vector_ushort_isnonneg(@Const gsl_vector_ushort v);

/* */ public static native @Cast("unsigned short") short gsl_vector_ushort_get(@Const gsl_vector_ushort v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_ushort_set(gsl_vector_ushort v, @Cast("const size_t") long i, @Cast("unsigned short") short x);
/* */ public static native @Cast("unsigned short*") ShortPointer gsl_vector_ushort_ptr(gsl_vector_ushort v, @Cast("const size_t") long i);
/* */ public static native @Cast("const unsigned short*") ShortPointer gsl_vector_ushort_const_ptr(@Const gsl_vector_ushort v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_USHORT_H__ */




// Parsed from gsl/gsl_vector_short.h

/* vector/gsl_vector_short.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_SHORT_H__
// #define __GSL_VECTOR_SHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_short.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_short.java


// Targeting ../_gsl_vector_short_view.java


// Targeting ../_gsl_vector_short_const_view.java




/* Allocation */

public static native gsl_vector_short gsl_vector_short_alloc(@Cast("const size_t") long n);
public static native gsl_vector_short gsl_vector_short_calloc(@Cast("const size_t") long n);

public static native gsl_vector_short gsl_vector_short_alloc_from_block(gsl_block_short b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_short gsl_vector_short_alloc_from_vector(gsl_vector_short v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_short_free(gsl_vector_short v);

/* Views */

public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array(ShortPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array(ShortBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array(short[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array_with_stride(ShortPointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array_with_stride(ShortBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_view gsl_vector_short_view_array_with_stride(short[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array(@Const ShortPointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array(@Const ShortBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array(@Const short[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array_with_stride(@Const ShortPointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array_with_stride(@Const ShortBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_view_array_with_stride(@Const short[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_view gsl_vector_short_subvector(gsl_vector_short v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_view gsl_vector_short_subvector_with_stride(gsl_vector_short v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_subvector(@Const gsl_vector_short v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_short_const_view gsl_vector_short_const_subvector_with_stride(@Const gsl_vector_short v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_short_set_zero(gsl_vector_short v);
public static native void gsl_vector_short_set_all(gsl_vector_short v, short x);
public static native int gsl_vector_short_set_basis(gsl_vector_short v, @Cast("size_t") long i);

public static native int gsl_vector_short_fread(FILE stream, gsl_vector_short v);
public static native int gsl_vector_short_fwrite(FILE stream, @Const gsl_vector_short v);
public static native int gsl_vector_short_fscanf(FILE stream, gsl_vector_short v);
public static native int gsl_vector_short_fprintf(FILE stream, @Const gsl_vector_short v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_short_fprintf(FILE stream, @Const gsl_vector_short v,
                              String format);

public static native int gsl_vector_short_memcpy(gsl_vector_short dest, @Const gsl_vector_short src);

public static native int gsl_vector_short_reverse(gsl_vector_short v);

public static native int gsl_vector_short_swap(gsl_vector_short v, gsl_vector_short w);
public static native int gsl_vector_short_swap_elements(gsl_vector_short v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native short gsl_vector_short_max(@Const gsl_vector_short v);
public static native short gsl_vector_short_min(@Const gsl_vector_short v);
public static native void gsl_vector_short_minmax(@Const gsl_vector_short v, ShortPointer min_out, ShortPointer max_out);
public static native void gsl_vector_short_minmax(@Const gsl_vector_short v, ShortBuffer min_out, ShortBuffer max_out);
public static native void gsl_vector_short_minmax(@Const gsl_vector_short v, short[] min_out, short[] max_out);

public static native @Cast("size_t") long gsl_vector_short_max_index(@Const gsl_vector_short v);
public static native @Cast("size_t") long gsl_vector_short_min_index(@Const gsl_vector_short v);
public static native void gsl_vector_short_minmax_index(@Const gsl_vector_short v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_short_add(gsl_vector_short a, @Const gsl_vector_short b);
public static native int gsl_vector_short_sub(gsl_vector_short a, @Const gsl_vector_short b);
public static native int gsl_vector_short_mul(gsl_vector_short a, @Const gsl_vector_short b);
public static native int gsl_vector_short_div(gsl_vector_short a, @Const gsl_vector_short b);
public static native int gsl_vector_short_scale(gsl_vector_short a, short x);
public static native int gsl_vector_short_add_constant(gsl_vector_short a, short x);
public static native int gsl_vector_short_axpby(short alpha, @Const gsl_vector_short x, short beta, gsl_vector_short y);
public static native short gsl_vector_short_sum(@Const gsl_vector_short a);

public static native int gsl_vector_short_equal(@Const gsl_vector_short u, 
                            @Const gsl_vector_short v);

public static native int gsl_vector_short_isnull(@Const gsl_vector_short v);
public static native int gsl_vector_short_ispos(@Const gsl_vector_short v);
public static native int gsl_vector_short_isneg(@Const gsl_vector_short v);
public static native int gsl_vector_short_isnonneg(@Const gsl_vector_short v);

/* */ public static native short gsl_vector_short_get(@Const gsl_vector_short v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_short_set(gsl_vector_short v, @Cast("const size_t") long i, short x);
/* */ public static native ShortPointer gsl_vector_short_ptr(gsl_vector_short v, @Cast("const size_t") long i);
/* */ public static native @Const ShortPointer gsl_vector_short_const_ptr(@Const gsl_vector_short v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_SHORT_H__ */




// Parsed from gsl/gsl_vector_uchar.h

/* vector/gsl_vector_uchar.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_UCHAR_H__
// #define __GSL_VECTOR_UCHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_uchar.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_uchar.java


// Targeting ../_gsl_vector_uchar_view.java


// Targeting ../_gsl_vector_uchar_const_view.java




/* Allocation */

public static native gsl_vector_uchar gsl_vector_uchar_alloc(@Cast("const size_t") long n);
public static native gsl_vector_uchar gsl_vector_uchar_calloc(@Cast("const size_t") long n);

public static native gsl_vector_uchar gsl_vector_uchar_alloc_from_block(gsl_block_uchar b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_uchar gsl_vector_uchar_alloc_from_vector(gsl_vector_uchar v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_uchar_free(gsl_vector_uchar v);

/* Views */

public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array(@Cast("unsigned char*") BytePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array(@Cast("unsigned char*") ByteBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array(@Cast("unsigned char*") byte[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array_with_stride(@Cast("unsigned char*") BytePointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array_with_stride(@Cast("unsigned char*") ByteBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_view_array_with_stride(@Cast("unsigned char*") byte[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array(@Cast("const unsigned char*") BytePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array(@Cast("const unsigned char*") ByteBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array(@Cast("const unsigned char*") byte[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array_with_stride(@Cast("const unsigned char*") BytePointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array_with_stride(@Cast("const unsigned char*") ByteBuffer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_view_array_with_stride(@Cast("const unsigned char*") byte[] base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_subvector(gsl_vector_uchar v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_view gsl_vector_uchar_subvector_with_stride(gsl_vector_uchar v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_subvector(@Const gsl_vector_uchar v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_uchar_const_view gsl_vector_uchar_const_subvector_with_stride(@Const gsl_vector_uchar v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_uchar_set_zero(gsl_vector_uchar v);
public static native void gsl_vector_uchar_set_all(gsl_vector_uchar v, @Cast("unsigned char") byte x);
public static native int gsl_vector_uchar_set_basis(gsl_vector_uchar v, @Cast("size_t") long i);

public static native int gsl_vector_uchar_fread(FILE stream, gsl_vector_uchar v);
public static native int gsl_vector_uchar_fwrite(FILE stream, @Const gsl_vector_uchar v);
public static native int gsl_vector_uchar_fscanf(FILE stream, gsl_vector_uchar v);
public static native int gsl_vector_uchar_fprintf(FILE stream, @Const gsl_vector_uchar v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_uchar_fprintf(FILE stream, @Const gsl_vector_uchar v,
                              String format);

public static native int gsl_vector_uchar_memcpy(gsl_vector_uchar dest, @Const gsl_vector_uchar src);

public static native int gsl_vector_uchar_reverse(gsl_vector_uchar v);

public static native int gsl_vector_uchar_swap(gsl_vector_uchar v, gsl_vector_uchar w);
public static native int gsl_vector_uchar_swap_elements(gsl_vector_uchar v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native @Cast("unsigned char") byte gsl_vector_uchar_max(@Const gsl_vector_uchar v);
public static native @Cast("unsigned char") byte gsl_vector_uchar_min(@Const gsl_vector_uchar v);
public static native void gsl_vector_uchar_minmax(@Const gsl_vector_uchar v, @Cast("unsigned char*") BytePointer min_out, @Cast("unsigned char*") BytePointer max_out);
public static native void gsl_vector_uchar_minmax(@Const gsl_vector_uchar v, @Cast("unsigned char*") ByteBuffer min_out, @Cast("unsigned char*") ByteBuffer max_out);
public static native void gsl_vector_uchar_minmax(@Const gsl_vector_uchar v, @Cast("unsigned char*") byte[] min_out, @Cast("unsigned char*") byte[] max_out);

public static native @Cast("size_t") long gsl_vector_uchar_max_index(@Const gsl_vector_uchar v);
public static native @Cast("size_t") long gsl_vector_uchar_min_index(@Const gsl_vector_uchar v);
public static native void gsl_vector_uchar_minmax_index(@Const gsl_vector_uchar v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_uchar_add(gsl_vector_uchar a, @Const gsl_vector_uchar b);
public static native int gsl_vector_uchar_sub(gsl_vector_uchar a, @Const gsl_vector_uchar b);
public static native int gsl_vector_uchar_mul(gsl_vector_uchar a, @Const gsl_vector_uchar b);
public static native int gsl_vector_uchar_div(gsl_vector_uchar a, @Const gsl_vector_uchar b);
public static native int gsl_vector_uchar_scale(gsl_vector_uchar a, @Cast("const unsigned char") byte x);
public static native int gsl_vector_uchar_add_constant(gsl_vector_uchar a, @Cast("const unsigned char") byte x);
public static native int gsl_vector_uchar_axpby(@Cast("const unsigned char") byte alpha, @Const gsl_vector_uchar x, @Cast("const unsigned char") byte beta, gsl_vector_uchar y);
public static native @Cast("unsigned char") byte gsl_vector_uchar_sum(@Const gsl_vector_uchar a);

public static native int gsl_vector_uchar_equal(@Const gsl_vector_uchar u, 
                            @Const gsl_vector_uchar v);

public static native int gsl_vector_uchar_isnull(@Const gsl_vector_uchar v);
public static native int gsl_vector_uchar_ispos(@Const gsl_vector_uchar v);
public static native int gsl_vector_uchar_isneg(@Const gsl_vector_uchar v);
public static native int gsl_vector_uchar_isnonneg(@Const gsl_vector_uchar v);

/* */ public static native @Cast("unsigned char") byte gsl_vector_uchar_get(@Const gsl_vector_uchar v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_uchar_set(gsl_vector_uchar v, @Cast("const size_t") long i, @Cast("unsigned char") byte x);
/* */ public static native @Cast("unsigned char*") BytePointer gsl_vector_uchar_ptr(gsl_vector_uchar v, @Cast("const size_t") long i);
/* */ public static native @Cast("const unsigned char*") BytePointer gsl_vector_uchar_const_ptr(@Const gsl_vector_uchar v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_UCHAR_H__ */




// Parsed from gsl/gsl_vector_char.h

/* vector/gsl_vector_char.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_VECTOR_CHAR_H__
// #define __GSL_VECTOR_CHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_block_char.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_vector_char.java


// Targeting ../_gsl_vector_char_view.java


// Targeting ../_gsl_vector_char_const_view.java




/* Allocation */

public static native gsl_vector_char gsl_vector_char_alloc(@Cast("const size_t") long n);
public static native gsl_vector_char gsl_vector_char_calloc(@Cast("const size_t") long n);

public static native gsl_vector_char gsl_vector_char_alloc_from_block(gsl_block_char b,
                                                     @Cast("const size_t") long offset, 
                                                     @Cast("const size_t") long n, 
                                                     @Cast("const size_t") long stride);

public static native gsl_vector_char gsl_vector_char_alloc_from_vector(gsl_vector_char v,
                                                      @Cast("const size_t") long offset, 
                                                      @Cast("const size_t") long n, 
                                                      @Cast("const size_t") long stride);

public static native void gsl_vector_char_free(gsl_vector_char v);

/* Views */

public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array(@Cast("char*") BytePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array(@Cast("char*") ByteBuffer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array(@Cast("char*") byte[] v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array_with_stride(@Cast("char*") BytePointer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array_with_stride(@Cast("char*") ByteBuffer base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_view gsl_vector_char_view_array_with_stride(@Cast("char*") byte[] base,
                                         @Cast("size_t") long stride,
                                         @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_view_array(@Cast("const char*") BytePointer v, @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_view_array(String v, @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_view_array_with_stride(@Cast("const char*") BytePointer base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);
public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_view_array_with_stride(String base,
                                               @Cast("size_t") long stride,
                                               @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_view gsl_vector_char_subvector(gsl_vector_char v, 
                            @Cast("size_t") long i, 
                            @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_view gsl_vector_char_subvector_with_stride(gsl_vector_char v, 
                                        @Cast("size_t") long i,
                                        @Cast("size_t") long stride,
                                        @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_subvector(@Const gsl_vector_char v, 
                                  @Cast("size_t") long i, 
                                  @Cast("size_t") long n);

public static native @ByVal _gsl_vector_char_const_view gsl_vector_char_const_subvector_with_stride(@Const gsl_vector_char v, 
                                              @Cast("size_t") long i, 
                                              @Cast("size_t") long stride,
                                              @Cast("size_t") long n);

/* Operations */

public static native void gsl_vector_char_set_zero(gsl_vector_char v);
public static native void gsl_vector_char_set_all(gsl_vector_char v, @Cast("char") byte x);
public static native int gsl_vector_char_set_basis(gsl_vector_char v, @Cast("size_t") long i);

public static native int gsl_vector_char_fread(FILE stream, gsl_vector_char v);
public static native int gsl_vector_char_fwrite(FILE stream, @Const gsl_vector_char v);
public static native int gsl_vector_char_fscanf(FILE stream, gsl_vector_char v);
public static native int gsl_vector_char_fprintf(FILE stream, @Const gsl_vector_char v,
                              @Cast("const char*") BytePointer format);
public static native int gsl_vector_char_fprintf(FILE stream, @Const gsl_vector_char v,
                              String format);

public static native int gsl_vector_char_memcpy(gsl_vector_char dest, @Const gsl_vector_char src);

public static native int gsl_vector_char_reverse(gsl_vector_char v);

public static native int gsl_vector_char_swap(gsl_vector_char v, gsl_vector_char w);
public static native int gsl_vector_char_swap_elements(gsl_vector_char v, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native @Cast("char") byte gsl_vector_char_max(@Const gsl_vector_char v);
public static native @Cast("char") byte gsl_vector_char_min(@Const gsl_vector_char v);
public static native void gsl_vector_char_minmax(@Const gsl_vector_char v, @Cast("char*") BytePointer min_out, @Cast("char*") BytePointer max_out);
public static native void gsl_vector_char_minmax(@Const gsl_vector_char v, @Cast("char*") ByteBuffer min_out, @Cast("char*") ByteBuffer max_out);
public static native void gsl_vector_char_minmax(@Const gsl_vector_char v, @Cast("char*") byte[] min_out, @Cast("char*") byte[] max_out);

public static native @Cast("size_t") long gsl_vector_char_max_index(@Const gsl_vector_char v);
public static native @Cast("size_t") long gsl_vector_char_min_index(@Const gsl_vector_char v);
public static native void gsl_vector_char_minmax_index(@Const gsl_vector_char v, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer imax);

public static native int gsl_vector_char_add(gsl_vector_char a, @Const gsl_vector_char b);
public static native int gsl_vector_char_sub(gsl_vector_char a, @Const gsl_vector_char b);
public static native int gsl_vector_char_mul(gsl_vector_char a, @Const gsl_vector_char b);
public static native int gsl_vector_char_div(gsl_vector_char a, @Const gsl_vector_char b);
public static native int gsl_vector_char_scale(gsl_vector_char a, @Cast("const char") byte x);
public static native int gsl_vector_char_add_constant(gsl_vector_char a, @Cast("const char") byte x);
public static native int gsl_vector_char_axpby(@Cast("const char") byte alpha, @Const gsl_vector_char x, @Cast("const char") byte beta, gsl_vector_char y);
public static native @Cast("char") byte gsl_vector_char_sum(@Const gsl_vector_char a);

public static native int gsl_vector_char_equal(@Const gsl_vector_char u, 
                            @Const gsl_vector_char v);

public static native int gsl_vector_char_isnull(@Const gsl_vector_char v);
public static native int gsl_vector_char_ispos(@Const gsl_vector_char v);
public static native int gsl_vector_char_isneg(@Const gsl_vector_char v);
public static native int gsl_vector_char_isnonneg(@Const gsl_vector_char v);

/* */ public static native @Cast("char") byte gsl_vector_char_get(@Const gsl_vector_char v, @Cast("const size_t") long i);
/* */ public static native void gsl_vector_char_set(gsl_vector_char v, @Cast("const size_t") long i, @Cast("char") byte x);
/* */ public static native @Cast("char*") BytePointer gsl_vector_char_ptr(gsl_vector_char v, @Cast("const size_t") long i);
/* */ public static native @Cast("const char*") BytePointer gsl_vector_char_const_ptr(@Const gsl_vector_char v, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_VECTOR_CHAR_H__ */




// Parsed from gsl/gsl_matrix.h

// #ifndef __GSL_MATRIX_H__
// #define __GSL_MATRIX_H__

// #include <gsl/gsl_matrix_complex_long_double.h>
// #include <gsl/gsl_matrix_complex_double.h>
// #include <gsl/gsl_matrix_complex_float.h>

// #include <gsl/gsl_matrix_long_double.h>
// #include <gsl/gsl_matrix_double.h>
// #include <gsl/gsl_matrix_float.h>

// #include <gsl/gsl_matrix_ulong.h>
// #include <gsl/gsl_matrix_long.h>

// #include <gsl/gsl_matrix_uint.h>
// #include <gsl/gsl_matrix_int.h>

// #include <gsl/gsl_matrix_ushort.h>
// #include <gsl/gsl_matrix_short.h>

// #include <gsl/gsl_matrix_uchar.h>
// #include <gsl/gsl_matrix_char.h>


// #endif /* __GSL_MATRIX_H__ */


// Parsed from gsl/gsl_blas_types.h

/* blas/gsl_blas_types.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * Author:  G. Jungman
 */
/* Based on draft BLAST C interface specification  [Jul 7 1998]
 */
// #ifndef __GSL_BLAS_TYPES_H__
// #define __GSL_BLAS_TYPES_H__

// #include <gsl/gsl_cblas.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/* typedef  gsl_complex  COMPLEX; */


// #endif /* __GSL_BLAS_TYPES_H__ */


// Parsed from gsl/gsl_matrix_complex_double.h

/* matrix/gsl_matrix_complex_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_COMPLEX_DOUBLE_H__
// #define __GSL_MATRIX_COMPLEX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_complex_double.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_complex.java


// Targeting ../_gsl_matrix_complex_view.java


// Targeting ../_gsl_matrix_complex_const_view.java




/* Allocation */

public static native gsl_matrix_complex gsl_matrix_complex_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_complex gsl_matrix_complex_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_complex gsl_matrix_complex_alloc_from_block(gsl_block_complex b, 
                                           @Cast("const size_t") long offset, 
                                           @Cast("const size_t") long n1, @Cast("const size_t") long n2, @Cast("const size_t") long d2);

public static native gsl_matrix_complex gsl_matrix_complex_alloc_from_matrix(gsl_matrix_complex b,
                                            @Cast("const size_t") long k1, @Cast("const size_t") long k2,
                                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_vector_complex gsl_vector_complex_alloc_row_from_matrix(gsl_matrix_complex m,
                                                @Cast("const size_t") long i);

public static native gsl_vector_complex gsl_vector_complex_alloc_col_from_matrix(gsl_matrix_complex m,
                                                @Cast("const size_t") long j);

public static native void gsl_matrix_complex_free(gsl_matrix_complex m);

/* Views */

public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_submatrix(gsl_matrix_complex m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_row(gsl_matrix_complex m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_column(gsl_matrix_complex m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_diagonal(gsl_matrix_complex m);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_subdiagonal(gsl_matrix_complex m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_superdiagonal(gsl_matrix_complex m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_subrow(gsl_matrix_complex m,
                                 @Cast("const size_t") long i, @Cast("const size_t") long offset,
                                 @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_complex_view gsl_matrix_complex_subcolumn(gsl_matrix_complex m,
                                    @Cast("const size_t") long j, @Cast("const size_t") long offset,
                                    @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array(DoublePointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array(DoubleBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array(double[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array_with_tda(DoublePointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array_with_tda(DoubleBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_array_with_tda(double[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_vector(gsl_vector_complex v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_view gsl_matrix_complex_view_vector_with_tda(gsl_vector_complex v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_submatrix(@Const gsl_matrix_complex m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_row(@Const gsl_matrix_complex m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_column(@Const gsl_matrix_complex m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_diagonal(@Const gsl_matrix_complex m);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_subdiagonal(@Const gsl_matrix_complex m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_superdiagonal(@Const gsl_matrix_complex m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_subrow(@Const gsl_matrix_complex m,
                                       @Cast("const size_t") long i, @Cast("const size_t") long offset,
                                       @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_complex_const_view gsl_matrix_complex_const_subcolumn(@Const gsl_matrix_complex m,
                                          @Cast("const size_t") long j, @Cast("const size_t") long offset,
                                          @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array(@Const DoublePointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array(@Const DoubleBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array(@Const double[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array_with_tda(@Const DoublePointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array_with_tda(@Const DoubleBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_array_with_tda(@Const double[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_vector(@Const gsl_vector_complex v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_const_view gsl_matrix_complex_const_view_vector_with_tda(@Const gsl_vector_complex v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_complex_set_zero(gsl_matrix_complex m);
public static native void gsl_matrix_complex_set_identity(gsl_matrix_complex m);
public static native void gsl_matrix_complex_set_all(gsl_matrix_complex m, @ByVal gsl_complex x);

public static native int gsl_matrix_complex_fread(FILE stream, gsl_matrix_complex m);
public static native int gsl_matrix_complex_fwrite(FILE stream, @Const gsl_matrix_complex m);
public static native int gsl_matrix_complex_fscanf(FILE stream, gsl_matrix_complex m);
public static native int gsl_matrix_complex_fprintf(FILE stream, @Const gsl_matrix_complex m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_complex_fprintf(FILE stream, @Const gsl_matrix_complex m, String format);

public static native int gsl_matrix_complex_memcpy(gsl_matrix_complex dest, @Const gsl_matrix_complex src);
public static native int gsl_matrix_complex_swap(gsl_matrix_complex m1, gsl_matrix_complex m2);
public static native int gsl_matrix_complex_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_complex dest, @Const gsl_matrix_complex src);

public static native int gsl_matrix_complex_swap_rows(gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_swap_columns(gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_swap_rowcol(gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_matrix_complex_transpose(gsl_matrix_complex m);
public static native int gsl_matrix_complex_transpose_memcpy(gsl_matrix_complex dest, @Const gsl_matrix_complex src);
public static native int gsl_matrix_complex_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_complex dest, @Const gsl_matrix_complex src);

public static native int gsl_matrix_complex_conjtrans_memcpy(gsl_matrix_complex dest, @Const gsl_matrix_complex src);

public static native int gsl_matrix_complex_equal(@Const gsl_matrix_complex a, @Const gsl_matrix_complex b);

public static native int gsl_matrix_complex_isnull(@Const gsl_matrix_complex m);
public static native int gsl_matrix_complex_ispos(@Const gsl_matrix_complex m);
public static native int gsl_matrix_complex_isneg(@Const gsl_matrix_complex m);
public static native int gsl_matrix_complex_isnonneg(@Const gsl_matrix_complex m);

public static native int gsl_matrix_complex_add(gsl_matrix_complex a, @Const gsl_matrix_complex b);
public static native int gsl_matrix_complex_sub(gsl_matrix_complex a, @Const gsl_matrix_complex b);
public static native int gsl_matrix_complex_mul_elements(gsl_matrix_complex a, @Const gsl_matrix_complex b);
public static native int gsl_matrix_complex_div_elements(gsl_matrix_complex a, @Const gsl_matrix_complex b);
public static native int gsl_matrix_complex_scale(gsl_matrix_complex a, @Const @ByVal gsl_complex x);
public static native int gsl_matrix_complex_scale_rows(gsl_matrix_complex a, @Const gsl_vector_complex x);
public static native int gsl_matrix_complex_scale_columns(gsl_matrix_complex a, @Const gsl_vector_complex x);
public static native int gsl_matrix_complex_add_constant(gsl_matrix_complex a, @Const @ByVal gsl_complex x);
public static native int gsl_matrix_complex_add_diagonal(gsl_matrix_complex a, @Const @ByVal gsl_complex x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_complex_get_row(gsl_vector_complex v, @Const gsl_matrix_complex m, @Cast("const size_t") long i);
public static native int gsl_matrix_complex_get_col(gsl_vector_complex v, @Const gsl_matrix_complex m, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_set_row(gsl_matrix_complex m, @Cast("const size_t") long i, @Const gsl_vector_complex v);
public static native int gsl_matrix_complex_set_col(gsl_matrix_complex m, @Cast("const size_t") long j, @Const gsl_vector_complex v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @ByVal gsl_complex gsl_matrix_complex_get(@Const gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_complex_set(gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Const @ByVal gsl_complex x);

/* */ public static native gsl_complex gsl_matrix_complex_ptr(gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const gsl_complex gsl_matrix_complex_const_ptr(@Const gsl_matrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif /* HAVE_INLINE */

// #endif /* __GSL_MATRIX_COMPLEX_DOUBLE_H__ */


// Parsed from gsl/gsl_matrix_complex_float.h

/* matrix/gsl_matrix_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_COMPLEX_FLOAT_H__
// #define __GSL_MATRIX_COMPLEX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_complex_float.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_complex_float.java


// Targeting ../_gsl_matrix_complex_float_view.java


// Targeting ../_gsl_matrix_complex_float_const_view.java




/* Allocation */

public static native gsl_matrix_complex_float gsl_matrix_complex_float_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_complex_float gsl_matrix_complex_float_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_complex_float gsl_matrix_complex_float_alloc_from_block(gsl_block_complex_float b, 
                                           @Cast("const size_t") long offset, 
                                           @Cast("const size_t") long n1, @Cast("const size_t") long n2, @Cast("const size_t") long d2);

public static native gsl_matrix_complex_float gsl_matrix_complex_float_alloc_from_matrix(gsl_matrix_complex_float b,
                                            @Cast("const size_t") long k1, @Cast("const size_t") long k2,
                                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_vector_complex_float gsl_vector_complex_float_alloc_row_from_matrix(gsl_matrix_complex_float m,
                                                @Cast("const size_t") long i);

public static native gsl_vector_complex_float gsl_vector_complex_float_alloc_col_from_matrix(gsl_matrix_complex_float m,
                                                @Cast("const size_t") long j);

public static native void gsl_matrix_complex_float_free(gsl_matrix_complex_float m);

/* Views */

public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_submatrix(gsl_matrix_complex_float m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_row(gsl_matrix_complex_float m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_column(gsl_matrix_complex_float m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_diagonal(gsl_matrix_complex_float m);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_subdiagonal(gsl_matrix_complex_float m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_superdiagonal(gsl_matrix_complex_float m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_subrow(gsl_matrix_complex_float m,
                                 @Cast("const size_t") long i, @Cast("const size_t") long offset,
                                 @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_complex_float_view gsl_matrix_complex_float_subcolumn(gsl_matrix_complex_float m,
                                    @Cast("const size_t") long j, @Cast("const size_t") long offset,
                                    @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array(FloatPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array(FloatBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array(float[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array_with_tda(FloatPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array_with_tda(FloatBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_array_with_tda(float[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_vector(gsl_vector_complex_float v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_float_view gsl_matrix_complex_float_view_vector_with_tda(gsl_vector_complex_float v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_submatrix(@Const gsl_matrix_complex_float m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_row(@Const gsl_matrix_complex_float m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_column(@Const gsl_matrix_complex_float m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_diagonal(@Const gsl_matrix_complex_float m);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_subdiagonal(@Const gsl_matrix_complex_float m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_superdiagonal(@Const gsl_matrix_complex_float m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_subrow(@Const gsl_matrix_complex_float m,
                                       @Cast("const size_t") long i, @Cast("const size_t") long offset,
                                       @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_complex_float_const_view gsl_matrix_complex_float_const_subcolumn(@Const gsl_matrix_complex_float m,
                                          @Cast("const size_t") long j, @Cast("const size_t") long offset,
                                          @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array(@Const FloatPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array(@Const FloatBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array(@Const float[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array_with_tda(@Const FloatPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array_with_tda(@Const FloatBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_array_with_tda(@Const float[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_vector(@Const gsl_vector_complex_float v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_complex_float_const_view gsl_matrix_complex_float_const_view_vector_with_tda(@Const gsl_vector_complex_float v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_complex_float_set_zero(gsl_matrix_complex_float m);
public static native void gsl_matrix_complex_float_set_identity(gsl_matrix_complex_float m);
public static native void gsl_matrix_complex_float_set_all(gsl_matrix_complex_float m, @ByVal gsl_complex_float x);

public static native int gsl_matrix_complex_float_fread(FILE stream, gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_fwrite(FILE stream, @Const gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_fscanf(FILE stream, gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_fprintf(FILE stream, @Const gsl_matrix_complex_float m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_complex_float_fprintf(FILE stream, @Const gsl_matrix_complex_float m, String format);

public static native int gsl_matrix_complex_float_memcpy(gsl_matrix_complex_float dest, @Const gsl_matrix_complex_float src);
public static native int gsl_matrix_complex_float_swap(gsl_matrix_complex_float m1, gsl_matrix_complex_float m2);
public static native int gsl_matrix_complex_float_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_complex_float dest, @Const gsl_matrix_complex_float src);

public static native int gsl_matrix_complex_float_swap_rows(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_float_swap_columns(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_float_swap_rowcol(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_matrix_complex_float_transpose(gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_transpose_memcpy(gsl_matrix_complex_float dest, @Const gsl_matrix_complex_float src);
public static native int gsl_matrix_complex_float_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_complex_float dest, @Const gsl_matrix_complex_float src);

public static native int gsl_matrix_complex_float_conjtrans_memcpy(gsl_matrix_complex_float dest, @Const gsl_matrix_complex_float src);

public static native int gsl_matrix_complex_float_equal(@Const gsl_matrix_complex_float a, @Const gsl_matrix_complex_float b);

public static native int gsl_matrix_complex_float_isnull(@Const gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_ispos(@Const gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_isneg(@Const gsl_matrix_complex_float m);
public static native int gsl_matrix_complex_float_isnonneg(@Const gsl_matrix_complex_float m);

public static native int gsl_matrix_complex_float_add(gsl_matrix_complex_float a, @Const gsl_matrix_complex_float b);
public static native int gsl_matrix_complex_float_sub(gsl_matrix_complex_float a, @Const gsl_matrix_complex_float b);
public static native int gsl_matrix_complex_float_mul_elements(gsl_matrix_complex_float a, @Const gsl_matrix_complex_float b);
public static native int gsl_matrix_complex_float_div_elements(gsl_matrix_complex_float a, @Const gsl_matrix_complex_float b);
public static native int gsl_matrix_complex_float_scale(gsl_matrix_complex_float a, @Const @ByVal gsl_complex_float x);
public static native int gsl_matrix_complex_float_scale_rows(gsl_matrix_complex_float a, @Const gsl_vector_complex_float x);
public static native int gsl_matrix_complex_float_scale_columns(gsl_matrix_complex_float a, @Const gsl_vector_complex_float x);
public static native int gsl_matrix_complex_float_add_constant(gsl_matrix_complex_float a, @Const @ByVal gsl_complex_float x);
public static native int gsl_matrix_complex_float_add_diagonal(gsl_matrix_complex_float a, @Const @ByVal gsl_complex_float x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_complex_float_get_row(gsl_vector_complex_float v, @Const gsl_matrix_complex_float m, @Cast("const size_t") long i);
public static native int gsl_matrix_complex_float_get_col(gsl_vector_complex_float v, @Const gsl_matrix_complex_float m, @Cast("const size_t") long j);
public static native int gsl_matrix_complex_float_set_row(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Const gsl_vector_complex_float v);
public static native int gsl_matrix_complex_float_set_col(gsl_matrix_complex_float m, @Cast("const size_t") long j, @Const gsl_vector_complex_float v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @ByVal gsl_complex_float gsl_matrix_complex_float_get(@Const gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_complex_float_set(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Const @ByVal gsl_complex_float x);

/* */ public static native gsl_complex_float gsl_matrix_complex_float_ptr(gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const gsl_complex_float gsl_matrix_complex_float_const_ptr(@Const gsl_matrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif /* HAVE_INLINE */

// #endif /* __GSL_MATRIX_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_matrix_double.h

/* matrix/gsl_matrix_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_DOUBLE_H__
// #define __GSL_MATRIX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_double.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix.java


// Targeting ../_gsl_matrix_view.java


// Targeting ../_gsl_matrix_const_view.java



/* Allocation */

public static native gsl_matrix gsl_matrix_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix gsl_matrix_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix gsl_matrix_alloc_from_block(gsl_block b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix gsl_matrix_alloc_from_matrix(gsl_matrix m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector gsl_vector_alloc_row_from_matrix(gsl_matrix m,
                                        @Cast("const size_t") long i);

public static native gsl_vector gsl_vector_alloc_col_from_matrix(gsl_matrix m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_free(gsl_matrix m);

/* Views */

public static native @ByVal _gsl_matrix_view gsl_matrix_submatrix(gsl_matrix m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_view gsl_matrix_row(gsl_matrix m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_view gsl_matrix_column(gsl_matrix m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_view gsl_matrix_diagonal(gsl_matrix m);

public static native @ByVal _gsl_vector_view gsl_matrix_subdiagonal(gsl_matrix m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_view gsl_matrix_superdiagonal(gsl_matrix m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_view gsl_matrix_subrow(gsl_matrix m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_view gsl_matrix_subcolumn(gsl_matrix m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_view gsl_matrix_view_array(DoublePointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_view gsl_matrix_view_array(DoubleBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_view gsl_matrix_view_array(double[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_view gsl_matrix_view_array_with_tda(DoublePointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_view gsl_matrix_view_array_with_tda(DoubleBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_view gsl_matrix_view_array_with_tda(double[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_view gsl_matrix_view_vector(gsl_vector v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_view gsl_matrix_view_vector_with_tda(gsl_vector v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_submatrix(@Const gsl_matrix m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_row(@Const gsl_matrix m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_column(@Const gsl_matrix m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_diagonal(@Const gsl_matrix m);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_subdiagonal(@Const gsl_matrix m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_superdiagonal(@Const gsl_matrix m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_subrow(@Const gsl_matrix m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_const_view gsl_matrix_const_subcolumn(@Const gsl_matrix m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array(@Const DoublePointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array(@Const DoubleBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array(@Const double[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array_with_tda(@Const DoublePointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array_with_tda(@Const DoubleBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_array_with_tda(@Const double[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_vector(@Const gsl_vector v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_const_view gsl_matrix_const_view_vector_with_tda(@Const gsl_vector v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_set_zero(gsl_matrix m);
public static native void gsl_matrix_set_identity(gsl_matrix m);
public static native void gsl_matrix_set_all(gsl_matrix m, double x);

public static native int gsl_matrix_fread(FILE stream, gsl_matrix m);
public static native int gsl_matrix_fwrite(FILE stream, @Const gsl_matrix m);
public static native int gsl_matrix_fscanf(FILE stream, gsl_matrix m);
public static native int gsl_matrix_fprintf(FILE stream, @Const gsl_matrix m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_fprintf(FILE stream, @Const gsl_matrix m, String format);
 
public static native int gsl_matrix_memcpy(gsl_matrix dest, @Const gsl_matrix src);
public static native int gsl_matrix_swap(gsl_matrix m1, gsl_matrix m2);
public static native int gsl_matrix_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix dest, @Const gsl_matrix src);

public static native int gsl_matrix_swap_rows(gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_swap_columns(gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_swap_rowcol(gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_transpose(gsl_matrix m);
public static native int gsl_matrix_transpose_memcpy(gsl_matrix dest, @Const gsl_matrix src);
public static native int gsl_matrix_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix dest, @Const gsl_matrix src);

public static native double gsl_matrix_max(@Const gsl_matrix m);
public static native double gsl_matrix_min(@Const gsl_matrix m);
public static native void gsl_matrix_minmax(@Const gsl_matrix m, DoublePointer min_out, DoublePointer max_out);
public static native void gsl_matrix_minmax(@Const gsl_matrix m, DoubleBuffer min_out, DoubleBuffer max_out);
public static native void gsl_matrix_minmax(@Const gsl_matrix m, double[] min_out, double[] max_out);

public static native void gsl_matrix_max_index(@Const gsl_matrix m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_min_index(@Const gsl_matrix m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_minmax_index(@Const gsl_matrix m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_equal(@Const gsl_matrix a, @Const gsl_matrix b);

public static native int gsl_matrix_isnull(@Const gsl_matrix m);
public static native int gsl_matrix_ispos(@Const gsl_matrix m);
public static native int gsl_matrix_isneg(@Const gsl_matrix m);
public static native int gsl_matrix_isnonneg(@Const gsl_matrix m);

public static native double gsl_matrix_norm1(@Const gsl_matrix m);

public static native int gsl_matrix_add(gsl_matrix a, @Const gsl_matrix b);
public static native int gsl_matrix_sub(gsl_matrix a, @Const gsl_matrix b);
public static native int gsl_matrix_mul_elements(gsl_matrix a, @Const gsl_matrix b);
public static native int gsl_matrix_div_elements(gsl_matrix a, @Const gsl_matrix b);
public static native int gsl_matrix_scale(gsl_matrix a, double x);
public static native int gsl_matrix_scale_rows(gsl_matrix a, @Const gsl_vector x);
public static native int gsl_matrix_scale_columns(gsl_matrix a, @Const gsl_vector x);
public static native int gsl_matrix_add_constant(gsl_matrix a, double x);
public static native int gsl_matrix_add_diagonal(gsl_matrix a, double x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_get_row(gsl_vector v, @Const gsl_matrix m, @Cast("const size_t") long i);
public static native int gsl_matrix_get_col(gsl_vector v, @Const gsl_matrix m, @Cast("const size_t") long j);
public static native int gsl_matrix_set_row(gsl_matrix m, @Cast("const size_t") long i, @Const gsl_vector v);
public static native int gsl_matrix_set_col(gsl_matrix m, @Cast("const size_t") long j, @Const gsl_vector v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native double gsl_matrix_get(@Const gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_set(gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j, double x);
/* */ public static native DoublePointer gsl_matrix_ptr(gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const DoublePointer gsl_matrix_const_ptr(@Const gsl_matrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_DOUBLE_H__ */


// Parsed from gsl/gsl_matrix_float.h

/* matrix/gsl_matrix_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_FLOAT_H__
// #define __GSL_MATRIX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_float.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_float.java


// Targeting ../_gsl_matrix_float_view.java


// Targeting ../_gsl_matrix_float_const_view.java



/* Allocation */

public static native gsl_matrix_float gsl_matrix_float_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_float gsl_matrix_float_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_float gsl_matrix_float_alloc_from_block(gsl_block_float b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_float gsl_matrix_float_alloc_from_matrix(gsl_matrix_float m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_float gsl_vector_float_alloc_row_from_matrix(gsl_matrix_float m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_float gsl_vector_float_alloc_col_from_matrix(gsl_matrix_float m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_float_free(gsl_matrix_float m);

/* Views */

public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_submatrix(gsl_matrix_float m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_row(gsl_matrix_float m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_column(gsl_matrix_float m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_diagonal(gsl_matrix_float m);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_subdiagonal(gsl_matrix_float m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_superdiagonal(gsl_matrix_float m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_subrow(gsl_matrix_float m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_float_view gsl_matrix_float_subcolumn(gsl_matrix_float m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array(FloatPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array(FloatBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array(float[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array_with_tda(FloatPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array_with_tda(FloatBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_array_with_tda(float[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_vector(gsl_vector_float v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_float_view gsl_matrix_float_view_vector_with_tda(gsl_vector_float v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_submatrix(@Const gsl_matrix_float m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_row(@Const gsl_matrix_float m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_column(@Const gsl_matrix_float m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_diagonal(@Const gsl_matrix_float m);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_subdiagonal(@Const gsl_matrix_float m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_superdiagonal(@Const gsl_matrix_float m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_subrow(@Const gsl_matrix_float m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_float_const_view gsl_matrix_float_const_subcolumn(@Const gsl_matrix_float m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array(@Const FloatPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array(@Const FloatBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array(@Const float[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array_with_tda(@Const FloatPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array_with_tda(@Const FloatBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_array_with_tda(@Const float[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_vector(@Const gsl_vector_float v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_float_const_view gsl_matrix_float_const_view_vector_with_tda(@Const gsl_vector_float v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_float_set_zero(gsl_matrix_float m);
public static native void gsl_matrix_float_set_identity(gsl_matrix_float m);
public static native void gsl_matrix_float_set_all(gsl_matrix_float m, float x);

public static native int gsl_matrix_float_fread(FILE stream, gsl_matrix_float m);
public static native int gsl_matrix_float_fwrite(FILE stream, @Const gsl_matrix_float m);
public static native int gsl_matrix_float_fscanf(FILE stream, gsl_matrix_float m);
public static native int gsl_matrix_float_fprintf(FILE stream, @Const gsl_matrix_float m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_float_fprintf(FILE stream, @Const gsl_matrix_float m, String format);
 
public static native int gsl_matrix_float_memcpy(gsl_matrix_float dest, @Const gsl_matrix_float src);
public static native int gsl_matrix_float_swap(gsl_matrix_float m1, gsl_matrix_float m2);
public static native int gsl_matrix_float_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_float dest, @Const gsl_matrix_float src);

public static native int gsl_matrix_float_swap_rows(gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_float_swap_columns(gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_float_swap_rowcol(gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_float_transpose(gsl_matrix_float m);
public static native int gsl_matrix_float_transpose_memcpy(gsl_matrix_float dest, @Const gsl_matrix_float src);
public static native int gsl_matrix_float_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_float dest, @Const gsl_matrix_float src);

public static native float gsl_matrix_float_max(@Const gsl_matrix_float m);
public static native float gsl_matrix_float_min(@Const gsl_matrix_float m);
public static native void gsl_matrix_float_minmax(@Const gsl_matrix_float m, FloatPointer min_out, FloatPointer max_out);
public static native void gsl_matrix_float_minmax(@Const gsl_matrix_float m, FloatBuffer min_out, FloatBuffer max_out);
public static native void gsl_matrix_float_minmax(@Const gsl_matrix_float m, float[] min_out, float[] max_out);

public static native void gsl_matrix_float_max_index(@Const gsl_matrix_float m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_float_min_index(@Const gsl_matrix_float m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_float_minmax_index(@Const gsl_matrix_float m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_float_equal(@Const gsl_matrix_float a, @Const gsl_matrix_float b);

public static native int gsl_matrix_float_isnull(@Const gsl_matrix_float m);
public static native int gsl_matrix_float_ispos(@Const gsl_matrix_float m);
public static native int gsl_matrix_float_isneg(@Const gsl_matrix_float m);
public static native int gsl_matrix_float_isnonneg(@Const gsl_matrix_float m);

public static native float gsl_matrix_float_norm1(@Const gsl_matrix_float m);

public static native int gsl_matrix_float_add(gsl_matrix_float a, @Const gsl_matrix_float b);
public static native int gsl_matrix_float_sub(gsl_matrix_float a, @Const gsl_matrix_float b);
public static native int gsl_matrix_float_mul_elements(gsl_matrix_float a, @Const gsl_matrix_float b);
public static native int gsl_matrix_float_div_elements(gsl_matrix_float a, @Const gsl_matrix_float b);
public static native int gsl_matrix_float_scale(gsl_matrix_float a, float x);
public static native int gsl_matrix_float_scale_rows(gsl_matrix_float a, @Const gsl_vector_float x);
public static native int gsl_matrix_float_scale_columns(gsl_matrix_float a, @Const gsl_vector_float x);
public static native int gsl_matrix_float_add_constant(gsl_matrix_float a, float x);
public static native int gsl_matrix_float_add_diagonal(gsl_matrix_float a, float x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_float_get_row(gsl_vector_float v, @Const gsl_matrix_float m, @Cast("const size_t") long i);
public static native int gsl_matrix_float_get_col(gsl_vector_float v, @Const gsl_matrix_float m, @Cast("const size_t") long j);
public static native int gsl_matrix_float_set_row(gsl_matrix_float m, @Cast("const size_t") long i, @Const gsl_vector_float v);
public static native int gsl_matrix_float_set_col(gsl_matrix_float m, @Cast("const size_t") long j, @Const gsl_vector_float v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native float gsl_matrix_float_get(@Const gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_float_set(gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j, float x);
/* */ public static native FloatPointer gsl_matrix_float_ptr(gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const FloatPointer gsl_matrix_float_const_ptr(@Const gsl_matrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_FLOAT_H__ */


// Parsed from gsl/gsl_matrix_ulong.h

/* matrix/gsl_matrix_ulong.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_ULONG_H__
// #define __GSL_MATRIX_ULONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_ulong.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_ulong.java


// Targeting ../_gsl_matrix_ulong_view.java


// Targeting ../_gsl_matrix_ulong_const_view.java



/* Allocation */

public static native gsl_matrix_ulong gsl_matrix_ulong_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_ulong gsl_matrix_ulong_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_ulong gsl_matrix_ulong_alloc_from_block(gsl_block_ulong b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_ulong gsl_matrix_ulong_alloc_from_matrix(gsl_matrix_ulong m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_ulong gsl_vector_ulong_alloc_row_from_matrix(gsl_matrix_ulong m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_ulong gsl_vector_ulong_alloc_col_from_matrix(gsl_matrix_ulong m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_ulong_free(gsl_matrix_ulong m);

/* Views */

public static native @ByVal _gsl_matrix_ulong_view gsl_matrix_ulong_submatrix(gsl_matrix_ulong m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_row(gsl_matrix_ulong m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_column(gsl_matrix_ulong m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_diagonal(gsl_matrix_ulong m);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_subdiagonal(gsl_matrix_ulong m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_superdiagonal(gsl_matrix_ulong m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_subrow(gsl_matrix_ulong m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_ulong_view gsl_matrix_ulong_subcolumn(gsl_matrix_ulong m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_ulong_view gsl_matrix_ulong_view_array(@Cast("unsigned long*") CLongPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ulong_view gsl_matrix_ulong_view_array_with_tda(@Cast("unsigned long*") CLongPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_ulong_view gsl_matrix_ulong_view_vector(gsl_vector_ulong v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ulong_view gsl_matrix_ulong_view_vector_with_tda(gsl_vector_ulong v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_ulong_const_view gsl_matrix_ulong_const_submatrix(@Const gsl_matrix_ulong m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_row(@Const gsl_matrix_ulong m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_column(@Const gsl_matrix_ulong m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_diagonal(@Const gsl_matrix_ulong m);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_subdiagonal(@Const gsl_matrix_ulong m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_superdiagonal(@Const gsl_matrix_ulong m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_subrow(@Const gsl_matrix_ulong m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_ulong_const_view gsl_matrix_ulong_const_subcolumn(@Const gsl_matrix_ulong m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_ulong_const_view gsl_matrix_ulong_const_view_array(@Cast("const unsigned long*") CLongPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ulong_const_view gsl_matrix_ulong_const_view_array_with_tda(@Cast("const unsigned long*") CLongPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_ulong_const_view gsl_matrix_ulong_const_view_vector(@Const gsl_vector_ulong v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ulong_const_view gsl_matrix_ulong_const_view_vector_with_tda(@Const gsl_vector_ulong v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_ulong_set_zero(gsl_matrix_ulong m);
public static native void gsl_matrix_ulong_set_identity(gsl_matrix_ulong m);
public static native void gsl_matrix_ulong_set_all(gsl_matrix_ulong m, @Cast("unsigned long") long x);

public static native int gsl_matrix_ulong_fread(FILE stream, gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_fwrite(FILE stream, @Const gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_fscanf(FILE stream, gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_fprintf(FILE stream, @Const gsl_matrix_ulong m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_ulong_fprintf(FILE stream, @Const gsl_matrix_ulong m, String format);
 
public static native int gsl_matrix_ulong_memcpy(gsl_matrix_ulong dest, @Const gsl_matrix_ulong src);
public static native int gsl_matrix_ulong_swap(gsl_matrix_ulong m1, gsl_matrix_ulong m2);
public static native int gsl_matrix_ulong_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_ulong dest, @Const gsl_matrix_ulong src);

public static native int gsl_matrix_ulong_swap_rows(gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ulong_swap_columns(gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ulong_swap_rowcol(gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ulong_transpose(gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_transpose_memcpy(gsl_matrix_ulong dest, @Const gsl_matrix_ulong src);
public static native int gsl_matrix_ulong_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_ulong dest, @Const gsl_matrix_ulong src);

public static native @Cast("unsigned long") long gsl_matrix_ulong_max(@Const gsl_matrix_ulong m);
public static native @Cast("unsigned long") long gsl_matrix_ulong_min(@Const gsl_matrix_ulong m);
public static native void gsl_matrix_ulong_minmax(@Const gsl_matrix_ulong m, @Cast("unsigned long*") CLongPointer min_out, @Cast("unsigned long*") CLongPointer max_out);

public static native void gsl_matrix_ulong_max_index(@Const gsl_matrix_ulong m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_ulong_min_index(@Const gsl_matrix_ulong m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_ulong_minmax_index(@Const gsl_matrix_ulong m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_ulong_equal(@Const gsl_matrix_ulong a, @Const gsl_matrix_ulong b);

public static native int gsl_matrix_ulong_isnull(@Const gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_ispos(@Const gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_isneg(@Const gsl_matrix_ulong m);
public static native int gsl_matrix_ulong_isnonneg(@Const gsl_matrix_ulong m);



public static native int gsl_matrix_ulong_add(gsl_matrix_ulong a, @Const gsl_matrix_ulong b);
public static native int gsl_matrix_ulong_sub(gsl_matrix_ulong a, @Const gsl_matrix_ulong b);
public static native int gsl_matrix_ulong_mul_elements(gsl_matrix_ulong a, @Const gsl_matrix_ulong b);
public static native int gsl_matrix_ulong_div_elements(gsl_matrix_ulong a, @Const gsl_matrix_ulong b);
public static native int gsl_matrix_ulong_scale(gsl_matrix_ulong a, @Cast("const unsigned long") long x);
public static native int gsl_matrix_ulong_scale_rows(gsl_matrix_ulong a, @Const gsl_vector_ulong x);
public static native int gsl_matrix_ulong_scale_columns(gsl_matrix_ulong a, @Const gsl_vector_ulong x);
public static native int gsl_matrix_ulong_add_constant(gsl_matrix_ulong a, @Cast("const unsigned long") long x);
public static native int gsl_matrix_ulong_add_diagonal(gsl_matrix_ulong a, @Cast("const unsigned long") long x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_ulong_get_row(gsl_vector_ulong v, @Const gsl_matrix_ulong m, @Cast("const size_t") long i);
public static native int gsl_matrix_ulong_get_col(gsl_vector_ulong v, @Const gsl_matrix_ulong m, @Cast("const size_t") long j);
public static native int gsl_matrix_ulong_set_row(gsl_matrix_ulong m, @Cast("const size_t") long i, @Const gsl_vector_ulong v);
public static native int gsl_matrix_ulong_set_col(gsl_matrix_ulong m, @Cast("const size_t") long j, @Const gsl_vector_ulong v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @Cast("unsigned long") long gsl_matrix_ulong_get(@Const gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_ulong_set(gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned long") long x);
/* */ public static native @Cast("unsigned long*") CLongPointer gsl_matrix_ulong_ptr(gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Cast("const unsigned long*") CLongPointer gsl_matrix_ulong_const_ptr(@Const gsl_matrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_ULONG_H__ */


// Parsed from gsl/gsl_matrix_long.h

/* matrix/gsl_matrix_long.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_LONG_H__
// #define __GSL_MATRIX_LONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_long.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_long.java


// Targeting ../_gsl_matrix_long_view.java


// Targeting ../_gsl_matrix_long_const_view.java



/* Allocation */

public static native gsl_matrix_long gsl_matrix_long_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_long gsl_matrix_long_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_long gsl_matrix_long_alloc_from_block(gsl_block_long b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_long gsl_matrix_long_alloc_from_matrix(gsl_matrix_long m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_long gsl_vector_long_alloc_row_from_matrix(gsl_matrix_long m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_long gsl_vector_long_alloc_col_from_matrix(gsl_matrix_long m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_long_free(gsl_matrix_long m);

/* Views */

public static native @ByVal _gsl_matrix_long_view gsl_matrix_long_submatrix(gsl_matrix_long m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_row(gsl_matrix_long m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_column(gsl_matrix_long m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_diagonal(gsl_matrix_long m);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_subdiagonal(gsl_matrix_long m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_superdiagonal(gsl_matrix_long m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_subrow(gsl_matrix_long m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_long_view gsl_matrix_long_subcolumn(gsl_matrix_long m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_long_view gsl_matrix_long_view_array(CLongPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_long_view gsl_matrix_long_view_array_with_tda(CLongPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_long_view gsl_matrix_long_view_vector(gsl_vector_long v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_long_view gsl_matrix_long_view_vector_with_tda(gsl_vector_long v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_long_const_view gsl_matrix_long_const_submatrix(@Const gsl_matrix_long m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_row(@Const gsl_matrix_long m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_column(@Const gsl_matrix_long m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_diagonal(@Const gsl_matrix_long m);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_subdiagonal(@Const gsl_matrix_long m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_superdiagonal(@Const gsl_matrix_long m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_subrow(@Const gsl_matrix_long m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_long_const_view gsl_matrix_long_const_subcolumn(@Const gsl_matrix_long m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_long_const_view gsl_matrix_long_const_view_array(@Const CLongPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_long_const_view gsl_matrix_long_const_view_array_with_tda(@Const CLongPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_long_const_view gsl_matrix_long_const_view_vector(@Const gsl_vector_long v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_long_const_view gsl_matrix_long_const_view_vector_with_tda(@Const gsl_vector_long v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_long_set_zero(gsl_matrix_long m);
public static native void gsl_matrix_long_set_identity(gsl_matrix_long m);
public static native void gsl_matrix_long_set_all(gsl_matrix_long m, long x);

public static native int gsl_matrix_long_fread(FILE stream, gsl_matrix_long m);
public static native int gsl_matrix_long_fwrite(FILE stream, @Const gsl_matrix_long m);
public static native int gsl_matrix_long_fscanf(FILE stream, gsl_matrix_long m);
public static native int gsl_matrix_long_fprintf(FILE stream, @Const gsl_matrix_long m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_long_fprintf(FILE stream, @Const gsl_matrix_long m, String format);
 
public static native int gsl_matrix_long_memcpy(gsl_matrix_long dest, @Const gsl_matrix_long src);
public static native int gsl_matrix_long_swap(gsl_matrix_long m1, gsl_matrix_long m2);
public static native int gsl_matrix_long_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_long dest, @Const gsl_matrix_long src);

public static native int gsl_matrix_long_swap_rows(gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_long_swap_columns(gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_long_swap_rowcol(gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_long_transpose(gsl_matrix_long m);
public static native int gsl_matrix_long_transpose_memcpy(gsl_matrix_long dest, @Const gsl_matrix_long src);
public static native int gsl_matrix_long_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_long dest, @Const gsl_matrix_long src);

public static native long gsl_matrix_long_max(@Const gsl_matrix_long m);
public static native long gsl_matrix_long_min(@Const gsl_matrix_long m);
public static native void gsl_matrix_long_minmax(@Const gsl_matrix_long m, CLongPointer min_out, CLongPointer max_out);

public static native void gsl_matrix_long_max_index(@Const gsl_matrix_long m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_long_min_index(@Const gsl_matrix_long m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_long_minmax_index(@Const gsl_matrix_long m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_long_equal(@Const gsl_matrix_long a, @Const gsl_matrix_long b);

public static native int gsl_matrix_long_isnull(@Const gsl_matrix_long m);
public static native int gsl_matrix_long_ispos(@Const gsl_matrix_long m);
public static native int gsl_matrix_long_isneg(@Const gsl_matrix_long m);
public static native int gsl_matrix_long_isnonneg(@Const gsl_matrix_long m);

public static native long gsl_matrix_long_norm1(@Const gsl_matrix_long m);

public static native int gsl_matrix_long_add(gsl_matrix_long a, @Const gsl_matrix_long b);
public static native int gsl_matrix_long_sub(gsl_matrix_long a, @Const gsl_matrix_long b);
public static native int gsl_matrix_long_mul_elements(gsl_matrix_long a, @Const gsl_matrix_long b);
public static native int gsl_matrix_long_div_elements(gsl_matrix_long a, @Const gsl_matrix_long b);
public static native int gsl_matrix_long_scale(gsl_matrix_long a, long x);
public static native int gsl_matrix_long_scale_rows(gsl_matrix_long a, @Const gsl_vector_long x);
public static native int gsl_matrix_long_scale_columns(gsl_matrix_long a, @Const gsl_vector_long x);
public static native int gsl_matrix_long_add_constant(gsl_matrix_long a, long x);
public static native int gsl_matrix_long_add_diagonal(gsl_matrix_long a, long x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_long_get_row(gsl_vector_long v, @Const gsl_matrix_long m, @Cast("const size_t") long i);
public static native int gsl_matrix_long_get_col(gsl_vector_long v, @Const gsl_matrix_long m, @Cast("const size_t") long j);
public static native int gsl_matrix_long_set_row(gsl_matrix_long m, @Cast("const size_t") long i, @Const gsl_vector_long v);
public static native int gsl_matrix_long_set_col(gsl_matrix_long m, @Cast("const size_t") long j, @Const gsl_vector_long v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native long gsl_matrix_long_get(@Const gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_long_set(gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j, long x);
/* */ public static native CLongPointer gsl_matrix_long_ptr(gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const CLongPointer gsl_matrix_long_const_ptr(@Const gsl_matrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_LONG_H__ */


// Parsed from gsl/gsl_matrix_uint.h

/* matrix/gsl_matrix_uint.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_UINT_H__
// #define __GSL_MATRIX_UINT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_uint.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_uint.java


// Targeting ../_gsl_matrix_uint_view.java


// Targeting ../_gsl_matrix_uint_const_view.java



/* Allocation */

public static native gsl_matrix_uint gsl_matrix_uint_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_uint gsl_matrix_uint_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_uint gsl_matrix_uint_alloc_from_block(gsl_block_uint b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_uint gsl_matrix_uint_alloc_from_matrix(gsl_matrix_uint m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_uint gsl_vector_uint_alloc_row_from_matrix(gsl_matrix_uint m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_uint gsl_vector_uint_alloc_col_from_matrix(gsl_matrix_uint m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_uint_free(gsl_matrix_uint m);

/* Views */

public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_submatrix(gsl_matrix_uint m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_row(gsl_matrix_uint m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_column(gsl_matrix_uint m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_diagonal(gsl_matrix_uint m);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_subdiagonal(gsl_matrix_uint m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_superdiagonal(gsl_matrix_uint m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_subrow(gsl_matrix_uint m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_uint_view gsl_matrix_uint_subcolumn(gsl_matrix_uint m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array(@Cast("unsigned int*") IntPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array(@Cast("unsigned int*") IntBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array(@Cast("unsigned int*") int[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array_with_tda(@Cast("unsigned int*") IntPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array_with_tda(@Cast("unsigned int*") IntBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_array_with_tda(@Cast("unsigned int*") int[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_vector(gsl_vector_uint v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uint_view gsl_matrix_uint_view_vector_with_tda(gsl_vector_uint v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_submatrix(@Const gsl_matrix_uint m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_row(@Const gsl_matrix_uint m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_column(@Const gsl_matrix_uint m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_diagonal(@Const gsl_matrix_uint m);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_subdiagonal(@Const gsl_matrix_uint m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_superdiagonal(@Const gsl_matrix_uint m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_subrow(@Const gsl_matrix_uint m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_uint_const_view gsl_matrix_uint_const_subcolumn(@Const gsl_matrix_uint m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array(@Cast("const unsigned int*") IntPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array(@Cast("const unsigned int*") IntBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array(@Cast("const unsigned int*") int[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array_with_tda(@Cast("const unsigned int*") IntPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array_with_tda(@Cast("const unsigned int*") IntBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_array_with_tda(@Cast("const unsigned int*") int[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_vector(@Const gsl_vector_uint v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uint_const_view gsl_matrix_uint_const_view_vector_with_tda(@Const gsl_vector_uint v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_uint_set_zero(gsl_matrix_uint m);
public static native void gsl_matrix_uint_set_identity(gsl_matrix_uint m);
public static native void gsl_matrix_uint_set_all(gsl_matrix_uint m, @Cast("unsigned int") int x);

public static native int gsl_matrix_uint_fread(FILE stream, gsl_matrix_uint m);
public static native int gsl_matrix_uint_fwrite(FILE stream, @Const gsl_matrix_uint m);
public static native int gsl_matrix_uint_fscanf(FILE stream, gsl_matrix_uint m);
public static native int gsl_matrix_uint_fprintf(FILE stream, @Const gsl_matrix_uint m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_uint_fprintf(FILE stream, @Const gsl_matrix_uint m, String format);
 
public static native int gsl_matrix_uint_memcpy(gsl_matrix_uint dest, @Const gsl_matrix_uint src);
public static native int gsl_matrix_uint_swap(gsl_matrix_uint m1, gsl_matrix_uint m2);
public static native int gsl_matrix_uint_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_uint dest, @Const gsl_matrix_uint src);

public static native int gsl_matrix_uint_swap_rows(gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uint_swap_columns(gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uint_swap_rowcol(gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uint_transpose(gsl_matrix_uint m);
public static native int gsl_matrix_uint_transpose_memcpy(gsl_matrix_uint dest, @Const gsl_matrix_uint src);
public static native int gsl_matrix_uint_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_uint dest, @Const gsl_matrix_uint src);

public static native @Cast("unsigned int") int gsl_matrix_uint_max(@Const gsl_matrix_uint m);
public static native @Cast("unsigned int") int gsl_matrix_uint_min(@Const gsl_matrix_uint m);
public static native void gsl_matrix_uint_minmax(@Const gsl_matrix_uint m, @Cast("unsigned int*") IntPointer min_out, @Cast("unsigned int*") IntPointer max_out);
public static native void gsl_matrix_uint_minmax(@Const gsl_matrix_uint m, @Cast("unsigned int*") IntBuffer min_out, @Cast("unsigned int*") IntBuffer max_out);
public static native void gsl_matrix_uint_minmax(@Const gsl_matrix_uint m, @Cast("unsigned int*") int[] min_out, @Cast("unsigned int*") int[] max_out);

public static native void gsl_matrix_uint_max_index(@Const gsl_matrix_uint m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_uint_min_index(@Const gsl_matrix_uint m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_uint_minmax_index(@Const gsl_matrix_uint m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_uint_equal(@Const gsl_matrix_uint a, @Const gsl_matrix_uint b);

public static native int gsl_matrix_uint_isnull(@Const gsl_matrix_uint m);
public static native int gsl_matrix_uint_ispos(@Const gsl_matrix_uint m);
public static native int gsl_matrix_uint_isneg(@Const gsl_matrix_uint m);
public static native int gsl_matrix_uint_isnonneg(@Const gsl_matrix_uint m);



public static native int gsl_matrix_uint_add(gsl_matrix_uint a, @Const gsl_matrix_uint b);
public static native int gsl_matrix_uint_sub(gsl_matrix_uint a, @Const gsl_matrix_uint b);
public static native int gsl_matrix_uint_mul_elements(gsl_matrix_uint a, @Const gsl_matrix_uint b);
public static native int gsl_matrix_uint_div_elements(gsl_matrix_uint a, @Const gsl_matrix_uint b);
public static native int gsl_matrix_uint_scale(gsl_matrix_uint a, @Cast("const unsigned int") int x);
public static native int gsl_matrix_uint_scale_rows(gsl_matrix_uint a, @Const gsl_vector_uint x);
public static native int gsl_matrix_uint_scale_columns(gsl_matrix_uint a, @Const gsl_vector_uint x);
public static native int gsl_matrix_uint_add_constant(gsl_matrix_uint a, @Cast("const unsigned int") int x);
public static native int gsl_matrix_uint_add_diagonal(gsl_matrix_uint a, @Cast("const unsigned int") int x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_uint_get_row(gsl_vector_uint v, @Const gsl_matrix_uint m, @Cast("const size_t") long i);
public static native int gsl_matrix_uint_get_col(gsl_vector_uint v, @Const gsl_matrix_uint m, @Cast("const size_t") long j);
public static native int gsl_matrix_uint_set_row(gsl_matrix_uint m, @Cast("const size_t") long i, @Const gsl_vector_uint v);
public static native int gsl_matrix_uint_set_col(gsl_matrix_uint m, @Cast("const size_t") long j, @Const gsl_vector_uint v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @Cast("unsigned int") int gsl_matrix_uint_get(@Const gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_uint_set(gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned int") int x);
/* */ public static native @Cast("unsigned int*") IntPointer gsl_matrix_uint_ptr(gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Cast("const unsigned int*") IntPointer gsl_matrix_uint_const_ptr(@Const gsl_matrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_UINT_H__ */


// Parsed from gsl/gsl_matrix_int.h

/* matrix/gsl_matrix_int.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_INT_H__
// #define __GSL_MATRIX_INT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_int.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_int.java


// Targeting ../_gsl_matrix_int_view.java


// Targeting ../_gsl_matrix_int_const_view.java



/* Allocation */

public static native gsl_matrix_int gsl_matrix_int_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_int gsl_matrix_int_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_int gsl_matrix_int_alloc_from_block(gsl_block_int b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_int gsl_matrix_int_alloc_from_matrix(gsl_matrix_int m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_int gsl_vector_int_alloc_row_from_matrix(gsl_matrix_int m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_int gsl_vector_int_alloc_col_from_matrix(gsl_matrix_int m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_int_free(gsl_matrix_int m);

/* Views */

public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_submatrix(gsl_matrix_int m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_row(gsl_matrix_int m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_column(gsl_matrix_int m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_diagonal(gsl_matrix_int m);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_subdiagonal(gsl_matrix_int m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_superdiagonal(gsl_matrix_int m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_subrow(gsl_matrix_int m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_int_view gsl_matrix_int_subcolumn(gsl_matrix_int m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array(IntPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array(IntBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array(int[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array_with_tda(IntPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array_with_tda(IntBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_array_with_tda(int[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_vector(gsl_vector_int v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_int_view gsl_matrix_int_view_vector_with_tda(gsl_vector_int v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_submatrix(@Const gsl_matrix_int m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_row(@Const gsl_matrix_int m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_column(@Const gsl_matrix_int m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_diagonal(@Const gsl_matrix_int m);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_subdiagonal(@Const gsl_matrix_int m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_superdiagonal(@Const gsl_matrix_int m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_subrow(@Const gsl_matrix_int m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_int_const_view gsl_matrix_int_const_subcolumn(@Const gsl_matrix_int m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array(@Const IntPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array(@Const IntBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array(@Const int[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array_with_tda(@Const IntPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array_with_tda(@Const IntBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_array_with_tda(@Const int[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_vector(@Const gsl_vector_int v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_int_const_view gsl_matrix_int_const_view_vector_with_tda(@Const gsl_vector_int v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_int_set_zero(gsl_matrix_int m);
public static native void gsl_matrix_int_set_identity(gsl_matrix_int m);
public static native void gsl_matrix_int_set_all(gsl_matrix_int m, int x);

public static native int gsl_matrix_int_fread(FILE stream, gsl_matrix_int m);
public static native int gsl_matrix_int_fwrite(FILE stream, @Const gsl_matrix_int m);
public static native int gsl_matrix_int_fscanf(FILE stream, gsl_matrix_int m);
public static native int gsl_matrix_int_fprintf(FILE stream, @Const gsl_matrix_int m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_int_fprintf(FILE stream, @Const gsl_matrix_int m, String format);
 
public static native int gsl_matrix_int_memcpy(gsl_matrix_int dest, @Const gsl_matrix_int src);
public static native int gsl_matrix_int_swap(gsl_matrix_int m1, gsl_matrix_int m2);
public static native int gsl_matrix_int_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_int dest, @Const gsl_matrix_int src);

public static native int gsl_matrix_int_swap_rows(gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_int_swap_columns(gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_int_swap_rowcol(gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_int_transpose(gsl_matrix_int m);
public static native int gsl_matrix_int_transpose_memcpy(gsl_matrix_int dest, @Const gsl_matrix_int src);
public static native int gsl_matrix_int_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_int dest, @Const gsl_matrix_int src);

public static native int gsl_matrix_int_max(@Const gsl_matrix_int m);
public static native int gsl_matrix_int_min(@Const gsl_matrix_int m);
public static native void gsl_matrix_int_minmax(@Const gsl_matrix_int m, IntPointer min_out, IntPointer max_out);
public static native void gsl_matrix_int_minmax(@Const gsl_matrix_int m, IntBuffer min_out, IntBuffer max_out);
public static native void gsl_matrix_int_minmax(@Const gsl_matrix_int m, int[] min_out, int[] max_out);

public static native void gsl_matrix_int_max_index(@Const gsl_matrix_int m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_int_min_index(@Const gsl_matrix_int m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_int_minmax_index(@Const gsl_matrix_int m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_int_equal(@Const gsl_matrix_int a, @Const gsl_matrix_int b);

public static native int gsl_matrix_int_isnull(@Const gsl_matrix_int m);
public static native int gsl_matrix_int_ispos(@Const gsl_matrix_int m);
public static native int gsl_matrix_int_isneg(@Const gsl_matrix_int m);
public static native int gsl_matrix_int_isnonneg(@Const gsl_matrix_int m);

public static native int gsl_matrix_int_norm1(@Const gsl_matrix_int m);

public static native int gsl_matrix_int_add(gsl_matrix_int a, @Const gsl_matrix_int b);
public static native int gsl_matrix_int_sub(gsl_matrix_int a, @Const gsl_matrix_int b);
public static native int gsl_matrix_int_mul_elements(gsl_matrix_int a, @Const gsl_matrix_int b);
public static native int gsl_matrix_int_div_elements(gsl_matrix_int a, @Const gsl_matrix_int b);
public static native int gsl_matrix_int_scale(gsl_matrix_int a, int x);
public static native int gsl_matrix_int_scale_rows(gsl_matrix_int a, @Const gsl_vector_int x);
public static native int gsl_matrix_int_scale_columns(gsl_matrix_int a, @Const gsl_vector_int x);
public static native int gsl_matrix_int_add_constant(gsl_matrix_int a, int x);
public static native int gsl_matrix_int_add_diagonal(gsl_matrix_int a, int x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_int_get_row(gsl_vector_int v, @Const gsl_matrix_int m, @Cast("const size_t") long i);
public static native int gsl_matrix_int_get_col(gsl_vector_int v, @Const gsl_matrix_int m, @Cast("const size_t") long j);
public static native int gsl_matrix_int_set_row(gsl_matrix_int m, @Cast("const size_t") long i, @Const gsl_vector_int v);
public static native int gsl_matrix_int_set_col(gsl_matrix_int m, @Cast("const size_t") long j, @Const gsl_vector_int v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native int gsl_matrix_int_get(@Const gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_int_set(gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j, int x);
/* */ public static native IntPointer gsl_matrix_int_ptr(gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const IntPointer gsl_matrix_int_const_ptr(@Const gsl_matrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_INT_H__ */


// Parsed from gsl/gsl_matrix_ushort.h

/* matrix/gsl_matrix_ushort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_USHORT_H__
// #define __GSL_MATRIX_USHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_ushort.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_ushort.java


// Targeting ../_gsl_matrix_ushort_view.java


// Targeting ../_gsl_matrix_ushort_const_view.java



/* Allocation */

public static native gsl_matrix_ushort gsl_matrix_ushort_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_ushort gsl_matrix_ushort_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_ushort gsl_matrix_ushort_alloc_from_block(gsl_block_ushort b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_ushort gsl_matrix_ushort_alloc_from_matrix(gsl_matrix_ushort m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_ushort gsl_vector_ushort_alloc_row_from_matrix(gsl_matrix_ushort m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_ushort gsl_vector_ushort_alloc_col_from_matrix(gsl_matrix_ushort m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_ushort_free(gsl_matrix_ushort m);

/* Views */

public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_submatrix(gsl_matrix_ushort m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_row(gsl_matrix_ushort m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_column(gsl_matrix_ushort m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_diagonal(gsl_matrix_ushort m);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_subdiagonal(gsl_matrix_ushort m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_superdiagonal(gsl_matrix_ushort m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_subrow(gsl_matrix_ushort m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_ushort_view gsl_matrix_ushort_subcolumn(gsl_matrix_ushort m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array(@Cast("unsigned short*") ShortPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array(@Cast("unsigned short*") ShortBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array(@Cast("unsigned short*") short[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array_with_tda(@Cast("unsigned short*") ShortPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array_with_tda(@Cast("unsigned short*") ShortBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_array_with_tda(@Cast("unsigned short*") short[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_vector(gsl_vector_ushort v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ushort_view gsl_matrix_ushort_view_vector_with_tda(gsl_vector_ushort v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_submatrix(@Const gsl_matrix_ushort m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_row(@Const gsl_matrix_ushort m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_column(@Const gsl_matrix_ushort m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_diagonal(@Const gsl_matrix_ushort m);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_subdiagonal(@Const gsl_matrix_ushort m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_superdiagonal(@Const gsl_matrix_ushort m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_subrow(@Const gsl_matrix_ushort m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_ushort_const_view gsl_matrix_ushort_const_subcolumn(@Const gsl_matrix_ushort m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array(@Cast("const unsigned short*") ShortPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array(@Cast("const unsigned short*") ShortBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array(@Cast("const unsigned short*") short[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array_with_tda(@Cast("const unsigned short*") ShortPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array_with_tda(@Cast("const unsigned short*") ShortBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_array_with_tda(@Cast("const unsigned short*") short[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_vector(@Const gsl_vector_ushort v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_ushort_const_view gsl_matrix_ushort_const_view_vector_with_tda(@Const gsl_vector_ushort v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_ushort_set_zero(gsl_matrix_ushort m);
public static native void gsl_matrix_ushort_set_identity(gsl_matrix_ushort m);
public static native void gsl_matrix_ushort_set_all(gsl_matrix_ushort m, @Cast("unsigned short") short x);

public static native int gsl_matrix_ushort_fread(FILE stream, gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_fwrite(FILE stream, @Const gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_fscanf(FILE stream, gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_fprintf(FILE stream, @Const gsl_matrix_ushort m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_ushort_fprintf(FILE stream, @Const gsl_matrix_ushort m, String format);
 
public static native int gsl_matrix_ushort_memcpy(gsl_matrix_ushort dest, @Const gsl_matrix_ushort src);
public static native int gsl_matrix_ushort_swap(gsl_matrix_ushort m1, gsl_matrix_ushort m2);
public static native int gsl_matrix_ushort_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_ushort dest, @Const gsl_matrix_ushort src);

public static native int gsl_matrix_ushort_swap_rows(gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ushort_swap_columns(gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ushort_swap_rowcol(gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_ushort_transpose(gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_transpose_memcpy(gsl_matrix_ushort dest, @Const gsl_matrix_ushort src);
public static native int gsl_matrix_ushort_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_ushort dest, @Const gsl_matrix_ushort src);

public static native @Cast("unsigned short") short gsl_matrix_ushort_max(@Const gsl_matrix_ushort m);
public static native @Cast("unsigned short") short gsl_matrix_ushort_min(@Const gsl_matrix_ushort m);
public static native void gsl_matrix_ushort_minmax(@Const gsl_matrix_ushort m, @Cast("unsigned short*") ShortPointer min_out, @Cast("unsigned short*") ShortPointer max_out);
public static native void gsl_matrix_ushort_minmax(@Const gsl_matrix_ushort m, @Cast("unsigned short*") ShortBuffer min_out, @Cast("unsigned short*") ShortBuffer max_out);
public static native void gsl_matrix_ushort_minmax(@Const gsl_matrix_ushort m, @Cast("unsigned short*") short[] min_out, @Cast("unsigned short*") short[] max_out);

public static native void gsl_matrix_ushort_max_index(@Const gsl_matrix_ushort m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_ushort_min_index(@Const gsl_matrix_ushort m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_ushort_minmax_index(@Const gsl_matrix_ushort m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_ushort_equal(@Const gsl_matrix_ushort a, @Const gsl_matrix_ushort b);

public static native int gsl_matrix_ushort_isnull(@Const gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_ispos(@Const gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_isneg(@Const gsl_matrix_ushort m);
public static native int gsl_matrix_ushort_isnonneg(@Const gsl_matrix_ushort m);



public static native int gsl_matrix_ushort_add(gsl_matrix_ushort a, @Const gsl_matrix_ushort b);
public static native int gsl_matrix_ushort_sub(gsl_matrix_ushort a, @Const gsl_matrix_ushort b);
public static native int gsl_matrix_ushort_mul_elements(gsl_matrix_ushort a, @Const gsl_matrix_ushort b);
public static native int gsl_matrix_ushort_div_elements(gsl_matrix_ushort a, @Const gsl_matrix_ushort b);
public static native int gsl_matrix_ushort_scale(gsl_matrix_ushort a, @Cast("const unsigned short") short x);
public static native int gsl_matrix_ushort_scale_rows(gsl_matrix_ushort a, @Const gsl_vector_ushort x);
public static native int gsl_matrix_ushort_scale_columns(gsl_matrix_ushort a, @Const gsl_vector_ushort x);
public static native int gsl_matrix_ushort_add_constant(gsl_matrix_ushort a, @Cast("const unsigned short") short x);
public static native int gsl_matrix_ushort_add_diagonal(gsl_matrix_ushort a, @Cast("const unsigned short") short x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_ushort_get_row(gsl_vector_ushort v, @Const gsl_matrix_ushort m, @Cast("const size_t") long i);
public static native int gsl_matrix_ushort_get_col(gsl_vector_ushort v, @Const gsl_matrix_ushort m, @Cast("const size_t") long j);
public static native int gsl_matrix_ushort_set_row(gsl_matrix_ushort m, @Cast("const size_t") long i, @Const gsl_vector_ushort v);
public static native int gsl_matrix_ushort_set_col(gsl_matrix_ushort m, @Cast("const size_t") long j, @Const gsl_vector_ushort v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @Cast("unsigned short") short gsl_matrix_ushort_get(@Const gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_ushort_set(gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned short") short x);
/* */ public static native @Cast("unsigned short*") ShortPointer gsl_matrix_ushort_ptr(gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Cast("const unsigned short*") ShortPointer gsl_matrix_ushort_const_ptr(@Const gsl_matrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_USHORT_H__ */


// Parsed from gsl/gsl_matrix_short.h

/* matrix/gsl_matrix_short.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_SHORT_H__
// #define __GSL_MATRIX_SHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_short.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_short.java


// Targeting ../_gsl_matrix_short_view.java


// Targeting ../_gsl_matrix_short_const_view.java



/* Allocation */

public static native gsl_matrix_short gsl_matrix_short_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_short gsl_matrix_short_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_short gsl_matrix_short_alloc_from_block(gsl_block_short b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_short gsl_matrix_short_alloc_from_matrix(gsl_matrix_short m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_short gsl_vector_short_alloc_row_from_matrix(gsl_matrix_short m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_short gsl_vector_short_alloc_col_from_matrix(gsl_matrix_short m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_short_free(gsl_matrix_short m);

/* Views */

public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_submatrix(gsl_matrix_short m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_row(gsl_matrix_short m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_column(gsl_matrix_short m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_diagonal(gsl_matrix_short m);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_subdiagonal(gsl_matrix_short m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_superdiagonal(gsl_matrix_short m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_subrow(gsl_matrix_short m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_short_view gsl_matrix_short_subcolumn(gsl_matrix_short m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array(ShortPointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array(ShortBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array(short[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array_with_tda(ShortPointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array_with_tda(ShortBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_array_with_tda(short[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_vector(gsl_vector_short v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_short_view gsl_matrix_short_view_vector_with_tda(gsl_vector_short v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_submatrix(@Const gsl_matrix_short m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_row(@Const gsl_matrix_short m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_column(@Const gsl_matrix_short m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_diagonal(@Const gsl_matrix_short m);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_subdiagonal(@Const gsl_matrix_short m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_superdiagonal(@Const gsl_matrix_short m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_subrow(@Const gsl_matrix_short m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_short_const_view gsl_matrix_short_const_subcolumn(@Const gsl_matrix_short m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array(@Const ShortPointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array(@Const ShortBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array(@Const short[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array_with_tda(@Const ShortPointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array_with_tda(@Const ShortBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_array_with_tda(@Const short[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_vector(@Const gsl_vector_short v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_short_const_view gsl_matrix_short_const_view_vector_with_tda(@Const gsl_vector_short v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_short_set_zero(gsl_matrix_short m);
public static native void gsl_matrix_short_set_identity(gsl_matrix_short m);
public static native void gsl_matrix_short_set_all(gsl_matrix_short m, short x);

public static native int gsl_matrix_short_fread(FILE stream, gsl_matrix_short m);
public static native int gsl_matrix_short_fwrite(FILE stream, @Const gsl_matrix_short m);
public static native int gsl_matrix_short_fscanf(FILE stream, gsl_matrix_short m);
public static native int gsl_matrix_short_fprintf(FILE stream, @Const gsl_matrix_short m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_short_fprintf(FILE stream, @Const gsl_matrix_short m, String format);
 
public static native int gsl_matrix_short_memcpy(gsl_matrix_short dest, @Const gsl_matrix_short src);
public static native int gsl_matrix_short_swap(gsl_matrix_short m1, gsl_matrix_short m2);
public static native int gsl_matrix_short_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_short dest, @Const gsl_matrix_short src);

public static native int gsl_matrix_short_swap_rows(gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_short_swap_columns(gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_short_swap_rowcol(gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_short_transpose(gsl_matrix_short m);
public static native int gsl_matrix_short_transpose_memcpy(gsl_matrix_short dest, @Const gsl_matrix_short src);
public static native int gsl_matrix_short_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_short dest, @Const gsl_matrix_short src);

public static native short gsl_matrix_short_max(@Const gsl_matrix_short m);
public static native short gsl_matrix_short_min(@Const gsl_matrix_short m);
public static native void gsl_matrix_short_minmax(@Const gsl_matrix_short m, ShortPointer min_out, ShortPointer max_out);
public static native void gsl_matrix_short_minmax(@Const gsl_matrix_short m, ShortBuffer min_out, ShortBuffer max_out);
public static native void gsl_matrix_short_minmax(@Const gsl_matrix_short m, short[] min_out, short[] max_out);

public static native void gsl_matrix_short_max_index(@Const gsl_matrix_short m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_short_min_index(@Const gsl_matrix_short m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_short_minmax_index(@Const gsl_matrix_short m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_short_equal(@Const gsl_matrix_short a, @Const gsl_matrix_short b);

public static native int gsl_matrix_short_isnull(@Const gsl_matrix_short m);
public static native int gsl_matrix_short_ispos(@Const gsl_matrix_short m);
public static native int gsl_matrix_short_isneg(@Const gsl_matrix_short m);
public static native int gsl_matrix_short_isnonneg(@Const gsl_matrix_short m);

public static native short gsl_matrix_short_norm1(@Const gsl_matrix_short m);

public static native int gsl_matrix_short_add(gsl_matrix_short a, @Const gsl_matrix_short b);
public static native int gsl_matrix_short_sub(gsl_matrix_short a, @Const gsl_matrix_short b);
public static native int gsl_matrix_short_mul_elements(gsl_matrix_short a, @Const gsl_matrix_short b);
public static native int gsl_matrix_short_div_elements(gsl_matrix_short a, @Const gsl_matrix_short b);
public static native int gsl_matrix_short_scale(gsl_matrix_short a, short x);
public static native int gsl_matrix_short_scale_rows(gsl_matrix_short a, @Const gsl_vector_short x);
public static native int gsl_matrix_short_scale_columns(gsl_matrix_short a, @Const gsl_vector_short x);
public static native int gsl_matrix_short_add_constant(gsl_matrix_short a, short x);
public static native int gsl_matrix_short_add_diagonal(gsl_matrix_short a, short x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_short_get_row(gsl_vector_short v, @Const gsl_matrix_short m, @Cast("const size_t") long i);
public static native int gsl_matrix_short_get_col(gsl_vector_short v, @Const gsl_matrix_short m, @Cast("const size_t") long j);
public static native int gsl_matrix_short_set_row(gsl_matrix_short m, @Cast("const size_t") long i, @Const gsl_vector_short v);
public static native int gsl_matrix_short_set_col(gsl_matrix_short m, @Cast("const size_t") long j, @Const gsl_vector_short v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native short gsl_matrix_short_get(@Const gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_short_set(gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j, short x);
/* */ public static native ShortPointer gsl_matrix_short_ptr(gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Const ShortPointer gsl_matrix_short_const_ptr(@Const gsl_matrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_SHORT_H__ */


// Parsed from gsl/gsl_matrix_uchar.h

/* matrix/gsl_matrix_uchar.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_UCHAR_H__
// #define __GSL_MATRIX_UCHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_uchar.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_uchar.java


// Targeting ../_gsl_matrix_uchar_view.java


// Targeting ../_gsl_matrix_uchar_const_view.java



/* Allocation */

public static native gsl_matrix_uchar gsl_matrix_uchar_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_uchar gsl_matrix_uchar_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_uchar gsl_matrix_uchar_alloc_from_block(gsl_block_uchar b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_uchar gsl_matrix_uchar_alloc_from_matrix(gsl_matrix_uchar m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_uchar gsl_vector_uchar_alloc_row_from_matrix(gsl_matrix_uchar m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_uchar gsl_vector_uchar_alloc_col_from_matrix(gsl_matrix_uchar m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_uchar_free(gsl_matrix_uchar m);

/* Views */

public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_submatrix(gsl_matrix_uchar m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_row(gsl_matrix_uchar m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_column(gsl_matrix_uchar m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_diagonal(gsl_matrix_uchar m);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_subdiagonal(gsl_matrix_uchar m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_superdiagonal(gsl_matrix_uchar m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_subrow(gsl_matrix_uchar m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_uchar_view gsl_matrix_uchar_subcolumn(gsl_matrix_uchar m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array(@Cast("unsigned char*") BytePointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array(@Cast("unsigned char*") ByteBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array(@Cast("unsigned char*") byte[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array_with_tda(@Cast("unsigned char*") BytePointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array_with_tda(@Cast("unsigned char*") ByteBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_array_with_tda(@Cast("unsigned char*") byte[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_vector(gsl_vector_uchar v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uchar_view gsl_matrix_uchar_view_vector_with_tda(gsl_vector_uchar v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_submatrix(@Const gsl_matrix_uchar m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_row(@Const gsl_matrix_uchar m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_column(@Const gsl_matrix_uchar m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_diagonal(@Const gsl_matrix_uchar m);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_subdiagonal(@Const gsl_matrix_uchar m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_superdiagonal(@Const gsl_matrix_uchar m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_subrow(@Const gsl_matrix_uchar m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_uchar_const_view gsl_matrix_uchar_const_subcolumn(@Const gsl_matrix_uchar m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array(@Cast("const unsigned char*") BytePointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array(@Cast("const unsigned char*") ByteBuffer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array(@Cast("const unsigned char*") byte[] base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array_with_tda(@Cast("const unsigned char*") BytePointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array_with_tda(@Cast("const unsigned char*") ByteBuffer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_array_with_tda(@Cast("const unsigned char*") byte[] base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_vector(@Const gsl_vector_uchar v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_uchar_const_view gsl_matrix_uchar_const_view_vector_with_tda(@Const gsl_vector_uchar v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_uchar_set_zero(gsl_matrix_uchar m);
public static native void gsl_matrix_uchar_set_identity(gsl_matrix_uchar m);
public static native void gsl_matrix_uchar_set_all(gsl_matrix_uchar m, @Cast("unsigned char") byte x);

public static native int gsl_matrix_uchar_fread(FILE stream, gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_fwrite(FILE stream, @Const gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_fscanf(FILE stream, gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_fprintf(FILE stream, @Const gsl_matrix_uchar m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_uchar_fprintf(FILE stream, @Const gsl_matrix_uchar m, String format);
 
public static native int gsl_matrix_uchar_memcpy(gsl_matrix_uchar dest, @Const gsl_matrix_uchar src);
public static native int gsl_matrix_uchar_swap(gsl_matrix_uchar m1, gsl_matrix_uchar m2);
public static native int gsl_matrix_uchar_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_uchar dest, @Const gsl_matrix_uchar src);

public static native int gsl_matrix_uchar_swap_rows(gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uchar_swap_columns(gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uchar_swap_rowcol(gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_uchar_transpose(gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_transpose_memcpy(gsl_matrix_uchar dest, @Const gsl_matrix_uchar src);
public static native int gsl_matrix_uchar_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_uchar dest, @Const gsl_matrix_uchar src);

public static native @Cast("unsigned char") byte gsl_matrix_uchar_max(@Const gsl_matrix_uchar m);
public static native @Cast("unsigned char") byte gsl_matrix_uchar_min(@Const gsl_matrix_uchar m);
public static native void gsl_matrix_uchar_minmax(@Const gsl_matrix_uchar m, @Cast("unsigned char*") BytePointer min_out, @Cast("unsigned char*") BytePointer max_out);
public static native void gsl_matrix_uchar_minmax(@Const gsl_matrix_uchar m, @Cast("unsigned char*") ByteBuffer min_out, @Cast("unsigned char*") ByteBuffer max_out);
public static native void gsl_matrix_uchar_minmax(@Const gsl_matrix_uchar m, @Cast("unsigned char*") byte[] min_out, @Cast("unsigned char*") byte[] max_out);

public static native void gsl_matrix_uchar_max_index(@Const gsl_matrix_uchar m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_uchar_min_index(@Const gsl_matrix_uchar m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_uchar_minmax_index(@Const gsl_matrix_uchar m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_uchar_equal(@Const gsl_matrix_uchar a, @Const gsl_matrix_uchar b);

public static native int gsl_matrix_uchar_isnull(@Const gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_ispos(@Const gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_isneg(@Const gsl_matrix_uchar m);
public static native int gsl_matrix_uchar_isnonneg(@Const gsl_matrix_uchar m);



public static native int gsl_matrix_uchar_add(gsl_matrix_uchar a, @Const gsl_matrix_uchar b);
public static native int gsl_matrix_uchar_sub(gsl_matrix_uchar a, @Const gsl_matrix_uchar b);
public static native int gsl_matrix_uchar_mul_elements(gsl_matrix_uchar a, @Const gsl_matrix_uchar b);
public static native int gsl_matrix_uchar_div_elements(gsl_matrix_uchar a, @Const gsl_matrix_uchar b);
public static native int gsl_matrix_uchar_scale(gsl_matrix_uchar a, @Cast("const unsigned char") byte x);
public static native int gsl_matrix_uchar_scale_rows(gsl_matrix_uchar a, @Const gsl_vector_uchar x);
public static native int gsl_matrix_uchar_scale_columns(gsl_matrix_uchar a, @Const gsl_vector_uchar x);
public static native int gsl_matrix_uchar_add_constant(gsl_matrix_uchar a, @Cast("const unsigned char") byte x);
public static native int gsl_matrix_uchar_add_diagonal(gsl_matrix_uchar a, @Cast("const unsigned char") byte x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_uchar_get_row(gsl_vector_uchar v, @Const gsl_matrix_uchar m, @Cast("const size_t") long i);
public static native int gsl_matrix_uchar_get_col(gsl_vector_uchar v, @Const gsl_matrix_uchar m, @Cast("const size_t") long j);
public static native int gsl_matrix_uchar_set_row(gsl_matrix_uchar m, @Cast("const size_t") long i, @Const gsl_vector_uchar v);
public static native int gsl_matrix_uchar_set_col(gsl_matrix_uchar m, @Cast("const size_t") long j, @Const gsl_vector_uchar v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @Cast("unsigned char") byte gsl_matrix_uchar_get(@Const gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_uchar_set(gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned char") byte x);
/* */ public static native @Cast("unsigned char*") BytePointer gsl_matrix_uchar_ptr(gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Cast("const unsigned char*") BytePointer gsl_matrix_uchar_const_ptr(@Const gsl_matrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_UCHAR_H__ */


// Parsed from gsl/gsl_matrix_char.h

/* matrix/gsl_matrix_char.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MATRIX_CHAR_H__
// #define __GSL_MATRIX_CHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>
// #include <gsl/gsl_vector_char.h>
// #include <gsl/gsl_blas_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_matrix_char.java


// Targeting ../_gsl_matrix_char_view.java


// Targeting ../_gsl_matrix_char_const_view.java



/* Allocation */

public static native gsl_matrix_char gsl_matrix_char_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_char gsl_matrix_char_calloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native gsl_matrix_char gsl_matrix_char_alloc_from_block(gsl_block_char b, 
                                   @Cast("const size_t") long offset, 
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2, 
                                   @Cast("const size_t") long d2);

public static native gsl_matrix_char gsl_matrix_char_alloc_from_matrix(gsl_matrix_char m,
                                    @Cast("const size_t") long k1, 
                                    @Cast("const size_t") long k2,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native gsl_vector_char gsl_vector_char_alloc_row_from_matrix(gsl_matrix_char m,
                                        @Cast("const size_t") long i);

public static native gsl_vector_char gsl_vector_char_alloc_col_from_matrix(gsl_matrix_char m,
                                        @Cast("const size_t") long j);

public static native void gsl_matrix_char_free(gsl_matrix_char m);

/* Views */

public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_submatrix(gsl_matrix_char m, 
                            @Cast("const size_t") long i, @Cast("const size_t") long j, 
                            @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_row(gsl_matrix_char m, @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_column(gsl_matrix_char m, @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_diagonal(gsl_matrix_char m);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_subdiagonal(gsl_matrix_char m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_superdiagonal(gsl_matrix_char m, @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_subrow(gsl_matrix_char m, @Cast("const size_t") long i,
                         @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_char_view gsl_matrix_char_subcolumn(gsl_matrix_char m, @Cast("const size_t") long j,
                            @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array(@Cast("char*") BytePointer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array(@Cast("char*") ByteBuffer base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array(@Cast("char*") byte[] base,
                             @Cast("const size_t") long n1, 
                             @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array_with_tda(@Cast("char*") BytePointer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array_with_tda(@Cast("char*") ByteBuffer base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_array_with_tda(@Cast("char*") byte[] base, 
                                      @Cast("const size_t") long n1, 
                                      @Cast("const size_t") long n2,
                                      @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_vector(gsl_vector_char v,
                              @Cast("const size_t") long n1, 
                              @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_char_view gsl_matrix_char_view_vector_with_tda(gsl_vector_char v,
                                       @Cast("const size_t") long n1, 
                                       @Cast("const size_t") long n2,
                                       @Cast("const size_t") long tda);


public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_submatrix(@Const gsl_matrix_char m, 
                                  @Cast("const size_t") long i, @Cast("const size_t") long j, 
                                  @Cast("const size_t") long n1, @Cast("const size_t") long n2);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_row(@Const gsl_matrix_char m, 
                            @Cast("const size_t") long i);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_column(@Const gsl_matrix_char m, 
                               @Cast("const size_t") long j);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_diagonal(@Const gsl_matrix_char m);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_subdiagonal(@Const gsl_matrix_char m, 
                                    @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_superdiagonal(@Const gsl_matrix_char m, 
                                      @Cast("const size_t") long k);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_subrow(@Const gsl_matrix_char m, @Cast("const size_t") long i,
                               @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_vector_char_const_view gsl_matrix_char_const_subcolumn(@Const gsl_matrix_char m, @Cast("const size_t") long j,
                                  @Cast("const size_t") long offset, @Cast("const size_t") long n);

public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_array(@Cast("const char*") BytePointer base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);
public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_array(String base,
                                   @Cast("const size_t") long n1, 
                                   @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_array_with_tda(@Cast("const char*") BytePointer base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);
public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_array_with_tda(String base, 
                                            @Cast("const size_t") long n1, 
                                            @Cast("const size_t") long n2,
                                            @Cast("const size_t") long tda);

public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_vector(@Const gsl_vector_char v,
                                    @Cast("const size_t") long n1, 
                                    @Cast("const size_t") long n2);

public static native @ByVal _gsl_matrix_char_const_view gsl_matrix_char_const_view_vector_with_tda(@Const gsl_vector_char v,
                                             @Cast("const size_t") long n1, 
                                             @Cast("const size_t") long n2,
                                             @Cast("const size_t") long tda);

/* Operations */

public static native void gsl_matrix_char_set_zero(gsl_matrix_char m);
public static native void gsl_matrix_char_set_identity(gsl_matrix_char m);
public static native void gsl_matrix_char_set_all(gsl_matrix_char m, @Cast("char") byte x);

public static native int gsl_matrix_char_fread(FILE stream, gsl_matrix_char m);
public static native int gsl_matrix_char_fwrite(FILE stream, @Const gsl_matrix_char m);
public static native int gsl_matrix_char_fscanf(FILE stream, gsl_matrix_char m);
public static native int gsl_matrix_char_fprintf(FILE stream, @Const gsl_matrix_char m, @Cast("const char*") BytePointer format);
public static native int gsl_matrix_char_fprintf(FILE stream, @Const gsl_matrix_char m, String format);
 
public static native int gsl_matrix_char_memcpy(gsl_matrix_char dest, @Const gsl_matrix_char src);
public static native int gsl_matrix_char_swap(gsl_matrix_char m1, gsl_matrix_char m2);
public static native int gsl_matrix_char_tricpy(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_char dest, @Const gsl_matrix_char src);

public static native int gsl_matrix_char_swap_rows(gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_char_swap_columns(gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_char_swap_rowcol(gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_matrix_char_transpose(gsl_matrix_char m);
public static native int gsl_matrix_char_transpose_memcpy(gsl_matrix_char dest, @Const gsl_matrix_char src);
public static native int gsl_matrix_char_transpose_tricpy(@Cast("CBLAS_UPLO_t") int Uplo_src, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_char dest, @Const gsl_matrix_char src);

public static native @Cast("char") byte gsl_matrix_char_max(@Const gsl_matrix_char m);
public static native @Cast("char") byte gsl_matrix_char_min(@Const gsl_matrix_char m);
public static native void gsl_matrix_char_minmax(@Const gsl_matrix_char m, @Cast("char*") BytePointer min_out, @Cast("char*") BytePointer max_out);
public static native void gsl_matrix_char_minmax(@Const gsl_matrix_char m, @Cast("char*") ByteBuffer min_out, @Cast("char*") ByteBuffer max_out);
public static native void gsl_matrix_char_minmax(@Const gsl_matrix_char m, @Cast("char*") byte[] min_out, @Cast("char*") byte[] max_out);

public static native void gsl_matrix_char_max_index(@Const gsl_matrix_char m, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);
public static native void gsl_matrix_char_min_index(@Const gsl_matrix_char m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin);
public static native void gsl_matrix_char_minmax_index(@Const gsl_matrix_char m, @Cast("size_t*") SizeTPointer imin, @Cast("size_t*") SizeTPointer jmin, @Cast("size_t*") SizeTPointer imax, @Cast("size_t*") SizeTPointer jmax);

public static native int gsl_matrix_char_equal(@Const gsl_matrix_char a, @Const gsl_matrix_char b);

public static native int gsl_matrix_char_isnull(@Const gsl_matrix_char m);
public static native int gsl_matrix_char_ispos(@Const gsl_matrix_char m);
public static native int gsl_matrix_char_isneg(@Const gsl_matrix_char m);
public static native int gsl_matrix_char_isnonneg(@Const gsl_matrix_char m);



public static native int gsl_matrix_char_add(gsl_matrix_char a, @Const gsl_matrix_char b);
public static native int gsl_matrix_char_sub(gsl_matrix_char a, @Const gsl_matrix_char b);
public static native int gsl_matrix_char_mul_elements(gsl_matrix_char a, @Const gsl_matrix_char b);
public static native int gsl_matrix_char_div_elements(gsl_matrix_char a, @Const gsl_matrix_char b);
public static native int gsl_matrix_char_scale(gsl_matrix_char a, @Cast("const char") byte x);
public static native int gsl_matrix_char_scale_rows(gsl_matrix_char a, @Const gsl_vector_char x);
public static native int gsl_matrix_char_scale_columns(gsl_matrix_char a, @Const gsl_vector_char x);
public static native int gsl_matrix_char_add_constant(gsl_matrix_char a, @Cast("const char") byte x);
public static native int gsl_matrix_char_add_diagonal(gsl_matrix_char a, @Cast("const char") byte x);

/***********************************************************************/
/* The functions below are obsolete                                    */
/***********************************************************************/
public static native int gsl_matrix_char_get_row(gsl_vector_char v, @Const gsl_matrix_char m, @Cast("const size_t") long i);
public static native int gsl_matrix_char_get_col(gsl_vector_char v, @Const gsl_matrix_char m, @Cast("const size_t") long j);
public static native int gsl_matrix_char_set_row(gsl_matrix_char m, @Cast("const size_t") long i, @Const gsl_vector_char v);
public static native int gsl_matrix_char_set_col(gsl_matrix_char m, @Cast("const size_t") long j, @Const gsl_vector_char v);
/***********************************************************************/

/* inline functions if you are using GCC */

/* */ public static native @Cast("char") byte gsl_matrix_char_get(@Const gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native void gsl_matrix_char_set(gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const char") byte x);
/* */ public static native @Cast("char*") BytePointer gsl_matrix_char_ptr(gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
/* */ public static native @Cast("const char*") BytePointer gsl_matrix_char_const_ptr(@Const gsl_matrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);

// #ifdef HAVE_INLINE 

// #endif

// #endif /* __GSL_MATRIX_CHAR_H__ */


// Parsed from gsl/gsl_blas.h

/* blas/gsl_blas.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/*
 * Author:  G. Jungman
 */
// #ifndef __GSL_BLAS_H__
// #define __GSL_BLAS_H__

// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>

// #include <gsl/gsl_blas_types.h>


// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


/* ========================================================================
 * Level 1
 * ========================================================================
 */

public static native int gsl_blas_sdsdot(float alpha,
                     @Const gsl_vector_float X,
                     @Const gsl_vector_float Y,
                     FloatPointer result
                     );
public static native int gsl_blas_sdsdot(float alpha,
                     @Const gsl_vector_float X,
                     @Const gsl_vector_float Y,
                     FloatBuffer result
                     );
public static native int gsl_blas_sdsdot(float alpha,
                     @Const gsl_vector_float X,
                     @Const gsl_vector_float Y,
                     float[] result
                     );

public static native int gsl_blas_dsdot(@Const gsl_vector_float X,
                    @Const gsl_vector_float Y,
                    DoublePointer result
                    );
public static native int gsl_blas_dsdot(@Const gsl_vector_float X,
                    @Const gsl_vector_float Y,
                    DoubleBuffer result
                    );
public static native int gsl_blas_dsdot(@Const gsl_vector_float X,
                    @Const gsl_vector_float Y,
                    double[] result
                    );

public static native int gsl_blas_sdot(@Const gsl_vector_float X,
                   @Const gsl_vector_float Y,
                   FloatPointer result
                   );
public static native int gsl_blas_sdot(@Const gsl_vector_float X,
                   @Const gsl_vector_float Y,
                   FloatBuffer result
                   );
public static native int gsl_blas_sdot(@Const gsl_vector_float X,
                   @Const gsl_vector_float Y,
                   float[] result
                   );

public static native int gsl_blas_ddot(@Const gsl_vector X,
                   @Const gsl_vector Y,
                   DoublePointer result
                   );
public static native int gsl_blas_ddot(@Const gsl_vector X,
                   @Const gsl_vector Y,
                   DoubleBuffer result
                   );
public static native int gsl_blas_ddot(@Const gsl_vector X,
                   @Const gsl_vector Y,
                   double[] result
                   );


public static native int gsl_blas_cdotu(@Const gsl_vector_complex_float X,
                     @Const gsl_vector_complex_float Y,
                     gsl_complex_float dotu);

public static native int gsl_blas_cdotc(@Const gsl_vector_complex_float X,
                     @Const gsl_vector_complex_float Y,
                     gsl_complex_float dotc);

public static native int gsl_blas_zdotu(@Const gsl_vector_complex X,
                     @Const gsl_vector_complex Y,
                     gsl_complex dotu);

public static native int gsl_blas_zdotc(@Const gsl_vector_complex X,
                     @Const gsl_vector_complex Y,
                     gsl_complex dotc);


public static native float gsl_blas_snrm2(@Const gsl_vector_float X);
public static native float gsl_blas_sasum(@Const gsl_vector_float X);
public static native double gsl_blas_dnrm2(@Const gsl_vector X);
public static native double gsl_blas_dasum(@Const gsl_vector X);
public static native float gsl_blas_scnrm2(@Const gsl_vector_complex_float X);
public static native float gsl_blas_scasum(@Const gsl_vector_complex_float X);
public static native double gsl_blas_dznrm2(@Const gsl_vector_complex X);
public static native double gsl_blas_dzasum(@Const gsl_vector_complex X);


public static native @Cast("CBLAS_INDEX_t") long gsl_blas_isamax(@Const gsl_vector_float X);
public static native @Cast("CBLAS_INDEX_t") long gsl_blas_idamax(@Const gsl_vector X);
public static native @Cast("CBLAS_INDEX_t") long gsl_blas_icamax(@Const gsl_vector_complex_float X);
public static native @Cast("CBLAS_INDEX_t") long gsl_blas_izamax(@Const gsl_vector_complex X);


public static native int gsl_blas_sswap(gsl_vector_float X,
                     gsl_vector_float Y);

public static native int gsl_blas_scopy(@Const gsl_vector_float X,
                     gsl_vector_float Y);

public static native int gsl_blas_saxpy(float alpha,
                     @Const gsl_vector_float X,
                     gsl_vector_float Y);

public static native int gsl_blas_dswap(gsl_vector X,
                     gsl_vector Y);

public static native int gsl_blas_dcopy(@Const gsl_vector X,
                     gsl_vector Y);

public static native int gsl_blas_daxpy(double alpha,
                     @Const gsl_vector X,
                     gsl_vector Y);

public static native int gsl_blas_cswap(gsl_vector_complex_float X,
                     gsl_vector_complex_float Y);

public static native int gsl_blas_ccopy(@Const gsl_vector_complex_float X,
                     gsl_vector_complex_float Y);

public static native int gsl_blas_caxpy(@Const @ByVal gsl_complex_float alpha,
                     @Const gsl_vector_complex_float X,
                     gsl_vector_complex_float Y);

public static native int gsl_blas_zswap(gsl_vector_complex X,
                     gsl_vector_complex Y);

public static native int gsl_blas_zcopy(@Const gsl_vector_complex X,
                     gsl_vector_complex Y);

public static native int gsl_blas_zaxpy(@Const @ByVal gsl_complex alpha,
                     @Const gsl_vector_complex X,
                     gsl_vector_complex Y);


public static native int gsl_blas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native int gsl_blas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native int gsl_blas_srotg(float[] a, float[] b, float[] c, float[] s);

public static native int gsl_blas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native int gsl_blas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native int gsl_blas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);

public static native int gsl_blas_srot(gsl_vector_float X,
                    gsl_vector_float Y,
                    float c, float s);

public static native int gsl_blas_srotm(gsl_vector_float X,
                     gsl_vector_float Y,
                     @Const FloatPointer P);
public static native int gsl_blas_srotm(gsl_vector_float X,
                     gsl_vector_float Y,
                     @Const FloatBuffer P);
public static native int gsl_blas_srotm(gsl_vector_float X,
                     gsl_vector_float Y,
                     @Const float[] P);

public static native int gsl_blas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native int gsl_blas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native int gsl_blas_drotg(double[] a, double[] b, double[] c, double[] s);

public static native int gsl_blas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1,
                      double b2, DoublePointer P);
public static native int gsl_blas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1,
                      double b2, DoubleBuffer P);
public static native int gsl_blas_drotmg(double[] d1, double[] d2, double[] b1,
                      double b2, double[] P);

public static native int gsl_blas_drot(gsl_vector X,
                    gsl_vector Y,
                    double c, double s);

public static native int gsl_blas_drotm(gsl_vector X,
                     gsl_vector Y,
                     @Const DoublePointer P);
public static native int gsl_blas_drotm(gsl_vector X,
                     gsl_vector Y,
                     @Const DoubleBuffer P);
public static native int gsl_blas_drotm(gsl_vector X,
                     gsl_vector Y,
                     @Const double[] P);


public static native void gsl_blas_sscal(float alpha, gsl_vector_float X);
public static native void gsl_blas_dscal(double alpha, gsl_vector X);
public static native void gsl_blas_cscal(@Const @ByVal gsl_complex_float alpha, gsl_vector_complex_float X);
public static native void gsl_blas_zscal(@Const @ByVal gsl_complex alpha, gsl_vector_complex X);
public static native void gsl_blas_csscal(float alpha, gsl_vector_complex_float X);
public static native void gsl_blas_zdscal(double alpha, gsl_vector_complex X);


/* ===========================================================================
 * Level 2
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native int gsl_blas_sgemv(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     float alpha,
                     @Const gsl_matrix_float A,
                     @Const gsl_vector_float X,
                     float beta,
                     gsl_vector_float Y);

public static native int gsl_blas_strmv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_float A,
                     gsl_vector_float X);

public static native int gsl_blas_strsv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_float A,
                     gsl_vector_float X);

public static native int gsl_blas_dgemv(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     double alpha,
                     @Const gsl_matrix A,
                     @Const gsl_vector X,
                     double beta,
                     gsl_vector Y);

public static native int gsl_blas_dtrmv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix A,
                     gsl_vector X);

public static native int gsl_blas_dtrsv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix A,
                     gsl_vector X);

public static native int gsl_blas_cgemv(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const gsl_vector_complex_float X,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_vector_complex_float Y);

public static native int gsl_blas_ctrmv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_complex_float A,
                     gsl_vector_complex_float X);

public static native int gsl_blas_ctrsv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_complex_float A,
                     gsl_vector_complex_float X);

public static native int gsl_blas_zgemv(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const gsl_vector_complex X,
                     @Const @ByVal gsl_complex beta,
                     gsl_vector_complex Y);

public static native int gsl_blas_ztrmv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_complex A,
                     gsl_vector_complex X);

public static native int gsl_blas_ztrsv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int TransA, @Cast("CBLAS_DIAG_t") int Diag,
                     @Const gsl_matrix_complex A,
                     gsl_vector_complex X);

/*
 * Routines with S and D prefixes only
 */
public static native int gsl_blas_ssymv(@Cast("CBLAS_UPLO_t") int Uplo,
                     float alpha,
                     @Const gsl_matrix_float A,
                     @Const gsl_vector_float X,
                     float beta,
                     gsl_vector_float Y);

public static native int gsl_blas_sger(float alpha,
                    @Const gsl_vector_float X,
                    @Const gsl_vector_float Y,
                    gsl_matrix_float A);

public static native int gsl_blas_ssyr(@Cast("CBLAS_UPLO_t") int Uplo,
                    float alpha,
                    @Const gsl_vector_float X,
                    gsl_matrix_float A);

public static native int gsl_blas_ssyr2(@Cast("CBLAS_UPLO_t") int Uplo,
                     float alpha,
                     @Const gsl_vector_float X,
                     @Const gsl_vector_float Y,
                     gsl_matrix_float A);

public static native int gsl_blas_dsymv(@Cast("CBLAS_UPLO_t") int Uplo,
                     double alpha,
                     @Const gsl_matrix A,
                     @Const gsl_vector X,
                     double beta,
                     gsl_vector Y);
public static native int gsl_blas_dger(double alpha,
                    @Const gsl_vector X,
                    @Const gsl_vector Y,
                    gsl_matrix A);

public static native int gsl_blas_dsyr(@Cast("CBLAS_UPLO_t") int Uplo,
                    double alpha,
                    @Const gsl_vector X,
                    gsl_matrix A);

public static native int gsl_blas_dsyr2(@Cast("CBLAS_UPLO_t") int Uplo,
                     double alpha,
                     @Const gsl_vector X,
                     @Const gsl_vector Y,
                     gsl_matrix A);

/*
 * Routines with C and Z prefixes only
 */

public static native int gsl_blas_chemv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const gsl_vector_complex_float X,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_vector_complex_float Y);

public static native int gsl_blas_cgeru(@Const @ByVal gsl_complex_float alpha,
                     @Const gsl_vector_complex_float X,
                     @Const gsl_vector_complex_float Y,
                     gsl_matrix_complex_float A);

public static native int gsl_blas_cgerc(@Const @ByVal gsl_complex_float alpha,
                     @Const gsl_vector_complex_float X,
                     @Const gsl_vector_complex_float Y,
                     gsl_matrix_complex_float A);

public static native int gsl_blas_cher(@Cast("CBLAS_UPLO_t") int Uplo,
                    float alpha,
                    @Const gsl_vector_complex_float X,
                    gsl_matrix_complex_float A);

public static native int gsl_blas_cher2(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_vector_complex_float X,
                     @Const gsl_vector_complex_float Y,
                     gsl_matrix_complex_float A);

public static native int gsl_blas_zhemv(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const gsl_vector_complex X,
                     @Const @ByVal gsl_complex beta,
                     gsl_vector_complex Y);

public static native int gsl_blas_zgeru(@Const @ByVal gsl_complex alpha,
                     @Const gsl_vector_complex X,
                     @Const gsl_vector_complex Y,
                     gsl_matrix_complex A);

public static native int gsl_blas_zgerc(@Const @ByVal gsl_complex alpha,
                     @Const gsl_vector_complex X,
                     @Const gsl_vector_complex Y,
                     gsl_matrix_complex A);

public static native int gsl_blas_zher(@Cast("CBLAS_UPLO_t") int Uplo,
                    double alpha,
                    @Const gsl_vector_complex X,
                    gsl_matrix_complex A);

public static native int gsl_blas_zher2(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_vector_complex X,
                     @Const gsl_vector_complex Y,
                     gsl_matrix_complex A);

/*
 * ===========================================================================
 * Prototypes for level 3 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native int gsl_blas_sgemm(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_TRANSPOSE_t") int TransB,
                     float alpha,
                     @Const gsl_matrix_float A,
                     @Const gsl_matrix_float B,
                     float beta,
                     gsl_matrix_float C);

public static native int gsl_blas_ssymm(@Cast("CBLAS_SIDE_t") int Side, @Cast("CBLAS_UPLO_t") int Uplo,
                     float alpha,
                     @Const gsl_matrix_float A,
                     @Const gsl_matrix_float B,
                     float beta,
                     gsl_matrix_float C);

public static native int gsl_blas_ssyrk(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     float alpha,
                     @Const gsl_matrix_float A,
                     float beta,
                     gsl_matrix_float C);

public static native int gsl_blas_ssyr2k(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      float alpha,
                      @Const gsl_matrix_float A,
                      @Const gsl_matrix_float B,
                      float beta,
                      gsl_matrix_float C);

public static native int gsl_blas_strmm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     float alpha,
                     @Const gsl_matrix_float A,
                     gsl_matrix_float B);

public static native int gsl_blas_strsm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     float alpha,
                     @Const gsl_matrix_float A,
                     gsl_matrix_float B);

public static native int gsl_blas_dgemm(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_TRANSPOSE_t") int TransB,
                     double alpha,
                     @Const gsl_matrix A,
                     @Const gsl_matrix B,
                     double beta,
                     gsl_matrix C);

public static native int gsl_blas_dsymm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo,
                     double alpha,
                     @Const gsl_matrix A,
                     @Const gsl_matrix B,
                     double beta,
                     gsl_matrix C);

public static native int gsl_blas_dsyrk(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     double alpha,
                     @Const gsl_matrix A,
                     double beta,
                     gsl_matrix C);

public static native int gsl_blas_dsyr2k(@Cast("CBLAS_UPLO_t") int Uplo,
                      @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      double alpha,
                      @Const gsl_matrix A,
                      @Const gsl_matrix B,
                      double beta,
                      gsl_matrix C);

public static native int gsl_blas_dtrmm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     double alpha,
                     @Const gsl_matrix A,
                     gsl_matrix B);

public static native int gsl_blas_dtrsm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     double alpha,
                     @Const gsl_matrix A,
                     gsl_matrix B);

public static native int gsl_blas_cgemm(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_TRANSPOSE_t") int TransB,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const gsl_matrix_complex_float B,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_matrix_complex_float C);

public static native int gsl_blas_csymm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const gsl_matrix_complex_float B,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_matrix_complex_float C);

public static native int gsl_blas_csyrk(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_matrix_complex_float C);

public static native int gsl_blas_csyr2k(@Cast("CBLAS_UPLO_t") int Uplo,
                      @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      @Const @ByVal gsl_complex_float alpha,
                      @Const gsl_matrix_complex_float A,
                      @Const gsl_matrix_complex_float B,
                      @Const @ByVal gsl_complex_float beta,
                      gsl_matrix_complex_float C);

public static native int gsl_blas_ctrmm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     gsl_matrix_complex_float B);

public static native int gsl_blas_ctrsm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     gsl_matrix_complex_float B);

public static native int gsl_blas_zgemm(@Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_TRANSPOSE_t") int TransB,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const gsl_matrix_complex B,
                     @Const @ByVal gsl_complex beta,
                     gsl_matrix_complex C);

public static native int gsl_blas_zsymm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const gsl_matrix_complex B,
                     @Const @ByVal gsl_complex beta,
                     gsl_matrix_complex C);

public static native int gsl_blas_zsyrk(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const @ByVal gsl_complex beta,
                     gsl_matrix_complex C);

public static native int gsl_blas_zsyr2k(@Cast("CBLAS_UPLO_t") int Uplo,
                      @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      @Const @ByVal gsl_complex alpha,
                      @Const gsl_matrix_complex A,
                      @Const gsl_matrix_complex B,
                      @Const @ByVal gsl_complex beta,
                      gsl_matrix_complex C);

public static native int gsl_blas_ztrmm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     gsl_matrix_complex B);

public static native int gsl_blas_ztrsm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_TRANSPOSE_t") int TransA,
                     @Cast("CBLAS_DIAG_t") int Diag,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     gsl_matrix_complex B);

/*
 * Routines with prefixes C and Z only
 */
public static native int gsl_blas_chemm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex_float alpha,
                     @Const gsl_matrix_complex_float A,
                     @Const gsl_matrix_complex_float B,
                     @Const @ByVal gsl_complex_float beta,
                     gsl_matrix_complex_float C);

public static native int gsl_blas_cherk(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     float alpha,
                     @Const gsl_matrix_complex_float A,
                     float beta,
                     gsl_matrix_complex_float C);

public static native int gsl_blas_cher2k(@Cast("CBLAS_UPLO_t") int Uplo,
                      @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      @Const @ByVal gsl_complex_float alpha,
                      @Const gsl_matrix_complex_float A,
                      @Const gsl_matrix_complex_float B,
                      float beta,
                      gsl_matrix_complex_float C);

public static native int gsl_blas_zhemm(@Cast("CBLAS_SIDE_t") int Side,
                     @Cast("CBLAS_UPLO_t") int Uplo,
                     @Const @ByVal gsl_complex alpha,
                     @Const gsl_matrix_complex A,
                     @Const gsl_matrix_complex B,
                     @Const @ByVal gsl_complex beta,
                     gsl_matrix_complex C);

public static native int gsl_blas_zherk(@Cast("CBLAS_UPLO_t") int Uplo,
                     @Cast("CBLAS_TRANSPOSE_t") int Trans,
                     double alpha,
                     @Const gsl_matrix_complex A,
                     double beta,
                     gsl_matrix_complex C);

public static native int gsl_blas_zher2k(@Cast("CBLAS_UPLO_t") int Uplo,
                      @Cast("CBLAS_TRANSPOSE_t") int Trans,
                      @Const @ByVal gsl_complex alpha,
                      @Const gsl_matrix_complex A,
                      @Const gsl_matrix_complex B,
                      double beta,
                      gsl_matrix_complex C);

// #endif /* __GSL_BLAS_H__ */


// Parsed from gsl/gsl_bspline.h

/* bspline/gsl_bspline.h
 *
 * Copyright (C) 2006 Patrick Alken
 * Copyright (C) 2008 Rhys Ulerich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BSPLINE_H__
// #define __GSL_BSPLINE_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_bspline_workspace.java



public static native gsl_bspline_workspace gsl_bspline_alloc(@Cast("const size_t") long k, @Cast("const size_t") long nbreak);

public static native void gsl_bspline_free(gsl_bspline_workspace w);

public static native @Cast("size_t") long gsl_bspline_ncoeffs(gsl_bspline_workspace w);
public static native @Cast("size_t") long gsl_bspline_order(gsl_bspline_workspace w);
public static native @Cast("size_t") long gsl_bspline_nbreak(gsl_bspline_workspace w);
public static native double gsl_bspline_breakpoint(@Cast("size_t") long i, gsl_bspline_workspace w);
public static native double gsl_bspline_greville_abscissa(@Cast("size_t") long i, gsl_bspline_workspace w);

public static native int gsl_bspline_knots(@Const gsl_vector breakpts, gsl_bspline_workspace w);

public static native int gsl_bspline_knots_uniform(double a, double b,
                              gsl_bspline_workspace w);

public static native int gsl_bspline_knots_greville(@Const gsl_vector abscissae,
                           gsl_bspline_workspace w,
                           DoublePointer abserr);
public static native int gsl_bspline_knots_greville(@Const gsl_vector abscissae,
                           gsl_bspline_workspace w,
                           DoubleBuffer abserr);
public static native int gsl_bspline_knots_greville(@Const gsl_vector abscissae,
                           gsl_bspline_workspace w,
                           double[] abserr);

public static native int gsl_bspline_eval(double x, gsl_vector B, 
                 gsl_bspline_workspace w);

public static native int gsl_bspline_eval_nonzero(double x,
                         gsl_vector Bk,
                         @Cast("size_t*") SizeTPointer istart,
                         @Cast("size_t*") SizeTPointer iend,
                         gsl_bspline_workspace w);

public static native int gsl_bspline_deriv_eval(double x,
                       @Cast("const size_t") long nderiv,
                       gsl_matrix dB,
                       gsl_bspline_workspace w);

public static native int gsl_bspline_deriv_eval_nonzero(double x,
                               @Cast("const size_t") long nderiv,
                               gsl_matrix dB,
                               @Cast("size_t*") SizeTPointer istart,
                               @Cast("size_t*") SizeTPointer iend,
                               gsl_bspline_workspace w);

// #endif /* __GSL_BSPLINE_H__ */


// Parsed from gsl/gsl_cdf.h

/* cdf/gsl_cdf.h
 * 
 * Copyright (C) 2002 Jason H. Stover.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  J. Stover */

// #ifndef __GSL_CDF_H__
// #define __GSL_CDF_H__

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif 

public static native double gsl_cdf_ugaussian_P(double x);
public static native double gsl_cdf_ugaussian_Q(double x);

public static native double gsl_cdf_ugaussian_Pinv(double P);
public static native double gsl_cdf_ugaussian_Qinv(double Q);

public static native double gsl_cdf_gaussian_P(double x, double sigma);
public static native double gsl_cdf_gaussian_Q(double x, double sigma);

public static native double gsl_cdf_gaussian_Pinv(double P, double sigma);
public static native double gsl_cdf_gaussian_Qinv(double Q, double sigma);

public static native double gsl_cdf_gamma_P(double x, double a, double b);
public static native double gsl_cdf_gamma_Q(double x, double a, double b);

public static native double gsl_cdf_gamma_Pinv(double P, double a, double b);
public static native double gsl_cdf_gamma_Qinv(double Q, double a, double b);

public static native double gsl_cdf_cauchy_P(double x, double a);
public static native double gsl_cdf_cauchy_Q(double x, double a);

public static native double gsl_cdf_cauchy_Pinv(double P, double a);
public static native double gsl_cdf_cauchy_Qinv(double Q, double a);

public static native double gsl_cdf_laplace_P(double x, double a);
public static native double gsl_cdf_laplace_Q(double x, double a);

public static native double gsl_cdf_laplace_Pinv(double P, double a);
public static native double gsl_cdf_laplace_Qinv(double Q, double a);

public static native double gsl_cdf_rayleigh_P(double x, double sigma);
public static native double gsl_cdf_rayleigh_Q(double x, double sigma);

public static native double gsl_cdf_rayleigh_Pinv(double P, double sigma);
public static native double gsl_cdf_rayleigh_Qinv(double Q, double sigma);

public static native double gsl_cdf_chisq_P(double x, double nu);
public static native double gsl_cdf_chisq_Q(double x, double nu);

public static native double gsl_cdf_chisq_Pinv(double P, double nu);
public static native double gsl_cdf_chisq_Qinv(double Q, double nu);

public static native double gsl_cdf_exponential_P(double x, double mu);
public static native double gsl_cdf_exponential_Q(double x, double mu);

public static native double gsl_cdf_exponential_Pinv(double P, double mu);
public static native double gsl_cdf_exponential_Qinv(double Q, double mu);

public static native double gsl_cdf_exppow_P(double x, double a, double b);
public static native double gsl_cdf_exppow_Q(double x, double a, double b);

public static native double gsl_cdf_tdist_P(double x, double nu);
public static native double gsl_cdf_tdist_Q(double x, double nu);

public static native double gsl_cdf_tdist_Pinv(double P, double nu);
public static native double gsl_cdf_tdist_Qinv(double Q, double nu);

public static native double gsl_cdf_fdist_P(double x, double nu1, double nu2);
public static native double gsl_cdf_fdist_Q(double x, double nu1, double nu2);

public static native double gsl_cdf_fdist_Pinv(double P, double nu1, double nu2);
public static native double gsl_cdf_fdist_Qinv(double Q, double nu1, double nu2);

public static native double gsl_cdf_beta_P(double x, double a, double b);
public static native double gsl_cdf_beta_Q(double x, double a, double b);

public static native double gsl_cdf_beta_Pinv(double P, double a, double b);
public static native double gsl_cdf_beta_Qinv(double Q, double a, double b);

public static native double gsl_cdf_flat_P(double x, double a, double b);
public static native double gsl_cdf_flat_Q(double x, double a, double b);

public static native double gsl_cdf_flat_Pinv(double P, double a, double b);
public static native double gsl_cdf_flat_Qinv(double Q, double a, double b);

public static native double gsl_cdf_lognormal_P(double x, double zeta, double sigma);
public static native double gsl_cdf_lognormal_Q(double x, double zeta, double sigma);

public static native double gsl_cdf_lognormal_Pinv(double P, double zeta, double sigma);
public static native double gsl_cdf_lognormal_Qinv(double Q, double zeta, double sigma);

public static native double gsl_cdf_gumbel1_P(double x, double a, double b);
public static native double gsl_cdf_gumbel1_Q(double x, double a, double b);

public static native double gsl_cdf_gumbel1_Pinv(double P, double a, double b);
public static native double gsl_cdf_gumbel1_Qinv(double Q, double a, double b);

public static native double gsl_cdf_gumbel2_P(double x, double a, double b);
public static native double gsl_cdf_gumbel2_Q(double x, double a, double b);

public static native double gsl_cdf_gumbel2_Pinv(double P, double a, double b);
public static native double gsl_cdf_gumbel2_Qinv(double Q, double a, double b);

public static native double gsl_cdf_weibull_P(double x, double a, double b);
public static native double gsl_cdf_weibull_Q(double x, double a, double b);

public static native double gsl_cdf_weibull_Pinv(double P, double a, double b);
public static native double gsl_cdf_weibull_Qinv(double Q, double a, double b);

public static native double gsl_cdf_pareto_P(double x, double a, double b);
public static native double gsl_cdf_pareto_Q(double x, double a, double b);

public static native double gsl_cdf_pareto_Pinv(double P, double a, double b);
public static native double gsl_cdf_pareto_Qinv(double Q, double a, double b);

public static native double gsl_cdf_logistic_P(double x, double a);
public static native double gsl_cdf_logistic_Q(double x, double a);

public static native double gsl_cdf_logistic_Pinv(double P, double a);
public static native double gsl_cdf_logistic_Qinv(double Q, double a);

public static native double gsl_cdf_binomial_P(@Cast("const unsigned int") int k, double p, @Cast("const unsigned int") int n);
public static native double gsl_cdf_binomial_Q(@Cast("const unsigned int") int k, double p, @Cast("const unsigned int") int n);

public static native double gsl_cdf_poisson_P(@Cast("const unsigned int") int k, double mu);
public static native double gsl_cdf_poisson_Q(@Cast("const unsigned int") int k, double mu);

public static native double gsl_cdf_geometric_P(@Cast("const unsigned int") int k, double p);
public static native double gsl_cdf_geometric_Q(@Cast("const unsigned int") int k, double p);

public static native double gsl_cdf_negative_binomial_P(@Cast("const unsigned int") int k, double p, double n);
public static native double gsl_cdf_negative_binomial_Q(@Cast("const unsigned int") int k, double p, double n);

public static native double gsl_cdf_pascal_P(@Cast("const unsigned int") int k, double p, @Cast("const unsigned int") int n);
public static native double gsl_cdf_pascal_Q(@Cast("const unsigned int") int k, double p, @Cast("const unsigned int") int n);

public static native double gsl_cdf_hypergeometric_P(@Cast("const unsigned int") int k, @Cast("const unsigned int") int n1,
                                 @Cast("const unsigned int") int n2, @Cast("const unsigned int") int t);
public static native double gsl_cdf_hypergeometric_Q(@Cast("const unsigned int") int k, @Cast("const unsigned int") int n1,
                                 @Cast("const unsigned int") int n2, @Cast("const unsigned int") int t);

// #endif /* __GSL_CDF_H__ */


// Parsed from gsl/gsl_chebyshev.h

/* cheb/gsl_chebyshev.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CHEBYSHEV_H__
// #define __GSL_CHEBYSHEV_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_mode.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_cheb_series.java




/* Calculate a Chebyshev series of specified order over
 * a specified interval, for a given function.
 * Return 0 on failure.
 */
public static native gsl_cheb_series gsl_cheb_alloc(@Cast("const size_t") long order);

/* Free a Chebyshev series previously calculated with gsl_cheb_alloc().
 */
public static native void gsl_cheb_free(gsl_cheb_series cs);

/* Calculate a Chebyshev series using the storage provided.
 * Uses the interval (a,b) and the order with which it
 * was initially created.
 *
 */
public static native int gsl_cheb_init(gsl_cheb_series cs, @Const gsl_function func,
                  double a, double b);

/* Return the order, size of coefficient array and coefficient array ptr */
public static native @Cast("size_t") long gsl_cheb_order(@Const gsl_cheb_series cs);
public static native @Cast("size_t") long gsl_cheb_size(@Const gsl_cheb_series cs);
public static native DoublePointer gsl_cheb_coeffs(@Const gsl_cheb_series cs);

/* Evaluate a Chebyshev series at a given point.
 * No errors can occur for a struct obtained from gsl_cheb_new().
 */
public static native double gsl_cheb_eval(@Const gsl_cheb_series cs, double x);
public static native int gsl_cheb_eval_err(@Const gsl_cheb_series cs, double x, 
                      DoublePointer result, DoublePointer abserr);
public static native int gsl_cheb_eval_err(@Const gsl_cheb_series cs, double x, 
                      DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_cheb_eval_err(@Const gsl_cheb_series cs, double x, 
                      double[] result, double[] abserr);


/* Evaluate a Chebyshev series at a given point, to (at most) the given order.
 * No errors can occur for a struct obtained from gsl_cheb_new().
 */
public static native double gsl_cheb_eval_n(@Const gsl_cheb_series cs, @Cast("const size_t") long order, 
                       double x);
public static native int gsl_cheb_eval_n_err(@Const gsl_cheb_series cs, @Cast("const size_t") long order, 
                        double x, DoublePointer result, DoublePointer abserr);
public static native int gsl_cheb_eval_n_err(@Const gsl_cheb_series cs, @Cast("const size_t") long order, 
                        double x, DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_cheb_eval_n_err(@Const gsl_cheb_series cs, @Cast("const size_t") long order, 
                        double x, double[] result, double[] abserr);


/* Evaluate a Chebyshev series at a given point, using the default
 * order for double precision mode(s) and the single precision
 * order for other modes.
 * No errors can occur for a struct obtained from gsl_cheb_new().
 */
public static native double gsl_cheb_eval_mode(@Const gsl_cheb_series cs, double x, @Cast("gsl_mode_t") int mode);
public static native int gsl_cheb_eval_mode_e(@Const gsl_cheb_series cs, double x, @Cast("gsl_mode_t") int mode, DoublePointer result, DoublePointer abserr);
public static native int gsl_cheb_eval_mode_e(@Const gsl_cheb_series cs, double x, @Cast("gsl_mode_t") int mode, DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_cheb_eval_mode_e(@Const gsl_cheb_series cs, double x, @Cast("gsl_mode_t") int mode, double[] result, double[] abserr);



/* Compute the derivative of a Chebyshev series.
 */
public static native int gsl_cheb_calc_deriv(gsl_cheb_series deriv, @Const gsl_cheb_series cs);

/* Compute the integral of a Chebyshev series. The
 * integral is fixed by the condition that it equals zero at
 * the left end-point, ie it is precisely
 *       Integrate[cs(t; a,b), {t, a, x}]
 */
public static native int gsl_cheb_calc_integ(gsl_cheb_series integ, @Const gsl_cheb_series cs);

// #endif /* __GSL_CHEBYSHEV_H__ */


// Parsed from gsl/gsl_combination.h

/* combination/gsl_combination.h
 * based on permutation/gsl_permutation.h by Brian Gough
 * 
 * Copyright (C) 2001 Szymon Jaroszewicz
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_COMBINATION_H__
// #define __GSL_COMBINATION_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_combination.java



public static native gsl_combination gsl_combination_alloc(@Cast("const size_t") long n, @Cast("const size_t") long k);
public static native gsl_combination gsl_combination_calloc(@Cast("const size_t") long n, @Cast("const size_t") long k);
public static native void gsl_combination_init_first(gsl_combination c);
public static native void gsl_combination_init_last(gsl_combination c);
public static native void gsl_combination_free(gsl_combination c);
public static native int gsl_combination_memcpy(gsl_combination dest, @Const gsl_combination src); 

public static native int gsl_combination_fread(FILE stream, gsl_combination c);
public static native int gsl_combination_fwrite(FILE stream, @Const gsl_combination c);
public static native int gsl_combination_fscanf(FILE stream, gsl_combination c);
public static native int gsl_combination_fprintf(FILE stream, @Const gsl_combination c, @Cast("const char*") BytePointer format);
public static native int gsl_combination_fprintf(FILE stream, @Const gsl_combination c, String format);

public static native @Cast("size_t") long gsl_combination_n(@Const gsl_combination c);
public static native @Cast("size_t") long gsl_combination_k(@Const gsl_combination c);
public static native @Cast("size_t*") SizeTPointer gsl_combination_data(@Const gsl_combination c);

public static native int gsl_combination_valid(gsl_combination c);
public static native int gsl_combination_next(gsl_combination c);
public static native int gsl_combination_prev(gsl_combination c);

/* */ public static native @Cast("size_t") long gsl_combination_get(@Const gsl_combination c, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE

// #endif /* HAVE_INLINE */

// #endif /* __GSL_COMBINATION_H__ */


// Parsed from gsl/gsl_deriv.h

/* deriv/gsl_deriv.h
 * 
 * Copyright (C) 2000 David Morrison
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_DERIV_H__
// #define __GSL_DERIV_H__
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_deriv_central(@Const gsl_function f,
                       double x, double h,
                       DoublePointer result, DoublePointer abserr);
public static native int gsl_deriv_central(@Const gsl_function f,
                       double x, double h,
                       DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_deriv_central(@Const gsl_function f,
                       double x, double h,
                       double[] result, double[] abserr);

public static native int gsl_deriv_backward(@Const gsl_function f,
                        double x, double h,
                        DoublePointer result, DoublePointer abserr);
public static native int gsl_deriv_backward(@Const gsl_function f,
                        double x, double h,
                        DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_deriv_backward(@Const gsl_function f,
                        double x, double h,
                        double[] result, double[] abserr);

public static native int gsl_deriv_forward(@Const gsl_function f,
                       double x, double h,
                       DoublePointer result, DoublePointer abserr);
public static native int gsl_deriv_forward(@Const gsl_function f,
                       double x, double h,
                       DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_deriv_forward(@Const gsl_function f,
                       double x, double h,
                       double[] result, double[] abserr);

// #endif /* __GSL_DERIV_H__ */


// Parsed from gsl/gsl_dht.h

/* dht/gsl_dht.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  G. Jungman
 */
// #ifndef __GSL_DHT_H__
// #define __GSL_DHT_H__

// #include <stdlib.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_dht.java




/* Create a new transform object for a given size
 * sampling array on the domain [0, xmax].
 */
public static native gsl_dht gsl_dht_alloc(@Cast("size_t") long size);
public static native gsl_dht gsl_dht_new(@Cast("size_t") long size, double nu, double xmax);

/* Recalculate a transform object for given values of nu, xmax.
 * You cannot change the size of the object since the internal
 * allocation is reused.
 */
public static native int gsl_dht_init(gsl_dht t, double nu, double xmax);

/* The n'th computed x sample point for a given transform.
 * 0 <= n <= size-1
 */
public static native double gsl_dht_x_sample(@Const gsl_dht t, int n);


/* The n'th computed k sample point for a given transform.
 * 0 <= n <= size-1
 */
public static native double gsl_dht_k_sample(@Const gsl_dht t, int n);


/* Free a transform object.
 */
public static native void gsl_dht_free(gsl_dht t);


/* Perform a transform on a sampled array.
 * f_in[0] ... f_in[size-1] and similarly for f_out[]
 */
public static native int gsl_dht_apply(@Const gsl_dht t, DoublePointer f_in, DoublePointer f_out);
public static native int gsl_dht_apply(@Const gsl_dht t, DoubleBuffer f_in, DoubleBuffer f_out);
public static native int gsl_dht_apply(@Const gsl_dht t, double[] f_in, double[] f_out);

// #endif /* __GSL_DHT_H__ */


// Parsed from gsl/gsl_diff.h

/* diff/gsl_diff.h
 * 
 * Copyright (C) 2000 David Morrison
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_DIFF_H__
// #define __GSL_DIFF_H__
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

// #ifndef GSL_DISABLE_DEPRECATED
public static native int gsl_diff_central(@Const gsl_function f,
                      double x,
                      DoublePointer result, DoublePointer abserr);
public static native int gsl_diff_central(@Const gsl_function f,
                      double x,
                      DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_diff_central(@Const gsl_function f,
                      double x,
                      double[] result, double[] abserr);

public static native int gsl_diff_backward(@Const gsl_function f,
                       double x,
                       DoublePointer result, DoublePointer abserr);
public static native int gsl_diff_backward(@Const gsl_function f,
                       double x,
                       DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_diff_backward(@Const gsl_function f,
                       double x,
                       double[] result, double[] abserr);

public static native int gsl_diff_forward(@Const gsl_function f,
                      double x,
                      DoublePointer result, DoublePointer abserr);
public static native int gsl_diff_forward(@Const gsl_function f,
                      double x,
                      DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_diff_forward(@Const gsl_function f,
                      double x,
                      double[] result, double[] abserr);
// #endif

// #endif /* __GSL_DIFF_H__ */


// Parsed from gsl/gsl_eigen.h

/* eigen/gsl_eigen.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2006, 2007 Gerard Jungman, Brian Gough, Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_EIGEN_H__
// #define __GSL_EIGEN_H__

// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_eigen_symm_workspace.java



public static native gsl_eigen_symm_workspace gsl_eigen_symm_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_symm_free(gsl_eigen_symm_workspace w);
public static native int gsl_eigen_symm(gsl_matrix A, gsl_vector eval, gsl_eigen_symm_workspace w);
// Targeting ../gsl_eigen_symmv_workspace.java



public static native gsl_eigen_symmv_workspace gsl_eigen_symmv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_symmv_free(gsl_eigen_symmv_workspace w);
public static native int gsl_eigen_symmv(gsl_matrix A, gsl_vector eval, gsl_matrix evec, gsl_eigen_symmv_workspace w);
// Targeting ../gsl_eigen_herm_workspace.java



public static native gsl_eigen_herm_workspace gsl_eigen_herm_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_herm_free(gsl_eigen_herm_workspace w);
public static native int gsl_eigen_herm(gsl_matrix_complex A, gsl_vector eval,
                         gsl_eigen_herm_workspace w);
// Targeting ../gsl_eigen_hermv_workspace.java



public static native gsl_eigen_hermv_workspace gsl_eigen_hermv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_hermv_free(gsl_eigen_hermv_workspace w);
public static native int gsl_eigen_hermv(gsl_matrix_complex A, gsl_vector eval, 
                           gsl_matrix_complex evec,
                           gsl_eigen_hermv_workspace w);
// Targeting ../gsl_eigen_francis_workspace.java



public static native gsl_eigen_francis_workspace gsl_eigen_francis_alloc();
public static native void gsl_eigen_francis_free(gsl_eigen_francis_workspace w);
public static native void gsl_eigen_francis_T(int compute_t,
                          gsl_eigen_francis_workspace w);
public static native int gsl_eigen_francis(gsl_matrix H, gsl_vector_complex eval,
                       gsl_eigen_francis_workspace w);
public static native int gsl_eigen_francis_Z(gsl_matrix H, gsl_vector_complex eval,
                         gsl_matrix Z,
                         gsl_eigen_francis_workspace w);
// Targeting ../gsl_eigen_nonsymm_workspace.java



public static native gsl_eigen_nonsymm_workspace gsl_eigen_nonsymm_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_nonsymm_free(gsl_eigen_nonsymm_workspace w);
public static native void gsl_eigen_nonsymm_params(int compute_t, int balance,
                               gsl_eigen_nonsymm_workspace w);
public static native int gsl_eigen_nonsymm(gsl_matrix A, gsl_vector_complex eval,
                       gsl_eigen_nonsymm_workspace w);
public static native int gsl_eigen_nonsymm_Z(gsl_matrix A, gsl_vector_complex eval,
                         gsl_matrix Z, gsl_eigen_nonsymm_workspace w);
// Targeting ../gsl_eigen_nonsymmv_workspace.java



public static native gsl_eigen_nonsymmv_workspace gsl_eigen_nonsymmv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_nonsymmv_free(gsl_eigen_nonsymmv_workspace w);
public static native void gsl_eigen_nonsymmv_params(int balance,
                                gsl_eigen_nonsymmv_workspace w);
public static native int gsl_eigen_nonsymmv(gsl_matrix A, gsl_vector_complex eval,
                        gsl_matrix_complex evec,
                        gsl_eigen_nonsymmv_workspace w);
public static native int gsl_eigen_nonsymmv_Z(gsl_matrix A, gsl_vector_complex eval,
                          gsl_matrix_complex evec, gsl_matrix Z,
                          gsl_eigen_nonsymmv_workspace w);
// Targeting ../gsl_eigen_gensymm_workspace.java



public static native gsl_eigen_gensymm_workspace gsl_eigen_gensymm_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_gensymm_free(gsl_eigen_gensymm_workspace w);
public static native int gsl_eigen_gensymm(gsl_matrix A, gsl_matrix B,
                       gsl_vector eval, gsl_eigen_gensymm_workspace w);
public static native int gsl_eigen_gensymm_standardize(gsl_matrix A, @Const gsl_matrix B);
// Targeting ../gsl_eigen_gensymmv_workspace.java



public static native gsl_eigen_gensymmv_workspace gsl_eigen_gensymmv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_gensymmv_free(gsl_eigen_gensymmv_workspace w);
public static native int gsl_eigen_gensymmv(gsl_matrix A, gsl_matrix B,
                        gsl_vector eval, gsl_matrix evec,
                        gsl_eigen_gensymmv_workspace w);
// Targeting ../gsl_eigen_genherm_workspace.java



public static native gsl_eigen_genherm_workspace gsl_eigen_genherm_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_genherm_free(gsl_eigen_genherm_workspace w);
public static native int gsl_eigen_genherm(gsl_matrix_complex A, gsl_matrix_complex B,
                       gsl_vector eval, gsl_eigen_genherm_workspace w);
public static native int gsl_eigen_genherm_standardize(gsl_matrix_complex A,
                                   @Const gsl_matrix_complex B);
// Targeting ../gsl_eigen_genhermv_workspace.java



public static native gsl_eigen_genhermv_workspace gsl_eigen_genhermv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_genhermv_free(gsl_eigen_genhermv_workspace w);
public static native int gsl_eigen_genhermv(gsl_matrix_complex A, gsl_matrix_complex B,
                        gsl_vector eval, gsl_matrix_complex evec,
                        gsl_eigen_genhermv_workspace w);
// Targeting ../gsl_eigen_gen_workspace.java



public static native gsl_eigen_gen_workspace gsl_eigen_gen_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_gen_free(gsl_eigen_gen_workspace w);
public static native void gsl_eigen_gen_params(int compute_s, int compute_t,
                           int balance, gsl_eigen_gen_workspace w);
public static native int gsl_eigen_gen(gsl_matrix A, gsl_matrix B,
                   gsl_vector_complex alpha, gsl_vector beta,
                   gsl_eigen_gen_workspace w);
public static native int gsl_eigen_gen_QZ(gsl_matrix A, gsl_matrix B,
                      gsl_vector_complex alpha, gsl_vector beta,
                      gsl_matrix Q, gsl_matrix Z,
                      gsl_eigen_gen_workspace w);
// Targeting ../gsl_eigen_genv_workspace.java



public static native gsl_eigen_genv_workspace gsl_eigen_genv_alloc(@Cast("const size_t") long n);
public static native void gsl_eigen_genv_free(gsl_eigen_genv_workspace w);
public static native int gsl_eigen_genv(gsl_matrix A, gsl_matrix B,
                    gsl_vector_complex alpha, gsl_vector beta,
                    gsl_matrix_complex evec,
                    gsl_eigen_genv_workspace w);
public static native int gsl_eigen_genv_QZ(gsl_matrix A, gsl_matrix B,
                       gsl_vector_complex alpha, gsl_vector beta,
                       gsl_matrix_complex evec,
                       gsl_matrix Q, gsl_matrix Z,
                       gsl_eigen_genv_workspace w);



/** enum gsl_eigen_sort_t */
public static final int
  GSL_EIGEN_SORT_VAL_ASC = 0,
  GSL_EIGEN_SORT_VAL_DESC = 1,
  GSL_EIGEN_SORT_ABS_ASC = 2,
  GSL_EIGEN_SORT_ABS_DESC = 3;

/* Sort eigensystem results based on eigenvalues.
 * Sorts in order of increasing value or increasing
 * absolute value.
 *
 * exceptions: GSL_EBADLEN
 */

public static native int gsl_eigen_symmv_sort(gsl_vector eval, gsl_matrix evec,
                         @Cast("gsl_eigen_sort_t") int sort_type);

public static native int gsl_eigen_hermv_sort(gsl_vector eval, gsl_matrix_complex evec,
                         @Cast("gsl_eigen_sort_t") int sort_type);

public static native int gsl_eigen_nonsymmv_sort(gsl_vector_complex eval,
                            gsl_matrix_complex evec,
                            @Cast("gsl_eigen_sort_t") int sort_type);

public static native int gsl_eigen_gensymmv_sort(gsl_vector eval, gsl_matrix evec, 
                             @Cast("gsl_eigen_sort_t") int sort_type);

public static native int gsl_eigen_genhermv_sort(gsl_vector eval, gsl_matrix_complex evec, 
                             @Cast("gsl_eigen_sort_t") int sort_type);

public static native int gsl_eigen_genv_sort(gsl_vector_complex alpha, gsl_vector beta,
                         gsl_matrix_complex evec,
                         @Cast("gsl_eigen_sort_t") int sort_type);

/* Prototypes for the schur module */

public static native int gsl_schur_gen_eigvals(@Const gsl_matrix A, @Const gsl_matrix B,
                          DoublePointer wr1, DoublePointer wr2, DoublePointer wi,
                          DoublePointer scale1, DoublePointer scale2);
public static native int gsl_schur_gen_eigvals(@Const gsl_matrix A, @Const gsl_matrix B,
                          DoubleBuffer wr1, DoubleBuffer wr2, DoubleBuffer wi,
                          DoubleBuffer scale1, DoubleBuffer scale2);
public static native int gsl_schur_gen_eigvals(@Const gsl_matrix A, @Const gsl_matrix B,
                          double[] wr1, double[] wr2, double[] wi,
                          double[] scale1, double[] scale2);

public static native int gsl_schur_solve_equation(double ca, @Const gsl_matrix A, double z,
                             double d1, double d2, @Const gsl_vector b,
                             gsl_vector x, DoublePointer s, DoublePointer xnorm,
                             double smin);
public static native int gsl_schur_solve_equation(double ca, @Const gsl_matrix A, double z,
                             double d1, double d2, @Const gsl_vector b,
                             gsl_vector x, DoubleBuffer s, DoubleBuffer xnorm,
                             double smin);
public static native int gsl_schur_solve_equation(double ca, @Const gsl_matrix A, double z,
                             double d1, double d2, @Const gsl_vector b,
                             gsl_vector x, double[] s, double[] xnorm,
                             double smin);

public static native int gsl_schur_solve_equation_z(double ca, @Const gsl_matrix A,
                               gsl_complex z, double d1, double d2,
                               @Const gsl_vector_complex b,
                               gsl_vector_complex x, DoublePointer s,
                               DoublePointer xnorm, double smin);
public static native int gsl_schur_solve_equation_z(double ca, @Const gsl_matrix A,
                               gsl_complex z, double d1, double d2,
                               @Const gsl_vector_complex b,
                               gsl_vector_complex x, DoubleBuffer s,
                               DoubleBuffer xnorm, double smin);
public static native int gsl_schur_solve_equation_z(double ca, @Const gsl_matrix A,
                               gsl_complex z, double d1, double d2,
                               @Const gsl_vector_complex b,
                               gsl_vector_complex x, double[] s,
                               double[] xnorm, double smin);


/* The following functions are obsolete: */

/* Eigensolve by Jacobi Method
 *
 * The data in the matrix input is destroyed.
 *
 * exceptions: 
 */
public static native int gsl_eigen_jacobi(gsl_matrix matrix,
                      gsl_vector eval,
                      gsl_matrix evec,
                      @Cast("unsigned int") int max_rot, 
                      @Cast("unsigned int*") IntPointer nrot);
public static native int gsl_eigen_jacobi(gsl_matrix matrix,
                      gsl_vector eval,
                      gsl_matrix evec,
                      @Cast("unsigned int") int max_rot, 
                      @Cast("unsigned int*") IntBuffer nrot);
public static native int gsl_eigen_jacobi(gsl_matrix matrix,
                      gsl_vector eval,
                      gsl_matrix evec,
                      @Cast("unsigned int") int max_rot, 
                      @Cast("unsigned int*") int[] nrot);


/* Invert by Jacobi Method
 *
 * exceptions: 
 */
public static native int gsl_eigen_invert_jacobi(@Const gsl_matrix matrix,
                             gsl_matrix ainv,
                             @Cast("unsigned int") int max_rot);

// #endif /* __GSL_EIGEN_H__ */


// Parsed from gsl/gsl_fit.h

/* fit/gsl_fit.h
 * 
 * Copyright (C) 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FIT_H__
// #define __GSL_FIT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_fit_linear(@Const DoublePointer x, @Cast("const size_t") long xstride,
                    @Const DoublePointer y, @Cast("const size_t") long ystride,
                    @Cast("const size_t") long n,
                    DoublePointer c0, DoublePointer c1, 
                    DoublePointer cov00, DoublePointer cov01, DoublePointer cov11, 
                    DoublePointer sumsq);
public static native int gsl_fit_linear(@Const DoubleBuffer x, @Cast("const size_t") long xstride,
                    @Const DoubleBuffer y, @Cast("const size_t") long ystride,
                    @Cast("const size_t") long n,
                    DoubleBuffer c0, DoubleBuffer c1, 
                    DoubleBuffer cov00, DoubleBuffer cov01, DoubleBuffer cov11, 
                    DoubleBuffer sumsq);
public static native int gsl_fit_linear(@Const double[] x, @Cast("const size_t") long xstride,
                    @Const double[] y, @Cast("const size_t") long ystride,
                    @Cast("const size_t") long n,
                    double[] c0, double[] c1, 
                    double[] cov00, double[] cov01, double[] cov11, 
                    double[] sumsq);


public static native int gsl_fit_wlinear(@Const DoublePointer x, @Cast("const size_t") long xstride,
                     @Const DoublePointer w, @Cast("const size_t") long wstride,
                     @Const DoublePointer y, @Cast("const size_t") long ystride,
                     @Cast("const size_t") long n,
                     DoublePointer c0, DoublePointer c1, 
                     DoublePointer cov00, DoublePointer cov01, DoublePointer cov11, 
                     DoublePointer chisq);
public static native int gsl_fit_wlinear(@Const DoubleBuffer x, @Cast("const size_t") long xstride,
                     @Const DoubleBuffer w, @Cast("const size_t") long wstride,
                     @Const DoubleBuffer y, @Cast("const size_t") long ystride,
                     @Cast("const size_t") long n,
                     DoubleBuffer c0, DoubleBuffer c1, 
                     DoubleBuffer cov00, DoubleBuffer cov01, DoubleBuffer cov11, 
                     DoubleBuffer chisq);
public static native int gsl_fit_wlinear(@Const double[] x, @Cast("const size_t") long xstride,
                     @Const double[] w, @Cast("const size_t") long wstride,
                     @Const double[] y, @Cast("const size_t") long ystride,
                     @Cast("const size_t") long n,
                     double[] c0, double[] c1, 
                     double[] cov00, double[] cov01, double[] cov11, 
                     double[] chisq);

public static native int gsl_fit_linear_est(double x, 
                    double c0, double c1, 
                    double cov00, double cov01, double cov11,
                    DoublePointer y, DoublePointer y_err);
public static native int gsl_fit_linear_est(double x, 
                    double c0, double c1, 
                    double cov00, double cov01, double cov11,
                    DoubleBuffer y, DoubleBuffer y_err);
public static native int gsl_fit_linear_est(double x, 
                    double c0, double c1, 
                    double cov00, double cov01, double cov11,
                    double[] y, double[] y_err);


public static native int gsl_fit_mul(@Const DoublePointer x, @Cast("const size_t") long xstride,
                 @Const DoublePointer y, @Cast("const size_t") long ystride,
                 @Cast("const size_t") long n,
                 DoublePointer c1, 
                 DoublePointer cov11, 
                 DoublePointer sumsq);
public static native int gsl_fit_mul(@Const DoubleBuffer x, @Cast("const size_t") long xstride,
                 @Const DoubleBuffer y, @Cast("const size_t") long ystride,
                 @Cast("const size_t") long n,
                 DoubleBuffer c1, 
                 DoubleBuffer cov11, 
                 DoubleBuffer sumsq);
public static native int gsl_fit_mul(@Const double[] x, @Cast("const size_t") long xstride,
                 @Const double[] y, @Cast("const size_t") long ystride,
                 @Cast("const size_t") long n,
                 double[] c1, 
                 double[] cov11, 
                 double[] sumsq);

public static native int gsl_fit_wmul(@Const DoublePointer x, @Cast("const size_t") long xstride,
                  @Const DoublePointer w, @Cast("const size_t") long wstride,
                  @Const DoublePointer y, @Cast("const size_t") long ystride,
                  @Cast("const size_t") long n,
                  DoublePointer c1, 
                  DoublePointer cov11, 
                  DoublePointer sumsq);
public static native int gsl_fit_wmul(@Const DoubleBuffer x, @Cast("const size_t") long xstride,
                  @Const DoubleBuffer w, @Cast("const size_t") long wstride,
                  @Const DoubleBuffer y, @Cast("const size_t") long ystride,
                  @Cast("const size_t") long n,
                  DoubleBuffer c1, 
                  DoubleBuffer cov11, 
                  DoubleBuffer sumsq);
public static native int gsl_fit_wmul(@Const double[] x, @Cast("const size_t") long xstride,
                  @Const double[] w, @Cast("const size_t") long wstride,
                  @Const double[] y, @Cast("const size_t") long ystride,
                  @Cast("const size_t") long n,
                  double[] c1, 
                  double[] cov11, 
                  double[] sumsq);


public static native int gsl_fit_mul_est(double x, 
                 double c1, 
                 double cov11,
                 DoublePointer y, DoublePointer y_err);
public static native int gsl_fit_mul_est(double x, 
                 double c1, 
                 double cov11,
                 DoubleBuffer y, DoubleBuffer y_err);
public static native int gsl_fit_mul_est(double x, 
                 double c1, 
                 double cov11,
                 double[] y, double[] y_err);

// #endif /* __GSL_FIT_H__ */


// Parsed from gsl/gsl_permutation.h

/* permutation/gsl_permutation.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTATION_H__
// #define __GSL_PERMUTATION_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_permutation.java



public static native gsl_permutation gsl_permutation_alloc(@Cast("const size_t") long n);
public static native gsl_permutation gsl_permutation_calloc(@Cast("const size_t") long n);
public static native void gsl_permutation_init(gsl_permutation p);
public static native void gsl_permutation_free(gsl_permutation p);
public static native int gsl_permutation_memcpy(gsl_permutation dest, @Const gsl_permutation src);

public static native int gsl_permutation_fread(FILE stream, gsl_permutation p);
public static native int gsl_permutation_fwrite(FILE stream, @Const gsl_permutation p);
public static native int gsl_permutation_fscanf(FILE stream, gsl_permutation p);
public static native int gsl_permutation_fprintf(FILE stream, @Const gsl_permutation p, @Cast("const char*") BytePointer format);
public static native int gsl_permutation_fprintf(FILE stream, @Const gsl_permutation p, String format);

public static native @Cast("size_t") long gsl_permutation_size(@Const gsl_permutation p);
public static native @Cast("size_t*") SizeTPointer gsl_permutation_data(@Const gsl_permutation p);

public static native int gsl_permutation_swap(gsl_permutation p, @Cast("const size_t") long i, @Cast("const size_t") long j);

public static native int gsl_permutation_valid(@Const gsl_permutation p);
public static native void gsl_permutation_reverse(gsl_permutation p);
public static native int gsl_permutation_inverse(gsl_permutation inv, @Const gsl_permutation p);
public static native int gsl_permutation_next(gsl_permutation p);
public static native int gsl_permutation_prev(gsl_permutation p);
public static native int gsl_permutation_mul(gsl_permutation p, @Const gsl_permutation pa, @Const gsl_permutation pb);

public static native int gsl_permutation_linear_to_canonical(gsl_permutation q, @Const gsl_permutation p);
public static native int gsl_permutation_canonical_to_linear(gsl_permutation p, @Const gsl_permutation q);

public static native @Cast("size_t") long gsl_permutation_inversions(@Const gsl_permutation p);
public static native @Cast("size_t") long gsl_permutation_linear_cycles(@Const gsl_permutation p);
public static native @Cast("size_t") long gsl_permutation_canonical_cycles(@Const gsl_permutation q);

/* */ public static native @Cast("size_t") long gsl_permutation_get(@Const gsl_permutation p, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE

// #endif /* HAVE_INLINE */

// #endif /* __GSL_PERMUTATION_H__ */


// Parsed from gsl/gsl_heapsort.h

/* sort/gsl_heapsort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Thomas Walter, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_HEAPSORT_H__
// #define __GSL_HEAPSORT_H__

// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_comparison_fn_t.java



public static native void gsl_heapsort(Pointer array, @Cast("size_t") long count, @Cast("size_t") long size, gsl_comparison_fn_t compare);
public static native int gsl_heapsort_index(@Cast("size_t*") SizeTPointer p, @Const Pointer array, @Cast("size_t") long count, @Cast("size_t") long size, gsl_comparison_fn_t compare);

// #endif /* __GSL_HEAPSORT_H__ */


// Parsed from gsl/gsl_histogram2d.h

/* histogram/gsl_histogram2d.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_HISTOGRAM2D_H__
// #define __GSL_HISTOGRAM2D_H__

// #include <stdlib.h>
// #include <stdio.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_histogram2d.java


// Targeting ../gsl_histogram2d_pdf.java



public static native gsl_histogram2d gsl_histogram2d_alloc(@Cast("const size_t") long nx, @Cast("const size_t") long ny);
public static native gsl_histogram2d gsl_histogram2d_calloc(@Cast("const size_t") long nx, @Cast("const size_t") long ny);
public static native gsl_histogram2d gsl_histogram2d_calloc_uniform(@Cast("const size_t") long nx, @Cast("const size_t") long ny,
                                             double xmin, double xmax,
                                             double ymin, double ymax);

public static native void gsl_histogram2d_free(gsl_histogram2d h);

public static native int gsl_histogram2d_increment(gsl_histogram2d h, double x, double y);
public static native int gsl_histogram2d_accumulate(gsl_histogram2d h, 
                                double x, double y, double weight);
public static native int gsl_histogram2d_find(@Const gsl_histogram2d h, 
                          double x, double y, @Cast("size_t*") SizeTPointer i, @Cast("size_t*") SizeTPointer j);

public static native double gsl_histogram2d_get(@Const gsl_histogram2d h, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_histogram2d_get_xrange(@Const gsl_histogram2d h, @Cast("const size_t") long i,
                                DoublePointer xlower, DoublePointer xupper);
public static native int gsl_histogram2d_get_xrange(@Const gsl_histogram2d h, @Cast("const size_t") long i,
                                DoubleBuffer xlower, DoubleBuffer xupper);
public static native int gsl_histogram2d_get_xrange(@Const gsl_histogram2d h, @Cast("const size_t") long i,
                                double[] xlower, double[] xupper);
public static native int gsl_histogram2d_get_yrange(@Const gsl_histogram2d h, @Cast("const size_t") long j,
                                DoublePointer ylower, DoublePointer yupper);
public static native int gsl_histogram2d_get_yrange(@Const gsl_histogram2d h, @Cast("const size_t") long j,
                                DoubleBuffer ylower, DoubleBuffer yupper);
public static native int gsl_histogram2d_get_yrange(@Const gsl_histogram2d h, @Cast("const size_t") long j,
                                double[] ylower, double[] yupper);

                                     
public static native double gsl_histogram2d_xmax(@Const gsl_histogram2d h);
public static native double gsl_histogram2d_xmin(@Const gsl_histogram2d h);
public static native @Cast("size_t") long gsl_histogram2d_nx(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_ymax(@Const gsl_histogram2d h);
public static native double gsl_histogram2d_ymin(@Const gsl_histogram2d h);
public static native @Cast("size_t") long gsl_histogram2d_ny(@Const gsl_histogram2d h);

public static native void gsl_histogram2d_reset(gsl_histogram2d h);

public static native gsl_histogram2d gsl_histogram2d_calloc_range(@Cast("size_t") long nx, @Cast("size_t") long ny, 
                             DoublePointer xrange, DoublePointer yrange);
public static native gsl_histogram2d gsl_histogram2d_calloc_range(@Cast("size_t") long nx, @Cast("size_t") long ny, 
                             DoubleBuffer xrange, DoubleBuffer yrange);
public static native gsl_histogram2d gsl_histogram2d_calloc_range(@Cast("size_t") long nx, @Cast("size_t") long ny, 
                             double[] xrange, double[] yrange);

public static native int gsl_histogram2d_set_ranges_uniform(gsl_histogram2d h, 
                                    double xmin, double xmax,
                                    double ymin, double ymax);

public static native int gsl_histogram2d_set_ranges(gsl_histogram2d h, 
                            @Const DoublePointer xrange, @Cast("size_t") long xsize,
                            @Const DoublePointer yrange, @Cast("size_t") long ysize);
public static native int gsl_histogram2d_set_ranges(gsl_histogram2d h, 
                            @Const DoubleBuffer xrange, @Cast("size_t") long xsize,
                            @Const DoubleBuffer yrange, @Cast("size_t") long ysize);
public static native int gsl_histogram2d_set_ranges(gsl_histogram2d h, 
                            @Const double[] xrange, @Cast("size_t") long xsize,
                            @Const double[] yrange, @Cast("size_t") long ysize);

public static native int gsl_histogram2d_memcpy(gsl_histogram2d dest, @Const gsl_histogram2d source);

public static native gsl_histogram2d gsl_histogram2d_clone(@Const gsl_histogram2d source);

public static native double gsl_histogram2d_max_val(@Const gsl_histogram2d h);

public static native void gsl_histogram2d_max_bin(@Const gsl_histogram2d h, @Cast("size_t*") SizeTPointer i, @Cast("size_t*") SizeTPointer j);

public static native double gsl_histogram2d_min_val(@Const gsl_histogram2d h);

public static native void gsl_histogram2d_min_bin(@Const gsl_histogram2d h, @Cast("size_t*") SizeTPointer i, @Cast("size_t*") SizeTPointer j);

public static native double gsl_histogram2d_xmean(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_ymean(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_xsigma(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_ysigma(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_cov(@Const gsl_histogram2d h);

public static native double gsl_histogram2d_sum(@Const gsl_histogram2d h);

public static native int gsl_histogram2d_equal_bins_p(@Const gsl_histogram2d h1,
                             @Const gsl_histogram2d h2);

public static native int gsl_histogram2d_add(gsl_histogram2d h1, @Const gsl_histogram2d h2);

public static native int gsl_histogram2d_sub(gsl_histogram2d h1, @Const gsl_histogram2d h2);

public static native int gsl_histogram2d_mul(gsl_histogram2d h1, @Const gsl_histogram2d h2);

public static native int gsl_histogram2d_div(gsl_histogram2d h1, @Const gsl_histogram2d h2);

public static native int gsl_histogram2d_scale(gsl_histogram2d h, double scale);

public static native int gsl_histogram2d_shift(gsl_histogram2d h, double shift);

public static native int gsl_histogram2d_fwrite(FILE stream, @Const gsl_histogram2d h);
public static native int gsl_histogram2d_fread(FILE stream, gsl_histogram2d h);
public static native int gsl_histogram2d_fprintf(FILE stream, @Const gsl_histogram2d h, 
                             @Cast("const char*") BytePointer range_format,
                             @Cast("const char*") BytePointer bin_format);
public static native int gsl_histogram2d_fprintf(FILE stream, @Const gsl_histogram2d h, 
                             String range_format,
                             String bin_format);
public static native int gsl_histogram2d_fscanf(FILE stream, gsl_histogram2d h);

public static native gsl_histogram2d_pdf gsl_histogram2d_pdf_alloc(@Cast("const size_t") long nx, @Cast("const size_t") long ny);
public static native int gsl_histogram2d_pdf_init(gsl_histogram2d_pdf p, @Const gsl_histogram2d h);
public static native void gsl_histogram2d_pdf_free(gsl_histogram2d_pdf p);
public static native int gsl_histogram2d_pdf_sample(@Const gsl_histogram2d_pdf p, 
                                   double r1, double r2, 
                                   DoublePointer x, DoublePointer y);
public static native int gsl_histogram2d_pdf_sample(@Const gsl_histogram2d_pdf p, 
                                   double r1, double r2, 
                                   DoubleBuffer x, DoubleBuffer y);
public static native int gsl_histogram2d_pdf_sample(@Const gsl_histogram2d_pdf p, 
                                   double r1, double r2, 
                                   double[] x, double[] y);

// #endif /* __GSL_HISTOGRAM2D_H__ */



// Parsed from gsl/gsl_histogram.h

/* histogram/gsl_histogram.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_HISTOGRAM_H__
// #define __GSL_HISTOGRAM_H__

// #include <stdlib.h>
// #include <stdio.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_histogram.java


// Targeting ../gsl_histogram_pdf.java



public static native gsl_histogram gsl_histogram_alloc(@Cast("size_t") long n);

public static native gsl_histogram gsl_histogram_calloc(@Cast("size_t") long n);
public static native gsl_histogram gsl_histogram_calloc_uniform(@Cast("const size_t") long n, double xmin, double xmax);
public static native void gsl_histogram_free(gsl_histogram h);
public static native int gsl_histogram_increment(gsl_histogram h, double x);
public static native int gsl_histogram_accumulate(gsl_histogram h, double x, double weight);
public static native int gsl_histogram_find(@Const gsl_histogram h, 
                        double x, @Cast("size_t*") SizeTPointer i);

public static native double gsl_histogram_get(@Const gsl_histogram h, @Cast("size_t") long i);
public static native int gsl_histogram_get_range(@Const gsl_histogram h, @Cast("size_t") long i, 
                             DoublePointer lower, DoublePointer upper);
public static native int gsl_histogram_get_range(@Const gsl_histogram h, @Cast("size_t") long i, 
                             DoubleBuffer lower, DoubleBuffer upper);
public static native int gsl_histogram_get_range(@Const gsl_histogram h, @Cast("size_t") long i, 
                             double[] lower, double[] upper);
                                     
public static native double gsl_histogram_max(@Const gsl_histogram h);
public static native double gsl_histogram_min(@Const gsl_histogram h);
public static native @Cast("size_t") long gsl_histogram_bins(@Const gsl_histogram h);

public static native void gsl_histogram_reset(gsl_histogram h);

public static native gsl_histogram gsl_histogram_calloc_range(@Cast("size_t") long n, DoublePointer range);
public static native gsl_histogram gsl_histogram_calloc_range(@Cast("size_t") long n, DoubleBuffer range);
public static native gsl_histogram gsl_histogram_calloc_range(@Cast("size_t") long n, double[] range);

public static native int gsl_histogram_set_ranges(gsl_histogram h, @Const DoublePointer range, @Cast("size_t") long size);
public static native int gsl_histogram_set_ranges(gsl_histogram h, @Const DoubleBuffer range, @Cast("size_t") long size);
public static native int gsl_histogram_set_ranges(gsl_histogram h, @Const double[] range, @Cast("size_t") long size);
public static native int gsl_histogram_set_ranges_uniform(gsl_histogram h, double xmin, double xmax);



public static native int gsl_histogram_memcpy(gsl_histogram dest, @Const gsl_histogram source);

public static native gsl_histogram gsl_histogram_clone(@Const gsl_histogram source);

public static native double gsl_histogram_max_val(@Const gsl_histogram h);

public static native @Cast("size_t") long gsl_histogram_max_bin(@Const gsl_histogram h);

public static native double gsl_histogram_min_val(@Const gsl_histogram h);

public static native @Cast("size_t") long gsl_histogram_min_bin(@Const gsl_histogram h);

public static native int gsl_histogram_equal_bins_p(@Const gsl_histogram h1, @Const gsl_histogram h2);

public static native int gsl_histogram_add(gsl_histogram h1, @Const gsl_histogram h2);

public static native int gsl_histogram_sub(gsl_histogram h1, @Const gsl_histogram h2);

public static native int gsl_histogram_mul(gsl_histogram h1, @Const gsl_histogram h2);
 
public static native int gsl_histogram_div(gsl_histogram h1, @Const gsl_histogram h2);

public static native int gsl_histogram_scale(gsl_histogram h, double scale);

public static native int gsl_histogram_shift(gsl_histogram h, double shift);


public static native double gsl_histogram_sigma(@Const gsl_histogram h);

public static native double gsl_histogram_mean(@Const gsl_histogram h);

public static native double gsl_histogram_sum(@Const gsl_histogram h);

public static native int gsl_histogram_fwrite(FILE stream, @Const gsl_histogram h);
public static native int gsl_histogram_fread(FILE stream, gsl_histogram h);
public static native int gsl_histogram_fprintf(FILE stream, @Const gsl_histogram h, 
                           @Cast("const char*") BytePointer range_format, @Cast("const char*") BytePointer bin_format);
public static native int gsl_histogram_fprintf(FILE stream, @Const gsl_histogram h, 
                           String range_format, String bin_format);
public static native int gsl_histogram_fscanf(FILE stream, gsl_histogram h);

public static native gsl_histogram_pdf gsl_histogram_pdf_alloc(@Cast("const size_t") long n);
public static native int gsl_histogram_pdf_init(gsl_histogram_pdf p, @Const gsl_histogram h);
public static native void gsl_histogram_pdf_free(gsl_histogram_pdf p);
public static native double gsl_histogram_pdf_sample(@Const gsl_histogram_pdf p, double r);

// #endif /* __GSL_HISTOGRAM_H__ */


// Parsed from gsl/gsl_integration.h

/* integration/gsl_integration.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_INTEGRATION_H__
// #define __GSL_INTEGRATION_H__
// #include <stdlib.h>
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_integration_workspace.java



public static native gsl_integration_workspace gsl_integration_workspace_alloc(@Cast("const size_t") long n);

public static native void gsl_integration_workspace_free(gsl_integration_workspace w);
// Targeting ../gsl_integration_qaws_table.java



public static native gsl_integration_qaws_table gsl_integration_qaws_table_alloc(double alpha, double beta, int mu, int nu);

public static native int gsl_integration_qaws_table_set(gsl_integration_qaws_table t,
                                double alpha, double beta, int mu, int nu);

public static native void gsl_integration_qaws_table_free(gsl_integration_qaws_table t);

/* Workspace for QAWO integrator */

/** enum gsl_integration_qawo_enum */
public static final int GSL_INTEG_COSINE = 0, GSL_INTEG_SINE = 1;
// Targeting ../gsl_integration_qawo_table.java



public static native gsl_integration_qawo_table gsl_integration_qawo_table_alloc(double omega, double L, 
                                  @Cast("gsl_integration_qawo_enum") int sine,
                                  @Cast("size_t") long n);

public static native int gsl_integration_qawo_table_set(gsl_integration_qawo_table t,
                                double omega, double L,
                                @Cast("gsl_integration_qawo_enum") int sine);

public static native int gsl_integration_qawo_table_set_length(gsl_integration_qawo_table t,
                                       double L);

public static native void gsl_integration_qawo_table_free(gsl_integration_qawo_table t);
// Targeting ../gsl_integration_rule.java



public static native void gsl_integration_qk15(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk15(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk15(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qk21(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk21(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk21(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qk31(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk31(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk31(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qk41(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk41(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk41(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qk51(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk51(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk51(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qk61(@Const gsl_function f, double a, double b,
                           DoublePointer result, DoublePointer abserr,
                           DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk61(@Const gsl_function f, double a, double b,
                           DoubleBuffer result, DoubleBuffer abserr,
                           DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk61(@Const gsl_function f, double a, double b,
                           double[] result, double[] abserr,
                           double[] resabs, double[] resasc);

public static native void gsl_integration_qcheb(gsl_function f, double a, double b, 
                            DoublePointer cheb12, DoublePointer cheb24);
public static native void gsl_integration_qcheb(gsl_function f, double a, double b, 
                            DoubleBuffer cheb12, DoubleBuffer cheb24);
public static native void gsl_integration_qcheb(gsl_function f, double a, double b, 
                            double[] cheb12, double[] cheb24);

/* The low-level integration rules in QUADPACK are identified by small
   integers (1-6). We'll use symbolic constants to refer to them.  */

/** enum  */
public static final int
    GSL_INTEG_GAUSS15 = 1,      /* 15 point Gauss-Kronrod rule */
    GSL_INTEG_GAUSS21 = 2,      /* 21 point Gauss-Kronrod rule */
    GSL_INTEG_GAUSS31 = 3,      /* 31 point Gauss-Kronrod rule */
    GSL_INTEG_GAUSS41 = 4,      /* 41 point Gauss-Kronrod rule */
    GSL_INTEG_GAUSS51 = 5,      /* 51 point Gauss-Kronrod rule */
    GSL_INTEG_GAUSS61 = 6;       /* 61 point Gauss-Kronrod rule */

public static native void gsl_integration_qk(int n, @Const DoublePointer xgk, 
                    @Const DoublePointer wg, @Const DoublePointer wgk,
                    DoublePointer fv1, DoublePointer fv2,
                    @Const gsl_function f, double a, double b,
                    DoublePointer result, DoublePointer abserr, 
                    DoublePointer resabs, DoublePointer resasc);
public static native void gsl_integration_qk(int n, @Const DoubleBuffer xgk, 
                    @Const DoubleBuffer wg, @Const DoubleBuffer wgk,
                    DoubleBuffer fv1, DoubleBuffer fv2,
                    @Const gsl_function f, double a, double b,
                    DoubleBuffer result, DoubleBuffer abserr, 
                    DoubleBuffer resabs, DoubleBuffer resasc);
public static native void gsl_integration_qk(int n, @Const double[] xgk, 
                    @Const double[] wg, @Const double[] wgk,
                    double[] fv1, double[] fv2,
                    @Const gsl_function f, double a, double b,
                    double[] result, double[] abserr, 
                    double[] resabs, double[] resasc);


public static native int gsl_integration_qng(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel,
                         DoublePointer result, DoublePointer abserr,
                         @Cast("size_t*") SizeTPointer neval);
public static native int gsl_integration_qng(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel,
                         DoubleBuffer result, DoubleBuffer abserr,
                         @Cast("size_t*") SizeTPointer neval);
public static native int gsl_integration_qng(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel,
                         double[] result, double[] abserr,
                         @Cast("size_t*") SizeTPointer neval);

public static native int gsl_integration_qag(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel, @Cast("size_t") long _limit,
                         int key,
                         gsl_integration_workspace workspace,
                         DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qag(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel, @Cast("size_t") long _limit,
                         int key,
                         gsl_integration_workspace workspace,
                         DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qag(@Const gsl_function f,
                         double a, double b,
                         double epsabs, double epsrel, @Cast("size_t") long _limit,
                         int key,
                         gsl_integration_workspace workspace,
                         double[] result, double[] abserr);

public static native int gsl_integration_qagi(gsl_function f,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qagi(gsl_function f,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qagi(gsl_function f,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          double[] result, double[] abserr);

public static native int gsl_integration_qagiu(gsl_function f,
                           double a,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qagiu(gsl_function f,
                           double a,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qagiu(gsl_function f,
                           double a,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           double[] result, double[] abserr);

public static native int gsl_integration_qagil(gsl_function f,
                           double b,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qagil(gsl_function f,
                           double b,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qagil(gsl_function f,
                           double b,
                           double epsabs, double epsrel, @Cast("size_t") long _limit,
                           gsl_integration_workspace workspace,
                           double[] result, double[] abserr);


public static native int gsl_integration_qags(@Const gsl_function f,
                          double a, double b,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qags(@Const gsl_function f,
                          double a, double b,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qags(@Const gsl_function f,
                          double a, double b,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          double[] result, double[] abserr);

public static native int gsl_integration_qagp(@Const gsl_function f,
                          DoublePointer pts, @Cast("size_t") long npts,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qagp(@Const gsl_function f,
                          DoubleBuffer pts, @Cast("size_t") long npts,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qagp(@Const gsl_function f,
                          double[] pts, @Cast("size_t") long npts,
                          double epsabs, double epsrel, @Cast("size_t") long _limit,
                          gsl_integration_workspace workspace,
                          double[] result, double[] abserr);

public static native int gsl_integration_qawc(gsl_function f,
                          double a, double b, double c,
                          double epsabs, double epsrel, @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qawc(gsl_function f,
                          double a, double b, double c,
                          double epsabs, double epsrel, @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qawc(gsl_function f,
                          double a, double b, double c,
                          double epsabs, double epsrel, @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          double[] result, double[] abserr);

public static native int gsl_integration_qaws(gsl_function f,
                          double a, double b,
                          gsl_integration_qaws_table t,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qaws(gsl_function f,
                          double a, double b,
                          gsl_integration_qaws_table t,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qaws(gsl_function f,
                          double a, double b,
                          gsl_integration_qaws_table t,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          double[] result, double[] abserr);

public static native int gsl_integration_qawo(gsl_function f,
                          double a,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_qawo_table wf,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qawo(gsl_function f,
                          double a,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_qawo_table wf,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qawo(gsl_function f,
                          double a,
                          double epsabs, double epsrel,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_qawo_table wf,
                          double[] result, double[] abserr);

public static native int gsl_integration_qawf(gsl_function f,
                          double a,
                          double epsabs,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_workspace cycle_workspace,
                          gsl_integration_qawo_table wf,
                          DoublePointer result, DoublePointer abserr);
public static native int gsl_integration_qawf(gsl_function f,
                          double a,
                          double epsabs,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_workspace cycle_workspace,
                          gsl_integration_qawo_table wf,
                          DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_integration_qawf(gsl_function f,
                          double a,
                          double epsabs,
                          @Cast("const size_t") long _limit,
                          gsl_integration_workspace workspace,
                          gsl_integration_workspace cycle_workspace,
                          gsl_integration_qawo_table wf,
                          double[] result, double[] abserr);
// Targeting ../gsl_integration_glfixed_table.java




public static native gsl_integration_glfixed_table gsl_integration_glfixed_table_alloc(@Cast("size_t") long n);

public static native void gsl_integration_glfixed_table_free(gsl_integration_glfixed_table t);

/* Routine for fixed-order Gauss-Legendre integration */

public static native double gsl_integration_glfixed(@Const gsl_function f,
                                double a,
                                double b,
                                @Const gsl_integration_glfixed_table t);

/* Routine to retrieve the i-th Gauss-Legendre point and weight from t */

public static native int gsl_integration_glfixed_point(double a,
                                   double b,
                                   @Cast("size_t") long i,
                                   DoublePointer xi,
                                   DoublePointer wi,
                                   @Const gsl_integration_glfixed_table t);
public static native int gsl_integration_glfixed_point(double a,
                                   double b,
                                   @Cast("size_t") long i,
                                   DoubleBuffer xi,
                                   DoubleBuffer wi,
                                   @Const gsl_integration_glfixed_table t);
public static native int gsl_integration_glfixed_point(double a,
                                   double b,
                                   @Cast("size_t") long i,
                                   double[] xi,
                                   double[] wi,
                                   @Const gsl_integration_glfixed_table t);
// Targeting ../gsl_integration_cquad_ival.java


// Targeting ../gsl_integration_cquad_workspace.java



public static native gsl_integration_cquad_workspace gsl_integration_cquad_workspace_alloc(@Cast("const size_t") long n);

public static native void gsl_integration_cquad_workspace_free(gsl_integration_cquad_workspace w);

public static native int gsl_integration_cquad(@Const gsl_function f, double a, double b,
		                   double epsabs, double epsrel,
		                   gsl_integration_cquad_workspace ws,
		                   DoublePointer result, DoublePointer abserr, @Cast("size_t*") SizeTPointer nevals);
public static native int gsl_integration_cquad(@Const gsl_function f, double a, double b,
		                   double epsabs, double epsrel,
		                   gsl_integration_cquad_workspace ws,
		                   DoubleBuffer result, DoubleBuffer abserr, @Cast("size_t*") SizeTPointer nevals);
public static native int gsl_integration_cquad(@Const gsl_function f, double a, double b,
		                   double epsabs, double epsrel,
		                   gsl_integration_cquad_workspace ws,
		                   double[] result, double[] abserr, @Cast("size_t*") SizeTPointer nevals);
// Targeting ../gsl_integration_romberg_workspace.java



public static native gsl_integration_romberg_workspace gsl_integration_romberg_alloc(@Cast("const size_t") long n);
public static native void gsl_integration_romberg_free(gsl_integration_romberg_workspace w);
public static native int gsl_integration_romberg(@Const gsl_function f, double a, double b,
                            double epsabs, double epsrel, DoublePointer result,
                            @Cast("size_t*") SizeTPointer neval, gsl_integration_romberg_workspace w);
public static native int gsl_integration_romberg(@Const gsl_function f, double a, double b,
                            double epsabs, double epsrel, DoubleBuffer result,
                            @Cast("size_t*") SizeTPointer neval, gsl_integration_romberg_workspace w);
public static native int gsl_integration_romberg(@Const gsl_function f, double a, double b,
                            double epsabs, double epsrel, double[] result,
                            @Cast("size_t*") SizeTPointer neval, gsl_integration_romberg_workspace w);
// Targeting ../gsl_integration_fixed_params.java


// Targeting ../gsl_integration_fixed_type.java


// Targeting ../gsl_integration_fixed_workspace.java



/* IQPACK integral types */
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_legendre(); public static native void gsl_integration_fixed_legendre(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_chebyshev(); public static native void gsl_integration_fixed_chebyshev(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_gegenbauer(); public static native void gsl_integration_fixed_gegenbauer(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_jacobi(); public static native void gsl_integration_fixed_jacobi(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_laguerre(); public static native void gsl_integration_fixed_laguerre(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_hermite(); public static native void gsl_integration_fixed_hermite(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_exponential(); public static native void gsl_integration_fixed_exponential(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_rational(); public static native void gsl_integration_fixed_rational(gsl_integration_fixed_type setter);
public static native @Const gsl_integration_fixed_type gsl_integration_fixed_chebyshev2(); public static native void gsl_integration_fixed_chebyshev2(gsl_integration_fixed_type setter);

public static native gsl_integration_fixed_workspace gsl_integration_fixed_alloc(@Const gsl_integration_fixed_type type, @Cast("const size_t") long n,
                            double a, double b, double alpha, double beta);

public static native void gsl_integration_fixed_free(gsl_integration_fixed_workspace w);

public static native @Cast("size_t") long gsl_integration_fixed_n(@Const gsl_integration_fixed_workspace w);

public static native DoublePointer gsl_integration_fixed_nodes(@Const gsl_integration_fixed_workspace w);

public static native DoublePointer gsl_integration_fixed_weights(@Const gsl_integration_fixed_workspace w);

public static native int gsl_integration_fixed(@Const gsl_function func, DoublePointer result,
                          @Const gsl_integration_fixed_workspace w);
public static native int gsl_integration_fixed(@Const gsl_function func, DoubleBuffer result,
                          @Const gsl_integration_fixed_workspace w);
public static native int gsl_integration_fixed(@Const gsl_function func, double[] result,
                          @Const gsl_integration_fixed_workspace w);

// #endif /* __GSL_INTEGRATION_H__ */


// Parsed from gsl/gsl_interp.h

/* interpolation/gsl_interp.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  G. Jungman
 */
// #ifndef __GSL_INTERP_H__
// #define __GSL_INTERP_H__
// #include <stdlib.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_interp_accel.java


// Targeting ../gsl_interp_type.java


// Targeting ../gsl_interp.java




/* available types */
public static native @Const gsl_interp_type gsl_interp_linear(); public static native void gsl_interp_linear(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_polynomial(); public static native void gsl_interp_polynomial(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_cspline(); public static native void gsl_interp_cspline(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_cspline_periodic(); public static native void gsl_interp_cspline_periodic(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_akima(); public static native void gsl_interp_akima(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_akima_periodic(); public static native void gsl_interp_akima_periodic(gsl_interp_type setter);
public static native @Const gsl_interp_type gsl_interp_steffen(); public static native void gsl_interp_steffen(gsl_interp_type setter);

public static native gsl_interp_accel gsl_interp_accel_alloc();

public static native int gsl_interp_accel_reset(gsl_interp_accel a);

public static native void gsl_interp_accel_free(gsl_interp_accel a);

public static native gsl_interp gsl_interp_alloc(@Const gsl_interp_type T, @Cast("size_t") long n);
     
public static native int gsl_interp_init(gsl_interp obj, @Const DoublePointer xa, @Const DoublePointer ya, @Cast("size_t") long size);
public static native int gsl_interp_init(gsl_interp obj, @Const DoubleBuffer xa, @Const DoubleBuffer ya, @Cast("size_t") long size);
public static native int gsl_interp_init(gsl_interp obj, @Const double[] xa, @Const double[] ya, @Cast("size_t") long size);

public static native @Cast("const char*") BytePointer gsl_interp_name(@Const gsl_interp interp);
public static native @Cast("unsigned int") int gsl_interp_min_size(@Const gsl_interp interp);
public static native @Cast("unsigned int") int gsl_interp_type_min_size(@Const gsl_interp_type T);


public static native int gsl_interp_eval_e(@Const gsl_interp obj,
                  @Const DoublePointer xa, @Const DoublePointer ya, double x,
                  gsl_interp_accel a, DoublePointer y);
public static native int gsl_interp_eval_e(@Const gsl_interp obj,
                  @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                  gsl_interp_accel a, DoubleBuffer y);
public static native int gsl_interp_eval_e(@Const gsl_interp obj,
                  @Const double[] xa, @Const double[] ya, double x,
                  gsl_interp_accel a, double[] y);

public static native double gsl_interp_eval(@Const gsl_interp obj,
                @Const DoublePointer xa, @Const DoublePointer ya, double x,
                gsl_interp_accel a);
public static native double gsl_interp_eval(@Const gsl_interp obj,
                @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                gsl_interp_accel a);
public static native double gsl_interp_eval(@Const gsl_interp obj,
                @Const double[] xa, @Const double[] ya, double x,
                gsl_interp_accel a);

public static native int gsl_interp_eval_deriv_e(@Const gsl_interp obj,
                        @Const DoublePointer xa, @Const DoublePointer ya, double x,
                        gsl_interp_accel a,
                        DoublePointer d);
public static native int gsl_interp_eval_deriv_e(@Const gsl_interp obj,
                        @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                        gsl_interp_accel a,
                        DoubleBuffer d);
public static native int gsl_interp_eval_deriv_e(@Const gsl_interp obj,
                        @Const double[] xa, @Const double[] ya, double x,
                        gsl_interp_accel a,
                        double[] d);

public static native double gsl_interp_eval_deriv(@Const gsl_interp obj,
                      @Const DoublePointer xa, @Const DoublePointer ya, double x,
                      gsl_interp_accel a);
public static native double gsl_interp_eval_deriv(@Const gsl_interp obj,
                      @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                      gsl_interp_accel a);
public static native double gsl_interp_eval_deriv(@Const gsl_interp obj,
                      @Const double[] xa, @Const double[] ya, double x,
                      gsl_interp_accel a);

public static native int gsl_interp_eval_deriv2_e(@Const gsl_interp obj,
                         @Const DoublePointer xa, @Const DoublePointer ya, double x,
                         gsl_interp_accel a,
                         DoublePointer d2);
public static native int gsl_interp_eval_deriv2_e(@Const gsl_interp obj,
                         @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                         gsl_interp_accel a,
                         DoubleBuffer d2);
public static native int gsl_interp_eval_deriv2_e(@Const gsl_interp obj,
                         @Const double[] xa, @Const double[] ya, double x,
                         gsl_interp_accel a,
                         double[] d2);

public static native double gsl_interp_eval_deriv2(@Const gsl_interp obj,
                       @Const DoublePointer xa, @Const DoublePointer ya, double x,
                       gsl_interp_accel a);
public static native double gsl_interp_eval_deriv2(@Const gsl_interp obj,
                       @Const DoubleBuffer xa, @Const DoubleBuffer ya, double x,
                       gsl_interp_accel a);
public static native double gsl_interp_eval_deriv2(@Const gsl_interp obj,
                       @Const double[] xa, @Const double[] ya, double x,
                       gsl_interp_accel a);

public static native int gsl_interp_eval_integ_e(@Const gsl_interp obj,
                        @Const DoublePointer xa, @Const DoublePointer ya,
                        double a, double b,
                        gsl_interp_accel acc,
                        DoublePointer result);
public static native int gsl_interp_eval_integ_e(@Const gsl_interp obj,
                        @Const DoubleBuffer xa, @Const DoubleBuffer ya,
                        double a, double b,
                        gsl_interp_accel acc,
                        DoubleBuffer result);
public static native int gsl_interp_eval_integ_e(@Const gsl_interp obj,
                        @Const double[] xa, @Const double[] ya,
                        double a, double b,
                        gsl_interp_accel acc,
                        double[] result);

public static native double gsl_interp_eval_integ(@Const gsl_interp obj,
                      @Const DoublePointer xa, @Const DoublePointer ya,
                      double a, double b,
                      gsl_interp_accel acc);
public static native double gsl_interp_eval_integ(@Const gsl_interp obj,
                      @Const DoubleBuffer xa, @Const DoubleBuffer ya,
                      double a, double b,
                      gsl_interp_accel acc);
public static native double gsl_interp_eval_integ(@Const gsl_interp obj,
                      @Const double[] xa, @Const double[] ya,
                      double a, double b,
                      gsl_interp_accel acc);

public static native void gsl_interp_free(gsl_interp interp);

/* */ public static native @Cast("size_t") long gsl_interp_bsearch(@Const DoublePointer x_array, double x,
                   @Cast("size_t") long index_lo, @Cast("size_t") long index_hi);
public static native @Cast("size_t") long gsl_interp_bsearch(@Const DoubleBuffer x_array, double x,
                   @Cast("size_t") long index_lo, @Cast("size_t") long index_hi);
public static native @Cast("size_t") long gsl_interp_bsearch(@Const double[] x_array, double x,
                   @Cast("size_t") long index_lo, @Cast("size_t") long index_hi);

// #ifdef HAVE_INLINE

/* Perform a binary search of an array of values.
 * 
 * The parameters index_lo and index_hi provide an initial bracket,
 * and it is assumed that index_lo < index_hi. The resulting index
 * is guaranteed to be strictly less than index_hi and greater than
 * or equal to index_lo, so that the implicit bracket [index, index+1]
 * always corresponds to a region within the implicit value range of
 * the value array.
 *
 * Note that this means the relationship of 'x' to x_array[index]
 * and x_array[index+1] depends on the result region, i.e. the
 * behaviour at the boundaries may not correspond to what you
 * expect. We have the following complete specification of the
 * behaviour.
 * Suppose the input is x_array[] = { x0, x1, ..., xN }
 *    if ( x == x0 )           then  index == 0
 *    if ( x > x0 && x <= x1 ) then  index == 0, and sim. for other interior pts
 *    if ( x == xN )           then  index == N-1
 *    if ( x > xN )            then  index == N-1
 *    if ( x < x0 )            then  index == 0 
 */
// #endif

/* */ public static native @Cast("size_t") long gsl_interp_accel_find(gsl_interp_accel a, @Const DoublePointer x_array, @Cast("size_t") long size, double x);
public static native @Cast("size_t") long gsl_interp_accel_find(gsl_interp_accel a, @Const DoubleBuffer x_array, @Cast("size_t") long size, double x);
public static native @Cast("size_t") long gsl_interp_accel_find(gsl_interp_accel a, @Const double[] x_array, @Cast("size_t") long size, double x);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

// #endif /* __GSL_INTERP_H__ */


// Parsed from gsl/gsl_linalg.h

/* linalg/gsl_linalg.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2006, 2007, 2019 Gerard Jungman, Brian Gough, Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_LINALG_H__
// #define __GSL_LINALG_H__

// #include <stdlib.h>
// #include <gsl/gsl_mode.h>
// #include <gsl/gsl_permutation.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_blas.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// #define __BEGIN_DECLS extern "C" {
// #define __END_DECLS }
// #else
// #endif

/** enum gsl_linalg_matrix_mod_t */
public static final int
    GSL_LINALG_MOD_NONE = 0,
    GSL_LINALG_MOD_TRANSPOSE = 1,
    GSL_LINALG_MOD_CONJUGATE = 2;

/* Note: You can now use the gsl_blas_dgemm function instead of matmult */

/* Simple implementation of matrix multiply.
 * Calculates C = A.B
 *
 * exceptions: GSL_EBADLEN
 */
public static native int gsl_linalg_matmult(@Const gsl_matrix A,
                        @Const gsl_matrix B,
                        gsl_matrix C);


/* Simple implementation of matrix multiply.
 * Allows transposition of either matrix, so it
 * can compute A.B or Trans(A).B or A.Trans(B) or Trans(A).Trans(B)
 *
 * exceptions: GSL_EBADLEN
 */
public static native int gsl_linalg_matmult_mod(@Const gsl_matrix A,
                            @Cast("gsl_linalg_matrix_mod_t") int modA,
                            @Const gsl_matrix B,
                            @Cast("gsl_linalg_matrix_mod_t") int modB,
                            gsl_matrix C);

/* Calculate the matrix exponential by the scaling and
 * squaring method described in Moler + Van Loan,
 * SIAM Rev 20, 801 (1978). The mode argument allows
 * choosing an optimal strategy, from the table
 * given in the paper, for a given precision.
 *
 * exceptions: GSL_ENOTSQR, GSL_EBADLEN
 */
public static native int gsl_linalg_exponential_ss(
  @Const gsl_matrix A,
  gsl_matrix eA,
  @Cast("gsl_mode_t") int mode
  );


/* Householder Transformations */

public static native double gsl_linalg_householder_transform(gsl_vector v);
public static native double gsl_linalg_householder_transform2(DoublePointer alpha, gsl_vector v);
public static native double gsl_linalg_householder_transform2(DoubleBuffer alpha, gsl_vector v);
public static native double gsl_linalg_householder_transform2(double[] alpha, gsl_vector v);
public static native @ByVal gsl_complex gsl_linalg_complex_householder_transform(gsl_vector_complex v);

public static native int gsl_linalg_householder_hm(double tau, 
                               @Const gsl_vector v, 
                               gsl_matrix A);

public static native int gsl_linalg_householder_mh(double tau, 
                               @Const gsl_vector v, 
                               gsl_matrix A);

public static native int gsl_linalg_householder_hv(double tau, 
                               @Const gsl_vector v, 
                               gsl_vector w);

public static native int gsl_linalg_householder_left(double tau,
                                @Const gsl_vector v,
                                gsl_matrix A,
                                gsl_vector work);

public static native int gsl_linalg_householder_right(double tau,
                                 @Const gsl_vector v,
                                 gsl_matrix A,
                                 gsl_vector work);

public static native int gsl_linalg_householder_hm1(double tau, 
                                gsl_matrix A);

public static native int gsl_linalg_complex_householder_hm(@ByVal gsl_complex tau, 
                                       @Const gsl_vector_complex v, 
                                       gsl_matrix_complex A);

public static native int gsl_linalg_complex_householder_mh(@ByVal gsl_complex tau,
                                       @Const gsl_vector_complex v,
                                       gsl_matrix_complex A);

public static native int gsl_linalg_complex_householder_hv(@ByVal gsl_complex tau, 
                                       @Const gsl_vector_complex v, 
                                       gsl_vector_complex w);

public static native int gsl_linalg_complex_householder_left(@Const @ByVal gsl_complex tau,
                                         @Const gsl_vector_complex v,
                                         gsl_matrix_complex A,
                                         gsl_vector_complex work);

/* Hessenberg reduction */

public static native int gsl_linalg_hessenberg_decomp(gsl_matrix A, gsl_vector tau);
public static native int gsl_linalg_hessenberg_unpack(gsl_matrix H, gsl_vector tau,
                                 gsl_matrix U);
public static native int gsl_linalg_hessenberg_unpack_accum(gsl_matrix H, gsl_vector tau,
                                       gsl_matrix U);
public static native int gsl_linalg_hessenberg_set_zero(gsl_matrix H);
public static native int gsl_linalg_hessenberg_submatrix(gsl_matrix M, gsl_matrix A,
                                    @Cast("size_t") long top, gsl_vector tau);

/* Hessenberg-Triangular reduction */

public static native int gsl_linalg_hesstri_decomp(gsl_matrix A, gsl_matrix B,
                              gsl_matrix U, gsl_matrix V,
                              gsl_vector work);

/* Singular Value Decomposition

 * exceptions: 
 */

public static native int gsl_linalg_SV_decomp(gsl_matrix A,
                      gsl_matrix V,
                      gsl_vector S,
                      gsl_vector work);

public static native int gsl_linalg_SV_decomp_mod(gsl_matrix A,
                          gsl_matrix X,
                          gsl_matrix V,
                          gsl_vector S,
                          gsl_vector work);

public static native int gsl_linalg_SV_decomp_jacobi(gsl_matrix A,
                                 gsl_matrix Q,
                                 gsl_vector S);

public static native int gsl_linalg_SV_solve(@Const gsl_matrix U,
                     @Const gsl_matrix Q,
                     @Const gsl_vector S,
                     @Const gsl_vector b,
                     gsl_vector x);

public static native int gsl_linalg_SV_leverage(@Const gsl_matrix U, gsl_vector h);


/* LU Decomposition, Gaussian elimination with partial pivoting
 */

public static native int gsl_linalg_LU_decomp(gsl_matrix A, gsl_permutation p, IntPointer signum);
public static native int gsl_linalg_LU_decomp(gsl_matrix A, gsl_permutation p, IntBuffer signum);
public static native int gsl_linalg_LU_decomp(gsl_matrix A, gsl_permutation p, int[] signum);

public static native int gsl_linalg_LU_solve(@Const gsl_matrix LU,
                         @Const gsl_permutation p,
                         @Const gsl_vector b,
                         gsl_vector x);

public static native int gsl_linalg_LU_svx(@Const gsl_matrix LU,
                       @Const gsl_permutation p,
                       gsl_vector x);

public static native int gsl_linalg_LU_refine(@Const gsl_matrix A,
                          @Const gsl_matrix LU,
                          @Const gsl_permutation p,
                          @Const gsl_vector b,
                          gsl_vector x,
                          gsl_vector work);

public static native int gsl_linalg_LU_invert(@Const gsl_matrix LU,
                          @Const gsl_permutation p,
                          gsl_matrix inverse);
public static native int gsl_linalg_LU_invx(gsl_matrix LU, @Const gsl_permutation p);

public static native double gsl_linalg_LU_det(gsl_matrix LU, int signum);
public static native double gsl_linalg_LU_lndet(gsl_matrix LU);
public static native int gsl_linalg_LU_sgndet(gsl_matrix lu, int signum);

/* Banded LU decomposition */

public static native int gsl_linalg_LU_band_decomp(@Cast("const size_t") long M, @Cast("const size_t") long lb, @Cast("const size_t") long ub, gsl_matrix AB, gsl_vector_uint piv);

public static native int gsl_linalg_LU_band_solve(@Cast("const size_t") long lb, @Cast("const size_t") long ub, @Const gsl_matrix LUB,
                              @Const gsl_vector_uint piv, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_LU_band_svx(@Cast("const size_t") long lb, @Cast("const size_t") long ub, @Const gsl_matrix LUB,
                            @Const gsl_vector_uint piv, gsl_vector x);

public static native int gsl_linalg_LU_band_unpack(@Cast("const size_t") long M, @Cast("const size_t") long lb, @Cast("const size_t") long ub, @Const gsl_matrix LUB,
                               @Const gsl_vector_uint piv, gsl_matrix L, gsl_matrix U);

/* Complex LU Decomposition */

public static native int gsl_linalg_complex_LU_decomp(gsl_matrix_complex A, 
                                  gsl_permutation p, 
                                  IntPointer signum);
public static native int gsl_linalg_complex_LU_decomp(gsl_matrix_complex A, 
                                  gsl_permutation p, 
                                  IntBuffer signum);
public static native int gsl_linalg_complex_LU_decomp(gsl_matrix_complex A, 
                                  gsl_permutation p, 
                                  int[] signum);

public static native int gsl_linalg_complex_LU_solve(@Const gsl_matrix_complex LU,
                                 @Const gsl_permutation p,
                                 @Const gsl_vector_complex b,
                                 gsl_vector_complex x);

public static native int gsl_linalg_complex_LU_svx(@Const gsl_matrix_complex LU,
                               @Const gsl_permutation p,
                               gsl_vector_complex x);

public static native int gsl_linalg_complex_LU_refine(@Const gsl_matrix_complex A,
                                  @Const gsl_matrix_complex LU,
                                  @Const gsl_permutation p,
                                  @Const gsl_vector_complex b,
                                  gsl_vector_complex x,
                                  gsl_vector_complex work);

public static native int gsl_linalg_complex_LU_invert(@Const gsl_matrix_complex LU,
                                  @Const gsl_permutation p,
                                  gsl_matrix_complex inverse);
public static native int gsl_linalg_complex_LU_invx(gsl_matrix_complex LU, @Const gsl_permutation p);

public static native @ByVal gsl_complex gsl_linalg_complex_LU_det(gsl_matrix_complex LU,
                                       int signum);

public static native double gsl_linalg_complex_LU_lndet(gsl_matrix_complex LU);

public static native @ByVal gsl_complex gsl_linalg_complex_LU_sgndet(gsl_matrix_complex LU,
                                          int signum);

/* QR decomposition */

public static native int gsl_linalg_QR_decomp(gsl_matrix A, gsl_vector tau);

public static native int gsl_linalg_QR_decomp_old(gsl_matrix A, gsl_vector tau);

public static native int gsl_linalg_QR_decomp_r(gsl_matrix A, gsl_matrix T);

public static native int gsl_linalg_QR_solve(@Const gsl_matrix QR, @Const gsl_vector tau, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_QR_solve_r(@Const gsl_matrix QR, @Const gsl_matrix T, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_QR_svx(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_vector x);

public static native int gsl_linalg_QR_lssolve(@Const gsl_matrix QR, @Const gsl_vector tau, @Const gsl_vector b, 
                           gsl_vector x, gsl_vector residual);

public static native int gsl_linalg_QR_lssolve_r(@Const gsl_matrix QR, @Const gsl_matrix T, @Const gsl_vector b,
                             gsl_vector x, gsl_vector work);

public static native int gsl_linalg_QR_QRsolve(gsl_matrix Q, gsl_matrix R, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_QR_Rsolve(@Const gsl_matrix QR, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_QR_Rsvx(@Const gsl_matrix QR, gsl_vector x);

public static native int gsl_linalg_QR_update(gsl_matrix Q, gsl_matrix R, gsl_vector w, @Const gsl_vector v);

public static native int gsl_linalg_QR_QTvec(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_vector v);

public static native int gsl_linalg_QR_QTvec_r(@Const gsl_matrix QR, @Const gsl_matrix T, gsl_vector b, gsl_vector work);

public static native int gsl_linalg_QR_Qvec(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_vector v);

public static native int gsl_linalg_QR_QTmat(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_matrix A);

public static native int gsl_linalg_QR_QTmat_r(@Const gsl_matrix QR, @Const gsl_matrix T, gsl_matrix B, gsl_matrix work);

public static native int gsl_linalg_QR_matQ(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_matrix A);

public static native int gsl_linalg_QR_unpack(@Const gsl_matrix QR, @Const gsl_vector tau, gsl_matrix Q, gsl_matrix R);

public static native int gsl_linalg_QR_unpack_r(@Const gsl_matrix QR, @Const gsl_matrix T, gsl_matrix Q, gsl_matrix R);

public static native int gsl_linalg_R_solve(@Const gsl_matrix R, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_R_svx(@Const gsl_matrix R, gsl_vector x);

public static native int gsl_linalg_QR_rcond(@Const gsl_matrix QR, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_QR_rcond(@Const gsl_matrix QR, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_QR_rcond(@Const gsl_matrix QR, double[] rcond, gsl_vector work);

/* complex QR decomposition */

public static native int gsl_linalg_complex_QR_decomp(gsl_matrix_complex A, gsl_vector_complex tau);

public static native int gsl_linalg_complex_QR_decomp_r(gsl_matrix_complex A, gsl_matrix_complex T);

public static native int gsl_linalg_complex_QR_solve(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau,
                                 @Const gsl_vector_complex b, gsl_vector_complex x);

public static native int gsl_linalg_complex_QR_solve_r(@Const gsl_matrix_complex QR, @Const gsl_matrix_complex T,
                                   @Const gsl_vector_complex b, gsl_vector_complex x);

public static native int gsl_linalg_complex_QR_svx(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau, gsl_vector_complex x);

public static native int gsl_linalg_complex_QR_lssolve(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau,
                                   @Const gsl_vector_complex b, gsl_vector_complex x,
                                   gsl_vector_complex residual);

public static native int gsl_linalg_complex_QR_lssolve_r(@Const gsl_matrix_complex QR, @Const gsl_matrix_complex T,
                                     @Const gsl_vector_complex b, gsl_vector_complex x, gsl_vector_complex work);

public static native int gsl_linalg_complex_QR_QHvec(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau, gsl_vector_complex v);

public static native int gsl_linalg_complex_QR_QHvec_r(@Const gsl_matrix_complex QR, @Const gsl_matrix_complex T,
                                  gsl_vector_complex b, gsl_vector_complex work);

public static native int gsl_linalg_complex_QR_Qvec(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau, gsl_vector_complex v);

public static native int gsl_linalg_complex_QR_unpack(@Const gsl_matrix_complex QR, @Const gsl_vector_complex tau,
                                  gsl_matrix_complex Q, gsl_matrix_complex R);

public static native int gsl_linalg_complex_QR_unpack_r(@Const gsl_matrix_complex QR, @Const gsl_matrix_complex T,
                                   gsl_matrix_complex Q, gsl_matrix_complex R);

/* banded QR decomposition */

public static native int gsl_linalg_QR_band_decomp_L2(@Cast("const size_t") long M, @Cast("const size_t") long p, @Cast("const size_t") long q,
                                  gsl_matrix AB, gsl_vector tau);

public static native int gsl_linalg_QR_band_unpack_L2(@Cast("const size_t") long p, @Cast("const size_t") long q, @Const gsl_matrix QRB,
                                  @Const gsl_vector tau, gsl_matrix Q, gsl_matrix R);

/* Q R P^T decomposition */

public static native int gsl_linalg_QRPT_decomp(gsl_matrix A,
                            gsl_vector tau,
                            gsl_permutation p,
                            IntPointer signum,
                            gsl_vector norm);
public static native int gsl_linalg_QRPT_decomp(gsl_matrix A,
                            gsl_vector tau,
                            gsl_permutation p,
                            IntBuffer signum,
                            gsl_vector norm);
public static native int gsl_linalg_QRPT_decomp(gsl_matrix A,
                            gsl_vector tau,
                            gsl_permutation p,
                            int[] signum,
                            gsl_vector norm);

public static native int gsl_linalg_QRPT_decomp2(@Const gsl_matrix A, 
                             gsl_matrix q, gsl_matrix r, 
                             gsl_vector tau, 
                             gsl_permutation p, 
                             IntPointer signum,
                             gsl_vector norm);
public static native int gsl_linalg_QRPT_decomp2(@Const gsl_matrix A, 
                             gsl_matrix q, gsl_matrix r, 
                             gsl_vector tau, 
                             gsl_permutation p, 
                             IntBuffer signum,
                             gsl_vector norm);
public static native int gsl_linalg_QRPT_decomp2(@Const gsl_matrix A, 
                             gsl_matrix q, gsl_matrix r, 
                             gsl_vector tau, 
                             gsl_permutation p, 
                             int[] signum,
                             gsl_vector norm);

public static native int gsl_linalg_QRPT_solve(@Const gsl_matrix QR,
                           @Const gsl_vector tau,
                           @Const gsl_permutation p,
                           @Const gsl_vector b,
                           gsl_vector x);

public static native int gsl_linalg_QRPT_lssolve(@Const gsl_matrix QR,
                             @Const gsl_vector tau,
                             @Const gsl_permutation p,
                             @Const gsl_vector b,
                             gsl_vector x,
                             gsl_vector residual);

public static native int gsl_linalg_QRPT_lssolve2(@Const gsl_matrix QR,
                              @Const gsl_vector tau,
                              @Const gsl_permutation p,
                              @Const gsl_vector b,
                              @Cast("const size_t") long rank,
                              gsl_vector x,
                              gsl_vector residual);

public static native int gsl_linalg_QRPT_svx(@Const gsl_matrix QR,
                         @Const gsl_vector tau,
                         @Const gsl_permutation p,
                         gsl_vector x);

public static native int gsl_linalg_QRPT_QRsolve(@Const gsl_matrix Q,
                             @Const gsl_matrix R,
                             @Const gsl_permutation p,
                             @Const gsl_vector b,
                             gsl_vector x);

public static native int gsl_linalg_QRPT_Rsolve(@Const gsl_matrix QR,
                             @Const gsl_permutation p,
                             @Const gsl_vector b,
                             gsl_vector x);

public static native int gsl_linalg_QRPT_Rsvx(@Const gsl_matrix QR,
                           @Const gsl_permutation p,
                           gsl_vector x);

public static native int gsl_linalg_QRPT_update(gsl_matrix Q,
                            gsl_matrix R,
                            @Const gsl_permutation p,
                            gsl_vector u,
                            @Const gsl_vector v);

public static native @Cast("size_t") long gsl_linalg_QRPT_rank(@Const gsl_matrix QR, double tol);

public static native int gsl_linalg_QRPT_rcond(@Const gsl_matrix QR, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_QRPT_rcond(@Const gsl_matrix QR, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_QRPT_rcond(@Const gsl_matrix QR, double[] rcond, gsl_vector work);

/* triangle on top of diagonal QR decomposition */

public static native int gsl_linalg_QR_UD_decomp(gsl_matrix U, @Const gsl_vector D, gsl_matrix Y, gsl_matrix T);

public static native int gsl_linalg_QR_UD_lssolve(@Const gsl_matrix R, @Const gsl_matrix Y, @Const gsl_matrix T,
                              @Const gsl_vector b, gsl_vector x, gsl_vector work);

/* triangle on top of rectangle QR decomposition */

public static native int gsl_linalg_QR_UR_decomp(gsl_matrix S, gsl_matrix A, gsl_matrix T);

/* triangle on top of triangle QR decomposition */

public static native int gsl_linalg_QR_UU_decomp(gsl_matrix U, gsl_matrix S, gsl_matrix T);

public static native int gsl_linalg_QR_UU_lssolve(@Const gsl_matrix R, @Const gsl_matrix Y, @Const gsl_matrix T,
                              @Const gsl_vector b, gsl_vector x, gsl_vector work);

public static native int gsl_linalg_QR_UU_QTvec(@Const gsl_matrix Y, @Const gsl_matrix T, gsl_vector b, gsl_vector work);

/* triangle on top of trapezoidal QR decomposition */

public static native int gsl_linalg_QR_UZ_decomp(gsl_matrix S, gsl_matrix A, gsl_matrix T);

/* QL decomposition */

public static native int gsl_linalg_QL_decomp(gsl_matrix A, gsl_vector tau);

public static native int gsl_linalg_QL_unpack(@Const gsl_matrix QL, @Const gsl_vector tau, gsl_matrix Q, gsl_matrix L);

/* COD decomposition */

public static native int gsl_linalg_COD_decomp(gsl_matrix A, gsl_vector tau_Q, gsl_vector tau_Z,
                          gsl_permutation p, @Cast("size_t*") SizeTPointer rank, gsl_vector work);

public static native int gsl_linalg_COD_decomp_e(gsl_matrix A, gsl_vector tau_Q, gsl_vector tau_Z,
                            gsl_permutation p, double tol, @Cast("size_t*") SizeTPointer rank, gsl_vector work);

public static native int gsl_linalg_COD_lssolve(@Const gsl_matrix QRZT, @Const gsl_vector tau_Q, @Const gsl_vector tau_Z,
                            @Const gsl_permutation perm, @Cast("const size_t") long rank, @Const gsl_vector b,
                            gsl_vector x, gsl_vector residual);

public static native int gsl_linalg_COD_lssolve2(double lambda, @Const gsl_matrix QRZT, @Const gsl_vector tau_Q, @Const gsl_vector tau_Z,
                         @Const gsl_permutation perm, @Cast("const size_t") long rank, @Const gsl_vector b,
                         gsl_vector x, gsl_vector residual, gsl_matrix S, gsl_vector work);

public static native int gsl_linalg_COD_unpack(@Const gsl_matrix QRZT, @Const gsl_vector tau_Q,
                          @Const gsl_vector tau_Z, @Cast("const size_t") long rank, gsl_matrix Q,
                          gsl_matrix R, gsl_matrix Z);

public static native int gsl_linalg_COD_matZ(@Const gsl_matrix QRZT, @Const gsl_vector tau_Z, @Cast("const size_t") long rank,
                        gsl_matrix A, gsl_vector work);

/* LQ decomposition */

public static native int gsl_linalg_LQ_decomp(gsl_matrix A, gsl_vector tau);

public static native int gsl_linalg_LQ_lssolve(@Const gsl_matrix LQ, @Const gsl_vector tau,
                          @Const gsl_vector b, gsl_vector x, gsl_vector residual);

public static native int gsl_linalg_LQ_QTvec(@Const gsl_matrix LQ, @Const gsl_vector tau, gsl_vector v);

public static native int gsl_linalg_LQ_solve_T(@Const gsl_matrix LQ, @Const gsl_vector tau, 
			 @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_LQ_svx_T(@Const gsl_matrix LQ, @Const gsl_vector tau, 
                         gsl_vector x);

public static native int gsl_linalg_LQ_lssolve_T(@Const gsl_matrix LQ, @Const gsl_vector tau, 
			   @Const gsl_vector b, gsl_vector x, 
			   gsl_vector residual);

public static native int gsl_linalg_LQ_Lsolve_T(@Const gsl_matrix LQ, @Const gsl_vector b, 
			  gsl_vector x);

public static native int gsl_linalg_LQ_Lsvx_T(@Const gsl_matrix LQ, gsl_vector x);

public static native int gsl_linalg_L_solve_T(@Const gsl_matrix L, @Const gsl_vector b, 
			gsl_vector x);

public static native int gsl_linalg_LQ_vecQ(@Const gsl_matrix LQ, @Const gsl_vector tau, 
			gsl_vector v);

public static native int gsl_linalg_LQ_vecQT(@Const gsl_matrix LQ, @Const gsl_vector tau, 
			 gsl_vector v);

public static native int gsl_linalg_LQ_unpack(@Const gsl_matrix LQ, @Const gsl_vector tau, 
			  gsl_matrix Q, gsl_matrix L);

public static native int gsl_linalg_LQ_update(gsl_matrix Q, gsl_matrix R,
			  @Const gsl_vector v, gsl_vector w);
public static native int gsl_linalg_LQ_LQsolve(gsl_matrix Q, gsl_matrix L, 
			   @Const gsl_vector b, gsl_vector x);

/* P^T L Q decomposition */

public static native int gsl_linalg_PTLQ_decomp(gsl_matrix A, gsl_vector tau, 
			    gsl_permutation p, IntPointer signum, 
			    gsl_vector norm);
public static native int gsl_linalg_PTLQ_decomp(gsl_matrix A, gsl_vector tau, 
			    gsl_permutation p, IntBuffer signum, 
			    gsl_vector norm);
public static native int gsl_linalg_PTLQ_decomp(gsl_matrix A, gsl_vector tau, 
			    gsl_permutation p, int[] signum, 
			    gsl_vector norm);

public static native int gsl_linalg_PTLQ_decomp2(@Const gsl_matrix A, gsl_matrix q, 
			     gsl_matrix r, gsl_vector tau, 
			     gsl_permutation p, IntPointer signum, 
			     gsl_vector norm);
public static native int gsl_linalg_PTLQ_decomp2(@Const gsl_matrix A, gsl_matrix q, 
			     gsl_matrix r, gsl_vector tau, 
			     gsl_permutation p, IntBuffer signum, 
			     gsl_vector norm);
public static native int gsl_linalg_PTLQ_decomp2(@Const gsl_matrix A, gsl_matrix q, 
			     gsl_matrix r, gsl_vector tau, 
			     gsl_permutation p, int[] signum, 
			     gsl_vector norm);

public static native int gsl_linalg_PTLQ_solve_T(@Const gsl_matrix QR,
			   @Const gsl_vector tau,
			   @Const gsl_permutation p,
			   @Const gsl_vector b,
			   gsl_vector x);

public static native int gsl_linalg_PTLQ_svx_T(@Const gsl_matrix LQ,
                           @Const gsl_vector tau,
                           @Const gsl_permutation p,
                           gsl_vector x);

public static native int gsl_linalg_PTLQ_LQsolve_T(@Const gsl_matrix Q, @Const gsl_matrix L,
			     @Const gsl_permutation p,
			     @Const gsl_vector b,
			     gsl_vector x);

public static native int gsl_linalg_PTLQ_Lsolve_T(@Const gsl_matrix LQ,
			    @Const gsl_permutation p,
			    @Const gsl_vector b,
			    gsl_vector x);

public static native int gsl_linalg_PTLQ_Lsvx_T(@Const gsl_matrix LQ,
			  @Const gsl_permutation p,
			  gsl_vector x);

public static native int gsl_linalg_PTLQ_update(gsl_matrix Q, gsl_matrix L,
			    @Const gsl_permutation p,
			    @Const gsl_vector v, gsl_vector w);

/* Cholesky Decomposition */

public static native int gsl_linalg_cholesky_decomp(gsl_matrix A);
public static native int gsl_linalg_cholesky_decomp1(gsl_matrix A);

public static native int gsl_linalg_cholesky_solve(@Const gsl_matrix cholesky,
                               @Const gsl_vector b,
                               gsl_vector x);
public static native int gsl_linalg_cholesky_solve_mat(@Const gsl_matrix cholesky,
                                   @Const gsl_matrix B,
                                   gsl_matrix X);

public static native int gsl_linalg_cholesky_svx(@Const gsl_matrix cholesky,
                             gsl_vector x);
public static native int gsl_linalg_cholesky_svx_mat(@Const gsl_matrix cholesky,
                                 gsl_matrix X);

public static native int gsl_linalg_cholesky_invert(gsl_matrix cholesky);

/* Cholesky decomposition with unit-diagonal triangular parts.
 *   A = L D L^T, where diag(L) = (1,1,...,1).
 *   Upon exit, A contains L and L^T as for Cholesky, and
 *   the diagonal of A is (1,1,...,1). The vector Dis set
 *   to the diagonal elements of the diagonal matrix D.
 */
public static native int gsl_linalg_cholesky_decomp_unit(gsl_matrix A, gsl_vector D);

public static native int gsl_linalg_cholesky_scale(@Const gsl_matrix A, gsl_vector S);

public static native int gsl_linalg_cholesky_scale_apply(gsl_matrix A, @Const gsl_vector S);

public static native int gsl_linalg_cholesky_decomp2(gsl_matrix A, gsl_vector S);

public static native int gsl_linalg_cholesky_svx2(@Const gsl_matrix LLT,
                              @Const gsl_vector S,
                              gsl_vector x);

public static native int gsl_linalg_cholesky_solve2(@Const gsl_matrix LLT,
                                @Const gsl_vector S,
                                @Const gsl_vector b,
                                gsl_vector x);

public static native int gsl_linalg_cholesky_rcond(@Const gsl_matrix LLT, DoublePointer rcond,
                               gsl_vector work);
public static native int gsl_linalg_cholesky_rcond(@Const gsl_matrix LLT, DoubleBuffer rcond,
                               gsl_vector work);
public static native int gsl_linalg_cholesky_rcond(@Const gsl_matrix LLT, double[] rcond,
                               gsl_vector work);

/* Complex Cholesky Decomposition */

public static native int gsl_linalg_complex_cholesky_decomp(gsl_matrix_complex A);

public static native int gsl_linalg_complex_cholesky_solve(@Const gsl_matrix_complex cholesky,
                                       @Const gsl_vector_complex b,
                                       gsl_vector_complex x);

public static native int gsl_linalg_complex_cholesky_svx(@Const gsl_matrix_complex cholesky,
                                     gsl_vector_complex x);

public static native int gsl_linalg_complex_cholesky_invert(gsl_matrix_complex cholesky);

/* Pivoted Cholesky LDLT decomposition */

public static native int gsl_linalg_pcholesky_decomp(gsl_matrix A, gsl_permutation p);

public static native int gsl_linalg_pcholesky_solve(@Const gsl_matrix LDLT,
                               @Const gsl_permutation p,
                               @Const gsl_vector b,
                               gsl_vector x);

public static native int gsl_linalg_pcholesky_svx(@Const gsl_matrix LDLT,
                             @Const gsl_permutation p,
                             gsl_vector x);

public static native int gsl_linalg_pcholesky_decomp2(gsl_matrix A, gsl_permutation p,
                                 gsl_vector S);

public static native int gsl_linalg_pcholesky_solve2(@Const gsl_matrix LDLT,
                                @Const gsl_permutation p,
                                @Const gsl_vector S,
                                @Const gsl_vector b,
                                gsl_vector x);

public static native int gsl_linalg_pcholesky_svx2(@Const gsl_matrix LDLT,
                              @Const gsl_permutation p,
                              @Const gsl_vector S,
                              gsl_vector x);

public static native int gsl_linalg_pcholesky_invert(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                gsl_matrix Ainv);

public static native int gsl_linalg_pcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_pcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_pcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                double[] rcond, gsl_vector work);

/* Modified Cholesky decomposition */

public static native int gsl_linalg_mcholesky_decomp(gsl_matrix A, gsl_permutation p,
                                 gsl_vector E);

public static native int gsl_linalg_mcholesky_solve(@Const gsl_matrix LDLT,
                               @Const gsl_permutation p,
                               @Const gsl_vector b,
                               gsl_vector x);

public static native int gsl_linalg_mcholesky_svx(@Const gsl_matrix LDLT,
                             @Const gsl_permutation p,
                             gsl_vector x);

public static native int gsl_linalg_mcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_mcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_mcholesky_rcond(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                double[] rcond, gsl_vector work);

public static native int gsl_linalg_mcholesky_invert(@Const gsl_matrix LDLT, @Const gsl_permutation p,
                                gsl_matrix Ainv);

/* Banded Cholesky decomposition */

public static native int gsl_linalg_cholesky_band_decomp(gsl_matrix A);

public static native int gsl_linalg_cholesky_band_solve(@Const gsl_matrix LLT, @Const gsl_vector b,
                                    gsl_vector x);

public static native int gsl_linalg_cholesky_band_svx(@Const gsl_matrix LLT, gsl_vector x);

public static native int gsl_linalg_cholesky_band_solvem(@Const gsl_matrix LLT, @Const gsl_matrix B,
                                     gsl_matrix X);

public static native int gsl_linalg_cholesky_band_svxm(@Const gsl_matrix LLT, gsl_matrix X);

public static native int gsl_linalg_cholesky_band_invert(@Const gsl_matrix LLT, gsl_matrix Ainv);

public static native int gsl_linalg_cholesky_band_unpack(@Const gsl_matrix LLT, gsl_matrix L);

public static native int gsl_linalg_cholesky_band_scale(@Const gsl_matrix A, gsl_vector S);

public static native int gsl_linalg_cholesky_band_scale_apply(gsl_matrix A, @Const gsl_vector S);

public static native int gsl_linalg_cholesky_band_rcond(@Const gsl_matrix LLT, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_cholesky_band_rcond(@Const gsl_matrix LLT, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_cholesky_band_rcond(@Const gsl_matrix LLT, double[] rcond, gsl_vector work);

/* L D L^T decomposition */

public static native int gsl_linalg_ldlt_decomp(gsl_matrix A);

public static native int gsl_linalg_ldlt_solve(@Const gsl_matrix LDLT, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_ldlt_svx(@Const gsl_matrix LDLT, gsl_vector x);

public static native int gsl_linalg_ldlt_rcond(@Const gsl_matrix LDLT, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_ldlt_rcond(@Const gsl_matrix LDLT, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_ldlt_rcond(@Const gsl_matrix LDLT, double[] rcond, gsl_vector work);

/* Banded L D L^T decomposition */

public static native int gsl_linalg_ldlt_band_decomp(gsl_matrix A);

public static native int gsl_linalg_ldlt_band_solve(@Const gsl_matrix LDLT, @Const gsl_vector b, gsl_vector x);

public static native int gsl_linalg_ldlt_band_svx(@Const gsl_matrix LDLT, gsl_vector x);

public static native int gsl_linalg_ldlt_band_unpack(@Const gsl_matrix LDLT, gsl_matrix L, gsl_vector D);

public static native int gsl_linalg_ldlt_band_rcond(@Const gsl_matrix LDLT, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_ldlt_band_rcond(@Const gsl_matrix LDLT, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_ldlt_band_rcond(@Const gsl_matrix LDLT, double[] rcond, gsl_vector work);

/* Symmetric to symmetric tridiagonal decomposition */

public static native int gsl_linalg_symmtd_decomp(gsl_matrix A, 
                              gsl_vector tau);

public static native int gsl_linalg_symmtd_unpack(@Const gsl_matrix A, 
                              @Const gsl_vector tau,
                              gsl_matrix Q, 
                              gsl_vector diag, 
                              gsl_vector subdiag);

public static native int gsl_linalg_symmtd_unpack_T(@Const gsl_matrix A,
                                gsl_vector diag, 
                                gsl_vector subdiag);

/* Hermitian to symmetric tridiagonal decomposition */

public static native int gsl_linalg_hermtd_decomp(gsl_matrix_complex A, 
                              gsl_vector_complex tau);

public static native int gsl_linalg_hermtd_unpack(@Const gsl_matrix_complex A, 
                              @Const gsl_vector_complex tau,
                              gsl_matrix_complex U, 
                              gsl_vector diag, 
                              gsl_vector sudiag);

public static native int gsl_linalg_hermtd_unpack_T(@Const gsl_matrix_complex A, 
                                gsl_vector diag, 
                                gsl_vector subdiag);

/* Linear Solve Using Householder Transformations

 * exceptions: 
 */

public static native int gsl_linalg_HH_solve(gsl_matrix A, @Const gsl_vector b, gsl_vector x);
public static native int gsl_linalg_HH_svx(gsl_matrix A, gsl_vector x);

/* Linear solve for a symmetric tridiagonal system.

 * The input vectors represent the NxN matrix as follows:
 *
 *     diag[0]  offdiag[0]             0    ...
 *  offdiag[0]     diag[1]    offdiag[1]    ...
 *           0  offdiag[1]       diag[2]    ...
 *           0           0    offdiag[2]    ...
 *         ...         ...           ...    ...
 */
public static native int gsl_linalg_solve_symm_tridiag(@Const gsl_vector diag,
                                   @Const gsl_vector offdiag,
                                   @Const gsl_vector b,
                                   gsl_vector x);

/* Linear solve for a nonsymmetric tridiagonal system.

 * The input vectors represent the NxN matrix as follows:
 *
 *       diag[0]  abovediag[0]              0    ...
 *  belowdiag[0]       diag[1]   abovediag[1]    ...
 *             0  belowdiag[1]        diag[2]    ...
 *             0             0   belowdiag[2]    ...
 *           ...           ...            ...    ...
 */
public static native int gsl_linalg_solve_tridiag(@Const gsl_vector diag,
                                   @Const gsl_vector abovediag,
                                   @Const gsl_vector belowdiag,
                                   @Const gsl_vector b,
                                   gsl_vector x);


/* Linear solve for a symmetric cyclic tridiagonal system.

 * The input vectors represent the NxN matrix as follows:
 *
 *      diag[0]  offdiag[0]             0   .....  offdiag[N-1]
 *   offdiag[0]     diag[1]    offdiag[1]   .....
 *            0  offdiag[1]       diag[2]   .....
 *            0           0    offdiag[2]   .....
 *          ...         ...
 * offdiag[N-1]         ...
 */
public static native int gsl_linalg_solve_symm_cyc_tridiag(@Const gsl_vector diag,
                                       @Const gsl_vector offdiag,
                                       @Const gsl_vector b,
                                       gsl_vector x);

/* Linear solve for a nonsymmetric cyclic tridiagonal system.

 * The input vectors represent the NxN matrix as follows:
 *
 *        diag[0]  abovediag[0]             0   .....  belowdiag[N-1]
 *   belowdiag[0]       diag[1]  abovediag[1]   .....
 *              0  belowdiag[1]       diag[2]
 *              0             0  belowdiag[2]   .....
 *            ...           ...
 * abovediag[N-1]           ...
 */
public static native int gsl_linalg_solve_cyc_tridiag(@Const gsl_vector diag,
                                  @Const gsl_vector abovediag,
                                  @Const gsl_vector belowdiag,
                                  @Const gsl_vector b,
                                  gsl_vector x);


/* Bidiagonal decomposition */

public static native int gsl_linalg_bidiag_decomp(gsl_matrix A, 
                              gsl_vector tau_U, 
                              gsl_vector tau_V);

public static native int gsl_linalg_bidiag_unpack(@Const gsl_matrix A, 
                              @Const gsl_vector tau_U, 
                              gsl_matrix U, 
                              @Const gsl_vector tau_V,
                              gsl_matrix V,
                              gsl_vector diag, 
                              gsl_vector superdiag);

public static native int gsl_linalg_bidiag_unpack2(gsl_matrix A, 
                               gsl_vector tau_U, 
                               gsl_vector tau_V,
                               gsl_matrix V);

public static native int gsl_linalg_bidiag_unpack_B(@Const gsl_matrix A, 
                                gsl_vector diag, 
                                gsl_vector superdiag);

/* Balancing */

public static native int gsl_linalg_balance_matrix(gsl_matrix A, gsl_vector D);
public static native int gsl_linalg_balance_accum(gsl_matrix A, gsl_vector D);
public static native int gsl_linalg_balance_columns(gsl_matrix A, gsl_vector D);

/* condition estimation */

public static native int gsl_linalg_tri_rcond(@Cast("CBLAS_UPLO_t") int Uplo, @Const gsl_matrix A, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_tri_rcond(@Cast("CBLAS_UPLO_t") int Uplo, @Const gsl_matrix A, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_tri_rcond(@Cast("CBLAS_UPLO_t") int Uplo, @Const gsl_matrix A, double[] rcond, gsl_vector work);
public static native int gsl_linalg_tri_upper_rcond(@Const gsl_matrix A, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_tri_upper_rcond(@Const gsl_matrix A, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_tri_upper_rcond(@Const gsl_matrix A, double[] rcond, gsl_vector work);
public static native int gsl_linalg_tri_lower_rcond(@Const gsl_matrix A, DoublePointer rcond, gsl_vector work);
public static native int gsl_linalg_tri_lower_rcond(@Const gsl_matrix A, DoubleBuffer rcond, gsl_vector work);
public static native int gsl_linalg_tri_lower_rcond(@Const gsl_matrix A, double[] rcond, gsl_vector work);
// Targeting ../Ainvx_int_gsl_vector_Pointer.java


public static native int gsl_linalg_invnorm1(@Cast("const size_t") long N,
                        Ainvx_int_gsl_vector_Pointer Ainvx,
                        Pointer params, DoublePointer Ainvnorm, gsl_vector work);
public static native int gsl_linalg_invnorm1(@Cast("const size_t") long N,
                        Ainvx_int_gsl_vector_Pointer Ainvx,
                        Pointer params, DoubleBuffer Ainvnorm, gsl_vector work);
public static native int gsl_linalg_invnorm1(@Cast("const size_t") long N,
                        Ainvx_int_gsl_vector_Pointer Ainvx,
                        Pointer params, double[] Ainvnorm, gsl_vector work);

/* triangular matrices */

public static native int gsl_linalg_tri_upper_invert(gsl_matrix T);
public static native int gsl_linalg_tri_lower_invert(gsl_matrix T);
public static native int gsl_linalg_tri_upper_unit_invert(gsl_matrix T);
public static native int gsl_linalg_tri_lower_unit_invert(gsl_matrix T);

public static native int gsl_linalg_tri_invert(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix T);
public static native int gsl_linalg_complex_tri_invert(@Cast("CBLAS_UPLO_t") int Uplo, @Cast("CBLAS_DIAG_t") int Diag, gsl_matrix_complex T);

public static native int gsl_linalg_tri_LTL(gsl_matrix L);
public static native int gsl_linalg_tri_UL(gsl_matrix LU);
public static native int gsl_linalg_complex_tri_LHL(gsl_matrix_complex L);
public static native int gsl_linalg_complex_tri_UL(gsl_matrix_complex LU);

/* */ public static native void gsl_linalg_givens(double a, double b,
                                    DoublePointer c, DoublePointer s);
public static native void gsl_linalg_givens(double a, double b,
                                    DoubleBuffer c, DoubleBuffer s);
public static native void gsl_linalg_givens(double a, double b,
                                    double[] c, double[] s);
/* */ public static native void gsl_linalg_givens_gv(gsl_vector v, @Cast("const size_t") long i,
                                       @Cast("const size_t") long j, double c,
                                       double s);

// #ifdef HAVE_INLINE

/* Generate a Givens rotation (cos,sin) which takes v=(x,y) to (|v|,0) 
   From Golub and Van Loan, "Matrix Computations", Section 5.1.8 */ /* gsl_linalg_givens() */

// #endif /* HAVE_INLINE */

// #endif /* __GSL_LINALG_H__ */


// Parsed from gsl/gsl_poly.h

/* poly/gsl_poly.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_POLY_H__
// #define __GSL_POLY_H__

// #include <stdlib.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_complex.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif


/* Evaluate polynomial
 *
 * c[0] + c[1] x + c[2] x^2 + ... + c[len-1] x^(len-1)
 *
 * exceptions: none
 */

/* real polynomial, real x */
/* */ public static native double gsl_poly_eval(@Const DoublePointer c, int len, double x);
public static native double gsl_poly_eval(@Const DoubleBuffer c, int len, double x);
public static native double gsl_poly_eval(@Const double[] c, int len, double x);

/* real polynomial, complex x */
/* */ public static native @ByVal gsl_complex gsl_poly_complex_eval(@Const DoublePointer c, int len, @Const @ByVal gsl_complex z);
public static native @ByVal gsl_complex gsl_poly_complex_eval(@Const DoubleBuffer c, int len, @Const @ByVal gsl_complex z);
public static native @ByVal gsl_complex gsl_poly_complex_eval(@Const double[] c, int len, @Const @ByVal gsl_complex z);

/* complex polynomial, complex x */
/* */ public static native @ByVal gsl_complex gsl_complex_poly_complex_eval(@Const gsl_complex c, int len, @Const @ByVal gsl_complex z);

public static native int gsl_poly_eval_derivs(@Const DoublePointer c, @Cast("const size_t") long lenc, double x, DoublePointer res, @Cast("const size_t") long lenres);
public static native int gsl_poly_eval_derivs(@Const DoubleBuffer c, @Cast("const size_t") long lenc, double x, DoubleBuffer res, @Cast("const size_t") long lenres);
public static native int gsl_poly_eval_derivs(@Const double[] c, @Cast("const size_t") long lenc, double x, double[] res, @Cast("const size_t") long lenres);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */

/* Work with divided-difference polynomials, Abramowitz & Stegun 25.2.26 */

public static native int gsl_poly_dd_init(DoublePointer dd, @Const DoublePointer x, @Const DoublePointer y,
                  @Cast("size_t") long size);
public static native int gsl_poly_dd_init(DoubleBuffer dd, @Const DoubleBuffer x, @Const DoubleBuffer y,
                  @Cast("size_t") long size);
public static native int gsl_poly_dd_init(double[] dd, @Const double[] x, @Const double[] y,
                  @Cast("size_t") long size);

/* */ public static native double gsl_poly_dd_eval(@Const DoublePointer dd, @Const DoublePointer xa, @Cast("const size_t") long size, double x);
public static native double gsl_poly_dd_eval(@Const DoubleBuffer dd, @Const DoubleBuffer xa, @Cast("const size_t") long size, double x);
public static native double gsl_poly_dd_eval(@Const double[] dd, @Const double[] xa, @Cast("const size_t") long size, double x);

// #ifdef HAVE_INLINE
// #endif /* HAVE_INLINE */


public static native int gsl_poly_dd_taylor(DoublePointer c, double xp,
                    @Const DoublePointer dd, @Const DoublePointer x, @Cast("size_t") long size,
                    DoublePointer w);
public static native int gsl_poly_dd_taylor(DoubleBuffer c, double xp,
                    @Const DoubleBuffer dd, @Const DoubleBuffer x, @Cast("size_t") long size,
                    DoubleBuffer w);
public static native int gsl_poly_dd_taylor(double[] c, double xp,
                    @Const double[] dd, @Const double[] x, @Cast("size_t") long size,
                    double[] w);

public static native int gsl_poly_dd_hermite_init(DoublePointer dd, DoublePointer z, @Const DoublePointer xa, @Const DoublePointer ya,
                          @Const DoublePointer dya, @Cast("const size_t") long size);
public static native int gsl_poly_dd_hermite_init(DoubleBuffer dd, DoubleBuffer z, @Const DoubleBuffer xa, @Const DoubleBuffer ya,
                          @Const DoubleBuffer dya, @Cast("const size_t") long size);
public static native int gsl_poly_dd_hermite_init(double[] dd, double[] z, @Const double[] xa, @Const double[] ya,
                          @Const double[] dya, @Cast("const size_t") long size);

/* Solve for real or complex roots of the standard quadratic equation,
 * returning the number of real roots.
 *
 * Roots are returned ordered.
 */
public static native int gsl_poly_solve_quadratic(double a, double b, double c, 
                              DoublePointer x0, DoublePointer x1);
public static native int gsl_poly_solve_quadratic(double a, double b, double c, 
                              DoubleBuffer x0, DoubleBuffer x1);
public static native int gsl_poly_solve_quadratic(double a, double b, double c, 
                              double[] x0, double[] x1);

public static native int gsl_poly_complex_solve_quadratic(double a, double b, double c, 
                                  gsl_complex z0, gsl_complex z1);


/* Solve for real roots of the cubic equation
 * x^3 + a x^2 + b x + c = 0, returning the
 * number of real roots.
 *
 * Roots are returned ordered.
 */
public static native int gsl_poly_solve_cubic(double a, double b, double c, 
                          DoublePointer x0, DoublePointer x1, DoublePointer x2);
public static native int gsl_poly_solve_cubic(double a, double b, double c, 
                          DoubleBuffer x0, DoubleBuffer x1, DoubleBuffer x2);
public static native int gsl_poly_solve_cubic(double a, double b, double c, 
                          double[] x0, double[] x1, double[] x2);

public static native int gsl_poly_complex_solve_cubic(double a, double b, double c, 
                              gsl_complex z0, gsl_complex z1, 
                              gsl_complex z2);
// Targeting ../gsl_poly_complex_workspace.java



public static native gsl_poly_complex_workspace gsl_poly_complex_workspace_alloc(@Cast("size_t") long n);
public static native void gsl_poly_complex_workspace_free(gsl_poly_complex_workspace w);

public static native int gsl_poly_complex_solve(@Const DoublePointer a, @Cast("size_t") long n, 
                        gsl_poly_complex_workspace w,
                        @Cast("gsl_complex_packed_ptr") DoublePointer z);
public static native int gsl_poly_complex_solve(@Const DoubleBuffer a, @Cast("size_t") long n, 
                        gsl_poly_complex_workspace w,
                        @Cast("gsl_complex_packed_ptr") DoubleBuffer z);
public static native int gsl_poly_complex_solve(@Const double[] a, @Cast("size_t") long n, 
                        gsl_poly_complex_workspace w,
                        @Cast("gsl_complex_packed_ptr") double[] z);

// #endif /* __GSL_POLY_H__ */


// Parsed from gsl/gsl_rng.h

/* rng/gsl_rng.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 James Theiler, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_RNG_H__
// #define __GSL_RNG_H__
// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_rng_type.java


// Targeting ../gsl_rng.java




/* These structs also need to appear in default.c so you can select
   them via the environment variable GSL_RNG_TYPE */

public static native @Const gsl_rng_type gsl_rng_borosh13(); public static native void gsl_rng_borosh13(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_coveyou(); public static native void gsl_rng_coveyou(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_cmrg(); public static native void gsl_rng_cmrg(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_fishman18(); public static native void gsl_rng_fishman18(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_fishman20(); public static native void gsl_rng_fishman20(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_fishman2x(); public static native void gsl_rng_fishman2x(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_gfsr4(); public static native void gsl_rng_gfsr4(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_knuthran(); public static native void gsl_rng_knuthran(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_knuthran2(); public static native void gsl_rng_knuthran2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_knuthran2002(); public static native void gsl_rng_knuthran2002(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_lecuyer21(); public static native void gsl_rng_lecuyer21(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_minstd(); public static native void gsl_rng_minstd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_mrg(); public static native void gsl_rng_mrg(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_mt19937(); public static native void gsl_rng_mt19937(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_mt19937_1999(); public static native void gsl_rng_mt19937_1999(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_mt19937_1998(); public static native void gsl_rng_mt19937_1998(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_r250(); public static native void gsl_rng_r250(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ran0(); public static native void gsl_rng_ran0(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ran1(); public static native void gsl_rng_ran1(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ran2(); public static native void gsl_rng_ran2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ran3(); public static native void gsl_rng_ran3(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_rand(); public static native void gsl_rng_rand(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_rand48(); public static native void gsl_rng_rand48(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random128_bsd(); public static native void gsl_rng_random128_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random128_glibc2(); public static native void gsl_rng_random128_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random128_libc5(); public static native void gsl_rng_random128_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random256_bsd(); public static native void gsl_rng_random256_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random256_glibc2(); public static native void gsl_rng_random256_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random256_libc5(); public static native void gsl_rng_random256_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random32_bsd(); public static native void gsl_rng_random32_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random32_glibc2(); public static native void gsl_rng_random32_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random32_libc5(); public static native void gsl_rng_random32_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random64_bsd(); public static native void gsl_rng_random64_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random64_glibc2(); public static native void gsl_rng_random64_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random64_libc5(); public static native void gsl_rng_random64_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random8_bsd(); public static native void gsl_rng_random8_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random8_glibc2(); public static native void gsl_rng_random8_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random8_libc5(); public static native void gsl_rng_random8_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random_bsd(); public static native void gsl_rng_random_bsd(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random_glibc2(); public static native void gsl_rng_random_glibc2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_random_libc5(); public static native void gsl_rng_random_libc5(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_randu(); public static native void gsl_rng_randu(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranf(); public static native void gsl_rng_ranf(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlux(); public static native void gsl_rng_ranlux(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlux389(); public static native void gsl_rng_ranlux389(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlxd1(); public static native void gsl_rng_ranlxd1(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlxd2(); public static native void gsl_rng_ranlxd2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlxs0(); public static native void gsl_rng_ranlxs0(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlxs1(); public static native void gsl_rng_ranlxs1(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranlxs2(); public static native void gsl_rng_ranlxs2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_ranmar(); public static native void gsl_rng_ranmar(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_slatec(); public static native void gsl_rng_slatec(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_taus(); public static native void gsl_rng_taus(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_taus2(); public static native void gsl_rng_taus2(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_taus113(); public static native void gsl_rng_taus113(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_transputer(); public static native void gsl_rng_transputer(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_tt800(); public static native void gsl_rng_tt800(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_uni(); public static native void gsl_rng_uni(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_uni32(); public static native void gsl_rng_uni32(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_vax(); public static native void gsl_rng_vax(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_waterman14(); public static native void gsl_rng_waterman14(gsl_rng_type setter);
public static native @Const gsl_rng_type gsl_rng_zuf(); public static native void gsl_rng_zuf(gsl_rng_type setter);

public static native @Cast("const gsl_rng_type**") PointerPointer gsl_rng_types_setup();

public static native @Const gsl_rng_type gsl_rng_default(); public static native void gsl_rng_default(gsl_rng_type setter);
public static native @Cast("unsigned long int") long gsl_rng_default_seed(); public static native void gsl_rng_default_seed(long setter);

public static native gsl_rng gsl_rng_alloc(@Const gsl_rng_type T);
public static native int gsl_rng_memcpy(gsl_rng dest, @Const gsl_rng src);
public static native gsl_rng gsl_rng_clone(@Const gsl_rng r);

public static native void gsl_rng_free(gsl_rng r);

public static native void gsl_rng_set(@Const gsl_rng r, @Cast("unsigned long int") long seed);
public static native @Cast("unsigned long int") long gsl_rng_max(@Const gsl_rng r);
public static native @Cast("unsigned long int") long gsl_rng_min(@Const gsl_rng r);
public static native @Cast("const char*") BytePointer gsl_rng_name(@Const gsl_rng r);

public static native int gsl_rng_fread(FILE stream, gsl_rng r);
public static native int gsl_rng_fwrite(FILE stream, @Const gsl_rng r);

public static native @Cast("size_t") long gsl_rng_size(@Const gsl_rng r);
public static native Pointer gsl_rng_state(@Const gsl_rng r);

public static native void gsl_rng_print_state(@Const gsl_rng r);

public static native @Const gsl_rng_type gsl_rng_env_setup();

/* */ public static native @Cast("unsigned long int") long gsl_rng_get(@Const gsl_rng r);
/* */ public static native double gsl_rng_uniform(@Const gsl_rng r);
/* */ public static native double gsl_rng_uniform_pos(@Const gsl_rng r);
/* */ public static native @Cast("unsigned long int") long gsl_rng_uniform_int(@Const gsl_rng r, @Cast("unsigned long int") long n);

// #ifdef HAVE_INLINE

/* Note: to avoid integer overflow in (range+1) we work with scale =
   range/n = (max-min)/n rather than scale=(max-min+1)/n, this reduces
   efficiency slightly but avoids having to check for the out of range
   value.  Note that range is typically O(2^32) so the addition of 1
   is negligible in most usage. */
// #endif /* HAVE_INLINE */

// #endif /* __GSL_RNG_H__ */


// Parsed from gsl/gsl_qrng.h

/* Author: G. Jungman + modifications from O. Teytaud
 */
// #ifndef __GSL_QRNG_H__
// #define __GSL_QRNG_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_inline.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_qrng_type.java


// Targeting ../gsl_qrng.java




/* Supported generator types.
 */
public static native @Const gsl_qrng_type gsl_qrng_niederreiter_2(); public static native void gsl_qrng_niederreiter_2(gsl_qrng_type setter);
public static native @Const gsl_qrng_type gsl_qrng_sobol(); public static native void gsl_qrng_sobol(gsl_qrng_type setter);
public static native @Const gsl_qrng_type gsl_qrng_halton(); public static native void gsl_qrng_halton(gsl_qrng_type setter);
public static native @Const gsl_qrng_type gsl_qrng_reversehalton(); public static native void gsl_qrng_reversehalton(gsl_qrng_type setter);


/* Allocate and initialize a generator
 * of the specified type, in the given
 * space dimension.
 */
public static native gsl_qrng gsl_qrng_alloc(@Const gsl_qrng_type T, @Cast("unsigned int") int dimension);


/* Copy a generator. */
public static native int gsl_qrng_memcpy(gsl_qrng dest, @Const gsl_qrng src);


/* Clone a generator. */
public static native gsl_qrng gsl_qrng_clone(@Const gsl_qrng q);


/* Free a generator. */
public static native void gsl_qrng_free(gsl_qrng q);


/* Intialize a generator. */
public static native void gsl_qrng_init(gsl_qrng q);


/* Get the standardized name of the generator. */
public static native @Cast("const char*") BytePointer gsl_qrng_name(@Const gsl_qrng q);


/* ISN'T THIS CONFUSING FOR PEOPLE?
  WHAT IF SOMEBODY TRIES TO COPY WITH THIS ???
  */
public static native @Cast("size_t") long gsl_qrng_size(@Const gsl_qrng q);


public static native Pointer gsl_qrng_state(@Const gsl_qrng q);


/* Retrieve next vector in sequence. */
/* */ public static native int gsl_qrng_get(@Const gsl_qrng q, DoublePointer x);
public static native int gsl_qrng_get(@Const gsl_qrng q, DoubleBuffer x);
public static native int gsl_qrng_get(@Const gsl_qrng q, double[] x);

// #ifdef HAVE_INLINE

// #endif /* HAVE_INLINE */


// #endif /* !__GSL_QRNG_H__ */


// Parsed from gsl/gsl_randist.h

/* randist/gsl_randist.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 James Theiler, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_RANDIST_H__
// #define __GSL_RANDIST_H__
// #include <gsl/gsl_rng.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native @Cast("unsigned int") int gsl_ran_bernoulli(@Const gsl_rng r, double p);
public static native double gsl_ran_bernoulli_pdf(@Cast("const unsigned int") int k, double p);

public static native double gsl_ran_beta(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_beta_pdf(double x, double a, double b);

public static native @Cast("unsigned int") int gsl_ran_binomial(@Const gsl_rng r, double p, @Cast("unsigned int") int n);
public static native @Cast("unsigned int") int gsl_ran_binomial_knuth(@Const gsl_rng r, double p, @Cast("unsigned int") int n);
public static native @Cast("unsigned int") int gsl_ran_binomial_tpe(@Const gsl_rng r, double p, @Cast("unsigned int") int n);
public static native double gsl_ran_binomial_pdf(@Cast("const unsigned int") int k, double p, @Cast("const unsigned int") int n);

public static native double gsl_ran_exponential(@Const gsl_rng r, double mu);
public static native double gsl_ran_exponential_pdf(double x, double mu);

public static native double gsl_ran_exppow(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_exppow_pdf(double x, double a, double b);

public static native double gsl_ran_cauchy(@Const gsl_rng r, double a);
public static native double gsl_ran_cauchy_pdf(double x, double a);

public static native double gsl_ran_chisq(@Const gsl_rng r, double nu);
public static native double gsl_ran_chisq_pdf(double x, double nu);

public static native void gsl_ran_dirichlet(@Const gsl_rng r, @Cast("const size_t") long K, @Const DoublePointer alpha, DoublePointer theta);
public static native void gsl_ran_dirichlet(@Const gsl_rng r, @Cast("const size_t") long K, @Const DoubleBuffer alpha, DoubleBuffer theta);
public static native void gsl_ran_dirichlet(@Const gsl_rng r, @Cast("const size_t") long K, @Const double[] alpha, double[] theta);
public static native double gsl_ran_dirichlet_pdf(@Cast("const size_t") long K, @Const DoublePointer alpha, @Const DoublePointer theta);
public static native double gsl_ran_dirichlet_pdf(@Cast("const size_t") long K, @Const DoubleBuffer alpha, @Const DoubleBuffer theta);
public static native double gsl_ran_dirichlet_pdf(@Cast("const size_t") long K, @Const double[] alpha, @Const double[] theta);
public static native double gsl_ran_dirichlet_lnpdf(@Cast("const size_t") long K, @Const DoublePointer alpha, @Const DoublePointer theta);
public static native double gsl_ran_dirichlet_lnpdf(@Cast("const size_t") long K, @Const DoubleBuffer alpha, @Const DoubleBuffer theta);
public static native double gsl_ran_dirichlet_lnpdf(@Cast("const size_t") long K, @Const double[] alpha, @Const double[] theta);

public static native double gsl_ran_erlang(@Const gsl_rng r, double a, double n);
public static native double gsl_ran_erlang_pdf(double x, double a, double n);

public static native double gsl_ran_fdist(@Const gsl_rng r, double nu1, double nu2);
public static native double gsl_ran_fdist_pdf(double x, double nu1, double nu2);

public static native double gsl_ran_flat(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_flat_pdf(double x, double a, double b);

public static native double gsl_ran_gamma(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_gamma_int(@Const gsl_rng r, @Cast("const unsigned int") int a);
public static native double gsl_ran_gamma_pdf(double x, double a, double b);
public static native double gsl_ran_gamma_mt(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_gamma_knuth(@Const gsl_rng r, double a, double b);

public static native double gsl_ran_gaussian(@Const gsl_rng r, double sigma);
public static native double gsl_ran_gaussian_ratio_method(@Const gsl_rng r, double sigma);
public static native double gsl_ran_gaussian_ziggurat(@Const gsl_rng r, double sigma);
public static native double gsl_ran_gaussian_pdf(double x, double sigma);

public static native double gsl_ran_ugaussian(@Const gsl_rng r);
public static native double gsl_ran_ugaussian_ratio_method(@Const gsl_rng r);
public static native double gsl_ran_ugaussian_pdf(double x);

public static native double gsl_ran_gaussian_tail(@Const gsl_rng r, double a, double sigma);
public static native double gsl_ran_gaussian_tail_pdf(double x, double a, double sigma);

public static native double gsl_ran_ugaussian_tail(@Const gsl_rng r, double a);
public static native double gsl_ran_ugaussian_tail_pdf(double x, double a);

public static native void gsl_ran_bivariate_gaussian(@Const gsl_rng r, double sigma_x, double sigma_y, double rho, DoublePointer x, DoublePointer y);
public static native void gsl_ran_bivariate_gaussian(@Const gsl_rng r, double sigma_x, double sigma_y, double rho, DoubleBuffer x, DoubleBuffer y);
public static native void gsl_ran_bivariate_gaussian(@Const gsl_rng r, double sigma_x, double sigma_y, double rho, double[] x, double[] y);
public static native double gsl_ran_bivariate_gaussian_pdf(double x, double y, double sigma_x, double sigma_y, double rho);

public static native int gsl_ran_multivariate_gaussian(@Const gsl_rng r, @Const gsl_vector mu, @Const gsl_matrix L, gsl_vector result);
public static native int gsl_ran_multivariate_gaussian_log_pdf(@Const gsl_vector x,
                                           @Const gsl_vector mu,
                                           @Const gsl_matrix L,
                                           DoublePointer result,
                                           gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_log_pdf(@Const gsl_vector x,
                                           @Const gsl_vector mu,
                                           @Const gsl_matrix L,
                                           DoubleBuffer result,
                                           gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_log_pdf(@Const gsl_vector x,
                                           @Const gsl_vector mu,
                                           @Const gsl_matrix L,
                                           double[] result,
                                           gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_pdf(@Const gsl_vector x,
                                       @Const gsl_vector mu,
                                       @Const gsl_matrix L,
                                       DoublePointer result,
                                       gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_pdf(@Const gsl_vector x,
                                       @Const gsl_vector mu,
                                       @Const gsl_matrix L,
                                       DoubleBuffer result,
                                       gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_pdf(@Const gsl_vector x,
                                       @Const gsl_vector mu,
                                       @Const gsl_matrix L,
                                       double[] result,
                                       gsl_vector work);
public static native int gsl_ran_multivariate_gaussian_mean(@Const gsl_matrix X, gsl_vector mu_hat);
public static native int gsl_ran_multivariate_gaussian_vcov(@Const gsl_matrix X, gsl_matrix sigma_hat);

public static native int gsl_ran_wishart(@Const gsl_rng r,
                     double df,
                     @Const gsl_matrix L,
                     gsl_matrix result,
                     gsl_matrix work);
public static native int gsl_ran_wishart_log_pdf(@Const gsl_matrix X,
                             @Const gsl_matrix L_X,
                             double df,
                             @Const gsl_matrix L,
                             DoublePointer result,
                             gsl_matrix work);
public static native int gsl_ran_wishart_log_pdf(@Const gsl_matrix X,
                             @Const gsl_matrix L_X,
                             double df,
                             @Const gsl_matrix L,
                             DoubleBuffer result,
                             gsl_matrix work);
public static native int gsl_ran_wishart_log_pdf(@Const gsl_matrix X,
                             @Const gsl_matrix L_X,
                             double df,
                             @Const gsl_matrix L,
                             double[] result,
                             gsl_matrix work);
public static native int gsl_ran_wishart_pdf(@Const gsl_matrix X,
                         @Const gsl_matrix L_X,
                         double df,
                         @Const gsl_matrix L,
                         DoublePointer result,
                         gsl_matrix work);
public static native int gsl_ran_wishart_pdf(@Const gsl_matrix X,
                         @Const gsl_matrix L_X,
                         double df,
                         @Const gsl_matrix L,
                         DoubleBuffer result,
                         gsl_matrix work);
public static native int gsl_ran_wishart_pdf(@Const gsl_matrix X,
                         @Const gsl_matrix L_X,
                         double df,
                         @Const gsl_matrix L,
                         double[] result,
                         gsl_matrix work);

public static native double gsl_ran_landau(@Const gsl_rng r);
public static native double gsl_ran_landau_pdf(double x);

public static native @Cast("unsigned int") int gsl_ran_geometric(@Const gsl_rng r, double p);
public static native double gsl_ran_geometric_pdf(@Cast("const unsigned int") int k, double p);

public static native @Cast("unsigned int") int gsl_ran_hypergeometric(@Const gsl_rng r, @Cast("unsigned int") int n1, @Cast("unsigned int") int n2, @Cast("unsigned int") int t);
public static native double gsl_ran_hypergeometric_pdf(@Cast("const unsigned int") int k, @Cast("const unsigned int") int n1, @Cast("const unsigned int") int n2, @Cast("unsigned int") int t);

public static native double gsl_ran_gumbel1(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_gumbel1_pdf(double x, double a, double b);

public static native double gsl_ran_gumbel2(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_gumbel2_pdf(double x, double a, double b);

public static native double gsl_ran_logistic(@Const gsl_rng r, double a);
public static native double gsl_ran_logistic_pdf(double x, double a);

public static native double gsl_ran_lognormal(@Const gsl_rng r, double zeta, double sigma);
public static native double gsl_ran_lognormal_pdf(double x, double zeta, double sigma);

public static native @Cast("unsigned int") int gsl_ran_logarithmic(@Const gsl_rng r, double p);
public static native double gsl_ran_logarithmic_pdf(@Cast("const unsigned int") int k, double p);

public static native void gsl_ran_multinomial(@Const gsl_rng r, @Cast("const size_t") long K,
                          @Cast("const unsigned int") int N, @Const DoublePointer p,
                          @Cast("unsigned int*") IntPointer n );
public static native void gsl_ran_multinomial(@Const gsl_rng r, @Cast("const size_t") long K,
                          @Cast("const unsigned int") int N, @Const DoubleBuffer p,
                          @Cast("unsigned int*") IntBuffer n );
public static native void gsl_ran_multinomial(@Const gsl_rng r, @Cast("const size_t") long K,
                          @Cast("const unsigned int") int N, @Const double[] p,
                          @Cast("unsigned int*") int[] n );
public static native double gsl_ran_multinomial_pdf(@Cast("const size_t") long K,
                                @Const DoublePointer p, @Cast("const unsigned int*") IntPointer n );
public static native double gsl_ran_multinomial_pdf(@Cast("const size_t") long K,
                                @Const DoubleBuffer p, @Cast("const unsigned int*") IntBuffer n );
public static native double gsl_ran_multinomial_pdf(@Cast("const size_t") long K,
                                @Const double[] p, @Cast("const unsigned int*") int[] n );
public static native double gsl_ran_multinomial_lnpdf(@Cast("const size_t") long K,
                           @Const DoublePointer p, @Cast("const unsigned int*") IntPointer n );
public static native double gsl_ran_multinomial_lnpdf(@Cast("const size_t") long K,
                           @Const DoubleBuffer p, @Cast("const unsigned int*") IntBuffer n );
public static native double gsl_ran_multinomial_lnpdf(@Cast("const size_t") long K,
                           @Const double[] p, @Cast("const unsigned int*") int[] n );


public static native @Cast("unsigned int") int gsl_ran_negative_binomial(@Const gsl_rng r, double p, double n);
public static native double gsl_ran_negative_binomial_pdf(@Cast("const unsigned int") int k, double p, double n);

public static native @Cast("unsigned int") int gsl_ran_pascal(@Const gsl_rng r, double p, @Cast("unsigned int") int n);
public static native double gsl_ran_pascal_pdf(@Cast("const unsigned int") int k, double p, @Cast("unsigned int") int n);

public static native double gsl_ran_pareto(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_pareto_pdf(double x, double a, double b);

public static native @Cast("unsigned int") int gsl_ran_poisson(@Const gsl_rng r, double mu);
public static native void gsl_ran_poisson_array(@Const gsl_rng r, @Cast("size_t") long n, @Cast("unsigned int*") IntPointer array,
                            double mu);
public static native void gsl_ran_poisson_array(@Const gsl_rng r, @Cast("size_t") long n, @Cast("unsigned int*") IntBuffer array,
                            double mu);
public static native void gsl_ran_poisson_array(@Const gsl_rng r, @Cast("size_t") long n, @Cast("unsigned int*") int[] array,
                            double mu);
public static native double gsl_ran_poisson_pdf(@Cast("const unsigned int") int k, double mu);

public static native double gsl_ran_rayleigh(@Const gsl_rng r, double sigma);
public static native double gsl_ran_rayleigh_pdf(double x, double sigma);

public static native double gsl_ran_rayleigh_tail(@Const gsl_rng r, double a, double sigma);
public static native double gsl_ran_rayleigh_tail_pdf(double x, double a, double sigma);

public static native double gsl_ran_tdist(@Const gsl_rng r, double nu);
public static native double gsl_ran_tdist_pdf(double x, double nu);

public static native double gsl_ran_laplace(@Const gsl_rng r, double a);
public static native double gsl_ran_laplace_pdf(double x, double a);

public static native double gsl_ran_levy(@Const gsl_rng r, double c, double alpha);
public static native double gsl_ran_levy_skew(@Const gsl_rng r, double c, double alpha, double beta);

public static native double gsl_ran_weibull(@Const gsl_rng r, double a, double b);
public static native double gsl_ran_weibull_pdf(double x, double a, double b);

public static native void gsl_ran_dir_2d(@Const gsl_rng r, DoublePointer x, DoublePointer y);
public static native void gsl_ran_dir_2d(@Const gsl_rng r, DoubleBuffer x, DoubleBuffer y);
public static native void gsl_ran_dir_2d(@Const gsl_rng r, double[] x, double[] y);
public static native void gsl_ran_dir_2d_trig_method(@Const gsl_rng r, DoublePointer x, DoublePointer y);
public static native void gsl_ran_dir_2d_trig_method(@Const gsl_rng r, DoubleBuffer x, DoubleBuffer y);
public static native void gsl_ran_dir_2d_trig_method(@Const gsl_rng r, double[] x, double[] y);
public static native void gsl_ran_dir_3d(@Const gsl_rng r, DoublePointer x, DoublePointer y, DoublePointer z);
public static native void gsl_ran_dir_3d(@Const gsl_rng r, DoubleBuffer x, DoubleBuffer y, DoubleBuffer z);
public static native void gsl_ran_dir_3d(@Const gsl_rng r, double[] x, double[] y, double[] z);
public static native void gsl_ran_dir_nd(@Const gsl_rng r, @Cast("size_t") long n, DoublePointer x);
public static native void gsl_ran_dir_nd(@Const gsl_rng r, @Cast("size_t") long n, DoubleBuffer x);
public static native void gsl_ran_dir_nd(@Const gsl_rng r, @Cast("size_t") long n, double[] x);

public static native void gsl_ran_shuffle(@Const gsl_rng r, Pointer base, @Cast("size_t") long nmembm, @Cast("size_t") long size);
public static native int gsl_ran_choose(@Const gsl_rng r, Pointer dest, @Cast("size_t") long k, Pointer src, @Cast("size_t") long n, @Cast("size_t") long size);
public static native void gsl_ran_sample(@Const gsl_rng r, Pointer dest, @Cast("size_t") long k, Pointer src, @Cast("size_t") long n, @Cast("size_t") long size);
// Targeting ../gsl_ran_discrete_t.java



public static native gsl_ran_discrete_t gsl_ran_discrete_preproc(@Cast("size_t") long K, @Const DoublePointer P);
public static native gsl_ran_discrete_t gsl_ran_discrete_preproc(@Cast("size_t") long K, @Const DoubleBuffer P);
public static native gsl_ran_discrete_t gsl_ran_discrete_preproc(@Cast("size_t") long K, @Const double[] P);
public static native void gsl_ran_discrete_free(gsl_ran_discrete_t g);
public static native @Cast("size_t") long gsl_ran_discrete(@Const gsl_rng r, @Const gsl_ran_discrete_t g);
public static native double gsl_ran_discrete_pdf(@Cast("size_t") long k, @Const gsl_ran_discrete_t g);

// #endif /* __GSL_RANDIST_H__ */


// Parsed from gsl/gsl_roots.h

/* roots/gsl_roots.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Reid Priedhorsky, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_ROOTS_H__
// #define __GSL_ROOTS_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_math.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_root_fsolver_type.java


// Targeting ../gsl_root_fsolver.java


// Targeting ../gsl_root_fdfsolver_type.java


// Targeting ../gsl_root_fdfsolver.java



public static native gsl_root_fsolver gsl_root_fsolver_alloc(@Const gsl_root_fsolver_type T);
public static native void gsl_root_fsolver_free(gsl_root_fsolver s);

public static native int gsl_root_fsolver_set(gsl_root_fsolver s,
                          gsl_function f, 
                          double x_lower, double x_upper);

public static native int gsl_root_fsolver_iterate(gsl_root_fsolver s);

public static native @Cast("const char*") BytePointer gsl_root_fsolver_name(@Const gsl_root_fsolver s);
public static native double gsl_root_fsolver_root(@Const gsl_root_fsolver s);
public static native double gsl_root_fsolver_x_lower(@Const gsl_root_fsolver s);
public static native double gsl_root_fsolver_x_upper(@Const gsl_root_fsolver s);


public static native gsl_root_fdfsolver gsl_root_fdfsolver_alloc(@Const gsl_root_fdfsolver_type T);

public static native int gsl_root_fdfsolver_set(gsl_root_fdfsolver s, 
                         gsl_function_fdf fdf, double root);

public static native int gsl_root_fdfsolver_iterate(gsl_root_fdfsolver s);

public static native void gsl_root_fdfsolver_free(gsl_root_fdfsolver s);

public static native @Cast("const char*") BytePointer gsl_root_fdfsolver_name(@Const gsl_root_fdfsolver s);
public static native double gsl_root_fdfsolver_root(@Const gsl_root_fdfsolver s);

public static native int gsl_root_test_interval(double x_lower, double x_upper, double epsabs, double epsrel);

public static native int gsl_root_test_residual(double f, double epsabs);

public static native int gsl_root_test_delta(double x1, double x0, double epsabs, double epsrel);

public static native @Const gsl_root_fsolver_type gsl_root_fsolver_bisection(); public static native void gsl_root_fsolver_bisection(gsl_root_fsolver_type setter);
public static native @Const gsl_root_fsolver_type gsl_root_fsolver_brent(); public static native void gsl_root_fsolver_brent(gsl_root_fsolver_type setter);
public static native @Const gsl_root_fsolver_type gsl_root_fsolver_falsepos(); public static native void gsl_root_fsolver_falsepos(gsl_root_fsolver_type setter);
public static native @Const gsl_root_fdfsolver_type gsl_root_fdfsolver_newton(); public static native void gsl_root_fdfsolver_newton(gsl_root_fdfsolver_type setter);
public static native @Const gsl_root_fdfsolver_type gsl_root_fdfsolver_secant(); public static native void gsl_root_fdfsolver_secant(gsl_root_fdfsolver_type setter);
public static native @Const gsl_root_fdfsolver_type gsl_root_fdfsolver_steffenson(); public static native void gsl_root_fdfsolver_steffenson(gsl_root_fdfsolver_type setter);

// #endif /* __GSL_ROOTS_H__ */


// Parsed from gsl/gsl_siman.h

/* siman/gsl_siman.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Mark Galassi
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SIMAN_H__
// #define __GSL_SIMAN_H__
// #include <stdlib.h>
// #include <gsl/gsl_rng.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_siman_Efunc_t.java


// Targeting ../gsl_siman_step_t.java


// Targeting ../gsl_siman_metric_t.java


// Targeting ../gsl_siman_print_t.java


// Targeting ../gsl_siman_copy_t.java


// Targeting ../gsl_siman_copy_construct_t.java


// Targeting ../gsl_siman_destroy_t.java


// Targeting ../gsl_siman_params_t.java



/* prototype for the workhorse function */

public static native void gsl_siman_solve(@Const gsl_rng r, 
                     Pointer x0_p, gsl_siman_Efunc_t Ef,
                     gsl_siman_step_t take_step,
                     gsl_siman_metric_t distance,
                     gsl_siman_print_t print_position,
                     gsl_siman_copy_t copyfunc,
                     gsl_siman_copy_construct_t copy_constructor,
                     gsl_siman_destroy_t destructor,
                     @Cast("size_t") long element_size,
                     @ByVal gsl_siman_params_t params);

public static native void gsl_siman_solve_many(@Const gsl_rng r, Pointer x0_p, gsl_siman_Efunc_t Ef,
                      gsl_siman_step_t take_step,
                      gsl_siman_metric_t distance,
                      gsl_siman_print_t print_position,
                      @Cast("size_t") long element_size,
                      @ByVal gsl_siman_params_t params);

// #endif /* __GSL_SIMAN_H__ */


// Parsed from gsl/gsl_spline.h

/* interpolation/gsl_spline.h
 * 
 * Copyright (C) 2001, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPLINE_H__
// #define __GSL_SPLINE_H__
// #include <stdlib.h>
// #include <gsl/gsl_interp.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spline.java



public static native gsl_spline gsl_spline_alloc(@Const gsl_interp_type T, @Cast("size_t") long size);
     
public static native int gsl_spline_init(gsl_spline spline, @Const DoublePointer xa, @Const DoublePointer ya, @Cast("size_t") long size);
public static native int gsl_spline_init(gsl_spline spline, @Const DoubleBuffer xa, @Const DoubleBuffer ya, @Cast("size_t") long size);
public static native int gsl_spline_init(gsl_spline spline, @Const double[] xa, @Const double[] ya, @Cast("size_t") long size);

public static native @Cast("const char*") BytePointer gsl_spline_name(@Const gsl_spline spline);
public static native @Cast("unsigned int") int gsl_spline_min_size(@Const gsl_spline spline);


public static native int gsl_spline_eval_e(@Const gsl_spline spline, double x,
                  gsl_interp_accel a, DoublePointer y);
public static native int gsl_spline_eval_e(@Const gsl_spline spline, double x,
                  gsl_interp_accel a, DoubleBuffer y);
public static native int gsl_spline_eval_e(@Const gsl_spline spline, double x,
                  gsl_interp_accel a, double[] y);

public static native double gsl_spline_eval(@Const gsl_spline spline, double x, gsl_interp_accel a);

public static native int gsl_spline_eval_deriv_e(@Const gsl_spline spline,
                        double x,
                        gsl_interp_accel a,
                        DoublePointer y);
public static native int gsl_spline_eval_deriv_e(@Const gsl_spline spline,
                        double x,
                        gsl_interp_accel a,
                        DoubleBuffer y);
public static native int gsl_spline_eval_deriv_e(@Const gsl_spline spline,
                        double x,
                        gsl_interp_accel a,
                        double[] y);

public static native double gsl_spline_eval_deriv(@Const gsl_spline spline,
                      double x,
                      gsl_interp_accel a);

public static native int gsl_spline_eval_deriv2_e(@Const gsl_spline spline,
                         double x,
                         gsl_interp_accel a,
                         DoublePointer y);
public static native int gsl_spline_eval_deriv2_e(@Const gsl_spline spline,
                         double x,
                         gsl_interp_accel a,
                         DoubleBuffer y);
public static native int gsl_spline_eval_deriv2_e(@Const gsl_spline spline,
                         double x,
                         gsl_interp_accel a,
                         double[] y);

public static native double gsl_spline_eval_deriv2(@Const gsl_spline spline,
                       double x,
                       gsl_interp_accel a);

public static native int gsl_spline_eval_integ_e(@Const gsl_spline spline,
                        double a, double b,
                        gsl_interp_accel acc,
                        DoublePointer y);
public static native int gsl_spline_eval_integ_e(@Const gsl_spline spline,
                        double a, double b,
                        gsl_interp_accel acc,
                        DoubleBuffer y);
public static native int gsl_spline_eval_integ_e(@Const gsl_spline spline,
                        double a, double b,
                        gsl_interp_accel acc,
                        double[] y);

public static native double gsl_spline_eval_integ(@Const gsl_spline spline,
                      double a, double b,
                      gsl_interp_accel acc);

public static native void gsl_spline_free(gsl_spline spline);

// #endif /* __GSL_INTERP_H__ */


// Parsed from gsl/gsl_sum.h

/* sum/gsl_sum.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  G. Jungman */


// #ifndef __GSL_SUM_H__
// #define __GSL_SUM_H__

// #include <stdlib.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_sum_levin_u_workspace.java



public static native gsl_sum_levin_u_workspace gsl_sum_levin_u_alloc(@Cast("size_t") long n);
public static native void gsl_sum_levin_u_free(gsl_sum_levin_u_workspace w);

/* Basic Levin-u acceleration method.
 *
 *   array       = array of series elements
 *   n           = size of array
 *   sum_accel   = result of summation acceleration
 *   err         = estimated error   
 *
 * See [Fessler et al., ACM TOMS 9, 346 (1983) and TOMS-602]
 */

public static native int gsl_sum_levin_u_accel(@Const DoublePointer array,
                           @Cast("const size_t") long n,
                           gsl_sum_levin_u_workspace w,
                           DoublePointer sum_accel, DoublePointer abserr);
public static native int gsl_sum_levin_u_accel(@Const DoubleBuffer array,
                           @Cast("const size_t") long n,
                           gsl_sum_levin_u_workspace w,
                           DoubleBuffer sum_accel, DoubleBuffer abserr);
public static native int gsl_sum_levin_u_accel(@Const double[] array,
                           @Cast("const size_t") long n,
                           gsl_sum_levin_u_workspace w,
                           double[] sum_accel, double[] abserr);

/* Basic Levin-u acceleration method with constraints on the terms
 * used,
 *
 *   array       = array of series elements
 *   n           = size of array
 *   min_terms   = minimum number of terms to sum
 *   max_terms   = maximum number of terms to sum
 *   sum_accel   = result of summation acceleration
 *   err         = estimated error   
 *
 * See [Fessler et al., ACM TOMS 9, 346 (1983) and TOMS-602] 
 */

public static native int gsl_sum_levin_u_minmax(@Const DoublePointer array,
                            @Cast("const size_t") long n,
                            @Cast("const size_t") long min_terms,
                            @Cast("const size_t") long max_terms,
                            gsl_sum_levin_u_workspace w,
                            DoublePointer sum_accel, DoublePointer abserr);
public static native int gsl_sum_levin_u_minmax(@Const DoubleBuffer array,
                            @Cast("const size_t") long n,
                            @Cast("const size_t") long min_terms,
                            @Cast("const size_t") long max_terms,
                            gsl_sum_levin_u_workspace w,
                            DoubleBuffer sum_accel, DoubleBuffer abserr);
public static native int gsl_sum_levin_u_minmax(@Const double[] array,
                            @Cast("const size_t") long n,
                            @Cast("const size_t") long min_terms,
                            @Cast("const size_t") long max_terms,
                            gsl_sum_levin_u_workspace w,
                            double[] sum_accel, double[] abserr);

/* Basic Levin-u step w/o reference to the array of terms.
 * We only need to specify the value of the current term
 * to execute the step. See TOMS-745.
 *
 * sum = t0 + ... + t_{n-1} + term;  term = t_{n}
 *
 *   term   = value of the series term to be added
 *   n      = position of term in series (starting from 0)
 *   sum_accel = result of summation acceleration
 *   sum_plain = simple sum of series
 */

public static native int gsl_sum_levin_u_step(double term,
                      @Cast("const size_t") long n,
                      @Cast("const size_t") long nmax,
                      gsl_sum_levin_u_workspace w, 
                      DoublePointer sum_accel);
public static native int gsl_sum_levin_u_step(double term,
                      @Cast("const size_t") long n,
                      @Cast("const size_t") long nmax,
                      gsl_sum_levin_u_workspace w, 
                      DoubleBuffer sum_accel);
public static native int gsl_sum_levin_u_step(double term,
                      @Cast("const size_t") long n,
                      @Cast("const size_t") long nmax,
                      gsl_sum_levin_u_workspace w, 
                      double[] sum_accel);
// Targeting ../gsl_sum_levin_utrunc_workspace.java



public static native gsl_sum_levin_utrunc_workspace gsl_sum_levin_utrunc_alloc(@Cast("size_t") long n);
public static native void gsl_sum_levin_utrunc_free(gsl_sum_levin_utrunc_workspace w);

public static native int gsl_sum_levin_utrunc_accel(@Const DoublePointer array,
                                @Cast("const size_t") long n,
                                gsl_sum_levin_utrunc_workspace w,
                                DoublePointer sum_accel, DoublePointer abserr_trunc);
public static native int gsl_sum_levin_utrunc_accel(@Const DoubleBuffer array,
                                @Cast("const size_t") long n,
                                gsl_sum_levin_utrunc_workspace w,
                                DoubleBuffer sum_accel, DoubleBuffer abserr_trunc);
public static native int gsl_sum_levin_utrunc_accel(@Const double[] array,
                                @Cast("const size_t") long n,
                                gsl_sum_levin_utrunc_workspace w,
                                double[] sum_accel, double[] abserr_trunc);

public static native int gsl_sum_levin_utrunc_minmax(@Const DoublePointer array,
                                 @Cast("const size_t") long n,
                                 @Cast("const size_t") long min_terms,
                                 @Cast("const size_t") long max_terms,
                                 gsl_sum_levin_utrunc_workspace w,
                                 DoublePointer sum_accel, DoublePointer abserr_trunc);
public static native int gsl_sum_levin_utrunc_minmax(@Const DoubleBuffer array,
                                 @Cast("const size_t") long n,
                                 @Cast("const size_t") long min_terms,
                                 @Cast("const size_t") long max_terms,
                                 gsl_sum_levin_utrunc_workspace w,
                                 DoubleBuffer sum_accel, DoubleBuffer abserr_trunc);
public static native int gsl_sum_levin_utrunc_minmax(@Const double[] array,
                                 @Cast("const size_t") long n,
                                 @Cast("const size_t") long min_terms,
                                 @Cast("const size_t") long max_terms,
                                 gsl_sum_levin_utrunc_workspace w,
                                 double[] sum_accel, double[] abserr_trunc);

public static native int gsl_sum_levin_utrunc_step(double term,
                               @Cast("const size_t") long n,
                               gsl_sum_levin_utrunc_workspace w, 
                               DoublePointer sum_accel);
public static native int gsl_sum_levin_utrunc_step(double term,
                               @Cast("const size_t") long n,
                               gsl_sum_levin_utrunc_workspace w, 
                               DoubleBuffer sum_accel);
public static native int gsl_sum_levin_utrunc_step(double term,
                               @Cast("const size_t") long n,
                               gsl_sum_levin_utrunc_workspace w, 
                               double[] sum_accel);

// #endif /* __GSL_SUM_H__ */


// Parsed from gsl/gsl_wavelet.h

/* wavelet/gsl_wavelet.h
 * 
 * Copyright (C) 2004 Ivo Alxneit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_WAVELET_H__
// #define __GSL_WAVELET_H__
// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_errno.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/** enum gsl_wavelet_direction */
public static final int
  gsl_wavelet_forward = 1, gsl_wavelet_backward = -1;
// Targeting ../gsl_wavelet_type.java


// Targeting ../gsl_wavelet.java


// Targeting ../gsl_wavelet_workspace.java



public static native @Const gsl_wavelet_type gsl_wavelet_daubechies(); public static native void gsl_wavelet_daubechies(gsl_wavelet_type setter);
public static native @Const gsl_wavelet_type gsl_wavelet_daubechies_centered(); public static native void gsl_wavelet_daubechies_centered(gsl_wavelet_type setter);
public static native @Const gsl_wavelet_type gsl_wavelet_haar(); public static native void gsl_wavelet_haar(gsl_wavelet_type setter);
public static native @Const gsl_wavelet_type gsl_wavelet_haar_centered(); public static native void gsl_wavelet_haar_centered(gsl_wavelet_type setter);
public static native @Const gsl_wavelet_type gsl_wavelet_bspline(); public static native void gsl_wavelet_bspline(gsl_wavelet_type setter);
public static native @Const gsl_wavelet_type gsl_wavelet_bspline_centered(); public static native void gsl_wavelet_bspline_centered(gsl_wavelet_type setter);

public static native gsl_wavelet gsl_wavelet_alloc(@Const gsl_wavelet_type T, @Cast("size_t") long k);
public static native void gsl_wavelet_free(gsl_wavelet w);
public static native @Cast("const char*") BytePointer gsl_wavelet_name(@Const gsl_wavelet w);

public static native gsl_wavelet_workspace gsl_wavelet_workspace_alloc(@Cast("size_t") long n);
public static native void gsl_wavelet_workspace_free(gsl_wavelet_workspace work);

public static native int gsl_wavelet_transform(@Const gsl_wavelet w, 
                           DoublePointer data, @Cast("size_t") long stride, @Cast("size_t") long n,
                           @Cast("gsl_wavelet_direction") int dir, 
                           gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform(@Const gsl_wavelet w, 
                           DoubleBuffer data, @Cast("size_t") long stride, @Cast("size_t") long n,
                           @Cast("gsl_wavelet_direction") int dir, 
                           gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform(@Const gsl_wavelet w, 
                           double[] data, @Cast("size_t") long stride, @Cast("size_t") long n,
                           @Cast("gsl_wavelet_direction") int dir, 
                           gsl_wavelet_workspace work);

public static native int gsl_wavelet_transform_forward(@Const gsl_wavelet w, 
                                   DoublePointer data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                   gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform_forward(@Const gsl_wavelet w, 
                                   DoubleBuffer data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                   gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform_forward(@Const gsl_wavelet w, 
                                   double[] data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                   gsl_wavelet_workspace work);

public static native int gsl_wavelet_transform_inverse(@Const gsl_wavelet w, 
                                    DoublePointer data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                    gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform_inverse(@Const gsl_wavelet w, 
                                    DoubleBuffer data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                    gsl_wavelet_workspace work);
public static native int gsl_wavelet_transform_inverse(@Const gsl_wavelet w, 
                                    double[] data, @Cast("size_t") long stride, @Cast("size_t") long n, 
                                    gsl_wavelet_workspace work);

// #endif /* __GSL_WAVELET_H__ */


// Parsed from gsl/gsl_wavelet2d.h

/* wavelet/gsl_wavelet.h
 * 
 * Copyright (C) 2004 Ivo Alxneit
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_WAVELET2D_H__
// #define __GSL_WAVELET2D_H__
// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_vector_double.h>
// #include <gsl/gsl_matrix_double.h>
// #include <gsl/gsl_wavelet.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_wavelet2d_transform(@Const gsl_wavelet w, 
                             DoublePointer data, 
                             @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                             @Cast("gsl_wavelet_direction") int dir, 
                             gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform(@Const gsl_wavelet w, 
                             DoubleBuffer data, 
                             @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                             @Cast("gsl_wavelet_direction") int dir, 
                             gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform(@Const gsl_wavelet w, 
                             double[] data, 
                             @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                             @Cast("gsl_wavelet_direction") int dir, 
                             gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_transform_forward(@Const gsl_wavelet w, 
                                     DoublePointer data,
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform_forward(@Const gsl_wavelet w, 
                                     DoubleBuffer data,
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform_forward(@Const gsl_wavelet w, 
                                     double[] data,
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_transform_inverse(@Const gsl_wavelet w, 
                                     DoublePointer data, 
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform_inverse(@Const gsl_wavelet w, 
                                     DoubleBuffer data, 
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_transform_inverse(@Const gsl_wavelet w, 
                                     double[] data, 
                                     @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                     gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_nstransform(@Const gsl_wavelet w, 
                               DoublePointer data, 
                               @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                               @Cast("gsl_wavelet_direction") int dir,
                               gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform(@Const gsl_wavelet w, 
                               DoubleBuffer data, 
                               @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                               @Cast("gsl_wavelet_direction") int dir,
                               gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform(@Const gsl_wavelet w, 
                               double[] data, 
                               @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                               @Cast("gsl_wavelet_direction") int dir,
                               gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_nstransform_forward(@Const gsl_wavelet w, 
                                       DoublePointer data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                                       gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform_forward(@Const gsl_wavelet w, 
                                       DoubleBuffer data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                                       gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform_forward(@Const gsl_wavelet w, 
                                       double[] data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2,
                                       gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_nstransform_inverse(@Const gsl_wavelet w, 
                                       DoublePointer data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                       gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform_inverse(@Const gsl_wavelet w, 
                                       DoubleBuffer data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                       gsl_wavelet_workspace work);
public static native int gsl_wavelet2d_nstransform_inverse(@Const gsl_wavelet w, 
                                       double[] data, 
                                       @Cast("size_t") long tda, @Cast("size_t") long size1, @Cast("size_t") long size2, 
                                       gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_transform_matrix(@Const gsl_wavelet w, 
                                gsl_matrix a, 
                                @Cast("gsl_wavelet_direction") int dir, 
                                gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_transform_matrix_forward(@Const gsl_wavelet w, 
                                        gsl_matrix a, 
                                        gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_transform_matrix_inverse(@Const gsl_wavelet w, 
                                        gsl_matrix a, 
                                        gsl_wavelet_workspace work);


public static native int gsl_wavelet2d_nstransform_matrix(@Const gsl_wavelet w, 
                                  gsl_matrix a, 
                                  @Cast("gsl_wavelet_direction") int dir, 
                                  gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_nstransform_matrix_forward(@Const gsl_wavelet w, 
                                          gsl_matrix a, 
                                          gsl_wavelet_workspace work);

public static native int gsl_wavelet2d_nstransform_matrix_inverse(@Const gsl_wavelet w, 
                                          gsl_matrix a, 
                                          gsl_wavelet_workspace work);

// #endif /* __GSL_WAVELET2D_H__ */


// Parsed from gsl/gsl_multilarge.h

/* gsl_multilarge.h
 * 
 * Copyright (C) 2015 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MULTILARGE_H__
// #define __GSL_MULTILARGE_H__

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_multilarge_linear_type.java


// Targeting ../gsl_multilarge_linear_workspace.java



/* available types */
public static native @Const gsl_multilarge_linear_type gsl_multilarge_linear_normal(); public static native void gsl_multilarge_linear_normal(gsl_multilarge_linear_type setter);
public static native @Const gsl_multilarge_linear_type gsl_multilarge_linear_tsqr(); public static native void gsl_multilarge_linear_tsqr(gsl_multilarge_linear_type setter);

/*
 * Prototypes
 */
public static native gsl_multilarge_linear_workspace gsl_multilarge_linear_alloc(@Const gsl_multilarge_linear_type T,
                            @Cast("const size_t") long p);

public static native void gsl_multilarge_linear_free(gsl_multilarge_linear_workspace w);

public static native @Cast("const char*") BytePointer gsl_multilarge_linear_name(@Const gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_reset(gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_accumulate(gsl_matrix X,
                                     gsl_vector y,
                                     gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_solve(double lambda, gsl_vector c,
                                DoublePointer rnorm, DoublePointer snorm,
                                gsl_multilarge_linear_workspace w);
public static native int gsl_multilarge_linear_solve(double lambda, gsl_vector c,
                                DoubleBuffer rnorm, DoubleBuffer snorm,
                                gsl_multilarge_linear_workspace w);
public static native int gsl_multilarge_linear_solve(double lambda, gsl_vector c,
                                double[] rnorm, double[] snorm,
                                gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_rcond(DoublePointer rcond, gsl_multilarge_linear_workspace w);
public static native int gsl_multilarge_linear_rcond(DoubleBuffer rcond, gsl_multilarge_linear_workspace w);
public static native int gsl_multilarge_linear_rcond(double[] rcond, gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_lcurve(gsl_vector reg_param, gsl_vector rho,
                                 gsl_vector eta,
                                 gsl_multilarge_linear_workspace w);

public static native int gsl_multilarge_linear_wstdform1(@Const gsl_vector L,
                                     @Const gsl_matrix X,
                                     @Const gsl_vector w,
                                     @Const gsl_vector y,
                                     gsl_matrix Xs,
                                     gsl_vector ys,
                                     gsl_multilarge_linear_workspace work);

public static native int gsl_multilarge_linear_stdform1(@Const gsl_vector L,
                                    @Const gsl_matrix X,
                                    @Const gsl_vector y,
                                    gsl_matrix Xs,
                                    gsl_vector ys,
                                    gsl_multilarge_linear_workspace work);

public static native int gsl_multilarge_linear_L_decomp(gsl_matrix L, gsl_vector tau);

public static native int gsl_multilarge_linear_wstdform2(@Const gsl_matrix LQR,
                                     @Const gsl_vector Ltau,
                                     @Const gsl_matrix X,
                                     @Const gsl_vector w,
                                     @Const gsl_vector y,
                                     gsl_matrix Xs,
                                     gsl_vector ys,
                                     gsl_multilarge_linear_workspace work);

public static native int gsl_multilarge_linear_stdform2(@Const gsl_matrix LQR,
                                    @Const gsl_vector Ltau,
                                    @Const gsl_matrix X,
                                    @Const gsl_vector y,
                                    gsl_matrix Xs,
                                    gsl_vector ys,
                                    gsl_multilarge_linear_workspace work);

public static native int gsl_multilarge_linear_genform1(@Const gsl_vector L,
                                    @Const gsl_vector cs,
                                    gsl_vector c,
                                    gsl_multilarge_linear_workspace work);

public static native int gsl_multilarge_linear_genform2(@Const gsl_matrix LQR,
                                    @Const gsl_vector Ltau,
                                    @Const gsl_vector cs,
                                    gsl_vector c,
                                    gsl_multilarge_linear_workspace work);

public static native @Const gsl_matrix gsl_multilarge_linear_matrix_ptr(@Const gsl_multilarge_linear_workspace work);

public static native @Const gsl_vector gsl_multilarge_linear_rhs_ptr(@Const gsl_multilarge_linear_workspace work);

// #endif /* __GSL_MULTILARGE_H__ */


// Parsed from gsl/gsl_rstat.h

/* rstat/gsl_rstat.h
 * 
 * Copyright (C) 2015 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_RSTAT_H__
// #define __GSL_RSTAT_H__

// #include <stdlib.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_rstat_quantile_workspace.java



public static native gsl_rstat_quantile_workspace gsl_rstat_quantile_alloc(double p);
public static native void gsl_rstat_quantile_free(gsl_rstat_quantile_workspace w);
public static native int gsl_rstat_quantile_reset(gsl_rstat_quantile_workspace w);
public static native int gsl_rstat_quantile_add(double x, gsl_rstat_quantile_workspace w);
public static native double gsl_rstat_quantile_get(gsl_rstat_quantile_workspace w);
// Targeting ../gsl_rstat_workspace.java



public static native gsl_rstat_workspace gsl_rstat_alloc();
public static native void gsl_rstat_free(gsl_rstat_workspace w);
public static native @Cast("size_t") long gsl_rstat_n(@Const gsl_rstat_workspace w);
public static native int gsl_rstat_add(double x, gsl_rstat_workspace w);
public static native double gsl_rstat_min(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_max(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_mean(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_variance(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_sd(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_rms(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_sd_mean(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_median(gsl_rstat_workspace w);
public static native double gsl_rstat_skew(@Const gsl_rstat_workspace w);
public static native double gsl_rstat_kurtosis(@Const gsl_rstat_workspace w);
public static native int gsl_rstat_reset(gsl_rstat_workspace w);

// #endif /* __GSL_RSTAT_H__ */


// Parsed from gsl/gsl_spmatrix.h

// #ifndef __GSL_SPMATRIX_H__
// #define __GSL_SPMATRIX_H__

/** enum  */
public static final int
  GSL_SPMATRIX_COO = 0, /* coordinate/triplet representation */
  GSL_SPMATRIX_CSC = 1, /* compressed sparse column */
  GSL_SPMATRIX_CSR = 2, /* compressed sparse row */
  GSL_SPMATRIX_TRIPLET = GSL_SPMATRIX_COO,
  GSL_SPMATRIX_CCS = GSL_SPMATRIX_CSC,
  GSL_SPMATRIX_CRS = GSL_SPMATRIX_CSR;
// Targeting ../gsl_spmatrix_pool_node.java


// Targeting ../gsl_spmatrix_pool.java



// #define GSL_SPMATRIX_ISCOO(m)         ((m)->sptype == GSL_SPMATRIX_COO)
// #define GSL_SPMATRIX_ISCSC(m)         ((m)->sptype == GSL_SPMATRIX_CSC)
// #define GSL_SPMATRIX_ISCSR(m)         ((m)->sptype == GSL_SPMATRIX_CSR)

// #define GSL_SPMATRIX_ISTRIPLET(m)     GSL_SPMATRIX_ISCOO(m)
// #define GSL_SPMATRIX_ISCCS(m)         GSL_SPMATRIX_ISCSC(m)
// #define GSL_SPMATRIX_ISCRS(m)         GSL_SPMATRIX_ISCSR(m)

public static final int GSL_SPMATRIX_FLG_GROW =         (1 << 0); /* allow size of matrix to grow as elements are added */
public static final int GSL_SPMATRIX_FLG_FIXED =        (1 << 1); /* sparsity pattern is fixed */

/* compare matrix entries (ia,ja) and (ib,jb) - sort by rows first, then by columns */
// #define GSL_SPMATRIX_COMPARE_ROWCOL(m,ia,ja,ib,jb)   ((ia) < (ib) ? -1 : ((ia) > (ib) ? 1 : ((ja) < (jb) ? -1 : ((ja) > (jb)))))

/* common/utility functions */



// #include <gsl/gsl_spmatrix_complex_long_double.h>
// #include <gsl/gsl_spmatrix_complex_double.h>
// #include <gsl/gsl_spmatrix_complex_float.h>

// #include <gsl/gsl_spmatrix_long_double.h>
// #include <gsl/gsl_spmatrix_double.h>
// #include <gsl/gsl_spmatrix_float.h>

// #include <gsl/gsl_spmatrix_ulong.h>
// #include <gsl/gsl_spmatrix_long.h>

// #include <gsl/gsl_spmatrix_uint.h>
// #include <gsl/gsl_spmatrix_int.h>

// #include <gsl/gsl_spmatrix_ushort.h>
// #include <gsl/gsl_spmatrix_short.h>

// #include <gsl/gsl_spmatrix_uchar.h>
// #include <gsl/gsl_spmatrix_char.h>

// #endif /* __GSL_SPMATRIX_H__ */


// Parsed from gsl/gsl_spblas.h

/* gsl_spblas.h
 * 
 * Copyright (C) 2012-2014 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPBLAS_H__
// #define __GSL_SPBLAS_H__

// #include <stdlib.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_spmatrix.h>
// #include <gsl/gsl_blas.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/*
 * Prototypes
 */

public static native int gsl_spblas_dgemv(@Cast("const CBLAS_TRANSPOSE_t") int TransA, double alpha,
                     @Const gsl_spmatrix A, @Const gsl_vector x,
                     double beta, gsl_vector y);
public static native int gsl_spblas_dgemm(double alpha, @Const gsl_spmatrix A,
                     @Const gsl_spmatrix B, gsl_spmatrix C);
public static native @Cast("size_t") long gsl_spblas_scatter(@Const gsl_spmatrix A, @Cast("const size_t") long j,
                          double alpha, IntPointer w, DoublePointer x,
                          int mark, gsl_spmatrix C, @Cast("size_t") long nz);
public static native @Cast("size_t") long gsl_spblas_scatter(@Const gsl_spmatrix A, @Cast("const size_t") long j,
                          double alpha, IntBuffer w, DoubleBuffer x,
                          int mark, gsl_spmatrix C, @Cast("size_t") long nz);
public static native @Cast("size_t") long gsl_spblas_scatter(@Const gsl_spmatrix A, @Cast("const size_t") long j,
                          double alpha, int[] w, double[] x,
                          int mark, gsl_spmatrix C, @Cast("size_t") long nz);

// #endif /* __GSL_SPBLAS_H__ */


// Parsed from gsl/gsl_splinalg.h

/* gsl_splinalg.h
 * 
 * Copyright (C) 2012-2014 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPLINALG_H__
// #define __GSL_SPLINALG_H__

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_spmatrix.h>
// #include <gsl/gsl_linalg.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_splinalg_itersolve_type.java


// Targeting ../gsl_splinalg_itersolve.java



/* available types */
public static native @Const gsl_splinalg_itersolve_type gsl_splinalg_itersolve_gmres(); public static native void gsl_splinalg_itersolve_gmres(gsl_splinalg_itersolve_type setter);

/*
 * Prototypes
 */
public static native gsl_splinalg_itersolve gsl_splinalg_itersolve_alloc(@Const gsl_splinalg_itersolve_type T,
                             @Cast("const size_t") long n, @Cast("const size_t") long m);
public static native void gsl_splinalg_itersolve_free(gsl_splinalg_itersolve w);
public static native @Cast("const char*") BytePointer gsl_splinalg_itersolve_name(@Const gsl_splinalg_itersolve w);
public static native int gsl_splinalg_itersolve_iterate(@Const gsl_spmatrix A,
                                   @Const gsl_vector b,
                                   double tol, gsl_vector x,
                                   gsl_splinalg_itersolve w);
public static native double gsl_splinalg_itersolve_normr(@Const gsl_splinalg_itersolve w);

// #endif /* __GSL_SPLINALG_H__ */


// Parsed from gsl/gsl_interp2d.h

/* interpolation/gsl_interp2d.h
 * 
 * Copyright 2012 David Zaslavsky
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_INTERP2D_H__
// #define __GSL_INTERP2D_H__

// #include <gsl/gsl_interp.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_interp2d_type.java


// Targeting ../gsl_interp2d.java



/* available types */
public static native @Const gsl_interp2d_type gsl_interp2d_bilinear(); public static native void gsl_interp2d_bilinear(gsl_interp2d_type setter);
public static native @Const gsl_interp2d_type gsl_interp2d_bicubic(); public static native void gsl_interp2d_bicubic(gsl_interp2d_type setter);

public static native gsl_interp2d gsl_interp2d_alloc(@Const gsl_interp2d_type T, @Cast("const size_t") long xsize,
                                  @Cast("const size_t") long ysize);

public static native @Cast("const char*") BytePointer gsl_interp2d_name(@Const gsl_interp2d interp);
public static native @Cast("size_t") long gsl_interp2d_min_size(@Const gsl_interp2d interp);
public static native @Cast("size_t") long gsl_interp2d_type_min_size(@Const gsl_interp2d_type T);
public static native int gsl_interp2d_set(@Const gsl_interp2d interp, DoublePointer zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native int gsl_interp2d_set(@Const gsl_interp2d interp, DoubleBuffer zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native int gsl_interp2d_set(@Const gsl_interp2d interp, double[] zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native double gsl_interp2d_get(@Const gsl_interp2d interp, @Const DoublePointer zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native double gsl_interp2d_get(@Const gsl_interp2d interp, @Const DoubleBuffer zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native double gsl_interp2d_get(@Const gsl_interp2d interp, @Const double[] zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native @Cast("size_t") long gsl_interp2d_idx(@Const gsl_interp2d interp,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_interp2d_init(gsl_interp2d interp, @Const DoublePointer xa, @Const DoublePointer ya,
                      @Const DoublePointer za, @Cast("const size_t") long xsize, @Cast("const size_t") long ysize);
public static native int gsl_interp2d_init(gsl_interp2d interp, @Const DoubleBuffer xa, @Const DoubleBuffer ya,
                      @Const DoubleBuffer za, @Cast("const size_t") long xsize, @Cast("const size_t") long ysize);
public static native int gsl_interp2d_init(gsl_interp2d interp, @Const double[] xa, @Const double[] ya,
                      @Const double[] za, @Cast("const size_t") long xsize, @Cast("const size_t") long ysize);
public static native void gsl_interp2d_free(gsl_interp2d interp);

public static native double gsl_interp2d_eval(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                         @Const DoublePointer yarr, @Const DoublePointer zarr, double x,
                         double y, gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                         @Const DoubleBuffer yarr, @Const DoubleBuffer zarr, double x,
                         double y, gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval(@Const gsl_interp2d interp, @Const double[] xarr,
                         @Const double[] yarr, @Const double[] zarr, double x,
                         double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native double gsl_interp2d_eval_extrap(@Const gsl_interp2d interp,
                                @Const DoublePointer xarr, @Const DoublePointer yarr,
                                @Const DoublePointer zarr, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya);
public static native double gsl_interp2d_eval_extrap(@Const gsl_interp2d interp,
                                @Const DoubleBuffer xarr, @Const DoubleBuffer yarr,
                                @Const DoubleBuffer zarr, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya);
public static native double gsl_interp2d_eval_extrap(@Const gsl_interp2d interp,
                                @Const double[] xarr, @Const double[] yarr,
                                @Const double[] zarr, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya);

public static native int gsl_interp2d_eval_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                        @Const DoublePointer yarr, @Const DoublePointer zarr,
                        double x, double y, gsl_interp_accel xa,
                        gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                        @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                        double x, double y, gsl_interp_accel xa,
                        gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_e(@Const gsl_interp2d interp, @Const double[] xarr,
                        @Const double[] yarr, @Const double[] zarr,
                        double x, double y, gsl_interp_accel xa,
                        gsl_interp_accel ya, double[] z);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_interp2d_eval_e_extrap(@Const gsl_interp2d interp,
                               @Const DoublePointer xarr,
                               @Const DoublePointer yarr,
                               @Const DoublePointer zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               DoublePointer z);
public static native int gsl_interp2d_eval_e_extrap(@Const gsl_interp2d interp,
                               @Const DoubleBuffer xarr,
                               @Const DoubleBuffer yarr,
                               @Const DoubleBuffer zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               DoubleBuffer z);
public static native int gsl_interp2d_eval_e_extrap(@Const gsl_interp2d interp,
                               @Const double[] xarr,
                               @Const double[] yarr,
                               @Const double[] zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               double[] z);

// #endif /* !GSL_DISABLE_DEPRECATED */

public static native int gsl_interp2d_eval_extrap_e(@Const gsl_interp2d interp,
                               @Const DoublePointer xarr,
                               @Const DoublePointer yarr,
                               @Const DoublePointer zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               DoublePointer z);
public static native int gsl_interp2d_eval_extrap_e(@Const gsl_interp2d interp,
                               @Const DoubleBuffer xarr,
                               @Const DoubleBuffer yarr,
                               @Const DoubleBuffer zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               DoubleBuffer z);
public static native int gsl_interp2d_eval_extrap_e(@Const gsl_interp2d interp,
                               @Const double[] xarr,
                               @Const double[] yarr,
                               @Const double[] zarr,
                               double x,
                               double y,
                               gsl_interp_accel xa,
                               gsl_interp_accel ya,
                               double[] z);

public static native double gsl_interp2d_eval_deriv_x(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                 @Const DoublePointer yarr, @Const DoublePointer zarr,
                                 double x, double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_x(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                 @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                 double x, double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_x(@Const gsl_interp2d interp, @Const double[] xarr,
                                 @Const double[] yarr, @Const double[] zarr,
                                 double x, double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya);

public static native int gsl_interp2d_eval_deriv_x_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                @Const DoublePointer yarr, @Const DoublePointer zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_deriv_x_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_deriv_x_e(@Const gsl_interp2d interp, @Const double[] xarr,
                                @Const double[] yarr, @Const double[] zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, double[] z);

public static native double gsl_interp2d_eval_deriv_y(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                 @Const DoublePointer yarr, @Const DoublePointer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_y(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                 @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_y(@Const gsl_interp2d interp, @Const double[] xarr,
                                 @Const double[] yarr, @Const double[] zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_interp2d_eval_deriv_y_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                @Const DoublePointer yarr, @Const DoublePointer zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_deriv_y_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_deriv_y_e(@Const gsl_interp2d interp, @Const double[] xarr,
                                @Const double[] yarr, @Const double[] zarr,
                                double x, double y,
                                gsl_interp_accel xa, gsl_interp_accel ya, double[] z);

public static native double gsl_interp2d_eval_deriv_xx(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                  @Const DoublePointer yarr, @Const DoublePointer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_xx(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                  @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_xx(@Const gsl_interp2d interp, @Const double[] xarr,
                                  @Const double[] yarr, @Const double[] zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_interp2d_eval_deriv_xx_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                 @Const DoublePointer yarr, @Const DoublePointer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_deriv_xx_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                 @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_deriv_xx_e(@Const gsl_interp2d interp, @Const double[] xarr,
                                 @Const double[] yarr, @Const double[] zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, double[] z);

public static native double gsl_interp2d_eval_deriv_yy(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                  @Const DoublePointer yarr, @Const DoublePointer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_yy(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                  @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_yy(@Const gsl_interp2d interp, @Const double[] xarr,
                                  @Const double[] yarr, @Const double[] zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_interp2d_eval_deriv_yy_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                 @Const DoublePointer yarr, @Const DoublePointer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_deriv_yy_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                 @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_deriv_yy_e(@Const gsl_interp2d interp, @Const double[] xarr,
                                 @Const double[] yarr, @Const double[] zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, double[] z);

public static native double gsl_interp2d_eval_deriv_xy(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                  @Const DoublePointer yarr, @Const DoublePointer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_xy(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                  @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);
public static native double gsl_interp2d_eval_deriv_xy(@Const gsl_interp2d interp, @Const double[] xarr,
                                  @Const double[] yarr, @Const double[] zarr,
                                  double x, double y,
                                  gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_interp2d_eval_deriv_xy_e(@Const gsl_interp2d interp, @Const DoublePointer xarr,
                                 @Const DoublePointer yarr, @Const DoublePointer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoublePointer z);
public static native int gsl_interp2d_eval_deriv_xy_e(@Const gsl_interp2d interp, @Const DoubleBuffer xarr,
                                 @Const DoubleBuffer yarr, @Const DoubleBuffer zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_interp2d_eval_deriv_xy_e(@Const gsl_interp2d interp, @Const double[] xarr,
                                 @Const double[] yarr, @Const double[] zarr,
                                 double x, double y,
                                 gsl_interp_accel xa, gsl_interp_accel ya, double[] z);

// #endif /* __GSL_INTERP2D_H__ */


// Parsed from gsl/gsl_spline2d.h

/* interpolation/gsl_spline2d.h
 * 
 * Copyright 2012 David Zaslavsky
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPLINE2D_H__
// #define __GSL_SPLINE2D_H__

// #include <gsl/gsl_interp.h>
// #include <gsl/gsl_interp2d.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spline2d.java



public static native gsl_spline2d gsl_spline2d_alloc(@Const gsl_interp2d_type T, @Cast("size_t") long xsize, @Cast("size_t") long ysize);

public static native int gsl_spline2d_init(gsl_spline2d interp, @Const DoublePointer xa,
                      @Const DoublePointer ya, @Const DoublePointer za,
                      @Cast("size_t") long xsize, @Cast("size_t") long ysize);
public static native int gsl_spline2d_init(gsl_spline2d interp, @Const DoubleBuffer xa,
                      @Const DoubleBuffer ya, @Const DoubleBuffer za,
                      @Cast("size_t") long xsize, @Cast("size_t") long ysize);
public static native int gsl_spline2d_init(gsl_spline2d interp, @Const double[] xa,
                      @Const double[] ya, @Const double[] za,
                      @Cast("size_t") long xsize, @Cast("size_t") long ysize);

public static native void gsl_spline2d_free(gsl_spline2d interp);

public static native double gsl_spline2d_eval(@Const gsl_spline2d interp, double x,
                         double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_e(@Const gsl_spline2d interp, double x,
                        double y, gsl_interp_accel xa, gsl_interp_accel ya,
                        DoublePointer z);
public static native int gsl_spline2d_eval_e(@Const gsl_spline2d interp, double x,
                        double y, gsl_interp_accel xa, gsl_interp_accel ya,
                        DoubleBuffer z);
public static native int gsl_spline2d_eval_e(@Const gsl_spline2d interp, double x,
                        double y, gsl_interp_accel xa, gsl_interp_accel ya,
                        double[] z);

public static native double gsl_spline2d_eval_extrap(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_extrap_e(@Const gsl_spline2d interp, double x,
                               double y, gsl_interp_accel xa, gsl_interp_accel ya,
                               DoublePointer z);
public static native int gsl_spline2d_eval_extrap_e(@Const gsl_spline2d interp, double x,
                               double y, gsl_interp_accel xa, gsl_interp_accel ya,
                               DoubleBuffer z);
public static native int gsl_spline2d_eval_extrap_e(@Const gsl_spline2d interp, double x,
                               double y, gsl_interp_accel xa, gsl_interp_accel ya,
                               double[] z);

public static native double gsl_spline2d_eval_deriv_x(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_deriv_x_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, DoublePointer z);
public static native int gsl_spline2d_eval_deriv_x_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_spline2d_eval_deriv_x_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, double[] z);

public static native double gsl_spline2d_eval_deriv_y(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya);

public static native int gsl_spline2d_eval_deriv_y_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, DoublePointer z);
public static native int gsl_spline2d_eval_deriv_y_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_spline2d_eval_deriv_y_e(@Const gsl_spline2d interp, double x,
                                double y, gsl_interp_accel xa,
                                gsl_interp_accel ya, double[] z);

public static native double gsl_spline2d_eval_deriv_xx(@Const gsl_spline2d interp, double x,
                                  double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_deriv_xx_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoublePointer z);
public static native int gsl_spline2d_eval_deriv_xx_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_spline2d_eval_deriv_xx_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, double[] z);

public static native double gsl_spline2d_eval_deriv_yy(@Const gsl_spline2d interp, double x,
                                  double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_deriv_yy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoublePointer z);
public static native int gsl_spline2d_eval_deriv_yy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_spline2d_eval_deriv_yy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, double[] z);

public static native double gsl_spline2d_eval_deriv_xy(@Const gsl_spline2d interp, double x,
                                  double y, gsl_interp_accel xa, gsl_interp_accel ya);

public static native int gsl_spline2d_eval_deriv_xy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoublePointer z);
public static native int gsl_spline2d_eval_deriv_xy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, DoubleBuffer z);
public static native int gsl_spline2d_eval_deriv_xy_e(@Const gsl_spline2d interp, double x,
                                 double y, gsl_interp_accel xa,
                                 gsl_interp_accel ya, double[] z);

public static native @Cast("size_t") long gsl_spline2d_min_size(@Const gsl_spline2d interp);

public static native @Cast("const char*") BytePointer gsl_spline2d_name(@Const gsl_spline2d interp);

public static native int gsl_spline2d_set(@Const gsl_spline2d interp, DoublePointer zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native int gsl_spline2d_set(@Const gsl_spline2d interp, DoubleBuffer zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native int gsl_spline2d_set(@Const gsl_spline2d interp, double[] zarr,
                     @Cast("const size_t") long i, @Cast("const size_t") long j, double z);
public static native double gsl_spline2d_get(@Const gsl_spline2d interp, @Const DoublePointer zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native double gsl_spline2d_get(@Const gsl_spline2d interp, @Const DoubleBuffer zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native double gsl_spline2d_get(@Const gsl_spline2d interp, @Const double[] zarr,
                        @Cast("const size_t") long i, @Cast("const size_t") long j);

// #endif /* __GSL_SPLINE2D_H__ */


// Parsed from gsl/gsl_bst_avl.h

/* bst/gsl_bst_avl.h
 * 
 * Copyright (C) 2018 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BST_AVL_H__
// #define __GSL_BST_AVL_H__

// #include <stdlib.h>
// #include <gsl/gsl_bst_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

// #ifndef GSL_BST_AVL_MAX_HEIGHT
public static final int GSL_BST_AVL_MAX_HEIGHT = 32;
// Targeting ../gsl_bst_avl_node.java


// Targeting ../gsl_bst_avl_table.java


// Targeting ../gsl_bst_avl_traverser.java



// #endif /* __GSL_BST_AVL_H__ */


// Parsed from gsl/gsl_bst_rb.h

/* bst/gsl_bst_rb.h
 * 
 * Copyright (C) 2018 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BST_RB_H__
// #define __GSL_BST_RB_H__

// #include <stdlib.h>
// #include <gsl/gsl_bst_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

// #ifndef GSL_BST_RB_MAX_HEIGHT
public static final int GSL_BST_RB_MAX_HEIGHT = 48;
// Targeting ../gsl_bst_rb_node.java


// Targeting ../gsl_bst_rb_table.java


// Targeting ../gsl_bst_rb_traverser.java



// #endif /* __GSL_BST_RB_H__ */


// Parsed from gsl/gsl_bst_types.h

/* bst/gsl_bst_types.h
 * 
 * Copyright (C) 2019 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BST_TYPES_H__
// #define __GSL_BST_TYPES_H__

// #include <stdlib.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_bst_cmp_function.java


// Targeting ../gsl_bst_allocator.java



// #endif /* __GSL_BST_TYPES_H__ */


// Parsed from gsl/gsl_bst.h

/* bst/gsl_bst.h
 * 
 * Copyright (C) 2018, 2019 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_BST_H__
// #define __GSL_BST_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst_avl.h>
// #include <gsl/gsl_bst_rb.h>
// #include <gsl/gsl_bst_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_bst_type.java


// Targeting ../gsl_bst_workspace.java


// Targeting ../gsl_bst_trav.java



/* tree types */
public static native @Const gsl_bst_type gsl_bst_avl(); public static native void gsl_bst_avl(gsl_bst_type setter);
public static native @Const gsl_bst_type gsl_bst_rb(); public static native void gsl_bst_rb(gsl_bst_type setter);

/*
 * Prototypes
 */

public static native gsl_bst_workspace gsl_bst_alloc(@Const gsl_bst_type T, @Const gsl_bst_allocator allocator,
                                  gsl_bst_cmp_function compare, Pointer params);
public static native void gsl_bst_free(gsl_bst_workspace w);
public static native int gsl_bst_empty(gsl_bst_workspace w);
public static native Pointer gsl_bst_insert(Pointer item, gsl_bst_workspace w);
public static native Pointer gsl_bst_find(@Const Pointer item, @Const gsl_bst_workspace w);
public static native Pointer gsl_bst_remove(@Const Pointer item, gsl_bst_workspace w);
public static native @Cast("size_t") long gsl_bst_nodes(@Const gsl_bst_workspace w);
public static native @Cast("size_t") long gsl_bst_node_size(@Const gsl_bst_workspace w);
public static native @Cast("const char*") BytePointer gsl_bst_name(@Const gsl_bst_workspace w);

public static native int gsl_bst_trav_init(gsl_bst_trav trav, @Const gsl_bst_workspace w);
public static native Pointer gsl_bst_trav_first(gsl_bst_trav trav, @Const gsl_bst_workspace w);
public static native Pointer gsl_bst_trav_last(gsl_bst_trav trav, @Const gsl_bst_workspace w);
public static native Pointer gsl_bst_trav_find(@Const Pointer item, gsl_bst_trav trav, @Const gsl_bst_workspace w);
public static native Pointer gsl_bst_trav_insert(Pointer item, gsl_bst_trav trav, gsl_bst_workspace w);
public static native Pointer gsl_bst_trav_copy(gsl_bst_trav dest, @Const gsl_bst_trav src);
public static native Pointer gsl_bst_trav_next(gsl_bst_trav trav);
public static native Pointer gsl_bst_trav_prev(gsl_bst_trav trav);
public static native Pointer gsl_bst_trav_cur(@Const gsl_bst_trav trav);
public static native Pointer gsl_bst_trav_replace(gsl_bst_trav trav, Pointer new_item);

// #endif /* __GSL_BST_H__ */


// Parsed from gsl/gsl_spmatrix_complex_double.h

/* spmatrix/gsl_spmatrix_double.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_COMPLEX_DOUBLE_H__
// #define __GSL_SPMATRIX_COMPLEX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_complex_double.h>
// #include <gsl/gsl_matrix_complex_double.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_complex.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_complex gsl_spmatrix_complex_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_complex_free(gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_complex m);
public static native @Cast("size_t") long gsl_spmatrix_complex_nnz(@Const gsl_spmatrix_complex m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_complex_type(@Const gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_set_zero(gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_tree_rebuild(gsl_spmatrix_complex m);

/* compress */

public static native int gsl_spmatrix_complex_csc(gsl_spmatrix_complex dest, @Const gsl_spmatrix_complex src);
public static native int gsl_spmatrix_complex_csr(gsl_spmatrix_complex dest, @Const gsl_spmatrix_complex src);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_compress(@Const gsl_spmatrix_complex src, int sptype);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_compcol(@Const gsl_spmatrix_complex src);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_ccs(@Const gsl_spmatrix_complex src);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_crs(@Const gsl_spmatrix_complex src);

/* copy */

public static native int gsl_spmatrix_complex_memcpy(gsl_spmatrix_complex dest, @Const gsl_spmatrix_complex src);

/* file I/O */

public static native int gsl_spmatrix_complex_fprintf(FILE stream, @Const gsl_spmatrix_complex m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_complex_fprintf(FILE stream, @Const gsl_spmatrix_complex m, String format);
public static native gsl_spmatrix_complex gsl_spmatrix_complex_fscanf(FILE stream);
public static native int gsl_spmatrix_complex_fwrite(FILE stream, @Const gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_fread(FILE stream, gsl_spmatrix_complex m);

/* get/set */

public static native @ByVal gsl_complex gsl_spmatrix_complex_get(@Const gsl_spmatrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_complex_set(gsl_spmatrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Const @ByVal gsl_complex x);
public static native gsl_complex gsl_spmatrix_complex_ptr(@Const gsl_spmatrix_complex m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* operations */

public static native int gsl_spmatrix_complex_scale(gsl_spmatrix_complex m, @Const @ByVal gsl_complex x);
public static native int gsl_spmatrix_complex_scale_columns(gsl_spmatrix_complex m, @Const gsl_vector_complex x);
public static native int gsl_spmatrix_complex_scale_rows(gsl_spmatrix_complex m, @Const gsl_vector_complex x);
public static native int gsl_spmatrix_complex_add(gsl_spmatrix_complex c, @Const gsl_spmatrix_complex a, @Const gsl_spmatrix_complex b);
public static native int gsl_spmatrix_complex_dense_add(gsl_matrix_complex a, @Const gsl_spmatrix_complex b);
public static native int gsl_spmatrix_complex_dense_sub(gsl_matrix_complex a, @Const gsl_spmatrix_complex b);
public static native int gsl_spmatrix_complex_d2sp(gsl_spmatrix_complex T, @Const gsl_matrix_complex A);
public static native int gsl_spmatrix_complex_sp2d(gsl_matrix_complex A, @Const gsl_spmatrix_complex S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_complex_add_to_dense(gsl_matrix_complex a, @Const gsl_spmatrix_complex b);

// #endif

/* properties */

public static native int gsl_spmatrix_complex_equal(@Const gsl_spmatrix_complex a, @Const gsl_spmatrix_complex b);

/* swap */

public static native int gsl_spmatrix_complex_transpose(gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_transpose2(gsl_spmatrix_complex m);
public static native int gsl_spmatrix_complex_transpose_memcpy(gsl_spmatrix_complex dest, @Const gsl_spmatrix_complex src);

// #endif /* __GSL_SPMATRIX_COMPLEX_DOUBLE_H__ */


// Parsed from gsl/gsl_spmatrix_complex_float.h

/* spmatrix/gsl_spmatrix_float.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_COMPLEX_FLOAT_H__
// #define __GSL_SPMATRIX_COMPLEX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_complex_float.h>
// #include <gsl/gsl_matrix_complex_float.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_complex_float.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_complex_float_free(gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_complex_float m);
public static native @Cast("size_t") long gsl_spmatrix_complex_float_nnz(@Const gsl_spmatrix_complex_float m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_complex_float_type(@Const gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_set_zero(gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_tree_rebuild(gsl_spmatrix_complex_float m);

/* compress */

public static native int gsl_spmatrix_complex_float_csc(gsl_spmatrix_complex_float dest, @Const gsl_spmatrix_complex_float src);
public static native int gsl_spmatrix_complex_float_csr(gsl_spmatrix_complex_float dest, @Const gsl_spmatrix_complex_float src);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_compress(@Const gsl_spmatrix_complex_float src, int sptype);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_compcol(@Const gsl_spmatrix_complex_float src);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_ccs(@Const gsl_spmatrix_complex_float src);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_crs(@Const gsl_spmatrix_complex_float src);

/* copy */

public static native int gsl_spmatrix_complex_float_memcpy(gsl_spmatrix_complex_float dest, @Const gsl_spmatrix_complex_float src);

/* file I/O */

public static native int gsl_spmatrix_complex_float_fprintf(FILE stream, @Const gsl_spmatrix_complex_float m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_complex_float_fprintf(FILE stream, @Const gsl_spmatrix_complex_float m, String format);
public static native gsl_spmatrix_complex_float gsl_spmatrix_complex_float_fscanf(FILE stream);
public static native int gsl_spmatrix_complex_float_fwrite(FILE stream, @Const gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_fread(FILE stream, gsl_spmatrix_complex_float m);

/* get/set */

public static native @ByVal gsl_complex_float gsl_spmatrix_complex_float_get(@Const gsl_spmatrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_complex_float_set(gsl_spmatrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Const @ByVal gsl_complex_float x);
public static native gsl_complex_float gsl_spmatrix_complex_float_ptr(@Const gsl_spmatrix_complex_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* operations */

public static native int gsl_spmatrix_complex_float_scale(gsl_spmatrix_complex_float m, @Const @ByVal gsl_complex_float x);
public static native int gsl_spmatrix_complex_float_scale_columns(gsl_spmatrix_complex_float m, @Const gsl_vector_complex_float x);
public static native int gsl_spmatrix_complex_float_scale_rows(gsl_spmatrix_complex_float m, @Const gsl_vector_complex_float x);
public static native int gsl_spmatrix_complex_float_add(gsl_spmatrix_complex_float c, @Const gsl_spmatrix_complex_float a, @Const gsl_spmatrix_complex_float b);
public static native int gsl_spmatrix_complex_float_dense_add(gsl_matrix_complex_float a, @Const gsl_spmatrix_complex_float b);
public static native int gsl_spmatrix_complex_float_dense_sub(gsl_matrix_complex_float a, @Const gsl_spmatrix_complex_float b);
public static native int gsl_spmatrix_complex_float_d2sp(gsl_spmatrix_complex_float T, @Const gsl_matrix_complex_float A);
public static native int gsl_spmatrix_complex_float_sp2d(gsl_matrix_complex_float A, @Const gsl_spmatrix_complex_float S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_complex_float_add_to_dense(gsl_matrix_complex_float a, @Const gsl_spmatrix_complex_float b);

// #endif

/* properties */

public static native int gsl_spmatrix_complex_float_equal(@Const gsl_spmatrix_complex_float a, @Const gsl_spmatrix_complex_float b);

/* swap */

public static native int gsl_spmatrix_complex_float_transpose(gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_transpose2(gsl_spmatrix_complex_float m);
public static native int gsl_spmatrix_complex_float_transpose_memcpy(gsl_spmatrix_complex_float dest, @Const gsl_spmatrix_complex_float src);

// #endif /* __GSL_SPMATRIX_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_spmatrix_double.h

/* spmatrix/gsl_spmatrix_double.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_DOUBLE_H__
// #define __GSL_SPMATRIX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_double.h>
// #include <gsl/gsl_matrix_double.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix gsl_spmatrix_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix gsl_spmatrix_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_free(gsl_spmatrix m);
public static native int gsl_spmatrix_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix m);
public static native @Cast("size_t") long gsl_spmatrix_nnz(@Const gsl_spmatrix m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_type(@Const gsl_spmatrix m);
public static native int gsl_spmatrix_set_zero(gsl_spmatrix m);
public static native int gsl_spmatrix_tree_rebuild(gsl_spmatrix m);

/* compress */

public static native int gsl_spmatrix_csc(gsl_spmatrix dest, @Const gsl_spmatrix src);
public static native int gsl_spmatrix_csr(gsl_spmatrix dest, @Const gsl_spmatrix src);
public static native gsl_spmatrix gsl_spmatrix_compress(@Const gsl_spmatrix src, int sptype);
public static native gsl_spmatrix gsl_spmatrix_compcol(@Const gsl_spmatrix src);
public static native gsl_spmatrix gsl_spmatrix_ccs(@Const gsl_spmatrix src);
public static native gsl_spmatrix gsl_spmatrix_crs(@Const gsl_spmatrix src);

/* copy */

public static native int gsl_spmatrix_memcpy(gsl_spmatrix dest, @Const gsl_spmatrix src);

/* file I/O */

public static native int gsl_spmatrix_fprintf(FILE stream, @Const gsl_spmatrix m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_fprintf(FILE stream, @Const gsl_spmatrix m, String format);
public static native gsl_spmatrix gsl_spmatrix_fscanf(FILE stream);
public static native int gsl_spmatrix_fwrite(FILE stream, @Const gsl_spmatrix m);
public static native int gsl_spmatrix_fread(FILE stream, gsl_spmatrix m);

/* get/set */

public static native double gsl_spmatrix_get(@Const gsl_spmatrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_set(gsl_spmatrix m, @Cast("const size_t") long i, @Cast("const size_t") long j, double x);
public static native DoublePointer gsl_spmatrix_ptr(@Const gsl_spmatrix m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_minmax(@Const gsl_spmatrix m, DoublePointer min_out, DoublePointer max_out);
public static native int gsl_spmatrix_minmax(@Const gsl_spmatrix m, DoubleBuffer min_out, DoubleBuffer max_out);
public static native int gsl_spmatrix_minmax(@Const gsl_spmatrix m, double[] min_out, double[] max_out);
public static native int gsl_spmatrix_min_index(@Const gsl_spmatrix m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_scale(gsl_spmatrix m, double x);
public static native int gsl_spmatrix_scale_columns(gsl_spmatrix m, @Const gsl_vector x);
public static native int gsl_spmatrix_scale_rows(gsl_spmatrix m, @Const gsl_vector x);
public static native int gsl_spmatrix_add(gsl_spmatrix c, @Const gsl_spmatrix a, @Const gsl_spmatrix b);
public static native int gsl_spmatrix_dense_add(gsl_matrix a, @Const gsl_spmatrix b);
public static native int gsl_spmatrix_dense_sub(gsl_matrix a, @Const gsl_spmatrix b);
public static native int gsl_spmatrix_d2sp(gsl_spmatrix T, @Const gsl_matrix A);
public static native int gsl_spmatrix_sp2d(gsl_matrix A, @Const gsl_spmatrix S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_add_to_dense(gsl_matrix a, @Const gsl_spmatrix b);

// #endif

/* properties */

public static native int gsl_spmatrix_equal(@Const gsl_spmatrix a, @Const gsl_spmatrix b);
public static native double gsl_spmatrix_norm1(@Const gsl_spmatrix a);

/* swap */

public static native int gsl_spmatrix_transpose(gsl_spmatrix m);
public static native int gsl_spmatrix_transpose2(gsl_spmatrix m);
public static native int gsl_spmatrix_transpose_memcpy(gsl_spmatrix dest, @Const gsl_spmatrix src);

// #endif /* __GSL_SPMATRIX_DOUBLE_H__ */


// Parsed from gsl/gsl_spmatrix_float.h

/* spmatrix/gsl_spmatrix_float.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_FLOAT_H__
// #define __GSL_SPMATRIX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_float.h>
// #include <gsl/gsl_matrix_float.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_float.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_float gsl_spmatrix_float_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_float gsl_spmatrix_float_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_float_free(gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_float m);
public static native @Cast("size_t") long gsl_spmatrix_float_nnz(@Const gsl_spmatrix_float m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_float_type(@Const gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_set_zero(gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_tree_rebuild(gsl_spmatrix_float m);

/* compress */

public static native int gsl_spmatrix_float_csc(gsl_spmatrix_float dest, @Const gsl_spmatrix_float src);
public static native int gsl_spmatrix_float_csr(gsl_spmatrix_float dest, @Const gsl_spmatrix_float src);
public static native gsl_spmatrix_float gsl_spmatrix_float_compress(@Const gsl_spmatrix_float src, int sptype);
public static native gsl_spmatrix_float gsl_spmatrix_float_compcol(@Const gsl_spmatrix_float src);
public static native gsl_spmatrix_float gsl_spmatrix_float_ccs(@Const gsl_spmatrix_float src);
public static native gsl_spmatrix_float gsl_spmatrix_float_crs(@Const gsl_spmatrix_float src);

/* copy */

public static native int gsl_spmatrix_float_memcpy(gsl_spmatrix_float dest, @Const gsl_spmatrix_float src);

/* file I/O */

public static native int gsl_spmatrix_float_fprintf(FILE stream, @Const gsl_spmatrix_float m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_float_fprintf(FILE stream, @Const gsl_spmatrix_float m, String format);
public static native gsl_spmatrix_float gsl_spmatrix_float_fscanf(FILE stream);
public static native int gsl_spmatrix_float_fwrite(FILE stream, @Const gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_fread(FILE stream, gsl_spmatrix_float m);

/* get/set */

public static native float gsl_spmatrix_float_get(@Const gsl_spmatrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_float_set(gsl_spmatrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j, float x);
public static native FloatPointer gsl_spmatrix_float_ptr(@Const gsl_spmatrix_float m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_float_minmax(@Const gsl_spmatrix_float m, FloatPointer min_out, FloatPointer max_out);
public static native int gsl_spmatrix_float_minmax(@Const gsl_spmatrix_float m, FloatBuffer min_out, FloatBuffer max_out);
public static native int gsl_spmatrix_float_minmax(@Const gsl_spmatrix_float m, float[] min_out, float[] max_out);
public static native int gsl_spmatrix_float_min_index(@Const gsl_spmatrix_float m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_float_scale(gsl_spmatrix_float m, float x);
public static native int gsl_spmatrix_float_scale_columns(gsl_spmatrix_float m, @Const gsl_vector_float x);
public static native int gsl_spmatrix_float_scale_rows(gsl_spmatrix_float m, @Const gsl_vector_float x);
public static native int gsl_spmatrix_float_add(gsl_spmatrix_float c, @Const gsl_spmatrix_float a, @Const gsl_spmatrix_float b);
public static native int gsl_spmatrix_float_dense_add(gsl_matrix_float a, @Const gsl_spmatrix_float b);
public static native int gsl_spmatrix_float_dense_sub(gsl_matrix_float a, @Const gsl_spmatrix_float b);
public static native int gsl_spmatrix_float_d2sp(gsl_spmatrix_float T, @Const gsl_matrix_float A);
public static native int gsl_spmatrix_float_sp2d(gsl_matrix_float A, @Const gsl_spmatrix_float S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_float_add_to_dense(gsl_matrix_float a, @Const gsl_spmatrix_float b);

// #endif

/* properties */

public static native int gsl_spmatrix_float_equal(@Const gsl_spmatrix_float a, @Const gsl_spmatrix_float b);
public static native float gsl_spmatrix_float_norm1(@Const gsl_spmatrix_float a);

/* swap */

public static native int gsl_spmatrix_float_transpose(gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_transpose2(gsl_spmatrix_float m);
public static native int gsl_spmatrix_float_transpose_memcpy(gsl_spmatrix_float dest, @Const gsl_spmatrix_float src);

// #endif /* __GSL_SPMATRIX_FLOAT_H__ */


// Parsed from gsl/gsl_spmatrix_ulong.h

/* spmatrix/gsl_spmatrix_ulong.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_ULONG_H__
// #define __GSL_SPMATRIX_ULONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_ulong.h>
// #include <gsl/gsl_matrix_ulong.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_ulong.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_ulong_free(gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_ulong m);
public static native @Cast("size_t") long gsl_spmatrix_ulong_nnz(@Const gsl_spmatrix_ulong m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_ulong_type(@Const gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_set_zero(gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_tree_rebuild(gsl_spmatrix_ulong m);

/* compress */

public static native int gsl_spmatrix_ulong_csc(gsl_spmatrix_ulong dest, @Const gsl_spmatrix_ulong src);
public static native int gsl_spmatrix_ulong_csr(gsl_spmatrix_ulong dest, @Const gsl_spmatrix_ulong src);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_compress(@Const gsl_spmatrix_ulong src, int sptype);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_compcol(@Const gsl_spmatrix_ulong src);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_ccs(@Const gsl_spmatrix_ulong src);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_crs(@Const gsl_spmatrix_ulong src);

/* copy */

public static native int gsl_spmatrix_ulong_memcpy(gsl_spmatrix_ulong dest, @Const gsl_spmatrix_ulong src);

/* file I/O */

public static native int gsl_spmatrix_ulong_fprintf(FILE stream, @Const gsl_spmatrix_ulong m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_ulong_fprintf(FILE stream, @Const gsl_spmatrix_ulong m, String format);
public static native gsl_spmatrix_ulong gsl_spmatrix_ulong_fscanf(FILE stream);
public static native int gsl_spmatrix_ulong_fwrite(FILE stream, @Const gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_fread(FILE stream, gsl_spmatrix_ulong m);

/* get/set */

public static native @Cast("unsigned long") long gsl_spmatrix_ulong_get(@Const gsl_spmatrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_ulong_set(gsl_spmatrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned long") long x);
public static native @Cast("unsigned long*") CLongPointer gsl_spmatrix_ulong_ptr(@Const gsl_spmatrix_ulong m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_ulong_minmax(@Const gsl_spmatrix_ulong m, @Cast("unsigned long*") CLongPointer min_out, @Cast("unsigned long*") CLongPointer max_out);
public static native int gsl_spmatrix_ulong_min_index(@Const gsl_spmatrix_ulong m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_ulong_scale(gsl_spmatrix_ulong m, @Cast("const unsigned long") long x);
public static native int gsl_spmatrix_ulong_scale_columns(gsl_spmatrix_ulong m, @Const gsl_vector_ulong x);
public static native int gsl_spmatrix_ulong_scale_rows(gsl_spmatrix_ulong m, @Const gsl_vector_ulong x);
public static native int gsl_spmatrix_ulong_add(gsl_spmatrix_ulong c, @Const gsl_spmatrix_ulong a, @Const gsl_spmatrix_ulong b);
public static native int gsl_spmatrix_ulong_dense_add(gsl_matrix_ulong a, @Const gsl_spmatrix_ulong b);
public static native int gsl_spmatrix_ulong_dense_sub(gsl_matrix_ulong a, @Const gsl_spmatrix_ulong b);
public static native int gsl_spmatrix_ulong_d2sp(gsl_spmatrix_ulong T, @Const gsl_matrix_ulong A);
public static native int gsl_spmatrix_ulong_sp2d(gsl_matrix_ulong A, @Const gsl_spmatrix_ulong S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_ulong_add_to_dense(gsl_matrix_ulong a, @Const gsl_spmatrix_ulong b);

// #endif

/* properties */

public static native int gsl_spmatrix_ulong_equal(@Const gsl_spmatrix_ulong a, @Const gsl_spmatrix_ulong b);


/* swap */

public static native int gsl_spmatrix_ulong_transpose(gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_transpose2(gsl_spmatrix_ulong m);
public static native int gsl_spmatrix_ulong_transpose_memcpy(gsl_spmatrix_ulong dest, @Const gsl_spmatrix_ulong src);

// #endif /* __GSL_SPMATRIX_ULONG_H__ */


// Parsed from gsl/gsl_spmatrix_long.h

/* spmatrix/gsl_spmatrix_long.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_LONG_H__
// #define __GSL_SPMATRIX_LONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_long.h>
// #include <gsl/gsl_matrix_long.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_long.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_long gsl_spmatrix_long_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_long gsl_spmatrix_long_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_long_free(gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_long m);
public static native @Cast("size_t") long gsl_spmatrix_long_nnz(@Const gsl_spmatrix_long m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_long_type(@Const gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_set_zero(gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_tree_rebuild(gsl_spmatrix_long m);

/* compress */

public static native int gsl_spmatrix_long_csc(gsl_spmatrix_long dest, @Const gsl_spmatrix_long src);
public static native int gsl_spmatrix_long_csr(gsl_spmatrix_long dest, @Const gsl_spmatrix_long src);
public static native gsl_spmatrix_long gsl_spmatrix_long_compress(@Const gsl_spmatrix_long src, int sptype);
public static native gsl_spmatrix_long gsl_spmatrix_long_compcol(@Const gsl_spmatrix_long src);
public static native gsl_spmatrix_long gsl_spmatrix_long_ccs(@Const gsl_spmatrix_long src);
public static native gsl_spmatrix_long gsl_spmatrix_long_crs(@Const gsl_spmatrix_long src);

/* copy */

public static native int gsl_spmatrix_long_memcpy(gsl_spmatrix_long dest, @Const gsl_spmatrix_long src);

/* file I/O */

public static native int gsl_spmatrix_long_fprintf(FILE stream, @Const gsl_spmatrix_long m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_long_fprintf(FILE stream, @Const gsl_spmatrix_long m, String format);
public static native gsl_spmatrix_long gsl_spmatrix_long_fscanf(FILE stream);
public static native int gsl_spmatrix_long_fwrite(FILE stream, @Const gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_fread(FILE stream, gsl_spmatrix_long m);

/* get/set */

public static native long gsl_spmatrix_long_get(@Const gsl_spmatrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_long_set(gsl_spmatrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j, long x);
public static native CLongPointer gsl_spmatrix_long_ptr(@Const gsl_spmatrix_long m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_long_minmax(@Const gsl_spmatrix_long m, CLongPointer min_out, CLongPointer max_out);
public static native int gsl_spmatrix_long_min_index(@Const gsl_spmatrix_long m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_long_scale(gsl_spmatrix_long m, long x);
public static native int gsl_spmatrix_long_scale_columns(gsl_spmatrix_long m, @Const gsl_vector_long x);
public static native int gsl_spmatrix_long_scale_rows(gsl_spmatrix_long m, @Const gsl_vector_long x);
public static native int gsl_spmatrix_long_add(gsl_spmatrix_long c, @Const gsl_spmatrix_long a, @Const gsl_spmatrix_long b);
public static native int gsl_spmatrix_long_dense_add(gsl_matrix_long a, @Const gsl_spmatrix_long b);
public static native int gsl_spmatrix_long_dense_sub(gsl_matrix_long a, @Const gsl_spmatrix_long b);
public static native int gsl_spmatrix_long_d2sp(gsl_spmatrix_long T, @Const gsl_matrix_long A);
public static native int gsl_spmatrix_long_sp2d(gsl_matrix_long A, @Const gsl_spmatrix_long S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_long_add_to_dense(gsl_matrix_long a, @Const gsl_spmatrix_long b);

// #endif

/* properties */

public static native int gsl_spmatrix_long_equal(@Const gsl_spmatrix_long a, @Const gsl_spmatrix_long b);
public static native long gsl_spmatrix_long_norm1(@Const gsl_spmatrix_long a);

/* swap */

public static native int gsl_spmatrix_long_transpose(gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_transpose2(gsl_spmatrix_long m);
public static native int gsl_spmatrix_long_transpose_memcpy(gsl_spmatrix_long dest, @Const gsl_spmatrix_long src);

// #endif /* __GSL_SPMATRIX_LONG_H__ */


// Parsed from gsl/gsl_spmatrix_uint.h

/* spmatrix/gsl_spmatrix_uint.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_UINT_H__
// #define __GSL_SPMATRIX_UINT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_uint.h>
// #include <gsl/gsl_matrix_uint.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_uint.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_uint gsl_spmatrix_uint_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_uint_free(gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_uint m);
public static native @Cast("size_t") long gsl_spmatrix_uint_nnz(@Const gsl_spmatrix_uint m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_uint_type(@Const gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_set_zero(gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_tree_rebuild(gsl_spmatrix_uint m);

/* compress */

public static native int gsl_spmatrix_uint_csc(gsl_spmatrix_uint dest, @Const gsl_spmatrix_uint src);
public static native int gsl_spmatrix_uint_csr(gsl_spmatrix_uint dest, @Const gsl_spmatrix_uint src);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_compress(@Const gsl_spmatrix_uint src, int sptype);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_compcol(@Const gsl_spmatrix_uint src);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_ccs(@Const gsl_spmatrix_uint src);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_crs(@Const gsl_spmatrix_uint src);

/* copy */

public static native int gsl_spmatrix_uint_memcpy(gsl_spmatrix_uint dest, @Const gsl_spmatrix_uint src);

/* file I/O */

public static native int gsl_spmatrix_uint_fprintf(FILE stream, @Const gsl_spmatrix_uint m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_uint_fprintf(FILE stream, @Const gsl_spmatrix_uint m, String format);
public static native gsl_spmatrix_uint gsl_spmatrix_uint_fscanf(FILE stream);
public static native int gsl_spmatrix_uint_fwrite(FILE stream, @Const gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_fread(FILE stream, gsl_spmatrix_uint m);

/* get/set */

public static native @Cast("unsigned int") int gsl_spmatrix_uint_get(@Const gsl_spmatrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_uint_set(gsl_spmatrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned int") int x);
public static native @Cast("unsigned int*") IntPointer gsl_spmatrix_uint_ptr(@Const gsl_spmatrix_uint m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_uint_minmax(@Const gsl_spmatrix_uint m, @Cast("unsigned int*") IntPointer min_out, @Cast("unsigned int*") IntPointer max_out);
public static native int gsl_spmatrix_uint_minmax(@Const gsl_spmatrix_uint m, @Cast("unsigned int*") IntBuffer min_out, @Cast("unsigned int*") IntBuffer max_out);
public static native int gsl_spmatrix_uint_minmax(@Const gsl_spmatrix_uint m, @Cast("unsigned int*") int[] min_out, @Cast("unsigned int*") int[] max_out);
public static native int gsl_spmatrix_uint_min_index(@Const gsl_spmatrix_uint m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_uint_scale(gsl_spmatrix_uint m, @Cast("const unsigned int") int x);
public static native int gsl_spmatrix_uint_scale_columns(gsl_spmatrix_uint m, @Const gsl_vector_uint x);
public static native int gsl_spmatrix_uint_scale_rows(gsl_spmatrix_uint m, @Const gsl_vector_uint x);
public static native int gsl_spmatrix_uint_add(gsl_spmatrix_uint c, @Const gsl_spmatrix_uint a, @Const gsl_spmatrix_uint b);
public static native int gsl_spmatrix_uint_dense_add(gsl_matrix_uint a, @Const gsl_spmatrix_uint b);
public static native int gsl_spmatrix_uint_dense_sub(gsl_matrix_uint a, @Const gsl_spmatrix_uint b);
public static native int gsl_spmatrix_uint_d2sp(gsl_spmatrix_uint T, @Const gsl_matrix_uint A);
public static native int gsl_spmatrix_uint_sp2d(gsl_matrix_uint A, @Const gsl_spmatrix_uint S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_uint_add_to_dense(gsl_matrix_uint a, @Const gsl_spmatrix_uint b);

// #endif

/* properties */

public static native int gsl_spmatrix_uint_equal(@Const gsl_spmatrix_uint a, @Const gsl_spmatrix_uint b);


/* swap */

public static native int gsl_spmatrix_uint_transpose(gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_transpose2(gsl_spmatrix_uint m);
public static native int gsl_spmatrix_uint_transpose_memcpy(gsl_spmatrix_uint dest, @Const gsl_spmatrix_uint src);

// #endif /* __GSL_SPMATRIX_UINT_H__ */


// Parsed from gsl/gsl_spmatrix_int.h

/* spmatrix/gsl_spmatrix_int.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_INT_H__
// #define __GSL_SPMATRIX_INT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_int.h>
// #include <gsl/gsl_matrix_int.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_int.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_int gsl_spmatrix_int_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_int gsl_spmatrix_int_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_int_free(gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_int m);
public static native @Cast("size_t") long gsl_spmatrix_int_nnz(@Const gsl_spmatrix_int m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_int_type(@Const gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_set_zero(gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_tree_rebuild(gsl_spmatrix_int m);

/* compress */

public static native int gsl_spmatrix_int_csc(gsl_spmatrix_int dest, @Const gsl_spmatrix_int src);
public static native int gsl_spmatrix_int_csr(gsl_spmatrix_int dest, @Const gsl_spmatrix_int src);
public static native gsl_spmatrix_int gsl_spmatrix_int_compress(@Const gsl_spmatrix_int src, int sptype);
public static native gsl_spmatrix_int gsl_spmatrix_int_compcol(@Const gsl_spmatrix_int src);
public static native gsl_spmatrix_int gsl_spmatrix_int_ccs(@Const gsl_spmatrix_int src);
public static native gsl_spmatrix_int gsl_spmatrix_int_crs(@Const gsl_spmatrix_int src);

/* copy */

public static native int gsl_spmatrix_int_memcpy(gsl_spmatrix_int dest, @Const gsl_spmatrix_int src);

/* file I/O */

public static native int gsl_spmatrix_int_fprintf(FILE stream, @Const gsl_spmatrix_int m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_int_fprintf(FILE stream, @Const gsl_spmatrix_int m, String format);
public static native gsl_spmatrix_int gsl_spmatrix_int_fscanf(FILE stream);
public static native int gsl_spmatrix_int_fwrite(FILE stream, @Const gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_fread(FILE stream, gsl_spmatrix_int m);

/* get/set */

public static native int gsl_spmatrix_int_get(@Const gsl_spmatrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_int_set(gsl_spmatrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j, int x);
public static native IntPointer gsl_spmatrix_int_ptr(@Const gsl_spmatrix_int m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_int_minmax(@Const gsl_spmatrix_int m, IntPointer min_out, IntPointer max_out);
public static native int gsl_spmatrix_int_minmax(@Const gsl_spmatrix_int m, IntBuffer min_out, IntBuffer max_out);
public static native int gsl_spmatrix_int_minmax(@Const gsl_spmatrix_int m, int[] min_out, int[] max_out);
public static native int gsl_spmatrix_int_min_index(@Const gsl_spmatrix_int m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_int_scale(gsl_spmatrix_int m, int x);
public static native int gsl_spmatrix_int_scale_columns(gsl_spmatrix_int m, @Const gsl_vector_int x);
public static native int gsl_spmatrix_int_scale_rows(gsl_spmatrix_int m, @Const gsl_vector_int x);
public static native int gsl_spmatrix_int_add(gsl_spmatrix_int c, @Const gsl_spmatrix_int a, @Const gsl_spmatrix_int b);
public static native int gsl_spmatrix_int_dense_add(gsl_matrix_int a, @Const gsl_spmatrix_int b);
public static native int gsl_spmatrix_int_dense_sub(gsl_matrix_int a, @Const gsl_spmatrix_int b);
public static native int gsl_spmatrix_int_d2sp(gsl_spmatrix_int T, @Const gsl_matrix_int A);
public static native int gsl_spmatrix_int_sp2d(gsl_matrix_int A, @Const gsl_spmatrix_int S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_int_add_to_dense(gsl_matrix_int a, @Const gsl_spmatrix_int b);

// #endif

/* properties */

public static native int gsl_spmatrix_int_equal(@Const gsl_spmatrix_int a, @Const gsl_spmatrix_int b);
public static native int gsl_spmatrix_int_norm1(@Const gsl_spmatrix_int a);

/* swap */

public static native int gsl_spmatrix_int_transpose(gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_transpose2(gsl_spmatrix_int m);
public static native int gsl_spmatrix_int_transpose_memcpy(gsl_spmatrix_int dest, @Const gsl_spmatrix_int src);

// #endif /* __GSL_SPMATRIX_INT_H__ */


// Parsed from gsl/gsl_spmatrix_ushort.h

/* spmatrix/gsl_spmatrix_ushort.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_USHORT_H__
// #define __GSL_SPMATRIX_USHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_ushort.h>
// #include <gsl/gsl_matrix_ushort.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_ushort.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_ushort_free(gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_ushort m);
public static native @Cast("size_t") long gsl_spmatrix_ushort_nnz(@Const gsl_spmatrix_ushort m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_ushort_type(@Const gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_set_zero(gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_tree_rebuild(gsl_spmatrix_ushort m);

/* compress */

public static native int gsl_spmatrix_ushort_csc(gsl_spmatrix_ushort dest, @Const gsl_spmatrix_ushort src);
public static native int gsl_spmatrix_ushort_csr(gsl_spmatrix_ushort dest, @Const gsl_spmatrix_ushort src);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_compress(@Const gsl_spmatrix_ushort src, int sptype);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_compcol(@Const gsl_spmatrix_ushort src);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_ccs(@Const gsl_spmatrix_ushort src);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_crs(@Const gsl_spmatrix_ushort src);

/* copy */

public static native int gsl_spmatrix_ushort_memcpy(gsl_spmatrix_ushort dest, @Const gsl_spmatrix_ushort src);

/* file I/O */

public static native int gsl_spmatrix_ushort_fprintf(FILE stream, @Const gsl_spmatrix_ushort m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_ushort_fprintf(FILE stream, @Const gsl_spmatrix_ushort m, String format);
public static native gsl_spmatrix_ushort gsl_spmatrix_ushort_fscanf(FILE stream);
public static native int gsl_spmatrix_ushort_fwrite(FILE stream, @Const gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_fread(FILE stream, gsl_spmatrix_ushort m);

/* get/set */

public static native @Cast("unsigned short") short gsl_spmatrix_ushort_get(@Const gsl_spmatrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_ushort_set(gsl_spmatrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned short") short x);
public static native @Cast("unsigned short*") ShortPointer gsl_spmatrix_ushort_ptr(@Const gsl_spmatrix_ushort m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_ushort_minmax(@Const gsl_spmatrix_ushort m, @Cast("unsigned short*") ShortPointer min_out, @Cast("unsigned short*") ShortPointer max_out);
public static native int gsl_spmatrix_ushort_minmax(@Const gsl_spmatrix_ushort m, @Cast("unsigned short*") ShortBuffer min_out, @Cast("unsigned short*") ShortBuffer max_out);
public static native int gsl_spmatrix_ushort_minmax(@Const gsl_spmatrix_ushort m, @Cast("unsigned short*") short[] min_out, @Cast("unsigned short*") short[] max_out);
public static native int gsl_spmatrix_ushort_min_index(@Const gsl_spmatrix_ushort m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_ushort_scale(gsl_spmatrix_ushort m, @Cast("const unsigned short") short x);
public static native int gsl_spmatrix_ushort_scale_columns(gsl_spmatrix_ushort m, @Const gsl_vector_ushort x);
public static native int gsl_spmatrix_ushort_scale_rows(gsl_spmatrix_ushort m, @Const gsl_vector_ushort x);
public static native int gsl_spmatrix_ushort_add(gsl_spmatrix_ushort c, @Const gsl_spmatrix_ushort a, @Const gsl_spmatrix_ushort b);
public static native int gsl_spmatrix_ushort_dense_add(gsl_matrix_ushort a, @Const gsl_spmatrix_ushort b);
public static native int gsl_spmatrix_ushort_dense_sub(gsl_matrix_ushort a, @Const gsl_spmatrix_ushort b);
public static native int gsl_spmatrix_ushort_d2sp(gsl_spmatrix_ushort T, @Const gsl_matrix_ushort A);
public static native int gsl_spmatrix_ushort_sp2d(gsl_matrix_ushort A, @Const gsl_spmatrix_ushort S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_ushort_add_to_dense(gsl_matrix_ushort a, @Const gsl_spmatrix_ushort b);

// #endif

/* properties */

public static native int gsl_spmatrix_ushort_equal(@Const gsl_spmatrix_ushort a, @Const gsl_spmatrix_ushort b);


/* swap */

public static native int gsl_spmatrix_ushort_transpose(gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_transpose2(gsl_spmatrix_ushort m);
public static native int gsl_spmatrix_ushort_transpose_memcpy(gsl_spmatrix_ushort dest, @Const gsl_spmatrix_ushort src);

// #endif /* __GSL_SPMATRIX_USHORT_H__ */


// Parsed from gsl/gsl_spmatrix_short.h

/* spmatrix/gsl_spmatrix_short.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_SHORT_H__
// #define __GSL_SPMATRIX_SHORT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_short.h>
// #include <gsl/gsl_matrix_short.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_short.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_short gsl_spmatrix_short_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_short gsl_spmatrix_short_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_short_free(gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_short m);
public static native @Cast("size_t") long gsl_spmatrix_short_nnz(@Const gsl_spmatrix_short m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_short_type(@Const gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_set_zero(gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_tree_rebuild(gsl_spmatrix_short m);

/* compress */

public static native int gsl_spmatrix_short_csc(gsl_spmatrix_short dest, @Const gsl_spmatrix_short src);
public static native int gsl_spmatrix_short_csr(gsl_spmatrix_short dest, @Const gsl_spmatrix_short src);
public static native gsl_spmatrix_short gsl_spmatrix_short_compress(@Const gsl_spmatrix_short src, int sptype);
public static native gsl_spmatrix_short gsl_spmatrix_short_compcol(@Const gsl_spmatrix_short src);
public static native gsl_spmatrix_short gsl_spmatrix_short_ccs(@Const gsl_spmatrix_short src);
public static native gsl_spmatrix_short gsl_spmatrix_short_crs(@Const gsl_spmatrix_short src);

/* copy */

public static native int gsl_spmatrix_short_memcpy(gsl_spmatrix_short dest, @Const gsl_spmatrix_short src);

/* file I/O */

public static native int gsl_spmatrix_short_fprintf(FILE stream, @Const gsl_spmatrix_short m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_short_fprintf(FILE stream, @Const gsl_spmatrix_short m, String format);
public static native gsl_spmatrix_short gsl_spmatrix_short_fscanf(FILE stream);
public static native int gsl_spmatrix_short_fwrite(FILE stream, @Const gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_fread(FILE stream, gsl_spmatrix_short m);

/* get/set */

public static native short gsl_spmatrix_short_get(@Const gsl_spmatrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_short_set(gsl_spmatrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j, short x);
public static native ShortPointer gsl_spmatrix_short_ptr(@Const gsl_spmatrix_short m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_short_minmax(@Const gsl_spmatrix_short m, ShortPointer min_out, ShortPointer max_out);
public static native int gsl_spmatrix_short_minmax(@Const gsl_spmatrix_short m, ShortBuffer min_out, ShortBuffer max_out);
public static native int gsl_spmatrix_short_minmax(@Const gsl_spmatrix_short m, short[] min_out, short[] max_out);
public static native int gsl_spmatrix_short_min_index(@Const gsl_spmatrix_short m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_short_scale(gsl_spmatrix_short m, short x);
public static native int gsl_spmatrix_short_scale_columns(gsl_spmatrix_short m, @Const gsl_vector_short x);
public static native int gsl_spmatrix_short_scale_rows(gsl_spmatrix_short m, @Const gsl_vector_short x);
public static native int gsl_spmatrix_short_add(gsl_spmatrix_short c, @Const gsl_spmatrix_short a, @Const gsl_spmatrix_short b);
public static native int gsl_spmatrix_short_dense_add(gsl_matrix_short a, @Const gsl_spmatrix_short b);
public static native int gsl_spmatrix_short_dense_sub(gsl_matrix_short a, @Const gsl_spmatrix_short b);
public static native int gsl_spmatrix_short_d2sp(gsl_spmatrix_short T, @Const gsl_matrix_short A);
public static native int gsl_spmatrix_short_sp2d(gsl_matrix_short A, @Const gsl_spmatrix_short S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_short_add_to_dense(gsl_matrix_short a, @Const gsl_spmatrix_short b);

// #endif

/* properties */

public static native int gsl_spmatrix_short_equal(@Const gsl_spmatrix_short a, @Const gsl_spmatrix_short b);
public static native short gsl_spmatrix_short_norm1(@Const gsl_spmatrix_short a);

/* swap */

public static native int gsl_spmatrix_short_transpose(gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_transpose2(gsl_spmatrix_short m);
public static native int gsl_spmatrix_short_transpose_memcpy(gsl_spmatrix_short dest, @Const gsl_spmatrix_short src);

// #endif /* __GSL_SPMATRIX_SHORT_H__ */


// Parsed from gsl/gsl_spmatrix_uchar.h

/* spmatrix/gsl_spmatrix_uchar.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_UCHAR_H__
// #define __GSL_SPMATRIX_UCHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_uchar.h>
// #include <gsl/gsl_matrix_uchar.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_uchar.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_uchar_free(gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_uchar m);
public static native @Cast("size_t") long gsl_spmatrix_uchar_nnz(@Const gsl_spmatrix_uchar m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_uchar_type(@Const gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_set_zero(gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_tree_rebuild(gsl_spmatrix_uchar m);

/* compress */

public static native int gsl_spmatrix_uchar_csc(gsl_spmatrix_uchar dest, @Const gsl_spmatrix_uchar src);
public static native int gsl_spmatrix_uchar_csr(gsl_spmatrix_uchar dest, @Const gsl_spmatrix_uchar src);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_compress(@Const gsl_spmatrix_uchar src, int sptype);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_compcol(@Const gsl_spmatrix_uchar src);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_ccs(@Const gsl_spmatrix_uchar src);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_crs(@Const gsl_spmatrix_uchar src);

/* copy */

public static native int gsl_spmatrix_uchar_memcpy(gsl_spmatrix_uchar dest, @Const gsl_spmatrix_uchar src);

/* file I/O */

public static native int gsl_spmatrix_uchar_fprintf(FILE stream, @Const gsl_spmatrix_uchar m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_uchar_fprintf(FILE stream, @Const gsl_spmatrix_uchar m, String format);
public static native gsl_spmatrix_uchar gsl_spmatrix_uchar_fscanf(FILE stream);
public static native int gsl_spmatrix_uchar_fwrite(FILE stream, @Const gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_fread(FILE stream, gsl_spmatrix_uchar m);

/* get/set */

public static native @Cast("unsigned char") byte gsl_spmatrix_uchar_get(@Const gsl_spmatrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_uchar_set(gsl_spmatrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const unsigned char") byte x);
public static native @Cast("unsigned char*") BytePointer gsl_spmatrix_uchar_ptr(@Const gsl_spmatrix_uchar m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_uchar_minmax(@Const gsl_spmatrix_uchar m, @Cast("unsigned char*") BytePointer min_out, @Cast("unsigned char*") BytePointer max_out);
public static native int gsl_spmatrix_uchar_minmax(@Const gsl_spmatrix_uchar m, @Cast("unsigned char*") ByteBuffer min_out, @Cast("unsigned char*") ByteBuffer max_out);
public static native int gsl_spmatrix_uchar_minmax(@Const gsl_spmatrix_uchar m, @Cast("unsigned char*") byte[] min_out, @Cast("unsigned char*") byte[] max_out);
public static native int gsl_spmatrix_uchar_min_index(@Const gsl_spmatrix_uchar m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_uchar_scale(gsl_spmatrix_uchar m, @Cast("const unsigned char") byte x);
public static native int gsl_spmatrix_uchar_scale_columns(gsl_spmatrix_uchar m, @Const gsl_vector_uchar x);
public static native int gsl_spmatrix_uchar_scale_rows(gsl_spmatrix_uchar m, @Const gsl_vector_uchar x);
public static native int gsl_spmatrix_uchar_add(gsl_spmatrix_uchar c, @Const gsl_spmatrix_uchar a, @Const gsl_spmatrix_uchar b);
public static native int gsl_spmatrix_uchar_dense_add(gsl_matrix_uchar a, @Const gsl_spmatrix_uchar b);
public static native int gsl_spmatrix_uchar_dense_sub(gsl_matrix_uchar a, @Const gsl_spmatrix_uchar b);
public static native int gsl_spmatrix_uchar_d2sp(gsl_spmatrix_uchar T, @Const gsl_matrix_uchar A);
public static native int gsl_spmatrix_uchar_sp2d(gsl_matrix_uchar A, @Const gsl_spmatrix_uchar S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_uchar_add_to_dense(gsl_matrix_uchar a, @Const gsl_spmatrix_uchar b);

// #endif

/* properties */

public static native int gsl_spmatrix_uchar_equal(@Const gsl_spmatrix_uchar a, @Const gsl_spmatrix_uchar b);


/* swap */

public static native int gsl_spmatrix_uchar_transpose(gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_transpose2(gsl_spmatrix_uchar m);
public static native int gsl_spmatrix_uchar_transpose_memcpy(gsl_spmatrix_uchar dest, @Const gsl_spmatrix_uchar src);

// #endif /* __GSL_SPMATRIX_UCHAR_H__ */


// Parsed from gsl/gsl_spmatrix_char.h

/* spmatrix/gsl_spmatrix_char.h
 * 
 * Copyright (C) 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020 Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_SPMATRIX_CHAR_H__
// #define __GSL_SPMATRIX_CHAR_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_bst.h>
// #include <gsl/gsl_vector_char.h>
// #include <gsl/gsl_matrix_char.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_spmatrix_char.java



/*
 * Prototypes
 */

/* allocation / initialization */

public static native gsl_spmatrix_char gsl_spmatrix_char_alloc(@Cast("const size_t") long n1, @Cast("const size_t") long n2);
public static native gsl_spmatrix_char gsl_spmatrix_char_alloc_nzmax(@Cast("const size_t") long n1, @Cast("const size_t") long n2,
                                                     @Cast("const size_t") long nzmax, int sptype);
public static native void gsl_spmatrix_char_free(gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_realloc(@Cast("const size_t") long nzmax, gsl_spmatrix_char m);
public static native @Cast("size_t") long gsl_spmatrix_char_nnz(@Const gsl_spmatrix_char m);
public static native @Cast("const char*") BytePointer gsl_spmatrix_char_type(@Const gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_set_zero(gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_tree_rebuild(gsl_spmatrix_char m);

/* compress */

public static native int gsl_spmatrix_char_csc(gsl_spmatrix_char dest, @Const gsl_spmatrix_char src);
public static native int gsl_spmatrix_char_csr(gsl_spmatrix_char dest, @Const gsl_spmatrix_char src);
public static native gsl_spmatrix_char gsl_spmatrix_char_compress(@Const gsl_spmatrix_char src, int sptype);
public static native gsl_spmatrix_char gsl_spmatrix_char_compcol(@Const gsl_spmatrix_char src);
public static native gsl_spmatrix_char gsl_spmatrix_char_ccs(@Const gsl_spmatrix_char src);
public static native gsl_spmatrix_char gsl_spmatrix_char_crs(@Const gsl_spmatrix_char src);

/* copy */

public static native int gsl_spmatrix_char_memcpy(gsl_spmatrix_char dest, @Const gsl_spmatrix_char src);

/* file I/O */

public static native int gsl_spmatrix_char_fprintf(FILE stream, @Const gsl_spmatrix_char m, @Cast("const char*") BytePointer format);
public static native int gsl_spmatrix_char_fprintf(FILE stream, @Const gsl_spmatrix_char m, String format);
public static native gsl_spmatrix_char gsl_spmatrix_char_fscanf(FILE stream);
public static native int gsl_spmatrix_char_fwrite(FILE stream, @Const gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_fread(FILE stream, gsl_spmatrix_char m);

/* get/set */

public static native @Cast("char") byte gsl_spmatrix_char_get(@Const gsl_spmatrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);
public static native int gsl_spmatrix_char_set(gsl_spmatrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j, @Cast("const char") byte x);
public static native @Cast("char*") BytePointer gsl_spmatrix_char_ptr(@Const gsl_spmatrix_char m, @Cast("const size_t") long i, @Cast("const size_t") long j);

/* minmax */

public static native int gsl_spmatrix_char_minmax(@Const gsl_spmatrix_char m, @Cast("char*") BytePointer min_out, @Cast("char*") BytePointer max_out);
public static native int gsl_spmatrix_char_minmax(@Const gsl_spmatrix_char m, @Cast("char*") ByteBuffer min_out, @Cast("char*") ByteBuffer max_out);
public static native int gsl_spmatrix_char_minmax(@Const gsl_spmatrix_char m, @Cast("char*") byte[] min_out, @Cast("char*") byte[] max_out);
public static native int gsl_spmatrix_char_min_index(@Const gsl_spmatrix_char m, @Cast("size_t*") SizeTPointer imin_out, @Cast("size_t*") SizeTPointer jmin_out);

/* operations */

public static native int gsl_spmatrix_char_scale(gsl_spmatrix_char m, @Cast("const char") byte x);
public static native int gsl_spmatrix_char_scale_columns(gsl_spmatrix_char m, @Const gsl_vector_char x);
public static native int gsl_spmatrix_char_scale_rows(gsl_spmatrix_char m, @Const gsl_vector_char x);
public static native int gsl_spmatrix_char_add(gsl_spmatrix_char c, @Const gsl_spmatrix_char a, @Const gsl_spmatrix_char b);
public static native int gsl_spmatrix_char_dense_add(gsl_matrix_char a, @Const gsl_spmatrix_char b);
public static native int gsl_spmatrix_char_dense_sub(gsl_matrix_char a, @Const gsl_spmatrix_char b);
public static native int gsl_spmatrix_char_d2sp(gsl_spmatrix_char T, @Const gsl_matrix_char A);
public static native int gsl_spmatrix_char_sp2d(gsl_matrix_char A, @Const gsl_spmatrix_char S);

// #ifndef GSL_DISABLE_DEPRECATED

public static native int gsl_spmatrix_char_add_to_dense(gsl_matrix_char a, @Const gsl_spmatrix_char b);

// #endif

/* properties */

public static native int gsl_spmatrix_char_equal(@Const gsl_spmatrix_char a, @Const gsl_spmatrix_char b);


/* swap */

public static native int gsl_spmatrix_char_transpose(gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_transpose2(gsl_spmatrix_char m);
public static native int gsl_spmatrix_char_transpose_memcpy(gsl_spmatrix_char dest, @Const gsl_spmatrix_char src);

// #endif /* __GSL_SPMATRIX_CHAR_H__ */


// Parsed from gsl/gsl_const.h

/* const/gsl_const.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2004, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST__
// #define __GSL_CONST__

// #include <gsl/gsl_const_num.h>

// #include <gsl/gsl_const_cgs.h>
// #include <gsl/gsl_const_mks.h>

// #include <gsl/gsl_const_cgsm.h>
// #include <gsl/gsl_const_mksa.h>

// #endif /* __GSL_CONST__ */


// Parsed from gsl/gsl_const_num.h

/* const/gsl_const_num.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
 * 2006, 2007, 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST_NUM__
// #define __GSL_CONST_NUM__

public static final double GSL_CONST_NUM_FINE_STRUCTURE = (7.297352533e-3); /* 1 */
public static final double GSL_CONST_NUM_AVOGADRO = (6.02214199e23); /* 1 / mol */
public static final double GSL_CONST_NUM_YOTTA = (1e24); /* 1 */
public static final double GSL_CONST_NUM_ZETTA = (1e21); /* 1 */
public static final double GSL_CONST_NUM_EXA = (1e18); /* 1 */
public static final double GSL_CONST_NUM_PETA = (1e15); /* 1 */
public static final double GSL_CONST_NUM_TERA = (1e12); /* 1 */
public static final double GSL_CONST_NUM_GIGA = (1e9); /* 1 */
public static final double GSL_CONST_NUM_MEGA = (1e6); /* 1 */
public static final double GSL_CONST_NUM_KILO = (1e3); /* 1 */
public static final double GSL_CONST_NUM_MILLI = (1e-3); /* 1 */
public static final double GSL_CONST_NUM_MICRO = (1e-6); /* 1 */
public static final double GSL_CONST_NUM_NANO = (1e-9); /* 1 */
public static final double GSL_CONST_NUM_PICO = (1e-12); /* 1 */
public static final double GSL_CONST_NUM_FEMTO = (1e-15); /* 1 */
public static final double GSL_CONST_NUM_ATTO = (1e-18); /* 1 */
public static final double GSL_CONST_NUM_ZEPTO = (1e-21); /* 1 */
public static final double GSL_CONST_NUM_YOCTO = (1e-24); /* 1 */

// #endif /* __GSL_CONST_NUM__ */


// Parsed from gsl/gsl_const_cgs.h

/* const/gsl_const_cgs.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
 * 2006, 2007, 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST_CGS__
// #define __GSL_CONST_CGS__

public static final double GSL_CONST_CGS_SPEED_OF_LIGHT = (2.99792458e10); /* cm / s */
public static final double GSL_CONST_CGS_GRAVITATIONAL_CONSTANT = (6.673e-8); /* cm^3 / g s^2 */
public static final double GSL_CONST_CGS_PLANCKS_CONSTANT_H = (6.62606896e-27); /* g cm^2 / s */
public static final double GSL_CONST_CGS_PLANCKS_CONSTANT_HBAR = (1.05457162825e-27); /* g cm^2 / s */
public static final double GSL_CONST_CGS_ASTRONOMICAL_UNIT = (1.49597870691e13); /* cm */
public static final double GSL_CONST_CGS_LIGHT_YEAR = (9.46053620707e17); /* cm */
public static final double GSL_CONST_CGS_PARSEC = (3.08567758135e18); /* cm */
public static final double GSL_CONST_CGS_GRAV_ACCEL = (9.80665e2); /* cm / s^2 */
public static final double GSL_CONST_CGS_ELECTRON_VOLT = (1.602176487e-12); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_MASS_ELECTRON = (9.10938188e-28); /* g */
public static final double GSL_CONST_CGS_MASS_MUON = (1.88353109e-25); /* g */
public static final double GSL_CONST_CGS_MASS_PROTON = (1.67262158e-24); /* g */
public static final double GSL_CONST_CGS_MASS_NEUTRON = (1.67492716e-24); /* g */
public static final double GSL_CONST_CGS_RYDBERG = (2.17987196968e-11); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_BOLTZMANN = (1.3806504e-16); /* g cm^2 / K s^2 */
public static final double GSL_CONST_CGS_MOLAR_GAS = (8.314472e7); /* g cm^2 / K mol s^2 */
public static final double GSL_CONST_CGS_STANDARD_GAS_VOLUME = (2.2710981e4); /* cm^3 / mol */
public static final double GSL_CONST_CGS_MINUTE = (6e1); /* s */
public static final double GSL_CONST_CGS_HOUR = (3.6e3); /* s */
public static final double GSL_CONST_CGS_DAY = (8.64e4); /* s */
public static final double GSL_CONST_CGS_WEEK = (6.048e5); /* s */
public static final double GSL_CONST_CGS_INCH = (2.54e0); /* cm */
public static final double GSL_CONST_CGS_FOOT = (3.048e1); /* cm */
public static final double GSL_CONST_CGS_YARD = (9.144e1); /* cm */
public static final double GSL_CONST_CGS_MILE = (1.609344e5); /* cm */
public static final double GSL_CONST_CGS_NAUTICAL_MILE = (1.852e5); /* cm */
public static final double GSL_CONST_CGS_FATHOM = (1.8288e2); /* cm */
public static final double GSL_CONST_CGS_MIL = (2.54e-3); /* cm */
public static final double GSL_CONST_CGS_POINT = (3.52777777778e-2); /* cm */
public static final double GSL_CONST_CGS_TEXPOINT = (3.51459803515e-2); /* cm */
public static final double GSL_CONST_CGS_MICRON = (1e-4); /* cm */
public static final double GSL_CONST_CGS_ANGSTROM = (1e-8); /* cm */
public static final double GSL_CONST_CGS_HECTARE = (1e8); /* cm^2 */
public static final double GSL_CONST_CGS_ACRE = (4.04685642241e7); /* cm^2 */
public static final double GSL_CONST_CGS_BARN = (1e-24); /* cm^2 */
public static final double GSL_CONST_CGS_LITER = (1e3); /* cm^3 */
public static final double GSL_CONST_CGS_US_GALLON = (3.78541178402e3); /* cm^3 */
public static final double GSL_CONST_CGS_QUART = (9.46352946004e2); /* cm^3 */
public static final double GSL_CONST_CGS_PINT = (4.73176473002e2); /* cm^3 */
public static final double GSL_CONST_CGS_CUP = (2.36588236501e2); /* cm^3 */
public static final double GSL_CONST_CGS_FLUID_OUNCE = (2.95735295626e1); /* cm^3 */
public static final double GSL_CONST_CGS_TABLESPOON = (1.47867647813e1); /* cm^3 */
public static final double GSL_CONST_CGS_TEASPOON = (4.92892159375e0); /* cm^3 */
public static final double GSL_CONST_CGS_CANADIAN_GALLON = (4.54609e3); /* cm^3 */
public static final double GSL_CONST_CGS_UK_GALLON = (4.546092e3); /* cm^3 */
public static final double GSL_CONST_CGS_MILES_PER_HOUR = (4.4704e1); /* cm / s */
public static final double GSL_CONST_CGS_KILOMETERS_PER_HOUR = (2.77777777778e1); /* cm / s */
public static final double GSL_CONST_CGS_KNOT = (5.14444444444e1); /* cm / s */
public static final double GSL_CONST_CGS_POUND_MASS = (4.5359237e2); /* g */
public static final double GSL_CONST_CGS_OUNCE_MASS = (2.8349523125e1); /* g */
public static final double GSL_CONST_CGS_TON = (9.0718474e5); /* g */
public static final double GSL_CONST_CGS_METRIC_TON = (1e6); /* g */
public static final double GSL_CONST_CGS_UK_TON = (1.0160469088e6); /* g */
public static final double GSL_CONST_CGS_TROY_OUNCE = (3.1103475e1); /* g */
public static final double GSL_CONST_CGS_CARAT = (2e-1); /* g */
public static final double GSL_CONST_CGS_UNIFIED_ATOMIC_MASS = (1.660538782e-24); /* g */
public static final double GSL_CONST_CGS_GRAM_FORCE = (9.80665e2); /* cm g / s^2 */
public static final double GSL_CONST_CGS_POUND_FORCE = (4.44822161526e5); /* cm g / s^2 */
public static final double GSL_CONST_CGS_KILOPOUND_FORCE = (4.44822161526e8); /* cm g / s^2 */
public static final double GSL_CONST_CGS_POUNDAL = (1.38255e4); /* cm g / s^2 */
public static final double GSL_CONST_CGS_CALORIE = (4.1868e7); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_BTU = (1.05505585262e10); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_THERM = (1.05506e15); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_HORSEPOWER = (7.457e9); /* g cm^2 / s^3 */
public static final double GSL_CONST_CGS_BAR = (1e6); /* g / cm s^2 */
public static final double GSL_CONST_CGS_STD_ATMOSPHERE = (1.01325e6); /* g / cm s^2 */
public static final double GSL_CONST_CGS_TORR = (1.33322368421e3); /* g / cm s^2 */
public static final double GSL_CONST_CGS_METER_OF_MERCURY = (1.33322368421e6); /* g / cm s^2 */
public static final double GSL_CONST_CGS_INCH_OF_MERCURY = (3.38638815789e4); /* g / cm s^2 */
public static final double GSL_CONST_CGS_INCH_OF_WATER = (2.490889e3); /* g / cm s^2 */
public static final double GSL_CONST_CGS_PSI = (6.89475729317e4); /* g / cm s^2 */
public static final double GSL_CONST_CGS_POISE = (1e0); /* g / cm s */
public static final double GSL_CONST_CGS_STOKES = (1e0); /* cm^2 / s */
public static final double GSL_CONST_CGS_STILB = (1e0); /* cd / cm^2 */
public static final double GSL_CONST_CGS_LUMEN = (1e0); /* cd sr */
public static final double GSL_CONST_CGS_LUX = (1e-4); /* cd sr / cm^2 */
public static final double GSL_CONST_CGS_PHOT = (1e0); /* cd sr / cm^2 */
public static final double GSL_CONST_CGS_FOOTCANDLE = (1.076e-3); /* cd sr / cm^2 */
public static final double GSL_CONST_CGS_LAMBERT = (1e0); /* cd sr / cm^2 */
public static final double GSL_CONST_CGS_FOOTLAMBERT = (1.07639104e-3); /* cd sr / cm^2 */
public static final double GSL_CONST_CGS_CURIE = (3.7e10); /* 1 / s */
public static final double GSL_CONST_CGS_ROENTGEN = (2.58e-7); /* A s / g */
public static final double GSL_CONST_CGS_RAD = (1e2); /* cm^2 / s^2 */
public static final double GSL_CONST_CGS_SOLAR_MASS = (1.98892e33); /* g */
public static final double GSL_CONST_CGS_BOHR_RADIUS = (5.291772083e-9); /* cm */
public static final double GSL_CONST_CGS_NEWTON = (1e5); /* cm g / s^2 */
public static final double GSL_CONST_CGS_DYNE = (1e0); /* cm g / s^2 */
public static final double GSL_CONST_CGS_JOULE = (1e7); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_ERG = (1e0); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGS_STEFAN_BOLTZMANN_CONSTANT = (5.67040047374e-5); /* g / K^4 s^3 */
public static final double GSL_CONST_CGS_THOMSON_CROSS_SECTION = (6.65245893699e-25); /* cm^2 */

// #endif /* __GSL_CONST_CGS__ */


// Parsed from gsl/gsl_const_mks.h

/* const/gsl_const_mks.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
 * 2006, 2007, 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST_MKS__
// #define __GSL_CONST_MKS__

public static final double GSL_CONST_MKS_SPEED_OF_LIGHT = (2.99792458e8); /* m / s */
public static final double GSL_CONST_MKS_GRAVITATIONAL_CONSTANT = (6.673e-11); /* m^3 / kg s^2 */
public static final double GSL_CONST_MKS_PLANCKS_CONSTANT_H = (6.62606896e-34); /* kg m^2 / s */
public static final double GSL_CONST_MKS_PLANCKS_CONSTANT_HBAR = (1.05457162825e-34); /* kg m^2 / s */
public static final double GSL_CONST_MKS_ASTRONOMICAL_UNIT = (1.49597870691e11); /* m */
public static final double GSL_CONST_MKS_LIGHT_YEAR = (9.46053620707e15); /* m */
public static final double GSL_CONST_MKS_PARSEC = (3.08567758135e16); /* m */
public static final double GSL_CONST_MKS_GRAV_ACCEL = (9.80665e0); /* m / s^2 */
public static final double GSL_CONST_MKS_ELECTRON_VOLT = (1.602176487e-19); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_MASS_ELECTRON = (9.10938188e-31); /* kg */
public static final double GSL_CONST_MKS_MASS_MUON = (1.88353109e-28); /* kg */
public static final double GSL_CONST_MKS_MASS_PROTON = (1.67262158e-27); /* kg */
public static final double GSL_CONST_MKS_MASS_NEUTRON = (1.67492716e-27); /* kg */
public static final double GSL_CONST_MKS_RYDBERG = (2.17987196968e-18); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_BOLTZMANN = (1.3806504e-23); /* kg m^2 / K s^2 */
public static final double GSL_CONST_MKS_MOLAR_GAS = (8.314472e0); /* kg m^2 / K mol s^2 */
public static final double GSL_CONST_MKS_STANDARD_GAS_VOLUME = (2.2710981e-2); /* m^3 / mol */
public static final double GSL_CONST_MKS_MINUTE = (6e1); /* s */
public static final double GSL_CONST_MKS_HOUR = (3.6e3); /* s */
public static final double GSL_CONST_MKS_DAY = (8.64e4); /* s */
public static final double GSL_CONST_MKS_WEEK = (6.048e5); /* s */
public static final double GSL_CONST_MKS_INCH = (2.54e-2); /* m */
public static final double GSL_CONST_MKS_FOOT = (3.048e-1); /* m */
public static final double GSL_CONST_MKS_YARD = (9.144e-1); /* m */
public static final double GSL_CONST_MKS_MILE = (1.609344e3); /* m */
public static final double GSL_CONST_MKS_NAUTICAL_MILE = (1.852e3); /* m */
public static final double GSL_CONST_MKS_FATHOM = (1.8288e0); /* m */
public static final double GSL_CONST_MKS_MIL = (2.54e-5); /* m */
public static final double GSL_CONST_MKS_POINT = (3.52777777778e-4); /* m */
public static final double GSL_CONST_MKS_TEXPOINT = (3.51459803515e-4); /* m */
public static final double GSL_CONST_MKS_MICRON = (1e-6); /* m */
public static final double GSL_CONST_MKS_ANGSTROM = (1e-10); /* m */
public static final double GSL_CONST_MKS_HECTARE = (1e4); /* m^2 */
public static final double GSL_CONST_MKS_ACRE = (4.04685642241e3); /* m^2 */
public static final double GSL_CONST_MKS_BARN = (1e-28); /* m^2 */
public static final double GSL_CONST_MKS_LITER = (1e-3); /* m^3 */
public static final double GSL_CONST_MKS_US_GALLON = (3.78541178402e-3); /* m^3 */
public static final double GSL_CONST_MKS_QUART = (9.46352946004e-4); /* m^3 */
public static final double GSL_CONST_MKS_PINT = (4.73176473002e-4); /* m^3 */
public static final double GSL_CONST_MKS_CUP = (2.36588236501e-4); /* m^3 */
public static final double GSL_CONST_MKS_FLUID_OUNCE = (2.95735295626e-5); /* m^3 */
public static final double GSL_CONST_MKS_TABLESPOON = (1.47867647813e-5); /* m^3 */
public static final double GSL_CONST_MKS_TEASPOON = (4.92892159375e-6); /* m^3 */
public static final double GSL_CONST_MKS_CANADIAN_GALLON = (4.54609e-3); /* m^3 */
public static final double GSL_CONST_MKS_UK_GALLON = (4.546092e-3); /* m^3 */
public static final double GSL_CONST_MKS_MILES_PER_HOUR = (4.4704e-1); /* m / s */
public static final double GSL_CONST_MKS_KILOMETERS_PER_HOUR = (2.77777777778e-1); /* m / s */
public static final double GSL_CONST_MKS_KNOT = (5.14444444444e-1); /* m / s */
public static final double GSL_CONST_MKS_POUND_MASS = (4.5359237e-1); /* kg */
public static final double GSL_CONST_MKS_OUNCE_MASS = (2.8349523125e-2); /* kg */
public static final double GSL_CONST_MKS_TON = (9.0718474e2); /* kg */
public static final double GSL_CONST_MKS_METRIC_TON = (1e3); /* kg */
public static final double GSL_CONST_MKS_UK_TON = (1.0160469088e3); /* kg */
public static final double GSL_CONST_MKS_TROY_OUNCE = (3.1103475e-2); /* kg */
public static final double GSL_CONST_MKS_CARAT = (2e-4); /* kg */
public static final double GSL_CONST_MKS_UNIFIED_ATOMIC_MASS = (1.660538782e-27); /* kg */
public static final double GSL_CONST_MKS_GRAM_FORCE = (9.80665e-3); /* kg m / s^2 */
public static final double GSL_CONST_MKS_POUND_FORCE = (4.44822161526e0); /* kg m / s^2 */
public static final double GSL_CONST_MKS_KILOPOUND_FORCE = (4.44822161526e3); /* kg m / s^2 */
public static final double GSL_CONST_MKS_POUNDAL = (1.38255e-1); /* kg m / s^2 */
public static final double GSL_CONST_MKS_CALORIE = (4.1868e0); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_BTU = (1.05505585262e3); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_THERM = (1.05506e8); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_HORSEPOWER = (7.457e2); /* kg m^2 / s^3 */
public static final double GSL_CONST_MKS_BAR = (1e5); /* kg / m s^2 */
public static final double GSL_CONST_MKS_STD_ATMOSPHERE = (1.01325e5); /* kg / m s^2 */
public static final double GSL_CONST_MKS_TORR = (1.33322368421e2); /* kg / m s^2 */
public static final double GSL_CONST_MKS_METER_OF_MERCURY = (1.33322368421e5); /* kg / m s^2 */
public static final double GSL_CONST_MKS_INCH_OF_MERCURY = (3.38638815789e3); /* kg / m s^2 */
public static final double GSL_CONST_MKS_INCH_OF_WATER = (2.490889e2); /* kg / m s^2 */
public static final double GSL_CONST_MKS_PSI = (6.89475729317e3); /* kg / m s^2 */
public static final double GSL_CONST_MKS_POISE = (1e-1); /* kg m^-1 s^-1 */
public static final double GSL_CONST_MKS_STOKES = (1e-4); /* m^2 / s */
public static final double GSL_CONST_MKS_STILB = (1e4); /* cd / m^2 */
public static final double GSL_CONST_MKS_LUMEN = (1e0); /* cd sr */
public static final double GSL_CONST_MKS_LUX = (1e0); /* cd sr / m^2 */
public static final double GSL_CONST_MKS_PHOT = (1e4); /* cd sr / m^2 */
public static final double GSL_CONST_MKS_FOOTCANDLE = (1.076e1); /* cd sr / m^2 */
public static final double GSL_CONST_MKS_LAMBERT = (1e4); /* cd sr / m^2 */
public static final double GSL_CONST_MKS_FOOTLAMBERT = (1.07639104e1); /* cd sr / m^2 */
public static final double GSL_CONST_MKS_CURIE = (3.7e10); /* 1 / s */
public static final double GSL_CONST_MKS_ROENTGEN = (2.58e-4); /* A s / kg */
public static final double GSL_CONST_MKS_RAD = (1e-2); /* m^2 / s^2 */
public static final double GSL_CONST_MKS_SOLAR_MASS = (1.98892e30); /* kg */
public static final double GSL_CONST_MKS_BOHR_RADIUS = (5.291772083e-11); /* m */
public static final double GSL_CONST_MKS_NEWTON = (1e0); /* kg m / s^2 */
public static final double GSL_CONST_MKS_DYNE = (1e-5); /* kg m / s^2 */
public static final double GSL_CONST_MKS_JOULE = (1e0); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_ERG = (1e-7); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKS_STEFAN_BOLTZMANN_CONSTANT = (5.67040047374e-8); /* kg / K^4 s^3 */
public static final double GSL_CONST_MKS_THOMSON_CROSS_SECTION = (6.65245893699e-29); /* m^2 */
public static final double GSL_CONST_MKS_BOHR_MAGNETON = (9.27400899e-24); /* A m^2 */
public static final double GSL_CONST_MKS_NUCLEAR_MAGNETON = (5.05078317e-27); /* A m^2 */
public static final double GSL_CONST_MKS_ELECTRON_MAGNETIC_MOMENT = (9.28476362e-24); /* A m^2 */
public static final double GSL_CONST_MKS_PROTON_MAGNETIC_MOMENT = (1.410606633e-26); /* A m^2 */
public static final double GSL_CONST_MKS_FARADAY = (9.64853429775e4); /* A s / mol */
public static final double GSL_CONST_MKS_ELECTRON_CHARGE = (1.602176487e-19); /* A s */
public static final double GSL_CONST_MKS_VACUUM_PERMITTIVITY = (8.854187817e-12); /* A^2 s^4 / kg m^3 */
public static final double GSL_CONST_MKS_VACUUM_PERMEABILITY = (1.25663706144e-6); /* kg m / A^2 s^2 */
public static final double GSL_CONST_MKS_DEBYE = (3.33564095198e-30); /* A s^2 / m^2 */
public static final double GSL_CONST_MKS_GAUSS = (1e-4); /* kg / A s^2 */

// #endif /* __GSL_CONST_MKS__ */


// Parsed from gsl/gsl_const_cgsm.h

/* const/gsl_const_cgsm.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
 * 2006, 2007, 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST_CGSM__
// #define __GSL_CONST_CGSM__

public static final double GSL_CONST_CGSM_SPEED_OF_LIGHT = (2.99792458e10); /* cm / s */
public static final double GSL_CONST_CGSM_GRAVITATIONAL_CONSTANT = (6.673e-8); /* cm^3 / g s^2 */
public static final double GSL_CONST_CGSM_PLANCKS_CONSTANT_H = (6.62606896e-27); /* g cm^2 / s */
public static final double GSL_CONST_CGSM_PLANCKS_CONSTANT_HBAR = (1.05457162825e-27); /* g cm^2 / s */
public static final double GSL_CONST_CGSM_ASTRONOMICAL_UNIT = (1.49597870691e13); /* cm */
public static final double GSL_CONST_CGSM_LIGHT_YEAR = (9.46053620707e17); /* cm */
public static final double GSL_CONST_CGSM_PARSEC = (3.08567758135e18); /* cm */
public static final double GSL_CONST_CGSM_GRAV_ACCEL = (9.80665e2); /* cm / s^2 */
public static final double GSL_CONST_CGSM_ELECTRON_VOLT = (1.602176487e-12); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_MASS_ELECTRON = (9.10938188e-28); /* g */
public static final double GSL_CONST_CGSM_MASS_MUON = (1.88353109e-25); /* g */
public static final double GSL_CONST_CGSM_MASS_PROTON = (1.67262158e-24); /* g */
public static final double GSL_CONST_CGSM_MASS_NEUTRON = (1.67492716e-24); /* g */
public static final double GSL_CONST_CGSM_RYDBERG = (2.17987196968e-11); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_BOLTZMANN = (1.3806504e-16); /* g cm^2 / K s^2 */
public static final double GSL_CONST_CGSM_MOLAR_GAS = (8.314472e7); /* g cm^2 / K mol s^2 */
public static final double GSL_CONST_CGSM_STANDARD_GAS_VOLUME = (2.2710981e4); /* cm^3 / mol */
public static final double GSL_CONST_CGSM_MINUTE = (6e1); /* s */
public static final double GSL_CONST_CGSM_HOUR = (3.6e3); /* s */
public static final double GSL_CONST_CGSM_DAY = (8.64e4); /* s */
public static final double GSL_CONST_CGSM_WEEK = (6.048e5); /* s */
public static final double GSL_CONST_CGSM_INCH = (2.54e0); /* cm */
public static final double GSL_CONST_CGSM_FOOT = (3.048e1); /* cm */
public static final double GSL_CONST_CGSM_YARD = (9.144e1); /* cm */
public static final double GSL_CONST_CGSM_MILE = (1.609344e5); /* cm */
public static final double GSL_CONST_CGSM_NAUTICAL_MILE = (1.852e5); /* cm */
public static final double GSL_CONST_CGSM_FATHOM = (1.8288e2); /* cm */
public static final double GSL_CONST_CGSM_MIL = (2.54e-3); /* cm */
public static final double GSL_CONST_CGSM_POINT = (3.52777777778e-2); /* cm */
public static final double GSL_CONST_CGSM_TEXPOINT = (3.51459803515e-2); /* cm */
public static final double GSL_CONST_CGSM_MICRON = (1e-4); /* cm */
public static final double GSL_CONST_CGSM_ANGSTROM = (1e-8); /* cm */
public static final double GSL_CONST_CGSM_HECTARE = (1e8); /* cm^2 */
public static final double GSL_CONST_CGSM_ACRE = (4.04685642241e7); /* cm^2 */
public static final double GSL_CONST_CGSM_BARN = (1e-24); /* cm^2 */
public static final double GSL_CONST_CGSM_LITER = (1e3); /* cm^3 */
public static final double GSL_CONST_CGSM_US_GALLON = (3.78541178402e3); /* cm^3 */
public static final double GSL_CONST_CGSM_QUART = (9.46352946004e2); /* cm^3 */
public static final double GSL_CONST_CGSM_PINT = (4.73176473002e2); /* cm^3 */
public static final double GSL_CONST_CGSM_CUP = (2.36588236501e2); /* cm^3 */
public static final double GSL_CONST_CGSM_FLUID_OUNCE = (2.95735295626e1); /* cm^3 */
public static final double GSL_CONST_CGSM_TABLESPOON = (1.47867647813e1); /* cm^3 */
public static final double GSL_CONST_CGSM_TEASPOON = (4.92892159375e0); /* cm^3 */
public static final double GSL_CONST_CGSM_CANADIAN_GALLON = (4.54609e3); /* cm^3 */
public static final double GSL_CONST_CGSM_UK_GALLON = (4.546092e3); /* cm^3 */
public static final double GSL_CONST_CGSM_MILES_PER_HOUR = (4.4704e1); /* cm / s */
public static final double GSL_CONST_CGSM_KILOMETERS_PER_HOUR = (2.77777777778e1); /* cm / s */
public static final double GSL_CONST_CGSM_KNOT = (5.14444444444e1); /* cm / s */
public static final double GSL_CONST_CGSM_POUND_MASS = (4.5359237e2); /* g */
public static final double GSL_CONST_CGSM_OUNCE_MASS = (2.8349523125e1); /* g */
public static final double GSL_CONST_CGSM_TON = (9.0718474e5); /* g */
public static final double GSL_CONST_CGSM_METRIC_TON = (1e6); /* g */
public static final double GSL_CONST_CGSM_UK_TON = (1.0160469088e6); /* g */
public static final double GSL_CONST_CGSM_TROY_OUNCE = (3.1103475e1); /* g */
public static final double GSL_CONST_CGSM_CARAT = (2e-1); /* g */
public static final double GSL_CONST_CGSM_UNIFIED_ATOMIC_MASS = (1.660538782e-24); /* g */
public static final double GSL_CONST_CGSM_GRAM_FORCE = (9.80665e2); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_POUND_FORCE = (4.44822161526e5); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_KILOPOUND_FORCE = (4.44822161526e8); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_POUNDAL = (1.38255e4); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_CALORIE = (4.1868e7); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_BTU = (1.05505585262e10); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_THERM = (1.05506e15); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_HORSEPOWER = (7.457e9); /* g cm^2 / s^3 */
public static final double GSL_CONST_CGSM_BAR = (1e6); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_STD_ATMOSPHERE = (1.01325e6); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_TORR = (1.33322368421e3); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_METER_OF_MERCURY = (1.33322368421e6); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_INCH_OF_MERCURY = (3.38638815789e4); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_INCH_OF_WATER = (2.490889e3); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_PSI = (6.89475729317e4); /* g / cm s^2 */
public static final double GSL_CONST_CGSM_POISE = (1e0); /* g / cm s */
public static final double GSL_CONST_CGSM_STOKES = (1e0); /* cm^2 / s */
public static final double GSL_CONST_CGSM_STILB = (1e0); /* cd / cm^2 */
public static final double GSL_CONST_CGSM_LUMEN = (1e0); /* cd sr */
public static final double GSL_CONST_CGSM_LUX = (1e-4); /* cd sr / cm^2 */
public static final double GSL_CONST_CGSM_PHOT = (1e0); /* cd sr / cm^2 */
public static final double GSL_CONST_CGSM_FOOTCANDLE = (1.076e-3); /* cd sr / cm^2 */
public static final double GSL_CONST_CGSM_LAMBERT = (1e0); /* cd sr / cm^2 */
public static final double GSL_CONST_CGSM_FOOTLAMBERT = (1.07639104e-3); /* cd sr / cm^2 */
public static final double GSL_CONST_CGSM_CURIE = (3.7e10); /* 1 / s */
public static final double GSL_CONST_CGSM_ROENTGEN = (2.58e-8); /* abamp s / g */
public static final double GSL_CONST_CGSM_RAD = (1e2); /* cm^2 / s^2 */
public static final double GSL_CONST_CGSM_SOLAR_MASS = (1.98892e33); /* g */
public static final double GSL_CONST_CGSM_BOHR_RADIUS = (5.291772083e-9); /* cm */
public static final double GSL_CONST_CGSM_NEWTON = (1e5); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_DYNE = (1e0); /* cm g / s^2 */
public static final double GSL_CONST_CGSM_JOULE = (1e7); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_ERG = (1e0); /* g cm^2 / s^2 */
public static final double GSL_CONST_CGSM_STEFAN_BOLTZMANN_CONSTANT = (5.67040047374e-5); /* g / K^4 s^3 */
public static final double GSL_CONST_CGSM_THOMSON_CROSS_SECTION = (6.65245893699e-25); /* cm^2 */
public static final double GSL_CONST_CGSM_BOHR_MAGNETON = (9.27400899e-21); /* abamp cm^2 */
public static final double GSL_CONST_CGSM_NUCLEAR_MAGNETON = (5.05078317e-24); /* abamp cm^2 */
public static final double GSL_CONST_CGSM_ELECTRON_MAGNETIC_MOMENT = (9.28476362e-21); /* abamp cm^2 */
public static final double GSL_CONST_CGSM_PROTON_MAGNETIC_MOMENT = (1.410606633e-23); /* abamp cm^2 */
public static final double GSL_CONST_CGSM_FARADAY = (9.64853429775e3); /* abamp s / mol */
public static final double GSL_CONST_CGSM_ELECTRON_CHARGE = (1.602176487e-20); /* abamp s */

// #endif /* __GSL_CONST_CGSM__ */


// Parsed from gsl/gsl_const_mksa.h

/* const/gsl_const_mksa.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
 * 2006, 2007, 2008, 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_CONST_MKSA__
// #define __GSL_CONST_MKSA__

public static final double GSL_CONST_MKSA_SPEED_OF_LIGHT = (2.99792458e8); /* m / s */
public static final double GSL_CONST_MKSA_GRAVITATIONAL_CONSTANT = (6.673e-11); /* m^3 / kg s^2 */
public static final double GSL_CONST_MKSA_PLANCKS_CONSTANT_H = (6.62606896e-34); /* kg m^2 / s */
public static final double GSL_CONST_MKSA_PLANCKS_CONSTANT_HBAR = (1.05457162825e-34); /* kg m^2 / s */
public static final double GSL_CONST_MKSA_ASTRONOMICAL_UNIT = (1.49597870691e11); /* m */
public static final double GSL_CONST_MKSA_LIGHT_YEAR = (9.46053620707e15); /* m */
public static final double GSL_CONST_MKSA_PARSEC = (3.08567758135e16); /* m */
public static final double GSL_CONST_MKSA_GRAV_ACCEL = (9.80665e0); /* m / s^2 */
public static final double GSL_CONST_MKSA_ELECTRON_VOLT = (1.602176487e-19); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_MASS_ELECTRON = (9.10938188e-31); /* kg */
public static final double GSL_CONST_MKSA_MASS_MUON = (1.88353109e-28); /* kg */
public static final double GSL_CONST_MKSA_MASS_PROTON = (1.67262158e-27); /* kg */
public static final double GSL_CONST_MKSA_MASS_NEUTRON = (1.67492716e-27); /* kg */
public static final double GSL_CONST_MKSA_RYDBERG = (2.17987196968e-18); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_BOLTZMANN = (1.3806504e-23); /* kg m^2 / K s^2 */
public static final double GSL_CONST_MKSA_MOLAR_GAS = (8.314472e0); /* kg m^2 / K mol s^2 */
public static final double GSL_CONST_MKSA_STANDARD_GAS_VOLUME = (2.2710981e-2); /* m^3 / mol */
public static final double GSL_CONST_MKSA_MINUTE = (6e1); /* s */
public static final double GSL_CONST_MKSA_HOUR = (3.6e3); /* s */
public static final double GSL_CONST_MKSA_DAY = (8.64e4); /* s */
public static final double GSL_CONST_MKSA_WEEK = (6.048e5); /* s */
public static final double GSL_CONST_MKSA_INCH = (2.54e-2); /* m */
public static final double GSL_CONST_MKSA_FOOT = (3.048e-1); /* m */
public static final double GSL_CONST_MKSA_YARD = (9.144e-1); /* m */
public static final double GSL_CONST_MKSA_MILE = (1.609344e3); /* m */
public static final double GSL_CONST_MKSA_NAUTICAL_MILE = (1.852e3); /* m */
public static final double GSL_CONST_MKSA_FATHOM = (1.8288e0); /* m */
public static final double GSL_CONST_MKSA_MIL = (2.54e-5); /* m */
public static final double GSL_CONST_MKSA_POINT = (3.52777777778e-4); /* m */
public static final double GSL_CONST_MKSA_TEXPOINT = (3.51459803515e-4); /* m */
public static final double GSL_CONST_MKSA_MICRON = (1e-6); /* m */
public static final double GSL_CONST_MKSA_ANGSTROM = (1e-10); /* m */
public static final double GSL_CONST_MKSA_HECTARE = (1e4); /* m^2 */
public static final double GSL_CONST_MKSA_ACRE = (4.04685642241e3); /* m^2 */
public static final double GSL_CONST_MKSA_BARN = (1e-28); /* m^2 */
public static final double GSL_CONST_MKSA_LITER = (1e-3); /* m^3 */
public static final double GSL_CONST_MKSA_US_GALLON = (3.78541178402e-3); /* m^3 */
public static final double GSL_CONST_MKSA_QUART = (9.46352946004e-4); /* m^3 */
public static final double GSL_CONST_MKSA_PINT = (4.73176473002e-4); /* m^3 */
public static final double GSL_CONST_MKSA_CUP = (2.36588236501e-4); /* m^3 */
public static final double GSL_CONST_MKSA_FLUID_OUNCE = (2.95735295626e-5); /* m^3 */
public static final double GSL_CONST_MKSA_TABLESPOON = (1.47867647813e-5); /* m^3 */
public static final double GSL_CONST_MKSA_TEASPOON = (4.92892159375e-6); /* m^3 */
public static final double GSL_CONST_MKSA_CANADIAN_GALLON = (4.54609e-3); /* m^3 */
public static final double GSL_CONST_MKSA_UK_GALLON = (4.546092e-3); /* m^3 */
public static final double GSL_CONST_MKSA_MILES_PER_HOUR = (4.4704e-1); /* m / s */
public static final double GSL_CONST_MKSA_KILOMETERS_PER_HOUR = (2.77777777778e-1); /* m / s */
public static final double GSL_CONST_MKSA_KNOT = (5.14444444444e-1); /* m / s */
public static final double GSL_CONST_MKSA_POUND_MASS = (4.5359237e-1); /* kg */
public static final double GSL_CONST_MKSA_OUNCE_MASS = (2.8349523125e-2); /* kg */
public static final double GSL_CONST_MKSA_TON = (9.0718474e2); /* kg */
public static final double GSL_CONST_MKSA_METRIC_TON = (1e3); /* kg */
public static final double GSL_CONST_MKSA_UK_TON = (1.0160469088e3); /* kg */
public static final double GSL_CONST_MKSA_TROY_OUNCE = (3.1103475e-2); /* kg */
public static final double GSL_CONST_MKSA_CARAT = (2e-4); /* kg */
public static final double GSL_CONST_MKSA_UNIFIED_ATOMIC_MASS = (1.660538782e-27); /* kg */
public static final double GSL_CONST_MKSA_GRAM_FORCE = (9.80665e-3); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_POUND_FORCE = (4.44822161526e0); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_KILOPOUND_FORCE = (4.44822161526e3); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_POUNDAL = (1.38255e-1); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_CALORIE = (4.1868e0); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_BTU = (1.05505585262e3); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_THERM = (1.05506e8); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_HORSEPOWER = (7.457e2); /* kg m^2 / s^3 */
public static final double GSL_CONST_MKSA_BAR = (1e5); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_STD_ATMOSPHERE = (1.01325e5); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_TORR = (1.33322368421e2); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_METER_OF_MERCURY = (1.33322368421e5); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_INCH_OF_MERCURY = (3.38638815789e3); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_INCH_OF_WATER = (2.490889e2); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_PSI = (6.89475729317e3); /* kg / m s^2 */
public static final double GSL_CONST_MKSA_POISE = (1e-1); /* kg m^-1 s^-1 */
public static final double GSL_CONST_MKSA_STOKES = (1e-4); /* m^2 / s */
public static final double GSL_CONST_MKSA_STILB = (1e4); /* cd / m^2 */
public static final double GSL_CONST_MKSA_LUMEN = (1e0); /* cd sr */
public static final double GSL_CONST_MKSA_LUX = (1e0); /* cd sr / m^2 */
public static final double GSL_CONST_MKSA_PHOT = (1e4); /* cd sr / m^2 */
public static final double GSL_CONST_MKSA_FOOTCANDLE = (1.076e1); /* cd sr / m^2 */
public static final double GSL_CONST_MKSA_LAMBERT = (1e4); /* cd sr / m^2 */
public static final double GSL_CONST_MKSA_FOOTLAMBERT = (1.07639104e1); /* cd sr / m^2 */
public static final double GSL_CONST_MKSA_CURIE = (3.7e10); /* 1 / s */
public static final double GSL_CONST_MKSA_ROENTGEN = (2.58e-4); /* A s / kg */
public static final double GSL_CONST_MKSA_RAD = (1e-2); /* m^2 / s^2 */
public static final double GSL_CONST_MKSA_SOLAR_MASS = (1.98892e30); /* kg */
public static final double GSL_CONST_MKSA_BOHR_RADIUS = (5.291772083e-11); /* m */
public static final double GSL_CONST_MKSA_NEWTON = (1e0); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_DYNE = (1e-5); /* kg m / s^2 */
public static final double GSL_CONST_MKSA_JOULE = (1e0); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_ERG = (1e-7); /* kg m^2 / s^2 */
public static final double GSL_CONST_MKSA_STEFAN_BOLTZMANN_CONSTANT = (5.67040047374e-8); /* kg / K^4 s^3 */
public static final double GSL_CONST_MKSA_THOMSON_CROSS_SECTION = (6.65245893699e-29); /* m^2 */
public static final double GSL_CONST_MKSA_BOHR_MAGNETON = (9.27400899e-24); /* A m^2 */
public static final double GSL_CONST_MKSA_NUCLEAR_MAGNETON = (5.05078317e-27); /* A m^2 */
public static final double GSL_CONST_MKSA_ELECTRON_MAGNETIC_MOMENT = (9.28476362e-24); /* A m^2 */
public static final double GSL_CONST_MKSA_PROTON_MAGNETIC_MOMENT = (1.410606633e-26); /* A m^2 */
public static final double GSL_CONST_MKSA_FARADAY = (9.64853429775e4); /* A s / mol */
public static final double GSL_CONST_MKSA_ELECTRON_CHARGE = (1.602176487e-19); /* A s */
public static final double GSL_CONST_MKSA_VACUUM_PERMITTIVITY = (8.854187817e-12); /* A^2 s^4 / kg m^3 */
public static final double GSL_CONST_MKSA_VACUUM_PERMEABILITY = (1.25663706144e-6); /* kg m / A^2 s^2 */
public static final double GSL_CONST_MKSA_DEBYE = (3.33564095198e-30); /* A s^2 / m^2 */
public static final double GSL_CONST_MKSA_GAUSS = (1e-4); /* kg / A s^2 */

// #endif /* __GSL_CONST_MKSA__ */


// Parsed from gsl/gsl_fft.h

/* fft/gsl_fft.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_H__
// #define __GSL_FFT_H__

// #include <gsl/gsl_complex.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/** enum gsl_fft_direction */
public static final int
    gsl_fft_forward = -1, gsl_fft_backward = 1;

/* this gives the sign in the formula

   h(f) = \sum x(t) exp(+/- 2 pi i f t) 
       
   where - is the forward transform direction and + the inverse direction */

// #endif /* __GSL_FFT_H__ */


// Parsed from gsl/gsl_fft_complex_float.h

/* fft/gsl_fft_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_COMPLEX_FLOAT_H__
// #define __GSL_FFT_COMPLEX_FLOAT_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/*  Power of 2 routines  */


public static native int gsl_fft_complex_float_radix2_forward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_forward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_forward(@Cast("gsl_complex_packed_array_float") float[] data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_backward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                           @Cast("const size_t") long stride,
                                           @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_backward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                           @Cast("const size_t") long stride,
                                           @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_backward(@Cast("gsl_complex_packed_array_float") float[] data,
                                           @Cast("const size_t") long stride,
                                           @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_inverse(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_inverse(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_inverse(@Cast("gsl_complex_packed_array_float") float[] data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_transform(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                            @Cast("const size_t") long stride,
                                            @Cast("const size_t") long n,
                                            @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_radix2_transform(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                            @Cast("const size_t") long stride,
                                            @Cast("const size_t") long n,
                                            @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_radix2_transform(@Cast("gsl_complex_packed_array_float") float[] data,
                                            @Cast("const size_t") long stride,
                                            @Cast("const size_t") long n,
                                            @Cast("const gsl_fft_direction") int sign);

public static native int gsl_fft_complex_float_radix2_dif_forward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_forward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_forward(@Cast("gsl_complex_packed_array_float") float[] data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_dif_backward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                               @Cast("const size_t") long stride,
                                               @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_backward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                               @Cast("const size_t") long stride,
                                               @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_backward(@Cast("gsl_complex_packed_array_float") float[] data,
                                               @Cast("const size_t") long stride,
                                               @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_dif_inverse(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_inverse(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);
public static native int gsl_fft_complex_float_radix2_dif_inverse(@Cast("gsl_complex_packed_array_float") float[] data,
                                              @Cast("const size_t") long stride,
                                              @Cast("const size_t") long n);

public static native int gsl_fft_complex_float_radix2_dif_transform(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                                @Cast("const size_t") long stride,
                                                @Cast("const size_t") long n,
                                                @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_radix2_dif_transform(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                                @Cast("const size_t") long stride,
                                                @Cast("const size_t") long n,
                                                @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_radix2_dif_transform(@Cast("gsl_complex_packed_array_float") float[] data,
                                                @Cast("const size_t") long stride,
                                                @Cast("const size_t") long n,
                                                @Cast("const gsl_fft_direction") int sign);
// Targeting ../gsl_fft_complex_wavetable_float.java


// Targeting ../gsl_fft_complex_workspace_float.java




public static native gsl_fft_complex_wavetable_float gsl_fft_complex_wavetable_float_alloc(@Cast("size_t") long n);

public static native void gsl_fft_complex_wavetable_float_free(gsl_fft_complex_wavetable_float wavetable);

public static native gsl_fft_complex_workspace_float gsl_fft_complex_workspace_float_alloc(@Cast("size_t") long n);

public static native void gsl_fft_complex_workspace_float_free(gsl_fft_complex_workspace_float workspace);


public static native int gsl_fft_complex_float_memcpy(gsl_fft_complex_wavetable_float dest,
                               gsl_fft_complex_wavetable_float src);


public static native int gsl_fft_complex_float_forward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_forward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_forward(@Cast("gsl_complex_packed_array_float") float[] data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);

public static native int gsl_fft_complex_float_backward(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n,
                                    @Const gsl_fft_complex_wavetable_float wavetable,
                                    gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_backward(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n,
                                    @Const gsl_fft_complex_wavetable_float wavetable,
                                    gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_backward(@Cast("gsl_complex_packed_array_float") float[] data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n,
                                    @Const gsl_fft_complex_wavetable_float wavetable,
                                    gsl_fft_complex_workspace_float work);

public static native int gsl_fft_complex_float_inverse(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_inverse(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);
public static native int gsl_fft_complex_float_inverse(@Cast("gsl_complex_packed_array_float") float[] data,
                                   @Cast("const size_t") long stride,
                                   @Cast("const size_t") long n,
                                   @Const gsl_fft_complex_wavetable_float wavetable,
                                   gsl_fft_complex_workspace_float work);

public static native int gsl_fft_complex_float_transform(@Cast("gsl_complex_packed_array_float") FloatPointer data,
                                     @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                     @Const gsl_fft_complex_wavetable_float wavetable,
                                     gsl_fft_complex_workspace_float work,
                                     @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_transform(@Cast("gsl_complex_packed_array_float") FloatBuffer data,
                                     @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                     @Const gsl_fft_complex_wavetable_float wavetable,
                                     gsl_fft_complex_workspace_float work,
                                     @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_float_transform(@Cast("gsl_complex_packed_array_float") float[] data,
                                     @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                     @Const gsl_fft_complex_wavetable_float wavetable,
                                     gsl_fft_complex_workspace_float work,
                                     @Cast("const gsl_fft_direction") int sign);

// #endif /* __GSL_FFT_COMPLEX_FLOAT_H__ */




// Parsed from gsl/gsl_fft_complex.h

/* fft/gsl_fft_complex.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_COMPLEX_H__
// #define __GSL_FFT_COMPLEX_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/*  Power of 2 routines  */


public static native int gsl_fft_complex_radix2_forward(@Cast("gsl_complex_packed_array") DoublePointer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_forward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_forward(@Cast("gsl_complex_packed_array") double[] data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_backward(@Cast("gsl_complex_packed_array") DoublePointer data,
                                     @Cast("const size_t") long stride,
                                     @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_backward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                     @Cast("const size_t") long stride,
                                     @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_backward(@Cast("gsl_complex_packed_array") double[] data,
                                     @Cast("const size_t") long stride,
                                     @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_inverse(@Cast("gsl_complex_packed_array") DoublePointer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_inverse(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_inverse(@Cast("gsl_complex_packed_array") double[] data,
                                    @Cast("const size_t") long stride,
                                    @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_transform(@Cast("gsl_complex_packed_array") DoublePointer data,
                                      @Cast("const size_t") long stride,
                                      @Cast("const size_t") long n,
                                      @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_radix2_transform(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                      @Cast("const size_t") long stride,
                                      @Cast("const size_t") long n,
                                      @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_radix2_transform(@Cast("gsl_complex_packed_array") double[] data,
                                      @Cast("const size_t") long stride,
                                      @Cast("const size_t") long n,
                                      @Cast("const gsl_fft_direction") int sign);

public static native int gsl_fft_complex_radix2_dif_forward(@Cast("gsl_complex_packed_array") DoublePointer data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_forward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_forward(@Cast("gsl_complex_packed_array") double[] data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_dif_backward(@Cast("gsl_complex_packed_array") DoublePointer data,
                                         @Cast("const size_t") long stride,
                                         @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_backward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                         @Cast("const size_t") long stride,
                                         @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_backward(@Cast("gsl_complex_packed_array") double[] data,
                                         @Cast("const size_t") long stride,
                                         @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_dif_inverse(@Cast("gsl_complex_packed_array") DoublePointer data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_inverse(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);
public static native int gsl_fft_complex_radix2_dif_inverse(@Cast("gsl_complex_packed_array") double[] data,
                                        @Cast("const size_t") long stride,
                                        @Cast("const size_t") long n);

public static native int gsl_fft_complex_radix2_dif_transform(@Cast("gsl_complex_packed_array") DoublePointer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n,
                                          @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_radix2_dif_transform(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n,
                                          @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_radix2_dif_transform(@Cast("gsl_complex_packed_array") double[] data,
                                          @Cast("const size_t") long stride,
                                          @Cast("const size_t") long n,
                                          @Cast("const gsl_fft_direction") int sign);
// Targeting ../gsl_fft_complex_wavetable.java


// Targeting ../gsl_fft_complex_workspace.java




public static native gsl_fft_complex_wavetable gsl_fft_complex_wavetable_alloc(@Cast("size_t") long n);

public static native void gsl_fft_complex_wavetable_free(gsl_fft_complex_wavetable wavetable);

public static native gsl_fft_complex_workspace gsl_fft_complex_workspace_alloc(@Cast("size_t") long n);

public static native void gsl_fft_complex_workspace_free(gsl_fft_complex_workspace workspace);

public static native int gsl_fft_complex_memcpy(gsl_fft_complex_wavetable dest,
                            gsl_fft_complex_wavetable src);


public static native int gsl_fft_complex_forward(@Cast("gsl_complex_packed_array") DoublePointer data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_forward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_forward(@Cast("gsl_complex_packed_array") double[] data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);

public static native int gsl_fft_complex_backward(@Cast("gsl_complex_packed_array") DoublePointer data,
                              @Cast("const size_t") long stride,
                              @Cast("const size_t") long n,
                              @Const gsl_fft_complex_wavetable wavetable,
                              gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_backward(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                              @Cast("const size_t") long stride,
                              @Cast("const size_t") long n,
                              @Const gsl_fft_complex_wavetable wavetable,
                              gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_backward(@Cast("gsl_complex_packed_array") double[] data,
                              @Cast("const size_t") long stride,
                              @Cast("const size_t") long n,
                              @Const gsl_fft_complex_wavetable wavetable,
                              gsl_fft_complex_workspace work);

public static native int gsl_fft_complex_inverse(@Cast("gsl_complex_packed_array") DoublePointer data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_inverse(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);
public static native int gsl_fft_complex_inverse(@Cast("gsl_complex_packed_array") double[] data,
                             @Cast("const size_t") long stride,
                             @Cast("const size_t") long n,
                             @Const gsl_fft_complex_wavetable wavetable,
                             gsl_fft_complex_workspace work);

public static native int gsl_fft_complex_transform(@Cast("gsl_complex_packed_array") DoublePointer data,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n,
                               @Const gsl_fft_complex_wavetable wavetable,
                               gsl_fft_complex_workspace work,
                               @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_transform(@Cast("gsl_complex_packed_array") DoubleBuffer data,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n,
                               @Const gsl_fft_complex_wavetable wavetable,
                               gsl_fft_complex_workspace work,
                               @Cast("const gsl_fft_direction") int sign);
public static native int gsl_fft_complex_transform(@Cast("gsl_complex_packed_array") double[] data,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n,
                               @Const gsl_fft_complex_wavetable wavetable,
                               gsl_fft_complex_workspace work,
                               @Cast("const gsl_fft_direction") int sign);

// #endif /* __GSL_FFT_COMPLEX_H__ */


// Parsed from gsl/gsl_fft_halfcomplex_float.h

/* fft/gsl_fft_halfcomplex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_HALFCOMPLEX_FLOAT_H__
// #define __GSL_FFT_HALFCOMPLEX_FLOAT_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>
// #include <gsl/gsl_fft_real_float.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_fft_halfcomplex_float_radix2_backward(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_backward(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_backward(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_inverse(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_inverse(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_inverse(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_transform(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_transform(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_transform(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
// Targeting ../gsl_fft_halfcomplex_wavetable_float.java




public static native gsl_fft_halfcomplex_wavetable_float gsl_fft_halfcomplex_wavetable_float_alloc(@Cast("size_t") long n);

public static native void gsl_fft_halfcomplex_wavetable_float_free(gsl_fft_halfcomplex_wavetable_float wavetable);

public static native int gsl_fft_halfcomplex_float_backward(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                        @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                        gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_backward(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                        @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                        gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_backward(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                        @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                        gsl_fft_real_workspace_float work);

public static native int gsl_fft_halfcomplex_float_inverse(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                       @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                       gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_inverse(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                       @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                       gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_inverse(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                       @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                       gsl_fft_real_workspace_float work);

public static native int gsl_fft_halfcomplex_float_transform(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                         @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                         gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_transform(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                         @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                         gsl_fft_real_workspace_float work);
public static native int gsl_fft_halfcomplex_float_transform(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                         @Const gsl_fft_halfcomplex_wavetable_float wavetable,
                                         gsl_fft_real_workspace_float work);

public static native int gsl_fft_halfcomplex_float_unpack(@Const FloatPointer halfcomplex_coefficient,
                                  FloatPointer complex_coefficient,
                                  @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_unpack(@Const FloatBuffer halfcomplex_coefficient,
                                  FloatBuffer complex_coefficient,
                                  @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_unpack(@Const float[] halfcomplex_coefficient,
                                  float[] complex_coefficient,
                                  @Cast("const size_t") long stride, @Cast("const size_t") long n);

public static native int gsl_fft_halfcomplex_float_radix2_unpack(@Const FloatPointer halfcomplex_coefficient,
                                         FloatPointer complex_coefficient,
                                         @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_unpack(@Const FloatBuffer halfcomplex_coefficient,
                                         FloatBuffer complex_coefficient,
                                         @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_float_radix2_unpack(@Const float[] halfcomplex_coefficient,
                                         float[] complex_coefficient,
                                         @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_FFT_HALFCOMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_fft_halfcomplex.h

/* fft/gsl_fft_halfcomplex.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_HALFCOMPLEX_H__
// #define __GSL_FFT_HALFCOMPLEX_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>
// #include <gsl/gsl_fft_real.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_fft_halfcomplex_radix2_backward(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_backward(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_backward(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_inverse(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_inverse(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_inverse(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_transform(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_transform(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_transform(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
// Targeting ../gsl_fft_halfcomplex_wavetable.java



public static native gsl_fft_halfcomplex_wavetable gsl_fft_halfcomplex_wavetable_alloc(@Cast("size_t") long n);

public static native void gsl_fft_halfcomplex_wavetable_free(gsl_fft_halfcomplex_wavetable wavetable);


public static native int gsl_fft_halfcomplex_backward(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_halfcomplex_wavetable wavetable,
                                  gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_backward(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_halfcomplex_wavetable wavetable,
                                  gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_backward(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_halfcomplex_wavetable wavetable,
                                  gsl_fft_real_workspace work);

public static native int gsl_fft_halfcomplex_inverse(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                 @Const gsl_fft_halfcomplex_wavetable wavetable,
                                 gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_inverse(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                 @Const gsl_fft_halfcomplex_wavetable wavetable,
                                 gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_inverse(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                 @Const gsl_fft_halfcomplex_wavetable wavetable,
                                 gsl_fft_real_workspace work);

public static native int gsl_fft_halfcomplex_transform(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                   @Const gsl_fft_halfcomplex_wavetable wavetable,
                                   gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_transform(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                   @Const gsl_fft_halfcomplex_wavetable wavetable,
                                   gsl_fft_real_workspace work);
public static native int gsl_fft_halfcomplex_transform(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                   @Const gsl_fft_halfcomplex_wavetable wavetable,
                                   gsl_fft_real_workspace work);

public static native int gsl_fft_halfcomplex_unpack(@Const DoublePointer halfcomplex_coefficient,
                            DoublePointer complex_coefficient,
                            @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_unpack(@Const DoubleBuffer halfcomplex_coefficient,
                            DoubleBuffer complex_coefficient,
                            @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_unpack(@Const double[] halfcomplex_coefficient,
                            double[] complex_coefficient,
                            @Cast("const size_t") long stride, @Cast("const size_t") long n);

public static native int gsl_fft_halfcomplex_radix2_unpack(@Const DoublePointer halfcomplex_coefficient,
                                   DoublePointer complex_coefficient,
                                   @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_unpack(@Const DoubleBuffer halfcomplex_coefficient,
                                   DoubleBuffer complex_coefficient,
                                   @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_halfcomplex_radix2_unpack(@Const double[] halfcomplex_coefficient,
                                   double[] complex_coefficient,
                                   @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_FFT_HALFCOMPLEX_H__ */


// Parsed from gsl/gsl_fft_real_float.h

/* fft/gsl_fft_real_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_REAL_FLOAT_H__
// #define __GSL_FFT_REAL_FLOAT_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_fft_real_float_radix2_transform(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_float_radix2_transform(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_float_radix2_transform(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
// Targeting ../gsl_fft_real_wavetable_float.java


// Targeting ../gsl_fft_real_workspace_float.java



public static native gsl_fft_real_wavetable_float gsl_fft_real_wavetable_float_alloc(@Cast("size_t") long n);

public static native void gsl_fft_real_wavetable_float_free(gsl_fft_real_wavetable_float wavetable);

public static native gsl_fft_real_workspace_float gsl_fft_real_workspace_float_alloc(@Cast("size_t") long n);

public static native void gsl_fft_real_workspace_float_free(gsl_fft_real_workspace_float workspace);

public static native int gsl_fft_real_float_transform(FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_real_wavetable_float wavetable,
                                  gsl_fft_real_workspace_float work);
public static native int gsl_fft_real_float_transform(FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_real_wavetable_float wavetable,
                                  gsl_fft_real_workspace_float work);
public static native int gsl_fft_real_float_transform(float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                                  @Const gsl_fft_real_wavetable_float wavetable,
                                  gsl_fft_real_workspace_float work);


public static native int gsl_fft_real_float_unpack(@Const FloatPointer real_float_coefficient,
                               FloatPointer complex_coefficient,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_float_unpack(@Const FloatBuffer real_float_coefficient,
                               FloatBuffer complex_coefficient,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_float_unpack(@Const float[] real_float_coefficient,
                               float[] complex_coefficient,
                               @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_FFT_REAL_FLOAT_H__ */


// Parsed from gsl/gsl_fft_real.h

/* fft/gsl_fft_real.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_FFT_REAL_H__
// #define __GSL_FFT_REAL_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_fft_real_radix2_transform(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_radix2_transform(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_radix2_transform(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
// Targeting ../gsl_fft_real_wavetable.java


// Targeting ../gsl_fft_real_workspace.java



public static native gsl_fft_real_wavetable gsl_fft_real_wavetable_alloc(@Cast("size_t") long n);

public static native void gsl_fft_real_wavetable_free(gsl_fft_real_wavetable wavetable);

public static native gsl_fft_real_workspace gsl_fft_real_workspace_alloc(@Cast("size_t") long n);

public static native void gsl_fft_real_workspace_free(gsl_fft_real_workspace workspace);


public static native int gsl_fft_real_transform(DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                            @Const gsl_fft_real_wavetable wavetable,
                            gsl_fft_real_workspace work);
public static native int gsl_fft_real_transform(DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                            @Const gsl_fft_real_wavetable wavetable,
                            gsl_fft_real_workspace work);
public static native int gsl_fft_real_transform(double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                            @Const gsl_fft_real_wavetable wavetable,
                            gsl_fft_real_workspace work);


public static native int gsl_fft_real_unpack(@Const DoublePointer real_coefficient,
                         DoublePointer complex_coefficient,
                         @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_unpack(@Const DoubleBuffer real_coefficient,
                         DoubleBuffer complex_coefficient,
                         @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_fft_real_unpack(@Const double[] real_coefficient,
                         double[] complex_coefficient,
                         @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_FFT_REAL_H__ */


// Parsed from gsl/gsl_dft_complex_float.h

/* fft/gsl_dft_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_DFT_COMPLEX_FLOAT_H__
// #define __GSL_DFT_COMPLEX_FLOAT_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_dft_complex_float_forward(@Const FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             FloatPointer result);
public static native int gsl_dft_complex_float_forward(@Const FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             FloatBuffer result);
public static native int gsl_dft_complex_float_forward(@Const float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             float[] result);

public static native int gsl_dft_complex_float_backward(@Const FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              FloatPointer result);
public static native int gsl_dft_complex_float_backward(@Const FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              FloatBuffer result);
public static native int gsl_dft_complex_float_backward(@Const float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              float[] result);

public static native int gsl_dft_complex_float_inverse(@Const FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             FloatPointer result);
public static native int gsl_dft_complex_float_inverse(@Const FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             FloatBuffer result);
public static native int gsl_dft_complex_float_inverse(@Const float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             float[] result);

public static native int gsl_dft_complex_float_transform(@Const FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     FloatPointer result, @Cast("const gsl_fft_direction") int sign);
public static native int gsl_dft_complex_float_transform(@Const FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     FloatBuffer result, @Cast("const gsl_fft_direction") int sign);
public static native int gsl_dft_complex_float_transform(@Const float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     float[] result, @Cast("const gsl_fft_direction") int sign);

// #endif /* __GSL_DFT_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_dft_complex.h

/* fft/gsl_dft_complex.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_DFT_COMPLEX_H__
// #define __GSL_DFT_COMPLEX_H__

// #include <stddef.h>

// #include <gsl/gsl_math.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_fft.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_dft_complex_forward(@Const DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             DoublePointer result);
public static native int gsl_dft_complex_forward(@Const DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             DoubleBuffer result);
public static native int gsl_dft_complex_forward(@Const double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             double[] result);

public static native int gsl_dft_complex_backward(@Const DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              DoublePointer result);
public static native int gsl_dft_complex_backward(@Const DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              DoubleBuffer result);
public static native int gsl_dft_complex_backward(@Const double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                              double[] result);

public static native int gsl_dft_complex_inverse(@Const DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             DoublePointer result);
public static native int gsl_dft_complex_inverse(@Const DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             DoubleBuffer result);
public static native int gsl_dft_complex_inverse(@Const double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                             double[] result);

public static native int gsl_dft_complex_transform(@Const DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     DoublePointer result, @Cast("const gsl_fft_direction") int sign);
public static native int gsl_dft_complex_transform(@Const DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     DoubleBuffer result, @Cast("const gsl_fft_direction") int sign);
public static native int gsl_dft_complex_transform(@Const double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n,
                     double[] result, @Cast("const gsl_fft_direction") int sign);

// #endif /* __GSL_DFT_COMPLEX_H__ */


// Parsed from gsl/gsl_monte.h

/* monte/gsl_monte.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Michael Booth
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Some things common to all the Monte-Carlo implementations */
/* Author: MJB */

// #ifndef __GSL_MONTE_H__
// #define __GSL_MONTE_H__

// #include <stdlib.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_monte_function.java



// #define GSL_MONTE_FN_EVAL(F,x) (*((F)->f))(x,(F)->dim,(F)->params)

// #endif /* __GSL_MONTE_H__ */


// Parsed from gsl/gsl_monte_plain.h

/* monte/gsl_monte_plain.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Michael Booth
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Plain Monte-Carlo. */

/* Author: MJB */

// #ifndef __GSL_MONTE_PLAIN_H__
// #define __GSL_MONTE_PLAIN_H__

// #include <stdio.h>
// #include <gsl/gsl_monte.h>
// #include <gsl/gsl_rng.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_monte_plain_state.java



public static native int gsl_monte_plain_integrate(@Const gsl_monte_function f,
                           @Const DoublePointer xl, @Const DoublePointer xu,
                           @Cast("const size_t") long dim,
                           @Cast("const size_t") long calls, 
                           gsl_rng r,
                           gsl_monte_plain_state state,
                           DoublePointer result, DoublePointer abserr);
public static native int gsl_monte_plain_integrate(@Const gsl_monte_function f,
                           @Const DoubleBuffer xl, @Const DoubleBuffer xu,
                           @Cast("const size_t") long dim,
                           @Cast("const size_t") long calls, 
                           gsl_rng r,
                           gsl_monte_plain_state state,
                           DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_monte_plain_integrate(@Const gsl_monte_function f,
                           @Const double[] xl, @Const double[] xu,
                           @Cast("const size_t") long dim,
                           @Cast("const size_t") long calls, 
                           gsl_rng r,
                           gsl_monte_plain_state state,
                           double[] result, double[] abserr);

public static native gsl_monte_plain_state gsl_monte_plain_alloc(@Cast("size_t") long dim);

public static native int gsl_monte_plain_init(gsl_monte_plain_state state);

public static native void gsl_monte_plain_free(gsl_monte_plain_state state);

// #endif /* __GSL_MONTE_PLAIN_H__ */


// Parsed from gsl/gsl_monte_miser.h

/* monte/gsl_monte_miser.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Michael Booth
 * Copyright (C) 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author: MJB */

// #ifndef __GSL_MONTE_MISER_H__
// #define __GSL_MONTE_MISER_H__

// #include <gsl/gsl_rng.h>
// #include <gsl/gsl_monte.h>
// #include <gsl/gsl_monte_plain.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_monte_miser_state.java

 

public static native int gsl_monte_miser_integrate(gsl_monte_function f, 
                              @Const DoublePointer xl, @Const DoublePointer xh, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls, 
                              gsl_rng r, 
                              gsl_monte_miser_state state,
                              DoublePointer result, DoublePointer abserr);
public static native int gsl_monte_miser_integrate(gsl_monte_function f, 
                              @Const DoubleBuffer xl, @Const DoubleBuffer xh, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls, 
                              gsl_rng r, 
                              gsl_monte_miser_state state,
                              DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_monte_miser_integrate(gsl_monte_function f, 
                              @Const double[] xl, @Const double[] xh, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls, 
                              gsl_rng r, 
                              gsl_monte_miser_state state,
                              double[] result, double[] abserr);

public static native gsl_monte_miser_state gsl_monte_miser_alloc(@Cast("size_t") long dim);

public static native int gsl_monte_miser_init(gsl_monte_miser_state state);

public static native void gsl_monte_miser_free(gsl_monte_miser_state state);
// Targeting ../gsl_monte_miser_params.java



public static native void gsl_monte_miser_params_get(@Const gsl_monte_miser_state state,
				 gsl_monte_miser_params params);

public static native void gsl_monte_miser_params_set(gsl_monte_miser_state state,
				 @Const gsl_monte_miser_params params);

// #endif /* __GSL_MONTE_MISER_H__ */


// Parsed from gsl/gsl_monte_vegas.h

/* monte/gsl_monte_vegas.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Michael Booth
 * Copyright (C) 2009 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* header for the gsl "vegas" routines.  Mike Booth, May 1998 */

// #ifndef __GSL_MONTE_VEGAS_H__
// #define __GSL_MONTE_VEGAS_H__

// #include <stdlib.h>
// #include <gsl/gsl_rng.h>
// #include <gsl/gsl_monte.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

/** enum  */
public static final int GSL_VEGAS_MODE_IMPORTANCE = 1, 
      GSL_VEGAS_MODE_IMPORTANCE_ONLY = 0, 
      GSL_VEGAS_MODE_STRATIFIED = -1;
// Targeting ../gsl_monte_vegas_state.java



public static native int gsl_monte_vegas_integrate(gsl_monte_function f, 
                              DoublePointer xl, DoublePointer xu, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls,
                              gsl_rng r,
                              gsl_monte_vegas_state state,
                              DoublePointer result, DoublePointer abserr);
public static native int gsl_monte_vegas_integrate(gsl_monte_function f, 
                              DoubleBuffer xl, DoubleBuffer xu, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls,
                              gsl_rng r,
                              gsl_monte_vegas_state state,
                              DoubleBuffer result, DoubleBuffer abserr);
public static native int gsl_monte_vegas_integrate(gsl_monte_function f, 
                              double[] xl, double[] xu, 
                              @Cast("size_t") long dim, @Cast("size_t") long calls,
                              gsl_rng r,
                              gsl_monte_vegas_state state,
                              double[] result, double[] abserr);

public static native gsl_monte_vegas_state gsl_monte_vegas_alloc(@Cast("size_t") long dim);

public static native int gsl_monte_vegas_init(gsl_monte_vegas_state state);

public static native void gsl_monte_vegas_free(gsl_monte_vegas_state state);

public static native double gsl_monte_vegas_chisq(@Const gsl_monte_vegas_state state);
public static native void gsl_monte_vegas_runval(@Const gsl_monte_vegas_state state, DoublePointer result, DoublePointer sigma);
public static native void gsl_monte_vegas_runval(@Const gsl_monte_vegas_state state, DoubleBuffer result, DoubleBuffer sigma);
public static native void gsl_monte_vegas_runval(@Const gsl_monte_vegas_state state, double[] result, double[] sigma);
// Targeting ../gsl_monte_vegas_params.java



public static native void gsl_monte_vegas_params_get(@Const gsl_monte_vegas_state state,
				 gsl_monte_vegas_params params);

public static native void gsl_monte_vegas_params_set(gsl_monte_vegas_state state,
				 @Const gsl_monte_vegas_params params);

// #endif /* __GSL_MONTE_VEGAS_H__ */



// Parsed from gsl/gsl_multifit.h

/* multifit/gsl_multifit.h
 * 
 * Copyright (C) 2000, 2007, 2010 Brian Gough
 * Copyright (C) 2013, Patrick Alken
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MULTIFIT_H__
// #define __GSL_MULTIFIT_H__

// #include <stdlib.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_multifit_linear_workspace.java



public static native gsl_multifit_linear_workspace gsl_multifit_linear_alloc(@Cast("const size_t") long n, @Cast("const size_t") long p);

public static native void gsl_multifit_linear_free(gsl_multifit_linear_workspace w);

public static native int gsl_multifit_linear(@Const gsl_matrix X,
                     @Const gsl_vector y,
                     gsl_vector c,
                     gsl_matrix cov,
                     DoublePointer chisq,
                     gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear(@Const gsl_matrix X,
                     @Const gsl_vector y,
                     gsl_vector c,
                     gsl_matrix cov,
                     DoubleBuffer chisq,
                     gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear(@Const gsl_matrix X,
                     @Const gsl_vector y,
                     gsl_vector c,
                     gsl_matrix cov,
                     double[] chisq,
                     gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_tsvd(@Const gsl_matrix X,
                          @Const gsl_vector y,
                          double tol,
                          gsl_vector c,
                          gsl_matrix cov,
                          DoublePointer chisq,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_tsvd(@Const gsl_matrix X,
                          @Const gsl_vector y,
                          double tol,
                          gsl_vector c,
                          gsl_matrix cov,
                          DoubleBuffer chisq,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_tsvd(@Const gsl_matrix X,
                          @Const gsl_vector y,
                          double tol,
                          gsl_vector c,
                          gsl_matrix cov,
                          double[] chisq,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_svd(@Const gsl_matrix X,
                         gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_bsvd(@Const gsl_matrix X,
                          gsl_multifit_linear_workspace work);

public static native @Cast("size_t") long gsl_multifit_linear_rank(double tol, @Const gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_solve(double lambda,
                           @Const gsl_matrix X,
                           @Const gsl_vector y,
                           gsl_vector c,
                           DoublePointer rnorm,
                           DoublePointer snorm,
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_solve(double lambda,
                           @Const gsl_matrix X,
                           @Const gsl_vector y,
                           gsl_vector c,
                           DoubleBuffer rnorm,
                           DoubleBuffer snorm,
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_solve(double lambda,
                           @Const gsl_matrix X,
                           @Const gsl_vector y,
                           gsl_vector c,
                           double[] rnorm,
                           double[] snorm,
                           gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_applyW(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           gsl_matrix WX,
                           gsl_vector Wy);

public static native int gsl_multifit_linear_stdform1(@Const gsl_vector L,
                              @Const gsl_matrix X,
                              @Const gsl_vector y,
                              gsl_matrix Xs,
                              gsl_vector ys,
                              gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_wstdform1(@Const gsl_vector L,
                               @Const gsl_matrix X,
                               @Const gsl_vector w,
                               @Const gsl_vector y,
                               gsl_matrix Xs,
                               gsl_vector ys,
                               gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_L_decomp(gsl_matrix L, gsl_vector tau);

public static native int gsl_multifit_linear_stdform2(@Const gsl_matrix LQR,
                              @Const gsl_vector Ltau,
                              @Const gsl_matrix X,
                              @Const gsl_vector y,
                              gsl_matrix Xs,
                              gsl_vector ys,
                              gsl_matrix M,
                              gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_wstdform2(@Const gsl_matrix LQR,
                               @Const gsl_vector Ltau,
                               @Const gsl_matrix X,
                               @Const gsl_vector w,
                               @Const gsl_vector y,
                               gsl_matrix Xs,
                               gsl_vector ys,
                               gsl_matrix M,
                               gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_genform1(@Const gsl_vector L,
                              @Const gsl_vector cs,
                              gsl_vector c,
                              gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_genform2(@Const gsl_matrix LQR,
                              @Const gsl_vector Ltau,
                              @Const gsl_matrix X,
                              @Const gsl_vector y,
                              @Const gsl_vector cs,
                              @Const gsl_matrix M,
                              gsl_vector c,
                              gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_wgenform2(@Const gsl_matrix LQR,
                               @Const gsl_vector Ltau,
                               @Const gsl_matrix X,
                               @Const gsl_vector w,
                               @Const gsl_vector y,
                               @Const gsl_vector cs,
                               @Const gsl_matrix M,
                               gsl_vector c,
                               gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_lreg(double smin, double smax,
                          gsl_vector reg_param);

public static native int gsl_multifit_linear_lcurve(@Const gsl_vector y,
                            gsl_vector reg_param,
                            gsl_vector rho, gsl_vector eta,
                            gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_lcurvature(@Const gsl_vector y,
                                @Const gsl_vector reg_param,
                                @Const gsl_vector rho,
                                @Const gsl_vector eta,
                                gsl_vector kappa,
                                gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_lcorner(@Const gsl_vector rho,
                            @Const gsl_vector eta,
                            @Cast("size_t*") SizeTPointer idx);

public static native int gsl_multifit_linear_lcorner2(@Const gsl_vector reg_param,
                             @Const gsl_vector eta,
                             @Cast("size_t*") SizeTPointer idx);

public static native int gsl_multifit_linear_Lk(@Cast("const size_t") long p, @Cast("const size_t") long k, gsl_matrix L);

public static native int gsl_multifit_linear_Lsobolev(@Cast("const size_t") long p, @Cast("const size_t") long kmax,
                             @Const gsl_vector alpha, gsl_matrix L,
                             gsl_multifit_linear_workspace work);

public static native int gsl_multifit_wlinear(@Const gsl_matrix X,
                      @Const gsl_vector w,
                      @Const gsl_vector y,
                      gsl_vector c,
                      gsl_matrix cov,
                      DoublePointer chisq,
                      gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear(@Const gsl_matrix X,
                      @Const gsl_vector w,
                      @Const gsl_vector y,
                      gsl_vector c,
                      gsl_matrix cov,
                      DoubleBuffer chisq,
                      gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear(@Const gsl_matrix X,
                      @Const gsl_vector w,
                      @Const gsl_vector y,
                      gsl_vector c,
                      gsl_matrix cov,
                      double[] chisq,
                      gsl_multifit_linear_workspace work);

public static native int gsl_multifit_wlinear_tsvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           gsl_vector c,
                           gsl_matrix cov,
                           DoublePointer chisq,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_tsvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           gsl_vector c,
                           gsl_matrix cov,
                           DoubleBuffer chisq,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_tsvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           gsl_vector c,
                           gsl_matrix cov,
                           double[] chisq,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_multifit_linear_workspace work);

public static native int gsl_multifit_wlinear_svd(@Const gsl_matrix X,
                          @Const gsl_vector w,
                          @Const gsl_vector y,
                          double tol,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_vector c,
                          gsl_matrix cov,
                          DoublePointer chisq, 
                          gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_svd(@Const gsl_matrix X,
                          @Const gsl_vector w,
                          @Const gsl_vector y,
                          double tol,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_vector c,
                          gsl_matrix cov,
                          DoubleBuffer chisq, 
                          gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_svd(@Const gsl_matrix X,
                          @Const gsl_vector w,
                          @Const gsl_vector y,
                          double tol,
                          @Cast("size_t*") SizeTPointer rank,
                          gsl_vector c,
                          gsl_matrix cov,
                          double[] chisq, 
                          gsl_multifit_linear_workspace work);

public static native int gsl_multifit_wlinear_usvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_vector c,
                           gsl_matrix cov,
                           DoublePointer chisq, 
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_usvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_vector c,
                           gsl_matrix cov,
                           DoubleBuffer chisq, 
                           gsl_multifit_linear_workspace work);
public static native int gsl_multifit_wlinear_usvd(@Const gsl_matrix X,
                           @Const gsl_vector w,
                           @Const gsl_vector y,
                           double tol,
                           @Cast("size_t*") SizeTPointer rank,
                           gsl_vector c,
                           gsl_matrix cov,
                           double[] chisq, 
                           gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_est(@Const gsl_vector x,
                         @Const gsl_vector c,
                         @Const gsl_matrix cov, DoublePointer y, DoublePointer y_err);
public static native int gsl_multifit_linear_est(@Const gsl_vector x,
                         @Const gsl_vector c,
                         @Const gsl_matrix cov, DoubleBuffer y, DoubleBuffer y_err);
public static native int gsl_multifit_linear_est(@Const gsl_vector x,
                         @Const gsl_vector c,
                         @Const gsl_matrix cov, double[] y, double[] y_err);

public static native double gsl_multifit_linear_rcond(@Const gsl_multifit_linear_workspace w);

public static native int gsl_multifit_linear_residuals(@Const gsl_matrix X, @Const gsl_vector y,
                               @Const gsl_vector c, gsl_vector r);

/* gcv.c */
public static native int gsl_multifit_linear_gcv_init(@Const gsl_vector y,
                             gsl_vector reg_param,
                             gsl_vector UTy,
                             DoublePointer delta0,
                             gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv_init(@Const gsl_vector y,
                             gsl_vector reg_param,
                             gsl_vector UTy,
                             DoubleBuffer delta0,
                             gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv_init(@Const gsl_vector y,
                             gsl_vector reg_param,
                             gsl_vector UTy,
                             double[] delta0,
                             gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_gcv_curve(@Const gsl_vector reg_param,
                              @Const gsl_vector UTy,
                              double delta0,
                              gsl_vector G,
                              gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_gcv_min(@Const gsl_vector reg_param,
                            @Const gsl_vector UTy,
                            @Const gsl_vector G,
                            double delta0,
                            DoublePointer lambda,
                            gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv_min(@Const gsl_vector reg_param,
                            @Const gsl_vector UTy,
                            @Const gsl_vector G,
                            double delta0,
                            DoubleBuffer lambda,
                            gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv_min(@Const gsl_vector reg_param,
                            @Const gsl_vector UTy,
                            @Const gsl_vector G,
                            double delta0,
                            double[] lambda,
                            gsl_multifit_linear_workspace work);

public static native double gsl_multifit_linear_gcv_calc(double lambda,
                             @Const gsl_vector UTy,
                             double delta0,
                             gsl_multifit_linear_workspace work);

public static native int gsl_multifit_linear_gcv(@Const gsl_vector y,
                        gsl_vector reg_param,
                        gsl_vector G,
                        DoublePointer lambda,
                        DoublePointer G_lambda,
                        gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv(@Const gsl_vector y,
                        gsl_vector reg_param,
                        gsl_vector G,
                        DoubleBuffer lambda,
                        DoubleBuffer G_lambda,
                        gsl_multifit_linear_workspace work);
public static native int gsl_multifit_linear_gcv(@Const gsl_vector y,
                        gsl_vector reg_param,
                        gsl_vector G,
                        double[] lambda,
                        double[] G_lambda,
                        gsl_multifit_linear_workspace work);
// Targeting ../gsl_multifit_robust_type.java


// Targeting ../gsl_multifit_robust_stats.java


// Targeting ../gsl_multifit_robust_workspace.java



/* available types */
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_default(); public static native void gsl_multifit_robust_default(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_bisquare(); public static native void gsl_multifit_robust_bisquare(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_cauchy(); public static native void gsl_multifit_robust_cauchy(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_fair(); public static native void gsl_multifit_robust_fair(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_huber(); public static native void gsl_multifit_robust_huber(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_ols(); public static native void gsl_multifit_robust_ols(gsl_multifit_robust_type setter);
public static native @Const gsl_multifit_robust_type gsl_multifit_robust_welsch(); public static native void gsl_multifit_robust_welsch(gsl_multifit_robust_type setter);

public static native gsl_multifit_robust_workspace gsl_multifit_robust_alloc(@Const gsl_multifit_robust_type T,
                                                         @Cast("const size_t") long n, @Cast("const size_t") long p);
public static native void gsl_multifit_robust_free(gsl_multifit_robust_workspace w);
public static native int gsl_multifit_robust_tune(double tune,
                             gsl_multifit_robust_workspace w);
public static native int gsl_multifit_robust_maxiter(@Cast("const size_t") long maxiter,
                                gsl_multifit_robust_workspace w);
public static native @Cast("const char*") BytePointer gsl_multifit_robust_name(@Const gsl_multifit_robust_workspace w);
public static native @ByVal gsl_multifit_robust_stats gsl_multifit_robust_statistics(@Const gsl_multifit_robust_workspace w);
public static native int gsl_multifit_robust_weights(@Const gsl_vector r, gsl_vector wts,
                                gsl_multifit_robust_workspace w);
public static native int gsl_multifit_robust(@Const gsl_matrix X, @Const gsl_vector y,
                        gsl_vector c, gsl_matrix cov,
                        gsl_multifit_robust_workspace w);
public static native int gsl_multifit_robust_est(@Const gsl_vector x, @Const gsl_vector c,
                            @Const gsl_matrix cov, DoublePointer y, DoublePointer y_err);
public static native int gsl_multifit_robust_est(@Const gsl_vector x, @Const gsl_vector c,
                            @Const gsl_matrix cov, DoubleBuffer y, DoubleBuffer y_err);
public static native int gsl_multifit_robust_est(@Const gsl_vector x, @Const gsl_vector c,
                            @Const gsl_matrix cov, double[] y, double[] y_err);
public static native int gsl_multifit_robust_residuals(@Const gsl_matrix X,
                                  @Const gsl_vector y,
                                  @Const gsl_vector c, gsl_vector r,
                                  gsl_multifit_robust_workspace w);

// #endif /* __GSL_MULTIFIT_H__ */


// Parsed from gsl/gsl_multifit_nlin.h

/* multifit_nlin/gsl_multifit_nlin.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MULTIFIT_NLIN_H__
// #define __GSL_MULTIFIT_NLIN_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_multifit_gradient(@Const gsl_matrix J, @Const gsl_vector f,
                           gsl_vector g);

public static native int gsl_multifit_covar(@Const gsl_matrix J, double epsrel, gsl_matrix covar);
public static native int gsl_multifit_covar_QRPT(gsl_matrix r, gsl_permutation perm,
                             double epsrel, gsl_matrix covar);
// Targeting ../gsl_multifit_function.java



// #define GSL_MULTIFIT_FN_EVAL(F,x,y) (*((F)->f))(x,(F)->params,(y))
// Targeting ../gsl_multifit_fsolver_type.java


// Targeting ../gsl_multifit_fsolver.java



public static native gsl_multifit_fsolver gsl_multifit_fsolver_alloc(@Const gsl_multifit_fsolver_type T, 
                            @Cast("size_t") long n, @Cast("size_t") long p);

public static native void gsl_multifit_fsolver_free(gsl_multifit_fsolver s);

public static native int gsl_multifit_fsolver_set(gsl_multifit_fsolver s, 
                              gsl_multifit_function f, 
                              @Const gsl_vector x);

public static native int gsl_multifit_fsolver_iterate(gsl_multifit_fsolver s);

public static native int gsl_multifit_fsolver_driver(gsl_multifit_fsolver s,
                                 @Cast("const size_t") long maxiter,
                                 double epsabs, double epsrel);

public static native @Cast("const char*") BytePointer gsl_multifit_fsolver_name(@Const gsl_multifit_fsolver s);
public static native gsl_vector gsl_multifit_fsolver_position(@Const gsl_multifit_fsolver s);
// Targeting ../gsl_multifit_function_fdf.java


// Targeting ../gsl_multifit_fdfsolver_type.java


// Targeting ../gsl_multifit_fdfsolver.java




public static native gsl_multifit_fdfsolver gsl_multifit_fdfsolver_alloc(@Const gsl_multifit_fdfsolver_type T, 
                              @Cast("size_t") long n, @Cast("size_t") long p);

public static native int gsl_multifit_fdfsolver_set(gsl_multifit_fdfsolver s, 
                            gsl_multifit_function_fdf fdf,
                            @Const gsl_vector x);
public static native int gsl_multifit_fdfsolver_wset(gsl_multifit_fdfsolver s, 
                                 gsl_multifit_function_fdf f, 
                                 @Const gsl_vector x,
                                 @Const gsl_vector wts);

public static native int gsl_multifit_fdfsolver_iterate(gsl_multifit_fdfsolver s);

public static native int gsl_multifit_fdfsolver_driver(gsl_multifit_fdfsolver s,
                                   @Cast("const size_t") long maxiter,
                                   double xtol,
                                   double gtol,
                                   double ftol,
                                   IntPointer info);
public static native int gsl_multifit_fdfsolver_driver(gsl_multifit_fdfsolver s,
                                   @Cast("const size_t") long maxiter,
                                   double xtol,
                                   double gtol,
                                   double ftol,
                                   IntBuffer info);
public static native int gsl_multifit_fdfsolver_driver(gsl_multifit_fdfsolver s,
                                   @Cast("const size_t") long maxiter,
                                   double xtol,
                                   double gtol,
                                   double ftol,
                                   int[] info);

public static native int gsl_multifit_fdfsolver_jac(gsl_multifit_fdfsolver s,
                                gsl_matrix J);

public static native void gsl_multifit_fdfsolver_free(gsl_multifit_fdfsolver s);

public static native @Cast("const char*") BytePointer gsl_multifit_fdfsolver_name(@Const gsl_multifit_fdfsolver s);
public static native gsl_vector gsl_multifit_fdfsolver_position(@Const gsl_multifit_fdfsolver s);
public static native gsl_vector gsl_multifit_fdfsolver_residual(@Const gsl_multifit_fdfsolver s);
public static native @Cast("size_t") long gsl_multifit_fdfsolver_niter(@Const gsl_multifit_fdfsolver s);
public static native int gsl_multifit_eval_wf(gsl_multifit_function_fdf fdf,
                         @Const gsl_vector x, @Const gsl_vector wts,
                         gsl_vector y);
public static native int gsl_multifit_eval_wdf(gsl_multifit_function_fdf fdf,
                          @Const gsl_vector x, @Const gsl_vector wts,
                          gsl_matrix dy);

public static native int gsl_multifit_fdfsolver_test(@Const gsl_multifit_fdfsolver s,
                                 double xtol,
                                 double gtol,
                                 double ftol, IntPointer info);
public static native int gsl_multifit_fdfsolver_test(@Const gsl_multifit_fdfsolver s,
                                 double xtol,
                                 double gtol,
                                 double ftol, IntBuffer info);
public static native int gsl_multifit_fdfsolver_test(@Const gsl_multifit_fdfsolver s,
                                 double xtol,
                                 double gtol,
                                 double ftol, int[] info);
public static native int gsl_multifit_test_delta(@Const gsl_vector dx, @Const gsl_vector x, 
                             double epsabs, double epsrel);

public static native int gsl_multifit_test_gradient(@Const gsl_vector g, double epsabs);

public static native int gsl_multifit_fdfsolver_dif_df(@Const gsl_vector x,
                                  @Const gsl_vector wts,
                                  gsl_multifit_function_fdf fdf,
                                  @Const gsl_vector f, gsl_matrix J);

// Targeting ../gsl_multifit_fdfridge.java



public static native gsl_multifit_fdfridge gsl_multifit_fdfridge_alloc(@Const gsl_multifit_fdfsolver_type T,
                             @Cast("const size_t") long n, @Cast("const size_t") long p);
public static native void gsl_multifit_fdfridge_free(gsl_multifit_fdfridge work);
public static native @Cast("const char*") BytePointer gsl_multifit_fdfridge_name(@Const gsl_multifit_fdfridge w);
public static native gsl_vector gsl_multifit_fdfridge_position(@Const gsl_multifit_fdfridge w);
public static native gsl_vector gsl_multifit_fdfridge_residual(@Const gsl_multifit_fdfridge w);
public static native @Cast("size_t") long gsl_multifit_fdfridge_niter(@Const gsl_multifit_fdfridge w);
public static native int gsl_multifit_fdfridge_set(gsl_multifit_fdfridge w,
                               gsl_multifit_function_fdf f,
                               @Const gsl_vector x,
                               double lambda);
public static native int gsl_multifit_fdfridge_wset(gsl_multifit_fdfridge w,
                                gsl_multifit_function_fdf f,
                                @Const gsl_vector x,
                                double lambda,
                                @Const gsl_vector wts);
public static native int gsl_multifit_fdfridge_set2(gsl_multifit_fdfridge w,
                                gsl_multifit_function_fdf f,
                                @Const gsl_vector x,
                                @Const gsl_vector lambda);
public static native int gsl_multifit_fdfridge_wset2(gsl_multifit_fdfridge w,
                                 gsl_multifit_function_fdf f,
                                 @Const gsl_vector x,
                                 @Const gsl_vector lambda,
                                 @Const gsl_vector wts);
public static native int gsl_multifit_fdfridge_set3(gsl_multifit_fdfridge w,
                                gsl_multifit_function_fdf f,
                                @Const gsl_vector x,
                                @Const gsl_matrix L);
public static native int gsl_multifit_fdfridge_wset3(gsl_multifit_fdfridge w,
                                 gsl_multifit_function_fdf f,
                                 @Const gsl_vector x,
                                 @Const gsl_matrix L,
                                 @Const gsl_vector wts);
public static native int gsl_multifit_fdfridge_iterate(gsl_multifit_fdfridge w);
public static native int gsl_multifit_fdfridge_driver(gsl_multifit_fdfridge w,
                                  @Cast("const size_t") long maxiter,
                                  double xtol,
                                  double gtol,
                                  double ftol,
                                  IntPointer info);
public static native int gsl_multifit_fdfridge_driver(gsl_multifit_fdfridge w,
                                  @Cast("const size_t") long maxiter,
                                  double xtol,
                                  double gtol,
                                  double ftol,
                                  IntBuffer info);
public static native int gsl_multifit_fdfridge_driver(gsl_multifit_fdfridge w,
                                  @Cast("const size_t") long maxiter,
                                  double xtol,
                                  double gtol,
                                  double ftol,
                                  int[] info);

/* extern const gsl_multifit_fsolver_type * gsl_multifit_fsolver_gradient; */

public static native @Const gsl_multifit_fdfsolver_type gsl_multifit_fdfsolver_lmsder(); public static native void gsl_multifit_fdfsolver_lmsder(gsl_multifit_fdfsolver_type setter);
public static native @Const gsl_multifit_fdfsolver_type gsl_multifit_fdfsolver_lmder(); public static native void gsl_multifit_fdfsolver_lmder(gsl_multifit_fdfsolver_type setter);
public static native @Const gsl_multifit_fdfsolver_type gsl_multifit_fdfsolver_lmniel(); public static native void gsl_multifit_fdfsolver_lmniel(gsl_multifit_fdfsolver_type setter);

// #endif /* __GSL_MULTIFIT_NLIN_H__ */


// Parsed from gsl/gsl_multimin.h

/* multimin/gsl_multimin.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Fabrice Rossi
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Modified by Tuomo Keskitalo to include fminimizer and 
   Nelder Mead related lines */

// #ifndef __GSL_MULTIMIN_H__
// #define __GSL_MULTIMIN_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>
// #include <gsl/gsl_min.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_multimin_function.java



// #define GSL_MULTIMIN_FN_EVAL(F,x) (*((F)->f))(x,(F)->params)
// Targeting ../gsl_multimin_function_fdf.java



// #define GSL_MULTIMIN_FN_EVAL_F(F,x) (*((F)->f))(x,(F)->params)
// #define GSL_MULTIMIN_FN_EVAL_DF(F,x,g) (*((F)->df))(x,(F)->params,(g))
// #define GSL_MULTIMIN_FN_EVAL_F_DF(F,x,y,g) (*((F)->fdf))(x,(F)->params,(y),(g))

public static native int gsl_multimin_diff(@Const gsl_multimin_function f,
                       @Const gsl_vector x, gsl_vector g);
// Targeting ../gsl_multimin_fminimizer_type.java


// Targeting ../gsl_multimin_fminimizer.java



public static native gsl_multimin_fminimizer gsl_multimin_fminimizer_alloc(@Const gsl_multimin_fminimizer_type T,
                              @Cast("size_t") long n);

public static native int gsl_multimin_fminimizer_set(gsl_multimin_fminimizer s,
                             gsl_multimin_function f,
                             @Const gsl_vector x,
                             @Const gsl_vector step_size);

public static native void gsl_multimin_fminimizer_free(gsl_multimin_fminimizer s);

public static native @Cast("const char*") BytePointer gsl_multimin_fminimizer_name(@Const gsl_multimin_fminimizer s);

public static native int gsl_multimin_fminimizer_iterate(gsl_multimin_fminimizer s);

public static native gsl_vector gsl_multimin_fminimizer_x(@Const gsl_multimin_fminimizer s);

public static native double gsl_multimin_fminimizer_minimum(@Const gsl_multimin_fminimizer s);

public static native double gsl_multimin_fminimizer_size(@Const gsl_multimin_fminimizer s);

/* Convergence test functions */

public static native int gsl_multimin_test_gradient(@Const gsl_vector g, double epsabs);

public static native int gsl_multimin_test_size(double size, double epsabs);
// Targeting ../gsl_multimin_fdfminimizer_type.java


// Targeting ../gsl_multimin_fdfminimizer.java



public static native gsl_multimin_fdfminimizer gsl_multimin_fdfminimizer_alloc(@Const gsl_multimin_fdfminimizer_type T,
                                @Cast("size_t") long n);

public static native int gsl_multimin_fdfminimizer_set(gsl_multimin_fdfminimizer s,
                               gsl_multimin_function_fdf fdf,
                               @Const gsl_vector x,
                               double step_size, double tol);

public static native void gsl_multimin_fdfminimizer_free(gsl_multimin_fdfminimizer s);

public static native @Cast("const char*") BytePointer gsl_multimin_fdfminimizer_name(@Const gsl_multimin_fdfminimizer s);

public static native int gsl_multimin_fdfminimizer_iterate(gsl_multimin_fdfminimizer s);

public static native int gsl_multimin_fdfminimizer_restart(gsl_multimin_fdfminimizer s);

public static native gsl_vector gsl_multimin_fdfminimizer_x(@Const gsl_multimin_fdfminimizer s);

public static native gsl_vector gsl_multimin_fdfminimizer_dx(@Const gsl_multimin_fdfminimizer s);

public static native gsl_vector gsl_multimin_fdfminimizer_gradient(@Const gsl_multimin_fdfminimizer s);

public static native double gsl_multimin_fdfminimizer_minimum(@Const gsl_multimin_fdfminimizer s);

public static native @Const gsl_multimin_fdfminimizer_type gsl_multimin_fdfminimizer_steepest_descent(); public static native void gsl_multimin_fdfminimizer_steepest_descent(gsl_multimin_fdfminimizer_type setter);
public static native @Const gsl_multimin_fdfminimizer_type gsl_multimin_fdfminimizer_conjugate_pr(); public static native void gsl_multimin_fdfminimizer_conjugate_pr(gsl_multimin_fdfminimizer_type setter);
public static native @Const gsl_multimin_fdfminimizer_type gsl_multimin_fdfminimizer_conjugate_fr(); public static native void gsl_multimin_fdfminimizer_conjugate_fr(gsl_multimin_fdfminimizer_type setter);
public static native @Const gsl_multimin_fdfminimizer_type gsl_multimin_fdfminimizer_vector_bfgs(); public static native void gsl_multimin_fdfminimizer_vector_bfgs(gsl_multimin_fdfminimizer_type setter);
public static native @Const gsl_multimin_fdfminimizer_type gsl_multimin_fdfminimizer_vector_bfgs2(); public static native void gsl_multimin_fdfminimizer_vector_bfgs2(gsl_multimin_fdfminimizer_type setter);
public static native @Const gsl_multimin_fminimizer_type gsl_multimin_fminimizer_nmsimplex(); public static native void gsl_multimin_fminimizer_nmsimplex(gsl_multimin_fminimizer_type setter);
public static native @Const gsl_multimin_fminimizer_type gsl_multimin_fminimizer_nmsimplex2(); public static native void gsl_multimin_fminimizer_nmsimplex2(gsl_multimin_fminimizer_type setter);
public static native @Const gsl_multimin_fminimizer_type gsl_multimin_fminimizer_nmsimplex2rand(); public static native void gsl_multimin_fminimizer_nmsimplex2rand(gsl_multimin_fminimizer_type setter);

// #endif /* __GSL_MULTIMIN_H__ */


// Parsed from gsl/gsl_multiroots.h

/* multiroots/gsl_multiroots.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MULTIROOTS_H__
// #define __GSL_MULTIROOTS_H__

// #include <stdlib.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_math.h>
// #include <gsl/gsl_vector.h>
// #include <gsl/gsl_matrix.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_multiroot_function.java



// #define GSL_MULTIROOT_FN_EVAL(F,x,y) (*((F)->f))(x,(F)->params,(y))

public static native int gsl_multiroot_fdjacobian(gsl_multiroot_function F,
                              @Const gsl_vector x, @Const gsl_vector f,
                              double epsrel, gsl_matrix jacobian);
// Targeting ../gsl_multiroot_fsolver_type.java


// Targeting ../gsl_multiroot_fsolver.java



public static native gsl_multiroot_fsolver gsl_multiroot_fsolver_alloc(@Const gsl_multiroot_fsolver_type T, 
                                     @Cast("size_t") long n); 

public static native void gsl_multiroot_fsolver_free(gsl_multiroot_fsolver s);

public static native int gsl_multiroot_fsolver_set(gsl_multiroot_fsolver s, 
                               gsl_multiroot_function f, 
                               @Const gsl_vector x);

public static native int gsl_multiroot_fsolver_iterate(gsl_multiroot_fsolver s);

public static native @Cast("const char*") BytePointer gsl_multiroot_fsolver_name(@Const gsl_multiroot_fsolver s);
public static native gsl_vector gsl_multiroot_fsolver_root(@Const gsl_multiroot_fsolver s);
public static native gsl_vector gsl_multiroot_fsolver_dx(@Const gsl_multiroot_fsolver s);
public static native gsl_vector gsl_multiroot_fsolver_f(@Const gsl_multiroot_fsolver s);
// Targeting ../gsl_multiroot_function_fdf.java



// #define GSL_MULTIROOT_FN_EVAL_F(F,x,y) ((*((F)->f))(x,(F)->params,(y)))
// #define GSL_MULTIROOT_FN_EVAL_DF(F,x,dy) ((*((F)->df))(x,(F)->params,(dy)))
// #define GSL_MULTIROOT_FN_EVAL_F_DF(F,x,y,dy) ((*((F)->fdf))(x,(F)->params,(y),(dy)))
// Targeting ../gsl_multiroot_fdfsolver_type.java


// Targeting ../gsl_multiroot_fdfsolver.java



public static native gsl_multiroot_fdfsolver gsl_multiroot_fdfsolver_alloc(@Const gsl_multiroot_fdfsolver_type T,
                                      @Cast("size_t") long n);

public static native int gsl_multiroot_fdfsolver_set(gsl_multiroot_fdfsolver s, 
                             gsl_multiroot_function_fdf fdf,
                             @Const gsl_vector x);

public static native int gsl_multiroot_fdfsolver_iterate(gsl_multiroot_fdfsolver s);

public static native void gsl_multiroot_fdfsolver_free(gsl_multiroot_fdfsolver s);

public static native @Cast("const char*") BytePointer gsl_multiroot_fdfsolver_name(@Const gsl_multiroot_fdfsolver s);
public static native gsl_vector gsl_multiroot_fdfsolver_root(@Const gsl_multiroot_fdfsolver s);
public static native gsl_vector gsl_multiroot_fdfsolver_dx(@Const gsl_multiroot_fdfsolver s);
public static native gsl_vector gsl_multiroot_fdfsolver_f(@Const gsl_multiroot_fdfsolver s);

public static native int gsl_multiroot_test_delta(@Const gsl_vector dx, @Const gsl_vector x, 
                              double epsabs, double epsrel);

public static native int gsl_multiroot_test_residual(@Const gsl_vector f, double epsabs);

public static native @Const gsl_multiroot_fsolver_type gsl_multiroot_fsolver_dnewton(); public static native void gsl_multiroot_fsolver_dnewton(gsl_multiroot_fsolver_type setter);
public static native @Const gsl_multiroot_fsolver_type gsl_multiroot_fsolver_broyden(); public static native void gsl_multiroot_fsolver_broyden(gsl_multiroot_fsolver_type setter);
public static native @Const gsl_multiroot_fsolver_type gsl_multiroot_fsolver_hybrid(); public static native void gsl_multiroot_fsolver_hybrid(gsl_multiroot_fsolver_type setter);
public static native @Const gsl_multiroot_fsolver_type gsl_multiroot_fsolver_hybrids(); public static native void gsl_multiroot_fsolver_hybrids(gsl_multiroot_fsolver_type setter);

public static native @Const gsl_multiroot_fdfsolver_type gsl_multiroot_fdfsolver_newton(); public static native void gsl_multiroot_fdfsolver_newton(gsl_multiroot_fdfsolver_type setter);
public static native @Const gsl_multiroot_fdfsolver_type gsl_multiroot_fdfsolver_gnewton(); public static native void gsl_multiroot_fdfsolver_gnewton(gsl_multiroot_fdfsolver_type setter);
public static native @Const gsl_multiroot_fdfsolver_type gsl_multiroot_fdfsolver_hybridj(); public static native void gsl_multiroot_fdfsolver_hybridj(gsl_multiroot_fdfsolver_type setter);
public static native @Const gsl_multiroot_fdfsolver_type gsl_multiroot_fdfsolver_hybridsj(); public static native void gsl_multiroot_fdfsolver_hybridsj(gsl_multiroot_fdfsolver_type setter);

// #endif /* __GSL_MULTIROOTS_H__ */


// Parsed from gsl/gsl_multiset.h

/* multiset/gsl_multiset.h
 * based on combination/gsl_combination.h by Szymon Jaroszewicz
 * based on permutation/gsl_permutation.h by Brian Gough
 *
 * Copyright (C) 2009 Rhys Ulerich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_MULTISET_H__
// #define __GSL_MULTISET_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_types.h>
// #include <gsl/gsl_inline.h>
// #include <gsl/gsl_check_range.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_multiset.java



public static native gsl_multiset gsl_multiset_alloc(@Cast("const size_t") long n, @Cast("const size_t") long k);
public static native gsl_multiset gsl_multiset_calloc(@Cast("const size_t") long n, @Cast("const size_t") long k);
public static native void gsl_multiset_init_first(gsl_multiset c);
public static native void gsl_multiset_init_last(gsl_multiset c);
public static native void gsl_multiset_free(gsl_multiset c);
public static native int gsl_multiset_memcpy(gsl_multiset dest, @Const gsl_multiset src);

public static native int gsl_multiset_fread(FILE stream, gsl_multiset c);
public static native int gsl_multiset_fwrite(FILE stream, @Const gsl_multiset c);
public static native int gsl_multiset_fscanf(FILE stream, gsl_multiset c);
public static native int gsl_multiset_fprintf(FILE stream, @Const gsl_multiset c, @Cast("const char*") BytePointer format);
public static native int gsl_multiset_fprintf(FILE stream, @Const gsl_multiset c, String format);

public static native @Cast("size_t") long gsl_multiset_n(@Const gsl_multiset c);
public static native @Cast("size_t") long gsl_multiset_k(@Const gsl_multiset c);
public static native @Cast("size_t*") SizeTPointer gsl_multiset_data(@Const gsl_multiset c);

public static native int gsl_multiset_valid(gsl_multiset c);
public static native int gsl_multiset_next(gsl_multiset c);
public static native int gsl_multiset_prev(gsl_multiset c);

/* */ public static native @Cast("size_t") long gsl_multiset_get(@Const gsl_multiset c, @Cast("const size_t") long i);

// #ifdef HAVE_INLINE

// #endif /* HAVE_INLINE */

// #endif /* __GSL_MULTISET_H__ */


// Parsed from gsl/gsl_ntuple.h

/* histogram/ntuple.h
 * 
 * Copyright (C) 2000 Simone Piccardi
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/* Jan/2001 Modified by Brian Gough. Minor changes for GSL */

// #ifndef __GSL_NTUPLE_H__
// #define __GSL_NTUPLE_H__

// #include <stdlib.h>
// #include <stdio.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_histogram.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// Targeting ../gsl_ntuple.java


// Targeting ../gsl_ntuple_select_fn.java


// Targeting ../gsl_ntuple_value_fn.java



public static native gsl_ntuple gsl_ntuple_open(@Cast("char*") BytePointer filename, Pointer ntuple_data, @Cast("size_t") long size);
public static native gsl_ntuple gsl_ntuple_open(@Cast("char*") ByteBuffer filename, Pointer ntuple_data, @Cast("size_t") long size);
public static native gsl_ntuple gsl_ntuple_open(@Cast("char*") byte[] filename, Pointer ntuple_data, @Cast("size_t") long size);

public static native gsl_ntuple gsl_ntuple_create(@Cast("char*") BytePointer filename, Pointer ntuple_data, @Cast("size_t") long size);
public static native gsl_ntuple gsl_ntuple_create(@Cast("char*") ByteBuffer filename, Pointer ntuple_data, @Cast("size_t") long size);
public static native gsl_ntuple gsl_ntuple_create(@Cast("char*") byte[] filename, Pointer ntuple_data, @Cast("size_t") long size);

public static native int gsl_ntuple_write(gsl_ntuple ntuple);
public static native int gsl_ntuple_read(gsl_ntuple ntuple);

public static native int gsl_ntuple_bookdata(gsl_ntuple ntuple);  /* synonym for write */

public static native int gsl_ntuple_project(gsl_histogram h, gsl_ntuple ntuple, 
                        gsl_ntuple_value_fn value_func,
                        gsl_ntuple_select_fn select_func);

public static native int gsl_ntuple_close(gsl_ntuple ntuple);

// #endif /* __GSL_NTUPLE_H__ */






// Parsed from gsl/gsl_odeiv2.h

/* ode-initval/odeiv2.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  G. Jungman */
/* Modified by Tuomo Keskitalo */

// #ifndef __GSL_ODEIV2_H__
// #define __GSL_ODEIV2_H__

// #include <stdio.h>
// #include <stdlib.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_odeiv2_system.java



/* Function evaluation macros */

// #define GSL_ODEIV_FN_EVAL(S,t,y,f)  (*((S)->function))(t,y,f,(S)->params)
// #define GSL_ODEIV_JA_EVAL(S,t,y,dfdy,dfdt)  (*((S)->jacobian))(t,y,dfdy,dfdt,(S)->params)

/* Type definitions */
// Targeting ../gsl_odeiv2_step_type.java


// Targeting ../gsl_odeiv2_step.java



/* Available stepper types */

public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk2(); public static native void gsl_odeiv2_step_rk2(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk4(); public static native void gsl_odeiv2_step_rk4(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rkf45(); public static native void gsl_odeiv2_step_rkf45(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rkck(); public static native void gsl_odeiv2_step_rkck(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk8pd(); public static native void gsl_odeiv2_step_rk8pd(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk2imp(); public static native void gsl_odeiv2_step_rk2imp(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk4imp(); public static native void gsl_odeiv2_step_rk4imp(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_bsimp(); public static native void gsl_odeiv2_step_bsimp(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_rk1imp(); public static native void gsl_odeiv2_step_rk1imp(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_msadams(); public static native void gsl_odeiv2_step_msadams(gsl_odeiv2_step_type setter);
public static native @Const gsl_odeiv2_step_type gsl_odeiv2_step_msbdf(); public static native void gsl_odeiv2_step_msbdf(gsl_odeiv2_step_type setter);

/* Stepper object methods */

public static native gsl_odeiv2_step gsl_odeiv2_step_alloc(@Const gsl_odeiv2_step_type T,
                                        @Cast("size_t") long dim);
public static native int gsl_odeiv2_step_reset(gsl_odeiv2_step s);
public static native void gsl_odeiv2_step_free(gsl_odeiv2_step s);
public static native @Cast("const char*") BytePointer gsl_odeiv2_step_name(@Const gsl_odeiv2_step s);
public static native @Cast("unsigned int") int gsl_odeiv2_step_order(@Const gsl_odeiv2_step s);
public static native int gsl_odeiv2_step_apply(gsl_odeiv2_step s, double t, double h,
                           DoublePointer y, DoublePointer yerr, @Const DoublePointer dydt_in,
                           DoublePointer dydt_out, @Const gsl_odeiv2_system dydt);
public static native int gsl_odeiv2_step_apply(gsl_odeiv2_step s, double t, double h,
                           DoubleBuffer y, DoubleBuffer yerr, @Const DoubleBuffer dydt_in,
                           DoubleBuffer dydt_out, @Const gsl_odeiv2_system dydt);
public static native int gsl_odeiv2_step_apply(gsl_odeiv2_step s, double t, double h,
                           double[] y, double[] yerr, @Const double[] dydt_in,
                           double[] dydt_out, @Const gsl_odeiv2_system dydt);
public static native int gsl_odeiv2_step_set_driver(gsl_odeiv2_step s,
                                @Const gsl_odeiv2_driver d);
// Targeting ../gsl_odeiv2_control_type.java


// Targeting ../gsl_odeiv2_control.java



/* Possible return values for an hadjust() evolution method */

public static final int GSL_ODEIV_HADJ_INC =   1;  /* step was increased */
public static final int GSL_ODEIV_HADJ_NIL =   0;  /* step unchanged     */
public static final int GSL_ODEIV_HADJ_DEC = (-1); /* step decreased     */

/* General step size control methods.
 *
 * The hadjust() method controls the adjustment of
 * step size given the result of a step and the error.
 * Valid hadjust() methods must return one of the codes below.
 * errlevel function calculates the desired error level D0.
 *
 * The general data can be used by specializations
 * to store state and control their heuristics.
 */

public static native gsl_odeiv2_control gsl_odeiv2_control_alloc(@Const gsl_odeiv2_control_type T);
public static native int gsl_odeiv2_control_init(gsl_odeiv2_control c, double eps_abs,
                             double eps_rel, double a_y, double a_dydt);
public static native void gsl_odeiv2_control_free(gsl_odeiv2_control c);
public static native int gsl_odeiv2_control_hadjust(gsl_odeiv2_control c, gsl_odeiv2_step s,
                                @Const DoublePointer y, @Const DoublePointer yerr,
                                @Const DoublePointer dydt, DoublePointer h);
public static native int gsl_odeiv2_control_hadjust(gsl_odeiv2_control c, gsl_odeiv2_step s,
                                @Const DoubleBuffer y, @Const DoubleBuffer yerr,
                                @Const DoubleBuffer dydt, DoubleBuffer h);
public static native int gsl_odeiv2_control_hadjust(gsl_odeiv2_control c, gsl_odeiv2_step s,
                                @Const double[] y, @Const double[] yerr,
                                @Const double[] dydt, double[] h);
public static native @Cast("const char*") BytePointer gsl_odeiv2_control_name(@Const gsl_odeiv2_control c);
public static native int gsl_odeiv2_control_errlevel(gsl_odeiv2_control c, double y,
                                 double dydt, double h,
                                 @Cast("const size_t") long ind, DoublePointer errlev);
public static native int gsl_odeiv2_control_errlevel(gsl_odeiv2_control c, double y,
                                 double dydt, double h,
                                 @Cast("const size_t") long ind, DoubleBuffer errlev);
public static native int gsl_odeiv2_control_errlevel(gsl_odeiv2_control c, double y,
                                 double dydt, double h,
                                 @Cast("const size_t") long ind, double[] errlev);
public static native int gsl_odeiv2_control_set_driver(gsl_odeiv2_control c,
                                   @Const gsl_odeiv2_driver d);

/* Available control object constructors.
 *
 * The standard control object is a four parameter heuristic
 * defined as follows:
 *    D0 = eps_abs + eps_rel * (a_y |y| + a_dydt h |y'|)
 *    D1 = |yerr|
 *    q  = consistency order of method (q=4 for 4(5) embedded RK)
 *    S  = safety factor (0.9 say)
 *
 *                      /  (D0/D1)^(1/(q+1))  D0 >= D1
 *    h_NEW = S h_OLD * |
 *                      \  (D0/D1)^(1/q)      D0 < D1
 *
 * This encompasses all the standard error scaling methods.
 *
 * The y method is the standard method with a_y=1, a_dydt=0.
 * The yp method is the standard method with a_y=0, a_dydt=1.
 */

public static native gsl_odeiv2_control gsl_odeiv2_control_standard_new(double eps_abs,
                                                     double eps_rel,
                                                     double a_y,
                                                     double a_dydt);
public static native gsl_odeiv2_control gsl_odeiv2_control_y_new(double eps_abs, double eps_rel);
public static native gsl_odeiv2_control gsl_odeiv2_control_yp_new(double eps_abs,
                                               double eps_rel);

/* This controller computes errors using different absolute errors for
 * each component
 *
 *    D0 = eps_abs * scale_abs[i] + eps_rel * (a_y |y| + a_dydt h |y'|)
 */

public static native gsl_odeiv2_control gsl_odeiv2_control_scaled_new(double eps_abs,
                                                   double eps_rel, double a_y,
                                                   double a_dydt,
                                                   @Const DoublePointer scale_abs,
                                                   @Cast("size_t") long dim);
public static native gsl_odeiv2_control gsl_odeiv2_control_scaled_new(double eps_abs,
                                                   double eps_rel, double a_y,
                                                   double a_dydt,
                                                   @Const DoubleBuffer scale_abs,
                                                   @Cast("size_t") long dim);
public static native gsl_odeiv2_control gsl_odeiv2_control_scaled_new(double eps_abs,
                                                   double eps_rel, double a_y,
                                                   double a_dydt,
                                                   @Const double[] scale_abs,
                                                   @Cast("size_t") long dim);
// Targeting ../gsl_odeiv2_evolve.java



/* Evolution object methods */

public static native gsl_odeiv2_evolve gsl_odeiv2_evolve_alloc(@Cast("size_t") long dim);
public static native int gsl_odeiv2_evolve_apply(gsl_odeiv2_evolve e, gsl_odeiv2_control con,
                             gsl_odeiv2_step step,
                             @Const gsl_odeiv2_system dydt, DoublePointer t,
                             double t1, DoublePointer h, DoublePointer y);
public static native int gsl_odeiv2_evolve_apply(gsl_odeiv2_evolve e, gsl_odeiv2_control con,
                             gsl_odeiv2_step step,
                             @Const gsl_odeiv2_system dydt, DoubleBuffer t,
                             double t1, DoubleBuffer h, DoubleBuffer y);
public static native int gsl_odeiv2_evolve_apply(gsl_odeiv2_evolve e, gsl_odeiv2_control con,
                             gsl_odeiv2_step step,
                             @Const gsl_odeiv2_system dydt, double[] t,
                             double t1, double[] h, double[] y);
public static native int gsl_odeiv2_evolve_apply_fixed_step(gsl_odeiv2_evolve e,
                                        gsl_odeiv2_control con,
                                        gsl_odeiv2_step step,
                                        @Const gsl_odeiv2_system dydt,
                                        DoublePointer t, double h0,
                                        DoublePointer y);
public static native int gsl_odeiv2_evolve_apply_fixed_step(gsl_odeiv2_evolve e,
                                        gsl_odeiv2_control con,
                                        gsl_odeiv2_step step,
                                        @Const gsl_odeiv2_system dydt,
                                        DoubleBuffer t, double h0,
                                        DoubleBuffer y);
public static native int gsl_odeiv2_evolve_apply_fixed_step(gsl_odeiv2_evolve e,
                                        gsl_odeiv2_control con,
                                        gsl_odeiv2_step step,
                                        @Const gsl_odeiv2_system dydt,
                                        double[] t, double h0,
                                        double[] y);
public static native int gsl_odeiv2_evolve_reset(gsl_odeiv2_evolve e);
public static native void gsl_odeiv2_evolve_free(gsl_odeiv2_evolve e);
public static native int gsl_odeiv2_evolve_set_driver(gsl_odeiv2_evolve e,
                                  @Const gsl_odeiv2_driver d);
// Targeting ../gsl_odeiv2_driver.java



/* Driver object methods */

public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_y_new(@Const gsl_odeiv2_system sys,
                                                  @Const gsl_odeiv2_step_type T, double hstart,
                                                  double epsabs,
                                                  double epsrel);
public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_yp_new(@Const gsl_odeiv2_system sys,
                                                   @Const gsl_odeiv2_step_type T, double hstart,
                                                   double epsabs,
                                                   double epsrel);
public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_scaled_new(@Const gsl_odeiv2_system sys,
                                                       @Const gsl_odeiv2_step_type T, double hstart,
                                                       double epsabs,
                                                       double epsrel,
                                                       double a_y,
                                                       double a_dydt,
                                                       @Const DoublePointer scale_abs);
public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_scaled_new(@Const gsl_odeiv2_system sys,
                                                       @Const gsl_odeiv2_step_type T, double hstart,
                                                       double epsabs,
                                                       double epsrel,
                                                       double a_y,
                                                       double a_dydt,
                                                       @Const DoubleBuffer scale_abs);
public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_scaled_new(@Const gsl_odeiv2_system sys,
                                                       @Const gsl_odeiv2_step_type T, double hstart,
                                                       double epsabs,
                                                       double epsrel,
                                                       double a_y,
                                                       double a_dydt,
                                                       @Const double[] scale_abs);
public static native gsl_odeiv2_driver gsl_odeiv2_driver_alloc_standard_new(@Const gsl_odeiv2_system sys,
                                                         @Const gsl_odeiv2_step_type T,
                                                         double hstart,
                                                         double epsabs,
                                                         double epsrel,
                                                         double a_y,
                                                         double a_dydt);
public static native int gsl_odeiv2_driver_set_hmin(gsl_odeiv2_driver d, double hmin);
public static native int gsl_odeiv2_driver_set_hmax(gsl_odeiv2_driver d, double hmax);
public static native int gsl_odeiv2_driver_set_nmax(gsl_odeiv2_driver d,
                                @Cast("const unsigned long int") long nmax);
public static native int gsl_odeiv2_driver_apply(gsl_odeiv2_driver d, DoublePointer t,
                             double t1, DoublePointer y);
public static native int gsl_odeiv2_driver_apply(gsl_odeiv2_driver d, DoubleBuffer t,
                             double t1, DoubleBuffer y);
public static native int gsl_odeiv2_driver_apply(gsl_odeiv2_driver d, double[] t,
                             double t1, double[] y);
public static native int gsl_odeiv2_driver_apply_fixed_step(gsl_odeiv2_driver d, DoublePointer t,
                                        double h,
                                        @Cast("const unsigned long int") long n,
                                        DoublePointer y);
public static native int gsl_odeiv2_driver_apply_fixed_step(gsl_odeiv2_driver d, DoubleBuffer t,
                                        double h,
                                        @Cast("const unsigned long int") long n,
                                        DoubleBuffer y);
public static native int gsl_odeiv2_driver_apply_fixed_step(gsl_odeiv2_driver d, double[] t,
                                        double h,
                                        @Cast("const unsigned long int") long n,
                                        double[] y);
public static native int gsl_odeiv2_driver_reset(gsl_odeiv2_driver d);
public static native int gsl_odeiv2_driver_reset_hstart(gsl_odeiv2_driver d, double hstart);
public static native void gsl_odeiv2_driver_free(gsl_odeiv2_driver state);
// #endif /* __GSL_ODEIV2_H__ */


// Parsed from gsl/gsl_odeiv.h

/* ode-initval/gsl_odeiv.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Author:  G. Jungman
 */
// #ifndef __GSL_ODEIV_H__
// #define __GSL_ODEIV_H__

// #include <stdio.h>
// #include <stdlib.h>
// #include <gsl/gsl_types.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif
// Targeting ../gsl_odeiv_system.java



// #define GSL_ODEIV_FN_EVAL(S,t,y,f)  (*((S)->function))(t,y,f,(S)->params)
// #define GSL_ODEIV_JA_EVAL(S,t,y,dfdy,dfdt)  (*((S)->jacobian))(t,y,dfdy,dfdt,(S)->params)
// Targeting ../gsl_odeiv_step_type.java


// Targeting ../gsl_odeiv_step.java




/* Available stepper types.
 *
 * rk2    : embedded 2nd(3rd) Runge-Kutta
 * rk4    : 4th order (classical) Runge-Kutta
 * rkck   : embedded 4th(5th) Runge-Kutta, Cash-Karp
 * rk8pd  : embedded 8th(9th) Runge-Kutta, Prince-Dormand
 * rk2imp : implicit 2nd order Runge-Kutta at Gaussian points
 * rk4imp : implicit 4th order Runge-Kutta at Gaussian points
 * gear1  : M=1 implicit Gear method
 * gear2  : M=2 implicit Gear method
 */

public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk2(); public static native void gsl_odeiv_step_rk2(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk4(); public static native void gsl_odeiv_step_rk4(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rkf45(); public static native void gsl_odeiv_step_rkf45(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rkck(); public static native void gsl_odeiv_step_rkck(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk8pd(); public static native void gsl_odeiv_step_rk8pd(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk2imp(); public static native void gsl_odeiv_step_rk2imp(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk2simp(); public static native void gsl_odeiv_step_rk2simp(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_rk4imp(); public static native void gsl_odeiv_step_rk4imp(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_bsimp(); public static native void gsl_odeiv_step_bsimp(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_gear1(); public static native void gsl_odeiv_step_gear1(gsl_odeiv_step_type setter);
public static native @Const gsl_odeiv_step_type gsl_odeiv_step_gear2(); public static native void gsl_odeiv_step_gear2(gsl_odeiv_step_type setter);


/* Constructor for specialized stepper objects.
 */
public static native gsl_odeiv_step gsl_odeiv_step_alloc(@Const gsl_odeiv_step_type T, @Cast("size_t") long dim);
public static native int gsl_odeiv_step_reset(gsl_odeiv_step s);
public static native void gsl_odeiv_step_free(gsl_odeiv_step s);

/* General stepper object methods.
 */
public static native @Cast("const char*") BytePointer gsl_odeiv_step_name(@Const gsl_odeiv_step s);
public static native @Cast("unsigned int") int gsl_odeiv_step_order(@Const gsl_odeiv_step s);

public static native int gsl_odeiv_step_apply(gsl_odeiv_step s, double t, double h, DoublePointer y, DoublePointer yerr, @Const DoublePointer dydt_in, DoublePointer dydt_out, @Const gsl_odeiv_system dydt);
public static native int gsl_odeiv_step_apply(gsl_odeiv_step s, double t, double h, DoubleBuffer y, DoubleBuffer yerr, @Const DoubleBuffer dydt_in, DoubleBuffer dydt_out, @Const gsl_odeiv_system dydt);
public static native int gsl_odeiv_step_apply(gsl_odeiv_step s, double t, double h, double[] y, double[] yerr, @Const double[] dydt_in, double[] dydt_out, @Const gsl_odeiv_system dydt);
// Targeting ../gsl_odeiv_control_type.java


// Targeting ../gsl_odeiv_control.java



/* Possible return values for an hadjust() evolution method.
 */  /* step was increased */  /* step unchanged     */ /* step decreased     */

public static native gsl_odeiv_control gsl_odeiv_control_alloc(@Const gsl_odeiv_control_type T);
public static native int gsl_odeiv_control_init(gsl_odeiv_control c, double eps_abs, double eps_rel, double a_y, double a_dydt);
public static native void gsl_odeiv_control_free(gsl_odeiv_control c);
public static native int gsl_odeiv_control_hadjust(gsl_odeiv_control c, gsl_odeiv_step s, @Const DoublePointer y, @Const DoublePointer yerr, @Const DoublePointer dydt, DoublePointer h);
public static native int gsl_odeiv_control_hadjust(gsl_odeiv_control c, gsl_odeiv_step s, @Const DoubleBuffer y, @Const DoubleBuffer yerr, @Const DoubleBuffer dydt, DoubleBuffer h);
public static native int gsl_odeiv_control_hadjust(gsl_odeiv_control c, gsl_odeiv_step s, @Const double[] y, @Const double[] yerr, @Const double[] dydt, double[] h);
public static native @Cast("const char*") BytePointer gsl_odeiv_control_name(@Const gsl_odeiv_control c);

/* Available control object constructors.
 *
 * The standard control object is a four parameter heuristic
 * defined as follows:
 *    D0 = eps_abs + eps_rel * (a_y |y| + a_dydt h |y'|)
 *    D1 = |yerr|
 *    q  = consistency order of method (q=4 for 4(5) embedded RK)
 *    S  = safety factor (0.9 say)
 *
 *                      /  (D0/D1)^(1/(q+1))  D0 >= D1
 *    h_NEW = S h_OLD * |
 *                      \  (D0/D1)^(1/q)      D0 < D1
 *
 * This encompasses all the standard error scaling methods.
 *
 * The y method is the standard method with a_y=1, a_dydt=0.
 * The yp method is the standard method with a_y=0, a_dydt=1.
 */

public static native gsl_odeiv_control gsl_odeiv_control_standard_new(double eps_abs, double eps_rel, double a_y, double a_dydt);
public static native gsl_odeiv_control gsl_odeiv_control_y_new(double eps_abs, double eps_rel);
public static native gsl_odeiv_control gsl_odeiv_control_yp_new(double eps_abs, double eps_rel);

/* This controller computes errors using different absolute errors for
 * each component
 *
 *    D0 = eps_abs * scale_abs[i] + eps_rel * (a_y |y| + a_dydt h |y'|)
 */
public static native gsl_odeiv_control gsl_odeiv_control_scaled_new(double eps_abs, double eps_rel, double a_y, double a_dydt, @Const DoublePointer scale_abs, @Cast("size_t") long dim);
public static native gsl_odeiv_control gsl_odeiv_control_scaled_new(double eps_abs, double eps_rel, double a_y, double a_dydt, @Const DoubleBuffer scale_abs, @Cast("size_t") long dim);
public static native gsl_odeiv_control gsl_odeiv_control_scaled_new(double eps_abs, double eps_rel, double a_y, double a_dydt, @Const double[] scale_abs, @Cast("size_t") long dim);
// Targeting ../gsl_odeiv_evolve.java



/* Evolution object methods.
 */
public static native gsl_odeiv_evolve gsl_odeiv_evolve_alloc(@Cast("size_t") long dim);
public static native int gsl_odeiv_evolve_apply(gsl_odeiv_evolve e, gsl_odeiv_control con, gsl_odeiv_step step, @Const gsl_odeiv_system dydt, DoublePointer t, double t1, DoublePointer h, DoublePointer y);
public static native int gsl_odeiv_evolve_apply(gsl_odeiv_evolve e, gsl_odeiv_control con, gsl_odeiv_step step, @Const gsl_odeiv_system dydt, DoubleBuffer t, double t1, DoubleBuffer h, DoubleBuffer y);
public static native int gsl_odeiv_evolve_apply(gsl_odeiv_evolve e, gsl_odeiv_control con, gsl_odeiv_step step, @Const gsl_odeiv_system dydt, double[] t, double t1, double[] h, double[] y);
public static native int gsl_odeiv_evolve_reset(gsl_odeiv_evolve e);
public static native void gsl_odeiv_evolve_free(gsl_odeiv_evolve e);

// #endif /* __GSL_ODEIV_H__ */


// Parsed from gsl/gsl_permute.h

// #ifndef __GSL_PERMUTE_H__
// #define __GSL_PERMUTE_H__

// #include <gsl/gsl_permute_complex_long_double.h>
// #include <gsl/gsl_permute_complex_double.h>
// #include <gsl/gsl_permute_complex_float.h>

// #include <gsl/gsl_permute_long_double.h>
// #include <gsl/gsl_permute_double.h>
// #include <gsl/gsl_permute_float.h>

// #include <gsl/gsl_permute_ulong.h>
// #include <gsl/gsl_permute_long.h>

// #include <gsl/gsl_permute_uint.h>
// #include <gsl/gsl_permute_int.h>

// #include <gsl/gsl_permute_ushort.h>
// #include <gsl/gsl_permute_short.h>

// #include <gsl/gsl_permute_uchar.h>
// #include <gsl/gsl_permute_char.h>

// #endif /* __GSL_PERMUTE_H__ */


// Parsed from gsl/gsl_permute_complex_double.h

/* permutation/gsl_permute_complex_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_COMPLEX_DOUBLE_H__
// #define __GSL_PERMUTE_COMPLEX_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_complex(@Cast("const size_t*") SizeTPointer p, DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex(@Cast("const size_t*") SizeTPointer p, DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex(@Cast("const size_t*") SizeTPointer p, double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_inverse(@Cast("const size_t*") SizeTPointer p, DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_inverse(@Cast("const size_t*") SizeTPointer p, DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_inverse(@Cast("const size_t*") SizeTPointer p, double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_COMPLEX_DOUBLE_H__ */


// Parsed from gsl/gsl_permute_complex_float.h

/* permutation/gsl_permute_complex_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_COMPLEX_FLOAT_H__
// #define __GSL_PERMUTE_COMPLEX_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_complex.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_complex_float(@Cast("const size_t*") SizeTPointer p, FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_float(@Cast("const size_t*") SizeTPointer p, FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_float(@Cast("const size_t*") SizeTPointer p, float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_float_inverse(@Cast("const size_t*") SizeTPointer p, FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_float_inverse(@Cast("const size_t*") SizeTPointer p, FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_complex_float_inverse(@Cast("const size_t*") SizeTPointer p, float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_COMPLEX_FLOAT_H__ */


// Parsed from gsl/gsl_permute_double.h

/* permutation/gsl_permute_double.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_DOUBLE_H__
// #define __GSL_PERMUTE_DOUBLE_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute(@Cast("const size_t*") SizeTPointer p, DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute(@Cast("const size_t*") SizeTPointer p, DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute(@Cast("const size_t*") SizeTPointer p, double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_inverse(@Cast("const size_t*") SizeTPointer p, DoublePointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_inverse(@Cast("const size_t*") SizeTPointer p, DoubleBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_inverse(@Cast("const size_t*") SizeTPointer p, double[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_DOUBLE_H__ */


// Parsed from gsl/gsl_permute_float.h

/* permutation/gsl_permute_float.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_FLOAT_H__
// #define __GSL_PERMUTE_FLOAT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_float(@Cast("const size_t*") SizeTPointer p, FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_float(@Cast("const size_t*") SizeTPointer p, FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_float(@Cast("const size_t*") SizeTPointer p, float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_float_inverse(@Cast("const size_t*") SizeTPointer p, FloatPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_float_inverse(@Cast("const size_t*") SizeTPointer p, FloatBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_float_inverse(@Cast("const size_t*") SizeTPointer p, float[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_FLOAT_H__ */


// Parsed from gsl/gsl_permute_ulong.h

/* permutation/gsl_permute_ulong.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_ULONG_H__
// #define __GSL_PERMUTE_ULONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_ulong(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned long*") CLongPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_ulong_inverse(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned long*") CLongPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_ULONG_H__ */


// Parsed from gsl/gsl_permute_long.h

/* permutation/gsl_permute_long.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_LONG_H__
// #define __GSL_PERMUTE_LONG_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_long(@Cast("const size_t*") SizeTPointer p, CLongPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_long_inverse(@Cast("const size_t*") SizeTPointer p, CLongPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_LONG_H__ */


// Parsed from gsl/gsl_permute_uint.h

/* permutation/gsl_permute_uint.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_UINT_H__
// #define __GSL_PERMUTE_UINT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_uint(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") IntPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_uint(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") IntBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_uint(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") int[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_uint_inverse(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") IntPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_uint_inverse(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") IntBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_uint_inverse(@Cast("const size_t*") SizeTPointer p, @Cast("unsigned int*") int[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_UINT_H__ */


// Parsed from gsl/gsl_permute_int.h

/* permutation/gsl_permute_int.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

// #ifndef __GSL_PERMUTE_INT_H__
// #define __GSL_PERMUTE_INT_H__

// #include <stdlib.h>
// #include <gsl/gsl_errno.h>
// #include <gsl/gsl_permutation.h>

// #undef __BEGIN_DECLS
// #undef __END_DECLS
// #ifdef __cplusplus
// # define __BEGIN_DECLS extern "C" {
// # define __END_DECLS }
// #else
// #endif

public static native int gsl_permute_int(@Cast("const size_t*") SizeTPointer p, IntPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_int(@Cast("const size_t*") SizeTPointer p, IntBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_int(@Cast("const size_t*") SizeTPointer p, int[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_int_inverse(@Cast("const size_t*") SizeTPointer p, IntPointer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_int_inverse(@Cast("const size_t*") SizeTPointer p, IntBuffer data, @Cast("const size_t") long stride, @Cast("const size_t") long n);
public static native int gsl_permute_int_inverse(@Cast("const size_t*") SizeTPointer p, int[] data, @Cast("const size_t") long stride, @Cast("const size_t") long n);

// #endif /* __GSL_PERMUTE_INT_H__ */


// Parsed from gsl/gsl_permute_ushort.h

/* permutation/gsl_permute_ushort.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000, 2007 Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software