// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class ArrayType
    \brief Class ArrayType inherits from DataType and provides wrappers for
     the HDF5's Array Datatypes.
*/
// Inheritance: DataType -> H5Object -> H5Location -> IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class ArrayType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ArrayType(Pointer p) { super(p); }

        // Constructor that creates a new array data type based on the
        // specified base type.
        public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongPointer dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
        private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongPointer dims);
        public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongBuffer dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
        private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") LongBuffer dims);
        public ArrayType(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") long[] dims) { super((Pointer)null); allocate(base_type, ndims, dims); }
        private native void allocate(@Const @ByRef DataType base_type, int ndims, @Cast("const hsize_t*") long[] dims);

        // Assignment operator
        public native @ByRef @Name("operator =") ArrayType put(@Const @ByRef ArrayType rhs);

        // Constructors that open an array datatype, given a location.
        public ArrayType(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name);
        public ArrayType(@Const @ByRef H5Location loc, String name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, String name);

        // Returns an ArrayType object via DataType* by decoding the
        // binary object description of this type.
        public native DataType decode();

        // Returns the number of dimensions of this array datatype.
        public native int getArrayNDims();
        //int getArrayNDims(); // removed 1.8.18 and 1.10.1

        // Returns the sizes of dimensions of this array datatype.
        public native int getArrayDims(@Cast("hsize_t*") LongPointer dims);
        public native int getArrayDims(@Cast("hsize_t*") LongBuffer dims);
        public native int getArrayDims(@Cast("hsize_t*") long[] dims);
        //int getArrayDims(hsize_t* dims); // removed 1.8.18 and 1.10.1

        /**\brief Returns this class name. */
        public native @StdString BytePointer fromClass();

        // Copy constructor: same as the original ArrayType.
        public ArrayType(@Const @ByRef ArrayType original) { super((Pointer)null); allocate(original); }
        private native void allocate(@Const @ByRef ArrayType original);

        // Constructor that takes an existing id
        public ArrayType(@Cast("const hid_t") long existing_id) { super((Pointer)null); allocate(existing_id); }
        private native void allocate(@Cast("const hid_t") long existing_id);

        // Noop destructor

        // Default constructor
        public ArrayType() { super((Pointer)null); allocate(); }
        private native void allocate();

}
