// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class AtomType
    \brief AtomType is a base class, inherited by IntType, FloatType,
     StrType, and PredType.
    <p>
    AtomType provides operations on HDF5 atomic datatypes.  It also inherits
    from DataType.
*/
// Inheritance: DataType -> H5Object -> H5Location -> IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class AtomType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AtomType(Pointer p) { super(p); }

    // Returns the byte order of an atomic datatype.
    public native @Cast("H5T_order_t") int getOrder();
    public native @Cast("H5T_order_t") int getOrder(@StdString @ByRef BytePointer order_string);

    // Sets the byte ordering of an atomic datatype.
    public native void setOrder(@Cast("H5T_order_t") int order);

    // Retrieves the bit offset of the first significant bit.
    // 12/05/00 - changed return type to int from size_t - C API
    public native int getOffset();

    // Sets the bit offset of the first significant bit.
    public native void setOffset(@Cast("size_t") long offset);

    // Retrieves the padding type of the least and most-significant bit padding.
    public native void getPad(@Cast("H5T_pad_t*") @ByRef IntPointer lsb, @Cast("H5T_pad_t*") @ByRef IntPointer msb);
    public native void getPad(@Cast("H5T_pad_t*") @ByRef IntBuffer lsb, @Cast("H5T_pad_t*") @ByRef IntBuffer msb);
    public native void getPad(@Cast("H5T_pad_t*") @ByRef int[] lsb, @Cast("H5T_pad_t*") @ByRef int[] msb);

    // Sets the least and most-significant bits padding types
    public native void setPad(@Cast("H5T_pad_t") int lsb, @Cast("H5T_pad_t") int msb);

    // Returns the precision of an atomic datatype.
    public native @Cast("size_t") long getPrecision();

    // Sets the precision of an atomic datatype.
    public native void setPrecision(@Cast("size_t") long precision);

    // Sets the total size for an atomic datatype.
    public native void setSize(@Cast("size_t") long size);

    /**\brief Returns this class name. */
    public native @StdString @Override BytePointer fromClass();

// #ifndef DOXYGEN_SHOULD_SKIP_THIS
    // Copy constructor: same as the original AtomType.
    public AtomType(@Const @ByRef AtomType original) { super((Pointer)null); allocate(original); }
    private native void allocate(@Const @ByRef AtomType original);

    // Noop destructor

}
