// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5.global;

import org.bytedeco.hdf5.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class hdf5 extends org.bytedeco.hdf5.presets.hdf5 {
    static { Loader.load(); }

// Parsed from H5pubconf.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* H5pubconf.h  Generated By CMake during the configuration */

// #ifndef H5_CONFIG_H_
// #define H5_CONFIG_H_

/* Define if the Windows virtual file driver should be compiled */
public static final int H5_HAVE_WINDOWS = 1;

/* Define if using MinGW */
/* #undef H5_HAVE_MINGW */

/* Define if on the Windows platform and default WIN32 API */
public static final int H5_HAVE_WIN32_API = 1;

/* Define if using a Windows compiler (i.e. Visual Studio) */
public static final int H5_HAVE_VISUAL_STUDIO = 1;

/* Define the default plugins path to compile */
public static final String H5_DEFAULT_PLUGINDIR = "%ALLUSERSPROFILE%\\hdf5\\lib\\plugin";

/* Define if dev_t is a scalar */
/* #undef H5_DEV_T_IS_SCALAR */

/* Define if your system is IBM ppc64le and cannot convert some long double
   values correctly. */
/* #undef H5_DISABLE_SOME_LDOUBLE_CONV */

/* Define to dummy `main' function (if any) required to link to the Fortran
   libraries. */
/* #undef H5_FC_DUMMY_MAIN */

/* Define if F77 and FC dummy `main' functions are identical. */
/* #undef H5_FC_DUMMY_MAIN_EQ_F77 */

/* Define to a macro mangling the given C identifier (in lower and upper
   case), which must not contain underscores, for linking with Fortran. */
// #define H5_FC_FUNC(name,NAME) name ## _

/* As FC_FUNC, but for C identifiers containing underscores. */
// #define H5_FC_FUNC_(name,NAME) name ## _

/* Define if Fortran C_LONG_DOUBLE is different from C_DOUBLE */
// #define H5_FORTRAN_C_LONG_DOUBLE_IS_UNIQUE 

/* Define if we have Fortran C_LONG_DOUBLE */
// #define H5_FORTRAN_HAVE_C_LONG_DOUBLE 

/* Define if we have Fortran intrinsic C_SIZEOF */
/* #undef H5_FORTRAN_HAVE_C_SIZEOF */

/* Define if we have Fortran intrinsic SIZEOF */
/* #undef H5_FORTRAN_HAVE_SIZEOF */

/* Define if we have Fortran intrinsic STORAGE_SIZE */
/* #undef H5_FORTRAN_HAVE_STORAGE_SIZE */

/* Determine the size of C long double */
/* #undef H5_FORTRAN_SIZEOF_LONG_DOUBLE */

/* Define Fortran compiler ID */
// #define H5_Fortran_COMPILER_ID 

/* Define number of valid Fortran INTEGER KINDs (must be defined before F_IKIND)*/
/* #undef H5_H5CONFIG_F_NUM_IKIND */

/* Define valid Fortran INTEGER KINDs */
/* #undef H5_H5CONFIG_F_IKIND */

/* Define number of valid Fortran REAL KINDs (must be defined before F_RKIND) */
/* #undef H5_H5CONFIG_F_NUM_RKIND */

/* Define valid Fortran REAL KINDs */
/* #undef H5_H5CONFIG_F_RKIND */

/* Define valid Fortran REAL KINDs Sizeof */
/* #undef H5_H5CONFIG_F_RKIND_SIZEOF */

/* Define to 1 if you have the `alarm' function. */
/* #undef H5_HAVE_ALARM */

/* Define to 1 if you have the <arpa/inet.h> header file. */
/* #undef H5_HAVE_ARPA_INET_H */

/* Define to 1 if you have the `asprintf' function. */
/* #undef H5_HAVE_ASPRINTF */

/* Define if the __attribute__(()) extension is present */
/* #undef H5_HAVE_ATTRIBUTE */

/* Define if the compiler understands C99 designated initialization of structs
   and unions */
/* #undef H5_HAVE_C99_DESIGNATED_INITIALIZER */

/* Define if the compiler understands the __func__ keyword */
/* #undef H5_HAVE_C99_FUNC */

/* Define to 1 if you have the `clock_gettime' function. */
/* #undef H5_HAVE_CLOCK_GETTIME */

/* Define if the function stack tracing code is to be compiled in */
/* #undef H5_HAVE_CODESTACK */

/* Define to 1 if you have the <curl/curl.h> header file. */
/* #undef H5_HAVE_CURL_CURL_H */

/* Define if Darwin or Mac OS X */
/* #undef H5_HAVE_DARWIN */

/* Define to 1 if you have the `difftime' function. */
public static final int H5_HAVE_DIFFTIME = 1;

/* Define if the direct I/O virtual file driver (VFD) should be compiled */
/* #undef H5_HAVE_DIRECT */

/* Define to 1 if you have the <dirent.h> header file. */
/* #undef H5_HAVE_DIRENT_H */

/* Define to 1 if you have the <dlfcn.h> header file. */
/* #undef H5_HAVE_DLFCN_H */

/* Define to 1 if you have the <dmalloc.h> header file. */
/* #undef H5_HAVE_DMALLOC_H */

/* Define if library information should be embedded in the executables */
public static final int H5_HAVE_EMBEDDED_LIBINFO = 1;

/* Define to 1 if you have the `fcntl' function. */
/* #undef H5_HAVE_FCNTL */

/* Define to 1 if you have the <features.h> header file. */
/* #undef H5_HAVE_FEATURES_H */

/* Define if support for deflate (zlib) filter is enabled */
public static final int H5_HAVE_FILTER_DEFLATE = 1;

/* Define if support for szip filter is enabled */
/* #undef H5_HAVE_FILTER_SZIP */

/* Determine if __float128 is available */
/* #undef H5_HAVE_FLOAT128 */

/* Define to 1 if you have the `flock' function. */
/* #undef H5_HAVE_FLOCK */

/* Define to 1 if you have the `fork' function. */
/* #undef H5_HAVE_FORK */

/* Define to 1 if you have the `frexpf' function. */
/* #undef H5_HAVE_FREXPF */

/* Define to 1 if you have the `frexpl' function. */
/* #undef H5_HAVE_FREXPL */

/* Define to 1 if you have the `fseeko' function. */
/* #undef H5_HAVE_FSEEKO */

/* Define if the compiler understands the __FUNCTION__ keyword */
public static final int H5_HAVE_FUNCTION = 1;

/* Determine if INTEGER*16 is available */
/* #undef H5_HAVE_Fortran_INTEGER_SIZEOF_16 */

/* Define to 1 if you have the `GetConsoleScreenBufferInfo' function. */
public static final int H5_HAVE_GETCONSOLESCREENBUFFERINFO = 1;

/* Define to 1 if you have the `gethostname' function. */
public static final int H5_HAVE_GETHOSTNAME = 1;

/* Define to 1 if you have the `getpwuid' function. */
/* #undef H5_HAVE_GETPWUID */

/* Define to 1 if you have the `getrusage' function. */
/* #undef H5_HAVE_GETRUSAGE */

/* Define to 1 if you have the `gettextinfo' function. */
/* #undef H5_HAVE_GETTEXTINFO */

/* Define to 1 if you have the `gettimeofday' function. */
public static final int H5_HAVE_GETTIMEOFDAY = 1;

/* Define to 1 if you have the <hdfs.h> header file. */
/* #undef H5_HAVE_HDFS_H */

/* Define if the compiler understands inline */
public static final int H5_HAVE_INLINE = 1;

/* Define if parallel library will contain instrumentation to detect correct
   optimization operation */
/* #undef H5_HAVE_INSTRUMENTED_LIBRARY */

/* Define to 1 if you have the <inttypes.h> header file. */
public static final int H5_HAVE_INTTYPES_H = 1;

/* Define to 1 if you have the `ioctl' function. */
/* #undef H5_HAVE_IOCTL */

/* Define to 1 if you have the <io.h> header file. */
public static final int H5_HAVE_IO_H = 1;

/* Define to 1 if you have the `crypto' library (-lcrypto). */
/* #undef H5_HAVE_LIBCRYPTO */

/* Define to 1 if you have the `curl' library (-lcurl). */
/* #undef H5_HAVE_LIBCURL */

/* Define to 1 if you have the `dl' library (-ldl). */
/* #undef H5_HAVE_LIBDL */

/* Define to 1 if you have the `dmalloc' library (-ldmalloc). */
/* #undef H5_HAVE_LIBDMALLOC */

/* Proceed to build with libhdfs */
/* #undef H5_HAVE_LIBHDFS */

/* Define to 1 if you have the `jvm' library (-ljvm). */
/* #undef H5_HAVE_LIBJVM */

/* Define to 1 if you have the `m' library (-lm). */
public static final int H5_HAVE_LIBM = 1;

/* Define to 1 if you have the `mpe' library (-lmpe). */
/* #undef H5_HAVE_LIBMPE */

/* Define to 1 if you have the `pthread' library (-lpthread). */
/* #undef H5_HAVE_LIBPTHREAD */

/* Define to 1 if you have the `sz' library (-lsz). */
/* #undef H5_HAVE_LIBSZ */

/* Define to 1 if you have the `ws2_32' library (-lws2_32). */
public static final int H5_HAVE_LIBWS2_32 = 1;

/* Define to 1 if you have the `z' library (-lz). */
public static final int H5_HAVE_LIBZ = 1;

/* Define to 1 if you have the `llround' function. */
public static final int H5_HAVE_LLROUND = 1;

/* Define to 1 if you have the `llroundf' function. */
public static final int H5_HAVE_LLROUNDF = 1;

/* Define to 1 if you have the `longjmp' function. */
public static final int H5_HAVE_LONGJMP = 1;

/* Define to 1 if you have the `lround' function. */
public static final int H5_HAVE_LROUND = 1;

/* Define to 1 if you have the `lroundf' function. */
public static final int H5_HAVE_LROUNDF = 1;

/* Define to 1 if you have the `lseek64' function. */
/* #undef H5_HAVE_LSEEK64 */

/* Define to 1 if you have the `lstat' function. */
/* #undef H5_HAVE_LSTAT */

/* Define if the map API (H5M) should be compiled */
/* #undef H5_HAVE_MAP_API */

/* Define to 1 if you have the <memory.h> header file. */
public static final int H5_HAVE_MEMORY_H = 1;

/* Define whether the Mirror virtual file driver (VFD) will be compiled */
/* #undef H5_HAVE_MIRROR_VFD */

/* Define if we have MPE support */
/* #undef H5_HAVE_MPE */

/* Define to 1 if you have the <mpe.h> header file. */
/* #undef H5_HAVE_MPE_H */

/* Define if MPI_Comm_c2f and MPI_Comm_f2c exist */
/* #undef H5_HAVE_MPI_MULTI_LANG_Comm */

/* Define if MPI_Info_c2f and MPI_Info_f2c exist */
/* #undef H5_HAVE_MPI_MULTI_LANG_Info */

/* Define to 1 if you have the <netdb.h> header file. */
/* #undef H5_HAVE_NETDB_H */

/* Define to 1 if you have the <netinet/in.h> header file. */
/* #undef H5_HAVE_NETINET_IN_H */

/* Define to 1 if you have the <openssl/evp.h> header file. */
/* #undef H5_HAVE_OPENSSL_EVP_H */

/* Define to 1 if you have the <openssl/hmac.h> header file. */
/* #undef H5_HAVE_OPENSSL_HMAC_H */

/* Define to 1 if you have the <openssl/sha.h> header file. */
/* #undef H5_HAVE_OPENSSL_SHA_H */

/* Define if we have parallel support */
/* #undef H5_HAVE_PARALLEL */

/* Define if we have support for writing to filtered datasets in parallel */
/* #undef H5_HAVE_PARALLEL_FILTERED_WRITES */

/* Define if both pread and pwrite exist. */
/* #undef H5_HAVE_PREADWRITE */

/* Define to 1 if you have the <pthread.h> header file. */
/* #undef H5_HAVE_PTHREAD_H */

/* Define to 1 if you have the <pwd.h> header file. */
/* #undef H5_HAVE_PWD_H */

/* Define to 1 if you have the <quadmath.h> header file. */
/* #undef H5_HAVE_QUADMATH_H */

/* Define to 1 if you have the `random' function. */
/* #undef H5_HAVE_RANDOM */

/* Define to 1 if you have the `rand_r' function. */
/* #undef H5_HAVE_RAND_R */

/* Define whether the Read-Only S3 virtual file driver (VFD) should be
   compiled */
/* #undef H5_HAVE_ROS3_VFD */

/* Define to 1 if you have the `round' function. */
public static final int H5_HAVE_ROUND = 1;

/* Define to 1 if you have the `roundf' function. */
public static final int H5_HAVE_ROUNDF = 1;

/* Define to 1 if you have the `setjmp' function. */
public static final int H5_HAVE_SETJMP = 1;

/* Define to 1 if you have the <setjmp.h> header file. */
public static final int H5_HAVE_SETJMP_H = 1;

/* Define to 1 if you have the `setsysinfo' function. */
/* #undef H5_HAVE_SETSYSINFO */

/* Define to 1 if you have the `siglongjmp' function. */
/* #undef H5_HAVE_SIGLONGJMP */

/* Define to 1 if you have the `signal' function. */
public static final int H5_HAVE_SIGNAL = 1;

/* Define to 1 if you have the `sigprocmask' function. */
/* #undef H5_HAVE_SIGPROCMASK */

/* Define to 1 if you have the `sigsetjmp' function. */
/* #undef H5_HAVE_SIGSETJMP */

/* Define to 1 if you have the `snprintf' function. */
/* #undef H5_HAVE_SNPRINTF */

/* Define to 1 if you have the `srandom' function. */
/* #undef H5_HAVE_SRANDOM */

/* Define to 1 if you have the `stat64' function. */
/* #undef H5_HAVE_STAT64 */

/* Define if struct stat has the st_blocks field */
/* #undef H5_HAVE_STAT_ST_BLOCKS */

/* Define to 1 if you have the <stdbool.h> header file. */
public static native @MemberGetter int H5_HAVE_STDBOOL_H();
public static final int H5_HAVE_STDBOOL_H = H5_HAVE_STDBOOL_H();

/* Define to 1 if you have the <stddef.h> header file. */
public static final int H5_HAVE_STDDEF_H = 1;

/* Define to 1 if you have the <stdint.h> header file. */
public static final int H5_HAVE_STDINT_H = 1;

/* Define to 1 if you have the <stdint.h> header file for Cplusplus. */
/* #undef H5_HAVE_STDINT_H_CXX */

/* Define to 1 if you have the <stdlib.h> header file. */
public static final int H5_HAVE_STDLIB_H = 1;

/* Define to 1 if you have the `strdup' function. */
public static final int H5_HAVE_STRDUP = 1;

/* Define to 1 if you have the <strings.h> header file. */
/* #undef H5_HAVE_STRINGS_H */

/* Define to 1 if you have the <string.h> header file. */
public static final int H5_HAVE_STRING_H = 1;

/* Define to 1 if you have the `strtoll' function. */
public static final int H5_HAVE_STRTOLL = 1;

/* Define to 1 if you have the `strtoull' function. */
public static final int H5_HAVE_STRTOULL = 1;

/* Define if struct text_info is defined */
/* #undef H5_HAVE_STRUCT_TEXT_INFO */

/* Define if struct videoconfig is defined */
/* #undef H5_HAVE_STRUCT_VIDEOCONFIG */

/* Define to 1 if you have the `symlink' function. */
/* #undef H5_HAVE_SYMLINK */

/* Define to 1 if you have the `system' function. */
public static final int H5_HAVE_SYSTEM = 1;

/* Define to 1 if you have the <sys/file.h> header file. */
/* #undef H5_HAVE_SYS_FILE_H */

/* Define to 1 if you have the <sys/ioctl.h> header file. */
/* #undef H5_HAVE_SYS_IOCTL_H */

/* Define to 1 if you have the <sys/resource.h> header file. */
/* #undef H5_HAVE_SYS_RESOURCE_H */

/* Define to 1 if you have the <sys/socket.h> header file. */
/* #undef H5_HAVE_SYS_SOCKET_H */

/* Define to 1 if you have the <sys/stat.h> header file. */
public static final int H5_HAVE_SYS_STAT_H = 1;

/* Define to 1 if you have the <sys/time.h> header file. */
/* #undef H5_HAVE_SYS_TIME_H */

/* Define to 1 if you have the <sys/types.h> header file. */
public static final int H5_HAVE_SYS_TYPES_H = 1;

/* Define to 1 if you have the <szlib.h> header file. */
/* #undef H5_HAVE_SZLIB_H */

// #if defined(_WIN32) && !defined(H5_BUILT_AS_DYNAMIC_LIB)
/* Not supported on WIN32 platforms with static linking */
/* #undef H5_HAVE_THREADSAFE */
// #else
/* Define if we have thread safe support */
/* #undef H5_HAVE_THREADSAFE */
// #endif

/* Define if timezone is a global variable */
public static final int H5_HAVE_TIMEZONE = 1;

/* Define if the ioctl TIOCGETD is defined */
/* #undef H5_HAVE_TIOCGETD */

/* Define if the ioctl TIOGWINSZ is defined */
/* #undef H5_HAVE_TIOCGWINSZ */

/* Define to 1 if you have the `tmpfile' function. */
public static final int H5_HAVE_TMPFILE = 1;

/* Define if tm_gmtoff is a member of struct tm */
/* #undef H5_HAVE_TM_GMTOFF */

/* Define to 1 if you have the <unistd.h> header file. */
/* #undef H5_HAVE_UNISTD_H */

/* Define to 1 if you have the `vasprintf' function. */
/* #undef H5_HAVE_VASPRINTF */

/* Define to 1 if you have the `vsnprintf' function. */
/* #undef H5_HAVE_VSNPRINTF */

/* Define to 1 if you have the `waitpid' function. */
/* #undef H5_HAVE_WAITPID */

/* Define to 1 if you have the 'InitOnceExecuteOnce' function. */
/* #undef H5_HAVE_WIN_THREADS */

/* Define if your system has window style path name. */
public static final int H5_HAVE_WINDOW_PATH = 1;

/* Define to 1 if you have the <winsock2.h> header file. */
public static final int H5_HAVE_WINSOCK2_H = 1;

/* Define to 1 if you have the <zlib.h> header file. */
public static final int H5_HAVE_ZLIB_H = 1;

/* Define to 1 if you have the `_getvideoconfig' function. */
/* #undef H5_HAVE__GETVIDEOCONFIG */

/* Define to 1 if you have the `_scrsize' function. */
/* #undef H5_HAVE__SCRSIZE */

/* Define if the compiler understands __inline */
public static final int H5_HAVE___INLINE = 1;

/* Define if the compiler understands __inline__ */
/* #undef H5_HAVE___INLINE__ */

/* Define if the library will ignore file locks when disabled */
public static final int H5_IGNORE_DISABLED_FILE_LOCKS = 1;

/* Define if the high-level library headers should be included in hdf5.h */
public static final int H5_INCLUDE_HL = 1;

/* Define if new-style references should be used with dimension scales */
/* #undef H5_DIMENSION_SCALES_WITH_NEW_REF */

/* Define if your system can convert long double to (unsigned) long long
   values correctly. */
public static final int H5_LDOUBLE_TO_LLONG_ACCURATE = 1;

/* Define if your system converts long double to (unsigned) long values with
   special algorithm. */
/* #undef H5_LDOUBLE_TO_LONG_SPECIAL */

/* Define if your system can convert (unsigned) long long to long double
   values correctly. */
public static final int H5_LLONG_TO_LDOUBLE_CORRECT = 1;

/* Define if your system can convert (unsigned) long to long double values
   with special algorithm. */
/* #undef H5_LONG_TO_LDOUBLE_SPECIAL */

/* Define to the sub-directory where libtool stores uninstalled libraries. */
/* #undef H5_LT_OBJDIR */

/* Define to enable internal memory allocation sanity checking. */
/* #undef H5_MEMORY_ALLOC_SANITY_CHECK */

/* Define if we can violate pointer alignment restrictions */
public static final int H5_NO_ALIGNMENT_RESTRICTIONS = 1;

/* Define if deprecated public API symbols are disabled */
/* #undef H5_NO_DEPRECATED_SYMBOLS */

/* Name of package */
public static final String H5_PACKAGE = "hdf5";

/* Define to the address where bug reports for this package should be sent. */
public static final String H5_PACKAGE_BUGREPORT = "help@hdfgroup.org";

/* Define to the full name of this package. */
public static final String H5_PACKAGE_NAME = "HDF5";

/* Define to the full name and version of this package. */
public static final String H5_PACKAGE_STRING = "HDF5 1.12.2";

/* Define to the one symbol short name of this package. */
public static final String H5_PACKAGE_TARNAME = "hdf5";

/* Define to the home page for this package. */
public static final String H5_PACKAGE_URL = "http://www.hdfgroup.org";

/* Define to the version of this package. */
public static final String H5_PACKAGE_VERSION = "1.12.2";

/* Determine the maximum decimal precision in C */
public static final int H5_PAC_C_MAX_REAL_PRECISION = 0;

/* Define Fortran Maximum Real Decimal Precision */
// #define H5_PAC_FC_MAX_REAL_PRECISION 

/* Width for printf() for type `long long' or `__int64', use `ll' */
public static final String H5_PRINTF_LL_WIDTH = "I64";

/* The size of `bool', as computed by sizeof. */
public static final int H5_SIZEOF_BOOL = 1;

/* The size of `char', as computed by sizeof. */
public static final int H5_SIZEOF_CHAR = 1;

/* The size of `double', as computed by sizeof. */
public static final int H5_SIZEOF_DOUBLE = 8;

/* The size of `float', as computed by sizeof. */
public static final int H5_SIZEOF_FLOAT = 4;

/* The size of `int', as computed by sizeof. */
public static final int H5_SIZEOF_INT = 4;

/* The size of `int16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT16_T = 2;

/* The size of `int32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT32_T = 4;

/* The size of `int64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT64_T = 8;

/* The size of `int8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT8_T = 1;

/* The size of `int_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST16_T = 4;

/* The size of `int_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST32_T = 4;

/* The size of `int_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST64_T = 8;

/* The size of `int_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_FAST8_T = 1;

/* The size of `int_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST16_T = 2;

/* The size of `int_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST32_T = 4;

/* The size of `int_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST64_T = 8;

/* The size of `int_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_INT_LEAST8_T = 1;

// #if !defined(__APPLE__)

/* The size of `size_t', as computed by sizeof. */
public static final int H5_SIZEOF_SIZE_T = 4;

/* The size of `ssize_t', as computed by sizeof. */
/* #undef H5_SIZEOF_SSIZE_T */

/* The size of `long', as computed by sizeof. */
public static final int H5_SIZEOF_LONG = 4;

/* The size of `long double', as computed by sizeof. */
public static final int H5_SIZEOF_LONG_DOUBLE = 8;

// #else

  /* On Apple, to support Universal Binaries (where multiple CPU
     architectures exist in one library/executable), we can't assume
     the machine doing the compiling has the same endianness or type
     sizes as all the various architectures (PowerPC, Intel, ARM). */

//   # if defined(__LP64__) && __LP64__
  public static final int H5_SIZEOF_SSIZE_T = 8;
//   # else
//   # endif

//   # if defined(__i386__) || defined(__x86_64__)
//   # elif defined(__aarch64__)
//   # else
//   # endif

// #endif

/* Define size of long long and/or __int64 bit integer type only if the type
   exists.  */
// #if !defined(__APPLE__)
 public static final int H5_SIZEOF_LONG_LONG = 8;
// #else
// #endif

/* The size of `off64_t', as computed by sizeof. */
/* #undef H5_SIZEOF_OFF64_T */

/* The size of `off_t', as computed by sizeof. */
public static final int H5_SIZEOF_OFF_T = 4;

/* The size of `ptrdiff_t', as computed by sizeof. */
/* #undef H5_SIZEOF_PTRDIFF_T */

/* The size of `short', as computed by sizeof. */
public static final int H5_SIZEOF_SHORT = 2;

/* The size of `time_t', as computed by sizeof. */
public static final int H5_SIZEOF_TIME_T = 8;

/* The size of `uint16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT16_T = 2;

/* The size of `uint32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT32_T = 4;

/* The size of `uint64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT64_T = 8;

/* The size of `uint8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT8_T = 1;

/* The size of `uint_fast16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST16_T = 4;

/* The size of `uint_fast32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST32_T = 4;

/* The size of `uint_fast64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST64_T = 8;

/* The size of `uint_fast8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_FAST8_T = 1;

/* The size of `uint_least16_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST16_T = 2;

/* The size of `uint_least32_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST32_T = 4;

/* The size of `uint_least64_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST64_T = 8;

/* The size of `uint_least8_t', as computed by sizeof. */
public static final int H5_SIZEOF_UINT_LEAST8_T = 1;

/* The size of `unsigned', as computed by sizeof. */
public static final int H5_SIZEOF_UNSIGNED = 4;

/* The size of `_Quad', as computed by sizeof. */
public static final int H5_SIZEOF__QUAD = 0;

/* The size of `__float128', as computed by sizeof. */
public static final int H5_SIZEOF___FLOAT128 = 0;

/* The size of `__int64', as computed by sizeof. */
public static final int H5_SIZEOF___INT64 = 8;

/* Define to 1 if you have the ANSI C header files. */
public static final int H5_STDC_HEADERS = 1;

/* Define if strict file format checks are enabled */
/* #undef H5_STRICT_FORMAT_CHECKS */

/* Define if your system supports pthread_attr_setscope(&attribute,
   PTHREAD_SCOPE_SYSTEM) call. */
/* #undef H5_SYSTEM_SCOPE_THREADS */

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
/* #undef H5_TIME_WITH_SYS_TIME */

/* Define using v1.6 public API symbols by default */
/* #undef H5_USE_16_API_DEFAULT */

/* Define using v1.8 public API symbols by default */
/* #undef H5_USE_18_API_DEFAULT */

/* Define using v1.10 public API symbols by default */
/* #undef H5_USE_110_API_DEFAULT */

/* Define using v1.12 public API symbols by default */
public static final int H5_USE_112_API_DEFAULT = 1;

/* Define if the library will use file locking */
public static final int H5_USE_FILE_LOCKING = 1;

/* Define if the library will use recursive RW locks for thread safety */
/* #undef H5_USE_RECURSIVE_RW_LOCKS */

/* Define if a memory checking tool will be used on the library, to cause
   library to be very picky about memory operations and also disable the
   internal free list manager code. */
/* #undef H5_USING_MEMCHECKER */

/* Version number of package */
public static final String H5_VERSION = "1.12.2";

/* Data accuracy is preferred to speed during data conversions */
public static final int H5_WANT_DATA_ACCURACY = 1;

/* Check exception handling functions during data conversions */
public static final int H5_WANT_DCONV_EXCEPTION = 1;

/* Define WORDS_BIGENDIAN to 1 if your processor stores words with the most
   significant byte first (like Motorola and SPARC, unlike Intel). */
// #if !defined(__APPLE__)
// # ifndef WORDS_BIGENDIAN
// #  undef WORDS_BIGENDIAN
// # endif
// #else
// # if defined __BIG_ENDIAN__
public static final int WORDS_BIGENDIAN = 1;
// # endif
// #endif

/* #undef WORDS_BIGENDIAN */

/* Number of bits in a file offset, on hosts where this is settable. */
/* #undef H5__FILE_OFFSET_BITS */

/* Define for large files, on AIX-style hosts. */
/* #undef H5__LARGE_FILES */

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef H5_const */

/* Define to `long int' if <sys/types.h> does not define. */
/* #undef H5_off_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ptrdiff_t */

/* Define to `unsigned long' if <sys/types.h> does not define. */
/* #undef H5_size_t */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef H5_ssize_t */

// #endif


// Parsed from H5public.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the HDF5 module.
 */
// #ifndef H5public_H
// #define H5public_H

/* Include files for public use... */
/*
 * Since H5pubconf.h is a generated header file, it is messy to try
 * to put a #ifndef H5pubconf_H ... #endif guard in it.
 * HDF5 has set an internal rule that it is being included here.
 * Source files should NOT include H5pubconf.h directly but include
 * it via H5public.h.  The #ifndef H5public_H guard above would
 * prevent repeated include.
 */
// #include "H5pubconf.h" /* From configure */

/* API Version macro wrapper definitions */
// #include "H5version.h"

// #ifdef H5_HAVE_FEATURES_H
// #include <features.h> /* For setting POSIX, BSD, etc. compatibility */
// #endif
// #ifdef H5_HAVE_SYS_TYPES_H
// #include <sys/types.h>
// #endif
// #ifdef H5_STDC_HEADERS
// #include <limits.h> /* For H5T_NATIVE_CHAR defn in H5Tpublic.h  */
// #include <stdarg.h> /* For variadic functions in H5VLpublic.h   */
// #endif
// #ifndef __cplusplus
// #ifdef H5_HAVE_STDINT_H
// #include <stdint.h> /* For C9x types */
// #endif
// #else
// #ifdef H5_HAVE_STDINT_H_CXX
// #include <stdint.h> /* For C9x types (when included from C++) */
// #endif
// #endif
// #ifdef H5_HAVE_INTTYPES_H
// #include <inttypes.h> /* C99/POSIX.1 header for uint64_t, PRIu64 */
// #endif
// #ifdef H5_HAVE_STDDEF_H
// #include <stddef.h>
// #endif

// #ifdef H5_HAVE_PARALLEL
// #endif

/* Macros for enabling/disabling particular GCC warnings */
/* (see the following web-sites for more info:
 *      http://www.dbp-consulting.com/tutorials/SuppressingGCCWarnings.html
 *      http://gcc.gnu.org/onlinedocs/gcc/Diagnostic-Pragmas.html#Diagnostic-Pragmas
 */
/* These pragmas are only implemented usefully in gcc 4.6+ */
// #if ((__GNUC__ * 100) + __GNUC_MINOR__) >= 406
// #else
// #define H5_GCC_DIAG_OFF(x)
// #define H5_GCC_DIAG_ON(x)
// #endif

/* Version numbers */
/**
 * For major interface/format changes
 */
public static final int H5_VERS_MAJOR = 1;
/**
 * For minor interface/format changes
 */
public static final int H5_VERS_MINOR = 12;
/**
 * For tweaks, bug-fixes, or development
 */
public static final int H5_VERS_RELEASE = 2;
/**
 * For pre-releases like \c snap0. Empty string for official releases.
 */
public static final String H5_VERS_SUBRELEASE = "";
/**
 * Full version string
 */
public static final String H5_VERS_INFO = "HDF5 library version: 1.12.2";

// #define H5check() H5check_version(H5_VERS_MAJOR, H5_VERS_MINOR, H5_VERS_RELEASE)

/* macros for comparing the version */
/**
 * \brief Determines whether the version of the library being used is greater
 *        than or equal to the specified version
 *
 * @param Maj [in] Major version number - A non-negative integer value
 * @param Min [in] Minor version number - A non-negative integer value
 * @param Rel [in] Release version number - A non-negative integer value
 * @return A value of 1 is returned if the library version is greater than
 *          or equal to the version number specified.\n
 *          A value of 0 is returned if the library version is less than the
 *          version number specified.\n
 *          A library version is greater than the specified version number if
 *          its major version is larger than the specified major version
 *          number. If the major version numbers are the same, it is greater
 *          than the specified version number if its minor version is larger
 *          than the specified minor version number. If the minor version
 *          numbers are the same, then a library version would be greater than
 *          the specified version number if its release number is larger than
 *          the specified release number.
 *
 * \details The #H5_VERSION_GE and #H5_VERSION_LE macros are used at compile
 *          time to conditionally include or exclude code based on the version
 *          of the HDF5 library against which an application will be linked.
 *
 *          The #H5_VERSION_GE macro compares the version of the HDF5 library
 *          being used against the version number specified in the parameters.
 *
 *          For more information about release versioning, see \ref_h5lib_relver.
 *
 * @since 1.8.7
 *
 */
// #define H5_VERSION_GE(Maj, Min, Rel)
//     (((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR == Min) && (H5_VERS_RELEASE >= Rel)) ||
//      ((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR > Min)) || (H5_VERS_MAJOR > Maj))

/**
 * \brief Determines whether the version of the library being used is less
 *        than or equal to the specified version
 *
 * @param Maj [in] Major version number - A non-negative integer value
 * @param Min [in] Minor version number - A non-negative integer value
 * @param Rel [in] Release version number - A non-negative integer value
 * @return A value of 1 is returned if the library version is less than
 *          or equal to the version number specified.\n
 *          A value of 0 is returned if the library version is greater than the
 *          version number specified.\n
 *          A library version is less than the specified version number if
 *          its major version is smaller than the specified major version
 *          number. If the major version numbers are the same, it is smaller
 *          than the specified version number if its minor version is smaller
 *          than the specified minor version number. If the minor version
 *          numbers are the same, then a library version would be smaller than
 *          the specified version number if its release number is smaller than
 *          the specified release number.
 *
 * \details The #H5_VERSION_GE and #H5_VERSION_LE macros are used at compile
 *          time to conditionally include or exclude code based on the version
 *          of the HDF5 library against which an application will be linked.
 *
 *          The #H5_VERSION_LE macro compares the version of the HDF5 library
 *          being used against the version number specified in the parameters.
 *
 *          For more information about release versioning, see \ref_h5lib_relver.
 *
 * @since 1.8.7
 *
 */
// #define H5_VERSION_LE(Maj, Min, Rel)
//     (((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR == Min) && (H5_VERS_RELEASE <= Rel)) ||
//      ((H5_VERS_MAJOR == Maj) && (H5_VERS_MINOR < Min)) || (H5_VERS_MAJOR < Maj))

/**
 * Status return values.  Failed integer functions in HDF5 result almost
 * always in a negative value (unsigned failing functions sometimes return
 * zero for failure) while successful return is non-negative (often zero).
 * The negative failure value is most commonly -1, but don't bet on it.
 *
 * The proper way to detect failure is something like:
 * <pre>{@code
 * if((dset = H5Dopen2(file, name)) < 0)
 *    fprintf(stderr, "unable to open the requested dataset\n");
 * }</pre>
 */

/**
 * Boolean type.  Successful return values are zero (false) or positive
 * (true). The typical true value is 1 but don't bet on it.  Boolean
 * functions cannot fail.  Functions that return #htri_t however return zero
 * (false), positive (true), or negative (failure). The proper way to test
 * for truth from a #htri_t function is:
 * <pre>{@code
 * if ((retval = H5Tcommitted(type)) > 0) {
 *     printf("data type is committed\n");
 * } else if (!retval) {
 *     printf("data type is not committed\n");
 * } else {
 *     printf("error determining whether data type is committed\n");
 * }
 * }</pre>
 */
// #ifdef H5_HAVE_STDBOOL_H
// #include <stdbool.h>
// #else /* H5_HAVE_STDBOOL_H */
// #endif /* H5_HAVE_STDBOOL_H */

/* The signed version of size_t
 *
 * ssize_t is POSIX and not defined in any C standard. It's used in some
 * public HDF5 API calls so this work-around will define it if it's not
 * present.
 *
 * Use of ssize_t should be discouraged in new code.
 */
// #if H5_SIZEOF_SSIZE_T == 0
/* Undefine this size, we will re-define it in one of the sections below */
// #undef H5_SIZEOF_SSIZE_T
// #if H5_SIZEOF_SIZE_T == H5_SIZEOF_INT
// #elif H5_SIZEOF_SIZE_T == H5_SIZEOF_LONG
// #elif H5_SIZEOF_SIZE_T == H5_SIZEOF_LONG_LONG
// #else /* Can't find matching type for ssize_t */
// #error "nothing appropriate for ssize_t"
// #endif
// #endif

/**
 * The size of file objects.
 *
 * \internal Defined as a (minimum) 64-bit integer type.
 */
// #if H5_SIZEOF_INT64_T >= 8
// #elif H5_SIZEOF_INT >= 8
// #undef H5_SIZEOF_INT64_T
// #elif H5_SIZEOF_LONG >= 8
// #undef H5_SIZEOF_INT64_T
// #elif H5_SIZEOF_LONG_LONG >= 8
// #undef H5_SIZEOF_INT64_T
// #else
// #error "nothing appropriate for int64_t"
// #endif

/* uint64_t type is used for fields for H5O_info_t.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT64_T >= 8
// #ifndef UINT64_MAX
public static final long UINT64_MAX = ((long)-1);
// #endif
// #elif H5_SIZEOF_INT >= 8
// #undef H5_SIZEOF_UINT64_T
// #elif H5_SIZEOF_LONG >= 8
// #undef H5_SIZEOF_UINT64_T
// #elif H5_SIZEOF_LONG_LONG >= 8
// #undef H5_SIZEOF_UINT64_T
// #else
// #error "nothing appropriate for uint64_t"
// #endif

/**
 * The size of file objects. Used when negative values are needed to indicate errors.
 *
 * \internal Defined as a (minimum) 64-bit integer type. Use of hssize_t
 * should be discouraged in new code.
 */
// #if H5_SIZEOF_LONG_LONG >= 8
public static final String PRIdHSIZE =          H5_PRINTF_LL_WIDTH +  "d";
public static final String PRIiHSIZE =          H5_PRINTF_LL_WIDTH +  "i";
public static final String PRIoHSIZE =          H5_PRINTF_LL_WIDTH +  "o";
public static final String PRIuHSIZE =          H5_PRINTF_LL_WIDTH +  "u";
public static final String PRIxHSIZE =          H5_PRINTF_LL_WIDTH +  "x";
public static final String PRIXHSIZE =          H5_PRINTF_LL_WIDTH +  "X";
public static final int H5_SIZEOF_HSIZE_T =  H5_SIZEOF_LONG_LONG;
public static final int H5_SIZEOF_HSSIZE_T = H5_SIZEOF_LONG_LONG;
public static native @MemberGetter int HSIZE_UNDEF();
public static final int HSIZE_UNDEF = HSIZE_UNDEF();
// #else
// #error "nothing appropriate for hsize_t"
// #endif

// #ifdef H5_HAVE_PARALLEL
// #endif

/**
 * The address of an object in the file.
 *
 * \internal Defined as a (minimum) 64-bit unsigned integer type.
 */
// #if H5_SIZEOF_INT >= 8
public static native @MemberGetter int HADDR_UNDEF();
public static final int HADDR_UNDEF = HADDR_UNDEF();
public static final int H5_SIZEOF_HADDR_T = H5_SIZEOF_INT;
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */
public static final String PRIdHADDR = "d";
public static final String PRIoHADDR = "o";
public static final String PRIuHADDR = "u";
public static final String PRIxHADDR = "x";
public static final String PRIXHADDR = "X";
// #elif H5_SIZEOF_LONG >= 8
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */
// #elif H5_SIZEOF_LONG_LONG >= 8
// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */
// #else
// #error "nothing appropriate for haddr_t"
// #endif
public static final String H5_PRINTF_HADDR_FMT = "%" +  PRIuHADDR;
public static final int HADDR_MAX =           (HADDR_UNDEF - 1);

/* uint32_t type is used for creation order field for messages.  It may be
 * defined in Posix.1g, otherwise it is defined here.
 */
// #if H5_SIZEOF_UINT32_T >= 4
// #elif H5_SIZEOF_SHORT >= 4
// #undef H5_SIZEOF_UINT32_T
// #elif H5_SIZEOF_INT >= 4
// #undef H5_SIZEOF_UINT32_T
// #elif H5_SIZEOF_LONG >= 4
// #undef H5_SIZEOF_UINT32_T
// #else
// #error "nothing appropriate for uint32_t"
// #endif

/** <!-- [H5_iter_order_t_snip] -->
/**
 * Common iteration orders
 */
/** enum H5_iter_order_t */
public static final int
    /** Unknown order */
    H5_ITER_UNKNOWN = -1,
    /** Increasing order */
    H5_ITER_INC = 0,
    /** Decreasing order */
    H5_ITER_DEC = 1,
    /** No particular order, whatever is fastest */
    H5_ITER_NATIVE = 2,
    /** Number of iteration orders */
    H5_ITER_N = 3;
/** <!-- [H5_iter_order_t_snip] --> */

/* Iteration callback values */
/* (Actually, any positive value will cause the iterator to stop and pass back
 *      that positive value to the function that called the iterator)
 */
/** Error, stop iteration */
public static final int H5_ITER_ERROR = (-1);
/** Continue iteration */
public static final int H5_ITER_CONT =  (0);
/** Stop iteration, short-circuit success */
public static final int H5_ITER_STOP =  (1);

/** <!-- [H5_index_t_snip] -->
/**
 * The types of indices on links in groups/attributes on objects.
 * Primarily used for "<do> <foo> by index" routines and for iterating over
 * links in groups/attributes on objects.
 */
/** enum H5_index_t */
public static final int
    /** Unknown index type                   */
    H5_INDEX_UNKNOWN = -1,
    /** Index on names                       */
    H5_INDEX_NAME = 0,
    /** Index on creation order              */
    H5_INDEX_CRT_ORDER = 1,
    /** Number of indices defined            */
    H5_INDEX_N = 2;
// Targeting ..\H5_ih_info_t.java


/** <!-- [H5_ih_info_t_snip] -->
<p>
/**
 * The maximum size allowed for tokens
 * \details Tokens are unique and permanent identifiers that are
 *          used to reference HDF5 objects in a container. This allows
 *          for 128-bit tokens
 */
public static final int H5O_MAX_TOKEN_SIZE = (16);
// Targeting ..\H5O_token_t.java


// Targeting ..\H5_alloc_stats_t.java



/* API adapter header (defines H5_DLL, etc.) */
// #include "H5api_adpt.h"

// #ifdef __cplusplus
// #endif

/* Functions in H5.c */
/**
 * \ingroup H5
 * \brief Initializes the HDF5 library
 * @return \herr_t
 *
 * \details H5open() initializes the HDF5 library.
 *
 * \details When the HDF5 library is used in a C application, the library is
 *          automatically initialized when the first HDf5 function call is
 *          issued. If one finds that an HDF5 library function is failing
 *          inexplicably, H5open() can be called first. It is safe to call
 *          H5open() before an application issues any other function calls to
 *          the HDF5 library as there are no damaging side effects in calling
 *          it more than once.
 */
public static native @Cast("herr_t") int H5open();
/**
 * \ingroup H5
 * \brief Flushes all data to disk, closes all open objects, and releases memory
 * @return \herr_t
 *
 * \details H5close() flushes all data to disk, closes all open HDF5 objects,
 *          and cleans up all memory used by the HDF5 library. This function is
 *          generally called when the application calls exit(), but may be
 *          called earlier in the event of an emergency shutdown or out of a
 *          desire to free all resources used by the HDF5 library.
 */
public static native @Cast("herr_t") int H5close();
/**
 * \ingroup H5
 * \brief Instructs library not to install atexit() cleanup routine
 * @return \herr_t
 *
 * \details H5dont_atexit() indicates to the library that an atexit() cleanup
 *          routine should not be installed. The major purpose for using this
 *          function is in situations where the library is dynamically linked
 *          into an application and is un-linked from the application before
 *          exit() gets called. In those situations, a routine installed with
 *          atexit() would jump to a routine which was no longer in memory,
 *          causing errors.
 *
 * \attention In order to be effective, this routine \Emph{must} be called
 *            before any other HDF5 function calls, and must be called each
 *            time the library is loaded/linked into the application (the first
 *            time and after it's been un-loaded).
 */
public static native @Cast("herr_t") int H5dont_atexit();
/**
 * \ingroup H5
 * \brief Garbage collects on all free-lists of all types
 * @return \herr_t
 *
 * \details H5garbage_collect() walks through all garbage collection routines
 *          of the library, freeing any unused memory.
 *
 *          It is not required that H5garbage_collect() be called at any
 *          particular time; it is only necessary in certain situations where
 *          the application has performed actions that cause the library to
 *          allocate many objects. The application should call
 *          H5garbage_collect() if it eventually releases those objects and
 *          wants to reduce the memory used by the library from the peak usage
 *          required.
 *
 * \note The library automatically garbage collects all the free lists when the
 *       application ends.
 */
public static native @Cast("herr_t") int H5garbage_collect();
/**
 * \ingroup H5
 * \brief Sets free-list size limits
 *
 * @param reg_global_lim [in] The cumulative limit, in bytes, on memory used for
 *                           all regular free lists (Default: 1MB)
 * @param reg_list_lim [in] The limit, in bytes, on memory used for each regular
 *                         free list (Default: 64KB)
 * @param arr_global_lim [in] The cumulative limit, in bytes, on memory used for
 *                           all array free lists (Default: 4MB)
 * @param arr_list_lim [in] The limit, in bytes, on memory used for each array
 *                         free list (Default: 256KB)
 * @param blk_global_lim [in] The cumulative limit, in bytes, on memory used for
 *                           all block free lists and, separately, for all
 *                           factory free lists (Default: 16MB)
 * @param blk_list_lim [in] The limit, in bytes, on memory used for each block
 *                         or factory free list (Default: 1MB)
 * @return \herr_t
 *
 * \details H5set_free_list_limits() sets size limits on all types of free
 *          lists. The HDF5 library uses free lists internally to manage
 *          memory. The types of free lists used are as follows:
 *          \li Regular free lists manage memory for single internal data
 *              structures.
 *          \li Array free lists manage memory for arrays of internal
 *              data structures.
 *          \li Block free lists manage memory for arbitrarily-sized blocks
 *              of bytes.
 *          \li Factory free lists manage memory for fixed-size blocks of
 *              bytes.
 *
 *          The parameters specify global and per-list limits; for example, \p
 *          reg_global_limit and \p reg_list_limit limit the accumulated size
 *          of all regular free lists and the size of each individual regular
 *          free list, respectively. Therefore, if an application sets a 1Mb
 *          limit on each of the global lists, up to 4Mb of total storage might
 *          be allocated, 1Mb for each of the regular, array, block, and
 *          factory type lists.
 *
 *          The settings specified for block free lists are duplicated for
 *          factory free lists. Therefore, increasing the global limit on block
 *          free lists by x bytes will increase the potential free list memory
 *          usage by 2x bytes.
 *
 *          Using a value of -1 for a limit means that no limit is set for the
 *          specified type of free list.
 *
 * @version 1.8.3 Function changed in this release to set factory free list
 *                memory limits.
 *
 * @since 1.6.0
 */
public static native @Cast("herr_t") int H5set_free_list_limits(int reg_global_lim, int reg_list_lim, int arr_global_lim,
                                     int arr_list_lim, int blk_global_lim, int blk_list_lim);
/**
 * \ingroup H5
 * \brief Gets the current size of the free lists used to manage memory
 *
 * @param reg_size [out] The current size of all "regular" free list memory used
 * @param arr_size [out] The current size of all "array" free list memory used
 * @param blk_size [out] The current size of all "block" free list memory used
 * @param fac_size [out] The current size of all "factory" free list memory used
 * @return \herr_t
 *
 * \details H5get_free_list_sizes() obtains the current size of the different
 *          kinds of free lists that the library uses to manage memory. The
 *          free list sizes can be set with H5set_free_list_limits() and
 *          garbage collected with H5garbage_collect(). These lists are global
 *          for the entire library.
 *
 * @since 1.10.7
 */
public static native @Cast("herr_t") int H5get_free_list_sizes(@Cast("size_t*") SizeTPointer reg_size, @Cast("size_t*") SizeTPointer arr_size, @Cast("size_t*") SizeTPointer blk_size, @Cast("size_t*") SizeTPointer fac_size);
/**
 * \ingroup H5
 * \brief Gets the memory allocation statistics for the library
 *
 * @param stats [out] Memory allocation statistics
 * @return \herr_t
 *
 * \details H5get_alloc_stats() gets the memory allocation statistics for the
 *          library, if the \c --enable-memory-alloc-sanity-check option was
 *          given when building the library. Applications can check whether
 *          this option was enabled detecting if the
 *          \c H5_MEMORY_ALLOC_SANITY_CHECK macro is defined. This option is
 *          enabled by default for debug builds of the library and disabled by
 *          default for non-debug builds. If the option is not enabled, all the
 *          values returned with be 0. These statistics are global for the
 *          entire library, but do not include allocations from chunked dataset
 *          I/O filters or non-native VOL connectors.
 *
 * @since 1.10.7
 */
public static native @Cast("herr_t") int H5get_alloc_stats(H5_alloc_stats_t stats);
/**
 * \ingroup H5
 * \brief Returns the HDF library release number
 *
 * @param majnum [out] The major version number of the library
 * @param minnum [out] The minor version number of the library
 * @param relnum [out] The release version number of the library
 * @return \herr_t
 *
 * \details H5get_libversion() retrieves the major, minor, and release numbers
 *          of the version of the HDF5 library which is linked to the
 *          application.
 *
 */
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntPointer majnum, @Cast("unsigned*") IntPointer minnum, @Cast("unsigned*") IntPointer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") IntBuffer majnum, @Cast("unsigned*") IntBuffer minnum, @Cast("unsigned*") IntBuffer relnum);
public static native @Cast("herr_t") int H5get_libversion(@Cast("unsigned*") int[] majnum, @Cast("unsigned*") int[] minnum, @Cast("unsigned*") int[] relnum);
/**
 * \ingroup H5
 * \brief Verifies that HDF5 library versions are consistent
 *
 * @param majnum [in] HDF5 library major version number
 * @param minnum [in] HDF5 library minor version number
 * @param relnum [in] HDF5 library release number
 * @return \herr_t
 *
 * \details H5check_version() verifies that the version of the HDF5 library
 *          with which an application was compiled, as indicated by the passed
 *          parameters, matches the version of the HDF5 library against which
 *          the application is currently linked.
 *
 *          \p majnum is the major version number of the HDF library with which
 *          the application was compiled, \p minnum is the minor version
 *          number, and \p relnum is the release number. Consider the following
 *          example:
 *
 *          An official HDF5 release is labelled as follows:
 *          HDF5 Release \Code{\<majnum\>.\<minnum\>.\<relnum\>}\n
 *          For example, in HDF5 Release 1.8.5:
 *          \li 1 is the major version number, \p majnum.
 *          \li 8 is the minor version number, \p minnum.
 *          \li 5 is the release number, \p relnum.
 *
 *          As stated above, H5check_version() first verifies that the version
 *          of the HDF5 library with which an application was compiled matches
 *          the version of the HDF5 library against which the application is
 *          currently linked. If this check fails, H5check_version() causes the
 *          application to abort (by means of a standard C abort() call) and
 *          prints information that is usually useful for debugging. This
 *          precaution is is taken to avoid the risks of data corruption or
 *          segmentation faults.
 *
 *          The most common cause of this failure is that an application was
 *          compiled with one version of HDF5 and is dynamically linked with a
 *          different version different version.
 *
 *          If the above test passes, H5check_version() proceeds to verify the
 *          consistency of additional library version information. This is
 *          designed to catch source code inconsistencies that do not normally
 *          cause failures; if this check reveals an inconsistency, an
 *          informational warning is printed but the application is allowed to
 *          run.
 *
 */
public static native @Cast("herr_t") int H5check_version(@Cast("unsigned") int majnum, @Cast("unsigned") int minnum, @Cast("unsigned") int relnum);
/**
 * \ingroup H5
 * \brief Determines whether the HDF5 library was built with the thread-safety
 *        feature enabled
 *
 * @param is_ts [out] Boolean value indicating whether the library was built
 *                   with thread-safety enabled
 * @return \herr_t
 *
 * \details The HDF5 library, although not internally multi-threaded, can be
 *          built with a thread-safety feature enabled that protects internal
 *          data structures with a mutex. In certain circumstances, it may be
 *          useful to determine, at run-time, whether the linked HDF5 library
 *          was built with the thread-safety feature enabled.
 */
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") BoolPointer is_ts);
public static native @Cast("herr_t") int H5is_library_threadsafe(@Cast("hbool_t*") boolean[] is_ts);
/**
 * \ingroup H5
 * \brief Frees memory allocated by the HDF5 library
 *
 * @param mem [in] Buffer to be freed. Can be NULL
 * @return \herr_t
 *
 * \details H5free_memory() frees memory that has been allocated by the caller
 *          with H5allocate_memory() or by the HDF5 library on behalf of the
 *          caller.
 *
 *          H5Tget_member_name() provides an example of memory allocation on
 *          behalf of the caller: The function returns a buffer containing the
 *          name of a compound datatype member. It is the caller’s
 *          responsibility to eventually free that buffer with H5free_memory().
 *
 * \attention It is especially important to use this function to free memory
 *            allocated by the library on Windows. The C standard library is
 *            implemented in dynamic link libraries (DLLs) known as the C
 *            run-time (CRT). Each version of Visual Studio comes with two CRT
 *            DLLs (debug and release) and allocating and freeing across DLL
 *            boundaries can cause resource leaks and subtle bugs due to heap
 *            corruption.\n
 *            Only use this function to free memory allocated by the HDF5
 *            Library. It will generally not be safe to use this function to
 *            free memory allocated by any other means.\n
 *            Even when using this function, it is still best to ensure that
 *            all components of a C application are built with the same version
 *            of Visual Studio and build (debug or release) and thus linked
 *            against the same CRT.
 *
 * @see H5allocate_memory(), H5resize_memory()
 *
 * @since 1.8.13
 *
 */
public static native @Cast("herr_t") int H5free_memory(Pointer mem);
/**
 * \ingroup H5
 * \brief Frees memory allocated by the HDF5 library
 *
 * @param size [in] The size in bytes of the buffer to be allocated
 * @param clear [in] Flag whether the new buffer is to be initialized with 0
 *
 * @return On success, returns pointer to newly allocated buffer or returns
 *         NULL if size is 0 (zero).\n
 *         Returns NULL on failure.
 *
 * \details H5allocate_memory() allocates a memory buffer of size bytes that
 *          will later be freed internally by the HDF5 library.
 *
 *          The boolean \p clear parameter specifies whether the buffer should
 *          be initialized. If clear is \c TRUE, all bits in the buffer are to be
 *          set to 0 (zero); if clear is \c FALSE, the buffer will not be
 *          initialized.
 *
 *          This function is intended to have the semantics of malloc() and
 *          calloc(). However, unlike malloc() and calloc() which allow for a
 *          "special" pointer to be returned instead of NULL, this function
 *          always returns NULL on failure or when size is set to 0 (zero).
 *
 * \note At this time, the only intended use for this function is to allocate
 *       memory that will be returned to the library as a data buffer from a
 *       third-party filter.
 *
 * \attention To avoid heap corruption, allocated memory should be freed using
 *            the same library that initially allocated it. In most cases, the
 *            HDF5 API uses resources that are allocated and freed either
 *            entirely by the user or entirely by the library, so this is not a
 *            problem. In rare cases, however, HDF5 API calls will free memory
 *            that the user allocated. This function allows the user to safely
 *            allocate this memory.\n
 *            It is particularly important to use this function to allocate
 *            memory in Microsoft Windows environments. In Windows, the C
 *            standard library is implemented in dynamic link libraries (DLLs)
 *            known as the C run-time (CRT). Each version of Visual Studio
 *            comes with multiple versions of the CRT DLLs (debug, release, et
 *            cetera) and allocating and freeing memory across DLL boundaries
 *            can cause resource leaks and subtle bugs due to heap corruption.\n
 *            Even when using this function, it is best where possible to
 *            ensure that all components of a C application are built with the
 *            same version of Visual Studio and configuration (Debug or
 *            Release), and thus linked against the same CRT.\n
 *            Use this function only to allocate memory inside third-party HDF5
 *            filters. It will generally not be safe to use this function to
 *            allocate memory for any other purpose.
 *
 * @see H5free_memory(), H5resize_memory()
 *
 * @since 1.8.15
 *
 */
public static native Pointer H5allocate_memory(@Cast("size_t") long size, @Cast("hbool_t") boolean clear);
/**
 * \ingroup H5
 * \brief Resizes and, if required, re-allocates memory that will later be
 *        freed internally by the HDF5 library
 *
 * @param mem [in] Pointer to a buffer to be resized. May be NULL
 * @param size [in] New size of the buffer, in bytes
 <p>
 *
 * @return On success, returns pointer to resized or reallocated buffer
 *         or returns NULL if size is 0 (zero).\n
 *         Returns NULL on failure.
 *
 * \details H5resize_memory() takes a pointer to an existing buffer and resizes
 *          the buffer to match the value in \p size. If necessary, the buffer
 *          is reallocated. If \p size is 0, the buffer is released.
 *
 *          The input buffer must either be NULL or have been allocated by
 *          H5allocate_memory() since the input buffer may be freed by the
 *          library.
 *
 *          For certain behaviors, the pointer \p mem may be passed in as NULL.
 *
 *          This function is intended to have the semantics of realloc():
 *
 *          <table>
 *            <tr><td>\Code{H5resize_memory(buffer, size)}</td>
 *                <td>Resizes buffer. Returns pointer to resized buffer.</td></tr>
 *            <tr><td>\Code{H5resize_memory(NULL, size)}</td>
 *                <td>Allocates memory using HDF5 Library allocator.
 *                    Returns pointer to new buffer</td></tr>
 *            <tr><td>\Code{H5resize_memory(buffer, 0)}</td>
 *                <td>Frees memory using HDF5 Library allocator.
 *                    Returns NULL.</td></tr>
 *            <tr><td>\Code{H5resize_memory(NULL, 0)}</td>
 *                <td>Returns NULL (undefined in C standard).</td></tr>
 *          </table>
 *
 *          Unlike realloc(), which allows for a "special pointer to be
 *          returned instead of NULL, this function always returns NULL on
 *          failure or when size is 0 (zero).
 *
 * \note At this time, the only intended use for this function is to resize or
 *       reallocate memory that will be returned to the library (and eventually
 *       to the user) as a data buffer from a third-party HDF5 filter.
 *
 * \attention To avoid heap corruption, allocated memory should be freed using
 *            the same library that initially allocated it. In most cases, the
 *            HDF5 API uses resources that are allocated and freed either
 *            entirely by the user or entirely by the library, so this is not a
 *            problem. In rare cases, however, HDF5 API calls will free memory
 *            that the user allocated. This function allows the user to safely
 *            allocate this memory.\n
 *            It is particularly important to use this function to resize
 *            memory on Microsoft Windows systems. In Windows, the C standard
 *            library is implemented in dynamic link libraries (DLLs) known as
 *            the C run-time (CRT). Each version of Visual Studio comes with
 *            multiple versions of the CRT DLLs (debug, release, et cetera) and
 *            allocating and freeing memory across DLL boundaries can cause
 *            resource leaks and subtle bugs due to heap corruption.\n
 *            Even when using this function, it is still best to ensure that
 *            all components of a C application are built with the same version
 *            of Visual Studio and the same configuration (Debug or Release),
 *            and thus linked against the same CRT.\n
 *            Only use this function to resize memory inside third-party HDF5
 *            filters. It will generally not be safe to use this function to
 *            resize memory for any other purpose.
 *
 * @see H5allocate_memory(), H5free_memory()
 *
 * @since 1.8.15
 *
 */
public static native Pointer H5resize_memory(Pointer mem, @Cast("size_t") long size);

// #ifdef __cplusplus
// #endif
// #endif /* H5public_H */


// Parsed from H5Cpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:	H5Cpublic.h
 *              June 4, 2005
 *              John Mainzer
 *
 * Purpose:     Public include file for cache functions.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5Cpublic_H
// #define H5Cpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/** enum H5C_cache_incr_mode */
public static final int
    
/**Automatic cache size increase is disabled, and the remaining increment fields are ignored.*/
    H5C_incr__off = 0,

    
/**Automatic cache size increase is enabled using the hit rate threshold algorithm.*/
    H5C_incr__threshold = 1;

/** enum H5C_cache_flash_incr_mode */
public static final int
    
/**Flash cache size increase is disabled.*/
    H5C_flash_incr__off = 0,

    
/**Flash cache size increase is enabled using the add space algorithm.*/
    H5C_flash_incr__add_space = 1;

/** enum H5C_cache_decr_mode */
public static final int
    
/**Automatic cache size decrease is disabled.*/
    H5C_decr__off = 0,

    
/**Automatic cache size decrease is enabled  using the hit rate threshold algorithm.*/
    H5C_decr__threshold = 1,

    
/**Automatic cache size decrease is enabled using the ageout algorithm. */
    H5C_decr__age_out = 2,

    
/**Automatic cache size decrease is enabled using the ageout with hit rate threshold algorithm.*/
    H5C_decr__age_out_with_threshold = 3;

// #endif


// Parsed from H5Ipublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in
 * the H5I module.
 */
// #ifndef H5Ipublic_H
// #define H5Ipublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/**
 * Library type values.
 * \internal Library type values.  Start with {@code 1' instead of }0' because it
 *           makes the tracing output look better when hid_t values are large
 *           numbers. Change the TYPE_BITS in H5I.c if the MAXID gets larger
 *           than 32 (an assertion will fail otherwise).
 *
 *           When adding types here, add a section to the 'misc19' test in
 *           test/tmisc.c to verify that the H5I{inc|dec|get}_ref() routines
 *           work correctly with it. \endinternal
 */
/** <!-- [H5I_type_t_snip] --> */
/** enum H5I_type_t */
public static final int
    /** uninitialized type                        */
    H5I_UNINIT = (-2),
    /** invalid Type                              */
    H5I_BADID  = (-1),
    /** type ID for File objects                  */
    H5I_FILE   = 1,
    /** type ID for Group objects                 */
    H5I_GROUP = 2,
    /** type ID for Datatype objects              */
    H5I_DATATYPE = 3,
    /** type ID for Dataspace objects             */
    H5I_DATASPACE = 4,
    /** type ID for Dataset objects               */
    H5I_DATASET = 5,
    /** type ID for Map objects                   */
    H5I_MAP = 6,
    /** type ID for Attribute objects             */
    H5I_ATTR = 7,
    /** type ID for virtual file layer            */
    H5I_VFL = 8,
    /** type ID for virtual object layer          */
    H5I_VOL = 9,
    /** type ID for generic property list classes */
    H5I_GENPROP_CLS = 10,
    /** type ID for generic property lists        */
    H5I_GENPROP_LST = 11,
    /** type ID for error classes                 */
    H5I_ERROR_CLASS = 12,
    /** type ID for error messages                */
    H5I_ERROR_MSG = 13,
    /** type ID for error stacks                  */
    H5I_ERROR_STACK = 14,
    /** type ID for dataspace selection iterator  */
    H5I_SPACE_SEL_ITER = 15,
    /** number of library types, MUST BE LAST!    */
    H5I_NTYPES = 16;
/** <!-- [H5I_type_t_snip] -->
<p>
/**
 * Type of IDs to return to users
 */

// #define PRIdHID PRId64
// #define PRIxHID PRIx64
// #define PRIXHID PRIX64
// #define PRIoHID PRIo64

/**
 * The size of identifiers
 */
public static final int H5_SIZEOF_HID_T = H5_SIZEOF_INT64_T;

/**
 * An invalid object ID. This is also negative for error return.
 */
public static final int H5I_INVALID_HID = (-1);
// Targeting ..\H5I_free_t.java


// Targeting ..\H5I_search_func_t.java


// Targeting ..\H5I_iterate_func_t.java


/** <!-- [H5I_iterate_func_t_snip] --> */

// #ifdef __cplusplus
// #endif

/* Public API functions */

/**
 * \ingroup H5IUD
 *
 * \brief Registers an object under a type and returns an ID for it
 *
 * @param type [in] The identifier of the type of the new ID
 * @param object [in] Pointer to object for which a new ID is created
 *
 * @return \hid_t{object}
 *
 * \details H5Iregister() creates and returns a new ID for an object.
 *
 * \details The \p type parameter is the identifier for the ID type to which
 *          this new ID will belong. This identifier must have been created by
 *          a call to H5Iregister_type().
 *
 * \details The \p object parameter is a pointer to the memory which the new ID
 *          will be a reference to. This pointer will be stored by the library
 *          and returned via a call to H5Iobject_verify().
 *
 */
public static native @Cast("hid_t") long H5Iregister(@Cast("H5I_type_t") int type, @Const Pointer object);
/**
 * \ingroup H5IUD
 *
 * \brief Returns the object referenced by an ID
 *
 * @param id [in] ID to be dereferenced
 * @param type [in] The identifier type
 <p>
 *
 * @return Pointer to the object referenced by \p id on success, NULL on failure.
 *
 * \details H5Iobject_verify() returns a pointer to the memory referenced by id
 *          after verifying that \p id is of type \p type. This function is
 *          analogous to dereferencing a pointer in C with type checking.
 *
 * \note H5Iobject_verify() does not change the ID it is called on in any way
 *       (as opposed to H5Iremove_verify(), which removes the ID from its
 *       type’s hash table).
 *
 * @see H5Iregister()
 *
 */
public static native Pointer H5Iobject_verify(@Cast("hid_t") long id, @Cast("H5I_type_t") int type);
/**
 * \ingroup H5IUD
 *
 * \brief Removes an ID from its type
 *
 * @param id [in] The ID to be removed from its type
 * @param type [in] The identifier type
 <p>
 *
 * @return Returns a pointer to the memory referred to by \p id on success,
 *         NULL on failure.
 *
 * \details H5Iremove_verify() first ensures that \p id belongs to \p type.
 *          If so, it removes \p id from its type and returns the pointer
 *          to the memory it referred to. This pointer is the same pointer that
 *          was placed in storage by H5Iregister(). If id does not belong to
 *          \p type, then NULL is returned.
 *
 *          The \p id parameter is the ID which is to be removed from its type.
 *
 *          The \p type parameter is the identifier for the ID type which \p id
 *          is supposed to belong to. This identifier must have been created by
 *          a call to H5Iregister_type().
 *
 * \note This function does NOT deallocate the memory that \p id refers to.
 *       The pointer returned by H5Iregister() must be deallocated by the user
 *       to avoid memory leaks.
 *
 */
public static native Pointer H5Iremove_verify(@Cast("hid_t") long id, @Cast("H5I_type_t") int type);
/**
 * \ingroup H5I
 *
 * \brief Retrieves the type of an object
 *
 * \obj_id{id}
 *
 * @return Returns the object type if successful; otherwise #H5I_BADID.
 *
 * \details H5Iget_type() retrieves the type of the object identified by
 *          \p id. If no valid type can be determined or the identifier submitted is
 *          invalid, the function returns #H5I_BADID.
 *
 *          This function is of particular use in determining the type of
 *          object closing function (H5Dclose(), H5Gclose(), etc.) to call
 *          after a call to H5Rdereference().
 *
 * \note Note that this function returns only the type of object that \p id
 *       would identify if it were valid; it does not determine whether \p id
 *       is valid identifier. Validity can be determined with a call to
 *       H5Iis_valid().
 *
 */
public static native @Cast("H5I_type_t") int H5Iget_type(@Cast("hid_t") long id);
/**
 * \ingroup H5I
 *
 * \brief Retrieves an identifier for the file containing the specified object
 *
 * \obj_id{id}
 *
 * @return \hid_t{file}
 *
 * \details H5Iget_file_id() returns the identifier of the file associated with
 *          the object referenced by \p id.
 *
 * \note Note that the HDF5 library permits an application to close a file
 *       while objects within the file remain open. If the file containing the
 *       object \p id is still open, H5Iget_file_id() will retrieve the
 *       existing file identifier. If there is no existing file identifier for
 *       the file, i.e., the file has been closed, H5Iget_file_id() will reopen
 *       the file and return a new file identifier. In either case, the file
 *       identifier must eventually be released using H5Fclose().
 *
 * @since 1.6.3
 *
 */
public static native @Cast("hid_t") long H5Iget_file_id(@Cast("hid_t") long id);
/**
 * \ingroup H5I
 *
 * \brief Retrieves a name of an object based on the object identifier
 *
 * \obj_id{id}
 * @param name [out] A buffer for thename associated with the identifier
 * @param size [in] The size of the \p name buffer; usually the size of
 *                 the name in bytes plus 1 for a NULL terminator
 *
 * @return ssize_t
 *
 * \details H5Iget_name() retrieves a name for the object identified by \p id.
 *
 * \details Up to size characters of the name are returned in \p name;
 *          additional characters, if any, are not returned to the user
 *          application.
 *
 *          If the length of the name, which determines the required value of
 *          \p size, is unknown, a preliminary H5Iget_name() call can be made.
 *          The return value of this call will be the size in bytes of the
 *          object name. That value, plus 1 for a NULL terminator, is then
 *          assigned to size for a second H5Iget_name() call, which will
 *          retrieve the actual name.
 *
 *          If the object identified by \p id is an attribute, as determined
 *          via H5Iget_type(), H5Iget_name() retrieves the name of the object
 *          to which that attribute is attached. To retrieve the name of the
 *          attribute itself, use H5Aget_name().
 *
 *          If there is no name associated with the object identifier or if the
 *          name is NULL, H5Iget_name() returns 0 (zero).
 *
 * \note Note that an object in an HDF5 file may have multiple paths if there
 *       are multiple links pointing to it. This function may return any one of
 *       these paths. When possible, H5Iget_name() returns the path with which
 *       the object was opened.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Iget_name(@Cast("hid_t") long id, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * \ingroup H5I
 *
 * \brief Increments the reference count for an object
 *
 * \obj_id{id}
 *
 * @return Returns a non-negative reference count of the object ID after
 *         incrementing it if successful; otherwise a negative value is
 *         returned.
 *
 * \details H5Iinc_ref() increments the reference count of the object
 *          identified by \p id.
 *
 *          The reference count for an object ID is attached to the information
 *          about an object in memory and has no relation to the number of
 *          links to an object on disk.
 *
 *          The reference count for a newly created object will be 1. Reference
 *          counts for objects may be explicitly modified with this function or
 *          with H5Idec_ref(). When an object ID's reference count reaches
 *          zero, the object will be closed. Calling an object ID's \c close
 *          function decrements the reference count for the ID which normally
 *          closes the object, but if the reference count for the ID has been
 *          incremented with this function, the object will only be closed when
 *          the reference count reaches zero with further calls to H5Idec_ref()
 *          or the object ID's \c close function.
 *
 *          If the object ID was created by a collective parallel call (such as
 *          H5Dcreate(), H5Gopen(), etc.), the reference count should be
 *          modified by all the processes which have copies of the ID.
 *          Generally this means that group, dataset, attribute, file and named
 *          datatype IDs should be modified by all the processes and that all
 *          other types of IDs are safe to modify by individual processes.
 *
 *          This function is of particular value when an application is
 *          maintaining multiple copies of an object ID. The object ID can be
 *          incremented when a copy is made. Each copy of the ID can then be
 *          safely closed or decremented and the HDF5 object will be closed
 *          when the reference count for that that object drops to zero.
 *
 * @since 1.6.2
 *
 */
public static native int H5Iinc_ref(@Cast("hid_t") long id);
/**
 * \ingroup H5I
 *
 * \brief Decrements the reference count for an object
 *
 * \obj_id{id}
 *
 * @return Returns a non-negative reference count of the object ID after
 *         decrementing it, if successful; otherwise a negative value is
 *         returned.
 *
 * \details H5Idec_ref() decrements the reference count of the object
 *          identified by \p id.
 *
 *          The reference count for an object ID is attached to the information
 *          about an object in memory and has no relation to the number of
 *          links to an object on disk.
 *
 *          The reference count for a newly created object will be 1. Reference
 *          counts for objects may be explicitly modified with this function or
 *          with H5Iinc_ref(). When an object identifier’s reference count
 *          reaches zero, the object will be closed. Calling an object
 *          identifier’s \c close function decrements the reference count for
 *          the identifier which normally closes the object, but if the
 *          reference count for the identifier has been incremented with
 *          H5Iinc_ref(), the object will only be closed when the reference
 *          count reaches zero with further calls to this function or the
 *          object identifier’s \c close function.
 *
 *          If the object ID was created by a collective parallel call (such as
 *          H5Dcreate(), H5Gopen(), etc.), the reference count should be
 *          modified by all the processes which have copies of the ID.
 *          Generally this means that group, dataset, attribute, file and named
 *          datatype IDs should be modified by all the processes and that all
 *          other types of IDs are safe to modify by individual processes.
 *
 *          This function is of particular value when an application is
 *          maintaining multiple copies of an object ID. The object ID can be
 *          incremented when a copy is made. Each copy of the ID can then be
 *          safely closed or decremented and the HDF5 object will be closed
 *          when the reference count for that that object drops to zero.
 *
 * @since 1.6.2
 *
 */
public static native int H5Idec_ref(@Cast("hid_t") long id);
/**
 * \ingroup H5I
 *
 * \brief Retrieves the reference count for an object
 *
 * \obj_id{id}
 *
 * @return Returns a non-negative current reference count of the object
 *         identifier if successful; otherwise a negative value is returned.
 *
 * \details H5Iget_ref() retrieves the reference count of the object identified
 *          by \p id.
 *
 *          The reference count for an object identifier is attached to the
 *          information about an object in memory and has no relation to the
 *          number of links to an object on disk.
 *
 *          The function H5Iis_valid() is used to determine whether a specific
 *          object identifier is valid.
 *
 * @since 1.6.2
 *
 */
public static native int H5Iget_ref(@Cast("hid_t") long id);
/**
 * \ingroup H5IUD
 *
 * \brief Creates and returns a new ID type
 *
 * @param hash_size [in] Minimum hash table size (in entries) used to store IDs
 *                      for the new type
 * @param reserved [in] Number of reserved IDs for the new type
 * @param free_func [in] Function used to deallocate space for a single ID
 *
 * @return Returns the type identifier on success, negative on failure.
 *
 * \details H5Iregister_type() allocates space for a new ID type and returns an
 *          identifier for it.
 *
 *          The \p hash_size parameter indicates the minimum size of the hash
 *          table used to store IDs in the new type.
 *
 *          The \p reserved parameter indicates the number of IDs in this new
 *          type to be reserved. Reserved IDs are valid IDs which are not
 *          associated with any storage within the library.
 *
 *          The \p free_func parameter is a function pointer to a function
 *          which returns an herr_t and accepts a \c void*. The purpose of this
 *          function is to deallocate memory for a single ID. It will be called
 *          by H5Iclear_type() and H5Idestroy_type() on each ID. This function
 *          is NOT called by H5Iremove_verify(). The \c void* will be the same
 *          pointer which was passed in to the H5Iregister() function. The \p
 *          free_func function should return 0 on success and -1 on failure.
 *
 */
public static native @Cast("H5I_type_t") int H5Iregister_type(@Cast("size_t") long hash_size, @Cast("unsigned") int reserved, H5I_free_t free_func);
/**
 * \ingroup H5IUD
 *
 * \brief Deletes all identifiers of the given type
 *
 * @param type [in] Identifier of identifier type which is to be cleared of identifiers
 * @param force [in] Whether or not to force deletion of all identifiers
 *
 * @return \herr_t
 *
 * \details H5Iclear_type() deletes all identifiers of the type identified by
 *          the argument \p type.
 *
 *          The identifier type's free function is first called on all of these
 *          identifiers to free their memory, then they are removed from the
 *          type.
 *
 *          If the \p force flag is set to false, only those identifiers whose
 *          reference counts are equal to 1 will be deleted, and all other
 *          identifiers will be entirely unchanged. If the force flag is true,
 *          all identifiers of this type will be deleted.
 *
 */
public static native @Cast("herr_t") int H5Iclear_type(@Cast("H5I_type_t") int type, @Cast("hbool_t") boolean force);
/**
 * \ingroup H5IUD
 *
 * \brief Removes an identifier type and all identifiers within that type
 *
 * @param type [in] Identifier of identifier type which is to be destroyed
 *
 * @return \herr_t
 *
 * \details H5Idestroy_type deletes an entire identifier type \p type. All
 *          identifiers of this type are destroyed and no new identifiers of
 *          this type can be registered.
 *
 *          The type’s free function is called on all of the identifiers which
 *          are deleted by this function, freeing their memory. In addition,
 *          all memory used by this type’s hash table is freed.
 *
 *          Since the H5I_type_t values of destroyed identifier types are
 *          reused when new types are registered, it is a good idea to set the
 *          variable holding the value of the destroyed type to #H5I_UNINIT.
 *
 */
public static native @Cast("herr_t") int H5Idestroy_type(@Cast("H5I_type_t") int type);
/**
 * \ingroup H5IUD
 *
 * \brief Increments the reference count on an ID type
 *
 * @param type [in] The identifier of the type whose reference count is to be incremented
 *
 * @return Returns the current reference count on success, negative on failure.
 *
 * \details H5Iinc_type_ref() increments the reference count on an ID type. The
 *          reference count is used by the library to indicate when an ID type
 *          can be destroyed.
 *
 *          The type parameter is the identifier for the ID type whose
 *          reference count is to be incremented. This identifier must have
 *          been created by a call to H5Iregister_type().
 *
 */
public static native int H5Iinc_type_ref(@Cast("H5I_type_t") int type);
/**
 * \ingroup H5IUD
 *
 * \brief Decrements the reference count on an identifier type
 *
 * @param type [in] The identifier of the type whose reference count is to be decremented
 *
 * @return Returns the current reference count on success, negative on failure.
 *
 * \details H5Idec_type_ref() decrements the reference count on an identifier
 *          type. The reference count is used by the library to indicate when
 *          an identifier type can be destroyed. If the reference count reaches
 *          zero, this function will destroy it.
 *
 *          The type parameter is the identifier for the identifier type whose
 *          reference count is to be decremented. This identifier must have
 *          been created by a call to H5Iregister_type().
 *
 */
public static native int H5Idec_type_ref(@Cast("H5I_type_t") int type);
/**
 * \ingroup H5IUD
 *
 * \brief Retrieves the reference count on an ID type
 *
 * @param type [in] The identifier of the type whose reference count is to be retrieved
 *
 * @return Returns the current reference count on success, negative on failure.
 *
 * \details H5Iget_type_ref() retrieves the reference count on an ID type. The
 *          reference count is used by the library to indicate when an ID type
 *          can be destroyed.
 *
 *          The type parameter is the identifier for the ID type whose
 *          reference count is to be retrieved. This identifier must have been
 *          created by a call to H5Iregister_type().
 *
 */
public static native int H5Iget_type_ref(@Cast("H5I_type_t") int type);
/**
 * \ingroup H5IUD
 *
 * \brief Finds the memory referred to by an ID within the given ID type such
 *        that some criterion is satisfied
 *
 * @param type [in] The identifier of the type to be searched
 * @param func [in] The function defining the search criteria
 * @param key [in] A key for the search function
 *
 * @return Returns a pointer to the object which satisfies the search function
 *         on success, NULL on failure.
 *
 * \details H5Isearch() searches through a given ID type to find an object that
 *          satisfies the criteria defined by \p func. If such an object is
 *          found, the pointer to the memory containing this object is
 *          returned. Otherwise, NULL is returned. To do this, \p func is
 *          called on every member of type \p type. The first member to satisfy
 *          \p func is returned.
 *
 *          The \p type parameter is the identifier for the ID type which is to
 *          be searched. This identifier must have been created by a call to
 *          H5Iregister_type().
 *
 *          The parameter \p func is a function pointer to a function which
 *          takes three parameters. The first parameter is a \c void* and will
 *          be a pointer to the object to be tested. This is the same object
 *          that was placed in storage using H5Iregister(). The second
 *          parameter is a hid_t and is the ID of the object to be tested. The
 *          last parameter is a \c void*. This is the \p key parameter and can
 *          be used however the user finds helpful, or it can be ignored if it
 *          is not needed. \p func returns 0 if the object it is testing does
 *          not pass its criteria. A non-zero value should be returned if the
 *          object does pass its criteria. H5I_search_func_t is defined in
 *          H5Ipublic.h and is shown below.
 *          \snippet this H5I_search_func_t_snip
 *          The \p key parameter will be passed to the search function as a
 *          parameter. It can be used to further define the search at run-time.
 *
 */
public static native Pointer H5Isearch(@Cast("H5I_type_t") int type, H5I_search_func_t func, Pointer key);
/**
 * \ingroup H5IUD
 *
 * \brief Calls a callback for each member of the identifier type specified
 *
 * @param type [in] The identifier type
 * @param op [in] The callback function
 * @param op_data [in,out] The data for the callback function
 *
 * @return The last value returned by \p op
 *
 * \details H5Iiterate() calls the callback function \p op for each member of
 *          the identifier type \p type. The callback function type for \p op,
 *          H5I_iterate_func_t, is defined in H5Ipublic.h as:
 *          \snippet this H5I_iterate_func_t_snip
 *          \p op takes as parameters the identifier and a pass through of
 *          \p op_data, and returns an herr_t.
 *
 *          A positive return from op will cause the iteration to stop and
 *          H5Iiterate() will return the value returned by \p op. A negative
 *          return from \p op will cause the iteration to stop and H5Iiterate()
 *          will return failure. A zero return from \p op will allow iteration
 *          to continue, as long as there are other identifiers remaining in
 *          type.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Iiterate(@Cast("H5I_type_t") int type, H5I_iterate_func_t op, Pointer op_data);
/**
 * \ingroup H5IUD
 *
 * \brief Returns the number of identifiers in a given identifier type
 *
 * @param type [in] The identifier type
 * @param num_members [out] Number of identifiers of the specified identifier type
 *
 * @return \herr_t
 *
 * \details H5Inmembers() returns the number of identifiers of the identifier
 *          type specified in \p type.
 *
 *          The number of identifiers is returned in \p num_members. If no
 *          identifiers of this type have been registered, the type does not
 *          exist, or it has been destroyed, \p num_members is returned with
 *          the value 0.
 *
 */
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongPointer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") LongBuffer num_members);
public static native @Cast("herr_t") int H5Inmembers(@Cast("H5I_type_t") int type, @Cast("hsize_t*") long[] num_members);
/**
 * \ingroup H5IUD
 *
 * \brief Determines whether an identifier type is registered
 *
 * @param type [in] Identifier type
 *
 * @return \htri_t
 *
 * \details H5Itype_exists() determines whether the given identifier type,
 *          \p type, is registered with the library.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Itype_exists(@Cast("H5I_type_t") int type);
/**
 * \ingroup H5I
 *
 * \brief Determines whether an identifier is valid
 *
 * \obj_id{id}
 *
 * @return \htri_t
 *
 * \details H5Iis_valid() determines whether the identifier \p id is valid.
 *
 * \details Valid identifiers are those that have been obtained by an
 *          application and can still be used to access the original target.
 *          Examples of invalid identifiers include:
 *          \li Out of range values: negative, for example
 *          \li Previously-valid identifiers that have been released:
 *              for example, a dataset identifier for which the dataset has
 *              been closed
 *
 *          H5Iis_valid() can be used with any type of identifier: object
 *          identifier, property list identifier, attribute identifier, error
 *          message identifier, etc. When necessary, a call to H5Iget_type()
 *          can determine the type of the object that \p id identifies.
 *
 * @since 1.8.3
 *
 */
public static native @Cast("htri_t") int H5Iis_valid(@Cast("hid_t") long id);

// #ifdef __cplusplus
// #endif
// #endif /* H5Ipublic_H */


// Parsed from H5Tpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5T module.
 */
// #ifndef H5Tpublic_H
// #define H5Tpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

// #define HOFFSET(S, M) (offsetof(S, M))

/**
 * These are the various classes of datatypes
 * internal If this goes over 16 types (0-15), the file format will need to
 *          change.
 */
/** <!-- [H5T_class_t_snip] --> */
/** enum H5T_class_t */
public static final int
    /** error                                   */
    H5T_NO_CLASS  = -1,
    /** integer types                           */
    H5T_INTEGER   = 0,
    /** floating-point types                    */
    H5T_FLOAT     = 1,
    /** date and time types                     */
    H5T_TIME      = 2,
    /** character string types                  */
    H5T_STRING    = 3,
    /** bit field types                         */
    H5T_BITFIELD  = 4,
    /** opaque types                            */
    H5T_OPAQUE    = 5,
    /** compound types                          */
    H5T_COMPOUND  = 6,
    /** reference types                         */
    H5T_REFERENCE = 7,
    /** enumeration types                       */
    H5T_ENUM      = 8,
    /** variable-Length types                   */
    H5T_VLEN      = 9,
    /** array types                             */
    H5T_ARRAY     = 10,

    /** sentinel: this must be last             */
    H5T_NCLASSES = 11;
/** <!-- [H5T_class_t_snip] -->
<p>
/**
 * Byte orders
 */
/** <!-- [H5T_order_t_snip] --> */
/** enum H5T_order_t */
public static final int
    /** error                                   */
    H5T_ORDER_ERROR = -1,
    /** little endian                           */
    H5T_ORDER_LE    = 0,
    /** bit endian                              */
    H5T_ORDER_BE    = 1,
    /** VAX mixed endian                        */
    H5T_ORDER_VAX   = 2,
    /** Compound type with mixed member orders  */
    H5T_ORDER_MIXED = 3,
    /** no particular order (strings, bits,..)  */
    H5T_ORDER_NONE  = 4;
    /*H5T_ORDER_NONE must be last */
/** <!-- [H5T_order_t_snip] -->
<p>
/**
 * Types of integer sign schemes
 */
/** <!-- [H5T_sign_t_snip] --> */
/** enum H5T_sign_t */
public static final int
    /** error                                   */
    H5T_SGN_ERROR = -1,
    /** this is an unsigned type                */
    H5T_SGN_NONE  = 0,
    /** two's complement                        */
    H5T_SGN_2     = 1,

    H5T_NSGN = 2; /** sentinel: this must be last!             */
/** <!-- [H5T_sign_t_snip] -->
<p>
/**
 * Floating-point normalization schemes
 */
/** <!-- [H5T_norm_t_snip] --> */
/** enum H5T_norm_t */
public static final int
    /** error                                   */
    H5T_NORM_ERROR   = -1,
    /** msb of mantissa isn't stored, always 1  */
    H5T_NORM_IMPLIED = 0,
    /** msb of mantissa is always 1             */
    H5T_NORM_MSBSET  = 1,
    /** not normalized                          */
    H5T_NORM_NONE    = 2;
    /*H5T_NORM_NONE must be last */
/** <!-- [H5T_norm_t_snip] -->
<p>
/**
 * Character set to use for text strings.
 * \internal Do not change these values since they appear in HDF5 files!
 */
/** enum H5T_cset_t */
public static final int
    /** error                           */
    H5T_CSET_ERROR       = -1,
    /** US ASCII                        */
    H5T_CSET_ASCII       = 0,
    /** UTF-8 Unicode encoding		     */
    H5T_CSET_UTF8        = 1,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_2  = 2,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_3  = 3,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_4  = 4,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_5  = 5,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_6  = 6,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_7  = 7,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_8  = 8,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_9  = 9,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_10 = 10,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_11 = 11,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_12 = 12,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_13 = 13,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_14 = 14,
    /** reserved for later use		     */
    H5T_CSET_RESERVED_15 = 15;
public static final int H5T_NCSET = H5T_CSET_RESERVED_2; /*Number of character sets actually defined  */

/**
 * Type of padding to use in character strings.
 * \internal  Do not change these values since they appear in HDF5 files!
 */
/** enum H5T_str_t */
public static final int
    /** error                           */
    H5T_STR_ERROR       = -1,
    /** null terminate like in C        */
    H5T_STR_NULLTERM    = 0,
    /** pad with nulls                  */
    H5T_STR_NULLPAD     = 1,
    /** pad with spaces like in Fortran */
    H5T_STR_SPACEPAD    = 2,
    /** reserved for later use		     */
    H5T_STR_RESERVED_3  = 3,
    /** reserved for later use		     */
    H5T_STR_RESERVED_4  = 4,
    /** reserved for later use		     */
    H5T_STR_RESERVED_5  = 5,
    /** reserved for later use		     */
    H5T_STR_RESERVED_6  = 6,
    /** reserved for later use		     */
    H5T_STR_RESERVED_7  = 7,
    /** reserved for later use		     */
    H5T_STR_RESERVED_8  = 8,
    /** reserved for later use		     */
    H5T_STR_RESERVED_9  = 9,
    /** reserved for later use		     */
    H5T_STR_RESERVED_10 = 10,
    /** reserved for later use		     */
    H5T_STR_RESERVED_11 = 11,
    /** reserved for later use		     */
    H5T_STR_RESERVED_12 = 12,
    /** reserved for later use		     */
    H5T_STR_RESERVED_13 = 13,
    /** reserved for later use		     */
    H5T_STR_RESERVED_14 = 14,
    /** reserved for later use		     */
    H5T_STR_RESERVED_15 = 15;
public static final int H5T_NSTR = H5T_STR_RESERVED_3; /*num H5T_str_t types actually defined	     */

/**
 * Type of padding to use in other atomic types
 */
/** <!-- [H5T_pad_t_snip] --> */
/** enum H5T_pad_t */
public static final int
    /** error                           */
    H5T_PAD_ERROR      = -1,
    /** always set to zero              */
    H5T_PAD_ZERO       = 0,
    /** always set to one               */
    H5T_PAD_ONE        = 1,
    /** set to background value         */
    H5T_PAD_BACKGROUND = 2,

    /** sentinel: THIS MUST BE LAST     */
    H5T_NPAD = 3;
/** <!-- [H5T_pad_t_snip] -->
<p>
/**
 * Commands sent to conversion functions
 */
/** enum H5T_cmd_t */
public static final int
    /** query and/or initialize private data	     */
    H5T_CONV_INIT = 0,
    /** convert data from source to dest datatype */
    H5T_CONV_CONV = 1,
    /** function is being removed from path	     */
    H5T_CONV_FREE = 2;

/**
 * How is the {@code bkg' buffer used by the conversion function?
 */
/** enum H5T_bkg_t */
public static final int
    /** background buffer is not needed, send NULL */
    H5T_BKG_NO   = 0,
    /** bkg buffer used as temp storage only       */
    H5T_BKG_TEMP = 1,
    /** init bkg buf with data before conversion   */
    H5T_BKG_YES  = 2;
// Targeting ..\H5T_cdata_t.java


/** <!-- [H5T_cdata_t_snip] -->
<p>
/**
 * Conversion function persistence
 */
/** enum H5T_pers_t */
public static final int
    /** wild card				     */
    H5T_PERS_DONTCARE = -1,
    /** hard conversion function		     */
    H5T_PERS_HARD     = 0,
    /** soft conversion function		     */
    H5T_PERS_SOFT     = 1;

/**
 * The order to retrieve atomic native datatype
 */
/** <!-- [H5T_direction_t_snip] --> */
/** enum H5T_direction_t */
public static final int
    /** default direction is ascending         */
    H5T_DIR_DEFAULT = 0,
    /** in ascending order                     */
    H5T_DIR_ASCEND  = 1,
    /** in descending order                    */
    H5T_DIR_DESCEND = 2;
/** <!-- [H5T_direction_t_snip] -->
<p>
/**
 * The exception type passed into the conversion callback function
 */
/** enum H5T_conv_except_t */
public static final int
    
/** Source value is greater than destination's range */
    H5T_CONV_EXCEPT_RANGE_HI = 0,
    
/** Source value is less than destination's range */
    H5T_CONV_EXCEPT_RANGE_LOW = 1,
    
/** Source value loses precision in destination */
    H5T_CONV_EXCEPT_PRECISION = 2,
    
/** Source value is truncated in destination */
    H5T_CONV_EXCEPT_TRUNCATE = 3,
    
/** Source value is positive infinity */
    H5T_CONV_EXCEPT_PINF = 4,
    
/** Source value is negative infinity */
    H5T_CONV_EXCEPT_NINF = 5,
    
/** Source value is \c NaN (not a number, including \c QNaN and \c SNaN) */
    H5T_CONV_EXCEPT_NAN = 6;

/**
 * The return value from conversion callback function H5T_conv_except_func_t()
 */
/** enum H5T_conv_ret_t */
public static final int
    /** abort conversion                           */
    H5T_CONV_ABORT     = -1,
    /** callback function failed to handle the exception      */
    H5T_CONV_UNHANDLED = 0,
    /** callback function handled the exception successfully  */
    H5T_CONV_HANDLED   = 1;
// Targeting ..\hvl_t.java



/* Variable Length String information */
/**
 * Indicate that a string is variable length (null-terminated in C, instead of
 * fixed length)
 */
public static native @MemberGetter int H5T_VARIABLE();
public static final int H5T_VARIABLE = H5T_VARIABLE();

/* Opaque information */
/**
 * Maximum length of an opaque tag
 * \internal This could be raised without too much difficulty
 */
public static final int H5T_OPAQUE_TAG_MAX = 256;

// #ifdef __cplusplus
// Targeting ..\H5T_conv_t.java


// Targeting ..\H5T_conv_except_func_t.java


/** <!-- [H5T_conv_except_func_t_snip] --> */

/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef H5private_H
// #define H5OPEN H5open(),
// #else /* H5private_H */
// #define H5OPEN
// #endif /* H5private_H */

/*
 * The IEEE floating point types in various byte orders.
 */
/**
 * \ingroup PDTIEEE
 * 32-bit big-endian IEEE floating-point numbers
 */
public static native @MemberGetter int H5T_IEEE_F32BE();
public static final int H5T_IEEE_F32BE = H5T_IEEE_F32BE();
/**
 * \ingroup PDTIEEE
 * 32-bit little-endian IEEE floating-point numbers
 */
public static native @MemberGetter int H5T_IEEE_F32LE();
public static final int H5T_IEEE_F32LE = H5T_IEEE_F32LE();
/**
 * \ingroup PDTIEEE
 * 64-bit big-endian IEEE floating-point numbers
 */
public static native @MemberGetter int H5T_IEEE_F64BE();
public static final int H5T_IEEE_F64BE = H5T_IEEE_F64BE();
/**
 * \ingroup PDTIEEE
 * 64-bit little-endian IEEE floating-point numbers
 */
public static native @MemberGetter int H5T_IEEE_F64LE();
public static final int H5T_IEEE_F64LE = H5T_IEEE_F64LE();
public static native @Cast("hid_t") long H5T_IEEE_F32BE_g(); public static native void H5T_IEEE_F32BE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F32LE_g(); public static native void H5T_IEEE_F32LE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F64BE_g(); public static native void H5T_IEEE_F64BE_g(long setter);
public static native @Cast("hid_t") long H5T_IEEE_F64LE_g(); public static native void H5T_IEEE_F64LE_g(long setter);

/*
 * These are "standard" types.  For instance, signed (2's complement) and
 * unsigned integers of various sizes and byte orders.
 */
/**
 * \ingroup PDTSTD
 * 8-bit big-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I8BE();
public static final int H5T_STD_I8BE = H5T_STD_I8BE();
/**
 * \ingroup PDTSTD
 * 8-bit little-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I8LE();
public static final int H5T_STD_I8LE = H5T_STD_I8LE();
/**
 * \ingroup PDTSTD
 * 16-bit big-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I16BE();
public static final int H5T_STD_I16BE = H5T_STD_I16BE();
/**
 * \ingroup PDTSTD
 * 16-bit little-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I16LE();
public static final int H5T_STD_I16LE = H5T_STD_I16LE();
/**
 * \ingroup PDTSTD
 * 32-bit big-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I32BE();
public static final int H5T_STD_I32BE = H5T_STD_I32BE();
/**
 * \ingroup PDTSTD
 * 32-bit little-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I32LE();
public static final int H5T_STD_I32LE = H5T_STD_I32LE();
/**
 * \ingroup PDTSTD
 * 64-bit big-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I64BE();
public static final int H5T_STD_I64BE = H5T_STD_I64BE();
/**
 * \ingroup PDTSTD
 * 64-bit little-endian signed integers
 */
public static native @MemberGetter int H5T_STD_I64LE();
public static final int H5T_STD_I64LE = H5T_STD_I64LE();
/**
 * \ingroup PDTSTD
 * 8-bit big-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U8BE();
public static final int H5T_STD_U8BE = H5T_STD_U8BE();
/**
 * \ingroup PDTSTD
 * 8-bit little-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U8LE();
public static final int H5T_STD_U8LE = H5T_STD_U8LE();
/**
 * \ingroup PDTSTD
 * 16-bit big-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U16BE();
public static final int H5T_STD_U16BE = H5T_STD_U16BE();
/**
 * \ingroup PDTSTD
 * 16-bit little-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U16LE();
public static final int H5T_STD_U16LE = H5T_STD_U16LE();
/**
 * \ingroup PDTSTD
 * 32-bit big-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U32BE();
public static final int H5T_STD_U32BE = H5T_STD_U32BE();
/**
 * \ingroup PDTSTD
 * 32-bit little-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U32LE();
public static final int H5T_STD_U32LE = H5T_STD_U32LE();
/**
 * \ingroup PDTSTD
 * 64-bit big-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U64BE();
public static final int H5T_STD_U64BE = H5T_STD_U64BE();
/**
 * \ingroup PDTSTD
 * 64-bit little-endian unsigned integers
 */
public static native @MemberGetter int H5T_STD_U64LE();
public static final int H5T_STD_U64LE = H5T_STD_U64LE();
/**
 * \ingroup PDTSTD
 * 8-bit big-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B8BE();
public static final int H5T_STD_B8BE = H5T_STD_B8BE();
/**
 * \ingroup PDTSTD
 * 8-bit little-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B8LE();
public static final int H5T_STD_B8LE = H5T_STD_B8LE();
/**
 * \ingroup PDTSTD
 * 16-bit big-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B16BE();
public static final int H5T_STD_B16BE = H5T_STD_B16BE();
/**
 * \ingroup PDTSTD
 * 16-bit little-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B16LE();
public static final int H5T_STD_B16LE = H5T_STD_B16LE();
/**
 * \ingroup PDTSTD
 * 32-bit big-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B32BE();
public static final int H5T_STD_B32BE = H5T_STD_B32BE();
/**
 * \ingroup PDTSTD
 * 32-bit little-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B32LE();
public static final int H5T_STD_B32LE = H5T_STD_B32LE();
/**
 * \ingroup PDTSTD
 * 64-bit big-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B64BE();
public static final int H5T_STD_B64BE = H5T_STD_B64BE();
/**
 * \ingroup PDTSTD
 * 64-bit little-endian bitfield
 */
public static native @MemberGetter int H5T_STD_B64LE();
public static final int H5T_STD_B64LE = H5T_STD_B64LE();
/**
 * \ingroup PDTSTD
 * Object reference
 */
public static native @MemberGetter int H5T_STD_REF_OBJ();
public static final int H5T_STD_REF_OBJ = H5T_STD_REF_OBJ();
/**
 * \ingroup PDTSTD
 * Dataset region reference
 */
public static native @MemberGetter int H5T_STD_REF_DSETREG();
public static final int H5T_STD_REF_DSETREG = H5T_STD_REF_DSETREG();
/**
 * \ingroup PDTSTD
 * Generic reference
 */
public static native @MemberGetter int H5T_STD_REF();
public static final int H5T_STD_REF = H5T_STD_REF();
public static native @Cast("hid_t") long H5T_STD_I8BE_g(); public static native void H5T_STD_I8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I8LE_g(); public static native void H5T_STD_I8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I16BE_g(); public static native void H5T_STD_I16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I16LE_g(); public static native void H5T_STD_I16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I32BE_g(); public static native void H5T_STD_I32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I32LE_g(); public static native void H5T_STD_I32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I64BE_g(); public static native void H5T_STD_I64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_I64LE_g(); public static native void H5T_STD_I64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U8BE_g(); public static native void H5T_STD_U8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U8LE_g(); public static native void H5T_STD_U8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U16BE_g(); public static native void H5T_STD_U16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U16LE_g(); public static native void H5T_STD_U16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U32BE_g(); public static native void H5T_STD_U32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U32LE_g(); public static native void H5T_STD_U32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U64BE_g(); public static native void H5T_STD_U64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_U64LE_g(); public static native void H5T_STD_U64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B8BE_g(); public static native void H5T_STD_B8BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B8LE_g(); public static native void H5T_STD_B8LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B16BE_g(); public static native void H5T_STD_B16BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B16LE_g(); public static native void H5T_STD_B16LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B32BE_g(); public static native void H5T_STD_B32BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B32LE_g(); public static native void H5T_STD_B32LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B64BE_g(); public static native void H5T_STD_B64BE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_B64LE_g(); public static native void H5T_STD_B64LE_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_OBJ_g(); public static native void H5T_STD_REF_OBJ_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_DSETREG_g(); public static native void H5T_STD_REF_DSETREG_g(long setter);
public static native @Cast("hid_t") long H5T_STD_REF_g(); public static native void H5T_STD_REF_g(long setter);

/*
 * Types which are particular to Unix.
 */
/**
 * \ingroup PDTUNIX
 */
public static native @MemberGetter int H5T_UNIX_D32BE();
public static final int H5T_UNIX_D32BE = H5T_UNIX_D32BE();
/**
 * \ingroup PDTUNIX
 */
public static native @MemberGetter int H5T_UNIX_D32LE();
public static final int H5T_UNIX_D32LE = H5T_UNIX_D32LE();
/**
 * \ingroup PDTUNIX
 */
public static native @MemberGetter int H5T_UNIX_D64BE();
public static final int H5T_UNIX_D64BE = H5T_UNIX_D64BE();
/**
 * \ingroup PDTUNIX
 */
public static native @MemberGetter int H5T_UNIX_D64LE();
public static final int H5T_UNIX_D64LE = H5T_UNIX_D64LE();
public static native @Cast("hid_t") long H5T_UNIX_D32BE_g(); public static native void H5T_UNIX_D32BE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D32LE_g(); public static native void H5T_UNIX_D32LE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D64BE_g(); public static native void H5T_UNIX_D64BE_g(long setter);
public static native @Cast("hid_t") long H5T_UNIX_D64LE_g(); public static native void H5T_UNIX_D64LE_g(long setter);

/*
 * Types particular to the C language.  String types use `bytes' instead
 * of `bits' as their size.
 */
/**
 * \ingroup PDTS
 * String datatype in C (size defined in bytes rather than in bits)
 */
public static native @MemberGetter int H5T_C_S1();
public static final int H5T_C_S1 = H5T_C_S1();
public static native @Cast("hid_t") long H5T_C_S1_g(); public static native void H5T_C_S1_g(long setter);

/*
 * Types particular to Fortran.
 */
/**
 * \ingroup PDTS
 * String datatype in Fortran (as defined for the HDF5 C library)
 */
public static native @MemberGetter int H5T_FORTRAN_S1();
public static final int H5T_FORTRAN_S1 = H5T_FORTRAN_S1();
public static native @Cast("hid_t") long H5T_FORTRAN_S1_g(); public static native void H5T_FORTRAN_S1_g(long setter);

/*
 * These types are for Intel CPU's.  They are little endian with IEEE
 * floating point.
 */
/**
 * \ingroup PDTX86
 * 8-bit little-endian signed (2's complement) integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_I8();
public static final int H5T_INTEL_I8 = H5T_INTEL_I8();
/**
 * \ingroup PDTX86
 * 16-bit little-endian signed (2's complement) integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_I16();
public static final int H5T_INTEL_I16 = H5T_INTEL_I16();
/**
 * \ingroup PDTX86
 * 32-bit little-endian signed (2's complement) integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_I32();
public static final int H5T_INTEL_I32 = H5T_INTEL_I32();
/**
 * \ingroup PDTX86
 * 64-bit little-endian signed (2's complement) integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_I64();
public static final int H5T_INTEL_I64 = H5T_INTEL_I64();
/**
 * \ingroup PDTX86
 * 8-bit little-endian unsigned integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_U8();
public static final int H5T_INTEL_U8 = H5T_INTEL_U8();
/**
 * \ingroup PDTX86
 * 16-bit little-endian unsigned integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_U16();
public static final int H5T_INTEL_U16 = H5T_INTEL_U16();
/**
 * \ingroup PDTX86
 * 32-bit little-endian unsigned integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_U32();
public static final int H5T_INTEL_U32 = H5T_INTEL_U32();
/**
 * \ingroup PDTX86
 * 64-bit little-endian unsigned integers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_U64();
public static final int H5T_INTEL_U64 = H5T_INTEL_U64();
/**
 * \ingroup PDTX86
 * 8-bit little-endian bitfield for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_B8();
public static final int H5T_INTEL_B8 = H5T_INTEL_B8();
/**
 * \ingroup PDTX86
 * 16-bit little-endian bitfield for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_B16();
public static final int H5T_INTEL_B16 = H5T_INTEL_B16();
/**
 * \ingroup PDTX86
 * 32-bit little-endian bitfield for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_B32();
public static final int H5T_INTEL_B32 = H5T_INTEL_B32();
/**
 * \ingroup PDTX86
 * 64-bit little-endian bitfield for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_B64();
public static final int H5T_INTEL_B64 = H5T_INTEL_B64();
/**
 * \ingroup PDTX86
 * 32-bit little-endian IEEE floating-point numbers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_F32();
public static final int H5T_INTEL_F32 = H5T_INTEL_F32();
/**
 * \ingroup PDTX86
 * 64-bit little-endian IEEE floating-point numbers for Intel CPUs
 */
public static native @MemberGetter int H5T_INTEL_F64();
public static final int H5T_INTEL_F64 = H5T_INTEL_F64();

/*
 * These types are for DEC Alpha CPU's.  They are little endian with IEEE
 * floating point.
 */
/**
 * \ingroup PDTALPHA
 * 8-bit little-endian signed (2's complement) integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_I8();
public static final int H5T_ALPHA_I8 = H5T_ALPHA_I8();
/**
 * \ingroup PDTALPHA
 * 16-bit little-endian signed (2's complement) integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_I16();
public static final int H5T_ALPHA_I16 = H5T_ALPHA_I16();
/**
 * \ingroup PDTALPHA
 * 32-bit little-endian signed (2's complement) integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_I32();
public static final int H5T_ALPHA_I32 = H5T_ALPHA_I32();
/**
 * \ingroup PDTALPHA
 * 64-bit little-endian signed (2's complement) integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_I64();
public static final int H5T_ALPHA_I64 = H5T_ALPHA_I64();
/**
 * \ingroup PDTALPHA
 * 8-bit little-endian unsigned integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_U8();
public static final int H5T_ALPHA_U8 = H5T_ALPHA_U8();
/**
 * \ingroup PDTALPHA
 * 16-bit little-endian unsigned integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_U16();
public static final int H5T_ALPHA_U16 = H5T_ALPHA_U16();
/**
 * \ingroup PDTALPHA
 * 32-bit little-endian unsigned integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_U32();
public static final int H5T_ALPHA_U32 = H5T_ALPHA_U32();
/**
 * \ingroup PDTALPHA
 * 64-bit little-endian unsigned integers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_U64();
public static final int H5T_ALPHA_U64 = H5T_ALPHA_U64();
/**
 * \ingroup PDTALPHA
 * 8-bit little-endian bitfield for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_B8();
public static final int H5T_ALPHA_B8 = H5T_ALPHA_B8();
/**
 * \ingroup PDTALPHA
 * 16-bit little-endian bitfield for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_B16();
public static final int H5T_ALPHA_B16 = H5T_ALPHA_B16();
/**
 * \ingroup PDTALPHA
 * 32-bit little-endian bitfield for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_B32();
public static final int H5T_ALPHA_B32 = H5T_ALPHA_B32();
/**
 * \ingroup PDTALPHA
 * 64-bit little-endian bitfield for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_B64();
public static final int H5T_ALPHA_B64 = H5T_ALPHA_B64();
/**
 * \ingroup PDTALPHA
 * 32-bit little-endian IEEE floating-point numbers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_F32();
public static final int H5T_ALPHA_F32 = H5T_ALPHA_F32();
/**
 * \ingroup PDTALPHA
 * 64-bit little-endian IEEE floating-point numbers for DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_ALPHA_F64();
public static final int H5T_ALPHA_F64 = H5T_ALPHA_F64();

/*
 * These types are for MIPS cpu's commonly used in SGI systems. They are big
 * endian with IEEE floating point.
 */
/**
 * \ingroup PDTMIPS
 * 8-bit big-endian signed (2's complement) integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_I8();
public static final int H5T_MIPS_I8 = H5T_MIPS_I8();
/**
 * \ingroup PDTMIPS
 * 16-bit big-endian signed (2's complement) integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_I16();
public static final int H5T_MIPS_I16 = H5T_MIPS_I16();
/**
 * \ingroup PDTMIPS
 * 32-bit big-endian signed (2's complement) integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_I32();
public static final int H5T_MIPS_I32 = H5T_MIPS_I32();
/**
 * \ingroup PDTMIPS
 * 64-bit big-endian signed (2's complement) integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_I64();
public static final int H5T_MIPS_I64 = H5T_MIPS_I64();
/**
 * \ingroup PDTMIPS
 * 8-bit big-endian unsigned integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_U8();
public static final int H5T_MIPS_U8 = H5T_MIPS_U8();
/**
 * \ingroup PDTMIPS
 * 16-bit big-endian unsigned integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_U16();
public static final int H5T_MIPS_U16 = H5T_MIPS_U16();
/**
 * \ingroup PDTMIPS
 * 32-bit big-endian unsigned integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_U32();
public static final int H5T_MIPS_U32 = H5T_MIPS_U32();
/**
 * \ingroup PDTMIPS
 * 64-bit big-endian unsigned integers for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_U64();
public static final int H5T_MIPS_U64 = H5T_MIPS_U64();
/**
 * \ingroup PDTMIPS
 * 8-bit big-endian bitfield for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_B8();
public static final int H5T_MIPS_B8 = H5T_MIPS_B8();
/**
 * \ingroup PDTMIPS
 * 16-bit big-endian bitfield for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_B16();
public static final int H5T_MIPS_B16 = H5T_MIPS_B16();
/**
 * \ingroup PDTMIPS
 * 32-bit big-endian bitfield for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_B32();
public static final int H5T_MIPS_B32 = H5T_MIPS_B32();
/**
 * \ingroup PDTMIPS
 * 64-bit big-endian bitfield for SGI MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_B64();
public static final int H5T_MIPS_B64 = H5T_MIPS_B64();
/**
 * \ingroup PDTMIPS
 * 32-bit big-endian IEEE floating-point numbers for MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_F32();
public static final int H5T_MIPS_F32 = H5T_MIPS_F32();
/**
 * \ingroup PDTMIPS
 * 64-bit big-endian IEEE floating-point numbers for MIPS CPUs
 */
public static native @MemberGetter int H5T_MIPS_F64();
public static final int H5T_MIPS_F64 = H5T_MIPS_F64();

/*
 * The VAX floating point types (i.e. in VAX byte order)
 */
/**
 * \ingroup PDTALPHA
 * 32-bit VAX byte order floating-point numbers for OpenVMS on DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_VAX_F32();
public static final int H5T_VAX_F32 = H5T_VAX_F32();
/**
 * \ingroup PDTALPHA
 * 64-bit VAX byte order floating-point numbers for OpenVMS on DEC Alpha CPUs
 */
public static native @MemberGetter int H5T_VAX_F64();
public static final int H5T_VAX_F64 = H5T_VAX_F64();
public static native @Cast("hid_t") long H5T_VAX_F32_g(); public static native void H5T_VAX_F32_g(long setter);
public static native @Cast("hid_t") long H5T_VAX_F64_g(); public static native void H5T_VAX_F64_g(long setter);

/*
 * The predefined native types. These are the types detected by H5detect and
 * they violate the naming scheme a little.  Instead of a class name,
 * precision and byte order as the last component, they have a C-like type
 * name.  If the type begins with `U' then it is the unsigned version of the
 * integer type; other integer types are signed.  The type LLONG corresponds
 * to C's `long long' and LDOUBLE is `long double' (these types might be the
 * same as `LONG' and `DOUBLE' respectively).
 */
/**
 * \ingroup PDTNAT
 * C-style \c char
 */
public static native @MemberGetter int H5T_NATIVE_CHAR();
public static final int H5T_NATIVE_CHAR = H5T_NATIVE_CHAR();
/**
 * \ingroup PDTNAT
 * C-style \Code{signed char}
 */
public static native @MemberGetter int H5T_NATIVE_SCHAR();
public static final int H5T_NATIVE_SCHAR = H5T_NATIVE_SCHAR();
/**
 * \ingroup PDTNAT
 * C-style \Code{unsigned char}
 */
public static native @MemberGetter int H5T_NATIVE_UCHAR();
public static final int H5T_NATIVE_UCHAR = H5T_NATIVE_UCHAR();
/**
 * \ingroup PDTNAT
 * C-style \Code{short}
 */
public static native @MemberGetter int H5T_NATIVE_SHORT();
public static final int H5T_NATIVE_SHORT = H5T_NATIVE_SHORT();
/**
 * \ingroup PDTNAT
 * C-style \Code{unsigned short}
 */
public static native @MemberGetter int H5T_NATIVE_USHORT();
public static final int H5T_NATIVE_USHORT = H5T_NATIVE_USHORT();
/**
 * \ingroup PDTNAT
 * C-style \Code{int}
 */
public static native @MemberGetter int H5T_NATIVE_INT();
public static final int H5T_NATIVE_INT = H5T_NATIVE_INT();
/**
 * \ingroup PDTNAT
 * C-style \Code{unsigned int}
 */
public static native @MemberGetter int H5T_NATIVE_UINT();
public static final int H5T_NATIVE_UINT = H5T_NATIVE_UINT();
/**
 * \ingroup PDTNAT
 * C-style \Code{long}
 */
public static native @MemberGetter int H5T_NATIVE_LONG();
public static final int H5T_NATIVE_LONG = H5T_NATIVE_LONG();
/**
 * \ingroup PDTNAT
 * C-style \Code{unsigned long}
 */
public static native @MemberGetter int H5T_NATIVE_ULONG();
public static final int H5T_NATIVE_ULONG = H5T_NATIVE_ULONG();
/**
 * \ingroup PDTNAT
 * C-style \Code{long long}
 */
public static native @MemberGetter int H5T_NATIVE_LLONG();
public static final int H5T_NATIVE_LLONG = H5T_NATIVE_LLONG();
/**
 * \ingroup PDTNAT
 * C-style \Code{unsigned long long}
 */
public static native @MemberGetter int H5T_NATIVE_ULLONG();
public static final int H5T_NATIVE_ULLONG = H5T_NATIVE_ULLONG();
/**
 * \ingroup PDTNAT
 * C-style \Code{float}
 */
public static native @MemberGetter int H5T_NATIVE_FLOAT();
public static final int H5T_NATIVE_FLOAT = H5T_NATIVE_FLOAT();
/**
 * \ingroup PDTNAT
 * C-style \Code{double}
 */
public static native @MemberGetter int H5T_NATIVE_DOUBLE();
public static final int H5T_NATIVE_DOUBLE = H5T_NATIVE_DOUBLE();
/**
 * \ingroup PDTNAT
 * C-style \Code{long double}
 */
public static native @MemberGetter int H5T_NATIVE_LDOUBLE();
public static final int H5T_NATIVE_LDOUBLE = H5T_NATIVE_LDOUBLE();
/**
 * \ingroup PDTNAT
 * HDF5 8-bit bitfield based on native types
 */
public static native @MemberGetter int H5T_NATIVE_B8();
public static final int H5T_NATIVE_B8 = H5T_NATIVE_B8();
/**
 * \ingroup PDTNAT
 * HDF5 16-bit bitfield based on native types
 */
public static native @MemberGetter int H5T_NATIVE_B16();
public static final int H5T_NATIVE_B16 = H5T_NATIVE_B16();
/**
 * \ingroup PDTNAT
 * HDF5 32-bit bitfield based on native types
 */
public static native @MemberGetter int H5T_NATIVE_B32();
public static final int H5T_NATIVE_B32 = H5T_NATIVE_B32();
/**
 * \ingroup PDTNAT
 * HDF5 64-bit bitfield based on native types
 */
public static native @MemberGetter int H5T_NATIVE_B64();
public static final int H5T_NATIVE_B64 = H5T_NATIVE_B64();
/**
 * \ingroup PDTNAT
 * HDF5 opaque unit based on native types
 */
public static native @MemberGetter int H5T_NATIVE_OPAQUE();
public static final int H5T_NATIVE_OPAQUE = H5T_NATIVE_OPAQUE();
/**
 * \ingroup PDTNAT
 * HDF5 address type based on native types
 */
public static native @MemberGetter int H5T_NATIVE_HADDR();
public static final int H5T_NATIVE_HADDR = H5T_NATIVE_HADDR();
/**
 * \ingroup PDTNAT
 * HDF5 size type based on native types
 */
public static native @MemberGetter int H5T_NATIVE_HSIZE();
public static final int H5T_NATIVE_HSIZE = H5T_NATIVE_HSIZE();
/**
 * \ingroup PDTNAT
 * HDF5 signed size type based on native types
 */
public static native @MemberGetter int H5T_NATIVE_HSSIZE();
public static final int H5T_NATIVE_HSSIZE = H5T_NATIVE_HSSIZE();
/**
 * \ingroup PDTNAT
 * HDF5 error code type based on native types
 */
public static native @MemberGetter int H5T_NATIVE_HERR();
public static final int H5T_NATIVE_HERR = H5T_NATIVE_HERR();
/**
 * \ingroup PDTNAT
 * HDF5 Boolean type based on native types
 */
public static native @MemberGetter int H5T_NATIVE_HBOOL();
public static final int H5T_NATIVE_HBOOL = H5T_NATIVE_HBOOL();
public static native @Cast("hid_t") long H5T_NATIVE_SCHAR_g(); public static native void H5T_NATIVE_SCHAR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UCHAR_g(); public static native void H5T_NATIVE_UCHAR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_SHORT_g(); public static native void H5T_NATIVE_SHORT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_USHORT_g(); public static native void H5T_NATIVE_USHORT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_g(); public static native void H5T_NATIVE_INT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_g(); public static native void H5T_NATIVE_UINT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_LONG_g(); public static native void H5T_NATIVE_LONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_ULONG_g(); public static native void H5T_NATIVE_ULONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_LLONG_g(); public static native void H5T_NATIVE_LLONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_ULLONG_g(); public static native void H5T_NATIVE_ULLONG_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_FLOAT_g(); public static native void H5T_NATIVE_FLOAT_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_DOUBLE_g(); public static native void H5T_NATIVE_DOUBLE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_LDOUBLE_g(); public static native void H5T_NATIVE_LDOUBLE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B8_g(); public static native void H5T_NATIVE_B8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B16_g(); public static native void H5T_NATIVE_B16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B32_g(); public static native void H5T_NATIVE_B32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_B64_g(); public static native void H5T_NATIVE_B64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_OPAQUE_g(); public static native void H5T_NATIVE_OPAQUE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HADDR_g(); public static native void H5T_NATIVE_HADDR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HSIZE_g(); public static native void H5T_NATIVE_HSIZE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HSSIZE_g(); public static native void H5T_NATIVE_HSSIZE_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HERR_g(); public static native void H5T_NATIVE_HERR_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_HBOOL_g(); public static native void H5T_NATIVE_HBOOL_g(long setter);

/* C9x integer types */
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT8();
public static final int H5T_NATIVE_INT8 = H5T_NATIVE_INT8();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT8();
public static final int H5T_NATIVE_UINT8 = H5T_NATIVE_UINT8();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_LEAST8();
public static final int H5T_NATIVE_INT_LEAST8 = H5T_NATIVE_INT_LEAST8();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST8();
public static final int H5T_NATIVE_UINT_LEAST8 = H5T_NATIVE_UINT_LEAST8();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_FAST8();
public static final int H5T_NATIVE_INT_FAST8 = H5T_NATIVE_INT_FAST8();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_FAST8();
public static final int H5T_NATIVE_UINT_FAST8 = H5T_NATIVE_UINT_FAST8();
public static native @Cast("hid_t") long H5T_NATIVE_INT8_g(); public static native void H5T_NATIVE_INT8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT8_g(); public static native void H5T_NATIVE_UINT8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST8_g(); public static native void H5T_NATIVE_INT_LEAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST8_g(); public static native void H5T_NATIVE_UINT_LEAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST8_g(); public static native void H5T_NATIVE_INT_FAST8_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST8_g(); public static native void H5T_NATIVE_UINT_FAST8_g(long setter);

/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT16();
public static final int H5T_NATIVE_INT16 = H5T_NATIVE_INT16();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT16();
public static final int H5T_NATIVE_UINT16 = H5T_NATIVE_UINT16();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_LEAST16();
public static final int H5T_NATIVE_INT_LEAST16 = H5T_NATIVE_INT_LEAST16();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST16();
public static final int H5T_NATIVE_UINT_LEAST16 = H5T_NATIVE_UINT_LEAST16();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_FAST16();
public static final int H5T_NATIVE_INT_FAST16 = H5T_NATIVE_INT_FAST16();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_FAST16();
public static final int H5T_NATIVE_UINT_FAST16 = H5T_NATIVE_UINT_FAST16();
public static native @Cast("hid_t") long H5T_NATIVE_INT16_g(); public static native void H5T_NATIVE_INT16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT16_g(); public static native void H5T_NATIVE_UINT16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST16_g(); public static native void H5T_NATIVE_INT_LEAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST16_g(); public static native void H5T_NATIVE_UINT_LEAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST16_g(); public static native void H5T_NATIVE_INT_FAST16_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST16_g(); public static native void H5T_NATIVE_UINT_FAST16_g(long setter);

/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT32();
public static final int H5T_NATIVE_INT32 = H5T_NATIVE_INT32();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT32();
public static final int H5T_NATIVE_UINT32 = H5T_NATIVE_UINT32();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_LEAST32();
public static final int H5T_NATIVE_INT_LEAST32 = H5T_NATIVE_INT_LEAST32();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST32();
public static final int H5T_NATIVE_UINT_LEAST32 = H5T_NATIVE_UINT_LEAST32();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_FAST32();
public static final int H5T_NATIVE_INT_FAST32 = H5T_NATIVE_INT_FAST32();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_FAST32();
public static final int H5T_NATIVE_UINT_FAST32 = H5T_NATIVE_UINT_FAST32();
public static native @Cast("hid_t") long H5T_NATIVE_INT32_g(); public static native void H5T_NATIVE_INT32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT32_g(); public static native void H5T_NATIVE_UINT32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST32_g(); public static native void H5T_NATIVE_INT_LEAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST32_g(); public static native void H5T_NATIVE_UINT_LEAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST32_g(); public static native void H5T_NATIVE_INT_FAST32_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST32_g(); public static native void H5T_NATIVE_UINT_FAST32_g(long setter);

/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT64();
public static final int H5T_NATIVE_INT64 = H5T_NATIVE_INT64();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT64();
public static final int H5T_NATIVE_UINT64 = H5T_NATIVE_UINT64();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_LEAST64();
public static final int H5T_NATIVE_INT_LEAST64 = H5T_NATIVE_INT_LEAST64();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_LEAST64();
public static final int H5T_NATIVE_UINT_LEAST64 = H5T_NATIVE_UINT_LEAST64();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_INT_FAST64();
public static final int H5T_NATIVE_INT_FAST64 = H5T_NATIVE_INT_FAST64();
/**
 * \ingroup PDTC9x
 */
public static native @MemberGetter int H5T_NATIVE_UINT_FAST64();
public static final int H5T_NATIVE_UINT_FAST64 = H5T_NATIVE_UINT_FAST64();
public static native @Cast("hid_t") long H5T_NATIVE_INT64_g(); public static native void H5T_NATIVE_INT64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT64_g(); public static native void H5T_NATIVE_UINT64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_LEAST64_g(); public static native void H5T_NATIVE_INT_LEAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_LEAST64_g(); public static native void H5T_NATIVE_UINT_LEAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_INT_FAST64_g(); public static native void H5T_NATIVE_INT_FAST64_g(long setter);
public static native @Cast("hid_t") long H5T_NATIVE_UINT_FAST64_g(); public static native void H5T_NATIVE_UINT_FAST64_g(long setter);

/* Operations defined on all datatypes */
/**
 * \ingroup H5T
 *
 * \brief Creates a new datatype.
 *
 * @param type [in] Class of datatype to create
 * @param size [in]  Size, in bytes, of the datatype being created
 *
 * @return \hid_t{datatype}
 *
 * \details H5Tcreate() creates a new datatype of the specified class with the
 *          specified number of bytes. This function is used only with the
 *          following datatype classes:
 *          - #H5T_COMPOUND
 *          - #H5T_OPAQUE
 *          - #H5T_ENUM
 *          - #H5T_STRING
 *
 *          Other datatypes, including integer and floating-point datatypes,
 *          are typically created by using H5Tcopy() to copy and modify a
 *          predefined datatype.
 *
 *          When creating a variable-length string datatype, \p size must
 *          be #H5T_VARIABLE; see \ref_vlen_strings.
 *
 *          When creating a fixed-length string datatype, \p size will
 *          be the length of the string in bytes. The length of the
 *          string in characters will depend on i the encoding used; see
 *          H5Pset_char_encoding().
 *
 *          ENUMs created with this function have a signed native integer
 *          base datatype.  Use H5Tenum_create() if a different integer base
 *          datatype is required.
 *
 *          The datatype identifier returned from this function should be
 *          released with H5Tclose or resource leaks will result.
 *
 * @see H5Tclose()
 *
 * @since 1.2.0
 *
 */
public static native @Cast("hid_t") long H5Tcreate(@Cast("H5T_class_t") int type, @Cast("size_t") long size);
/**
 * \ingroup H5T
 *
 * \brief Copies an existing datatype.
 *
 * \type_id
 *
 * @return \hid_t{datatype}
 *
 * \details H5Tcopy() makes a copy of an existing datatype. The returned type
 *          is always transient and unlocked.
 *
 *          The \p type_id argument can be either a datatype identifier,
 *          a predefined datatype (defined in H5Tpublic.h), or a dataset
 *          identifier.  If \p type_id is a dataset identifier, this function
 *          returns a transient, modifiable datatype which is a copy of the
 *          dataset's datatype.
 *
 *          The returned datatype identifier should be released with H5Tclose()
 *          to prevent resource leak.
 *
 */
public static native @Cast("hid_t") long H5Tcopy(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Releases a datatype
 *
 * \type_id
 *
 * @return \herr_t
 *
 * \details H5Tclose() releases the datatype \p dtype_id. Further access
 *          through this datatype identifier is illegal. Failure to release
 *          a datatype with this call will result in resource leaks.
 *
 */
public static native @Cast("herr_t") int H5Tclose(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Determines whether two datatype identifiers refer to the same datatype
 *
 * \type_id{type1_id}
 * \type_id{type2_id}
 *
 * @return \htri_t
 *
 * \details H5Tequal() determines whether two datatype identifiers refer to
 *          the same datatype.
 *
 * @since 1.6 or earlier
 *
 */
public static native @Cast("htri_t") int H5Tequal(@Cast("hid_t") long type1_id, @Cast("hid_t") long type2_id);
/**
 * \ingroup H5T
 *
 * \brief Locks a datatype
 *
 * \type_id
 *
 * @return \herr_t
 *
 * \details H5Tlock() locks the datatype specified by the dtype_id identifier,
 *          making it read-only and non-destructible. This is normally done by
 *          the library for predefined datatypes so the application does not
 *          inadvertently change or delete a predefined type. Once a datatype
 *          is locked it can never be unlocked.
 *
 */
public static native @Cast("herr_t") int H5Tlock(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Commits a transient datatype, linking it into the file and creating
 *        a new committed datatype
 *
 * \fg_loc_id
 * @param name [in] Name given to committed datatype
 * \type_id Identifier of datatype to be committed and, upon function’s
 *          return, identifier for the committed datatype
 * \lcpl_id
 * \tcpl_id
 * \tapl_id
 *
 * @return \herr_t
 *
 * \details H5Tcommit2() saves a transient datatype as an immutable committed
 *          datatype in a file. The datatype specified by \p dtype_id is
 *          committed to the file with the name name at the location specified
 *          by \p loc_id and with the datatype creation and access property
 *          lists \p tcpl_id and \p tapl_id, respectively.
 *
 *          \p loc_id may be a file identifier, or a group identifier within
 *          that file. \p name may be either an absolute path in the file or
 *          a relative path from \p loc_id naming the newly-commited datatype.
 *
 *          The link creation property list, \p lcpl_id, governs creation of
 *          the link(s) by which the new committed datatype is accessed and
 *          the creation of any intermediate groups that may be missing.
 *
 *          Once committed, this datatype may be used to define the datatype
 *          of any other dataset or attribute in the file.
 *
 *          This function will not accept a datatype that cannot actually hold
 *          information. This currently includes compound datatypes with no
 *          fields and enumerated datatypes with no members.
 *
 *          Committed datatypes are sometimes referred to as named datatypes.
 *
 * @version 1.8.7 Function modified in this release to reject datatypes that
 *          will not accommodate actual data, such as a compound datatype
 *          with no fields or an enumerated datatype with no members.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long type_id, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long tcpl_id,
                         @Cast("hid_t") long tapl_id);
public static native @Cast("herr_t") int H5Tcommit2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long type_id, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long tcpl_id,
                         @Cast("hid_t") long tapl_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5T
 *
 * \brief Opens a committed (named) datatype
 *
 * \fgdta_loc_id
 * @param name [in] Name of the datatype to open
 * \tapl_id
 *
 * @return \hid_t{datatype}
 *
 * \details H5Topen2() opens a committed datatype at the location specified
 *          by \p loc_id and returns an identifier for the datatype. \p
 *          loc_id is either a file or group identifier. The identifier should
 *          eventually be closed by calling H5Tclose()  to release resources.
 *
 *          The committed datatype is opened with the datatype access property
 *          list tapl_id.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Topen2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long tapl_id);
public static native @Cast("hid_t") long H5Topen2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long tapl_id);
/**
 * \ingroup H5T
 *
 * \brief Commits a transient datatype to a file, creating a new named
 *        datatype, but does not link it into the file structure
 *
 * \fg_loc_id
 * \type_id
 * \tcpl_id
 * \tapl_id
 *
 * @return \herr_t
 *
 * \details H5Tcommit_anon() commits a transient datatype (not immutable)
 *          to a file, turning it into a named datatype with the specified
 *          creation and property lists. With default property lists,
 *          #H5P_DEFAULT, H5Tcommit_anon() provides similar functionality to
 *          that of H5Tcommit(), with the differences described below.
 *
 *          #H5P_DEFAULT can be passed in for the datatype creation property
 *          list identifier, \p tcpl_id.  The datatype access property list
 *          identifier, \p tapl_id, is provided for future functionality and
 *          is not used at this time. This parameter should always be passed
 *          as the value #H5P_DEFAULT.
 *
 *          Note that H5Tcommit_anon() does not link this newly-committed
 *          datatype into the file. After the H5Tcommit_anon() call, the
 *          datatype identifier \p type_id must be linked into the HDF5 file
 *          structure with H5Olink() or it will be deleted from the file when
 *          the file is closed.
 *
 *          The differences between this function and H5Tcommit() are as follows:
 *          \li H5Tcommit_anon() explicitly includes property lists,
 *              which provides for greater control of the creation process
 *              and of the properties of the new named datatype. H5Tcommit()
 *              always uses default properties.
 *          \li H5Tcommit_anon() neither provides the new named datatype’s
 *              name nor links it into the HDF5 file structure; those actions
 *              must be performed separately through a call to H5Olink(),
 *              which offers greater control over linking.
 *
 *          This function will not accept a datatype that cannot actually
 *          hold data. This currently includes compound datatypes with no
 *          fields and enumerated datatypes with no members.
 *
 * @version 1.8.7 Function modified in this release to reject datatypes that
 *                will not accommodate actual data, such as a compound datatype
 *                with no fields or an enumerated datatype with no members.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tcommit_anon(@Cast("hid_t") long loc_id, @Cast("hid_t") long type_id, @Cast("hid_t") long tcpl_id, @Cast("hid_t") long tapl_id);
/**
 * \ingroup H5T
 *
 * \brief Returns a copy of a datatype's creation property list
 *
 * \type_id
 *
 * @return \hid_t{datatype creation property list}
 *
 * \details H5Tget_create_plist() returns a property list identifier
 *          for the datatype creation property list associated with the datatype
 *          specified by \p type_id.
 *
 *          The creation property list identifier should be released with
 *          H5Pclose() to prevent memory leaks.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Tget_create_plist(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Determines whether a datatype is a committed type or a transient type
 *
 * \type_id
 *
 * @return \htri_t
 *
 * \details H5Tcommitted() queries a type to determine whether the type
 *          specified by the \p dtype_id identifier is a committed (formerly
 *          known as a \Emph{named}) type or a transient type. If this function returns
 *          a positive value, then the type is committed (that is, it has been
 *          committed, perhaps by some other application). Datasets which
 *          return committed datatypes with H5Dget_type() are able to share
 *          the datatype with other datasets in the same file.
 *
 * @version 1.8.0 Fortran API was added
 *
 * @since 1.6 or earlier
 *
 */
public static native @Cast("htri_t") int H5Tcommitted(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Encodes a datatype object description into a binary buffer
 *
 * @param obj_id [in] Identifier of the object to be encoded
 * @param buf [in,out] Buffer for the object to be encoded into.
 * @param nalloc [in,out] IN: The size of the allocated buffer
 *                       OUT: The size of the buffer needed
 *
 * @return \herr_t
 *
 * \details H5Tencode() Given datatype identifier, H5Tencode() converts a
 *          datatype description into binary form in a buffer. Using this
 *          binary form in the buffer, a datatype object can be reconstructed
 *          using H5Tdecode() to return a new object handle (\ref hid_t) for
 *          this datatype.
 *
 *          If the provided buffer is NULL, only the size of buffer needed is
 *          returned through \p nalloc.
 *
 *          A preliminary H5Tencode() call can be made to find out the size
 *          of the buffer needed. This value is returned as \p nalloc. That
 *          value can then be assigned to \p nalloc for a second H5Tencode()
 *          call, which will retrieve the actual encoded object.
 *
 *          If the library finds that \p nalloc is not big enough for the
 *          object, it simply returns the size of the buffer needed through
 *          \p nalloc without encoding the provided buffer.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tencode(@Cast("hid_t") long obj_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc);
/**
 * \ingroup H5T
 *
 * \brief Decodes a binary object description of datatype and return a new
 *        object handle
 *
 * @param buf [in] Buffer for the datatype object to be decoded
 *
 * @return \hid_t{datatype}
 *
 * \details H5Tdecode() Given an object description of datatype in binary in a
 *          buffer, H5Tdecode() reconstructs the HDF5 datatype object and
 *          returns a new object handle for it. The binary description of
 *          the object is encoded by H5Tencode(). User is responsible for
 *          passing in the right buffer.
 *
 *          The datatype identifier returned by this function can be released
 *          with H5Tclose() when the identifier is no longer needed so that
 *          resource leaks will not develop.
 *
 */
public static native @Cast("hid_t") long H5Tdecode(@Const Pointer buf);
/**
 * \ingroup H5T
 *
 * \brief Flushes all buffers associated with a committed datatype to disk
 *
 * \type_id
 *
 * @return \herr_t
 *
 * \details H5Tflush() causes all buffers associated with a committed datatype
 *          \p type_id to be immediately flushed to disk without removing the
 *          data from the cache.
 *
 *          HDF5 does not possess full control over buffering.  H5Tflush()
 *          flushes the internal HDF5 buffers and then asks the operating
 *          system (the OS) to flush the system buffers for the open
 *          files. After that, the OS is responsible for ensuring that the
 *          data is actually flushed to disk.
 *
 * @return \herr_t
 *
 * @since 1.10.0  C function introduced with this release.
 *
 * @see     H5Dflush()
 *          H5Drefresh()
 *          H5Tflush()
 *          H5Grefresh()
 *          H5Oflush()
 *          H5Orefresh()
 *          H5Tflush()
 *          H5Trefresh()
 *          H5Fstart_swmr_write()
 *          H5Pget_append_flush()
 *          H5Pget_object_flush_cb()
 *          H5Pset_append_flush()
 *          H5Pset_object_flush_cb()
 *
 */
public static native @Cast("herr_t") int H5Tflush(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Refreshes all buffers associated with a committed datatype
 *
 * \type_id
 *
 * @return \herr_t
 *
 * \details H5Trefresh() causes all buffers associated with a committed
 *          datatype to be cleared and immediately re-loaded with updated
 *          contents from disk.
 *
 *          This function essentially closes the datatype, evicts all
 *          metadata associated with it from the cache, and then re-opens the
 *          datatype. The reopened datatype is automatically re-registered
 *          with the same identifier.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Trefresh(@Cast("hid_t") long type_id);

/* Operations defined on compound datatypes */
/**
 * \ingroup COMPOUND
 *
 * \brief Adds a new member to a compound datatype.
 *
 * \type_id{parent_id}
 * @param name [in]      Name of the field to insert
 * @param offset [in]    Offset in memory structure of the field to insert
 * @param member_id [in]  Datatype identifier of the field to insert
 *
 * @return \herr_t
 *
 * \details H5Tinsert() adds another member to the compound datatype, specified
 *          \p type_id.
 *
 *          The new member has a \p name which must be unique within the
 *          compound datatype. The \p offset argument defines the start of the
 *          member in an instance of the compound datatype, and \p member_id
 *          is the datatype identifier of the new member.
 *
 *          \note Members of a compound datatype do not have to be atomic
 *          datatypes; a compound datatype can have a member which is a
 *          compound datatype.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") long parent_id, @Cast("const char*") BytePointer name, @Cast("size_t") long offset, @Cast("hid_t") long member_id);
public static native @Cast("herr_t") int H5Tinsert(@Cast("hid_t") long parent_id, String name, @Cast("size_t") long offset, @Cast("hid_t") long member_id);
/**
 * \ingroup COMPOUND
 *
 * \brief Recursively removes padding from within a compound datatype
 *
 * \type_id
 *
 * @return \herr_t
 *
 * \details H5Tpack() recursively removes padding from within a compound
 *          datatype to make it more efficient (space-wise) to store that data.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tpack(@Cast("hid_t") long type_id);

/* Operations defined on enumeration datatypes */
/**
 * \ingroup ENUM
 *
 * \brief Creates a new enumeration datatype
 *
 * @param base_id [in] Datatype identifier for the base datatype.  Must be an
 *            integer datatype
 *
 * @return \hid_t{enumeration datatype}
 *
 * \details H5Tenum_create() creates a new enumeration datatype based on the
 *          specified base datatype, dtype_id, which must be an integer datatype.
 *
 *          If a particular architecture datatype is required, a little endian
 *          or big endian datatype for example, use a native datatype as the
 *          base datatype and use H5Tconvert()  on values as they are read
 *          from or written to a dataset.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("hid_t") long H5Tenum_create(@Cast("hid_t") long base_id);
/**
 * \ingroup ENUM
 *
 * \brief Inserts a new enumeration datatype member
 *
 * \type_id{type}
 * @param name [in]  Name of the new member
 * @param value [in] Pointer to the value of the new member
 *
 * @return \herr_t
 *
 * \details H5Tenum_insert() inserts a new enumeration datatype member into an
 *          enumeration datatype.
 *
 *          \p type_id is the datatype identifier for the enumeration datatype,
 *          \p name is the name of the new member, and \p value points to the
 *           value of the new member.
 *
 *          \p name and \p value must both be unique within \p dtype_id.
 *
 *          \p value points to data which must be of the integer base datatype
 *          used when the enumeration datatype was created. If a particular
 *          architecture datatype is required, a little endian or big endian
 *          datatype for example, use a native datatype as the base datatype
 *          and use H5Tconvert() on values as they are read from or written
 *          to a dataset.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") long type, @Cast("const char*") BytePointer name, @Const Pointer value);
public static native @Cast("herr_t") int H5Tenum_insert(@Cast("hid_t") long type, String name, @Const Pointer value);
/**
 * \ingroup ENUM
 *
 * \brief Returns the symbol name corresponding to a specified member of an
 *        enumeration datatype
 *
 * \type_id{type}
 * @param value [in] Value of the enumeration datatype
 * @param name [out] Buffer for output of the symbol name
 * @param size [in] Anticipated size of the symbol name, in bytes
 *
 * @return Returns a non-negative value if successful. Otherwise returns a
 *         negative value
 *
 * \details H5Tenum_nameof() finds the symbol name that corresponds to the
 *          specified \p value of the enumeration datatype \p type.
 *
 *          At most \p size characters of the symbol \p name are copied into
 *          the \p name buffer. If the entire symbol name and null terminator
 *          do not fit in the name buffer, then as many characters as possible
 *          are copied (not null terminated) and the function fails.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("herr_t") int H5Tenum_nameof(@Cast("hid_t") long type, @Const Pointer value, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * \ingroup ENUM
 *
 * \brief Returns the value corresponding to a specified member of an
 *        enumeration datatype
 *
 * \type_id{type}
 * @param name [in] Symbol name of the enumeration datatype
 * @param value [out] Buffer for the value of the enumeration datatype
 *
 * @return \herr_t
 *
 * \details H5Tenum_valueof() finds the value that corresponds to the
 *          specified name of the enumeration datatype \p dtype_id.
 *
 *          Values returned in \p value will be of the enumerated type’s
 *          base type, that is, the datatype used by H5Tenum_create() when
 *          the enumerated type was created.
 *
 *          The \p value buffer must be at least large enough to hold a value
 *          of that base type. If the size is unknown, you can determine it
 *          with H5Tget_size().
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") long type, @Cast("const char*") BytePointer name, Pointer value);
public static native @Cast("herr_t") int H5Tenum_valueof(@Cast("hid_t") long type, String name, Pointer value);

/* Operations defined on variable-length datatypes */
/**
 * \ingroup VLEN
 *
 * \brief Creates a new variable-length array datatype
 *
 * \type_id{base_id}, the element type of the datatype to create
 *
 * @return \hid_t{variable-length datatype}
 *
 * \details H5Tvlen_create() creates a new one-dimensional array datatype of
 *          variable-length (VL) with the base datatype \p base_id.
 *
 *          This one-dimensional array often represents a data sequence of the
 *          base datatype, such as characters for character sequences or vertex
 *          coordinates for polygon lists. The base type specified for the VL
 *          datatype can be any HDF5 datatype, including another VL datatype, a
 *          compound datatype, or an atomic datatype.
 *
 *          When necessary, use H5Tget_super() to determine the base type of
 *          the VL datatype.
 *
 *          The datatype identifier returned from this function should be
 *          released with H5Tclose() or resource leaks will result. Under
 *          certain circumstances, H5Dvlen_reclaim() must also be used.
 *
 * \attention H5Tvlen_create() cannot be used to create a variable-length
 *            string datatype. H5Tvlen_create() called with a string or
 *            character base type creates a variable-length sequence of strings
 *            (a variable-length, 1-dimensional array), with each element of
 *            the array being of the string or character base type.\n
 *            To create a variable-length string datatype, see \ref_vlen_strings.
 *
 */
public static native @Cast("hid_t") long H5Tvlen_create(@Cast("hid_t") long base_id);

/* Operations defined on array datatypes */
/**
 * \ingroup ARRAY
 *
 * \brief Creates an array datatype object
 *
 * @param base_id [in] Datatype identifier for the array base datatype
 * @param ndims [in] Rank of the array
 * @param dim [in] Size of each array dimension
 *
 * @return \hid_t{array datatype}
 *
 * \details H5Tarray_create2() creates a new array datatype object.\n\n
 *          \p base_id is the datatype of every element of the array, i.e.,
 *          of the number at each position in the array.
 *
 *          \p ndims is the number of dimensions and the size of each dimension
 *          is specified in the array \p dim. The value of \p rank is
 *          currently limited to #H5S_MAX_RANK and must be greater than 0
 *          (zero). All dimension sizes specified in \p dim must be greater
 *          than 0 (zero).
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("hid_t") long H5Tarray_create2(@Cast("hid_t") long base_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") long[] dim);
/**
 * \ingroup ARRAY
 *
 * \brief Returns the rank of an array datatype
 *
 * \type_id
 *
 * @return Returns the rank of the array if successful; otherwise returns a
 *         negative value.
 *
 * \details H5Tget_array_ndims() returns the rank, i.e., the number of
 *          dimensions, of an array datatype object.
 *
 * @since 1.2.0
 *
 */
public static native int H5Tget_array_ndims(@Cast("hid_t") long type_id);
/**
 * \ingroup ARRAY
 *
 * \brief Retrieves sizes of array dimensions
 *
 * \type_id
 * @param dims [out] Sizes of array dimensions
 *
 * @return Returns the non-negative number of dimensions of the array type
 *         if successful; otherwise returns a negative value.
 *
 * \details H5Tget_array_dims2() returns the sizes of the dimensions of the
 *          specified array datatype object in the array \p dims.
 *
 * @since 1.2.0
 *
 */
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") LongPointer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") LongBuffer dims);
public static native int H5Tget_array_dims2(@Cast("hid_t") long type_id, @Cast("hsize_t*") long[] dims);

/* Operations defined on opaque datatypes */
/**
 * \ingroup OPAQUE
 *
 * \brief Tags an opaque datatype
 *
 * \type_id{type} of an opaque datatype
 * @param tag [in] Descriptive ASCII string with which the opaque datatype is
 *                to be tagged
 *
 * @return \herr_t
 *
 * \details H5Tset_tag() tags an opaque datatype \p type with a descriptive
 *          ASCII identifier, \p tag.
 *
 *          \p tag is intended to provide a concise description; the maximum
 *          size is hard-coded in the HDF5 library as 256 bytes
 *          (#H5T_OPAQUE_TAG_MAX).
 *
 * @version 1.6.5 The #H5T_OPAQUE_TAG_MAX macro constant, specifying the
 *                maximum size of an opaque datatype tag, was added in
 *                H5Tpublic.h.
 *
 */
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") long type, @Cast("const char*") BytePointer tag);
public static native @Cast("herr_t") int H5Tset_tag(@Cast("hid_t") long type, String tag);
/**
 * \ingroup OPAQUE
 *
 * \brief Gets the tag associated with an opaque datatype
 *
 * \type_id{type} of an opaque datatype
 *
 * @return Returns a pointer to an allocated string if successful; otherwise
 *         returns NULL.
 *
 * \details H5Tget_tag() returns the tag associated with the opaque datatype
 *         \p type.
 *
 * \attention The tag is returned via a pointer to an allocated string, which
 *            the caller must free.
 *
 */
public static native @Cast("char*") BytePointer H5Tget_tag(@Cast("hid_t") long type);

/* Querying property values */
/**
 * \ingroup H5T
 *
 * \brief Returns the base datatype from which a datatype is derived
 *
 * \type_id{type}
 *
 * @return \hid_t{datatype}
 *
 * \details H5Tget_super() returns the base datatype from which the datatype
 *          \p type_id is derived.  In the case of an enumeration type, the
 *          return value is an integer type.
 *
 *          The datatype identifier returned by this function must be released
 *          with H5Tclose()  when the identifier is no longer needed so that
 *          resource leaks will not develop.
 *
 */
public static native @Cast("hid_t") long H5Tget_super(@Cast("hid_t") long type);
/**
 * \ingroup H5T
 *
 * \brief Returns a datatype class
 *
 * \type_id
 *
 * @return Returns the datatype class if successful; otherwise #H5T_NO_CLASS.
 *
 * \details H5Tget_class() returns the class of the datatype \p type_id.
 *          Valid class identifiers, as defined in H5Tpublic.h, are:
 *          \snippet this H5T_class_t_snip
 *
 * \note The library returns #H5T_STRING for both fixed-length and
 *       variable-length strings.
 *
 * \note Unsupported datatype: The time datatype class, #H5T_TIME,
 *       is not supported. If #H5T_TIME is used, the resulting data will
 *       be readable and modifiable only on the originating computing
 *       platform; it will not be portable to other platforms.
 *
 */
public static native @Cast("H5T_class_t") int H5Tget_class(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Determines whether a datatype contains any datatypes of the given
 *        datatype class
 *
 * \type_id
 * @param cls [in] Datatype class
 *
 * @return \htri_t
 *
 * \details H5Tdetect_class() determines whether the datatype specified in
 *          \p type_id contains any datatypes of the datatype class specified
 *          in \p dtype_class.
 *
 *          This function is useful primarily in recursively examining all the
 *          fields and/or base types of compound, array, and variable-length
 *          datatypes.
 *
 *          Valid class identifiers, as defined in H5Tpublic.h, are:
 *          \snippet this H5T_class_t_snip
 *
 * @since 1.6.0
 *
 */
public static native @Cast("htri_t") int H5Tdetect_class(@Cast("hid_t") long type_id, @Cast("H5T_class_t") int cls);
/**
 * \ingroup H5T
 *
 * \brief Returns the size of a datatype
 *
 * \type_id
 *
 * @return Returns the size of the datatype in bytes if successful; otherwise,
 *         returns 0.
 *
 * \details H5Tget_size() returns the size of a datatype in bytes.
 *          \li For atomic datatypes, array datatypes, compound datatypes, and
 *          other datatypes of a constant size, the returned value is the
 *          size of the actual datatype in bytes.
 *          \li For variable-length string datatypes the returned value is
 *          the size of the pointer to the actual string, or \c sizeof(\c
 *          char \c *). This function does not return the size of actual
 *          variable-length string data.
 *          \li For variable-length sequence datatypes (see H5Tvlen_create()),
 *          the returned value is the size of the \p hvl_t struct, or \c
 *          sizeof(\p hvl_t). The \p hvl_t struct contains a pointer to the
 *          actual data and a size value.  This function does not return the
 *          size of actual variable-length sequence data.
 *
 * @see H5Tset_size()
 *
 * @since 1.2.0
 */
public static native @Cast("size_t") long H5Tget_size(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Returns the byte order of an atomic datatype
 *
 * \type_id
 *
 * @return Returns a byte order constant if successful; otherwise returns
 *         #H5T_ORDER_ERROR (-1)
 *
 * \details H5Tget_order() returns the byte order of an atomic datatype.
 *          Possible return values are:
 *          \snippet this H5T_order_t_snip
 *          Members of a compound datatype need not have the same byte
 *          order. If members of a compound datatype have more than one of
 *          little endian, big endian, or VAX byte order, H5Tget_order() will
 *          return #H5T_ORDER_MIXED for the compound datatype. A byte order of
 *          #H5T_ORDER_NONE will, however, be ignored; for example, if one or
 *          more members of a compound datatype have byte order #H5T_ORDER_NONE
 *          but all other members have byte order #H5T_ORDER_LE,  H5Tget_order()
 *          will return #H5T_ORDER_LE for the compound datatype.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_order_t") int H5Tget_order(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Returns the precision of an atomic datatype
 *
 * \type_id
 *
 * @return Returns the number of significant bits if successful; otherwise 0
 *
 * \details H5Tget_precision() returns the precision of an atomic datatype
 *          (for example, integer or float) or a datatype whose base (parent)
 *          type is an atomic type (for example, array, enum and variable
 *          length). The precision is the number of significant bits which,
 *          unless padding is present, is 8 times larger than the value
 *          returned by H5Tget_size().
 *
 * @since 1.2.0
 *
 */
public static native @Cast("size_t") long H5Tget_precision(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the bit offset of the first significant bit
 *
 * \type_id
 *
 * @return Returns an offset value if successful; otherwise returns a
 *         negative value.
 *
 * \details H5Tget_offset() retrieves the bit offset of the first significant
 *          bit. The significant bits of an atomic datum can be offset from the
 *          beginning of the memory for that datum by an amount of padding. The
 *          'offset' property specifies the number of bits of padding that
 *          appear to the "right of" the value. That is, if we have a 32-bit
 *          datum with 16-bits of precision having the value 0x1122 then it
 *          will be laid out in memory as (from small byte address toward
 *          larger byte addresses):
 *          <pre>{@code {.unparsed}
 *          0:  [ pad]  [0x11]  [0x22]  [ pad]
 *          1:  [ pad]  [0x22]  [0x11]  [ pad]
 *          2:  [0x11]  [ pad]  [ pad]  [0x22]
 *          3:  [0x22]  [ pad]  [ pad]  [0x11]
 *          }</pre>
 *
 * @since 1.2.0
 *
 */
public static native int H5Tget_offset(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the padding type of the least and most-significant bit padding
 *
 * \type_id
 * @param lsb [out] Buffer for the least-significant bit padding type
 * @param msb [out] Buffer for the most-significant bit padding type
 *
 * @return \herr_t
 *
 * \details H5Tget_pad() retrieves the padding type of the least and
 *          most-significant bit padding. Valid padding types are:
 *          \snippet this H5T_pad_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") IntPointer lsb, @Cast("H5T_pad_t*") IntPointer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") IntBuffer lsb, @Cast("H5T_pad_t*") IntBuffer msb);
public static native @Cast("herr_t") int H5Tget_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t*") int[] lsb, @Cast("H5T_pad_t*") int[] msb);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the sign type for an integer type
 *
 * \type_id
 *
 * @return Returns a valid sign type if successful; otherwise #H5T_SGN_ERROR (-1)
 *
 * \details H5Tget_sign() retrieves the sign type for an integer type.
 *          Valid types are:
 *          \snippet this H5T_sign_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_sign_t") int H5Tget_sign(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves floating point datatype bit field information
 *
 * \type_id
 * @param spos [out] Pointer to location to return floating-point sign bit
 * @param epos [out] Pointer to location to return exponent bit-position
 * @param esize [out] Pointer to location to return size of exponent in bits
 * @param mpos [out] Pointer to location to return mantissa bit-position
 * @param msize [out] Pointer to location to return size of mantissa in bits
 *
 * @return \herr_t
 *
 * \details H5Tget_fields() retrieves information about the locations of
 *          the various bit fields of a floating point datatype. The field
 *          positions are bit positions in the significant region of the
 *          datatype. Bits are numbered with the least significant bit number
 *          zero. Any (or even all) of the arguments can be null pointers.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tget_fields(@Cast("hid_t") long type_id, @Cast("size_t*") SizeTPointer spos, @Cast("size_t*") SizeTPointer epos, @Cast("size_t*") SizeTPointer esize,
                            @Cast("size_t*") SizeTPointer mpos, @Cast("size_t*") SizeTPointer msize);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the exponent bias of a floating-point type
 *
 * \type_id
 *
 * @return Returns the bias if successful and 0, otherwise.
 *
 * \details H5Tget_ebias() retrieves the exponent bias of a floating-point type.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("size_t") long H5Tget_ebias(@Cast("hid_t") long type_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup ATOM
 *
 * \brief Retrieves mantissa normalization of a floating-point datatype
 *
 * \type_id
 *
 * @return Returns a valid normalization type if successful; otherwise
 *         returns #H5T_NORM_ERROR (-1)
 *
 * \details H5Tget_norm() retrieves the mantissa normalization of a
 *          floating-point datatype. Valid normalization types are:
 *          \snippet this H5T_norm_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_norm_t") int H5Tget_norm(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the internal padding type for unused bits in floating-point
 *        datatypes
 *
 * \type_id
 *
 * @return Returns a valid padding type if successful; otherwise returns
 *         #H5T_PAD_ERROR (-1).
 *
 * \details H5Tget_inpad() retrieves the internal padding type for unused
 *          bits in floating-point datatypes. Valid padding types are:
 *          \snippet this H5T_pad_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_pad_t") int H5Tget_inpad(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the type of padding used for a string datatype
 *
 * \type_id
 *
 * @return Returns a valid string of the padding if successful; otherwise
 *         returns #H5T_STR_ERROR (-1)
 *
 * \details H5Tget_strpad() retrieves the type of padding used for a string
 *          datatype.
 *
 *          The string padding type is set with H5Tset_strpad().  Possible
 *          values returned are:
 * \str_pad_type
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_str_t") int H5Tget_strpad(@Cast("hid_t") long type_id);
/**
 * \ingroup COMPENUM
 *
 * \brief Retrieves the number of elements in a compound or enumeration datatype
 *
 * \type_id
 *
 * @return Returns the number of elements if successful; otherwise returns a
 *         negative value.
 *
 * \details H5Tget_nmembers() retrieves the number of fields in a compound
 *          datatype or the number of members of an enumeration datatype.
 *
 * @since 1.2.0
 *
 */
public static native int H5Tget_nmembers(@Cast("hid_t") long type_id);
/**
 * \ingroup COMPENUM
 *
 * \brief Retrieves the name of a compound or enumeration datatype member
 *
 * \type_id
 * @param membno [in] Zero-based index of the field or element
 *
 * @return Returns a valid pointer to a string allocated with malloc() if
 *         successful; otherwise returns NULL.
 *
 * \details H5Tget_member_name() retrieves the name of a field of a compound
 *          datatype or an element of an enumeration datatype.
 *
 *          The index of the target field or element is specified in \p
 *          member_no. Compound datatype fields and enumeration datatype
 *          elements are stored in no particular order with index values of
 *          0 through N-1, where N is the value returned by H5Tget_nmembers().
 *
 *          The HDF5 library allocates a buffer to receive the name of
 *          the field. The caller must subsequently free the buffer with
 *          H5free_memory().
 *
 * @since 1.2.0
 *
 */
public static native @Cast("char*") BytePointer H5Tget_member_name(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
/**
 * \ingroup COMPENUM
 *
 * \brief Retrieves the index of a compound or enumeration datatype member
 *
 * \type_id
 * @param name [in] Name of the field or member
 *
 * @return \herr_t
 *
 * \details H5Tget_member_index() retrieves the index of a field of a compound
 *          datatype or an element of an enumeration datatype.
 *
 *          The name of the target field or element is specified by \p name.
 *
 *          Fields are stored in no particular order with index values of 0
 *          through N-1, where N is the value returned by H5Tget_nmembers() .
 *
 * @since 1.2.0
 *
 */
public static native int H5Tget_member_index(@Cast("hid_t") long type_id, @Cast("const char*") BytePointer name);
public static native int H5Tget_member_index(@Cast("hid_t") long type_id, String name);
/**
 * \ingroup COMPOUND
 *
 * \brief Retrieves the offset of a field of a compound datatype
 *
 * \type_id
 * @param membno [in] Zero-based index of the field or element
 *
 * @return Returns the byte offset of the field if successful; otherwise
 *         returns 0 (zero).
 *
 * \details H5Tget_member_offset() retrieves the byte offset of the beginning
 *          of a field within a compound datatype with respect to the beginning
 *          of the compound datatype datum.
 *
 *          Note that zero is a valid offset and that this function will fail
 *          only if a call to H5Tget_member_class() fails with the same arguments.
 *
 * @version 1.6.4 \p member_no parameter type changed to unsigned.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("size_t") long H5Tget_member_offset(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
/**
 * \ingroup COMPOUND
 *
 * \brief Returns datatype class of compound datatype member
 *
 * \type_id
 * @param membno [in] Zero-based index of the field or element
 *
 * @return Returns the datatype class, a non-negative value, if successful;
 *         otherwise returns a negative value.
 *
 * \details Given a compound datatype, \p dtype_id, H5Tget_member_class()
 *          returns the datatype class of the member specified by \p member_no.
 *
 *          Valid class identifiers, as defined in H5Tpublic.h, are:
 *          \snippet this H5T_class_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_class_t") int H5Tget_member_class(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
/**
 * \ingroup COMPOUND
 *
 * \brief Returns the datatype of the specified member
 *
 * \type_id
 * @param membno [in] Zero-based index of the field or element
 *
 * @return Returns the identifier of a copy of the datatype of the field if
 *         successful; otherwise returns a negative value.
 *
 * \details H5Tget_member_type() returns the datatype of the specified member.
 *          The caller should invoke H5Tclose() to release resources associated
 *          with the type.
 *
 * @version 1.6.4 \p membno parameter type changed to unsigned.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("hid_t") long H5Tget_member_type(@Cast("hid_t") long type_id, @Cast("unsigned") int membno);
/**
 * \ingroup ENUM
 *
 * \brief Returns the value of an enumeration datatype member
 *
 * \type_id
 * @param membno [in] Number of the enumeration datatype member
 * @param value [out] Buffer for the value of the enumeration datatype member
 *
 * @return \herr_t
 *
 * \details H5Tget_member_value() returns the value of the enumeration datatype
 *          member \p member_no.
 *
 *          The member value is returned in a user-supplied buffer pointed to
 *          by \p value. Values returned in \p value will be of the enumerated
 *          type’s base type, that is, the datatype used by H5Tenum_create()
 *          when the enumerated type was created.
 *
 *          The value buffer must be at least large enough to hold a value
 *          of that base type. If the size is unknown, you can determine it
 *          with H5Tget_size().
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tget_member_value(@Cast("hid_t") long type_id, @Cast("unsigned") int membno, Pointer value);
/**
 * \ingroup ATOM
 *
 * \brief Retrieves the character set type of a string datatype
 *
 * \type_id
 *
 * @return Returns a valid character set type if successful; otherwise
 *         #H5T_CSET_ERROR (-1).
 *
 * \details H5Tget_cset() retrieves the character set type of a string datatype.
 *          Valid character set types are:
 *          \csets
 *
 * @since 1.2.0
 *
 */
public static native @Cast("H5T_cset_t") int H5Tget_cset(@Cast("hid_t") long type_id);
/**
 * \ingroup ATOM
 *
 * \brief Determines whether datatype is a variable-length string
 *
 * \type_id
 *
 * @return Returns:
 *         \li a positive value if the specified datatype is a variable-length
 *             string
 *         \li 0 if the specified datatype is not a variable-length string
 *         \li a negative value when the function fails
 *
 * \details H5Tis_variable_str() determines whether the datatype identified
 *          by \p dtype_id is a variable-length string.
 *
 *          This function can be used to distinguish between fixed and
 *          variable-length string datatypes.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("htri_t") int H5Tis_variable_str(@Cast("hid_t") long type_id);
/**
 * \ingroup H5T
 *
 * \brief Returns the native datatype identifier of a specified datatype
 *
 * \type_id
 * @param direction [in] Direction of search
 *
 * @return \hid_t{native datatype}
 *
 * \details H5Tget_native_type() returns the equivalent native datatype
 *          identifier for the datatype specified by \p type_id.
 *
 *          H5Tget_native_type() is designed primarily to facilitate use of
 *          the H5Dread() function, for which users otherwise must undertake a
 *          multi-step process to determine the native datatype of a dataset
 *          prior to reading it into memory. This function can be used for
 *          the following purposes:
 *
 *          \li To determine the native datatype of an atomic datatype
 *          \li To determine the base datatype of an array, enumerated, or
 *              variable-length datatype
 *          \li To determine the native atomic datatypes of the individual
 *              components of a compound datatype
 *
 *          For example, if \p type_id is a compound datatype, the returned
 *          datatype identifier will be for a similar compound datatype with
 *          each element converted to the corresponding native datatype;
 *          nested compound datatypes will be unwound. If \p type_id is an
 *          array, the returned datatype identifier will be for the native
 *          datatype of a single array element.
 *
 *          H5Tget_native_type() selects the first matching native datatype
 *          from the following list:
 *
 *          \li #H5T_NATIVE_CHAR
 *          \li #H5T_NATIVE_SHORT
 *          \li #H5T_NATIVE_INT
 *          \li #H5T_NATIVE_LONG
 *          \li #H5T_NATIVE_LLONG
 *
 *          \li #H5T_NATIVE_UCHAR
 *          \li #H5T_NATIVE_USHORT
 *          \li #H5T_NATIVE_UINT
 *          \li #H5T_NATIVE_ULONG
 *          \li #H5T_NATIVE_ULLONG
 *
 *          \li #H5T_NATIVE_FLOAT
 *          \li #H5T_NATIVE_DOUBLE
 *          \li #H5T_NATIVE_LDOUBLE
 *
 *          \li #H5T_NATIVE_B8
 *          \li #H5T_NATIVE_B16
 *          \li #H5T_NATIVE_B32
 *          \li #H5T_NATIVE_B64
 *
 *          The direction parameter indicates the order in which the library
 *          searches for a native datatype match. Valid values for direction
 *          are as follows:
 *          \snippet this H5T_direction_t_snip
 *
 *          H5Tget_native_type() is designed primarily for use with integer,
 *          floating point, and bitfield datatypes. String, time, opaque, and
 *          reference datatypes are returned as a copy of dtype_id. See above
 *          for compound, array, enumerated, and variable-length datatypes.
 *
 *          The identifier returned by H5Tget_native_type() should eventually
 *          be closed by calling H5Tclose() to release resources.
 *
 *          \note Please note that a datatype is actually an object
 *          identifier or handle returned from opening the datatype. It
 *          is not persistent and its value can be different from one HDF5
 *          session to the next.
 *
 *          \note H5Tequal() can be used to compare datatypes.
 *
 *          \note HDF5 High Level APIs that may also be of interest are: H5LTdtype_to_text()
 *                creates a text description of a datatype. H5LTtext_to_dtype() creates an
 *                HDF5 datatype given a text description.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("hid_t") long H5Tget_native_type(@Cast("hid_t") long type_id, @Cast("H5T_direction_t") int direction);

/* Setting property values */
/**
 * \ingroup H5T
 *
 * \brief Sets size for a datatype.
 *
 * \type_id
 * @param size [in] New datatype size is bytes or #H5T_VARIABLE
 *
 * @return \herr_t
 *
 * \details H5Tset_size() sets the total size, \p size, in bytes, for a
 *          datatype.
 *
 *          \p size must have a positive value, unless it is passed in as
 *          #H5T_VARIABLE and the datatype is a string datatype.
 *
 *          \li Numeric datatypes: If the datatype is atomic and the size
 *          is decreased so that significant bits of the datatype extend
 *          beyond the edge of the new size, then the offset property of the
 *          datatype is decreased toward zero.  If the offset becomes zero
 *          and the significant bits of the datatype still hang over the edge
 *          of the new size, then the number of significant bits is decreased.
 *
 *          \li String or character datatypes: The size set for a string
 *          datatype should include space for the null-terminator character,
 *          otherwise it will not be stored on (or retrieved from)
 *          disk. Adjusting the size of a string automatically sets the
 *          precision to \p 8*size.
 *
 *          \li Variable-length string datatypes: If \p dtype_id is a
 *          variable-length string, size must normally be set to #H5T_VARIABLE.
 *          See \ref_vlen_strings.
 *
 *          \li Compound datatypes: This function may be used to increase or
 *          decrease the size of a compound datatype, but the function will
 *          fail if the new size is too small to accommodate all member fields.
 *
 *          \li Ineligible datatypes: This function cannot be used with
 *          enumerated datatypes (#H5T_ENUM), array datatypes (#H5T_ARRAY),
 *          variable-length array datatypes (#H5T_VLEN), or reference datatypes
 *          (#H5T_REFERENCE).
 *
 * @see H5Tget_size()
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_size(@Cast("hid_t") long type_id, @Cast("size_t") long size);
/**
 * \ingroup ATOM
 *
 * \brief Sets the byte order of a datatype
 *
 * \type_id
 * @param order [in] Byte order constant
 *
 * @return \herr_t
 *
 * \details H5Tset_order() sets the byte order of a datatype.\n
 *          Byte order can currently be set to any of the following:
 *          \snippet this H5T_order_t_snip
 *          #H5T_ORDER_MIXED (3) is a valid value for order only when
 *          returned by the function H5Tget_order(); it cannot be set with
 *          H5Tset_order().
 *
 *          #H5T_ORDER_NONE (4) is a valid value for order, but it has no
 *          effect. It is valid only for fixed-length strings and object and
 *          region references and specifies “no particular order.”
 *
 *          The byte order of a derived datatype is initially the same as
 *          that of the parent type, but can be changed with H5Tset_order().
 *
 *          This function cannot be used with a datatype after it has been
 *          committed.
 *
 * \note    Special considerations:
 *          \li ENUM datatypes: Byte order must be set before any member on
 *              an ENUM is defined.
 *          \li Compound datatypes: Byte order is set individually on each member
 *              of a compound datatype; members of a compound datatype need not
 *              have the same byte order.
 *          \li Opaque datatypes: Byte order can be set but has no effect.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_order(@Cast("hid_t") long type_id, @Cast("H5T_order_t") int order);
/**
 * \ingroup ATOM
 *
 * \brief Sets the precision of an atomic datatype
 *
 * \type_id
 * @param prec [in] Number of bits of precision for datatype
 *
 * @return \herr_t
 *
 * \details H5Tset_precision() sets the precision of an atomic datatype. The
 *          precision is the number of significant bits which, unless
 *          padding is present, is 8 times larger than the value returned
 *          by H5Tget_size().
 *
 *          If the precision is increased then the offset is decreased and
 *          then the size is increased to insure that significant bits do not
 *          "hang over" the edge of the datatype.
 *
 *          Changing the precision of an #H5T_STRING automatically changes
 *          the size as well. The precision must be a multiple of 8.
 *
 *          When decreasing the precision of a floating point type, set the
 *          locations and sizes of the sign, mantissa, and exponent fields
 *          first.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_precision(@Cast("hid_t") long type_id, @Cast("size_t") long prec);
/**
 * \ingroup ATOM
 *
 * \brief Sets the bit offset of the first significant bit
 *
 * \type_id
 * @param offset [in] Offset of first significant bit
 *
 * @return \herr_t
 *
 * \details H5Tset_offset() sets the bit offset of the first significant
 *          bit. The significant bits of an atomic datum can be offset from
 *          the beginning of the memory for that datum by an amount of
 *          padding. The offset property specifies the number of bits of
 *          padding that appear “to the right of” the value. That is,
 *          if we have a 32-bit datum with 16-bits of precision having the
 *          value 0x1122, then it will be laid out in memory as (from small
 *          byte address toward larger byte addresses):
 *          <pre>{@code {.unparsed}
 *          0:  [ pad]  [0x11]  [0x22]  [ pad]
 *          1:  [ pad]  [0x22]  [0x11]  [ pad]
 *          2:  [0x11]  [ pad]  [ pad]  [0x22]
 *          3:  [0x22]  [ pad]  [ pad]  [0x11]
 *          }</pre>
 *          If the offset is incremented then the total size is incremented
 *          also if necessary to prevent significant bits of the value from
 *          hanging over the edge of the datatype.
 *
 *          The offset of an #H5T_STRING cannot be set to anything but zero.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_offset(@Cast("hid_t") long type_id, @Cast("size_t") long offset);
/**
 * \ingroup ATOM
 *
 * \brief Sets the least and most-significant bits padding types
 *
 * \type_id
 * @param lsb [in] Padding type for least-significant bits
 * @param msb [in] Padding type for most-significant bits
 *
 * @return \herr_t
 *
 * \details H5Tset_pad() sets the least and most-significant bits padding types.
 *          Available values are:
 * \padding_type
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_pad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t") int lsb, @Cast("H5T_pad_t") int msb);
/**
 * \ingroup ATOM
 *
 * \brief Sets the sign property for an integer type
 *
 * \type_id
 * @param sign [in] Sign type
 *
 * @return \herr_t
 *
 * \details H5Tset_sign() sets the sign property for an integer type:
 * \sign_prop
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_sign(@Cast("hid_t") long type_id, @Cast("H5T_sign_t") int sign);
/**
 * \ingroup ATOM
 *
 * \brief Sets locations and sizes of floating point bit fields
 *
 * \type_id
 * @param spos [in] Sign position, i.e., the bit offset of the floating-point
 *                 sign bit
 * @param epos [in] Exponent bit position
 * @param esize [in] Size of exponent in bits
 * @param mpos [in] Mantissa bit position
 * @param msize [in] Size of mantissa in bits
 *
 * @return \herr_t
 *
 * \details H5Tset_fields() sets the locations and sizes of the various
 *          floating-point bit fields. The field positions are bit positions
 *          in the significant region of the datatype. Bits are numbered with
 *          the least significant bit number zero.
 *
 *          Fields are not allowed to extend beyond the number of bits of
 *          precision, nor are they allowed to overlap with one another.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_fields(@Cast("hid_t") long type_id, @Cast("size_t") long spos, @Cast("size_t") long epos, @Cast("size_t") long esize, @Cast("size_t") long mpos, @Cast("size_t") long msize);
/**
 * \ingroup ATOM
 *
 * \brief Sets the exponent bias of a floating-point type
 *
 * \type_id
 * @param ebias [in] Exponent bias value
 *
 * @return \herr_t
 *
 * \details H5Tset_ebias() sets the exponent bias of a floating-point type.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_ebias(@Cast("hid_t") long type_id, @Cast("size_t") long ebias);
/**
 * \ingroup ATOM
 *
 * \brief Sets the mantissa normalization of a floating-point datatype
 *
 * \type_id
 * @param norm [in] Mantissa normalization type
 *
 * @return \herr_t
 *
 * \details H5Tset_norm() sets the mantissa normalization of a floating-point
 *          datatype. Valid normalization types are:
 *          \snippet this H5T_norm_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_norm(@Cast("hid_t") long type_id, @Cast("H5T_norm_t") int norm);
/**
 * \ingroup ATOM
 *
 * \brief Fills unused internal floating-point bits
 *
 * \type_id
 * @param pad [in] Padding type
 *
 * @return \herr_t
 *
 * \details H5Tset_inpad() If any internal bits of a floating point-type are
 *          unused (that is, those significant bits which are not part of the
 *          sign, exponent, or mantissa), then H5Tset_inpad()  will be filled
 *          according to the value of the padding value property inpad. Valid
 *          padding types are:
 *          \snippet this H5T_pad_t_snip
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_inpad(@Cast("hid_t") long type_id, @Cast("H5T_pad_t") int pad);
/**
 * \ingroup ATOM
 *
 * \brief Sets character set to be used in a string or character datatype
 *
 * \type_id
 * @param cset [in] Character set type
 *
 * @return \herr_t
 *
 * \details H5Tset_cset() sets the character set to be used in a dataset with
 *          a string or character datatype.
 *
 *          Valid values for cset include the following:
 *          \csets
 *          For example, if the character set for the datatype \p type_id is set
 *          to #H5T_CSET_UTF8, string or character data of datatype dtype_id
 *          will be encoded using the UTF-8 Unicode character set.
 *
 *          ASCII and UTF-8 Unicode are the only currently supported character
 *          encodings. Extended ASCII encodings (for example, ISO 8859) are
 *          not supported. This encoding policy is not enforced by the HDF5
 *          library. Using encodings other than ASCII and UTF-8 can lead to
 *          compatibility and usability problems.
 *
 *          Note that H5Tset_cset()  sets the character set for a character or
 *          string datatype while H5Pset_char_encoding()  sets the character
 *          set used for an HDF5 link or attribute name.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_cset(@Cast("hid_t") long type_id, @Cast("H5T_cset_t") int cset);
/**
 * \ingroup ATOM
 *
 * \brief Defines the type of padding used for character strings
 *
 * \type_id
 * @param strpad [in] String padding type
 *
 * @return \herr_t
 *
 * \details H5Tset_strpad() defines the type of padding used for a string
 *          datatype.
 *
 *          The method used to store character strings differs with the
 *          programming language.  C usually null terminates strings while
 *          Fortran left-justifies and space-pads strings.
 *
 *          Valid values of \p strpad are as follows:
 *          \str_pad_type
 *          When converting from a longer string to a shorter string, the
 *          behavior is as follows. If the shorter string is #H5T_STR_NULLPAD
 *          or #H5T_STR_SPACEPAD, then the string is simply truncated. If
 *          the short string is #H5T_STR_NULLTERM, it is truncated and a null
 *          terminator is appended.
 *
 *          When converting from a shorter string to a longer string, the
 *          longer string is padded on the end by appending nulls or spaces.
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Tset_strpad(@Cast("hid_t") long type_id, @Cast("H5T_str_t") int strpad);

/**
 * \ingroup CONV
 *
 * \brief Registers a datatype conversion function
 *
 * @param pers [in] Conversion function type
 * @param name [in] Name displayed in diagnostic output
 * \type_id{src_id} of source datatype
 * \type_id{dst_id} of destination datatype
 * @param func [in] Function to convert between source and destination datatypes
 *
 * @return \herr_t
 *
 * \details H5Tregister() registers a hard or soft conversion function for a
 *          datatype conversion path. The parameter \p pers indicates whether a
 *          conversion function is hard (#H5T_PERS_HARD) or soft
 *          (#H5T_PERS_SOFT). User-defined functions employing compiler casting
 *          are designated as \Emph{hard}; other user-defined conversion
 *          functions registered with the HDF5 library (with H5Tregister() )
 *          are designated as \Emph{soft}. The HDF5 library also has its own
 *          hard and soft conversion functions.
 *
 *          A conversion path can have only one hard function. When type is
 *          #H5T_PERS_HARD, \p func replaces any previous hard function.
 *
 *          When type is #H5T_PERS_SOFT, H5Tregister() adds the function to the
 *          end of the master soft list and replaces the soft function in all
 *          applicable existing conversion paths. Soft functions are used when
 *          determining which conversion function is appropriate for this path.
 *
 *          The \p name is used only for debugging and should be a short
 *          identifier for the function.
 *
 *          The path is specified by the source and destination datatypes \p
 *          src_id and \p dst_id. For soft conversion functions, only the class
 *          of these types is important.
 *
 *          The type of the conversion function pointer is declared as:
 *          \snippet this H5T_conv_t_snip
 *
 *          The \ref H5T_cdata_t \c struct is declared as:
 *          \snippet this H5T_cdata_t_snip
 *
 * @since 1.6.3 The following change occurred in the \ref H5T_conv_t function:
 *              the \c nelmts parameter type changed to size_t.
 *
 */
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, H5T_conv_t func);
/**
 * \ingroup CONV
 *
 * \brief Removes a conversion function
 *
 * @param pers [in] Conversion function type
 * @param name [in] Name displayed in diagnostic output
 * \type_id{src_id} of source datatype
 * \type_id{dst_id} of destination datatype
 * @param func [in] Function to convert between source and destination datatypes
 *
 * @return \herr_t
 *
 * \details H5Tunregister() removes a conversion function matching criteria
 *          such as soft or hard conversion, source and destination types, and
 *          the conversion function.
 *
 *          If a user is trying to remove a conversion function he registered,
 *          all parameters can be used. If he is trying to remove a library’s
 *          default conversion function, there is no guarantee the \p name and
 *          \p func parameters will match the user’s chosen values. Passing in
 *          some values may cause this function to fail. A good practice is to
 *          pass in NULL as their values.
 *
 *          All parameters are optional. The missing parameters will be used to
 *          generalize the search criteria.
 *
 *          The conversion function pointer type declaration is described in
 *          H5Tregister().
 *
 * @version 1.6.3 The following change occurred in the \ref H5T_conv_t function:
 *                the \c nelmts parameter type changed to size_t.
 *
 */
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, @Cast("const char*") BytePointer name, @Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, H5T_conv_t func);
public static native @Cast("herr_t") int H5Tunregister(@Cast("H5T_pers_t") int pers, String name, @Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, H5T_conv_t func);
/**
 * \ingroup CONV
 *
 * \brief Finds a conversion function
 *
 * \type_id{src_id} of source datatype
 * \type_id{dst_id} of destination datatype
 * @param pcdata [out] Pointer to type conversion data
 *
 * @return Returns a pointer to a suitable conversion function if successful.
 *         Otherwise returns NULL.
 *
 * \details H5Tfind() finds a conversion function that can handle a conversion
 *          from type \p src_id to type \p dst_id. The \p pcdata argument is a
 *          pointer to a pointer to type conversion data which was created and
 *          initialized by the soft type conversion function of this path when
 *          the conversion function was installed on the path.
 *
 */
public static native H5T_conv_t H5Tfind(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @Cast("H5T_cdata_t**") PointerPointer pcdata);
public static native H5T_conv_t H5Tfind(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @ByPtrPtr H5T_cdata_t pcdata);
/**
 * \ingroup CONV
 *
 * \brief Check whether the library’s default conversion is hard conversion
 *
 * \type_id{src_id} of source datatype
 * \type_id{dst_id} of destination datatype
 *
 * @return \htri_t
 *
 * \details H5Tcompiler_conv() determines whether the library’s conversion
 *          function from type \p src_id to type \p dst_id is a compiler (hard)
 *          conversion or not. A compiler conversion uses compiler’s casting; a
 *          library (soft) conversion uses the library’s own conversion
 *          function.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Tcompiler_conv(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup CONV
 *
 * \brief Converts data from one specified datatype to another
 *
 * \type_id{src_id} of source datatype
 * \type_id{dst_id} of destination datatype
 * @param nelmts [in] Size of array \p buf
 * @param buf [in,out] Array containing pre- and post-conversion values
 * @param background [in] Optional background buffer
 * \dxpl_id{plist_id}
 *
 * @return \herr_t
 *
 * \details H5Tconvert() converts \p nelmts elements from a source datatype,
 *          specified by \p src_id, to a destination datatype, \p dst_id. The
 *          source elements are packed in \p buf and on return the destination
 *          elements will be packed in \p buf. That is, the conversion is
 *          performed in place.
 *
 *          The optional background buffer is for use with compound datatypes.
 *          It is an array of \p nelmts values for the destination datatype
 *          which can then be merged with the converted values to recreate the
 *          compound datatype. For instance, background might be an array of
 *          structs with the \c a and \c b fields already initialized and the
 *          conversion of buf supplies the \c c and \c d field values.
 *
 *          The parameter \p plist_id contains the dataset transfer property list
 *          identifier which is passed to the conversion functions. As of
 *          Release 1.2, this parameter is only used to pass along the
 *          variable-length datatype custom allocation information.
 *
 * \note H5Tconvert() will not resize the buffer \p buf; it must be large
 *       enough to hold the larger of the input and output data.
 *
 * @version 1.6.3 \p nelmts parameter type changed to size_t.
 * @version 1.4.0 \p nelmts parameter type changed to hsize_t.
 *
 */
public static native @Cast("herr_t") int H5Tconvert(@Cast("hid_t") long src_id, @Cast("hid_t") long dst_id, @Cast("size_t") long nelmts, Pointer buf, Pointer background,
                         @Cast("hid_t") long plist_id);
/**
 * \ingroup VLEN
 *
 * \brief Reclaims the variable length (VL) datatype memory buffers
 *
 * \type_id
 * \space_id
 * \dxpl_id{plist_id} used to create the buffer
 * @param buf [in] Pointer to the buffer to be reclaimed
 *
 * @return \herr_t
 *
 * \details H5Treclaim() reclaims memory buffers created to store VL datatypes.
 *          It only frees the variable length data in the selection defined in
 *          the dataspace specified by \p space_id. The dataset transfer
 *          property list \p plist_id is required to find the correct
 *          allocation and/or free methods for the variable-length data in the
 *          buffer.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Treclaim(@Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long plist_id, Pointer buf);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */

// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Tpublic_H */


// Parsed from H5Lpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Lpublic.h
 *                      Dec 1 2005
 *                      James Laird
 *
 * Purpose:             Public declarations for the H5L package (links)
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5Lpublic_H
// #define H5Lpublic_H

/* Public headers needed by this file */
// #include "H5public.h"  /* Generic Functions            */
// #include "H5Ipublic.h" /* IDs                      */
// #include "H5Opublic.h" /* Object Headers            */
// #include "H5Tpublic.h" /* Datatypes                */

/*****************/
/* Public Macros */
/*****************/

/**
 * \brief Maximum length of a link's name
 *
 * The maximum length of a link's name is encoded in a 32-bit unsigned integer.
 */
public static native @MemberGetter int H5L_MAX_LINK_NAME_LEN();
public static final int H5L_MAX_LINK_NAME_LEN = H5L_MAX_LINK_NAME_LEN(); /* (4GB - 1) */

/**
 * \brief Macro to indicate operation occurs on same location
 */
public static native @MemberGetter int H5L_SAME_LOC();
public static final int H5L_SAME_LOC = H5L_SAME_LOC(); /* (hid_t) */

/**
 * \brief Current version of the H5L_class_t struct
 */
public static final int H5L_LINK_CLASS_T_VERS = 1;

// #ifdef __cplusplus
// #endif

/*******************/
/* Public Typedefs */
/*******************/

/**
 * \brief  Link class types.
 *
 * Values less than 64 are reserved for the HDF5 library's internal use. Values
 * 64 to 255 are for "user-defined" link class types; these types are defined
 * by HDF5 but their behavior can be overridden by users. Users who want to
 * create new classes of links should contact the HDF5 development team at
 * mailto:help\hdfgroup.org. These values can never change because they appear
 * in HDF5 files.
 */
/** enum H5L_type_t */
public static final int
    /** Invalid link type id         */
    H5L_TYPE_ERROR    = (-1),
    /** Hard link id                 */
    H5L_TYPE_HARD     = 0,
    /** Soft link id                 */
    H5L_TYPE_SOFT     = 1,
    /** External link id             */
    H5L_TYPE_EXTERNAL = 64,
    /** Maximum link type id         */
    H5L_TYPE_MAX      = 255;
/**
 * \brief  Maximum value link value for "built-in" link types
 */
public static final int H5L_TYPE_BUILTIN_MAX = H5L_TYPE_SOFT;
/**
 * \brief Link ids at or above this value are "user-defined" link types.
 */
public static final int H5L_TYPE_UD_MIN = H5L_TYPE_EXTERNAL;
/**
 * \brief Maximum link id value for "user-defined" link types.
 */
public static final int H5L_TYPE_UD_MAX = H5L_TYPE_MAX;
// Targeting ..\H5L_info2_t.java


// Targeting ..\H5L_create_func_t.java


// Targeting ..\H5L_move_func_t.java


// Targeting ..\H5L_copy_func_t.java


// Targeting ..\H5L_traverse_func_t.java


// Targeting ..\H5L_delete_func_t.java


// Targeting ..\H5L_query_func_t.java


// Targeting ..\H5L_class_t.java


// Targeting ..\H5L_iterate2_t.java


// Targeting ..\H5L_elink_traverse_t.java



/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
/**
 * \ingroup H5L
 *
 * \brief Moves a link within an HDF5 file
 *
 * \fgdta_loc_id{src_loc}
 * @param src_name [in] Original link name
 * \fgdta_loc_id{dst_loc}
 * @param dst_name [in] New link name
 * \lcpl_id
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lmove() moves a link within an HDF5 file. The original link,
 *          \p src_name, is removed from \p src_loc and the new link,
 *          \p dst_name, is inserted at dst_loc. This change is
 *          accomplished as an atomic operation.
 *
 *          \p src_loc and \p src_name identify the original link.
 *          \p src_loc is the original location identifier; \p src_name is
 *          the path to the link and is interpreted relative to \p src_loc.
 *
 *          \p dst_loc and \p dst_name identify the new link. \p dst_loc is
 *          either a file or group identifier; \p dst_name is the path to
 *          the link and is interpreted relative to \p dst_loc.
 *
 *          \p lcpl_id and \p lapl_id are the link creation and link access
 *          property lists, respectively, associated with the new link,
 *          \p dst_name.
 *
 *          Through these property lists, several properties are available to
 *          govern the behavior of H5Lmove(). The property controlling creation
 *          of missing intermediate groups is set in the link creation property
 *          list with H5Pset_create_intermediate_group(); H5Lmove() ignores any
 *          other properties in the link creation property list. Properties
 *          controlling character encoding, link traversals, and external link
 *          prefixes are set in the link access property list with
 *          H5Pset_char_encoding(), H5Pset_nlinks(), and H5Pset_elink_prefix(),
 *          respectively.
 *
 * \note Note that H5Lmove() does not modify the value of the link; the new
 *       link points to the same object as the original link pointed to.
 *       Furthermore, if the object pointed to by the original link was already
 *       open with a valid object identifier, that identifier will remain valid
 *       after the call to H5Lmove().
 *
 * \attention Exercise care in moving links as it is possible to render data in
 *            a file inaccessible with H5Lmove(). If the link being moved is on
 *            the only path leading to an HDF5 object, that object may become
 *            permanently inaccessible in the file.
 *
 * @since 1.8.0
 *
 *-------------------------------------------------------------------------
 */
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") long src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc, @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long lcpl_id,
                      @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lmove(@Cast("hid_t") long src_loc, String src_name, @Cast("hid_t") long dst_loc, String dst_name, @Cast("hid_t") long lcpl_id,
                      @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Creates an identical copy of a link with the same creation time and
 *        target.  The new link can have a different name and be in a different
 *        location than the original.
 *
 * \fgdt_loc_id{src_loc}
 * @param src_name [in]   Name of the link to be copied
 * \fgdt_loc_id{dst_loc}
 * @param dst_name [in]   Name to be assigned to the new copy
 * \lcpl_id
 * \lapl_id
 * @return \herr_t
 *
 * \details H5Lcopy() copies the link specified by \p src_name from the location
 *          specified by \p src_loc_id to the location specified by
 *          \p dst_loc_id. The new copy of the link is created with the name
 *          \p dst_name.
 *
 *          If \p dst_loc_id is a file identifier, \p dst_name will be
 *          interpreted relative to that file’s root group.
 *
 *          The new link is created with the creation and access property lists
 *          specified by \p lcpl_id and \p lapl_id. The interpretation of
 *          \p lcpl_id is limited in the manner described in the next paragraph.
 *
 *          H5Lcopy() retains the creation time and the target of the original
 *          link. However, since the link may be renamed, the character
 *          encoding is that specified in \p lcpl_id rather than that of the
 *          original link. Other link creation properties are ignored.
 *
 *          If the link is a soft link, also known as a symbolic link, its
 *          target is interpreted relative to the location of the copy.
 *
 *          Several properties are available to govern the behavior of
 *          H5Lcopy(). These properties are set in the link creation and access
 *          property lists, \p lcpl_id and \p lapl_id, respectively. The
 *          property controlling creation of missing intermediate groups is set
 *          in the link creation property list with
 *          H5Pset_create_intermediate_group(); this function ignores any
 *          other properties in the link creation property list. Properties
 *          controlling character encoding, link traversals, and external link
 *          prefixes are set in the link access property list with
 *          H5Pset_char_encoding(), H5Pset_nlinks(), and
 *          H5Pset_elink_prefix().
 *
 * \note H5Lcopy() does not affect the object that the link points to.
 *
 * \attention H5Lcopy() cannot copy hard links across files as a hard link is
 *            not valid without a target object; to copy objects from one file
 *            to another, see H5Ocopy().
 *
 * @see H5Ocopy()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") long src_loc, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc, @Cast("const char*") BytePointer dst_name, @Cast("hid_t") long lcpl_id,
                      @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcopy(@Cast("hid_t") long src_loc, String src_name, @Cast("hid_t") long dst_loc, String dst_name, @Cast("hid_t") long lcpl_id,
                      @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Creates a hard link to an object
 *
 * \fgdta_loc_id{cur_loc}
 * @param cur_name [in] Name of the target object, which must already exist
 * \fgdta_loc_id{dst_loc}
 * @param dst_name [in] The name of the new link
 * \lcpl_id
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lcreate_hard() creates a new hard link to a pre-existing object
 *          in an HDF5 file.
 *
 *          \p cur_loc and \p cur_name specify the location
 *          and name, respectively, of the target object, i.e., the object that
 *          the new hard link points to. \p dst_loc and \p dst_name specify the
 *          location and name, respectively, of the new hard link.
 *
 *          \p cur_name and \p dst_name are interpreted relative to \p cur_loc
 *          and \p dst_loc, respectively. If \p cur_loc and \p dst_loc are the
 *          same location, the HDF5 macro #H5L_SAME_LOC can be used for either
 *          parameter (but not both).
 *
 *          \p lcpl_id and \p lapl_id are the link creation and access property
 *          lists associated with the new link.
 *
 * \note Hard and soft links are for use only if the target object is in the
 *       current file. If the desired target object is in a different file from
 *       the new link, an external link may be created with
 *       H5Lcreate_external().
 *
 * \note The HDF5 library keeps a count of all hard links pointing to an
 *       object; if the hard link count reaches zero (0), the object will be
 *       deleted from the file. Creating new hard links to an object will
 *       prevent it from being deleted if other links are removed. The
 *       library maintains no similar count for soft links and they can dangle.
 *
 * \note The new link may be one of many that point to that object.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") long cur_loc, @Cast("const char*") BytePointer cur_name, @Cast("hid_t") long dst_loc, @Cast("const char*") BytePointer dst_name,
                             @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_hard(@Cast("hid_t") long cur_loc, String cur_name, @Cast("hid_t") long dst_loc, String dst_name,
                             @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Creates a soft link
 *
 * @param link_target [in] An HDF5 path name
 * \fgdta_loc_id{link_loc_id}
 * @param link_name [in] The name of the new link
 * \lcpl_id
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lcreate_soft() creates a new soft link to an object in an HDF5
 *          file.
 *
 *          \p link_target specifies the HDF5 path name the soft link contains.
 *          \p link_target can be an arbitrary HDF5 path name and is
 *          interpreted only at lookup time. This path may be absolute in the
 *          file or relative to \p link_loc_id.
 *
 *          \p link_loc_id and \p link_name specify the location and name,
 *          respectively, of the new soft link. \p link_name is interpreted
 *          relative to \p link_loc_id and must contain only the name of the soft
 *          link; \p link_name may not contain any additional path elements.
 *
 *          If \p link_loc_id is a group identifier, the object pointed to by
 *          \p link_name will be accessed as a member of that group. If
 *          \p link_loc_id is a file identifier, the object will be accessed as a
 *          member of the file's root group.
 *
 *          \p lcpl_id and \p lapl_id are the link creation and access property
 *          lists associated with the new link.
 *
 *          For instance, if target_path is \c ./foo, \p link_loc_id specifies
 *          \c ./x/y/bar, and the name of the new link is \c new_link, then a
 *          subsequent request for \c ./x/y/bar/new_link will return same the
 *          object as would be found at \c ./foo.
 *
 * \note H5Lcreate_soft() is for use only if the target object is in the
 *       current file. If the desired target object is in a different file from
 *       the new link, use H5Lcreate_external() to create an external link.
 *
 * \note Soft links and external links are also known as symbolic links as they
 *       use a name to point to an object; hard links employ an object’s
 *       address in the file.
 *
 * \note Unlike hard links, a soft link in an HDF5 file is allowed to dangle,
 *       meaning that the target object need not exist at the time that the
 *       link is created.
 *
 * \note The HDF5 library does not keep a count of soft links as it does of
 *       hard links.
 *
 * \note The new link may be one of many that point to that object.
 *
 * @see H5Lcreate_hard(), H5Lcreate_external()
 *
 * @since 1.8.0
 *
 <p>
 */
public static native @Cast("herr_t") int H5Lcreate_soft(@Cast("const char*") BytePointer link_target, @Cast("hid_t") long link_loc_id, @Cast("const char*") BytePointer link_name, @Cast("hid_t") long lcpl_id,
                             @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_soft(String link_target, @Cast("hid_t") long link_loc_id, String link_name, @Cast("hid_t") long lcpl_id,
                             @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Removes a link from a group
 *
 * \fgdta_loc_id
 * @param name [in] Name of the link to delete
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Ldelete() removes the link specified by \p name from the location
 *          \p loc_id.
 *
 *          If the link being removed is a hard link, H5Ldelete() also
 *          decrements the link count for the object to which name points.
 *          Unless there is a duplicate hard link in that group, this action
 *          removes the object to which name points from the group that
 *          previously contained it.
 *
 *          Object headers keep track of how many hard links refer to an
 *          object; when the hard link count, also referred to as the reference
 *          count, reaches zero, the object can be removed from the file. The
 *          file space associated will then be released, i.e., identified in
 *          memory as freespace. Objects which are open are not removed until
 *          all identifiers to the object are closed.
 *
 * \attention Exercise caution in the use of H5Ldelete(); if the link being
 *            removed is on the only path leading to an HDF5 object, that
 *            object may become permanently inaccessible in the file.
 *
 * @see H5Lcreate_hard(), H5Lcreate_soft(), H5Lcreate_external()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Removes the \Emph{n}-th link in a group
 *
 * \fgdta_loc_id
 * @param group_name [in] Name of subject group
 * @param idx_type [in] Index or field which determines the order
 * @param order [in] Order within field or index
 * @param n [in] Link for which to retrieve information
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Ldelete_by_idx() removes the \Emph{n}-th link in a group
 *          according to the specified order, \p order, in the specified index,
 *          \p index.
 *
 *          If \p loc_id specifies the group in which the link resides,
 *          \p group_name can be a dot (\c .).
 *
 * @see H5Ldelete()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                               @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ldelete_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                               @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Returns the value of a link
 *
 * \fgdta_loc_id
 * @param name [in] Link name
 * @param buf [out] The buffer to hold the link value
 * @param size [in] Maximum number of bytes of link value to be returned
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lget_val() returns the value of link \p name. For smbolic links,
 *          this is the path to which the link points, including the null
 *          terminator. For external and user-defined links, it is the link
 *          buffer.
 *
 *          \p size is the size of \p buf and should be the size of the link
 *          value being returned. This size value can be determined through a
 *          call to H5Lget_info(); it is returned in the \c val_size field of
 *          the \ref H5L_info_t \c struct.
 *
 *          If \p size is smaller than the size of the returned value, then the
 *          string stored in \p buf will be truncated to \p size bytes. For
 *          soft links, this means that the value will not be null terminated.
 *
 *          In the case of external links, the target file and object names are
 *          extracted from \p buf by calling H5Lunpack_elink_val().
 *
 *          The link class of link \p name can be determined with a call to
 *          H5Lget_info().
 *
 *          \p lapl_id specifies the link access property list associated with
 *          the link \p name. In the general case, when default link access
 *          properties are acceptable, this can be passed in as #H5P_DEFAULT. An
 *          example of a situation that requires a non-default link access
 *          property list is when the link is an external link; an external
 *          link may require that a link prefix be set in a link access
 *          property list (see H5Pset_elink_prefix()).
 *
 *          This function should be used only after H5Lget_info() has been
 *          called to verify that \p name is a symbolic link. This can be
 *          determined from the \c link_type field of the \ref H5L_info_t
 *          \c struct.
 *
 * \note This function will fail if called on a hard link.
 *
 * @see H5Lget_val_by_idx()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, Pointer buf, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val(@Cast("hid_t") long loc_id, String name, Pointer buf, @Cast("size_t") long size, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Retrieves value of the \Emph{n}-th link in a group, according to the order within an index
 *
 * \fgdta_loc_id
 * @param group_name [in] Group name
 * @param idx_type [in] Type of index
 * @param order [in] Order within field or index
 * @param n [in] Link position for which to retrieve information
 * @param buf [out] The buffer to hold the link value
 * @param size [in] Maximum number of bytes of link value to be returned
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lget_val_by_idx() retrieves the value of the \Emph{n}-th link in
 *          a group, according to the specified order, \p order, within an
 *          index, \p index.
 *
 *          For soft links, the value is an HDF5 path name.
 *
 *          For external links, this is a compound value containing file and
 *          path name information; to use this external link information, it
 *          must first be decoded with H5Lunpack_elink_val()
 *
 *          For user-defined links, this value will be described in the
 *          definition of the user-defined link type.
 *
 *          \p loc_id specifies the location identifier of the group specified
 *          by \p group_name.
 *
 *          \p group_name specifies the group in which the link exists. If
 *          \p loc_id already specifies the group in which the link exists,
 *          \p group_name must be a dot (\c .).
 *
 *          The size in bytes of link_val is specified in \p size. The size
 *          value can be determined through a call to H5Lget_info_by_idx(); it
 *          is returned in the \c val_size field of the \ref H5L_info_t
 *          \c struct. If
 *          size is smaller than the size of the returned value, then the
 *          string stored in link_val will be truncated to size bytes. For soft
 *          links, this means that the value will not be null terminated.
 *
 *          If the type of the link is unknown or uncertain, H5Lget_val_by_idx()
 *          should be called only after the type has been determined via a call
 *          to H5Lget_info_by_idx().
 *
 * \note This function will fail if called on a hard link.
 *
 * @see H5Lget_val()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, Pointer buf, @Cast("size_t") long size,
                                @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_val_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, Pointer buf, @Cast("size_t") long size,
                                @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Determines whether a link with the specified name exists in a group
 *
 * \fgdta_loc_id
 * @param name [in] Link name
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lexists() allows an application to determine whether the link \p
 *          name exists in the location specified by \p loc_id. The link may be
 *          of any type; only the presence of a link with that name is checked.
 *
 *          Note that H5Lexists() verifies only that the target link exists. If
 *          name includes either a relative path or an absolute path to the
 *          target link, intermediate steps along the path must be verified
 *          before the existence of the target link can be safely checked. If
 *          the path is not verified, and an intermediate element of the path
 *          does not exist, H5Lexists() will fail. The example in the next
 *          paragraph illustrates one step-by-step method for verifying the
 *          existence of a link with a relative or absolute path.
 *
 *          \Bold{Example:} Use the following steps to verify the existence of
 *          the link \c datasetD in the \c group group1/group2/softlink_to_group3/,
 *          where \c group1 is a member of the group specified by \c loc_id:
 *
 *          1. First use H5Lexists() to verify that \c group1 exists.
 *          2. If \c group1 exists, use H5Lexists() again, this time with name
 *             set to \c group1/group2, to verify that \c group2 exists.
 *          3. If \c group2 exists, use H5Lexists() with name set to
 *             \c group1/group2/softlink_to_group3 to verify that
 *             \c softlink_to_group3 exists.
 *          4. If \c softlink_to_group3 exists, you can now safely use
 *             H5Lexists() with \c name set to
 *             \c group1/group2/softlink_to_group3/datasetD to verify that the
 *             target link, \c datasetD, exists.
 *
 *          If the link to be verified is specified with an absolute path, the
 *          same approach should be used, but starting with the first link in
 *          the file’s root group. For instance, if \c datasetD were in
 *          \c /group1/group2/softlink_to_group3, the first call to H5Lexists()
 *          would have name set to \c /group1.
 *
 *          Note that this is an outline and does not include all necessary
 *          details. Depending on circumstances, for example, you may need to
 *          verify that an intermediate link points to a group and that a soft
 *          link points to an existing target.
 *
 * \note The behavior of H5Lexists() was changed in the 1.10 release in the
 *       case where the root group, \c "/", is the name of the link. This
 *       change is described below:
 *       <ol>
 *       <li>Let \c file denote a valid HDF5 file identifier, and let \c lapl
 *          denote a valid link access property list identifier. A call to
 *          H5Lexists() with arguments \c file, \c "/", and \c lapl
 *          returns a positive value; in other words,
 *          \Code{H5Lexists(file, "/", lapl)} returns a positive value.
 *          In the HDF5 1.8 release, this function returns 0.</li>
 *       <li>Let \c root denote a valid HDF5 group identifier that refers to the
 *          root group of an HDF5 file, and let \c lapl denote a valid link
 *          access property list identifier. A call to H5Lexists() with
 *          arguments c root, \c "/", and \c lapl returns a positive value;
 *          in other words, \Code{H5Lexists(root, "/", lapl)} returns a positive
 *          value. In the HDF5 1.8 release, this function returns 0.</li>
 *       </ol>
 *       Note that the function accepts link names and path names. This is
 *       potentially misleading to callers, and we plan to separate the
 *       functionality for link names and path names in a future release.
 *
 * \attention H5Lexists() checks the existence of only the final element in a
 *            relative or absolute path; it does not check any other path
 *            elements. The function will therefore fail when both of the
 *            following conditions exist:
 *            - \c name is not local to the group specified by \c loc_id or,
 *              if \c loc_id is something other than a group identifier, \c name
 *              is not local to the root group.
 *            - Any element of the relative path or absolute path in name,
 *              except the target link, does not exist.
 *
 * @version 1.10.0 Function behavior changed in this release. (See the note.)
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Lexists(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Returns information about a link
 *
 * \fgdta_loc_id
 * @param name [in] Link name
 * @param linfo [out] Buffer in which link information is returned
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lget_info2() returns information about the specified link through
 *          the \p linfo argument.
 *
 *          The location identifier, \p loc_id, specifies the location of the
 *          link. A link name, \p name, interpreted relative to \p loc_id,
 *          specifies the link being queried.
 *
 *          \p lapl_id is the link access property list associated with the
 *          link name. In the general case, when default link access properties
 *          are acceptable, this can be passed in as #H5P_DEFAULT. An example
 *          of a situation that requires a non-default link access property
 *          list is when the link is an external link; an external link may
 *          require that a link prefix be set in a link access property list
 *          (see H5Pset_elink_prefix()).
 *
 *          H5Lget_info2() returns information about name in the data structure
 *          H5L_info2_t, which is described below and defined in H5Lpublic.h.
 *          This structure is returned in the buffer \p linfo.
 *          \snippet this H5L_info2_t_snip
 *          In the above struct, \c type specifies the link class. Valid values
 *          include the following:
 *          \link_types
 *          There will be additional valid values if user-defined links have
 *          been registered.
 *
 *          \p corder specifies the link’s creation order position while
 *          \p corder_valid indicates whether the value in corder is valid.
 *
 *          If \p corder_valid is \c TRUE, the value in \p corder is known to
 *          be valid; if \p corder_valid is \c FALSE, the value in \p corder is
 *          presumed to be invalid; \p corder starts at zero (0) and is
 *          incremented by one (1) as new links are created. But
 *          higher-numbered entries are not adjusted when a lower-numbered link
 *          is deleted; the deleted link's creation order position is simply
 *          left vacant. In such situations, the value of \p corder for the
 *          last link created will be larger than the number of links remaining
 *          in the group.
 *
 *          \p cset specifies the character set in which the link name is
 *          encoded. Valid values include the following:
 *          \csets
 *          This value is set with H5Pset_char_encoding().
 *
 *          \c token is the location that a hard link points to, and
 *          \c val_size is the size of a soft link or user defined link value.
 *          H5O_token_t is used in the VOL layer. It is defined in H5public.h
 *          as:
 *          \snippet H5public.h H5O_token_t_snip
 *
 *          If the link is a symbolic link, \c val_size will be the length of
 *          the link value, e.g., the length of the HDF5 path name with a null
 *          terminator.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Lget_info2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info2(@Cast("hid_t") long loc_id, String name, H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Retrieves metadata for a link in a group, according to the order
 *        within a field or index
 *
 * \loc_id
 * @param group_name [in] Group name
 * \idx_type
 * \order
 * @param n [in] Link position for which to retrieve information
 * @param linfo [out] Buffer in which link information is returned
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5get_info_by_idx2() returns the metadata for a link in a group
 *          according to a specified field or index and a specified order. The
 *          link for which information is to be returned is specified by \p
 *          idx_type, \p order, and \p n as follows:
 *
 *          - \p idx_type specifies the field by which the links in \p
 *            group_name are ordered. The links may be indexed on this field,
 *            in which case operations seeking specific links are likely to
 *            complete more quickly.
 *          - \p order specifies the order in which
 *            the links are to be referenced for the purposes of this function.
 *          - \p n specifies the position of the subject link. Note that this
 *            count is zero-based; 0 (zero) indicates that the function will
 *            return the value of the first link; if \p n is 5, the function
 *            will return the value of the sixth link; etc.
 *
 *          For example, assume that \p idx_type, \p order, and \p n are
 *          #H5_INDEX_NAME, #H5_ITER_DEC, and 5, respectively. #H5_INDEX_NAME
 *          indicates that the links are accessed in lexicographic order by
 *          their names. #H5_ITER_DEC specifies that the list be traversed in
 *          reverse order, or in decremented order. And 5 specifies that this
 *          call to the function will return the metadata for the 6th link
 *          (\c n + 1) from the end.
 *
 *          See H5Literate2() for a list of valid values and further discussion
 *          regarding \p idx_type and \p order.
 *
 *          If \p loc_id specifies the group in which the link resides,
 *          \p group_name can be a dot (\c .).
 *
 * @since 1.12.0
 *
 * @see H5Lget_info2()
 *
 */
public static native @Cast("herr_t") int H5Lget_info_by_idx2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lget_info_by_idx2(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5L_info2_t linfo, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5L
 *
 * \brief Retrieves name of the \Emph{n}-th link in a group, according to the
 *        order within a specified field or index
 *
 * \loc_id
 * @param group_name [in] Group name
 * \idx_type
 * \order
 * @param n [in] Link position for which to retrieve information
 * @param name [out] Buffer in which link name is returned
 * @param size [in] Size in bytes of \p name
 * \lapl_id
 *
 * @return Returns the size of the link name if successful; otherwise returns a
 *         negative value.
 *
 * \details H5get_name_by_idx() retrieves the name of the \Emph{n}-th link in a
 *          group, according to the specified order, \p order, within a specified
 *          field or index, \p idx_type.
 *
 *          \p idx_type specifies the index that is used. Valid values include
 *          the following:
 *          \indexes
 *
 *          \p order specifies the order in which objects are inspected along
 *          the index specified in \p idx_type. Valid values include the
 *          following:
 *          \orders
 *
 *          If \p loc_id specifies the group in which the link resides,
 *          \p group_name can be a dot (\c .).
 *
 *          The size in bytes of name is specified in \p size. If \p size is
 *          unknown, it can be determined via an initial H5Lget_name_by_idx()
 *          call with name set to NULL; the function's return value will be the
 *          size of the name.
 *
 * \note Please note that in order for the specified index to correspond to the
 *       creation order index, \p order must be set to #H5_ITER_INC or
 *       #H5_ITER_DEC when calling H5Lget_name_by_idx(). \note The index \p n
 *       passed to H5Lget_name_by_idx() is the index of the link within the
 *       link table, sorted according to \p order and \p idx_type. If order is
 *       #H5_ITER_NATIVE, then the link table is not sorted, and it does not
 *       matter what \p idx_type is. Specifying #H5_ITER_NATIVE does not
 *       guarantee any particular order, only that it remains consistent.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") BytePointer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") ByteBuffer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") byte[] name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") BytePointer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") ByteBuffer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Lget_name_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") byte[] name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
/**
 * \ingroup TRAV
 *
 * \brief Iterates over links in a group, with user callback routine,
 *        according to the order within an index.
 *
 * \group_id{grp_id}
 * \idx_type
 * \order
 * @param idx [in,out] Pointer to an iteration index to allow
 *                    continuing a previous iteration
 * \op
 * \op_data
 * @return \success{The return value of the first operator that returns
 *                  non-zero, or zero if all members were processed with no
 *                  operator returning non-zero.}
 * @return \failure{Negative if an error occurs in the library, or the negative
 *                  value returned by one of the operators.}
 *
 * \details H5Literate2() iterates through the links in a file or
 *          group, \p group_id, in the order of the specified
 *          index, \p idx_type, using a user-defined callback routine
 *          \p op. H5Literate2() does not recursively follow links into
 *          subgroups of the specified group.
 *
 *          Three parameters are used to manage progress of the iteration:
 *          \p idx_type, \p order, and \p idx_p.
 *
 *          \p idx_type specifies the index to be used. If the links have
 *          not been indexed by the index type, they will first be sorted by
 *          that index then the iteration will begin; if the links have been
 *          so indexed, the sorting step will be unnecessary, so the iteration
 *          may begin more quickly.
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index \p idx_type.
 *
 *          \p idx_p tracks the iteration and allows an iteration to be
 *          resumed if it was stopped before all members were processed. It is
 *          passed in by the application with a starting point and returned by
 *          the library with the point at which the iteration stopped.
 *
 *          \p op_data is a user-defined pointer to the data required to
 *          process links in the course of the iteration. This pointer is
 *          passed back to each step of the iteration in the \p op callback
 *          function's \p op_data parameter. \p op is invoked for each link
 *          encounter.
 *
 *          \p op_data is passed to and from each iteration and can be used to
 *          supply or aggregate information across iterations.
 *
 * \remark Same pattern of behavior as H5Giterate().
 *
 * \note This function is also available through the H5Literate() macro.
 *
 * \warning The behavior of H5Literate2() is undefined if the link
 *          membership of \p group_id changes during the iteration.
 *          This does not limit the ability to change link destinations
 *          while iterating, but caution is advised.
 *
 *
 * @since 1.12.0
 *
 * @see H5Literate_by_name2(), H5Lvisit2(), H5Lvisit_by_name2()
 *
 */
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
                          H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
                          H5L_iterate2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Literate2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
                          H5L_iterate2_t op, Pointer op_data);
/**
 * \ingroup TRAV
 *
 * \brief Iterates through links in a group
 *
 * \loc_id
 * @param group_name [in] Group name
 * \idx_type
 * \order
 * @param idx [in,out] iteration position at which to start (\Emph{IN}) or
 *                    position at which an interrupted iteration may be restarted
 *                    (\Emph{OUT})
 * \op
 * \op_data
 * \lapl_id
 * @return \success{The return value of the first operator that returns
 *                  non-zero, or zero if all members were processed with no
 *                  operator returning non-zero.}
 * @return \failure{Negative if an error occurs in the library, or the negative
 *                  value returned by one of the operators.}
 *
 * \details H5Literate_by_name2() iterates through the links in a group
 *          specified by \p loc_id and \p group_name, in the order of the
 *          specified index, \p idx_type, using a user-defined callback routine
 *          \p op. H5Literate_by_name2() does not recursively follow links into
 *          subgroups of the specified group.
 *
 *          \p idx_type specifies the index to be used. If the links have not
 *          been indexed by the index type, they will first be sorted by that
 *          index then the iteration will begin; if the links have been so
 *          indexed, the sorting step will be unnecessary, so the iteration may
 *          begin more quickly. Valid values include the following:
 *          \indexes
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index specified in \p idx_type. Valid values include the
 *          following:
 *          \orders
 *
 *          \p idx_p allows an interrupted iteration to be resumed; it is
 *          passed in by the application with a starting point and returned by
 *          the library with the point at which the iteration stopped.
 *
 * \note H5Literate_by_name2() is not recursive. In particular, if a member of
 *       \p group_name is found to be a group, call it \c subgroup_a,
 *       H5Literate_by_name2() does not examine the members of \c subgroup_a.
 *       When recursive iteration is required, the application must handle the
 *       recursion, explicitly calling H5Literate_by_name2() on discovered
 *       subgroups.
 *
 * \note H5Literate_by_name2() assumes that the membership of the group being
 *       iterated over remains unchanged through the iteration; if any of the
 *       links in the group change during the iteration, the function’s
 *       behavior is undefined. Note, however, that objects pointed to by the
 *       links can be modified.
 *
 * \note H5Literate_by_name2() is the same as H5Literate2(), except that
 *       H5Literate2() always proceeds in alphanumeric order.
 *
 * @since 1.12.0
 *
 * @see H5Literate(), H5Lvisit()
 *
 */
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Literate_by_name2(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5L_iterate2_t op, Pointer op_data,
                                  @Cast("hid_t") long lapl_id);
/**
 * \ingroup TRAV
 *
 * \brief Recursively visits all links starting from a specified group
 *
 * \group_id{grp_id}
 * \idx_type
 * \order
 * \op
 * \op_data
 * @return \success{The return value of the first operator that returns
 *                  non-zero, or zero if all members were processed with no
 *                  operator returning non-zero.}
 * @return \failure{Negative if an error occurs in the library, or the negative
 *                  value returned by one of the operators.}
 *
 * \details H5Lvisit2() is a recursive iteration function to visit all links in
 *          and below a group in an HDF5 file, thus providing a mechanism for
 *          an application to perform a common set of operations across all of
 *          those links or a dynamically selected subset. For non-recursive
 *          iteration across the members of a group, see H5Literate2().
 *
 *          The group serving as the root of the iteration is specified by its
 *          group or file identifier, \p group_id.
 *
 *          Two parameters are used to establish the iteration: \p idx_type and
 *          \p order.
 *
 *          \p idx_type specifies the index to be used. If the links have not
 *          been indexed by the index type, they will first be sorted by that
 *          index then the iteration will begin; if the links have been so
 *          indexed, the sorting step will be unnecessary, so the iteration may
 *          begin more quickly. Valid values include the following:
 *          \indexes
 *
 *          Note that the index type passed in \p idx_type is a best effort
 *          setting. If the application passes in a value indicating iteration
 *          in creation order and a group is encountered that was not tracked
 *          in creation order, that group will be iterated over in
 *          lexicographic order by name, or name order. (Name order is the
 *          native order used by the HDF5 library and is always available.)
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index specified in \p idx_type. Valid values include the
 *          following:
 *          \orders
 *
 *          \p op is a callback function of type \ref H5L_iterate2_t that is invoked
 *          for each link encountered.
 *          \snippet this H5L_iterate2_t_snip
 *
 *          The \ref H5L_info2_t struct is defined (in H5Lpublic.h) as follows:
 *          \snippet this H5L_info2_t_snip
 *
 *          The possible return values from the callback function, and the
 *          effect of each, are as follows:
 *          \li Zero causes the visit iterator to continue, returning zero when
 *              all group members have been processed.
 *          \li  A positive value causes the visit iterator to immediately
 *               return that positive value, indicating short-circuit success.
 *          \li A negative value causes the visit iterator to immediately
 *              return that value, indicating failure.
 *
 *          The H5Lvisit2() \p op_data parameter is a user-defined pointer to
 *          the data required to process links in the course of the iteration.
 *          This pointer is passed back to each step of the iteration in the
 *          \p op callback function's \p op_data parameter.
 *
 *          H5Lvisit2() and H5Ovisit2() are companion functions: one for
 *          examining and operating on links; the other for examining and
 *          operating on the objects that those links point to. Both functions
 *          ensure that by the time the function completes successfully, every
 *          link or object below the specified point in the file has been
 *          presented to the application for whatever processing the
 *          application requires.
 *
 * @since 1.12.0
 *
 * @see H5Literate()
 *
 */
public static native @Cast("herr_t") int H5Lvisit2(@Cast("hid_t") long grp_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5L_iterate2_t op,
                        Pointer op_data);
/**
 * \ingroup TRAV
 *
 * \brief Recursively visits all links starting from a specified group
 *
 * \loc_id
 * @param group_name [in] Group name
 * \idx_type
 * \order
 * \op
 * \op_data
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lvisit_by_name2() is a recursive iteration function to visit all
 *          links in and below a group in an HDF5 file, thus providing a
 *          mechanism for an application to perform a common set of operations
 *          across all of those links or a dynamically selected subset. For
 *          non-recursive iteration across the members of a group, see
 *          H5Literate2().
 *
 *          The group serving as the root of the iteration is specified by the
 *          \p loc_id / \p group_name parameter pair. \p loc_id specifies a
 *          file or group; group_name specifies either a group in the file
 *          (with an absolute name based in the file’s root group) or a group
 *          relative to \p loc_id. If \p loc_id fully specifies the group that
 *          is to serve as the root of the iteration, group_name should be '.'
 *          (a dot). (Note that when \p loc_id fully specifies the the group
 *          that is to serve as the root of the iteration, the user may wish to
 *          consider using H5Lvisit2() instead of H5Lvisit_by_name2().)
 *
 *          Two parameters are used to establish the iteration: \p idx_type and
 *          \p order.
 *
 *          \p idx_type specifies the index to be used. If the links have not
 *          been indexed by the index type, they will first be sorted by that
 *          index then the iteration will begin; if the links have been so
 *          indexed, the sorting step will be unnecessary, so the iteration may
 *          begin more quickly. Valid values include the following:
 *          \indexes
 *
 *          Note that the index type passed in \p idx_type is a best effort
 *          setting. If the application passes in a value indicating iteration
 *          in creation order and a group is encountered that was not tracked
 *          in creation order, that group will be iterated over in
 *          lexicographic order by name, or name order. (Name order is the
 *          native order used by the HDF5 library and is always available.)
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index specified in \p idx_type. Valid values include the
 *          following:
 *          \orders
 *
 *          The \p op callback function, the related \ref H5L_info2_t
 *          \c struct, and the effect that the callback function's return value
 *          has on the application are described in H5Lvisit2().
 *
 *          The H5Lvisit_by_name2() \p op_data parameter is a user-defined
 *          pointer to the data required to process links in the course of the
 *          iteration. This pointer is passed back to each step of the
 *          iteration in the callback function's \p op_data parameter.
 *
 *          \p lapl_id is a link access property list. In the general case,
 *          when default link access properties are acceptable, this can be
 *          passed in as #H5P_DEFAULT. An example of a situation that requires
 *          a non-default link access property list is when the link is an
 *          external link; an external link may require that a link prefix be
 *          set in a link access property list (see H5Pset_elink_prefix()).
 *
 *          H5Lvisit_by_name2() and H5Ovisit_by_name2() are companion
 *          functions: one for examining and operating on links; the other for
 *          examining and operating on the objects that those links point to.
 *          Both functions ensure that by the time the function completes
 *          successfully, every link or object below the specified point in the
 *          file has been presented to the application for whatever processing
 *          the application requires.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Lvisit_by_name2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lvisit_by_name2(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, H5L_iterate2_t op, Pointer op_data, @Cast("hid_t") long lapl_id);
/* UD link functions */
/**
 * \ingroup H5L
 *
 * \brief Creates a link of a user-defined type
 *
 * \loc_id{link_loc_id}
 * @param link_name [in] Link name
 * @param link_type [in] User-defined link class
 * @param udata [in] User-supplied link information
 * @param udata_size [in] Size of udata buffer
 * \lcpl_id
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Lcreate_ud() creates a link of user-defined type \p link_type
 *          named \p link_name at the location specified in \p link_loc_id with
 *          user-specified data \p udata.
 *
 *          \p link_name is interpreted relative to \p link_loc_id.
 *
 *          Valid values for the link class of the new link, \p link_type,
 *          include #H5L_TYPE_EXTERNAL and any user-defined link classes that
 *          have been registered with the library. See H5Lregister() for
 *          further information.
 *
 *          The format of the information pointed to by \p udata is defined by
 *          the user. \p udata_size specifies the size of the \p udata buffer.
 *          \p udata may be NULL if \p udata_size is zero (0).
 *
 *          The property lists specified by \p lcpl_id and \p lapl_id specify
 *          properties used to create and access the link.
 *
 * \note The external link type, #H5L_TYPE_EXTERNAL, included in the HDF5
 *       library distribution, is implemented as a user-defined link type. This
 *       was done, in part, to provide a model for the implementation of other
 *       user-defined links.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") long link_loc_id, @Cast("const char*") BytePointer link_name, @Cast("H5L_type_t") int link_type, @Const Pointer udata,
                           @Cast("size_t") long udata_size, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_ud(@Cast("hid_t") long link_loc_id, String link_name, @Cast("H5L_type_t") int link_type, @Const Pointer udata,
                           @Cast("size_t") long udata_size, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
/**
 * \ingroup H5LA
 *
 * \brief Registers a user-defined link class or changes behavior of an
 *        existing class
 *
 * @param cls [in] Pointer to a buffer containing the struct describing the
 *            user-defined link class
 *
 * @return \herr_t
 *
 * \details H5Lregister() registers a class of user-defined links, or changes
 *          the behavior of an existing class.
 *
 *          \p cls is a pointer to a buffer containing a copy of the
 *          H5L_class_t struct. This struct is defined in H5Lpublic.h as
 *          follows:
 *          \snippet this H5L_class_t_snip
 *
 *          The class definition passed with \p cls must include at least the
 *          following:
 *          \li An H5L_class_t version (which should be #H5L_LINK_CLASS_T_VERS)
 *          \li A link class identifier, \c class_id
 *          \li A traversal function, \c trav_func
 *
 *          Remaining \c struct members are optional and may be passed as NULL.
 *
 *          The link class passed in \c class_id must be in the user-definable
 *          range between #H5L_TYPE_UD_MIN and #H5L_TYPE_UD_MAX
 *          (see the table below) and will override
 *          any existing link class with that identifier.
 *
 *          As distributed, valid values of \c class_id used in HDF5 include
 *          the following (defined in H5Lpublic.h):
 *          \link_types
 *
 *          The hard and soft link class identifiers cannot be modified or
 *          reassigned, but the external link class is implemented as an
 *          example in the user-definable link class identifier range.
 *          H5Lregister() is used to register additional link classes. It could
 *          also be used to modify the behavior of the external link class,
 *          though that is not recommended.
 *
 *          The following table summarizes existing link types and values and
 *          the reserved and user-definable link class identifier value ranges.
 *          <table>
 *            <tr>
 *              <th>Link class identifier or Value range</th>
 *              <th>Description</th>
 *              <th>Link class or label</th>
 *            </tr>
 *            <tr>
 *              <td>0 to 63</td>
 *              <td>Reserved range</td>
 *              <td></td>
 *            </tr>
 *            <tr>
 *              <td>64 to 255</td>
 *              <td>User-definable range</td>
 *              <td></td>
 *            </tr>
 *            <tr>
 *              <td>64</td>
 *              <td>Minimum user-defined value</td>
 *              <td>#H5L_TYPE_UD_MIN</td>
 *            </tr>
 *            <tr>
 *              <td>64</td>
 *              <td>External link</td>
 *              <td>#H5L_TYPE_EXTERNAL</td>
 *            </tr>
 *            <tr>
 *              <td>255</td>
 *              <td>Maximum user-defined value</td>
 *              <td>#H5L_TYPE_UD_MAX</td>
 *            </tr>
 *            <tr>
 *              <td>255</td>
 *              <td>Maximum value</td>
 *              <td>#H5L_TYPE_MAX</td>
 *            </tr>
 *            <tr>
 *              <td>-1</td>
 *              <td>Error</td>
 *              <td>#H5L_TYPE_ERROR</td>
 *            </tr>
 *          </table>
 *
 *          Note that HDF5 internally registers user-defined link classes only
 *          by the numeric value of the link class identifier. An application,
 *          on the other hand, will generally use a name for a user-defined
 *          class, if for no other purpose than as a variable name. Assume,
 *          for example, that a complex link type is registered with the link
 *          class identifier 73 and that the code includes the following
 *          assignment:
 *          <pre>{@code
 *          H5L_TYPE_COMPLEX_A = 73
 *          }</pre>
 *          The application can refer to the link class with a term,
 *          \c  H5L_TYPE_COMPLEX_A, that conveys meaning to a human reviewing
 *          the code, while HDF5 recognizes it by the more cryptic numeric
 *          identifier, 73.
 *
 * \attention Important details and considerations include the following:
 *            \li If you plan to distribute files or software with a
 *                user-defined link class, please contact the Help Desk at
 *                The HDF Group to help prevent collisions between \c class_id
 *                values. See below.
 *            \li As distributed with HDF5, the external link class is
 *                implemented as an example of a user-defined link class with
 *                #H5L_TYPE_EXTERNAL equal to #H5L_TYPE_UD_MIN. \c class_id in
 *                the H5L_class_t \c struct must not equal #H5L_TYPE_UD_MIN
 *                unless you intend to overwrite or modify the behavior of
 *                external links.
 *            \li H5Lregister() can be used only with link class identifiers
 *                in the user-definable range (see table above).
 *            \li The hard and soft links defined by the HDF5 library,
 *                #H5L_TYPE_HARD and #H5L_TYPE_SOFT, reside in the reserved
 *                range below #H5L_TYPE_UD_MIN and cannot be redefined or
 *                modified.
 *            \li H5Lis_registered() can be used to determine whether a desired
 *                link class identifier is available. \Emph{Note that this
 *                function will tell you only whether the link class identifier
 *                has been registered with the installed copy of HDF5; it
 *                cannot tell you whether the link class has been registered
 *                with The HDF Group.}
 *            \li #H5L_TYPE_MAX is the maximum allowed value for a link type
 *                identifier.
 *            \li #H5L_TYPE_UD_MIN equals #H5L_TYPE_EXTERNAL.
 *            \li #H5L_TYPE_UD_MAX equals #H5L_TYPE_MAX.
 *            \li #H5L_TYPE_ERROR indicates that an error has occurred.
 *
 * \note \Bold{Registration with The HDF Group:}\n
 *       There are sometimes reasons to take a broader approach to registering
 *       a user-defined link class than just invoking H5Lregister(). For
 *       example:
 *       \li A user-defined link class is intended for use across an
 *           organization, among collaborators, or across a community of users.
 *       \li An application or library overlying HDF5 invokes a user-defined
 *           link class that must be shipped with the software.
 *       \li Files are distributed that make use of a user-defined link class.
 *       \li Or simply, a specific user-defined link class is thought to be
 *           widely useful.
 *
 *       In such cases, you are encouraged to register that link class with
 *       The HDF Group's Helpdesk. The HDF Group maintains a registry of known
 *       user-defined link classes and tracks the selected link class
 *       identifiers. This registry is intended to reduce the risk of
 *       collisions between \c class_id values and to help coordinate the use
 *       of specialized link classes.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lregister(@Const H5L_class_t cls);
/**
 * \ingroup H5LA
 *
 * \brief Unregisters a class of user-defined links
 *
 * @param id [in] User-defined link class identifier
 *
 * @return \herr_t
 *
 * \details H5Lunregister() unregisters a class of user-defined links,
 *          preventing them from being traversed, queried, moved, etc.
 *
 * \note A link class can be re-registered using H5Lregister().
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lunregister(@Cast("H5L_type_t") int id);
/**
 * \ingroup H5LA
 *
 * \brief Determines whether a class of user-defined links is registered
 *
 * @param id [in] User-defined link class identifier
 *
 * @return \htri_t
 *
 * \details H5Lis_registered() tests whether a user-defined link class is
 *          currently registered, either by the HDF5 library or by the user
 *          through the use of H5Lregister().
 *
 * \note A link class must be registered to create new links of that type or to
 *       traverse existing links of that type.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Lis_registered(@Cast("H5L_type_t") int id);

/* External link functions */
/**
 * \ingroup H5L
 *
 * \brief Decodes external link information
 *
 * @param ext_linkval [in] Buffer containing external link information
 * @param link_size [in] Size, in bytes, of the \p ext_linkval buffer
 * @param flags [out] External link flags, packed as a bitmap (\Emph{Reserved as
 *                   a bitmap for flags; no flags are currently defined, so the
 *                   only valid value * is 0.})
 * @param filename [out] Returned filename @param obj_path [out] Returned
 * object path, relative to \p filename
 *
 * @return \herr_t
 *
 * \details H5Lunpack_elink_val() decodes the external link information
 *          returned by H5Lget_val() in the \p ext_linkval buffer.
 *
 *          \p ext_linkval should be the buffer set by H5Lget_val() and will
 *          consist of two NULL-terminated strings, the filename and object
 *          path, one after the other.
 *
 *          Given this buffer, H5Lunpack_elink_val() creates pointers to the
 *          filename and object path within the buffer and returns them in
 *          \p filename and \p obj_path, unless they are passed in as NULL.
 *
 *          H5Lunpack_elink_val() requires that \p ext_linkval contain a
 *          concatenated pair of null-terminated strings, so use of this
 *          function on a string that is not an external link \p udata buffer
 *          may result in a segmentation fault. This failure can be avoided by
 *          adhering to the following procedure:
 *          <ol>
 *            <li>Call H5Lget_info() to get the link type and the size of the
 *                link value.<li>
 *            <li>Verify that the link is an external link, i.e., that its link
 *                type is #H5L_TYPE_EXTERNAL.</li>
 *            <li>Call H5Lget_val() to get the link value.</li>
 *            <li>Call H5Lunpack_elink_val() to unpack that value.</li>
 *          </ol>
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size, @Cast("unsigned*") IntPointer flags,
                                  @Cast("const char**") PointerPointer filename, @Cast("const char**") PointerPointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size, @Cast("unsigned*") IntPointer flags,
                                  @Cast("const char**") @ByPtrPtr BytePointer filename, @Cast("const char**") @ByPtrPtr BytePointer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size, @Cast("unsigned*") IntBuffer flags,
                                  @Cast("const char**") @ByPtrPtr ByteBuffer filename, @Cast("const char**") @ByPtrPtr ByteBuffer obj_path);
public static native @Cast("herr_t") int H5Lunpack_elink_val(@Const Pointer ext_linkval, @Cast("size_t") long link_size, @Cast("unsigned*") int[] flags,
                                  @Cast("const char**") @ByPtrPtr byte[] filename, @Cast("const char**") @ByPtrPtr byte[] obj_path);
/**
 * \ingroup H5L
 *
 * \brief Creates an external link, a soft link to an object in a different file.
 *
 * @param file_name [in]   Name of the target file containing the target object.
 * @param obj_name [in]    Path within the target file to the target object
 * \fgdt_loc_id{link_loc_id}
 * @param link_name [in]   Name of the new link, relative to \p link_loc_id
 * \lcpl_id
 * \lapl_id
 * @return \herr_t
 *
 * \details H5Lcreate_external() creates a new external link. An external link
 *          is a soft link to an object in a different HDF5 file from the
 *          location of the link, i.e., to an external object.
 *
 *          \p file_name identifies the target file containing the target
 *          object; \p obj_name specifies the path of the target object within
 *          that file. \p obj_name must be an absolute pathname in
 *          \p file_name, i.e., it must start at the target file’s root group,
 *          but it is not interpreted until an application attempts to traverse
 *          it.
 *
 *          \p link_loc_id and \p link_name specify the location and name,
 *          respectively, of the new link. \p link_name is interpreted relative
 *          to \p link_loc_id.
 *
 *          \p lcpl_id is the link creation property list used in creating the
 *          new link.
 *
 *          \p lapl_id is the link access property list used in traversing the
 *          new link. Note that an external file opened by the traversal of an
 *          external link is always opened with the weak file close degree
 *          property setting, #H5F_CLOSE_WEAK (see H5Pset_fclose_degree());
 *          any file close degree property setting in \p lapl_id is ignored.
 *
 *          An external link behaves similarly to a soft link, and like a soft
 *          link in an HDF5 file, it may dangle: the target file and object
 *          need not exist at the time that the external link is created.
 *
 *          When the external link \p link_name is accessed, the library will
 *          search for the target file \p file_name as described below:
 *
 *          - If \p file_name is a relative pathname, the following steps are
 *            performed:
 *            - The library will get the prefix(es) set in the environment
 *              variable \c HDF5_EXT_PREFIX and will try to prepend each prefix
 *              to \p file_name to form a new \p file_name.
 *            - If the new \p file_name does not exist or if \c HDF5_EXT_PREFIX
 *              is not set, the library will get the prefix set via
 *              H5Pset_elink_prefix() and prepend it to \p file_name to form a
 *              new \p file_name.
 *            - If the new \p file_name does not exist or no prefix is being
 *              set by H5Pset_elink_prefix(), then the path of the file
 *              associated with \p link_loc_id is obtained. This path can be
 *              the absolute path or the current working directory plus the
 *              relative path of that file when it is created/opened. The
 *              library will prepend this path to \p file_name to form a new
 *              \p file_name.
 *            - If the new \p file_name does not exist, then the library will
 *              look for \p file_name and will return failure/success
 *              accordingly.
 *          - If \p file_name is an absolute pathname, the library will first
 *            try to find \p file_name. If \p file_name does not exist,
 *            \p file_name is stripped of directory paths to form a new
 *            \p file_name. The search for the new \p file_name then follows
 *            the same steps as described above for a relative pathname. See
 *            examples below illustrating how target_file_name is stripped to
 *            form a new \p file_name.
 *
 *          Note that \p file_name is considered to be an absolute pathname
 *          when the following condition is true:
 *
 *          - For Unix, the first character of \p file_name is a slash (\c /).
 *            For example, consider a \p file_name of \c /tmp/A.h5.
 *            If that target file does not exist, the new \p file_name after
 *            stripping will be \c A.h5.
 *          - For Windows, there are 6 cases:
 *            -# \p file_name is an absolute drive with absolute pathname.
 *               For example, consider a \p file_name of \c /tmp/A.h5. If that
 *               target file does not exist, the new \p file_name after
 *               stripping will be \c A.h5.
 *            -# \p file_name is an absolute pathname without specifying drive
 *               name. For example, consider a \p file_name of \c /tmp/A.h5.
 *               If that target file does not exist, the new \p file_name after
 *               stripping will be \c A.h5.
 *            -# \p file_name is an absolute drive with relative pathname.
 *               For example, consider a \p file_name of \c /tmp/A.h5. If that
 *               target file does not exist, the new \p file_name after
 *               stripping will be \c tmp\A.h5.
 *            -# \p file_name is in UNC (Uniform Naming Convention) format with
 *               server name, share name, and pathname. For example, consider
 *               a \p file_name of \c /tmp/A.h5. If that target file does not
 *               exist, the new \p file_name after stripping will be \c A.h5.
 *            -# \p file_name is in Long UNC (Uniform Naming Convention) format
 *               with server name, share name, and pathname. For example,
 *               consider a \p file_name of \c /tmp/A.h5. If that target file
 *               does not exist, the new \p file_name after stripping will be
 *               \c A.h5.
 *            -# \p file_name is in Long UNC (Uniform Naming Convention) format
 *               with an absolute drive and an absolute pathname. For example,
 *               consider a \p file_name of \c /tmp/A.h5. If that target file
 *               does not exist, the new \p file_name after stripping will be
 *               \c A.h5.
 *
 *          The library opens target file \p file_name with the file access
 *          property list that is set via H5Pset_elink_fapl() when the external
 *          link link_name is accessed. If no such property list is set, the
 *          library uses the file access property list associated with the file
 *          of \p link_loc_id to open the target file.
 *
 *          If an application requires additional control over file access
 *          flags or the file access property list, see H5Pset_elink_cb(); this
 *          function enables the use of an external link callback function as
 *          described in H5L_elink_traverse_t().
 *
 * \attention A file close degree property setting (H5Pset_fclose_degree()) in
 *            the external link file access property list or in the external
 *            link callback function will be ignored. A file opened by means of
 *            traversing an external link is always opened with the weak file
 *            close degree property setting, #H5F_CLOSE_WEAK .
 *
 * @see H5Lcreate_hard(), H5Lcreate_soft(), H5Lcreate_ud()
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Lcreate_external(@Cast("const char*") BytePointer file_name, @Cast("const char*") BytePointer obj_name, @Cast("hid_t") long link_loc_id,
                                 @Cast("const char*") BytePointer link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Lcreate_external(String file_name, String obj_name, @Cast("hid_t") long link_loc_id,
                                 String link_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Lpublic_H */


// Parsed from H5Opublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Opublic.h
 *                      Aug  5 1997
 *                      Robb Matzke
 *
 * Purpose:             Public declarations for the H5O (object header)
 *                      package.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5Opublic_H
// #define H5Opublic_H

/* Public headers needed by this file */
// #include "H5public.h"  /* Generic Functions            */
// #include "H5Ipublic.h" /* IDs                          */
// #include "H5Lpublic.h" /* Links                        */

/*****************/
/* Public Macros */
/*****************/

/* Flags for object copy (H5Ocopy) */
/** Copy only immediate members */
public static final int H5O_COPY_SHALLOW_HIERARCHY_FLAG =     (0x0001);
/** Expand soft links into new objects */
public static final int H5O_COPY_EXPAND_SOFT_LINK_FLAG =      (0x0002);
/** Expand external links into new objects */
public static final int H5O_COPY_EXPAND_EXT_LINK_FLAG =       (0x0004);
/** Copy objects that are pointed by references */
public static final int H5O_COPY_EXPAND_REFERENCE_FLAG =      (0x0008);
/** Copy object without copying attributes */
public static final int H5O_COPY_WITHOUT_ATTR_FLAG =          (0x0010);
/** Copy NULL messages (empty space) */
public static final int H5O_COPY_PRESERVE_NULL_FLAG =         (0x0020);
/** Merge committed datatypes in dest file */
public static final int H5O_COPY_MERGE_COMMITTED_DTYPE_FLAG = (0x0040);
/** All object copying flags (for internal checking) */
public static final int H5O_COPY_ALL =                        (0x007F);

/* Flags for shared message indexes.
 * Pass these flags in using the mesg_type_flags parameter in
 * H5P_set_shared_mesg_index.
 * (Developers: These flags correspond to object header message type IDs,
 * but we need to assign each kind of message to a different bit so that
 * one index can hold multiple types.)
 */
/** No shared messages */
public static final int H5O_SHMESG_NONE_FLAG =    0x0000;
/** Simple Dataspace Message.  */
public static native @MemberGetter int H5O_SHMESG_SDSPACE_FLAG();
public static final int H5O_SHMESG_SDSPACE_FLAG = H5O_SHMESG_SDSPACE_FLAG();
/** Datatype Message.  */
public static native @MemberGetter int H5O_SHMESG_DTYPE_FLAG();
public static final int H5O_SHMESG_DTYPE_FLAG = H5O_SHMESG_DTYPE_FLAG();
/** Fill Value Message. */
public static native @MemberGetter int H5O_SHMESG_FILL_FLAG();
public static final int H5O_SHMESG_FILL_FLAG = H5O_SHMESG_FILL_FLAG();
/** Filter pipeline message.  */
public static native @MemberGetter int H5O_SHMESG_PLINE_FLAG();
public static final int H5O_SHMESG_PLINE_FLAG = H5O_SHMESG_PLINE_FLAG();
/** Attribute Message.  */
public static native @MemberGetter int H5O_SHMESG_ATTR_FLAG();
public static final int H5O_SHMESG_ATTR_FLAG = H5O_SHMESG_ATTR_FLAG();
public static final int H5O_SHMESG_ALL_FLAG =                                                                                  
    (H5O_SHMESG_SDSPACE_FLAG | H5O_SHMESG_DTYPE_FLAG | H5O_SHMESG_FILL_FLAG | H5O_SHMESG_PLINE_FLAG |        
     H5O_SHMESG_ATTR_FLAG);

/* clang-format off */
/* Object header status flag definitions */
/** 2-bit field indicating # of bytes to store the size of chunk 0's data */
public static final int H5O_HDR_CHUNK0_SIZE =             0x03;
/** Attribute creation order is tracked */
public static final int H5O_HDR_ATTR_CRT_ORDER_TRACKED =  0x04;
/** Attribute creation order has index */
public static final int H5O_HDR_ATTR_CRT_ORDER_INDEXED =  0x08;
/** Non-default attribute storage phase change values stored */
public static final int H5O_HDR_ATTR_STORE_PHASE_CHANGE = 0x10;
/** Store access, modification, change & birth times for object */
public static final int H5O_HDR_STORE_TIMES =             0x20;
public static final int H5O_HDR_ALL_FLAGS =                                                                                    
    (H5O_HDR_CHUNK0_SIZE | H5O_HDR_ATTR_CRT_ORDER_TRACKED | H5O_HDR_ATTR_CRT_ORDER_INDEXED |                 
     H5O_HDR_ATTR_STORE_PHASE_CHANGE | H5O_HDR_STORE_TIMES);
/* clang-format on */

/* Maximum shared message values.  Number of indexes is 8 to allow room to add
 * new types of messages.
 */
public static final int H5O_SHMESG_MAX_NINDEXES =  8;
public static final int H5O_SHMESG_MAX_LIST_SIZE = 5000;

/* Flags for H5Oget_info.
 * These flags determine which fields will be filled in the H5O_info_t
 * struct.
 */
/** Fill in the fileno, addr, type, and rc fields */
public static final int H5O_INFO_BASIC =     0x0001;
/** Fill in the atime, mtime, ctime, and btime fields */
public static final int H5O_INFO_TIME =      0x0002;
/** Fill in the num_attrs field */
public static final int H5O_INFO_NUM_ATTRS = 0x0004;
public static final int H5O_INFO_ALL =       (H5O_INFO_BASIC | H5O_INFO_TIME | H5O_INFO_NUM_ATTRS);

/** <!-- [H5O_native_info_fields_snip] -->
/**
 * Flags for H5Oget_native_info().  These flags determine which fields will be
 * filled in the \ref H5O_native_info_t struct.
 */
/** Fill in the hdr field */
public static final int H5O_NATIVE_INFO_HDR =       0x0008;
/** Fill in the meta_size field */
public static final int H5O_NATIVE_INFO_META_SIZE = 0x0010;
public static final int H5O_NATIVE_INFO_ALL =       (H5O_NATIVE_INFO_HDR | H5O_NATIVE_INFO_META_SIZE);
/** <!-- [H5O_native_info_fields_snip] --> */

/* Convenience macro to check if the token is the 'undefined' token value */
// #define H5O_IS_TOKEN_UNDEF(token) (!HDmemcmp(&(token), &(H5O_TOKEN_UNDEF), sizeof(H5O_token_t)))

/*******************/
/* Public Typedefs */
/*******************/

/** <!-- [H5O_type_t_snip] -->
/**
 * Types of objects in file
 */
/** enum H5O_type_t */
public static final int
    /** Unknown object type        */
    H5O_TYPE_UNKNOWN = -1,
    /** Object is a group          */
    H5O_TYPE_GROUP = 0,
    /** Object is a dataset        */
    H5O_TYPE_DATASET = 1,
    /** Object is a named data type    */
    H5O_TYPE_NAMED_DATATYPE = 2,
    /** Object is a map */
    H5O_TYPE_MAP = 3,
    /** Number of different object types (must be last!) */
    H5O_TYPE_NTYPES = 4;
// Targeting ..\H5O_hdr_info_t.java


// Targeting ..\H5O_info2_t.java


// Targeting ..\H5O_native_info_t.java


/** <!-- [H5O_native_info_t_snip] -->
<p>
/**
 * Typedef for message creation indexes
 */
// Targeting ..\H5O_iterate2_t.java


/** <!-- [H5O_iterate2_t_snip] -->
 <p>
 *  <!-- [H5O_mcdt_search_ret_t_snip] --> */
/** enum H5O_mcdt_search_ret_t */
public static final int
    /** Abort H5Ocopy */
    H5O_MCDT_SEARCH_ERROR = -1,
    /** Continue the global search of all committed datatypes in the destination file
                           */
    H5O_MCDT_SEARCH_CONT = 0,
    /** Stop the search, but continue copying.  The committed datatype will be copied
                             but not merged. */
    H5O_MCDT_SEARCH_STOP = 1;
// Targeting ..\H5O_mcdt_search_cb_t.java


/** <!-- [H5O_mcdt_search_cb_t_snip] -->
<p>
/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus */
// #endif

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Opens an object in an HDF5 file by location identifier and path name.
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] Path to the object; relative to \p loc_id
 * \lapl_id
 *
 * @return \hid_tv{object}
 *
 * \details H5Oopen() opens a group, dataset, or committed (named) datatype
 *          specified by a location, \p loc_id, and a path name, \p name, in an HDF5 file.
 *
 *          This function opens the object in the same manner as H5Gopen(), H5Topen(), and H5Dopen().
 *          However, H5Oopen() does not require the type of object to be known beforehand.
 *          This can be useful with user-defined links, for instance, when only a path may be known.
 *
 *          H5Oopen() cannot be used to open a dataspace, attribute, property list, or file.
 *
 *          Once an object of unknown type has been opened with H5Oopen(),
 *          the type of that object can be determined by means of an H5Iget_type() call.
 *
 *          \p loc_id may be a file, group, dataset, named datatype, or attribute.
 *          If an attribute is specified for \p loc_id then the object where the
 *          attribute is attached will be accessed.
 *
 *          \p name must be the path to that object relative to \p loc_id.
 *
 *          \p lapl_id is the link access property list associated with the link pointing to
 *          the object.  If default link access properties are appropriate, this can be
 *          passed in as #H5P_DEFAULT.
 *
 *          When it is no longer needed, the opened object should be closed with
 *          H5Oclose(), H5Gclose(), H5Tclose(), or H5Dclose().
 *
 * @version 1.8.1 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Oopen(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Oopen(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Opens an object in an HDF5 file using its VOL independent token
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param token [in] Object token
 *
 * @return \hid_ti{object}
 *
 * \details H5Oopen_by_token() opens an object specified by the object
 *          identifier, \p loc_id and object token, \p token.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("hid_t") long H5Oopen_by_token(@Cast("hid_t") long loc_id, @ByVal H5O_token_t token);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Opens the nth object in a group
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param group_name [in] Name of group, relative to \p loc_id, in which object is located
 * \idx_type
 * \order
 * @param n [in] Object to open
 * \lapl_id
 *
 * @return \hid_tv{object}
 *
 * \details H5Open_by_idx() opens the nth object in the group specified by \p loc_id
 *          and \p group_name.
 *
 *          \p loc_id specifies a location identifier.
 *          \p group_name specifies the group relative to \p loc_id in which the object can be found.
 *          If \p loc_id fully specifies the group in which the object resides,
 *          \p group_name can be a dot (.).
 *
 *          The specific object to be opened within the group is specified by the three parameters:
 *          \p idx_type, \p order and \p n.
 *
 *          \p idx_type specifies the type of index by which objects are ordered.
 *          Valid index types include the following:
 *
 *          \indexes
 *
 *          \p order specifies the order in which the objects are to be referenced for the purposes
 *          of this function.  Valid orders include the following:
 *
 *          \orders
 *
 *          Note that for #H5_ITER_NATIVE, rather than implying a particular order,
 *          it instructs the HDF5 library to iterate through the objects in the fastest
 *          available order, i.e., in a natural order.
 *
 *          \p n specifies the position of the object within the index.  Note that this count is
 *          zero-based; 0 (zero) indicates that the function will return the value of the first object;
 *          if \p n is 5, the function will return the value of the sixth object; etc.
 *
 *          \p lapl_id specifies the link access property list to be used in accessing the object.
 *
 *          An object opened with this function should be closed when it is no longer needed so that
 *          resource leaks will not develop.  H5Oclose() can be used to close groups, datasets,
 *          or committed datatypes.
 *
 * @version 1.8.1 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Oopen_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                            @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Oopen_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                            @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Determines whether a link resolves to an actual object.
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] The name of the link to check
 * \lapl_id
 *
 * @return Returns a positive value if the object pointed to by
 *         the \p loc_id and \p name combination exists.
 * @return Returns 0 if the object pointed to by
 *         the \p loc_id and \p name combination does not exist.
 * @return Returns a negatvie value when the function fails.
 *
 * \details H5Oexists_by_name() allows an application to determine whether
 *          the link \p name in the group or file specified with \p loc_id
 *          resolves to an HDF5 object to open or if the link dangles. The
 *          link may be of any type, but hard links will always resolve
 *          to objects and do not need to be verified.
 *
 *          Note that H5Oexists_by_name() verifies only that the target
 *          object exists. If \p name includes either a relative path or
 *          an absolute path to the target link, intermediate steps
 *          along the path must be verified before the existence of
 *          the target link can be safely checked. If the path is not
 *          verified and an intermediate element of the path does not
 *          exist, H5Oexists_by_name() will fail. The example in the next
 *          paragraph illustrates one step-by-step method for verifying
 *          the existence of a link with a relative or absolute path.
 *
 * \par Example
 *          Use the following steps to verify the existence of
 *          the link \c datasetD in the \c group group1/group2/softlink_to_group3/,
 *          where \c group1 is a member of the group specified by \c loc_id:
 *
 * \par
 *      - First use H5Lexists() to verify that a link named \c group1 exists.
 *      - If \c group1 exists, use H5Oexists_by_name() to verify that the
 *        link \c group1 resolves to an object.
 *      - If \c group1 exists, use H5Lexists() again, this time with name
 *        set to \c group1/group2, to verify that the link \c group2 exists
 *        in \c group1.
 *      - If the \c group2 link exists, use H5Oexists_by_name() to verify
 *        that \c group1/group2 resolves to an object.
 *      - If \c group2 exists, use  H5Lexists() again, this time with name
 *        set to \c group1/group2/softlink_to_group3, to verify that the
 *        link \c softlink_to_group3 exists in \c group2.
 *      - If the \c softlink_to_group3 link exists, use H5Oexists_by_name()
 *        to verify that \c group1/group2/softlink_to_group3 resolves to
 *        an object.
 *      - If \c softlink_to_group3 exists, you can now safely use H5Lexists
 *        with name set to \c group1/group2/softlink_to_group3/datasetD to
 *        verify that the target link, \c datasetD, exists.
 *      - And finally, if the link \c datasetD exists, use H5Oexists_by_name
 *        to verify that \c group1/group2/softlink_to_group3/datasetD
 *        resolves to an object.
 *
 * \par
 *          If the link to be verified is specified with an absolute path,
 *          the same approach should be used, but starting with the first
 *          link in the file’s root group. For instance, if \c datasetD
 *          were in \c /group1/group2/softlink_to_group3, the first call to
 *          H5Lexists() would have name set to \c /group1.
 *
 * \par
 *          Note that this is an outline and does not include all necessary
 *          details. Depending on circumstances, for example, an application
 *          may need to verify the type of an object also.
 *
 * \warning \Bold{Failure Modes:}
 * \warning If \p loc_id and \p name both exist but the combination does not
 *          resolve to an object, the function will return 0 (zero);
 *          the function does not fail in this case.
 * \warning If either the location or the link specified by the \p loc_id
 *          and \p name combination does not exist, the function will fail,
 *          returning a negative value.
 * \warning Note that verifying the existence of an object within an HDF5
 *          file is a multistep process. An application can be certain the
 *          object does not exist only if H5Lexists()  and H5Oexists_by_name()
 *          have been used to verify the existence of the links and groups
 *          in the hierarchy above that object. The example above, in the
 *          function description, provides a step-by-step description of
 *          that verification process.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.5
 *
 */
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Oexists_by_name(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves the metadata for an object specified by an identifier
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param oinfo [out] Buffer in which to return object information
 * @param fields [in] Flags specifying the fields to include in \p oinfo
 *
 * @return \herr_t
 *
 * \details H5Oget_info3() specifies an object by its identifier, \p loc_id , and
 *          retrieves the metadata describing that object in \p oinfo.
 *
 *          The \p fields parameter contains flags to determine which fields will be filled in
 *          the H5O_info2_t \c struct returned in \p oinfo.
 *          These flags are defined in the H5Opublic.h file:
 *
 *          \obj_info_fields
 *
 * \par Example
 *      An example snippet from examples/h5_attribute.c:
 * \par
 *      \snippet h5_attribute.c H5Oget_info3_snip
 *
 * \note If you are iterating through a lot of different objects to
 *       retrieve information via the H5Oget_info() family of routines,
 *       you may see memory building up. This can be due to memory
 *       allocation for metadata such as object headers and messages
 *       when the iterated objects are put into the metadata cache.
 * \note
 *       If the memory buildup is not desirable, you can configure a
 *       smaller cache via H5Fset_mdc_config() or set the file access
 *       property list via H5Pset_mdc_config(). A smaller sized cache
 *       will force metadata entries to be evicted from the cache,
 *       thus freeing the memory associated with the entries.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_info3(@Cast("hid_t") long loc_id, H5O_info2_t oinfo, @Cast("unsigned") int fields);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves the metadata for an object, identifying the object by
 *        location and relative name
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] Name of object, relative to \p loc_id
 * @param oinfo [out] Buffer in which to return object information
 * @param fields [in] Flags specifying the fields to include in \p oinfo
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Oget_info_by_name3() specifies an object’s location and name,
 *          \p loc_id and \p name, respectively, and retrieves the metadata
 *          describing that object in \p oinfo, an H5O_info2_t struct.
 *
 *          The \p fields parameter contains flags to determine which fields will be filled in
 *          the H5O_info2_t \c struct returned in \p oinfo.
 *          These flags are defined in the H5Opublic.h file:
 *
 *          \obj_info_fields
 *
 *          The link access property list, \c lapl_id, is not currently used;
 *          it should be passed in as #H5P_DEFAULT.
 *
 * \par Example
 *      An example snippet from test/vol.c:
 *      \snippet vol.c H5Oget_info_by_name3_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_info_by_name3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5O_info2_t oinfo, @Cast("unsigned") int fields,
                                   @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_name3(@Cast("hid_t") long loc_id, String name, H5O_info2_t oinfo, @Cast("unsigned") int fields,
                                   @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves the metadata for an object, identifying the object
 *        by an index position
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param group_name [in] Name of group in which object is located
 * \idx_type
 * \order
 * @param n [in] Position within the index
 * @param oinfo [out] Buffer in which to return object information
 * @param fields [in] Flags specifying the fields to include in \p oinfo
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Oget_info_by_idx3() retrieves the metadata describing an
 *          object in the \c struct \p oinfo, as specified by the location,
 *          \p loc_id, group name, \p group_name, the index by which objects
 *          in that group are tracked, \p idx_type, the order by which the
 *          index is to be traversed, \p order, and an object’s position
 *          \p n within that index.
 *
 *          If \p loc_id fully specifies the group in which the object resides,
 *          \p group_name can be a dot (\c .).
 *
 *          The \p fields parameter contains flags to determine which fields will be filled in
 *          the H5O_info2_t \c struct returned in \p oinfo.
 *          These flags are defined in the H5Opublic.h file:
 *          \obj_info_fields
 *
 *          The link access property list, \c lapl_id, is not currently used;
 *          it should be passed in as #H5P_DEFAULT.
 *
 * \par Example
 *      An example snippet from test/titerate.c:
 *      \snippet titerate.c H5Oget_info_by_idx3_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_info_by_idx3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info2_t oinfo, @Cast("unsigned") int fields,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_info_by_idx3(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_info2_t oinfo, @Cast("unsigned") int fields,
                                  @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieve native file format information about an object
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param oinfo [out] Buffer in which to return native object information
 * @param fields [in] Flags to determine which fields in \p oinfo are filled in
 *
 * @return \herr_t
 *
 * \details H5Oget_native_info() retrieves the native file format information for an object
 *          specified by \p loc_id.
 *
 *          The \p fields parameter indicates which fields to fill in
 *          H5O_native_info_t. Possible values defined in H5Opublic.h are:
 *
 *          \snippet this H5O_native_info_fields_snip
 *
 * \par Example
 *      An example snippet from test/tfile.c:
 * \par
 *      \snippet tfile.c H5Oget_native_info_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_native_info(@Cast("hid_t") long loc_id, H5O_native_info_t oinfo, @Cast("unsigned") int fields);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieve native file format information about an object given its name
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] Name of object
 * @param oinfo [out] Buffer in which to return native object information
 * @param fields [in] Flags to determine which fields in \p oinfo are filled in
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Oget_native_info_by_name() retrieves the native file format
 *          information for an object specified by \p loc_id and the name \p
 *          name.
 *
 *          The \p fields parameter which fields to fill in H5O_native_info_t.
 *          Possible values defined in H5Opublic.h are:
 *
 *          \snippet this H5O_native_info_fields_snip
 *
 * \par Example
 *      An example snippet from test/tfile.c:
 *      \snippet tfile.c H5Oget_native_info_by_name_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_native_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5O_native_info_t oinfo,
                                         @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info_by_name(@Cast("hid_t") long loc_id, String name, H5O_native_info_t oinfo,
                                         @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieve native file format information about an object
 *        according to the order of an index
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param group_name [in] Name of group in which object is located
 * \idx_type
 * \order
 * @param n [in] Position within the index
 * @param oinfo [out] Buffer in which to return native object information
 * @param fields [in] Flags to determine which fields in \p oinfo are filled in
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Oget_native_info_by_idx() retrieves the native file format information for an object
 *          specified by \p loc_id, group name, \p group_name, the index by which
 *          objects in the group are tracked, \p idx_type, the order by which
 *          the index is to be traversed, \p order , and an object's position
 *          \p n within that index.
 *
 *          The \p fields parameter indicates which fields to fill in H5O_native_info_t.
 *          Possible values defined in H5Opublic.h are:
 *          \snippet this H5O_native_info_fields_snip
 *
 *          The link access property list, \c lapl_id, is not currently used;
 *          it should be passed in as #H5P_DEFAULT.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Oget_native_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_native_info_t oinfo,
                                        @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oget_native_info_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                        @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5O_native_info_t oinfo,
                                        @Cast("unsigned") int fields, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Creates a hard link to an object in an HDF5 file
 *
 * @param obj_id [in] Object to be linked
 * @param new_loc_id [in] Location identifier at which object is to be linked;
 *                       may be a file, group, dataset, named datatype or attribute identifier.
 * @param new_name [in] Name of link to be created, relative to \p new_loc_id.
 * \lcpl_id
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Olink() creates a new hard link to an object in an HDF5 file.
 *          \p new_loc_id and \p \p new_link_name specify the location and name of the
 *          new link while \p object_id identifies the object that the link
 *          points to.
 *
 *          H5Olink() is designed for two purposes:
 *          - To create the first hard link to an object that has just
 *            been created with H5Dcreate_anon(), H5Gcreate_anon(), or
 *            H5Tcommit_anon().
 *          - To add additional structure to an existing
 *            file so that, for example, an object can be shared among
 *            multiple groups.
 *
 *          \p lcpl and \p lapl are the link creation and access property lists
 *          associated with the new link.
 *
 * \par Example:
 *      To create a new link to an object while simultaneously creating
 *      missing intermediate groups: Suppose that an application must
 *      create the group C with the path /A/B01/C but may not know
 *      at run time whether the groups A and B01 exist. The following
 *      code ensures that those groups are created if they are missing:
 * \par
 * <pre>{@code
 *
 *      // Creates a link creation property list (LCPL).
 *      hid_t lcpl_id = H5Pcreate(H5P_LINK_CREATE);
 *
 *      // Sets "create missing intermediate groups" property in that LCPL.
 *      int status = H5Pset_create_intermediate_group(lcpl_id, TRUE);
 *
 *      // Creates a group without linking it into the file structure.
 *      hid_t gid  = H5Gcreate_anon(file_id, H5P_DEFAULT, H5P_DEFAULT);
 *
 *      // Links group into file structure.
 *      status = H5Olink(gid, file_id, "/A/B01/C", lcpl_id, H5P_DEFAULT);
 *
 * }</pre>
 *
 * \par
 *      Note that unless the object is intended to be temporary,
 *      the H5O_LINK call is mandatory if an object created with one
 *      of the H5*_CREATE_ANON functions (or with H5T_COMMIT_ANON)
 *      is to be retained in the file; without an H5O_LINK call,
 *      the object will not be linked into the HDF5 file structure
 *      and will be deleted when the file is closed.
 *
 * @version 1.8.1 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") long obj_id, @Cast("hid_t") long new_loc_id, @Cast("const char*") BytePointer new_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Olink(@Cast("hid_t") long obj_id, @Cast("hid_t") long new_loc_id, String new_name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Increments an object reference count
 *
 * \fgdta_loc_obj_id{object_id}
 *
 * @return \herr_t
 *
 * \details H5Oincr_refcount() increments the hard link reference count for an object.
 *          It should be used any time a user-defined link that references
 *          an object by address is added. When the link is deleted,
 *          H5Odecr_refcount() should be used.
 *
 *          An object’s reference count is the number of hard links in the
 *          file that point to that object. See the “Programming Model”
 *          section of the HDF5 Groups chapter in the -- <em>HDF5 User’s Guide</em>
 *          for a more complete discussion of reference counts.
 *
 *          If a user application needs to determine an object’s reference
 *          count, an H5Oget_info() call is required; the reference count
 *          is returned in the \c rc field of the #H5O_info_t \c struct.
 *
 * \warning This function must be used with care!
 * \warning Improper use can lead to inaccessible data, wasted space in the file,
 *          or <b><em>file corruption</em></b>.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Oincr_refcount(@Cast("hid_t") long object_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Decrements an object reference count
 *
 * \fgdta_loc_obj_id{object_id}
 *
 * @return \herr_t
 *
 * \details H5Odecr_refcount() decrements the hard link reference count for an object.
 *          It should be used any time a user-defined link that references
 *          an object by address is deleted. In general, H5Oincr_refcount() will have
 *          been used previously, when the link was created.
 *
 *          An object’s reference count is the number of hard links in the
 *          file that point to that object. See the “Programming Model”
 *          section of the HDF5 Groups chapter in the <em>HDF5 User’s Guide</em>
 *          for a more complete discussion of reference counts.
 *
 *          If a user application needs to determine an object’s reference
 *          count, an H5Oget_info() call is required; the reference count
 *          is returned in the \c rc field of the #H5O_info_t \c struct.
 *
 * \warning This function must be used with care!
 * \warning Improper use can lead to inaccessible data, wasted space in the file,
 *          or <b><em>file corruption</em></b>.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Odecr_refcount(@Cast("hid_t") long object_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Copies an object in an HDF5 file
 *
 * @param src_loc_id [in] Object identifier indicating the location of the
 *                       source object to be copied
 * @param src_name [in] Name of the source object to be copied
 * @param dst_loc_id [in] Location identifier specifying the destination
 * @param dst_name [in] Name to be assigned to the new copy
 * @param ocpypl_id [in] Object copy property list
 * \lcpl_id
 *
 * @return \herr_t
 *
 * \details H5Ocopy() copies the group, dataset or committed datatype
 *          specified by \p src_name from the file or group specified by
 *          \p src_loc_id to the destination location \p dst_loc_id.
 *
 *          The destination location, as specified in dst_loc_id, may
 *          be a group in the current file or a location in a different
 *          file. If dst_loc_id is a file identifier, the copy will be
 *          placed in that file’s root group.
 *
 *          The copy will be created with the path specified in \p dst_name,
 *          which must not pre-exist in the destination location. If
 *          \p dst_name already exists at the location \p dst_loc_id,
 *          H5Ocopy() will fail. If \p dst_name is an absolute path,
 *          the copy will be created relative to the file’s root group.
 *
 *          The copy of the object is created with the property lists
 *          specified by \p ocpypl_id and \p lcpl_id. #H5P_DEFAULT can be passed
 *          in for these property lists. The default behavior:
 *
 *          - of the link creation property list is to NOT create
 *             intermediate groups.
 *          - of the flags specified by the object creation property list
 *            is described in H5Pset_copy_object().
 *
 *          These property lists or flags can be modified to govern the
 *          behavior of H5Ocopy() as follows:
 *
 *          - A flag controlling the creation of intermediate groups that
 *              may not yet exist is set in the link creation property list
 *              \p lcpl_id with H5Pset_create_intermediate_group().
 *
 *          - Copying of committed datatypes can be tuned through the use
 *              of H5Pset_copy_object(), H5Padd_merge_committed_dtype_path(),
 *              H5Pset_mcdt_search_cb(), and related functions.
 *
 *          - Flags controlling other aspects of object copying are set in the
 *              object copy property list \p ocpypl_id with H5Pset_copy_object().
 *
 *          H5Ocopy() will always try to make a copy of the object specified
 *          in \p src_name.
 *
 *          - If the object specified by \p src_name is a group containing a
 *              soft or external link, the default is that the new copy will
 *              contain a soft or external link with the same value as the
 *              original. See H5Pset_copy_object() for optional settings.
 *
 *          - If the path specified in \p src_name is or contains a soft link
 *              or an external link, H5Ocopy() will copy the target object.
 *              Use H5Lcopy() if the intent is to create a new soft or external
 *              link with the same value as the original link.
 *
 *          H5Ocopy() can be used to copy an object in an HDF5 file. If
 *          an object has been changed since it was opened, it should be
 *          written back to the file before using H5Ocopy(). The object
 *          can be written back either by closing the object (H5Gclose(),
 *          H5Oclose(), H5Dclose(), or H5Tclose()) or by flushing
 *          the HDF5 file (H5Fflush()).
 *
 * \par See Also:
 *      - Functions to modify the behavior of H5Ocopy():
 *          - H5Padd_merge_committed_dtype_path()
 *          - H5Pset_copy_object()
 *          - H5Pset_create_intermediate_group()
 *          - H5Pset_mcdt_search_cb()
 *      - Copying Committed Datatypes with #H5Ocopy - A comprehensive
 *        discussion of copying committed datatypes (PDF) in
 *        Advanced Topics in HDF5
 *
 * @version 1.8.9 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") long src_loc_id, @Cast("const char*") BytePointer src_name, @Cast("hid_t") long dst_loc_id, @Cast("const char*") BytePointer dst_name,
                      @Cast("hid_t") long ocpypl_id, @Cast("hid_t") long lcpl_id);
public static native @Cast("herr_t") int H5Ocopy(@Cast("hid_t") long src_loc_id, String src_name, @Cast("hid_t") long dst_loc_id, String dst_name,
                      @Cast("hid_t") long ocpypl_id, @Cast("hid_t") long lcpl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Sets comment for specified object
 *
 * \fgdta_loc_obj_id{obj_id}
 * @param comment [in] The new comment
 *
 * @return \herr_t
 *
 * \details H5Oset_comment() sets the comment for the specified object
 *          to the contents of \p comment. Any previously existing comment
 *          is overwritten.
 *
 *          The target object is specified by an identifier, \p obj_id.
 *          If \p comment is the empty string or a null pointer, any existing
 *          comment message is removed from the object.
 *
 *          Comments should be relatively short, null-terminated, ASCII strings.
 *
 *          Comments can be attached to any object that has an object
 *          header. Datasets, groups, and committed (named) datatypes have
 *          object headers. Symbolic links do not have object headers.
 *
 *          If a comment is being added to an object attribute, this comment
 *          will be attached to the object to which the attribute belongs
 *          and not to the attribute itself.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer comment);
public static native @Cast("herr_t") int H5Oset_comment(@Cast("hid_t") long obj_id, String comment);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Sets comment for specified object
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] Name of the object whose comment is to be set or reset
 * @param comment [in] The new comment
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Oset_comment_by_name() sets the comment for the specified object
 *          to the contents of \p comment. Any previously existing comment
 *          is overwritten.
 *
 *          The target object is specified by \p loc_id and \p name.
 *          \p loc_id can specify any object in the file.
 *          \p name can be one of the following:
 *
 *          - The name of the object specified as a path relative to \p loc_id
 *          - An absolute name of the object, starting from \c /, the file’s root group
 *          - A dot (\c .), if \p loc_id fully specifies the object
 *
 *          If \p comment is the empty string or a null pointer, any existing
 *          comment message is removed from the object.
 *
 *          Comments should be relatively short, null-terminated, ASCII strings.
 *
 *          Comments can be attached to any object that has an object
 *          header. Datasets, groups, and committed (named) datatypes have
 *          object headers. Symbolic links do not have object headers.
 *
 *          If a comment is being added to an object attribute, this comment
 *          will be attached to the object to which the attribute belongs
 *          and not to the attribute itself.
 *
 *          \p lapl_id contains a link access property list identifier. A
 *          link access property list can come into play when traversing
 *          links to access an object.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer comment, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Oset_comment_by_name(@Cast("hid_t") long loc_id, String name, String comment, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves comment for specified object
 *
 * \fgdta_loc_obj_id{obj_id}
 * @param comment [out] The comment
 * @param bufsize [in] Anticipated required size of the comment buffer
 *
 * @return Upon success, returns the number of characters in the
 *         comment, not including the \c NULL terminator, or zero (\c 0) if
 *         the object has no comment. The value returned may be larger
 *         than \p bufsize. Otherwise returns a negative value.
 *
 * \details H5Oget_comment() retrieves the comment for the specified object in
 *          the buffer \p comment.
 *
 *          The target object is specified by an identifier, \p object_id.
 *
 *          The size in bytes of the buffer \p comment, including the \c NULL
 *          terminator, is specified in \p bufsize. If \p bufsize is unknown,
 *          a preliminary H5Oget_comment() call with the pointer \p comment
 *          set to \c NULL will return the size of the comment <em>without</em>
 *          the \c NULL terminator.
 *
 *          If \p bufsize is set to a smaller value than described above,
 *          only \p bufsize bytes of the comment, without a \c NULL terminator,
 *          are returned in \p comment.
 *
 *          If an object does not have a comment, the empty string is
 *          returned in \p comment.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize);
public static native @Cast("ssize_t") long H5Oget_comment(@Cast("hid_t") long obj_id, @Cast("char*") byte[] comment, @Cast("size_t") long bufsize);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves comment for specified object
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param name [in] Name of the object whose comment is to be retrieved
 * @param comment [out] The comment
 * @param bufsize [in] Anticipated required size of the \p comment buffer
 * \lapl_id
 *
 * @return Upon success, returns the number of characters in the comment,
 *         not including the \c NULL terminator, or zero (\c 0) if the object
 *         has no comment. The value returned may be larger than \c bufsize.
 *         Otherwise returns a negative value.
 *
 * \details H5Oget_comment_by_name() retrieves the comment for an object
 *          in the buffer \p comment.
 *
 *          The target object is specified by \p loc_id and \p name.
 *          \p loc_id can specify any object in the file.
 *          \p name can be one of the following:
 *
 *          - The name of the object relative to \p loc_id
 *          - An absolute name of the object, starting from \c /, the file’s root group
 *          - A dot (\c .), if \p loc_id fully specifies the object
 *
 *          The size in bytes of the comment, including the \c NULL terminator,
 *          is specified in \p bufsize. If \p bufsize is unknown, a preliminary
 *          H5Oget_comment_by_name() call with the pointer \p comment set
 *          to \c NULL will return the size of the comment <em>without</em>
 *          the \c NULL terminator.
 *
 *          If \p bufsize is set to a smaller value than described above,
 *          only \p bufsize bytes of the comment, without a \c NULL terminator,
 *          are returned in \p comment.
 *
 *          If an object does not have a comment, the empty string is
 *          returned in \p comment.
 *
 *          \p lapl_id contains a link access property list identifier. A
 *          link access property list can come into play when traversing
 *          links to access an object.
 *
 * @version 1.8.11 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name, @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("char*") byte[] comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name, @Cast("char*") BytePointer comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("char*") ByteBuffer comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Oget_comment_by_name(@Cast("hid_t") long loc_id, String name, @Cast("char*") byte[] comment, @Cast("size_t") long bufsize,
                                      @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Recursively visits all objects accessible from a specified object
 *
 * \fgdta_loc_obj_id{obj_id}
 * \idx_type
 * \order
 * @param op [in] Callback function passing data regarding the object
 *               to the calling application
 * @param op_data [in] User-defined pointer to data required by the application
 *                    for its processing of the object
 * @param fields [in] Flags specifying the fields to be retrieved to the
 *                   callback \p op
 *
 * @return On success, returns the return value of the first operator
 *         that returns a positive value, or zero if all members were
 *         processed with no operator returning non-zero.
 *
 * @return On failure, returns a negative value if something goes wrong
 *         within the library, or the first negative value returned by
 *         an operator.
 *
 * \details H5Ovisit3() is a recursive iteration function to visit the
 *          object \p obj_id and, if \p obj_id is a group, all objects in
 *          and below it in an HDF5 file, thus providing a mechanism for
 *          an application to perform a common set of operations across
 *          all of those objects or a dynamically selected subset.
 *          For non-recursive iteration across the members of a group,
 *          see H5Literate2().
 *
 *          If \p obj_id is a group identifier, that group serves as the
 *          root of a recursive iteration. If \p obj_id is a file identifier,
 *          that file’s root group serves as the root of the recursive
 *          iteration.  If \p obj_id is an attribute identifier,
 *          then the object where the attribute is attached will be iterated.
 *          If \p obj_id is any other type of object, such as a dataset or
 *          named datatype, there is no iteration.
 *
 *          Two parameters are used to establish the iteration: \p idx_type
 *          and \p order.
 *
 *          \p idx_type specifies the index to be used. If the links in
 *          a group have not been indexed by the index type, they will
 *          first be sorted by that index then the iteration will begin;
 *          if the links have been so indexed, the sorting step will be
 *          unnecessary, so the iteration may begin more quickly.
 <p>
 *          Note that the index type passed in \p idx_type is a
 *          <em>best effort</em> setting. If the application passes in
 *          a value indicating iteration in creation order and a group is
 *          encountered that was not tracked in creation order, that group
 *          will be iterated over in alphanumeric order by name, or
 *          <em>name order</em>.  (<em>Name order</em> is the native order
 *          used by the HDF5 library and is always available.)
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index specified in \p idx_type.
 *
 *          The H5Ovisit3() \p op_data parameter is a user-defined pointer to the data
 *          required to process objects in the course of the iteration. This pointer
 *          is passed back to each step of the iteration in the callback
 *          function’s \p op_data parameter.
 *
 *          The \p fields parameter contains flags to determine which fields will
 *          be retrieved by the \p op callback function. These flags are defined
 *          in the H5Opublic.h file:
 *          \obj_info_fields
 *
 *          H5Lvisit2() and H5Ovisit3() are companion functions: one for
 *          examining and operating on links; the other for examining
 *          and operating on the objects that those links point to. Both
 *          functions ensure that by the time the function completes
 *          successfully, every link or object below the specified point
 *          in the file has been presented to the application for whatever
 *          processing the application requires. These functions assume
 *          that the membership of the group being iterated over remains
 *          unchanged through the iteration; if any of the links in the
 *          group change during the iteration, the resulting behavior
 *          is undefined.
 *
 * \par Example
 *      An example snippet from test/links.c:
 *      \snippet links.c H5Ovisit3_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Ovisit3(@Cast("hid_t") long obj_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, H5O_iterate2_t op,
                        Pointer op_data, @Cast("unsigned") int fields);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Recursively visits all objects accessible from a specified object
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param obj_name [in] Name of the object, generally relative to
 *                     \p loc_id, that will serve as root of the iteration
 * \idx_type
 * \order
 * @param op [in] Callback function passing data regarding the object
 *               to the calling application
 * @param op_data [in] User-defined pointer to data required by the application
 *                    for its processing of the object
 * @param fields [in] Flags specifying the fields to be retrieved to the
 *                   callback function \p op
 * \lapl_id
 *
 * @return On success, returns the return value of the first operator
 *         that returns a positive value, or zero if all members were
 *         processed with no operator returning non-zero.
 *
 * @return On failure, returns a negative value if something goes wrong
 *         within the library, or the first negative value returned by
 *         an operator.
 *
 * \details H5Ovisit_by_name3() is a recursive iteration function to visit
 *          the object specified by the \p loc_id / \p obj_name parameter
 *          pair and, if that object is a group, all objects in and below it
 *          in an HDF5 file, thus providing a mechanism for an application to
 *          perform a common set of operations across all of those objects or
 *          a dynamically selected subset. For non-recursive iteration across
 *          the members of a group, see H5Literate2().
 *
 *          The object serving as the root of the iteration is specified
 *          by the \p loc_id / \p obj_name parameter pair. \p loc_id specifies
 *          a file or an object in a file;  if \p loc_id is an attribute identifier,
 *          the object where the attribute is attached will be used.
 *          \p obj_name specifies either an object in the file (with an absolute
 *          name based in the file’s root group) or an object name relative
 *          to \p loc_id. If \p loc_id fully specifies the object that is to serve
 *          as the root of the iteration, \p obj_name should be '\c .' (a dot).
 *          (Note that when \p loc_id fully specifies the object that is to serve
 *          as the root of the iteration, the user may wish to consider
 *          using H5Ovisit3() instead of H5Ovisit_by_name3().)
 *
 *          Two parameters are used to establish the iteration: \p idx_type
 *          and \p order.
 *
 *          \p idx_type specifies the index to be used. If the links in
 *          a group have not been indexed by the index type, they will
 *          first be sorted by that index then the iteration will begin;
 *          if the links have been so indexed, the sorting step will be
 *          unnecessary, so the iteration may begin more quickly.
 *
 *          Note that the index type passed in \p idx_type is a
 *          <em>best effort</em> setting. If the application passes in a
 *          value indicating iteration in creation order and a group is
 *          encountered that was not tracked in creation order, that group
 *          will be iterated over in alphanumeric order by name, or
 *          <em>name order</em>.  (<em>Name order</em> is the native order
 *          used by the HDF5 library and is always available.)
 *
 *          \p order specifies the order in which objects are to be inspected
 *          along the index specified in \p idx_type.
 *
 *          The H5Ovisit_by_name3() \p op_data parameter is a user-defined
 *          pointer to the data required to process objects in the course
 *          of the iteration. This pointer is passed back to each step of
 *          the iteration in the callback function’s \p op_data parameter.
 *
 *          \p lapl_id is a link access property list. In the general case,
 *          when default link access properties are acceptable, this can
 *          be passed in as #H5P_DEFAULT. An example of a situation that
 *          requires a non-default link access property list is when
 *          the link is an external link; an external link may require
 *          that a link prefix be set in a link access property list
 *          (see H5Pset_elink_prefix()).
 *
 *          The \p fields parameter contains flags to determine which fields will
 *          be retrieved by the \p op callback function. These flags are defined
 *          in the H5Opublic.h file:
 *          \obj_info_fields
 *
 *          H5Lvisit_by_name2() and H5Ovisit_by_name3() are companion
 *          functions: one for examining and operating on links; the other
 *          for examining and operating on the objects that those links point to.
 *          Both functions ensure that by the time the function completes
 *          successfully, every link or object below the specified point
 *          in the file has been presented to the application for whatever
 *          processing the application requires.
 *
 * \par Example
 *      An example snippet from test/links.c:
 *      \snippet links.c H5Ovisit_by_name3_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Ovisit_by_name3(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, H5O_iterate2_t op, Pointer op_data, @Cast("unsigned") int fields,
                                @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Ovisit_by_name3(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                @Cast("H5_iter_order_t") int order, H5O_iterate2_t op, Pointer op_data, @Cast("unsigned") int fields,
                                @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Closes an object in an HDF5 file
 *
 * \obj_id{object_id}
 *
 * @return \herr_t
 *
 * \details H5Oclose() closes the group, dataset, or named datatype specified by
 *          object_id.
 *
 *          This function is the companion to H5Oopen(), and has the same
 *          effect as calling H5Gclose(), H5Dclose(), or H5Tclose().
 *
 *          H5Oclose() is not used to close a dataspace, attribute, property
 *          list, or file.
 *
 * @version 1.8.8 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Oclose(@Cast("hid_t") long object_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Flushes all buffers associated with an HDF5 object to disk
 *
 * \fgdta_loc_obj_id{obj_id}
 *
 * @return \herr_t
 *
 * \details H5Oflush() causes all buffers associated with an object to be immediately
 *          flushed to disk without removing the data from the cache.
 *
 *          The object associated with \p object_id can be any named object in an
 *          HDF5 file including a dataset, a group, or a committed datatype.
 *
 * \note HDF5 does not possess full control over buffering. H5Oflush()
 *       flushes the internal HDF5 buffers and then asks the operating
 *       system (the OS) to flush the system buffers for the open
 *       files. After that, the OS is responsible for ensuring that
 *       the data is actually flushed to disk.
 *
 * @see H5Dflush(), H5Drefresh(), H5Oflush(), H5Grefresh(), H5Oflush(),
 *      H5Orefresh(), H5Tflush(), H5Trefresh()
 * @see H5DOappend(), H5Fstart_swmr_write(), H5Pget_append_flush(),
 *      H5Pget_object_flush_cb(), H5Pset_append_flush(), H5Pset_object_flush_cb()
 * @see H5Oare_mdc_flushes_disabled(), H5Odisable_mdc_flushes(), H5Oenable_mdc_flushes()
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Oflush(@Cast("hid_t") long obj_id);
/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Refreshes all buffers associated with an HDF5 object
 *
 * \fgdta_loc_obj_id{oid}
 *
 * @return \herr_t
 *
 * \details H5Orefresh() causes all buffers associated with an object to be cleared
 *          and immediately re-loaded with updated contents from disk.
 *
 *          This function essentially closes the object, evicts all
 *          metadata associated with it from the cache, and then re-opens
 *          the object. The reopened object is automatically re-registered
 *          with the same identifier.
 *
 *          The object associated with \p oid can be any named object in an
 *          HDF5 file including a dataset, a group, or a committed datatype.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Orefresh(@Cast("hid_t") long oid);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Prevents metadata entries for an HDF5 object from being flushed
 *        from the metadata cache to storage
 *
 * @param object_id [in] Identifier of the object that will have flushes disabled;
 *                      may be a group, named datatype, or dataset identifier
 *
 * @return \herr_t
 *
 * \details H5Odisable_mdc_flushes(), H5Oenable_mdc_flushes() and associated flush
 *          functions can be used to control the flushing of entries from
 *          a file’s metadata cache.
 *
 *          This function prevents an object’s or cache’s dirty metadata
 *          entries from being flushed from the cache by the usual cache
 *          eviction/flush policy. Instead, users must manually flush the
 *          cache or entries for individual objects via the appropriate
 *          H5Fflush(), H5Dflush(), H5Gflush(), H5Tflush(), and H5Oflush() calls.
 *
 *          Metadata cache entries can be controlled at both the individual
 *          HDF5 object level (datasets, groups, committed datatypes)
 *          and the entire metadata cache level.
 *
 * \note HDF5 objects include datasets, groups, and committed datatypes.  Only
 *       #hid_t identifiers that represent these objects can be passed to the
 *       function.  Passing in a #hid_t identifier that represents any other
 *       HDF5 entity is considered an error.  It is an error to pass an HDF5
 *       file identifier (obtained from H5Fopen() or H5Fcreate()) to this
 *       function.  Misuse of this function can cause the cache to exhaust
 *       available memory.  Objects can be returned to the default automatic
 *       flush behavior with H5Oenable_mdc_flushes().  Flush prevention only
 *       pertains to new or dirty metadata entries.  Clean entries can be
 *       evicted from the cache.  Calling this function on an object that has
 *       already had flushes disabled will return an error.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Odisable_mdc_flushes(@Cast("hid_t") long object_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Enables flushing of dirty metadata entries from a file’s metadata cache
 *
 * @param object_id [in] Identifier of the object that will have flushes re-enabled;
 *                      may be a group, named datatype, or dataset identifier
 *
 * @return \herr_t
 *
 * \details H5Oenable_mdc_flushes(), H5Odisable_mdc_flushes()
 *          and associated flush functions can be used to control the flushing
 *          of entries from a file’s metadata cache.
 *
 *          This function allows an object or cache’s dirty metadata entries to be
 *          flushed from the cache by the usual cache eviction/flush policy.
 *
 *          Metadata cache entries can be controlled at both the individual HDF5
 *          object level (datasets, groups, committed datatypes) and the entire
 *          metadata cache level.
 *
 *
 * \note HDF5 objects include datasets, groups, and committed datatypes.  Only
 *       #hid_t identifiers that represent these objects can be passed to the
 *       function.  Passing in a #hid_t identifier that represents any other
 *       HDF5 entity is considered an error.  It is an error to pass an HDF5
 *       file identifier (obtained from H5Fopen() or H5Fcreate()) to this
 *       function.  Using this function on an object that has not had flushes
 *       disabled is considered an error. The state of an object can be
 *       determined with H5Oare_mdc_flushes_disabled().  An object will be
 *       returned to the default flush algorithm when it is closed.  All objects
 *       will be returned to the default flush algorithm when the file is
 *       closed.  An object’s entries will not necessarily be flushed as a
 *       result of calling this function.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Oenable_mdc_flushes(@Cast("hid_t") long object_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Retrieves comment for specified object
 *
 * @param object_id [in] Identifier of an object in the cache;
 *                      may be a group, named datatype, or dataset identifier
 * @param are_disabled [out] Flushes enabled/disabled
 *
 * @return \p are_disabled will be set to \c 1 if an object has had flushes disabled
 *            and \c 0 if it has not had flushes disabled.
 * @return \herr_t
 *
 * \details H5Oare_mdc_flushes_disabled() determines if an HDF5 object (dataset, group, committed
 *          datatype) has had flushes of metadata entries disabled.
 *
 *          The H5Oenable_mdc_flushes(), H5Odisable_mdc_flushes() and
 *          associated flush functions can be used to control the flushing of
 *          entries from a file’s metadata cache. Metadata cache entries can be controlled
 *          at both the individual HDF5 object level (datasets, groups,
 *          committed datatypes) and the entire metadata cache level.
 *
 * \note HDF5 objects include datasets, groups, and committed datatypes.
 *       Only #hid_t identifiers that represent these objects can be passed to the function.
 * \note Passing in a #hid_t identifier that represents any other HDF5 entity is
 *       considered an error.
 * \note It is an error to pass an HDF5 file identifier
 *       (obtained from H5Fopen() or H5Fcreate()) to this function.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") long object_id, @Cast("hbool_t*") BoolPointer are_disabled);
public static native @Cast("herr_t") int H5Oare_mdc_flushes_disabled(@Cast("hid_t") long object_id, @Cast("hbool_t*") boolean[] are_disabled);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Compares two VOL connector object tokens
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param token [in] 1 First object token
 * @param token [in] 2 Second object token
 * @param cmp_value [out] Comparison value
 *
 * @return \herr_t
 *
 * \details H5Otoken_cmp() compares two VOL connector object tokens, \p token1
 *          and \p token2 for the file or group identifier specified by \p loc_id.
 *          Both object tokens must be from the same VOL connector class.
 *
 *          H5O_token_t is defined in H5public.h as follows:
 *          \snippet H5public.h H5O_token_t_snip
 *
 *          A comparison value, \p cmp_value, is returned, which indicates the
 *          result of the comparison:
 *
 * <table>
 *  <tr>
 *      <th>cmp_value</th>
 *      <th>Result</th>
 * </tr>
 *  <tr>
 *      <td> > 0</td>
 *      <td> \p token1 > \p token2</td>
 *  </tr>
 *  <tr>
 *      <td> < 0</td>
 *      <td>\p token1 < \p token2</td>
 *  </tr>
 *  <tr>
 *      <td>0</td>
 *      <td>\p token1 = \p token2</td>
 *  </tr>
 * </table>
 *
 * \par Example
 *      An example snippet from test/links.c:
 *      \snippet links.c H5Otoken_cmp_snip
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
                           IntPointer cmp_value);
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
                           IntBuffer cmp_value);
public static native @Cast("herr_t") int H5Otoken_cmp(@Cast("hid_t") long loc_id, @Const H5O_token_t token1, @Const H5O_token_t token2,
                           int[] cmp_value);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Serializes a connector's object token into a string
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param token [in] Connector object token
 * @param token_str [out] String for connector object token \p token
 *
 * @return \herr_t
 *
 * \details H5Otoken_to_str() serializes a connector's object token specified by
 *          \p token and the location identifier for the object, \p loc_id,
 *          into a string, \p token_str.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") PointerPointer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr BytePointer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr ByteBuffer token_str);
public static native @Cast("herr_t") int H5Otoken_to_str(@Cast("hid_t") long loc_id, @Const H5O_token_t token, @Cast("char**") @ByPtrPtr byte[] token_str);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5O
 *
 * \brief Deserializes a string into a connector object token
 *
 * \fgdta_loc_obj_id{loc_id}
 * @param token_str [in] Object token string
 * @param token [out] Connector object token
 *
 * @return \herr_t
 *
 * \details H5Otoken_from_str() deserializes a string, \p token_str, into a
 *          connector object token, \p token, for the object specified by the
 *          location identifier, \p loc_id.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Otoken_from_str(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer token_str, H5O_token_t token);
public static native @Cast("herr_t") int H5Otoken_from_str(@Cast("hid_t") long loc_id, String token_str, H5O_token_t token);

/* The canonical 'undefined' token value */
// #define H5O_TOKEN_UNDEF (H5OPEN H5O_TOKEN_UNDEF_g)
@MemberGetter public static native @Const @ByRef H5O_token_t H5O_TOKEN_UNDEF_g();

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Opublic_H */


// Parsed from H5Zpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Programmer:  Robb Matzke
 *              Thursday, April 16, 1998
 */

// #ifndef H5Zpublic_H
// #define H5Zpublic_H

/* Public headers needed by this file */
// #include "H5public.h"

/**
 * \brief Filter identifiers
 *
 * \details Values 0 through 255 are for filters defined by the HDF5 library.
 *          Values 256 through 511 are available for testing new filters.
 *          Subsequent values should be obtained from the HDF5 development team
 *          at mailto:help\hdfgroup.org. These values will never change because
 *          they appear in the HDF5 files.
 */

/* Filter IDs */
/**
 * no filter
 */
public static final int H5Z_FILTER_ERROR = (-1);
/**
 * reserved indefinitely
 */
public static final int H5Z_FILTER_NONE = 0;
/**
 * deflation like gzip
 */
public static final int H5Z_FILTER_DEFLATE = 1;
/**
 * shuffle the data
 */
public static final int H5Z_FILTER_SHUFFLE = 2;
/**
 * fletcher32 checksum of EDC
 */
public static final int H5Z_FILTER_FLETCHER32 = 3;
/**
 * szip compression
 */
public static final int H5Z_FILTER_SZIP = 4;
/**
 * nbit compression
 */
public static final int H5Z_FILTER_NBIT = 5;
/**
 * scale+offset compression
 */
public static final int H5Z_FILTER_SCALEOFFSET = 6;
/**
 * filter ids below this value are reserved for library use
 */
public static final int H5Z_FILTER_RESERVED = 256;
/**
 * maximum filter id
 */
public static final int H5Z_FILTER_MAX = 65535;

/* General macros */
/**
 * Symbol to remove all filters in H5Premove_filter()
 */
public static final int H5Z_FILTER_ALL = 0;
/**
 * Maximum number of filters allowed in a pipeline
 *
 * \internal (should probably be allowed to be an unlimited amount, but
 *            currently each filter uses a bit in a 32-bit field, so the format
 *            would have to be changed to accommodate that)
 */
public static final int H5Z_MAX_NFILTERS = 32;

/* Flags for filter definition (stored) */
/**
 * definition flag mask
 */
public static final int H5Z_FLAG_DEFMASK = 0x00ff;
/**
 * filter is mandatory
 */
public static final int H5Z_FLAG_MANDATORY = 0x0000;
/**
 * filter is optional
 */
public static final int H5Z_FLAG_OPTIONAL = 0x0001;

/* Additional flags for filter invocation (not stored) */
/**
 * invocation flag mask
 */
public static final int H5Z_FLAG_INVMASK = 0xff00;
/**
 * reverse direction; read
 */
public static final int H5Z_FLAG_REVERSE = 0x0100;
/**
 * skip EDC filters for read
 */
public static final int H5Z_FLAG_SKIP_EDC = 0x0200;

/* Special parameters for szip compression */
/* [These are aliases for the similar definitions in szlib.h, which we can't
 * include directly due to the duplication of various symbols with the zlib.h
 * header file] */
/**
 * \ingroup SZIP */
public static final int H5_SZIP_ALLOW_K13_OPTION_MASK = 1;
/**
 * \ingroup SZIP */
public static final int H5_SZIP_CHIP_OPTION_MASK = 2;
/**
 * \ingroup SZIP */
public static final int H5_SZIP_EC_OPTION_MASK = 4;
/**
 * \ingroup SZIP */
public static final int H5_SZIP_NN_OPTION_MASK = 32;
/**
 * \ingroup SZIP */
public static final int H5_SZIP_MAX_PIXELS_PER_BLOCK = 32;

/* Macros for the shuffle filter */
/**
 * \ingroup SHUFFLE
 * Number of parameters that users can set for the shuffle filter
 */
public static final int H5Z_SHUFFLE_USER_NPARMS = 0;
/**
 * \ingroup SHUFFLE
 * Total number of parameters for the shuffle filter
 */
public static final int H5Z_SHUFFLE_TOTAL_NPARMS = 1;

/* Macros for the szip filter */
/**
 * \ingroup SZIP
 * Number of parameters that users can set for SZIP
 */
public static final int H5Z_SZIP_USER_NPARMS = 2;
/**
 * \ingroup SZIP
 * Total number of parameters for SZIP filter
 */
public static final int H5Z_SZIP_TOTAL_NPARMS = 4;
/**
 * \ingroup SZIP
 * "User" parameter for option mask
 */
public static final int H5Z_SZIP_PARM_MASK = 0;
/**
 * \ingroup SZIP
 * "User" parameter for pixels-per-block
 */
public static final int H5Z_SZIP_PARM_PPB = 1;
/**
 * \ingroup SZIP
 * "Local" parameter for bits-per-pixel
 */
public static final int H5Z_SZIP_PARM_BPP = 2;
/**
 * \ingroup SZIP
 * "Local" parameter for pixels-per-scanline
 */
public static final int H5Z_SZIP_PARM_PPS = 3;

/* Macros for the nbit filter */
/**
 * \ingroup NBIT
 * Number of parameters that users can set for the N-bit filter
 */
public static final int H5Z_NBIT_USER_NPARMS = 0; /* Number of parameters that users can set */

/* Macros for the scale offset filter */
/**
 * \ingroup SCALEOFFSET
 * Number of parameters that users can set for the scale-offset filter
 */
public static final int H5Z_SCALEOFFSET_USER_NPARMS = 2;

/* Special parameters for ScaleOffset filter*/
/**
 * \ingroup SCALEOFFSET */
public static final int H5Z_SO_INT_MINBITS_DEFAULT = 0;
/**
 * \ingroup SCALEOFFSET */
/** enum H5Z_SO_scale_type_t */
public static final int
    H5Z_SO_FLOAT_DSCALE = 0,
    H5Z_SO_FLOAT_ESCALE = 1,
    H5Z_SO_INT          = 2;

/**
 * Current version of the H5Z_class_t struct
 */
public static final int H5Z_CLASS_T_VERS = (1);

/**
 * \ingroup FLETCHER32
 * Values to decide if EDC is enabled for reading data
 */
/** enum H5Z_EDC_t */
public static final int
    /** error value */
    H5Z_ERROR_EDC   = -1,
    H5Z_DISABLE_EDC = 0,
    H5Z_ENABLE_EDC  = 1,
    /** sentinel */
    H5Z_NO_EDC      = 2;

/* Bit flags for H5Zget_filter_info */
public static final int H5Z_FILTER_CONFIG_ENCODE_ENABLED = (0x0001);
public static final int H5Z_FILTER_CONFIG_DECODE_ENABLED = (0x0002);

/**
 * Return values for filter callback function
 */
/** enum H5Z_cb_return_t */
public static final int
    /** error value */
    H5Z_CB_ERROR = -1,
    /** I/O should fail if filter fails. */
    H5Z_CB_FAIL  = 0,
    /** I/O continues if filter fails.   */
    H5Z_CB_CONT  = 1,
    /** sentinel */
    H5Z_CB_NO    = 2;
// Targeting ..\H5Z_filter_func_t.java


// Targeting ..\H5Z_cb_t.java



// #ifdef __cplusplus
// Targeting ..\H5Z_can_apply_func_t.java


// Targeting ..\H5Z_set_local_func_t.java


// Targeting ..\H5Z_func_t.java


// Targeting ..\H5Z_class2_t.java


/** <!-- [H5Z_class2_t_snip] -->
<p>
/**
 * \ingroup H5Z
 *
 * \brief Registers a new filter with the HDF5 library
 *
 * @param cls [in] A pointer to a buffer for the struct containing the
 *                filter-definition
 *
 * @return \herr_t
 *
 * \details H5Zregister() registers a new filter with the HDF5 library.
 *
 * \details Making a new filter available to an application is a two-step
 *          process. The first step is to write the three filter callback
 *          functions described below: \c can_apply, \c set_local, and \c
 *          filter. This call to H5Zregister(), registering the filter with the
 *          library, is the second step. The can_apply and set_local fields can
 *          be set to NULL if they are not required for the filter being
 *          registered.
 *
 *          H5Zregister() accepts a single parameter, a pointer to a buffer for
 *          the \p cls data structure. That data structure must conform to one
 *          of the following definitions:
 *          \snippet this H5Z_class1_t_snip
 *          or
 *          \snippet this H5Z_class2_t_snip
 *
 *          \c version is a library-defined value reporting the version number
 *          of the #H5Z_class_t struct. This currently must be set to
 *          #H5Z_CLASS_T_VERS.
 *
 *          \c id is the identifier for the new filter. This is a user-defined
 *          value between #H5Z_FILTER_RESERVED and #H5Z_FILTER_MAX. These
 *          values are defined in the HDF5 source file H5Zpublic.h, but the
 *          symbols #H5Z_FILTER_RESERVED and #H5Z_FILTER_MAX should always be
 *          used instead of the literal values.
 *
 *          \c encoder_present is a library-defined value indicating whether
 *          the filter’s encoding capability is available to the application.
 *
 *          \c decoder_present is a library-defined value indicating whether
 *          the filter’s encoding capability is available to the application.
 *
 *          \c name is a descriptive comment used for debugging, may contain a
 *          descriptive name for the filter, and may be the null pointer.
 *
 *          \c can_apply, described in detail below, is a user-defined callback
 *          function which determines whether the combination of the dataset
 *          creation property list values, the datatype, and the dataspace
 *          represent a valid combination to apply this filter to.
 *
 *          \c set_local, described in detail below, is a user-defined callback
 *          function which sets any parameters that are specific to this
 *          dataset, based on the combination of the dataset creation property
 *          list values, the datatype, and the dataspace.
 *
 *          \c filter, described in detail below, is a user-defined callback
 *          function which performs the action of the filter.
 *
 *          The statistics associated with a filter are not reset by this
 *          function; they accumulate over the life of the library.
 *
 *          #H5Z_class_t is a macro which maps to either H5Z_class1_t or
 *          H5Z_class2_t, depending on the needs of the application. To affect
 *          only this macro, H5Z_class_t_vers may be defined to either 1 or 2.
 *          Otherwise, it will behave in the same manner as other API
 *          compatibility macros. See API Compatibility Macros in HDF5 for more
 *          information. H5Z_class1_t matches the #H5Z_class_t structure that is
 *          used in the 1.6.x versions of the HDF5 library.
 *
 *          H5Zregister() will automatically detect which structure type has
 *          been passed in, regardless of the mapping of the #H5Z_class_t macro.
 *          However, the application must make sure that the fields are filled
 *          in according to the correct structure definition if the macro is
 *          used to declare the structure.
 *
 *          \Bold{The callback functions:}\n Before H5Zregister() can link a
 *          filter into an application, three callback functions must be
 *          defined as described in the HDF5 library header file H5Zpublic.h.
 *
 *          When a filter is applied to the fractal heap for a group (e.g.,
 *          when compressing group metadata) and if the can apply and set local
 *          callback functions have been defined for that filter, HDF5 passes
 *          the value -1 for all parameters for those callback functions. This
 *          is done to ensure that the filter will not be applied to groups if
 *          it relies on these parameters, as they are not applicable to group
 *          fractal heaps; to operate on group fractal heaps, a filter must be
 *          capable of operating on an opaque block of binary data.
 *
 *          The \Emph{can apply} callback function must return a positive value
 *          for a valid combination, zero for an invalid combination, and a
 *          negative value for an error.
 *          \snippet this H5Z_can_apply_func_t_snip
 *
 *          Before a dataset is created, the \Emph{can apply} callbacks for any
 *          filters used in the dataset creation property list are called with
 *          the dataset's dataset creation property list, \c dcpl_id, the
 *          dataset's datatype, \p type_id, and a dataspace describing a chunk,
 *          \p space_id, (for chunked dataset storage).
 *
 *          This callback must determine whether the combination of the dataset
 *          creation property list settings, the datatype, and the dataspace
 *          represent a valid combination to which to apply this filter. For
 *          example, an invalid combination may involve the filter not
 *          operating correctly on certain datatypes, on certain datatype
 *          sizes, or on certain sizes of the chunk dataspace. If this filter
 *          is enabled through H5Pset_filter() as optional and the can apply
 *          function returns 0, the library will skip the filter in the filter
 *          pipeline.
 *
 *          This callback can be the NULL pointer, in which case the library
 *          will assume that the filter can be applied to a dataset with any
 *          combination of dataset creation property list values, datatypes,
 *          and dataspaces.
 *
 *          The \Emph{set local} callback function is defined as follows:
 *          \snippet this H5Z_set_local_func_t_snip
 *
 *          After the can apply callbacks are checked for a new dataset, the
 *          \Emph{set local} callback functions for any filters used in the
 *          dataset creation property list are called. These callbacks receive
 *          \c dcpl_id, the dataset's private copy of the dataset creation
 *          property list passed in to H5Dcreate() (i.e. not the actual
 *          property list passed in to H5Dcreate()); \c type_id, the datatype
 *          identifier passed in to H5Dcreate(), which is not copied and should
 *          not be modified; and \c space_id, a dataspace describing the chunk
 *          (for chunked dataset storage), which should also not be modified.
 *
 *          The set local callback must set any filter parameters that are
 *          specific to this dataset, based on the combination of the dataset
 *          creation property list values, the datatype, and the dataspace. For
 *          example, some filters perform different actions based on different
 *          datatypes, datatype sizes, numbers of dimensions, or dataspace
 *          sizes.
 *
 *          The \Emph{set local} callback may be the NULL pointer, in which
 *          case, the library will assume that there are no dataset-specific
 *          settings for this filter.
 *
 *          The \Emph{set local} callback function must return a non-negative
 *          value on success and a negative value for an error.
 *
 *          The \Emph{filter operation} callback function, defining the
 *          filter's operation on the data, is defined as follows:
 *          \snippet this H5Z_func_t_snip
 *
 *          The parameters \c flags, \c cd_nelmts, and \c cd_values are the
 *          same as for the function H5Pset_filter(). The one exception is that
 *          an additional flag, #H5Z_FLAG_REVERSE, is set when the filter is
 *          called as part of the input pipeline.
 *
 *          The parameter \c buf points to the input buffer which has a size of
 *          \c buf_size bytes, \c nbytes of which are valid data.
 *
 *          The filter should perform the transformation in place if possible.
 *          If the transformation cannot be done in place, then the filter
 *          should allocate a new buffer with malloc() and assign it to \c buf,
 *          assigning the allocated size of that buffer to \c buf_size. The old
 *          buffer should be freed by calling free().
 *
 *          If successful, the \Emph{filter operation} callback function
 *          returns the number of valid bytes of data contained in \c buf. In
 *          the case of failure, the return value is 0 (zero) and all pointer
 *          arguments are left unchanged.
 *
 * @version 1.8.6 Return type for the \Emph{can apply} callback function,
 *                \ref H5Z_can_apply_func_t, changed to \ref htri_t.
 * @version 1.8.5 Semantics of the \Emph{can apply} and \Emph{set local}
 *                callback functions changed to accommodate the use of filters
 *                with group fractal heaps.
 * @version 1.8.3 #H5Z_class_t renamed to H5Z_class2_t, H5Z_class1_t structure
 *                introduced for backwards compatibility with release 1.6.x,
 *                and #H5Z_class_t macro introduced in this release. Function
 *                modified to accept either structure type.
 * @version 1.8.0 The fields \c version, \c encoder_present, and
 *                \c decoder_present were added to the #H5Z_class_t \c struct
 *                in this release.
 * @version 1.6.0 This function was substantially revised in Release 1.6.0 with
 *                a new #H5Z_class_t struct and new set local and can apply
 *                callback functions.
 *
 */
public static native @Cast("herr_t") int H5Zregister(@Const Pointer cls);
/**
 * \ingroup H5Z
 *
 * \brief Unregisters a filter.
 *
 * @param id [in] Identifier of the filter to be unregistered.
 * @return \herr_t
 *
 * \details H5Zunregister() unregisters the filter specified in \p id.
 *
 * \details This function first iterates through all opened datasets and
 *          groups. If an open object that uses this filter is found, the
 *          function will fail with a message indicating that an object using
 *          the filter is still open. All open files are then flushed to make
 *          sure that all cached data that may use this filter are written out.
 *
 *          If the application is a parallel program, all processes that
 *          participate in collective data write should call this function to
 *          ensure that all data is flushed.
 *
 *          After a call to H5Zunregister(), the filter specified in filter
 *          will no longer be available to the application.
 *
 * @version 1.8.12 Function modified to check for open objects using the
 *                 filter.
 * @since 1.6.0
 */
public static native @Cast("herr_t") int H5Zunregister(@Cast("H5Z_filter_t") int id);
/**
 * \ingroup H5Z
 *
 * \brief Determines whether a filter is available
 *
 * @param id [in] Filter identifier
 * @return \htri_t
 *
 * \details H5Zfilter_avail() determines whether the filter specified in \p id
 *          is available to the application.
 *
 * @since 1.6.0
 */
public static native @Cast("htri_t") int H5Zfilter_avail(@Cast("H5Z_filter_t") int id);
/**
 * \ingroup H5Z
 *
 * \brief Retrieves information about a filter
 *
 * @param filter [in] Filter identifier
 * @param filter_config_flags [out] A bit field encoding the returned filter
 *                                 information
 * @return \herr_t
 *
 * \details H5Zget_filter_info() retrieves information about a filter. At
 *          present, this means that the function retrieves a filter's
 *          configuration flags, indicating whether the filter is configured to
 *          decode data, to encode data, neither, or both.
 *
 *          If \p filter_config_flags is not set to NULL prior to the function
 *          call, the returned parameter contains a bit field specifying the
 *          available filter configuration. The configuration flag values can
 *          then be determined through a series of bitwise AND operations, as
 *          described below.
 *
 *          Valid filter configuration flags include the following:
 *          <table>
 *            <tr><td>#H5Z_FILTER_CONFIG_ENCODE_ENABLED</td>
 *                <td>Encoding is enabled for this filter</td></tr>
 *            <tr><td>#H5Z_FILTER_CONFIG_DECODE_ENABLED</td>
 *                <td>Decoding is enabled for this filter</td></tr>
 *          </table>
 *
 *          A bitwise AND of the returned \p filter_config_flags and a valid
 *          filter configuration flag will reveal whether the related
 *          configuration option is available. For example, if the value of
 *          <pre>{@code
 *          H5Z_FILTER_CONFIG_ENCODE_ENABLED & filter_config_flags
 *          }</pre>
 *          is true, i.e., greater than 0 (zero), the queried filter
 *          is configured to encode data; if the value is \c FALSE, i.e., equal to
 *          0 (zero), the filter is not so configured.
 *
 *          If a filter is not encode-enabled, the corresponding \c H5Pset_*
 *          function will return an error if the filter is added to a dataset
 *          creation property list (which is required if the filter is to be
 *          used to encode that dataset). For example, if the
 *          #H5Z_FILTER_CONFIG_ENCODE_ENABLED flag is not returned for the SZIP
 *          filter, #H5Z_FILTER_SZIP, a call to H5Pset_szip() will fail.
 *
 *          If a filter is not decode-enabled, the application will not be able
 *          to read an existing file encoded with that filter.
 *
 *          This function should be called, and the returned \p
 *          filter_config_flags analyzed, before calling any other function,
 *          such as H5Pset_szip() , that might require a particular filter
 *          configuration.
 *
 * @since 1.6.3
 */
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntPointer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") IntBuffer filter_config_flags);
public static native @Cast("herr_t") int H5Zget_filter_info(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int*") int[] filter_config_flags);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* _H5Zpublic_H */


// Parsed from H5Apublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5A module.
 */
// #ifndef H5Apublic_H
// #define H5Apublic_H

/* Public headers needed by this file */
// #include "H5Ipublic.h" /* IDs			  		*/
// #include "H5Opublic.h" /* Object Headers			*/
// #include "H5Tpublic.h"
// Targeting ..\H5A_info_t.java


// Targeting ..\H5A_operator2_t.java


/** <!-- [H5A_operator2_t_snip] -->
<p>
/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus */
// #endif

/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Closes the specified attribute
 *
 * \attr_id
 *
 * @return \herr_t
 *
 * \details H5Aclose() terminates access to the attribute through
 *          \p attr_id and releases the identifier.
 *
 * \par Example
 * \snippet H5A_examples.c create
 *
 * @since 1.0.0
 *
 * @see H5Acreate(), H5Aopen()
 */
public static native @Cast("herr_t") int H5Aclose(@Cast("hid_t") long attr_id);
/* --------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Creates an attribute attached to a specified object
 *
 * \fgdt_loc_id
 * @param attr_name [in]  Name of attribute
 * @param type_id [in]    Attribute datatype identifier
 * \space_id
 * \acpl_id
 * \aapl_id
 *
 * @return \hid_tv{attribute}
 *
 * \details H5Acreate2() creates an attribute, \p attr_name, which is attached
 *          to the object specified by the identifier \p loc_id.
 *
 *          The attribute name, \p attr_name, must be unique for the object.
 *
 *          The attribute is created with the specified datatype and dataspace,
 *          \p type_id and \p space_id.
 *
 *          \plist_unused{acpl}
 *
 *          The attribute identifier returned by this function must be released
 *          with H5Aclose() resource leaks will develop.
 *
 * \note If \p loc_id is a file identifier, the attribute will be attached
 *       that file’s root group.
 *
 * \par Example
 * \snippet H5A_examples.c create
 *
 * @since 1.8.0
 *
 * @see H5Aclose()
 *
 */
public static native @Cast("hid_t") long H5Acreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id,
                        @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Acreate2(@Cast("hid_t") long loc_id, String attr_name, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id,
                        @Cast("hid_t") long aapl_id);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief  Creates an attribute attached to a specified object
 *
 * \fgdt_loc_id
 * @param obj_name [in]  Name, relative to \p loc_id, of object that
 *                      attribute is to be attached to
 * @param attr_name [in] Attribute name
 * @param type_id [in]   Attribute datatype identifier
 * \space_id
 * \acpl_id
 * \aapl_id
 * \lapl_id
 *
 * @return \hid_tv{attribute}
 *
 * \details H5Acreate_by_name() creates an attribute, \p attr_name, which is
 *          attached to the object specified by \p loc_id and \p obj_name.
 *
 *          \p loc_id is a location identifier; \p obj_name is the object
 *          name relative to \p loc_id.
 *
 *          The attribute name, \p attr_name, must be unique for the object.
 *
 *          The attribute is created with the specified datatype and
 *          dataspace, \p type_id and \p space_id.
 *
 *          \plist_unused{aapl}
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Acreate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long type_id,
                               @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Acreate_by_name(@Cast("hid_t") long loc_id, String obj_name, String attr_name, @Cast("hid_t") long type_id,
                               @Cast("hid_t") long space_id, @Cast("hid_t") long acpl_id, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Deletes an attribute from a specified location
 *
 * \fgdt_loc_id
 * @param attr_name [in]  Name of the attribute to delete
 *
 * @return \herr_t
 *
 * \details H5Adelete() removes the attribute specified by its name,
 *          \p attr_name, from a file, dataset, group, or named datatype.
 *
 * \attention This function should not be used when other attribute identifiers
 *            are open on \p loc_id. This may cause the internal indexes of
 *            the attributes to change and future writes to the open
 *            attributes to produce incorrect results.
 *
 * \par Example
 * \snippet H5A_examples.c delete
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer attr_name);
public static native @Cast("herr_t") int H5Adelete(@Cast("hid_t") long loc_id, String attr_name);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Deletes an attribute from an object according to index order
 *
 * \fgdt_loc_id
 * @param obj_name [in] Name of object, relative to location, from which
 *                     attribute is to be removed
 * @param idx_type [in] Type of index
 * @param order [in]    Order in which to iterate over index
 * @param n [in]        Offset within index
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Adelete_by_idx() removes an attribute, specified by its
 *          location in an index, from an object.
 *
 *          The object from which the attribute is to be removed is
 *          specified by a location identifier and name, \p loc_id and
 *          \p obj_name, respectively.
 *
 *          The attribute to be removed is specified by a position in an
 *          index, \p n. The type of index is specified by \p idx_type.
 *          The order in which the index is to be traversed is specified by
 *          \p order. For example, if \p idx_type, \p order,
 *          and \p n are set to #H5_INDEX_NAME, #H5_ITER_INC, and 5,
 *          respectively, the fifth attribute in lexicographic order of
 *          attribute names will be removed.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 <p>
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                               @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                               @Cast("hsize_t") long n, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Removes an attribute from a specified location
 *
 * \fgdt_loc_id
 * @param obj_name [in]  Name of object, relative to location, from which
 *                      attribute is to be removed
 * @param attr_name [in] Name of attribute to delete
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Adelete_by_name() removes the attribute \p attr_name
 *          from an object specified by location and name, \p loc_id and
 *          \p obj_name, respectively.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to
 *          access the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Adelete_by_name(@Cast("hid_t") long loc_id, String obj_name, String attr_name, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Determines whether an attribute with a given name exists on an
 *        object
 *
 * \fgdt_loc_id{obj_id}
 * @param attr_name [in]  Attribute name
 *
 * @return \htri_t
 *
 * \details H5Aexists() determines whether the attribute \p attr_name
 *          exists on the object specified by \p obj_id.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer attr_name);
public static native @Cast("htri_t") int H5Aexists(@Cast("hid_t") long obj_id, String attr_name);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief  Determines whether an attribute with a given name exists on an
 *         object
 *
 * \fgdt_loc_id{obj_id}
 * @param obj_name [in]  Object name
 * @param attr_name [in] Attribute name
 * \lapl_id
 *
 * @return \htri_t
 *
 * \details H5Aexists_by_name() determines whether the attribute
 *          \p attr_name exists on an object. That object is specified by
 *          its location and name, \p loc_id and \p obj_name, respectively.
 *
 *          \p loc_id specifies a location in the file containing the object.
 *          \p obj_name is the name of the object to which the attribute is
 *          attached and can be a relative name, relative to \p loc_id,
 *          or an absolute name, based in the root group of the file.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("htri_t") int H5Aexists_by_name(@Cast("hid_t") long obj_id, String obj_name, String attr_name, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Gets an attribute creation property list identifier
 *
 * \attr_id
 *
 * @return \hid_tv{attribute's creation property list}
 *
 * \details H5Aget_create_plist() returns an identifier for the attribute
 *          creation property list associated with the attribute specified
 *          by \p attr_id.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Aget_create_plist(@Cast("hid_t") long attr_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Retrieves attribute information, by attribute identifier
 *
 * \attr_id
 * @param ainfo [out]   Attribute information struct
 *
 * @return \herr_t
 *
 * \details H5Aget_info() retrieves attribute information, locating the
 *          attribute with an attribute identifier, \p attr_id. The
 *          attribute information is returned in the \p ainfo struct.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Aget_info(@Cast("hid_t") long attr_id, H5A_info_t ainfo);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Retrieves attribute information by attribute index position
 *
 * \fgdt_loc_id
 * @param obj_name [in]  Name of object to which attribute is attached,
 *                       relative to location
 * @param idx_type [in]  Type of index
 * @param order [in]     Index traversal order
 * @param n [in]         Attribute’s position in index
 * @param ainfo [out]     Struct containing returned attribute information
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Aget_info_by_idx() retrieves information for an attribute
 *          that is attached to an object, which is specified by its
 *          location and name, \p loc_id and \p obj_name, respectively.
 *          The attribute is located by its index position and the attribute
 *          information is returned in the \p ainfo struct.
 *
 *          The attribute is located by means of an index type, an index
 *          traversal order, and a position in the index, \p idx_type,
 *          \p order and \p n, respectively.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Retrieves attribute information, by attribute name
 *
 * \fgdt_loc_id
 * @param obj_name [in]   Name of the object to which an attribute is attached,
 *                       relative to location
 * @param attr_name [in]  Attribute name
 * @param ainfo [out]     Struct containing returned attribute information
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Aget_info_by_name() retrieves information for an attribute,
 *          \p attr_name, that is attached to an object specified by its
 *          location and name, \p loc_id and \p obj_name, respectively.
 *          The attribute information is returned in the \p ainfo struct.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to
 *          access the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name,
                                  H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aget_info_by_name(@Cast("hid_t") long loc_id, String obj_name, String attr_name,
                                  H5A_info_t ainfo, @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Gets an attribute name
 *
 * \attr_id
 * @param buf_size [in]  The size of the buffer to store the name in
 * @param buf [out]       Buffer to store name in
 *
 * @return  Returns the length of the attribute's name, which may be longer
 *          than \p buf_size, if successful. Otherwise returns a negative
 *          value.
 *
 * \details H5Aget_name() retrieves the name of an attribute specified by
 *          the identifier, \p attr_id. Up to \p buf_size characters are
 *          stored in \p buf followed by a \0 string terminator. If the
 *          name of the attribute is longer than (\p buf_size -1), the
 *          string terminator is stored in the last position of the buffer
 *          to properly terminate the string.
 *
 *          If the user only wants to retrieve the name length, the
 *          values 0 and NULL should be passed for the parameters
 *          \p bufsize and \p buf.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") BytePointer buf);
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") ByteBuffer buf);
public static native @Cast("ssize_t") long H5Aget_name(@Cast("hid_t") long attr_id, @Cast("size_t") long buf_size, @Cast("char*") byte[] buf);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Gets an attribute name by attribute index position
 *
 * \fgdt_loc_id
 * @param obj_name [in]   Name of object to which attribute is attached,
 *                        relative to location
 * @param idx_type [in]   Type of index
 * @param order [in]      Index traversal order
 * @param n [in]          Attribute’s position in index
 * @param name [out]       Attribute name
 * @param size [in]       Size, in bytes, of attribute name
 * \lapl_id
 *
 * @return Returns attribute name size, in bytes, if successful;
 *         otherwise returns a negative value.
 *
 * \details H5Aget_name_by_idx() retrieves the name of an attribute that is
 *          attached to an object, which is specified by its location and
 *          name, \p loc_id and \p obj_name, respectively. The attribute is
 *          located by its index position, the size of the name is specified
 *          in \p size, and the attribute name is returned in \p name.
 *
 *          The attribute is located by means of an index type, an index
 *          traversal order, and a position in the index, \p idx_type,
 *          \p order and \p n, respectively.
 *
 *          If the attribute name’s size is unknown, the values 0 and NULL
 *          can be passed in for the parameters \p size and \p name. The
 *          function’s return value will provide the correct value for
 *          \p size.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") BytePointer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") ByteBuffer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") byte[] name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") BytePointer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") ByteBuffer name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
public static native @Cast("ssize_t") long H5Aget_name_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                  @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, @Cast("char*") byte[] name, @Cast("size_t") long size,
                                  @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Gets a copy of the dataspace for an attribute
 *
 * \attr_id
 *
 * @return \hid_tv{attribute dataspace}
 *
 * \details  H5Aget_space() retrieves a copy of the dataspace for an
 *           attribute. The dataspace identifier returned from this
 *           function must be released with H5Sclose() or resource leaks
 *           will develop.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("hid_t") long H5Aget_space(@Cast("hid_t") long attr_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Returns the amount of storage used to store an attribute
 *
 * \attr_id
 *
 * @return Returns the amount of storage size allocated for the attribute;
 *         otherwise returns 0 (zero).
 *
 * \details H5Aget_storage_size() returns the amount of storage that is
 *          required for the specified attribute, \p attr_id.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("hsize_t") long H5Aget_storage_size(@Cast("hid_t") long attr_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Gets an attribute's datatype
 *
 * \attr_id
 *
 * @return \hid_t{datatype}
 *
 * \details H5Aget_type() retrieves a copy of the attribute's datatype.
 *          The datatype is reopened if it is a named type before returning
 *          it to the application. The datatypes returned by this function
 *          are always read-only.
 *
 *          The datatype identifier returned from this function must be
 *          released with H5Tclose() or resource leaks will develop.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("hid_t") long H5Aget_type(@Cast("hid_t") long attr_id);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Calls a user-defined function for each attribute on an object
 *
 * \fgdt_loc_id
 * @param idx_type [in] Type of index
 * @param order [in]    Order in which to iterate over index
 * @param idx [in,out]      Initial and returned offset within index
 * @param op [in]       User-defined function to pass each attribute to
 * @param op_data [in,out]  User data to pass through to and to be returned
 *                         by iterator operator function
 *
 * @return \herr_t
 *       Further note that this function returns the return value of the
 *       last operator if it was non-zero, which can be a negative value,
 *       zero if all attributes were processed, or a positive value
 *       indicating short-circuit success.
 *
 * \details H5Aiterate2() iterates over the attributes attached to a
 *          dataset, named datatype, or group, as specified by \p loc_id.
 *          For each attribute, user-provided data, \p op_data, with
 *          additional information as defined below, is passed to a
 *          user-defined function, \p op, which operates on that
 *          attribute.
 *
 *          The order of the iteration and the attributes iterated over
 *          are specified by three parameters: the index type,
 *          \p idx_type; the order in which the index is to be traversed,
 *          \p order; and the attribute’s position in the index, \p idx.
 *          The next attribute to be operated on is specified by \p idx,
 *          a position in the index.
 *
 *          For example, if \p idx_type, \p order, and \p idx are set to
 *          #H5_INDEX_NAME, #H5_ITER_INC, and 5, respectively, the attribute
 *          in question is the fifth attribute from the beginning of the
 *          alphanumeric index of attribute names. If \p order were set to
 *          #H5_ITER_DEC, it would be the fifth attribute from the end of
 *          the index.
 *
 *          The parameter \p idx is passed in on an H5Aiterate2() call with
 *          one value and may be returned with another value. The value
 *          passed in identifies the parameter to be operated on first;
 *          the value returned identifies the parameter to be operated on
 *          in the next step of the iteration.
 *
 * \note This function is also available through the H5Aiterate() macro.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx,
                          H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx,
                          H5A_operator2_t op, Pointer op_data);
public static native @Cast("herr_t") int H5Aiterate2(@Cast("hid_t") long loc_id, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx,
                          H5A_operator2_t op, Pointer op_data);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Calls user-defined function for each attribute on an object
 *
 * \fgdt_loc_id
 * @param obj_name [in]    Name of object, relative to location
 * @param idx_type [in]    Type of index
 * @param order [in]       Order in which to iterate over index
 * @param idx [in,out]     Initial and returned offset within index
 * @param op [in]          User-defined function to pass each attribute to
 * @param op_data [in,out] User data to pass through to and to be returned
 *                        by iterator operator function
 * \lapl_id
 *
 * @return \herr_t
 *         Further note that this function returns the return value of
 *         the last operator if it was non-zero, which can be a negative
 *         value, zero if all attributes were processed, or a positive value
 *         indicating short-circuit success.
 *
 * \details H5Aiterate_by_name() iterates over the attributes attached
 *          to the dataset or group specified with \p loc_id and \p obj_name.
 *          For each attribute, user-provided data, \p op_data, with
 *          additional information as defined below, is passed to a
 *          user-defined function, \p op, which operates on that attribute.
 *
 *          The order of the iteration and the attributes iterated over
 *          are specified by three parameters: the index type, \p idx_type;
 *          the order in which the index is to be traversed, \p order;
 *          and the attribute’s position in the index, \p idx.
 *          The next attribute to be operated on is specified by \p idx,
 *          a position in the index.
 *
 *          For example, if \p idx_type, \p order, and \p idx are set to
 *          #H5_INDEX_NAME, #H5_ITER_INC, and 5, respectively, the attribute
 *          in question is the fifth attribute from the beginning of the
 *          alphanumeric index of attribute names. If \p order were set to
 *          #H5_ITER_DEC, it would be the fifth attribute from the end of
 *          the index.
 *
 *          The parameter \p idx is passed in on an H5Aiterate_by_name()
 *          call with one value and may be returned with another value. The
 *          value passed in identifies the parameter to be operated on first;
 *          the value returned identifies the parameter to be operated on in
 *          the next step of the iteration.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongPointer idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") LongBuffer idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Aiterate_by_name(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t*") long[] idx, H5A_operator2_t op, Pointer op_data,
                                 @Cast("hid_t") long lapl_id);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Opens an attribute for an object specified by object identifier and
 *        attribute name
 *
 * \fgdt_loc_id{obj_id}
 * @param attr_name [in]    Name of attribute to open
 * \aapl_id
 *
 * @return \hid_tv{attribute}
 *
 * \details H5Aopen() opens an existing attribute, \p attr_name, that is
 *          attached to object specified by an object identifier, \p obj_id.
 *
 *          \plist_unused{aapl_id}
 *
 *          This function, H5Aopen_by_idx() or H5Aopen_by_name() must be called
 *          before the attribute can be accessed for any further purpose,
 *          including reading, writing, or any modification.
 *
 *          The attribute identifier returned by this function must be released
 *          with H5Aclose() or resource leaks will develop.
 *
 * \par Example
 * \snippet H5A_examples.c read
 *
 * @since 1.8.0
 *
 * @see H5Aclose(), H5Acreate()
 */
public static native @Cast("hid_t") long H5Aopen(@Cast("hid_t") long obj_id, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long aapl_id);
public static native @Cast("hid_t") long H5Aopen(@Cast("hid_t") long obj_id, String attr_name, @Cast("hid_t") long aapl_id);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Opens the nth attribute attached to an object
 *
 * \loc_id
 * @param obj_name [in]  Name of object to which attribute is attached,
 *                      relative to location
 * @param idx_type [in]  Type of index
 * @param order [in]     Index traversal order
 * @param n [in]         Attribute’s position in index
 * \aapl_id
 * \lapl_id
 *
 * @return \hid_tv{attribute}
 *
 * \details H5Aopen_by_idx() opens an existing attribute that is attached
 *          to an object specified by location and name, \p loc_id and
 *          \p obj_name, respectively.
 *
 *          The attribute is identified by an index type, an index traversal
 *          order, and a position in the index, \p idx_type, \p order and
 *          \p n, respectively.
 *
 *          \plist_unused{aapl_id}
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 *          This function, H5Aopen(), or H5Aopen_by_name() must be called
 *          before an attribute can be accessed for any further purpose,
 *          including reading, writing, or any modification.
 *
 *          The attribute identifier returned by this function must be
 *          released with H5Aclose() or resource leaks will develop.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Aopen_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                            @Cast("hsize_t") long n, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen_by_idx(@Cast("hid_t") long loc_id, String obj_name, @Cast("H5_index_t") int idx_type, @Cast("H5_iter_order_t") int order,
                            @Cast("hsize_t") long n, @Cast("hid_t") long aapl_id, @Cast("hid_t") long lapl_id);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Opens an attribute for an object by object name and attribute name
 *
 * \fgdt_loc_id
 * @param obj_name [in]   Name of object to which attribute is attached,
 *                       relative to \p loc_id
 * @param attr_name [in]  Name of attribute to open
 * \aapl_id
 * \lapl_id
 *
 * @return \hid_tv{attribute}
 *
 * \details H5Aopen_by_name() opens an existing attribute, \p attr_name,
 *          that is attached to an object specified by location and name,
 *          \p loc_id and \p obj_name, respectively.
 *
 *          \p loc_id specifies a location from which the target object can
 *          be located and \p obj_name is an object name relative to
 *          \p loc_id.
 *
 *          \plist_unused{aapl_id}
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to access
 *          the object, \p obj_name.
 *
 *          This function, H5Aopen(), or H5Aopen_by_idx() must be called
 *          before an attribute can be accessed for any further purpose,
 *          including reading, writing, or any modification.
 *
 *          The attribute identifier returned by this function must be
 *          released with H5Aclose() or resource leaks will develop.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Aopen_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer attr_name, @Cast("hid_t") long aapl_id,
                             @Cast("hid_t") long lapl_id);
public static native @Cast("hid_t") long H5Aopen_by_name(@Cast("hid_t") long loc_id, String obj_name, String attr_name, @Cast("hid_t") long aapl_id,
                             @Cast("hid_t") long lapl_id);
/*-------------------------------------------------------------------------- */
/**
 * \ingroup H5A
 *
 * \brief Reads the value of an attribute
 *
 * \attr_id
 * \mem_type_id{type_id}
 * @param buf [out]        Buffer for data to be read
 *
 * @return \herr_t
 *
 * \details H5Aread() reads an attribute, specified with \p attr_id. The
 *          attribute's in-memory datatype is specified with \p type_id. The
 *          entire attribute is read into \p buf from the file.
 *
 *          Datatype conversion takes place at the time of a read or write and
 *          is automatic.
 *
 * \par Example
 * \snippet H5A_examples.c read
 *
 * @version 1.8.8  Fortran updated to Fortran2003.
 * @version 1.4.2  The \p dims parameter was added to the Fortran API in this
 *                 release.
 * @since   1.0.0
 *
 * @see H5Awrite()
 *
 */
public static native @Cast("herr_t") int H5Aread(@Cast("hid_t") long attr_id, @Cast("hid_t") long type_id, Pointer buf);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Renames an attribute
 *
 * \fgdt_loc_id
 * @param old_name [in]   Name of the attribute to be changed
 * @param new_name [in]   New name for the attribute
 *
 * @return \herr_t
 *
 * \details H5Arename() changes the name of the attribute located at
 *          \p loc_id.
 *
 *          The old name, \p old_name, is changed to the new name,
 *          \p new_name.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer old_name, @Cast("const char*") BytePointer new_name);
public static native @Cast("herr_t") int H5Arename(@Cast("hid_t") long loc_id, String old_name, String new_name);
/*--------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \brief Writes data to an attribute
 *
 * \attr_id
 * \mem_type_id{type_id}
 * @param buf [out]       Data to be written
 *
 * @return \herr_t
 *
 * \details H5Awrite() writes an attribute, specified with \p attr_id. The
 *          attribute's in-memory datatype is specified with \p type_id.
 *          The entire attribute is written from \p buf to the file.
 *
 *          Datatype conversion takes place at the time of a read or write and
 *          is automatic.
 *
 * \par Example
 * \snippet H5A_examples.c update
 *
 * @version 1.8.8   Fortran updated to Fortran2003.
 * @version 1.4.2   Fortran \p dims parameter added in this release
 * @since 1.0.0
 * @see H5Aread()
 *
 */
public static native @Cast("herr_t") int H5Awrite(@Cast("hid_t") long attr_id, @Cast("hid_t") long type_id, @Const Pointer buf);
/*-------------------------------------------------------------------------*/
/**
 * \ingroup H5A
 *
 * \fgdt_loc_id
 * @param obj_name [in]      Name of object, relative to location, whose
 *                          attribute is to be renamed
 * @param old_attr_name [in] Prior attribute name
 * @param new_attr_name [in] New attribute name
 * \lapl_id
 *
 * \details H5Arename_by_name() changes the name of attribute that is
 *          attached to the object specified by \p loc_id and \p obj_name.
 *          The attribute named \p old_attr_name is renamed
 *          \p new_attr_name.
 *
 *          The link access property list, \p lapl_id, may provide
 *          information regarding the properties of links required to
 *          access the object, \p obj_name.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer obj_name, @Cast("const char*") BytePointer old_attr_name,
                                @Cast("const char*") BytePointer new_attr_name, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Arename_by_name(@Cast("hid_t") long loc_id, String obj_name, String old_attr_name,
                                String new_attr_name, @Cast("hid_t") long lapl_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* H5Apublic_H */


// Parsed from H5ACpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5ACpublic.h
 *                      Jul 10 1997
 *                      Robb Matzke
 *
 * Purpose:             Public include file for cache functions.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5ACpublic_H
// #define H5ACpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Cpublic.h"

/****************************************************************************
 *
 * structure H5AC_cache_config_t
 *
 * H5AC_cache_config_t is a public structure intended for use in public APIs.
 * At least in its initial incarnation, it is basically a copy of struct
 * H5C_auto_size_ctl_t, minus the report_fcn field, and plus the
 * dirty_bytes_threshold field.
 *
 * The report_fcn field is omitted, as including it would require us to
 * make H5C_t structure public.
 *
 * The dirty_bytes_threshold field does not appear in H5C_auto_size_ctl_t,
 * as synchronization between caches on different processes is handled at
 * the H5AC level, not at the level of H5C.  Note however that there is
 * considerable interaction between this value and the other fields in this
 * structure.
 *
 * Similarly, the open_trace_file, close_trace_file, and trace_file_name
 * fields do not appear in H5C_auto_size_ctl_t, as most trace file
 * issues are handled at the H5AC level.  The one exception is storage of
 * the pointer to the trace file, which is handled by H5C.
 *
 * The structure is in H5ACpublic.h as we may wish to allow different
 * configuration options for metadata and raw data caches.
 *
 * The fields of the structure are discussed individually below:
 *
 * version: Integer field containing the version number of this version
 *      of the H5AC_cache_config_t structure.  Any instance of
 *      H5AC_cache_config_t passed to the cache must have a known
 *      version number, or an error will be flagged.
 *
 * rpt_fcn_enabled: Boolean field used to enable and disable the default
 *    reporting function.  This function is invoked every time the
 *    automatic cache resize code is run, and reports on its activities.
 *
 *    This is a debugging function, and should normally be turned off.
 *
 * open_trace_file: Boolean field indicating whether the trace_file_name
 *     field should be used to open a trace file for the cache.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     The trace file is a debugging feature that allow the capture of
 *     top level metadata cache requests for purposes of debugging and/or
 *     optimization.  This field should normally be set to FALSE, as
 *     trace file collection imposes considerable overhead.
 *
 *     This field should only be set to TRUE when the trace_file_name
 *     contains the full path of the desired trace file, and either
 *     there is no open trace file on the cache, or the close_trace_file
 *     field is also TRUE.
 *
 * close_trace_file: Boolean field indicating whether the current trace
 *     file (if any) should be closed.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     See the above comments on the open_trace_file field.  This field
 *     should be set to FALSE unless there is an open trace file on the
 *     cache that you wish to close.
 *
 * trace_file_name: Full path of the trace file to be opened if the
 *     open_trace_file field is TRUE.
 *
 *      *** DEPRECATED *** Use H5Fstart/stop logging functions instead
 *
 *     In the parallel case, an ascii representation of the mpi rank of
 *     the process will be appended to the file name to yield a unique
 *     trace file name for each process.
 *
 *     The length of the path must not exceed H5AC__MAX_TRACE_FILE_NAME_LEN
 *     characters.
 *
 * evictions_enabled:  Boolean field used to either report the current
 *     evictions enabled status of the cache, or to set the cache's
 *    evictions enabled status.
 *
 *     In general, the metadata cache should always be allowed to
 *     evict entries.  However, in some cases it is advantageous to
 *     disable evictions briefly, and thereby postpone metadata
 *     writes.  However, this must be done with care, as the cache
 *     can grow quickly.  If you do this, re-enable evictions as
 *     soon as possible and monitor cache size.
 *
 *     At present, evictions can only be disabled if automatic
 *     cache resizing is also disabled (that is, ( incr_mode ==
 *    H5C_incr__off ) && ( decr_mode == H5C_decr__off )).  There
 *    is no logical reason why this should be so, but it simplifies
 *    implementation and testing, and I can't think of any reason
 *    why it would be desirable.  If you can think of one, I'll
 *    revisit the issue.
 *
 * set_initial_size: Boolean flag indicating whether the size of the
 *      initial size of the cache is to be set to the value given in
 *      the initial_size field.  If set_initial_size is FALSE, the
 *      initial_size field is ignored.
 *
 * initial_size: If enabled, this field contain the size the cache is
 *      to be set to upon receipt of this structure.  Needless to say,
 *      initial_size must lie in the closed interval [min_size, max_size].
 *
 * min_clean_fraction: double in the range 0 to 1 indicating the fraction
 *      of the cache that is to be kept clean.  This field is only used
 *      in parallel mode.  Typical values are 0.1 to 0.5.
 *
 * max_size: Maximum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [MIN_MAX_CACHE_SIZE, MAX_MAX_CACHE_SIZE].  Also, max_size must
 *      be greater than or equal to min_size.
 *
 * min_size: Minimum size to which the cache can be adjusted.  The
 *      supplied value must fall in the closed interval
 *      [H5C__MIN_MAX_CACHE_SIZE, H5C__MAX_MAX_CACHE_SIZE].  Also, min_size
 *      must be less than or equal to max_size.
 *
 * epoch_length: Number of accesses on the cache over which to collect
 *      hit rate stats before running the automatic cache resize code,
 *      if it is enabled.
 *
 *      At the end of an epoch, we discard prior hit rate data and start
 *      collecting afresh.  The epoch_length must lie in the closed
 *      interval [H5C__MIN_AR_EPOCH_LENGTH, H5C__MAX_AR_EPOCH_LENGTH].
 *
 *
 * Cache size increase control fields:
 *
 * incr_mode: Instance of the H5C_cache_incr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      increased.  At present there are two possible values:
 *
 *      H5C_incr__off:  Don't attempt to increase the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size increase section ar ignored.
 *
 *      H5C_incr__threshold: Attempt to increase the size of the cache
 *              whenever the average hit rate over the last epoch drops
 *              below the value supplied in the lower_hr_threshold
 *              field.
 *
 *              Note that this attempt will fail if the cache is already
 *              at its maximum size, or if the cache is not already using
 *              all available space.
 *
 *      Note that you must set decr_mode to H5C_incr__off if you
 *      disable metadata cache entry evictions.
 *
 * lower_hr_threshold: Lower hit rate threshold.  If the increment mode
 *      (incr_mode) is H5C_incr__threshold and the hit rate drops below the
 *      value supplied in this field in an epoch, increment the cache size by
 *      size_increment.  Note that cache size may not be incremented above
 *      max_size, and that the increment may be further restricted by the
 *      max_increment field if it is enabled.
 *
 *      When enabled, this field must contain a value in the range [0.0, 1.0].
 *      Depending on the incr_mode selected, it may also have to be less than
 *      upper_hr_threshold.
 *
 * increment:  Double containing the multiplier used to derive the new
 *      cache size from the old if a cache size increment is triggered.
 *      The increment must be greater than 1.0, and should not exceed 2.0.
 *
 *      The new cache size is obtained my multiplying the current max cache
 *      size by the increment, and then clamping to max_size and to stay
 *      within the max_increment as necessary.
 *
 * apply_max_increment:  Boolean flag indicating whether the max_increment
 *      field should be used to limit the maximum cache size increment.
 *
 * max_increment: If enabled by the apply_max_increment field described
 *      above, this field contains the maximum number of bytes by which the
 *      cache size can be increased in a single re-size.
 *
 * flash_incr_mode:  Instance of the H5C_cache_flash_incr_mode enumerated
 *      type whose value indicates whether and by which algorithm we should
 *      make flash increases in the size of the cache to accommodate insertion
 *      of large entries and large increases in the size of a single entry.
 *
 *      The addition of the flash increment mode was occasioned by performance
 *      problems that appear when a local heap is increased to a size in excess
 *      of the current cache size.  While the existing re-size code dealt with
 *      this eventually, performance was very bad for the remainder of the
 *      epoch.
 *
 *      At present, there are two possible values for the flash_incr_mode:
 *
 *      H5C_flash_incr__off:  Don't perform flash increases in the size of
 *              the cache.
 *
 *      H5C_flash_incr__add_space:  Let x be either the size of a newly
 *              newly inserted entry, or the number of bytes by which the
 *              size of an existing entry has been increased.
 *
 *              If
 *                      x > flash_threshold * current max cache size,
 *
 *              increase the current maximum cache size by x * flash_multiple
 *              less any free space in the cache, and star a new epoch.  For
 *              now at least, pay no attention to the maximum increment.
 *
 *      In both of the above cases, the flash increment pays no attention to
 *      the maximum increment (at least in this first incarnation), but DOES
 *      stay within max_size.
 *
 *      With a little thought, it should be obvious that the above flash
 *      cache size increase algorithm is not sufficient for all circumstances
 *      -- for example, suppose the user round robins through
 *      (1/flash_threshold) +1 groups, adding one data set to each on each
 *      pass.  Then all will increase in size at about the same time, requiring
 *      the max cache size to at least double to maintain acceptable
 *      performance, however the above flash increment algorithm will not be
 *      triggered.
 *
 *      Hopefully, the add space algorithms detailed above will be sufficient
 *      for the performance problems encountered to date.  However, we should
 *      expect to revisit the issue.
 *
 * flash_multiple: Double containing the multiple described above in the
 *      H5C_flash_incr__add_space section of the discussion of the
 *      flash_incr_mode section.  This field is ignored unless flash_incr_mode
 *      is H5C_flash_incr__add_space.
 *
 * flash_threshold: Double containing the factor by which current max cache
 *      size is multiplied to obtain the size threshold for the add_space flash
 *      increment algorithm.  The field is ignored unless flash_incr_mode is
 *      H5C_flash_incr__add_space.
 *
 *
 * Cache size decrease control fields:
 *
 * decr_mode: Instance of the H5C_cache_decr_mode enumerated type whose
 *      value indicates how we determine whether the cache size should be
 *      decreased.  At present there are four possibilities.
 *
 *      H5C_decr__off:  Don't attempt to decrease the size of the cache
 *              automatically.
 *
 *              When this increment mode is selected, the remaining fields
 *              in the cache size decrease section are ignored.
 *
 *      H5C_decr__threshold: Attempt to decrease the size of the cache
 *              whenever the average hit rate over the last epoch rises
 *              above the value supplied in the upper_hr_threshold
 *              field.
 *
 *      H5C_decr__age_out:  At the end of each epoch, search the cache for
 *              entries that have not been accessed for at least the number
 *              of epochs specified in the epochs_before_eviction field, and
 *              evict these entries.  Conceptually, the maximum cache size
 *              is then decreased to match the new actual cache size.  However,
 *              this reduction may be modified by the min_size, the
 *              max_decrement, and/or the empty_reserve.
 *
 *      H5C_decr__age_out_with_threshold:  Same as age_out, but we only
 *              attempt to reduce the cache size when the hit rate observed
 *              over the last epoch exceeds the value provided in the
 *              upper_hr_threshold field.
 *
 *      Note that you must set decr_mode to H5C_decr__off if you
 *      disable metadata cache entry evictions.
 *
 * upper_hr_threshold: Upper hit rate threshold.  The use of this field
 *      varies according to the current decr_mode:
 *
 *      H5C_decr__off or H5C_decr__age_out:  The value of this field is
 *              ignored.
 *
 *      H5C_decr__threshold:  If the hit rate exceeds this threshold in any
 *              epoch, attempt to decrement the cache size by size_decrement.
 *
 *              Note that cache size may not be decremented below min_size.
 *
 *              Note also that if the upper_threshold is 1.0, the cache size
 *              will never be reduced.
 *
 *      H5C_decr__age_out_with_threshold:  If the hit rate exceeds this
 *              threshold in any epoch, attempt to reduce the cache size
 *              by evicting entries that have not been accessed for more
 *              than the specified number of epochs.
 *
 * decrement: This field is only used when the decr_mode is
 *      H5C_decr__threshold.
 *
 *      The field is a double containing the multiplier used to derive the
 *      new cache size from the old if a cache size decrement is triggered.
 *      The decrement must be in the range 0.0 (in which case the cache will
 *      try to contract to its minimum size) to 1.0 (in which case the
 *      cache will never shrink).
 *
 * apply_max_decrement:  Boolean flag used to determine whether decrements
 *      in cache size are to be limited by the max_decrement field.
 *
 * max_decrement: Maximum number of bytes by which the cache size can be
 *      decreased in a single re-size.  Note that decrements may also be
 *      restricted by the min_size of the cache, and (in age out modes) by
 *      the empty_reserve field.
 *
 * epochs_before_eviction:  Integer field used in H5C_decr__age_out and
 *      H5C_decr__age_out_with_threshold decrement modes.
 *
 *      This field contains the number of epochs an entry must remain
 *      unaccessed before it is evicted in an attempt to reduce the
 *      cache size.  If applicable, this field must lie in the range
 *      [1, H5C__MAX_EPOCH_MARKERS].
 *
 * apply_empty_reserve:  Boolean field controlling whether the empty_reserve
 *      field is to be used in computing the new cache size when the
 *      decr_mode is H5C_decr__age_out or H5C_decr__age_out_with_threshold.
 *
 * empty_reserve:  To avoid a constant racheting down of cache size by small
 *      amounts in the H5C_decr__age_out and H5C_decr__age_out_with_threshold
 *      modes, this field allows one to require that any cache size
 *      reductions leave the specified fraction of unused space in the cache.
 *
 *      The value of this field must be in the range [0.0, 1.0].  I would
 *      expect typical values to be in the range of 0.01 to 0.1.
 *
 *
 * Parallel Configuration Fields:
 *
 * In PHDF5, all operations that modify metadata must be executed collectively.
 *
 * We used to think that this was enough to ensure consistency across the
 * metadata caches, but since we allow processes to read metadata individually,
 * the order of dirty entries in the LRU list can vary across processes,
 * which can result in inconsistencies between the caches.
 *
 * PHDF5 uses several strategies to prevent such inconsistencies in metadata,
 * all of which use the fact that the same stream of dirty metadata is seen
 * by all processes for purposes of synchronization.  This is done by
 * having each process count the number of bytes of dirty metadata generated,
 * and then running a "sync point" whenever this count exceeds a user
 * specified threshold (see dirty_bytes_threshold below).
 *
 * The current metadata write strategy is indicated by the
 * metadata_write_strategy field.  The possible values of this field, along
 * with the associated metadata write strategies are discussed below.
 *
 * dirty_bytes_threshold:  Threshold of dirty byte creation used to
 *     synchronize updates between caches. (See above for outline and
 *    motivation.)
 *
 *    This value MUST be consistent across all processes accessing the
 *    file.  This field is ignored unless HDF5 has been compiled for
 *    parallel.
 *
 * metadata_write_strategy: Integer field containing a code indicating the
 *    desired metadata write strategy.  The valid values of this field
 *    are enumerated and discussed below:
 *
 *
 *    H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY:
 *
 *    When metadata_write_strategy is set to this value, only process
 *    zero is allowed to write dirty metadata to disk.  All other
 *    processes must retain dirty metadata until they are informed at
 *    a sync point that the dirty metadata in question has been written
 *    to disk.
 *
 *    When the sync point is reached (or when there is a user generated
 *    flush), process zero flushes sufficient entries to bring it into
 *    compliance with its min clean size (or flushes all dirty entries in
 *    the case of a user generated flush), broad casts the list of
 *    entries just cleaned to all the other processes, and then exits
 *    the sync point.
 *
 *    Upon receipt of the broadcast, the other processes mark the indicated
 *    entries as clean, and leave the sync point as well.
 *
 *
 *    H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED:
 *
 *    In the distributed metadata write strategy, process zero still makes
 *    the decisions as to what entries should be flushed, but the actual
 *    flushes are distributed across the processes in the computation to
 *    the extent possible.
 *
 *    In this strategy, when a sync point is triggered (either by dirty
 *    metadata creation or manual flush), all processes enter a barrier.
 *
 *    On the other side of the barrier, process 0 constructs an ordered
 *    list of the entries to be flushed, and then broadcasts this list
 *    to the caches in all the processes.
 *
 *    All processes then scan the list of entries to be flushed, flushing
 *    some, and marking the rest as clean.  The algorithm for this purpose
 *    ensures that each entry in the list is flushed exactly once, and
 *    all are marked clean in each cache.
 *
 *    Note that in the case of a flush of the cache, no message passing
 *    is necessary, as all processes have the same list of dirty entries,
 *    and all of these entries must be flushed.  Thus in this case it is
 *    sufficient for each process to sort its list of dirty entries after
 *    leaving the initial barrier, and use this list as if it had been
 *    received from process zero.
 *
 *    To avoid possible messages from the past/future, all caches must
 *    wait until all caches are done before leaving the sync point.
 *
 ****************************************************************************/

public static final int H5AC__CURR_CACHE_CONFIG_VERSION = 1;
public static final int H5AC__MAX_TRACE_FILE_NAME_LEN =   1024;

public static final int H5AC_METADATA_WRITE_STRATEGY__PROCESS_0_ONLY = 0;
public static final int H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED =    1;
// Targeting ..\H5AC_cache_config_t.java


/** <!-- [H5AC_cache_config_t_snip] --> */

public static final int H5AC__CURR_CACHE_IMAGE_CONFIG_VERSION = 1;

public static final int H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE = -1;
public static final int H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX =  100;
// Targeting ..\H5AC_cache_image_config_t.java



/** <!-- [H5AC_cache_image_config_t_snip] --> */

// #endif


// Parsed from H5Dpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5D module.
 */
// #ifndef H5Dpublic_H
// #define H5Dpublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/*****************/
/* Public Macros */
/*****************/

/* Macros used to "unset" chunk cache configuration parameters */
public static native @MemberGetter int H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static final int H5D_CHUNK_CACHE_NSLOTS_DEFAULT = H5D_CHUNK_CACHE_NSLOTS_DEFAULT();
public static native @MemberGetter int H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final int H5D_CHUNK_CACHE_NBYTES_DEFAULT = H5D_CHUNK_CACHE_NBYTES_DEFAULT();
public static final double H5D_CHUNK_CACHE_W0_DEFAULT =     (-1.0);

/**
 * Bit flags for the H5Pset_chunk_opts() and H5Pget_chunk_opts()
 */
public static final int H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS = (0x0002);

/*******************/
/* Public Typedefs */
/*******************/

/** <!-- [H5D_layout_t_snip] -->
/**
 * Values for the H5D_LAYOUT property
 */
/** enum H5D_layout_t */
public static final int
    /** error */
    H5D_LAYOUT_ERROR = -1,
    /** raw data is small (< 64KB) */
    H5D_COMPACT      = 0,
    /** contiguous layout */
    H5D_CONTIGUOUS   = 1,
    /** chunked or tiled layout */
    H5D_CHUNKED      = 2,
    /** actual data is stored in other datasets */
    H5D_VIRTUAL      = 3,
    /** this one must be last! */
    H5D_NLAYOUTS     = 4;
/** <!-- [H5D_layout_t_snip] -->
 <p>
 *  <!-- [H5D_chunk_index_t_snip] -->
/**
 * Types of chunk index data structures
 */
/** enum H5D_chunk_index_t */
public static final int
    /** v1 B-tree index (default)                */
    H5D_CHUNK_IDX_BTREE = 0,
    /** Single Chunk index (cur dims[]=max dims[]=chunk dims[]; filtered & non-filtered) */
    H5D_CHUNK_IDX_SINGLE = 1,
    /** Implicit: No Index (#H5D_ALLOC_TIME_EARLY, non-filtered, fixed dims) */
    H5D_CHUNK_IDX_NONE   = 2,
    /** Fixed array (for 0 unlimited dims)       */
    H5D_CHUNK_IDX_FARRAY = 3,
    /** Extensible array (for 1 unlimited dim)   */
    H5D_CHUNK_IDX_EARRAY = 4,
    /** v2 B-tree index (for >1 unlimited dims)  */
    H5D_CHUNK_IDX_BT2    = 5,
    /** This one must be last!                   */
    H5D_CHUNK_IDX_NTYPES = 6;
/** <!-- [H5D_chunk_index_t_snip] -->
 <p>
 *  <!-- [H5D_alloc_time_t_snip] -->
/**
 * Values for the space allocation time property
 */
/** enum H5D_alloc_time_t */
public static final int
    /** Error */
    H5D_ALLOC_TIME_ERROR   = -1,
    /** Default (layout dependent) */
    H5D_ALLOC_TIME_DEFAULT = 0,
    /** Allocate on creation */
    H5D_ALLOC_TIME_EARLY   = 1,
    /** Allocate on first write */
    H5D_ALLOC_TIME_LATE    = 2,
    /** Allocate incrementally (by chunk) */
    H5D_ALLOC_TIME_INCR    = 3;
/** <!-- [H5D_alloc_time_t_snip] -->
 <p>
 *  <!-- [H5D_space_status_t_snip] -->
/**
 * Values for the status of space allocation
 */
/** enum H5D_space_status_t */
public static final int
    /** Error */
    H5D_SPACE_STATUS_ERROR          = -1,
    /** Space has not been allocated for this dataset. */
    H5D_SPACE_STATUS_NOT_ALLOCATED  = 0,
    /** Space has been partially allocated for this dataset.
                                               (Used only for datasets with chunked storage.) */
    H5D_SPACE_STATUS_PART_ALLOCATED = 1,
    /** Space has been allocated for this dataset. */
    H5D_SPACE_STATUS_ALLOCATED = 2;
/** <!-- [H5D_space_status_t_snip] -->
 <p>
 *  <!-- [H5D_fill_time_t_snip] -->
/**
 * Values for time of writing fill value property
 */
/** enum H5D_fill_time_t */
public static final int
    /** Error */
    H5D_FILL_TIME_ERROR = -1,
    /** Fill on allocation */
    H5D_FILL_TIME_ALLOC = 0,
    /** Never write fill values */
    H5D_FILL_TIME_NEVER = 1,
    /** Fill if fill-value was set */
    H5D_FILL_TIME_IFSET = 2;
/** <!-- [H5D_fill_time_t_snip] -->
 <p>
 *  <!-- [H5D_fill_value_t_snip] -->
/**
 * Values for fill value status
 */
/** enum H5D_fill_value_t */
public static final int
    /** Error */
    H5D_FILL_VALUE_ERROR        = -1,
    /** No fill value defined */
    H5D_FILL_VALUE_UNDEFINED    = 0,
    /** Default fill-value */
    H5D_FILL_VALUE_DEFAULT      = 1,
    /** User-defined fill-value */
    H5D_FILL_VALUE_USER_DEFINED = 2;
/** <!-- [H5D_fill_value_t_snip] -->
 <p>
 *  <!-- [H5D_vds_view_t_snip] -->
/**
 * Values for VDS bounds option
 */
/** enum H5D_vds_view_t */
public static final int
    /** Error */
    H5D_VDS_ERROR          = -1,
    /** Include all data before the first missing mapped data */
    H5D_VDS_FIRST_MISSING  = 0,
    /** Include all available mapped data */
    H5D_VDS_LAST_AVAILABLE = 1;
// Targeting ..\H5D_append_cb_t.java


// Targeting ..\H5D_operator_t.java


// Targeting ..\H5D_scatter_func_t.java


// Targeting ..\H5D_gather_func_t.java


/** <!-- [H5D_gather_func_t_snip] -->
<p>
/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus */
// #endif

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Creates a new dataset and links it into the file
 *
 * \fgdta_loc_id
 * @param name [in] Name of the dataset to create
 * \type_id
 * \space_id
 * \lcpl_id
 * \dcpl_id
 * \dapl_id
 *
 * @return \hid_t{dataset}
 *
 * \details H5Dcreate2() creates a new dataset named \p name at
 *          the location specified by \p loc_id, and associates constant
 *          and initial persistent properties with that dataset, including
 *          the datatype \p dtype_id, the dataspace \p space_id, and
 *          other properties as specified by the dataset creation property
 *          list \p dcpl_id and the access property list \p dapl_id,
 *          respectively. Once created, the dataset is opened for access.
 *
 *          \p loc_id may specify a file, group, dataset, named datatype,
 *          or attribute.  If an attribute, dataset, or named datatype is
 *          specified then the dataset will be created at the location
 *          where the attribute, dataset, or named datatype is attached.
 *
 *          \p name may be either an absolute path in the file or a relative
 *          path from \p loc_id naming the dataset.
 *
 *          If \p dtype_id is a committed datatype, and if the file location
 *          associated with the committed datatype is different from the
 *          file location where the dataset will be created, the datatype
 *          is copied and converted to a transient type.
 *
 *          The link creation property list, \p lcpl_id, governs creation
 *          of the link(s) by which the new dataset is accessed and the
 *          creation of any intermediate groups that may be missing.
 *
 *          The datatype and dataspace properties and the dataset creation
 *          and access property lists are attached to the dataset, so the
 *          caller may derive new datatypes, dataspaces, and creation and
 *          access properties from the old ones and reuse them in calls to
 *          create additional datasets.  Once created, the dataset can be
 *          read from or written to. Reading data from a dataset that was
 *          not previously written, the HDF5 library will return default
 *          or user-defined fill values.
 *
 * \par Example
 * \snippet H5D_examples.c create
 *
 * @since 1.8.0
 *
 * @see H5Dopen2(), H5Dclose(), H5Tset_size()
 *
 */
public static native @Cast("hid_t") long H5Dcreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long lcpl_id,
                        @Cast("hid_t") long dcpl_id, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dcreate2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long lcpl_id,
                        @Cast("hid_t") long dcpl_id, @Cast("hid_t") long dapl_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Creates a dataset in a file without linking it into the file
 *        structure
 *
 * \fgdta_loc_id
 * \type_id
 * \space_id
 * \dcpl_id
 * \dapl_id
 *
 * @return \hid_t{dataset}
 *
 * \details H5Dcreate_anon() creates a dataset in the file specified
 *          by \p loc_id.
 *
 *          \p loc_id may specify a file, group, dataset, named datatype,
 *          or attribute.  If an attribute, dataset, or named datatype is
 *          specified then the dataset will be created at the location
 *          where the attribute, dataset, or named datatype is attached.
 *
 *          The dataset’s datatype and dataspace are specified by
 *          \p type_id and \p space_id, respectively. These are the
 *          datatype and dataspace of the dataset as it will exist in
 *          the file, which may differ from the datatype and dataspace
 *          in application memory.
 *
 *          H5Dcreate_anon() returns a new dataset identifier. Using
 *          this identifier, the new dataset must be linked into the
 *          HDF5 file structure with H5Olink() or it will be deleted
 *          when the file is closed.
 *
 * @since 1.8.0
 *
 * @see H5Olink(), H5Dcreate()
 *
 */
public static native @Cast("hid_t") long H5Dcreate_anon(@Cast("hid_t") long loc_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hid_t") long dcpl_id, @Cast("hid_t") long dapl_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Creates a new dataset and links it into the file
 *
 * \fgdta_loc_id
 * @param name [in]      Name of the dataset to open
 * \dapl_id
 *
 * @return \hid_t{dataset}
 *
 * \details H5Dopen2() opens the existing dataset specified
 *          by a location identifier and name, \p loc_id and \p name,
 *          respectively.
 *
 *          \p loc_id may specify a file, group, dataset, named datatype,
 *          or attribute.  If an attribute, dataset, or named datatype is
 *          specified then the dataset will be opened at the location
 *          where the attribute, dataset, or named datatype is attached.
 *
 * @since 1.8.0
 *
 * @see H5Dcreate2(), H5Dclose()
 *
 */
public static native @Cast("hid_t") long H5Dopen2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long dapl_id);
public static native @Cast("hid_t") long H5Dopen2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long dapl_id);

/**
 * --------------------------------------------------------------------------
 *\ingroup H5D
 *
 * \brief Returns an identifier for a copy of the dataspace for a dataset
 *
 * \dset_id
 *
 * @return \hid_t{dataspace}
 *
 * \details H5Dget_space() makes a copy of the dataspace of
 *          the dataset specified by \p dset_id. The function returns an
 *          identifier for the new copy of the dataspace.
 *
 *          A dataspace identifier returned from this function should
 *          be released with H5Sclose() when the identifier is no longer
 *          needed so that resource leaks will not occur.
 *
 * \par Example
 * \snippet H5D_examples.c update
 *
 * @see H5Sclose()
 *
 */
public static native @Cast("hid_t") long H5Dget_space(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Determines whether space has been allocated for a dataset
 *
 * \dset_id
 * @param allocation [out] Space allocation status
 *
 * @return \herr_t
 *
 * \details H5Dget_space_status() determines whether space has been allocated
 *          for the dataset \p dset_id.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") IntPointer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") IntBuffer allocation);
public static native @Cast("herr_t") int H5Dget_space_status(@Cast("hid_t") long dset_id, @Cast("H5D_space_status_t*") int[] allocation);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns an identifier for a copy of the datatype for a dataset
 *
 * \dset_id
 *
 * @return \hid_t{datatype}
 *
 * \details H5Dget_type() returns an identifier of a copy of
 *          the datatype for a dataset.
 *
 *          If a dataset has a named datatype, then an identifier to the
 *          opened datatype is returned. Otherwise, the returned datatype
 *          is read-only.
 *
 */
public static native @Cast("hid_t") long H5Dget_type(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns an identifier for a copy of the dataset creation
 *        property list for a dataset
 *
 * \dset_id
 *
 * @return \hid_t{dataset creation property list}
 *
 * \details H5Dget_create_plist() returns an identifier for
 *          a copy of the dataset creation property list associated with
 *          the dataset specified by \p dset_id.
 *
 */
public static native @Cast("hid_t") long H5Dget_create_plist(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns the dataset access property list associated with
 *        a dataset
 *
 * \dset_id
 *
 * @return \hid_t{dataset access property list}
 *
 * \details H5Dget_access_plist() returns a copy of the
 *          dataset access property list used to open the specified
 *          dataset, \p dset_id. Modifications to the returned property
 *          list will have no effect on the dataset it was retrieved from.
 *
 *          The chunk cache parameters in the returned property lists will
 *          be those used by the dataset. If the properties in the file
 *          access property list were used to determine the dataset's
 *          chunk cache configuration, then those properties will be
 *          present in the returned dataset access property list. If
 *          the dataset does not use a chunked layout, then the chunk
 *          cache properties will be set to the default. The chunk cache
 *          properties in the returned list are considered to be “set”,
 *          and any use of this list will override the corresponding
 *          properties in the file’s file access property list.
 *
 *          All link access properties in the returned list will be set
 *          to the default values.
 *
 * @since 1.8.3
 *
 */
public static native @Cast("hid_t") long H5Dget_access_plist(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns the amount of storage allocated for a dataset
 *
 * \dset_id
 *
 * @return Returns the amount of storage space, in bytes, or 0 (zero).
 *
 * \details H5Dget_storage_size() returns the amount of storage,
 *          in bytes, that is allocated in the file for the raw data of
 *          the dataset specified by \p dset_id.
 *          H5Dget_storage_size() reports only the space required to store
 *          the dataset elements, excluding any metadata.
 *          \li For contiguous datasets, the returned size equals the current
 *          allocated size of the raw data.
 *          \li For unfiltered chunked datasets, the returned size is the
 *          number of allocated chunks times the chunk size.
 *          \li For filtered chunked datasets, the returned size is the
 *          space required to store the filtered data. For example, if a
 *          compression filter is in use, H5Dget_storage_size() will return
 *          the total space required to store the compressed chunks.
 *
 * \note Note that H5Dget_storage_size() is not generally an
 *       appropriate function to use when determining the amount
 *       of memory required to work with a dataset. In such
 *       circumstances, you must determine the number of data
 *       points in a dataset and the size of an individual dataset
 *       element. H5Sget_simple_extent_npoints() and H5Tget_size()
 *       can be used to calculate that amount.
 *
 * \warning H5Dget_storage_size() does not differentiate between 0 (zero),
 *          the value returned for the storage size of a dataset
 *          with no stored values, and 0 (zero), the value returned to
 *          indicate an error.
 *
 *
 */
public static native @Cast("hsize_t") long H5Dget_storage_size(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns the amount of storage allocated within the file for a
 * raw data chunk in a dataset
 *
 * \dset_id
 * @param offset [in]   Logical offset in the dataset for the chunk to query
 * @param chunk_bytes [out] The size in bytes for the chunk
 *
 * @return \herr_t
 *
 * \details H5Dget_chunk_storage_size() returns the size in bytes
 *          allocated in the file for a raw data chunk as specified by
 *          its logical \p offset in the dataset \p dset_id. The size is
 *          returned in \p chunk_nbytes. It is the size of the compressed
 *          data if the chunk is filtered and the size may be zero if no
 *          storage is allocated yet for the dataset.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer offset, @Cast("hsize_t*") LongPointer chunk_bytes);
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer offset, @Cast("hsize_t*") LongBuffer chunk_bytes);
public static native @Cast("herr_t") int H5Dget_chunk_storage_size(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] offset, @Cast("hsize_t*") long[] chunk_bytes);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Retrieves number of chunks that have nonempty intersection with a
 *        specified selection
 *
 * \dset_id
 * @param fspace_id [in]   File dataspace selection identifier
 * @param nchunks [out]     Number of chunks in the selection
 *
 * @return \herr_t
 *
 * \details H5Dget_num_chunks() retrieves the number of chunks
 *          nchunks in a set of selected elements specified by \p fspace_id
 *          for a dataset specified by the identifier \p dset_id. If \p
 *          fspace_id is #H5S_ALL, the function will retrieve the total
 *          number of chunks stored for the dataset.
 *
 *          \p fspace_id specifies the file dataspace selection.  It is
 *          intended to take #H5S_ALL for specifying the current selection.
 *
 *          \note Please be aware that this function currently does not
 *          support non-trivial selections, thus \p fspace_id has no
 *          effect. Also, the implementation does not handle the #H5S_ALL
 *          macro correctly.  As a workaround, application can get
 *          the dataspace for the dataset using H5Dget_space() and pass that
 *          in for \p fspace_id.  This will be fixed in a future release.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") LongPointer nchunks);
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") LongBuffer nchunks);
public static native @Cast("herr_t") int H5Dget_num_chunks(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t*") long[] nchunks);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Retrieves information about a chunk specified by its coordinates
 *
 * \dset_id
 * @param offset [in]      Logical position of the chunk’s first element
 * @param filter_mask [out] Indicating filters used with the chunk when written
 * @param addr [out]        Chunk address in the file
 * @param size [out]        Chunk size in bytes, 0 if chunk doesn’t exist
 *
 * @return \herr_t
 *
 * \details H5Dget_chunk_info_by_coord() retrieves the \p filter_mask, \p size,
 *          and \p addr for a chunk in the dataset specified by \p dset_id,
 *          using the coordinates specified by \p offset.
 *
 *          If the queried chunk does not exist in the file, \p size will
 *          be set to 0, \p addr to \c HADDR_UNDEF, and the buffer \p
 *          filter_mask will not be modified.
 *
 *          \p offset is a pointer to a one-dimensional array with a size
 *          equal to the dataset’s rank. Each element is the logical
 *          position of the chunk’s first element in a dimension.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer offset, @Cast("unsigned*") IntPointer filter_mask,
                                         @Cast("haddr_t*") LongPointer addr, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer offset, @Cast("unsigned*") IntBuffer filter_mask,
                                         @Cast("haddr_t*") LongBuffer addr, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dget_chunk_info_by_coord(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] offset, @Cast("unsigned*") int[] filter_mask,
                                         @Cast("haddr_t*") long[] addr, @Cast("hsize_t*") long[] size);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Retrieves information about a chunk specified by its index
 *
 * \dset_id
 * @param fspace_id [in] File dataspace selection identifier (See Note below)
 * @param chk_idx [in]   Index of the chunk
 * @param offset [out]    Logical position of the chunk’s first element
 * @param filter_mask [out] Indicating filters used with the chunk when written
 * @param addr [out]      Chunk address in the file
 * @param size [out]      Chunk size in bytes, 0 if chunk doesn’t exist
 *
 * @return \herr_t
 *
 * \details H5Dget_chunk_info() retrieves the offset coordinates,
 *          \p offset, filter mask, \p filter_mask, size, \p size, and address
 *          \p addr for the dataset specified by the identifier \p dset_id and the chunk
 *          specified by the index \p index. The chunk belongs to a set of
 *          chunks in the selection specified by \p fspace_id. If the queried
 *          chunk does not exist in the file, the size will be set to 0 and
 *          address to #HADDR_UNDEF. The value pointed to by filter_mask will
 *          not be modified. \c NULL can be passed in for any \p out parameters.
 *
 *          \p chk_idx is the chunk index in the selection. The index value
 *          may have a value of 0 up to the number of chunks stored in
 *          the file that have a nonempty intersection with the file
 *          dataspace selection
 *
 *          \note As of 1.10.5, the dataspace intersection is not yet
 *          supported, hence, the index is of all the written chunks.
 *
 *          \p fspace_id specifies the file dataspace selection.  It is
 *          intended to take #H5S_ALL for specifying the current selection.
 *
 *          \note Please be aware that this function currently does not
 *          support non-trivial selections, thus \p fspace_id has no
 *          effect. Also, the implementation does not handle the #H5S_ALL
 *          macro correctly.  As a workaround, an application can get
 *          the dataspace for the dataset using H5Dget_space() and pass that
 *          in for \p fspace_id.  This will be fixed in a future release.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") LongPointer offset,
                                @Cast("unsigned*") IntPointer filter_mask, @Cast("haddr_t*") LongPointer addr, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") LongBuffer offset,
                                @Cast("unsigned*") IntBuffer filter_mask, @Cast("haddr_t*") LongBuffer addr, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dget_chunk_info(@Cast("hid_t") long dset_id, @Cast("hid_t") long fspace_id, @Cast("hsize_t") long chk_idx, @Cast("hsize_t*") long[] offset,
                                @Cast("unsigned*") int[] filter_mask, @Cast("haddr_t*") long[] addr, @Cast("hsize_t*") long[] size);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Returns dataset address in file
 *
 * \dset_id
 *
 * @return Returns the offset in bytes; otherwise, returns #HADDR_UNDEF,
 *         a negative value.
 *
 * \details H5Dget_offset() returns the address in the file of
 *          the dataset, \p dset_id. That address is expressed as the
 *          offset in bytes from the beginning of the file.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("haddr_t") long H5Dget_offset(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Reads raw data from a dataset into a provided buffer
 *
 * \dset_id                 Identifier of the dataset to read from
 * @param mem_type_id [in]   Identifier of the memory datatype
 * @param mem_space_id [in]  Identifier of the memory dataspace
 * @param file_space_id [in] Identifier of the dataset's dataspace in the file
 * @param dxpl_id [in]       Identifier of a transfer property list
 * @param buf [out]          Buffer to receive data read from file
 *
 * @return \herr_t
 *
 * \details H5Dread() reads a dataset, specified by its identifier
 *          \p dset_id, from the file into an application memory buffer \p
 *          buf. Data transfer properties are defined by the argument \p
 *          dxpl_id. The memory datatype of the (partial) dataset
 *          is identified by the identifier \p mem_type_id. The part
 *          of the dataset to read is defined by \p mem_space_id and \p
 *          file_space_id.
 *
 *          \p file_space_id is used to specify only the selection within
 *          the file dataset's dataspace. Any dataspace specified in \p
 *          file_space_id is ignored by the library and the dataset's
 *          dataspace is always used. \p file_space_id can be the constant
 *          #H5S_ALL, which indicates that the entire file dataspace,
 *          as defined by the current dimensions of the dataset, is to
 *          be selected.
 *
 *          \p mem_space_id is used to specify both the memory dataspace
 *          and the selection within that dataspace. \p mem_space_id can
 *          be the constant #H5S_ALL, in which case the file dataspace is
 *          used for the memory dataspace and the selection defined with \p
 *          file_space_id is used for the selection within that dataspace.
 *
 *          The number of elements selected in the memory dataspace \Emph{must}
 *          be equal to the number of elements selected in the file dataspace.
 *
 *          The behavior of the library for the various combinations of
 *          valid dataspace identifiers and #H5S_ALL for the \p mem_space_id
 *          and the \p file_space_id parameters is described below:
 *
 *          <table>
 *            <tr>
 *              <th>mem_space_id</th>
 *              <th>file_space_id</th>
 *              <th>Behavior</th>
 *            </tr>
 *            <tr>
 *              <td>valid dataspace ID</td>
 *              <td>valid dataspace ID</td>
 *              <td>\p mem_space_id specifies the memory dataspace and the
 *                  selection within it. \p file_space_id specifies the
 *                  selection within the file dataset's dataspace.</td>
 *            </tr>
 *            <tr>
 *              <td>#H5S_ALL</td>
 *              <td>valid dataspace ID</td>
 *              <td>The file dataset's dataspace is used for the memory
 *                  dataspace and the selection specified with \p file_space_id
 *                  specifies the selection within it. The combination of the
 *                  file dataset's dataspace and the selection from
 *                  \p file_space_id is used for memory also.</td>
 *            </tr>
 *            <tr>
 *              <td>valid dataspace ID</td>
 *              <td>#H5S_ALL</td>
 *              <td>\p mem_space_id specifies the memory dataspace and the
 *                  selection within it. The selection within the file
 *                  dataset's dataspace is set to the "all" selection.</td>
 *            </tr>
 *            <tr>
 *              <td>#H5S_ALL</td>
 *              <td>#H5S_ALL</td>
 *              <td>The file dataset's dataspace is used for the memory
 *                  dataspace and the selection within the memory dataspace
 *                  is set to the "all" selection. The selection within the
 *                  file dataset's dataspace is set to the "all" selection.</td>
 *            </tr>
 *          </table>
 *
 * \note If no storage space was allocated for the dataset
 *       and a fill value is defined, the returned buffer \p buf
 *       is filled with the fill value.
 *
 * \par Example
 * \snippet H5D_examples.c read
 *
 */
public static native @Cast("herr_t") int H5Dread(@Cast("hid_t") long dset_id, @Cast("hid_t") long mem_type_id, @Cast("hid_t") long mem_space_id, @Cast("hid_t") long file_space_id,
                      @Cast("hid_t") long dxpl_id, Pointer buf);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Writes raw data from a buffer to a dataset
 *
 * @param dset_id [in]        Identifier of the dataset to read from
 * @param mem_type_id [in]    Identifier of the memory datatype
 * @param mem_space_id [in]   Identifier of the memory dataspace
 * @param file_space_id [in]  Identifier of the dataset's dataspace in the file
 * \dxpl_id
 * @param buf [out]           Buffer with data to be written to the file
 *
 * @return \herr_t
 *
 * \details H5Dwrite() writes a (partial) dataset, specified by
 *          its identifier \p dset_id, from the application memory buffer \p
 *          buf into the file. Data transfer properties are defined by the
 *          argument \p dxpl_id. The memory datatype of the (partial)
 *          dataset is identified by the identifier \p mem_type_id. The
 *          part of the dataset to write is defined by \p mem_space_id
 *          and \p file_space_id.
 *
 *          If \p mem_type_id is either a fixed-length or variable-length
 *          string, it is important to set the string length when defining
 *          the datatype. String datatypes are derived from #H5T_C_S1
 *          (or #H5T_FORTRAN_S1 for Fortran codes), which defaults
 *          to 1 character in size. See H5Tset_size() and Creating
 *          variable-length string datatypes.
 *
 *          \p file_space_id is used to specify only the selection within
 *          the file dataset's dataspace. Any dataspace specified in \p
 *          file_space_id is ignored by the library and the dataset's
 *          dataspace is always used. \p file_space_id can be the constant
 *          #H5S_ALL, which indicates that the entire file dataspace,
 *          as defined by the current dimensions of the dataset, is to
 *          be selected.
 *
 *          \p mem_space_id is used to specify both the memory dataspace
 *          and the selection within that dataspace. mem_space_id can be
 *          the constant #H5S_ALL, in which case the file dataspace is
 *          used for the memory dataspace and the selection defined with \p
 *          file_space_id is used for the selection within that dataspace.
 *
 *          The behavior of the library for the various combinations of
 *          valid dataspace IDs and #H5S_ALL for the mem_space_id and
 *          thefile_space_id parameters is described below:
 *
 *          <table>
 *          <tr><th>\c mem_space_id</th>
 *          <th>\c file_space_id</th>
 *          <th>Behavior</th></tr>
 *          <tr><td>valid dataspace ID</td>
 *              <td>valid dataspace ID</td>
 *              <td>\p mem_space_id specifies the memory dataspace and the
 *                  selection within it. \p file_space_id specifies the
 *                  selection within the file dataset's dataspace.</td></tr>
 *          <tr><td>#H5S_ALL</td>
 *              <td>valid dataspace ID</td>
 *              <td>The file dataset's dataspace is used for the memory
 *                  dataspace and the selection specified with \p file_space_id
 *                  specifies the selection within it. The combination of the
 *                  file dataset's dataspace and the selection from \p
 *                  file_space_id is used for memory also. valid dataspace
 *                  ID</td></tr>
 *          <tr><td>valid dataspace ID</td>
 *              <td>#H5S_ALL</td>
 *              <td>\p mem_space_id specifies the memory dataspace and the
 *                  selection within it. The selection within the file
 *                  dataset's dataspace is set to "all" selection.</td></tr>
 *          <tr><td>#H5S_ALL</td>
 *              <td>#H5S_ALL</td>
 *              <td>The file dataset's dataspace is used for the memory
 *                  dataspace and the selection within the memory dataspace is
 *                  set to the "all" selection. The selection within the file
 *                  dataset's dataspace is set to the "all"
 *                  selection.</td></tr>
 *          </table>
 *          Setting an "all" selection indicates that the entire dataspace,
 *          as defined by the current dimensions of a dataspace, will
 *          be selected. The number of elements selected in the memory
 *          dataspace must match the number of elements selected in the
 *          file dataspace.
 *
 *          \p dxpl_id can be the constant #H5P_DEFAULT, in which
 *          case the default data transfer properties are used.
 *
 *          Writing to a dataset will fail if the HDF5 file was not opened
 *          with write access permissions.
 *
 *          If the dataset's space allocation time is set to
 *          #H5D_ALLOC_TIME_LATE or #H5D_ALLOC_TIME_INCR and the space for
 *          the dataset has not yet been allocated, that space is allocated
 *          when the first raw data is written to the dataset. Unused space
 *          in the dataset will be written with fill values at the same
 *          time if the dataset's fill time is set to #H5D_FILL_TIME_IFSET
 *          or #H5D_FILL_TIME_ALLOC.
 *
 * \par_compr_note
 *
 * \attention If a dataset's storage layout is 'compact', care must be
 *          taken when writing data to the dataset in parallel. A compact
 *          dataset's raw data is cached in memory and may be flushed
 *          to the file from any of the parallel processes, so parallel
 *          applications should always attempt to write identical data to
 *          the dataset from all processes.
 *
 * \par Example
 * \snippet H5D_examples.c update
 *
 * @see H5Pset_fill_time(), H5Pset_alloc_time()
 *
 */
public static native @Cast("herr_t") int H5Dwrite(@Cast("hid_t") long dset_id, @Cast("hid_t") long mem_type_id, @Cast("hid_t") long mem_space_id, @Cast("hid_t") long file_space_id,
                       @Cast("hid_t") long dxpl_id, @Const Pointer buf);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Writes a raw data chunk from a buffer directly to a dataset in a file
 *
 * \dset_id
 * \dxpl_id
 * @param filters [in]  Mask for identifying the filters in use
 * @param offset [in]   Logical position of the chunk’s first element in the
 *                      dataspace
 * @param data_size [in]    Size of the actual data to be written in bytes
 * @param buf [in]          Buffer containing data to be written to the chunk
 *
 * @return \herr_t
 *
 * \details H5Dwrite_chunk() writes a raw data chunk as specified
 *          by its logical offset \p offset in a chunked dataset \p dset_id
 *          from the application memory buffer \p buf to the dataset in
 *          the file. Typically, the data in \p buf is preprocessed in
 *          memory by a custom transformation, such as compression. The
 *          chunk will bypass the library’s internal data transfer
 *          pipeline, including filters, and will be written directly to
 *          the file. Only one chunk can be written with this function.
 *
 *          \p filters is a mask providing a record of which filters are
 *          used with the the chunk. The default value of the mask is
 *          zero (0), indicating that all enabled filters are applied. A
 *          filter is skipped if the bit corresponding to the filter’s
 *          position in the pipeline (0 ≤ position < 32) is turned on.
 *          This mask is saved with the chunk in the file.
 *
 *          \p offset is an array specifying the logical position of the
 *          first element of the chunk in the dataset’s dataspace. The
 *          length of the offset array must equal the number of dimensions,
 *          or rank, of the dataspace. The values in offset must not exceed
 *          the dimension limits and must specify a point that falls on
 *          a dataset chunk boundary.
 *
 *          \p data_size is the size in bytes of the chunk, representing
 *          the number of bytes to be read from the buffer \p buf. If the
 *          data chunk has been precompressed, \p data_size should be the
 *          size of the compressed data.
 *
 *          \p buf is the memory buffer containing data to be written to
 *          the chunk in the file.
 *
 * \attention Exercise caution when using H5Dread_chunk() and
 *          H5Dwrite_chunk(), as they read and write data chunks directly
 *          in a file. H5Dwrite_chunk() bypasses hyperslab selection, the
 *          conversion of data from one datatype to another, and the filter
 *          pipeline to write the chunk. Developers should have experience
 *          with these processes before using this function.
 *
 * \note    H5Dread_chunk() and H5Dwrite_chunk() are currently not supported
 *          with parallel HDF5 and do not support variable-length types.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") short filters, @Cast("const hsize_t*") LongPointer offset,
                             @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") short filters, @Cast("const hsize_t*") LongBuffer offset,
                             @Cast("size_t") long data_size, @Const Pointer buf);
public static native @Cast("herr_t") int H5Dwrite_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("uint32_t") short filters, @Cast("const hsize_t*") long[] offset,
                             @Cast("size_t") long data_size, @Const Pointer buf);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Reads a raw data chunk directly from a dataset in a file into
 * a buffer
 *
 * \dset_id
 * \dxpl_id
 * @param offset [in]   Logical position of the chunk’s first element in the
 *                      dataspace
 * @param filters [in,out]  Mask for identifying the filters in use
 * @param buf [out]     Buffer containing data to be written to the chunk
 *
 * @return \herr_t
 *
 * \details H5Dread_chunk() reads a raw data chunk as specified by
 *          its logical offset \p offset in a chunked dataset \p dset_id
 *          from the dataset in the file into the application memory
 *          buffer \p buf. The data in \p buf is read directly from the
 *          file bypassing the library’s internal data transfer pipeline,
 *          including filters.
 *
 *          \p offset is an array specifying the logical position of the
 *          first element of the chunk in the dataset’s dataspace. The
 *          length of the \p offset array must equal the number of dimensions,
 *          or rank, of the dataspace. The values in \p offset must not exceed
 *          the dimension limits and must specify a point that falls on
 *          a dataset chunk boundary.
 *
 *          The mask \p filters indicates which filters were used when the
 *          chunk was written. A zero value (all bits 0) indicates that all
 *          enabled filters are applied on the chunk. A filter is skipped if
 *          the bit corresponding to the filter’s position in the pipeline
 *          (0 ≤ position < 32) is turned on.
 *
 *          \p buf is the memory buffer containing the chunk read from
 *          the dataset in the file.
 *
 * \attention Exercise caution when using H5Dread_chunk() and
 *          H5Dwrite_chunk(), as they read and write data chunks directly
 *          in a file. H5Dwrite_chunk() bypasses hyperslab selection, the
 *          conversion of data from one datatype to another, and the filter
 *          pipeline to write the chunk. Developers should have experience
 *          with these processes before using this function. Please see
 *          Using the Direct Chunk Write Function for more information.
 *
 * \note H5Dread_chunk() and H5Dwrite_chunk() are currently not supported
 *       with parallel HDF5 and do not support variable-length datatypes.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("const hsize_t*") LongPointer offset, @Cast("uint32_t*") ShortPointer filters,
                            Pointer buf);
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("const hsize_t*") LongBuffer offset, @Cast("uint32_t*") ShortBuffer filters,
                            Pointer buf);
public static native @Cast("herr_t") int H5Dread_chunk(@Cast("hid_t") long dset_id, @Cast("hid_t") long dxpl_id, @Cast("const hsize_t*") long[] offset, @Cast("uint32_t*") short[] filters,
                            Pointer buf);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Iterates over all selected elements in a dataspace
 *
 * @param buf [in,out] Buffer containing the elements to iterate over
 * \type_id
 * \space_id
 * @param op [in] Function pointer
 * @param operator_data [in,out] User-defined data
 *
 * @return \success{The return value of the first operator that returns
 *                  non-zero, or zero if all members were processed with no
 *                  operator returning non-zero.}
 * @return \failure{Negative if an error occurs in the library, or the negative
 *                  value returned by one of the operators.}
 *
 * \details H5Diterate() iterates over all the data elements
 *          in the memory buffer \p buf, executing the callback function
 *          \p op once for each such data element.
 *
 * \attention Unlike other HDF5 iterators, this iteration operation cannot
 *            be restarted at the point of exit; a second H5Diterate()
 *            call will always restart at the beginning.
 *
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Diterate(Pointer buf, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, H5D_operator_t op, Pointer operator_data);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Determines the number of bytes required to store variable-length
 *        (VL) data
 *
 * \dset_id
 * \type_id
 * \space_id
 * @param size [out] Size in bytes of the memory buffer required to store
 *        the VL data
 *
 * @return \herr_t
 *
 * \details H5Dvlen_get_buf_size() determines the number of bytes
 *          required to store the VL data from the dataset, using \p
 *          space_id for the selection in the dataset on disk and the \p
 *          type_id for the memory representation of the VL data in memory.
 *          \p size is returned with the number of bytes required to store
 *          the VL data in memory.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dvlen_get_buf_size(@Cast("hid_t") long dset_id, @Cast("hid_t") long type_id, @Cast("hid_t") long space_id, @Cast("hsize_t*") long[] size);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Fills dataspace elements with a fill value in a memory buffer
 *
 * @param fill [in]          Pointer to the fill value to be used
 * @param fill_type_id [in]  Fill value datatype identifier
 * @param buf [in,out]       Pointer to the memory buffer containing the
 *                          selection to be filled
 * @param buf_type_id [in]   Datatype of dataspace elements to be filled
 * \space_id
 *
 * @return \herr_t
 *
 * \details H5Dfill() fills the dataspace selection, \p space_id, in memory
 *          with the fill value specified in \p fill. If \p fill is NULL,
 *          a fill value of 0 (zero) is used.
 *
 *          \p fill_type_id specifies the datatype of the fill value.
 *          \p buf specifies the buffer in which the fill elements
 *          will be written. \p buf_type_id specifies the datatype of
 *          those data elements.
 *
 * \note Note that if the fill value datatype differs from the memory
 *       buffer datatype, the fill value will be converted to the memory
 *       buffer datatype before filling the selection.
 *
 * \note Applications sometimes write data only to portions of an
 *       allocated dataset. It is often useful in such cases to fill
 *       the unused space with a known fill value.
 *
 * @see H5Pset_fill_value(), H5Pget_fill_value(), H5Pfill_value_defined(),
 *      H5Pset_fill_time(), H5Pget_fill_time(), H5Pcreate(), H5Dcreate_anon()
 *
 */
public static native @Cast("herr_t") int H5Dfill(@Const Pointer _fill, @Cast("hid_t") long fill_type_id, Pointer buf, @Cast("hid_t") long buf_type_id, @Cast("hid_t") long space_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Changes the sizes of a dataset’s dimensions
 *
 * \dset_id
 * @param size [in] []   Array containing the new magnitude of each dimension
 *                     of the dataset
 *
 * @return \herr_t
 *
 * \details H5Dset_extent() sets the current dimensions of the
 *          chunked dataset \p dset_id to the sizes specified in size.
 *
 *          \p size is a 1-dimensional array with n elements, where \p n is
 *          the rank of the dataset’s current dataspace.
 *
 *          This function can be applied to the following datasets:
 *          - A chunked dataset with unlimited dimensions
 *          - A chunked dataset with fixed dimensions if the new dimension
 *          sizes are less than the maximum sizes set with maxdims (see
 *          H5Screate_simple())
 *          - An external dataset with unlimited dimensions
 *          - An external dataset with fixed dimensions if the new dimension
 *          sizes are less than the maximum sizes set with \p maxdims
 *
 *          Note that external datasets are always contiguous and can be
 *          extended only along the first dimension.
 *
 *          Space on disk is immediately allocated for the new dataset extent if
 *          the dataset’s space allocation time is set to #H5D_ALLOC_TIME_EARLY.
 *
 *          Fill values will be written to the dataset in either of the
 *          following situations, but not otherwise:
 *
 *          - If the dataset’s fill time is set to #H5D_FILL_TIME_IFSET and a
 *            fill value is defined (see H5Pset_fill_time() and
 *            H5Pset_fill_value())
 *          - If the dataset’s fill time is set to #H5D_FILL_TIME_ALLOC
 *            (see H5Pset_alloc_time())
 *
 * \note If the sizes specified in \p size array are smaller than the dataset’s
 *       current dimension sizes, H5Dset_extent() will reduce the dataset’s
 *       dimension sizes to the specified values. It is the user application’s
 *       responsibility to ensure that valuable data is not lost as
 *       H5Dset_extent() does not check.
 *
 * \note Except for external datasets, H5Dset_extent() is for use with
 *       chunked datasets only, not contiguous datasets.
 *
 * \note A call to H5Dset_extent() affects the dataspace of a dataset.  If a
 *       dataspace handle was opened for a dataset prior to a call to
 *       H5Dset_extent() then that dataspace handle will no longer reflect the
 *       correct dataspace extent of the dataset. H5Dget_space() must be called
 *       (after closing the previous handle) to obtain the current dataspace
 *       extent.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Dset_extent(@Cast("hid_t") long dset_id, @Cast("const hsize_t*") long[] size);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Flushes all buffers associated with a dataset to disk
 *
 * \dset_id
 *
 * @return \herr_t
 *
 * \details H5Dflush() causes all buffers associated with a
 *          dataset to be immediately flushed to disk without removing
 *          the data from the cache.
 *
 *          \note HDF5 does not possess full control over buffering.
 *          H5Dflush() flushes the internal HDF5 buffers and then asks the
 *          operating system (the OS) to flush the system buffers for the
 *          open files. After that, the OS is responsible for ensuring
 *          that the data is actually flushed to disk.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Dflush(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Refreshes all buffers associated with a dataset
 *
 * \dset_id
 *
 * @return \herr_t
 *
 * \details H5Drefresh() causes all buffers associated with a
 *          dataset to be cleared and immediately re-loaded with updated
 *          contents from disk.
 *
 *          This function essentially closes the dataset, evicts all
 *          metadata associated with it from the cache, and then re-opens
 *          the dataset. The reopened dataset is automatically re-registered
 *          with the same identifier.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Drefresh(@Cast("hid_t") long dset_id);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Scatters data into a selection within a memory buffer
 *
 * @param op [in]       Callback function which provides data to be scattered
 * @param op_data [in]  User-defined pointer to data required by op
 * @param type_id [in]  Identifier for the datatype describing the data in
 *                      both the source and destination buffers
 * @param dst_space_id [in]    Identifier for the dataspace for destination
 * @param dst_buf [out]  Destination buffer which the data will be scattered to
 *
 * @return \herr_t
 *
 * \details H5Dscatter() retrieves data from the supplied callback
 *          \p op and scatters it to the supplied buffer \p dst_buf in a
 *          manner similar to data being written to a dataset.
 *
 *          \p dst_space_id is a dataspace which defines the extent of \p
 *          dst_buf and the selection within it to scatter the data to.
 *
 *          \p type_id is the datatype of the data to be scattered in both
 *          the source and destination buffers.
 *
 *          \p dst_buf must be at least as large as the number of elements
 *          in the extent of \p dst_space_id times the size in bytes of
 *          \p type_id.
 *
 *          To retrieve the data to be scattered, H5Dscatter() repeatedly
 *          calls \p op, which should return a valid source buffer, until
 *          enough data to fill the selection has been retrieved.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dscatter(H5D_scatter_func_t op, Pointer op_data, @Cast("hid_t") long type_id, @Cast("hid_t") long dst_space_id,
                         Pointer dst_buf);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Gathers data from a selection within a memory buffer
 * raw data chunk in a dataset
 *
 * @param src_space_id [in]  Dataspace identifier for the source buffer
 * @param src_buf [in]   Source buffer which the data will be gathered from
 * @param type_id [in]   Datatype identifier for the source
 * @param dst_buf_size [in]   Size in bytes of \p dst_buf
 * @param dst_buf [out]   Destination buffer for the gathered data
 * @param op [in]   Callback function which handles the gathered data
 * @param op_data [in]   User-defined pointer to data required by \p op
 *
 * @return \herr_t
 *
 * \details H5Dgather() retrieves data from a selection within the supplied
 *          buffer src_buf and passes it to the supplied callback function
 *          \p op in a contiguous form.
 *
 *          The dataspace \p src_space_id describes both the dimensions of
 *          the source buffer and the selection within the source buffer
 *          to gather data from.
 *
 *          \p src_buf must be at least the size of the gathered data, that
 *          is, the number of elements in the extent of \p src_space_id
 *          times the size in bytes of \p type_id.
 *
 *          The datatype \p type_id describes the data in both the source
 *          and destination buffers. This information is used to calculate
 *          the element size.
 *
 *          The data is gathered into \p dst_buf, which needs to be large
 *          enough to hold all the data if the callback function \p op is
 *          not provided.
 *
 *          \p op is a callback function which handles the gathered data.
 *          It is optional if \p dst_buf is large enough to hold all of the
 *          gathered data; required otherwise.
 *
 *          If no callback function is provided, H5Dgather() simply gathers
 *          the data into \p dst_buf and returns. If a callback function is
 *          provided, H5Dgather() repeatedly gathers up to \p dst_buf_size
 *          bytes to process the serialized data.
 *
 *          The callback function \p op should process, store, or otherwise,
 *          make use of the data returned in \p dst_buf before it returns,
 *          because the buffer will be overwritten unless it is the last
 *          call to the callback. This function will be repeatedly called
 *          until all gathered elements have been passed to the callback
 *          in \p dst_buf. The callback function should return zero (0)
 *          to indicate success, and a negative value to indicate failure.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Dgather(@Cast("hid_t") long src_space_id, @Const Pointer src_buf, @Cast("hid_t") long type_id, @Cast("size_t") long dst_buf_size,
                        Pointer dst_buf, H5D_gather_func_t op, Pointer op_data);

/**
 * --------------------------------------------------------------------------
 * \ingroup H5D
 *
 * \brief Closes the specified dataset
 *
 * \dset_id
 *
 * @return \herr_t
 *
 * \details H5Dclose() terminates access to a dataset via the identifier
 *          \p dset_id and releases the underlying resources.
 *
 * \par Example
 * \snippet H5D_examples.c read
 *
 * @since 1.8.0
 *
 * @see H5Dcreate2(), H5Dopen2()
 *
 */
public static native @Cast("herr_t") int H5Dclose(@Cast("hid_t") long dset_id);

/* Internal API routines */
public static native @Cast("herr_t") int H5Ddebug(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dformat_convert(@Cast("hid_t") long dset_id);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") IntPointer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") IntBuffer idx_type);
public static native @Cast("herr_t") int H5Dget_chunk_index_type(@Cast("hid_t") long did, @Cast("H5D_chunk_index_t*") int[] idx_type);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Dpublic_H */


// Parsed from H5Epublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5E module.
 */
// #ifndef H5Epublic_H
// #define H5Epublic_H

// #include <stdio.h> /*FILE arg of H5Eprint()                     */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5Ipublic.h"

/* Value for the default error stack */
public static native @MemberGetter int H5E_DEFAULT();
public static final int H5E_DEFAULT = H5E_DEFAULT(); /* (hid_t) */

/**
 * Different kinds of error information
 */
/** enum H5E_type_t */
public static final int H5E_MAJOR = 0, H5E_MINOR = 1;
// Targeting ..\H5E_error2_t.java



/* When this header is included from a private header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef H5private_H
// #define H5OPEN H5open(),
// #else /* H5private_H */
// #define H5OPEN
// #endif /* H5private_H */

/* HDF5 error class */
// #define H5E_ERR_CLS (H5OPEN H5E_ERR_CLS_g)


/* Include the automatically generated public header information */
/* (This includes the list of major and minor error codes for the library) */
// #include "H5Epubgen.h"

/*
 * One often needs to temporarily disable automatic error reporting when
 * trying something that's likely or expected to fail.  The code to try can
 * be nested between calls to H5Eget_auto() and H5Eset_auto(), but it's
 * easier just to use this macro like:
 *     H5E_BEGIN_TRY {
 *        ...stuff here that's likely to fail...
 *      } H5E_END_TRY;
 *
 * Warning: don't break, return, or longjmp() from the body of the loop or
 *        the error reporting won't be properly restored!
 *
 * These two macros still use the old API functions for backward compatibility
 * purpose.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #else /* H5_NO_DEPRECATED_SYMBOLS */
// #define H5E_BEGIN_TRY
//     {
//         H5E_auto2_t saved_efunc;
//         void *      H5E_saved_edata;
// 
//         (void)H5Eget_auto2(H5E_DEFAULT, &saved_efunc, &H5E_saved_edata);
//         (void)H5Eset_auto2(H5E_DEFAULT, NULL, NULL);

// #define H5E_END_TRY
//     (void)H5Eset_auto2(H5E_DEFAULT, saved_efunc, H5E_saved_edata);
//     }
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

/*
 * Public API Convenience Macros for Error reporting - Documented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
// #define H5Epush_sim(func, cls, maj, min, str)
//     H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str)

/*
 * Public API Convenience Macros for Error reporting - Undocumented
 */
/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in */
/*  And return after pushing error onto stack */
// #define H5Epush_ret(func, cls, maj, min, str, ret)
//     do {
//         H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//         return (ret);
//     } while (0)

/* Use the Standard C __FILE__ & __LINE__ macros instead of typing them in
 * And goto a label after pushing error onto stack.
 */
// #define H5Epush_goto(func, cls, maj, min, str, label)
//     {
//         H5Epush2(H5E_DEFAULT, __FILE__, func, __LINE__, cls, maj, min, str);
//         goto label;
//     }

/**
 * Error stack traversal direction
 */
/** enum H5E_direction_t */
public static final int
    /** begin w/ most specific error, end at API function */
    H5E_WALK_UPWARD   = 0,
    /** begin at API function, end w/ most specific error */
    H5E_WALK_DOWNWARD = 1;

// #ifdef __cplusplus
// Targeting ..\H5E_walk2_t.java


// Targeting ..\H5E_auto2_t.java


/** <!-- [H5E_auto2_t_snip] --> */

/* Public API functions */
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Registers a client library or application program to the HDF5 error API
 *
 * @param cls_name [in] Name of the error class
 * @param lib_name [in] Name of the client library or application to which the error class belongs
 * @param version [in] Version of the client library or application to which the
              error class belongs. Can be \c NULL.
 * @return Returns a class identifier on success; otherwise returns H5I_INVALID_ID.
 *
 * \details H5Eregister_class() registers a client library or application
 *          program to the HDF5 error API so that the client library or
 *          application program can report errors together with the HDF5
 *          library. It receives an identifier for this error class for further
 *          error operations. The library name and version number will be
 *          printed out in the error message as a preamble.
 *
 * @since 1.8.0
 */
public static native @Cast("hid_t") long H5Eregister_class(@Cast("const char*") BytePointer cls_name, @Cast("const char*") BytePointer lib_name, @Cast("const char*") BytePointer version);
public static native @Cast("hid_t") long H5Eregister_class(String cls_name, String lib_name, String version);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Removes an error class
 *
 * @param class_id [in] Error class identifier.
 * @return \herr_t
 *
 * \details H5Eunregister_class() removes the error class specified by \p
 *          class_id. All the major and minor errors in this class will also be
 *          closed.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eunregister_class(@Cast("hid_t") long class_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Closes an error message
 *
 * @param err_id [in] An error message identifier
 * @return \herr_t
 *
 * \details H5Eclose_msg() closes an error message identifier, which can be
 *          either a major or minor message.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eclose_msg(@Cast("hid_t") long err_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Adds a major error message to an error class
 *
 * @param cls [in] An error class identifier
 * @param msg_type [in] The type of the error message
 * @param msg [in] Major error message
 * @return \herr_t
 *
 * \details H5Ecreate_msg() adds an error message to an error class defined by
 *          client library or application program. The error message can be
 *          either major or minor as indicated by the parameter \p msg_type.
 *
 *          Use H5Eclose_msg() to close the message identifier returned by this
 *          function.
 *
 * @since 1.8.0
 */
public static native @Cast("hid_t") long H5Ecreate_msg(@Cast("hid_t") long cls, @Cast("H5E_type_t") int msg_type, @Cast("const char*") BytePointer msg);
public static native @Cast("hid_t") long H5Ecreate_msg(@Cast("hid_t") long cls, @Cast("H5E_type_t") int msg_type, String msg);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Creates a new, empty error stack
 *
 * @return \hid_ti{error stack}
 *
 * \details H5Ecreate_stack() creates a new empty error stack and returns the
 *          new stack’s identifier. Use H5Eclose_stack() to close the error stack
 *          identifier returned by this function.
 *
 * @since 1.8.0
 */
public static native @Cast("hid_t") long H5Ecreate_stack();
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Returns a copy of the current error stack
 *
 * @return \hid_ti{error stack}
 *
 * \details H5Eget_current_stack() copies the current error stack and returns an
 *          error stack identifier for the new copy.
 *
 * @since 1.8.0
 */
public static native @Cast("hid_t") long H5Eget_current_stack();
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Appends one error stack to another, optionally closing the source
 *        stack.
 *
 * \estack_id{dst_stack_id}
 * \estack_id{src_stack_id}
 * @param close_source_stack [in] Flag to indicate whether to close the source stack
 * @return \herr_t
 *
 * \details H5Eappend_stack() appends the messages from error stack
 *          \p src_stack_id to the error stack \p dst_stack_id.
 *          If \p close_source_stack is \c TRUE, the source error stack
 *          will be closed.
 *
 * @since 1.13.0
 */

/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Closes an error stack handle
 *
 * \estack_id{stack_id}
 *
 * @return \herr_t
 *
 * \details H5Eclose_stack() closes the error stack handle \p stack_id
 *          and releases its resources. #H5E_DEFAULT cannot be closed.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eclose_stack(@Cast("hid_t") long stack_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Retrieves error class name
 *
 * @param class_id [in] Error class identifier
 * @param name [out] Buffer for the error class name
 * @param size [in] The maximum number of characters the class name to be returned
 *            by this function in\p name.
 * @return Returns non-negative value as on success; otherwise returns negative value.
 *
 * \details H5Eget_class_name() retrieves the name of the error class specified
 *          by the class identifier. If non-NULL pointer is passed in for \p
 *          name and \p size is greater than zero, the class name of \p size
 *          long is returned. The length of the error class name is also
 *          returned. If NULL is passed in as \p name, only the length of class
 *          name is returned. If zero is returned, it means no name. The user is
 *          responsible for allocating sufficient buffer space for the name.
 *
 * @since 1.8.0
 */
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_class_name(@Cast("hid_t") long class_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Replaces the current error stack
 *
 * \estack_id{err_stack_id}
 *
 * @return \herr_t
 *
 * \details H5Eset_current_stack() replaces the content of the current error
 *          stack with a copy of the content of the error stack specified by
 *          \p err_stack_id, and it closes the error stack specified by
 *          \p err_stack_id.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eset_current_stack(@Cast("hid_t") long err_stack_id);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Pushes a new error record onto an error stack
 *
 * \estack_id{err_stack}. If the identifier is #H5E_DEFAULT, the error record
 *                        will be pushed to the current stack.
 * @param file [in] Name of the file in which the error was detected
 * @param func [in] Name of the function in which the error was detected
 * @param line [in] Line number in the file where the error was detected
 * @param cls_id [in] Error class identifier
 * @param maj_id [in] Major error identifier
 * @param min_id [in] Minor error identifier
 * @param msg [in] Error description string
 * @return \herr_t
 *
 * \details H5Epush2() pushes a new error record onto the error stack specified
 *          by \p err_stack.\n
 *          The error record contains the error class identifier \p cls_id, the
 *          major and minor message identifiers \p maj_id and \p min_id, the
 *          function name \p func where the error was detected, the file name \p
 *          file and line number \p line in the file where the error was
 *          detected, and an error description \p msg.\n
 *          The major and minor errors must be in the same error class.\n
 *          The function name, filename, and error description strings must be
 *          statically allocated.\n
 *          \p msg can be a format control string with additional
 *          arguments. This design of appending additional arguments is similar
 *          to the system and C functions printf() and fprintf().
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") long err_stack, @Cast("const char*") BytePointer file, @Cast("const char*") BytePointer func, @Cast("unsigned") int line, @Cast("hid_t") long cls_id,
                       @Cast("hid_t") long maj_id, @Cast("hid_t") long min_id, @Cast("const char*") BytePointer msg);
public static native @Cast("herr_t") int H5Epush2(@Cast("hid_t") long err_stack, String file, String func, @Cast("unsigned") int line, @Cast("hid_t") long cls_id,
                       @Cast("hid_t") long maj_id, @Cast("hid_t") long min_id, String msg);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Deletes specified number of error messages from the error stack
 *
 * \estack_id{err_stack}
 * @param count [in] The number of error messages to be deleted from the top
 *                  of error stack
 * @return \herr_t
 *
 * \details H5Epop() deletes the number of error records specified in \p count
 *          from the top of the error stack specified by \p err_stack (including
 *          major, minor messages and description). The number of error messages
 *          to be deleted is specified by \p count.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Epop(@Cast("hid_t") long err_stack, @Cast("size_t") long count);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Prints the specified error stack in a default manner
 *
 * \estack_id{err_stack}
 * @param stream [in] File pointer, or \c NULL for \c stderr
 * @return \herr_t
 *
 * \details H5Eprint2() prints the error stack specified by \p err_stack on the
 *          specified stream, \p stream. Even if the error stack is empty, a
 *          one-line message of the following form will be printed:
 *          <pre>{@code {.unparsed}
 *          HDF5-DIAG: Error detected in HDF5 library version: 1.5.62 thread 0.
 *          }</pre>
 *
 *          A similar line will appear before the error messages of each error
 *          class stating the library name, library version number, and thread
 *          identifier.
 *
 *          If \p err_stack is #H5E_DEFAULT, the current error stack will be
 *          printed.
 *
 *          H5Eprint2() is a convenience function for H5Ewalk2() with a function
 *          that prints error messages. Users are encouraged to write their own
 *          more specific error handlers.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eprint2(@Cast("hid_t") long err_stack, @Cast("FILE*") Pointer stream);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Walks the specified error stack, calling the specified function
 *
 * \estack_id{err_stack}
 * @param direction [in] Direction in which the error stack is to be walked
 * @param func [in] Function to be called for each error encountered
 * @param client_data [in] Data to be passed to \p func
 * @return \herr_t
 *
 * \details H5Ewalk2() walks the error stack specified by err_stack for the
 *          current thread and calls the function specified in \p func for each
 *          error along the way.
 *
 *          If the value of \p err_stack is #H5E_DEFAULT, then H5Ewalk2() walks
 *          the current error stack.
 *
 *          \p direction specifies whether the stack is walked from the inside
 *          out or the outside in. A value of #H5E_WALK_UPWARD means to begin
 *          with the most specific error and end at the API; a value of
 *          #H5E_WALK_DOWNWARD means to start at the API and end at the
 *          innermost function where the error was first detected.
 *
 *          \p func, a function conforming to the #H5E_walk2_t prototype, will
 *          be called for each error in the error stack. Its arguments will
 *          include an index number \c n (beginning at zero regardless of stack
 *          traversal direction), an error stack entry \c err_desc, and the \c
 *          client_data pointer passed to H5Eprint(). The #H5E_walk2_t prototype
 *          is as follows:
 *          \snippet this H5E_walk2_t_snip
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Ewalk2(@Cast("hid_t") long err_stack, @Cast("H5E_direction_t") int direction, H5E_walk2_t func, Pointer client_data);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Returns the settings for the automatic error stack traversal
 *        function and its data
 *
 * \estack_id
 * @param func [out] The function currently set to be called upon an error condition
 * @param client_data [out] Data currently set to be passed to the error function
 * @return \herr_t
 *
 * \details H5Eget_auto2() returns the settings for the automatic error stack
 *          traversal function, \p func, and its data, \p client_data, that are
 *          associated with the error stack specified by \p estack_id.
 *
 *          Either or both of the \p func and \p client_data arguments may be
 *          \c NULL, in which case the value is not returned.
 *
 *          The library initializes its default error stack traversal functions
 *          to H5Eprint1() and H5Eprint2(). A call to H5Eget_auto2() returns
 *          H5Eprint2() or the user-defined function passed in through
 *          H5Eset_auto2(). A call to H5Eget_auto1() returns H5Eprint1() or the
 *          user-defined function passed in through H5Eset_auto1(). However, if
 *          the application passes in a user-defined function through
 *          H5Eset_auto1(), it should call H5Eget_auto1() to query the traversal
 *          function. If the application passes in a user-defined function
 *          through H5Eset_auto2(), it should call H5Eget_auto2() to query the
 *          traversal function.
 *
 *          Mixing the new style and the old style functions will cause a
 *          failure. For example, if the application sets a user-defined
 *          old-style traversal function through H5Eset_auto1(), a call to
 *          H5Eget_auto2() will fail and will indicate that the application has
 *          mixed H5Eset_auto1() and H5Eget_auto2(). On the other hand, mixing
 *          H5Eset_auto2() and H5Eget_auto1() will also cause a failure. But if
 *          the traversal functions are the library’s default H5Eprint1() or
 *          H5Eprint2(), mixing H5Eset_auto1() and H5Eget_auto2() or mixing
 *          H5Eset_auto2() and H5Eget_auto1() does not fail.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") long estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") PointerPointer client_data);
public static native @Cast("herr_t") int H5Eget_auto2(@Cast("hid_t") long estack_id, @ByPtrPtr H5E_auto2_t func, @Cast("void**") @ByPtrPtr Pointer client_data);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Turns automatic error printing on or off
 *
 * \estack_id
 * @param func [in] Function to be called upon an error condition
 * @param client_data [in] Data passed to the error function
 * @return \herr_t
 *
 * \details H5Eset_auto2() turns on or off automatic printing of errors for the
 *          error stack specified with \p estack_id. An \p estack_id value of
 *          #H5E_DEFAULT indicates the current stack.
 *
 *          When automatic printing is turned on, by the use of a non-null \p func
 *          pointer, any API function which returns an error indication will
 *          first call \p func, passing it \p client_data as an argument.
 *
 *          \p func, a function compliant with the #H5E_auto2_t prototype, is
 *          defined in the H5Epublic.h source code file as:
 *          \snippet this H5E_auto2_t_snip
 *
 *          When the library is first initialized, the auto printing function is
 *          set to H5Eprint2() (cast appropriately) and \p client_data is the
 *          standard error stream pointer, \c stderr.
 *
 *          Automatic stack traversal is always in the #H5E_WALK_DOWNWARD
 *          direction.
 *
 *          Automatic error printing is turned off with a H5Eset_auto2() call
 *          with a \c NULL \p func pointer.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eset_auto2(@Cast("hid_t") long estack_id, H5E_auto2_t func, Pointer client_data);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Clears the specified error stack or the error stack for the current thread
 *
 * \estack_id{err_stack}
 * @return \herr_t
 *
 * \details H5Eclear2() clears the error stack specified by \p err_stack, or, if
 *          \p err_stack is set to #H5E_DEFAULT, the error stack for the current
 *          thread.
 *
 *          \p err_stack is an error stack identifier, such as that returned by
 *          H5Eget_current_stack().
 *
 *          The current error stack is also cleared whenever an API function is
 *          called, with certain exceptions (for instance, H5Eprint1() or
 *          H5Eprint2()).
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eclear2(@Cast("hid_t") long err_stack);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Determines the type of error stack
 *
 * \estack_id{err_stack}
 * @param is_stack [out] A flag indicating which error stack \c typedef the
 *                      specified error stack conforms to
 *
 * @return \herr_t
 *
 * \details H5Eauto_is_v2() determines whether the error auto reporting function
 *          for an error stack conforms to the #H5E_auto2_t \c typedef or the
 *          #H5E_auto1_t \c typedef.
 *
 *          The \p is_stack parameter is set to 1 if the error stack conforms to
 *          #H5E_auto2_t and 0 if it conforms to #H5E_auto1_t.
 *
 * @since 1.8.0
 */
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") IntPointer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") IntBuffer is_stack);
public static native @Cast("herr_t") int H5Eauto_is_v2(@Cast("hid_t") long err_stack, @Cast("unsigned*") int[] is_stack);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Retrieves an error message
 *
 * @param msg_id [in] Error message identifier
 * @param type [out] The type of the error message Valid values are #H5E_MAJOR
 *                  and #H5E_MINOR.
 * @param msg [out] Error message buffer
 * @param size [in] The length of error message to be returned by this function
 * @return Returns the size of the error message in bytes on success; otherwise
 *         returns a negative value.
 *
 * \details H5Eget_msg() retrieves the error message including its length and
 *          type. The error message is specified by \p msg_id. The user is
 *          responsible for passing in sufficient buffer space for the
 *          message. If \p msg is not NULL and \p size is greater than zero, the
 *          error message of \p size long is returned. The length of the message
 *          is also returned. If NULL is passed in as \p msg, only the length
 *          and type of the message is returned. If the return value is zero, it
 *          means there is no message.
 *
 * @since 1.8.0
 */
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") IntPointer type, @Cast("char*") BytePointer msg, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") IntBuffer type, @Cast("char*") ByteBuffer msg, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Eget_msg(@Cast("hid_t") long msg_id, @Cast("H5E_type_t*") int[] type, @Cast("char*") byte[] msg, @Cast("size_t") long size);
/**
 * --------------------------------------------------------------------------
 * \ingroup H5E
 *
 * \brief Retrieves the number of error messages in an error stack
 *
 * \estack_id{error_stack_id}
 * @return Returns a non-negative value on success; otherwise returns a negative value.
 *
 * \details H5Eget_num() retrieves the number of error records in the error
 *          stack specified by \p error_stack_id (including major, minor
 *          messages and description).
 *
 * @since 1.8.0
 */
public static native @Cast("ssize_t") long H5Eget_num(@Cast("hid_t") long error_stack_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS
// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif

// #endif /* end H5Epublic_H */


// Parsed from H5Fpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains public declarations for the H5F module.
 */
// #ifndef H5Fpublic_H
// #define H5Fpublic_H

/* Public header files needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h"
// #include "H5Ipublic.h"

/* When this header is included from a private header, don't make calls to H5check() */
// #undef H5CHECK
// #ifndef H5private_H
// #define H5CHECK H5check(),
// #else /* H5private_H */
// #define H5CHECK
// #endif /* H5private_H */

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef H5private_H
// #define H5OPEN H5open(),
// #else /* H5private_H */
// #define H5OPEN
// #endif /* H5private_H */

/*
 * These are the bits that can be passed to the `flags' argument of
 * H5Fcreate() and H5Fopen(). Use the bit-wise OR operator (|) to combine
 * them as needed.  As a side effect, they call H5check_version() to make sure
 * that the application is compiled with a version of the hdf5 header files
 * which are compatible with the library to which the application is linked.
 * We're assuming that these constants are used rather early in the hdf5
 * session.
 */
/** Absence of RDWR: read-only */
public static native @MemberGetter int H5F_ACC_RDONLY();
public static final int H5F_ACC_RDONLY = H5F_ACC_RDONLY();
/** Open for read and write    */
public static native @MemberGetter int H5F_ACC_RDWR();
public static final int H5F_ACC_RDWR = H5F_ACC_RDWR();
/** Overwrite existing files   */
public static native @MemberGetter int H5F_ACC_TRUNC();
public static final int H5F_ACC_TRUNC = H5F_ACC_TRUNC();
/** Fail if file already exists*/
public static native @MemberGetter int H5F_ACC_EXCL();
public static final int H5F_ACC_EXCL = H5F_ACC_EXCL();
/* NOTE: 0x0008u was H5F_ACC_DEBUG, now deprecated */
/** Create non-existing files  */
public static native @MemberGetter int H5F_ACC_CREAT();
public static final int H5F_ACC_CREAT = H5F_ACC_CREAT();
/** Indicate that this file is open for writing in a                                  \
                       *   single-writer/multi-reader (SWMR)  scenario.                                      \
                       *   Note that the process(es) opening the file for reading                            \
                       *   must open the file with #H5F_ACC_RDONLY and use the                               \
                       *   #H5F_ACC_SWMR_READ access flag. */
public static native @MemberGetter int H5F_ACC_SWMR_WRITE();
public static final int H5F_ACC_SWMR_WRITE = H5F_ACC_SWMR_WRITE();
/** Indicate that this file is open for reading in a                                  \
                       * single-writer/multi-reader (SWMR) scenario. Note that                               \
                       * the process(es) opening the file for SWMR reading must                              \
                       * also open the file with the #H5F_ACC_RDONLY flag.  */
public static native @MemberGetter int H5F_ACC_SWMR_READ();
public static final int H5F_ACC_SWMR_READ = H5F_ACC_SWMR_READ();

/**
 * Default property list identifier
 *
 * \internal Value passed to H5Pset_elink_acc_flags to cause flags to be taken from the parent file.
 * \internal ignore setting on lapl
 */
public static native @MemberGetter int H5F_ACC_DEFAULT();
public static final int H5F_ACC_DEFAULT = H5F_ACC_DEFAULT();

/* Flags for H5Fget_obj_count() & H5Fget_obj_ids() calls */
/** File objects */
public static final int H5F_OBJ_FILE =     (0x0001);
/** Dataset objects */
public static final int H5F_OBJ_DATASET =  (0x0002);
/** Group objects */
public static final int H5F_OBJ_GROUP =    (0x0004);
/** Named datatype objects */
public static final int H5F_OBJ_DATATYPE = (0x0008);
/** Attribute objects */
public static final int H5F_OBJ_ATTR =     (0x0010);
public static final int H5F_OBJ_ALL =      (H5F_OBJ_FILE | H5F_OBJ_DATASET | H5F_OBJ_GROUP | H5F_OBJ_DATATYPE | H5F_OBJ_ATTR);
/** Restrict search to objects opened through current file ID                                 \
                   (as opposed to objects opened through any file ID accessing this file) */
public static final int H5F_OBJ_LOCAL =                                                                                        
    (0x0020);

public static native @MemberGetter int H5F_FAMILY_DEFAULT();
public static final int H5F_FAMILY_DEFAULT = H5F_FAMILY_DEFAULT(); /* (hsize_t) */

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/**
 * The scope of an operation such as H5Fflush(), e.g.,
 * a single file vs. a set of mounted files
 */
/** enum H5F_scope_t */
public static final int
    /** The specified file handle only */
    H5F_SCOPE_LOCAL  = 0,
    /** The entire virtual file        */
    H5F_SCOPE_GLOBAL = 1;

/**
 * Unlimited file size for H5Pset_external()
 */
public static native @MemberGetter long H5F_UNLIMITED();
public static final long H5F_UNLIMITED = H5F_UNLIMITED();

/**
 * How does file close behave?
 */
/** enum H5F_close_degree_t */
public static final int
    /** Use the degree pre-defined by underlying VFD */
    H5F_CLOSE_DEFAULT = 0,
    /** File closes only after all opened objects are closed */
    H5F_CLOSE_WEAK    = 1,
    /** If no opened objects, file is closed; otherwise, file close fails */
    H5F_CLOSE_SEMI    = 2,
    /** If there are opened objects, close them first, then close file */
    H5F_CLOSE_STRONG  = 3;
// Targeting ..\H5F_info2_t.java


/** <!-- [H5F_info2_t_snip] -->
<p>
/**
 * Types of allocation requests. The values larger than #H5FD_MEM_DEFAULT
 * should not change other than adding new types to the end. These numbers
 * might appear in files.
 *
 * \internal Please change the log VFD flavors array if you change this
 *           enumeration.
 */
/** enum H5F_mem_t */
public static final int
    /** Data should not appear in the free list.
                           * Must be negative.
                           */
    H5FD_MEM_NOLIST = -1,
    /** Value not yet set.  Can also be the
                           * datatype set in a larger allocation
                           * that will be suballocated by the library.
                           * Must be zero.
                           */
    H5FD_MEM_DEFAULT = 0,
    /** Superblock data */
    H5FD_MEM_SUPER = 1,
    /** B-tree data */
    H5FD_MEM_BTREE = 2,
    /** Raw data (content of datasets, etc.) */
    H5FD_MEM_DRAW  = 3,
    /** Global heap data */
    H5FD_MEM_GHEAP = 4,
    /** Local heap data */
    H5FD_MEM_LHEAP = 5,
    /** Object header data */
    H5FD_MEM_OHDR  = 6,

    /** Sentinel value - must be last */
    H5FD_MEM_NTYPES = 7;
// Targeting ..\H5F_sect_info_t.java


/** <!-- [H5F_sect_info_t_snip] -->
<p>
/**
 * Library's format versions
 */
/** enum H5F_libver_t */
public static final int
    H5F_LIBVER_ERROR    = -1,
    /** Use the earliest possible format for storing objects */
    H5F_LIBVER_EARLIEST = 0,
    /** Use the latest v18 format for storing objects */
    H5F_LIBVER_V18      = 1,
    /** Use the latest v110 format for storing objects */
    H5F_LIBVER_V110     = 2,
    /** Use the latest v112 format for storing objects */
    H5F_LIBVER_V112     = 3,
    /** Sentinel */
    H5F_LIBVER_NBOUNDS = 4;

public static final int H5F_LIBVER_LATEST = H5F_LIBVER_V112;

/**
 * File space handling strategy
 */
/** <!-- [H5F_fspace_strategy_t_snip] --> */
/** enum H5F_fspace_strategy_t */
public static final int
    /** Mechanisms: free-space managers, aggregators, and virtual file
                                         drivers This is the library default when not set */
    H5F_FSPACE_STRATEGY_FSM_AGGR = 0,
    /** Mechanisms: free-space managers with embedded paged aggregation and virtual file drivers */
    H5F_FSPACE_STRATEGY_PAGE = 1,
    /** Mechanisms: aggregators and virtual file drivers */
    H5F_FSPACE_STRATEGY_AGGR = 2,
    /** Mechanisms: virtual file drivers */
    H5F_FSPACE_STRATEGY_NONE = 3,
    /** Sentinel */
    H5F_FSPACE_STRATEGY_NTYPES = 4;
/** <!-- [H5F_fspace_strategy_t_snip] -->
<p>
/**
 * File space handling strategy for release 1.10.0
 *
 * @deprecated 1.10.1
 */
/** enum H5F_file_space_type_t */
public static final int
    /** Default (or current) free space strategy setting */
    H5F_FILE_SPACE_DEFAULT     = 0,
    /** Persistent free space managers, aggregators, virtual file driver */
    H5F_FILE_SPACE_ALL_PERSIST = 1,
    /** Non-persistent free space managers, aggregators, virtual file driver
                                         This is the library default */
    H5F_FILE_SPACE_ALL         = 2,
    /** Aggregators, Virtual file driver */
    H5F_FILE_SPACE_AGGR_VFD = 3,
    /** Virtual file driver */
    H5F_FILE_SPACE_VFD      = 4,
    /** Sentinel */
    H5F_FILE_SPACE_NTYPES = 5;

/** <!-- [H5F_retry_info_t_snip] --> */
public static final int H5F_NUM_METADATA_READ_RETRY_TYPES = 21;
// Targeting ..\H5F_retry_info_t.java


// Targeting ..\H5F_flush_cb_t.java



/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus
// #endif

/**
 * \ingroup H5F
 *
 * \brief Checks if a file can be opened with a given file access property
 *        list
 *
 * @param container_name [in] Name of a file
 * \fapl_id
 *
 * @return \htri_t
 *
 * \details H5Fis_accessible() checks if the file specified by \p
 *          container_name can be opened with the file access property list
 *          \p fapl_id.
 *
 * \note The H5Fis_accessible() function enables files to be checked with a
 *       given file access property list, unlike H5Fis_hdf5(), which only uses
 *       the default file driver when opening a file.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("htri_t") int H5Fis_accessible(@Cast("const char*") BytePointer container_name, @Cast("hid_t") long fapl_id);
public static native @Cast("htri_t") int H5Fis_accessible(String container_name, @Cast("hid_t") long fapl_id);
/**
 * \ingroup H5F
 *
 * \brief Creates an HDF5 file
 *
 * @param filename [in] Name of the file to create
 * @param flags [in]    File access flags. Allowable values are:
 *                     - #H5F_ACC_TRUNC: Truncate file, if it already exists,
 *                       erasing all data previously stored in the file
 *                     - #H5F_ACC_EXCL: Fail if file already exists
 * \fcpl_id
 * \fapl_id
 * @return \hid_t{file}
 *
 * \details H5Fcreate() is the primary function for creating HDF5 files; it
 *          creates a new HDF5 file with the specified name and property lists.
 *
 *          The \p filename parameter specifies the name of the new file.
 *
 *          The \p flags parameter specifies whether an existing file is to be
 *          overwritten. It should be set to either #H5F_ACC_TRUNC to overwrite
 *          an existing file or #H5F_ACC_EXCL, instructing the function to fail
 *          if the file already exists.
 *
 *          New files are always created in read-write mode, so the read-write
 *          and read-only flags, #H5F_ACC_RDWR and #H5F_ACC_RDONLY,
 *          respectively, are not relevant in this function. Further note that
 *          a specification of #H5F_ACC_RDONLY will be ignored; the file will
 *          be created in read-write mode, regardless.
 *
 *          More complex behaviors of file creation and access are controlled
 *          through the file creation and file access property lists,
 *          \p fcpl_id and \p fapl_id, respectively. The value of #H5P_DEFAULT
 *          for any property list value indicates that the library should use
 *          the default values for that appropriate property list.
 *
 *          The return value is a file identifier for the newly-created file;
 *          this file identifier should be closed by calling H5Fclose() when
 *          it is no longer needed.
 *
 * \par Example
 * \snippet H5F_examples.c minimal
 *
 * \note  #H5F_ACC_TRUNC and #H5F_ACC_EXCL are mutually exclusive; use
 *        exactly one.
 *
 * \note An additional flag, #H5F_ACC_DEBUG, prints debug information. This
 *       flag can be combined with one of the above values using the bit-wise
 *       OR operator (\c |), but it is used only by HDF5 library developers;
 *       \Emph{it is neither tested nor supported for use in applications}.
 *
 * \attention \Bold{Special case — File creation in the case of an already-open file:}
 *            If a file being created is already opened, by either a previous
 *            H5Fopen() or H5Fcreate() call, the HDF5 library may or may not
 *            detect that the open file and the new file are the same physical
 *            file. (See H5Fopen() regarding the limitations in detecting the
 *            re-opening of an already-open file.)\n
 *            If the library detects that the file is already opened,
 *            H5Fcreate() will return a failure, regardless of the use of
 *            #H5F_ACC_TRUNC.\n
 *            If the library does not detect that the file is already opened
 *            and #H5F_ACC_TRUNC is not used, H5Fcreate() will return a failure
 *            because the file already exists. Note that this is correct
 *            behavior.\n
 *            But if the library does not detect that the file is already
 *            opened and #H5F_ACC_TRUNC is used, H5Fcreate() will truncate the
 *            existing file and return a valid file identifier. Such a
 *            truncation of a currently-opened file will almost certainly
 *            result in errors. While unlikely, the HDF5 library may not be
 *            able to detect, and thus report, such errors.\n
 *            Applications should avoid calling H5Fcreate() with an already
 *            opened file.
 *
 * @since 1.0.0
 *
 * @see H5Fopen(), H5Fclose()
 *
 */
public static native @Cast("hid_t") long H5Fcreate(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags, @Cast("hid_t") long fcpl_id, @Cast("hid_t") long fapl_id);
public static native @Cast("hid_t") long H5Fcreate(String filename, @Cast("unsigned") int flags, @Cast("hid_t") long fcpl_id, @Cast("hid_t") long fapl_id);
/**
 * \ingroup H5F
 *
 * \brief Opens an existing HDF5 file
 *
 * @param filename [in] Name of the file to be opened
 * @param flags [in]    File access flags. Allowable values are:
 *                     - #H5F_ACC_RDWR: Allows read and write access to file
 *                     - #H5F_ACC_RDONLY: Allows read-only access to file
 *                     - #H5F_ACC_RDWR \c | #H5F_ACC_SWMR_WRITE: Indicates that
 *                       the file is open for writing in a
 *                       single-writer/multi-writer (SWMR) scenario.
 *                     - #H5F_ACC_RDONLY \c | #H5F_ACC_SWMR_READ:  Indicates
 *                       that the file is open for reading in a
 *                       single-writer/multi-reader (SWMR) scenario.
 *                     - An additional flag, #H5F_ACC_DEBUG, prints debug
 *                       information. This flag can be combined with one of the
 *                       above values using the bit-wise OR operator (\c |), but
 *                       it is used only by HDF5 library developers;
 *                       \Emph{it is neither tested nor supported} for use in
 *                       applications.
 * \fapl_id
 * @return \hid_t{file}
 *
 * \details H5Fopen() is the primary function for accessing existing HDF5 files.
 *          This function opens the named file in the specified access mode and
 *          with the specified access property list.
 *
 *          Note that H5Fopen() does not create a file if it does not already
 *          exist; see H5Fcreate().
 *
 *          The \p filename parameter specifies the name of the file to be
 *          opened.
 *
 *          The \p fapl_id parameter specifies the file access property list.
 *          Use of #H5P_DEFAULT specifies that default I/O access properties
 *          are to be used.
 *
 *          The \p flags parameter specifies whether the file will be opened in
 *          read-write or read-only mode, #H5F_ACC_RDWR or #H5F_ACC_RDONLY,
 *          respectively. More complex behaviors of file access are controlled
 *          through the file-access property list.
 *
 *          The return value is a file identifier for the open file; this file
 *          identifier should be closed by calling H5Fclose() when it is no
 *          longer needed.
 *
 * \par Example
 * \snippet H5F_examples.c open
 *
 * \note  #H5F_ACC_RDWR and #H5F_ACC_RDONLY are mutually exclusive; use
 *        exactly one.
 *
 * \attention \Bold{Special cases — Multiple opens:} A file can often be opened
 *            with a new H5Fopen() call without closing an already-open
 *            identifier established in a previous H5Fopen() or H5Fcreate()
 *            call. Each such H5Fopen() call will return a unique identifier
 *            and the file can be accessed through any of these identifiers as
 *            long as the identifier remains valid. In such multiply-opened
 *            cases, the open calls must use the same flags argument and the
 *            file access property lists must use the same file close degree
 *            property setting (see the external link discussion below and
 *            H5Pset_fclose_degree()).\n
 *            In some cases, such as files on a local Unix file system, the
 *            HDF5 library can detect that a file is multiply opened and will
 *            maintain coherent access among the file identifiers.\n
 *            But in many other cases, such as parallel file systems or
 *            networked file systems, it is not always possible to detect
 *            multiple opens of the same physical file. In such cases, HDF5
 *            will treat the file identifiers as though they are accessing
 *            different files and will be unable to maintain coherent access.
 *            Errors are likely to result in these cases. While unlikely, the
 *            HDF5 library may not be able to detect, and thus report,
 *            such errors.\n
 *            It is generally recommended that applications avoid multiple
 *            opens of the same file.
 *
 * \attention \Bold{Special restriction on multiple opens of a file first
 *            opened by means of an external link:} When an external link is
 *            followed, the external file is always opened with the weak file
 *            close degree property setting, #H5F_CLOSE_WEAK (see
 *            H5Lcreate_external() and H5Pset_fclose_degree()). If the file is
 *            reopened with H5Fopen while it remains held open from such an
 *            external link call, the file access property list used in the
 *            open call must include the file close degree setting
 *            #H5F_CLOSE_WEAK or the open will fail.
 *
 * @version 1.10.0 The #H5F_ACC_SWMR_WRITE and #H5F_ACC_SWMR_READ flags were added.
 *
 * @see H5Fclose()
 *
 */
public static native @Cast("hid_t") long H5Fopen(@Cast("const char*") BytePointer filename, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id);
public static native @Cast("hid_t") long H5Fopen(String filename, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id);
/**
 * \ingroup H5F
 *
 * \brief Returns a new identifier for a previously-opened HDF5 file
 *
 * @param file_id [in] Identifier of a file for which an additional identifier
 *                    is required
 *
 * @return \hid_t{file}
 *
 * \details H5Freopen() returns a new file identifier for an already-open HDF5
 *          file, as specified by \p file_id. Both identifiers share caches and
 *          other information. The only difference between the identifiers is
 *          that the new identifier is not mounted anywhere and no files are
 *          mounted on it.
 *
 *          The new file identifier should be closed by calling H5Fclose() when
 *          it is no longer needed.
 *
 * \note Note that there is no circumstance under which H5Freopen() can
 *       actually open a closed file; the file must already be open and have an
 *       active \p file_id. E.g., one cannot close a file with H5Fclose() on
 *       \p file_id then use H5Freopen() on \p file_id to reopen it.
 *
 */
public static native @Cast("hid_t") long H5Freopen(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Flushes all buffers associated with a file to storage
 *
 * \loc_id{object_id}
 * @param scope [in] The scope of the flush action
 *
 * @return \herr_t
 *
 * \details H5Fflush() causes all buffers associated with a file to be
 *          immediately flushed to storage without removing the data from the
 *          cache.
 *
 *          \p object_id can be any object associated with the file, including
 *          the file itself, a dataset, a group, an attribute, or a named
 *          datatype.
 *
 *          \p scope specifies whether the scope of the flush action is
 *          global or local. Valid values are as follows:
 *          \scopes
 *
 * \par Example
 * \snippet H5F_examples.c flush
 *
 * \attention HDF5 does not possess full control over buffering. H5Fflush()
 *            flushes the internal HDF5 buffers then asks the operating system
 *            (the OS) to flush the system buffers for the open files. After
 *            that, the OS is responsible for ensuring that the data is
 *            actually flushed to disk.
 *
 */
public static native @Cast("herr_t") int H5Fflush(@Cast("hid_t") long object_id, @Cast("H5F_scope_t") int scope);
/**
 * \ingroup H5F
 *
 * \brief Terminates access to an HDF5 file
 *
 * \file_id
 * @return \herr_t
 *
 * \details H5Fclose() terminates access to an HDF5 file (specified by
 *          \p file_id) by flushing all data to storage.
 *
 *          If this is the last file identifier open for the file and no other
 *          access identifier is open (e.g., a dataset identifier, group
 *          identifier, or shared datatype identifier), the file will be fully
 *          closed and access will end.
 *
 * \par Example
 * \snippet H5F_examples.c minimal
 *
 * \note \Bold{Delayed close:} Note the following deviation from the
 *       above-described behavior. If H5Fclose() is called for a file but one
 *       or more objects within the file remain open, those objects will remain
 *       accessible until they are individually closed. Thus, if the dataset
 *       \c data_sample is open when H5Fclose() is called for the file
 *       containing it, \c data_sample will remain open and accessible
 *       (including writable) until it is explicitly closed. The file will be
 *       automatically closed once all objects in the file have been closed.\n
 *       Be warned, however, that there are circumstances where it is not
 *       possible to delay closing a file. For example, an MPI-IO file close is
 *       a collective call; all of the processes that opened the file must
 *       close it collectively. The file cannot be closed at some time in the
 *       future by each process in an independent fashion. Another example is
 *       that an application using an AFS token-based file access privilege may
 *       destroy its AFS token after H5Fclose() has returned successfully. This
 *       would make any future access to the file, or any object within it,
 *       illegal.\n
 *       In such situations, applications must close all open objects in a file
 *       before calling H5Fclose. It is generally recommended to do so in all
 *       cases.
 *
 * @see H5Fopen()
 *
 */
public static native @Cast("herr_t") int H5Fclose(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Deletes an HDF5 file
 *
 * @param filename [in] Name of the file to delete
 * \fapl_id
 *
 * @return \herr_t
 *
 * \details H5Fdelete() deletes an HDF5 file \p filename with a file access
 *          property list \p fapl_id. The \p fapl_id should be configured with
 *          the same VOL connector or VFD that was used to open the file.
 *
 *          This API was introduced for use with the Virtual Object Layer
 *          (VOL). With the VOL, HDF5 "files" can map to arbitrary storage
 *          schemes such as object stores and relational database tables. The
 *          data created by these implementations may be inconvenient for a
 *          user to remove without a detailed knowledge of the storage scheme.
 *          H5Fdelete() gives VOL connector authors the ability to add
 *          connector-specific delete code to their connectors so that users
 *          can remove these "files" without detailed knowledge of the storage
 *          scheme.
 *
 *          For a VOL connector, H5Fdelete() deletes the file in a way that
 *          makes sense for the specified VOL connector.
 *
 *          For the native HDF5 connector, HDF5 files will be deleted via the
 *          VFDs, each of which will have to be modified to delete the files it
 *          creates.
 *
 *          For all implementations, H5Fdelete() will first check if the file
 *          is an HDF5 file via H5Fis_accessible(). This is done to ensure that
 *          H5Fdelete() cannot be used as an arbitrary file deletion call.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Fdelete(@Cast("const char*") BytePointer filename, @Cast("hid_t") long fapl_id);
public static native @Cast("herr_t") int H5Fdelete(String filename, @Cast("hid_t") long fapl_id);
/**
 * \ingroup H5F
 *
 * \brief Returns a file creation property list identifier
 *
 * \file_id
 * @return \hid_t{file creation property list}
 *
 * \details H5Fget_create_plist() returns the file creation property list
 *          identifier identifying the creation properties used to create this
 *          file. This function is useful for duplicating properties when
 *          creating another file.
 *
 *          The creation property list identifier should be released with
 *          H5Pclose().
 *
 */
public static native @Cast("hid_t") long H5Fget_create_plist(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Returns a file access property list identifier
 *
 * \file_id
 * @return \hid_t{file access property list}
 *
 * \details H5Fget_access_plist() returns the file access property list
 *          identifier of the specified file.
 *
 */
public static native @Cast("hid_t") long H5Fget_access_plist(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Determines the read/write or read-only status of a file
 *
 * \file_id
 * @param intent [out] Access mode flag as originally passed with H5Fopen()
 *
 * @return \herr_t
 *
 * \details Given the identifier of an open file, \p file_id, H5Fget_intent()
 *          retrieves the intended access mode" flag passed with H5Fopen() when
 *          the file was opened.
 *
 *          The value of the flag is returned in \p intent. Valid values are as
 *          follows:
 *          \file_access
 *
 * \note The function will not return an error if intent is NULL; it will
 *       simply do nothing.
 *
 * @version 1.10.0 Function enhanced to work with SWMR functionality.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") IntPointer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") IntBuffer intent);
public static native @Cast("herr_t") int H5Fget_intent(@Cast("hid_t") long file_id, @Cast("unsigned*") int[] intent);
/**
 * \ingroup H5F
 *
 * \brief Retrieves a file's file number that uniquely identifies an open file
 *
 * \file_id
 * @param fileno [out] A buffer to hold the file number
 *
 * @return \herr_t
 *
 * \details H5Fget_fileno() retrieves a file number for a file specified by the
 *          file identifier \p file_id and the pointer \p fnumber to the file
 *          number.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Fget_fileno(@Cast("hid_t") long file_id, @Cast("unsigned long*") CLongPointer fileno);
/**
 * \ingroup H5F
 *
 * \brief Returns the number of open object identifiers for an open file
 *
 * \file_id or #H5F_OBJ_ALL for all currently-open HDF5 files
 * @param types [in] Type of object for which identifiers are to be returned
 *
 * @return Returns the number of open objects if successful; otherwise returns
 *         a negative value.
 *
 * \details Given the identifier of an open file, file_id, and the desired
 *          object types, types, H5Fget_obj_count() returns the number of open
 *          object identifiers for the file.
 *
 *          To retrieve a count of open identifiers for open objects in all
 *          HDF5 application files that are currently open, pass the value
 *          #H5F_OBJ_ALL in \p file_id.
 *
 *          The types of objects to be counted are specified in types as
 *          follows:
 *          \obj_types
 *
 *          Multiple object types can be combined with the
 *          logical \c OR operator (|). For example, the expression
 *          \c (#H5F_OBJ_DATASET|#H5F_OBJ_GROUP) would call for datasets and
 *          groups.
 *
 * @version 1.6.8, 1.8.2 Function return type changed to \c ssize_t.
 * @version 1.6.5 #H5F_OBJ_LOCAL has been added as a qualifier on the types
 *                of objects to be counted. #H5F_OBJ_LOCAL restricts the
 *                search to objects opened through current file identifier.
 *
 */
public static native @Cast("ssize_t") long H5Fget_obj_count(@Cast("hid_t") long file_id, @Cast("unsigned") int types);
/**
 *-------------------------------------------------------------------------
 * \ingroup H5F
 *
 * \brief Returns a list of open object identifiers
 *
 * \file_id or #H5F_OBJ_ALL for all currently-open HDF5 files
 * @param types [in] Type of object for which identifiers are to be returned
 * @param max_objs [in] Maximum number of object identifiers to place into
 *                     \p obj_id_list
 * @param obj_id_list [out] Pointer to the returned buffer of open object
 *                         identifiers
 *
 * @return Returns number of objects placed into \p obj_id_list if successful;
 *         otherwise returns a negative value.
 *
 * \details Given the file identifier \p file_id and the type of objects to be
 *          identified, types, H5Fget_obj_ids() returns the list of identifiers
 *          for all open HDF5 objects fitting the specified criteria.
 *
 *          To retrieve identifiers for open objects in all HDF5 application
 *          files that are currently open, pass the value #H5F_OBJ_ALL in
 *          \p file_id.
 *
 *          The types of object identifiers to be retrieved are specified in
 *          types using the codes listed for the same parameter in
 *          H5Fget_obj_count().
 *
 *          To retrieve a count of open objects, use the H5Fget_obj_count()
 *          function. This count can be used to set the \p max_objs parameter.
 *
 * @version 1.8.2 Function return type changed to \c ssize_t and \p
 *                max_objs parameter datatype changed to \c size_t.
 * @version 1.6.8 Function return type changed to \c ssize_t and \p
 *                max_objs parameter datatype changed to \c size_t.
 * @since 1.6.0
 *
 */
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") LongPointer obj_id_list);
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") LongBuffer obj_id_list);
public static native @Cast("ssize_t") long H5Fget_obj_ids(@Cast("hid_t") long file_id, @Cast("unsigned") int types, @Cast("size_t") long max_objs, @Cast("hid_t*") long[] obj_id_list);
/**
 * \ingroup H5F
 *
 * \brief Returns pointer to the file handle from the virtual file driver
 *
 * \file_id
 * \fapl_id{fapl}
 * @param file_handle [out] Pointer to the file handle being used by the
 *                         low-level virtual file driver
 *
 * @return \herr_t
 *
 * \details Given the file identifier \p file_id and the file access property
 *          list \p fapl_id, H5Fget_vfd_handle() returns a pointer to the file
 *          handle from the low-level file driver currently being used by the
 *          HDF5 library for file I/O.
 *
 * \note For most drivers, the value of \p fapl_id will be #H5P_DEFAULT. For
 *       the \c FAMILY or \c MULTI drivers, this value should be defined
 *       through the property list functions: H5Pset_family_offset() for the
 *       \c FAMILY driver and H5Pset_multi_type() for the \c MULTI driver
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") long file_id, @Cast("hid_t") long fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5Fget_vfd_handle(@Cast("hid_t") long file_id, @Cast("hid_t") long fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
/**
 * \ingroup H5F
 *
 * \brief Mounts an HDF5 file
 *
 * \loc_id{loc}
 * @param name [in] Name of the group onto which the file specified by \p child
 *                 is to be mounted
 * \file_id{child}
 * @param plist [in] File mount property list identifier. Pass #H5P_DEFAULT!
 *
 * @return \herr_t
 *
 * \details H5Fmount() mounts the file specified by \p child onto the object
 *          specified by \p loc and \p name using the mount properties \p plist
 *          If the object specified by \p loc is a dataset, named datatype or
 *          attribute, then the file will be mounted at the location where the
 *          attribute, dataset, or named datatype is attached.
 *
 * \par Example
 * \snippet H5F_examples.c mount
 *
 * \note To date, no file mount properties have been defined in HDF5. The
 *       proper value to pass for \p plist is #H5P_DEFAULT, indicating the
 *       default file mount property list.
 *
 */
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") long loc, @Cast("const char*") BytePointer name, @Cast("hid_t") long child, @Cast("hid_t") long plist);
public static native @Cast("herr_t") int H5Fmount(@Cast("hid_t") long loc, String name, @Cast("hid_t") long child, @Cast("hid_t") long plist);
/**
 * \ingroup H5F
 *
 * \brief Unounts an HDF5 file
 *
 * \loc_id{loc}
 * @param name [in] Name of the mount point
 *
 * @return \herr_t
 *
 * \details Given a mount point, H5Funmount() dissociates the mount point's
 *          file from the file mounted there. This function does not close
 *          either file.
 *
 *          The mount point can be either the group in the parent or the root
 *          group of the mounted file (both groups have the same name). If the
 *          mount point was opened before the mount then it is the group in the
 *          parent; if it was opened after the mount then it is the root group
 *          of the child.
 *
 */
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") long loc, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Funmount(@Cast("hid_t") long loc, String name);
/**
 * \ingroup H5F
 *
 * \brief Returns the amount of free space in a file (in bytes)
 *
 * \file_id
 *
 * @return Returns the amount of free space in the file if successful;
 *         otherwise returns a negative value.
 *
 * \details Given the identifier of an open file, \p file_id,
 *          H5Fget_freespace() returns the amount of space that is unused by
 *          any objects in the file.
 *
 *          The interpretation of this number depends on the configured free space
 *          management strategy. For example, if the HDF5 library only tracks free
 *          space in a file from a file open or create until that file is closed,
 *          then this routine will report the free space that has been created
 *          during that interval.
 *
 * @since 1.6.1
 *
 */
public static native @Cast("hssize_t") long H5Fget_freespace(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Returns the size of an HDF5 file (in bytes)
 *
 * \file_id
 * @param size [out] Size of the file, in bytes
 *
 * @return \herr_t
 *
 * \details H5Fget_filesize() returns the size of the HDF5 file specified by
 *          \p file_id.
 *
 *          The returned size is that of the entire file, as opposed to only
 *          the HDF5 portion of the file. I.e., size includes the user block,
 *          if any, the HDF5 portion of the file, and any data that may have
 *          been appended beyond the data written through the HDF5 library.
 *
 * @since 1.6.3
 *
 */
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Fget_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t*") long[] size);
/**
 * \ingroup H5F
 *
 * \brief Retrieves the file's end-of-allocation (EOA)
 *
 * \file_id
 * @param eoa [out] The file's EOA
 *
 * @return \herr_t
 *
 * \details H5Fget_eoa() retrieves the file's EOA and returns it in the
 *          parameter eoa.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongPointer eoa);
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongBuffer eoa);
public static native @Cast("herr_t") int H5Fget_eoa(@Cast("hid_t") long file_id, @Cast("haddr_t*") long[] eoa);
/**
 * \ingroup H5F
 *
 * \brief Sets the file' EOA to the maximum of (EOA, EOF) + increment
 *
 * \file_id
 * @param increment [in] The number of bytes to be added to the maximum of
 *                      (EOA, EOF)
 *
 * @return \herr_t
 *
 * \details H5Fincrement_filesize() sets the file's EOA to the maximum of (EOA,
 *          EOF) + \p increment. The EOA is the end-of-file address stored in
 *          the file's superblock while EOF is the file's actual end-of-file.
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Fincrement_filesize(@Cast("hid_t") long file_id, @Cast("hsize_t") long increment);
/**
 * \ingroup H5F
 *
 * \brief Retrieves a copy of the image of an existing, open file
 *
 * \file_id
 * @param buf_ptr [out] Pointer to the buffer into which the image of the
 *                     HDF5 file is to be copied. If \p buf_ptr is NULL,
 *                     no data will be copied but the function’s return value
 *                     will still indicate the buffer size required (or a
 *                     negative value on error).
 * @param buf_len [out] Size of the supplied buffer
 *
 * @return ssize_t
 *
 * \details H5Fget_file_image() retrieves a copy of the image of an existing,
 *          open file. This routine can be used with files opened using the
 *          SEC2 (or POSIX), STDIO, and Core (or Memory) virtual file drivers
 *          (VFDs).
 *
 *          If the return value of H5Fget_file_image() is a positive value, it
 *          will be the length in bytes of the buffer required to store the
 *          file image. So if the file size is unknown, it can be safely
 *          determined with an initial H5Fget_file_image() call with buf_ptr
 *          set to NULL. The file image can then be retrieved with a second
 *          H5Fget_file_image() call with \p buf_len set to the initial call’s
 *          return value.
 *
 *          While the current file size can also be retrieved with
 *          H5Fget_filesize(), that call may produce a larger value than is
 *          needed. The value returned by H5Fget_filesize() includes the user
 *          block, if it exists, and any unallocated space at the end of the
 *          file. It is safe in all situations to get the file size with
 *          H5Fget_file_image() and it often produces a value that is more
 *          appropriate for the size of a file image buffer.
 *
 * \note \Bold{Recommended Reading:} This function is part of the file image
 *       operations feature set. It is highly recommended to study the guide
 *       \ref_file_image_ops before using this feature set.
 *
 * \attention H5Pget_file_image() will fail, returning a negative value, if the
 *            file is too large for the supplied buffer.
 *
 * @see H5LTopen_file_image(), H5Pset_file_image(), H5Pget_file_image(),
 *      H5Pset_file_image_callbacks(), H5Pget_file_image_callbacks()
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Fget_file_image(@Cast("hid_t") long file_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
/**
 * \ingroup MDC
 *
 * \brief Obtains current metadata cache configuration for target file
 *
 * \file_id
 * @param config_ptr [in,out] Pointer to the H5AC_cache_config_t instance in which
 *                        the current metadata cache configuration is to be
 *                        reported. The fields of this structure are discussed
 *                        \ref H5AC-cache-config-t "here".
 * @return \herr_t
 *
 * \note The \c in direction applies only to the H5AC_cache_config_t::version
 *       field. All other fields are out parameters.
 *
 * \details H5Fget_mdc_config() loads the current metadata cache configuration
 *          into the instance of H5AC_cache_config_t pointed to by the \p config_ptr
 *          parameter.\n
 *          The fields of the H5AC_cache_config_t structure are shown below:
 *          \snippet H5ACpublic.h H5AC_cache_config_t_snip
 *          \click4more
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Fget_mdc_config(@Cast("hid_t") long file_id, H5AC_cache_config_t config_ptr);
/**
 * \ingroup MDC
 *
 * \brief Attempts to configure metadata cache of target file
 *
 * \file_id
 * @param config_ptr [in,out] Pointer to the H5AC_cache_config_t instance
 *                           containing the desired configuration.
 *                           The fields of this structure are discussed
 *                           \ref H5AC-cache-config-t "here".
 * @return \herr_t
 *
 * \details H5Fset_mdc_config() attempts to configure the file's metadata cache
 *          according configuration supplied in \p config_ptr.
 *          \snippet H5ACpublic.h H5AC_cache_config_t_snip
 *          \click4more
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Fset_mdc_config(@Cast("hid_t") long file_id, H5AC_cache_config_t config_ptr);
/**
 * \ingroup MDC
 *
 * \brief Obtains target file's metadata cache hit rate
 *
 * \file_id
 * @param hit_rate_ptr [out] Pointer to the double in which the hit rate is returned. Note that
 *                          \p hit_rate_ptr is undefined if the API call fails
 * @return \herr_t
 *
 * \details H5Fget_mdc_hit_rate() queries the metadata cache of the target file to obtain its hit rate
 *          \Code{(cache hits / (cache hits + cache misses))} since the last time hit rate statistics
 *          were reset. If the cache has not been accessed since the last time the hit rate stats were
 *          reset, the hit rate is defined to be 0.0.
 *
 *          The hit rate stats can be reset either manually (via H5Freset_mdc_hit_rate_stats()), or
 *          automatically. If the cache's adaptive resize code is enabled, the hit rate stats will be
 *          reset once per epoch. If they are reset manually as well, the cache may behave oddly.
 *
 *          See the overview of the metadata cache in the special topics section of the user manual for
 *          details on the metadata cache and its adaptive resize algorithms.
 *
 */
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, DoublePointer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, DoubleBuffer hit_rate_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_hit_rate(@Cast("hid_t") long file_id, double[] hit_rate_ptr);
/**
 * \ingroup MDC
 *
 * \brief Obtains current metadata cache size data for specified file
 *
 * \file_id
 * @param max_size_ptr [out] Pointer to the location in which the current cache maximum size is to be
 *                          returned, or NULL if this datum is not desired
 * @param min_clean_size_ptr [out] Pointer to the location in which the current cache minimum clean
 *                                size is to be returned, or NULL if that datum is not desired
 * @param cur_size_ptr [out] Pointer to the location in which the current cache size is to be returned,
 *                          or NULL if that datum is not desired
 * @param cur_num_entries_ptr [out] Pointer to the location in which the current number of entries in
 *                                 the cache is to be returned, or NULL if that datum is not desired
 * @return \herr_t
 *
 * \details H5Fget_mdc_size()  queries the metadata cache of the target file for the desired size
 *          information, and returns this information in the locations indicated by the pointer
 *          parameters. If any pointer parameter is NULL, the associated data is not returned.
 *
 *          If the API call fails, the values returned via the pointer parameters are undefined.
 *
 *          If adaptive cache resizing is enabled, the cache maximum size and minimum clean size
 *          may change at the end of each epoch. Current size and current number of entries can
 *          change on each cache access.
 *
 *          Current size can exceed maximum size under certain conditions. See the overview of the
 *          metadata cache in the special topics section of the user manual for a discussion of this.
 *
 */
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id, @Cast("size_t*") SizeTPointer max_size_ptr, @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr, IntPointer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id, @Cast("size_t*") SizeTPointer max_size_ptr, @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr, IntBuffer cur_num_entries_ptr);
public static native @Cast("herr_t") int H5Fget_mdc_size(@Cast("hid_t") long file_id, @Cast("size_t*") SizeTPointer max_size_ptr, @Cast("size_t*") SizeTPointer min_clean_size_ptr,
                              @Cast("size_t*") SizeTPointer cur_size_ptr, int[] cur_num_entries_ptr);
/**
 * \ingroup MDC
 *
 * \brief Resets hit rate statistics counters for the target file
 *
 * \file_id
 * @return \herr_t
 *
 * \details
 * \parblock
 * H5Freset_mdc_hit_rate_stats() resets the hit rate statistics counters in the metadata cache
 * associated with the specified file.
 *
 * If the adaptive cache resizing code is enabled, the hit rate statistics are reset at the beginning
 * of each epoch. This API call allows you to do the same thing from your program.
 *
 * The adaptive cache resizing code may behave oddly if you use this call when adaptive cache resizing
 * is enabled. However, the call should be useful if you choose to control metadata cache size from your
 * program.
 *
 * See \ref_mdc_in_hdf5 for details about the metadata cache and the adaptive cache resizing
 * algorithms. If you have not read, understood, and thought about the material covered in that
 * documentation,
 * you should not be using this API call.
 * \endparblock
 *
 */
public static native @Cast("herr_t") int H5Freset_mdc_hit_rate_stats(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Retrieves name of file to which object belongs
 *
 * \obj_id
 * @param name [out] Buffer for the file name
 * @param size [in] Size, in bytes, of the \p name buffer
 *
 * @return Returns the length of the file name if successful; otherwise returns
 *         a negative value.
 *
 * \details H5Fget_name() retrieves the name of the file to which the object \p
 *          obj_id belongs. The object can be a file, group, dataset,
 *          attribute, or named datatype.
 *
 *          Up to \p size characters of the file name are returned in \p name;
 *          additional characters, if any, are not returned to the user
 *          application.
 *
 *          If the length of the name, which determines the required value of
 *          size, is unknown, a preliminary H5Fget_name() call can be made by
 *          setting \p name to NULL. The return value of this call will be the
 *          size of the file name; that value plus one (1) can then be assigned
 *          to size for a second H5Fget_name() call, which will retrieve the
 *          actual name. (The value passed in with the parameter \p size must
 *          be one greater than size in bytes of the actual name in order to
 *          accommodate the null terminator; if \p size is set to the exact
 *          size of the name, the last byte passed back will contain the null
 *          terminator and the last character will be missing from the name
 *          passed back to the calling application.)
 *
 *          If an error occurs, the buffer pointed to by \p name is unchanged
 *          and the function returns a negative value.
 *
 * @since 1.6.3
 *
 */
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Fget_name(@Cast("hid_t") long obj_id, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * \ingroup H5F
 *
 * \brief Retrieves name of file to which object belongs
 *
 * \fgdta_obj_id
 * @param file_info [out] Buffer for global file information
 *
 * @return \herr_t
 *
 * \details H5Fget_info2() returns global information for the file associated
 *          with the object identifier \p obj_id in the H5F_info2_t \c struct
 *          named \p file_info.
 *
 *          \p obj_id is an identifier for any object in the file of interest.
 *
 *          H5F_info2_t struct is defined in H5Fpublic.h as follows:
 *          \snippet this H5F_info2_t_snip
 *
 *          The \c super sub-struct contains the following information:
 *          \li \c vers is the version number of the superblock.
 *          \li \c  super_size is the size of the superblock.
 *          \li \c super_ext_size is the size of the superblock extension.
 *
 *          The \c free sub-struct contains the following information:
 *          \li vers is the version number of the free-space manager.
 *          \li \c hdr_size is the size of the free-space manager header.
 *          \li \c tot_space is the total amount of free space in the file.
 *
 *          The \c sohm sub-struct contains shared object header message
 *          information as follows:
 *          \li \c vers is the version number of the shared object header information.
 *          \li \c hdr_size is the size of the shared object header message.
 *          \li \c msgs_info is an H5_ih_info_t struct defined in H5public.h as
 *              follows: \snippet H5public.h H5_ih_info_t_snip
 *          \li \p index_size is the summed size of all the shared object
 *              header indexes. Each index might be either a B-tree or
 *              a list.
 *          \li \p heap_size is the size of the heap.
 *
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Fget_info2(@Cast("hid_t") long obj_id, H5F_info2_t file_info);
/**
 * \ingroup SWMR
 *
 * \brief Retrieves the collection of read retries for metadata entries with checksum
 *
 * \file_id
 * @param info [out] Struct containing the collection of read retries for metadata
 *                  entries with checksum
 * @return \herr_t\n
 *
 * \details \Bold{Failure Modes:}
 *       \li When the input identifier is not a file identifier.
 *       \li When the pointer to the output structure is NULL.
 *       \li When the memory allocation for \p retries failed.
 *
 * \details H5Fget_metadata_read_retry_info() retrieves information regarding the number
 *          of read retries for metadata entries with checksum for the file \p file_id.
 *          This information is reported in the H5F_retry_info_t struct defined in
 *          H5Fpublic.h as follows:
 *          \snippet this H5F_retry_info_t_snip
 *          \c nbins is the number of bins for each \c retries[i] of metadata entry \c i.
 *          It is calculated based on the current number of read attempts used in the
 *          library and logarithmic base 10.
 *
 *          If read retries are incurred for a metadata entry \c i, the library will
 *          allocate memory for \Code{retries[i] (nbins * sizeof(uint32_t)} and store
 *          the collection of retries there. If there are no retries for a metadata entry
 *          \c i, \Code{retries[i]} will be NULL. After a call to this routine, users should
 *          free each \Code{retries[i]} that is non-NULL, otherwise resource leak will occur.
 *
 *          For the library default read attempts of 100 for SWMR access, nbins will be 2
 *          as depicted below:
 *          \li \Code{retries[i][0]} is the number of 1 to 9 read retries.
 *          \li \Code{retries[i][1]} is the number of 10 to 99 read retries.
 *          For the library default read attempts of 1 for non-SWMR access, \c nbins will
 *          be 0 and each \Code{retries[i]} will be NULL.
 *
 *          The following table lists the 21 metadata entries of \Code{retries[]}:
 *          <table>
 *          <tr>
 *          <th>Index for \Code{retries[]}</th>
 *          <th>Metadata entries<sup>*</sup></th>
 *          </tr>
 *          <tr><td>0</td><td>Object header (version 2)</td></tr>
 *          <tr><td>1</td><td>Object header chunk (version 2)</td></tr>
 *          <tr><td>2</td><td>B-tree header (version 2)</td></tr>
 *          <tr><td>3</td><td>B-tree internal node (version 2)</td></tr>
 *          <tr><td>4</td><td>B-tree leaf node (version 2)</td></tr>
 *          <tr><td>5</td><td>Fractal heap header</td></tr>
 *          <tr><td>6</td><td>Fractal heap direct block (optional checksum)</td></tr>
 *          <tr><td>7</td><td>Fractal heap indirect block</td></tr>
 *          <tr><td>8</td><td>Free-space header</td></tr>
 *          <tr><td>9</td><td>Free-space sections</td></tr>
 *          <tr><td>10</td><td>Shared object header message table</td></tr>
 *          <tr><td>11</td><td>Shared message record list</td></tr>
 *          <tr><td>12</td><td>Extensive array header</td></tr>
 *          <tr><td>13</td><td>Extensive array index block</td></tr>
 *          <tr><td>14</td><td>Extensive array super block</td></tr>
 *          <tr><td>15</td><td>Extensive array data block</td></tr>
 *          <tr><td>16</td><td>Extensive array data block page</td></tr>
 *          <tr><td>17</td><td>Fixed array super block</td></tr>
 *          <tr><td>18</td><td>Fixed array data block</td></tr>
 *          <tr><td>19</td><td>Fixed array data block page</td></tr>
 *          <tr><td>20</td><td>File's superblock (version 2)</td></tr>
 *          <tr><td colspan=2><sup>*</sup> All entries are of version 0 (zero) unless indicated
 *          otherwise.</td></tr>
 *          </table>
 *
 * \note   On a system that is not atomic, the library might possibly read inconsistent
 *         metadata with checksum when performing single-writer/multiple-reader (SWMR)
 *         operations for an HDF5 file. Upon encountering such situations, the library
 *         will try reading the metadata again for a set number of times to attempt to
 *         obtain consistent data. The maximum number of read attempts used by the library
 *         will be either the value set via H5Pset_metadata_read_attempts() or the library
 *         default value when a value is not set.\n
 *         When the current number of metadata read attempts used in the library is unable
 *         to remedy the reading of inconsistent metadata on a system, the user can assess
 *         the information obtained via this routine to derive a different maximum value.
 *         The information can also be helpful for debugging purposes to identify potential
 *         issues with metadata flush dependencies and SWMR implementation in general.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Fget_metadata_read_retry_info(@Cast("hid_t") long file_id, H5F_retry_info_t info);
/**
 * \ingroup SWMR
 *
 * \brief Retrieves free-space section information for a file
 *
 * \file_id
 *
 * @return \herr_t
 *
 * \details H5Fstart_swmr_write() will activate SWMR writing mode for a file
 *          associated with \p file_id. This routine will prepare and ensure
 *          the file is safe for SWMR writing as follows:
 *          \li Check that the file is opened with write access (#H5F_ACC_RDWR).
 *          \li Check that the file is opened with the latest library format to
 *              ensure data structures with check-summed metadata are used.
 *          \li Check that the file is not already marked in SWMR writing mode.
 *          \li Enable reading retries for check-summed metadata to remedy
 *              possible checksum failures from reading inconsistent metadata
 *              on a system that is not atomic.
 *          \li Turn off usage of the library's accumulator to avoid possible
 *              ordering problem on a system that is not atomic.
 *          \li Perform a flush of the file’s data buffers and metadata to set
 *              a consistent state for starting SWMR write operations.
 *
 *          Library objects are groups, datasets, and committed datatypes. For
 *          the current implementation, groups and datasets can remain open when
 *          activating SWMR writing mode, but not committed datatypes. Attributes
 *          attached to objects cannot remain open either.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Fstart_swmr_write(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Retrieves free-space section information for a file
 *
 * \file_id
 * @param type [in] The file memory allocation type
 * @param nsects [in] The number of free-space sections
 * @param sect_info [out] Array of instances of H5F_sect_info_t in which
 *                       the free-space section information is to be returned
 *
 * @return Returns the number of free-space sections for the specified
 *         free-space manager in the file; otherwise returns a negative value.
 *
 * \details H5Fget_free_sections() retrieves free-space section information for
 *          the free-space manager with type that is associated with file
 *          \p file_id. If type is #H5FD_MEM_DEFAULT, this routine retrieves
 *          free-space section information for all the free-space managers in
 *          the file.
 *
 *          Valid values for \p type are the following:
 *          \mem_types
 *
 *          H5F_sect_info_t is defined as follows (in H5Fpublic.h):
 *          \snippet this H5F_sect_info_t_snip
 *
 *          This routine retrieves free-space section information for \p nsects
 *          sections or at most the maximum number of sections in the specified
 *          free-space manager. If the number of sections is not known, a
 *          preliminary H5Fget_free_sections() call can be made by setting \p
 *          sect_info to NULL and the total number of free-space sections for
 *          the specified free-space manager will be returned. Users can then
 *          allocate space for entries in \p sect_info, each of which is
 *          defined as an H5F_sect_info_t \c struct.
 *
 * \attention \Bold{Failure Modes:} This routine will fail when the following
 *            is true:
 *            \li The library fails to retrieve the file creation property list
 *                associated with \p file_id.
 *            \li If the parameter \p sect_info is non-null, but the parameter
 *                \p nsects is equal to 0.
 *            \li The library fails to retrieve free-space section information
 *                for the file.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("ssize_t") long H5Fget_free_sections(@Cast("hid_t") long file_id, @Cast("H5F_mem_t") int type, @Cast("size_t") long nsects,
                                    H5F_sect_info_t sect_info);
/**
 * \ingroup H5F
 *
 * \brief Clears the external link open file cache
 *
 * \file_id
 * @return \herr_t
 *
 * \details H5Fclear_elink_file_cache() evicts all the cached child files in
 *          the specified file’s external file cache, causing them to be closed
 *          if there is nothing else holding them open.
 *
 *          H5Fclear_elink_file_cache() does not close the cache itself;
 *          subsequent external link traversals from the parent file will again
 *          cache the target file. See H5Pset_elink_file_cache_size() for
 *          information on closing the file cache.
 *
 * @see H5Pset_elink_file_cache_size(), H5Pget_elink_file_cache_size()
 *
 * @since 1.8.7
 *
 */
public static native @Cast("herr_t") int H5Fclear_elink_file_cache(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Enables the switch of version bounds setting for a file
 *
 * \file_id
 * @param low [in] The earliest version of the library that will be used for
 *                writing objects
 * @param high [in] The latest version of the library that will be used for
 *                 writing objects
 *
 * @return \herr_t
 *
 * \details H5Fset_libver_bounds() enables the switch of version bounds setting
 *          for an open file associated with \p file_id.
 *
 *          For the parameters \p low and \p high, see the description for
 *          H5Pset_libver_bounds().
 *
 * \par Example
 * \snippet H5F_examples.c libver_bounds
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Fset_libver_bounds(@Cast("hid_t") long file_id, @Cast("H5F_libver_t") int low, @Cast("H5F_libver_t") int high);
/**
 * \ingroup MDC
 *
 * \brief Starts logging metadata cache events if logging was previously enabled
 *
 * \file_id
 *
 * @return \herr_t
 *
 * \details The metadata cache is a central part of the HDF5 library through
 *          which all \Emph{file metadata} reads and writes take place. File
 *          metadata is normally invisible to the user and is used by the
 *          library for purposes such as locating and indexing data. File
 *          metadata should not be confused with user metadata, which consists
 *          of attributes created by users and attached to HDF5 objects such
 *          as datasets via H5A API calls.
 *
 *          Due to the complexity of the cache, a trace/logging feature has been
 *          created that can be used by HDF5 developers for debugging and performance
 *          analysis. The functions that control this functionality will normally be
 *          of use to a very limited number of developers outside of The HDF Group.
 *          The functions have been documented to help users create logs that can
 *          be sent with bug reports.
 *
 *          Control of the log functionality is straightforward. Logging is enabled
 *          via the H5Pset_mdc_log_options() function, which will modify the file
 *          access property list used to open or create a file. This function has
 *          a flag that determines whether logging begins at file open or starts
 *          in a paused state. Log messages can then be controlled via the
 *          H5Fstart_mdc_logging() and H5Fstop_mdc_logging() functions.
 *          H5Pget_mdc_log_options() can be used to examine a file access property
 *          list, and H5Fget_mdc_logging_status() will return the current state of
 *          the logging flags.
 *
 *          The log format is described in the \ref_mdc_logging document.
 *
 * \note Logging can only be started or stopped if metadata cache logging was enabled
 *       via H5Pset_mdc_log_options().\n
 *       When enabled and currently logging, the overhead of the logging feature will
 *       almost certainly be significant.\n
 *       The log file is opened when the HDF5 file is opened or created and not when
 *       this function is called for the first time.\n
 *       This function opens the log file and starts logging metadata cache operations
 *       for a particular file. Calling this function when logging has already been
 *       enabled will be considered an error.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Fstart_mdc_logging(@Cast("hid_t") long file_id);
/**
 * \ingroup MDC
 *
 * \brief Stops logging metadata cache events if logging was previously enabled and is currently ongoing
 *
 * \file_id
 *
 * @return \herr_t
 *
 * \details The metadata cache is a central part of the HDF5 library through
 *          which all \Emph{file metadata} reads and writes take place. File
 *          metadata is normally invisible to the user and is used by the
 *          library for purposes such as locating and indexing data. File
 *          metadata should not be confused with user metadata, which consists
 *          of attributes created by users and attached to HDF5 objects such
 *          as datasets via H5A API calls.
 *
 *          Due to the complexity of the cache, a trace/logging feature has been
 *          created that can be used by HDF5 developers for debugging and performance
 *          analysis. The functions that control this functionality will normally be
 *          of use to a very limited number of developers outside of The HDF Group.
 *          The functions have been documented to help users create logs that can
 *          be sent with bug reports.
 *
 *          Control of the log functionality is straightforward. Logging is enabled
 *          via the H5Pset_mdc_log_options() function, which will modify the file
 *          access property list used to open or create a file. This function has
 *          a flag that determines whether logging begins at file open or starts
 *          in a paused state. Log messages can then be controlled via the
 *          H5Fstart_mdc_logging() and H5Fstop_mdc_logging() functions.
 *          H5Pget_mdc_log_options() can be used to examine a file access property
 *          list, and H5Fget_mdc_logging_status() will return the current state of
 *          the logging flags.
 *
 *          The log format is described in the \ref_mdc_logging document.
 *
 * \note Logging can only be started or stopped if metadata cache logging was enabled
 *       via H5Pset_mdc_log_options().\n
 *       This function only suspends the logging operations. The log file will remain
 *       open and will not be closed until the HDF5 file is closed.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Fstop_mdc_logging(@Cast("hid_t") long file_id);
/**
 * \ingroup MDC
 *
 * \brief Gets the current metadata cache logging status
 *
 * \file_id
 * @param is_enabled [out] Whether logging is enabled
 * @param is_currently_logging [out] Whether events are currently being logged
 * @return \herr_t
 *
 * \details The metadata cache is a central part of the HDF5 library through
 *          which all \Emph{file metadata} reads and writes take place. File
 *          metadata is normally invisible to the user and is used by the
 *          library for purposes such as locating and indexing data. File
 *          metadata should not be confused with user metadata, which consists
 *          of attributes created by users and attached to HDF5 objects such
 *          as datasets via H5A API calls.
 *
 *          Due to the complexity of the cache, a trace/logging feature has been
 *          created that can be used by HDF5 developers for debugging and performance
 *          analysis. The functions that control this functionality will normally be
 *          of use to a very limited number of developers outside of The HDF Group.
 *          The functions have been documented to help users create logs that can
 *          be sent with bug reports.
 *
 *          Control of the log functionality is straightforward. Logging is enabled
 *          via the H5Pset_mdc_log_options() function, which will modify the file
 *          access property list used to open or create a file. This function has
 *          a flag that determines whether logging begins at file open or starts
 *          in a paused state. Log messages can then be controlled via the
 *          H5Fstart_mdc_logging() and H5Fstop_mdc_logging() functions.
 *          H5Pget_mdc_log_options() can be used to examine a file access property
 *          list, and H5Fget_mdc_logging_status() will return the current state of
 *          the logging flags.
 *
 *          The log format is described in the \ref_mdc_logging document.
 *
 * \note Unlike H5Fstart_mdc_logging() and H5Fstop_mdc_logging(), this function can
 *       be called on any open file identifier.
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") long file_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("hbool_t*") BoolPointer is_currently_logging);
public static native @Cast("herr_t") int H5Fget_mdc_logging_status(@Cast("hid_t") long file_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("hbool_t*") boolean[] is_currently_logging);
/**
 * \ingroup SWMR
 *
 * \todo UFO?
 */
public static native @Cast("herr_t") int H5Fformat_convert(@Cast("hid_t") long fid);
/**
 * \ingroup H5F
 *
 * \brief Resets the page buffer statistics
 *
 * \file_id
 *
 * @return \herr_t
 *
 * \details H5Freset_page_buffering_stats() resets the page buffer statistics
 *          for a specified file identifier \p file_id.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Freset_page_buffering_stats(@Cast("hid_t") long file_id);
/**
 * \ingroup H5F
 *
 * \brief Retrieves statistics about page access when it is enabled
 *
 * \file_id
 * @param accesses [out] Two integer array for the number of metadata and raw
 *                      data accesses to the page buffer
 * @param hits [out] Two integer array for the number of metadata and raw data
 *                  hits in the page buffer
 * @param misses [out] Two integer array for the number of metadata and raw data
 *                    misses in the page buffer
 * @param evictions [out] Two integer array for the number of metadata and raw
 *                       data evictions from the page buffer
 * @param bypasses [out] Two integer array for the number of metadata and raw
 *                      data accesses that bypass the page buffer
 *
 * @return \herr_t
 *
 * \details H5Fget_page_buffering_stats() retrieves page buffering statistics
 *          such as the number of metadata and raw data accesses (\p accesses),
 *          hits (\p hits), misses (\p misses), evictions (\p evictions), and
 *          accesses that bypass the page buffer (\p bypasses).
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") IntPointer accesses, @Cast("unsigned*") IntPointer hits,
                                          @Cast("unsigned*") IntPointer misses, @Cast("unsigned*") IntPointer evictions, @Cast("unsigned*") IntPointer bypasses);
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") IntBuffer accesses, @Cast("unsigned*") IntBuffer hits,
                                          @Cast("unsigned*") IntBuffer misses, @Cast("unsigned*") IntBuffer evictions, @Cast("unsigned*") IntBuffer bypasses);
public static native @Cast("herr_t") int H5Fget_page_buffering_stats(@Cast("hid_t") long file_id, @Cast("unsigned*") int[] accesses, @Cast("unsigned*") int[] hits,
                                          @Cast("unsigned*") int[] misses, @Cast("unsigned*") int[] evictions, @Cast("unsigned*") int[] bypasses);
/**
 * \ingroup MDC
 *
 * \brief Obtains information about a cache image if it exists
 *
 * \file_id
 * @param image_addr [out] Offset of the cache image if it exists, or #HADDR_UNDEF if it does not
 * @param image_size [out] Length of the cache image if it exists, or 0 if it does not
 * @return \herr_t
 *
 * \details
 * \parblock
 * H5Fget_mdc_image_info() returns information about a cache image if it exists.
 *
 * When an HDF5 file is opened in Read/Write mode, any metadata cache image will
 * be read and deleted from the file on the first metadata cache access (or, if
 * persistent free space managers are enabled, on the first file space
 * allocation / deallocation, or read of free space manager status, whichever
 * comes first).
 *
 * Thus, if the file is opened Read/Write, H5Fget_mdc_image_info() should be called
 * immediately after file open and before any other operation. If H5Fget_mdc_image_info()
 * is called after the cache image is loaded, it will correctly report that no cache image
 * exists, as the image will have already been read and deleted from the file. In the Read Only
 * case, the function may be called at any time, as any cache image will not be deleted
 * from the file.
 * \endparblock
 *
 * @since 1.10.1
 */
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongPointer image_addr, @Cast("hsize_t*") LongPointer image_size);
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") LongBuffer image_addr, @Cast("hsize_t*") LongBuffer image_size);
public static native @Cast("herr_t") int H5Fget_mdc_image_info(@Cast("hid_t") long file_id, @Cast("haddr_t*") long[] image_addr, @Cast("hsize_t*") long[] image_size);
/**
 * \ingroup H5F
 *
 * \brief Retrieves the setting for whether or not a file will create minimized
 *        dataset object headers
 *
 * \file_id
 * @param minimize [out] Flag indicating whether the library will or will not
 *                      create minimized dataset object headers
 *
 * @return \herr_t
 *
 * \details H5Fget_dset_no_attrs_hint() retrieves the no dataset attributes
 *          hint setting for the file specified by the file identifier \p
 *          file_id. This setting is used to inform the library to create
 *          minimized dataset object headers when \c TRUE.
 *
 *          The setting's value is returned in the boolean pointer minimize.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Fget_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t*") BoolPointer minimize);
public static native @Cast("herr_t") int H5Fget_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t*") boolean[] minimize);
/**
 * \ingroup H5F
 *
 * \brief Sets the flag to create minimized dataset object headers
 *
 * \file_id
 * @param minimize [in] Flag indicating whether the library will or will not
 *                     create minimized dataset object headers
 *
 * @return \herr_t
 *
 * \details H5Fset_dset_no_attrs_hint() sets the no dataset attributes hint
 *          setting for the file specified by the file identifier \p file_id.
 *          If the boolean flag \p minimize is set to \c TRUE, then the library
 *          will create minimized dataset object headers in the file.
 *          \Bold{All} files that refer to the same file-on-disk will be
 *          affected by the most recent setting, regardless of the file
 *          identifier/handle (e.g., as returned by H5Fopen()). By setting the
 *          \p minimize flag to \c TRUE, the library expects that no attributes
 *          will be added to the dataset - attributes can be added, but they
 *          are appended with a continuation message, which can reduce
 *          performance.
 *
 * \attention This setting interacts with H5Pset_dset_no_attrs_hint(): if
 *            either is set to \c TRUE, then the created dataset's object header
 *            will be minimized.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Fset_dset_no_attrs_hint(@Cast("hid_t") long file_id, @Cast("hbool_t") boolean minimize);

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Fpublic_H */


// Parsed from H5FDpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * Programmer:  Robb Matzke
 *              Monday, July 26, 1999
 */
// #ifndef H5FDpublic_H
// #define H5FDpublic_H

// #include "H5public.h"
// #include "H5Fpublic.h" /*for H5F_close_degree_t */

public static final int H5_HAVE_VFL =      1; /*define a convenient app feature test*/
public static final int H5FD_VFD_DEFAULT = 0; /* Default VFL driver value */

/* Types of allocation requests: see H5Fpublic.h  */

/* Map "fractal heap" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fractal heap" indirect blocks to 'ohdr' type file memory, since they
 * are similar to fractal heap header blocks.
 *
 * Map "fractal heap" direct blocks to 'lheap' type file memory, since they
 * will be replacing local heaps.
 *
 * Map "fractal heap" 'huge' objects to 'draw' type file memory, since they
 * represent large objects that are directly stored in the file.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FHEAP_HDR =      H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_IBLOCK =   H5FD_MEM_OHDR;
public static final int H5FD_MEM_FHEAP_DBLOCK =   H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FHEAP_HUGE_OBJ = H5FD_MEM_DRAW;

/* Map "free space" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "free space" serialized sections to 'lheap' type file memory, since they
 * are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_FSPACE_HDR =   H5FD_MEM_OHDR;
public static final int H5FD_MEM_FSPACE_SINFO = H5FD_MEM_LHEAP;

/* Map "shared object header message" master table to 'ohdr' type file memory,
 * since its a fair amount of work to add a new kind of file memory and they are
 * similar enough to object headers and probably too minor to deserve their own
 * type.
 *
 * Map "shared object header message" indices to 'btree' type file memory,
 * since they are similar enough to B-tree nodes.
 *
 *      -QAK
 */
public static final int H5FD_MEM_SOHM_TABLE = H5FD_MEM_OHDR;
public static final int H5FD_MEM_SOHM_INDEX = H5FD_MEM_BTREE;

/* Map "extensible array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "extensible array" index blocks to 'ohdr' type file memory, since they
 * are similar to extensible array header blocks.
 *
 * Map "extensible array" super blocks to 'btree' type file memory, since they
 * are similar enough to B-tree nodes.
 *
 * Map "extensible array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 *      -QAK
 */
public static final int H5FD_MEM_EARRAY_HDR =       H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_IBLOCK =    H5FD_MEM_OHDR;
public static final int H5FD_MEM_EARRAY_SBLOCK =    H5FD_MEM_BTREE;
public static final int H5FD_MEM_EARRAY_DBLOCK =    H5FD_MEM_LHEAP;
public static final int H5FD_MEM_EARRAY_DBLK_PAGE = H5FD_MEM_LHEAP;

/* Map "fixed array" header blocks to 'ohdr' type file memory, since its
 * a fair amount of work to add a new kind of file memory and they are similar
 * enough to object headers and probably too minor to deserve their own type.
 *
 * Map "fixed array" data blocks & pages to 'lheap' type file memory, since
 * they are similar enough to local heap info.
 *
 */
public static final int H5FD_MEM_FARRAY_HDR =       H5FD_MEM_OHDR;
public static final int H5FD_MEM_FARRAY_DBLOCK =    H5FD_MEM_LHEAP;
public static final int H5FD_MEM_FARRAY_DBLK_PAGE = H5FD_MEM_LHEAP;

/*
 * A free-list map which maps all types of allocation requests to a single
 * free list.  This is useful for drivers that don't really care about
 * keeping different requests segregated in the underlying file and which
 * want to make most efficient reuse of freed memory.  The use of the
 * H5FD_MEM_SUPER free list is arbitrary.
 */
// #define H5FD_FLMAP_SINGLE
//     {
//         H5FD_MEM_SUPER,     /*default*/
//             H5FD_MEM_SUPER, /*super*/
//             H5FD_MEM_SUPER, /*btree*/
//             H5FD_MEM_SUPER, /*draw*/
//             H5FD_MEM_SUPER, /*gheap*/
//             H5FD_MEM_SUPER, /*lheap*/
//             H5FD_MEM_SUPER  /*ohdr*/
//     }

/*
 * A free-list map which segregates requests into `raw' or `meta' data
 * pools.
 */
// #define H5FD_FLMAP_DICHOTOMY
//     {
//         H5FD_MEM_SUPER,     /*default*/
//             H5FD_MEM_SUPER, /*super*/
//             H5FD_MEM_SUPER, /*btree*/
//             H5FD_MEM_DRAW,  /*draw*/
//             H5FD_MEM_DRAW,  /*gheap*/
//             H5FD_MEM_SUPER, /*lheap*/
//             H5FD_MEM_SUPER  /*ohdr*/
//     }

/*
 * The default free list map which causes each request type to use it's own
 * free-list.
 */
// #define H5FD_FLMAP_DEFAULT
//     {
//         H5FD_MEM_DEFAULT,     /*default*/
//             H5FD_MEM_DEFAULT, /*super*/
//             H5FD_MEM_DEFAULT, /*btree*/
//             H5FD_MEM_DEFAULT, /*draw*/
//             H5FD_MEM_DEFAULT, /*gheap*/
//             H5FD_MEM_DEFAULT, /*lheap*/
//             H5FD_MEM_DEFAULT  /*ohdr*/
//     }

/* Define VFL driver features that can be enabled on a per-driver basis */
/* These are returned with the 'query' function pointer in H5FD_class_t */
/*
 * Defining H5FD_FEAT_AGGREGATE_METADATA for a VFL driver means that
 * the library will attempt to allocate a larger block for metadata and
 * then sub-allocate each metadata request from that larger block.
 */
public static final int H5FD_FEAT_AGGREGATE_METADATA = 0x00000001;
/*
 * Defining H5FD_FEAT_ACCUMULATE_METADATA for a VFL driver means that
 * the library will attempt to cache metadata as it is written to the file
 * and build up a larger block of metadata to eventually pass to the VFL
 * 'write' routine.
 *
 * Distinguish between updating the metadata accumulator on writes and
 * reads.  This is particularly (perhaps only, even) important for MPI-I/O
 * where we guarantee that writes are collective, but reads may not be.
 * If we were to allow the metadata accumulator to be written during a
 * read operation, the application would hang.
 */
public static final int H5FD_FEAT_ACCUMULATE_METADATA_WRITE = 0x00000002;
public static final int H5FD_FEAT_ACCUMULATE_METADATA_READ =  0x00000004;
public static final int H5FD_FEAT_ACCUMULATE_METADATA =                                                                        
    (H5FD_FEAT_ACCUMULATE_METADATA_WRITE | H5FD_FEAT_ACCUMULATE_METADATA_READ);
/*
 * Defining H5FD_FEAT_DATA_SIEVE for a VFL driver means that
 * the library will attempt to cache raw data as it is read from/written to
 * a file in a "data seive" buffer.  See Rajeev Thakur's papers:
 *  http://www.mcs.anl.gov/~thakur/papers/romio-coll.ps.gz
 *  http://www.mcs.anl.gov/~thakur/papers/mpio-high-perf.ps.gz
 */
public static final int H5FD_FEAT_DATA_SIEVE = 0x00000008;
/*
 * Defining H5FD_FEAT_AGGREGATE_SMALLDATA for a VFL driver means that
 * the library will attempt to allocate a larger block for "small" raw data
 * and then sub-allocate "small" raw data requests from that larger block.
 */
public static final int H5FD_FEAT_AGGREGATE_SMALLDATA = 0x00000010;
/*
 * Defining H5FD_FEAT_IGNORE_DRVRINFO for a VFL driver means that
 * the library will ignore the driver info that is encoded in the file
 * for the VFL driver.  (This will cause the driver info to be eliminated
 * from the file when it is flushed/closed, if the file is opened R/W).
 */
public static final int H5FD_FEAT_IGNORE_DRVRINFO = 0x00000020;
/*
 * Defining the H5FD_FEAT_DIRTY_DRVRINFO_LOAD for a VFL driver means that
 * the library will mark the driver info dirty when the file is opened
 * R/W.  This will cause the driver info to be re-encoded when the file
 * is flushed/closed.
 */
public static final int H5FD_FEAT_DIRTY_DRVRINFO_LOAD = 0x00000040;
/*
 * Defining H5FD_FEAT_POSIX_COMPAT_HANDLE for a VFL driver means that
 * the handle for the VFD (returned with the 'get_handle' callback) is
 * of type 'int' and is compatible with POSIX I/O calls.
 */
public static final int H5FD_FEAT_POSIX_COMPAT_HANDLE = 0x00000080;
/*
 * Defining H5FD_FEAT_HAS_MPI for a VFL driver means that
 * the driver makes use of MPI communication and code may retrieve
 * communicator/rank information from it
 */
public static final int H5FD_FEAT_HAS_MPI = 0x00000100;
/*
 * Defining the H5FD_FEAT_ALLOCATE_EARLY for a VFL driver will force
 * the library to use the H5D_ALLOC_TIME_EARLY on dataset create
 * instead of the default H5D_ALLOC_TIME_LATE
 */
public static final int H5FD_FEAT_ALLOCATE_EARLY = 0x00000200;
/*
 * Defining H5FD_FEAT_ALLOW_FILE_IMAGE for a VFL driver means that
 * the driver is able to use a file image in the fapl as the initial
 * contents of a file.
 */
public static final int H5FD_FEAT_ALLOW_FILE_IMAGE = 0x00000400;
/*
 * Defining H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS for a VFL driver
 * means that the driver is able to use callbacks to make a copy of the
 * image to store in memory.
 */
public static final int H5FD_FEAT_CAN_USE_FILE_IMAGE_CALLBACKS = 0x00000800;
/*
 * Defining H5FD_FEAT_SUPPORTS_SWMR_IO for a VFL driver means that the
 * driver supports the single-writer/multiple-readers I/O pattern.
 */
public static final int H5FD_FEAT_SUPPORTS_SWMR_IO = 0x00001000;
/*
 * Defining H5FD_FEAT_USE_ALLOC_SIZE for a VFL driver
 * means that the library will just pass the allocation size to the
 * the driver's allocation callback which will eventually handle alignment.
 * This is specifically used for the multi/split driver.
 */
public static final int H5FD_FEAT_USE_ALLOC_SIZE = 0x00002000;
/*
 * Defining H5FD_FEAT_PAGED_AGGR for a VFL driver
 * means that the driver needs special file space mapping for paged aggregation.
 * This is specifically used for the multi/split driver.
 */
public static final int H5FD_FEAT_PAGED_AGGR = 0x00004000;
/*
 * Defining H5FD_FEAT_DEFAULT_VFD_COMPATIBLE for a VFL driver
 * that creates a file which is compatible with the default VFD.
 * Generally, this means that the VFD creates a single file that follows
 * the canonical HDF5 file format.
 * Regarding the Splitter VFD specifically, only drivers with this flag
 * enabled may be used as the Write-Only (W/O) channel driver.
 */
public static final int H5FD_FEAT_DEFAULT_VFD_COMPATIBLE = 0x00008000;

/* Forward declaration */
// Targeting ..\H5FD_class_t.java


// Targeting ..\H5FD_free_t.java


// Targeting ..\H5FD_t.java



/**
 * Define enum for the source of file image callbacks
 */
/** <!-- [H5FD_file_image_op_t_snip] --> */
/** enum H5FD_file_image_op_t */
public static final int
    H5FD_FILE_IMAGE_OP_NO_OP = 0,
    
/** Passed to the \p image_malloc and \p image_memcpy callbacks when a
     * file image buffer is to be copied while being set in a file access
     * property list (FAPL)*/
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET = 1,
    
/** Passed to the \p image_malloc and \p image_memcpy callbacks
     * when a file image buffer is to be copied when a FAPL is copied*/
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY = 2,
    
/**Passed to the \p image_malloc and \p image_memcpy callbacks when
     * a file image buffer is to be copied while being retrieved from a FAPL*/
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET = 3,
    
/**Passed to the \p image_free callback when a file image
     * buffer is to be released during a FAPL close operation*/
    H5FD_FILE_IMAGE_OP_PROPERTY_LIST_CLOSE = 4,
    
/**Passed to the \p image_malloc and
     * \p image_memcpy callbackswhen a
     * file image buffer is to be copied during a file open operation \n
     * While the file image being opened will typically be copied from a
     * FAPL, this need not always be the case. For example, the core file
     * driver, also known as the memory file driver, takes its initial
     * image from a file.*/
    H5FD_FILE_IMAGE_OP_FILE_OPEN = 5,
    
/**Passed to the \p image_realloc callback when a file driver needs
     * to resize an image buffer*/
    H5FD_FILE_IMAGE_OP_FILE_RESIZE = 6,
    
/**Passed to the \p image_free callback when an image buffer is to
     * be released during a file close operation*/
    H5FD_FILE_IMAGE_OP_FILE_CLOSE = 7;
// Targeting ..\H5FD_file_image_callbacks_t.java


/** <!-- [H5FD_file_image_callbacks_t_snip] --> */

// #ifdef __cplusplus
// #endif

/* Function prototypes */
public static native @Cast("hid_t") long H5FDregister(@Const H5FD_class_t cls);
public static native @Cast("herr_t") int H5FDunregister(@Cast("hid_t") long driver_id);
public static native H5FD_t H5FDopen(@Cast("const char*") BytePointer name, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id, @Cast("haddr_t") long maxaddr);
public static native H5FD_t H5FDopen(String name, @Cast("unsigned") int flags, @Cast("hid_t") long fapl_id, @Cast("haddr_t") long maxaddr);
public static native @Cast("herr_t") int H5FDclose(H5FD_t file);
public static native int H5FDcmp(@Const H5FD_t f1, @Const H5FD_t f2);
public static native int H5FDquery(@Const H5FD_t f, @Cast("unsigned long*") CLongPointer flags);
public static native @Cast("haddr_t") long H5FDalloc(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5FDfree(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id, @Cast("haddr_t") long addr, @Cast("hsize_t") long size);
public static native @Cast("haddr_t") long H5FDget_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDset_eoa(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("haddr_t") long eoa);
public static native @Cast("haddr_t") long H5FDget_eof(H5FD_t file, @Cast("H5FD_mem_t") int type);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") long fapl, @Cast("void**") PointerPointer file_handle);
public static native @Cast("herr_t") int H5FDget_vfd_handle(H5FD_t file, @Cast("hid_t") long fapl, @Cast("void**") @ByPtrPtr Pointer file_handle);
public static native @Cast("herr_t") int H5FDread(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id, @Cast("haddr_t") long addr, @Cast("size_t") long size,
                        Pointer buf);
public static native @Cast("herr_t") int H5FDwrite(H5FD_t file, @Cast("H5FD_mem_t") int type, @Cast("hid_t") long dxpl_id, @Cast("haddr_t") long addr, @Cast("size_t") long size,
                         @Const Pointer buf);
public static native @Cast("herr_t") int H5FDflush(H5FD_t file, @Cast("hid_t") long dxpl_id, @Cast("hbool_t") boolean closing);
public static native @Cast("herr_t") int H5FDtruncate(H5FD_t file, @Cast("hid_t") long dxpl_id, @Cast("hbool_t") boolean closing);
public static native @Cast("herr_t") int H5FDlock(H5FD_t file, @Cast("hbool_t") boolean rw);
public static native @Cast("herr_t") int H5FDunlock(H5FD_t file);

/* Allows querying a VFD ID for features before the file is opened */
public static native @Cast("herr_t") int H5FDdriver_query(@Cast("hid_t") long driver_id, @Cast("unsigned long*") CLongPointer flags);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from H5Gpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5Gpublic.h
 *                      Jul 11 1997
 *                      Robb Matzke
 *
 * Purpose:             Public declarations for the H5G package
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5Gpublic_H
// #define H5Gpublic_H

/* System headers needed by this file */
// #include <sys/types.h>

/* Public headers needed by this file */
// #include "H5public.h"  /* Generic Functions			*/
// #include "H5Lpublic.h" /* Links                                */
// #include "H5Opublic.h" /* Object headers			*/
// #include "H5Tpublic.h" /* Datatypes				*/

/*****************/
/* Public Macros */
/*****************/

/*******************/
/* Public Typedefs */
/*******************/

/** <!-- [H5G_storage_t_snip] -->
/**
 * Types of link storage for groups
 */
/** enum H5G_storage_type_t */
public static final int
    /** Unknown link storage type	*/
    H5G_STORAGE_TYPE_UNKNOWN = -1,
    /** Links in group are stored with a "symbol table" */
/** (this is sometimes called "old-style" groups) */
    H5G_STORAGE_TYPE_SYMBOL_TABLE = 0,
    /** Links are stored in object header */
    H5G_STORAGE_TYPE_COMPACT = 1,
    /** Links are stored in fractal heap & indexed with v2 B-tree */
    H5G_STORAGE_TYPE_DENSE = 2;
// Targeting ..\H5G_info_t.java


/** <!-- [H5G_info_t_snip] -->
<p>
/********************/
/* Public Variables */
/********************/

/*********************/
/* Public Prototypes */
/*********************/
// #ifdef __cplusplus */
// #endif

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Creates a new group and links it into the file
 *
 * \fgdta_loc_id
 * @param name [in]      Name of the group to create
 * \lcpl_id
 * \gcpl_id
 * \gapl_id
 *
 * @return \hid_t{group}
 *
 * \details H5Gcreate2() creates a new group in a file. After a
 *          group has been created, links to datasets and to other groups
 *          can be added.
 *
 *          The \p loc_id and \p name parameters specify where the group
 *          is located. \p loc_id may be a file, group, dataset, named
 *          datatype or attribute in the file. If an attribute, dataset,
 *          or named datatype is specified for \p loc_id then the group
 *          will be created at the location where the attribute, dataset,
 *          or named datatype is attached. \p name is the link to the group;
 *          \p name may be either an absolute path in the file (the links
 *          from the root group to the new group) or a relative path from
 *          \p loc_id (the link(s) from the group specified by \p loc_id
 *          to the new group).
 *
 *          \p lcpl_id, \p gcpl_id, and \p gapl_id are property list
 *          identifiers. These property lists govern how the link to the
 *          group is created, how the group is created, and how the group
 *          can be accessed in the future, respectively. #H5P_DEFAULT can
 *          be passed in if the default properties are appropriate for
 *          these property lists. Currently, there are no APIs for the
 *          group access property list; use #H5P_DEFAULT.
 *
 *          The group identifier should be closed by H5Gclose() when access
 *          is no longer required to prevent resource leaks.
 *
 * @since 1.8.0
 *
 * @see H5Gopen2(), H5Gclose()
 *
 */
public static native @Cast("hid_t") long H5Gcreate2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gcreate2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long lcpl_id, @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Creates a new empty group without linking it into the file structure
 *
 * \fgdta_loc_id
 * \gcpl_id
 * \gapl_id
 *
 * @return \hid_t{group}
 *
 * \details H5Gcreate_anon() creates a new empty group in the file
 *          specified by \p loc_id. With default settings, H5Gcreate_anon()
 *          provides similar functionality to that provided by
 *          H5Gcreate1(), with the differences described in the list below.
 *
 *          The new group’s creation and access properties are specified
 *          in \p gcpl_id and \p gapl_id, respectively.
 *
 *          H5Gcreate_anon() returns a new group identifier. This identifier
 *          must be linked into the HDF5 file structure with H5Olink()
 *          or it will be deleted from the file when the file is closed.
 *
 *          The differences between this function and H5Gcreate1() are
 *          as follows:
 *
 *          \li H5Gcreate1() does not provide for the use of custom property
 *              lists; H5Gcreate1() always uses default properties.
 *          \li H5Gcreate_anon() neither provides the new group’s name
 *              nor links it into the HDF5 file structure; those actions
 *              must be performed separately through a call to H5Olink(),
 *              which offers greater control over linking.
 *          \li H5Gcreate_anon() does not directly provide a hint mechanism
 *              for the group’s heap size. Comparable information can be
 *              included in the group creation property list \p gcpl_id through
 *              a H5Pset_local_heap_size_hint() call.
 *
 *          A group created with this function should be closed with
 *          H5Gclose() when the group is no longer needed so that resource
 *          leaks will not develop.
 *
 * @see H5Olink(), H5Dcreate(), Using Identifiers
 *
 * @since 1.8.0
 *
 */
public static native @Cast("hid_t") long H5Gcreate_anon(@Cast("hid_t") long loc_id, @Cast("hid_t") long gcpl_id, @Cast("hid_t") long gapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Opens an existing group in a file
 *
 * \fgdta_loc_id
 * @param name [in]      Name of the group to open
 * \gapl_id
 *
 * @return \hid_t{group}
 *
 * \details H5Gopen2() opens an existing group, \p name, at the location
 *          specified by \p loc_id.
 *
 *          With default settings, H5Gopen2() provides similar functionality
 *          to that provided by H5Gopen(). The only difference is that
 *          H5Gopen2() can provide a group access property list, \p gapl_id.
 *
 *          H5Gopen2() returns a group identifier for the group that was
 *          opened. This group identifier should be released by H5Gclose()
 *          when it is no longer needed to prevent resource leaks.
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("hid_t") long H5Gopen2(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, @Cast("hid_t") long gapl_id);
public static native @Cast("hid_t") long H5Gopen2(@Cast("hid_t") long loc_id, String name, @Cast("hid_t") long gapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Gets a group creation property list identifier
 *
 * \group_id
 *
 * @return \hid_t{creation property list}
 *
 * \details H5Gget_create_plist() returns an identifier for the group creation
 *          property list associated with the group specified by \p group_id.
 *
 *          The creation property list identifier should be released with
 *          H5Gclose() to prevent resource leaks.
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("hid_t") long H5Gget_create_plist(@Cast("hid_t") long group_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Retrieves information about a group
 *
 * \fgdta_loc_id
 * @param ginfo [out] Struct in which group information is returned
 *
 * @return \hid_t{group}
 *
 * \details H5Gget_info() retrieves information about the group at location
 *          specified by \p loc_id. The information is returned in the \p ginfo.
 *
 *          \p ginfo is an H5G_info_t struct and is defined (in H5Gpublic.h)
 *          as follows:
 *
 * \snippet this H5G_info_t_snip
 * Possible values of \p storage_type are:
 * \storage_type
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("herr_t") int H5Gget_info(@Cast("hid_t") long loc_id, H5G_info_t ginfo);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Retrieves information about a group by its name
 *
 * \fgdta_loc_id
 * @param name [in]      Name of the group to query
 * @param ginfo [out] Struct in which group information is returned
 * \lapl_id
 *
 * @return \herr_t
 *
 * \details H5Gget_info_by_name() retrieves information about the group \p name
 *          at location specified by \p loc_id. The information is returned in
 *          the \p ginfo struct.
 *
 *          If \p loc_id specifies the group for which information is queried,
 *          then the group's \p name can be a dot (.).
 *
 *          \p ginfo is an H5G_info_t struct and is defined (in H5Gpublic.h)
 *          as follows:
 *
 * \snippet this H5G_info_t_snip
 * Possible values of \p storage_type are:
 * \storage_type
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer name, H5G_info_t ginfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_name(@Cast("hid_t") long loc_id, String name, H5G_info_t ginfo, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Retrieves information about a group, according to the group’s
 *        position within an index
 *
 * \fgdta_loc_id
 * @param group_name [in] Name of the group to query
 * @param idx_type [in]   Transient index identifying object
 * @param order [in]      Transient index identifying object
 * @param n [in]          Position in the index of the group to query
 * @param ginfo [out]     Struct in which group information is returned
 * \lapl_id
 *
 * @return Returns
 *      \li The size of the object name if successful, or
 *      \li 0 if no name is associated with the group identifier, or
 *      \li negative value, if failure occurred
 *
 * \details H5Gget_info_by_idx() retrieves the same information
 *          about a group as retrieved by the function H5Gget_info(),
 *          but the means of identifying the group differs; the group is
 *          identified by position in an index rather than by name.
 *
 *          \p loc_id and \p group_name specify the group containing
 *          the group for which information is sought. The groups in \p
 *          group_name are indexed by \p idx_type; the group for which
 *          information is retrieved is identified in that index by index
 *          order, \p order, and index position, \p n.
 *
 *          If \p loc_id specifies the group containing the group for
 *          which information is queried, \p group_name can be a dot (.).
 *
 *          Valid values for \p index_type are as follows:
 * \indexes
 *          The order in which the index is to be examined, as specified
 *          by \p order, can be one of the following:
 * \orders
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") long loc_id, @Cast("const char*") BytePointer group_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo, @Cast("hid_t") long lapl_id);
public static native @Cast("herr_t") int H5Gget_info_by_idx(@Cast("hid_t") long loc_id, String group_name, @Cast("H5_index_t") int idx_type,
                                 @Cast("H5_iter_order_t") int order, @Cast("hsize_t") long n, H5G_info_t ginfo, @Cast("hid_t") long lapl_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Flushes all buffers associated with a group to disk
 *
 * \group_id
 *
 * @return \herr_t
 *
 * \details H5Gflush() causes all buffers associated with a group to be
 *          immediately flushed to disk without removing the data from
 *          the cache.
 *
 * \attention
 *          HDF5 does not possess full control over buffering. H5G_FLUSH
 *          flushes the internal HDF5 buffers and then asks the operating
 *          system (the OS) to flush the system buffers for the open
 *          files. After that, the OS is responsible for ensuring that
 *          the data is actually flushed to disk.
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("herr_t") int H5Gflush(@Cast("hid_t") long group_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Refreshes all buffers associated with a group
 *
 * \group_id
 *
 * @return \herr_t
 *
 * \details H5Grefresh() causes all buffers associated with a group to be
 *          cleared and immediately re-loaded with updated contents from disk.
 *
 *          This function essentially closes the group, evicts all
 *          metadata associated with it from the cache, and then re-opens
 *          the group. The reopened group is automatically re-registered
 *          with the same identifier.
 *
 * @since 1.8.0
 *
 * @see H5Gcreate2(), H5Gclose()
 *
 */
public static native @Cast("herr_t") int H5Grefresh(@Cast("hid_t") long group_id);

/**
 *-------------------------------------------------------------------------
 * \ingroup H5G
 *
 * \brief Closes the specified group
 *
 * \group_id
 *
 * @return \herr_t
 *
 * \details H5Gclose() releases resources used by a group which was
 *          opened by H5Gcreate() or H5Gopen().  After closing a group,
 *          \p group_id cannot be used again until another H5Gcreate()
 *          or H5Gopen() is called on it.
 *
 *          Failure to release a group with this call will result in
 *          resource leaks.
 *
 * \par Example
 * \snippet H5F_examples.c mount
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Gclose(@Cast("hid_t") long group_id);

/* Symbols defined for compatibility with previous versions of the HDF5 API.
 *
 * Use of these symbols is deprecated.
 */
// #ifndef H5_NO_DEPRECATED_SYMBOLS

// #endif /* H5_NO_DEPRECATED_SYMBOLS */

// #ifdef __cplusplus
// #endif
// #endif /* H5Gpublic_H */


// Parsed from H5MMpublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*-------------------------------------------------------------------------
 *
 * Created:             H5MMpublic.h
 *                      Jul 10 1997
 *                      Robb Matzke
 *
 * Purpose:             Public declarations for the H5MM (memory management)
 *                      package.
 *
 *-------------------------------------------------------------------------
 */
// #ifndef H5MMpublic_H
// #define H5MMpublic_H

/* Public headers needed by this file */
// #include "H5public.h"
// Targeting ..\H5MM_allocate_t.java


// Targeting ..\H5MM_free_t.java


/** <!-- [H5MM_free_t_snip] --> */

// #ifdef __cplusplus
// #endif

// #ifdef __cplusplus
// #endif
// #endif /* H5MMpublic_H */


// Parsed from H5Ppublic.h

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This file contains function prototypes for each exported function in the
 * H5P module.
 */
// #ifndef H5Ppublic_H
// #define H5Ppublic_H

/* System headers needed by this file */

/* Public headers needed by this file */
// #include "H5public.h"
// #include "H5ACpublic.h" /* Metadata cache                           */
// #include "H5Dpublic.h"  /* Datasets                                 */
// #include "H5Fpublic.h"  /* Files                                    */
// #include "H5FDpublic.h" /* File drivers                             */
// #include "H5Ipublic.h"  /* ID management                            */
// #include "H5Lpublic.h"  /* Links                                    */
// #include "H5MMpublic.h" /* Memory management                        */
// #include "H5Opublic.h"  /* Object headers                           */
// #include "H5Spublic.h"  /* Dataspaces                               */
// #include "H5Tpublic.h"  /* Datatypes                                */
// #include "H5Zpublic.h"  /* Data filters                             */

/*****************/
/* Public Macros */
/*****************/

/* When this header is included from a private HDF5 header, don't make calls to H5open() */
// #undef H5OPEN
// #ifndef H5private_H
// #define H5OPEN H5open(),
// #else /* H5private_H */
// #define H5OPEN
// #endif /* H5private_H */

/*
 * The library's property list classes
 */

public static native @MemberGetter int H5P_ROOT();
public static final int H5P_ROOT = H5P_ROOT();
public static native @MemberGetter int H5P_OBJECT_CREATE();
public static final int H5P_OBJECT_CREATE = H5P_OBJECT_CREATE();
public static native @MemberGetter int H5P_FILE_CREATE();
public static final int H5P_FILE_CREATE = H5P_FILE_CREATE();
public static native @MemberGetter int H5P_FILE_ACCESS();
public static final int H5P_FILE_ACCESS = H5P_FILE_ACCESS();
public static native @MemberGetter int H5P_DATASET_CREATE();
public static final int H5P_DATASET_CREATE = H5P_DATASET_CREATE();
public static native @MemberGetter int H5P_DATASET_ACCESS();
public static final int H5P_DATASET_ACCESS = H5P_DATASET_ACCESS();
public static native @MemberGetter int H5P_DATASET_XFER();
public static final int H5P_DATASET_XFER = H5P_DATASET_XFER();
public static native @MemberGetter int H5P_FILE_MOUNT();
public static final int H5P_FILE_MOUNT = H5P_FILE_MOUNT();
public static native @MemberGetter int H5P_GROUP_CREATE();
public static final int H5P_GROUP_CREATE = H5P_GROUP_CREATE();
public static native @MemberGetter int H5P_GROUP_ACCESS();
public static final int H5P_GROUP_ACCESS = H5P_GROUP_ACCESS();
public static native @MemberGetter int H5P_DATATYPE_CREATE();
public static final int H5P_DATATYPE_CREATE = H5P_DATATYPE_CREATE();
public static native @MemberGetter int H5P_DATATYPE_ACCESS();
public static final int H5P_DATATYPE_ACCESS = H5P_DATATYPE_ACCESS();
public static native @MemberGetter int H5P_MAP_CREATE();
public static final int H5P_MAP_CREATE = H5P_MAP_CREATE();
public static native @MemberGetter int H5P_MAP_ACCESS();
public static final int H5P_MAP_ACCESS = H5P_MAP_ACCESS();
public static native @MemberGetter int H5P_STRING_CREATE();
public static final int H5P_STRING_CREATE = H5P_STRING_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE();
public static final int H5P_ATTRIBUTE_CREATE = H5P_ATTRIBUTE_CREATE();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS();
public static final int H5P_ATTRIBUTE_ACCESS = H5P_ATTRIBUTE_ACCESS();
public static native @MemberGetter int H5P_OBJECT_COPY();
public static final int H5P_OBJECT_COPY = H5P_OBJECT_COPY();
public static native @MemberGetter int H5P_LINK_CREATE();
public static final int H5P_LINK_CREATE = H5P_LINK_CREATE();
public static native @MemberGetter int H5P_LINK_ACCESS();
public static final int H5P_LINK_ACCESS = H5P_LINK_ACCESS();
public static native @MemberGetter int H5P_VOL_INITIALIZE();
public static final int H5P_VOL_INITIALIZE = H5P_VOL_INITIALIZE();
public static native @MemberGetter int H5P_REFERENCE_ACCESS();
public static final int H5P_REFERENCE_ACCESS = H5P_REFERENCE_ACCESS();

/*
 * The library's default property lists
 */
public static native @MemberGetter int H5P_FILE_CREATE_DEFAULT();
public static final int H5P_FILE_CREATE_DEFAULT = H5P_FILE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_FILE_ACCESS_DEFAULT();
public static final int H5P_FILE_ACCESS_DEFAULT = H5P_FILE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_CREATE_DEFAULT();
public static final int H5P_DATASET_CREATE_DEFAULT = H5P_DATASET_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATASET_ACCESS_DEFAULT();
public static final int H5P_DATASET_ACCESS_DEFAULT = H5P_DATASET_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATASET_XFER_DEFAULT();
public static final int H5P_DATASET_XFER_DEFAULT = H5P_DATASET_XFER_DEFAULT();
public static native @MemberGetter int H5P_FILE_MOUNT_DEFAULT();
public static final int H5P_FILE_MOUNT_DEFAULT = H5P_FILE_MOUNT_DEFAULT();
public static native @MemberGetter int H5P_GROUP_CREATE_DEFAULT();
public static final int H5P_GROUP_CREATE_DEFAULT = H5P_GROUP_CREATE_DEFAULT();
public static native @MemberGetter int H5P_GROUP_ACCESS_DEFAULT();
public static final int H5P_GROUP_ACCESS_DEFAULT = H5P_GROUP_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_CREATE_DEFAULT();
public static final int H5P_DATATYPE_CREATE_DEFAULT = H5P_DATATYPE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_DATATYPE_ACCESS_DEFAULT();
public static final int H5P_DATATYPE_ACCESS_DEFAULT = H5P_DATATYPE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_MAP_CREATE_DEFAULT();
public static final int H5P_MAP_CREATE_DEFAULT = H5P_MAP_CREATE_DEFAULT();
public static native @MemberGetter int H5P_MAP_ACCESS_DEFAULT();
public static final int H5P_MAP_ACCESS_DEFAULT = H5P_MAP_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_CREATE_DEFAULT();
public static final int H5P_ATTRIBUTE_CREATE_DEFAULT = H5P_ATTRIBUTE_CREATE_DEFAULT();
public static native @MemberGetter int H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static final int H5P_ATTRIBUTE_ACCESS_DEFAULT = H5P_ATTRIBUTE_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_OBJECT_COPY_DEFAULT();
public static final int H5P_OBJECT_COPY_DEFAULT = H5P_OBJECT_COPY_DEFAULT();
public static native @MemberGetter int H5P_LINK_CREATE_DEFAULT();
public static final int H5P_LINK_CREATE_DEFAULT = H5P_LINK_CREATE_DEFAULT();
public static native @MemberGetter int H5P_LINK_ACCESS_DEFAULT();
public static final int H5P_LINK_ACCESS_DEFAULT = H5P_LINK_ACCESS_DEFAULT();
public static native @MemberGetter int H5P_VOL_INITIALIZE_DEFAULT();
public static final int H5P_VOL_INITIALIZE_DEFAULT = H5P_VOL_INITIALIZE_DEFAULT();
public static native @MemberGetter int H5P_REFERENCE_ACCESS_DEFAULT();
public static final int H5P_REFERENCE_ACCESS_DEFAULT = H5P_REFERENCE_ACCESS_DEFAULT();

/* Common creation order flags (for links in groups and attributes on objects) */
public static final int H5P_CRT_ORDER_TRACKED = 0x0001;
public static final int H5P_CRT_ORDER_INDEXED = 0x0002;

/**
 * Default value of type \ref hid_t for all property list classes
 */
public static native @MemberGetter int H5P_DEFAULT();
public static final int H5P_DEFAULT = H5P_DEFAULT(); /* (hid_t) */

// #ifdef __cplusplus
// Targeting ..\H5P_cls_create_func_t.java


// Targeting ..\H5P_cls_copy_func_t.java


// Targeting ..\H5P_cls_close_func_t.java


// Targeting ..\H5P_prp_cb1_t.java


// Targeting ..\H5P_prp_cb2_t.java


/** <!-- [H5P_prp_cb2_t_snip] --> */
// Targeting ..\H5P_prp_encode_func_t.java


// Targeting ..\H5P_prp_decode_func_t.java


/** <!-- [H5P_prp_decode_func_t_snip] --> */
// Targeting ..\H5P_prp_compare_func_t.java


/** <!-- [H5P_prp_compare_func_t_snip] --> */
// Targeting ..\H5P_iterate_t.java


/** <!-- [H5P_iterate_t_snip] -->
 <p>
 *  <!--[H5D_mpio_actual_chunk_opt_mode_t_snip] -->
/**
 * Actual IO mode property
 *
 * \details The default value, #H5D_MPIO_NO_CHUNK_OPTIMIZATION, is used for all
 *          I/O operations that do not use chunk optimizations, including
 *          non-collective I/O and contiguous collective I/O.
 */
/** enum H5D_mpio_actual_chunk_opt_mode_t */
public static final int
    
/** No chunk optimization was performed. Either no collective I/O was
        attempted or the dataset wasn't chunked. */
    H5D_MPIO_NO_CHUNK_OPTIMIZATION = 0,
    
/** Collective I/O is performed on all chunks simultaneously. */
    H5D_MPIO_LINK_CHUNK = 1,
    
/** Each chunk was individually assigned collective or independent I/O based
         on what fraction of processes access the chunk. If the fraction is greater
         than the multi chunk ratio threshold, collective I/O is performed on that
         chunk. The multi chunk ratio threshold can be set using
         H5Pset_dxpl_mpio_chunk_opt_ratio(). The default value is 60%. */
    H5D_MPIO_MULTI_CHUNK = 2;
/** <!--[H5D_mpio_actual_chunk_opt_mode_t_snip] -->
 <p>
 *  <!-- [H5D_mpio_actual_io_mode_t_snip] -->
/**
 * The following values are conveniently defined as a bit field so that
 * we can switch from the default to independent or collective and then to
 * mixed without having to check the original value.
 */
/** enum H5D_mpio_actual_io_mode_t */
public static final int
    
/** No collective I/O was performed. Collective I/O was not requested or
         collective I/O isn't possible on this dataset */
    H5D_MPIO_NO_COLLECTIVE = 0x0,
    
/** HDF5 performed one the chunk collective optimization schemes and each
         chunk was accessed independently */
    H5D_MPIO_CHUNK_INDEPENDENT = 0x1,
    
/** HDF5 performed one the chunk collective optimization schemes and each
         chunk was accessed collectively */
    H5D_MPIO_CHUNK_COLLECTIVE = 0x2,
    
/** HDF5 performed one the chunk collective optimization schemes and some
         chunks were accessed independently, some collectively. */
    H5D_MPIO_CHUNK_MIXED = 0x1 | 0x2,
    /** \internal The contiguous case is separate from the bit field. */
    
/** Collective I/O was performed on a contiguous dataset */
    H5D_MPIO_CONTIGUOUS_COLLECTIVE = 0x4;
/** <!-- [H5D_mpio_actual_io_mode_t_snip] -->
 <p>
 *  <!-- [H5D_mpio_no_collective_cause_t_snip] -->
/**
 * Broken collective IO property
 */
/** enum H5D_mpio_no_collective_cause_t */
public static final int
    
/** Collective I/O was performed successfully */
    H5D_MPIO_COLLECTIVE = 0x00,
    
/** Collective I/O was not performed because independent I/O was requested */
    H5D_MPIO_SET_INDEPENDENT = 0x01,
    
/** Collective I/O was not performed because datatype conversions were required */
    H5D_MPIO_DATATYPE_CONVERSION = 0x02,
    
/** Collective I/O was not performed because data transforms needed to be applied */
    H5D_MPIO_DATA_TRANSFORMS = 0x04,
    
/** Collective I/O was disabled by environment variable (\Code{HDF5_MPI_OPT_TYPES}) */
    H5D_MPIO_MPI_OPT_TYPES_ENV_VAR_DISABLED = 0x08,
    
/** Collective I/O was not performed because one of the dataspaces was neither simple nor scalar */
    H5D_MPIO_NOT_SIMPLE_OR_SCALAR_DATASPACES = 0x10,
    
/** Collective I/O was not performed because the dataset was neither contiguous nor chunked */
    H5D_MPIO_NOT_CONTIGUOUS_OR_CHUNKED_DATASET = 0x20,
    
/** Collective I/O was not performed because parallel filtered writes are disabled */
    H5D_MPIO_PARALLEL_FILTERED_WRITES_DISABLED = 0x40,
    
/** Error */
    H5D_MPIO_ERROR_WHILE_CHECKING_COLLECTIVE_POSSIBLE = 0x80,
    
/** Sentinel */
    H5D_MPIO_NO_COLLECTIVE_MAX_CAUSE = 0x100;
/** <!-- [H5D_mpio_no_collective_cause_t_snip] -->
<p>
/********************/
/* Public Variables */
/********************/

/* Property list class IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") long H5P_CLS_ROOT_ID_g(); public static native void H5P_CLS_ROOT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_OBJECT_CREATE_ID_g(); public static native void H5P_CLS_OBJECT_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_CREATE_ID_g(); public static native void H5P_CLS_FILE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_ACCESS_ID_g(); public static native void H5P_CLS_FILE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_CREATE_ID_g(); public static native void H5P_CLS_DATASET_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_ACCESS_ID_g(); public static native void H5P_CLS_DATASET_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATASET_XFER_ID_g(); public static native void H5P_CLS_DATASET_XFER_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_FILE_MOUNT_ID_g(); public static native void H5P_CLS_FILE_MOUNT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_GROUP_CREATE_ID_g(); public static native void H5P_CLS_GROUP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_GROUP_ACCESS_ID_g(); public static native void H5P_CLS_GROUP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATATYPE_CREATE_ID_g(); public static native void H5P_CLS_DATATYPE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_DATATYPE_ACCESS_ID_g(); public static native void H5P_CLS_DATATYPE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_MAP_CREATE_ID_g(); public static native void H5P_CLS_MAP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_MAP_ACCESS_ID_g(); public static native void H5P_CLS_MAP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_STRING_CREATE_ID_g(); public static native void H5P_CLS_STRING_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_CLS_ATTRIBUTE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_CLS_ATTRIBUTE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_OBJECT_COPY_ID_g(); public static native void H5P_CLS_OBJECT_COPY_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_LINK_CREATE_ID_g(); public static native void H5P_CLS_LINK_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_LINK_ACCESS_ID_g(); public static native void H5P_CLS_LINK_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_VOL_INITIALIZE_ID_g(); public static native void H5P_CLS_VOL_INITIALIZE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_CLS_REFERENCE_ACCESS_ID_g(); public static native void H5P_CLS_REFERENCE_ACCESS_ID_g(long setter);

/* Default roperty list IDs */
/* (Internal to library, do not use!  Use macros above) */
public static native @Cast("hid_t") long H5P_LST_FILE_CREATE_ID_g(); public static native void H5P_LST_FILE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_FILE_ACCESS_ID_g(); public static native void H5P_LST_FILE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_CREATE_ID_g(); public static native void H5P_LST_DATASET_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_ACCESS_ID_g(); public static native void H5P_LST_DATASET_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATASET_XFER_ID_g(); public static native void H5P_LST_DATASET_XFER_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_FILE_MOUNT_ID_g(); public static native void H5P_LST_FILE_MOUNT_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_GROUP_CREATE_ID_g(); public static native void H5P_LST_GROUP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_GROUP_ACCESS_ID_g(); public static native void H5P_LST_GROUP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATATYPE_CREATE_ID_g(); public static native void H5P_LST_DATATYPE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_DATATYPE_ACCESS_ID_g(); public static native void H5P_LST_DATATYPE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_MAP_CREATE_ID_g(); public static native void H5P_LST_MAP_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_MAP_ACCESS_ID_g(); public static native void H5P_LST_MAP_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_ATTRIBUTE_CREATE_ID_g(); public static native void H5P_LST_ATTRIBUTE_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_ATTRIBUTE_ACCESS_ID_g(); public static native void H5P_LST_ATTRIBUTE_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_OBJECT_COPY_ID_g(); public static native void H5P_LST_OBJECT_COPY_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_LINK_CREATE_ID_g(); public static native void H5P_LST_LINK_CREATE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_LINK_ACCESS_ID_g(); public static native void H5P_LST_LINK_ACCESS_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_VOL_INITIALIZE_ID_g(); public static native void H5P_LST_VOL_INITIALIZE_ID_g(long setter);
public static native @Cast("hid_t") long H5P_LST_REFERENCE_ACCESS_ID_g(); public static native void H5P_LST_REFERENCE_ACCESS_ID_g(long setter);

/*********************/
/* Public Prototypes */
/*********************/

/* Generic property list routines */

/**
 * \ingroup GPLO
 *
 * \brief Terminates access to a property list
 *
 * \plist_id
 *
 * @return \herr_t
 *
 * \details H5Pclose() terminates access to a property list. All property
 *          lists should be closed when the application is finished
 *          accessing them. This frees resources used by the property
 *          list.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pclose(@Cast("hid_t") long plist_id);
/**
 * \ingroup GPLOA
 *
 * \brief Closes an existing property list class
 *
 * \plistcls_id{plist_id}
 *
 * @return \herr_t
 *
 * \details H5Pclose_class() removes a property list class from the library.
 *          Existing property lists of this class will continue to exist,
 *          but new ones are not able to be created.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Pclose_class(@Cast("hid_t") long plist_id);
/**
 * \ingroup GPLO
 *
 * \brief Copies an existing property list to create a new property list
 *
 * \plist_id
 *
 * @return \hid_t{property list}
 *
 * \details H5Pcopy() copies an existing property list to create a new
 *          property list. The new property list has the same properties
 *          and values as the original property list.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("hid_t") long H5Pcopy(@Cast("hid_t") long plist_id);
/**
 * \ingroup GPLOA
 *
 * \brief Copies a property from one list or class to another
 *
 * @param dst_id [in] Identifier of the destination property list or class
 * @param src_id [in] Identifier of the source property list or class
 * @param name [in] Name of the property to copy
 *
 * @return \herr_t
 *
 * \details H5Pcopy_prop() copies a property from one property list or
 *          class to another.
 *
 *          If a property is copied from one class to another, all the
 *          property information will be first deleted from the destination
 *          class and then the property information will be copied from the
 *          source class into the destination class.
 *
 *          If a property is copied from one list to another, the property
 *          will be first deleted from the destination list (generating a
 *          call to the close callback for the property, if one exists)
 *          and then the property is copied from the source list to the
 *          destination list (generating a call to the copy callback for
 *          the property, if one exists).
 *
 *          If the property does not exist in the class or list, this
 *          call is equivalent to calling H5Pregister() or H5Pinsert() (for
 *          a class or list, as appropriate) and the create callback will
 *          be called in the case of the property being copied into a list
 *          (if such a callback exists for the property).
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") long dst_id, @Cast("hid_t") long src_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Pcopy_prop(@Cast("hid_t") long dst_id, @Cast("hid_t") long src_id, String name);
/**
 * \ingroup GPLO
 *
 * \brief Creates a new property list as an instance of a property list class
 *
 * \plistcls_id{cls_id}
 *
 * @return \hid_t{property list}
 *
 * \details H5Pcreate() creates a new property list as an instance of
 *          some property list class. The new property list is initialized
 *          with default values for the specified class. The classes are as
 *          follows:
 *
 * <table>
 *   <tr>
 *     <th>Class Identifier</th>
 *     <th>Class Name</th>
 *     <th>Comments</th>
 *   </tr>
 *   <tr>
 *     <td>#H5P_ATTRIBUTE_CREATE</td>
 *     <td>attribute create</td>
 *     <td>Properties for attribute creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_DATASET_ACCESS</td>
 *     <td>dataset access</td>
 *     <td>Properties for dataset access</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_DATASET_CREATE</td>
 *     <td>dataset create</td>
 *     <td>Properties for dataset creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_DATASET_XFER</td>
 *     <td>data transfer</td>
 *     <td>Properties for raw data transfer</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_DATATYPE_ACCESS</td>
 *     <td>datatype access</td>
 *     <td>Properties for datatype access</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_DATATYPE_CREATE</td>
 *     <td>datatype create</td>
 *     <td>Properties for datatype creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_FILE_ACCESS</td>
 *     <td>file access</td>
 *     <td>Properties for file access</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_FILE_CREATE</td>
 *     <td>file create</td>
 *     <td>Properties for file creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_FILE_MOUNT</td>
 *     <td>file mount</td>
 *     <td>Properties for file mounting</td>
 *   </tr>
 *   <tr valign="top">
 *     <td>#H5P_GROUP_ACCESS</td>
 *     <td>group access</td>
 *     <td>Properties for group access</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_GROUP_CREATE</td>
 *     <td>group create</td>
 *     <td>Properties for group creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_LINK_ACCESS</td>
 *     <td>link access</td>
 *     <td>Properties governing link traversal when accessing objects</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_LINK_CREATE</td>
 *     <td>link create</td>
 *     <td>Properties governing link creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_OBJECT_COPY</td>
 *     <td>object copy</td>
 *     <td>Properties governing the object copying process</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_OBJECT_CREATE</td>
 *     <td>object create</td>
 *     <td>Properties for object creation</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_STRING_CREATE</td>
 *     <td>string create</td>
 *     <td>Properties for character encoding when encoding strings or
 *       object names</td>
 *   </tr>
 *   <tr>
 *     <td>#H5P_VOL_INITIALIZE</td>
 *     <td>vol initialize</td>
 *     <td>Properties for VOL initialization</td>
 *   </tr>
 * </table>
 *
 * This property list must eventually be closed with H5Pclose();
 * otherwise, errors are likely to occur.
 *
 * @version 1.12.0 The #H5P_VOL_INITIALIZE property list class was added
 * @version 1.8.15 For each class, the class name returned by
 *                 H5Pget_class_name() was added.
 *                 The list of possible Fortran values was updated.
 * @version 1.8.0 The following property list classes were added at this
 *                release: #H5P_DATASET_ACCESS, #H5P_GROUP_CREATE,
 *                #H5P_GROUP_ACCESS, #H5P_DATATYPE_CREATE,
 *                #H5P_DATATYPE_ACCESS, #H5P_ATTRIBUTE_CREATE
 *
 * @since 1.0.0
 *
 */
public static native @Cast("hid_t") long H5Pcreate(@Cast("hid_t") long cls_id);
/**
 * \ingroup GPLOA
 *
 * \brief Creates a new property list class
 *
 * \plistcls_id{parent}
 * @param name [in]        Name of property list class to register
 * @param create [in]      Callback routine called when a property list is
 *                        created
 * @param create_data [in] Pointer to user-defined class create data, to be
 *                        passed along to class create callback
 * @param copy [in]        Callback routine called when a property list is
 *                        copied
 * @param copy_data [in]   Pointer to user-defined class copy data, to be
 *                        passed along to class copy callback
 * @param close [in]       Callback routine called when a property list is
 *                        being closed
 * @param close_data [in]  Pointer to user-defined class close data, to be
 *                        passed along to class close callback
 *
 * @return \hid_t{property list class}
 *
 * \details H5Pcreate_class() registers a new property list class with the
 *          library. The new property list class can inherit from an
 *          existing property list class, \p parent, or may be derived
 *          from the default “empty” class, NULL. New classes with
 *          inherited properties from existing classes may not remove
 *          those existing properties, only add or remove their own class
 *          properties. Property list classes defined and supported in the
 *          HDF5 library distribution are listed and briefly described in
 *          H5Pcreate(). The \p create, \p copy, \p close functions are called
 *          when a property list of the new class is created, copied, or closed,
 *          respectively.
 *
 *          H5Pclose_class() must be used to release the property list class
 *          identifier returned by this function.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("hid_t") long H5Pcreate_class(@Cast("hid_t") long parent, @Cast("const char*") BytePointer name, H5P_cls_create_func_t create, Pointer create_data,
                             H5P_cls_copy_func_t copy, Pointer copy_data, H5P_cls_close_func_t _close,
                             Pointer close_data);
public static native @Cast("hid_t") long H5Pcreate_class(@Cast("hid_t") long parent, String name, H5P_cls_create_func_t create, Pointer create_data,
                             H5P_cls_copy_func_t copy, Pointer copy_data, H5P_cls_close_func_t _close,
                             Pointer close_data);
/**
 * \ingroup GPLO
 *
 * \brief Decodes property list received in a binary object buffer and
 *        returns a new property list identifier
 *
 * @param buf [in] Buffer holding the encoded property list
 *
 * @return \hid_tv{object}
 *
 * \details Given a binary property list description in a buffer, H5Pdecode()
 *          reconstructs the HDF5 property list and returns an identifier
 *          for the new property list. The binary description of the property
 *          list is encoded by H5Pencode().
 *
 *          The user is responsible for passing in the correct buffer.
 *
 *          The property list identifier returned by this function should be
 *          released with H5Pclose() when the identifier is no longer needed
 *          so that resource leaks will not develop.
 *
 * \note Some properties cannot be encoded and therefore will not be available
 *       in the decoded property list. These properties are discussed in
 *       H5Pencode().
 *
 * @since 1.10.0
 *
 */
public static native @Cast("hid_t") long H5Pdecode(@Const Pointer buf);
/**
 * \ingroup GPLO
 *
 * \brief Encodes the property values in a property list into a binary
 *        buffer
 *
 * \plist_id
 * @param buf [out]    Buffer into which the property list will be encoded.
 *                    If the provided buffer is NULL, the size of the
 *                    buffer required is returned through \p nalloc; the
 *                    function does nothing more.
 * @param nalloc [out] The size of the required buffer
 * \fapl_id
 *
 * @return \herr_t
 *
 * \details H5Pencode2() encodes the property list \p plist_id into the
 *          binary buffer \p buf, according to the file format setting
 *          specified by the file access property list \p fapl_id.
 *
 *          If the required buffer size is unknown, \p buf can be passed
 *          in as NULL and the function will set the required buffer size
 *          in \p nalloc. The buffer can then be created and the property
 *          list encoded with a subsequent H5Pencode2() call.
 *
 *          If the buffer passed in is not big enough to hold the encoded
 *          properties, the H5Pencode2() call can be expected to fail with
 *          a segmentation fault.
 *
 *          The file access property list \p fapl_id is used to
 *          control the encoding via the \a libver_bounds property
 *          (see H5Pset_libver_bounds()). If the \a libver_bounds
 *          property is missing, H5Pencode2() proceeds as if the \a
 *          libver_bounds property were set to (#H5F_LIBVER_EARLIEST,
 *          #H5F_LIBVER_LATEST). (Functionally, H5Pencode1() is identical to
 *          H5Pencode2() with \a libver_bounds set to (#H5F_LIBVER_EARLIEST,
 *          #H5F_LIBVER_LATEST).)
 *          Properties that do not have encode callbacks will be skipped.
 *          There is currently no mechanism to register an encode callback for
 *          a user-defined property, so user-defined properties cannot currently
 *          be encoded.
 *
 *          Some properties cannot be encoded, particularly properties that are
 *          reliant on local context.
 *
 *      \b Motivation:
 *       This function was introduced in HDF5-1.12 as part of the \a H5Sencode
 *       format change to enable 64-bit selection encodings and a dataspace
 *       selection that is tied to a file.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Pencode2(@Cast("hid_t") long plist_id, Pointer buf, @Cast("size_t*") SizeTPointer nalloc, @Cast("hid_t") long fapl_id);
/**
 * \ingroup GPLOA
 *
 * \brief Compares two property lists or classes for equality
 *
 * @param id [in] 1 First property object to be compared
 * @param id [in] 2 Second property object to be compared
 *
 * @return \htri_t
 *
 * \details H5Pequal() compares two property lists or classes to determine
 *          whether they are equal to one another.
 *
 *          Either both \p id1 and \p id2 must be property lists or both
 *          must be classes; comparing a list to a class is an error.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("htri_t") int H5Pequal(@Cast("hid_t") long id1, @Cast("hid_t") long id2);
/**
 * \ingroup GPLOA
 *
 * \brief Queries whether a property name exists in a property list or
 *       class
 *
 * @param plist_id [in]   Identifier for the property list or class to query
 * @param name [in]       Name of property to check for
 *
 * @return \htri_t
 *
 * \details  H5Pexist() determines whether a property exists within a
 *           property list or class.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("htri_t") int H5Pexist(@Cast("hid_t") long plist_id, String name);
/**
 * \ingroup GPLOA
 *
 * \brief Queries the value of a property
 *
 * \plist_id
 * @param name [in]  Name of property to query
 * @param value [out] Pointer to a location to which to copy the value of
 *                   the property
 *
 * @return \herr_t
 *
 * \details H5Pget() retrieves a copy of the value for a property in a
 *          property list. If there is a \p get callback routine registered
 *          for this property, the copy of the value of the property will
 *          first be passed to that routine and any changes to the copy of
 *          the value will be used when returning the property value from
 *          this routine.
 *
 *          This routine may be called for zero-sized properties with the
 *          \p value set to NULL. The \p get routine will be called with
 *          a NULL value if the callback exists.
 *
 *          The property name must exist or this routine will fail.
 *
 *          If the \p get callback routine returns an error, \ value will
 *          not be modified.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, Pointer value);
public static native @Cast("herr_t") int H5Pget(@Cast("hid_t") long plist_id, String name, Pointer value);
/**
 *\ingroup GPLO
 *
 * \brief Returns the property list class identifier for a property list
 *
 * \plist_id
 *
 * @return \hid_t{property list class}
 *
 * \details H5Pget_class() returns the property list class identifier for
 *          the property list identified by the \p plist_id parameter.
 *
 *          Note that H5Pget_class() returns a value of #hid_t type, an
 *          internal HDF5 identifier, rather than directly returning a
 *          property list class. That identifier can then be used with
 *          either H5Pequal() or H5Pget_class_name() to determine which
 *          predefined HDF5 property list class H5Pget_class() has returned.
 *
 *          A full list of valid predefined property list classes appears
 *          in the description of H5Pcreate().
 *
 *          Determining the HDF5 property list class name with H5Pequal()
 *          requires a series of H5Pequal() calls in an if-else sequence.
 *          An iterative sequence of H5Pequal() calls can compare the
 *          identifier returned by H5Pget_class() to members of the list of
 *          valid property list class names. A pseudo-code snippet might
 *          read as follows:
 *
 *          <pre>{@code
 *          plist_class_id = H5Pget_class (dsetA_plist);
 *
 *          if H5Pequal (plist_class_id, H5P_OBJECT_CREATE) = TRUE;
 *              [ H5P_OBJECT_CREATE is the property list class    ]
 *              [ returned by H5Pget_class.                        ]
 *
 *          else if H5Pequal (plist_class_id, H5P_DATASET_CREATE) = TRUE;
 *              [ H5P_DATASET_CREATE is the property list class.  ]
 *
 *          else if H5Pequal (plist_class_id, H5P_DATASET_XFER) = TRUE;
 *              [ H5P_DATASET_XFER is the property list class.    ]
 *
 *          .
 *          .   [ Continuing the iteration until a match is found. ]
 *          .
 *          }</pre>
 *
 *          H5Pget_class_name() returns the property list class name directly
 *          as a string:
 *
 *          <pre>{@code
 *          plist_class_id = H5Pget_class (dsetA_plist);
 *          plist_class_name = H5Pget_class_name (plist_class_id)
 *          }</pre>
 *
 *          Note that frequent use of H5Pget_class_name() can become a
 *          performance problem in a high-performance environment. The
 *          H5Pequal() approach is generally much faster.
 *
 * @version 1.6.0 Return type changed in this release.
 * @since 1.0.0
 *
 */
public static native @Cast("hid_t") long H5Pget_class(@Cast("hid_t") long plist_id);
/**
 * \ingroup GPLOA
 *
 * \brief Retrieves the name of a class
 *
 * \plistcls_id{pclass_id}
 *
 * @return Returns a pointer to an allocated string containing the class
 *         name if successful, and NULL if not successful.
 *
 * \details H5Pget_class_name() retrieves the name of a generic property
 *          list class. The pointer to the name must be freed by the user
 *          with a call to H5free_memory() after each successful call.
 *
 *          <table>
 *           <tr>
 *            <th>Class Name (class identifier) Returned</th>
 *            <th>Property List Class</th>
 *            <th>Expanded Name of the Property List Class</th>
 *            <th>The Class Identifier Used with H5Pcreate</th>
 *            <th>Comments</th>
 *           </tr>
 *           <tr>
 *            <td>attribute create</td>
 *            <td>acpl</td>
 *            <td>Attribute Creation Property List</td>
 *            <td>H5P_ATTRIBUTE_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>dataset access</td>
 *            <td>dapl</td>
 *            <td>Dataset Access Property List</td>
 *            <td>H5P_DATASET_ACCESS</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>dataset create</td>
 *            <td>dcpl</td>
 *            <td>Dataset Creation Property List</td>
 *            <td>H5P_DATASET_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>data transfer</td>
 *            <td>dxpl</td>
 *            <td>Data Transfer Property List</td>
 *            <td>H5P_DATASET_XFER</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>datatype access</td>
 *            <td> </td>
 *            <td> </td>
 *            <td>H5P_DATATYPE_ACCESS</td>
 *            <td>This class can be created, but there are no properties
 *                in the class currently.
 *            </td>
 *           </tr>
 *           <tr>
 *            <td>datatype create</td>
 *            <td> </td>
 *            <td> </td>
 *            <td>H5P_DATATYPE_CREATE</td>
 *            <td>This class can be created, but there
 *                are no properties in the class currently.</td>
 *           </tr>
 *           <tr>
 *            <td>file access</td>
 *            <td>fapl</td>
 *            <td>File Access Property List</td>
 *            <td>H5P_FILE_ACCESS</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>file create</td>
 *            <td>fcpl</td>
 *            <td>File Creation Property List</td>
 *            <td>H5P_FILE_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>file mount</td>
 *            <td>fmpl</td>
 *            <td>File Mount Property List</td>
 *            <td>H5P_FILE_MOUNT</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>group access</td>
 *            <td> </td>
 *            <td> </td>
 *            <td>H5P_GROUP_ACCESS</td>
 *            <td>This class can be created, but there
 *                are no properties in the class currently.</td>
 *           </tr>
 *           <tr>
 *            <td>group create</td>
 *            <td>gcpl</td>
 *            <td>Group Creation Property List</td>
 *            <td>H5P_GROUP_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *             <td>link access</td>
 *             <td>lapl</td>
 *             <td>Link Access Property List</td>
 *             <td>H5P_LINK_ACCESS</td>
 *             <td> </td>
 *           </tr>
 *           <tr>
 *            <td>link create</td>
 *            <td>lcpl</td>
 *            <td>Link Creation Property List</td>
 *            <td>H5P_LINK_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>object copy</td>
 *            <td>ocpypl</td>
 *            <td>Object Copy Property List</td>
 *            <td>H5P_OBJECT_COPY</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>object create</td>
 *            <td>ocpl</td>
 *            <td>Object Creation Property List</td>
 *            <td>H5P_OBJECT_CREATE</td>
 *            <td> </td>
 *           </tr>
 *           <tr>
 *            <td>string create</td>
 *            <td>strcpl</td>
 *            <td>String Creation Property List</td>
 *            <td>H5P_STRING_CREATE</td>
 *            <td> </td>
 *           </tr>
 *          </table>
 *
 * @since 1.4.0
 *
 */
public static native @Cast("char*") BytePointer H5Pget_class_name(@Cast("hid_t") long pclass_id);
/**
 * \ingroup GPLOA
 *
 * \brief Retrieves the parent class of a property class
 *
 * \plistcls_id{pclass_id}
 *
 * @return \hid_t{parent class object}
 *
 * \details H5Pget_class_parent() retrieves an identifier for the parent
 *          class of a property class.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("hid_t") long H5Pget_class_parent(@Cast("hid_t") long pclass_id);
/**
 * \ingroup GPLOA
 *
 * \brief  Queries the number of properties in a property list or class
 *
 * @param id [in]     Identifier for property object to query
 * @param nprops [out] Number of properties in object
 *
 * @return \herr_t
 *
 * \details H5Pget_nprops() retrieves the number of properties in a
 *          property list or property list class.
 *
 *          If \p id is a property list identifier, the current number of
 *          properties in the list is returned in \p nprops.
 *
 *          If \p id is a property list class identifier, the number of
 *          registered properties in the class is returned in \p nprops.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Pget_nprops(@Cast("hid_t") long id, @Cast("size_t*") SizeTPointer nprops);
/**
 * \ingroup GPLOA
 *
 * \brief Queries the size of a property value in bytes
 *
 * @param id [in]   Identifier of property object to query
 * @param name [in] Name of property to query
 * @param size [out] Size of property in bytes
 *
 * @return  \herr_t
 *
 * \details H5Pget_size() retrieves the size of a property's value in
 *          bytes. This function operates on both property lists and
 *          property classes.
 *
 *          Zero-sized properties are allowed and return 0.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") long id, @Cast("const char*") BytePointer name, @Cast("size_t*") SizeTPointer size);
public static native @Cast("herr_t") int H5Pget_size(@Cast("hid_t") long id, String name, @Cast("size_t*") SizeTPointer size);
/**
 * \ingroup GPLOA
 *
 * \brief Registers a temporary property with a property list
 *
 * \plist_id
 * @param name [in]    Name of property to create
 * @param size [in]    Size of property in bytes
 * @param value [in]   Initial value for the property
 * @param set [in]     Callback routine called before a new value is copied
 *                    into the property's value
 * @param get [in]     Callback routine called when a property value is
 *                    retrieved from the property
 * @param prp_del [in] Callback routine called when a property is deleted
 *                    from a property list
 * @param copy [in]    Callback routine called when a property is copied
 *                    from an existing property list
 * @param compare [in] Callback routine called when a property is compared
 *                    with another property list
 * @param close [in]   Callback routine called when a property list is
 *                    being closed and the property value will be disposed
 *                    of
 *
 * @return \herr_t
 *
 * \details H5Pinsert2() creates a new property in a property
 *          list. The property will exist only in this property list and
 *          copies made from it.
 *
 *          The initial property value must be provided in \p value and
 *          the property value will be set accordingly.
 *
 *          The name of the property must not already exist in this list,
 *          or this routine will fail.
 *
 *          The \p set and \p get callback routines may be set to NULL
 *          if they are not needed.
 *
 *          Zero-sized properties are allowed and do not store any data
 *          in the property list. The default value of a zero-size
 *          property may be set to NULL. They may be used to indicate the
 *          presence or absence of a particular piece of information.
 *
 *          The \p set routine is called before a new value is copied
 *          into the property. The #H5P_prp_set_func_t callback function
 *          is defined as follows:
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list being
 *                modified</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being modified</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *             <td>\Code{void * value}</td>
 *             <td>IN: Pointer to new value pointer for the property
 *                 being modified</td>
 *           </tr>
 *          </table>
 *
 *          The \p set routine may modify the value pointer to be set and
 *          those changes will be used when setting the property's value.
 *          If the \p set routine returns a negative value, the new property
 *          value is not copied into the property and the \p  set routine
 *          returns an error value. The \p set routine will be called for
 *          the initial value.
 *
 *          \b Note: The \p set callback function may be useful to range
 *          check the value being set for the property or may perform some
 *          transformation or translation of the value set. The \p get
 *          callback would then reverse the transformation or translation.
 *          A single \p get or \p set callback could handle multiple
 *          properties by performing different actions based on the
 *          property name or other properties in the property list.
 *
 *          The \p get routine is called when a value is retrieved from
 *          a property value. The #H5P_prp_get_func_t callback function
 *          is defined as follows:
 *
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to the above callback function are:
 *
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list being queried</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being queried</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t  size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void *  value}</td>
 *            <td>IN: The value of the property being returned</td>
 *           </tr>
 *          </table>
 *
 *          The \p get routine may modify the value to be returned from
 *          the query and those changes will be preserved. If the \p get
 *          routine returns a negative value, the query routine returns
 *          an error value.
 *
 *          The \p prp_del routine is called when a property is being
 *          deleted from a property list. The #H5P_prp_delete_func_t
 *          callback function is defined as follows:
 *
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to the above callback function are:
 *
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list the property is
 *                being deleted from</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property in the list</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN: The value for the property being deleted</td>
 *           </tr>
 *          </table>
 *
 *          The \p prp_del routine may modify the value passed in, but the
 *          value is not used by the library when the \p prp_del routine
 *          returns. If the \p prp_del routine returns a negative value,
 *          the property list \p prp_del routine returns an error value but
 *          the property is still deleted.
 *
 *          The \p copy routine is called when a new property list with
 *          this property is being created through a \p copy operation.
 *
 *          The #H5P_prp_copy_func_t callback function is defined as follows:
 *
 *          \snippet this H5P_prp_cb1_t_snip
 *
 *          The parameters to the above callback function are:
 *          <table>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being copied</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN/OUT: The value for the property being copied</td>
 *           </tr>
 *          </table>
 *
 *          The \p copy routine may modify the value to be set and those
 *          changes will be stored as the new value of the property. If the
 *          \p copy routine returns a negative value, the new property value
 *          is not copied into the property and the copy routine returns an
 *          error value.
 *
 *          The \p compare routine is called when a property list with this
 *          property is compared to another property list with the same
 *          property.
 *
 *          The #H5P_prp_compare_func_t callback function is defined as
 *          follows:
 *
 *          \snippet this H5P_prp_compare_func_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const void * value1}</td>
 *            <td>IN: The value of the first property to compare</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const void * value2}</td>
 *            <td>IN: The value of the second property to compare</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *          </table>
 *
 *          The \p compare routine may not modify the values. The \p compare
 *          routine should return a positive value if \p value1 is greater
 *          than \p value2, a negative value if \p value2 is greater than
 *          \p value1 and zero if \p value1 and \p value2 are equal.
 *
 *          The \p close routine is called when a property list with this
 *          property is being closed.
 *
 *          The #H5P_prp_close_func_t callback function is defined as follows:
 *          \snippet this H5P_prp_cb1_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property in the list</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN: The value for the property being closed</td>
 *           </tr>
 *          </table>
 *
 *          The \p close routine may modify the value passed in, the
 *          value is not used by the library when the close routine
 *          returns. If the \p close routine returns a negative value,
 *          the property list \p close routine returns an error value
 *          but the property list is still closed.
 *
 *          \b Note: There is no \p create callback routine for temporary
 *          property list objects; the initial value is assumed to
 *          have any necessary setup already performed on it.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size, Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t set,
                         @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t get, @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t copy,
                         H5P_prp_compare_func_t compare, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t _close);
public static native @Cast("herr_t") int H5Pinsert2(@Cast("hid_t") long plist_id, String name, @Cast("size_t") long size, Pointer value, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t set,
                         @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t get, @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t copy,
                         H5P_prp_compare_func_t compare, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t _close);
/**
 * \ingroup GPLOA
 *
 * \brief Determines whether a property list is a member of a class
 *
 * \plist_id
 * \plistcls_id{pclass_id}
 *
 * @return \htri_t
 *
 * \details H5Pisa_class() checks to determine whether the property list
 *          \p plist_id is a member of the property list class
 *          \p pclass_id.
 *
 * @see H5Pcreate()
 *
 * @since  1.6.0
 *
 */
public static native @Cast("htri_t") int H5Pisa_class(@Cast("hid_t") long plist_id, @Cast("hid_t") long pclass_id);
/**
 * \ingroup GPLOA
 *
 * \brief Iterates over properties in a property class or list
 *
 * @param id [in]  Identifier of property object to iterate over
 * @param idx [in,out] Index of the property to begin with
 * @param iter_func [in]  Function pointer to function to be called
 *                           with each property iterated over
 * @param iter_data [in,out]  Pointer to iteration data from user
 *
 * @return On success: the return value of the last call to \p iter_func if
 *         it was non-zero; zero if all properties have been processed.
 *         On Failure, a negative value
 *
 * \details H5Piterate() iterates over the properties in the property
 *          object specified in \p id, which may be either a property
 *          list or a property class, performing a specified operation
 *          on each property in turn.
 *
 *          For each property in the object, \p iter_func and the
 *          additional information specified below are passed to the
 *          #H5P_iterate_t operator function.
 *
 *          The iteration begins with the \p idx-th property in the
 *          object; the next element to be processed by the operator
 *          is returned in \p idx. If \p idx is NULL, the iterator
 *          starts at the first property; since no stopping point is
 *          returned in this case, the iterator cannot be restarted if
 *          one of the calls to its operator returns non-zero.
 *
 *          The operation \p iter_func receives the property list or class
 *          identifier for the object being iterated over, \p id, the
 *          name of the current property within the object, \p name,
 *          and the pointer to the operator data passed in to H5Piterate(),
 *          \p iter_data.
 *
 *          H5Piterate() assumes that the properties in the object
 *          identified by \p id remain unchanged through the iteration.
 *          If the membership changes during the iteration, the function's
 *          behavior is undefined.
 *
 * @since 1.4.0
 *
 */
public static native int H5Piterate(@Cast("hid_t") long id, IntPointer idx, H5P_iterate_t iter_func, Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") long id, IntBuffer idx, H5P_iterate_t iter_func, Pointer iter_data);
public static native int H5Piterate(@Cast("hid_t") long id, int[] idx, H5P_iterate_t iter_func, Pointer iter_data);
/**
 * \ingroup GPLOA
 *
 * \brief Registers a permanent property with a property list class
 *
 * \plistcls_id{cls_id}
 * @param name [in]       Name of property to register
 * @param size [in]       Size of property in bytes
 * @param def_value [in]  Default value for property in newly created
 *                       property lists
 * @param create [in]     Callback routine called when a property list is
 *                       being created and the property value will be
 *                       initialized
 * @param set [in]        Callback routine called before a new value is
 *                       copied into the property's value
 * @param get [in]        Callback routine called when a property value is
 *                       retrieved from the property
 * @param prp_del [in]    Callback routine called when a property is deleted
 *                       from a property list
 * @param copy [in]       Callback routine called when a property is copied
 *                       from a property list
 * @param compare [in]    Callback routine called when a property is compared
 *                       with another property list
 * @param close [in]      Callback routine called when a property list is
 *                       being closed and the property value will be
 *                       disposed of
 *
 * @return  \herr_t
 *
 * \details H5Pregister2() registers a new property with a property list
 *          class. The \p cls_id identifier can be obtained by calling
 *          H5Pcreate_class(). The property will exist in all property
 *          list objects of \p cl_id created after this routine finishes. The
 *          name of the property must not already exist, or this routine
 *          will fail. The default property value must be provided and all
 *          new property lists created with this property will have the
 *          property value set to the default value. Any of the callback
 *          routines may be set to NULL if they are not needed.
 *
 *          Zero-sized properties are allowed and do not store any data in
 *          the property list. These may be used as flags to indicate the
 *          presence or absence of a particular piece of information. The
 *          default pointer for a zero-sized property may be set to NULL.
 *          The property \p create and \p close callbacks are called for
 *          zero-sized properties, but the \p set and \p get callbacks are
 *          never called.
 *
 *          The \p create routine is called when a new property list with
 *          this property is being created. The #H5P_prp_create_func_t
 *          callback function is defined as follows:
 *
 *          \snippet this H5P_prp_cb1_t_snip
 *
 *          The parameters to this callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being modified</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN/OUT: The default value for the property being created,
 *                which will be passed to H5Pregister2()</td>
 *           </tr>
 *          </table>
 *
 *          The \p create routine may modify the value to be set and those
 *          changes will be stored as the initial value of the property.
 *          If the \p create routine returns a negative value, the new
 *          property value is not copied into the property and the
 *          \p create routine returns an error value.
 *
 *          The \p set routine is called before a new value is copied into
 *          the property. The #H5P_prp_set_func_t callback function is defined
 *          as follows:
 *
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to this callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list being modified</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being modified</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void *value}</td>
 *            <td>IN/OUT: Pointer to new value pointer for the property
 *                being modified</td>
 *           </tr>
 *          </table>
 *
 *          The \p set routine may modify the value pointer to be set and
 *          those changes will be used when setting the property's value.
 *          If the \p set routine returns a negative value, the new property
 *          value is not copied into the property and the \p set routine
 *          returns an error value. The \p set routine will not be called
 *          for the initial value; only the \p create routine will be called.
 *
 *          \b Note: The \p set callback function may be useful to range
 *          check the value being set for the property or may perform some
 *          transformation or translation of the value set. The \p get
 *          callback would then reverse the transformation or translation.
 *          A single \p get or \p set callback could handle multiple
 *          properties by performing different actions based on the property
 *          name or other properties in the property list.
 *
 *          The \p get routine is called when a value is retrieved from a
 *          property value. The #H5P_prp_get_func_t callback function is
 *          defined as follows:
 *
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list being
 *                queried</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being queried</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN/OUT: The value of the property being returned</td>
 *           </tr>
 *          </table>
 *
 *          The \p get routine may modify the value to be returned from the
 *          query and those changes will be returned to the calling routine.
 *          If the \p set routine returns a negative value, the query
 *          routine returns an error value.
 *
 *          The \p prp_del routine is called when a property is being
 *          deleted from a property list. The #H5P_prp_delete_func_t
 *          callback function is defined as follows:
 *
 *          \snippet this H5P_prp_cb2_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\ref hid_t \c prop_id</td>
 *            <td>IN: The identifier of the property list the property is
 *                being deleted from</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property in the list</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN: The value for the property being deleted</td>
 *           </tr>
 *          </table>
 *
 *          The \p prp_del routine may modify the value passed in, but the
 *          value is not used by the library when the \p prp_del routine
 *          returns. If the \p prp_del routine returns a negative value,
 *          the property list  delete routine returns an error value but
 *          the property is still deleted.
 *
 *          The \p copy routine is called when a new property list with
 *          this property is being created through a \p copy operation.
 *          The #H5P_prp_copy_func_t callback function is defined as follows:
 *
 *          \snippet this H5P_prp_cb1_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property being copied</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN/OUT: The value for the property being copied</td>
 *           </tr>
 *          </table>
 *
 *          The \p copy routine may modify the value to be set and those
 *          changes will be stored as the new value of the property. If
 *          the \p copy routine returns a negative value, the new
 *          property value is not copied into the property and the \p copy
 *          routine returns an error value.
 *
 *          The \p compare routine is called when a property list with this
 *          property is compared to another property list with the same
 *          property. The #H5P_prp_compare_func_t callback function is
 *          defined as follows:
 *
 *          \snippet this H5P_prp_compare_func_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const void * value1}</td>
 *            <td>IN: The value of the first property to compare</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{const void * value2}</td>
 *            <td>IN: The value of the second property to compare</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *          </table>
 *
 *          The \p compare routine may not modify the values. The \p compare
 *          routine should return a positive value if \p value1 is greater
 *          than \p value2, a negative value if \p value2 is greater than
 *          \p value1 and zero if \p value1 and \p value2 are equal.
 *
 *          The \p close routine is called when a property list with this
 *          property is being closed. The #H5P_prp_close_func_t callback
 *          function is defined as follows:
 *
 *          \snippet this H5P_prp_cb1_t_snip
 *
 *          The parameters to the callback function are defined as follows:
 *
 *          <table>
 *           <tr>
 *            <td>\Code{const char * name}</td>
 *            <td>IN: The name of the property in the list</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{size_t size}</td>
 *            <td>IN: The size of the property in bytes</td>
 *           </tr>
 *           <tr>
 *            <td>\Code{void * value}</td>
 *            <td>IN: The value for the property being closed</td>
 *           </tr>
 *          </table>
 *
 *          The \p close routine may modify the value passed in, but the
 *          value is not used by the library when the \p close routine returns.
 *          If the \p close routine returns a negative value, the property
 *          list close routine returns an error value but the property list is
 *          still closed.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") long cls_id, @Cast("const char*") BytePointer name, @Cast("size_t") long size, Pointer def_value,
                           @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t create, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t get,
                           @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t copy,
                           H5P_prp_compare_func_t compare, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t _close);
public static native @Cast("herr_t") int H5Pregister2(@Cast("hid_t") long cls_id, String name, @Cast("size_t") long size, Pointer def_value,
                           @Cast("H5P_prp_create_func_t") H5P_prp_cb1_t create, @Cast("H5P_prp_set_func_t") H5P_prp_cb2_t set, @Cast("H5P_prp_get_func_t") H5P_prp_cb2_t get,
                           @Cast("H5P_prp_delete_func_t") H5P_prp_cb2_t prp_del, @Cast("H5P_prp_copy_func_t") H5P_prp_cb1_t copy,
                           H5P_prp_compare_func_t compare, @Cast("H5P_prp_close_func_t") H5P_prp_cb1_t _close);
/**
 * \ingroup GPLOA
 *
 * \brief Removes a property from a property list
 *
 * \plist_id
 * @param name [in] Name of property to remove
 *
 * @return \herr_t
 *
 * \details H5Premove() removes a property from a property list. Both
 *          properties which were in existence when the property list was
 *          created (i.e. properties registered with H5Pregister()) and
 *          properties added to the list after it was created (i.e. added
 *          with H5Pinsert1() may be removed from a property list.
 *          Properties do not need to be removed from a property list
 *          before the list itself is closed; they will be released
 *          automatically when H5Pclose() is called.
 *
 *          If a \p close callback exists for the removed property, it
 *          will be called before the property is released.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Premove(@Cast("hid_t") long plist_id, String name);
/**
 * \ingroup GPLOA
 *
 * \brief Sets a property list value
 *
 * \plist_id
 * @param name [in]  Name of property to modify
 * @param value [in] Pointer to value to set the property to
 *
 * @return \herr_t
 *
 * \details H5Pset() sets a new value for a property in a property list.
 *          If there is a \p set callback routine registered for this
 *          property, the \p value will be passed to that routine and any
 *          changes to the \p value will be used when setting the property
 *          value. The information pointed to by the \p value pointer
 *          (possibly modified by the \p set callback) is copied into the
 *          property list value and may be changed by the application
 *          making the H5Pset() call without affecting the property value.
 *
 *          The property name must exist or this routine will fail.
 *
 *          If the \p set callback routine returns an error, the property
 *          value will not be modified.
 *
 *          This routine may not be called for zero-sized properties and
 *          will return an error in that case.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Const Pointer value);
public static native @Cast("herr_t") int H5Pset(@Cast("hid_t") long plist_id, String name, @Const Pointer value);
/**
 * \ingroup GPLOA
 *
 * \brief Removes a property from a property list class
 *
 * \plistcls_id{pclass_id}
 * @param name [in] Name of property to remove
 *
 * @return \herr_t
 *
 * \details H5Punregister() removes a property from a property list class.
 *          Future property lists created of that class will not contain
 *          this property; existing property lists containing this property
 *          are not affected.
 *
 * @since 1.4.0
 *
 */
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") long pclass_id, @Cast("const char*") BytePointer name);
public static native @Cast("herr_t") int H5Punregister(@Cast("hid_t") long pclass_id, String name);

/* Object creation property list (OCPL) routines */

/**
 * \ingroup DCPL
 *
 * \brief Verifies that all required filters are available
 *
 * \plist_id
 *
 * @return \htri_t
 *
 * \details H5Pall_filters_avail() verifies that all of the filters set in
 *         the dataset or group creation property list \p plist_id are
 *         currently available.
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 * @since 1.6.0
 *
 */
public static native @Cast("htri_t") int H5Pall_filters_avail(@Cast("hid_t") long plist_id);
/**
 * \ingroup OCPL
 *
 * \brief Retrieves tracking and indexing settings for attribute creation
 *        order
 *
 * \plist_id
 * @param crt_order_flags [out] Flags specifying whether to track and
 *             index attribute creation order
 *
 * @return \herr_t
 *
 * \details H5Pget_attr_creation_order() retrieves the settings for
 *          tracking and indexing attribute creation order on an object.
 *
 *          \p plist_id is an object creation property list (\p ocpl),
 *          as it can be a dataset or group creation property list
 *          identifier. The term \p ocpl is used when different types
 *          of objects may be involved.
 *
 *          \p crt_order_flags returns flags with the following meanings:
 *
 *          <table>
 *           <tr>
 *            <td>#H5P_CRT_ORDER_TRACKED</td>
 *            <td>Attribute creation order is tracked but not necessarily
 *                indexed.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5P_CRT_ORDER_INDEXED </td>
 *            <td>Attribute creation order is indexed (requires
 *                #H5P_CRT_ORDER_TRACKED).</td>
 *           </tr>
 *          </table>
 *
 *          If \p crt_order_flags is returned with a value of 0 (zero),
 *          attribute creation order is neither tracked nor indexed.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_order_flags);
/**
 * \ingroup OCPL
 *
 * \brief Retrieves attribute storage phase change thresholds
 *
 * \plist_id
 * @param max_compact [out] Maximum number of attributes to be stored in
 *                         compact storage (Default: 8)
 * @param min_dense [out]   Minimum number of attributes to be stored in
 *                         dense storage (Default: 6)
 *
 * @return \herr_t
 *
 * \details H5Pget_attr_phase_change() retrieves threshold values for
 *          attribute storage on an object. These thresholds determine the
 *          point at which attribute storage changes from compact storage
 *          (i.e., storage in the object header) to dense storage (i.e.,
 *          storage in a heap and indexed with a B-tree).
 *
 *          In the general case, attributes are initially kept in compact
 *          storage. When the number of attributes exceeds \p max_compact,
 *          attribute storage switches to dense storage. If the number of
 *          attributes subsequently falls below \p min_dense, the
 *          attributes are returned to compact storage.
 *
 *          If \p max_compact is set to 0 (zero), dense storage always used.
 *
 *          \p plist_id is an object creation property list (\p ocpl), as it
 *          can be a dataset or group creation property list identifier.
 *          The term \p ocpl is used when different types of objects may be
 *          involved.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_compact, @Cast("unsigned*") IntPointer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer max_compact, @Cast("unsigned*") IntBuffer min_dense);
public static native @Cast("herr_t") int H5Pget_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] max_compact, @Cast("unsigned*") int[] min_dense);
/**
 * \ingroup OCPL
 *
 * \brief Returns information about a filter in a pipeline
 *
 * \ocpl_id{plist_id}
 * @param idx [in]    Sequence number within the filter pipeline of the filter
 *                   for which information is sought
 * @param flags [out] Bit vector specifying certain general properties of the
 *                   filter
 * @param cd_nelmts [in,out] Number of elements in \p cd_values
 * @param cd_values [out] Auxiliary data for the filter
 * @param namelen [in]   Anticipated number of characters in \p name
 * @param name [out]      Name of the filter
 * @param filter_config [out] Bit field, as described in H5Zget_filter_info()
 *
 * @return Returns a negative value on failure, and the filter identifier
 *         if successful (see #H5Z_filter_t):
 *         - #H5Z_FILTER_DEFLATE     Data compression filter,
 *                                    employing the gzip algorithm
 *         - #H5Z_FILTER_SHUFFLE     Data shuffling filter
 *         - #H5Z_FILTER_FLETCHER32  Error detection filter, employing the
 *                                     Fletcher32 checksum algorithm
 *         - #H5Z_FILTER_SZIP        Data compression filter, employing the
 *                                     SZIP algorithm
 *         - #H5Z_FILTER_NBIT        Data compression filter, employing the
 *                                     N-bit algorithm
 *         - #H5Z_FILTER_SCALEOFFSET Data compression filter, employing the
 *                                     scale-offset algorithm
 *
 * \details H5Pget_filter2() returns information about a filter specified by
 *          its filter number, in a filter pipeline specified by the property
 *          list with which it is associated.
 *
 *          \p plist_id must be a dataset or group creation property list.
 *
 *          \p idx is a value between zero and N-1, as described in
 *          H5Pget_nfilters(). The function will return a negative value if
 *          the filter number is out of range.
 *
 *          The structure of the \p flags argument is discussed in
 *          H5Pset_filter().
 *
 *          On input, \p cd_nelmts indicates the number of entries in the
 *          \p cd_values array, as allocated by the caller; on return,
 *          \p cd_nelmts contains the number of values defined by the filter.
 *
 *          If \p name is a pointer to an array of at least \p namelen bytes,
 *          the filter name will be copied into that array. The name will be
 *          null terminated if \p namelen is large enough. The filter name
 *          returned will be the name appearing in the file, the name
 *          registered for the filter, or an empty string.
 *
 *          \p filter_config is the bit field described in
 *          H5Zget_filter_info().
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 * @since 1.8.0
 *
 */
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("unsigned int*") IntPointer flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") IntPointer cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") BytePointer name, @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("unsigned int*") IntBuffer flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") IntBuffer cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") ByteBuffer name, @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("H5Z_filter_t") int H5Pget_filter2(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("unsigned int*") int[] flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") int[] cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") byte[] name, @Cast("unsigned*") int[] filter_config);
/**
 * \ingroup OCPL
 *
 * \brief Returns information about the specified filter
 *
 * \ocpl_id{plist_id}
 * @param filter_id [in]     Filter identifier
 * @param flags [out]         Bit vector specifying certain general
 *                              properties of the filter
 * @param cd_nelmts [in,out]     Number of elements in \p cd_values
 * @param cd_values [out] []   Auxiliary data for the filter
 * @param namelen [in]       Length of filter name and number of
 *                              elements in \p name
 * @param name [out] []        Name of filter
 * @param filter_config [out] Bit field, as described in
 *                              H5Zget_filter_info()
 *
 * @return \herr_t
 *
 * \details H5Pget_filter_by_id2() returns information about the filter
 *          specified in \p filter_id, a filter identifier.
 *
 *          \p plist_id must be a dataset or group creation property list
 *          and \p filter_id must be in the associated filter pipeline.
 *
 *          The \p filter_id and \p flags parameters are used in the same
 *          manner as described in the discussion of H5Pset_filter().
 *
 *          Aside from the fact that they are used for output, the
 *          parameters \p cd_nelmts and \p cd_values[] are used in the same
 *          manner as described in the discussion of H5Pset_filter(). On
 *          input, the \p cd_nelmts parameter indicates the number of
 *          entries in the \p cd_values[] array allocated by the calling
 *          program; on exit it contains the number of values defined by
 *          the filter.
 *
 *          On input, the \p namelen parameter indicates the number of
 *          characters allocated for the filter name by the calling program
 *          in the array \p name[]. On exit \p name[] contains the name of the
 *          filter with one character of the name in each element of the
 *          array.
 *
 *          \p filter_config is the bit field described in
 *          H5Zget_filter_info().
 *
 *          If the filter specified in \p filter_id is not set for the
 *          property list, an error will be returned and
 *          H5Pget_filter_by_id2() will fail.
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") IntPointer flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") IntPointer cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") BytePointer name, @Cast("unsigned*") IntPointer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") IntBuffer flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") IntBuffer cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") ByteBuffer name, @Cast("unsigned*") IntBuffer filter_config);
public static native @Cast("herr_t") int H5Pget_filter_by_id2(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") int[] flags,
                                   @Cast("size_t*") SizeTPointer cd_nelmts, @Cast("unsigned*") int[] cd_values, @Cast("size_t") long namelen,
                                   @Cast("char*") byte[] name, @Cast("unsigned*") int[] filter_config);
/**
 * \ingroup OCPL
 *
 * \brief Returns the number of filters in the pipeline
 *
 * \ocpl_id{plist_id}
 *
 * @return  Returns the number of filters in the pipeline if successful;
 *          otherwise returns a negative value.
 *
 * \details H5Pget_nfilters() returns the number of filters defined in the
 *          filter pipeline associated with the property list \p plist_id.
 *
 *          In each pipeline, the filters are numbered from 0 through \Code{N-1},
 *          where \c N is the value returned by this function. During output to
 *          the file, the filters are applied in increasing order; during
 *          input from the file, they are applied in decreasing order.
 *
 *          H5Pget_nfilters() returns the number of filters in the pipeline,
 *          including zero (0) if there are none.
 *
 * @since 1.0.0
 *
 */
public static native int H5Pget_nfilters(@Cast("hid_t") long plist_id);
/**
 * \ingroup OCPL
 *
 * \brief Determines whether times associated with an object
 *       are being recorded
 *
 * \plist_id
 * @param track_times [out] Boolean value, 1 (TRUE) or 0 (FALSE),
 *             specifying whether object times are being recorded
 *
 * @return \herr_t
 *
 * \details H5Pget_obj_track_times() queries the object creation property
 *          list, \p plist_id, to determine whether object times are being
 *          recorded.
 *
 *          If \p track_times is returned as 1, times are being recorded;
 *          if \p track_times is returned as 0, times are not being
 *          recorded.
 *
 *          Time data can be retrieved with H5Oget_info(), which will return
 *          it in the #H5O_info_t struct.
 *
 *          If times are not tracked, they will be reported as follows
 *          when queried: 12:00 AM UDT, Jan. 1, 1970
 *
 *          See H5Pset_obj_track_times() for further discussion.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer track_times);
public static native @Cast("herr_t") int H5Pget_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] track_times);
/**
 * \ingroup OCPL
 *
 * \brief Modifies a filter in the filter pipeline
 *
 * \ocpl_id{plist_id}
 * @param filter [in]      Filter to be modified
 * @param flags [in]       Bit vector specifying certain general properties
 *                        of the filter
 * @param cd_nelmts [in]   Number of elements in \p cd_values
 * @param cd_values [in] [] Auxiliary data for the filter
 *
 * @return \herr_t
 *
 * \details H5Pmodify_filter() modifies the specified \p filter in the
 *          filter pipeline. \p plist_id must be a dataset or group
 *          creation property list.
 *
 *          The \p filter, \p flags \p cd_nelmts[], and \p cd_values
 *          parameters are used in the same manner and accept the same
 *          values as described in the discussion of H5Pset_filter().
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                               @Cast("const unsigned int*") IntPointer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                               @Cast("const unsigned int*") IntBuffer cd_values);
public static native @Cast("herr_t") int H5Pmodify_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                               @Cast("const unsigned int*") int[] cd_values);
/**
 * \ingroup OCPL
 *
 * \brief    Delete one or more filters in the filter pipeline
 *
 * \ocpl_id{plist_id}
 * @param filter [in] Filter to be deleted
 *
 * @return \herr_t
 *
 * \details H5Premove_filter() removes the specified \p filter from the
 *          filter pipeline in the dataset or group creation property
 *          list \p plist_id.
 *
 *          The \p filter parameter specifies the filter to be removed.
 *          Valid values for use in \p filter are as follows:
 *
 *          <table>
 *           <tr>
 *            <td>#H5Z_FILTER_ALL</td>
 *            <td>Removes all filters from the filter pipeline</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_DEFLATE</td>
 *            <td>Data compression filter, employing the gzip
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SHUFFLE</td>
 *            <td>Data shuffling filter</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_FLETCHER32</td>
 *            <td>Error detection filter, employing the Fletcher32
 *                checksum algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SZIP</td>
 *            <td>Data compression filter, employing the SZIP
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_NBIT</td>
 *            <td>Data compression filter, employing the N-Bit
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SCALEOFFSET</td>
 *            <td>Data compression filter, employing the scale-offset
 *                algorithm</td>
 *           </tr>
 *          </table>
 *
 *          Additionally, user-defined filters can be removed with this
 *          routine by passing the filter identifier with which they were
 *          registered with the HDF5 library.
 *
 *          Attempting to remove a filter that is not in the filter
 *          pipeline is an error.
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 * @since 1.6.3
 *
 */
public static native @Cast("herr_t") int H5Premove_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter);
/**
 * \ingroup OCPL
 *
 * \brief Sets tracking and indexing of attribute creation order
 *
 * \plist_id
 * @param crt_order_flags [in] Flags specifying whether to track and index
 *                            attribute creation order. \em Default: No
 *                            flag set; attribute creation order is neither
 *                            tracked not indexed
 *
 * @return \herr_t
 *
 * \details H5Pset_attr_creation_order() sets flags for tracking and
 *          indexing attribute creation order on an object.
 *
 *          \p plist_id is a dataset or group creation property list
 *          identifier.
 *
 *          \p crt_order_flags contains flags with the following meanings:
 *
 *          <table>
 *           <tr>
 *            <td>#H5P_CRT_ORDER_TRACKED</td>
 *            <td>Attribute creation order is tracked but not necessarily
 *                indexed.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5P_CRT_ORDER_INDEXED </td>
 *            <td>Attribute creation order is indexed (requires
 *                #H5P_CRT_ORDER_TRACKED).</td>
 *           </tr>
 *          </table>
 *
 *          Default behavior is that attribute creation order is neither
 *          tracked nor indexed.
 *
 *          H5Pset_attr_creation_order() can be used to set attribute
 *          creation order tracking, or to set attribute creation order
 *          tracking and indexing.
 *
 * \note If a creation order index is to be built, it must be specified in
 *       the object creation property list. HDF5 currently provides no
 *       mechanism to turn on attribute creation order tracking at object
 *       creation time and to build the index later.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_attr_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_order_flags);
/**
 * \ingroup OCPL
 *
 * \brief Sets attribute storage phase change thresholds
 *
 * \plist_id
 * @param max_compact [in]  Maximum number of attributes to be stored in
 *                         compact storage (\em Default: 8); must be greater
 *                         than or equal to \p min_dense
 *
 * @param min_dense [in]    Minimum number of attributes to be stored in
 *                         dense storage (\em Default: 6)
 *
 * @return \herr_t
 *
 * \details H5Pset_attr_phase_change() sets threshold values for attribute
 *          storage on an object. These thresholds determine the point at
 *          which attribute storage changes from compact storage (i.e.,
 *          storage in the object header) to dense storage (i.e., storage
 *          in a heap and indexed with a B-tree).
 *
 *          In the general case, attributes are initially kept in compact
 *          storage. When the number of attributes exceeds \p max_compact,
 *          attribute storage switches to dense storage. If the number of
 *          attributes subsequently falls below \p min_dense, the attributes
 *          are returned to compact storage.
 *
 *          If \p max_compact is set to 0 (zero), dense storage is always
 *          used.  \p min_dense must be set to 0 (zero) when \p max_compact
 *          is 0 (zero).
 *
 *          \p plist_id is a dataset or group creation property list
 *          identifier.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_attr_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned") int max_compact, @Cast("unsigned") int min_dense);
/**
 * \ingroup DCPL
 *
 * \brief Sets deflate (GNU gzip) compression method and compression level
 *
 * \ocpl_id{plist_id}
 * @param level [in] Compression level
 *
 * @return \herr_t
 *
 * \par_compr_note
 *
 * \details H5Pset_deflate() sets the deflate compression method and the
 *          compression level, \p level, for a dataset or group creation
 *          property list, \p plist_id.
 *
 *          The filter identifier set in the property list is
 *          #H5Z_FILTER_DEFLATE.
 *
 *          The compression level, \p level, is a value from zero to nine,
 *          inclusive. A compression level of 0 (zero) indicates no
 *          compression; compression improves but speed slows progressively
 *          from levels 1 through 9:
 *
 *          <table>
 *            <tr>
 *              <th>Compression Level</th>
 *              <th>Gzip Action</th>
 *            </tr>
 *            <tr>
 *              <td>0</td>
 *              <td>No compression</td>
 *            </tr>
 *            <tr>
 *              <td>1</td>
 *              <td>Best compression speed; least compression</td>
 *            </tr>
 *           <tr>
 *             <td>2 through 8</td>
 *             <td>Compression improves; speed degrades</td>
 *           </tr>
 *           <tr>
 *             <td>9</td>
 *             <td>Best compression ratio; slowest speed</td>
 *           </tr>
 *          </table>
 *
 *          Note that setting the compression level to 0 (zero) does not turn
 *          off use of the gzip filter; it simply sets the filter to perform
 *          no compression as it processes the data.
 *
 *          HDF5 relies on GNU gzip for this compression.
 *
 * @version 1.8.5 Function extended to work with group creation property lists.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_deflate(@Cast("hid_t") long plist_id, @Cast("unsigned") int level);
/**
 * \ingroup OCPL
 *
 * \brief Adds a filter to the filter pipeline
 *
 * \ocpl_id{plist_id}
 * @param filter [in]    Filter identifier for the filter to be added to the
 *                      pipeline
 * @param flags [in]     Bit vector specifying certain general properties of
 *                      the filter
 * @param cd_nelmts [in] Number of elements in \p c_values
 * @param c_values [in]  Auxiliary data for the filter
 *
 * @return \herr_t
 *
 * \details H5Pset_filter() adds the specified \p filter identifier and
 *          corresponding properties to the end of an output filter
 *          pipeline.
 *
 *          \p plist_id must be either a dataset creation property list or
 *          group creation property list identifier. If \p plist_id is a
 *          dataset creation property list identifier, the filter is added
 *          to the raw data filter pipeline.
 *
 *          If \p plist_id is a group creation property list identifier,
 *          the filter is added to the link filter pipeline, which filters
 *          the fractal heap used to store most of the link metadata in
 *          certain types of groups. The only predefined filters that can
 *          be set in a group creation property list are the gzip filter
 *          (#H5Z_FILTER_DEFLATE) and the Fletcher32 error detection filter
 *          (#H5Z_FILTER_FLETCHER32).
 *
 *          The array \p c_values contains \p cd_nelmts integers which are
 *          auxiliary data for the filter. The integer values will be
 *          stored in the dataset object header as part of the filter
 *          information.
 *
 *          The \p flags argument is a bit vector with the following
 *          fields specifying certain general properties of the filter:
 *
 *          <table>
 *           <tr>
 *            <td>#H5Z_FLAG_OPTIONAL</td>
 *            <td>If this bit is set then the filter is optional. If the
 *                filter fails (see below) during an H5Dwrite() operation
 *                then the filter is just excluded from the pipeline for
 *                the chunk for which it failed; the filter will not
 *                participate in the pipeline during an H5Dread() of the
 *                chunk. This is commonly used for compression filters:
 *                if the filter result would be larger than the input,
 *                then the compression filter returns failure and the
 *                uncompressed data is stored in the file.<br /><br />
 *                This flag should not be set for the Fletcher32 checksum
 *                filter as it will bypass the checksum filter without
 *                reporting checksum errors to an application.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FLAG_MANDATORY</td>
 *            <td>If the filter is required, that is, set to mandatory,
 *                and the filter fails, the library’s behavior depends
 *                on whether the chunk cache is in use:
 *                \li If the chunk cache is enabled, data chunks will
 *                    be flushed to the file during H5Dclose() and the
 *                    library will return the failure in H5Dclose().
 *                \li When the chunk cache is disabled or not big enough,
 *                    or the chunk is being evicted from the cache, the
 *                    failure will happen during H5Dwrite().
 *
 *                In each case, the library will still write to the file
 *                all data chunks that were processed by the filter
 *                before the failure occurred.<br /><br />
 *                For example, assume that an application creates a
 *                dataset of four chunks, the chunk cache is enabled and
 *                is big enough to hold all four chunks, and the filter
 *                fails when it tries to write the fourth chunk. The
 *                actual flush of the chunks will happen during
 *                H5Dclose(), not H5Dwrite(). By the time H5Dclose()
 *                fails, the first three chunks will have been written
 *                to the file. Even though H5Dclose() fails, all the
 *                resources will be released and the file can be closed
 *                properly. <br /><br />
 *                If, however, the filter fails on the second chunk, only
 *                the first chunk will be written to the file as nothing
 *                further can be written once the filter fails.</td>
 *           </tr>
 *          </table>
 *          The \p filter parameter specifies the filter to be set. Valid
 *          pre-defined filter identifiers are as follows:
 *
 *          <table>
 *           <tr>
 *            <td>#H5Z_FILTER_DEFLATE</td>
 *            <td>Data compression filter, employing the gzip
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SHUFFLE</td>
 *            <td>Data shuffling filter</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_FLETCHER32</td>
 *            <td>Error detection filter, employing the Fletcher32
 *                checksum algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SZIP</td>
 *            <td>Data compression filter, employing the SZIP
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_NBIT</td>
 *            <td>Data compression filter, employing the N-Bit
 *                algorithm</td>
 *           </tr>
 *           <tr>
 *            <td>#H5Z_FILTER_SCALEOFFSET</td>
 *            <td>Data compression filter, employing the scale-offset
 *                algorithm</td>
 *           </tr>
 *          </table>
 *          Also see H5Pset_edc_check() and H5Pset_filter_callback().
 *
 * \note When a non-empty filter pipeline is used with a group creation
 *       property list, the group will be created with the new group file
 *       format. The filters will come into play only when dense storage
 *       is used (see H5Pset_link_phase_change()) and will be applied to
 *       the group’s fractal heap. The fractal heap will contain most of
 *       the the group’s link metadata, including link names.
 *
 * \note When working with group creation property lists, if you are
 *       adding a filter that is not in HDF5’s set of predefined filters,
 *       i.e., a user-defined or third-party filter, you must first
 *       determine that the filter will work for a group. See the
 *       discussion of the set local and can apply callback functions
 *       in H5Zregister().
 *
 * \note If multiple filters are set for a property list, they will be
 *       applied to each chunk of raw data for datasets or each block
 *       of the fractal heap for groups in the order in which they were
 *       set.
 *
 * \note Filters can be applied only to chunked datasets; they cannot be
 *       used with other dataset storage methods, such as contiguous,
 *       compact, or external datasets.
 *
 * \note Dataset elements of variable-length and dataset region
 *       reference datatypes are stored in separate structures in the
 *       file called heaps. Filters cannot currently be applied to
 *       these heaps.
 *
 * \note <b>Filter Behavior in HDF5:</b><br />
 *       Filters can be inserted into the HDF5 pipeline to perform
 *       functions such as compression and conversion. As such, they are
 *       a very flexible aspect of HDF5; for example, a user-defined
 *       filter could provide encryption for an HDF5 dataset.
 *
 * \note A filter can be declared as either required or optional.
 *       Required is the default status; optional status must be
 *       explicitly declared.
 *
 * \note A required filter that fails or is not defined causes an
 *       entire output operation to fail; if it was applied when the
 *       data was written, such a filter will cause an input operation
 *       to fail.
 *
 * \note The following table summarizes required filter behavior.
 *          <table>
 *           <tr>
 *            <th></th>
 *            <th>Required FILTER_X not available</th>
 *            <th>FILTER_X available</th>
 *           </tr>
 *           <tr>
 *            <td>H5Pset_<FILTER_X></td>
 *            <td>Will fail.</td>
 *            <td>Will succeed.</td>
 *           </tr>
 *           <tr>
 *            <td>H5Dwrite with FILTER_X set</td>
 *            <td>Will fail.</td>
 *            <td>Will succeed; FILTER_X will be applied to
 *                the data.</td>
 *           </tr>
 *           <tr>
 *            <td>H5Dread with FILTER_X set</td>
 *            <td>Will fail.</td>
 *            <td>Will succeed.</td>
 *           </tr>
 *          </table>
 * \note An optional filter can be set for an HDF5 dataset even when
 *       the filter is not available. Such a filter can then be
 *       applied to the dataset when it becomes available on the
 *       original system or when the file containing the dataset is
 *       processed on a system on which it is available.
 *
 * \note A filter can be declared as optional through the use of the
 *       #H5Z_FLAG_OPTIONAL flag with H5Pset_filter().
 *
 * \note Consider a situation where one is creating files that will
 *       normally be used only on systems where the optional (and
 *       fictional) filter FILTER_Z is routinely available. One can
 *       create those files on system A, which lacks FILTER_Z, create
 *       chunked datasets in the files with FILTER_Z defined in the
 *       dataset creation property list, and even write data to those
 *       datasets. The dataset object header will indicate that FILTER_Z
 *       has been associated with this dataset. But since system A does
 *       not have FILTER_Z, dataset chunks will be written without it
 *       being applied.
 *
 * \note HDF5 has a mechanism for determining whether chunks are
 *       actually written with the filters specified in the object
 *       header, so while the filter remains unavailable, system A will
 *       be able to read the data. Once the file is moved to system B,
 *       where FILTER_Z is available, HDF5 will apply FILTER_Z to any
 *       data rewritten or new data written in these datasets. Dataset
 *       chunks that have been written on system B will then be
 *       unreadable on system A; chunks that have not been re-written
 *       since being written on system A will remain readable on system
 *       A. All chunks will be readable on system B.
 *
 * \note The following table summarizes optional filter behavior.
 *          <table>
 *           <tr>
 *            <th></th>
 *            <th>FILTER_Z not available</th>
 *            <th>FILTER_Z available<br /> with encode and decode</th>
 *            <th>FILTER_Z available decode only</th>
 *           </tr>
 *           <tr>
 *            <td>H5Pset_<FILTER_Z></td>
 *            <td>Will succeed.</td>
 *            <td>Will succeed.</td>
 *            <td>Will succeed.</td>
 *           </tr>
 *           <tr>
 *            <td>H5Dread with FILTER_Z set</td>
 *            <td>Will succeed if FILTER_Z has not actually<br />
 *                been applied to data.</td>
 *            <td>Will succeed.</td>
 *            <td>Will succeed.</td>
 *           </tr>
 *           <tr>
 *            <td>H5Dwrite with FILTER_Z set</td>
 *            <td>Will succeed;<br />
 *                FILTER_Z will not be applied to the data.</td>
 *            <td>Will succeed;<br />
 *            FILTER_Z will be applied to the data.</td>
 *            <td>Will succeed;<br />
 *            FILTER_Z will not be applied to the data.</td>
 *           </tr>
 *          </table>
 * \note The above principles apply generally in the use of HDF5
 *       optional filters insofar as HDF5 does as much as possible to
 *       complete an operation when an optional filter is unavailable.
 *       (The SZIP filter is an exception to this rule; see H5Pset_szip()
 *       for details.)
 *
 * @see \ref_filter_pipe, \ref_group_impls
 *
 * @version 1.8.5 Function applied to group creation property lists.
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                            @Cast("const unsigned int*") IntPointer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                            @Cast("const unsigned int*") IntBuffer c_values);
public static native @Cast("herr_t") int H5Pset_filter(@Cast("hid_t") long plist_id, @Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                            @Cast("const unsigned int*") int[] c_values);
/**
 * \ingroup OCPL
 *
 * \brief Sets up use of the Fletcher32 checksum filter
 *
 * \ocpl_id{plist_id}
 *
 * @return \herr_t
 *
 * \details H5Pset_fletcher32() sets the Fletcher32 checksum filter in the
 *          dataset or group creation property list \p plist_id.
 *
 * \attention The Fletcher32 EDC checksum filter was added in HDF5 Release
 *            1.6.0. In the original implementation, however, the checksum
 *            value was calculated incorrectly on little-endian systems.
 *            The error was fixed in HDF5 Release 1.6.3.
 *
 * \attention As a result of this fix, an HDF5 library of Release 1.6.0
 *            through Release 1.6.2 cannot read a dataset created or written
 *            with Release 1.6.3 or later if the dataset was created with
 *            the checksum filter and the filter is enabled in the reading
 *            library. (Libraries of Release 1.6.3 and later understand the
 *            earlier error and compensate appropriately.)
 *
 * \attention \b Work-around: An HDF5 library of Release 1.6.2 or earlier
 *            will be able to read a dataset created or written with the
 *            checksum filter by an HDF5 library of Release 1.6.3 or later
 *            if the checksum filter is disabled for the read operation.
 *            This can be accomplished via a call to H5Pset_edc_check()
 *            with the value #H5Z_DISABLE_EDC in the second parameter.
 *            This has the obvious drawback that the application will be
 *            unable to verify the checksum, but the data does remain
 *            accessible.
 *
 * @version 1.8.5 Function extended to work with group creation property
 *                lists.
 * @version 1.6.3 Error in checksum calculation on little-endian systems
 *                corrected in this release.
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_fletcher32(@Cast("hid_t") long plist_id);
/**
 * \ingroup OCPL
 *
 * \brief Sets the recording of times associated with an object
 *
 * @param plist_id [in]    Object creation property list identifier
 * @param track_times [in] Boolean value, 1 or 0, specifying whether object
 *                        times are to be tracked
 *
 * @return \herr_t
 *
 * \details H5Pset_obj_track_times() sets a property in the object creation
 *          property list, \p plist_id, that governs the recording of times
 *          associated with an object.
 *
 *          If \p track_times is set to 1, time data will be recorded. If
 *          \p track_times is set to 0, time data will not be recorded.
 *
 *          Time data can be retrieved with H5Oget_info(), which will
 *          return it in the #H5O_info_t struct.
 *
 *          If times are not tracked, they will be reported as follows when queried:
 *            \Code{ 12:00 AM UDT, Jan. 1, 1970}
 *
 *          That date and time are commonly used to represent the beginning of the UNIX epoch.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_obj_track_times(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean track_times);

/* File creation property list (FCPL) routines */
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the file space page size for a file creation property
 *        list
 *
 * \fcpl_id{plist_id}
 * @param fsp_size [out]  File space page size
 *
 * @return \herr_t
 *
 * \details H5Pget_file_space_page_size() retrieves the file space page
 *          size for paged aggregation in the parameter \p fsp_size.
 *
 *          The library default is 4KB (4096) if \p fsp_size is not
 *          previously set via a call to H5Pset_file_space_page_size().
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongPointer fsp_size);
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongBuffer fsp_size);
public static native @Cast("herr_t") int H5Pget_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t*") long[] fsp_size);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the file space handling strategy, persisting free-space
 *        condition and threshold value for a file creation property list
 *
 * \fcpl_id{plist_id}
 * @param strategy [out]  The file space handling strategy
 * @param persist [out]   The boolean value indicating whether free space is
 *                       persistent or not
 * @param threshold [out] The free-space section size threshold value
 *
 * @return \herr_t
 *
 * \details H5Pget_file_space_strategy() retrieves the file space handling
 *          strategy, the persisting free-space condition and the threshold
 *          value in the parameters \p strategy, \p persist and
 *          \p threshold respectively.
 *
 *          The library default values returned when
 *          H5Pset_file_space_strategy() has not been called are:
 *
 *          \li \p strategy  - #H5F_FSPACE_STRATEGY_FSM_AGGR
 *          \li \p persist   - 0
 *          \li \p threshold - 1
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntPointer strategy, @Cast("hbool_t*") BoolPointer persist,
                                         @Cast("hsize_t*") LongPointer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntBuffer strategy, @Cast("hbool_t*") boolean[] persist,
                                         @Cast("hsize_t*") LongBuffer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") int[] strategy, @Cast("hbool_t*") BoolPointer persist,
                                         @Cast("hsize_t*") long[] threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntPointer strategy, @Cast("hbool_t*") boolean[] persist,
                                         @Cast("hsize_t*") LongPointer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") IntBuffer strategy, @Cast("hbool_t*") BoolPointer persist,
                                         @Cast("hsize_t*") LongBuffer threshold);
public static native @Cast("herr_t") int H5Pget_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t*") int[] strategy, @Cast("hbool_t*") boolean[] persist,
                                         @Cast("hsize_t*") long[] threshold);
/**
 * \ingroup FCPL
 *
 * \brief Queries the 1/2 rank of an indexed storage B-tree
 *
 * \fcpl_id{plist_id}
 * @param ik [out] Pointer to location to return the chunked storage B-tree
 *                1/2 rank (<em>Default value of B-tree 1/2 rank: 32</em>)
 *
 * @return \herr_t
 *
 * \details H5Pget_istore_k() queries the 1/2 rank of an indexed storage
 *          B-tree.
 *
 *          The argument \p ik may be the null pointer (NULL).
 *          This function is valid only for file creation property lists.
 *
 * @see H5Pset_istore_k()
 *
 * @version 1.6.4 \p ik parameter type changed to \em unsigned.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer ik);
public static native @Cast("herr_t") int H5Pget_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] ik);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the configuration settings for a shared message index
 *
 * \fcpl_id{plist_id}
 * @param index_num [in]       Index being configured
 * @param mesg_type_flags [out] Types of messages that may be stored in
 *                             this index
 * @param min_mesg_size [out]   Minimum message size
 *
 * @return \herr_t
 *
 * \details H5Pget_shared_mesg_index() retrieves the message type and
 *          minimum message size settings from the file creation property
 *          list \p plist_id for the shared object header message index
 *          specified by \p index_num.
 *
 *          \p index_num specifies the index. \p index_num is zero-indexed,
 *          so in a file with three indexes, they will be numbered 0, 1,
 *          and 2.
 *
 *          \p mesg_type_flags and \p min_mesg_size will contain,
 *          respectively, the types of messages and the minimum size, in
 *          bytes, of messages that can be stored in this index.
 *
 *          Valid message types are described in H5Pset_shared_mesg_index().
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntPointer mesg_type_flags,
                                       @Cast("unsigned*") IntPointer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") IntBuffer mesg_type_flags,
                                       @Cast("unsigned*") IntBuffer min_mesg_size);
public static native @Cast("herr_t") int H5Pget_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned*") int[] mesg_type_flags,
                                       @Cast("unsigned*") int[] min_mesg_size);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the number of shared object header message indexes in file
 *        creation property list
 *
 * \fcpl_id{plist_id}
 * @param nindexes [out]  Number of shared object header message indexes
 *                       available in files created with this property list
 *
 * @return \herr_t
 *
 * \details H5Pget_shared_mesg_nindexes() retrieves the number of shared
 *          object header message indexes in the specified file creation
 *          property list \p plist_id.
 *
 *          If the value of \p nindexes is 0 (zero), shared object header
 *          messages are disabled in files created with this property list.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer nindexes);
public static native @Cast("herr_t") int H5Pget_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] nindexes);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves shared object header message phase change information
 *
 * \fcpl_id{plist_id}
 * @param max_list [out]  Threshold above which storage of a shared object
 *                       header message index shifts from list to B-tree
 * @param min_btree [out] Threshold below which storage of a shared object
 *                       header message index reverts to list format
 *
 * @return \herr_t
 *
 * \details H5Pget_shared_mesg_phase_change() retrieves the threshold values
 *          for storage of shared object header message indexes in a file.
 *          These phase change thresholds determine the point at which the
 *          index storage mechanism changes from a more compact list format
 *          to a more performance-oriented B-tree format, and vice-versa.
 *
 *          By default, a shared object header message index is initially
 *          stored as a compact list. When the number of messages in an
 *          index exceeds the specified \p max_list threshold, storage
 *          switches to a B-tree format for improved performance. If the
 *          number of messages subsequently falls below the \p min_btree
 *          threshold, the index will revert to the list format.
 *
 *          If \p max_list is set to 0 (zero), shared object header message
 *          indexes in the file will always be stored as B-trees.
 *
 *          \p plist_id specifies the file creation property list.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_list, @Cast("unsigned*") IntPointer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer max_list, @Cast("unsigned*") IntBuffer min_btree);
public static native @Cast("herr_t") int H5Pget_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] max_list, @Cast("unsigned*") int[] min_btree);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the size of the offsets and lengths used in an HDF5
 *        file
 *
 * \fcpl_id{plist_id}
 * @param sizeof_addr [out] Pointer to location to return offset size in
 *             bytes
 * @param sizeof_size [out] Pointer to location to return length size in
 *             bytes
 *
 * @return \herr_t
 *
 * \details H5Pget_sizes() retrieves the size of the offsets and lengths
 *          used in an HDF5 file. This function is only valid for file
 *          creation property lists.
 *
 * @since  1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_sizes(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer sizeof_addr, @Cast("size_t*") SizeTPointer sizeof_size);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the size of the symbol table B-tree 1/2 rank and the
 *        symbol table leaf node 1/2 size
 *
 * \fcpl_id{plist_id}
 * @param ik [out] Pointer to location to return the symbol table's B-tree
 *                1/2 rank (<em>Default value of B-tree 1/2 rank: 16</em>)
 * @param lk [out] Pointer to location to return the symbol table's leaf
 *                node 1/2 size (<em>Default value of leaf node 1/2
 *                size: 4</em>)
 *
 * @return \herr_t
 *
 * \details H5Pget_sym_k() retrieves the size of the symbol table B-tree
 *          1/2 rank and the symbol table leaf node 1/2 size.
 *
 *          This function is valid only for file creation property lists.
 *
 *          If a parameter value is set to NULL, that parameter is not
 *          retrieved.
 *
 * @see H5Pset_sym_k()
 *
 * @version 1.6.4 \p ik parameter type changed to \em unsigned
 * @version 1.6.0 The \p ik parameter has changed from type int to
 *                \em unsigned
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer ik, @Cast("unsigned*") IntPointer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer ik, @Cast("unsigned*") IntBuffer lk);
public static native @Cast("herr_t") int H5Pget_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] ik, @Cast("unsigned*") int[] lk);
/**
 * \ingroup FCPL
 *
 * \brief Retrieves the size of a user block
 *
 * \fcpl_id{plist_id}
 * @param size [out]  Pointer to location to return user-block size
 *
 * @return \herr_t
 *
 * \details H5Pget_userblock() retrieves the size of a user block in a
 *          file creation property list.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t*") long[] size);
/**
 * \ingroup FCPL
 *
 * \brief Sets the file space page size for a file creation property list
 *
 * \fcpl_id{plist_id}
 * @param fsp_size [in]    File space page size
 *
 * @return \herr_t
 *
 * \details H5Pset_file_space_page_size() sets the file space page size
 *          \p fsp_size used in paged aggregation and paged buffering.
 *
 *          \p fsp_size has a minimum size of 512. Setting a value less
 *          than 512 will return an error. The library default size for
 *          the file space page size when not set is 4096.
 *
 *          The size set via this routine may not be changed for the life
 *          of the file.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pset_file_space_page_size(@Cast("hid_t") long plist_id, @Cast("hsize_t") long fsp_size);
/**
 * \ingroup FCPL
 *
 * \brief Sets the file space handling strategy and persisting free-space
 *        values for a file creation property list
 *
 * \fcpl_id{plist_id}
 * @param strategy [in]  The file space handling strategy to be used. See:
 *                      #H5F_fspace_strategy_t
 * @param persist [in]   A boolean value to indicate whether free space
 *                      should be persistent or not
 * @param threshold [in] The smallest free-space section size that the free
 *                      space manager will track
 *
 * @return \herr_t
 *
 * \details H5Pset_file_space_strategy() sets the file space handling
 *          \p strategy, specifies persisting free-space or not (\p persist),
 *          and sets the free-space section size \p threshold in the file
 *          creation property list \p plist_id.
 *
 *          #H5F_fspace_strategy_t is a struct defined in H5Fpublic.h as
 *          follows:
 *
 *          \snippet H5Fpublic.h H5F_fspace_strategy_t_snip
 *
 *          This setting cannot be changed for the life of the file.
 *
 *          As the #H5F_FSPACE_STRATEGY_AGGR and #H5F_FSPACE_STRATEGY_NONE
 *          strategies do not use the free-space managers, the \p persist
 *          and \p threshold settings will be ignored for those strategies.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pset_file_space_strategy(@Cast("hid_t") long plist_id, @Cast("H5F_fspace_strategy_t") int strategy, @Cast("hbool_t") boolean persist,
                                         @Cast("hsize_t") long threshold);
/**
 * \ingroup FCPL
 *
 * \brief Sets the size of the parameter used to control the B-trees for
 *        indexing chunked datasets
 *
 * \fcpl_id{plist_id}
 * @param ik [in] 1/2 rank of chunked storage B-tree
 *
 * @return \herr_t
 *
 * \details H5Pset_istore_k() sets the size of the parameter used to
 *          control the B-trees for indexing chunked datasets. This
 *          function is valid only for file creation property lists.
 *
 *          \p ik is one half the rank of a tree that stores chunked
 *          raw data. On average, such a tree will be 75% full, or have
 *          an average rank of 1.5 times the value of \p ik.
 *
 *          The HDF5 library uses (\p ik*2) as the maximum # of entries
 *          before splitting a B-tree node. Since only 2 bytes are used
 *          in storing # of entries for a B-tree node in an HDF5 file,
 *          (\p ik*2) cannot exceed 65536. The default value for
 *          \p ik is 32.
 *
 * @version 1.6.4 \p ik parameter type changed to \p unsigned.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_istore_k(@Cast("hid_t") long plist_id, @Cast("unsigned") int ik);
/**
 * \ingroup FCPL
 *
 * \brief Configures the specified shared object header message index
 *
 * \fcpl_id{plist_id}
 * @param index_num [in]       Index being configured
 * @param mesg_type_flags [in] Types of messages that should be stored in
 *                            this index
 * @param min_mesg_size [in]   Minimum message size
 *
 * @return \herr_t
 *
 * \details H5Pset_shared_mesg_index() is used to configure the specified
 *          shared object header message index, setting the types of
 *          messages that may be stored in the index and the minimum size
 *          of each message.
 *
 *          \p plist_id specifies the file creation property list.
 *
 *          \p index_num specifies the index to be configured.
 *          \p index_num is zero-indexed, so in a file with three indexes,
 *          they will be numbered 0, 1, and 2.
 *
 *          \p mesg_type_flags and \p min_mesg_size specify, respectively,
 *          the types and minimum size of messages that can be stored in
 *          this index.
 *
 *          Valid message types are as follows:
 *
 *          <table>
 *           <tr>
 *            <td>#H5O_SHMESG_NONE_FLAG</td>
 *            <td>No shared messages</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_SDSPACE_FLAG</td>
 *            <td>Simple dataspace message</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_DTYPE_FLAG</td>
 *            <td>Datatype message</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_FILL_FLAG</td>
 *            <td>Fill value message</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_PLINE_FLAG</td>
 *            <td>Filter pipeline message</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_ATTR_FLAG</td>
 *            <td>Attribute message</td>
 *           </tr>
 *           <tr>
 *            <td>#H5O_SHMESG_ALL_FLAG</td>
 *            <td>All message types; i.e., equivalent to the following:
 *            (#H5O_SHMESG_SDSPACE_FLAG | #H5O_SHMESG_DTYPE_FLAG |
 *             #H5O_SHMESG_FILL_FLAG | #H5O_SHMESG_PLINE_FLAG |
 *             #H5O_SHMESG_ATTR_FLAG)</td>
 *           </tr>
 *          </table>
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_shared_mesg_index(@Cast("hid_t") long plist_id, @Cast("unsigned") int index_num, @Cast("unsigned") int mesg_type_flags,
                                       @Cast("unsigned") int min_mesg_size);
/**
 * \ingroup FCPL
 *
 * \brief Sets number of shared object header message indexes
 *
 * \fcpl_id{plist_id}
 * @param nindexes [in] Number of shared object header message indexes to be
 *                     available in files created with this property list
 *                     (\p nindexes must be <= #H5O_SHMESG_MAX_NINDEXES (8))
 *
 * @return \herr_t
 *
 * \details H5Pset_shared_mesg_nindexes() sets the number of shared object
 *          header message indexes in the specified file creation property
 *          list.
 *
 *          This setting determines the number of shared object header
 *          message indexes, \p nindexes, that will be available in files
 *          created with this property list. These indexes can then be
 *          configured with H5Pset_shared_mesg_index().
 *
 *          If \p nindexes is set to 0 (zero), shared object header messages
 *          are disabled in files created with this property list.
 *
 *          There is a limit of #H5O_SHMESG_MAX_NINDEXES (8) that can be set
 *          with H5Pset_shared_mesg_nindexes(). An error will occur if
 *          specifying a value of \p nindexes that is greater than this value.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_shared_mesg_nindexes(@Cast("hid_t") long plist_id, @Cast("unsigned") int nindexes);
/**
 * \ingroup FCPL
 *
 * \brief Sets shared object header message storage phase change thresholds
 *
 * \fcpl_id{plist_id}
 * @param max_list [in]  Threshold above which storage of a shared object
 *                      header message index shifts from list to B-tree
 * @param min_btree [in] Threshold below which storage of a shared object
 *                      header message index reverts to list format
 *
 * @return \herr_t
 *
 * \details H5Pset_shared_mesg_phase_change() sets threshold values for
 *          storage of shared object header message indexes in a file.
 *          These phase change thresholds determine the point at which the
 *          index storage mechanism changes from a more compact list format
 *          to a more performance-oriented B-tree format, and vice-versa.
 *
 *          By default, a shared object header message index is initially
 *          stored as a compact list. When the number of messages in an
 *          index exceeds the threshold value of \p max_list, storage
 *          switches to a B-tree for improved performance. If the number
 *          of messages subsequently falls below the \p min_btree threshold,
 *          the index will revert to the list format.
 *
 *          If \p max_list is set to 0 (zero), shared object header message
 *          indexes in the file will be created as B-trees and will never
 *          revert to lists.
 *
 *          \p plist_id specifies the file creation property list.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_shared_mesg_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned") int max_list, @Cast("unsigned") int min_btree);
/**
 * \ingroup FCPL
 *
 * \brief Sets the byte size of the offsets and lengths used to address
 *        objects in an HDF5 file
 *
 * \fcpl_id{plist_id}
 * @param sizeof_addr [in] Size of an object offset in bytes
 * @param sizeof_size [in] Size of an object length in bytes
 *
 * @return \herr_t
 *
 * \details H5Pset_sizes() sets the byte size of the offsets and lengths
 *          used to address objects in an HDF5 file. This function is only
 *          valid for file creation property lists. Passing in a value
 *          of 0 for one of the parameters retains the current value. The
 *          default value for both values is the same as sizeof(hsize_t)
 *          in the library (normally 8 bytes). Valid values currently
 *          are 2, 4, 8 and 16.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_sizes(@Cast("hid_t") long plist_id, @Cast("size_t") long sizeof_addr, @Cast("size_t") long sizeof_size);
/**
 * \ingroup FCPL
 *
 * \brief
 *
 * \fcpl_id{plist_id}
 * @param ik [in] Symbol table tree rank
 * @param lk [in] Symbol table node size
 *
 * @return \herr_t
 *
 * \details H5Pset_sym_k() sets the size of parameters used to control the
 *          symbol table nodes.
 *
 *          This function is valid only for file creation property lists.
 *          Passing in a value of zero (0) for one of the parameters retains
 *          the current value.
 *
 *          \p ik is one half the rank of a B-tree that stores a symbol
 *          table for a group. Internal nodes of the symbol table are on
 *          average 75% full. That is, the average rank of the tree is
 *          1.5 times the value of \p ik. The HDF5 library uses (\p ik*2) as
 *          the maximum # of entries before splitting a B-tree node. Since
 *          only 2 bytes are used in storing # of entries for a B-tree node
 *          in an HDF5 file, (\p ik*2) cannot exceed 65536. The default value
 *          for \p ik is 16.
 *
 *          \p lk is one half of the number of symbols that can be stored in
 *          a symbol table node. A symbol table node is the leaf of a symbol
 *          table tree which is used to store a group. When symbols are
 *          inserted randomly into a group, the group's symbol table nodes are
 *          75% full on average. That is, they contain 1.5 times the number of
 *          symbols specified by \p lk. The default value for \p lk is 4.
 *
 * @version 1.6.4 \p ik parameter type changed to \em unsigned.
 * @version 1.6.0 The \p ik parameter has changed from type int to
 *          \em unsigned.
 *
 * @since  1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_sym_k(@Cast("hid_t") long plist_id, @Cast("unsigned") int ik, @Cast("unsigned") int lk);
/**
 * \ingroup FCPL
 *
 * \brief Sets user block size
 *
 * \fcpl_id{plist_id}
 * @param size [in] Size of the user-block in bytes
 *
 * @return  \herr_t
 *
 * \details H5Pset_userblock() sets the user block size of a file creation
 *          property list. The default user block size is 0; it may be set
 *          to any power of 2 equal to 512 or greater (512, 1024, 2048, etc.).
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_userblock(@Cast("hid_t") long plist_id, @Cast("hsize_t") long size);

/* File access property list (FAPL) routines */
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the current settings for alignment properties from a
 *        file access property list
 *
 * \fapl_id
 * @param threshold [out] Pointer to location of return threshold value
 * @param alignment [out] Pointer to location of return alignment value
 *
 * @return \herr_t
 *
 * \details H5Pget_alignment() retrieves the current settings for
 *          alignment properties from a file access property list. The
 *          \p threshold and/or \p alignment pointers may be null
 *          pointers (NULL).
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer threshold, @Cast("hsize_t*") LongPointer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer threshold, @Cast("hsize_t*") LongBuffer alignment);
public static native @Cast("herr_t") int H5Pget_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] threshold, @Cast("hsize_t*") long[] alignment);
/**
 * \ingroup FAPL
 *
 * \brief Queries the raw data chunk cache parameters
 *
 * \fapl_id{plist_id}
 * @param mdc_nelmts [in,out]  <i>No longer used</i>
 * @param rdcc_nslots [in,out] Number of elements (objects) in the raw data
 *                            chunk cache
 * @param rdcc_nbytes [in,out] Total size of the raw data chunk cache, in
 *                            bytes
 * @param rdcc_w [in,out] 0     Preemption policy
 *
 * @return \herr_t
 *
 * \details H5Pget_cache() retrieves the maximum possible number of
 *          elements in the raw data chunk cache, the maximum possible
 *          number of bytes in the raw data chunk cache, and the
 *          preemption policy value.
 *
 *          Any (or all) arguments may be null pointers, in which case
 *          the corresponding datum is not returned.
 *
 *          Note that the \p mdc_nelmts parameter is no longer used.
 *
 * @version 1.8.0 Use of the \p mdc_nelmts parameter discontinued.
 *                Metadata cache configuration is managed with
 *                H5Pset_mdc_config() and H5Pget_mdc_config()
 * @version 1.6.0 The \p rdcc_nbytes and \p rdcc_nslots parameters changed
 *                from type int to size_t.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id, IntPointer mdc_nelmts,
                           @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes, DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id, IntBuffer mdc_nelmts,
                           @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes, DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_cache(@Cast("hid_t") long plist_id, int[] mdc_nelmts,
                           @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes, double[] rdcc_w0);
/**
 * \ingroup FAPL
 *
 * \brief Gets information about the write tracking feature used by
 *        the core VFD
 *
 * \fapl_id
 * @param is_enabled [out] Whether the feature is enabled
 * @param page_size [out]  Size, in bytes, of write aggregation pages
 *
 * @return \herr_t
 *
 * \details H5Pget_core_write_tracking() retrieves information about the
 *          write tracking feature used by the core VFD.
 *
 *          When a file is created or opened for writing using the core
 *          virtual file driver (VFD) with the backing store option turned
 *          on, the VFD can be configured to track changes to the file
 *          and only write out the modified bytes. To avoid a large number
 *          of small writes, the changes can be aggregated into pages of
 *          a user-specified size. The core VFD is also known as the
 *          memory VFD. The driver identifier is #H5FD_CORE.
 *
 * \note This function is only for use with the core VFD and must be used
 *       after the call to H5Pset_fapl_core(). It is an error to use this
 *       function with any other VFD.
 *
 * \note This function only applies to the backing store write operation
 *       which typically occurs when the file is flushed or closed. This
 *       function has no relationship to the increment parameter passed
 *       to H5Pset_fapl_core().
 *
 * \note For optimum performance, the \p page_size parameter should be
 *       a power of two.
 *
 * @since 1.8.13
 *
 */
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("size_t*") SizeTPointer page_size);
public static native @Cast("herr_t") int H5Pget_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("size_t*") SizeTPointer page_size);
/**
 * \ingroup FAPL
 *
 * \brief Returns low-lever driver identifier
 *
 * \plist_id
 *
 * @return \hid_t{low level driver}
 *
 * \details H5Pget_driver() returns the identifier of the low-level file
 *          driver associated with the file access property list or
 *          data transfer property list \p plist_id.
 *
 *          Valid driver identifiers distributed with HDF5 are listed and
 *          described in the following table.
 *
 *          <table>
 *           <tr>
 *            <th>Driver Name</th>
 *            <th>Driver Identifier</th>
 *            <th>Description</th>
 *            <th>Related Function</th>
 *           </tr>
 *           <tr>
 *            <td>POSIX</td>
 *            <td>#H5FD_SEC2</td>
 *            <td>This driver uses POSIX file-system functions like read and
 *                write to perform I/O to a single, permanent file on local disk
 *                with no system buffering. This driver is POSIX-compliant and
 *                is the default file driver for all systems.</td>
 *            <td>H5Pset_fapl_sec2()</td>
 *           </tr>
 *           <tr>
 *            <td>Direct</td>
 *            <td>#H5FD_DIRECT</td>
 *            <td>This is the #H5FD_SEC2 driver except data is written to or
 *                read from the file synchronously without being cached by the
 *                system.</td>
 *            <td>H5Pset_fapl_direct()</td>
 *           </tr>
 *           <tr>
 *            <td>Log</td>
 *            <td>#H5FD_LOG</td>
 *            <td>This is the #H5FD_SEC2 driver with logging capabilities.</td>
 *            <td>H5Pset_fapl_log()</td>
 *           </tr>
 *           <tr>
 *            <td>Windows</td>
 *            <td>#H5FD_WINDOWS</td>
 *            <td>This driver was modified in HDF5-1.8.8 to be a wrapper of the
 *                POSIX driver, #H5FD_SEC2. This change should not affect user
 *                applications.</td>
 *            <td>H5Pset_fapl_windows()</td>
 *           </tr>
 *           <tr>
 *            <td>STDIO</td>
 *            <td>#H5FD_STDIO</td>
 *            <td>This driver uses functions from the standard C stdio.h to
 *                perform I/O to a single, permanent file on local disk with
 *                additional system buffering.</td>
 *            <td>H5Pset_fapl_stdio()</td>
 *           </tr>
 *           <tr>
 *            <td>Memory</td>
 *            <td>#H5FD_CORE</td>
 *            <td>With this driver, an application can work with a file in
 *                memory for faster reads and writes. File contents are kept in
 *                memory until the file is closed. At closing, the memory
 *                version of the file can be written back to disk or abandoned.
 *            </td>
 *            <td>H5Pset_fapl_core()</td>
 *           </tr>
 *           <tr>
 *            <td>Family</td>
 *            <td>#H5FD_FAMILY</td>
 *            <td>With this driver, the HDF5 file’s address space is partitioned
 *                into pieces and sent to separate storage files using an
 *                underlying driver of the user’s choice. This driver is for
 *                systems that do not support files larger than 2 gigabytes.
 *            </td>
 *            <td>H5Pset_fapl_family()</td>
 *           </tr>
 *           <tr>
 *            <td>Multi</td>
 *            <td>#H5FD_MULTI</td>
 *            <td>With this driver, data can be stored in multiple files
 *                according to the type of the data. I/O might work better if
 *                data is stored in separate files based on the type of data.
 *                The Split driver is a special case of this driver.</td>
 *            <td>H5Pset_fapl_multi()</td>
 *           </tr>
 *           <tr>
 *            <td>Parallel</td>
 *            <td>#H5FD_MPIO</td>
 *            <td>This is the standard HDF5 file driver for parallel file
 *                systems. This driver uses the MPI standard for both
 *                communication and file I/O.</td>
 *            <td>H5Pset_fapl_mpio()</td>
 *           </tr>
 *           <tr>
 *            <td>Parallel POSIX</td>
 *            <td>H5FD_MPIPOSIX</td>
 *            <td>This driver is no longer available.</td>
 *            <td></td>
 *           </tr>
 *           <tr>
 *            <td>Stream</td>
 *            <td>H5FD_STREAM</td>
 *            <td>This driver is no longer available.</td>
 *            <td></td>
 *           </tr>
 *          </table>
 *
 *          This list does not include custom drivers that might be
 *          defined and registered by a user.
 *
 *          The returned driver identifier is only valid as long as the
 *          file driver remains registered.
 *
 *
 * @since 1.4.0
 *
 */
public static native @Cast("hid_t") long H5Pget_driver(@Cast("hid_t") long plist_id);
/**
 * \ingroup FAPL
 *
 * \brief Returns a pointer to file driver information
 *
 * @param plist_id [in] File access or data transfer property list
 *                     identifier
 *
 * @return Returns a pointer to a struct containing low-level driver
 *         information. Otherwise returns NULL. NULL is also returned if
 *         no driver-specific properties have been registered. No error
 *         is pushed on the stack in this case.
 *
 * \details H5Pget_driver_info() returns a pointer to file driver-specific
 *          information for the low-level driver associated with the file
 *          access or data transfer property list \p plist_id.
 *
 *          The pointer returned by this function points to an “uncopied”
 *          struct. Driver-specific versions of that struct are defined
 *          for each low-level driver in the relevant source code file
 *          H5FD*.c. For example, the struct used for the MULTI driver is
 *          \c H5FD_multi_fapl_t defined in H5FDmulti.c.
 *
 *          If no driver-specific properties have been registered,
 *          H5Pget_driver_info() returns NULL.
 *
 * \note H5Pget_driver_info() and H5Pset_driver() are used only when
 *       creating a virtual file driver (VFD) in the virtual file
 *       layer (VFL).
 *
 * @version 1.10.1 Return value was changed from \em void * to
 *                 \em const \em void *.
 * @version 1.8.2 Function publicized in this release; previous releases
 *                described this function only in the virtual file driver
 *                documentation.
 *
 */
public static native @Const Pointer H5Pget_driver_info(@Cast("hid_t") long plist_id);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the size of the external link open file cache
 *
 * \fapl_id{plist_id}
 * @param efc_size [out] External link open file cache size in number of files
 *
 * @return \herr_t
 *
 * \details H5Pget_elink_file_cache_size() retrieves the number of files that
 *          can be held open in an external link open file cache.
 *
 * @since 1.8.7
 *
 */
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer efc_size);
public static native @Cast("herr_t") int H5Pget_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] efc_size);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the file access property list setting that determines
 *        whether an HDF5 object will be evicted from the library's metadata
 *        cache when it is closed
 *
 * \fapl_id
 * @param evict_on_close [out] Pointer to a variable that will indicate if
 *                            the object will be evicted on close
 *
 * @return \herr_t
 *
 * \details The library's metadata cache is fairly conservative about holding on
 *          to HDF5 object metadata (object headers, chunk index structures,
 *          etc.), which can cause the cache size to grow, resulting in memory
 *          pressure on an application or system. When enabled, the "evict on
 *          close" property will cause all metadata for an object to be
 *          immediately evicted from the cache as long as it is not referenced
 *          by any other open object.
 *
 *          See H5Pset_evict_on_close() for additional notes on behavior.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pget_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") BoolPointer evict_on_close);
public static native @Cast("herr_t") int H5Pget_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") boolean[] evict_on_close);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves a data offset from the file access property list
 *
 * \fapl_id
 * @param offset [out] Offset in bytes within the HDF5 file
 *
 * @return \herr_t
 *
 * \details H5Pget_family_offset() retrieves the value of offset from the
 *          file access property list \p fapl_id so that the user
 *          application can retrieve a file handle for low-level access to
 *          a particular member of a family of files. The file handle is
 *          retrieved with a separate call to H5Fget_vfd_handle() (or,
 *          in special circumstances, to H5FDget_vfd_handle(), see \ref VFL).
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer offset);
public static native @Cast("herr_t") int H5Pget_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] offset);
/**
 * \ingroup FAPL
 *
 * \brief Returns the file close degree
 *
 * \fapl_id
 * @param degree [out] Pointer to a location to which to return the file
 *                    close degree property, the value of \p degree
 *
 * @return \herr_t
 *
 * \details H5Pget_fclose_degree() returns the current setting of the file
 *          close degree property \p degree in the file access property
 *          list \p fapl_id. The value of \p degree determines how
 *          aggressively H5Fclose() deals with objects within a file that
 *          remain open when H5Fclose() is called to close that file.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") IntPointer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") IntBuffer degree);
public static native @Cast("herr_t") int H5Pget_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t*") int[] degree);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves a copy of the file image designated as the initial content
 *        and structure of a file
 *
 * \fapl_id
 * @param buf_ptr_ptr [in,out] On input, \c NULL or a pointer to a
 *                pointer to a buffer that contains the
 *                file image.\n On successful return, if \p buf_ptr_ptr is not
 *                \c NULL, \Code{*buf_ptr_ptr} will contain a pointer to a copy
 *                of the initial image provided in the last call to
 *                H5Pset_file_image() for the supplied \p fapl_id. If no initial
 *                image has been set, \Code{*buf_ptr_ptr} will be \c NULL.
 * @param buf_len_ptr [in,out] On input, \c NULL or a pointer to a buffer
 *                specifying the required size of the buffer to hold the file
 *                image.\n On successful return, if \p buf_len_ptr was not
 *                passed in as \c NULL, \p buf_len_ptr will return the required
 *                size in bytes of the buffer to hold the initial file image in
 *                the supplied file access property list, \p fapl_id. If no
 *                initial image is set, the value of \Code{*buf_len_ptr} will be
 *                set to 0 (zero)
 * @return \herr_t
 *
 * \details H5Pget_file_image() allows an application to retrieve a copy of the
 *          file image designated for a VFD to use as the initial contents of a file.
 *
 *          If file image callbacks are defined, H5Pget_file_image() will use
 *          them when allocating and loading the buffer to return to the
 *          application (see H5Pset_file_image_callbacks()). If file image
 *          callbacks are not defined, the function will use \c malloc and \c
 *          memcpy. When \c malloc and \c memcpy are used, it is the caller’s
 *          responsibility to discard the returned buffer with a call to \c
 *          free.
 *
 *          It is the responsibility of the calling application to free the
 *          buffer whose address is returned in \p buf_ptr_ptr. This can be
 *          accomplished with \c free if file image callbacks have not been set
 *          (see H5Pset_file_image_callbacks()) or with the appropriate method
 *          if file image callbacks have been set.
 *
 * @see H5LTopen_file_image(), H5Fget_file_image(), H5Pset_file_image(),
 *      H5Pset_file_image_callbacks(), H5Pget_file_image_callbacks(),
 *      \ref H5FD_file_image_callbacks_t, \ref H5FD_file_image_op_t,
 *      <a href="https://portal.hdfgroup.org/display/HDF5/HDF5+File+Image+Operations">
 *      HDF5 File Image Operations</a>.
 *
 *
 * @since 1.8.9
 *
 */
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") long fapl_id, @Cast("void**") PointerPointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
public static native @Cast("herr_t") int H5Pget_file_image(@Cast("hid_t") long fapl_id, @Cast("void**") @ByPtrPtr Pointer buf_ptr_ptr, @Cast("size_t*") SizeTPointer buf_len_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves callback routines for working with file images
 *
 * \fapl_id
 * @param callbacks_ptr [in,out] Pointer to the instance of the
 *                #H5FD_file_image_callbacks_t struct in which the callback
 *                routines are to be returned\n
 *                Struct fields must be initialized to NULL before the call
 *                is made.\n
 *                Struct field contents upon return will match those passed in
 *                in the last H5Pset_file_image_callbacks() call for the file
 *                access property list \p fapl_id.
 * @return \herr_t
 *
 * \details H5Pget_file_image_callbacks() retrieves the callback routines set for
 *          working with file images opened with the file access property list
 *          \p fapl_id.
 *
 *          The callbacks must have been previously set with
 *          H5Pset_file_image_callbacks() in the file access property list.
 *
 *          Upon the successful return of H5Pset_file_image_callbacks(), the
 *          fields in the instance of the #H5FD_file_image_callbacks_t struct
 *          pointed to by \p callbacks_ptr will contain the same values as were
 *          passed in the most recent H5Pset_file_image_callbacks() call for the
 *          file access property list \p fapl_id.
 *
 * @see H5LTopen_file_image(), H5Fget_file_image(), H5Pset_file_image(),
 *      H5Pset_file_image_callbacks(), H5Pget_file_image_callbacks(),
 *      \ref H5FD_file_image_callbacks_t, \ref H5FD_file_image_op_t,
 *      <a href="https://portal.hdfgroup.org/display/HDF5/HDF5+File+Image+Operations">
 *      HDF5 File Image Operations</a>.
 *
 * @since 1.8.9
 *
 */
public static native @Cast("herr_t") int H5Pget_file_image_callbacks(@Cast("hid_t") long fapl_id, H5FD_file_image_callbacks_t callbacks_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the file locking property values
 *
 * \fapl_id
 * @param use_file_locking [out] File locking flag
 * @param ignore_when_disabled [out] Ignore when disabled flag
 * @return \herr_t
 *
 * \details H5Pget_file_locking() retrieves the file locking property values for
 *          the file access property list specified by \p fapl_id.
 *
 * @since 1.10.7
 *
 */
public static native @Cast("herr_t") int H5Pget_file_locking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") BoolPointer use_file_locking, @Cast("hbool_t*") BoolPointer ignore_when_disabled);
public static native @Cast("herr_t") int H5Pget_file_locking(@Cast("hid_t") long fapl_id, @Cast("hbool_t*") boolean[] use_file_locking, @Cast("hbool_t*") boolean[] ignore_when_disabled);
/**
 * \ingroup FAPL
 *
 * \brief Returns garbage collecting references setting
 *
 * \fapl_id
 * @param gc_ref [out] Flag returning the state of reference garbage
 *                    collection. A returned value of 1 indicates that
 *                    garbage collection is on while 0 indicates that
 *                    garbage collection is off.
 *
 * @return \herr_t
 *
 * \details H5Pget_gc_references() returns the current setting for the
 *          garbage collection references property from the specified
 *          file access property list. The garbage collection references
 *          property is set by H5Pset_gc_references().
 *
 * @since 1.2.0
 *
 */
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") IntPointer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") IntBuffer gc_ref);
public static native @Cast("herr_t") int H5Pget_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned*") int[] gc_ref);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves library version bounds settings that indirectly control
 *        the format versions used when creating objects
 *
 * \fapl_id{plist_id}
 * @param low [out]  The earliest version of the library that will be used
 *                  for writing objects
 * @param high [out] The latest version of the library that will be used for
 *                  writing objects
 *
 * @return \herr_t
 *
 * \details H5Pget_libver_bounds() retrieves the lower and upper bounds on
 *          the HDF5 library release versions that indirectly determine the
 *          object format versions used when creating objects in the file.
 *
 *          This property is retrieved from the file access property list
 *          specified by the parameter \p fapl_id.
 *
 *          The value returned in the parameters \p low and \p high is one
 *          of the enumerated values in the #H5F_libver_t struct, which is
 *          defined in H5Fpublic.h.
 *
 * @version 1.10.2 Add #H5F_LIBVER_V18 to the enumerated defines in
 *                 #H5F_libver_t
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") IntPointer low, @Cast("H5F_libver_t*") IntPointer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") IntBuffer low, @Cast("H5F_libver_t*") IntBuffer high);
public static native @Cast("herr_t") int H5Pget_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t*") int[] low, @Cast("H5F_libver_t*") int[] high);
/**
 * \ingroup FAPL
 *
 * \brief Get the current initial metadata cache configuration from the
 *        provided file access property list
 *
 * \fapl_id{plist_id}
 * @param config_ptr [in,out] Pointer to the instance of #H5AC_cache_config_t
 *                in which the current metadata cache configuration is to be
 *                reported
 * @return \herr_t
 *
 * \note The \c in direction applies only to the \ref H5AC_cache_config_t.version
 *       field. All other fields are \c out parameters.
 *
 * \details The fields of the #H5AC_cache_config_t structure are shown
 *           below:
 *           \snippet H5ACpublic.h H5AC_cache_config_t_snip
 *           \click4more
 *
 *          H5Pget_mdc_config() gets the initial metadata cache configuration
 *          contained in a file access property list and loads it into the
 *          instance of #H5AC_cache_config_t pointed to by the \p config_ptr
 *          parameter. This configuration is used when the file is opened.
 *
 *          Note that the version field of \Code{*config_ptr} must be
 *          initialized; this allows the library to support earlier versions of
 *          the #H5AC_cache_config_t structure.
 *
 *          See the overview of the metadata cache in the special topics section
 *          of the user guide for details on the configuration data returned. If
 *          you haven't read and understood that documentation, the results of
 *          this call will not make much sense.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_mdc_config(@Cast("hid_t") long plist_id, H5AC_cache_config_t config_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the metadata cache image configuration values for a file
 *        access property list
 *
 * \fapl_id{plist_id}
 * @param config_ptr [out] Pointer to metadata cache image configuration values
 * @return \herr_t
 *
 * \details H5Pget_mdc_image_config() retrieves the metadata cache image values
 *          into \p config_ptr for the file access property list specified in \p
 *          plist_id.
 *
 *          #H5AC_cache_image_config_t is defined as follows:
 *          \snippet H5ACpublic.h H5AC_cache_image_config_t_snip
 *          \click4more
 *
 * @since 1.10.1
 */
public static native @Cast("herr_t") int H5Pget_mdc_image_config(@Cast("hid_t") long plist_id, H5AC_cache_image_config_t config_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Gets metadata cache logging options
 *
 * \fapl_id{plist_id}
 * @param is_enabled [out] Flag whether logging is enabled
 * @param location [out] Location of log in UTF-8/ASCII (file path/name) (On
 *             Windows, this must be ASCII)
 * @param location_size [out] Size in bytes of the location string
 * @param start_on_access [out] Whether the logging begins as soon as the file is
 *             opened or created
 * @return \herr_t
 *
 * \details The metadata cache is a central part of the HDF5 library through
 *          which all file metadata reads and writes take place. File metadata
 *          is normally invisible to the user and is used by the library for
 *          purposes such as locating and indexing data. File metadata should
 *          not be confused with user metadata, which consists of attributes
 *          created by users and attached to HDF5 objects such as datasets via
 *          \ref H5A API calls.
 *
 *          Due to the complexity of the cache, a trace/logging feature has been
 *          created that can be used by HDF5 developers for debugging and
 *          performance analysis. The functions that control this functionality
 *          will normally be of use to a very limited number of developers
 *          outside of The HDF Group. The functions have been documented to help
 *          users create logs that can be sent with bug reports.
 *
 *          Control of the log functionality is straightforward. Logging is
 *          enabled via the H5Pset_mdc_log_options() function, which will modify
 *          the file access property list used to open or create a file. This
 *          function has a flag that determines whether logging begins at file
 *          open or starts in a paused state. Log messages can then be
 *          controlled via the H5Fstart_mdc_logging() / H5Fstop_mdc_logging()
 *          functions. H5Pget_mdc_log_options() can be used to examine a file
 *          access property list, and H5Fget_mdc_logging_status() will return
 *          the current state of the logging flags.
 *
 *          The log format is described in the
 *           <a href="https://bit.ly/2PG6fNv">Metadata Cache Logging</a> document.
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") BytePointer location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") ByteBuffer location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") byte[] location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") BytePointer location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") BoolPointer is_enabled, @Cast("char*") ByteBuffer location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") BoolPointer start_on_access);
public static native @Cast("herr_t") int H5Pget_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t*") boolean[] is_enabled, @Cast("char*") byte[] location,
                                     @Cast("size_t*") SizeTPointer location_size, @Cast("hbool_t*") boolean[] start_on_access);
/**
 * \ingroup FAPL
 *
 * \brief Returns the current metadata block size setting
 *
 * \fapl_id{fapl_id}
 * @param size [out] Minimum size, in bytes, of metadata block allocations
 *
 * @return \herr_t
 *
 * \details Returns the current minimum size, in bytes, of new
 *          metadata block allocations. This setting is retrieved from the
 *          file access property list \p fapl_id.
 *
 *          This value is set by H5Pset_meta_block_size() and is
 *          retrieved from the file access property list \p fapl_id.
 *
 * @since 1.4.0
 */
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] size);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the number of read attempts from a file access
 *        property list
 *
 * \fapl_id{plist_id}
 * @param attempts [out] The number of read attempts
 *
 * @return \herr_t
 *
 * \details H5Pget_metadata_read_attempts() retrieves the number of read
 *          attempts that is set in the file access property list \p plist_id.
 *
 *          For a default file access property list, the value retrieved
 *          will depend on whether the user sets the number of attempts via
 *          H5Pset_metadata_read_attempts():
 *
 *          <ul>
 *
 *          <li>If the number of attempts is set to N, the value
 *          returned will be N.
 *          <li>If the number of attempts is not set, the value returned
 *          will be the default for non-SWMR access (1). SWMR is short
 *          for single-writer/multiple-reader.
 *          </ul>
 *
 *          For the file access property list of a specified HDF5 file,
 *          the value retrieved will depend on how the file is opened
 *          and whether the user sets the number of read attempts via
 *          H5Pset_metadata_read_attempts():
 *
 *          <ul>
 *          <li>For a file opened with SWMR access:
 *
 *          <ul>
 *              <li> If the number of attempts is set to N, the value
 *              returned will be N.
 *              <li> If the number of attempts is not set, the value
 *              returned will be the default for SWMR access (100).
 *          </ul>
 *          <li>For a file opened without SWMR access, the value
 *          retrieved will always be the default for non-SWMR access
 *          (1). The value set via H5Pset_metadata_read_attempts() does
 *          not have any effect on non-SWMR access.
 *          </ul>
 *
 * \par Failure Modes
 * \parblock
 *
 * When the input property list is not a file access property list.
 *
 * When the library is unable to retrieve the number of read attempts from
 * the file access property list.
 *
 * \endparblock
 *
 * \par Examples
 * \parblock
 *
 * The first example illustrates the two cases for retrieving the number
 * of read attempts from a default file access property list.
 *
 * \include H5Pget_metadata_read_attempts.1.c
 *
 * The second example illustrates the two cases for retrieving the
 * number of read attempts from the file access property list of a file
 * opened with SWMR access.
 *
 * \include H5Pget_metadata_read_attempts.2.c
 *
 * The third example illustrates the two cases for retrieving the number
 * of read attempts from the file access property list of a file opened
 * with non-SWMR access.
 *
 * \include H5Pget_metadata_read_attempts.3.c
 *
 * \endparblock
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer attempts);
public static native @Cast("herr_t") int H5Pget_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] attempts);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves type of data property for MULTI driver
 *
 * @param fapl_id [in] File access property list or data transfer property
 *                     list identifier
 * @param type [out]    Type of data
 *
 * @return \herr_t
 *
 * \details H5Pget_multi_type() retrieves the type of data setting from
 *          the file access or data transfer property list \p fapl_id.
 *          This enables a user application to specify the type of data
 *          the application wishes to access so that the application can
 *          retrieve a file handle for low-level access to the particular
 *          member of a set of MULTI files in which that type of data is
 *          stored. The file handle is retrieved with a separate call to
 *          H5Fget_vfd_handle() (or, in special circumstances, to
 *          H5FDget_vfd_handle(); see the Virtual File Layer documentation
 *          for more information.
 *
 *          The type of data returned in \p type will be one of those
 *          listed in the discussion of the \p type parameter in the the
 *          description of the function H5Pset_multi_type().
 *
 *          Use of this function is only appropriate for an HDF5 file
 *          written as a set of files with the MULTI file driver.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntPointer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") IntBuffer type);
public static native @Cast("herr_t") int H5Pget_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t*") int[] type);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the object flush property values from the file access property list
 *
 * \fapl_id{plist_id}
 * @param func [in] The user-defined callback function
 * @param udata [in] The user-defined input data for the callback function
 *
 * @return \herr_t
 *
 * \details H5Pget_object_flush_cb() gets the user-defined callback
 *          function that is set in the file access property list
 *          \p fapl_id and stored in the parameter \p func. The callback is
 *          invoked whenever an object flush occurs in the file. This
 *          routine also obtains the user-defined input data that is
 *          passed along to the callback function in the parameter
 *          \p udata.
 *
 * \par Example
 * \parblock
 * The example below illustrates the usage of this routine to obtain the
 * object flush property values.
 *
 * \include H5Pget_object_flush_cb.c
 * \endparblock
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_object_flush_cb(@Cast("hid_t") long plist_id, @ByPtrPtr H5F_flush_cb_t func, @Cast("void**") @ByPtrPtr Pointer udata);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the maximum size for the page buffer and the minimum
          percentage for metadata and raw data pages
 *
 * \fapl_id{plist_id}
 * @param buf_size [out] Maximum size, in bytes, of the page buffer
 * @param min_meta_perc [out] Minimum metadata percentage to keep in the
 *             page buffer before allowing pages containing metadata to
 *             be evicted
 *
 * @param min_raw_perc [out] Minimum raw data percentage to keep in the
 *             page buffer before allowing pages containing raw data to
 *             be evicted
 *
 * @return \herr_t
 *
 * \details H5Pget_page_buffer_size() retrieves \p buf_size, the maximum
 *          size in bytes of the page buffer, \p min_meta_perc, the
 *          minimum metadata percentage, and \p min_raw_perc, the
 *          minimum raw data percentage.
 *
 * @since 1.10.1
 */
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") IntPointer min_meta_perc,
                                      @Cast("unsigned*") IntPointer min_raw_perc);
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") IntBuffer min_meta_perc,
                                      @Cast("unsigned*") IntBuffer min_raw_perc);
public static native @Cast("herr_t") int H5Pget_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t*") SizeTPointer buf_size, @Cast("unsigned*") int[] min_meta_perc,
                                      @Cast("unsigned*") int[] min_raw_perc);
/**
 * \ingroup FAPL
 *
 * \brief Returns maximum data sieve buffer size
 *
 * \fapl_id{fapl_id}
 * @param size [in] Maximum size, in bytes, of data sieve buffer
 *
 * @return \herr_t
 *
 * \details H5Pget_sieve_buf_size() retrieves, size, the current maximum
 *          size of the data sieve buffer.
 *
 *          This value is set by H5Pset_sieve_buf_size() and is retrieved
 *          from the file access property list fapl_id.
 *
 * @version 1.6.0 The \p size parameter has changed from type \c hsize_t
 *                to \c size_t
 * @since 1.4.0
 */
public static native @Cast("herr_t") int H5Pget_sieve_buf_size(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer size);
/**
 * \ingroup FAPL
 *
 * \brief Retrieves the current small data block size setting
 *
 * \fapl_id{fapl_id}
 * @param size [out] Maximum size, in bytes, of the small data block
 *
 * @return \herr_t
 *
 * \details H5Pget_small_data_block_size() retrieves the current setting
 *          for the size of the small data block.
 *
 *          If the returned value is zero (0), the small data block
 *          mechanism has been disabled for the file.
 *
 * @since 1.4.4
 */
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t*") long[] size);
/**
 * \ingroup FAPL
 *
 * \brief Returns the identifier of the current VOL connector
 *
 * \fapl_id{plist_id}
 * @param vol_id [out]  Current VOL connector identifier
 *
 * @return \herr_t
 *
 * \details H5Pget_vol_id() returns the VOL connector identifier \p vol_id for
 *          the file access property list \p plist_id. This identifier should
 *          be closed with H5VLclose().
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") LongPointer vol_id);
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") LongBuffer vol_id);
public static native @Cast("herr_t") int H5Pget_vol_id(@Cast("hid_t") long plist_id, @Cast("hid_t*") long[] vol_id);
/**
 * \ingroup FAPL
 *
 * \brief Returns a copy of the VOL information for a connector
 *
 * \fapl_id{plist_id}
 * @param vol_info [out]  The VOL information for a connector
 *
 * @return \herr_t
 *
 * \details H5Pget_vol_info() returns a copy of the VOL information \p vol_info
 *          for a connector specified by the file access property list
 *          \p plist_id.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Pget_vol_info(@Cast("hid_t") long plist_id, @Cast("void**") PointerPointer vol_info);
public static native @Cast("herr_t") int H5Pget_vol_info(@Cast("hid_t") long plist_id, @Cast("void**") @ByPtrPtr Pointer vol_info);
/**
 * \ingroup FAPL
 *
 * \brief Sets alignment properties of a file access property list
 *
 * \fapl_id
 * @param threshold [in] Threshold value. Note that setting the threshold
 *                      value to 0 (zero) has the effect of a special case,
 *                      forcing everything to be aligned
 * @param alignment [in] Alignment value
 *
 * @return \herr_t
 *
 * \details H5Pset_alignment() sets the alignment properties of a
 *          file access property list so that any file object greater
 *          than or equal in size to \p threshold bytes will be aligned
 *          on an address which is a multiple of \p alignment. The
 *          addresses are relative to the end of the user block; the
 *          alignment is calculated by subtracting the user block size
 *          from the absolute file address and then adjusting the address
 *          to be a multiple of \p alignment.
 *
 *          Default values for \p threshold and \p alignment are one,
 *          implying no alignment. Generally the default values will
 *          result in the best performance for single-process access to
 *          the file. For MPI IO and other parallel systems, choose an
 *          alignment which is a multiple of the disk block size.
 *
 *          If the file space handling strategy is set to
 *          #H5F_FSPACE_STRATEGY_PAGE, then the alignment set via this
 *          routine is ignored. The file space handling strategy is set
 *          by H5Pset_file_space_strategy().
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_alignment(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long threshold, @Cast("hsize_t") long alignment);
/**
 * \ingroup FAPL
 *
 * \brief Sets the raw data chunk cache parameters
 *
 * \fapl_id{plist_id}
 * @param mdc_nelmts [in] No longer used; any value passed is ignored
 * @param rdcc_nslots [in] The number of chunk slots in the raw data chunk
 *                        cache for this dataset. Increasing this value
 *                        reduces the number of cache collisions, but
 *                        slightly increases the memory used. Due to the
 *                        hashing strategy, this value should ideally be a
 *                        prime number. As a rule of thumb, this value
 *                        should be at least 10 times the number of chunks
 *                        that can fit in \p rdcc_nbytes bytes. For
 *                        maximum performance, this value should be set
 *                        approximately 100 times that number of chunks.
 *                        The default value is 521.
 * @param rdcc_nbytes [in] Total size of the raw data chunk cache in bytes.
 *                        The default size is 1 MB per dataset.
 * @param rdcc_w [in] 0     The chunk preemption policy for all datasets.
 *                        This must be between 0 and 1 inclusive and
 *                        indicates the weighting according to which chunks
 *                        which have been fully read or written are
 *                        penalized when determining which chunks to flush
 *                        from cache. A value of 0 means fully read or
 *                        written chunks are treated no differently than
 *                        other chunks (the preemption is strictly LRU)
 *                        while a value of 1 means fully read or written
 *                        chunks are always preempted before other chunks.
 *                        If your application only reads or writes data once,
 *                        this can be safely set to 1. Otherwise, this should
 *                        be set lower depending on how often you re-read or
 *                        re-write the same data. The default value is 0.75.
 *                        If the value passed is #H5D_CHUNK_CACHE_W0_DEFAULT,
 *                        then the property will not be set on the dataset
 *                        access property list, and the parameter will come
 *                        from the file access property list.
 *
 * @return \herr_t
 *
 * \details H5Pset_cache() sets the number of elements, the total number of
 *          bytes, and the preemption policy value for all datasets in a file
 *          on the file’s file access property list.
 *
 *          The raw data chunk cache inserts chunks into the cache by first
 *          computing a hash value using the address of a chunk and then by
 *          using that hash value as the chunk’s index into the table of
 *          cached chunks. In other words, the size of this hash table and the
 *          number of possible hash values is determined by the \p rdcc_nslots
 *          parameter. If a different chunk in the cache has the same hash value,
 *          a collision will occur, which will reduce efficiency. If inserting
 *          the chunk into the cache would cause the cache to be too big, then
 *          the cache will be pruned according to the \p rdcc_w0 parameter.
 *
 *          The \p mdc_nelmts parameter is no longer used; any value passed
 *          in that parameter will be ignored.
 *
 *      \b Motivation: Setting raw data chunk cache parameters
 *       can be done with H5Pset_cache(), H5Pset_chunk_cache(),
 *       or a combination of both. H5Pset_cache() is used to
 *       adjust the chunk cache parameters for all datasets via
 *       a global setting for the file, and H5Pset_chunk_cache()
 *       is used to adjust the chunk cache parameters for
 *       individual datasets. When both are used, parameters
 *       set with H5Pset_chunk_cache() will override any parameters
 *       set with H5Pset_cache().
 *
 * \note Optimum chunk cache parameters may vary widely depending
 *       on different data layout and access patterns. For datasets
 *       with low performance requirements for example, changing
 *       the cache settings can save memory.
 *
 * \note Note: Raw dataset chunk caching is not currently
 *       supported when using the MPI I/O and MPI POSIX file drivers
 *       in read/write mode; see H5Pset_fapl_mpio(). When using this
 *       file driver, all calls to H5Dread() and H5Dwrite() will access
 *       the disk directly, and H5Pset_cache() will have no effect on
 *       performance.
 *
 * \note Raw dataset chunk caching is supported when these drivers are
 *       used in read-only mode.
 *
 * @version 1.8.0 The use of the \p mdc_nelmts parameter was discontinued.
 *                Metadata cache configuration is managed with
 *                H5Pset_mdc_config() and H5Pget_mdc_config().
 * @version 1.6.0 The \p rdcc_nbytes and \p rdcc_nelmts parameters
 *                changed from type int to size_t.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_cache(@Cast("hid_t") long plist_id, int mdc_nelmts, @Cast("size_t") long rdcc_nslots, @Cast("size_t") long rdcc_nbytes,
                           double rdcc_w0);
/**
 * \ingroup FAPL
 *
 * \brief Sets write tracking information for core driver, #H5FD_CORE
 *
 * \fapl_id{fapl_id}
 * @param is_enabled [in] Boolean value specifying whether feature is
                         enabled
 * @param page_size [in] Positive integer specifying size, in bytes, of
 *                      write aggregation pages Value of 1 (one) enables
 *                      tracking with no paging.
 *
 * @return \herr_t
 *
 * \details When a file is created or opened for writing using the core
 *          virtual file driver (VFD) with the backing store option
 *          turned on, the core driver can be configured to track
 *          changes to the file and write out only the modified bytes.
 *
 *          This write tracking feature is enabled and disabled with \p
 *          is_enabled. The default setting is that write tracking is
 *          disabled, or off.
 *
 *          To avoid a large number of small writes, changes can
 *          be aggregated into pages of a user-specified size, \p
 *          page_size.
 *
 *          Setting \p page_size to 1 enables tracking with no page
 *          aggregation.
 *
 *          The backing store option is set via the function
 *          H5Pset_fapl_core.
 *
 * \attention
 * \parblock
 *            This function is only for use with the core VFD and must
 *            be used after the call to H5Pset_fapl_core(). It is an error
 *            to use this function with any other VFD.
 *
 *            It is an error to use this function when the backing store
 *            flag has not been set using H5Pset_fapl_core().
 *
 *            This function only applies to the backing store write
 *            operation which typically occurs when the file is flushed
 *            or closed. This function has no relationship to the
 *            increment parameter passed to H5Pset_fapl_core().
 *
 *            For optimum performance, the \p page_size parameter should be
 *            a power of two.
 *
 *            It is an error to set the page size to 0.
 * \endparblock
 *
 * @version 1.8.14 C function modified in this release to return error
 *                 if \p page_size is set to 0 (zero).
 * @since 1.8.13
 *
 */
public static native @Cast("herr_t") int H5Pset_core_write_tracking(@Cast("hid_t") long fapl_id, @Cast("hbool_t") boolean is_enabled, @Cast("size_t") long page_size);
/**
 * \ingroup FAPL
 *
 * \brief Sets a file driver
 *
 * \plist_id
 * @param driver_id [in]   The new driver identifier
 * @param driver_info [in] Optional struct containing driver properties
 *
 * @return \herr_t
 *
 * \details H5Pset_driver() sets the file driver, driver_id, for a file
 *          access or data transfer property list, \p plist_id, and
 *          supplies an optional struct containing the driver-specific
 *          properties, \p driver_info.
 *
 *          The driver properties will be copied into the property list
 *          and the reference count on the driver will be incremented,
 *          allowing the caller to close the driver identifier but still
 *          use the property list.
 *
 * @version 1.8.2 Function publicized in this release; previous releases
 *                described this function only in the virtual file driver
 *                documentation.
 *
 */
public static native @Cast("herr_t") int H5Pset_driver(@Cast("hid_t") long plist_id, @Cast("hid_t") long driver_id, @Const Pointer driver_info);
/**
 * \ingroup FAPL
 *
 * \brief Sets the number of files that can be held open in an external
 *        link open file cache
 *
 * \par Motivation
 * \parblock
 * The <em>external link open file cache</em> holds files open after
 * they have been accessed via an external link. This cache reduces
 * the number of times such files are opened when external links are
 * accessed repeatedly and can significantly improves performance in
 * certain heavy-use situations and when low-level file opens or closes
 * are expensive.
 *
 * H5Pset_elink_file_cache_size() sets the number of files
 * that will be held open in an external link open file
 * cache. H5Pget_elink_file_cache_size() retrieves the size of an existing
 * cache; and H5Fclear_elink_file_cache() clears an existing cache without
 * closing it.
 * \endparblock
 *
 * \fapl_id{plist_id}
 * @param efc_size [in] External link open file cache size in number of files
 *                     <em>Default setting is 0 (zero).</em>
 *
 * @return \herr_t
 *
 * \details H5Pset_elink_file_cache_size() specifies the number of files
 *          that will be held open in an external link open file cache.
 *
 *          The default external link open file cache size is 0 (zero),
 *          meaning that files accessed via an external link are not
 *          held open. Setting the cache size to a positive integer
 *          turns on the cache; setting the size back to zero turns it
 *          off.
 *
 *          With this property set, files are placed in the external
 *          link open file cache cache when they are opened via an
 *          external link. Files are then held open until either
 *          they are evicted from the cache or the parent file is
 *          closed. This property setting can improve performance when
 *          external links are repeatedly accessed.
 *
 *          When the cache is full, files will be evicted using a least
 *          recently used (LRU) scheme; the file which has gone the
 *          longest time without being accessed through the parent file
 *          will be evicted and closed if nothing else is holding that
 *          file open.
 *
 *          Files opened through external links inherit the parent
 *          file’s file access property list by default, and therefore
 *          inherit the parent file’s external link open file cache
 *          setting.
 *
 *          When child files contain external links of their own, the
 *          caches can form a graph of cached external files. Closing
 *          the last external reference to such a graph will recursively
 *          close all files in the graph, even if cycles are present.
 * \par Example
 * \parblock
 * The following code sets up an external link open file cache that will
 * hold open up to 8 files reached through external links:
 *
 * <pre>{@code
 * status = H5Pset_elink_file_cache_size(fapl_id, 8);
 * }</pre>
 * \endparblock
 *
 * @since 1.8.7
 */
public static native @Cast("herr_t") int H5Pset_elink_file_cache_size(@Cast("hid_t") long plist_id, @Cast("unsigned") int efc_size);
/**
 * \ingroup FAPL
 *
 * \brief Controls the library's behavior of evicting metadata associated with
 *        a closed object
 *
 * \fapl_id
 * @param evict_on_close [in] Whether the HDF5 object should be evicted on close
 *
 * @return \herr_t
 *
 * \details The library's metadata cache is fairly conservative about holding
 *          on to HDF5 object metadata(object headers, chunk index structures,
 *          etc.), which can cause the cache size to grow, resulting in memory
 *          pressure on an application or system. When enabled, the "evict on
 *          close" property will cause all metadata for an object to be evicted
 *          from the cache as long as metadata is not referenced by any other
 *          open object.
 *
 *          This function only applies to file access property lists.
 *
 *          The default library behavior is to not evict on object or file
 *          close.
 *
 *          When applied to a file access property list, any subsequently opened
 *          object will inherit the "evict on close" property and will have
 *          its metadata evicted when the object is closed.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pset_evict_on_close(@Cast("hid_t") long fapl_id, @Cast("hbool_t") boolean evict_on_close);
/**
 * \ingroup FAPL
 *
 * \brief Sets offset property for low-level access to a file in a family of
 *        files
 *
 * \fapl_id
 * @param offset [in] Offset in bytes within the HDF5 file
 *
 * @return \herr_t
 *
 * \details H5Pset_family_offset() sets the offset property in the file access
 *          property list \p fapl_id so that the user application can
 *          retrieve a file handle for low-level access to a particular member
 *          of a family of files. The file handle is retrieved with a separate
 *          call to H5Fget_vfd_handle() (or, in special circumstances, to
 *          H5FDget_vfd_handle(); see \ref VFL).
 *
 *          The value of \p offset is an offset in bytes from the beginning of
 *          the HDF5 file, identifying a user-determined location within the
 *          HDF5 file.
 *          The file handle the user application is seeking is for the specific
 *          member-file in the associated family of files to which this offset
 *          is mapped.
 *
 *          Use of this function is only appropriate for an HDF5 file written as
 *          a family of files with the \c FAMILY file driver.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_family_offset(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long offset);
/**
 * \ingroup FAPL
 *
 * \brief Sets the file close degree
 *
 * \fapl_id
 * @param degree [in] Pointer to a location containing the file close
 *           degree property, the value of \p degree
 *
 * @return \herr_t
 *
 * \details H5Pset_fclose_degree() sets the file close degree property
 *          \p degree in the file access property list \p fapl_id.
 *
 *          The value of \p degree determines how aggressively
 *          H5Fclose() deals with objects within a file that remain open
 *          when H5Fclose() is called to close that file. \p degree can
 *          have any one of four valid values:
 *
 *          <table>
 *           <tr>
 *            <th>Degree name</th>
 *            <th>H5Fclose behavior with no open object in file</th>
 *            <th>H5Fclose behavior with open object(s) in file</th>
 *           </tr>
 *           <tr>
 *            <td>#H5F_CLOSE_WEAK</td>
 *            <td>Actual file is closed.</td>
 *            <td>Access to file identifier is terminated; actual file
 *                close is delayed until all objects in file are closed
 *            </td>
 *           </tr>
 *           <tr>
 *            <td>#H5F_CLOSE_SEMI</td>
 *            <td>Actual file is closed.</td>
 *            <td>Function returns FAILURE</td>
 *           </tr>
 *           <tr>
 *            <td>#H5F_CLOSE_STRONG</td>
 *            <td>Actual file is closed.</td>
 *            <td>All open objects remaining in the file are closed then
 *                file is closed</td>
 *           </tr>
 *           <tr>
 *            <td>#H5F_CLOSE_DEFAULT</td>
 *            <td>The VFL driver chooses the behavior. Currently, all VFL
 *            drivers set this value to #H5F_CLOSE_WEAK, except for the
 *            MPI-I/O driver, which sets it to #H5F_CLOSE_SEMI.</td>
 *            <td></td>
 *           </tr>
 *
 *          </table>
 * \warning If a file is opened multiple times without being closed, each
 *          open operation must use the same file close degree setting.
 *          For example, if a file is already open with #H5F_CLOSE_WEAK,
 *          an H5Fopen() call with #H5F_CLOSE_STRONG will fail.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_fclose_degree(@Cast("hid_t") long fapl_id, @Cast("H5F_close_degree_t") int degree);
/**
 * \ingroup FAPL
 *
 * \brief Sets an initial file image in a memory buffer
 *
 * \fapl_id
 * @param buf_ptr [in] Pointer to the initial file image, or
 *                    NULL if no initial file image is desired
 * @param buf_len [in] Size of the supplied buffer, or
 *                    0 (zero) if no initial image is desired
 *
 * @return \herr_t
 *
 * \details H5Pset_file_image() allows an application to provide a file image
 *          to be used as the initial contents of a file.
 *          Calling H5Pset_file_image()makes a copy of the buffer specified in
 *          \p buf_ptr of size \p buf_len.
 *
 *          \par Motivation:
 *          H5Pset_file_image() and other elements of HDF5 are
 *          used to load an image of an HDF5 file into system memory and open
 *          that image as a regular HDF5 file. An application can then use the
 *          file without the overhead of disk I/O.
 *
 *          \par Recommended Reading:
 *          This function is part of the file image
 *          operations feature set. It is highly recommended to study the guide
 *          [<em>HDF5 File Image Operations</em>]
 *          (https://portal.hdfgroup.org/display/HDF5/HDF5+File+Image+Operations
 *          ) before using this feature set. See the “See Also” section below
 *          for links to other elements of HDF5 file image operations.
 *
 * @see
 *    \li H5LTopen_file_image()
 *    \li H5Fget_file_image()
 *    \li H5Pget_file_image()
 *    \li H5Pset_file_image_callbacks()
 *    \li H5Pget_file_image_callbacks()
 *
 *    \li [HDF5 File Image Operations]
 *        (https://portal.hdfgroup.org/display/HDF5/HDF5+File+Image+Operations)
 *        in [Advanced Topics in HDF5]
 *        (https://portal.hdfgroup.org/display/HDF5/Advanced+Topics+in+HDF5)
 *
 *    \li Within H5Pset_file_image_callbacks():
 *    \li Callback #H5FD_file_image_callbacks_t
 *    \li Callback #H5FD_file_image_op_t
 *
 * @version 1.8.13 Fortran subroutine added in this release.
 * @since 1.8.9
 *
 */
public static native @Cast("herr_t") int H5Pset_file_image(@Cast("hid_t") long fapl_id, Pointer buf_ptr, @Cast("size_t") long buf_len);
/**
 * \ingroup FAPL
 *
 * \brief Sets the callbacks for working with file images
 *
 * \note      **Motivation:** H5Pset_file_image_callbacks() and other elements
 *            of HDF5 are used to load an image of an HDF5 file into system
 *            memory and open that image as a regular HDF5 file. An application
 *            can then use the file without the overhead of disk I/O.\n
 *            **Recommended Reading:** This function is part of the file
 *            image operations feature set. It is highly recommended to study
 *            the guide [HDF5 File Image Operations]
 *            (https://portal.hdfgroup.org/display/HDF5/HDF5+File+Image+Operations
 *            ) before using this feature set. See the “See Also” section below
 *            for links to other elements of HDF5 file image operations.
 *
 * \fapl_id
 * @param callbacks_ptr [in,out] Pointer to the instance of the
 *                #H5FD_file_image_callbacks_t structure
 *
 * @return \herr_t \n
 *         **Failure Modes**: Due to interactions between this function and
 *         H5Pset_file_image() and H5Pget_file_image(),
 *         H5Pset_file_image_callbacks() will fail if a file image has
 *         already been set in the target file access property list, \p fapl_id.
 *
 * \details H5Pset_file_image_callbacks() sets callback functions for working
 *          with file images in memory.
 *
 *          H5Pset_file_image_callbacks() allows an application to control the
 *          management of file image buffers through user defined callbacks.
 *          These callbacks can be used in the management of file image buffers
 *          in property lists and with certain file drivers.
 *
 *          H5Pset_file_image_callbacks() must be used before any file image has
 *          been set in the file access property list. Once a file image has
 *          been set, the function will fail.
 *
 *          The callback routines set up by H5Pset_file_image_callbacks() are
 *          invoked when a new file image buffer is allocated, when an existing
 *          file image buffer is copied or resized, or when a file image buffer
 *          is released from use.
 *
 *          Some file drivers allow the use of user-defined callback functions
 *          for allocating, freeing, and copying the driver’s internal buffer,
 *          potentially allowing optimizations such as avoiding large \c malloc
 *          and \c memcpy operations, or to perform detailed logging.
 *
 *          From the perspective of the HDF5 library, the operations of the
 *          \ref H5FD_file_image_callbacks_t.image_malloc "image_malloc",
 *          \ref H5FD_file_image_callbacks_t.image_memcpy "image_memcpy",
 *          \ref H5FD_file_image_callbacks_t.image_realloc "image_realloc", and
 *          \ref H5FD_file_image_callbacks_t.image_free "image_free" callbacks
 *          must be identical to those of the
 *          corresponding C standard library calls (\c malloc, \c memcpy,
 *          \c realloc, and \c free). While the operations must be identical,
 *          the file image callbacks have more parameters. The return values
 *          of \ref H5FD_file_image_callbacks_t.image_malloc "image_malloc" and
 *          \ref H5FD_file_image_callbacks_t.image_realloc "image_realloc" are identical to
 *          the return values of \c malloc and \c realloc. The return values of
 *          \ref H5FD_file_image_callbacks_t.image_malloc "image_malloc" and
 *          \ref H5FD_file_image_callbacks_t.image_free "image_free" differ from the return
 *          values of \c memcpy and \c free in that the return values of
 *          \ref H5FD_file_image_callbacks_t.image_memcpy "image_memcpy" and
 *          \ref H5FD_file_image_callbacks_t.image_free "image_free" can also indicate failure.
 *
 *          The callbacks and their parameters, along with a struct and
 *          an \c ENUM required for their use, are described below.
 *
 *          <b>Callback struct and \c ENUM:</b>
 *
 *          The callback functions set up by H5Pset_file_image_callbacks() use
 *          a struct and an \c ENUM that are defined as follows
 *
 *          The struct #H5FD_file_image_callbacks_t serves as a container
 *          for the callback functions and a pointer to user-supplied data.
 *          The struct is defined as follows:
 *          \snippet H5FDpublic.h H5FD_file_image_callbacks_t_snip
 *
 *          Elements of the #H5FD_file_image_op_t are used by the
 *          callbacks to invoke certain operations on file images. The ENUM is
 *          defined as follows:
 *          \snippet H5FDpublic.h H5FD_file_image_op_t_snip
 *
 *          The elements of the #H5FD_file_image_op_t are used in the following
 *          callbacks:
 *
 *          - The \ref H5FD_file_image_callbacks_t.image_malloc "image_malloc" callback
 *          contains a pointer to a function that must appear to HDF5 to have
 *          functionality identical to that of the standard C library \c malloc() call.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h image_malloc_snip
 *          \n
 *          - The \ref H5FD_file_image_callbacks_t.image_memcpy "image_memcpy"
 *          callback contains a pointer to a function
 *          that must appear to HDF5 to have functionality identical to that
 *          of the standard C library \c memcopy() call, except that it returns
 *          a \p NULL on failure. (The \c memcpy C Library routine is defined
 *          to return the \p dest parameter in all cases.)
 *
 *          - Setting \ref H5FD_file_image_callbacks_t.image_memcpy "image_memcpy"
 *          to \c NULL indicates that HDF5 should invoke
 *          the standard C library \c memcpy() routine when copying buffers.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h image_memcpy_snip
 *          \n
 *          - The \ref H5FD_file_image_callbacks_t.image_realloc "image_realloc" callback
 *          contains a pointer to a function that must appear to HDF5 to have
 *          functionality identical to that of the standard C library \c realloc() call.
 *
 *          - Setting \ref H5FD_file_image_callbacks_t.image_realloc "image_realloc"
 *          to \p NULL indicates that HDF5 should
 *          invoke the standard C library \c realloc() routine when resizing
 *          file image buffers.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h image_realloc_snip
 *          \n
 *          - The \ref H5FD_file_image_callbacks_t.image_free "image_free" callback contains
 *          a pointer to a function that must appear to HDF5 to have functionality
 *          identical to that of the standard C library \c free() call, except
 *          that it will return \c 0 (\c SUCCEED) on success and \c -1 (\c FAIL) on failure.
 *
 *          - Setting \ref H5FD_file_image_callbacks_t.image_free "image_free"
 *          to \c NULL indicates that HDF5 should invoke
 *          the standard C library \c free() routine when releasing file image
 *          buffers.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h image_free_snip
 *          \n
 *          - The  \ref H5FD_file_image_callbacks_t.udata_copy "udata_copy"
 *          callback contains a pointer to a function
 *          that, from the perspective of HDF5, allocates a buffer of suitable
 *          size, copies the contents of the supplied \p udata into the new
 *          buffer, and returns the address of the new buffer. The function
 *          returns NULL on failure. This function is necessary if a non-NULL
 *          \p udata parameter is supplied, so that property lists containing
 *          the image callbacks can be copied. If the \p udata parameter below
 *          is \c NULL, then this parameter should be \c NULL as well.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h udata_copy_snip
 *          \n
 *          - The \ref H5FD_file_image_callbacks_t.udata_free "udata_free"
 *          callback contains a pointer to a function
 *          that, from the perspective of HDF5, frees a user data block. This
 *          function is necessary if a non-NULL udata parameter is supplied so
 *          that property lists containing image callbacks can be discarded
 *          without a memory leak. If the udata parameter below is \c NULL,
 *          this parameter should be \c NULL as well.
 *
 *          - Signature in #H5FD_file_image_callbacks_t:
 *          \snippet H5FDpublic.h udata_free_snip
 *
 *          - \p **udata**, the final field in the #H5FD_file_image_callbacks_t
 *          struct, provides a pointer to user-defined data. This pointer will
 *          be passed to the
 *          \ref H5FD_file_image_callbacks_t.image_malloc "image_malloc",
 *          \ref H5FD_file_image_callbacks_t.image_memcpy "image_memcpy",
 *          \ref H5FD_file_image_callbacks_t.image_realloc "image_realloc", and
 *          \ref H5FD_file_image_callbacks_t.image_free "image_free" callbacks.
 *          Define udata as \c NULL if no user-defined data is provided.
 *
 * @since 1.8.9
 *
 */
public static native @Cast("herr_t") int H5Pset_file_image_callbacks(@Cast("hid_t") long fapl_id, H5FD_file_image_callbacks_t callbacks_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Sets the file locking property values
 *
 * \fapl_id
 * @param use_file_locking [in] Toggle to specify file locking (or not)
 * @param ignore_when_disabled [in] Toggle to ignore when disabled (or not)
 *
 * @return \herr_t
 *
 * \details H5Pset_file_locking() overrides the default file locking flag
 *          setting that was set when the library was configured.
 *
 *          This setting can be overridden by the \c HDF5_USE_FILE_LOCKING
 *          environment variable.
 *
 *          File locking is used when creating/opening a file to prevent
 *          problematic file accesses.
 *
 * @since 1.10.7
 *
 */
public static native @Cast("herr_t") int H5Pset_file_locking(@Cast("hid_t") long fapl_id, @Cast("hbool_t") boolean use_file_locking, @Cast("hbool_t") boolean ignore_when_disabled);
/**
 * \ingroup FAPL
 *
 * \brief Sets garbage collecting references flag
 *
 * \fapl_id
 * @param gc_ref [in] Flag setting reference garbage collection to on (1) or off (0)
 *
 * @return \herr_t
 *
 * \details H5Pset_gc_references() sets the flag for garbage collecting
 *          references for the file.
 *
 *          Dataset region references and other reference types use space in an
 *          HDF5 file's global heap. If garbage collection is on and the user
 *          passes in an uninitialized value in a reference structure, the heap
 *          might get corrupted. When garbage collection is off, however, and
 *          the user re-uses a reference, the previous heap block will be
 *          orphaned and not returned to the free heap space.
 *
 *          When garbage collection is on, the user must initialize the
 *          reference structures to 0 or risk heap corruption.
 *
 *          The default value for garbage collecting references is off.
 *
 */
public static native @Cast("herr_t") int H5Pset_gc_references(@Cast("hid_t") long fapl_id, @Cast("unsigned") int gc_ref);
/**
 * \ingroup FAPL
 *
 * \brief Controls the range of library release versions used when creating
 *        objects in a file
 *
 * \fapl_id{plist_id}
 * @param low [in]  The earliest version of the library that will be used
 *                 for writing objects
 * @param high [in] The latest version of the library that will be used for
 *                 writing objects
 *
 * @return \herr_t
 *
 * \details H5Pset_libver_bounds() controls the range of library release
 *          versions that will be used when creating objects in a file.
 *          The object format versions are determined indirectly from the
 *          library release versions specified in the call.
 *
 *          This property is set in the file access property list
 *          specified by the parameter \p fapl_id.
 *
 *          The parameter \p low sets the earliest possible format
 *          versions that the library will use when creating objects in
 *          the file.  Note that earliest possible is different from
 *          earliest, as some features introduced in library versions
 *          later than 1.0.0 resulted in updates to object formats.
 *          The parameter \p high sets the latest format versions that
 *          the library will be allowed to use when creating objects in
 *          the file.
 *
 *          The parameters \p low and \p high must be one of the
 *          enumerated values in the #H5F_libver_t struct, which is
 *          defined in H5Fpublic.h.
 *
 *          The macro #H5F_LIBVER_LATEST is aliased to the highest
 *          enumerated value in #H5F_libver_t, indicating that this is
 *          currently the latest format available.
 *
 *          The library supports the following five pairs of
 *          (\p low, \p high) combinations as derived from the values
 *          in #H5F_libver_t:
 *
 *          <table>
 *           <tr>
 *            <th>Value of \p low and \p high</th>
 *            <th>Result</th>
 *           </tr>
 *           <tr>
 *            <td>\p low=#H5F_LIBVER_EARLIEST<br />
 *                \p high=#H5F_LIBVER_V18</td>
 *            <td>
 *              \li The library will create objects with the earliest
 *                  possible format versions.
 *              \li The library will allow objects to be created with the
 *                  latest format versions available to library release 1.8.x.
 *              \li API calls that create objects or features that are
 *                  available to versions of the library greater than 1.8.x
 *                  release will fail.
 *             </td>
 *           </tr>
 *           <tr>
 *            <td>\p low=#H5F_LIBVER_EARLIEST<br />
 *                \p high=#H5F_LIBVER_V110</td>
 *            <td>
 *             \li The library will create objects with the earliest possible
 *                 format versions.
 *             \li The library will allow objects to be created with the latest
 *                 format versions available to library release 1.10.x.
 *                 Since 1.10.x is also #H5F_LIBVER_LATEST, there is no upper
 *                 limit on the format versions to use.  For example, if a newer
 *                 format version is required to support a feature e.g. virtual
 *                 dataset, this setting will allow the object to be created.
 *             \li This is the library default setting and provides the greatest
 *                 format compatibility.
 *            </td>
 *           </tr>
 *           <tr>
 *            <td>\p low=#H5F_LIBVER_V18<br />
 *                \p high=#H5F_LIBVER_V18</td>
 *            <td>
 *             \li The library will create objects with the latest format
 *                 versions available to library release 1.8.x.
 *             \li API calls that create objects or features that are available
 *                 to versions of the library greater than 1.8.x release will
 *                 fail.
 *             \li Earlier versions of the library may not be able to access
 *                 objects created with this setting.</td>
 *           </tr>
 *           <tr>
 *            <td>\p low=#H5F_LIBVER_V18<br />
 *                \p high=#H5F_LIBVER_V110</td>
 *            <td>
 *              \li The library will create objects with the latest format
 *                  versions available to library release 1.8.x.
 *              \li The library will allow objects to be created with the latest
 *                  format versions available to library release 1.10.x.
 *                  Since 1.10.x is also #H5F_LIBVER_LATEST, there is no upper
 *                  limit on the format versions to use.  For example, if a
 *                  newer format version is required to support a feature e.g.
 *                  virtual dataset, this setting will allow the object to be
 *                  created.
 *              \li Earlier versions of the library may not be able to access
 *                  objects created with this setting.</td>
 *           </tr>
 *           <tr>
 *            <td>\p low=#H5F_LIBVER_V110<br />
 *                \p high=#H5F_LIBVER_V110
 *             </td>
 *             <td>
 *              \li The library will create objects with the latest format
 *                  versions available to library release 1.10.x.
 *              \li The library will allow objects to be created with the latest
 *                  format versions available to library release 1.10.x.
 *                  Since 1.10.x is also #H5F_LIBVER_LATEST, there is no upper
 *                  limit on the format versions to use. For example, if a
 *                  newer format version is required to support a feature e.g.
 *                  virtual dataset, this setting will allow the object to be
 *                  created.
 *              \li This setting allows users to take advantage of the latest
 *                  features and performance enhancements in the library.
 *                  However, objects written with this setting may be
 *                  accessible to a smaller range of library versions than
 *                  would be the case if low is set to #H5F_LIBVER_EARLIEST.
 *              \li Earlier versions of the library may not be able to access
 *                  objects created with this
 * setting.
 *            </td>
 *           </tr>
 *          </table>
 *
 * @version 1.10.2 #H5F_LIBVER_V18 added to the enumerated defines in
 *                 #H5F_libver_t.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_libver_bounds(@Cast("hid_t") long plist_id, @Cast("H5F_libver_t") int low, @Cast("H5F_libver_t") int high);
/**
 * \ingroup FAPL
 *
 * \brief Set the initial metadata cache configuration in the indicated File
 *        Access Property List to the supplied value
 *
 * \fapl_id{plist_id}
 * @param config_ptr [in]  Pointer to the instance of \p H5AC_cache_config_t
 *            containing the desired configuration
 * @return \herr_t
 *
 *  \details The fields of the #H5AC_cache_config_t structure are shown
 *           below:
 *           \snippet H5ACpublic.h H5AC_cache_config_t_snip
 *           \click4more
 *
 * \details H5Pset_mdc_config() attempts to set the initial metadata cache
 *          configuration to the supplied value.  It will fail if an invalid
 *          configuration is detected.  This configuration is used when the file
 *          is opened.
 *
 *          See the overview of the metadata cache in the special topics section
 *          of the user manual for details on what is being configured. If you
 *          have not read and understood that documentation, you really should
 *          not be using this API call.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_mdc_config(@Cast("hid_t") long plist_id, H5AC_cache_config_t config_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Sets metadata cache logging options
 *
 * \fapl_id{plist_id}
 * @param is_enabled [in]  Whether logging is enabled
 * @param location [in] Location of log in UTF-8/ASCII (file path/name)
 *            (On Windows, this must be ASCII)
 * @param start_on_access [in]  Whether the logging will begin as soon as the
 *            file is opened or created
 *
 * @return \herr_t
 *
 * \details The metadata cache is a central part of the HDF5 library through
 *          which all file metadata reads and writes take place. File metadata
 *          is normally invisible to the user and is used by the library for
 *          purposes such as locating and indexing data. File metadata should
 *          not be confused with user metadata, which consists of attributes
 *          created by users and attached to HDF5 objects such as datasets via
 *          H5A API calls.
 *
 *          Due to the complexity of the cache, a trace/logging feature has
 *          been created that can be used by HDF5 developers for debugging and
 *          performance analysis. The functions that control this functionality
 *          will normally be of use to a very limited number of developers
 *          outside of The HDF Group. The functions have been documented to
 *          help users create logs that can be sent with bug reports.
 *
 *          Control of the log functionality is straightforward. Logging is
 *          enabled via the H5Pset_mdc_log_options() function,
 *          which will modify the file access property list used to open or
 *          create a file. This function has a flag that determines whether
 *          logging begins at file open or starts in a paused state. Log
 *          messages can then be controlled via the H5Fstart_mdc_logging()
 *          and H5Fstop_mdc_logging() function.
 *
 *          H5Pget_mdc_log_options() can be used to examine a file access
 *          property list, and H5Fget_mdc_logging_status() will return the
 *          current state of the logging flags.
 *
 *          The log format is described in [<em>Metadata Cache Logging</em>]
 *          (https://portal.hdfgroup.org/display/HDF5/Fine-tuning+the+Metadata+Cache).
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean is_enabled, @Cast("const char*") BytePointer location,
                                     @Cast("hbool_t") boolean start_on_access);
public static native @Cast("herr_t") int H5Pset_mdc_log_options(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean is_enabled, String location,
                                     @Cast("hbool_t") boolean start_on_access);
/**
 * \ingroup FAPL
 *
 * \brief Sets the minimum metadata block size
 *
 * \fapl_id{fapl_id}
 * @param size [in] Minimum size, in bytes, of metadata block allocations
 *
 * @return \herr_t
 *
 * \details H5Pset_meta_block_size() sets the minimum size, in bytes, of
 *          metadata block allocations when #H5FD_FEAT_AGGREGATE_METADATA is set by a VFL
 *          driver.
 <p>
 *          Each raw metadata block is initially allocated to be of the given size.
 *          Specific metadata objects (e.g., object headers, local heaps, B-trees) are then
 *          sub-allocated from this block.
 *
 *          The default setting is 2048 bytes, meaning that the library will
 *          attempt to aggregate metadata in at least 2K blocks in the file.
 *          Setting the value to zero (\Code{0}) with this function will turn
 *          off metadata aggregation, even if the VFL driver attempts to use the
 *          metadata aggregation strategy.
 *
 *          Metadata aggregation reduces the number of small data objects in the file that
 *          would otherwise be required for metadata. The aggregated block of metadata is
 *          usually written in a single write action and always in a contiguous block,
 *          potentially significantly improving library and application performance.
 *
 * @since 1.4.0
 */
public static native @Cast("herr_t") int H5Pset_meta_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long size);
/**
 * \ingroup FAPL
 *
 * \brief Sets the number of read attempts in a file access property list
 *
 * \fapl_id{plist_id}
 * @param attempts [in] The number of read attempts. Must be a value greater than \Code{0}
 *
 * @return \herr_t
 *
 * @return Failure Modes:
 *         - When the user sets the number of read attempts to \Code{0}.
 *         - When the input property list is not a file access property list.
 *         - When the library is unable to set the number of read attempts in the file access property list.
 *
 * \details H5Pset_metadata_read_attempts() sets the number of reads that the
 *          library will try when reading checksummed metadata in an HDF5 file opened
 *          with SWMR access. When reading such metadata, the library will compare the
 *          checksum computed for the metadata just read with the checksum stored within
 *          the piece of checksum. When performing SWMR operations on a file, the
 *          checksum check might fail when the library reads data on a system that is not
 *          atomic. To remedy such situations, the library will repeatedly read the piece
 *          of metadata until the check passes or finally fails the read when the allowed
 *          number of attempts is reached.
 *
 *          The number of read attempts used by the library will depend on how the file is
 *          opened and whether the user sets the number of read attempts via this routine:
 <p>
 *          - For a file opened with SWMR access:
 *            - If the user sets the number of attempts to \Code{N}, the library will use \Code{N}.
 *            - If the user does not set the number of attempts, the library will use the
 *              default for SWMR access (\Code{100}).
 *          - For a file opened with non-SWMR access, the library will always use the default
 *            for non-SWMR access (\Code{1}). The value set via this routine does not have any effect
 *            during non-SWMR access.
 *
 * \b Example: The first example illustrates the case in setting the number of read attempts for a file
 *             opened with SWMR access.
 *
 * \snippet H5Pset_metadata_read_attempts.c SWMR Access
 *
 * \b Example: The second example illustrates the case in setting the number of
 *             read attempts for a file opened with non-SWMR access. The value
 *             set in the file access property list does not have any effect.
 *
 * \snippet H5Pset_metadata_read_attempts.c non-SWMR Access
 *
 * \note \b Motivation: On a system that is not atomic, the library might
 *       possibly read inconsistent metadata with checksum when performing
 *       single-writer/multiple-reader (SWMR) operations for an HDF5 file. Upon
 *       encountering such situations, the library will try reading the metadata
 *       again to obtain consistent data. This routine provides the means to set
 *       the number of read attempts other than the library default.
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Pset_metadata_read_attempts(@Cast("hid_t") long plist_id, @Cast("unsigned") int attempts);
/**
 * \ingroup FAPL
 *
 * \brief Specifies type of data to be accessed via the \Code{MULTI} driver,
 *        enabling more direct access
 *
 * \fapl_id{fapl_id}
 * @param type [in] Type of data to be accessed
 *
 * @return \herr_t
 *
 * \details H5Pset_multi_type() sets the \Emph{type of data} property in the file
 *          access property list \p fapl_id. This setting enables a user
 *          application to specify the type of data the application wishes to
 *          access so that the application can retrieve a file handle for
 *          low-level access to the particular member of a set of \Code{MULTI}
 *          files in which that type of data is stored. The file handle is
 *          retrieved with a separate call to H5Fget_vfd_handle() (or, in special
 *          circumstances, to H5FDget_vfd_handle(); see \ref VFL.
 *
 * The type of data specified in \p type may be one of the following:
 *
 * <table>
 *   <tr>
 *     <td>#H5FD_MEM_SUPER</td>    <td>Super block data</td>
 *   </tr>
 *   <tr>
 *     <td>#H5FD_MEM_BTREE</td>    <td>B-tree data</td>
 *   </tr>
 *   <tr>
 *     <td>#H5FD_MEM_DRAW</td>    <td>Dataset raw data</td>
 *   </tr>
 *   <tr>
 *     <td>#H5FD_MEM_GHEAP</td>    <td>Global heap data</td>
 *   </tr>
 *   <tr>
 *     <td>#H5FD_MEM_LHEAP</td>    <td>Local Heap data</td>
 *   </tr>
 *   <tr>
 *     <td>#H5FD_MEM_OHDR</td>    <td>Object header data</td>
 *   </tr>
 * </table>
 *
 * This function is for use only when accessing an HDF5 file written as a set of
 * files with the \Code{MULTI} file driver.
 *
 * @since 1.6.0
 */
public static native @Cast("herr_t") int H5Pset_multi_type(@Cast("hid_t") long fapl_id, @Cast("H5FD_mem_t") int type);
/**
 * \ingroup FAPL
 *
 * \brief Sets a callback function to invoke when an object flush occurs in the file
 *
 * \fapl_id{plist_id}
 * \op{func}
 * \op_data_in{udata}
 *
 * @return \herr_t
 *
 * \details H5Pset_object_flush_cb() sets the callback function to invoke in the
 *          file access property list \p plist_id whenever an object flush occurs in
 *          the file. Library objects are group, dataset, and committed
 *          datatype.
 *
 *          The callback function \p func must conform to the prototype defined below:
 *          <pre>{@code
 *          typedef herr_t (*H5F_flush_cb_t)(hid_t object_id, void *user_data)
 *          }</pre>
 *
 *          The parameters of the callback function, per the above prototypes, are defined as follows:
 *            - \Code{object_id} is the identifier of the object which has just been flushed.
 *            - \Code{user_data} is the user-defined input data for the callback function.
 *
 * \b Example: The example below illustrates the usage of this routine to set
 *             the callback function to invoke when an object flush occurs.
 *
 * \include H5Pset_object_flush_cb.c
 *
 * @since 1.10.0
 */
public static native @Cast("herr_t") int H5Pset_object_flush_cb(@Cast("hid_t") long plist_id, H5F_flush_cb_t func, Pointer udata);
/**
 * \ingroup FAPL
 *
 * \brief Sets the maximum size of the data sieve buffer
 *
 * \fapl_id{fapl_id}
 * @param size [in] Maximum size, in bytes, of data sieve buffer
 *
 * @return \herr_t
 *
 * \details H5Pset_sieve_buf_size() sets \p size, the maximum size in bytes of the
 *          data sieve buffer, which is used by file drivers that are capable of
 *          using data sieving.
 *
 *          The data sieve buffer is used when performing I/O on datasets in the
 *          file. Using a buffer which is large enough to hold several pieces of
 *          the dataset being read in for hyperslab selections boosts
 *          performance by quite a bit.
 *
 *          The default value is set to 64KB, indicating that file I/O for raw
 *          data reads and writes will occur in at least 64KB blocks. Setting
 *          the value to zero (\Code{0}) with this API function will turn off
 *          the data sieving, even if the VFL driver attempts to use that
 *          strategy.
 *
 *          Internally, the library checks the storage sizes of the datasets in
 *          the file. It picks the smaller one between the size from the file
 *          access property and the size of the dataset to allocate the sieve
 *          buffer for the dataset in order to save memory usage.
 *
 * @version 1.6.0 The \p size parameter has changed from type \Code{hsize_t} to \Code{size_t}.
 *
 * @since 1.4.0
 */
public static native @Cast("herr_t") int H5Pset_sieve_buf_size(@Cast("hid_t") long fapl_id, @Cast("size_t") long size);
/**
 * \ingroup FAPL
 *
 * \brief Sets the size of a contiguous block reserved for small data
 *
 * \fapl_id{fapl_id}
 * @param size [in] Maximum size, in bytes, of the small data block.
                   The default size is \Code{2048}.
 *
 * @return \herr_t
 *
 * \details H5Pset_small_data_block_size() reserves blocks of \p size bytes for the
 *          contiguous storage of the raw data portion of \Emph{small} datasets. The
 *          HDF5 library then writes the raw data from small datasets to this
 *          reserved space, thus reducing unnecessary discontinuities within
 *          blocks of meta data and improving I/O performance.
 *
 *          A small data block is actually allocated the first time a qualifying
 *          small dataset is written to the file. Space for the raw data portion
 *          of this small dataset is suballocated within the small data block.
 *          The raw data from each subsequent small dataset is also written to
 *          the small data block until it is filled; additional small data
 *          blocks are allocated as required.
 *
 *          The HDF5 library employs an algorithm that determines whether I/O
 *          performance is likely to benefit from the use of this mechanism with
 *          each dataset as storage space is allocated in the file. A larger
 *          \p size will result in this mechanism being employed with larger
 *          datasets.
 *
 *          The small data block size is set as an allocation property in the
 *          file access property list identified by \p fapl_id.
 *
 *          Setting \p size to zero (\Code{0}) disables the small data block mechanism.
 *
 * @since 1.4.4
 */
public static native @Cast("herr_t") int H5Pset_small_data_block_size(@Cast("hid_t") long fapl_id, @Cast("hsize_t") long size);
/**
 * \ingroup FAPL
 *
 * \brief Set the file VOL connector for a file access property list
 *
 * \fapl_id{plist_id}
 * @param new_vol_id [in]     VOL connector identifier
 * @param new_vol_info [in]   Optional VOL information
 *
 * @return \herr_t
 *
 * \details H5Pset_vol() sets the VOL connector \p new_vol_id for a file access
 *          property list \p plist_id using the (optional) VOL information in
 *          \p new_vol_info.
 *
 * @since 1.12.0
 *
 */
public static native @Cast("herr_t") int H5Pset_vol(@Cast("hid_t") long plist_id, @Cast("hid_t") long new_vol_id, @Const Pointer new_vol_info);

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */
/**
 * \ingroup FAPL
 *
 * \brief Sets the metadata cache image option for a file access property list
 *
 * \fapl_id{plist_id}
 * @param config_ptr [out] Pointer to metadata cache image configuration values
 * @return \herr_t
 *
 * \details H5Pset_mdc_image_config() sets the metadata cache image option with
 *          configuration values specified by \p config_ptr for the file access
 *          property list specified in \p plist_id.
 *
 *          #H5AC_cache_image_config_t is defined as follows:
 *          \snippet H5ACpublic.h H5AC_cache_image_config_t_snip
 *          \click4more
 *
 * \par Limitations: While it is an obvious error to request a cache image when
 *      opening the file read only, it is not in general possible to test for
 *      this error in the H5Pset_mdc_image_config() call. Rather than fail the
 *      subsequent file open, the library silently ignores the file image
 *      request in this case.\n It is also an error to request a cache image on
 *      a file that does not support superblock extension messages (i.e. a
 *      superblock version less than 2). As above, it is not always possible to
 *      detect this error in the H5Pset_mdc_image_config() call, and thus the
 *      request for a cache image will fail silently in this case as well.\n
 *      Creation of cache images is currently disabled in parallel -- as above,
 *      any request for a cache image in this context will fail silently.\n
 *      Files with cache images may be read in parallel applications, but note
 *      that the load of the cache image is a collective operation triggered by
 *      the first operation that accesses metadata after file open (or, if
 *      persistent free space managers are enabled, on the first allocation or
 *      deallocation of file space, or read of file space manager status,
 *      whichever comes first). Thus the parallel process may deadlock if any
 *      process does not participate in this access.\n
 *      In long sequences of file  closes and opens, infrequently accessed
 *      metadata can accumulate in the cache image to the point where the cost
 *      of storing and restoring this metadata exceeds the benefit of retaining
 *      frequently used metadata in the cache image. When implemented, the
 *      #H5AC_cache_image_config_t::entry_ageout should address this problem. In
 *      the interim, not requesting a cache image every n file close/open cycles
 *      may be an acceptable work around. The choice of \c n will be driven by
 *      application behavior, but \Code{n = 10} seems a good starting point.
 *
 * @since 1.10.1
 */
public static native @Cast("herr_t") int H5Pset_mdc_image_config(@Cast("hid_t") long plist_id, H5AC_cache_image_config_t config_ptr);
/**
 * \ingroup FAPL
 *
 * \brief Sets the maximum size for the page buffer and the minimum percentage
 *        for metadata and raw data pages
 *
 * \fapl_id{plist_id}
 * @param buf_size [in] Maximum size, in bytes, of the page buffer
 * @param min_meta_per [in] Minimum metadata percentage to keep in the page buffer
 *            before allowing pages containing metadata to be evicted (Default is 0)
 * @param min_raw_per [in] Minimum raw data percentage to keep in the page buffer
 *            before allowing pages containing raw data to be evicted (Default is 0)
 * @return \herr_t
 *
 * \details H5Pset_page_buffer_size() sets buf_size, the maximum size in bytes
 *          of the page buffer. The default value is zero, meaning that page
 *          buffering is disabled. When a non-zero page buffer size is set, the
 *          library will enable page buffering if that size is larger or equal
 *          than a single page size if a paged file space strategy is enabled
 *          using the functions H5Pset_file_space_strategy() and
 *          H5Pset_file_space_page_size().
 *
 *          The page buffer layer captures all I/O requests before they are
 *          issued to the VFD and "caches" them in fixed sized pages. Once the
 *          total number of pages exceeds the page buffer size, the library
 *          evicts pages from the page buffer by writing them to the VFD. At
 *          file close, the page buffer is flushed writing all the pages to the
 *          file.
 *
 *          If a non-zero page buffer size is set, and the file space strategy
 *          is not set to paged or the page size for the file space strategy is
 *          larger than the page buffer size, the subsequent call to H5Fcreate()
 *          or H5Fopen() using the \p plist_id will fail.
 *
 *          The function also allows setting the minimum percentage of pages for
 *          metadata and raw data to prevent a certain type of data to evict hot
 *          data of the other type.
 *
 * @since 1.10.1
 *
 */
public static native @Cast("herr_t") int H5Pset_page_buffer_size(@Cast("hid_t") long plist_id, @Cast("size_t") long buf_size, @Cast("unsigned") int min_meta_per,
                                      @Cast("unsigned") int min_raw_per);

/* Dataset creation property list (DCPL) routines */
/**
 * \ingroup DCPL
 *
 * \brief Determines whether fill value is defined
 *
 * \dcpl_id{plist}
 * @param status [out] Status of fill value in property list
 *
 * @return \herr_t
 *
 * \details H5Pfill_value_defined() determines whether a fill value is
 *          defined in the dataset creation property list \p plist. Valid
 *          values returned in status are as follows:
 *
 *          <table>
 *           <tr>
 *            <td>#H5D_FILL_VALUE_UNDEFINED</td>
 *            <td>Fill value is undefined.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_VALUE_DEFAULT</td>
 *            <td>Fill value is the library default.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_VALUE_USER_DEFINED</td>
 *            <td>Fill value is defined by the application.</td>
 *           </tr>
 *          </table>
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") IntPointer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") IntBuffer status);
public static native @Cast("herr_t") int H5Pfill_value_defined(@Cast("hid_t") long plist, @Cast("H5D_fill_value_t*") int[] status);
/**
 * \ingroup DCPL
 *
 * \brief Retrieves the timing for storage space allocation
 *
 * \dcpl_id{plist_id}
 * @param alloc_time [out] The timing setting for allocating dataset
 *                        storage space
 *
 * @return \herr_t
 *
 * \details H5Pget_alloc_time() retrieves the timing for allocating storage
 *          space for a dataset's raw data. This property is set in the
 *          dataset creation property list \p plist_id. The timing setting
 *          is returned in \p alloc_time as one of the following values:
 *
 *          <table>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_DEFAULT<br />&nbsp;</td>
 *            <td>Uses the default allocation time, based on the dataset
 *                storage method. <br />See the \p alloc_time description in
 *                H5Pset_alloc_time() for default allocation times for
 *                various storage methods.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_EARLY</td>
 *            <td>All space is allocated when the dataset is created.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_INCR</td>
 *            <td>Space is allocated incrementally as data is written
 *                to the dataset.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_LATE</td>
 *            <td>All space is allocated when data is first written to
 *                the dataset.</td>
 *           </tr>
 *          </table>
 *
 * \note H5Pget_alloc_time() is designed to work in concert with the
 *       dataset fill value and fill value write time properties, set
 *       with the functions H5Pget_fill_value() and H5Pget_fill_time().
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") IntPointer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") IntBuffer alloc_time);
public static native @Cast("herr_t") int H5Pget_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t*") int[] alloc_time);
/**
 * \ingroup DCPL
 *
 * \brief Retrieves the size of chunks for the raw data of a chunked
 *        layout dataset
 *
 * \dcpl_id{plist_id}
 * @param max_ndims [in] Size of the \p dims array
 * @param dim [out] Array to store the chunk dimensions
 *
 * @return Returns chunk dimensionality if successful;
 *         otherwise returns a negative value.
 *
 * \details H5Pget_chunk() retrieves the size of chunks for the raw data
 *          of a chunked layout dataset. This function is only valid for
 *          dataset creation property lists. At most, \p max_ndims elements
 *          of \p dim will be initialized.
 *
 * @since 1.0.0
 *
 */
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") LongPointer dim);
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") LongBuffer dim);
public static native int H5Pget_chunk(@Cast("hid_t") long plist_id, int max_ndims, @Cast("hsize_t*") long[] dim);
/**
 *
 * \ingroup DCPL
 *
 * \brief Retrieves the edge chunk option setting from a dataset creation
 *        property list
 *
 * \dcpl_id{plist_id}
 * @param opts [out]  Edge chunk option flag. Valid values are described in
 *                   H5Pset_chunk_opts(). The option status can be
 *                   retrieved using the bitwise AND operator ( & ). For
 *                   example, the expression
 *                   (opts&#H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS) will
 *                   evaluate to #H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS if
 *                   that option has been enabled. Otherwise, it will
 *                   evaluate to 0 (zero).
 *
 * @return \herr_t
 *
 * \details H5Pget_chunk_opts() retrieves the edge chunk option setting
 *          stored in the dataset creation property list \p plist_id.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer opts);
public static native @Cast("herr_t") int H5Pget_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] opts);
/**
 * \ingroup DCPL
 *
 * \brief Retrieves the setting for whether or not to create minimized
 *        dataset object headers
 *
 * \dcpl_id
 * @param minimize [out]  Flag indicating whether the library will or will
 *                       not create minimized dataset object headers
 *
 * @return \herr_t
 *
 * \details H5Pget_dset_no_attrs_hint() retrieves the
 *          <i>no dataset attributes</i> hint setting for the dataset
 *          creation property list \p dcpl_id. This setting is used to
 *          inform the library to create minimized dataset object headers
 *          when TRUE. The setting value is returned in the boolean pointer
 *          \p minimize.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Pget_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t*") BoolPointer minimize);
public static native @Cast("herr_t") int H5Pget_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t*") boolean[] minimize);
/**
 * \ingroup DCPL
 *
 * \brief Returns information about an external file
 *
 * \dcpl_id{plist_id}
 * @param idx [in]       External file index
 * @param name_size [in] Maximum length of \p name array
 * @param name [out]      Name of the external file
 * @param offset [out]    Pointer to a location to return an offset value
 * @param size [out]      Pointer to a location to return the size of the
 *                       external file data
 *
 * @return \herr_t
 *
 * \details H5Pget_external() returns information about an external file.
 *          The external file is specified by its index, \p idx, which
 *          is a number from zero to N-1, where N is the value returned
 *          by H5Pget_external_count(). At most \p name_size characters
 *          are copied into the \p name array. If the external file name
 *          is longer than \p name_size with the null terminator, the
 *          return value is not null terminated (similar to strncpy()).
 *
 *          If \p name_size is zero or \p name is the null pointer, the
 *          external file name is not returned. If \p offset or \p size
 *          are null pointers then the corresponding information is not
 *          returned.
 *
 * @version 1.6.4 \p idx parameter type changed to unsigned.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") BytePointer name,
                              @Cast("off_t*") SizeTPointer offset, @Cast("hsize_t*") LongPointer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") ByteBuffer name,
                              @Cast("off_t*") SizeTPointer offset, @Cast("hsize_t*") LongBuffer size);
public static native @Cast("herr_t") int H5Pget_external(@Cast("hid_t") long plist_id, @Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") byte[] name,
                              @Cast("off_t*") SizeTPointer offset, @Cast("hsize_t*") long[] size);
/**
 * \ingroup DCPL
 *
 * \brief Returns the number of external files for a dataset
 *
 * \dcpl_id{plist_id}
 *
 * @return Returns the number of external files if successful; otherwise
 *         returns a negative value.
 *
 * \details H5Pget_external_count() returns the number of external files
 *          for the specified dataset.
 *
 * @since 1.0.0
 *
 */
public static native int H5Pget_external_count(@Cast("hid_t") long plist_id);
/**
 * \ingroup DCPL
 *
 * \brief Retrieves the time when fill values are written to a dataset
 *
 * \dcpl_id{plist_id}
 * @param fill_time [out] Setting for the timing of writing fill values to
 *                       the dataset
 *
 * @return \herr_t
 *
 * \details H5Pget_fill_time() examines the dataset creation property list
 *          \p plist_id to determine when fill values are to be written to
 *          a dataset. Valid values returned in \p fill_time are as
 *          follows:
 *
 *          <table>
 *           <tr>
 *            <td>#H5D_FILL_TIME_IFSET</td>
 *            <td>Fill values are written to the dataset when storage
 *                space is allocated only if there is a user-defined fill
 *                value, i.e., one set with H5Pset_fill_value(). (Default)
 *             </td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_TIME_ALLOC</td>
 *            <td>Fill values are written to the dataset when storage
 *                space is allocated.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_TIME_NEVER</td>
 *            <td>Fill values are never written to the dataset.</td>
 *           </tr>
 *          </table>
 *
 * \note H5Pget_fill_time() is designed to work in coordination with the
 *       dataset fill value and dataset storage allocation time properties,
 *       retrieved with the functions H5Pget_fill_value() and
 *       H5Pget_alloc_time().
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") IntPointer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") IntBuffer fill_time);
public static native @Cast("herr_t") int H5Pget_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t*") int[] fill_time);
/**
 * \ingroup DCPL
 *
 * \brief Retrieves a dataset fill value
 *
 * \dcpl_id{plist_id}
 * @param type_id [in] Datatype identifier for the value passed via
 *                     \p value
 * @param value [out]   Pointer to buffer to contain the returned
 *                     fill value
 *
 * @return \herr_t
 *
 * \details H5Pget_fill_value() returns the dataset fill value defined in
 *          the dataset creation property list \p plist_id. The fill value
 *          is returned through the \p value pointer and will be converted
 *          to the datatype specified  by \p type_id. This datatype may
 *          differ from the fill value datatype in the property list, but
 *          the HDF5 library must be able to convert between the two
 *          datatypes.
 *
 *          If the fill value is undefined, i.e., set to NULL in the
 *          property list, H5Pget_fill_value() will return an error.
 *          H5Pfill_value_defined() should be used to check for this
 *          condition before H5Pget_fill_value() is called.
 *
 *          Memory must be allocated by the calling application.
 *
 * \note H5Pget_fill_value() is designed to coordinate with the dataset
 *       storage allocation time and fill value write time properties,
 *       which can be retrieved with the functions H5Pget_alloc_time()
 *       and H5Pget_fill_time(), respectively.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_fill_value(@Cast("hid_t") long plist_id, @Cast("hid_t") long type_id, Pointer value);
/**
 * \ingroup DCPL
 *
 * \brief Returns the layout of the raw data for a dataset
 *
 * \dcpl_id{plist_id}
 *
 * @return Returns the layout type (a non-negative value) of a dataset
 *         creation property list if successful. Valid return values are:
 *         - #H5D_COMPACT: Raw data is stored in the object header in the
 *                        file.
 *         - #H5D_CONTIGUOUS: Raw data is stored separately from the object
 *                           header in one contiguous chunk in the file.
 *         - #H5D_CHUNKED: Raw data is stored separately from the object
 *                        header in chunks in separate locations in the
 *                        file.
 *         - #H5D_VIRTUAL: Raw data is drawn from multiple datasets in
 *                        different files.
 * @return
 *         Otherwise, returns a negative value indicating failure.
 *
 * \details H5Pget_layout() returns the layout of the raw data for a
 *          dataset. This function is only valid for dataset creation
 *          property lists.
 *
 *          Note that a compact storage layout may affect writing data to
 *          the dataset with parallel applications. See the H5Dwrite()
 *          documentation for details.
 *
 * @version 1.10.0 #H5D_VIRTUAL added in this release.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("H5D_layout_t") int H5Pget_layout(@Cast("hid_t") long plist_id);
/**
 * \ingroup DCPL
 *
 * \brief Gets the number of mappings for the virtual dataset
 *
 * \dcpl_id
 * @param count [out] The number of mappings
 *
 * @return \herr_t
 *
 * \details H5Pget_virtual_count() gets the number of mappings for a
 *          virtual dataset that has the creation property list specified
 *          by \p dcpl_id.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pget_virtual_count(@Cast("hid_t") long dcpl_id, @Cast("size_t*") SizeTPointer count);
/**
 * \ingroup DCPL
 *
 * \brief Gets the name of a source dataset used in the mapping
 *
 * \dcpl_id
 * @param index [in] Mapping index. The value of \p index is 0 (zero) or
 *                   greater and less than \p count
 *                   (0 ≤ \p index < \p count), where \p count is the
 *                   number of mappings returned by H5Pget_virtual_count().
 * @param name [out]  A buffer containing the name of the source dataset
 * @param size [in]  The size, in bytes, of the name buffer. Must be the
 *                   size of the dataset name in bytes plus 1 for a NULL
 *                   terminator
 *
 * @return Returns the length of the dataset name if successful;
 *         otherwise returns a negative value.
 *
 * \details H5Pget_virtual_dsetname() takes the dataset creation property
 *          list for the virtual dataset, \p dcpl_id, the mapping index,
 *          \p index, the size of the dataset name for a source dataset,
 *          \p size, and retrieves the name of the source dataset used in
 *          the mapping.
 *
 *          Up to \p size characters of the dataset name are returned in
 *          \p name; additional characters, if any, are not returned to
 *          the user application.
 *
 *          If the length of the dataset name, which determines the
 *          required value of \p size, is unknown, a preliminary call
 *          to H5Pget_virtual_dsetname() with the last two parameters
 *          set to NULL and zero respectively can be made. The return
 *          value of this call will be the size in bytes of the dataset
 *          name. That value, plus 1 for a NULL terminator, must then be
 *          assigned to \p size for a second H5Pget_virtual_dsetname()
 *          call, which will retrieve the actual dataset name.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_dsetname(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * \ingroup DCPL
 *
 * \brief Gets the filename of a source dataset used in the mapping
 *
 * \dcpl_id
 * @param index [in] Mapping index. The value of \p index is 0 (zero) or
 *                   greater and less than \p count
 *                   (0 ≤ \p index < \p count), where \p count is the
 *                   number of mappings returned by H5Pget_virtual_count().
 * @param name [out]  A buffer containing the name of the file containing
 *                   the source dataset
 * @param size [in]  The size, in bytes, of the name buffer. Must be the
 *                   size of the filename in bytes plus 1 for a NULL
 *                   terminator
 *
 * @return Returns the length of the filename if successful; otherwise
 *         returns a negative value.
 *
 * \details H5Pget_virtual_filename() takes the dataset creation property
 *          list for the virtual dataset, \p dcpl_id, the mapping index,
 *          \p index, the size of the filename for a source dataset,
 *          \p size, and retrieves the name of the file for a source dataset
 *          used in the mapping.
 *
 *          Up to \p size characters of the filename are returned in
 *          \p name; additional characters, if any, are not returned to
 *          the user application.
 *
 *          If the length of the filename, which determines the required
 *          value of \p size, is unknown, a preliminary call to
 *          H5Pget_virtual_filename() with the last two parameters set
 *          to NULL and zero respectively can be made. The return value
 *          of this call will be the size in bytes of the filename. That
 *          value, plus 1 for a NULL terminator, must then be assigned to
 *          \p size for a second H5Pget_virtual_filename() call, which
 *          will retrieve the actual filename.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") BytePointer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") ByteBuffer name, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_filename(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index, @Cast("char*") byte[] name, @Cast("size_t") long size);
/**
 * \ingroup DCPL
 *
 * \brief Gets a dataspace identifier for the selection within the source
 *        dataset used in the mapping
 *
 * \dcpl_id
 * @param index [in] Mapping index. The value of \p index is 0 (zero) or
 *                  greater and less than \p count
 *                  (0 ≤ \p index < \p count), where \p count is the number
 *                  of mappings returned by H5Pget_virtual_count().
 *
 * @return \hid_t{valid dataspace identifier}
 *
 * \details H5Pget_virtual_srcspace() takes the dataset creation property
 *          list for the virtual dataset, \p dcpl_id, and the mapping
 *          index, \p index, and returns a dataspace identifier for the
 *          selection within the source dataset used in the mapping.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("hid_t") long H5Pget_virtual_srcspace(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index);
/**
 * \ingroup DCPL
 *
 * \brief Gets a dataspace identifier for the selection within the virtual
 *        dataset used in the mapping
 *
 * \dcpl_id
 * @param index [in] Mapping index. The value of \p index is 0 (zero) or
 *                  greater and less than \p count
 *                  (0 ≤ \p index < \p count), where \p count is the number
 *                  of mappings returned by H5Pget_virtual_count()
 *
 * @return \hid_t{valid dataspace identifier}
 *
 * \details H5Pget_virtual_vspace() takes the dataset creation property
 *          list for the virtual dataset, \p dcpl_id, and the mapping
 *          index, \p index, and returns a dataspace identifier for the
 *          selection within the virtual dataset used in the mapping.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("hid_t") long H5Pget_virtual_vspace(@Cast("hid_t") long dcpl_id, @Cast("size_t") long index);
/**
 * \ingroup DCPL
 *
 * \brief Sets the timing for storage space allocation
 *
 * \dcpl_id{plist_id}
 * @param alloc_time [in] When to allocate dataset storage space
 *
 * @return \herr_t
 *
 * \details H5Pset_alloc_time() sets up the timing for the allocation of
 *          storage space for a dataset's raw data. This property is set
 *          in the dataset creation property list \p plist_id. Timing is
 *          specified in \p alloc_time with one of the following values:
 *
 *          <table>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_DEFAULT</td>
 *            <td>Allocate dataset storage space at the default time<br />
 *                (Defaults differ by storage method.)</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_EARLY</td>
 *            <td>Allocate all space when the dataset is created<br />
 *            (Default for compact datasets.)</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_INCR</td>
 *            <td>Allocate space incrementally, as data is written to
 *                the dataset<br />(Default for chunked storage datasets.)
 *
 *                \li Chunked datasets: Storage space allocation for each
 *                    chunk is deferred until data is written to the chunk.
 *                \li Contiguous datasets: Incremental storage space
 *                    allocation for contiguous data is treated as late
 *                    allocation.
 *                \li Compact datasets: Incremental allocation is not
 *                    allowed with compact datasets; H5Pset_alloc_time()
 *                    will return an error.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_ALLOC_TIME_LATE</td>
 *            <td>Allocate all space when data is first written to the
 *                dataset<br />
 *                (Default for contiguous datasets.)</td>
 *           </tr>
 *          </table>
 *
 * \note H5Pset_alloc_time() is designed to work in concert with the
 *       dataset fill value and fill value write time properties, set
 *       with the functions H5Pset_fill_value() and H5Pset_fill_time().
 *
 * \note See H5Dcreate() for further cross-references.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_alloc_time(@Cast("hid_t") long plist_id, @Cast("H5D_alloc_time_t") int alloc_time);
/**
 * \ingroup DCPL
 *
 * \brief Sets the size of the chunks used to store a chunked layout
 *        dataset
 *
 * \dcpl_id{plist_id}
 * @param ndims [in]  The number of dimensions of each chunk
 * @param dim [in]    An array defining the size, in dataset elements, of
 *                   each chunk
 *
 * @return \herr_t
 * \details H5Pset_chunk() sets the size of the chunks used to store a
 *          chunked layout dataset. This function is only valid for dataset
 *          creation property lists.
 *
 *          The \p ndims parameter currently must be the same size as the
 *          rank of the dataset.
 *
 *          The values of the \p dim array define the size of the chunks
 *          to store the dataset's raw data. The unit of measure for \p dim
 *          values is dataset elements.
 *
 *          As a side-effect of this function, the layout of the dataset is
 *          changed to #H5D_CHUNKED, if it is not already so set.
 *
 * \note Chunk size cannot exceed the size of a fixed-size dataset. For
 *       example, a dataset consisting of a 5x4 fixed-size array cannot be
 *       defined with 10x10 chunks. Chunk maximums:
 *       - The maximum number of elements in a chunk is 2<sup>32</sup>-1 which
 *         is equal to 4,294,967,295. If the number of elements in a chunk is
 *         set via H5Pset_chunk() to a value greater than 2<sup>32</sup>-1,
 *         then H5Pset_chunk() will fail.
 *       - The maximum size for any chunk is 4GB. If a chunk that is larger
 *         than 4GB attempts to be written with H5Dwrite(), then H5Dwrite()
 *         will fail.
 *
 * @see H5Pset_layout(), H5Dwrite()
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") LongPointer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") LongBuffer dim);
public static native @Cast("herr_t") int H5Pset_chunk(@Cast("hid_t") long plist_id, int ndims, @Cast("const hsize_t*") long[] dim);
/**
 * \ingroup DCPL
 *
 * \brief Sets the edge chunk option in a dataset creation property list
 *
 * \dcpl_id{plist_id}
 * @param opts [in] Edge chunk option flag. Valid values are:
 *                 \li #H5D_CHUNK_DONT_FILTER_PARTIAL_CHUNKS
 *                     When enabled, filters are not applied to partial
 *                     edge chunks. When disabled, partial edge chunks are
 *                     filtered. Enabling this option will improve
 *                     performance when appending to the dataset and, when
 *                     compression filters are used, prevent reallocation
 *                     of these chunks. Datasets created with this option
 *                     enabled will be inaccessible with HDF5 library
 *                     versions before Release 1.10. Default: \e Disabled
 *                 \li 0 (zero) Disables option; partial edge chunks
 *                     will be compressed.
 *
 * @return \herr_t
 *
 * \details H5Pset_chunk_opts() sets the edge chunk option in the
 *          dataset creation property list \p dcpl_id.
 *
 *          The available option is detailed in the parameters section.
 *          Only chunks that are not completely filled by the dataset’s
 *          dataspace are affected by this option. Such chunks are
 *          referred to as partial edge chunks.
 *
 *      \b Motivation: H5Pset_chunk_opts() is used to specify storage
 *       options for chunks on the edge of a dataset’s dataspace. This
 *       capability allows the user to tune performance in cases where
 *       the dataset size may not be a multiple of the chunk size and
 *       the handling of partial edge chunks can impact performance.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_chunk_opts(@Cast("hid_t") long plist_id, @Cast("unsigned") int opts);
/**
 * \ingroup DCPL
 *
 * \brief Sets the flag to create minimized dataset object headers
 *
 * \dcpl_id
 * @param minimize [in] Flag for indicating whether or not a dataset's
 *                     object header will be minimized
 *
 * @return \herr_t
 *
 * \details H5Pset_dset_no_attrs_hint() sets the no dataset attributes
 *          hint setting for the dataset creation property list \p dcpl_id.
 *          Datasets created with the dataset creation property list
 *          \p dcpl_id will have their object headers minimized if the
 *          boolean flag \p minimize is set to TRUE. By setting \p minimize
 *          to TRUE, the library expects that no attributes will be added
 *          to the dataset. Attributes can be added, but they are appended
 *          with a continuation message, which can reduce performance.
 *
 *          This setting interacts with H5Fset_dset_no_attrs_hint(): if
 *          either is set to TRUE, then the created dataset's object header
 *          will be minimized.
 *
 * @since 1.10.5
 *
 */
public static native @Cast("herr_t") int H5Pset_dset_no_attrs_hint(@Cast("hid_t") long dcpl_id, @Cast("hbool_t") boolean minimize);
/**
 * \ingroup DCPL
 *
 * \brief Adds an external file to the list of external files
 *
 * \dcpl_id{plist_id}
 * @param name [in]   Name of an external file
 * @param offset [in] Offset, in bytes, from the beginning of the file to
 *                   the location in the file where the data starts
 * @param size [in]   Number of bytes reserved in the file for the data
 *
 * @return \herr_t
 *
 * \details The first call to H5Pset_external() sets the external
 *          storage property in the property list, thus designating that
 *          the dataset will be stored in one or more non-HDF5 file(s)
 *          external to the HDF5 file. This call also adds the file
 *          \p name as the first file in the list of external files.
 *          Subsequent calls to the function add the named file as the
 *          next file in the list.
 *
 *          If a dataset is split across multiple files, then the files
 *          should be defined in order. The total size of the dataset is
 *          the sum of the \p size arguments for all the external files.
 *          If the total size is larger than the size of a dataset then
 *          the dataset can be extended (provided the data space also
 *          allows the extending).
 *
 *         The \p size argument specifies the number of bytes reserved
 *         for data in the external file. If \p size is set to
 *         #H5F_UNLIMITED, the external file can be of unlimited size
 *         and no more files can be added to the external files list.
 *         If \p size is set to 0 (zero), no external file will actually
 *         be created.
 *
 *         All of the external files for a given dataset must be specified
 *         with H5Pset_external() before H5Dcreate() is called to create
 *         the dataset. If one these files does not exist on the system
 *         when H5Dwrite() is called to write data to it, the library
 *         will create the file.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer name, @Cast("off_t") long offset, @Cast("hsize_t") long size);
public static native @Cast("herr_t") int H5Pset_external(@Cast("hid_t") long plist_id, String name, @Cast("off_t") long offset, @Cast("hsize_t") long size);
/**
 * \ingroup DCPL
 *
 * \brief Sets the time when fill values are written to a dataset
 *
 * \dcpl_id{plist_id}
 * @param fill_time [in] When to write fill values to a dataset
 *
 * @return \herr_t
 *
 * \details H5Pset_fill_time() sets up the timing for writing fill values
 *          to a dataset. This property is set in the dataset creation
 *          property list \p plist_id. Timing is specified in \p fill_time
 *          with one of the following values:
 *
 *          <table>
 *           <tr>
 *            <td>#H5D_FILL_TIME_IFSET</td>
 *            <td>Write fill values to the dataset when storage space is
 *                allocated only if there is a user-defined fill value,
 *                i.e.,one set with H5Pset_fill_value(). (Default)</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_TIME_ALLOC</td>
 *            <td>Write fill values to the dataset when storage space is
 *                allocated.</td>
 *           </tr>
 *           <tr>
 *            <td>#H5D_FILL_TIME_NEVER</td>
 *            <td>Never write fill values to the dataset.</td>
 *           </tr>
 *          </table>
 *
 * \note H5Pset_fill_time() is designed for coordination with the dataset
 *      fill value and dataset storage allocation time properties, set
 *      with the functions H5Pset_fill_value() and H5Pset_alloc_time().
 *      See H5Dcreate() for further cross-references.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_fill_time(@Cast("hid_t") long plist_id, @Cast("H5D_fill_time_t") int fill_time);
/**
 * \ingroup DCPL
 *
 * \brief Sets the fill value for a dataset
 *
 * \dcpl_id{plist_id}
 * @param type_id [in] Datatype of \p value
 * @param value [in] Pointer to buffer containing value to use as
 *            fill value
 *
 * @return \herr_t
 *
 * \details H5Pset_fill_value() sets the fill value for a dataset in the
 *          dataset creation property list. \p value is interpreted as
 *          being of datatype \p type_id. This datatype may differ from
 *          that of the dataset, but the HDF5 library must be able to
 *          convert \p value to the dataset datatype when the dataset is
 *          created.
 *
 *          The default fill value is 0 (zero), which is interpreted
 *          according to the actual dataset datatype.
 *
 *          Setting \p value to NULL indicates that the fill value is to
 *          be undefined.
 *
 * \note Applications sometimes write data only to portions of an allocated
 *       dataset. It is often useful in such cases to fill the unused space
 *       with a known fill value. This function allows the user application
 *       to set that fill value; the functions H5Dfill() and
 *       H5Pset_fill_time(), respectively, provide the ability to apply the
 *       fill value on demand or to set up its automatic application.
 *
 * \note A fill value should be defined so that it is appropriate for the
 *       application. While the HDF5 default fill value is 0 (zero), it is
 *       often appropriate to use another value. It might be useful, for
 *       example, to use a value that is known to be impossible for the
 *       application to legitimately generate.
 *
 * \note H5Pset_fill_value() is designed to work in concert with
 *       H5Pset_alloc_time() and H5Pset_fill_time(). H5Pset_alloc_time()
 *       and H5Pset_fill_time() govern the timing of dataset storage
 *       allocation and fill value write operations and can be important in
 *       tuning application performance.
 *
 * \note See H5Dcreate() for further cross-references.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_fill_value(@Cast("hid_t") long plist_id, @Cast("hid_t") long type_id, @Const Pointer value);
/**
 * \ingroup DCPL
 *
 * \brief Sets up use of the shuffle filter
 *
 * \dcpl_id{plist_id}
 *
 * @return \herr_t
 *
 * \par_compr_note
 *
 * \details H5Pset_shuffle() sets the shuffle filter, #H5Z_FILTER_SHUFFLE,
 *          in the dataset creation property list \p plist_id. The shuffle
 *          filter de-interlaces a block of data by reordering the bytes.
 *          All the bytes from one consistent byte position of each data
 *          element are placed together in one block; all bytes from a
 *          second consistent byte position of each data element are placed
 *          together a second block; etc. For example, given three data
 *          elements of a 4-byte datatype stored as 012301230123, shuffling
 *          will re-order data as 000111222333. This can be a valuable step
 *          in an effective compression algorithm because the bytes in each
 *          byte position are often closely related to each other and
 *          putting them together can increase the compression ratio.
 *
 *          As implied above, the primary value of the shuffle filter lies
 *          in its coordinated use with a compression filter; it does not
 *          provide data compression when used alone. When the shuffle
 *          filter is applied to a dataset immediately prior to the use of
 *          a compression filter, the compression ratio achieved is often
 *          superior to that achieved by the use of a compression filter
 *          without the shuffle filter.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_shuffle(@Cast("hid_t") long plist_id);
/**
 * \ingroup DCPL
 *
 * \brief Sets the type of storage used to store the raw data for a dataset
 *
 * \dcpl_id{plist_id}
 * @param layout [in] Type of storage layout for raw data
 *
 * @return \herr_t
 * \details H5Pset_layout() sets the type of storage used to store the raw
 *          data for a dataset. This function is only valid for dataset
 *          creation property lists.
 *
 *          Valid values for \p layout are:
 *           - #H5D_COMPACT: Store raw data in the dataset object header
 *                           in file. This should only be used for datasets
 *                           with small amounts of raw data. The raw data
 *                           size limit is 64K (65520 bytes). Attempting
 *                           to create a dataset with raw data larger than
 *                           this limit will cause the H5Dcreate() call to
 *                           fail.
 *           - #H5D_CONTIGUOUS: Store raw data separately from the object
 *                              header in one large chunk in the file.
 *           - #H5D_CHUNKED: Store raw data separately from the object header
 *                           as chunks of data in separate locations in
 *                           the file.
 *           - #H5D_VIRTUAL: Draw raw data from multiple datasets in
 *                           different files.
 *
 *          Note that a compact storage layout may affect writing data to
 *          the dataset with parallel applications. See the note in
 *          H5Dwrite() documentation for details.
 * @version 1.10.0 #H5D_VIRTUAL added in this release.
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_layout(@Cast("hid_t") long plist_id, @Cast("H5D_layout_t") int layout);
/**
 * \ingroup DCPL
 *
 * \brief Sets up the use of the N-Bit filter
 *
 * \dcpl_id{plist_id}
 *
 * @return \herr_t
 *
 * \par_compr_note
 *
 * \details H5Pset_nbit() sets the N-Bit filter, #H5Z_FILTER_NBIT, in the
 *          dataset creation property list \p plist_id.
 *
 *          The HDF5 user can create an N-Bit datatype with the following
 *          code:
 *          <pre>
 *          hid_t nbit_datatype = H5Tcopy(H5T_STD_I32LE);
 *          H5Tset_precision(nbit_datatype, 16);
 *          H5Tset_offset(nbit_datatype, 4);
 *          </pre>
 *
 *          In memory, one value of the N-Bit datatype in the above example
 *          will be stored on a little-endian machine as follows:
 *
 *          <table>
 *          <tr>
 *            <td>byte 3</td>
 *            <td>byte 2</td>
 *            <td>byte 1</td>
 *            <td>byte 0</td>
 *          </tr>
 *          <tr>
 *            <td> ???????? </td>
 *            <td> ????SPPP </td>
 *            <td> PPPPPPPP </td>
 *            <td> PPPP???? </td>
 *          </tr>
 *          </table>
 *          Note: S - sign bit, P - significant bit, ? - padding bit; For
 *          signed integer, the sign bit is included in the precision.
 *
 *          When data of the above datatype is stored on disk using the
 *          N-bit filter, all padding bits are chopped off and only
 *          significant bits are stored. The values on disk will be
 *          something like:
 *
 *          <table>
 *          <tr>
 *           <td>1st value</td>
 *           <td>2nd value</td>
 *           <td>...</td>
 *          </tr>
 *          <tr>
 *           <td>SPPPPPPPPPPPPPPP</td>
 *           <td>SPPPPPPPPPPPPPPP</td>
 *           <td>...</td>
 *          </tr>
 *          </table>
 *          The N-Bit filter is used effectively for compressing data of
 *          an N-Bit datatype as well as a compound and an array
 *          datatype with N-Bit fields. However, the datatype classes of
 *          the N-Bit datatype or the N-Bit field of the compound
 *          datatype or the array datatype are limited to integer or
 *          floating-point.
 *
 *          The N-Bit filter supports complex situations where a compound
 *          datatype contains member(s) of a compound datatype or an array
 *          datatype that has a compound datatype as the base type.
 *          However, it does not support the situation where an array
 *          datatype has a variable-length or variable-length string as
 *          its base datatype. The filter does support the situation where
 *          a variable-length or variable-length string is a member of a
 *          compound datatype.
 *
 *          The N-Bit filter allows all other HDF5 datatypes (such as
 *          time, string, bitfield, opaque, reference, enum, and variable
 *          length) to pass through as a no-op.
 *
 *          Like other I/O filters supported by the HDF5 library,
 *          application using the N-Bit filter must store data with
 *          chunked storage.
 *
 *          By nature, the N-Bit filter should not be used together with
 *          other I/O filters.
 *
 * @version 1.8.8 Fortran subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_nbit(@Cast("hid_t") long plist_id);
/**
 * \ingroup DCPL
 *
 * \brief  Sets up the use of the scale-offset filter
 *
 * \dcpl_id{plist_id}
 * @param scale_type [in]   Flag indicating compression method
 * @param scale_factor [in] Parameter related to scale. Must be
 *                         non-negative
 *
 * @return \herr_t
 *
 * \par_compr_note
 *
 * \details H5Pset_scaleoffset() sets the scale-offset filter,
 *          #H5Z_FILTER_SCALEOFFSET, for a dataset.
 *
 *          Generally speaking, scale-offset compression performs a scale and/or
 *          offset operation on each data value and truncates the resulting
 *          value to a minimum number of bits (MinBits) before storing it. The
 *          current scale-offset filter supports integer and floating-point
 *          datatypes.
 *
 *          For an integer datatype, the parameter \p scale_type should be set
 *          to #H5Z_SO_INT (2). The parameter \p scale_factor denotes MinBits.
 *          If the user sets it to H5Z_SO_INT_MINBITS_DEFAULT (0), the filter
 *          will calculate MinBits. If \p scale_factor is set to a positive
 *          integer, the filter does not do any calculation and just uses the
 *          number as MinBits. However, if the user gives a MinBits that is less
 *          than what would be generated by the filter, the compression will be
 *          lossy. Also, the MinBits supplied by the user cannot exceed the
 *          number of bits to store one value of the dataset datatype.
 *
 *          For a floating-point datatype, the filter adopts the GRiB data
 *          packing mechanism, which offers two alternate methods: E-scaling and
 *          D-scaling. Both methods are lossy compression. If the parameter
 *          \p scale_type is set to #H5Z_SO_FLOAT_DSCALE (0), the filter will
 *          use the D-scaling method; if it is set to #H5Z_SO_FLOAT_ESCALE (1),
 *          the filter will use the E-scaling method. Since only the D-scaling
 *          method is implemented, \p scale_type should be set to
 *          #H5Z_SO_FLOAT_DSCALE or 0.
 *
 *          When the D-scaling method is used, the original data is "D" scaled
 *          — multiplied by 10 to the power of \p scale_factor, and the
 *          "significant" part of the value is moved to the left of the decimal
 *          point. Care should be taken in setting the decimal \p scale_factor
 *          so that the integer part will have enough precision to contain the
 *          appropriate information of the data value. For example, if
 *          \p scale_factor is set to 2, the number 104.561 will be 10456.1
 *          after "D" scaling. The last digit 1 is not "significant" and is
 *          thrown off in the process of rounding. The user should make sure that
 *          after "D" scaling and rounding, the data values are within the range
 *          that can be represented by the integer (same size as the
 *          floating-point type).
 *
 *          Valid values for scale_type are as follows:
 *
 *          <table>
 *          <tr>
 *            <td>#H5Z_SO_FLOAT_DSCALE (0)</td>
 *            <td>Floating-point type, using variable MinBits method</td>
 *          </tr>
 *          <tr>
 *            <td>#H5Z_SO_FLOAT_ESCALE (1)</td>
 *            <td>Floating-point type, using fixed MinBits method</td>
 *          </tr>
 *          <tr>
 *            <td>#H5Z_SO_INT (2)</td>
 *            <td>Integer type</td>
 *          </tr>
 *          </table>
 *
 *          The meaning of \p scale_factor varies according to the value
 *          assigned to \p scale_type:
 *
 *          <table>
 *          <tr>
 *            <th>\p scale_type value</th>
 *            <th>\p scale_factor description</th>
 *          </tr>
 *          <tr>
 *            <td>#H5Z_SO_FLOAT_DSCALE</td>
 *            <td>Denotes the decimal scale factor for D-scaling and can be
 *                positive, negative or zero. This is the current
 *                implementation of the library.</td>
 *          </tr>
 *          <tr>
 *            <td>#H5Z_SO_FLOAT_ESCALE</td>
 *            <td>Denotes MinBits for E-scaling and must be a positive integer.
 *                This is not currently implemented by the library.</td>
 *          </tr>
 *          <tr>
 *            <td>#H5Z_SO_INT</td>
 *            <td>Denotes MinBits and it should be a positive integer or
 *                #H5Z_SO_INT_MINBITS_DEFAULT (0). If it is less than 0, the
 *                library will reset it to 0 since it is not implemented.
 *            </td>
 *          </tr>
 *          </table>
 *          Like other I/O filters supported by the HDF5 library, an
 *          application using the scale-offset filter must store data with
 *          chunked storage.
 *
 * @version 1.8.8 Fortran90 subroutine introduced in this release.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_scaleoffset(@Cast("hid_t") long plist_id, @Cast("H5Z_SO_scale_type_t") int scale_type, int scale_factor);
/**
 * \ingroup DCPL
 *
 * \brief Sets up use of the SZIP compression filter
 *
 * \dcpl_id{plist_id}
 * @param options_mask [in] A bit-mask conveying the desired SZIP options;
 *                         Valid values are #H5_SZIP_EC_OPTION_MASK and
 *                         #H5_SZIP_NN_OPTION_MASK.
 * @param pixels_per_block [in] The number of pixels or data elements in each
 *            data block
 *
 * @return \herr_t
 *
 * \par_compr_note
 *
 * \details H5Pset_szip() sets an SZIP compression filter, #H5Z_FILTER_SZIP,
 *          for a dataset. SZIP is a compression method designed for use with
 *          scientific data.
 *
 *          Before proceeding, all users should review the “Limitations”
 *          section below.
 *
 *          Users familiar with SZIP outside the HDF5 context may benefit
 *          from reviewing the Note “For Users Familiar with SZIP in Other
 *          Contexts” below.
 *
 *          In the text below, the term pixel refers to an HDF5 data element.
 *          This terminology derives from SZIP compression's use with image
 *          data, where pixel referred to an image pixel.
 *
 *          The SZIP \p bits_per_pixel value (see Note, below) is automatically
 *          set, based on the HDF5 datatype. SZIP can be used with atomic
 *          datatypes that may have size of 8, 16, 32, or 64 bits.
 *          Specifically, a dataset with a datatype that is 8-, 16-, 32-, or
 *          64-bit signed or unsigned integer; char; or 32- or 64-bit float
 *          can be compressed with SZIP. See Note, below, for further
 *          discussion of the the SZIP \p bits_per_pixel setting.
 *
 *          SZIP options are passed in an options mask, \p options_mask,
 *          as follows.
 *
 *          <table>
 *            <tr>
 *             <th>Option</th>
 *             <th>Description (Mutually exclusive; select one.)</th>
 *            </tr>
 *            <tr>
 *             <td>#H5_SZIP_EC_OPTION_MASK</td>
 *             <td>Selects entropy coding method</td>
 *            </tr>
 *            <tr>
 *             <td>#H5_SZIP_NN_OPTION_MASK</td>
 *             <td>Selects nearest neighbor coding method</td>
 *            </tr>
 *           </table>
 *
 *           The following guidelines can be used in determining which
 *           option to select:
 *
 *           - The entropy coding method, the EC option specified by
 *             #H5_SZIP_EC_OPTION_MASK, is best suited for data that has been
 *             processed. The EC method works best for small numbers.
 *           - The nearest neighbor coding method, the NN option specified
 *             by #H5_SZIP_NN_OPTION_MASK, preprocesses the data then the
 *             applies EC method as above.
 *
 *           Other factors may affect results, but the above criteria
 *           provides a good starting point for optimizing data compression.
 *
 *           SZIP compresses data block by block, with a user-tunable block
 *           size. This block size is passed in the parameter
 *           \p pixels_per_block and must be even and not greater than 32,
 *           with typical values being 8, 10, 16, or 32. This parameter
 *           affects compression ratio; the more pixel values vary, the
 *           smaller this number should be to achieve better performance.
 *
 *           In HDF5, compression can be applied only to chunked datasets.
 *           If \p pixels_per_block is bigger than the total number of
 *           elements in a dataset chunk, H5Pset_szip() will succeed but
 *           the subsequent call to H5Dcreate() will fail; the conflict
 *           can be detected only when the property list is used.
 *
 *           To achieve optimal performance for SZIP compression, it is
 *           recommended that a chunk's fastest-changing dimension be equal
 *           to N times \p pixels_per_block where N is the maximum number of
 *           blocks per scan line allowed by the SZIP library. In the
 *           current version of SZIP, N is set to 128.
 *
 *           SZIP compression is an optional HDF5 filter.
 *
 *           \b Limitations:
 *
 *           - SZIP compression cannot be applied to compound, array,
 *             variable-length, enumeration, or any other user-defined
 *             datatypes. If an SZIP filter is set in a dataset creation
 *             property list used to create a dataset containing a
 *             non-allowed datatype, the call to H5Dcreate() will fail; the
 *             conflict can be detected only when the property list is used.
 *           - Users should be aware that there are factors that affect one’s
 *             rights and ability to use SZIP compression by reviewing the
 *             SZIP copyright notice.
 *
 * \note \b For \b Users \b Familiar \b with \b SZIP \b in \b Other \b Contexts:
 *
 * \note  The following notes are of interest primarily to those who have
 *        used SZIP compression outside of the HDF5 context.
 *        In non-HDF5 applications, SZIP typically requires that the user
 *        application supply additional parameters:
 *        - \p pixels_in_object, the number of pixels in the object to
 *          be compressed
 *        - \p bits_per_pixel, the number of bits per pixel
 *        - \p pixels_per_scanline, the number of pixels per scan line
 *
 * \note  These values need not be independently supplied in the HDF5
 *        environment as they are derived from the datatype and dataspace,
 *        which are already known. In particular, HDF5 sets
 *        \p pixels_in_object to the number of elements in a chunk and
 *        \p bits_per_pixel to the size of the element or pixel datatype.
 *
 * \note  The following algorithm is used to set \p pixels_per_scanline:
 *        - If the size of a chunk's fastest-changing dimension, size,
 *          is greater than 4K, set \p pixels_per_scanline to 128 times
 *          \p pixels_per_block.
 *        - If size is less than 4K but greater than \p pixels_per_block,
 *          set \p pixels_per_scanline to the minimum of size and 128
 *          times \p pixels_per_block.
 *        - If size is less than \p pixels_per_block but greater than the
 *          number elements in the chunk, set \p pixels_per_scanline to
 *          the minimum of the number elements in the chunk and 128 times
 *          \p pixels_per_block.
 *
 * \note  The HDF5 datatype may have precision that is less than the full
 *        size of the data element, e.g., an 11-bit integer can be defined
 *        using H5Tset_precision(). To a certain extent, SZIP can take
 *        advantage of the precision of the datatype to improve compression:
 *        - If the HDF5 datatype size is 24-bit or less and the offset of
 *          the bits in the HDF5 datatype is zero (see H5Tset_offset() or
 *          H5Tget_offset()), the data is the in lowest N bits of the data
 *          element. In this case, the SZIP \p bits_per_pixel is set to the
 *          precision of the HDF5 datatype.
 *        - If the offset is not zero, the SZIP \p bits_per_pixel will be
 *          set to the number of bits in the full size of the data element.
 *        - If the HDF5 datatype precision is 25-bit to 32-bit, the SZIP
 *          \p bits_per_pixel will be set to 32.
 *        - If the HDF5 datatype precision is 33-bit to 64-bit, the SZIP
 *          \p bits_per_pixel will be set to 64.
 *
 * \note HDF5 always modifies the options mask provided by the user to set up
 *       usage of RAW_OPTION_MASK, ALLOW_K13_OPTION_MASK, and one of
 *       LSB_OPTION_MASK or MSB_OPTION_MASK, depending on endianness of the
 *       datatype.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_szip(@Cast("hid_t") long plist_id, @Cast("unsigned") int options_mask, @Cast("unsigned") int pixels_per_block);

/**
 * \ingroup DCPL
 *
 * \brief Sets the mapping between virtual and source datasets
 *
 * \dcpl_id
 * @param vspace_id [in] The dataspace identifier with the selection within the
 *            virtual dataset applied, possibly an unlimited selection
 * @param src_file_name [in] The name of the HDF5 file where the source dataset is
 *            located or a \Code{"."} (period) for a source dataset in the same
 *            file. The file might not exist yet. The name can be specified using
 *            a C-style \c printf statement as described below.
 * @param src_dset_name [in] The path to the HDF5 dataset in the file specified by
 *            \p src_file_name. The dataset might not exist yet. The dataset name
 *            can be specified using a C-style \c printf statement as described below.
 * @param src_space_id [in] The source dataset’s dataspace identifier with a
 *            selection applied, possibly an unlimited selection
 * @return \herr_t
 *
 * \details H5Pset_virtual() maps elements of the virtual dataset (VDS)
 *          described by the virtual dataspace identifier \p vspace_id to the
 *          elements of the source dataset described by the source dataset
 *          dataspace identifier \p src_space_id. The source dataset is
 *          identified by the name of the file where it is located,
 *          \p src_file_name, and the name of the dataset, \p src_dset_name.
 *
 * \par C-style \c printf Formatting Statements:
 *      C-style \c printf formatting allows a pattern to be specified in the name
 *      of a source file or dataset. Strings for the file and dataset names are
 *      treated as literals except for the following substitutions:
 *      <table>
 *      <tr>
 *      <td>\Code{"%%"}</td>
 *      <td>Replaced with a single \Code{"%"} (percent) character.</td>
 *      </tr>
 *      <tr>
 *      <td><code>"%<d>b"</code></td>
 *      <td>Where <code>"<d>"</code> is the virtual dataset dimension axis (0-based)
 *          and \Code{"b"} indicates that the block count of the selection in that
 *          dimension should be used. The full expression (for example, \Code{"%0b"})
 *          is replaced with a single numeric value when the mapping is evaluated at
 *          VDS access time. Example code for many source and virtual dataset mappings
 *          is available in the "Examples of Source to Virtual Dataset Mapping"
 *          chapter in the
 *          <a href="https://portal.hdfgroup.org/display/HDF5/RFC+HDF5+Virtual+Dataset">
 *            RFC: HDF5 Virtual Dataset</a>.
 *      </td>
 *      </tr>
 *      </table>
 *      If the printf form is used for the source file or dataset names, the
 *      selection in the source dataset’s dataspace must be fixed-size.
 *
 * \par Source File Resolutions:
 *      When a source dataset residing in a different file is accessed, the
 *      library will search for the source file \p src_file_name as described
 *      below:
 *      \li If \p src_file_name is a \Code{"."} (period) then it refers to the
 *          file containing the virtual dataset.
 *      \li If \p src_file_name is a relative pathname, the following steps are
 *          performed:
 *          - The library will get the prefix(es) set in the environment
 *            variable \c HDF5_VDS_PREFIX and will try to prepend each prefix
 *            to \p src_file_name to form a new \p src_file_name. If the new
 *            \p src_file_name does not exist or if \c HDF5_VDS_PREFIX is not
 *            set, the library will get the prefix set via H5Pset_virtual_prefix()
 *            and prepend it to \p src_file_name to form a new \p src_file_name.
 *            If the new \p src_file_name does not exist or no prefix is being
 *            set by H5Pset_virtual_prefix() then the path of the file containing
 *            the virtual dataset is obtained. This path can be the absolute path
 *            or the current working directory plus the relative path of that
 *            file when it is created/opened. The library will prepend this path
 *            to \p src_file_name to form a new \p src_file_name.
 *          - If the new \p src_file_name does not exist, then the library will
 *            look for \p src_file_name and will return failure/success accordingly.
 *      \li If \p src_file_name is an absolute pathname, the library will first
 *          try to find \p src_file_name. If \p src_file_name does not exist,
 *          \p src_file_name is stripped of directory paths to form a new
 *          \p src_file_name. The search for the new \p src_file_name then follows
 *          the same steps as described above for a relative pathname. See
 *          examples below illustrating how \p src_file_name is stripped to form
 *          a new \p src_file_name.
 * \par
 *      Note that \p src_file_name is considered to be an absolute pathname when
 *      the following condition is true:
 *      \li For Unix, the first character of \p src_file_name is a slash
 *          (\Code{/}).\n For example, consider a \p src_file_name of
 *          \Code{/tmp/A.h5}. If that source file does not exist, the new
 *          \p src_file_name after stripping will be \Code{A.h5}.
 *      \li For Windows, there are 6 cases:
 *          1. \p src_file_name is an absolute drive with absolute pathname.\n
 *             For example, consider a \p src_file_name of \Code{/tmp/A.h5}.
 *             If that source file does not exist, the new \p src_file_name
 *             after stripping will be \Code{A.h5}.
 *          2. \p src_file_name is an absolute pathname without specifying
 *             drive name.\n For example, consider a \p src_file_name of
 *             \Code{/tmp/A.h5}. If that source file does not exist, the new
 *             \p src_file_name after stripping will be \Code{A.h5}.
 *          3. \p src_file_name is an absolute drive with relative pathname.\n
 *             For example, consider a \p src_file_name of \Code{/tmp/A.h5}.
 *             If that source file does not exist, the new \p src_file_name
 *             after stripping will be \Code{tmp/A.h5}.
 *          4. \p src_file_name is in UNC (Uniform Naming Convention) format
 *             with server name, share name, and pathname.\n
 *             For example, consider a \p src_file_name of \Code{/tmp/A.h5}.
 *             If that source file does not exist, the new \p src_file_name
 *             after stripping will be \Code{A.h5}.
 *          5. \p src_file_name is in Long UNC (Uniform Naming Convention)
 *             format with server name, share name, and pathname.\n
 *             For example, consider a \p src_file_name of \Code{/tmp/A.h5}.
 *             If that source file does not exist, the new \p src_file_name
 *             after stripping will be \Code{A.h5}.
 *          6. \p src_file_name is in Long UNC (Uniform Naming Convention)
 *             format with an absolute drive and an absolute pathname.\n
 *             For example, consider a \p src_file_name of \Code{/tmp/A.h5}.
 *             If that source file does not exist, the new \p src_file_name
 *             after stripping will be \Code{A.h5}
 *
 * @see <a href="https://portal.hdfgroup.org/display/HDF5/Virtual+Dataset++-+VDS">
 *        Virtual Dataset Overview</a>
 *
 * \see_virtual
 *
 * @version 1.10.2 A change was made to the method of searching for VDS source files.
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") long dcpl_id, @Cast("hid_t") long vspace_id, @Cast("const char*") BytePointer src_file_name,
                             @Cast("const char*") BytePointer src_dset_name, @Cast("hid_t") long src_space_id);
public static native @Cast("herr_t") int H5Pset_virtual(@Cast("hid_t") long dcpl_id, @Cast("hid_t") long vspace_id, String src_file_name,
                             String src_dset_name, @Cast("hid_t") long src_space_id);

/* Dataset access property list (DAPL) routines */
/**
 * \ingroup DAPL
 *
 * \brief Retrieves the values of the append property that is set up in
 *        the dataset access property list
 *
 * \dapl_id
 * @param dims [in]     The number of elements for \p boundary
 * @param boundary [in] The dimension sizes used to determine the boundary
 * @param func [in]     The user-defined callback function
 * @param udata [in]    The user-defined input data
 *
 * @return \herr_t
 *
 * \details H5Pget_append_flush() obtains the following information
 *          from the dataset access property list, \p dapl_id.
 *
 *          \p boundary consists of the sizes set up in the access
 *          property list that are used to determine when a dataset
 *          dimension size hits the boundary. Only at most \p dims
 *          boundary sizes are retrieved, and \p dims will not exceed
 *          the corresponding value that is set in the property list.
 *
 *          \p func is the user-defined callback function to invoke when
 *          a dataset’s appended dimension size reaches a boundary and
 *          \p udata is the user-defined input data for the callback
 *          function.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int dims, @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func,
                                  @Cast("void**") PointerPointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int dims, @Cast("hsize_t*") LongPointer boundary, @ByPtrPtr H5D_append_cb_t func,
                                  @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int dims, @Cast("hsize_t*") LongBuffer boundary, @ByPtrPtr H5D_append_cb_t func,
                                  @Cast("void**") @ByPtrPtr Pointer udata);
public static native @Cast("herr_t") int H5Pget_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int dims, @Cast("hsize_t*") long[] boundary, @ByPtrPtr H5D_append_cb_t func,
                                  @Cast("void**") @ByPtrPtr Pointer udata);
/**
 * \ingroup DAPL
 *
 * \brief Retrieves the raw data chunk cache parameters
 *
 * \dapl_id
 * @param rdcc_nslots [out] Number of chunk slots in the raw data chunk
 *                         cache hash table
 * @param rdcc_nbytes [out] Total size of the raw data chunk cache, in
 *                         bytes
 * @param rdcc_w [out] 0     Preemption policy
 *
 * @return \herr_t
 *
 * \details H5Pget_chunk_cache() retrieves the number of chunk slots in
 *          the raw data chunk cache hash table, the maximum possible
 *          number of bytes in the raw data chunk cache, and the
 *          preemption policy value.
 *
 *          These values are retrieved from a dataset access property
 *          list. If the values have not been set on the property list,
 *          then values returned will be the corresponding values from
 *          a default file access property list.
 *
 *          Any (or all) pointer arguments may be null pointers, in which
 *          case the corresponding data is not returned.
 *
 * @since 1.8.3
 *
 */
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id, @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes,
                                 DoublePointer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id, @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes,
                                 DoubleBuffer rdcc_w0);
public static native @Cast("herr_t") int H5Pget_chunk_cache(@Cast("hid_t") long dapl_id, @Cast("size_t*") SizeTPointer rdcc_nslots, @Cast("size_t*") SizeTPointer rdcc_nbytes,
                                 double[] rdcc_w0);
/**
 * \ingroup DAPL
 *
 * \brief Retrieves the prefix for external raw data storage files as set
 *        in the dataset access property list
 *
 * \dapl_id
 * @param prefix [in,out] Dataset external storage prefix in UTF-8 or
 *                       ASCII (\em Path and \em filename must be ASCII
 *                       on Windows systems.)
 * @param size [in]   Size of prefix buffer in bytes
 *
 * @return Returns the size of \p prefix and the prefix string will be
 *         stored in \p prefix if successful.
 *         Otherwise returns a negative value and the contents of \p prefix
 *         will be undefined.
 *
 * \details H5Pget_efile_prefix() retrieves the file system path prefix
 *          for locating external files associated with a dataset that
 *          uses external storage. This will be the value set with
 *          H5Pset_efile_prefix() or the HDF5 library’s default.
 *
 *          The value of \p size is the size in bytes of the prefix,
 *          including the NULL terminator. If the size is unknown, a
 *          preliminary H5Pget_elink_prefix() call with the pointer
 *          \p prefix set to NULL will return the size of the prefix
 *          without the NULL terminator.
 *
 *          The \p prefix buffer must be allocated by the caller. In a
 *          call that retrieves the actual prefix, that buffer must be
 *          of the size specified in \p size.
 *
 * \note See H5Pset_efile_prefix() for a more complete description of
 *       file location behavior and for notes on the use of the
 *       HDF5_EXTFILE_PREFIX environment variable.
 *
 * @since 1.10.0, 1.8.17
 *
 */
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);
/**
 * \ingroup DAPL
 *
 * \brief Retrieves prefix applied to VDS source file paths
 *
 * \dapl_id
 * @param prefix [out] Prefix applied to VDS source file paths
 * @param size [in]   Size of prefix, including null terminator
 *
 * @return If successful, returns a non-negative value specifying the size
 *         in bytes of the prefix without the NULL terminator; otherwise
 *         returns a negative value.
 *
 * \details H5Pget_virtual_prefix() retrieves the prefix applied to the
 *          path of any VDS source files traversed.
 *
 *          When an VDS source file is traversed, the prefix is retrieved
 *          from the dataset access property list \p dapl_id, returned
 *          in the user-allocated buffer pointed to by \p prefix, and
 *          prepended to the filename stored in the VDS virtual file, set
 *          with H5Pset_virtual().
 *
 *          The size in bytes of the prefix, including the NULL terminator,
 *          is specified in \p size. If \p size is unknown, a preliminary
 *          H5Pget_virtual_prefix() call with the pointer \p prefix set to
 *          NULL will return the size of the prefix without the NULL
 *          terminator.
 *
 * \see_virtual
 *
 * @since 1.10.2
 *
 */
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") BytePointer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") ByteBuffer prefix, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("char*") byte[] prefix, @Cast("size_t") long size);
/**
 * \ingroup DAPL
 *
 * \brief Returns the maximum number of missing source files and/or datasets
 *        with the printf-style names when getting the extent for an unlimited
 *        virtual dataset
 *
 * \dapl_id
 * @param gap_size [out] Maximum number of the files and/or datasets
 *                      allowed to be missing for determining the extent
 *                      of an unlimited virtual dataset with printf-style
 *                      mappings. (\em Default: 0)
 *
 * @return \herr_t
 *
 * \details H5Pget_virtual_printf_gap() returns the maximum number of
 *          missing printf-style files and/or datasets for determining the
 *          extent of an unlimited virtual dataaset, \p gap_size, using
 *          the access property list for the virtual dataset, \p dapl_id.
 *
 *          The default library value for \p gap_size is 0 (zero).
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long dapl_id, @Cast("hsize_t*") LongPointer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long dapl_id, @Cast("hsize_t*") LongBuffer gap_size);
public static native @Cast("herr_t") int H5Pget_virtual_printf_gap(@Cast("hid_t") long dapl_id, @Cast("hsize_t*") long[] gap_size);
/**
 * \ingroup DAPL
 *
 * \brief Retrieves the view of a virtual dataset accessed with
 *        \p dapl_id
 *
 * \dapl_id
 * @param view [out] The flag specifying the view of the virtual dataset.
 *
 * @return \herr_t
 *
 * \details H5Pget_virtual_view() takes the virtual dataset access property
 *          list, \p dapl_id, and retrieves the flag, \p view, set by the
 *          H5Pset_virtual_view() call.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long dapl_id, @Cast("H5D_vds_view_t*") IntPointer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long dapl_id, @Cast("H5D_vds_view_t*") IntBuffer view);
public static native @Cast("herr_t") int H5Pget_virtual_view(@Cast("hid_t") long dapl_id, @Cast("H5D_vds_view_t*") int[] view);
/**
 * \ingroup DAPL
 *
 * \brief Sets two actions to perform when the size of a dataset’s
 *        dimension being appended reaches a specified boundary
 *
 * \dapl_id
 * @param ndims [in]    The number of elements for boundary
 * @param boundary [in] The dimension sizes used to determine the boundary
 * @param func [in]     The user-defined callback function
 * @param udata [in]    The user-defined input data
 *
 * @return \herr_t
 *
 * \details H5Pset_append_flush() sets the following two actions to
 *          perform for a dataset associated with the dataset access
 *          property list \p dapl_id:
 *
 *          \li Call the callback function \p func set in the property
 *              list
 *          \li Flush the dataset associated with the dataset access
 *              property list
 *
 *          When a user is appending data to a dataset via H5DOappend()
 *          and the dataset’s newly extended dimension size hits a
 *          specified boundary, the library will perform the first action
 *          listed above. Upon return from the callback function, the
 *          library will then perform the second action listed above and
 *          return to the user. If no boundary is hit or set, the two
 *          actions above are not invoked.
 *
 *          The specified boundary is indicated by the parameter
 *          \p boundary. It is a 1-dimensional array with \p ndims
 *          elements, which should be the same as the rank of the
 *          dataset’s dataspace. While appending to a dataset along a
 *          particular dimension index via H5Dappend(), the library
 *          determines a boundary is reached when the resulting dimension
 *          size is divisible by \p boundary[index]. A zero value for
 *          \p boundary[index] indicates no boundary is set for that
 *          dimension index.
 *
 *          The setting of this property will apply only for a chunked
 *          dataset with an extendible dataspace. A dataspace is extendible
 *          when it is defined with either one of the following:
 *
 *          \li A dataspace with fixed current and maximum dimension sizes
 *          \li A dataspace with at least one unlimited dimension for its
 *              maximum dimension size
 *
 *          When creating or opening a chunked dataset, the library will
 *          check whether the boundary as specified in the access property
 *          list is set up properly. The library will fail the dataset
 *          create or open if the following conditions are true:
 *
 *          \li \p ndims, the number of elements for boundary, is not the
 *              same as the rank of the dataset’s dataspace.
 *          \li A non-zero boundary value is specified for a non-extendible
 *          dimension.
 *
 *          The callback function \p func must conform to the following
 *          prototype:
 *          \snippet H5Dpublic.h H5D_append_cb_t_snip
 *
 *          The parameters of the callback function, per the above
 *          prototype, are defined as follows:
 *
 *          \li \p dataset_id is the dataset identifier.
 *          \li \p cur_dims is the dataset’s current dimension sizes when
 *              a boundary is hit.
 *          \li \p user_data is the user-defined input data.
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") LongPointer boundary,
                                  H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") LongBuffer boundary,
                                  H5D_append_cb_t func, Pointer udata);
public static native @Cast("herr_t") int H5Pset_append_flush(@Cast("hid_t") long dapl_id, @Cast("unsigned") int ndims, @Cast("const hsize_t*") long[] boundary,
                                  H5D_append_cb_t func, Pointer udata);
/**
 * \ingroup DAPL
 *
 * \brief Sets the raw data chunk cache parameters
 *
 * \dapl_id
 * @param rdcc_nslots [in] The number of chunk slots in the raw data chunk
 *                        cache for this dataset. Increasing this value
 *                        reduces the number of cache collisions, but
 *                        slightly increases the memory used. Due to the
 *                        hashing strategy, this value should ideally be a
 *                        prime number. As a rule of thumb, this value
 *                        should be at least 10 times the number of chunks
 *                        that can fit in \p rdcc_nbytes bytes. For maximum
 *                        performance, this value should be set
 *                        approximately 100 times that number of chunks.
 *                        The default value is 521. If the value passed is
 *                        #H5D_CHUNK_CACHE_NSLOTS_DEFAULT, then the
 *                        property will not be set on \p dapl_id and the
 *                        parameter will come from the file access
 *                        property list used to open the file.
 * @param rdcc_nbytes [in] The total size of the raw data chunk cache for
 *                        this dataset. In most cases increasing this
 *                        number will improve performance, as long as
 *                        you have enough free memory.
 *                        The default size is 1 MB. If the value passed is
 *                        #H5D_CHUNK_CACHE_NBYTES_DEFAULT, then the
 *                        property will not be set on \p dapl_id and the
 *                        parameter will come from the file access
 *                        property list.
 * @param rdcc_w [in] 0     The chunk preemption policy for this dataset.
 *                        This must be between 0 and 1 inclusive and
 *                        indicates the weighting according to which chunks
 *                        which have been fully read or written are
 *                        penalized when determining which chunks to flush
 *                        from cache. A value of 0 means fully read or
 *                        written chunks are treated no differently than
 *                        other chunks (the preemption is strictly LRU)
 *                        while a value of 1 means fully read or written
 *                        chunks are always preempted before other chunks.
 *                        If your application only reads or writes data
 *                        once, this can be safely set to 1. Otherwise,
 *                        this should be set lower, depending on how often
 *                        you re-read or re-write the same data.
 *                        The default value is 0.75. If the value passed is
 *                        #H5D_CHUNK_CACHE_W0_DEFAULT, then the property
 *                        will not be set on \p dapl_id and the parameter
 *                        will come from the file access property list.
 *
 * @return \herr_t
 *
 * \details H5Pset_chunk_cache() sets the number of elements, the total
 *          number of bytes, and the preemption policy value in the raw
 *          data chunk cache on a dataset access property list. After
 *          calling this function, the values set in the property list
 *          will override the values in the file's file access property
 *          list.
 *
 *          The raw data chunk cache inserts chunks into the cache
 *          by first computing a hash value using the address of a chunk,
 *          then using that hash value as the chunk's index into the table
 *          of cached chunks. The size of this hash table, i.e., and the
 *          number of possible hash values, is determined by the
 *          \p rdcc_nslots parameter. If a different chunk in the cache
 *          has the same hash value, this causes a collision, which
 *          reduces efficiency. If inserting the chunk into cache would
 *          cause the cache to be too big, then the cache is pruned
 *          according to the \p rdcc_w0 parameter.
 *
 *      \b Motivation: H5Pset_chunk_cache() is used to adjust the chunk
 *       cache parameters on a per-dataset basis, as opposed to a global
 *       setting for the file using H5Pset_cache(). The optimum chunk
 *       cache parameters may vary widely with different data layout and
 *       access patterns, so for optimal performance they must be set
 *       individually for each dataset. It may also be beneficial to
 *       reduce the size of the chunk cache for datasets whose
 *       performance is not important in order to save memory space.
 *
 *      \b Example \b Usage: The following code sets the chunk cache to
 *       use a hash table with 12421 elements and a maximum size of
 *       16 MB, while using the preemption policy specified for the
 *       entire file:
 *       \Code{
 *       H5Pset_chunk_cache(dapl_id, 12421, 16*1024*1024,
 *            H5D_CHUNK_CACHE_W0_DEFAULT);}
 *
 *      \b Usage \b Notes: The chunk cache size is a property for
 *       accessing a dataset and is not stored with a dataset or a
 *       file. To guarantee the same chunk cache settings each time
 *       the dataset is opened, call H5Dopen() with a dataset access
 *       property list where the chunk cache size is set by calling
 *       H5Pset_chunk_cache() for that property list. The property
 *       list can be used for multiple accesses in the same
 *       application.
 *
 *       For files where the same chunk cache size will be
 *       appropriate for all or most datasets, H5Pset_cache() can
 *       be called with a file access property list to set the
 *       chunk cache size for accessing all datasets in the file.
 *
 *       Both methods can be used in combination, in which case
 *       the chunk cache size set by H5Pset_cache() will apply
 *       except for specific datasets where H5Dopen() is called
 *       with dataset property list with the chunk cache size
 *       set by H5Pset_chunk_cache().
 *
 *       In the absence of any cache settings, H5Dopen() will
 *       by default create a 1 MB chunk cache for the opened
 *       dataset. If this size happens to be appropriate, no
 *       call will be needed to either function to set the
 *       chunk cache size.
 *
 *       It is also possible that a change in access pattern
 *       for later access to a dataset will change the
 *       appropriate chunk cache size.
 *
 * @since 1.8.3
 *
 */
public static native @Cast("herr_t") int H5Pset_chunk_cache(@Cast("hid_t") long dapl_id, @Cast("size_t") long rdcc_nslots, @Cast("size_t") long rdcc_nbytes, double rdcc_w0);
/**
 * \ingroup DAPL
 *
 * \brief Sets the external dataset storage file prefix in the dataset
 *        access property list
 *
 * \dapl_id
 * @param prefix [in] Dataset external storage prefix in UTF-8 or ASCII
 *           (<em>Path and filename must be ASCII on Windows systems.</em>)
 *
 * @return \herr_t
 *
 * \details H5Pset_efile_prefix() sets the prefix used to locate raw data
 *          files for a dataset that uses external storage. This prefix
 *          can provide either an absolute path or a relative path to the
 *          external files.
 *
 *          H5Pset_efile_prefix() is used in conjunction with
 *          H5Pset_external() to control the behavior of the HDF5 library
 *          when searching for the raw data files associated with a dataset
 *          that uses external storage:
 *
 *          \li The default behavior of the library is to search for the
 *              dataset’s external storage raw data files in the same
 *              directory as the HDF5 file which contains the dataset.
 *          \li If the prefix is set to an absolute path, the target
 *              directory will be searched for the dataset’s external
 *              storage raw data files.
 *          \li If the prefix is set to a relative path, the target
 *              directory, relative to the current working directory, will
 *              be searched for the dataset’s external storage raw data
 *              files.
 *          \li If the prefix is set to a relative path that begins with
 *              the special token ${ORIGIN}, that directory, relative to
 *              the HDF5 file containing the dataset, will be searched for
 *              the dataset’s external storage raw data files.
 *
 *           The HDF5_EXTFILE_PREFIX environment variable can be used to
 *           override the above behavior (the environment variable
 *           supersedes the API call). Setting the variable to a path
 *           string and calling H5Dcreate() or H5Dopen() is the equivalent
 *           of calling H5Pset_efile_prefix() and calling the same create
 *           or open function. The environment variable is checked at the
 *           time of the create or open action and copied so it can be
 *           safely changed after the H5Dcreate() or H5Dopen() call.
 *
 *           Calling H5Pset_efile_prefix() with \p prefix set to NULL or
 *           the empty string returns the search path to the default. The
 *           result would be the same as if H5Pset_efile_prefix() had never
 *           been called.
 *
 * \note If the external file prefix is not an absolute path and the HDF5
 *       file is moved, the external storage files will also need to be
 *       moved so they can be accessed at the new location.
 *
 * \note As stated above, the use of the HDF5_EXTFILE_PREFIX environment
 *       variable overrides any property list setting.
 *       H5Pset_efile_prefix() and H5Pget_efile_prefix(), being property
 *       functions, set and retrieve only the property list setting; they
 *       are unaware of the environment variable.
 *
 * \note On Windows, the prefix must be an ASCII string since the Windows
 *       standard C library’s I/O functions cannot handle UTF-8 file names.
 *
 * @since 1.10.0, 1.8.17
 *
 */
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") long dapl_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_efile_prefix(@Cast("hid_t") long dapl_id, String prefix);
/**
 * \ingroup DAPL
 *
 * \brief Sets prefix to be applied to VDS source file paths
 *
 * \dapl_id
 * @param prefix [in] Prefix to be applied to VDS source file paths
 *
 * @return \herr_t
 *
 * \details H5Pset_virtual_prefix() sets the prefix to be applied to the
 *          path of any VDS source files traversed. The prefix is prepended
 *          to the filename stored in the VDS virtual file, set with
 *          H5Pset_virtual().
 *
 *          The prefix is specified in the user-allocated buffer \p prefix
 *          and set in the dataset access property list \p dapl_id. The
 *          buffer should not be freed until the property list has been
 *          closed.
 *
 * \see_virtual
 *
 * @since 1.10.2
 *
 */
public static native @Cast("herr_t") int H5Pset_virtual_prefix(@Cast("hid_t") long dapl_id, @Cast("const char*") BytePointer prefix);
public static native @Cast("herr_t") int H5Pset_virtual_prefix(@Cast("hid_t") long dapl_id, String prefix);
/**
 * \ingroup DAPL
 *
 * \brief Sets the maximum number of missing source files and/or datasets
 *        with the printf-style names when getting the extent of an
 *        unlimited virtual dataset
 *
 * \dapl_id
 * @param gap_size [in] Maximum number of files and/or datasets allowed to
 *                     be missing for determining the extent of an
 *                     unlimited virtual dataset with printf-style
 *                     mappings (<em>Default value</em>: 0)
 *
 * @return \herr_t
 *
 * \details H5Pset_virtual_printf_gap() sets the access property list for
 *          the virtual dataset, \p dapl_id, to instruct the library to
 *          stop looking for the mapped data stored in the files and/or
 *          datasets with the printf-style names after not finding
 *          \p gap_size files and/or datasets. The found source files and
 *          datasets will determine the extent of the unlimited virtual
 *          dataset with the printf-style mappings.
 *
 *          Consider the following examples where the regularly spaced
 *          blocks of a virtual dataset are mapped to datasets with the
 *          names d-1, d-2, d-3, ..., d-N, ... :
 *
 *          \li If the dataset d-2 is missing and \p gap_size is set to 0,
 *              then the virtual dataset will contain only data found
 *              in d-1.
 *          \li If d-2 and d-3 are missing and \p gap_size is set to 2,
 *              then the virtual dataset will contain the data from
 *              d-1, d-3, ..., d-N, ... .  The blocks that are mapped to
 *              d-2 and d-3 will be filled according to the virtual
 *              dataset’s fill value setting.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_virtual_printf_gap(@Cast("hid_t") long dapl_id, @Cast("hsize_t") long gap_size);
/**
 * \ingroup DAPL
 *
 * \brief Sets the view of the virtual dataset (VDS) to include or exclude
 *        missing mapped elements
 *
 * \dapl_id
 * @param view [in] Flag specifying the extent of the data to be included
 *                 in the view.
 *
 * @return \herr_t
 *
 * \details H5Pset_virtual_view() takes the access property list for the
 *          virtual dataset, \p dapl_id, and the flag, \p view, and sets
 *          the VDS view according to the flag value.
 *
 *          If \p view is set to #H5D_VDS_FIRST_MISSING, the view includes
 *          all data before the first missing mapped data. This setting
 *          provides a view containing only the continuous data starting
 *          with the dataset’s first data element. Any break in
 *          continuity terminates the view.
 *
 *          If \p view is set to #H5D_VDS_LAST_AVAILABLE, the view
 *          includes all available mapped data.
 *
 *          Missing mapped data is filled with the fill value set in the
 *          VDS creation property list.
 *
 * \see_virtual
 *
 * @since 1.10.0
 *
 */
public static native @Cast("herr_t") int H5Pset_virtual_view(@Cast("hid_t") long dapl_id, @Cast("H5D_vds_view_t") int view);

/* Dataset xfer property list (DXPL) routines */
/**
 *
 * \ingroup  DXPL
 *
 * \brief Gets B-tree split ratios for a dataset transfer property list
 *
 * \dxpl_id{plist_id}
 * @param left [out] The B-tree split ratio for left-most nodes
 * @param middle [out] The B-tree split ratio for right-most nodes and lone nodes
 * @param right [out] The B-tree split ratio for all other nodes
 * @return \herr_t
 *
 * \details H5Pget_btree_ratios() returns the B-tree split ratios for a dataset
 *          transfer property list.
 *
 *          The B-tree split ratios are returned through the non-NULL arguments
 *          \p left, \p middle, and \p right, as set by the H5Pset_btree_ratios()
 *          function.
 *
 */
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, DoublePointer left, DoublePointer middle,
                                  DoublePointer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, DoubleBuffer left, DoubleBuffer middle,
                                  DoubleBuffer right);
public static native @Cast("herr_t") int H5Pget_btree_ratios(@Cast("hid_t") long plist_id, double[] left, double[] middle,
                                  double[] right);
/**
 *
 * \ingroup  DXPL
 *
 * \brief Reads buffer settings
 *
 * @param plist_id [in]  Identifier for the dataset transfer property list
 * @param tconv [out]     Address of the pointer to application-allocated type
 *                       conversion buffer
 * @param bkg [out]       Address of the pointer to application-allocated
 *                       background buffer
 *
 * @return Returns buffer size, in bytes, if successful; otherwise 0 on failure.
 *
 * \details H5Pget_buffer() reads values previously set with H5Pset_buffer().
 *
 * @version 1.6.0 The return type changed from \p hsize_t to \p size_t.
 * @version 1.4.0 The return type changed to \p hsize_t.
 *
 */
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") long plist_id, @Cast("void**") PointerPointer tconv, @Cast("void**") PointerPointer bkg);
public static native @Cast("size_t") long H5Pget_buffer(@Cast("hid_t") long plist_id, @Cast("void**") @ByPtrPtr Pointer tconv, @Cast("void**") @ByPtrPtr Pointer bkg);
/**
 *
 * \ingroup DXPL
 *
 * \brief Retrieves a data transform expression
 *
 * @param plist_id [in]    Identifier of the property list or class
 * @param expression [out]  Pointer to memory where the transform expression will
 *                         be copied
 * @param size [in]        Number of bytes of the transform expression to copy
 *                         to
 *
 * @return Success: the size of the transform expression. Failure: a negative
 *         value.
 *
 * \details H5Pget_data_transform() retrieves the data transform expression
 *          previously set in the dataset transfer property list \p plist_id
 *          by H5Pset_data_transform().
 *
 *          H5Pget_data_transform() can be used to both retrieve the transform
 *          expression and query its size.
 *
 *          If \p expression is non-NULL, up to \p size bytes of the data
 *          transform expression are written to the buffer. If \p expression
 *          is NULL, \p size is ignored, and the function does not write
 *          anything to the buffer. The function always returns the size of
 *          the data transform expression.
 *
 *          If 0 is returned for the size of the expression, no data transform
 *          expression exists for the property list.
 *
 *          If an error occurs, the buffer pointed to by \p expression is
 *          unchanged, and the function returns a negative value.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") BytePointer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") ByteBuffer expression, @Cast("size_t") long size);
public static native @Cast("ssize_t") long H5Pget_data_transform(@Cast("hid_t") long plist_id, @Cast("char*") byte[] expression, @Cast("size_t") long size);
/**
 *
 * \ingroup  DXPL
 *
 * \brief Determines whether error-detection is enabled for dataset reads
 *
 * @param plist_id [in] Dataset transfer property list identifier
 *
 * @return Returns \p H5Z_ENABLE_EDC or \p H5Z_DISABLE_EDC if successful;
 *         otherwise returns a negative value.
 *
 * \details H5Pget_edc_check() queries the dataset transfer property
 *          list \p plist to determine whether error detection is enabled for
 *          data read operations.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("H5Z_EDC_t") int H5Pget_edc_check(@Cast("hid_t") long plist_id);
/**
 *
 * \ingroup  DXPL
 *
 * \brief Retrieves number of I/O vectors to be read/written in hyperslab I/O
 *
 * @param fapl_id [in] Dataset transfer property list identifier
 * @param size [out]    Number of I/O vectors to accumulate in memory for I/O operations
 *
 * @return \herr_t
 *
 * \details H5Pget_hyper_vector_size() retrieves the number of I/O vectors to be accumulated in
 *          memory before being issued to the lower levels of the HDF5 library for reading or
 *          writing the actual data.
 *
 *          The number of I/O vectors set in the dataset transfer property list \p fapl_id is
 *          returned in \p size. Unless the default value is in use, \p size was
 *          previously set with a call to H5Pset_hyper_vector_size().
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pget_hyper_vector_size(@Cast("hid_t") long fapl_id, @Cast("size_t*") SizeTPointer size);
/**
 *
 * \ingroup  DXPL
 *
 * \brief Checks status of the dataset transfer property list (\b DEPRECATED)
 *
 * @deprecated {H5Pget_preserve() is deprecated as it is no longer useful;
 *            compound datatype field preservation is now core functionality
 *            in the HDF5 library.}
 *
 * @param plist_id [in] Identifier for the dataset transfer property list
 *
 * @return Returns 1 or 0 if successful; otherwise returns a negative value.
 *
 * \details H5Pget_preserve() checks the status of the dataset transfer
 *          property list.
 *
 * @since 1.0.0
 *
 * @version 1.6.0 The flag parameter was changed from INTEGER to LOGICAL to
 *                better match the C API. (Fortran 90)
 * @version 1.8.2 Deprecated.
 *
 */
public static native int H5Pget_preserve(@Cast("hid_t") long plist_id);
/**
 *
 * \ingroup DXPL
 *
 * \brief Gets user-defined datatype conversion callback function
 *
 * @param dxpl_id [in]       Dataset transfer property list identifier
 * @param op [out]           User-defined type conversion callback function
 * @param operate_data [out] User-defined input data for the callback function
 *
 * @return \herr_t
 *
 * \details H5Pget_type_conv_cb() gets the user-defined datatype conversion
 *          callback function \p op in the dataset transfer property list
 *          \p dxpl_id.
 *
 *          The parameter \p operate_data is a pointer to user-defined input
 *          data for the callback function.
 *
 *          The callback function \p op defines the actions an application is
 *          to take when there is an exception during datatype conversion.
 *
 *          Please refer to the function H5Pset_type_conv_cb() for more details.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") long dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") PointerPointer operate_data);
public static native @Cast("herr_t") int H5Pget_type_conv_cb(@Cast("hid_t") long dxpl_id, @ByPtrPtr H5T_conv_except_func_t op, @Cast("void**") @ByPtrPtr Pointer operate_data);
/**
 *
 * \ingroup DXPL
 *
 * \brief Gets the memory manager for variable-length datatype allocation in H5Dread() and H5Dvlen_reclaim()
 *
 * @param plist_id [in]   Identifier for the dataset transfer property list
 * @param alloc_func [out] User's allocate routine, or NULL for system malloc
 * @param alloc_info [out] Extra parameter for user’s allocation routine.
 *             Contents are ignored if preceding
 * parameter is NULL @param free_func [out]  User's free routine, or NULL for
 * system free @param free_info [out]
 * Extra parameter for user’s free routine. Contents are ignored if preceding
 * parameter is NULL
 *
 * @return \herr_t
 *
 * \details H5Pget_vlen_mem_manager() is the companion function to
 *          H5Pset_vlen_mem_manager(), returning the parameters set by
 *          that function.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") long plist_id, @ByPtrPtr H5MM_allocate_t alloc_func, @Cast("void**") PointerPointer alloc_info,
                                      @ByPtrPtr H5MM_free_t free_func, @Cast("void**") PointerPointer free_info);
public static native @Cast("herr_t") int H5Pget_vlen_mem_manager(@Cast("hid_t") long plist_id, @ByPtrPtr H5MM_allocate_t alloc_func, @Cast("void**") @ByPtrPtr Pointer alloc_info,
                                      @ByPtrPtr H5MM_free_t free_func, @Cast("void**") @ByPtrPtr Pointer free_info);
/**
 *
 * \ingroup DXPL
 *
 * \brief Sets B-tree split ratios for a dataset transfer property list
 *
 * @param plist_id [in] The dataset transfer property list identifier
 * @param left [in]     The B-tree split ratio for left-most nodes
 * @param middle [in]   The B-tree split ratio for all other nodes
 * @param right [in]    The B-tree split ratio for right-most nodes and lone
 *                     nodes
 *
 * @return \herr_t
 *
 * \details H5Pset_btree_ratios() sets the B-tree split ratios for a dataset
 *          transfer property list. The split ratios determine what percent of
 *          children go in the first node when a node splits.
 *
 *          The ratio \p left is used when the splitting node is the left-most
 *          node at its level in the tree;
 *          the ratio \p right is used when the splitting node is the right-most
 *          node at its level; and
 *          the ratio \p middle is used for all other cases.
 *
 *          A node that is the only node at its level in the tree uses the
 *          ratio \p right when it splits.
 *
 *          All ratios are real numbers between 0 and 1, inclusive.
 *
 */
public static native @Cast("herr_t") int H5Pset_btree_ratios(@Cast("hid_t") long plist_id, double left, double middle, double right);

/**
 *
 * \ingroup DXPL
 *
 * \brief Sets type conversion and background buffers
 *
 * \dxpl_id{plist_id}
 * @param size [in] Size, in bytes, of the type conversion and background buffers
 * @param tconv [in] Pointer to application-allocated type conversion buffer
 * @param bkg [in] Pointer to application-allocated background buffer
 * @return \herr_t
 *
 * \details Given a dataset transfer property list, H5Pset_buffer() sets the
 *          maximum size for the type conversion buffer and background buffer
 *          and optionally supplies pointers to application-allocated
 *          buffers. If the buffer size is smaller than the entire amount of
 *          data being transferred between the application and the file, and a
 *          type conversion buffer or background buffer is required, then strip
 *          mining will be used.
 *
 *          Note that there are minimum size requirements for the buffer. Strip
 *          mining can only break the data up along the first dimension, so the
 *          buffer must be large enough to accommodate a complete slice that
 *          encompasses all of the remaining dimensions. For example, when strip
 *          mining a \Code{100x200x300} hyperslab of a simple data space, the
 *          buffer must be large enough to hold \Code{1x200x300} data
 *          elements. When strip mining a \Code{100x200x300x150} hyperslab of a
 *          simple data space, the buffer must be large enough to hold
 *          \Code{1x200x300x150} data elements.
 *
 *          If \p tconv and/or \p bkg are null pointers, then buffers will be
 *          allocated and freed during the data transfer.
 *
 *          The default value for the maximum buffer is 1 MiB.
 *
 * @version 1.6.0 The \p size parameter has changed from type hsize_t to \c size_t.
 * @version 1.4.0 The \p size parameter has changed to type hsize_t.
 *
 */
public static native @Cast("herr_t") int H5Pset_buffer(@Cast("hid_t") long plist_id, @Cast("size_t") long size, Pointer tconv, Pointer bkg);

/**
 * \ingroup DXPL
 *
 * \brief Sets a data transform expression
 *
 * \dxpl_id{plist_id}
 * @param expression [in] Pointer to the null-terminated data transform
 *                       expression
 * @return \herr_t
 *
 * \details H5Pset_data_transform() sets the data transform to be used for
 *          reading and writing data. This function operates on the dataset
 *          transfer property list \p plist_id.
 *
 *          The \p expression parameter is a string containing an algebraic
 *          expression, such as \Code{(5/9.0)*(x-32)} or \Code{x*(x-5)}. When a
 *          dataset is read or written with this property list, the transform
 *          expression is applied with the \c x being replaced by the values in
 *          the dataset. When reading data, the values in the file are not
 *          changed and the transformed data is returned to the user.
 *
 *          Data transforms can only be applied to integer or
 *          floating-point datasets. Order of operations is obeyed and
 *          the only supported operations are +, -, *, and /. Parentheses
 *          can be nested arbitrarily and can be used to change precedence.
 *          When writing data back to the dataset, the transformed data is
 *          written to the file and there is no way to recover the original
 *          values to which the transform was applied.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") long plist_id, @Cast("const char*") BytePointer expression);
public static native @Cast("herr_t") int H5Pset_data_transform(@Cast("hid_t") long plist_id, String expression);

/**
 * \ingroup DXPL
 *
 * \brief Sets the dataset transfer property list to enable or disable error
 *        detection when reading data
 *
 * \dxpl_id{plist_id}
 * @param check [in] Specifies whether error checking is enabled or disabled
 *            for dataset read operations
 * @return \herr_t
 *
 * \details H5Pset_edc_check() sets the dataset transfer property list \p plist
 *          to enable or disable error detection when reading data.
 *
 *          Whether error detection is enabled or disabled is specified in the
 *          \p check parameter. Valid values are #H5Z_ENABLE_EDC (default) and
 *          #H5Z_DISABLE_EDC.
 *
 * \note The initial error detection implementation, Fletcher32 checksum,
 *       supports error detection for chunked datasets only.
 *
 * \attention The Fletcher32 EDC checksum filter, set with H5Pset_fletcher32(),
 *            was added in HDF5 Release 1.6.0. In the original implementation,
 *            however, the checksum value was calculated incorrectly on
 *            little-endian systems. The error was fixed in HDF5 Release 1.6.3.\n
 *            As a result of this fix, an HDF5 library of Release 1.6.0 through
 *            Release 1.6.2 cannot read a dataset created or written with
 *            Release 1.6.3 or later if the dataset was created with the
 *            checksum filter and the filter is enabled in the reading
 *            library. (Libraries of Release 1.6.3 and later understand the
 *            earlier error and compensate appropriately.)\n
 *            \Bold{Work-around:} An HDF5 library of Release 1.6.2 or earlier
 *            will be able to read a dataset created or written with the
 *            checksum filter by an HDF5 library of Release 1.6.3 or later if
 *            the checksum filter is disabled for the read operation. This can
 *            be accomplished via an H5Pset_edc_check() call with the value
 *            #H5Z_DISABLE_EDC in the second parameter. This has the obvious
 *            drawback that the application will be unable to verify the
 *            checksum, but the data does remain accessible.
 *
 * @version 1.6.3 Error in checksum calculation on little-endian systems
 *          corrected in this release.
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_edc_check(@Cast("hid_t") long plist_id, @Cast("H5Z_EDC_t") int check);

/**
 * \ingroup DXPL
 *
 * \brief Sets user-defined filter callback function
 *
 * \dxpl_id{plist_id}
 * @param func [in] User-defined filter callback function
 * @param op_data [in] User-defined input data for the callback function
 * @return \herr_t
 *
 * \details H5Pset_filter_callback() sets the user-defined filter callback
 *          function \p func in the dataset transfer property list \p plist_id.
 *
 *          The parameter \p op_data is a pointer to user-defined input data for
 *          the callback function and will be passed through to the callback
 *          function.
 *
 *          The callback function \p func defines the actions an application is
 *          to take when a filter fails. The function prototype is as follows:
 *          \snippet H5Zpublic.h H5Z_filter_func_t_snip
 *          where \c filter indicates which filter has failed, \c buf and \c buf_size
 *          are used to pass in the failed data, and op_data is the required
 *          input data for this callback function.
 *
 *          Valid callback function return values are #H5Z_CB_FAIL and #H5Z_CB_CONT.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_filter_callback(@Cast("hid_t") long plist_id, H5Z_filter_func_t func, Pointer op_data);

/**
 * \ingroup DXPL
 *
 * \brief Sets number of I/O vectors to be read/written in hyperslab I/O
 *
 * \dxpl_id{plist_id}
 * @param size [in] Number of I/O vectors to accumulate in memory for I/O
 *            operations\n
 *            Must be greater than 1 (one)\n
 *            Default value: 1024
 * @return \herr_t
 *
 * \details H5Pset_hyper_vector_size() sets the number of I/O vectors to be
 *          accumulated in memory before being issued to the lower levels of
 *          the HDF5 library for reading or writing the actual data.
 *
 *          The I/O vectors are hyperslab offset and length pairs and are
 *          generated during hyperslab I/O.
 *
 *          The number of I/O vectors is passed in \p size to be set in the
 *          dataset transfer property list \p plist_id. \p size must be
 *          greater than 1 (one).
 *
 *          H5Pset_hyper_vector_size() is an I/O optimization function;
 *          increasing vector_size should provide better performance, but the
 *          library will use more memory during hyperslab I/O. The default value
 *          of \p size is 1024.
 *
 * @since 1.6.0
 *
 */
public static native @Cast("herr_t") int H5Pset_hyper_vector_size(@Cast("hid_t") long plist_id, @Cast("size_t") long size);

/**
 * \ingroup DXPL
 *
 * \brief Sets the dataset transfer property list \p status
 *
 * \dxpl_id{plist_id}
 * @param status [in] Status toggle of the dataset transfer property list
 * @return \herr_t
 *
 * @deprecated This function is deprecated as it no longer has any effect;
 *             compound datatype field preservation is now core functionality in
 *             the HDF5 library.
 *
 * \details H5Pset_preserve() sets the dataset transfer property list status to
 *          \c 1 or \c 0.
 *
 *          When reading or writing compound datatypes and the destination is
 *          partially initialized and the read/write is intended to initialize
 *          the other members, one must set this property to \c 1. Otherwise the
 *          I/O pipeline treats the destination datapoints as completely
 *          uninitialized.
 *
 * @since 1.0.0
 *
 * @version 1.8.2 Deprecated.
 *
 */
public static native @Cast("herr_t") int H5Pset_preserve(@Cast("hid_t") long plist_id, @Cast("hbool_t") boolean status);

/**
 * \ingroup DXPL
 *
 * \brief Sets user-defined datatype conversion callback function
 *
 * \dxpl_id
 * @param op [in] User-defined type conversion callback function
 * @param operate_data [in] User-defined input data for the callback function
 * @return \herr_t
 *
 * \details H5Pset_type_conv_cb() sets the user-defined datatype conversion
 *          callback function \p op in the dataset transfer property list \p
 *          dxpl_id
 *
 *          The parameter operate_data is a pointer to user-defined input data
 *          for the callback function and will be passed through to the callback
 *          function.
 *
 *          The callback function \p op defines the actions an application is to
 *          take when there is an exception during datatype conversion. The
 *          function prototype is as follows:
 *          \snippet H5Tpublic.h H5T_conv_except_func_t_snip
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pset_type_conv_cb(@Cast("hid_t") long dxpl_id, H5T_conv_except_func_t op, Pointer operate_data);

/**
 * \ingroup DXPL
 *
 * \brief Sets the memory manager for variable-length datatype allocation in
 *        H5Dread() and H5Dvlen_reclaim()
 *
 * \dxpl_id{plist_id}
 * @param alloc_func [in] User's allocate routine, or \c NULL for system \c malloc
 * @param alloc_info [in] Extra parameter for user's allocation routine.
 *            Contents are ignored if preceding parameter is \c NULL.
 * @param free_func [in] User's free routine, or \c NULL for system \c free
 * @param free_info [in] Extra parameter for user's free routine. Contents are
 *            ignored if preceding parameter is \c NULL
 * @return \herr_t
 *
 * \details H5Pset_vlen_mem_manager() sets the memory manager for
 *          variable-length datatype allocation in H5Dread() and free in
 *          H5Dvlen_reclaim().
 *
 *          The \p alloc_func and \p free_func parameters identify the memory
 *          management routines to be used. If the user has defined custom
 *          memory management routines, \p alloc_func and/or free_func should be
 *          set to make those routine calls (i.e., the name of the routine is
 *          used as the value of the parameter); if the user prefers to use the
 *          system's \c malloc and/or \c free, the \p alloc_func and \p
 *          free_func parameters, respectively, should be set to \c NULL
 *
 *          The prototypes for these user-defined functions are as follows:
 *          \snippet H5MMpublic.h H5MM_allocate_t_snip
 *
 *          \snippet H5MMpublic.h H5MM_free_t_snip
 *
 *          The \p alloc_info and \p free_info parameters can be used to pass
 *          along any required information to the user's memory management
 *          routines.
 *
 *          In summary, if the user has defined custom memory management
 *          routines, the name(s) of the routines are passed in the \p
 *          alloc_func and \p free_func parameters and the custom routines'
 *          parameters are passed in the \p alloc_info and \p free_info
 *          parameters. If the user wishes to use the system \c malloc and \c
 *          free functions, the \p alloc_func and/or \p free_func parameters are
 *          set to \c NULL and the \p alloc_info and \p free_info parameters are
 *          ignored.
 *
 * @since 1.0.0
 *
 */
public static native @Cast("herr_t") int H5Pset_vlen_mem_manager(@Cast("hid_t") long plist_id, H5MM_allocate_t alloc_func, Pointer alloc_info,
                                      H5MM_free_t free_func, Pointer free_info);

// #ifdef H5_HAVE_PARALLEL
// #endif /* H5_HAVE_PARALLEL */

/* Link creation property list (LCPL) routines */
/**
 * \ingroup ALCAPL
 *
 * \brief Determines whether property is set to enable creating missing
 *        intermediate groups
 *
 * \lcpl_id{plist_id}
 * @param crt_intmd [out] Flag specifying whether to create intermediate
 *                       groups upon creation of an object
 *
 * @return \herr_t
 *
 * \details H5Pget_create_intermediate_group() determines whether the link
 *          creation property list \p plist_id is set to allow functions
 *          that create objects in groups different from the current
 *          working group to create intermediate groups that may be
 *          missing in the path of a new or moved object.
 *
 *          Functions that create objects in or move objects to a group
 *          other than the current working group make use of this
 *          property. H5Gcreate_anon() and H5Lmove() are examples of such
 *          functions.
 *
 *          If \p crt_intmd is positive, missing intermediate groups will
 *          be created; if \p crt_intmd is non-positive, missing intermediate
 *          groups will not be created.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_intmd);
public static native @Cast("herr_t") int H5Pget_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_intmd);
/**
 * \ingroup ALCAPL
 *
 * \brief Specifies in property list whether to create missing
 *        intermediate groups
 *
 * \lcpl_id{plist_id}
 * @param crt_intmd [in] Flag specifying whether to create intermediate
 *                      groups upon the creation of an object
 *
 * @return \herr_t
 *
 * \details H5Pset_create_intermediate_group()
 *
 * @since
 *
 */
public static native @Cast("herr_t") int H5Pset_create_intermediate_group(@Cast("hid_t") long plist_id, @Cast("unsigned") int crt_intmd);

/* Group creation property list (GCPL) routines */

/**
 * \ingroup GCPL
 *
 * \brief Returns the estimated link count and average link name length in a group
 *
 * \gcpl_id{plist_id}
 * @param est_num_entries [out] The estimated number of links in the group
 *             referenced by \p plist_id
 * @param est_name_len [out] The estimated average length of line names in the group
 *             referenced by \p plist_id
 * @return \herr_t
 *
 * \details H5Pget_est_link_info() retrieves two settings from the group creation
 *          property list \p plist_id: the estimated number of links that are
 *          expected to be inserted into a group created with the property list
 *          and the estimated average length of those link names.
 *
 *          The estimated number of links is returned in \p est_num_entries. The
 *          limit for \p est_num_entries is 64 K.
 *
 *          The estimated average length of the anticipated link names is returned
 *          in \p est_name_len. The limit for \p est_name_len is 64 K.
 *
 *          See \ref_group_impls for a discussion of the available types of HDF5
 *          group structures.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer est_num_entries,
                                   @Cast("unsigned*") IntPointer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer est_num_entries,
                                   @Cast("unsigned*") IntBuffer est_name_len);
public static native @Cast("herr_t") int H5Pget_est_link_info(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] est_num_entries,
                                   @Cast("unsigned*") int[] est_name_len);
/**
 * \ingroup GCPL
 *
 * \brief Queries whether link creation order is tracked and/or indexed in
 *        a group
 *
 * @param plist_id [in]         Group or file creation property list
 *                              identifier
 * @param crt_order_flags [out]  Creation order flag(s)
 *
 * @return \herr_t
 *
 * \details H5Pget_link_creation_order() queries the group or file creation
 *          property list, \p plist_id, and returns a flag indicating whether
 *          link creation order is tracked and/or indexed in a group.
 *
 *          See H5Pset_link_creation_order() for a list of valid creation
 *          order flags, as passed in \p crt_order_flags, and their
 *          meanings.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntBuffer crt_order_flags);
public static native @Cast("herr_t") int H5Pget_link_creation_order(@Cast("hid_t") long plist_id, @Cast("unsigned*") int[] crt_order_flags);
/**
 * \ingroup GCPL
 *
 * \brief Queries the settings for conversion between compact and dense
 *        groups
 *
 * \gcpl_id{plist_id}
 * @param max_compact [out] Maximum number of links for compact storage
 * @param min_dense [out]   Minimum number of links for dense storage
 *
 * @return \herr_t
 *
 * \details H5Pget_link_phase_change() queries the maximum number of
 *          entries for a compact group and the minimum number of links
 *          to require before converting a group to a dense form.
 *
 *          In the compact format, links are stored as messages in the
 *          group’s header. In the dense format, links are stored in a
 *          fractal heap and indexed with a version 2 B-tree.
 *
 *          \p max_compact is the maximum number of links to store as
 *          header messages in the group header before converting the
 *          group to the dense format. Groups that are in the compact
 *          format and exceed this number of links are automatically
 *          converted to the dense format.
 *
 *          \p min_dense is the minimum number of links to store in the
 *          dense format. Groups which are in dense format and in which
 *          the number of links falls below this number are automatically
 *          converted back to the compact format.
 *
 *          In the compact format, links are stored as messages in the
 *          group’s header. In the dense format, links are stored in a
 *          fractal heap and indexed with a version 2 B-tree.
 *
 *          See H5Pset_link_phase_change() for a discussion of
 *          traditional, compact, and dense group storage.
 *
 * @since 1.8.0
 *
 */
public static native @Cast("herr_t") int H5Pget_link_phase_change(@Cast("hid_t") long plist_id, @Cast("unsigned*") IntPointer max_compact,
                                       @Cast("unsigned*") IntPointer min_dense);
public static native