// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class CompType
    \brief CompType is a derivative of a DataType and operates on HDF5
    compound datatypes.
*/
//  Inheritance: DataType -> H5Object -> H5Location -> IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class CompType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CompType(Pointer p) { super(p); }

    // Default constructor
    public CompType() { super((Pointer)null); allocate(); }
    private native void allocate();

    // Creates a compound datatype using an existing id
    public CompType(@Cast("const hid_t") long existing_id) { super((Pointer)null); allocate(existing_id); }
    private native void allocate(@Cast("const hid_t") long existing_id);

    // Creates a new compound datatype, given the type's size // H5Tcreate

    // Gets the compound datatype of the specified dataset
    public CompType(@Const @ByRef DataSet dataset) { super((Pointer)null); allocate(dataset); }
    private native void allocate(@Const @ByRef DataSet dataset); // H5Dget_type

    // Copy constructor - same as the original CompType.
    public CompType(@Const @ByRef CompType original) { super((Pointer)null); allocate(original); }
    private native void allocate(@Const @ByRef CompType original);

    // Constructors that open a compound datatype, given a location.
    public CompType(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name) { super((Pointer)null); allocate(loc, name); }
    private native void allocate(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name);
    public CompType(@Const @ByRef H5Location loc, String name) { super((Pointer)null); allocate(loc, name); }
    private native void allocate(@Const @ByRef H5Location loc, String name);

    // Returns a CompType object via DataType* by decoding the binary
    // object description of this type.
    public native @Override DataType decode();

    // Returns the type class of the specified member of this compound
    // datatype.  It provides to the user a way of knowing what type
    // to create another datatype of the same class
    public native @Cast("H5T_class_t") int getMemberClass(@Cast("unsigned") int member_num);

    // Returns the index of a member in this compound data type.
    public native int getMemberIndex(@Cast("const char*") BytePointer name);
    public native int getMemberIndex(String name);

    // Returns the offset of a member of this compound datatype.
    public native @Cast("size_t") long getMemberOffset(@Cast("unsigned") int memb_no);

    // Returns the name of a member of this compound datatype.
    public native @StdString BytePointer getMemberName(@Cast("unsigned") int member_num);

    // Returns the generic datatype of the specified member in
    // this compound datatype.
    public native @ByVal DataType getMemberDataType(@Cast("unsigned") int member_num);

    // Returns the array datatype of the specified member in
    // this compound datatype.
    public native @ByVal ArrayType getMemberArrayType(@Cast("unsigned") int member_num);

    // Returns the compound datatype of the specified member in
    // this compound datatype.
    public native @ByVal CompType getMemberCompType(@Cast("unsigned") int member_num);

    // Returns the enumeration datatype of the specified member in
    // this compound datatype.
    public native @ByVal EnumType getMemberEnumType(@Cast("unsigned") int member_num);

    // Returns the integer datatype of the specified member in
    // this compound datatype.
    public native @ByVal IntType getMemberIntType(@Cast("unsigned") int member_num);

    // Returns the floating-point datatype of the specified member in
    // this compound datatype.
    public native @ByVal FloatType getMemberFloatType(@Cast("unsigned") int member_num);

    // Returns the string datatype of the specified member in
    // this compound datatype.
    public native @ByVal StrType getMemberStrType(@Cast("unsigned") int member_num);

    // Returns the variable length datatype of the specified member in
    // this compound datatype.
    public native @ByVal VarLenType getMemberVarLenType(@Cast("unsigned") int member_num);

    // Returns the number of members in this compound datatype.
    public native int getNmembers();

    // Adds a new member to this compound datatype.
    public native void insertMember(@StdString BytePointer name, @Cast("size_t") long offset, @Const @ByRef DataType new_member);
    public native void insertMember(@StdString String name, @Cast("size_t") long offset, @Const @ByRef DataType new_member);

    // Recursively removes padding from within this compound datatype.
    public native void pack();

    // Sets the total size for this compound datatype.
    public native void setSize(@Cast("size_t") long size);

    /**\brief Returns this class name. */
    public native @StdString @Override BytePointer fromClass();

    // Noop destructor.

}
