// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class DSetCreatPropList
    \brief Class DSetCreatPropList inherits from ObjCreatPropList and provides
    wrappers for the HDF5 dataset creation property functions.
*/
//  Inheritance: ObjCreatPropList -> PropList -> IdComponent
@Namespace("H5") @NoOffset @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class DSetCreatPropList extends ObjCreatPropList {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DSetCreatPropList(Pointer p) { super(p); }

    /**\brief Default dataset creation property list. */
    @MemberGetter public static native @Const @ByRef DSetCreatPropList DEFAULT();

    // Creates a dataset creation property list.
    public DSetCreatPropList() { super((Pointer)null); allocate(); }
    private native void allocate();

    // Queries whether all the filters set in this property list are
    // available currently.
    public native @Cast("bool") boolean allFiltersAvail();

    // Get space allocation time for this property.
    public native @Cast("H5D_alloc_time_t") int getAllocTime();

    // Set space allocation time for dataset during creation.
    public native void setAllocTime(@Cast("H5D_alloc_time_t") int alloc_time);

    // Retrieves the size of the chunks used to store a chunked layout dataset.
    public native int getChunk(int max_ndims, @Cast("hsize_t*") LongPointer dim);
    public native int getChunk(int max_ndims, @Cast("hsize_t*") LongBuffer dim);
    public native int getChunk(int max_ndims, @Cast("hsize_t*") long... dim);

    // Sets the size of the chunks used to store a chunked layout dataset.
    public native void setChunk(int ndims, @Cast("const hsize_t*") LongPointer dim);
    public native void setChunk(int ndims, @Cast("const hsize_t*") LongBuffer dim);
    public native void setChunk(int ndims, @Cast("const hsize_t*") long... dim);

    // Returns information about an external file.
    public native void getExternal(@Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") BytePointer name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef LongPointer size);
    public native void getExternal(@Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") ByteBuffer name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef LongBuffer size);
    public native void getExternal(@Cast("unsigned") int idx, @Cast("size_t") long name_size, @Cast("char*") byte[] name, @Cast("off_t*") @ByRef SizeTPointer offset, @Cast("hsize_t*") @ByRef long... size);

    // Returns the number of external files for a dataset.
    public native int getExternalCount();

    // Gets fill value writing time.
    public native @Cast("H5D_fill_time_t") int getFillTime();

    // Sets fill value writing time for dataset.
    public native void setFillTime(@Cast("H5D_fill_time_t") int fill_time);

    // Retrieves a dataset fill value.
    public native void getFillValue(@Const @ByRef DataType fvalue_type, Pointer value);

    // Sets a dataset fill value.
    public native void setFillValue(@Const @ByRef DataType fvalue_type, @Const Pointer value);

    // Returns information about a filter in a pipeline.
    public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef IntPointer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntPointer cd_values,
                               @Cast("size_t") long namelen, @Cast("char*") BytePointer name, @Cast("unsigned int*") @ByRef IntPointer filter_config);
    public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef IntBuffer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") IntBuffer cd_values,
                               @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name, @Cast("unsigned int*") @ByRef IntBuffer filter_config);
    public native @Cast("H5Z_filter_t") int getFilter(int filter_number, @Cast("unsigned int*") @ByRef int[] flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts, @Cast("unsigned int*") int[] cd_values,
                               @Cast("size_t") long namelen, @Cast("char*") byte[] name, @Cast("unsigned int*") @ByRef int[] filter_config);

    // Returns information about a filter in a pipeline given the filter id.
    public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef IntPointer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts,
                           @Cast("unsigned int*") IntPointer cd_values, @Cast("size_t") long namelen, @Cast("char*") BytePointer name,
                           @Cast("unsigned int*") @ByRef IntPointer filter_config);
    public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef IntBuffer flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts,
                           @Cast("unsigned int*") IntBuffer cd_values, @Cast("size_t") long namelen, @Cast("char*") ByteBuffer name,
                           @Cast("unsigned int*") @ByRef IntBuffer filter_config);
    public native void getFilterById(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int*") @ByRef int[] flags, @Cast("size_t*") @ByRef SizeTPointer cd_nelmts,
                           @Cast("unsigned int*") int[] cd_values, @Cast("size_t") long namelen, @Cast("char*") byte[] name,
                           @Cast("unsigned int*") @ByRef int[] filter_config);

    // Gets the layout of the raw data storage of the data that uses this
    // property list.
    public native @Cast("H5D_layout_t") int getLayout();

    // Sets the type of storage used to store the raw data for the
    // dataset that uses this property list.
    public native void setLayout(@Cast("H5D_layout_t") int layout);

    // Returns the number of filters in the pipeline.
    public native int getNfilters();

    // Checks if fill value has been defined for this property.
    public native @Cast("H5D_fill_value_t") int isFillValueDefined();

    // Modifies the specified filter.
    public native void modifyFilter(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                          @Cast("const unsigned int*") IntPointer cd_values);
    public native void modifyFilter(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                          @Cast("const unsigned int*") IntBuffer cd_values);
    public native void modifyFilter(@Cast("H5Z_filter_t") int filter_id, @Cast("unsigned int") int flags, @Cast("size_t") long cd_nelmts,
                          @Cast("const unsigned int*") int[] cd_values);

    // Remove one or all filters from the filter pipeline.
    public native void removeFilter(@Cast("H5Z_filter_t") int filter_id);

    // Sets compression method and compression level.
    public native void setDeflate(int level);

    // Adds an external file to the list of external files.
    public native void setExternal(@Cast("const char*") BytePointer name, @Cast("off_t") long offset, @Cast("hsize_t") long size);
    public native void setExternal(String name, @Cast("off_t") long offset, @Cast("hsize_t") long size);

    // Adds a filter to the filter pipeline.
    public native void setFilter(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/,
                       @Cast("const unsigned int*") IntPointer cd_values/*=NULL*/);
    public native void setFilter(@Cast("H5Z_filter_t") int filter);
    public native void setFilter(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/,
                       @Cast("const unsigned int*") IntBuffer cd_values/*=NULL*/);
    public native void setFilter(@Cast("H5Z_filter_t") int filter, @Cast("unsigned int") int flags/*=0*/, @Cast("size_t") long cd_nelmts/*=0*/,
                       @Cast("const unsigned int*") int[] cd_values/*=NULL*/);

    // Sets Fletcher32 checksum of EDC for this property list.
    public native void setFletcher32();

    // Sets method of the shuffle filter.
    public native void setShuffle();

    // Sets SZIP compression method.
    public native void setSzip(@Cast("unsigned int") int options_mask, @Cast("unsigned int") int pixels_per_block);

    // Sets N-bit compression method.
    public native void setNbit();

    // Maps elements of a virtual dataset to elements of the source dataset.
    public native void setVirtual(@Const @ByRef DataSpace vspace, @Cast("const char*") BytePointer src_fname, @Cast("const char*") BytePointer src_dsname,
                        @Const @ByRef DataSpace sspace);
    public native void setVirtual(@Const @ByRef DataSpace vspace, String src_fname, String src_dsname,
                        @Const @ByRef DataSpace sspace);

    /**\brief Returns this class name. */
    public native @StdString @Override BytePointer fromClass();

    // Copy constructor - same as the original DSetCreatPropList.
    public DSetCreatPropList(@Const @ByRef DSetCreatPropList orig) { super((Pointer)null); allocate(orig); }
    private native void allocate(@Const @ByRef DSetCreatPropList orig);

    // Creates a copy of an existing dataset creation property list
    // using the property list id.
    public DSetCreatPropList(@Cast("const hid_t") long plist_id) { super((Pointer)null); allocate(plist_id); }
    private native void allocate(@Cast("const hid_t") long plist_id);

    // Noop destructor.

// #ifndef DOXYGEN_SHOULD_SKIP_THIS

    // Deletes the global constant, should only be used by the library
    public static native void deleteConstants();

}
