// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** <!-- [H5AC_cache_image_config_t_snip] -->
/**
 * H5AC_cache_image_config_t is a public structure intended for use in public
 * APIs.  At least in its initial incarnation, it is a copy of \c struct \c
 * H5C_cache_image_ctl_t.
 */

@Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class H5AC_cache_image_config_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public H5AC_cache_image_config_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public H5AC_cache_image_config_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5AC_cache_image_config_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public H5AC_cache_image_config_t position(long position) {
        return (H5AC_cache_image_config_t)super.position(position);
    }
    @Override public H5AC_cache_image_config_t getPointer(long i) {
        return new H5AC_cache_image_config_t((Pointer)this).offsetAddress(i);
    }

    
    /** Integer field containing the version number of this version of the \c
         *  H5C_image_ctl_t structure.  Any instance of \c H5C_image_ctl_t passed
         *  to the cache must have a known version number, or an error will be
         *  flagged.
         */
    public native int version(); public native H5AC_cache_image_config_t version(int setter);
    
    /** Boolean flag indicating whether a cache image should be created on file
         *   close.
         */
    public native @Cast("hbool_t") boolean generate_image(); public native H5AC_cache_image_config_t generate_image(boolean setter);
    
    /** Boolean flag indicating whether the cache image should include the
         *  adaptive cache resize configuration and status.  Note that this field
         *  is ignored at present.
         */
    public native @Cast("hbool_t") boolean save_resize_status(); public native H5AC_cache_image_config_t save_resize_status(boolean setter);
    
    /** Integer field indicating the maximum number of times a
         *   prefetched entry can appear in subsequent cache images.  This field
         *   exists to allow the user to avoid the buildup of infrequently used
         *   entries in long sequences of cache images.
         *
         *   The value of this field must lie in the range \ref
         *   H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE (-1) to \ref
         *   H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX (100).
         *
         *   \ref H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE means that no limit is
         *   imposed on number of times a prefetched entry can appear in subsequent
         *   cache images.
         *
         *   A value of 0 prevents prefetched entries from being included in cache
         *   images.
         *
         *   Positive integers restrict prefetched entries to the specified number
         *   of appearances.
         *
         *   Note that the number of subsequent cache images that a prefetched entry
         *   has appeared in is tracked in an 8 bit field.  Thus, while \ref
         *   H5AC__CACHE_IMAGE__ENTRY_AGEOUT__MAX can be increased from its current
         *   value, any value in excess of 255 will be the functional equivalent of
         *   \ref H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE.
         */
    public native int entry_ageout(); public native H5AC_cache_image_config_t entry_ageout(int setter);
}
