// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;

/** <!-- [H5D_operator_t_snip] -->
 <p>
 *  <!-- [H5D_scatter_func_t_snip] -->
/**
 * \brief Callback for H5Dscatter()
 *
 * @param src_buf [out] Pointer to the buffer holding the next set of elements to
 *                     scatter. On entry, the value of where \p src_buf points to
 *                     is undefined. The callback function should set \p src_buf
 *                     to point to the next set of elements.
 * @param src_buf_bytes_used [out] Pointer to the number of valid bytes in \p src_buf.
 *                                On entry, the value where \p src_buf_bytes_used points
 *                                to is undefined. The callback function should set
 *                                \p src_buf_bytes_used to the of valid bytes in \p src_buf.
 *                                This number must be a multiple of the datatype size.
 * @param op_data [in,out] User-defined pointer to data required by the callback
 *                        function. A pass-through of the \p op_data pointer provided
 *                        with the H5Dscatter() function call.
 * @return herr_t
 *
 * \details The callback function should always return at least one
 *          element in \p src_buf, and must not return more elements
 *          than are remaining to be scattered. This function will be
 *          repeatedly called until all elements to be scattered have
 *          been returned. The callback function should return zero (0)
 *          to indicate success, and a negative value to indicate failure.
 *
 */
@Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class H5D_scatter_func_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    H5D_scatter_func_t(Pointer p) { super(p); }
    protected H5D_scatter_func_t() { allocate(); }
    private native void allocate();
    public native @Cast("herr_t") int call(@Cast("const void**") PointerPointer src_buf, @Cast("size_t*") SizeTPointer src_buf_bytes_used,
                                     Pointer op_data);
}
