// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class H5Library
    \brief Class H5Library operates the HDF5 library globably.
    <p>
    It is not necessary to construct an instance of H5Library to use the
    methods.
*/
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class H5Library extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public H5Library(Pointer p) { super(p); }

    // Initializes the HDF5 library.
    public static native void open();

    // Flushes all data to disk, closes files, and cleans up memory.
    public static native @Name("close") void _close();

    // Instructs library not to install atexit cleanup routine
    public static native void dontAtExit();

    // Returns the HDF library release number.
    public static native void getLibVersion(@Cast("unsigned*") @ByRef IntPointer majnum, @Cast("unsigned*") @ByRef IntPointer minnum, @Cast("unsigned*") @ByRef IntPointer relnum);
    public static native void getLibVersion(@Cast("unsigned*") @ByRef IntBuffer majnum, @Cast("unsigned*") @ByRef IntBuffer minnum, @Cast("unsigned*") @ByRef IntBuffer relnum);
    public static native void getLibVersion(@Cast("unsigned*") @ByRef int[] majnum, @Cast("unsigned*") @ByRef int[] minnum, @Cast("unsigned*") @ByRef int[] relnum);

    // Verifies that the arguments match the version numbers compiled
    // into the library
    public static native void checkVersion(@Cast("unsigned") int majnum, @Cast("unsigned") int minnum, @Cast("unsigned") int relnum);

    // Walks through all the garbage collection routines for the library,
    // which are supposed to free any unused memory they have allocated.
    public static native void garbageCollect();

    // Sets limits on the different kinds of free lists.
    public static native void setFreeListLimits(int reg_global_lim, int reg_list_lim, int arr_global_lim, int arr_list_lim,
                                      int blk_global_lim, int blk_list_lim);

    // Initializes C++ library and registers terminating functions at exit.
    // Only for the library functions, not for user-defined functions.
    public static native void initH5cpp();

    // Sends request for terminating the HDF5 library.
    public static native void termH5cpp();

}
