/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.LongBuffer;
import org.bytedeco.javacpp.Pointer;

public class LongPointer
extends Pointer {
    public LongPointer(long ... array) {
        this(array.length);
        this.put(array);
    }

    public LongPointer(LongBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            long[] array = buffer.array();
            this.allocateArray(array.length - buffer.arrayOffset());
            this.put(array, buffer.arrayOffset(), array.length - buffer.arrayOffset());
            this.position(buffer.position());
            this.limit(buffer.limit());
        }
    }

    public LongPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e);
        }
    }

    public LongPointer() {
    }

    public LongPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public LongPointer position(int position) {
        return (LongPointer)super.position(position);
    }

    public LongPointer limit(int limit) {
        return (LongPointer)super.limit(limit);
    }

    public LongPointer capacity(int capacity) {
        return (LongPointer)super.capacity(capacity);
    }

    public long get() {
        return this.get(0);
    }

    public native long get(int var1);

    public LongPointer put(long l) {
        return this.put(0, l);
    }

    public native LongPointer put(int var1, long var2);

    public LongPointer get(long[] array) {
        return this.get(array, 0, array.length);
    }

    public LongPointer put(long ... array) {
        return this.put(array, 0, array.length);
    }

    public native LongPointer get(long[] var1, int var2, int var3);

    public native LongPointer put(long[] var1, int var2, int var3);

    @Override
    public final LongBuffer asBuffer() {
        return this.asByteBuffer().asLongBuffer();
    }
}

