/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.UByteArrayIndexer;
import org.bytedeco.javacpp.indexer.UByteBufferIndexer;

public abstract class UByteIndexer
extends Indexer {
    protected UByteIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static UByteIndexer create(byte[] array, int[] sizes, int[] strides) {
        return new UByteArrayIndexer(array, sizes, strides);
    }

    public static UByteIndexer create(ByteBuffer buffer, int[] sizes, int[] strides) {
        return new UByteBufferIndexer(buffer, sizes, strides);
    }

    public static UByteIndexer create(BytePointer pointer, int[] sizes, int[] strides) {
        return UByteIndexer.create(pointer, sizes, strides, true);
    }

    public static UByteIndexer create(final BytePointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new UByteBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        byte[] array = new byte[pointer.limit() - position];
        pointer.get(array);
        return new UByteArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract int get(int var1);

    public UByteIndexer get(int i, int[] b) {
        return this.get(i, b, 0, b.length);
    }

    public abstract UByteIndexer get(int var1, int[] var2, int var3, int var4);

    public abstract int get(int var1, int var2);

    public UByteIndexer get(int i, int j, int[] b) {
        return this.get(i, j, b, 0, b.length);
    }

    public abstract UByteIndexer get(int var1, int var2, int[] var3, int var4, int var5);

    public abstract int get(int var1, int var2, int var3);

    public abstract int get(int ... var1);

    public UByteIndexer get(int[] indices, int[] b) {
        return this.get(indices, b, 0, b.length);
    }

    public abstract UByteIndexer get(int[] var1, int[] var2, int var3, int var4);

    public abstract UByteIndexer put(int var1, int var2);

    public UByteIndexer put(int i, int ... b) {
        return this.put(i, b, 0, b.length);
    }

    public abstract UByteIndexer put(int var1, int[] var2, int var3, int var4);

    public abstract UByteIndexer put(int var1, int var2, int var3);

    public UByteIndexer put(int i, int j, int ... b) {
        return this.put(i, j, b, 0, b.length);
    }

    public abstract UByteIndexer put(int var1, int var2, int[] var3, int var4, int var5);

    public abstract UByteIndexer put(int var1, int var2, int var3, int var4);

    public abstract UByteIndexer put(int[] var1, int var2);

    public UByteIndexer put(int[] indices, int ... b) {
        return this.put(indices, b, 0, b.length);
    }

    public abstract UByteIndexer put(int[] var1, int[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public UByteIndexer putDouble(int[] indices, double b) {
        return this.put(indices, (int)b);
    }
}

