/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.bytedeco.javacpp.tools.Builder;
import org.bytedeco.javacpp.tools.Logger;

public class BuildMojo
extends AbstractMojo {
    private String classPath = null;
    private String[] classPaths = null;
    private String includePath = null;
    private String[] includePaths = null;
    private String linkPath = null;
    private String[] linkPaths = null;
    private String preloadPath = null;
    private String[] preloadPaths = null;
    private File outputDirectory = null;
    private String outputName = null;
    private boolean compile = true;
    private boolean header = false;
    private boolean copyLibs = false;
    private String jarPrefix = null;
    private String properties = null;
    private File propertyFile = null;
    private Properties propertyKeysAndValues = null;
    private String classOrPackageName = null;
    private String[] classOrPackageNames = null;
    private Map<String, String> environmentVariables = null;
    private String[] compilerOptions = null;
    private boolean skip = false;
    private MavenProject project;

    String[] merge(String[] ss, String s) {
        if (ss != null && s != null) {
            ss = Arrays.copyOf(ss, ss.length + 1);
            ss[ss.length - 1] = s;
        } else if (s != null) {
            ss = new String[]{s};
        }
        return ss != null ? ss : new String[]{};
    }

    public void execute() throws MojoExecutionException {
        final Log log = this.getLog();
        try {
            String v;
            log.info((CharSequence)"Executing JavaCPP Builder");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("classPath: " + this.classPath));
                log.debug((CharSequence)("classPaths: " + Arrays.deepToString(this.classPaths)));
                log.debug((CharSequence)("includePath: " + this.includePath));
                log.debug((CharSequence)("includePaths: " + Arrays.deepToString(this.includePaths)));
                log.debug((CharSequence)("linkPath: " + this.linkPath));
                log.debug((CharSequence)("linkPaths: " + Arrays.deepToString(this.linkPaths)));
                log.debug((CharSequence)("preloadPath: " + this.preloadPath));
                log.debug((CharSequence)("preloadPaths: " + Arrays.deepToString(this.preloadPaths)));
                log.debug((CharSequence)("outputDirectory: " + this.outputDirectory));
                log.debug((CharSequence)("outputName: " + this.outputName));
                log.debug((CharSequence)("compile: " + this.compile));
                log.debug((CharSequence)("header: " + this.header));
                log.debug((CharSequence)("copyLibs: " + this.copyLibs));
                log.debug((CharSequence)("jarPrefix: " + this.jarPrefix));
                log.debug((CharSequence)("properties: " + this.properties));
                log.debug((CharSequence)("propertyFile: " + this.propertyFile));
                log.debug((CharSequence)("propertyKeysAndValues: " + this.propertyKeysAndValues));
                log.debug((CharSequence)("classOrPackageName: " + this.classOrPackageName));
                log.debug((CharSequence)("classOrPackageNames: " + Arrays.deepToString(this.classOrPackageNames)));
                log.debug((CharSequence)("environmentVariables: " + this.environmentVariables));
                log.debug((CharSequence)("compilerOptions: " + Arrays.deepToString(this.compilerOptions)));
                log.debug((CharSequence)("skip: " + this.skip));
            }
            if (this.skip) {
                log.info((CharSequence)"Skipped execution of JavaCPP Builder");
                return;
            }
            this.classPaths = this.merge(this.classPaths, this.classPath);
            this.classOrPackageNames = this.merge(this.classOrPackageNames, this.classOrPackageName);
            Logger logger = new Logger(){

                @Override
                public void debug(String s) {
                    log.debug((CharSequence)s);
                }

                @Override
                public void info(String s) {
                    log.info((CharSequence)s);
                }

                @Override
                public void warn(String s) {
                    log.warn((CharSequence)s);
                }

                @Override
                public void error(String s) {
                    log.error((CharSequence)s);
                }
            };
            Builder builder = new Builder(logger).classPaths(this.classPaths).outputDirectory(this.outputDirectory).outputName(this.outputName).compile(this.compile).header(this.header).copyLibs(this.copyLibs).jarPrefix(this.jarPrefix).properties(this.properties).propertyFile(this.propertyFile).properties(this.propertyKeysAndValues).classesOrPackages(this.classOrPackageNames).environmentVariables(this.environmentVariables).compilerOptions(this.compilerOptions);
            Properties properties = builder.properties;
            String separator = properties.getProperty("platform.path.separator");
            for (String s : this.merge(this.includePaths, this.includePath)) {
                v = properties.getProperty("platform.includepath", "");
                properties.setProperty("platform.includepath", v.length() == 0 || v.endsWith(separator) ? v + s : v + separator + s);
            }
            for (String s : this.merge(this.linkPaths, this.linkPath)) {
                v = properties.getProperty("platform.linkpath", "");
                properties.setProperty("platform.linkpath", v.length() == 0 || v.endsWith(separator) ? v + s : v + separator + s);
            }
            for (String s : this.merge(this.preloadPaths, this.preloadPath)) {
                v = properties.getProperty("platform.preloadpath", "");
                properties.setProperty("platform.preloadpath", v.length() == 0 || v.endsWith(separator) ? v + s : v + separator + s);
            }
            this.project.getProperties().putAll((Map<?, ?>)properties);
            Object[] outputFiles = builder.build();
            log.info((CharSequence)"Successfully executed JavaCPP Builder");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("outputFiles: " + Arrays.deepToString(outputFiles)));
            }
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to execute JavaCPP Builder: " + e.getMessage()));
            throw new MojoExecutionException("Failed to execute JavaCPP Builder", e);
        }
    }
}

