/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.CharIndexer;

public class CharArrayIndexer
extends CharIndexer {
    protected char[] array;

    public CharArrayIndexer(char[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public char[] array() {
        return this.array;
    }

    @Override
    public char get(int i) {
        return this.array[i];
    }

    @Override
    public CharIndexer get(int i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public char get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public CharIndexer get(int i, int j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public char get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public char get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public CharIndexer get(int[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, char c) {
        this.array[i] = c;
        return this;
    }

    @Override
    public CharIndexer put(int i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, char c) {
        this.array[i * this.strides[0] + j] = c;
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, int k, char c) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = c;
        return this;
    }

    @Override
    public CharIndexer put(int[] indices, char c) {
        this.array[this.index((int[])indices)] = c;
        return this;
    }

    @Override
    public CharIndexer put(int[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = c[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

