/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.FloatIndexer;

public class FloatArrayIndexer
extends FloatIndexer {
    protected float[] array;

    public FloatArrayIndexer(float[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public float[] array() {
        return this.array;
    }

    @Override
    public float get(int i) {
        return this.array[i];
    }

    @Override
    public FloatIndexer get(int i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public float get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public FloatIndexer get(int i, int j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public float get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public float get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public FloatIndexer get(int[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, float f) {
        this.array[i] = f;
        return this;
    }

    @Override
    public FloatIndexer put(int i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, float f) {
        this.array[i * this.strides[0] + j] = f;
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public FloatIndexer put(int i, int j, int k, float f) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = f;
        return this;
    }

    @Override
    public FloatIndexer put(int[] indices, float f) {
        this.array[this.index((int[])indices)] = f;
        return this;
    }

    @Override
    public FloatIndexer put(int[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = f[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

