/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.indexer.UShortIndexer;

public class UShortBufferIndexer
extends UShortIndexer {
    protected ShortBuffer buffer;

    public UShortBufferIndexer(ShortBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public int get(int i) {
        return this.buffer.get(i) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(i * this.strides[0] + n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int i, int j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k) & 0xFFFF;
    }

    @Override
    public int get(int ... indices) {
        return this.buffer.get(this.index(indices)) & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get(this.index(indices) + n) & 0xFFFF;
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int s) {
        this.buffer.put(i, (short)s);
        return this;
    }

    @Override
    public UShortIndexer put(int i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, (short)s[offset + n]);
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int s) {
        this.buffer.put(i * this.strides[0] + j, (short)s);
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, (short)s[offset + n]);
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int k, int s) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, (short)s);
        return this;
    }

    @Override
    public UShortIndexer put(int[] indices, int s) {
        this.buffer.put(this.index(indices), (short)s);
        return this;
    }

    @Override
    public UShortIndexer put(int[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, (short)s[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

