/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.OpenCVFrameConverter;

public class OpenCVFrameRecorder
extends FrameRecorder {
    private static FrameRecorder.Exception loadingException = null;
    private static final boolean windows = Loader.getPlatform().startsWith("windows");
    private String filename;
    private opencv_highgui.CvVideoWriter writer = null;
    private OpenCVFrameConverter.ToIplImage converter = new OpenCVFrameConverter.ToIplImage();

    public static OpenCVFrameRecorder createDefault(File f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static OpenCVFrameRecorder createDefault(String f, int w, int h) throws FrameRecorder.Exception {
        return new OpenCVFrameRecorder(f, w, h);
    }

    public static void tryLoad() throws FrameRecorder.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameRecorder.Exception("Failed to load " + OpenCVFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public OpenCVFrameRecorder(File file, int imageWidth, int imageHeight) {
        this(file.getAbsolutePath(), imageWidth, imageHeight);
    }

    public OpenCVFrameRecorder(String filename, int imageWidth, int imageHeight) {
        this.filename = filename;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 1;
        this.videoCodec = windows ? -1 : opencv_highgui.CV_FOURCC_DEFAULT;
        this.frameRate = 30.0;
    }

    @Override
    public void release() throws FrameRecorder.Exception {
        if (this.writer != null) {
            opencv_highgui.cvReleaseVideoWriter(this.writer);
            this.writer = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public void start() throws FrameRecorder.Exception {
        this.writer = opencv_highgui.cvCreateVideoWriter(this.filename, this.videoCodec, this.frameRate, opencv_core.cvSize(this.imageWidth, this.imageHeight), this.pixelFormat);
        if (this.writer == null) {
            throw new FrameRecorder.Exception("cvCreateVideoWriter(): Could not create a writer");
        }
    }

    @Override
    public void stop() throws FrameRecorder.Exception {
        this.release();
    }

    @Override
    public void record(Frame frame) throws FrameRecorder.Exception {
        opencv_core.IplImage image = this.converter.convert(frame);
        if (this.writer != null) {
            if (opencv_highgui.cvWriteFrame(this.writer, image) == 0) {
                throw new FrameRecorder.Exception("cvWriteFrame(): Could not record frame");
            }
        } else {
            throw new FrameRecorder.Exception("Cannot record: There is no writer (Has start() been called?)");
        }
        frame.keyFrame = true;
    }
}

