/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.io.File;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.opencv_calib3d;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.CameraDevice;
import org.bytedeco.javacv.JavaCV;
import org.bytedeco.javacv.ProjectorDevice;

public class ProjectiveDevice {
    private Settings settings;
    public int imageWidth = 0;
    public int imageHeight = 0;
    public opencv_core.CvMat cameraMatrix = null;
    public opencv_core.CvMat distortionCoeffs = null;
    public opencv_core.CvMat extrParams = null;
    public opencv_core.CvMat reprojErrs = null;
    public double avgReprojErr;
    public double maxReprojErr;
    public opencv_core.CvMat R = null;
    public opencv_core.CvMat T = null;
    public opencv_core.CvMat E = null;
    public opencv_core.CvMat F = null;
    public double avgEpipolarErr;
    public double maxEpipolarErr;
    public String colorOrder = "BGR";
    public opencv_core.CvMat colorMixingMatrix = null;
    public opencv_core.CvMat additiveLight = null;
    public double avgColorErr;
    public double colorR2 = 1.0;
    private boolean fixedPointMaps = false;
    private int mapsPyramidLevel = 0;
    private opencv_core.IplImage[] undistortMaps1 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] undistortMaps2 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] distortMaps1 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage[] distortMaps2 = new opencv_core.IplImage[]{null};
    private opencv_core.IplImage tempImage = null;
    private static ThreadLocal<opencv_core.CvMat> temp3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> B4x3 = opencv_core.CvMat.createThreadLocal(4, 3);
    private static ThreadLocal<opencv_core.CvMat> a4x1 = opencv_core.CvMat.createThreadLocal(4, 1);
    private static ThreadLocal<opencv_core.CvMat> t3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> relativeR3x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> relativeT3x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> R13x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> P13x4 = opencv_core.CvMat.createThreadLocal(3, 4);
    private static ThreadLocal<opencv_core.CvMat> R23x3 = opencv_core.CvMat.createThreadLocal(3, 3);
    private static ThreadLocal<opencv_core.CvMat> P23x4 = opencv_core.CvMat.createThreadLocal(3, 4);

    public ProjectiveDevice(String name) {
        Settings s = new Settings();
        s.name = name;
        this.setSettings(s);
    }

    public ProjectiveDevice(String name, File file) throws Exception {
        this(name);
        this.readParameters(file);
    }

    public ProjectiveDevice(String name, String filename) throws Exception {
        this(name);
        this.readParameters(filename);
    }

    public ProjectiveDevice(String name, opencv_core.CvFileStorage fs) throws Exception {
        this(name);
        this.readParameters(fs);
    }

    public ProjectiveDevice(Settings settings) throws Exception {
        this.setSettings(settings);
        if (settings instanceof CalibratedSettings) {
            this.readParameters(((CalibratedSettings)settings).parametersFile);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void rescale(int imageWidth, int imageHeight) {
        if ((imageWidth != this.imageWidth || imageHeight != this.imageHeight) && this.cameraMatrix != null) {
            double sx = (double)imageWidth / (double)this.imageWidth;
            double sy = (double)imageHeight / (double)this.imageHeight;
            this.cameraMatrix.put(0, sx * this.cameraMatrix.get(0));
            this.cameraMatrix.put(1, sx * this.cameraMatrix.get(1));
            this.cameraMatrix.put(2, sx * this.cameraMatrix.get(2));
            this.cameraMatrix.put(3, sy * this.cameraMatrix.get(3));
            this.cameraMatrix.put(4, sy * this.cameraMatrix.get(4));
            this.cameraMatrix.put(5, sy * this.cameraMatrix.get(5));
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            int p = this.mapsPyramidLevel;
            this.distortMaps2[p] = null;
            this.distortMaps1[p] = null;
            this.undistortMaps2[p] = null;
            this.undistortMaps1[p] = null;
        }
    }

    public int[] getRGBColorOrder() {
        int[] order = new int[3];
        block5: for (int i = 0; i < 3; ++i) {
            switch (Character.toUpperCase(this.colorOrder.charAt(i))) {
                case 'B': {
                    order[i] = 2;
                    continue block5;
                }
                case 'G': {
                    order[i] = 1;
                    continue block5;
                }
                case 'R': {
                    order[i] = 0;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return order;
    }

    public static double[] undistort(double[] xd, double[] k) {
        double k1 = k[0];
        double k2 = k[1];
        double k3 = k.length > 4 ? k[4] : 0.0;
        double k4 = k.length > 5 ? k[5] : 0.0;
        double k5 = k.length > 6 ? k[6] : 0.0;
        double k6 = k.length > 7 ? k[7] : 0.0;
        double p1 = k[2];
        double p2 = k[3];
        double[] xu = (double[])xd.clone();
        for (int i = 0; i < xd.length / 2; ++i) {
            double x = xu[i * 2];
            double y = xu[i * 2 + 1];
            double xo = xd[i * 2];
            double yo = xd[i * 2 + 1];
            for (int j = 0; j < 20; ++j) {
                double r_2 = x * x + y * y;
                double k_radial = 1.0 + k1 * r_2 + k2 * r_2 * r_2 + k3 * r_2 * r_2 * r_2;
                double delta_x = 2.0 * p1 * x * y + p2 * (r_2 + 2.0 * x * x);
                double delta_y = p1 * (r_2 + 2.0 * y * y) + 2.0 * p2 * x * y;
                x = (xo - delta_x) / k_radial;
                y = (yo - delta_y) / k_radial;
            }
            xu[i * 2] = x;
            xu[i * 2 + 1] = y;
        }
        return xu;
    }

    public double[] undistort(double ... x) {
        double[] xn = ProjectiveDevice.normalize(x, this.cameraMatrix);
        double[] xu = ProjectiveDevice.undistort(xn, this.distortionCoeffs.get());
        return ProjectiveDevice.unnormalize(xu, this.cameraMatrix);
    }

    public static double[] distort(double[] xu, double[] k) {
        double k1 = k[0];
        double k2 = k[1];
        double k3 = k.length > 4 ? k[4] : 0.0;
        double k4 = k.length > 5 ? k[5] : 0.0;
        double k5 = k.length > 6 ? k[6] : 0.0;
        double k6 = k.length > 7 ? k[7] : 0.0;
        double p1 = k[2];
        double p2 = k[3];
        double[] xd = (double[])xu.clone();
        for (int i = 0; i < xu.length / 2; ++i) {
            double x = xu[i * 2];
            double y = xu[i * 2 + 1];
            double r_2 = x * x + y * y;
            double k_radial = 1.0 + k1 * r_2 + k2 * r_2 * r_2 + k3 * r_2 * r_2 * r_2;
            double delta_x = 2.0 * p1 * x * y + p2 * (r_2 + 2.0 * x * x);
            double delta_y = p1 * (r_2 + 2.0 * y * y) + 2.0 * p2 * x * y;
            xd[i * 2] = x * k_radial + delta_x;
            xd[i * 2 + 1] = y * k_radial + delta_y;
        }
        return xd;
    }

    public double[] distort(double ... x) {
        double[] xn = ProjectiveDevice.normalize(x, this.cameraMatrix);
        double[] xd = ProjectiveDevice.distort(xn, this.distortionCoeffs.get());
        return ProjectiveDevice.unnormalize(xd, this.cameraMatrix);
    }

    public static double[] normalize(double[] xu, opencv_core.CvMat K) {
        double[] xn = (double[])xu.clone();
        double fx = K.get(0) / K.get(8);
        double fy = K.get(4) / K.get(8);
        double dx = K.get(2) / K.get(8);
        double dy = K.get(5) / K.get(8);
        double s = K.get(1) / K.get(8);
        for (int i = 0; i < xu.length / 2; ++i) {
            xn[i * 2] = (xu[i * 2] - dx) / fx - s * (xu[i * 2 + 1] + dy) / (fx * fy);
            xn[i * 2 + 1] = (xu[i * 2 + 1] - dy) / fy;
        }
        return xn;
    }

    public static double[] unnormalize(double[] xn, opencv_core.CvMat K) {
        double[] xu = (double[])xn.clone();
        double fx = K.get(0) / K.get(8);
        double fy = K.get(4) / K.get(8);
        double dx = K.get(2) / K.get(8);
        double dy = K.get(5) / K.get(8);
        double s = K.get(1) / K.get(8);
        for (int i = 0; i < xn.length / 2; ++i) {
            xu[i * 2] = fx * xn[i * 2] + dx + s * xn[i * 2 + 1];
            xu[i * 2 + 1] = fy * xn[i * 2 + 1] + dy;
        }
        return xu;
    }

    public boolean isFixedPointMaps() {
        return this.fixedPointMaps;
    }

    public void setFixedPointMaps(boolean fixedPointMaps) {
        if (this.fixedPointMaps != fixedPointMaps) {
            this.fixedPointMaps = fixedPointMaps;
            int p = this.mapsPyramidLevel;
            this.distortMaps2[p] = null;
            this.distortMaps1[p] = null;
            this.undistortMaps2[p] = null;
            this.undistortMaps1[p] = null;
        }
    }

    public int getMapsPyramidLevel() {
        return this.mapsPyramidLevel;
    }

    public void setMapsPyramidLevel(int mapsPyramidLevel) {
        if (this.mapsPyramidLevel != mapsPyramidLevel) {
            this.mapsPyramidLevel = mapsPyramidLevel;
            int p = mapsPyramidLevel;
            if (p >= this.undistortMaps1.length || p >= this.undistortMaps2.length || p >= this.distortMaps1.length || p >= this.distortMaps2.length) {
                this.undistortMaps1 = Arrays.copyOf(this.undistortMaps1, p + 1);
                this.undistortMaps2 = Arrays.copyOf(this.undistortMaps2, p + 1);
                this.distortMaps1 = Arrays.copyOf(this.distortMaps1, p + 1);
                this.distortMaps2 = Arrays.copyOf(this.distortMaps2, p + 1);
            }
        }
    }

    private void initUndistortMaps() {
        int p = this.mapsPyramidLevel;
        if (this.undistortMaps1[p] == null || this.undistortMaps2[p] == null) {
            if (this.fixedPointMaps) {
                this.undistortMaps1[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, -2147483632, 2);
                this.undistortMaps2[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 16, 1);
            } else {
                this.undistortMaps1[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 32, 1);
                this.undistortMaps2[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 32, 1);
            }
            opencv_imgproc.cvInitUndistortMap(this.cameraMatrix, this.distortionCoeffs, this.undistortMaps1[p], this.undistortMaps2[p]);
            if (this.mapsPyramidLevel > 0) {
                opencv_core.IplImage map1 = this.undistortMaps1[p];
                opencv_core.IplImage map2 = this.undistortMaps2[p];
                int w = this.imageWidth >> p;
                int h = this.imageHeight >> p;
                this.undistortMaps1[p] = opencv_core.IplImage.create(w, h, map1.depth(), map1.nChannels());
                this.undistortMaps2[p] = opencv_core.IplImage.create(w, h, map2.depth(), map2.nChannels());
                opencv_imgproc.cvResize(map1, this.undistortMaps1[p], 0);
                opencv_imgproc.cvResize(map2, this.undistortMaps2[p], 0);
            }
        }
    }

    public opencv_core.IplImage getUndistortMap1() {
        this.initUndistortMaps();
        return this.undistortMaps1[this.mapsPyramidLevel];
    }

    public opencv_core.IplImage getUndistortMap2() {
        this.initUndistortMaps();
        return this.undistortMaps2[this.mapsPyramidLevel];
    }

    public void undistort(opencv_core.IplImage src, opencv_core.IplImage dst) {
        if (src != null && dst != null) {
            this.initUndistortMaps();
            opencv_imgproc.cvRemap(src, dst, this.undistortMaps1[this.mapsPyramidLevel], this.undistortMaps2[this.mapsPyramidLevel], 9, opencv_core.CvScalar.ZERO);
        }
    }

    public opencv_core.IplImage undistort(opencv_core.IplImage image) {
        if (image != null) {
            this.initUndistortMaps();
            this.tempImage = opencv_core.IplImage.createIfNotCompatible(this.tempImage, image);
            opencv_core.cvResetImageROI(this.tempImage);
            opencv_imgproc.cvRemap(image, this.tempImage, this.undistortMaps1[this.mapsPyramidLevel], this.undistortMaps2[this.mapsPyramidLevel], 9, opencv_core.CvScalar.ZERO);
            return this.tempImage;
        }
        return null;
    }

    private void initDistortMaps() {
        int p = this.mapsPyramidLevel;
        if (this.distortMaps1[p] == null || this.distortMaps2[p] == null) {
            opencv_core.IplImage mapx = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 32, 1);
            opencv_core.IplImage mapy = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 32, 1);
            FloatBuffer bufx = mapx.getFloatBuffer();
            FloatBuffer bufy = mapy.getFloatBuffer();
            int width = mapx.width();
            int height = mapx.height();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double[] distxy = this.undistort(x, y);
                    bufx.put((float)distxy[0]);
                    bufy.put((float)distxy[1]);
                }
            }
            if (this.fixedPointMaps) {
                this.distortMaps1[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, -2147483632, 2);
                this.distortMaps2[p] = opencv_core.IplImage.create(this.imageWidth, this.imageHeight, 16, 1);
                opencv_imgproc.cvConvertMaps(mapx, mapy, this.distortMaps1[p], this.distortMaps2[p]);
                mapx.release();
                mapy.release();
            } else {
                this.distortMaps1[p] = mapx;
                this.distortMaps2[p] = mapy;
            }
            if (this.mapsPyramidLevel > 0) {
                opencv_core.IplImage map1 = this.distortMaps1[p];
                opencv_core.IplImage map2 = this.distortMaps2[p];
                int w = this.imageWidth >> p;
                int h = this.imageHeight >> p;
                this.distortMaps1[p] = opencv_core.IplImage.create(w, h, map1.depth(), map1.nChannels());
                this.distortMaps2[p] = opencv_core.IplImage.create(w, h, map2.depth(), map2.nChannels());
                opencv_imgproc.cvResize(map1, this.distortMaps1[p], 0);
                opencv_imgproc.cvResize(map2, this.distortMaps2[p], 0);
            }
        }
    }

    public opencv_core.IplImage getDistortMap1() {
        this.initDistortMaps();
        return this.distortMaps1[this.mapsPyramidLevel];
    }

    public opencv_core.IplImage getDistortMap2() {
        this.initDistortMaps();
        return this.distortMaps2[this.mapsPyramidLevel];
    }

    public void distort(opencv_core.IplImage src, opencv_core.IplImage dst) {
        if (src != null && dst != null) {
            this.initDistortMaps();
            opencv_imgproc.cvRemap(src, dst, this.distortMaps1[this.mapsPyramidLevel], this.distortMaps2[this.mapsPyramidLevel], 9, opencv_core.CvScalar.ZERO);
        }
    }

    public opencv_core.IplImage distort(opencv_core.IplImage image) {
        if (image != null) {
            this.initDistortMaps();
            this.tempImage = opencv_core.IplImage.createIfNotCompatible(this.tempImage, image);
            opencv_imgproc.cvRemap(image, this.tempImage, this.distortMaps1[this.mapsPyramidLevel], this.distortMaps2[this.mapsPyramidLevel], 9, opencv_core.CvScalar.ZERO);
            return this.tempImage;
        }
        return null;
    }

    public opencv_core.CvMat getBackProjectionMatrix(opencv_core.CvMat n, double d, opencv_core.CvMat B) {
        opencv_core.CvMat temp = temp3x3.get();
        temp.cols(1);
        temp.step(temp.step() / 3);
        B.rows(3);
        opencv_core.cvGEMM(this.R, this.T, -1.0, null, 0.0, temp, 1);
        opencv_core.cvGEMM(temp, n, 1.0, null, 0.0, B, 2);
        double a = opencv_core.cvDotProduct(n, temp) + d;
        B.put(0, B.get(0) - a);
        B.put(4, B.get(4) - a);
        B.put(8, B.get(8) - a);
        B.rows(4);
        temp.cols(3);
        temp.step(temp.step() * 3);
        B.put(9, n.get());
        opencv_core.cvMatMul(this.cameraMatrix, this.R, temp);
        opencv_core.cvInvert(temp, temp, 0);
        opencv_core.cvMatMul(B, temp, B);
        opencv_core.cvConvertScale(B, B, 1.0 / B.get(11), 0.0);
        return B;
    }

    public opencv_core.CvMat getFrontoParallelH(double[] roipts, opencv_core.CvMat n, opencv_core.CvMat H) {
        opencv_core.CvMat B = B4x3.get();
        opencv_core.CvMat a = a4x1.get();
        opencv_core.CvMat t = t3x1.get();
        double s = Math.signum(n.get(2));
        double[] dir = JavaCV.unitize(-s * n.get(1), s * n.get(0));
        double theta = Math.acos(s * n.get(2) / JavaCV.norm(n.get()));
        t.put(theta * dir[0], theta * dir[1], 0.0);
        opencv_calib3d.cvRodrigues2(t, H, null);
        opencv_core.cvMatMul(this.R, H, H);
        double x = 0.0;
        double y = 0.0;
        if (roipts != null) {
            double x1 = roipts[0];
            double y1 = roipts[1];
            double x2 = roipts[4];
            double y2 = roipts[5];
            double x3 = roipts[2];
            double y3 = roipts[3];
            double x4 = roipts[6];
            double y4 = roipts[7];
            double u = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
            x = x1 + u * (x2 - x1);
            y = y1 + u * (y2 - y1);
        }
        this.getBackProjectionMatrix(n, -1.0, B);
        t.put(x, y, 1.0);
        opencv_core.cvMatMul(B, t, a);
        H.put(2, a.get(0) / a.get(3));
        H.put(5, a.get(1) / a.get(3));
        H.put(8, a.get(2) / a.get(3));
        return H;
    }

    public opencv_core.CvMat getRectifyingHomography(ProjectiveDevice peer, opencv_core.CvMat H) {
        opencv_core.CvMat relativeR = relativeR3x3.get();
        opencv_core.CvMat relativeT = relativeT3x1.get();
        opencv_core.cvGEMM(this.R, peer.R, 1.0, null, 0.0, relativeR, 2);
        opencv_core.cvGEMM(relativeR, peer.T, -1.0, this.T, 1.0, relativeT, 0);
        opencv_core.CvMat R1 = R13x3.get();
        opencv_core.CvMat P1 = P13x4.get();
        opencv_core.CvMat R2 = R23x3.get();
        opencv_core.CvMat P2 = P23x4.get();
        opencv_core.CvSize imageSize = opencv_core.cvSize((peer.imageWidth + this.imageWidth) / 2, (peer.imageHeight + this.imageHeight) / 2);
        opencv_calib3d.cvStereoRectify(peer.cameraMatrix, this.cameraMatrix, peer.distortionCoeffs, this.distortionCoeffs, imageSize, relativeR, relativeT, R1, R2, P1, P2, null, 0, -1.0, opencv_core.CvSize.ZERO, null, null);
        opencv_core.cvMatMul(this.cameraMatrix, R2, R2);
        opencv_core.cvInvert(this.cameraMatrix, R1);
        opencv_core.cvMatMul(R2, R1, H);
        return H;
    }

    public static ProjectiveDevice[] read(String filename) throws Exception {
        opencv_core.CvFileStorage fs = opencv_core.CvFileStorage.open(filename, null, 0);
        CameraDevice[] cameraDevices = CameraDevice.read(fs);
        ProjectorDevice[] projectorDevices = ProjectorDevice.read(fs);
        ProjectiveDevice[] devices = new ProjectiveDevice[cameraDevices.length + projectorDevices.length];
        int i = 0;
        for (CameraDevice cameraDevice : cameraDevices) {
            devices[i++] = cameraDevice;
        }
        for (ProjectiveDevice projectiveDevice : projectorDevices) {
            devices[i++] = projectiveDevice;
        }
        fs.release();
        return devices;
    }

    public static void write(String filename, ProjectiveDevice[] ... devices) {
        int totalLength = 0;
        for (ProjectiveDevice[] ds : devices) {
            totalLength += ds.length;
        }
        ProjectiveDevice[] allDevices = new ProjectiveDevice[totalLength];
        int i = 0;
        ProjectiveDevice[][] projectiveDeviceArray = devices;
        int n = projectiveDeviceArray.length;
        for (int j = 0; j < n; ++j) {
            ProjectiveDevice[] ds;
            for (ProjectiveDevice d : ds = projectiveDeviceArray[j]) {
                allDevices[i++] = d;
            }
        }
        ProjectiveDevice.write(filename, allDevices);
    }

    public static void write(String filename, ProjectiveDevice ... devices) {
        opencv_core.CvFileStorage fs = opencv_core.CvFileStorage.open(filename, null, 1);
        opencv_core.CvAttrList a = opencv_core.cvAttrList();
        opencv_core.cvStartWriteStruct(fs, "Cameras", 5, null, a);
        for (ProjectiveDevice d : devices) {
            if (!(d instanceof CameraDevice)) continue;
            opencv_core.cvWriteString(fs, null, d.getSettings().getName(), 0);
        }
        opencv_core.cvEndWriteStruct(fs);
        opencv_core.cvStartWriteStruct(fs, "Projectors", 5, null, a);
        for (ProjectiveDevice d : devices) {
            if (!(d instanceof ProjectorDevice)) continue;
            opencv_core.cvWriteString(fs, null, d.getSettings().getName(), 0);
        }
        opencv_core.cvEndWriteStruct(fs);
        for (ProjectiveDevice d : devices) {
            d.writeParameters(fs);
        }
        fs.release();
    }

    public void writeParameters(File file) {
        this.writeParameters(file.getAbsolutePath());
    }

    public void writeParameters(String filename) {
        opencv_core.CvFileStorage fs = opencv_core.CvFileStorage.open(filename, null, 1);
        this.writeParameters(fs);
        fs.release();
    }

    public void writeParameters(opencv_core.CvFileStorage fs) {
        opencv_core.CvAttrList a = opencv_core.cvAttrList();
        opencv_core.cvStartWriteStruct(fs, this.getSettings().getName(), 6, null, a);
        opencv_core.cvWriteInt(fs, "imageWidth", this.imageWidth);
        opencv_core.cvWriteInt(fs, "imageHeight", this.imageHeight);
        opencv_core.cvWriteReal(fs, "responseGamma", this.getSettings().getResponseGamma());
        if (this.cameraMatrix != null) {
            opencv_core.cvWrite(fs, "cameraMatrix", (Pointer)this.cameraMatrix, a);
        }
        if (this.distortionCoeffs != null) {
            opencv_core.cvWrite(fs, "distortionCoeffs", (Pointer)this.distortionCoeffs, a);
        }
        if (this.extrParams != null) {
            opencv_core.cvWrite(fs, "extrParams", (Pointer)this.extrParams, a);
        }
        if (this.reprojErrs != null) {
            opencv_core.cvWrite(fs, "reprojErrs", (Pointer)this.reprojErrs, a);
        }
        opencv_core.cvWriteReal(fs, "avgReprojErr", this.avgReprojErr);
        opencv_core.cvWriteReal(fs, "maxReprojErr", this.maxReprojErr);
        if (this.R != null) {
            opencv_core.cvWrite(fs, "R", (Pointer)this.R, a);
        }
        if (this.T != null) {
            opencv_core.cvWrite(fs, "T", (Pointer)this.T, a);
        }
        if (this.E != null) {
            opencv_core.cvWrite(fs, "E", (Pointer)this.E, a);
        }
        if (this.F != null) {
            opencv_core.cvWrite(fs, "F", (Pointer)this.F, a);
        }
        opencv_core.cvWriteReal(fs, "avgEpipolarErr", this.avgEpipolarErr);
        opencv_core.cvWriteReal(fs, "maxEpipolarErr", this.maxEpipolarErr);
        opencv_core.cvWriteString(fs, "colorOrder", this.colorOrder, 0);
        if (this.colorMixingMatrix != null) {
            opencv_core.cvWrite(fs, "colorMixingMatrix", (Pointer)this.colorMixingMatrix, a);
        }
        if (this.additiveLight != null) {
            opencv_core.cvWrite(fs, "additiveLight", (Pointer)this.additiveLight, a);
        }
        opencv_core.cvWriteReal(fs, "avgColorErr", this.avgColorErr);
        opencv_core.cvWriteReal(fs, "colorR2", this.colorR2);
        opencv_core.cvEndWriteStruct(fs);
    }

    public void readParameters(File file) throws Exception {
        this.readParameters(file.getAbsolutePath());
    }

    public void readParameters(String filename) throws Exception {
        opencv_core.CvFileStorage fs = opencv_core.CvFileStorage.open(filename, null, 0);
        this.readParameters(fs);
        fs.release();
    }

    public void readParameters(opencv_core.CvFileStorage fs) throws Exception {
        if (fs == null) {
            throw new Exception("Error: CvFileStorage is null, cannot read parameters for device " + this.getSettings().getName() + ". Is the parametersFile correct?");
        }
        opencv_core.CvAttrList a = opencv_core.cvAttrList();
        opencv_core.CvFileNode fn = opencv_core.cvGetFileNodeByName(fs, null, this.getSettings().getName());
        if (fn == null) {
            throw new Exception("Error: CvFileNode is null, cannot read parameters for device " + this.getSettings().getName() + ". Is the name correct?");
        }
        this.imageWidth = opencv_core.cvReadIntByName(fs, fn, "imageWidth", this.imageWidth);
        this.imageHeight = opencv_core.cvReadIntByName(fs, fn, "imageHeight", this.imageHeight);
        this.getSettings().setResponseGamma(opencv_core.cvReadRealByName(fs, fn, "gamma", this.getSettings().getResponseGamma()));
        Pointer p = opencv_core.cvReadByName(fs, fn, "cameraMatrix", a);
        this.cameraMatrix = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "distortionCoeffs", a);
        this.distortionCoeffs = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "extrParams", a);
        this.extrParams = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "reprojErrs", a);
        this.reprojErrs = p == null ? null : new opencv_core.CvMat(p);
        this.avgReprojErr = opencv_core.cvReadRealByName(fs, fn, "avgReprojErr", this.avgReprojErr);
        this.maxReprojErr = opencv_core.cvReadRealByName(fs, fn, "maxReprojErr", this.maxReprojErr);
        p = opencv_core.cvReadByName(fs, fn, "R", a);
        this.R = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "T", a);
        this.T = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "E", a);
        this.E = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "F", a);
        this.F = p == null ? null : new opencv_core.CvMat(p);
        this.avgEpipolarErr = opencv_core.cvReadRealByName(fs, fn, "avgEpipolarErr", this.avgEpipolarErr);
        this.maxEpipolarErr = opencv_core.cvReadRealByName(fs, fn, "maxEpipolarErr", this.maxEpipolarErr);
        this.colorOrder = opencv_core.cvReadStringByName(fs, fn, "colorOrder", this.colorOrder);
        p = opencv_core.cvReadByName(fs, fn, "colorMixingMatrix", a);
        this.colorMixingMatrix = p == null ? null : new opencv_core.CvMat(p);
        p = opencv_core.cvReadByName(fs, fn, "additiveLight", a);
        this.additiveLight = p == null ? null : new opencv_core.CvMat(p);
        this.avgColorErr = opencv_core.cvReadRealByName(fs, fn, "avgColorErr", this.avgColorErr);
        this.colorR2 = opencv_core.cvReadRealByName(fs, fn, "colorR2", this.colorR2);
    }

    public String toString() {
        String s = this.getSettings().getName() + " (" + this.imageWidth + " x " + this.imageHeight + ")\n";
        for (int i = 0; i < this.getSettings().getName().length(); ++i) {
            s = s + "=";
        }
        s = s + "\nIntrinsics\n----------\ncamera matrix = " + (this.cameraMatrix == null ? "null" : this.cameraMatrix.toString(16)) + "\n" + "distortion coefficients = " + (this.distortionCoeffs == null ? "null" : this.distortionCoeffs) + "\n" + "reprojection RMS/max error (pixels) = " + (float)this.avgReprojErr + " / " + (float)this.maxReprojErr + "\n\n" + "Extrinsics\n" + "----------\n" + "rotation = " + (this.R == null ? "null" : this.R.toString(11)) + "\n" + "translation = " + (this.T == null ? "null" : this.T.toString(14)) + "\n" + "epipolar RMS/max error (pixels) = " + (float)this.avgEpipolarErr + " / " + (float)this.maxEpipolarErr + "\n\n" + "Color\n" + "-----\n" + "order = " + this.colorOrder + "\n" + "mixing matrix = " + (this.colorMixingMatrix == null ? "null" : this.colorMixingMatrix.toString(16)) + "\n" + "additive light = " + (this.additiveLight == null ? "null" : this.additiveLight.toString(17)) + "\n" + "normalized RMSE (intensity) = " + (float)this.avgColorErr + "\n" + "R^2 (intensity) = " + (float)this.colorR2;
        return s;
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CalibratedSettings
    extends Settings {
        File parametersFile = new File("calibration.yaml");

        public CalibratedSettings() {
        }

        public CalibratedSettings(CalibratedSettings settings) {
            super(settings);
            this.parametersFile = settings.parametersFile;
        }

        public File getParametersFile() {
            return this.parametersFile;
        }

        public void setParametersFile(File parametersFile) {
            this.parametersFile = parametersFile;
        }

        public String getParametersFilename() {
            return this.parametersFile == null ? "" : this.parametersFile.getPath();
        }

        public void setParametersFilename(String parametersFilename) {
            this.parametersFile = parametersFilename == null || parametersFilename.length() == 0 ? null : new File(parametersFilename);
        }
    }

    public static class CalibrationSettings
    extends Settings {
        double initAspectRatio = 1.0;
        int flags = 14720;

        public CalibrationSettings() {
        }

        public CalibrationSettings(CalibrationSettings settings) {
            super(settings);
            this.initAspectRatio = settings.initAspectRatio;
            this.flags = settings.flags;
        }

        public double getInitAspectRatio() {
            return this.initAspectRatio;
        }

        public void setInitAspectRatio(double initAspectRatio) {
            this.initAspectRatio = initAspectRatio;
        }

        public boolean isUseIntrinsicGuess() {
            return (this.flags & 1) != 0;
        }

        public void setUseIntrinsicGuess(boolean useIntrinsicGuess) {
            this.flags = useIntrinsicGuess ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        }

        public boolean isFixAspectRatio() {
            return (this.flags & 2) != 0;
        }

        public void setFixAspectRatio(boolean fixAspectRatio) {
            this.flags = fixAspectRatio ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        }

        public boolean isFixPrincipalPoint() {
            return (this.flags & 4) != 0;
        }

        public void setFixPrincipalPoint(boolean fixPrincipalPoint) {
            this.flags = fixPrincipalPoint ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        }

        public boolean isZeroTangentDist() {
            return (this.flags & 8) != 0;
        }

        public void setZeroTangentDist(boolean zeroTangentDist) {
            this.flags = zeroTangentDist ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
        }

        public boolean isFixFocalLength() {
            return (this.flags & 0x10) != 0;
        }

        public void setFixFocalLength(boolean fixFocalLength) {
            this.flags = fixFocalLength ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
        }

        public boolean isFixK1() {
            return (this.flags & 0x20) != 0;
        }

        public void setFixK1(boolean fixK1) {
            this.flags = fixK1 ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
        }

        public boolean isFixK2() {
            return (this.flags & 0x40) != 0;
        }

        public void setFixK2(boolean fixK2) {
            this.flags = fixK2 ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        }

        public boolean isFixK3() {
            return (this.flags & 0x80) != 0;
        }

        public void setFixK3(boolean fixK3) {
            this.flags = fixK3 ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
        }

        public boolean isFixK4() {
            return (this.flags & 0x800) != 0;
        }

        public void setFixK4(boolean fixK4) {
            this.flags = fixK4 ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
        }

        public boolean isFixK5() {
            return (this.flags & 0x1000) != 0;
        }

        public void setFixK5(boolean fixK5) {
            this.flags = fixK5 ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
        }

        public boolean isFixK6() {
            return (this.flags & 0x2000) != 0;
        }

        public void setFixK6(boolean fixK6) {
            this.flags = fixK6 ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
        }

        public boolean isRationalModel() {
            return (this.flags & 0x4000) != 0;
        }

        public void setRationalModel(boolean rationalModel) {
            this.flags = rationalModel ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
        }

        public boolean isStereoFixIntrinsic() {
            return (this.flags & 0x100) != 0;
        }

        public void setStereoFixIntrinsic(boolean stereoFixIntrinsic) {
            this.flags = stereoFixIntrinsic ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
        }

        public boolean isStereoSameFocalLength() {
            return (this.flags & 0x200) != 0;
        }

        public void setStereoSameFocalLength(boolean stereoSameFocalLength) {
            this.flags = stereoSameFocalLength ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
        }
    }

    public static class Settings
    extends BaseChildSettings {
        String name = "";
        double responseGamma = 0.0;

        public Settings() {
        }

        public Settings(Settings settings) {
            this.name = settings.name;
            this.responseGamma = settings.responseGamma;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.firePropertyChange("name", this.name, this.name);
        }

        public double getResponseGamma() {
            return this.responseGamma;
        }

        public void setResponseGamma(double responseGamma) {
            this.responseGamma = responseGamma;
        }
    }
}

