/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.nio.IntBuffer;
import org.bytedeco.javacpp.Pointer;

public class IntPointer
extends Pointer {
    public IntPointer(String s) {
        this(s.length() + 1);
        this.putString(s);
    }

    public IntPointer(int ... array) {
        this(array.length);
        this.put(array);
    }

    public IntPointer(IntBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            int[] array = buffer.array();
            this.allocateArray(array.length);
            this.put(array);
            this.position(buffer.position());
            this.limit(buffer.limit());
        }
    }

    public IntPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e);
        }
    }

    public IntPointer() {
    }

    public IntPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public IntPointer position(int position) {
        return (IntPointer)super.position(position);
    }

    public IntPointer limit(int limit) {
        return (IntPointer)super.limit(limit);
    }

    public IntPointer capacity(int capacity) {
        return (IntPointer)super.capacity(capacity);
    }

    public int[] getStringCodePoints() {
        int[] newbuffer;
        int[] buffer = new int[16];
        int i = 0;
        int j = this.position();
        while ((buffer[i] = this.position(j).get()) != 0) {
            ++j;
            if (++i < buffer.length) continue;
            newbuffer = new int[2 * buffer.length];
            System.arraycopy(buffer, 0, newbuffer, 0, buffer.length);
            buffer = newbuffer;
        }
        newbuffer = new int[i];
        System.arraycopy(buffer, 0, newbuffer, 0, i);
        return newbuffer;
    }

    public String getString() {
        int[] codePoints = this.getStringCodePoints();
        return new String(codePoints, 0, codePoints.length);
    }

    public IntPointer putString(String s) {
        int[] codePoints = new int[s.length()];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = s.codePointAt(i);
        }
        return this.put(codePoints).put(codePoints.length, 0);
    }

    public int get() {
        return this.get(0);
    }

    public native int get(int var1);

    public IntPointer put(int j) {
        return this.put(0, j);
    }

    public native IntPointer put(int var1, int var2);

    public IntPointer get(int[] array) {
        return this.get(array, 0, array.length);
    }

    public IntPointer put(int ... array) {
        return this.put(array, 0, array.length);
    }

    public native IntPointer get(int[] var1, int var2, int var3);

    public native IntPointer put(int[] var1, int var2, int var3);

    @Override
    public final IntBuffer asBuffer() {
        return this.asByteBuffer().asIntBuffer();
    }
}

