/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class DoubleRawIndexer
extends DoubleIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected DoublePointer pointer;
    final long base;
    final long size;

    public DoubleRawIndexer(DoublePointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, new long[]{1L});
    }

    public DoubleRawIndexer(DoublePointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 8L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public double get(long i) {
        return RAW.getDouble(this.base + DoubleRawIndexer.checkIndex(i, this.size) * 8L);
    }

    @Override
    public DoubleIndexer get(long i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public double get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public DoubleIndexer get(long i, long j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public double get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public double get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public DoubleIndexer get(long[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, double d) {
        RAW.putDouble(this.base + DoubleRawIndexer.checkIndex(i, this.size) * 8L, d);
        return this;
    }

    @Override
    public DoubleIndexer put(long i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, d[offset + n]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, double d) {
        this.put(i * this.strides[0] + j, d);
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, d[offset + n]);
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, long k, double d) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, d);
        return this;
    }

    @Override
    public DoubleIndexer put(long[] indices, double d) {
        this.put(this.index(indices), d);
        return this;
    }

    @Override
    public DoubleIndexer put(long[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, d[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

