/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avfilter;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.bytedeco.javacpp.postproc;
import org.bytedeco.javacpp.swresample;
import org.bytedeco.javacpp.swscale;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameFilter;

public class FFmpegFrameFilter
extends FrameFilter {
    private static FrameFilter.Exception loadingException = null;
    avfilter.AVFilterContext buffersink_ctx;
    avfilter.AVFilterContext buffersrc_ctx;
    avfilter.AVFilterGraph filter_graph;
    avcodec.AVPacket packet;
    avutil.AVFrame image_frame;
    avutil.AVFrame filt_frame;
    BytePointer[] image_ptr;
    Buffer[] image_buf;
    Frame frame;

    public static void tryLoad() throws FrameFilter.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(postproc.class);
            Loader.load(swresample.class);
            Loader.load(swscale.class);
            Loader.load(avfilter.class);
            avformat.av_register_all();
            avfilter.avfilter_register_all();
        }
        catch (Throwable t) {
            if (t instanceof FrameFilter.Exception) {
                loadingException = (FrameFilter.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameFilter.Exception("Failed to load " + FFmpegFrameRecorder.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameFilter(String filters, int imageWidth, int imageHeight) {
        this.filters = filters;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.pixelFormat = 3;
        this.frameRate = 30.0;
        this.aspectRatio = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws FrameFilter.Exception {
        Class<avfilter> clazz = avfilter.class;
        synchronized (avfilter.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void releaseUnsafe() throws FrameFilter.Exception {
        if (this.filter_graph != null) {
            avfilter.avfilter_graph_free(this.filter_graph);
            this.buffersink_ctx = null;
            this.buffersrc_ctx = null;
            this.filter_graph = null;
        }
        if (this.image_frame != null) {
            avutil.av_frame_free(this.image_frame);
            this.image_frame = null;
        }
        if (this.filt_frame != null) {
            avutil.av_frame_free(this.filt_frame);
            this.filt_frame = null;
        }
        this.frame = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws FrameFilter.Exception {
        Class<avfilter> clazz = avfilter.class;
        synchronized (avfilter.class) {
            this.startUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startUnsafe() throws FrameFilter.Exception {
        this.image_frame = avutil.av_frame_alloc();
        this.filt_frame = avutil.av_frame_alloc();
        this.image_ptr = new BytePointer[]{null};
        this.image_buf = new Buffer[]{null};
        this.frame = new Frame();
        if (this.image_frame == null || this.filt_frame == null) {
            throw new FrameFilter.Exception("Could not allocate frame");
        }
        avfilter.AVFilter buffersrc = avfilter.avfilter_get_by_name("buffer");
        avfilter.AVFilter buffersink = avfilter.avfilter_get_by_name("buffersink");
        avfilter.AVFilterInOut outputs = avfilter.avfilter_inout_alloc();
        avfilter.AVFilterInOut inputs = avfilter.avfilter_inout_alloc();
        avutil.AVRational time_base = avutil.av_inv_q(avutil.av_d2q(this.frameRate, 1001000));
        int[] pix_fmts = new int[]{this.pixelFormat, -1};
        try {
            this.filter_graph = avfilter.avfilter_graph_alloc();
            if (outputs == null || inputs == null || this.filter_graph == null) {
                throw new FrameFilter.Exception("Could not allocate filter graph: Out of memory?");
            }
            avutil.AVRational r = avutil.av_d2q(this.aspectRatio > 0.0 ? this.aspectRatio : 1.0, 255);
            this.buffersrc_ctx = new avfilter.AVFilterContext();
            String args = String.format("video_size=%dx%d:pix_fmt=%d:time_base=%d/%d:pixel_aspect=%d/%d", this.imageWidth, this.imageHeight, this.pixelFormat, time_base.num(), time_base.den(), r.num(), r.den());
            int ret = avfilter.avfilter_graph_create_filter(this.buffersrc_ctx, buffersrc, "in", args, null, this.filter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter(): Cannot create buffer source.");
            }
            this.buffersink_ctx = new avfilter.AVFilterContext();
            ret = avfilter.avfilter_graph_create_filter(this.buffersink_ctx, buffersink, "out", null, null, this.filter_graph);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_create_filter(): Cannot create buffer sink.");
            }
            outputs.name(avutil.av_strdup(new BytePointer("in")));
            outputs.filter_ctx(this.buffersrc_ctx);
            outputs.pad_idx(0);
            outputs.next(null);
            inputs.name(avutil.av_strdup(new BytePointer("out")));
            inputs.filter_ctx(this.buffersink_ctx);
            inputs.pad_idx(0);
            inputs.next(null);
            ret = avfilter.avfilter_graph_parse_ptr(this.filter_graph, this.filters, inputs, outputs, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_parse_ptr()");
            }
            ret = avfilter.avfilter_graph_config(this.filter_graph, null);
            if (ret < 0) {
                throw new FrameFilter.Exception("avfilter_graph_config()");
            }
        }
        finally {
            avfilter.avfilter_inout_free(inputs);
            avfilter.avfilter_inout_free(outputs);
        }
    }

    @Override
    public void stop() throws FrameFilter.Exception {
        this.release();
    }

    @Override
    public void push(Frame frame) throws FrameFilter.Exception {
        this.push(frame, -1);
    }

    public void push(Frame frame, int pixelFormat) throws FrameFilter.Exception {
        if (frame != null && frame.image != null) {
            this.pushImage(frame.imageWidth, frame.imageHeight, frame.imageDepth, frame.imageChannels, frame.imageStride, pixelFormat, frame.image);
        } else if (frame == null || frame.samples == null) {
            avfilter.av_buffersrc_add_frame_flags(this.buffersrc_ctx, null, 0);
        }
    }

    public void pushImage(int width, int height, int depth, int channels, int stride, int pixelFormat, Buffer ... image) throws FrameFilter.Exception {
        BytePointer data;
        int step = stride * Math.abs(depth) / 8;
        BytePointer bytePointer = data = image[0] instanceof ByteBuffer ? new BytePointer((ByteBuffer)image[0].position(0)) : new BytePointer(new Pointer(image[0].position(0)));
        if (pixelFormat == -1) {
            if ((depth == 8 || depth == -8) && channels == 3) {
                pixelFormat = 3;
            } else if ((depth == 8 || depth == -8) && channels == 1) {
                pixelFormat = 8;
            } else if ((depth == 16 || depth == -16) && channels == 1) {
                pixelFormat = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 31 : 32;
            } else if ((depth == 8 || depth == -8) && channels == 4) {
                pixelFormat = 28;
            } else if ((depth == 8 || depth == -8) && channels == 2) {
                pixelFormat = 26;
                step = width;
            } else {
                throw new FrameFilter.Exception("Could not guess pixel format of image: depth=" + depth + ", channels=" + channels);
            }
        }
        avcodec.avpicture_fill(new avcodec.AVPicture(this.image_frame), data, pixelFormat, width, height);
        this.image_frame.linesize(0, step);
        this.image_frame.format(pixelFormat);
        this.image_frame.width(width);
        this.image_frame.height(height);
        if (avfilter.av_buffersrc_add_frame_flags(this.buffersrc_ctx, this.image_frame, 8) < 0) {
            throw new FrameFilter.Exception("av_buffersrc_add_frame_flags(): Error while feeding the filtergraph.");
        }
    }

    @Override
    public Frame pull() throws FrameFilter.Exception {
        avutil.av_frame_unref(this.filt_frame);
        int ret = avfilter.av_buffersink_get_frame(this.buffersink_ctx, this.filt_frame);
        if (ret == -11 || ret == avutil.AVERROR_EOF) {
            return null;
        }
        if (ret < 0) {
            throw new FrameFilter.Exception("av_buffersink_get_frame(): Error occurred: " + avutil.av_make_error_string(new BytePointer(256L), 256L, ret).getString());
        }
        this.frame.imageWidth = this.filt_frame.width();
        this.frame.imageHeight = this.filt_frame.height();
        this.frame.imageDepth = 8;
        if (this.filt_frame.data(1) == null) {
            this.frame.imageStride = this.filt_frame.linesize(0);
            BytePointer ptr = this.filt_frame.data(0);
            if (ptr != null && !ptr.equals(this.image_ptr[0])) {
                this.image_ptr[0] = ptr.capacity(this.frame.imageHeight * this.frame.imageStride);
                this.image_buf[0] = ptr.asBuffer();
            }
            this.frame.image = this.image_buf;
            this.frame.image[0].position(0).limit(this.frame.imageHeight * this.frame.imageStride);
            this.frame.imageChannels = this.frame.imageStride / this.frame.imageWidth;
        } else {
            this.frame.imageStride = this.frame.imageWidth;
            int size = avcodec.avpicture_get_size(this.filt_frame.format(), this.frame.imageWidth, this.frame.imageHeight);
            if (this.image_buf[0] == null || this.image_buf[0].capacity() < size) {
                this.image_buf[0] = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
            }
            this.frame.image = this.image_buf;
            this.frame.image[0].position(0).limit(size);
            this.frame.imageChannels = 2;
            ret = avcodec.avpicture_layout(new avcodec.AVPicture(this.filt_frame), this.filt_frame.format(), this.frame.imageWidth, this.frame.imageHeight, (ByteBuffer)this.frame.image[0].position(0), this.frame.image[0].capacity());
        }
        return this.frame;
    }

    static {
        try {
            FFmpegFrameFilter.tryLoad();
        }
        catch (FrameFilter.Exception exception) {
            // empty catch block
        }
    }
}

