/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.avcodec;

public class FFmpegLockCallback {
    private static boolean initialized = false;
    private static AtomicInteger lockCounter = new AtomicInteger(0);
    private static HashMap<Integer, Lock> lockArray = new HashMap();
    private static avcodec.Cb_PointerPointer_int lockCallback = new avcodec.Cb_PointerPointer_int(){

        public int call(@Cast(value={"void**"}) PointerPointer mutex, @Cast(value={"AVLockOp"}) int op) {
            switch (op) {
                case 0: {
                    int number = lockCounter.incrementAndGet();
                    new IntPointer((Pointer)mutex).put(0L, number);
                    lockArray.put(number, new ReentrantLock());
                    return 0;
                }
                case 1: {
                    int number = new IntPointer((Pointer)mutex).get(0L);
                    Lock l = (Lock)lockArray.get(number);
                    if (l == null) {
                        System.err.println("Lock not found!");
                        return -1;
                    }
                    l.lock();
                    return 0;
                }
                case 2: {
                    int number = new IntPointer((Pointer)mutex).get(0L);
                    Lock l = (Lock)lockArray.get(number);
                    if (l == null) {
                        System.err.println("Lock not found!");
                        return -1;
                    }
                    l.unlock();
                    return 0;
                }
                case 3: {
                    int number = new IntPointer((Pointer)mutex).get(0L);
                    lockArray.remove(number);
                    mutex.put(0L, null);
                    return 0;
                }
            }
            return -1;
        }
    };

    public static synchronized void init() {
        if (!initialized) {
            initialized = true;
            avcodec.av_lockmgr_register((avcodec.Cb_PointerPointer_int)lockCallback);
        }
    }
}

