// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.leptonica;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.leptonica.global.lept.*;


/**
 * \file stringcode.h
 *
 *     Data structure to hold accumulating generated code for storing
 *     and extracting serializable leptonica objects (e.g., pixa, recog).
 *
 *     Also a flag for selecting a string from the L_GenAssoc struct
 *     in stringcode.
 */

@Name("L_StrCode") @Properties(inherit = org.bytedeco.leptonica.presets.lept.class)
public class L_STRCODE extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public L_STRCODE() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public L_STRCODE(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public L_STRCODE(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public L_STRCODE position(long position) {
        return (L_STRCODE)super.position(position);
    }
    @Override public L_STRCODE getPointer(long i) {
        return new L_STRCODE((Pointer)this).offsetAddress(i);
    }

    /** index for function and output file names   */
    public native @Cast("l_int32") int fileno(); public native L_STRCODE fileno(int setter);
    /** index into struct currently being stored   */
    public native @Cast("l_int32") int ifunc(); public native L_STRCODE ifunc(int setter);
    /** store case code for extraction             */
    public native SARRAY function(); public native L_STRCODE function(SARRAY setter);
    /** store base64 encoded data as strings       */
    public native SARRAY data(); public native L_STRCODE data(SARRAY setter);
    /** store line in description table            */
    public native SARRAY descr(); public native L_STRCODE descr(SARRAY setter);
    /** number of data strings                     */
    public native @Cast("l_int32") int n(); public native L_STRCODE n(int setter);
}
