// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.leptonica.global;

import org.bytedeco.leptonica.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class leptonica extends org.bytedeco.leptonica.presets.leptonica {
    static { Loader.load(); }

// Parsed from leptonica/alltypes.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_ALLTYPES_H
// #define  LEPTONICA_ALLTYPES_H

    /* Standard */
// #include <stdio.h>
// #include <stdlib.h>
// #include <stdarg.h>

    /* General and configuration defs */
// #include "endianness.h"
// #include "environ.h"

    /* Generic and non-image-specific containers */
// #include "array.h"
// #include "bbuffer.h"
// #include "hashmap.h"
// #include "heap.h"
// #include "list.h"
// #include "ptra.h"
// #include "queue.h"
// #include "rbtree.h"
// #include "stack.h"

    /* Imaging */
// #include "arrayaccess.h"
// #include "bmf.h"
// #include "ccbord.h"
// #include "colorfill.h"
// #include "dewarp.h"
// #include "gplot.h"
// #include "imageio.h"
// #include "jbclass.h"
// #include "morph.h"
// #include "pix.h"
// #include "recog.h"
// #include "regutils.h"
// #include "stringcode.h"
// #include "sudoku.h"
// #include "watershed.h"


// #endif /* LEPTONICA_ALLTYPES_H */


// Parsed from leptonica/environ.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_ENVIRON_H
// #define  LEPTONICA_ENVIRON_H

/*------------------------------------------------------------------------*
 *  Defines and includes differ for Unix and Windows.  Also for Windows,  *
 *  differentiate between conditionals based on platform and compiler.    *
 *      For platforms:                                                    *
 *          _WIN32       =>     Windows, 32- or 64-bit                    *
 *          _WIN64       =>     Windows, 64-bit only                      *
 *          __CYGWIN__   =>     Cygwin                                    *
 *      For compilers:                                                    *
 *          __GNUC__     =>     gcc                                       *
 *          _MSC_VER     =>     msvc                                      *
 *------------------------------------------------------------------------*/

/* MS VC++ does not provide stdint.h, so define the missing types here */


// #ifndef _MSC_VER
// #include <stdint.h>

// #else
/* Note that _WIN32 is defined for both 32 and 64 bit applications,
   whereas _WIN64 is defined only for the latter */

// #ifdef _WIN64
// #else
// #endif

/* VC++6 doesn't seem to have powf, expf. */
// #if (_MSC_VER < 1400)
// #define powf(x, y) (float)pow((double)(x), (double)(y))
// #define expf(x) (float)exp((double)(x))
// #endif

// #endif /* _MSC_VER */

// #ifndef LEPT_DLL
  /* Windows specifics */
//   #ifdef _WIN32
    /* DLL EXPORTS and IMPORTS */
//     #if defined(LIBLEPT_EXPORTS)
//       #define LEPT_DLL __declspec(dllexport)
//     #elif defined(LIBLEPT_IMPORTS)
//       #define LEPT_DLL __declspec(dllimport)
//     #else
//       #define LEPT_DLL
//     #endif
//   #else  /* non-Windows specifics */
//     #define LEPT_DLL
//   #endif  /* _WIN32 */
// #endif  /* LEPT_DLL */

// #ifndef _WIN32  /* non-Windows specifics */
//   #include <stdint.h>
// #endif  /* _WIN32 */


/*--------------------------------------------------------------------*
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *                          USER CONFIGURABLE                         *
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *               Environment variables with I/O libraries             *
 *               Manual Configuration Only: NOT AUTO_CONF             *
 *--------------------------------------------------------------------*/
/*
 *  Leptonica provides interfaces to link to several external image
 *  I/O libraries, plus zlib.  Setting any of these to 0 here causes
 *  non-functioning stubs to be linked.
 */
// #if !defined(HAVE_CONFIG_H) && !defined(ANDROID_BUILD) && !defined(OS_IOS)

//   #if !defined(HAVE_LIBJPEG)
  public static final int HAVE_LIBJPEG =       1;
//   #endif
//   #if !defined(HAVE_LIBTIFF)
  public static final int HAVE_LIBTIFF =       1;
//   #endif
//   #if !defined(HAVE_LIBPNG)
  public static final int HAVE_LIBPNG =        1;
//   #endif
//   #if !defined(HAVE_LIBZ)
  public static final int HAVE_LIBZ =          1;
//   #endif
//   #if !defined(HAVE_LIBGIF)
  public static final int HAVE_LIBGIF =        0;
//   #endif
//   #if !defined(HAVE_LIBUNGIF)
  public static final int HAVE_LIBUNGIF =      0;
//   #endif
//   #if !defined(HAVE_LIBWEBP)
  public static final int HAVE_LIBWEBP =       0;
//   #endif
//   #if !defined(HAVE_LIBWEBP_ANIM)
  public static final int HAVE_LIBWEBP_ANIM =  0;
//   #endif
//   #if !defined(HAVE_LIBJP2K)
  public static final int HAVE_LIBJP2K =       0;
//   #endif


  /*-----------------------------------------------------------------------*
   * Leptonica supports OpenJPEG 2.0+.  If you have a version of openjpeg  *
   * (HAVE_LIBJP2K == 1) that is >= 2.0, set the path to the openjpeg.h    *
   * header in angle brackets here.                                        *
   *-----------------------------------------------------------------------*/
//   #define  LIBJP2K_HEADER   <openjpeg-2.3/openjpeg.h>

// #endif  /* ! HAVE_CONFIG_H etc. */

/*--------------------------------------------------------------------*
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *                          USER CONFIGURABLE                         *
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*
 *     Environ variables for image I/O without external libraries     *
 *--------------------------------------------------------------------*/
/*
 *  Leptonica supplies I/O support without using external libraries for:
 *     * image read/write for bmp, pnm
 *     * header read for jp2k
 *     * image wrapping write for pdf and ps.
 *  Setting any of these to 0 causes non-functioning stubs to be linked.
 */
public static final int USE_BMPIO =        1;
public static final int USE_PNMIO =        1;
public static final int USE_JP2KHEADER =   1;
public static final int USE_PDFIO =        1;
public static final int USE_PSIO =         1;


/*-------------------------------------------------------------------------*
 * On linux systems, you can do I/O between Pix and memory.  Specifically,
 * you can compress (write compressed data to memory from a Pix) and
 * uncompress (read from compressed data in memory to a Pix).
 * For jpeg, png, jp2k, gif, pnm and bmp, these use the non-posix GNU
 * functions fmemopen() and open_memstream().  These functions are not
 * available on other systems.
 * To use these functions in linux, you must define HAVE_FMEMOPEN to 1.
 * To use them on MacOS, which does not support these functions, set it to 0.
 *-------------------------------------------------------------------------*/
// #if !defined(HAVE_CONFIG_H) && !defined(ANDROID_BUILD) && !defined(OS_IOS) &&
//     !defined(_WIN32)
public static final int HAVE_FMEMOPEN =    1;
// #endif  /* ! HAVE_CONFIG_H etc. */

/*-------------------------------------------------------------------------*
 * fstatat() is defined by POSIX, but some systems do not support it.      *
 * One example is older macOS systems (pre-10.10).                         *
 * Play it safe and set the default value to 0.                            *
 *-------------------------------------------------------------------------*/
// #if !defined(HAVE_CONFIG_H)
public static final int HAVE_FSTATAT =     0;
// #endif /* ! HAVE_CONFIG_H */

/*--------------------------------------------------------------------*
 * It is desirable on Windows to have all temp files written to the same
 * subdirectory of the Windows <Temp> directory, because files under <Temp>
 * persist after reboot, and the regression tests write a lot of files.
 * We write all test files to /tmp/lept or subdirectories of /tmp/lept.
 * Windows temp files are specified as in unix, but have the translation
 *        /tmp/lept/xxx  -->   <Temp>/lept/xxx
 *--------------------------------------------------------------------*/


/*--------------------------------------------------------------------*
 *                          Built-in types                            *
 *--------------------------------------------------------------------*/
/** return type 0 if OK, 1 on error */
/** signed 8-bit value */
/** unsigned 8-bit value */
/** signed 16-bit value */
/** unsigned 16-bit value */
/** signed 32-bit value */
/** unsigned 32-bit value */
/** 32-bit floating point value */
/** 64-bit floating point value */
// #ifdef COMPILER_MSVC
/** signed 64-bit value */
/** unsigned 64-bit value */
// #else
/** signed 64-bit value */
/** unsigned 64-bit value */
// #endif  /* COMPILER_MSVC */


/*-------------------------------------------------------------------------*
 * For security, the library is distributed in a configuration that does   *
 * not permit (1) forking with 'system', which is used for displaying      *
 * images and generating gnuplots, and (2) writing files with specified    *
 * compiled-in file names.  All such writes are with functions such as     *
 * pixWriteDebug() where the "Debug" is appended to the usual name.        *
 * Whether the "Debug" version defaults to the standard version or is a    *
 * no-op depends on the value of this global variable.  The default value  *
 * of LeptDebugOK is 0, and it is set in writefile.c.  This value can be   *
 * over-ridden, for development and debugging, by setLeptDebugOK().        *
 *-------------------------------------------------------------------------*/
public static native @Cast("l_int32") int LeptDebugOK(); public static native void LeptDebugOK(int setter);  /* default is 0 */


/*------------------------------------------------------------------------*
 *                            Standard macros                             *
 *------------------------------------------------------------------------*/
// #ifndef L_MIN
/** Minimum of %x and %y */
// #define L_MIN(x, y)   (((x) < (y)) ? (x) : (y))
// #endif

// #ifndef L_MAX
/** Maximum of %x and %y */
// #define L_MAX(x, y)   (((x) > (y)) ? (x) : (y))
// #endif

// #ifndef L_ABS
/** Absolute value of %x */
// #define L_ABS(x)     (((x) < 0) ? (-1 * (x)) : (x))
// #endif

// #ifndef L_SIGN
/** Sign of %x */
// #define L_SIGN(x)    (((x) < 0) ? -1 : 1)
// #endif

// #ifndef UNDEF
/** Undefined value */
public static final int UNDEF =        -1;
// #endif

// #ifndef NULL
/** NULL value */
public static final int NULL =          0;
// #endif

// #ifndef TRUE
/** True value */
public static final int TRUE =          1;
// #endif

// #ifndef FALSE
/** False value */
public static final int FALSE =         0;
// #endif


/*--------------------------------------------------------------------*
 *            Environment variables for endian dependence             *
 *--------------------------------------------------------------------*/
/*
 *  To control conditional compilation, one of two variables
 *
 *       L_LITTLE_ENDIAN  (e.g., for Intel X86)
 *       L_BIG_ENDIAN     (e.g., for Sun SPARC, Mac Power PC)
 *
 *  is defined when the GCC compiler is invoked.
 *  All code should compile properly for both hardware architectures.
 */


/*------------------------------------------------------------------------*
 *                    Simple search state variables                       *
 *------------------------------------------------------------------------*/
/** Search State */
/** enum  */
public static final int
    L_NOT_FOUND = 0,
    L_FOUND = 1;


/*------------------------------------------------------------------------*
 *                     Path separator conversion                          *
 *------------------------------------------------------------------------*/
/** Path Separators */
/** enum  */
public static final int
    UNIX_PATH_SEPCHAR = 0,
    WIN_PATH_SEPCHAR = 1;
// Targeting ..\L_TIMER.java


// Targeting ..\L_WALLTIMER.java




/*------------------------------------------------------------------------*
 *                      Standard memory allocation                        *
 *                                                                        *
 *  All default heap allocation is through the system malloc and free.    *
 *                                                                        *
 *  Leptonica also provides non-default allocation in two situations:     *
 *                                                                        *
 *  (1) A special allocator/deallocator pair can be provided for the      *
 *      pix image data array.  This might be useful to prevent memory     *
 *      fragmentation when large images are repeatedly allocated and      *
 *      freed.  See the PixMemoryManager in pix1.c for details,           *
 *      where the default is defined.                                     *
 *                                                                        *
 *  (2) Special allocator/deallocators can be provided for ALL heap       *
 *      allocation if required, for example, for embedded systems.        *
 *      For such builds, define LEPTONICA_INTERCEPT_ALLOC, and provide    *
 *      custom leptonica_{malloc, calloc, realloc, free} functions.       *
 *------------------------------------------------------------------------*/
// #ifdef LEPTONICA_INTERCEPT_ALLOC
// #else
//   #define LEPT_MALLOC(blocksize)           malloc(blocksize)
//   #define LEPT_CALLOC(numelem, elemsize)   calloc(numelem, elemsize)
//   #define LEPT_REALLOC(ptr, blocksize)     realloc(ptr, blocksize)
//   #define LEPT_FREE(ptr)                   free(ptr)
// #endif   /* LEPTONICA_INTERCEPT_ALLOC */

/*------------------------------------------------------------------------*
 *         Control printing of error, warning, and info messages          *
 *                                                                        *
 *  Leptonica never sends output to stdout.  By default, all messages     *
 *  go to stderr.  However, we provide a mechanism for runtime            *
 *  redirection of output, using a custom stderr handler defined          *
 *  by the user.  See utils1.c for details and examples.                  *
 *                                                                        *
 *  To omit all messages to stderr, simply define NO_CONSOLE_IO on the    *
 *  command line.  For finer grained control, we have a mechanism         *
 *  based on the message severity level.  The following assumes that      *
 *  NO_CONSOLE_IO is not defined.                                         *
 *                                                                        *
 *  Messages are printed if the message severity is greater than or equal *
 *  to the current severity threshold.  The current severity threshold    *
 *  is the greater of the compile-time severity, which is the minimum     *
 *  severity that can be reported, and the run-time severity, which is    *
 *  the severity threshold at the moment.                                 *
 *                                                                        *
 *  The compile-time threshold determines which messages are compiled     *
 *  into the library for potential printing.  Messages below the          *
 *  compile-time threshold are omitted and can never be printed.  The     *
 *  default compile-time threshold is L_SEVERITY_INFO, but this may be    *
 *  overridden by defining MINIMUM_SEVERITY to the desired enumeration    *
 *  identifier on the compiler command line.  Defining NO_CONSOLE_IO on   *
 *  the command line is the same as setting MINIMUM_SEVERITY to           *
 *  L_SEVERITY_NONE.                                                      *
 *                                                                        *
 *  The run-time threshold determines which messages are printed during   *
 *  library execution.  It defaults to the compile-time threshold but     *
 *  may be changed either statically by defining DEFAULT_SEVERITY to      *
 *  the desired enumeration identifier on the compiler command line, or   *
 *  dynamically by calling setMsgSeverity() to specify a new threshold.   *
 *  The run-time threshold may also be set from the value of the          *
 *  environment variable LEPT_MSG_SEVERITY by calling setMsgSeverity()   *
 *  and specifying L_SEVERITY_EXTERNAL.                                   *
 *                                                                        *
 *  In effect, the compile-time threshold setting says, "Generate code    *
 *  to permit messages of equal or greater severity than this to be       *
 *  printed, if desired," whereas the run-time threshold setting says,    *
 *  "Print messages that have an equal or greater severity than this."    *
 *------------------------------------------------------------------------*/

    /** Control printing of error, warning and info messages */
/** Message Control */
/** enum  */
public static final int
    L_SEVERITY_EXTERNAL = 0,   /* Get the severity from the environment   */
    L_SEVERITY_ALL      = 1,   /* Lowest severity: print all messages     */
    L_SEVERITY_DEBUG    = 2,   /* Print debugging and higher messages     */
    L_SEVERITY_INFO     = 3,   /* Print informational and higher messages */
    L_SEVERITY_WARNING  = 4,   /* Print warning and higher messages       */
    L_SEVERITY_ERROR    = 5,   /* Print error and higher messages         */
    L_SEVERITY_NONE     = 6;    /* Highest severity: print no messages     */

/*  No message less than the compile-time threshold will ever be
 *  reported, regardless of the current run-time threshold.  This allows
 *  selection of the set of messages to include in the library.  For
 *  example, setting the threshold to L_SEVERITY_WARNING eliminates all
 *  informational messages from the library.  With that setting, both
 *  warning and error messages would be printed unless setMsgSeverity()
 *  was called, or DEFAULT_SEVERITY was redefined, to set the run-time
 *  severity to L_SEVERITY_ERROR.  In that case, only error messages
 *  would be printed.
 *
 *  This mechanism makes the library smaller and faster, by eliminating
 *  undesired message reporting and the associated run-time overhead for
 *  message threshold checking, because code for messages whose severity
 *  is lower than MINIMUM_SEVERITY won't be generated.
 *
 *  A production library might typically permit ERROR messages to be
 *  generated, and a development library might permit DEBUG and higher.
 *  The actual messages printed (as opposed to generated) would depend
 *  on the current run-time severity threshold.
 *
 *  This is a complex mechanism and a few examples may help.
 *  (1) No output permitted under any circumstances.
 *      Use:  -DNO_CONSOLE_IO  or  -DMINIMUM_SEVERITY=6
 *  (2) Suppose you want to only allow error messages, and you don't
 *      want to permit info or warning messages at runtime.
 *      Use:  -DMINIMUM_SEVERITY=5
 *  (3) Suppose you want to only allow error messages by default,
 *      but you will permit this to be over-ridden at runtime.
 *      Use:  -DDEFAULT_SEVERITY=5
 *            and to allow info and warning override:
 *                 setMsgSeverity(L_SEVERITY_INFO);
 */

// #ifdef  NO_CONSOLE_IO
//   #undef MINIMUM_SEVERITY
//   #undef DEFAULT_SEVERITY

  /** Compile-time default */
  public static final int MINIMUM_SEVERITY =      L_SEVERITY_NONE;
  /** Run-time default */
  public static final int DEFAULT_SEVERITY =      L_SEVERITY_NONE;

// #else
//   #ifndef MINIMUM_SEVERITY
//   #endif

//   #ifndef DEFAULT_SEVERITY
//   #endif
// #endif


/**  The run-time message severity threshold is defined in utils1.c.  */
public static native @Cast("l_int32") int LeptMsgSeverity(); public static native void LeptMsgSeverity(int setter);

/*
 * <pre>
 *  Usage
 *  =====
 *  Messages are of two types.
 *
 *  (1) The messages
 *      ERROR_INT(a,b,c)       : returns l_int32
 *      ERROR_FLOAT(a,b,c)     : returns l_float32
 *      ERROR_PTR(a,b,c)       : returns void*
 *  are used to return from functions and take a fixed set of parameters:
 *      a : <message string>
 *      b : procName
 *      c : <return value from function>
 *  where procName is the name of the local variable naming the function.
 *
 *  (2) The purely informational L_* messages
 *      L_ERROR(a,...)
 *      L_WARNING(a,...)
 *      L_INFO(a,...)
 *  do not take a return value, but they take at least two parameters:
 *      a  :  <message string> with optional format conversions
 *      v1 : procName    (this must be included as the first vararg)
 *      v2, ... :  optional varargs to match format converters in the message
 *
 *  To return an error from a function that returns void, use:
 *      L_ERROR(<message string>, procName, [...])
 *      return;
 *
 *  Implementation details
 *  ======================
 *  Messages are defined with the IF_SEV macro.  The first parameter is
 *  the message severity, the second is the function to call if the
 *  message is to be printed, and the third is the return value if the
 *  message is to be suppressed.  For example, we might have an
 *  informational message defined as:
 *
 *    IF_SEV(L_SEVERITY_INFO, fprintf(.......), 0)
 *
 *  The macro expands into a conditional.  Because the first comparison
 *  is between two constants, an optimizing compiler will remove either
 *  the comparison (if it's true) or the entire macro expansion (if it
 *  is false).  This means that there is no run-time overhead for
 *  messages whose severity falls below the minimum specified at compile
 *  time, and for others the overhead is one (not two) comparisons.
 *
 *  The L_nnn() macros below do not return a value, but because the
 *  conditional operator requires one for the false condition, we
 *  specify a void expression.
 * </pre>
 */

// #ifdef  NO_CONSOLE_IO

//   #define PROCNAME(name)
//   #define ERROR_INT(a, b, c)            ((l_int32)(c))
//   #define ERROR_FLOAT(a, b, c)          ((l_float32)(c))
//   #define ERROR_PTR(a, b, c)            ((void *)(c))
//   #define L_ERROR(a, ...)
//   #define L_WARNING(a, ...)
//   #define L_INFO(a, ...)

// #else

//   #define PROCNAME(name)              static const char procName[] = name
//   #define IF_SEV(l, t, f)
//       ((l) >= MINIMUM_SEVERITY && (l) >= LeptMsgSeverity ? (t) : (f))

//   #define ERROR_INT(a, b, c)
//       IF_SEV(L_SEVERITY_ERROR, returnErrorInt((a), (b), (c)), (l_int32)(c))
//   #define ERROR_FLOAT(a, b, c)
//       IF_SEV(L_SEVERITY_ERROR, returnErrorFloat((a), (b), (c)), (l_float32)(c))
//   #define ERROR_PTR(a, b, c)
//       IF_SEV(L_SEVERITY_ERROR, returnErrorPtr((a), (b), (c)), (void *)(c))

//   #define L_ERROR(a, ...)
//       IF_SEV(L_SEVERITY_ERROR,
//              (void)lept_stderr("Error in %s: " a, __VA_ARGS__),
//              (void)0)
//   #define L_WARNING(a, ...)
//       IF_SEV(L_SEVERITY_WARNING,
//              (void)lept_stderr("Warning in %s: " a, __VA_ARGS__),
//              (void)0)
//   #define L_INFO(a, ...)
//       IF_SEV(L_SEVERITY_INFO,
//              (void)lept_stderr("Info in %s: " a, __VA_ARGS__),
//              (void)0)

// #if 0  /* Alternative method for controlling L_* message output */
// #endif

// #endif  /* NO_CONSOLE_IO */


/*------------------------------------------------------------------------*
 *              snprintf() renamed in MSVC (pre-VS2015)                   *
 *------------------------------------------------------------------------*/
// #if defined _MSC_VER && _MSC_VER < 1900
// #define snprintf(buf, size, ...)  _snprintf_s(buf, size, _TRUNCATE, __VA_ARGS__)
// #endif


// #endif /* LEPTONICA_ENVIRON_H */


// Parsed from leptonica/array.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_ARRAY_H
// #define  LEPTONICA_ARRAY_H

/**
 * \file array.h
 *
 * <pre>
 *  Contains the following structs:
 *      struct Numa          array of floats
 *      struct Numaa
 *      struct L_Dna         array of doubles
 *      struct L_Dnaa
 *      struct L_Dnahash
 *      struct Sarray        array of C-strings
 *      struct L_Bytea       array of bytes
 *
 *  Contains definitions for:
 *      Numa interpolation flags
 *      Numa border flags
 *      Numa data type conversion to string
 *
 *  Here are the non-image-related arrays in leptonica:
 *  * Numa, L_Dna, L_Ptra, Sarray:
 *    These have most of the typical operations of vectors, such as add,
 *    insert, remove and replace.
 *  * Numaa, L_Dnaa, L_Ptraa:
 *    These are arrays of float, double and generic pointer arrays.
 *  * L_Bytea:
 *    This is an array of bytes, analogous to a C++ string.
 *  * L_Dnahash:
 *    This is a simple hashing for integers, used in the jbig2 classifier.
 * </pre>
 */


/*------------------------------------------------------------------------*
 *                             Array Structs                              *
 *------------------------------------------------------------------------*/

/** Numa version for serialization */
public static final int NUMA_VERSION_NUMBER =     1;
// Targeting ..\NUMA.java


// Targeting ..\NUMAA.java



/** Dna version for serialization */
public static final int DNA_VERSION_NUMBER =     1;
// Targeting ..\L_DNA.java


// Targeting ..\L_DNAA.java


// Targeting ..\L_DNAHASH.java



/** Sarray version for serialization */
public static final int SARRAY_VERSION_NUMBER =     1;
// Targeting ..\SARRAY.java


// Targeting ..\L_BYTEA.java




/*------------------------------------------------------------------------*
 *                              Array flags                               *
 *------------------------------------------------------------------------*/
/** Numa Interpolation */
/** enum  */
public static final int
    /** linear     */
    L_LINEAR_INTERP = 1,
    /** quadratic  */
    L_QUADRATIC_INTERP = 2;

/** Numa Border Adding */
/** enum  */
public static final int
    /** extended with same value                  */
    L_CONTINUED_BORDER = 1,
    /** extended with constant normal derivative  */
    L_SLOPE_BORDER = 2,
    /** mirrored                                  */
    L_MIRRORED_BORDER = 3;

/** Numa Data Conversion */
/** enum  */
public static final int
    /** convert to integer  */
    L_INTEGER_VALUE = 1,
    /** convert to float    */
    L_FLOAT_VALUE = 2;

// #endif  /* LEPTONICA_ARRAY_H */


// Parsed from leptonica/bbuffer.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_BBUFFER_H
// #define  LEPTONICA_BBUFFER_H
// Targeting ..\L_BBUFFER.java




// #endif  /* LEPTONICA_BBUFFER_H */


// Parsed from leptonica/hashmap.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_HASHMAP_H
// #define  LEPTONICA_HASHMAP_H
// Targeting ..\L_HASHMAP.java


// Targeting ..\L_HASHITEM.java




/*------------------------------------------------------------------------*
 *                            Hashmap flags                               *
 *------------------------------------------------------------------------*/
/** Hashmap Lookup */
/** enum  */
public static final int
    /** invalid operation                         */
    L_UNDEFINED = 0,
    /** check if this key/val has been stored     */
    L_HMAP_CHECK = 1,
    /** create and store a hashitem if not found  */
    L_HMAP_CREATE = 2;

// #endif  /* LEPTONICA_HASHMAP_H */


// Parsed from leptonica/heap.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_HEAP_H
// #define  LEPTONICA_HEAP_H
// Targeting ..\L_HEAP.java




// #endif  /* LEPTONICA_HEAP_H */


// Parsed from leptonica/list.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/


// #ifndef  LEPTONICA_LIST_H
// #define  LEPTONICA_LIST_H
// Targeting ..\DLLIST.java




    /**  Simple list traverse macro - forward */
// #define L_BEGIN_LIST_FORWARD(head, element)
//         {
//         DLLIST   *_leptvar_nextelem_;
//         for ((element) = (head); (element); (element) = _leptvar_nextelem_) {
//             _leptvar_nextelem_ = (element)->next;


    /**  Simple list traverse macro - reverse */
// #define L_BEGIN_LIST_REVERSE(tail, element)
//         {
//         DLLIST   *_leptvar_prevelem_;
//         for ((element) = (tail); (element); (element) = _leptvar_prevelem_) {
//             _leptvar_prevelem_ = (element)->prev;


    /**  Simple list traverse macro - end of a list traverse */
// #define L_END_LIST    }}


// #endif  /* LEPTONICA_LIST_H */


// Parsed from leptonica/ptra.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_PTRA_H
// #define  LEPTONICA_PTRA_H

/**
 * \file ptra.h
 *
 * <pre>
 *  Contains the following structs:
 *      struct L_Ptra
 *      struct L_Ptraa
 *
 *  Contains definitions for:
 *      L_Ptra compaction flags for removal
 *      L_Ptra shifting flags for insert
 *      L_Ptraa accessor flags
 * </pre>
 */

    /* Bound on max initial ptra size */
@MemberGetter public static native @Cast("const l_uint32") int MaxInitPtraSize();
// Targeting ..\L_PTRA.java


// Targeting ..\L_PTRAA.java





/*------------------------------------------------------------------------*
 *          Accessor and modifier flags for L_Ptra and L_Ptraa            *
 *------------------------------------------------------------------------*/

/** Ptra Removal */
/** enum  */
public static final int
    /** null the pointer only                */
    L_NO_COMPACTION = 1,
    /** compact the array                    */
    L_COMPACTION = 2;

/** Ptra Insertion */
/** enum  */
public static final int
    /** choose based on number of holes        */
    L_AUTO_DOWNSHIFT = 0,
    /** downshifts min # of ptrs below insert  */
    L_MIN_DOWNSHIFT = 1,
    /** downshifts all ptrs below insert       */
    L_FULL_DOWNSHIFT = 2;

/** Ptraa Accessor */
/** enum  */
public static final int
    /** ptr to L_Ptra; caller can inspect only    */
    L_HANDLE_ONLY = 0,
    /** caller owns; destroy or save in L_Ptraa   */
    L_REMOVE = 1;


// #endif  /* LEPTONICA_PTRA_H */


// Parsed from leptonica/queue.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_QUEUE_H
// #define  LEPTONICA_QUEUE_H
// Targeting ..\L_QUEUE.java




// #endif  /* LEPTONICA_QUEUE_H */


// Parsed from leptonica/rbtree.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

/*
 * Modified from the excellent code here:
 *     http://en.literateprograms.org/Red-black_tree_(C)?oldid=19567
 * which has been placed in the public domain under the Creative Commons
 * CC0 1.0 waiver (http://creativecommons.org/publicdomain/zero/1.0/).
 *
 * When the key is generated from a hash (e.g., string --> uint64),
 * there is always the possibility of having collisions, but to make
 * the collision probability very low requires using a large hash.
 * For that reason, the key types are 64 bit quantities, which will result
 * in a negligible probabililty of collisions for millions of hashed values.
 * Using 8 byte keys instead of 4 byte keys requires a little more
 * storage, but the simplification in being able to ignore collisions
 * with the red-black trees for most applications is worth it.
 */

// #ifndef  LEPTONICA_RBTREE_H
// #define  LEPTONICA_RBTREE_H

    /** The three valid key types for red-black trees, maps and sets. */
/** RBTree Key Type */
/** enum  */
public static final int
    L_INT_TYPE = 1,
    L_UINT_TYPE = 2,
    L_FLOAT_TYPE = 3;
// Targeting ..\RB_TYPE.java


// Targeting ..\L_RBTREE.java


// Targeting ..\L_AMAP.java


// Targeting ..\L_ASET.java


// Targeting ..\L_RBTREE_NODE.java


// Targeting ..\L_AMAP_NODE.java


// Targeting ..\L_ASET_NODE.java

  /* hide tree implementation */


// #endif  /* LEPTONICA_RBTREE_H */


// Parsed from leptonica/stack.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_STACK_H
// #define  LEPTONICA_STACK_H
// Targeting ..\L_STACK.java




// #endif /*  LEPTONICA_STACK_H */



// Parsed from leptonica/arrayaccess.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_ARRAY_ACCESS_H
// #define  LEPTONICA_ARRAY_ACCESS_H

/**
 * \file arrayaccess.h
 *
 * <pre>
 *  1, 2, 4, 8, 16 and 32 bit data access within an array of 32-bit words
 *
 *  This is used primarily to access 1, 2, 4, 8, 16 and 32 bit pixels
 *  in a line of image data, represented as an array of 32-bit words.
 *
 *     pdata:  pointer to first 32-bit word in the array
 *     n:      index of the pixel in the array
 *
 *  Function calls for these accessors are defined in arrayaccess.c.
 *
 *  However, for efficiency we use the inline macros for all accesses.
 *  Even though the 2 and 4 bit set* accessors are more complicated,
 *  they are about 10% faster than the function calls.
 *
 *  The 32 bit access is just a cast and ptr arithmetic.  We include
 *  it so that the input ptr can be void*.
 *
 *  At the end of this file is code for invoking the function calls
 *  instead of inlining.
 *
 *  The macro SET_DATA_BIT_VAL(pdata, n, val) is a bit slower than
 *      if (val == 0)
 *          CLEAR_DATA_BIT(pdata, n);
 *      else
 *          SET_DATA_BIT(pdata, n);
 *
 *  Some compilers complain when the SET macros are surrounded by
 *  parentheses, because parens require an evaluation and it is not
 *  defined for SET macros.  If SET_DATA_QBIT were defined as a
 *  compound macro, in analogy to l_setDataQbit(), it requires
 *  surrounding braces:
 * <pre>{@code
 *     #define  SET_DATA_QBIT(pdata, n, val) \
 *        {l_uint32 *_TEMP_WORD_PTR_; \
 *         _TEMP_WORD_PTR_ = (l_uint32 *)(pdata) + ((n) >> 3); \
 *         *_TEMP_WORD_PTR_ &= ~(0xf0000000 >> (4 * ((n) & 7))); \
 *         *_TEMP_WORD_PTR_ |= (((val) & 15) << (28 - 4 * ((n) & 7)));}
 * }</pre>
 *  but if used in an if/else
 * <pre>{@code
 *      if (x)
 *         SET_DATA_QBIT(...);
 *      else
 *         ...
 * }</pre>
 *  the compiler sees
 * <pre>{@code
 *      if (x)
 *         {......};
 *      else
 *         ...
 * }</pre>
 *  The semicolon comes after the brace and will not compile.
 *  This can be fixed in the call by either omitting the semicolon
 *  or requiring another set of braces around SET_DATA_QBIT(), but
 *  both these options break compatibility with current code, and
 *  require special attention by anyone using the macros.
 *
 *  There are (at least) two ways to fix this in the macro definitions,
 *  suggested by Dave Bryan.
 *  (1) Surround the braces in the macro above with
 *         do {....} while(0)
 *      Then the semicolon just terminates the expression.
 *  (2) Reduce the blocks to a single expression; e.g,
 *         *((l_uint32 *)(pdata) + ((n) >> 3)) = \
 *           *((l_uint32 *)(pdata) + ((n) >> 3)) \
 *           & ~(0xf0000000 >> (4 * ((n) & 7))) \
 *           | (((val) & 15) << (28 - 4 * ((n) & 7)))
 *      This appears to cause redundant computation, but the compiler
 *      should evaluate the common subexpression only once.
 *  All these methods have the same performance, giving about 300M
 *  SET_DATA_QBIT operations per second on a fast 64 bit system.
 *  Using the function calls instead of the macros results in about 250M
 *  SET_DATA_QBIT operations per second, a performance hit of nearly 20%.
 * </pre>
 */

public static final int USE_INLINE_ACCESSORS =    1;

// #if USE_INLINE_ACCESSORS

    /*=============================================================*/
    /*                Faster: use in line accessors                */
    /*=============================================================*/

    /*--------------------------------------------------*
     *                     1 bit access                 *
     *--------------------------------------------------*/
/** 1 bit access - get */
// #define  GET_DATA_BIT(pdata, n)
//     ((*((const l_uint32 *)(pdata) + ((n) >> 5)) >> (31 - ((n) & 31))) & 1)

/** 1 bit access - set */
// #define  SET_DATA_BIT(pdata, n)
//     *((l_uint32 *)(pdata) + ((n) >> 5)) |= (0x80000000 >> ((n) & 31))

/** 1 bit access - clear */
// #define  CLEAR_DATA_BIT(pdata, n)
//     *((l_uint32 *)(pdata) + ((n) >> 5)) &= ~(0x80000000 >> ((n) & 31))

/** 1 bit access - set value (0 or 1) */
// #define  SET_DATA_BIT_VAL(pdata, n, val)
//      *((l_uint32 *)(pdata) + ((n) >> 5)) =
//         ((*((l_uint32 *)(pdata) + ((n) >> 5))
//         & (~(0x80000000 >> ((n) & 31))))
//         | ((l_uint32)(val) << (31 - ((n) & 31))))

    /*--------------------------------------------------*
     *                     2 bit access                 *
     *--------------------------------------------------*/
/** 2 bit access - get */
// #define  GET_DATA_DIBIT(pdata, n)
//     ((*((const l_uint32 *)(pdata) + ((n) >> 4)) >> (2 * (15 - ((n) & 15)))) & 3)

/** 2 bit access - set value (0 ... 3) */
// #define  SET_DATA_DIBIT(pdata, n, val)
//      *((l_uint32 *)(pdata) + ((n) >> 4)) =
//         ((*((l_uint32 *)(pdata) + ((n) >> 4))
//         & (~(0xc0000000 >> (2 * ((n) & 15)))))
//         | ((l_uint32)((val) & 3) << (30 - 2 * ((n) & 15))))

/** 2 bit access - clear */
// #define  CLEAR_DATA_DIBIT(pdata, n)
//     *((l_uint32 *)(pdata) + ((n) >> 4)) &= ~(0xc0000000 >> (2 * ((n) & 15)))


    /*--------------------------------------------------*
     *                     4 bit access                 *
     *--------------------------------------------------*/
/** 4 bit access - get */
// #define  GET_DATA_QBIT(pdata, n)
//      ((*((const l_uint32 *)(pdata) + ((n) >> 3)) >> (4 * (7 - ((n) & 7)))) & 0xf)

/** 4 bit access - set value (0 ... 15) */
// #define  SET_DATA_QBIT(pdata, n, val)
//      *((l_uint32 *)(pdata) + ((n) >> 3)) =
//         ((*((l_uint32 *)(pdata) + ((n) >> 3))
//         & (~(0xf0000000 >> (4 * ((n) & 7)))))
//         | ((l_uint32)((val) & 15) << (28 - 4 * ((n) & 7))))

/** 4 bit access - clear */
// #define  CLEAR_DATA_QBIT(pdata, n)
//     *((l_uint32 *)(pdata) + ((n) >> 3)) &= ~(0xf0000000 >> (4 * ((n) & 7)))


    /*--------------------------------------------------*
     *                     8 bit access                 *
     *--------------------------------------------------*/
// #ifdef  L_BIG_ENDIAN
/** 8 bit access - get */
// #define  GET_DATA_BYTE(pdata, n)
//              (*((const l_uint8 *)(pdata) + (n)))
// #else  /* L_LITTLE_ENDIAN */
/** 8 bit access - get */
// #define  GET_DATA_BYTE(pdata, n)
//              (*(l_uint8 *)((l_uintptr_t)((const l_uint8 *)(pdata) + (n)) ^ 3))
// #endif  /* L_BIG_ENDIAN */

// #ifdef  L_BIG_ENDIAN
/** 8 bit access - set value (0 ... 255) */
// #define  SET_DATA_BYTE(pdata, n, val)
//              *((l_uint8 *)(pdata) + (n)) = (val)
// #else  /* L_LITTLE_ENDIAN */
/** 8 bit access - set value (0 ... 255) */
// #define  SET_DATA_BYTE(pdata, n, val)
//              *(l_uint8 *)((l_uintptr_t)((l_uint8 *)(pdata) + (n)) ^ 3) = (val)
// #endif  /* L_BIG_ENDIAN */


    /*--------------------------------------------------*
     *                    16 bit access                 *
     *--------------------------------------------------*/
// #ifdef  L_BIG_ENDIAN
/** 16 bit access - get */
// #define  GET_DATA_TWO_BYTES(pdata, n)
//              (*((const l_uint16 *)(pdata) + (n)))
// #else  /* L_LITTLE_ENDIAN */
/** 16 bit access - get */
// #define  GET_DATA_TWO_BYTES(pdata, n)
//              (*(l_uint16 *)((l_uintptr_t)((const l_uint16 *)(pdata) + (n)) ^ 2))
// #endif  /* L_BIG_ENDIAN */

// #ifdef  L_BIG_ENDIAN
/** 16 bit access - set value (0 ... 65535) */
// #define  SET_DATA_TWO_BYTES(pdata, n, val)
//              *((l_uint16 *)(pdata) + (n)) = (val)
// #else  /* L_LITTLE_ENDIAN */
/** 16 bit access - set value (0 ... 65535) */
// #define  SET_DATA_TWO_BYTES(pdata, n, val)
//              *(l_uint16 *)((l_uintptr_t)((l_uint16 *)(pdata) + (n)) ^ 2) = (val)
// #endif  /* L_BIG_ENDIAN */


    /*--------------------------------------------------*
     *                    32 bit access                 *
     *--------------------------------------------------*/
/** 32 bit access - get */
// #define  GET_DATA_FOUR_BYTES(pdata, n)
//              (*((const l_uint32 *)(pdata) + (n)))

/** 32 bit access - set (0 ... 4294967295) */
// #define  SET_DATA_FOUR_BYTES(pdata, n, val)
//              *((l_uint32 *)(pdata) + (n)) = (val)


// #else

// #endif  /* USE_INLINE_ACCESSORS */


// #endif /* LEPTONICA_ARRAY_ACCESS_H */


// Parsed from leptonica/bmf.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_BMF_H
// #define  LEPTONICA_BMF_H

/**
 * \file bmf.h
 *
 *     Simple data structure to hold bitmap fonts and related data
 */

    /** Constants for deciding when text block is divided into paragraphs */
/** Split Text */
/** enum  */
public static final int
    /** tab or space at beginning of line   */
    SPLIT_ON_LEADING_WHITE = 1,
    /** newline with optional white space   */
    SPLIT_ON_BLANK_LINE    = 2,
    /** leading white space or newline      */
    SPLIT_ON_BOTH          = 3;
// Targeting ..\L_BMF.java



// #endif  /* LEPTONICA_BMF_H */


// Parsed from leptonica/ccbord.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_CCBORD_H
// #define  LEPTONICA_CCBORD_H

/**
 * \file ccbord.h
 *
 * <pre>
 *           CCBord:   represents a single connected component
 *           CCBorda:  an array of CCBord
 * </pre>
 */

    /** Use in ccbaStepChainsToPixCoords() */
/** CCB Coords */
/** enum  */
public static final int
      CCB_LOCAL_COORDS = 1,
      CCB_GLOBAL_COORDS = 2;

    /** Use in ccbaGenerateSPGlobalLocs() */
/** CCB Points */
/** enum  */
public static final int
      CCB_SAVE_ALL_PTS = 1,
      CCB_SAVE_TURNING_PTS = 2;
// Targeting ..\CCBORD.java


// Targeting ..\CCBORDA.java




// #endif  /* LEPTONICA_CCBORD_H */



// Parsed from leptonica/colorfill.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_COLORFILL_H
// #define  LEPTONICA_COLORFILL_H
// Targeting ..\L_COLORFILL.java




// #endif  /* LEPTONICA_COLORFILL_H */


// Parsed from leptonica/dewarp.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_DEWARP_H
// #define  LEPTONICA_DEWARP_H

/**
 * \file dewarp.h
 *
 * <pre>
 *     Data structure to hold arrays and results for generating
 *     horizontal and vertical disparity arrays based on textlines.
 *     Each disparity array is two-dimensional.  The vertical disparity
 *     array gives a vertical displacement, relative to the lowest point
 *     in the textlines.  The horizontal disparty array gives a horizontal
 *     displacement, relative to the minimum values (for even pages)
 *     or maximum values (for odd pages) of the left and right ends of
 *     full textlines.  Horizontal alignment always involves translations
 *     away from the book gutter.
 *
 *     We have intentionally separated the process of building models
 *     from the rendering process that uses the models.  For any page,
 *     the building operation either creates an actual model (that is,
 *     a model with at least the vertical disparity being computed, and
 *     for which the 'success' flag is set) or fails to create a model.
 *     However, at rendering time, a page can have one of two different
 *     types of models.
 *     (1) A valid model is an actual model that meets the rendering
 *         constraints, which are limits on model curvature parameters.
 *         See dewarpaTestForValidModel() for details.
 *         Valid models are identified by dewarpaInsertRefModels(),
 *         which sets the 'vvalid' and 'hvalid' fields.  Only valid
 *         models are used for rendering.
 *     (2) A reference model is used by a page that doesn't have
 *         a valid model, but has a nearby valid model of the same
 *         parity (even/odd page) that it can use.  The range in pages
 *         to search for a valid model is given by the 'maxdist' field.
 *
 *     At the rendering stage, vertical and horizontal disparities are
 *     treated differently.  It is somewhat more robust to generate
 *     vertical disparity models (VDM) than horizontal disparity
 *     models (HDM). A valid VDM is required for any correction to
 *     be made; if a valid VDM is not available, just use the input
 *     image.  Otherwise, assuming it is available, the use of the
 *     HDM is controlled by two fields: 'useboth' and 'check_columns'.
 *       (a) With useboth == 0, we use only the VDM.
 *       (b) With useboth == 1, we require using the VDM and, if a valid
 *           horizontal disparity model (HDM) is available, we also use it.
 *       (c) With check_columns == 1, check for multiple columns and if
 *           true, only use the VDM, even if a valid HDM is available.
 *           Note that 'check_columns' takes precedence over 'useboth'
 *           when there is more than 1 column of text.  By default,
 *           check_columns == 0.
 *
 *     The 'maxdist' parameter is input when the dewarpa is created.
 *     The other rendering parameters have default values given in dewarp1.c.
 *     All parameters used by rendering can be set (or reset) using accessors.
 *
 *     After dewarping, use of the VDM will cause all points on each
 *     altered curve to have a y-value equal to the minimum.  Use of
 *     the HDA will cause the left and right edges of the textlines
 *     to be vertically aligned if they had been typeset flush-left
 *     and flush-right, respectively.
 *
 *     The sampled disparity arrays are expanded to full resolution,
 *     using linear interpolation, and this is further expanded
 *     by slope continuation to the right and below if the image
 *     is larger than the full resolution disparity arrays.  Then
 *     the disparity correction can be applied to the input image.
 *     If the input pix are 2x reduced, the expansion from sampled
 *     to full res uses the product of (sampling) * (redfactor).
 *
 *     The most accurate results are produced at full resolution, and
 *     this is generally recommended.
 * </pre>
 */

    /** Dewarp version for serialization
     * <pre>
     * Note on versioning of the serialization of this data structure:
     * The dewarping utility and the stored data can be expected to change.
     * In most situations, the serialized version is ephemeral -- it is
     * not needed after being used.  No functions will be provided to
     * convert between different versions.
     * </pre>
     */
public static final int DEWARP_VERSION_NUMBER =      4;
// Targeting ..\L_DEWARPA.java


// Targeting ..\L_DEWARP.java



// #endif  /* LEPTONICA_DEWARP_H */


// Parsed from leptonica/gplot.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_GPLOT_H
// #define  LEPTONICA_GPLOT_H

/**
 * \file gplot.h
 *
 * <pre>
 *   Data structures and parameters for generating gnuplot files
 *
 *   We used to support X11 output, but recent versions of gnuplot do not
 *   support the X11 terminal.  To get display to your screen, use
 *   GPLOT_PNG output; e.g.,
 *       gplotSimple1(na, GPLOT_PNG, "/tmp/someroot", ...);
 *       l_fileDisplay("/tmp/someroot.png", ...);
 * </pre>
 */

public static final int GPLOT_VERSION_NUMBER =    1;

public static final int NUM_GPLOT_STYLES =  5;
/** enum GPLOT_STYLE */
public static final int
    GPLOT_LINES       = 0,
    GPLOT_POINTS      = 1,
    GPLOT_IMPULSES    = 2,
    GPLOT_LINESPOINTS = 3,
    GPLOT_DOTS        = 4;

public static final int NUM_GPLOT_OUTPUTS =  6;
/** enum GPLOT_OUTPUT */
public static final int
    GPLOT_NONE  = 0,
    GPLOT_PNG   = 1,
    GPLOT_PS    = 2,
    GPLOT_EPS   = 3,
    GPLOT_LATEX = 4,
    GPLOT_PNM   = 5;

/** enum GPLOT_SCALING */
public static final int
    /** default */
    GPLOT_LINEAR_SCALE  = 0,
    GPLOT_LOG_SCALE_X   = 1,
    GPLOT_LOG_SCALE_Y   = 2,
    GPLOT_LOG_SCALE_X_Y = 3;



// Targeting ..\GPLOT.java




// #endif /* LEPTONICA_GPLOT_H */


// Parsed from leptonica/imageio.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

/**
 * \file imageio.h
 *
 * <pre>
 *  General features of image I/O in leptonica
 *
 *  At present, there are 9 file formats for images that can be read
 *  and written:
 *      png (requires libpng, libz)
 *      jpeg (requires libjpeg)
 *      tiff (requires libtiff, libz)
 *      gif (requires libgif)
 *      webp (requires libwebp)
 *      jp2 (requires libopenjp2)
 *      bmp (no library required)
 *      pnm (no library required)
 *      spix (no library required)
 *  Additionally, there are two file formats for writing (only) images:
 *      PostScript (requires libpng, libz, libjpeg, libtiff)
 *      pdf (requires libpng, libz, libjpeg, libtiff)
 *
 *  For all 9 read/write formats, leptonica provides interconversion
 *  between pix (with raster data) and formatted image data:
 *      Conversion from pix (typically compression):
 *          pixWrite():        pix --> file
 *          pixWriteStream():  pix --> filestream (aka FILE*)
 *          pixWriteMem():     pix --> memory buffer
 *      Conversion to pix (typically decompression):
 *          pixRead():         file --> pix
 *          pixReadStream():   filestream --> pix
 *          pixReadMem():      memory buffer --> pix
 *
 *  Conversions for which the image data is not compressed are:
 *     * uncompressed tiff   (IFF_TIFF)
 *     * bmp
 *     * pnm
 *     * spix (fast serialization that copies the pix raster data)
 *
 *  The image header (metadata) information can be read from either
 *  the compressed file or a memory buffer, for all 9 formats.
 * </pre>
 */

// #ifndef  LEPTONICA_IMAGEIO_H
// #define  LEPTONICA_IMAGEIO_H

/* --------------------------------------------------------------- *
 *                    Image file format types                      *
 * --------------------------------------------------------------- */
/*
 *  The IFF_DEFAULT flag is used to write the file out in the
 *  same (input) file format that the pix was read from.  If the pix
 *  was not read from file, the input format field will be
 *  IFF_UNKNOWN and the output file format will be chosen to
 *  be compressed and lossless; namely, IFF_TIFF_G4 for d = 1
 *  and IFF_PNG for everything else.
 *
 *  In the future, new format types that have defined extensions
 *  will be added before IFF_DEFAULT, and will be kept in sync with
 *  the file format extensions in writefile.c.  The positions of
 *  file formats before IFF_DEFAULT will remain invariant.
 */

/** Image Formats */
/** enum  */
public static final int
    IFF_UNKNOWN        = 0,
    IFF_BMP            = 1,
    IFF_JFIF_JPEG      = 2,
    IFF_PNG            = 3,
    IFF_TIFF           = 4,
    IFF_TIFF_PACKBITS  = 5,
    IFF_TIFF_RLE       = 6,
    IFF_TIFF_G3        = 7,
    IFF_TIFF_G4        = 8,
    IFF_TIFF_LZW       = 9,
    IFF_TIFF_ZIP       = 10,
    IFF_PNM            = 11,
    IFF_PS             = 12,
    IFF_GIF            = 13,
    IFF_JP2            = 14,
    IFF_WEBP           = 15,
    IFF_LPDF           = 16,
    IFF_TIFF_JPEG      = 17,
    IFF_DEFAULT        = 18,
    IFF_SPIX           = 19;

/* Convenient macro for checking requested tiff output */
// #define  L_FORMAT_IS_TIFF(f)  ((f) == IFF_TIFF || (f) == IFF_TIFF_PACKBITS ||
//                                (f) == IFF_TIFF_RLE || (f) == IFF_TIFF_G3 ||
//                                (f) == IFF_TIFF_G4 || (f) == IFF_TIFF_LZW ||
//                                (f) == IFF_TIFF_ZIP || (f) == IFF_TIFF_JPEG)


/* --------------------------------------------------------------- *
 *                         Format header ids                       *
 * --------------------------------------------------------------- */
/** Header Ids */
/** enum  */
public static final int
    /** BM - for bitmaps    */
    BMP_ID             = 0x4d42,
    /** MM - for 'motorola' */
    TIFF_BIGEND_ID     = 0x4d4d,
    /** II - for 'intel'    */
    TIFF_LITTLEEND_ID  = 0x4949;


/* --------------------------------------------------------------- *
 *                Hinting bit flags in jpeg reader                 *
 * --------------------------------------------------------------- */
/** Jpeg Hints */
/* The default behavior is now to fail on data corruption. */
/** enum  */
public static final int
    /** only want luminance data; no chroma */
    L_JPEG_READ_LUMINANCE = 1,
    /** return possibly damaged pix */
    L_JPEG_CONTINUE_WITH_BAD_DATA = 2;


/* --------------------------------------------------------------- *
 *                            Jp2k codecs                          *
 * --------------------------------------------------------------- */
/** Jp2k Codecs */
/** enum  */
public static final int
    /** codestream                 */
    L_J2K_CODEC = 1,
    /** file format with 'ihdr'    */
    L_JP2_CODEC = 2;


/* --------------------------------------------------------------- *
 *                    Pdf formatted encoding types                 *
 * --------------------------------------------------------------- */
/** Pdf Encoding */
/** enum  */
public static final int
    /** use default encoding based on image        */
    L_DEFAULT_ENCODE  = 0,
    /** use dct encoding: 8 and 32 bpp, no cmap    */
    L_JPEG_ENCODE     = 1,
    /** use ccitt g4 fax encoding: 1 bpp           */
    L_G4_ENCODE       = 2,
    /** use flate encoding: any depth, cmap ok     */
    L_FLATE_ENCODE    = 3,
    /** use jp2k encoding: 8 and 32 bpp, no cmap   */
    L_JP2K_ENCODE     = 4;
// Targeting ..\L_COMP_DATA.java




/* ------------------------------------------------------------------------- *
 *                           Pdf multi image flags                           *
 * ------------------------------------------------------------------------- */
/** Pdf MultiImage */
/** enum  */
public static final int
    /** first image to be used                      */
    L_FIRST_IMAGE   = 1,
    /** intermediate image; not first or last       */
    L_NEXT_IMAGE    = 2,
    /** last image to be used                       */
    L_LAST_IMAGE    = 3;
// Targeting ..\L_PDF_DATA.java



// #endif  /* LEPTONICA_IMAGEIO_H */


// Parsed from leptonica/jbclass.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_JBCLASS_H
// #define  LEPTONICA_JBCLASS_H
// Targeting ..\JBCLASSER.java


// Targeting ..\JBDATA.java




/** JB Classifier */
/** enum  */
public static final int
    JB_RANKHAUS = 0,
    JB_CORRELATION = 1;

    /** For jbGetComponents(): type of component to extract from images */
/** JB Component */
/** enum  */
public static final int
    JB_CONN_COMPS = 0,
    JB_CHARACTERS = 1,
    JB_WORDS = 2;

    /** These parameters are used for naming the two files
     * in which the jbig2-like compressed data is stored.  */
public static final String JB_TEMPLATE_EXT =      ".templates.png";
public static final String JB_DATA_EXT =          ".data";


// #endif  /* LEPTONICA_JBCLASS_H */


// Parsed from leptonica/morph.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_MORPH_H
// #define  LEPTONICA_MORPH_H

/**
 * \file morph.h
 *
 * <pre>
 *  Contains the following structs:
 *      struct Sel
 *      struct Sela
 *      struct Kernel
 *
 *  Contains definitions for:
 *      morphological b.c. flags
 *      structuring element types
 *      runlength flags for granulometry
 *      direction flags for grayscale morphology
 *      morphological operation flags
 *      standard border size
 *      grayscale intensity scaling flags
 *      morphological tophat flags
 *      arithmetic and logical operator flags
 *      grayscale morphology selection flags
 *      distance function b.c. flags
 *      image comparison flags
 * </pre>
 */

/*-------------------------------------------------------------------------*
 *                             Sel and Sel array                           *
 *-------------------------------------------------------------------------*/
public static final int SEL_VERSION_NUMBER =    1;
// Targeting ..\SEL.java


// Targeting ..\SELA.java




/*-------------------------------------------------------------------------*
 *                                 Kernel                                  *
 *-------------------------------------------------------------------------*/
public static final int KERNEL_VERSION_NUMBER =    2;
// Targeting ..\L_KERNEL.java




/*-------------------------------------------------------------------------*
 *                 Morphological boundary condition flags                  *
 *                                                                         *
 *  Two types of boundary condition for erosion.                           *
 *  The global variable MORPH_BC takes on one of these two values.         *
 *  See notes in morph.c for usage.                                        *
 *-------------------------------------------------------------------------*/
/** Morph Boundary */
/** enum  */
public static final int
    SYMMETRIC_MORPH_BC = 0,
    ASYMMETRIC_MORPH_BC = 1;

/*-------------------------------------------------------------------------*
 *                        Structuring element vals                         *
 *-------------------------------------------------------------------------*/
/** SEL Vals */
/** enum  */
public static final int
    SEL_DONT_CARE  = 0,
    SEL_HIT        = 1,
    SEL_MISS       = 2;

/*-------------------------------------------------------------------------*
 *                  Runlength flags for granulometry                       *
 *-------------------------------------------------------------------------*/
/** Runlength Polarity */
/** enum  */
public static final int
    L_RUN_OFF = 0,
    L_RUN_ON  = 1;

/*-------------------------------------------------------------------------*
 *         Direction flags for grayscale morphology, granulometry,         *
 *                 composable Sels, convolution, etc.                      *
 *-------------------------------------------------------------------------*/
/** Direction Flags */
/** enum  */
public static final int
    L_HORIZ            = 1,
    L_VERT             = 2,
    L_BOTH_DIRECTIONS  = 3;

/*-------------------------------------------------------------------------*
 *                   Morphological operation flags                         *
 *-------------------------------------------------------------------------*/
/** Morph Operator */
/** enum  */
public static final int
    L_MORPH_DILATE    = 1,
    L_MORPH_ERODE     = 2,
    L_MORPH_OPEN      = 3,
    L_MORPH_CLOSE     = 4,
    L_MORPH_HMT       = 5;

/*-------------------------------------------------------------------------*
 *                    Grayscale intensity scaling flags                    *
 *-------------------------------------------------------------------------*/
/** Pixel Value Scaling */
/** enum  */
public static final int
    L_LINEAR_SCALE  = 1,
    L_LOG_SCALE     = 2;

/*-------------------------------------------------------------------------*
 *                      Morphological tophat flags                         *
 *-------------------------------------------------------------------------*/
/** Morph Tophat */
/** enum  */
public static final int
    L_TOPHAT_WHITE = 0,
    L_TOPHAT_BLACK = 1;

/*-------------------------------------------------------------------------*
 *                Arithmetic and logical operator flags                    *
 *                 (use on grayscale images and Numas)                     *
 *-------------------------------------------------------------------------*/
/** ArithLogical Ops */
/** enum  */
public static final int
    L_ARITH_ADD       = 1,
    L_ARITH_SUBTRACT  = 2,
    L_ARITH_MULTIPLY  = 3,   /* on numas only */
    L_ARITH_DIVIDE    = 4,   /* on numas only */
    L_UNION           = 5,   /* on numas only */
    L_INTERSECTION    = 6,   /* on numas only */
    L_SUBTRACTION     = 7,   /* on numas only */
    L_EXCLUSIVE_OR    = 8;    /* on numas only */

/*-------------------------------------------------------------------------*
 *                        Min/max selection flags                          *
 *-------------------------------------------------------------------------*/
/** MinMax Selection */
/** enum  */
public static final int
    L_CHOOSE_MIN = 1,         /* useful in a downscaling "erosion"       */
    L_CHOOSE_MAX = 2,         /* useful in a downscaling "dilation"      */
    L_CHOOSE_MAXDIFF = 3,     /* useful in a downscaling contrast        */
    L_CHOOSE_MIN_BOOST = 4,   /* use a modification of the min value     */
    L_CHOOSE_MAX_BOOST = 5;    /* use a modification of the max value     */

/*-------------------------------------------------------------------------*
 *            Exterior value b.c. for distance function flags              *
 *-------------------------------------------------------------------------*/
/** Exterior Value */
/** enum  */
public static final int
    L_BOUNDARY_BG = 1,  /* assume bg outside image */
    L_BOUNDARY_FG = 2;   /* assume fg outside image */

/*-------------------------------------------------------------------------*
 *                         Image comparison flags                          *
 *-------------------------------------------------------------------------*/
/** Image Comparison */
/** enum  */
public static final int
    L_COMPARE_XOR = 1,
    L_COMPARE_SUBTRACT = 2,
    L_COMPARE_ABS_DIFF = 3;

/*-------------------------------------------------------------------------*
 *    Standard size of border added around images for special processing   *
 *-------------------------------------------------------------------------*/
/** pixels, not bits */
@MemberGetter public static native @Cast("const l_int32") int ADDED_BORDER();
public static final int ADDED_BORDER = ADDED_BORDER();


// #endif  /* LEPTONICA_MORPH_H */


// Parsed from leptonica/pix.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_PIX_H
// #define  LEPTONICA_PIX_H
// Targeting ..\PIX.java


// Targeting ..\PIXCMAP.java


// Targeting ..\RGBA_QUAD.java




/*-------------------------------------------------------------------------*
 *                           Colors for 32 RGBA                            *
 *-------------------------------------------------------------------------*/
/* <pre>
 *  Notes:
 *      (1) These are the byte indices for colors in 32 bpp images.
 *          They are used through the GET/SET_DATA_BYTE accessors.
 *          The 4th byte, typically known as the "alpha channel" and used
 *          for blending, is used to a small extent in leptonica.
 *      (2) Do not change these values!  If you redefine them, functions
 *          that have the shifts hardcoded for efficiency and conciseness
 *          (instead of using the constants below) will break.  These
 *          functions are labelled with "***"  next to their names at
 *          the top of the files in which they are defined.
 *      (3) The shifts to extract the red, green, blue and alpha components
 *          from a 32 bit pixel are defined here.
 * </pre>
 */

/** RGBA Color */
/** enum  */
public static final int
    /** red color index in RGBA_QUAD    */
    COLOR_RED = 0,
    /** green color index in RGBA_QUAD  */
    COLOR_GREEN = 1,
    /** blue color index in RGBA_QUAD   */
    COLOR_BLUE = 2,
    /** alpha value index in RGBA_QUAD  */
    L_ALPHA_CHANNEL = 3;

@MemberGetter public static native @Cast("const l_int32") int L_RED_SHIFT();
public static final int L_RED_SHIFT = L_RED_SHIFT();           /* 24 */
@MemberGetter public static native @Cast("const l_int32") int L_GREEN_SHIFT();
public static final int L_GREEN_SHIFT = L_GREEN_SHIFT();         /* 16 */
@MemberGetter public static native @Cast("const l_int32") int L_BLUE_SHIFT();
public static final int L_BLUE_SHIFT = L_BLUE_SHIFT();          /*  8 */
@MemberGetter public static native @Cast("const l_int32") int L_ALPHA_SHIFT();
public static final int L_ALPHA_SHIFT = L_ALPHA_SHIFT();     /*  0 */


/*-------------------------------------------------------------------------*
 *                       Colors for drawing boxes                          *
 *-------------------------------------------------------------------------*/
/** Box Color */
/** enum  */
public static final int
    /** draw in red                   */
    L_DRAW_RED = 0,
    /** draw in green                 */
    L_DRAW_GREEN = 1,
    /** draw in blue                  */
    L_DRAW_BLUE = 2,
    /** draw specified color          */
    L_DRAW_SPECIFIED = 3,
    /** draw as sequence of r,g,b     */
    L_DRAW_RGB = 4,
    /** draw randomly chosen colors   */
    L_DRAW_RANDOM = 5;


/*-------------------------------------------------------------------------*
 *                       Perceptual color weights                          *
 *-------------------------------------------------------------------------*/
/* <pre>
 *  Notes:
 *      (1) These perceptual weighting factors are ad-hoc, but they do
 *          add up to 1.  Unlike, for example, the weighting factors for
 *          converting RGB to luminance, or more specifically to Y in the
 *          YUV colorspace.  Those numbers come from the
 *          International Telecommunications Union, via ITU-R.
 * </pre>
 */
/** Percept. weight for red   */
@MemberGetter public static native @Cast("const l_float32") float L_RED_WEIGHT();
public static final float L_RED_WEIGHT = L_RED_WEIGHT();
/** Percept. weight for green */
@MemberGetter public static native @Cast("const l_float32") float L_GREEN_WEIGHT();
public static final float L_GREEN_WEIGHT = L_GREEN_WEIGHT();
/** Percept. weight for blue  */
@MemberGetter public static native @Cast("const l_float32") float L_BLUE_WEIGHT();
public static final float L_BLUE_WEIGHT = L_BLUE_WEIGHT();


/*-------------------------------------------------------------------------*
 *                        Flags for colormap conversion                    *
 *-------------------------------------------------------------------------*/
/** Cmap Conversion */
/** enum  */
public static final int
    /** remove colormap for conv to 1 bpp  */
    REMOVE_CMAP_TO_BINARY = 0,
    /** remove colormap for conv to 8 bpp  */
    REMOVE_CMAP_TO_GRAYSCALE = 1,
    /** remove colormap for conv to 32 bpp */
    REMOVE_CMAP_TO_FULL_COLOR = 2,
    /** remove colormap and alpha          */
    REMOVE_CMAP_WITH_ALPHA = 3,
    /** remove depending on src format     */
    REMOVE_CMAP_BASED_ON_SRC = 4;


/*------------------------------------------------------------------------*
 *!
 * <pre>
 * The following operation bit flags have been modified from
 * Sun's pixrect.h.
 *
 * The 'op' in 'rasterop' is represented by an integer
 * composed with Boolean functions using the set of five integers
 * given below.  The integers, and the op codes resulting from
 * boolean expressions on them, need only be in the range from 0 to 15.
 * The function is applied on a per-pixel basis.
 *
 * Examples: the op code representing ORing the src and dest
 * is computed using the bit OR, as PIX_SRC | PIX_DST;  the op
 * code representing XORing src and dest is found from
 * PIX_SRC ^ PIX_DST;  the op code representing ANDing src and dest
 * is found from PIX_SRC & PIX_DST.  Note that
 * PIX_NOT(PIX_CLR) = PIX_SET, and v.v., as they must be.
 *
 * We use the following set of definitions:
 *
 *      #define   PIX_SRC      0xc
 *      #define   PIX_DST      0xa
 *      #define   PIX_NOT(op)  (op) ^ 0xf
 *      #define   PIX_CLR      0x0
 *      #define   PIX_SET      0xf
 *
 * These definitions differ from Sun's, in that Sun left-shifted
 * each value by 1 pixel, and used the least significant bit as a
 * flag for the "pseudo-operation" of clipping.  We don't need
 * this bit, because it is both efficient and safe ALWAYS to clip
 * the rectangles to the src and dest images, which is what we do.
 * See the notes in rop.h on the general choice of these bit flags.
 *
 * [If for some reason you need compatibility with Sun's xview package,
 * you can adopt the original Sun definitions to avoid redefinition conflicts:
 *
 *      #define   PIX_SRC      (0xc << 1)
 *      #define   PIX_DST      (0xa << 1)
 *      #define   PIX_NOT(op)  ((op) ^ 0x1e)
 *      #define   PIX_CLR      (0x0 << 1)
 *      #define   PIX_SET      (0xf << 1)
 * ]
 *
 * We have, for reference, the following 16 unique op flags:
 *
 *      PIX_CLR                           0000             0x0
 *      PIX_SET                           1111             0xf
 *      PIX_SRC                           1100             0xc
 *      PIX_DST                           1010             0xa
 *      PIX_NOT(PIX_SRC)                  0011             0x3
 *      PIX_NOT(PIX_DST)                  0101             0x5
 *      PIX_SRC | PIX_DST                 1110             0xe
 *      PIX_SRC & PIX_DST                 1000             0x8
 *      PIX_SRC ^ PIX_DST                 0110             0x6
 *      PIX_NOT(PIX_SRC) | PIX_DST        1011             0xb
 *      PIX_NOT(PIX_SRC) & PIX_DST        0010             0x2
 *      PIX_SRC | PIX_NOT(PIX_DST)        1101             0xd
 *      PIX_SRC & PIX_NOT(PIX_DST)        0100             0x4
 *      PIX_NOT(PIX_SRC | PIX_DST)        0001             0x1
 *      PIX_NOT(PIX_SRC & PIX_DST)        0111             0x7
 *      PIX_NOT(PIX_SRC ^ PIX_DST)        1001             0x9
 *
 * </pre>
 *-------------------------------------------------------------------------*/

/** use source pixels      */
public static final int PIX_SRC =      (0xc);
/** use destination pixels */
public static final int PIX_DST =      (0xa);
/** invert operation %op   */
public static native int PIX_NOT(int op);
/** clear pixels           */
public static final int PIX_CLR =      (0x0);
/** set pixels             */
public static final int PIX_SET =      (0xf);

/** paint = src | dst      */
public static final int PIX_PAINT =    (PIX_SRC | PIX_DST);
/** mask = src & dst       */
public static final int PIX_MASK =     (PIX_SRC & PIX_DST);
/** subtract =           */
/**    src & !dst        */
public static final int PIX_SUBTRACT = (PIX_DST & PIX_NOT(PIX_SRC));
/** xor = src ^ dst        */
public static final int PIX_XOR =      (PIX_SRC ^ PIX_DST);


/*-------------------------------------------------------------------------*
 * <pre>
 *   Important Notes:
 *
 *       (1) The image data is stored in a single contiguous
 *           array of l_uint32, into which the pixels are packed.
 *           By "packed" we mean that there are no unused bits
 *           between pixels, except for end-of-line padding to
 *           satisfy item (2) below.
 *
 *       (2) Every image raster line begins on a 32-bit word
 *           boundary within this array.
 *
 *       (3) Pix image data is stored in 32-bit units, with the
 *           pixels ordered from left to right in the image being
 *           stored in order from the MSB to LSB within the word,
 *           for both big-endian and little-endian machines.
 *           This is the natural ordering for big-endian machines,
 *           as successive bytes are stored and fetched progressively
 *           to the right.  However, for little-endians, when storing
 *           we re-order the bytes from this byte stream order, and
 *           reshuffle again for byte access on 32-bit entities.
 *           So if the bytes come in sequence from left to right, we
 *           store them on little-endians in byte order:
 *                3 2 1 0 7 6 5 4 ...
 *           This MSB to LSB ordering allows left and right shift
 *           operations on 32 bit words to move the pixels properly.
 *
 *       (4) We use 32 bit pixels for both RGB and RGBA color images.
 *           The A (alpha) byte is ignored in most leptonica functions
 *           operating on color images.  Within each 4 byte pixel, the
 *           color samples are ordered from MSB to LSB, as follows:
 *
 *                |  MSB  |  2nd MSB  |  3rd MSB  |  LSB  |
 *                   red      green       blue      alpha
 *                    0         1           2         3   (big-endian)
 *                    3         2           1         0   (little-endian)
 *
 *           Because we use MSB to LSB ordering within the 32-bit word,
 *           the individual 8-bit samples can be accessed with
 *           GET_DATA_BYTE and SET_DATA_BYTE macros, using the
 *           (implicitly big-ending) ordering
 *                 red:    byte 0  (MSB)
 *                 green:  byte 1  (2nd MSB)
 *                 blue:   byte 2  (3rd MSB)
 *                 alpha:  byte 3  (LSB)
 *
 *           The specific color assignment is made in this file,
 *           through the definitions of COLOR_RED, etc.  Then the R, G
 *           B and A sample values can be retrieved using
 *                 redval = GET_DATA_BYTE(&pixel, COLOR_RED);
 *                 greenval = GET_DATA_BYTE(&pixel, COLOR_GREEN);
 *                 blueval = GET_DATA_BYTE(&pixel, COLOR_BLUE);
 *                 alphaval = GET_DATA_BYTE(&pixel, L_ALPHA_CHANNEL);
 *           and they can be set with
 *                 SET_DATA_BYTE(&pixel, COLOR_RED, redval);
 *                 SET_DATA_BYTE(&pixel, COLOR_GREEN, greenval);
 *                 SET_DATA_BYTE(&pixel, COLOR_BLUE, blueval);
 *                 SET_DATA_BYTE(&pixel, L_ALPHA_CHANNEL, alphaval);
 *
 *           More efficiently, these components can be extracted directly
 *           by shifting and masking, explicitly using the values in
 *           L_RED_SHIFT, etc.:
 *                 (pixel32 >> L_RED_SHIFT) & 0xff;         (red)
 *                 (pixel32 >> L_GREEN_SHIFT) & 0xff;       (green)
 *                 (pixel32 >> L_BLUE_SHIFT) & 0xff;        (blue)
 *                 (pixel32 >> L_ALPHA_SHIFT) & 0xff;       (alpha)
 *           The functions extractRGBValues() and extractRGBAValues() are
 *           provided to do this.  Likewise, the pixels can be set
 *           directly by shifting, using composeRGBPixel() and
 *           composeRGBAPixel().
 *
 *           All these operations work properly on both big- and little-endians.
 *
 *       (5) A reference count is held within each pix, giving the
 *           number of ptrs to the pix.  When a pixClone() call
 *           is made, the ref count is increased by 1, and
 *           when a pixDestroy() call is made, the reference count
 *           of the pix is decremented.  The pix is only destroyed
 *           when the reference count goes to zero.
 *
 *       (6) The version numbers (below) are used in the serialization
 *           of these data structures.  They are placed in the files,
 *           and rarely (if ever) change.
 *
 *       (7) The serialization dependencies are as follows:
 *               pixaa  :  pixa  :  boxa
 *               boxaa  :  boxa
 *           So, for example, pixaa and boxaa can be changed without
 *           forcing a change in pixa or boxa.  However, if pixa is
 *           changed, it forces a change in pixaa, and if boxa is
 *           changed, if forces a change in the other three.
 *           We define four version numbers:
 *               PIXAA_VERSION_NUMBER
 *               PIXA_VERSION_NUMBER
 *               BOXAA_VERSION_NUMBER
 *               BOXA_VERSION_NUMBER
 * </pre>
 *-------------------------------------------------------------------------*/



/*-------------------------------------------------------------------------*
 *                              Array of pix                               *
 *-------------------------------------------------------------------------*/
    /*  Serialization for primary data structures */
/** Version for Pixaa serialization */
public static final int PIXAA_VERSION_NUMBER =      2;
/** Version for Pixa serialization  */
public static final int PIXA_VERSION_NUMBER =       2;
/** Version for Boxa serialization  */
public static final int BOXA_VERSION_NUMBER =       2;
/** Version for Boxaa serialization */
public static final int BOXAA_VERSION_NUMBER =      3;
// Targeting ..\PIXA.java


// Targeting ..\PIXAA.java


// Targeting ..\BOX.java


// Targeting ..\BOXA.java


// Targeting ..\BOXAA.java




/*-------------------------------------------------------------------------*
 *                               Array of points                           *
 *-------------------------------------------------------------------------*/
/** Version for Pta serialization     */
public static final int PTA_VERSION_NUMBER =      1;
// Targeting ..\PTA.java


// Targeting ..\PTAA.java


// Targeting ..\PIXACC.java


// Targeting ..\PIXTILING.java




/*-------------------------------------------------------------------------*
 *                       FPix: pix with float array                        *
 *-------------------------------------------------------------------------*/
/** Version for FPix serialization    */
public static final int FPIX_VERSION_NUMBER =      2;
// Targeting ..\FPIX.java


// Targeting ..\FPIXA.java




/*-------------------------------------------------------------------------*
 *                       DPix: pix with double array                       *
 *-------------------------------------------------------------------------*/
/** Version for DPix serialization    */
public static final int DPIX_VERSION_NUMBER =      2;
// Targeting ..\DPIX.java


// Targeting ..\PIXC.java




/*-------------------------------------------------------------------------*
 *                     PixaComp: array of compressed pix                   *
 *-------------------------------------------------------------------------*/
/** Version for PixaComp serialization */
public static final int PIXACOMP_VERSION_NUMBER = 2;
// Targeting ..\PIXAC.java




/*-------------------------------------------------------------------------*
 *                         Access and storage flags                        *
 *-------------------------------------------------------------------------*/
/*
 * <pre>
 *  For Pix, Box, Pta and Numa, there are 3 standard methods for handling
 *  the retrieval or insertion of a struct:
 *     (1) direct insertion (Don't do this if there is another handle
 *                           somewhere to this same struct!)
 *     (2) copy (Always safe, sets up a refcount of 1 on the new object.
 *               Can be undesirable if very large, such as an image or
 *               an array of images.)
 *     (3) clone (Makes another handle to the same struct, and bumps the
 *                refcount up by 1.  OK to use except in two situations:
 *                (a) You change data through one of the handles but don't
 *                    want those changes to be seen by the other handle.
 *                (b) The application is multi-threaded.  Because the clone
 *                    operation is not atomic (e.g., locked with a mutex),
 *                    it is possible to end up with an incorrect ref count,
 *                    causing either a memory leak or a crash.
 *
 *  For Pixa and Boxa, which are structs that hold an array of clonable
 *  structs, there is an additional method:
 *     (4) copy-clone (Makes a new higher-level struct with a refcount
 *                     of 1, but clones all the structs in the array.)
 *
 *  Unlike the other structs, when retrieving a string from an Sarray,
 *  you are allowed to get a handle without a copy or clone (i.e., the
 *  string is not owned by the handle).  You must not either free the string
 *  or insert it in some other struct that would own it.  Specifically,
 *  for an Sarray, the copyflag for retrieval is either:
 *         L_COPY or L_NOCOPY
 *  and for insertion, the copyflag is either:
 *         L_COPY or one of {L_INSERT , L_NOCOPY} (the latter are equivalent
 *                                                 for insertion))
 *  Typical patterns are:
 *  (1) Reference a string in an Sarray with L_NOCOPY and insert a copy
 *      of it in another Sarray with L_COPY.
 *  (2) Copy a string from an Sarray with L_COPY and insert it in
 *      another Sarray with L_INSERT (or L_NOCOPY).
 *  In both cases, a copy is made and both Sarrays own their instance
 *  of that string.
 * </pre>
 */
/** Object Access */
/** enum  */
public static final int
    /** do not copy the object; do not delete the ptr  */
    L_NOCOPY = 0,
    /** stuff it in; do not copy or clone        */
    L_INSERT = L_NOCOPY,
    /** make/use a copy of the object                  */
    L_COPY = 1,
    /** make/use clone (ref count) of the object       */
    L_CLONE = 2,
    /** make a new array object (e.g., pixa) and fill  */
/** the array with clones (e.g., pix)              */
    L_COPY_CLONE = 3;

/*----------------------------------------------------------------------------*
 *                              Sort flags                                    *
 *----------------------------------------------------------------------------*/
/** Sort Mode */
/** enum  */
public static final int
    /** use shell sort                        */
    L_SHELL_SORT = 1,
    /** use bin sort                          */
    L_BIN_SORT = 2;

/** Sort Order */
/** enum  */
public static final int
    /** sort in increasing order              */
    L_SORT_INCREASING = 1,
    /** sort in decreasing order              */
    L_SORT_DECREASING = 2;

/** Sort Type */
/** enum  */
public static final int
    /** sort box or c.c. by left edge location  */
    L_SORT_BY_X = 1,
    /** sort box or c.c. by top edge location   */
    L_SORT_BY_Y = 2,
    /** sort box or c.c. by right edge location */
    L_SORT_BY_RIGHT = 3,
    /** sort box or c.c. by bot edge location   */
    L_SORT_BY_BOT = 4,
    /** sort box or c.c. by width               */
    L_SORT_BY_WIDTH = 5,
    /** sort box or c.c. by height              */
    L_SORT_BY_HEIGHT = 6,
    /** sort box or c.c. by min dimension       */
    L_SORT_BY_MIN_DIMENSION = 7,
    /** sort box or c.c. by max dimension       */
    L_SORT_BY_MAX_DIMENSION = 8,
    /** sort box or c.c. by perimeter           */
    L_SORT_BY_PERIMETER = 9,
    /** sort box or c.c. by area                */
    L_SORT_BY_AREA = 10,
    /** sort box or c.c. by width/height ratio  */
    L_SORT_BY_ASPECT_RATIO = 11;

/*---------------------------------------------------------------------------*
 *                             Blend flags                                   *
 *---------------------------------------------------------------------------*/
/** Blend Types */
/** enum  */
public static final int
    /** add some of src inverse to itself     */
    L_BLEND_WITH_INVERSE = 1,
    /** shift src colors towards white        */
    L_BLEND_TO_WHITE = 2,
    /** shift src colors towards black        */
    L_BLEND_TO_BLACK = 3,
    /** blend src directly with blender       */
    L_BLEND_GRAY = 4,
    /** add amount of src inverse to itself,  */
/** based on blender pix value            */
    L_BLEND_GRAY_WITH_INVERSE = 5;

/** Paint Selection */
/** enum  */
public static final int
    /** colorize non-black pixels             */
    L_PAINT_LIGHT = 1,
    /** colorize non-white pixels             */
    L_PAINT_DARK = 2;

/*-------------------------------------------------------------------------*
 *                        Graphics pixel setting                           *
 *-------------------------------------------------------------------------*/
/** Pixel Setting */
/** enum  */
public static final int
    /** set all bits in each pixel to 1       */
    L_SET_PIXELS = 1,
    /** set all bits in each pixel to 0       */
    L_CLEAR_PIXELS = 2,
    /** flip all bits in each pixel           */
    L_FLIP_PIXELS = 3;

/*-------------------------------------------------------------------------*
 *                     Size and location filter flags                      *
 *-------------------------------------------------------------------------*/
/** Size Comparison */
/** enum  */
public static final int
    /** save if value is less than threshold  */
    L_SELECT_IF_LT = 1,
    /** save if value is more than threshold  */
    L_SELECT_IF_GT = 2,
    /** save if value is <= to the threshold  */
    L_SELECT_IF_LTE = 3,
    /** save if value is >= to the threshold  */
    L_SELECT_IF_GTE = 4;

/** Size Selection */
/** enum  */
public static final int
    /** select by width; 1 bpp            */
    L_SELECT_BY_WIDTH = 1,
    /** select by height; 1 bpp           */
    L_SELECT_BY_HEIGHT = 2,
    /** select by max of width and        */
/** height; 1 bpp                     */
    L_SELECT_BY_MAX_DIMENSION = 3,
    /** select by foreground area; 1 bpp  */
    L_SELECT_BY_AREA = 4,
    /** select by perimeter; 1 bpp        */
    L_SELECT_BY_PERIMETER = 5;

/** Location Filter */
/** enum  */
public static final int
    /** width must satisfy constraint         */
    L_SELECT_WIDTH = 1,
    /** height must satisfy constraint        */
    L_SELECT_HEIGHT = 2,
    /** x value must satisfy constraint       */
    L_SELECT_XVAL = 3,
    /** y value must satisfy constraint       */
    L_SELECT_YVAL = 4,
    /** either width or height (or xval       */
/** or yval) can satisfy constraint       */
    L_SELECT_IF_EITHER = 5,
    /** both width and height (or xval        */
/** and yval must satisfy constraint      */
    L_SELECT_IF_BOTH = 6;

/** Boxa Check */
/** enum  */
public static final int
    /** check and possibly modify width       */
    L_CHECK_WIDTH = 1,
    /** check and possibly modify height      */
    L_CHECK_HEIGHT = 2,
    /** check and possibly modify both        */
    L_CHECK_BOTH = 3;

/*-------------------------------------------------------------------------*
 *                    Color component selection flags                      *
 *-------------------------------------------------------------------------*/
/** Color Selection */
/** enum  */
public static final int
    /** use red component                     */
    L_SELECT_RED = 1,
    /** use green component                   */
    L_SELECT_GREEN = 2,
    /** use blue component                    */
    L_SELECT_BLUE = 3,
    /** use min color component               */
    L_SELECT_MIN = 4,
    /** use max color component               */
    L_SELECT_MAX = 5,
    /** use average of color components       */
    L_SELECT_AVERAGE = 6,
    /** use hue value (in HSV color space)    */
    L_SELECT_HUE = 7,
    /** use saturation value (in HSV space)   */
    L_SELECT_SATURATION = 8,
    /** use weighted average of color comps   */
    L_SELECT_WEIGHTED = 9;

/*-------------------------------------------------------------------------*
 *                          Color content flags                            *
 *-------------------------------------------------------------------------*/
/** Color Content */
/** enum  */
public static final int
    /** intermediate of diff component values */
    L_INTERMED_DIFF = 1,
    /** diff average closest comps to third   */
    L_AVE_MAX_DIFF_2 = 2,
    /** maximum diff of component values      */
    L_MAX_DIFF = 3;

/*-------------------------------------------------------------------------*
 *                         16-bit conversion flags                         *
 *-------------------------------------------------------------------------*/
/** 16-bit Conversion */
/** enum  */
public static final int
    /** use LSB                               */
    L_LS_BYTE = 1,
    /** use MSB                               */
    L_MS_BYTE = 2,
    /** use LSB if max(val) < 256; else MSB   */
    L_AUTO_BYTE = 3,
    /** use max(val, 255)                     */
    L_CLIP_TO_FF = 4,
    /** use two LSB                           */
    L_LS_TWO_BYTES = 5,
    /** use two MSB                           */
    L_MS_TWO_BYTES = 6,
    /** use max(val, 65535)                   */
    L_CLIP_TO_FFFF = 7;

/*-------------------------------------------------------------------------*
 *                        Rotate and shear flags                           *
 *-------------------------------------------------------------------------*/
/** Rotation Type */
/** enum  */
public static final int
    /** use area map rotation, if possible     */
    L_ROTATE_AREA_MAP = 1,
    /** use shear rotation                     */
    L_ROTATE_SHEAR = 2,
    /** use sampling                           */
    L_ROTATE_SAMPLING = 3;

/** Background Color */
/** enum  */
public static final int
    /** bring in white pixels from the outside */
    L_BRING_IN_WHITE = 1,
    /** bring in black pixels from the outside */
    L_BRING_IN_BLACK = 2;

/** Shear Point */
/** enum  */
public static final int
    /** shear image about UL corner            */
    L_SHEAR_ABOUT_CORNER = 1,
    /** shear image about center               */
    L_SHEAR_ABOUT_CENTER = 2;

/*-------------------------------------------------------------------------*
 *                     Affine transform order flags                        *
 *-------------------------------------------------------------------------*/
/** Affine Transform Order */
/** enum  */
public static final int
    /** translate, scale, rotate               */
    L_TR_SC_RO = 1,
    /** scale, rotate, translate               */
    L_SC_RO_TR = 2,
    /** rotate, translate, scale               */
    L_RO_TR_SC = 3,
    /** translate, rotate, scale               */
    L_TR_RO_SC = 4,
    /** rotate, scale, translate               */
    L_RO_SC_TR = 5,
    /** scale, translate, rotate               */
    L_SC_TR_RO = 6;

/*-------------------------------------------------------------------------*
 *                       Grayscale filling flags                           *
 *-------------------------------------------------------------------------*/
/** Grayscale Fill */
/** enum  */
public static final int
    /** fill white pixels (e.g, in fg map)      */
    L_FILL_WHITE = 1,
    /** fill black pixels (e.g., in bg map)     */
    L_FILL_BLACK = 2;

/*-------------------------------------------------------------------------*
 *                   Flags for setting to white or black                   *
 *-------------------------------------------------------------------------*/
/** BlackWhite Set */
/** enum  */
public static final int
    /** set pixels to white                      */
    L_SET_WHITE = 1,
    /** set pixels to black                      */
    L_SET_BLACK = 2;

/*-------------------------------------------------------------------------*
 *                  Flags for getting white or black value                 *
 *-------------------------------------------------------------------------*/
/** BlackWhite Get */
/** enum  */
public static final int
    /** get white pixel value                    */
    L_GET_WHITE_VAL = 1,
    /** get black pixel value                    */
    L_GET_BLACK_VAL = 2;

/*-------------------------------------------------------------------------*
 *                  Flags for 8 bit and 16 bit pixel sums                  *
 *-------------------------------------------------------------------------*/
/** BlackWhite Sum */
/** enum  */
public static final int
    /** white pixels are 0xff or 0xffff; black are 0  */
    L_WHITE_IS_MAX = 1,
    /** black pixels are 0xff or 0xffff; white are 0  */
    L_BLACK_IS_MAX = 2;

/*-------------------------------------------------------------------------*
 *                           Dither parameters                             *
 *         If within this grayscale distance from black or white,          *
 *         do not propagate excess or deficit to neighboring pixels.       *
 *-------------------------------------------------------------------------*/
/** Dither Distance */
/** enum  */
public static final int
    /** dist to black with no prop; 1 bpp      */
    DEFAULT_CLIP_LOWER_1 = 10,
    /** dist to black with no prop; 1 bpp      */
    DEFAULT_CLIP_UPPER_1 = 10,
    /** dist to black with no prop; 2 bpp      */
    DEFAULT_CLIP_LOWER_2 = 5,
    /** dist to black with no prop; 2 bpp      */
    DEFAULT_CLIP_UPPER_2 = 5;

/*-------------------------------------------------------------------------*
 *                          Distance type flags                            *
 *-------------------------------------------------------------------------*/
/** Distance Type */
/** enum  */
public static final int
    /** L1 distance (e.g., in color space)     */
    L_MANHATTAN_DISTANCE = 1,
    /** L2 distance                            */
    L_EUCLIDEAN_DISTANCE = 2;

/*-------------------------------------------------------------------------*
 *                         Distance Value flags                            *
 *-------------------------------------------------------------------------*/
/** Distance Value */
/** enum  */
public static final int
    /** values < 0                                   */
    L_NEGATIVE = 1,
    /** values >= 0                                  */
    L_NON_NEGATIVE = 2,
    /** values > 0                                   */
    L_POSITIVE = 3,
    /** values <= 0                                  */
    L_NON_POSITIVE = 4,
    /** values = 0                                   */
    L_ZERO = 5,
    /** all values                                   */
    L_ALL = 6;

/*-------------------------------------------------------------------------*
 *                         Statistical measures                            *
 *-------------------------------------------------------------------------*/
/** Stats Type */
/** enum  */
public static final int
    /** average of abs values                  */
    L_MEAN_ABSVAL = 1,
    /** median value of set                    */
    L_MEDIAN_VAL = 2,
    /** mode value of set                      */
    L_MODE_VAL = 3,
    /** mode count of set                      */
    L_MODE_COUNT = 4,
    /** rms of values                          */
    L_ROOT_MEAN_SQUARE = 5,
    /** standard deviation from mean           */
    L_STANDARD_DEVIATION = 6,
    /** variance of values                     */
    L_VARIANCE = 7;

/*-------------------------------------------------------------------------*
 *                       Set index selection flags                         *
 *-------------------------------------------------------------------------*/
/** Index Selection */
/** enum  */
public static final int
    /** select 'n' consecutive                 */
    L_CHOOSE_CONSECUTIVE = 1,
    /** select at intervals of 'n'             */
    L_CHOOSE_SKIP_BY = 2;

/*-------------------------------------------------------------------------*
 *                         Text orientation flags                          *
 *-------------------------------------------------------------------------*/
/** Text Orientation */
/** enum  */
public static final int
    /** low confidence on text orientation     */
    L_TEXT_ORIENT_UNKNOWN = 0,
    /** portrait, text rightside-up            */
    L_TEXT_ORIENT_UP = 1,
    /** landscape, text up to left             */
    L_TEXT_ORIENT_LEFT = 2,
    /** portrait, text upside-down             */
    L_TEXT_ORIENT_DOWN = 3,
    /** landscape, text up to right            */
    L_TEXT_ORIENT_RIGHT = 4;

/*-------------------------------------------------------------------------*
 *                         Edge orientation flags                          *
 *-------------------------------------------------------------------------*/
/** Edge Orientation */
/** enum  */
public static final int
    /** filters for horizontal edges            */
    L_HORIZONTAL_EDGES = 0,
    /** filters for vertical edges              */
    L_VERTICAL_EDGES = 1,
    /** filters for all edges                   */
    L_ALL_EDGES = 2;

/*-------------------------------------------------------------------------*
 *                         Line orientation flags                          *
 *-------------------------------------------------------------------------*/
/** Line Orientation */
/** enum  */
public static final int
    /** horizontal line                          */
    L_HORIZONTAL_LINE = 0,
    /** 45 degree line with positive slope       */
    L_POS_SLOPE_LINE = 1,
    /** vertical line                            */
    L_VERTICAL_LINE = 2,
    /** 45 degree line with negative slope       */
    L_NEG_SLOPE_LINE = 3,
    /** neither horizontal nor vertical */
    L_OBLIQUE_LINE = 4;

/*-------------------------------------------------------------------------*
 *                         Image orientation flags                         *
 *-------------------------------------------------------------------------*/
/** Image Orientation */
/** enum  */
public static final int
    /** typical: page is viewed with height > width  */
    L_PORTRAIT_MODE = 0,
    /** page is viewed at 90 deg to portrait mode    */
    L_LANDSCAPE_MODE = 1;

/*-------------------------------------------------------------------------*
 *                           Scan direction flags                          *
 *-------------------------------------------------------------------------*/
/** Scan Direction */
/** enum  */
public static final int
    /** scan from left                           */
    L_FROM_LEFT = 0,
    /** scan from right                          */
    L_FROM_RIGHT = 1,
    /** scan from top                            */
    L_FROM_TOP = 2,
    /** scan from bottom                         */
    L_FROM_BOT = 3,
    /** scan in negative direction               */
    L_SCAN_NEGATIVE = 4,
    /** scan in positive direction               */
    L_SCAN_POSITIVE = 5,
    /** scan in both directions                  */
    L_SCAN_BOTH = 6,
    /** horizontal scan (direction unimportant)  */
    L_SCAN_HORIZONTAL = 7,
    /** vertical scan (direction unimportant)    */
    L_SCAN_VERTICAL = 8;

/*-------------------------------------------------------------------------*
 *                Box size adjustment and location flags                   *
 *-------------------------------------------------------------------------*/
/** Box Adjustment */
/** enum  */
public static final int
    /** do not adjust                        */
    L_ADJUST_SKIP = 0,
    /** adjust left edge                     */
    L_ADJUST_LEFT = 1,
    /** adjust right edge                    */
    L_ADJUST_RIGHT = 2,
    /** adjust both left and right edges     */
    L_ADJUST_LEFT_AND_RIGHT = 3,
    /** adjust top edge                      */
    L_ADJUST_TOP = 4,
    /** adjust bottom edge                   */
    L_ADJUST_BOT = 5,
    /** adjust both top and bottom edges     */
    L_ADJUST_TOP_AND_BOT = 6,
    /** choose the min median value          */
    L_ADJUST_CHOOSE_MIN = 7,
    /** choose the max median value          */
    L_ADJUST_CHOOSE_MAX = 8,
    /** set left side to a given value       */
    L_SET_LEFT = 9,
    /** set right side to a given value      */
    L_SET_RIGHT = 10,
    /** set top side to a given value        */
    L_SET_TOP = 11,
    /** set bottom side to a given value     */
    L_SET_BOT = 12,
    /** get left side location               */
    L_GET_LEFT = 13,
    /** get right side location              */
    L_GET_RIGHT = 14,
    /** get top side location                */
    L_GET_TOP = 15,
    /** get bottom side location             */
    L_GET_BOT = 16;

/*-------------------------------------------------------------------------*
 *          Flags for modifying box boundaries using a second box          *
 *-------------------------------------------------------------------------*/
/** Box Boundary Mod */
/** enum  */
public static final int
    /** use boundaries giving min size       */
    L_USE_MINSIZE = 1,
    /** use boundaries giving max size       */
    L_USE_MAXSIZE = 2,
    /** modify boundary if big location diff */
    L_SUB_ON_LOC_DIFF = 3,
    /** modify boundary if big size diff     */
    L_SUB_ON_SIZE_DIFF = 4,
    /** modify boundary with capped min      */
    L_USE_CAPPED_MIN = 5,
    /** modify boundary with capped max      */
    L_USE_CAPPED_MAX = 6;

/*-------------------------------------------------------------------------*
 *              Handling overlapping bounding boxes in boxa                *
 *-------------------------------------------------------------------------*/
/** Box Overlap Mod */
/** enum  */
public static final int
    /** resize to bounding region; remove smaller  */
    L_COMBINE = 1,
    /** only remove smaller                        */
    L_REMOVE_SMALL = 2;

/*-------------------------------------------------------------------------*
 *        Selecting or making a box from two (intersecting) boxes          *
 *-------------------------------------------------------------------------*/
/** Box Combine or Select */
/** enum  */
public static final int
    /** use union of two boxes             */
    L_GEOMETRIC_UNION = 1,
    /** use intersection of two boxes      */
    L_GEOMETRIC_INTERSECTION = 2,
    /** use box with largest area          */
    L_LARGEST_AREA = 3,
    /** use box with smallest area         */
    L_SMALLEST_AREA = 4;

/*-------------------------------------------------------------------------*
 *                    Flags for replacing invalid boxes                    *
 *-------------------------------------------------------------------------*/
/** Box Replacement */
/** enum  */
public static final int
    /** consider all boxes in the sequence   */
    L_USE_ALL_BOXES = 1,
    /** consider boxes with the same parity  */
    L_USE_SAME_PARITY_BOXES = 2;

/*-------------------------------------------------------------------------*
 *                    Flags for box corners and center                     *
 *-------------------------------------------------------------------------*/
/** Box Corners and Center */
/** enum  */
public static final int
    /** UL corner                               */
    L_UPPER_LEFT = 1,
    /** UR corner                               */
    L_UPPER_RIGHT = 2,
    /** LL corner                               */
    L_LOWER_LEFT = 3,
    /** LR corner                               */
    L_LOWER_RIGHT = 4,
    /** center                                  */
    L_BOX_CENTER = 5;

/*-------------------------------------------------------------------------*
 *                            Horizontal warp                              *
 *-------------------------------------------------------------------------*/
/** Horiz Warp Stretch */
/** enum  */
public static final int
    /** increasing stretch or contraction to left  */
    L_WARP_TO_LEFT = 1,
    /** increasing stretch or contraction to right */
    L_WARP_TO_RIGHT = 2;

/** Horiz Warp Mode */
/** enum  */
public static final int
    /** stretch or contraction grows linearly      */
    L_LINEAR_WARP = 1,
    /** stretch or contraction grows quadratically */
    L_QUADRATIC_WARP = 2;

/*-------------------------------------------------------------------------*
 *                      Pixel selection for resampling                     *
 *-------------------------------------------------------------------------*/
/** Pixel Selection */
/** enum  */
public static final int
    /** linear interpolation from src pixels       */
    L_INTERPOLATED = 1,
    /** nearest src pixel sampling only            */
    L_SAMPLED = 2;

/*-------------------------------------------------------------------------*
 *                             Thinning flags                              *
 *-------------------------------------------------------------------------*/
/** Thinning Polarity */
/** enum  */
public static final int
    /** thin foreground of 1 bpp image         */
    L_THIN_FG = 1,
    /** thin background of 1 bpp image         */
    L_THIN_BG = 2;

/*-------------------------------------------------------------------------*
 *                            Runlength flags                              *
 *-------------------------------------------------------------------------*/
/** Runlength Direction */
/** enum  */
public static final int
    /** determine runlengths of horizontal runs  */
    L_HORIZONTAL_RUNS = 0,
    /** determine runlengths of vertical runs    */
    L_VERTICAL_RUNS = 1;

/*-------------------------------------------------------------------------*
 *                          Edge filter flags                              *
 *-------------------------------------------------------------------------*/
/** Edge Filter */
/** enum  */
public static final int
    /** Sobel edge filter                        */
    L_SOBEL_EDGE = 1,
    /** Two-sided edge filter                    */
    L_TWO_SIDED_EDGE = 2;

/*-------------------------------------------------------------------------*
 *             Subpixel color component ordering in LCD display            *
 *-------------------------------------------------------------------------*/
/** Subpixel Color Order */
/** enum  */
public static final int
    /** sensor order left-to-right RGB        */
    L_SUBPIXEL_ORDER_RGB = 1,
    /** sensor order left-to-right BGR        */
    L_SUBPIXEL_ORDER_BGR = 2,
    /** sensor order top-to-bottom RGB        */
    L_SUBPIXEL_ORDER_VRGB = 3,
    /** sensor order top-to-bottom BGR        */
    L_SUBPIXEL_ORDER_VBGR = 4;

/*-------------------------------------------------------------------------*
 *                          HSV histogram flags                            *
 *-------------------------------------------------------------------------*/
/** HSV Histogram */
/** enum  */
public static final int
    /** Use hue-saturation histogram           */
    L_HS_HISTO = 1,
    /** Use hue-value histogram                */
    L_HV_HISTO = 2,
    /** Use saturation-value histogram         */
    L_SV_HISTO = 3;

/*-------------------------------------------------------------------------*
 *                HSV Region flags (inclusion, exclusion)                  *
 *-------------------------------------------------------------------------*/
/** HSV Region */
/** enum  */
public static final int
    /** Use pixels with specified HSV region   */
    L_INCLUDE_REGION = 1,
    /** Use pixels outside HSV region          */
    L_EXCLUDE_REGION = 2;

/*-------------------------------------------------------------------------*
 *                Location flags for adding text to a pix                  *
 *-------------------------------------------------------------------------*/
/** Add Text Location */
/** enum  */
public static final int
    /** Add text above the image               */
    L_ADD_ABOVE = 1,
    /** Add text below the image               */
    L_ADD_BELOW = 2,
    /** Add text to the left of the image      */
    L_ADD_LEFT = 3,
    /** Add text to the right of the image     */
    L_ADD_RIGHT = 4,
    /** Add text over the top of the image     */
    L_ADD_AT_TOP = 5,
    /** Add text over the bottom of the image  */
    L_ADD_AT_BOT = 6,
    /** Add text over left side of the image   */
    L_ADD_AT_LEFT = 7,
    /** Add text over right side of the image  */
    L_ADD_AT_RIGHT = 8;

/*-------------------------------------------------------------------------*
 *                       Flags for plotting on a pix                       *
 *-------------------------------------------------------------------------*/
/** Pix Plot */
/** enum  */
public static final int
    /** Plot horizontally at top               */
    L_PLOT_AT_TOP = 1,
    /** Plot horizontally at middle            */
    L_PLOT_AT_MID_HORIZ = 2,
    /** Plot horizontally at bottom            */
    L_PLOT_AT_BOT = 3,
    /** Plot vertically at left                */
    L_PLOT_AT_LEFT = 4,
    /** Plot vertically at middle              */
    L_PLOT_AT_MID_VERT = 5,
    /** Plot vertically at right               */
    L_PLOT_AT_RIGHT = 6;

/*-------------------------------------------------------------------------*
 *                    Flags for making simple masks                        *
 *-------------------------------------------------------------------------*/
/** Mask Generation */
/** enum  */
public static final int
    /** Select the interior part               */
    L_USE_INNER = 1,
    /** Select the outer part (e.g., a frame)  */
    L_USE_OUTER = 2;

/*-------------------------------------------------------------------------*
 *                   Flags for selecting display program                   *
 *-------------------------------------------------------------------------*/
/** Display Program */
/** enum  */
public static final int
    /** Use xzgv with pixDisplay()              */
    L_DISPLAY_WITH_XZGV = 1,
    /** Use xli with pixDisplay()               */
    L_DISPLAY_WITH_XLI = 2,
    /** Use xv with pixDisplay()                */
    L_DISPLAY_WITH_XV = 3,
    /** Use irfvanview (win) with pixDisplay()  */
    L_DISPLAY_WITH_IV = 4,
    /** Use open (apple) with pixDisplay()      */
    L_DISPLAY_WITH_OPEN = 5;

/*-------------------------------------------------------------------------*
 *    Flag(s) used in the 'special' pix field for non-default operations   *
 *      - 0 is default for chroma sampling in jpeg                         *
 *      - 10-19 are used for zlib compression in png write                 *
 *      - 4 and 8 are used for specifying connectivity in labelling        *
 *-------------------------------------------------------------------------*/
/** Flags used in Pix::special */
/** enum  */
public static final int
    /** Write full resolution chroma      */
    L_NO_CHROMA_SAMPLING_JPEG = 1;

/*-------------------------------------------------------------------------*
 *          Handling negative values in conversion to unsigned int         *
 *-------------------------------------------------------------------------*/
/** Negative Value */
/** enum  */
public static final int
    /** Clip negative values to 0                */
    L_CLIP_TO_ZERO = 1,
    /** Convert to positive using L_ABS()        */
    L_TAKE_ABSVAL = 2;

/*-------------------------------------------------------------------------*
 *                        Relative to zero flags                           *
 *-------------------------------------------------------------------------*/
/** Relative To Zero */
/** enum  */
public static final int
    /** Choose values less than zero             */
    L_LESS_THAN_ZERO = 1,
    /** Choose values equal to zero              */
    L_EQUAL_TO_ZERO = 2,
    /** Choose values greater than zero          */
    L_GREATER_THAN_ZERO = 3;

/*-------------------------------------------------------------------------*
 *         Flags for adding or removing trailing slash from string         *
 *-------------------------------------------------------------------------*/
/** Trailing Slash */
/** enum  */
public static final int
    /** Add trailing slash to string           */
    L_ADD_TRAIL_SLASH = 1,
    /** Remove trailing slash from string      */
    L_REMOVE_TRAIL_SLASH = 2;
// Targeting ..\alloc_fn.java


// Targeting ..\dealloc_fn.java



// #endif  /* LEPTONICA_PIX_H */


// Parsed from leptonica/recog.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_RECOG_H
// #define  LEPTONICA_RECOG_H

/**
 * \file recog.h
 *
 * <pre>
 *     This is a simple utility for training and recognizing individual
 *     machine-printed text characters.  It is designed to be adapted
 *     to a particular set of character images; e.g., from a book.
 *
 *     There are two methods of training the recognizer.  In the most
 *     simple, a set of bitmaps has been labeled by some means, such
 *     a generic OCR program.  This is input either one template at a time
 *     or as a pixa of templates, to a function that creates a recog.
 *     If in a pixa, the text string label must be embedded in the
 *     text field of each pix.
 *
 *     If labeled data is not available, we start with a bootstrap
 *     recognizer (BSR) that has labeled data from a variety of sources.
 *     These images are scaled, typically to a fixed height, and then
 *     fed similarly scaled unlabeled images from the source (e.g., book),
 *     and the BSR attempts to identify them.  All images that have
 *     a high enough correlation score with one of the templates in the
 *     BSR are emitted in a pixa, which now holds unscaled and labeled
 *     templates from the source.  This is the generator for a book adapted
 *     recognizer (BAR).
 *
 *     The pixa should always be thought of as the primary structure.
 *     It is the generator for the recog, because a recog is built
 *     from a pixa of unscaled images.
 *
 *     New image templates can be added to a recog as long as it is
 *     in training mode.  Once training is finished, to add templates
 *     it is necessary to extract the generating pixa, add templates
 *     to that pixa, and make a new recog.  Similarly, we do not
 *     join two recog; instead, we simply join their generating pixa,
 *     and make a recog from that.
 *
 *     To remove outliers from a pixa of labeled pix, make a recog,
 *     determine the outliers, and generate a new pixa with the
 *     outliers removed.  The outliers are determined by building
 *     special templates for each character set that are scaled averages
 *     of the individual templates.  Then a correlation score is found
 *     between each template and the averaged templates.  There are
 *     two implementations; outliers are determined as either:
 *      (1) a template having a correlation score with its class average
 *          that is below a threshold, or
 *      (2) a template having a correlation score with its class average
 *          that is smaller than the correlation score with the average
 *          of another class.
 *     Outliers are removed from the generating pixa.  Scaled averaging
 *     is only performed for determining outliers and for splitting
 *     characters; it is never used in a trained recognizer for identifying
 *     unlabeled samples.
 *
 *     Two methods using averaged templates are provided for splitting
 *     touching characters:
 *      (1) greedy matching
 *      (2) document image decoding (DID)
 *     The DID method is the default.  It is about 5x faster and
 *     possibly more accurate.
 *
 *     Once a BAR has been made, unlabeled sample images are identified
 *     by finding the individual template in the BAR with highest
 *     correlation.  The input images and images in the BAR can be
 *     represented in two ways:
 *      (1) as scanned, binarized to 1 bpp
 *      (2) as a width-normalized outline formed by thinning to a
 *          skeleton and then dilating by a fixed amount.
 *
 *     The recog can be serialized to file and read back.  The serialized
 *     version holds the templates used for correlation (which may have
 *     been modified by scaling and turning into lines from the unscaled
 *     templates), plus, for arbitrary character sets, the UTF8
 *     representation and the lookup table mapping from the character
 *     representation to index.
 *
 *     Why do we not use averaged templates for recognition?
 *     Letterforms can take on significantly different shapes (eg.,
 *     the letters 'a' and 'g'), and it makes no sense to average these.
 *     The previous version of this utility allowed multiple recognizers
 *     to exist, but this is an unnecessary complication if recognition
 *     is done on all samples instead of on averages.
 * </pre>
 */

public static final int RECOG_VERSION_NUMBER =      2;
// Targeting ..\L_RECOG.java


// Targeting ..\L_RCH.java


// Targeting ..\L_RCHA.java


// Targeting ..\L_RDID.java




/*-------------------------------------------------------------------------*
 *             Flags for describing limited character sets                 *
 *-------------------------------------------------------------------------*/
/** Character Set */
/** enum  */
public static final int
    /** character set type is not specified      */
    L_UNKNOWN = 0,
    /** 10 digits                                */
    L_ARABIC_NUMERALS = 1,
    /** 7 lower-case letters (i,v,x,l,c,d,m)     */
    L_LC_ROMAN_NUMERALS = 2,
    /** 7 upper-case letters (I,V,X,L,C,D,M)     */
    L_UC_ROMAN_NUMERALS = 3,
    /** 26 lower-case letters                    */
    L_LC_ALPHA = 4,
    /** 26 upper-case letters                    */
    L_UC_ALPHA = 5;

/*-------------------------------------------------------------------------*
 *      Flags for selecting between using average and all templates:       *
 *                           recog->templ_use                              *
 *-------------------------------------------------------------------------*/
/** Template Select */
/** enum  */
public static final int
    /** use all templates; default            */
    L_USE_ALL_TEMPLATES = 0,
    /** use average templates; special cases  */
    L_USE_AVERAGE_TEMPLATES = 1;

// #endif  /* LEPTONICA_RECOG_H */


// Parsed from leptonica/regutils.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_REGUTILS_H
// #define  LEPTONICA_REGUTILS_H
// Targeting ..\L_REGPARAMS.java




    /** Running modes for the test */
/** Regtest Mode */
/** enum  */
public static final int
    L_REG_GENERATE = 0,
    L_REG_COMPARE = 1,
    L_REG_DISPLAY = 2;


// #endif  /* LEPTONICA_REGUTILS_H */



// Parsed from leptonica/stringcode.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_STRINGCODE_H
// #define  LEPTONICA_STRINGCODE_H
// Targeting ..\L_STRCODE.java




    /** Select string in stringcode for a specific serializable data type */
/** Stringcode Select */
/** enum  */
public static final int
    /** typedef for the data type                      */
    L_STR_TYPE = 0,
    /** name of the data type                          */
    L_STR_NAME = 1,
    /** reader to get the data type from file          */
    L_STR_READER = 2,
    /** reader to get the compressed string in memory  */
    L_STR_MEMREADER = 3;

// #endif  /* LEPTONICA_STRINGCODE_H */


// Parsed from leptonica/sudoku.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef SUDOKU_H_INCLUDED
// #define SUDOKU_H_INCLUDED
// Targeting ..\L_SUDOKU.java




    /** For printing out array data */
/** Sudoku Output */
/** enum  */
public static final int
    L_SUDOKU_INIT = 0,
    L_SUDOKU_STATE = 1;

// #endif /* SUDOKU_H_INCLUDED */




// Parsed from leptonica/watershed.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_WATERSHED_H
// #define  LEPTONICA_WATERSHED_H
// Targeting ..\L_WSHED.java



// #endif  /* LEPTONICA_WATERSHED_H */


// Parsed from leptonica/allheaders.h

/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

// #ifndef  LEPTONICA_ALLHEADERS_H
// #define  LEPTONICA_ALLHEADERS_H


public static final int LIBLEPT_MAJOR_VERSION =   1;
public static final int LIBLEPT_MINOR_VERSION =   82;
public static final int LIBLEPT_PATCH_VERSION =   0;

// #include "alltypes.h"

// #ifndef NO_PROTOS
/*
 *  These prototypes were autogen'd by xtractprotos, v. 1.5
 */
// #ifdef __cplusplus
// #endif  /* __cplusplus */

public static native PIX pixCleanBackgroundToWhite( PIX pixs, PIX pixim, PIX pixg, @Cast("l_float32") float gamma, @Cast("l_int32") int blackval, @Cast("l_int32") int whiteval );
public static native PIX pixBackgroundNormSimple( PIX pixs, PIX pixim, PIX pixg );
public static native PIX pixBackgroundNorm( PIX pixs, PIX pixim, PIX pixg, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy );
public static native PIX pixBackgroundNormMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("l_int32") int bgval );
public static native @Cast("l_ok") int pixBackgroundNormGrayArray( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixBackgroundNormGrayArray( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int pixBackgroundNormRGBArrays( PIX pixs, PIX pixim, PIX pixg, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("PIX**") PointerPointer ppixr, @Cast("PIX**") PointerPointer ppixg, @Cast("PIX**") PointerPointer ppixb );
public static native @Cast("l_ok") int pixBackgroundNormRGBArrays( PIX pixs, PIX pixim, PIX pixg, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @ByPtrPtr PIX ppixr, @ByPtrPtr PIX ppixg, @ByPtrPtr PIX ppixb );
public static native @Cast("l_ok") int pixBackgroundNormGrayArrayMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("l_int32") int bgval, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixBackgroundNormGrayArrayMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("l_int32") int bgval, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int pixBackgroundNormRGBArraysMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("l_int32") int bgval, @Cast("PIX**") PointerPointer ppixr, @Cast("PIX**") PointerPointer ppixg, @Cast("PIX**") PointerPointer ppixb );
public static native @Cast("l_ok") int pixBackgroundNormRGBArraysMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("l_int32") int bgval, @ByPtrPtr PIX ppixr, @ByPtrPtr PIX ppixg, @ByPtrPtr PIX ppixb );
public static native @Cast("l_ok") int pixGetBackgroundGrayMap( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixGetBackgroundGrayMap( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int pixGetBackgroundRGBMap( PIX pixs, PIX pixim, PIX pixg, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("PIX**") PointerPointer ppixmr, @Cast("PIX**") PointerPointer ppixmg, @Cast("PIX**") PointerPointer ppixmb );
public static native @Cast("l_ok") int pixGetBackgroundRGBMap( PIX pixs, PIX pixim, PIX pixg, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @ByPtrPtr PIX ppixmr, @ByPtrPtr PIX ppixmg, @ByPtrPtr PIX ppixmb );
public static native @Cast("l_ok") int pixGetBackgroundGrayMapMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("PIX**") PointerPointer ppixm );
public static native @Cast("l_ok") int pixGetBackgroundGrayMapMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @ByPtrPtr PIX ppixm );
public static native @Cast("l_ok") int pixGetBackgroundRGBMapMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @Cast("PIX**") PointerPointer ppixmr, @Cast("PIX**") PointerPointer ppixmg, @Cast("PIX**") PointerPointer ppixmb );
public static native @Cast("l_ok") int pixGetBackgroundRGBMapMorph( PIX pixs, PIX pixim, @Cast("l_int32") int reduction, @Cast("l_int32") int size, @ByPtrPtr PIX ppixmr, @ByPtrPtr PIX ppixmg, @ByPtrPtr PIX ppixmb );
public static native @Cast("l_ok") int pixFillMapHoles( PIX pix, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int filltype );
public static native PIX pixExtendByReplication( PIX pixs, @Cast("l_int32") int addw, @Cast("l_int32") int addh );
public static native @Cast("l_ok") int pixSmoothConnectedRegions( PIX pixs, PIX pixm, @Cast("l_int32") int factor );
public static native PIX pixGetInvBackgroundMap( PIX pixs, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy );
public static native PIX pixApplyInvBackgroundGrayMap( PIX pixs, PIX pixm, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native PIX pixApplyInvBackgroundRGBMap( PIX pixs, PIX pixmr, PIX pixmg, PIX pixmb, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native PIX pixApplyVariableGrayMap( PIX pixs, PIX pixg, @Cast("l_int32") int target );
public static native PIX pixGlobalNormRGB( PIX pixd, PIX pixs, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int mapval );
public static native PIX pixGlobalNormNoSatRGB( PIX pixd, PIX pixs, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int factor, @Cast("l_float32") float rank );
public static native @Cast("l_ok") int pixThresholdSpreadNorm( PIX pixs, @Cast("l_int32") int filtertype, @Cast("l_int32") int edgethresh, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval, @Cast("l_int32") int targetthresh, @Cast("PIX**") PointerPointer ppixth, @Cast("PIX**") PointerPointer ppixb, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixThresholdSpreadNorm( PIX pixs, @Cast("l_int32") int filtertype, @Cast("l_int32") int edgethresh, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval, @Cast("l_int32") int targetthresh, @ByPtrPtr PIX ppixth, @ByPtrPtr PIX ppixb, @ByPtrPtr PIX ppixd );
public static native PIX pixBackgroundNormFlex( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_int32") int delta );
public static native PIX pixContrastNorm( PIX pixd, PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int mindiff, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy );
public static native PIX pixAffineSampledPta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixAffineSampled( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixAffineSampled( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixAffineSampled( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixAffinePta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixAffine( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixAffine( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixAffine( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixAffinePtaColor( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint32") int colorval );
public static native PIX pixAffineColor( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint32") int colorval );
public static native PIX pixAffineColor( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint32") int colorval );
public static native PIX pixAffineColor( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint32") int colorval );
public static native PIX pixAffinePtaGray( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint8") byte grayval );
public static native PIX pixAffineGray( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixAffineGray( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixAffineGray( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint8") byte grayval );
public static native PIX pixAffinePtaWithAlpha( PIX pixs, PTA ptad, PTA ptas, PIX pixg, @Cast("l_float32") float fract, @Cast("l_int32") int border );
public static native @Cast("l_ok") int getAffineXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") PointerPointer pvc );
public static native @Cast("l_ok") int getAffineXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatPointer pvc );
public static native @Cast("l_ok") int getAffineXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatBuffer pvc );
public static native @Cast("l_ok") int getAffineXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr float[] pvc );
public static native @Cast("l_ok") int affineInvertXform( @Cast("l_float32*") FloatPointer vc, @Cast("l_float32**") PointerPointer pvci );
public static native @Cast("l_ok") int affineInvertXform( @Cast("l_float32*") FloatPointer vc, @Cast("l_float32**") @ByPtrPtr FloatPointer pvci );
public static native @Cast("l_ok") int affineInvertXform( @Cast("l_float32*") FloatBuffer vc, @Cast("l_float32**") @ByPtrPtr FloatBuffer pvci );
public static native @Cast("l_ok") int affineInvertXform( @Cast("l_float32*") float[] vc, @Cast("l_float32**") @ByPtrPtr float[] pvci );
public static native @Cast("l_ok") int affineXformSampledPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer pxp, @Cast("l_int32*") IntPointer pyp );
public static native @Cast("l_ok") int affineXformSampledPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer pxp, @Cast("l_int32*") IntBuffer pyp );
public static native @Cast("l_ok") int affineXformSampledPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") int[] pxp, @Cast("l_int32*") int[] pyp );
public static native @Cast("l_ok") int affineXformPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pxp, @Cast("l_float32*") FloatPointer pyp );
public static native @Cast("l_ok") int affineXformPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pxp, @Cast("l_float32*") FloatBuffer pyp );
public static native @Cast("l_ok") int affineXformPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pxp, @Cast("l_float32*") float[] pyp );
public static native @Cast("l_ok") int linearInterpolatePixelColor( @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_uint32") int colorval, @Cast("l_uint32*") IntPointer pval );
public static native @Cast("l_ok") int linearInterpolatePixelColor( @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_uint32") int colorval, @Cast("l_uint32*") IntBuffer pval );
public static native @Cast("l_ok") int linearInterpolatePixelColor( @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_uint32") int colorval, @Cast("l_uint32*") int[] pval );
public static native @Cast("l_ok") int linearInterpolatePixelGray( @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int grayval, @Cast("l_int32*") IntPointer pval );
public static native @Cast("l_ok") int linearInterpolatePixelGray( @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int grayval, @Cast("l_int32*") IntBuffer pval );
public static native @Cast("l_ok") int linearInterpolatePixelGray( @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpls, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int grayval, @Cast("l_int32*") int[] pval );
public static native @Cast("l_int32") int gaussjordan( @Cast("l_float32**") PointerPointer a, @Cast("l_float32*") FloatPointer b, @Cast("l_int32") int n );
public static native @Cast("l_int32") int gaussjordan( @Cast("l_float32**") @ByPtrPtr FloatPointer a, @Cast("l_float32*") FloatPointer b, @Cast("l_int32") int n );
public static native @Cast("l_int32") int gaussjordan( @Cast("l_float32**") @ByPtrPtr FloatBuffer a, @Cast("l_float32*") FloatBuffer b, @Cast("l_int32") int n );
public static native @Cast("l_int32") int gaussjordan( @Cast("l_float32**") @ByPtrPtr float[] a, @Cast("l_float32*") float[] b, @Cast("l_int32") int n );
public static native PIX pixAffineSequential( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int bw, @Cast("l_int32") int bh );
public static native @Cast("l_float32*") FloatPointer createMatrix2dTranslate( @Cast("l_float32") float transx, @Cast("l_float32") float transy );
public static native @Cast("l_float32*") FloatPointer createMatrix2dScale( @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native @Cast("l_float32*") FloatPointer createMatrix2dRotate( @Cast("l_float32") float xc, @Cast("l_float32") float yc, @Cast("l_float32") float angle );
public static native PTA ptaTranslate( PTA ptas, @Cast("l_float32") float transx, @Cast("l_float32") float transy );
public static native PTA ptaScale( PTA ptas, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PTA ptaRotate( PTA ptas, @Cast("l_float32") float xc, @Cast("l_float32") float yc, @Cast("l_float32") float angle );
public static native BOXA boxaTranslate( BOXA boxas, @Cast("l_float32") float transx, @Cast("l_float32") float transy );
public static native BOXA boxaScale( BOXA boxas, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native BOXA boxaRotate( BOXA boxas, @Cast("l_float32") float xc, @Cast("l_float32") float yc, @Cast("l_float32") float angle );
public static native PTA ptaAffineTransform( PTA ptas, @Cast("l_float32*") FloatPointer mat );
public static native PTA ptaAffineTransform( PTA ptas, @Cast("l_float32*") FloatBuffer mat );
public static native PTA ptaAffineTransform( PTA ptas, @Cast("l_float32*") float[] mat );
public static native BOXA boxaAffineTransform( BOXA boxas, @Cast("l_float32*") FloatPointer mat );
public static native BOXA boxaAffineTransform( BOXA boxas, @Cast("l_float32*") FloatBuffer mat );
public static native BOXA boxaAffineTransform( BOXA boxas, @Cast("l_float32*") float[] mat );
public static native @Cast("l_ok") int l_productMatVec( @Cast("l_float32*") FloatPointer mat, @Cast("l_float32*") FloatPointer vecs, @Cast("l_float32*") FloatPointer vecd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMatVec( @Cast("l_float32*") FloatBuffer mat, @Cast("l_float32*") FloatBuffer vecs, @Cast("l_float32*") FloatBuffer vecd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMatVec( @Cast("l_float32*") float[] mat, @Cast("l_float32*") float[] vecs, @Cast("l_float32*") float[] vecd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat2( @Cast("l_float32*") FloatPointer mat1, @Cast("l_float32*") FloatPointer mat2, @Cast("l_float32*") FloatPointer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat2( @Cast("l_float32*") FloatBuffer mat1, @Cast("l_float32*") FloatBuffer mat2, @Cast("l_float32*") FloatBuffer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat2( @Cast("l_float32*") float[] mat1, @Cast("l_float32*") float[] mat2, @Cast("l_float32*") float[] matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat3( @Cast("l_float32*") FloatPointer mat1, @Cast("l_float32*") FloatPointer mat2, @Cast("l_float32*") FloatPointer mat3, @Cast("l_float32*") FloatPointer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat3( @Cast("l_float32*") FloatBuffer mat1, @Cast("l_float32*") FloatBuffer mat2, @Cast("l_float32*") FloatBuffer mat3, @Cast("l_float32*") FloatBuffer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat3( @Cast("l_float32*") float[] mat1, @Cast("l_float32*") float[] mat2, @Cast("l_float32*") float[] mat3, @Cast("l_float32*") float[] matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat4( @Cast("l_float32*") FloatPointer mat1, @Cast("l_float32*") FloatPointer mat2, @Cast("l_float32*") FloatPointer mat3, @Cast("l_float32*") FloatPointer mat4, @Cast("l_float32*") FloatPointer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat4( @Cast("l_float32*") FloatBuffer mat1, @Cast("l_float32*") FloatBuffer mat2, @Cast("l_float32*") FloatBuffer mat3, @Cast("l_float32*") FloatBuffer mat4, @Cast("l_float32*") FloatBuffer matd, @Cast("l_int32") int size );
public static native @Cast("l_ok") int l_productMat4( @Cast("l_float32*") float[] mat1, @Cast("l_float32*") float[] mat2, @Cast("l_float32*") float[] mat3, @Cast("l_float32*") float[] mat4, @Cast("l_float32*") float[] matd, @Cast("l_int32") int size );
public static native @Cast("l_int32") int l_getDataBit( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataBit( Pointer line, @Cast("l_int32") int n );
public static native void l_clearDataBit( Pointer line, @Cast("l_int32") int n );
public static native void l_setDataBitVal( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native @Cast("l_int32") int l_getDataDibit( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataDibit( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native void l_clearDataDibit( Pointer line, @Cast("l_int32") int n );
public static native @Cast("l_int32") int l_getDataQbit( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataQbit( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native void l_clearDataQbit( Pointer line, @Cast("l_int32") int n );
public static native @Cast("l_int32") int l_getDataByte( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataByte( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native @Cast("l_int32") int l_getDataTwoBytes( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataTwoBytes( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native @Cast("l_int32") int l_getDataFourBytes( @Const Pointer line, @Cast("l_int32") int n );
public static native void l_setDataFourBytes( Pointer line, @Cast("l_int32") int n, @Cast("l_int32") int val );
public static native @Cast("char*") BytePointer barcodeDispatchDecoder( @Cast("char*") BytePointer barstr, @Cast("l_int32") int format, @Cast("l_int32") int debugflag );
public static native @Cast("char*") ByteBuffer barcodeDispatchDecoder( @Cast("char*") ByteBuffer barstr, @Cast("l_int32") int format, @Cast("l_int32") int debugflag );
public static native @Cast("char*") byte[] barcodeDispatchDecoder( @Cast("char*") byte[] barstr, @Cast("l_int32") int format, @Cast("l_int32") int debugflag );
public static native @Cast("l_int32") int barcodeFormatIsSupported( @Cast("l_int32") int format );
public static native NUMA pixFindBaselines( PIX pixs, @Cast("PTA**") PointerPointer ppta, PIXA pixadb );
public static native NUMA pixFindBaselines( PIX pixs, @ByPtrPtr PTA ppta, PIXA pixadb );
public static native PIX pixDeskewLocal( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixGetLocalSkewTransform( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("PTA**") PointerPointer pptas, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int pixGetLocalSkewTransform( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @ByPtrPtr PTA pptas, @ByPtrPtr PTA pptad );
public static native NUMA pixGetLocalSkewAngles( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_int32") int debug );
public static native NUMA pixGetLocalSkewAngles( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_int32") int debug );
public static native NUMA pixGetLocalSkewAngles( PIX pixs, @Cast("l_int32") int nslices, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_int32") int debug );
public static native L_BBUFFER bbufferCreate( @Cast("const l_uint8*") BytePointer indata, @Cast("l_int32") int nalloc );
public static native L_BBUFFER bbufferCreate( @Cast("const l_uint8*") ByteBuffer indata, @Cast("l_int32") int nalloc );
public static native L_BBUFFER bbufferCreate( @Cast("const l_uint8*") byte[] indata, @Cast("l_int32") int nalloc );
public static native void bbufferDestroy( @Cast("L_BBUFFER**") PointerPointer pbb );
public static native void bbufferDestroy( @ByPtrPtr L_BBUFFER pbb );
public static native @Cast("l_uint8*") BytePointer bbufferDestroyAndSaveData( @Cast("L_BBUFFER**") PointerPointer pbb, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_uint8*") BytePointer bbufferDestroyAndSaveData( @ByPtrPtr L_BBUFFER pbb, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int bbufferRead( L_BBUFFER bb, @Cast("l_uint8*") BytePointer src, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int bbufferRead( L_BBUFFER bb, @Cast("l_uint8*") ByteBuffer src, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int bbufferRead( L_BBUFFER bb, @Cast("l_uint8*") byte[] src, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int bbufferReadStream( L_BBUFFER bb, @Cast("FILE*") Pointer fp, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int bbufferExtendArray( L_BBUFFER bb, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int bbufferWrite( L_BBUFFER bb, @Cast("l_uint8*") BytePointer dest, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_ok") int bbufferWrite( L_BBUFFER bb, @Cast("l_uint8*") ByteBuffer dest, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_ok") int bbufferWrite( L_BBUFFER bb, @Cast("l_uint8*") byte[] dest, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_ok") int bbufferWriteStream( L_BBUFFER bb, @Cast("FILE*") Pointer fp, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnout );
public static native PIX pixBilateral( PIX pixs, @Cast("l_float32") float spatial_stdev, @Cast("l_float32") float range_stdev, @Cast("l_int32") int ncomps, @Cast("l_int32") int reduction );
public static native PIX pixBilateralGray( PIX pixs, @Cast("l_float32") float spatial_stdev, @Cast("l_float32") float range_stdev, @Cast("l_int32") int ncomps, @Cast("l_int32") int reduction );
public static native PIX pixBilateralExact( PIX pixs, L_KERNEL spatial_kel, L_KERNEL range_kel );
public static native PIX pixBilateralGrayExact( PIX pixs, L_KERNEL spatial_kel, L_KERNEL range_kel );
public static native PIX pixBlockBilateralExact( PIX pixs, @Cast("l_float32") float spatial_stdev, @Cast("l_float32") float range_stdev );
public static native L_KERNEL makeRangeKernel( @Cast("l_float32") float range_stdev );
public static native PIX pixBilinearSampledPta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixBilinearSampled( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinearSampled( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinearSampled( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinearPta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixBilinear( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinear( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinear( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixBilinearPtaColor( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint32") int colorval );
public static native PIX pixBilinearColor( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint32") int colorval );
public static native PIX pixBilinearColor( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint32") int colorval );
public static native PIX pixBilinearColor( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint32") int colorval );
public static native PIX pixBilinearPtaGray( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint8") byte grayval );
public static native PIX pixBilinearGray( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixBilinearGray( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixBilinearGray( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint8") byte grayval );
public static native PIX pixBilinearPtaWithAlpha( PIX pixs, PTA ptad, PTA ptas, PIX pixg, @Cast("l_float32") float fract, @Cast("l_int32") int border );
public static native @Cast("l_ok") int getBilinearXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") PointerPointer pvc );
public static native @Cast("l_ok") int getBilinearXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatPointer pvc );
public static native @Cast("l_ok") int getBilinearXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatBuffer pvc );
public static native @Cast("l_ok") int getBilinearXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr float[] pvc );
public static native @Cast("l_ok") int bilinearXformSampledPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer pxp, @Cast("l_int32*") IntPointer pyp );
public static native @Cast("l_ok") int bilinearXformSampledPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer pxp, @Cast("l_int32*") IntBuffer pyp );
public static native @Cast("l_ok") int bilinearXformSampledPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") int[] pxp, @Cast("l_int32*") int[] pyp );
public static native @Cast("l_ok") int bilinearXformPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pxp, @Cast("l_float32*") FloatPointer pyp );
public static native @Cast("l_ok") int bilinearXformPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pxp, @Cast("l_float32*") FloatBuffer pyp );
public static native @Cast("l_ok") int bilinearXformPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pxp, @Cast("l_float32*") float[] pyp );
public static native @Cast("l_ok") int pixOtsuAdaptiveThreshold( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("PIX**") PointerPointer ppixth, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixOtsuAdaptiveThreshold( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @ByPtrPtr PIX ppixth, @ByPtrPtr PIX ppixd );
public static native PIX pixOtsuThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntPointer pthresh );
public static native PIX pixOtsuThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntBuffer pthresh );
public static native PIX pixOtsuThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int bgval, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") int[] pthresh );
public static native PIX pixMaskedThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntPointer pthresh );
public static native PIX pixMaskedThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntBuffer pthresh );
public static native PIX pixMaskedThreshOnBackgroundNorm( PIX pixs, PIX pixim, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int thresh, @Cast("l_int32") int mincount, @Cast("l_int32") int smoothx, @Cast("l_int32") int smoothy, @Cast("l_float32") float scorefract, @Cast("l_int32*") int[] pthresh );
public static native @Cast("l_ok") int pixSauvolaBinarizeTiled( PIX pixs, @Cast("l_int32") int whsize, @Cast("l_float32") float factor, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("PIX**") PointerPointer ppixth, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixSauvolaBinarizeTiled( PIX pixs, @Cast("l_int32") int whsize, @Cast("l_float32") float factor, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @ByPtrPtr PIX ppixth, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int pixSauvolaBinarize( PIX pixs, @Cast("l_int32") int whsize, @Cast("l_float32") float factor, @Cast("l_int32") int addborder, @Cast("PIX**") PointerPointer ppixm, @Cast("PIX**") PointerPointer ppixsd, @Cast("PIX**") PointerPointer ppixth, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixSauvolaBinarize( PIX pixs, @Cast("l_int32") int whsize, @Cast("l_float32") float factor, @Cast("l_int32") int addborder, @ByPtrPtr PIX ppixm, @ByPtrPtr PIX ppixsd, @ByPtrPtr PIX ppixth, @ByPtrPtr PIX ppixd );
public static native PIX pixSauvolaOnContrastNorm( PIX pixs, @Cast("l_int32") int mindiff, @Cast("PIX**") PointerPointer ppixn, @Cast("PIX**") PointerPointer ppixth );
public static native PIX pixSauvolaOnContrastNorm( PIX pixs, @Cast("l_int32") int mindiff, @ByPtrPtr PIX ppixn, @ByPtrPtr PIX ppixth );
public static native PIX pixThreshOnDoubleNorm( PIX pixs, @Cast("l_int32") int mindiff );
public static native @Cast("l_ok") int pixThresholdByConnComp( PIX pixs, PIX pixm, @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int incr, @Cast("l_float32") float thresh48, @Cast("l_float32") float threshdiff, @Cast("l_int32*") IntPointer pglobthresh, @Cast("PIX**") PointerPointer ppixd, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixThresholdByConnComp( PIX pixs, PIX pixm, @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int incr, @Cast("l_float32") float thresh48, @Cast("l_float32") float threshdiff, @Cast("l_int32*") IntPointer pglobthresh, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixThresholdByConnComp( PIX pixs, PIX pixm, @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int incr, @Cast("l_float32") float thresh48, @Cast("l_float32") float threshdiff, @Cast("l_int32*") IntBuffer pglobthresh, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixThresholdByConnComp( PIX pixs, PIX pixm, @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int incr, @Cast("l_float32") float thresh48, @Cast("l_float32") float threshdiff, @Cast("l_int32*") int[] pglobthresh, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixThresholdByHisto( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int halfw, @Cast("l_float32") float delta, @Cast("l_int32*") IntPointer pthresh, @Cast("PIX**") PointerPointer ppixd, @Cast("PIX**") PointerPointer ppixhisto );
public static native @Cast("l_ok") int pixThresholdByHisto( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int halfw, @Cast("l_float32") float delta, @Cast("l_int32*") IntPointer pthresh, @ByPtrPtr PIX ppixd, @ByPtrPtr PIX ppixhisto );
public static native @Cast("l_ok") int pixThresholdByHisto( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int halfw, @Cast("l_float32") float delta, @Cast("l_int32*") IntBuffer pthresh, @ByPtrPtr PIX ppixd, @ByPtrPtr PIX ppixhisto );
public static native @Cast("l_ok") int pixThresholdByHisto( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int halfw, @Cast("l_float32") float delta, @Cast("l_int32*") int[] pthresh, @ByPtrPtr PIX ppixd, @ByPtrPtr PIX ppixhisto );
public static native PIX pixExpandBinaryReplicate( PIX pixs, @Cast("l_int32") int xfact, @Cast("l_int32") int yfact );
public static native PIX pixExpandBinaryPower2( PIX pixs, @Cast("l_int32") int factor );
public static native PIX pixReduceBinary2( PIX pixs, @Cast("l_uint8*") BytePointer intab );
public static native PIX pixReduceBinary2( PIX pixs, @Cast("l_uint8*") ByteBuffer intab );
public static native PIX pixReduceBinary2( PIX pixs, @Cast("l_uint8*") byte[] intab );
public static native PIX pixReduceRankBinaryCascade( PIX pixs, @Cast("l_int32") int level1, @Cast("l_int32") int level2, @Cast("l_int32") int level3, @Cast("l_int32") int level4 );
public static native PIX pixReduceRankBinary2( PIX pixs, @Cast("l_int32") int level, @Cast("l_uint8*") BytePointer intab );
public static native PIX pixReduceRankBinary2( PIX pixs, @Cast("l_int32") int level, @Cast("l_uint8*") ByteBuffer intab );
public static native PIX pixReduceRankBinary2( PIX pixs, @Cast("l_int32") int level, @Cast("l_uint8*") byte[] intab );
public static native @Cast("l_uint8*") BytePointer makeSubsampleTab2x( );
public static native PIX pixBlend( PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract );
public static native PIX pixBlendMask( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract, @Cast("l_int32") int type );
public static native PIX pixBlendGray( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract, @Cast("l_int32") int type, @Cast("l_int32") int transparent, @Cast("l_uint32") int transpix );
public static native PIX pixBlendGrayInverse( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract );
public static native PIX pixBlendColor( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract, @Cast("l_int32") int transparent, @Cast("l_uint32") int transpix );
public static native PIX pixBlendColorByChannel( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float rfract, @Cast("l_float32") float gfract, @Cast("l_float32") float bfract, @Cast("l_int32") int transparent, @Cast("l_uint32") int transpix );
public static native PIX pixBlendGrayAdapt( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract, @Cast("l_int32") int shift );
public static native PIX pixFadeWithGray( PIX pixs, PIX pixb, @Cast("l_float32") float factor, @Cast("l_int32") int type );
public static native PIX pixBlendHardLight( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixBlendCmap( PIX pixs, PIX pixb, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int sindex );
public static native PIX pixBlendWithGrayMask( PIX pixs1, PIX pixs2, PIX pixg, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native PIX pixBlendBackgroundToColor( PIX pixd, PIX pixs, BOX box, @Cast("l_uint32") int color, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native PIX pixMultiplyByColor( PIX pixd, PIX pixs, BOX box, @Cast("l_uint32") int color );
public static native PIX pixAlphaBlendUniform( PIX pixs, @Cast("l_uint32") int color );
public static native PIX pixAddAlphaToBlend( PIX pixs, @Cast("l_float32") float fract, @Cast("l_int32") int invert );
public static native PIX pixSetAlphaOverWhite( PIX pixs );
public static native @Cast("l_ok") int pixLinearEdgeFade( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int fadeto, @Cast("l_float32") float distfract, @Cast("l_float32") float maxfade );
public static native L_BMF bmfCreate( @Cast("const char*") BytePointer dir, @Cast("l_int32") int fontsize );
public static native L_BMF bmfCreate( String dir, @Cast("l_int32") int fontsize );
public static native void bmfDestroy( @Cast("L_BMF**") PointerPointer pbmf );
public static native void bmfDestroy( @ByPtrPtr L_BMF pbmf );
public static native PIX bmfGetPix( L_BMF bmf, @Cast("char") byte chr );
public static native @Cast("l_ok") int bmfGetWidth( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") IntPointer pw );
public static native @Cast("l_ok") int bmfGetWidth( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") IntBuffer pw );
public static native @Cast("l_ok") int bmfGetWidth( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") int[] pw );
public static native @Cast("l_ok") int bmfGetBaseline( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") IntPointer pbaseline );
public static native @Cast("l_ok") int bmfGetBaseline( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") IntBuffer pbaseline );
public static native @Cast("l_ok") int bmfGetBaseline( L_BMF bmf, @Cast("char") byte chr, @Cast("l_int32*") int[] pbaseline );
public static native PIXA pixaGetFont( @Cast("const char*") BytePointer dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") IntPointer pbl0, @Cast("l_int32*") IntPointer pbl1, @Cast("l_int32*") IntPointer pbl2 );
public static native PIXA pixaGetFont( String dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") IntBuffer pbl0, @Cast("l_int32*") IntBuffer pbl1, @Cast("l_int32*") IntBuffer pbl2 );
public static native PIXA pixaGetFont( @Cast("const char*") BytePointer dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") int[] pbl0, @Cast("l_int32*") int[] pbl1, @Cast("l_int32*") int[] pbl2 );
public static native PIXA pixaGetFont( String dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") IntPointer pbl0, @Cast("l_int32*") IntPointer pbl1, @Cast("l_int32*") IntPointer pbl2 );
public static native PIXA pixaGetFont( @Cast("const char*") BytePointer dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") IntBuffer pbl0, @Cast("l_int32*") IntBuffer pbl1, @Cast("l_int32*") IntBuffer pbl2 );
public static native PIXA pixaGetFont( String dir, @Cast("l_int32") int fontsize, @Cast("l_int32*") int[] pbl0, @Cast("l_int32*") int[] pbl1, @Cast("l_int32*") int[] pbl2 );
public static native @Cast("l_ok") int pixaSaveFont( @Cast("const char*") BytePointer indir, @Cast("const char*") BytePointer outdir, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixaSaveFont( String indir, String outdir, @Cast("l_int32") int fontsize );
public static native PIX pixReadStreamBmp( @Cast("FILE*") Pointer fp );
public static native PIX pixReadMemBmp( @Cast("const l_uint8*") BytePointer cdata, @Cast("size_t") long size );
public static native PIX pixReadMemBmp( @Cast("const l_uint8*") ByteBuffer cdata, @Cast("size_t") long size );
public static native PIX pixReadMemBmp( @Cast("const l_uint8*") byte[] cdata, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixWriteStreamBmp( @Cast("FILE*") Pointer fp, PIX pix );
public static native @Cast("l_ok") int pixWriteMemBmp( @Cast("l_uint8**") PointerPointer pfdata, @Cast("size_t*") SizeTPointer pfsize, PIX pixs );
public static native @Cast("l_ok") int pixWriteMemBmp( @Cast("l_uint8**") @ByPtrPtr BytePointer pfdata, @Cast("size_t*") SizeTPointer pfsize, PIX pixs );
public static native @Cast("l_ok") int pixWriteMemBmp( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pfdata, @Cast("size_t*") SizeTPointer pfsize, PIX pixs );
public static native @Cast("l_ok") int pixWriteMemBmp( @Cast("l_uint8**") @ByPtrPtr byte[] pfdata, @Cast("size_t*") SizeTPointer pfsize, PIX pixs );
public static native PIXA l_bootnum_gen1( );
public static native PIXA l_bootnum_gen2( );
public static native PIXA l_bootnum_gen3( );
public static native PIXA l_bootnum_gen4( @Cast("l_int32") int nsamp );
public static native BOX boxCreate( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native BOX boxCreateValid( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native BOX boxCopy( BOX box );
public static native BOX boxClone( BOX box );
public static native void boxDestroy( @Cast("BOX**") PointerPointer pbox );
public static native void boxDestroy( @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int boxGetGeometry( BOX box, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int boxGetGeometry( BOX box, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int boxGetGeometry( BOX box, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int boxSetGeometry( BOX box, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native @Cast("l_ok") int boxGetSideLocations( BOX box, @Cast("l_int32*") IntPointer pl, @Cast("l_int32*") IntPointer pr, @Cast("l_int32*") IntPointer pt, @Cast("l_int32*") IntPointer pb );
public static native @Cast("l_ok") int boxGetSideLocations( BOX box, @Cast("l_int32*") IntBuffer pl, @Cast("l_int32*") IntBuffer pr, @Cast("l_int32*") IntBuffer pt, @Cast("l_int32*") IntBuffer pb );
public static native @Cast("l_ok") int boxGetSideLocations( BOX box, @Cast("l_int32*") int[] pl, @Cast("l_int32*") int[] pr, @Cast("l_int32*") int[] pt, @Cast("l_int32*") int[] pb );
public static native @Cast("l_ok") int boxSetSideLocations( BOX box, @Cast("l_int32") int l, @Cast("l_int32") int r, @Cast("l_int32") int t, @Cast("l_int32") int b );
public static native @Cast("l_int32") int boxGetRefcount( BOX box );
public static native @Cast("l_ok") int boxChangeRefcount( BOX box, @Cast("l_int32") int delta );
public static native @Cast("l_ok") int boxIsValid( BOX box, @Cast("l_int32*") IntPointer pvalid );
public static native @Cast("l_ok") int boxIsValid( BOX box, @Cast("l_int32*") IntBuffer pvalid );
public static native @Cast("l_ok") int boxIsValid( BOX box, @Cast("l_int32*") int[] pvalid );
public static native BOXA boxaCreate( @Cast("l_int32") int n );
public static native BOXA boxaCopy( BOXA boxa, @Cast("l_int32") int copyflag );
public static native void boxaDestroy( @Cast("BOXA**") PointerPointer pboxa );
public static native void boxaDestroy( @ByPtrPtr BOXA pboxa );
public static native @Cast("l_ok") int boxaAddBox( BOXA boxa, BOX box, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int boxaExtendArray( BOXA boxa );
public static native @Cast("l_ok") int boxaExtendArrayToSize( BOXA boxa, @Cast("size_t") long size );
public static native @Cast("l_int32") int boxaGetCount( BOXA boxa );
public static native @Cast("l_int32") int boxaGetValidCount( BOXA boxa );
public static native BOX boxaGetBox( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native BOX boxaGetValidBox( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native NUMA boxaFindInvalidBoxes( BOXA boxa );
public static native @Cast("l_ok") int boxaGetBoxGeometry( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int boxaGetBoxGeometry( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int boxaGetBoxGeometry( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int boxaIsFull( BOXA boxa, @Cast("l_int32*") IntPointer pfull );
public static native @Cast("l_ok") int boxaIsFull( BOXA boxa, @Cast("l_int32*") IntBuffer pfull );
public static native @Cast("l_ok") int boxaIsFull( BOXA boxa, @Cast("l_int32*") int[] pfull );
public static native @Cast("l_ok") int boxaReplaceBox( BOXA boxa, @Cast("l_int32") int index, BOX box );
public static native @Cast("l_ok") int boxaInsertBox( BOXA boxa, @Cast("l_int32") int index, BOX box );
public static native @Cast("l_ok") int boxaRemoveBox( BOXA boxa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int boxaRemoveBoxAndSave( BOXA boxa, @Cast("l_int32") int index, @Cast("BOX**") PointerPointer pbox );
public static native @Cast("l_ok") int boxaRemoveBoxAndSave( BOXA boxa, @Cast("l_int32") int index, @ByPtrPtr BOX pbox );
public static native BOXA boxaSaveValid( BOXA boxas, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int boxaInitFull( BOXA boxa, BOX box );
public static native @Cast("l_ok") int boxaClear( BOXA boxa );
public static native BOXAA boxaaCreate( @Cast("l_int32") int n );
public static native BOXAA boxaaCopy( BOXAA baas, @Cast("l_int32") int copyflag );
public static native void boxaaDestroy( @Cast("BOXAA**") PointerPointer pbaa );
public static native void boxaaDestroy( @ByPtrPtr BOXAA pbaa );
public static native @Cast("l_ok") int boxaaAddBoxa( BOXAA baa, BOXA ba, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int boxaaExtendArray( BOXAA baa );
public static native @Cast("l_ok") int boxaaExtendArrayToSize( BOXAA baa, @Cast("l_int32") int size );
public static native @Cast("l_int32") int boxaaGetCount( BOXAA baa );
public static native @Cast("l_int32") int boxaaGetBoxCount( BOXAA baa );
public static native BOXA boxaaGetBoxa( BOXAA baa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native BOX boxaaGetBox( BOXAA baa, @Cast("l_int32") int iboxa, @Cast("l_int32") int ibox, @Cast("l_int32") int accessflag );
public static native @Cast("l_ok") int boxaaInitFull( BOXAA baa, BOXA boxa );
public static native @Cast("l_ok") int boxaaExtendWithInit( BOXAA baa, @Cast("l_int32") int maxindex, BOXA boxa );
public static native @Cast("l_ok") int boxaaReplaceBoxa( BOXAA baa, @Cast("l_int32") int index, BOXA boxa );
public static native @Cast("l_ok") int boxaaInsertBoxa( BOXAA baa, @Cast("l_int32") int index, BOXA boxa );
public static native @Cast("l_ok") int boxaaRemoveBoxa( BOXAA baa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int boxaaAddBox( BOXAA baa, @Cast("l_int32") int index, BOX box, @Cast("l_int32") int accessflag );
public static native BOXAA boxaaReadFromFiles( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native BOXAA boxaaReadFromFiles( String dirname, String substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native BOXAA boxaaRead( @Cast("const char*") BytePointer filename );
public static native BOXAA boxaaRead( String filename );
public static native BOXAA boxaaReadStream( @Cast("FILE*") Pointer fp );
public static native BOXAA boxaaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native BOXAA boxaaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native BOXAA boxaaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int boxaaWrite( @Cast("const char*") BytePointer filename, BOXAA baa );
public static native @Cast("l_ok") int boxaaWrite( String filename, BOXAA baa );
public static native @Cast("l_ok") int boxaaWriteStream( @Cast("FILE*") Pointer fp, BOXAA baa );
public static native @Cast("l_ok") int boxaaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, BOXAA baa );
public static native @Cast("l_ok") int boxaaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, BOXAA baa );
public static native @Cast("l_ok") int boxaaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, BOXAA baa );
public static native @Cast("l_ok") int boxaaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, BOXAA baa );
public static native BOXA boxaRead( @Cast("const char*") BytePointer filename );
public static native BOXA boxaRead( String filename );
public static native BOXA boxaReadStream( @Cast("FILE*") Pointer fp );
public static native BOXA boxaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native BOXA boxaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native BOXA boxaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int boxaWriteDebug( @Cast("const char*") BytePointer filename, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteDebug( String filename, BOXA boxa );
public static native @Cast("l_ok") int boxaWrite( @Cast("const char*") BytePointer filename, BOXA boxa );
public static native @Cast("l_ok") int boxaWrite( String filename, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteStream( @Cast("FILE*") Pointer fp, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteStderr( BOXA boxa );
public static native @Cast("l_ok") int boxaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, BOXA boxa );
public static native @Cast("l_ok") int boxaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, BOXA boxa );
public static native @Cast("l_ok") int boxPrintStreamInfo( @Cast("FILE*") Pointer fp, BOX box );
public static native @Cast("l_ok") int boxContains( BOX box1, BOX box2, @Cast("l_int32*") IntPointer presult );
public static native @Cast("l_ok") int boxContains( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer presult );
public static native @Cast("l_ok") int boxContains( BOX box1, BOX box2, @Cast("l_int32*") int[] presult );
public static native @Cast("l_ok") int boxIntersects( BOX box1, BOX box2, @Cast("l_int32*") IntPointer presult );
public static native @Cast("l_ok") int boxIntersects( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer presult );
public static native @Cast("l_ok") int boxIntersects( BOX box1, BOX box2, @Cast("l_int32*") int[] presult );
public static native BOXA boxaContainedInBox( BOXA boxas, BOX box );
public static native @Cast("l_ok") int boxaContainedInBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int boxaContainedInBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int boxaContainedInBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") int[] pcount );
public static native @Cast("l_ok") int boxaContainedInBoxa( BOXA boxa1, BOXA boxa2, @Cast("l_int32*") IntPointer pcontained );
public static native @Cast("l_ok") int boxaContainedInBoxa( BOXA boxa1, BOXA boxa2, @Cast("l_int32*") IntBuffer pcontained );
public static native @Cast("l_ok") int boxaContainedInBoxa( BOXA boxa1, BOXA boxa2, @Cast("l_int32*") int[] pcontained );
public static native BOXA boxaIntersectsBox( BOXA boxas, BOX box );
public static native @Cast("l_ok") int boxaIntersectsBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int boxaIntersectsBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int boxaIntersectsBoxCount( BOXA boxa, BOX box, @Cast("l_int32*") int[] pcount );
public static native BOXA boxaClipToBox( BOXA boxas, BOX box );
public static native BOXA boxaCombineOverlaps( BOXA boxas, PIXA pixadb );
public static native @Cast("l_ok") int boxaCombineOverlapsInPair( BOXA boxas1, BOXA boxas2, @Cast("BOXA**") PointerPointer pboxad1, @Cast("BOXA**") PointerPointer pboxad2, PIXA pixadb );
public static native @Cast("l_ok") int boxaCombineOverlapsInPair( BOXA boxas1, BOXA boxas2, @ByPtrPtr BOXA pboxad1, @ByPtrPtr BOXA pboxad2, PIXA pixadb );
public static native BOX boxOverlapRegion( BOX box1, BOX box2 );
public static native BOX boxBoundingRegion( BOX box1, BOX box2 );
public static native @Cast("l_ok") int boxOverlapFraction( BOX box1, BOX box2, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int boxOverlapFraction( BOX box1, BOX box2, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int boxOverlapFraction( BOX box1, BOX box2, @Cast("l_float32*") float[] pfract );
public static native @Cast("l_ok") int boxOverlapArea( BOX box1, BOX box2, @Cast("l_int32*") IntPointer parea );
public static native @Cast("l_ok") int boxOverlapArea( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer parea );
public static native @Cast("l_ok") int boxOverlapArea( BOX box1, BOX box2, @Cast("l_int32*") int[] parea );
public static native BOXA boxaHandleOverlaps( BOXA boxas, @Cast("l_int32") int op, @Cast("l_int32") int range, @Cast("l_float32") float min_overlap, @Cast("l_float32") float max_ratio, @Cast("NUMA**") PointerPointer pnamap );
public static native BOXA boxaHandleOverlaps( BOXA boxas, @Cast("l_int32") int op, @Cast("l_int32") int range, @Cast("l_float32") float min_overlap, @Cast("l_float32") float max_ratio, @ByPtrPtr NUMA pnamap );
public static native @Cast("l_ok") int boxOverlapDistance( BOX box1, BOX box2, @Cast("l_int32*") IntPointer ph_ovl, @Cast("l_int32*") IntPointer pv_ovl );
public static native @Cast("l_ok") int boxOverlapDistance( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer ph_ovl, @Cast("l_int32*") IntBuffer pv_ovl );
public static native @Cast("l_ok") int boxOverlapDistance( BOX box1, BOX box2, @Cast("l_int32*") int[] ph_ovl, @Cast("l_int32*") int[] pv_ovl );
public static native @Cast("l_ok") int boxSeparationDistance( BOX box1, BOX box2, @Cast("l_int32*") IntPointer ph_sep, @Cast("l_int32*") IntPointer pv_sep );
public static native @Cast("l_ok") int boxSeparationDistance( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer ph_sep, @Cast("l_int32*") IntBuffer pv_sep );
public static native @Cast("l_ok") int boxSeparationDistance( BOX box1, BOX box2, @Cast("l_int32*") int[] ph_sep, @Cast("l_int32*") int[] pv_sep );
public static native @Cast("l_ok") int boxCompareSize( BOX box1, BOX box2, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer prel );
public static native @Cast("l_ok") int boxCompareSize( BOX box1, BOX box2, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer prel );
public static native @Cast("l_ok") int boxCompareSize( BOX box1, BOX box2, @Cast("l_int32") int type, @Cast("l_int32*") int[] prel );
public static native @Cast("l_ok") int boxContainsPt( BOX box, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") IntPointer pcontains );
public static native @Cast("l_ok") int boxContainsPt( BOX box, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") IntBuffer pcontains );
public static native @Cast("l_ok") int boxContainsPt( BOX box, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") int[] pcontains );
public static native BOX boxaGetNearestToPt( BOXA boxa, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native BOX boxaGetNearestToLine( BOXA boxa, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int boxaFindNearestBoxes( BOXA boxa, @Cast("l_int32") int dist_select, @Cast("l_int32") int range, @Cast("NUMAA**") PointerPointer pnaaindex, @Cast("NUMAA**") PointerPointer pnaadist );
public static native @Cast("l_ok") int boxaFindNearestBoxes( BOXA boxa, @Cast("l_int32") int dist_select, @Cast("l_int32") int range, @ByPtrPtr NUMAA pnaaindex, @ByPtrPtr NUMAA pnaadist );
public static native @Cast("l_ok") int boxaGetNearestByDirection( BOXA boxa, @Cast("l_int32") int i, @Cast("l_int32") int dir, @Cast("l_int32") int dist_select, @Cast("l_int32") int range, @Cast("l_int32*") IntPointer pindex, @Cast("l_int32*") IntPointer pdist );
public static native @Cast("l_ok") int boxaGetNearestByDirection( BOXA boxa, @Cast("l_int32") int i, @Cast("l_int32") int dir, @Cast("l_int32") int dist_select, @Cast("l_int32") int range, @Cast("l_int32*") IntBuffer pindex, @Cast("l_int32*") IntBuffer pdist );
public static native @Cast("l_ok") int boxaGetNearestByDirection( BOXA boxa, @Cast("l_int32") int i, @Cast("l_int32") int dir, @Cast("l_int32") int dist_select, @Cast("l_int32") int range, @Cast("l_int32*") int[] pindex, @Cast("l_int32*") int[] pdist );
public static native @Cast("l_ok") int boxGetCenter( BOX box, @Cast("l_float32*") FloatPointer pcx, @Cast("l_float32*") FloatPointer pcy );
public static native @Cast("l_ok") int boxGetCenter( BOX box, @Cast("l_float32*") FloatBuffer pcx, @Cast("l_float32*") FloatBuffer pcy );
public static native @Cast("l_ok") int boxGetCenter( BOX box, @Cast("l_float32*") float[] pcx, @Cast("l_float32*") float[] pcy );
public static native @Cast("l_ok") int boxIntersectByLine( BOX box, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float slope, @Cast("l_int32*") IntPointer px1, @Cast("l_int32*") IntPointer py1, @Cast("l_int32*") IntPointer px2, @Cast("l_int32*") IntPointer py2, @Cast("l_int32*") IntPointer pn );
public static native @Cast("l_ok") int boxIntersectByLine( BOX box, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float slope, @Cast("l_int32*") IntBuffer px1, @Cast("l_int32*") IntBuffer py1, @Cast("l_int32*") IntBuffer px2, @Cast("l_int32*") IntBuffer py2, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("l_ok") int boxIntersectByLine( BOX box, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float slope, @Cast("l_int32*") int[] px1, @Cast("l_int32*") int[] py1, @Cast("l_int32*") int[] px2, @Cast("l_int32*") int[] py2, @Cast("l_int32*") int[] pn );
public static native BOX boxClipToRectangle( BOX box, @Cast("l_int32") int wi, @Cast("l_int32") int hi );
public static native @Cast("l_ok") int boxClipToRectangleParams( BOX box, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32*") IntPointer pxstart, @Cast("l_int32*") IntPointer pystart, @Cast("l_int32*") IntPointer pxend, @Cast("l_int32*") IntPointer pyend, @Cast("l_int32*") IntPointer pbw, @Cast("l_int32*") IntPointer pbh );
public static native @Cast("l_ok") int boxClipToRectangleParams( BOX box, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32*") IntBuffer pxstart, @Cast("l_int32*") IntBuffer pystart, @Cast("l_int32*") IntBuffer pxend, @Cast("l_int32*") IntBuffer pyend, @Cast("l_int32*") IntBuffer pbw, @Cast("l_int32*") IntBuffer pbh );
public static native @Cast("l_ok") int boxClipToRectangleParams( BOX box, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32*") int[] pxstart, @Cast("l_int32*") int[] pystart, @Cast("l_int32*") int[] pxend, @Cast("l_int32*") int[] pyend, @Cast("l_int32*") int[] pbw, @Cast("l_int32*") int[] pbh );
public static native BOX boxRelocateOneSide( BOX boxd, BOX boxs, @Cast("l_int32") int loc, @Cast("l_int32") int sideflag );
public static native BOXA boxaAdjustSides( BOXA boxas, @Cast("l_int32") int delleft, @Cast("l_int32") int delright, @Cast("l_int32") int deltop, @Cast("l_int32") int delbot );
public static native @Cast("l_ok") int boxaAdjustBoxSides( BOXA boxa, @Cast("l_int32") int index, @Cast("l_int32") int delleft, @Cast("l_int32") int delright, @Cast("l_int32") int deltop, @Cast("l_int32") int delbot );
public static native BOX boxAdjustSides( BOX boxd, BOX boxs, @Cast("l_int32") int delleft, @Cast("l_int32") int delright, @Cast("l_int32") int deltop, @Cast("l_int32") int delbot );
public static native BOXA boxaSetSide( BOXA boxad, BOXA boxas, @Cast("l_int32") int side, @Cast("l_int32") int val, @Cast("l_int32") int thresh );
public static native @Cast("l_ok") int boxSetSide( BOX boxs, @Cast("l_int32") int side, @Cast("l_int32") int val, @Cast("l_int32") int thresh );
public static native BOXA boxaAdjustWidthToTarget( BOXA boxad, BOXA boxas, @Cast("l_int32") int sides, @Cast("l_int32") int target, @Cast("l_int32") int thresh );
public static native BOXA boxaAdjustHeightToTarget( BOXA boxad, BOXA boxas, @Cast("l_int32") int sides, @Cast("l_int32") int target, @Cast("l_int32") int thresh );
public static native @Cast("l_ok") int boxEqual( BOX box1, BOX box2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int boxEqual( BOX box1, BOX box2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int boxEqual( BOX box1, BOX box2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int boxaEqual( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int maxdist, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int boxaEqual( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int boxaEqual( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int boxaEqual( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int boxSimilar( BOX box1, BOX box2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32*") IntPointer psimilar );
public static native @Cast("l_ok") int boxSimilar( BOX box1, BOX box2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32*") IntBuffer psimilar );
public static native @Cast("l_ok") int boxSimilar( BOX box1, BOX box2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32*") int[] psimilar );
public static native @Cast("l_ok") int boxaSimilar( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32") int debug, @Cast("l_int32*") IntPointer psimilar, @Cast("NUMA**") PointerPointer pnasim );
public static native @Cast("l_ok") int boxaSimilar( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32") int debug, @Cast("l_int32*") IntPointer psimilar, @ByPtrPtr NUMA pnasim );
public static native @Cast("l_ok") int boxaSimilar( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32") int debug, @Cast("l_int32*") IntBuffer psimilar, @ByPtrPtr NUMA pnasim );
public static native @Cast("l_ok") int boxaSimilar( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int leftdiff, @Cast("l_int32") int rightdiff, @Cast("l_int32") int topdiff, @Cast("l_int32") int botdiff, @Cast("l_int32") int debug, @Cast("l_int32*") int[] psimilar, @ByPtrPtr NUMA pnasim );
public static native @Cast("l_ok") int boxaJoin( BOXA boxad, BOXA boxas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native @Cast("l_ok") int boxaaJoin( BOXAA baad, BOXAA baas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native @Cast("l_ok") int boxaSplitEvenOdd( BOXA boxa, @Cast("l_int32") int fillflag, @Cast("BOXA**") PointerPointer pboxae, @Cast("BOXA**") PointerPointer pboxao );
public static native @Cast("l_ok") int boxaSplitEvenOdd( BOXA boxa, @Cast("l_int32") int fillflag, @ByPtrPtr BOXA pboxae, @ByPtrPtr BOXA pboxao );
public static native BOXA boxaMergeEvenOdd( BOXA boxae, BOXA boxao, @Cast("l_int32") int fillflag );
public static native BOXA boxaTransform( BOXA boxas, @Cast("l_int32") int shiftx, @Cast("l_int32") int shifty, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native BOX boxTransform( BOX box, @Cast("l_int32") int shiftx, @Cast("l_int32") int shifty, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native BOXA boxaTransformOrdered( BOXA boxas, @Cast("l_int32") int shiftx, @Cast("l_int32") int shifty, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int order );
public static native BOX boxTransformOrdered( BOX boxs, @Cast("l_int32") int shiftx, @Cast("l_int32") int shifty, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int order );
public static native BOXA boxaRotateOrth( BOXA boxas, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int rotation );
public static native BOX boxRotateOrth( BOX box, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int rotation );
public static native BOXA boxaShiftWithPta( BOXA boxas, PTA pta, @Cast("l_int32") int dir );
public static native BOXA boxaSort( BOXA boxas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex );
public static native BOXA boxaSort( BOXA boxas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex );
public static native BOXA boxaBinSort( BOXA boxas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex );
public static native BOXA boxaBinSort( BOXA boxas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex );
public static native BOXA boxaSortByIndex( BOXA boxas, NUMA naindex );
public static native BOXAA boxaSort2d( BOXA boxas, @Cast("NUMAA**") PointerPointer pnaad, @Cast("l_int32") int delta1, @Cast("l_int32") int delta2, @Cast("l_int32") int minh1 );
public static native BOXAA boxaSort2d( BOXA boxas, @ByPtrPtr NUMAA pnaad, @Cast("l_int32") int delta1, @Cast("l_int32") int delta2, @Cast("l_int32") int minh1 );
public static native BOXAA boxaSort2dByIndex( BOXA boxas, NUMAA naa );
public static native @Cast("l_ok") int boxaExtractAsNuma( BOXA boxa, @Cast("NUMA**") PointerPointer pnal, @Cast("NUMA**") PointerPointer pnat, @Cast("NUMA**") PointerPointer pnar, @Cast("NUMA**") PointerPointer pnab, @Cast("NUMA**") PointerPointer pnaw, @Cast("NUMA**") PointerPointer pnah, @Cast("l_int32") int keepinvalid );
public static native @Cast("l_ok") int boxaExtractAsNuma( BOXA boxa, @ByPtrPtr NUMA pnal, @ByPtrPtr NUMA pnat, @ByPtrPtr NUMA pnar, @ByPtrPtr NUMA pnab, @ByPtrPtr NUMA pnaw, @ByPtrPtr NUMA pnah, @Cast("l_int32") int keepinvalid );
public static native @Cast("l_ok") int boxaExtractAsPta( BOXA boxa, @Cast("PTA**") PointerPointer pptal, @Cast("PTA**") PointerPointer pptat, @Cast("PTA**") PointerPointer pptar, @Cast("PTA**") PointerPointer pptab, @Cast("PTA**") PointerPointer pptaw, @Cast("PTA**") PointerPointer pptah, @Cast("l_int32") int keepinvalid );
public static native @Cast("l_ok") int boxaExtractAsPta( BOXA boxa, @ByPtrPtr PTA pptal, @ByPtrPtr PTA pptat, @ByPtrPtr PTA pptar, @ByPtrPtr PTA pptab, @ByPtrPtr PTA pptaw, @ByPtrPtr PTA pptah, @Cast("l_int32") int keepinvalid );
public static native PTA boxaExtractCorners( BOXA boxa, @Cast("l_int32") int loc );
public static native @Cast("l_ok") int boxaGetRankVals( BOXA boxa, @Cast("l_float32") float fract, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pr, @Cast("l_int32*") IntPointer pb, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int boxaGetRankVals( BOXA boxa, @Cast("l_float32") float fract, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pr, @Cast("l_int32*") IntBuffer pb, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int boxaGetRankVals( BOXA boxa, @Cast("l_float32") float fract, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pr, @Cast("l_int32*") int[] pb, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int boxaGetMedianVals( BOXA boxa, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pr, @Cast("l_int32*") IntPointer pb, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int boxaGetMedianVals( BOXA boxa, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pr, @Cast("l_int32*") IntBuffer pb, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int boxaGetMedianVals( BOXA boxa, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pr, @Cast("l_int32*") int[] pb, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int boxaGetAverageSize( BOXA boxa, @Cast("l_float32*") FloatPointer pw, @Cast("l_float32*") FloatPointer ph );
public static native @Cast("l_ok") int boxaGetAverageSize( BOXA boxa, @Cast("l_float32*") FloatBuffer pw, @Cast("l_float32*") FloatBuffer ph );
public static native @Cast("l_ok") int boxaGetAverageSize( BOXA boxa, @Cast("l_float32*") float[] pw, @Cast("l_float32*") float[] ph );
public static native @Cast("l_ok") int boxaaGetExtent( BOXAA baa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("BOX**") PointerPointer pbox, @Cast("BOXA**") PointerPointer pboxa );
public static native @Cast("l_ok") int boxaaGetExtent( BOXAA baa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @ByPtrPtr BOX pbox, @ByPtrPtr BOXA pboxa );
public static native @Cast("l_ok") int boxaaGetExtent( BOXAA baa, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @ByPtrPtr BOX pbox, @ByPtrPtr BOXA pboxa );
public static native @Cast("l_ok") int boxaaGetExtent( BOXAA baa, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @ByPtrPtr BOX pbox, @ByPtrPtr BOXA pboxa );
public static native BOXA boxaaFlattenToBoxa( BOXAA baa, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32") int copyflag );
public static native BOXA boxaaFlattenToBoxa( BOXAA baa, @ByPtrPtr NUMA pnaindex, @Cast("l_int32") int copyflag );
public static native BOXA boxaaFlattenAligned( BOXAA baa, @Cast("l_int32") int num, BOX fillerbox, @Cast("l_int32") int copyflag );
public static native BOXAA boxaEncapsulateAligned( BOXA boxa, @Cast("l_int32") int num, @Cast("l_int32") int copyflag );
public static native BOXAA boxaaTranspose( BOXAA baas );
public static native @Cast("l_ok") int boxaaAlignBox( BOXAA baa, BOX box, @Cast("l_int32") int delta, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int boxaaAlignBox( BOXAA baa, BOX box, @Cast("l_int32") int delta, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int boxaaAlignBox( BOXAA baa, BOX box, @Cast("l_int32") int delta, @Cast("l_int32*") int[] pindex );
public static native PIX pixMaskConnComp( PIX pixs, @Cast("l_int32") int connectivity, @Cast("BOXA**") PointerPointer pboxa );
public static native PIX pixMaskConnComp( PIX pixs, @Cast("l_int32") int connectivity, @ByPtrPtr BOXA pboxa );
public static native PIX pixMaskBoxa( PIX pixd, PIX pixs, BOXA boxa, @Cast("l_int32") int op );
public static native PIX pixPaintBoxa( PIX pixs, BOXA boxa, @Cast("l_uint32") int val );
public static native PIX pixSetBlackOrWhiteBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int op );
public static native PIX pixPaintBoxaRandom( PIX pixs, BOXA boxa );
public static native PIX pixBlendBoxaRandom( PIX pixs, BOXA boxa, @Cast("l_float32") float fract );
public static native PIX pixDrawBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int width, @Cast("l_uint32") int val );
public static native PIX pixDrawBoxaRandom( PIX pixs, BOXA boxa, @Cast("l_int32") int width );
public static native PIX boxaaDisplay( PIX pixs, BOXAA baa, @Cast("l_int32") int linewba, @Cast("l_int32") int linewb, @Cast("l_uint32") int colorba, @Cast("l_uint32") int colorb, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIXA pixaDisplayBoxaa( PIXA pixas, BOXAA baa, @Cast("l_int32") int colorflag, @Cast("l_int32") int width );
public static native BOXA pixSplitIntoBoxa( PIX pixs, @Cast("l_int32") int minsum, @Cast("l_int32") int skipdist, @Cast("l_int32") int delta, @Cast("l_int32") int maxbg, @Cast("l_int32") int maxcomps, @Cast("l_int32") int remainder );
public static native BOXA pixSplitComponentIntoBoxa( PIX pix, BOX box, @Cast("l_int32") int minsum, @Cast("l_int32") int skipdist, @Cast("l_int32") int delta, @Cast("l_int32") int maxbg, @Cast("l_int32") int maxcomps, @Cast("l_int32") int remainder );
public static native BOXA makeMosaicStrips( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int direction, @Cast("l_int32") int size );
public static native @Cast("l_ok") int boxaCompareRegions( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int areathresh, @Cast("l_int32*") IntPointer pnsame, @Cast("l_float32*") FloatPointer pdiffarea, @Cast("l_float32*") FloatPointer pdiffxor, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int boxaCompareRegions( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int areathresh, @Cast("l_int32*") IntPointer pnsame, @Cast("l_float32*") FloatPointer pdiffarea, @Cast("l_float32*") FloatPointer pdiffxor, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int boxaCompareRegions( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int areathresh, @Cast("l_int32*") IntBuffer pnsame, @Cast("l_float32*") FloatBuffer pdiffarea, @Cast("l_float32*") FloatBuffer pdiffxor, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int boxaCompareRegions( BOXA boxa1, BOXA boxa2, @Cast("l_int32") int areathresh, @Cast("l_int32*") int[] pnsame, @Cast("l_float32*") float[] pdiffarea, @Cast("l_float32*") float[] pdiffxor, @ByPtrPtr PIX ppixdb );
public static native BOX pixSelectLargeULComp( PIX pixs, @Cast("l_float32") float areaslop, @Cast("l_int32") int yslop, @Cast("l_int32") int connectivity );
public static native BOX boxaSelectLargeULBox( BOXA boxas, @Cast("l_float32") float areaslop, @Cast("l_int32") int yslop );
public static native BOXA boxaSelectRange( BOXA boxas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int copyflag );
public static native BOXAA boxaaSelectRange( BOXAA baas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int copyflag );
public static native BOXA boxaSelectBySize( BOXA boxas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntPointer pchanged );
public static native BOXA boxaSelectBySize( BOXA boxas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntBuffer pchanged );
public static native BOXA boxaSelectBySize( BOXA boxas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") int[] pchanged );
public static native NUMA boxaMakeSizeIndicator( BOXA boxa, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation );
public static native BOXA boxaSelectByArea( BOXA boxas, @Cast("l_int32") int area, @Cast("l_int32") int relation, @Cast("l_int32*") IntPointer pchanged );
public static native BOXA boxaSelectByArea( BOXA boxas, @Cast("l_int32") int area, @Cast("l_int32") int relation, @Cast("l_int32*") IntBuffer pchanged );
public static native BOXA boxaSelectByArea( BOXA boxas, @Cast("l_int32") int area, @Cast("l_int32") int relation, @Cast("l_int32*") int[] pchanged );
public static native NUMA boxaMakeAreaIndicator( BOXA boxa, @Cast("l_int32") int area, @Cast("l_int32") int relation );
public static native BOXA boxaSelectByWHRatio( BOXA boxas, @Cast("l_float32") float ratio, @Cast("l_int32") int relation, @Cast("l_int32*") IntPointer pchanged );
public static native BOXA boxaSelectByWHRatio( BOXA boxas, @Cast("l_float32") float ratio, @Cast("l_int32") int relation, @Cast("l_int32*") IntBuffer pchanged );
public static native BOXA boxaSelectByWHRatio( BOXA boxas, @Cast("l_float32") float ratio, @Cast("l_int32") int relation, @Cast("l_int32*") int[] pchanged );
public static native NUMA boxaMakeWHRatioIndicator( BOXA boxa, @Cast("l_float32") float ratio, @Cast("l_int32") int relation );
public static native BOXA boxaSelectWithIndicator( BOXA boxas, NUMA na, @Cast("l_int32*") IntPointer pchanged );
public static native BOXA boxaSelectWithIndicator( BOXA boxas, NUMA na, @Cast("l_int32*") IntBuffer pchanged );
public static native BOXA boxaSelectWithIndicator( BOXA boxas, NUMA na, @Cast("l_int32*") int[] pchanged );
public static native BOXA boxaPermutePseudorandom( BOXA boxas );
public static native BOXA boxaPermuteRandom( BOXA boxad, BOXA boxas );
public static native @Cast("l_ok") int boxaSwapBoxes( BOXA boxa, @Cast("l_int32") int i, @Cast("l_int32") int j );
public static native PTA boxaConvertToPta( BOXA boxa, @Cast("l_int32") int ncorners );
public static native BOXA ptaConvertToBoxa( PTA pta, @Cast("l_int32") int ncorners );
public static native PTA boxConvertToPta( BOX box, @Cast("l_int32") int ncorners );
public static native BOX ptaConvertToBox( PTA pta );
public static native @Cast("l_ok") int boxaGetExtent( BOXA boxa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("BOX**") PointerPointer pbox );
public static native @Cast("l_ok") int boxaGetExtent( BOXA boxa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int boxaGetExtent( BOXA boxa, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int boxaGetExtent( BOXA boxa, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int boxaGetCoverage( BOXA boxa, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int exactflag, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int boxaGetCoverage( BOXA boxa, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int exactflag, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int boxaGetCoverage( BOXA boxa, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int exactflag, @Cast("l_float32*") float[] pfract );
public static native @Cast("l_ok") int boxaaSizeRange( BOXAA baa, @Cast("l_int32*") IntPointer pminw, @Cast("l_int32*") IntPointer pminh, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int boxaaSizeRange( BOXAA baa, @Cast("l_int32*") IntBuffer pminw, @Cast("l_int32*") IntBuffer pminh, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int boxaaSizeRange( BOXAA baa, @Cast("l_int32*") int[] pminw, @Cast("l_int32*") int[] pminh, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native @Cast("l_ok") int boxaSizeRange( BOXA boxa, @Cast("l_int32*") IntPointer pminw, @Cast("l_int32*") IntPointer pminh, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int boxaSizeRange( BOXA boxa, @Cast("l_int32*") IntBuffer pminw, @Cast("l_int32*") IntBuffer pminh, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int boxaSizeRange( BOXA boxa, @Cast("l_int32*") int[] pminw, @Cast("l_int32*") int[] pminh, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native @Cast("l_ok") int boxaLocationRange( BOXA boxa, @Cast("l_int32*") IntPointer pminx, @Cast("l_int32*") IntPointer pminy, @Cast("l_int32*") IntPointer pmaxx, @Cast("l_int32*") IntPointer pmaxy );
public static native @Cast("l_ok") int boxaLocationRange( BOXA boxa, @Cast("l_int32*") IntBuffer pminx, @Cast("l_int32*") IntBuffer pminy, @Cast("l_int32*") IntBuffer pmaxx, @Cast("l_int32*") IntBuffer pmaxy );
public static native @Cast("l_ok") int boxaLocationRange( BOXA boxa, @Cast("l_int32*") int[] pminx, @Cast("l_int32*") int[] pminy, @Cast("l_int32*") int[] pmaxx, @Cast("l_int32*") int[] pmaxy );
public static native @Cast("l_ok") int boxaGetSizes( BOXA boxa, @Cast("NUMA**") PointerPointer pnaw, @Cast("NUMA**") PointerPointer pnah );
public static native @Cast("l_ok") int boxaGetSizes( BOXA boxa, @ByPtrPtr NUMA pnaw, @ByPtrPtr NUMA pnah );
public static native @Cast("l_ok") int boxaGetArea( BOXA boxa, @Cast("l_int32*") IntPointer parea );
public static native @Cast("l_ok") int boxaGetArea( BOXA boxa, @Cast("l_int32*") IntBuffer parea );
public static native @Cast("l_ok") int boxaGetArea( BOXA boxa, @Cast("l_int32*") int[] parea );
public static native PIX boxaDisplayTiled( BOXA boxas, PIXA pixa, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int maxwidth, @Cast("l_int32") int linewidth, @Cast("l_float32") float scalefactor, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native BOXA boxaSmoothSequenceMedian( BOXA boxas, @Cast("l_int32") int halfwin, @Cast("l_int32") int subflag, @Cast("l_int32") int maxdiff, @Cast("l_int32") int extrapixels, @Cast("l_int32") int debug );
public static native BOXA boxaWindowedMedian( BOXA boxas, @Cast("l_int32") int halfwin, @Cast("l_int32") int debug );
public static native BOXA boxaModifyWithBoxa( BOXA boxas, BOXA boxam, @Cast("l_int32") int subflag, @Cast("l_int32") int maxdiff, @Cast("l_int32") int extrapixels );
public static native BOXA boxaReconcilePairWidth( BOXA boxas, @Cast("l_int32") int delw, @Cast("l_int32") int op, @Cast("l_float32") float factor, NUMA na );
public static native @Cast("l_ok") int boxaSizeConsistency( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float threshp, @Cast("l_float32") float threshm, @Cast("l_float32*") FloatPointer pfvarp, @Cast("l_float32*") FloatPointer pfvarm, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int boxaSizeConsistency( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float threshp, @Cast("l_float32") float threshm, @Cast("l_float32*") FloatBuffer pfvarp, @Cast("l_float32*") FloatBuffer pfvarm, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int boxaSizeConsistency( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float threshp, @Cast("l_float32") float threshm, @Cast("l_float32*") float[] pfvarp, @Cast("l_float32*") float[] pfvarm, @Cast("l_int32*") int[] psame );
public static native BOXA boxaReconcileAllByMedian( BOXA boxas, @Cast("l_int32") int select1, @Cast("l_int32") int select2, @Cast("l_int32") int thresh, @Cast("l_int32") int extra, PIXA pixadb );
public static native BOXA boxaReconcileSidesByMedian( BOXA boxas, @Cast("l_int32") int select, @Cast("l_int32") int thresh, @Cast("l_int32") int extra, PIXA pixadb );
public static native BOXA boxaReconcileSizeByMedian( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float dfract, @Cast("l_float32") float sfract, @Cast("l_float32") float factor, @Cast("NUMA**") PointerPointer pnadelw, @Cast("NUMA**") PointerPointer pnadelh, @Cast("l_float32*") FloatPointer pratiowh );
public static native BOXA boxaReconcileSizeByMedian( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float dfract, @Cast("l_float32") float sfract, @Cast("l_float32") float factor, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh, @Cast("l_float32*") FloatPointer pratiowh );
public static native BOXA boxaReconcileSizeByMedian( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float dfract, @Cast("l_float32") float sfract, @Cast("l_float32") float factor, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh, @Cast("l_float32*") FloatBuffer pratiowh );
public static native BOXA boxaReconcileSizeByMedian( BOXA boxas, @Cast("l_int32") int type, @Cast("l_float32") float dfract, @Cast("l_float32") float sfract, @Cast("l_float32") float factor, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh, @Cast("l_float32*") float[] pratiowh );
public static native @Cast("l_ok") int boxaPlotSides( BOXA boxa, @Cast("const char*") BytePointer plotname, @Cast("NUMA**") PointerPointer pnal, @Cast("NUMA**") PointerPointer pnat, @Cast("NUMA**") PointerPointer pnar, @Cast("NUMA**") PointerPointer pnab, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int boxaPlotSides( BOXA boxa, @Cast("const char*") BytePointer plotname, @ByPtrPtr NUMA pnal, @ByPtrPtr NUMA pnat, @ByPtrPtr NUMA pnar, @ByPtrPtr NUMA pnab, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int boxaPlotSides( BOXA boxa, String plotname, @ByPtrPtr NUMA pnal, @ByPtrPtr NUMA pnat, @ByPtrPtr NUMA pnar, @ByPtrPtr NUMA pnab, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int boxaPlotSizes( BOXA boxa, @Cast("const char*") BytePointer plotname, @Cast("NUMA**") PointerPointer pnaw, @Cast("NUMA**") PointerPointer pnah, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int boxaPlotSizes( BOXA boxa, @Cast("const char*") BytePointer plotname, @ByPtrPtr NUMA pnaw, @ByPtrPtr NUMA pnah, @ByPtrPtr PIX ppixd );
public static native @Cast("l_ok") int boxaPlotSizes( BOXA boxa, String plotname, @ByPtrPtr NUMA pnaw, @ByPtrPtr NUMA pnah, @ByPtrPtr PIX ppixd );
public static native BOXA boxaFillSequence( BOXA boxas, @Cast("l_int32") int useflag, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int boxaSizeVariation( BOXA boxa, @Cast("l_int32") int type, @Cast("l_float32*") FloatPointer pdel_evenodd, @Cast("l_float32*") FloatPointer prms_even, @Cast("l_float32*") FloatPointer prms_odd, @Cast("l_float32*") FloatPointer prms_all );
public static native @Cast("l_ok") int boxaSizeVariation( BOXA boxa, @Cast("l_int32") int type, @Cast("l_float32*") FloatBuffer pdel_evenodd, @Cast("l_float32*") FloatBuffer prms_even, @Cast("l_float32*") FloatBuffer prms_odd, @Cast("l_float32*") FloatBuffer prms_all );
public static native @Cast("l_ok") int boxaSizeVariation( BOXA boxa, @Cast("l_int32") int type, @Cast("l_float32*") float[] pdel_evenodd, @Cast("l_float32*") float[] prms_even, @Cast("l_float32*") float[] prms_odd, @Cast("l_float32*") float[] prms_all );
public static native @Cast("l_ok") int boxaMedianDimensions( BOXA boxas, @Cast("l_int32*") IntPointer pmedw, @Cast("l_int32*") IntPointer pmedh, @Cast("l_int32*") IntPointer pmedwe, @Cast("l_int32*") IntPointer pmedwo, @Cast("l_int32*") IntPointer pmedhe, @Cast("l_int32*") IntPointer pmedho, @Cast("NUMA**") PointerPointer pnadelw, @Cast("NUMA**") PointerPointer pnadelh );
public static native @Cast("l_ok") int boxaMedianDimensions( BOXA boxas, @Cast("l_int32*") IntPointer pmedw, @Cast("l_int32*") IntPointer pmedh, @Cast("l_int32*") IntPointer pmedwe, @Cast("l_int32*") IntPointer pmedwo, @Cast("l_int32*") IntPointer pmedhe, @Cast("l_int32*") IntPointer pmedho, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh );
public static native @Cast("l_ok") int boxaMedianDimensions( BOXA boxas, @Cast("l_int32*") IntBuffer pmedw, @Cast("l_int32*") IntBuffer pmedh, @Cast("l_int32*") IntBuffer pmedwe, @Cast("l_int32*") IntBuffer pmedwo, @Cast("l_int32*") IntBuffer pmedhe, @Cast("l_int32*") IntBuffer pmedho, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh );
public static native @Cast("l_ok") int boxaMedianDimensions( BOXA boxas, @Cast("l_int32*") int[] pmedw, @Cast("l_int32*") int[] pmedh, @Cast("l_int32*") int[] pmedwe, @Cast("l_int32*") int[] pmedwo, @Cast("l_int32*") int[] pmedhe, @Cast("l_int32*") int[] pmedho, @ByPtrPtr NUMA pnadelw, @ByPtrPtr NUMA pnadelh );
public static native L_BYTEA l_byteaCreate( @Cast("size_t") long nbytes );
public static native L_BYTEA l_byteaInitFromMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_BYTEA l_byteaInitFromMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_BYTEA l_byteaInitFromMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native L_BYTEA l_byteaInitFromFile( @Cast("const char*") BytePointer fname );
public static native L_BYTEA l_byteaInitFromFile( String fname );
public static native L_BYTEA l_byteaInitFromStream( @Cast("FILE*") Pointer fp );
public static native L_BYTEA l_byteaCopy( L_BYTEA bas, @Cast("l_int32") int copyflag );
public static native void l_byteaDestroy( @Cast("L_BYTEA**") PointerPointer pba );
public static native void l_byteaDestroy( @ByPtrPtr L_BYTEA pba );
public static native @Cast("size_t") long l_byteaGetSize( L_BYTEA ba );
public static native @Cast("l_uint8*") BytePointer l_byteaGetData( L_BYTEA ba, @Cast("size_t*") SizeTPointer psize );
public static native @Cast("l_uint8*") BytePointer l_byteaCopyData( L_BYTEA ba, @Cast("size_t*") SizeTPointer psize );
public static native @Cast("l_ok") int l_byteaAppendData( L_BYTEA ba, @Cast("const l_uint8*") BytePointer newdata, @Cast("size_t") long newbytes );
public static native @Cast("l_ok") int l_byteaAppendData( L_BYTEA ba, @Cast("const l_uint8*") ByteBuffer newdata, @Cast("size_t") long newbytes );
public static native @Cast("l_ok") int l_byteaAppendData( L_BYTEA ba, @Cast("const l_uint8*") byte[] newdata, @Cast("size_t") long newbytes );
public static native @Cast("l_ok") int l_byteaAppendString( L_BYTEA ba, @Cast("const char*") BytePointer str );
public static native @Cast("l_ok") int l_byteaAppendString( L_BYTEA ba, String str );
public static native @Cast("l_ok") int l_byteaJoin( L_BYTEA ba1, @Cast("L_BYTEA**") PointerPointer pba2 );
public static native @Cast("l_ok") int l_byteaJoin( L_BYTEA ba1, @ByPtrPtr L_BYTEA pba2 );
public static native @Cast("l_ok") int l_byteaSplit( L_BYTEA ba1, @Cast("size_t") long splitloc, @Cast("L_BYTEA**") PointerPointer pba2 );
public static native @Cast("l_ok") int l_byteaSplit( L_BYTEA ba1, @Cast("size_t") long splitloc, @ByPtrPtr L_BYTEA pba2 );
public static native @Cast("l_ok") int l_byteaFindEachSequence( L_BYTEA ba, @Cast("const l_uint8*") BytePointer sequence, @Cast("size_t") long seqlen, @Cast("L_DNA**") PointerPointer pda );
public static native @Cast("l_ok") int l_byteaFindEachSequence( L_BYTEA ba, @Cast("const l_uint8*") BytePointer sequence, @Cast("size_t") long seqlen, @ByPtrPtr L_DNA pda );
public static native @Cast("l_ok") int l_byteaFindEachSequence( L_BYTEA ba, @Cast("const l_uint8*") ByteBuffer sequence, @Cast("size_t") long seqlen, @ByPtrPtr L_DNA pda );
public static native @Cast("l_ok") int l_byteaFindEachSequence( L_BYTEA ba, @Cast("const l_uint8*") byte[] sequence, @Cast("size_t") long seqlen, @ByPtrPtr L_DNA pda );
public static native @Cast("l_ok") int l_byteaWrite( @Cast("const char*") BytePointer fname, L_BYTEA ba, @Cast("size_t") long startloc, @Cast("size_t") long nbytes );
public static native @Cast("l_ok") int l_byteaWrite( String fname, L_BYTEA ba, @Cast("size_t") long startloc, @Cast("size_t") long nbytes );
public static native @Cast("l_ok") int l_byteaWriteStream( @Cast("FILE*") Pointer fp, L_BYTEA ba, @Cast("size_t") long startloc, @Cast("size_t") long nbytes );
public static native CCBORDA ccbaCreate( PIX pixs, @Cast("l_int32") int n );
public static native void ccbaDestroy( @Cast("CCBORDA**") PointerPointer pccba );
public static native void ccbaDestroy( @ByPtrPtr CCBORDA pccba );
public static native CCBORD ccbCreate( PIX pixs );
public static native void ccbDestroy( @Cast("CCBORD**") PointerPointer pccb );
public static native void ccbDestroy( @ByPtrPtr CCBORD pccb );
public static native @Cast("l_ok") int ccbaAddCcb( CCBORDA ccba, CCBORD ccb );
public static native @Cast("l_int32") int ccbaGetCount( CCBORDA ccba );
public static native CCBORD ccbaGetCcb( CCBORDA ccba, @Cast("l_int32") int index );
public static native CCBORDA pixGetAllCCBorders( PIX pixs );
public static native PTAA pixGetOuterBordersPtaa( PIX pixs );
public static native @Cast("l_ok") int pixGetOuterBorder( CCBORD ccb, PIX pixs, BOX box );
public static native @Cast("l_ok") int ccbaGenerateGlobalLocs( CCBORDA ccba );
public static native @Cast("l_ok") int ccbaGenerateStepChains( CCBORDA ccba );
public static native @Cast("l_ok") int ccbaStepChainsToPixCoords( CCBORDA ccba, @Cast("l_int32") int coordtype );
public static native @Cast("l_ok") int ccbaGenerateSPGlobalLocs( CCBORDA ccba, @Cast("l_int32") int ptsflag );
public static native @Cast("l_ok") int ccbaGenerateSinglePath( CCBORDA ccba );
public static native PTA getCutPathForHole( PIX pix, PTA pta, BOX boxinner, @Cast("l_int32*") IntPointer pdir, @Cast("l_int32*") IntPointer plen );
public static native PTA getCutPathForHole( PIX pix, PTA pta, BOX boxinner, @Cast("l_int32*") IntBuffer pdir, @Cast("l_int32*") IntBuffer plen );
public static native PTA getCutPathForHole( PIX pix, PTA pta, BOX boxinner, @Cast("l_int32*") int[] pdir, @Cast("l_int32*") int[] plen );
public static native PIX ccbaDisplayBorder( CCBORDA ccba );
public static native PIX ccbaDisplaySPBorder( CCBORDA ccba );
public static native PIX ccbaDisplayImage1( CCBORDA ccba );
public static native PIX ccbaDisplayImage2( CCBORDA ccba );
public static native @Cast("l_ok") int ccbaWrite( @Cast("const char*") BytePointer filename, CCBORDA ccba );
public static native @Cast("l_ok") int ccbaWrite( String filename, CCBORDA ccba );
public static native @Cast("l_ok") int ccbaWriteStream( @Cast("FILE*") Pointer fp, CCBORDA ccba );
public static native CCBORDA ccbaRead( @Cast("const char*") BytePointer filename );
public static native CCBORDA ccbaRead( String filename );
public static native CCBORDA ccbaReadStream( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int ccbaWriteSVG( @Cast("const char*") BytePointer filename, CCBORDA ccba );
public static native @Cast("l_ok") int ccbaWriteSVG( String filename, CCBORDA ccba );
public static native @Cast("char*") BytePointer ccbaWriteSVGString( CCBORDA ccba );
public static native PIXA pixaThinConnected( PIXA pixas, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @Cast("l_int32") int maxiters );
public static native PIX pixThinConnected( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @Cast("l_int32") int maxiters );
public static native PIX pixThinConnectedBySet( PIX pixs, @Cast("l_int32") int type, SELA sela, @Cast("l_int32") int maxiters );
public static native SELA selaMakeThinSets( @Cast("l_int32") int index, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixFindCheckerboardCorners( PIX pixs, @Cast("l_int32") int size, @Cast("l_int32") int dilation, @Cast("l_int32") int nsels, @Cast("PIX**") PointerPointer ppix_corners, @Cast("PTA**") PointerPointer ppta_corners, PIXA pixadb );
public static native @Cast("l_ok") int pixFindCheckerboardCorners( PIX pixs, @Cast("l_int32") int size, @Cast("l_int32") int dilation, @Cast("l_int32") int nsels, @ByPtrPtr PIX ppix_corners, @ByPtrPtr PTA ppta_corners, PIXA pixadb );
public static native @Cast("l_ok") int jbCorrelation( @Cast("const char*") BytePointer dirin, @Cast("l_float32") float thresh, @Cast("l_float32") float weight, @Cast("l_int32") int components, @Cast("const char*") BytePointer rootname, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, @Cast("l_int32") int renderflag );
public static native @Cast("l_ok") int jbCorrelation( String dirin, @Cast("l_float32") float thresh, @Cast("l_float32") float weight, @Cast("l_int32") int components, String rootname, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, @Cast("l_int32") int renderflag );
public static native @Cast("l_ok") int jbRankHaus( @Cast("const char*") BytePointer dirin, @Cast("l_int32") int size, @Cast("l_float32") float rank, @Cast("l_int32") int components, @Cast("const char*") BytePointer rootname, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, @Cast("l_int32") int renderflag );
public static native @Cast("l_ok") int jbRankHaus( String dirin, @Cast("l_int32") int size, @Cast("l_float32") float rank, @Cast("l_int32") int components, String rootname, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, @Cast("l_int32") int renderflag );
public static native JBCLASSER jbWordsInTextlines( @Cast("const char*") BytePointer dirin, @Cast("l_int32") int reduction, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_float32") float thresh, @Cast("l_float32") float weight, @Cast("NUMA**") PointerPointer pnatl, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages );
public static native JBCLASSER jbWordsInTextlines( @Cast("const char*") BytePointer dirin, @Cast("l_int32") int reduction, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_float32") float thresh, @Cast("l_float32") float weight, @ByPtrPtr NUMA pnatl, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages );
public static native JBCLASSER jbWordsInTextlines( String dirin, @Cast("l_int32") int reduction, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_float32") float thresh, @Cast("l_float32") float weight, @ByPtrPtr NUMA pnatl, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages );
public static native @Cast("l_ok") int pixGetWordsInTextlines( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("BOXA**") PointerPointer pboxad, @Cast("PIXA**") PointerPointer ppixad, @Cast("NUMA**") PointerPointer pnai );
public static native @Cast("l_ok") int pixGetWordsInTextlines( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxad, @ByPtrPtr PIXA ppixad, @ByPtrPtr NUMA pnai );
public static native @Cast("l_ok") int pixGetWordBoxesInTextlines( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("BOXA**") PointerPointer pboxad, @Cast("NUMA**") PointerPointer pnai );
public static native @Cast("l_ok") int pixGetWordBoxesInTextlines( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxad, @ByPtrPtr NUMA pnai );
public static native @Cast("l_ok") int pixFindWordAndCharacterBoxes( PIX pixs, BOX boxs, @Cast("l_int32") int thresh, @Cast("BOXA**") PointerPointer pboxaw, @Cast("BOXAA**") PointerPointer pboxaac, @Cast("const char*") BytePointer debugdir );
public static native @Cast("l_ok") int pixFindWordAndCharacterBoxes( PIX pixs, BOX boxs, @Cast("l_int32") int thresh, @ByPtrPtr BOXA pboxaw, @ByPtrPtr BOXAA pboxaac, @Cast("const char*") BytePointer debugdir );
public static native @Cast("l_ok") int pixFindWordAndCharacterBoxes( PIX pixs, BOX boxs, @Cast("l_int32") int thresh, @ByPtrPtr BOXA pboxaw, @ByPtrPtr BOXAA pboxaac, String debugdir );
public static native NUMAA boxaExtractSortedPattern( BOXA boxa, NUMA na );
public static native @Cast("l_ok") int numaaCompareImagesByBoxes( NUMAA naa1, NUMAA naa2, @Cast("l_int32") int nperline, @Cast("l_int32") int nreq, @Cast("l_int32") int maxshiftx, @Cast("l_int32") int maxshifty, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") IntPointer psame, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int numaaCompareImagesByBoxes( NUMAA naa1, NUMAA naa2, @Cast("l_int32") int nperline, @Cast("l_int32") int nreq, @Cast("l_int32") int maxshiftx, @Cast("l_int32") int maxshifty, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") IntBuffer psame, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int numaaCompareImagesByBoxes( NUMAA naa1, NUMAA naa2, @Cast("l_int32") int nperline, @Cast("l_int32") int nreq, @Cast("l_int32") int maxshiftx, @Cast("l_int32") int maxshifty, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") int[] psame, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixColorContent( PIX pixs, @Cast("l_int32") int rref, @Cast("l_int32") int gref, @Cast("l_int32") int bref, @Cast("l_int32") int mingray, @Cast("PIX**") PointerPointer ppixr, @Cast("PIX**") PointerPointer ppixg, @Cast("PIX**") PointerPointer ppixb );
public static native @Cast("l_ok") int pixColorContent( PIX pixs, @Cast("l_int32") int rref, @Cast("l_int32") int gref, @Cast("l_int32") int bref, @Cast("l_int32") int mingray, @ByPtrPtr PIX ppixr, @ByPtrPtr PIX ppixg, @ByPtrPtr PIX ppixb );
public static native PIX pixColorMagnitude( PIX pixs, @Cast("l_int32") int rref, @Cast("l_int32") int gref, @Cast("l_int32") int bref, @Cast("l_int32") int type );
public static native @Cast("l_ok") int pixColorFraction( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh, @Cast("l_int32") int factor, @Cast("l_float32*") FloatPointer ppixfract, @Cast("l_float32*") FloatPointer pcolorfract );
public static native @Cast("l_ok") int pixColorFraction( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh, @Cast("l_int32") int factor, @Cast("l_float32*") FloatBuffer ppixfract, @Cast("l_float32*") FloatBuffer pcolorfract );
public static native @Cast("l_ok") int pixColorFraction( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh, @Cast("l_int32") int factor, @Cast("l_float32*") float[] ppixfract, @Cast("l_float32*") float[] pcolorfract );
public static native PIX pixColorShiftWhitePoint( PIX pixs, @Cast("l_int32") int rref, @Cast("l_int32") int gref, @Cast("l_int32") int bref );
public static native PIX pixMaskOverColorPixels( PIX pixs, @Cast("l_int32") int threshdiff, @Cast("l_int32") int mindist );
public static native PIX pixMaskOverGrayPixels( PIX pixs, @Cast("l_int32") int maxlimit, @Cast("l_int32") int satlimit );
public static native PIX pixMaskOverColorRange( PIX pixs, @Cast("l_int32") int rmin, @Cast("l_int32") int rmax, @Cast("l_int32") int gmin, @Cast("l_int32") int gmax, @Cast("l_int32") int bmin, @Cast("l_int32") int bmax );
public static native @Cast("l_ok") int pixFindColorRegions( PIX pixs, PIX pixm, @Cast("l_int32") int factor, @Cast("l_int32") int lightthresh, @Cast("l_int32") int darkthresh, @Cast("l_int32") int mindiff, @Cast("l_int32") int colordiff, @Cast("l_float32") float edgefract, @Cast("l_float32*") FloatPointer pcolorfract, @Cast("PIX**") PointerPointer pcolormask1, @Cast("PIX**") PointerPointer pcolormask2, PIXA pixadb );
public static native @Cast("l_ok") int pixFindColorRegions( PIX pixs, PIX pixm, @Cast("l_int32") int factor, @Cast("l_int32") int lightthresh, @Cast("l_int32") int darkthresh, @Cast("l_int32") int mindiff, @Cast("l_int32") int colordiff, @Cast("l_float32") float edgefract, @Cast("l_float32*") FloatPointer pcolorfract, @ByPtrPtr PIX pcolormask1, @ByPtrPtr PIX pcolormask2, PIXA pixadb );
public static native @Cast("l_ok") int pixFindColorRegions( PIX pixs, PIX pixm, @Cast("l_int32") int factor, @Cast("l_int32") int lightthresh, @Cast("l_int32") int darkthresh, @Cast("l_int32") int mindiff, @Cast("l_int32") int colordiff, @Cast("l_float32") float edgefract, @Cast("l_float32*") FloatBuffer pcolorfract, @ByPtrPtr PIX pcolormask1, @ByPtrPtr PIX pcolormask2, PIXA pixadb );
public static native @Cast("l_ok") int pixFindColorRegions( PIX pixs, PIX pixm, @Cast("l_int32") int factor, @Cast("l_int32") int lightthresh, @Cast("l_int32") int darkthresh, @Cast("l_int32") int mindiff, @Cast("l_int32") int colordiff, @Cast("l_float32") float edgefract, @Cast("l_float32*") float[] pcolorfract, @ByPtrPtr PIX pcolormask1, @ByPtrPtr PIX pcolormask2, PIXA pixadb );
public static native @Cast("l_ok") int pixNumSignificantGrayColors( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_float32") float minfract, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixNumSignificantGrayColors( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_float32") float minfract, @Cast("l_int32") int factor, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixNumSignificantGrayColors( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_float32") float minfract, @Cast("l_int32") int factor, @Cast("l_int32*") int[] pncolors );
public static native @Cast("l_ok") int pixColorsForQuantization( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") IntPointer pncolors, @Cast("l_int32*") IntPointer piscolor, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixColorsForQuantization( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") IntBuffer pncolors, @Cast("l_int32*") IntBuffer piscolor, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixColorsForQuantization( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") int[] pncolors, @Cast("l_int32*") int[] piscolor, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixNumColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixNumColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixNumColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") int[] pncolors );
public static native PIX pixConvertRGBToCmapLossless( PIX pixs );
public static native @Cast("l_ok") int pixGetMostPopulatedColors( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor, @Cast("l_int32") int ncolors, @Cast("l_uint32**") PointerPointer parray, @Cast("PIXCMAP**") PointerPointer pcmap );
public static native @Cast("l_ok") int pixGetMostPopulatedColors( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor, @Cast("l_int32") int ncolors, @Cast("l_uint32**") @ByPtrPtr IntPointer parray, @ByPtrPtr PIXCMAP pcmap );
public static native @Cast("l_ok") int pixGetMostPopulatedColors( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor, @Cast("l_int32") int ncolors, @Cast("l_uint32**") @ByPtrPtr IntBuffer parray, @ByPtrPtr PIXCMAP pcmap );
public static native @Cast("l_ok") int pixGetMostPopulatedColors( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor, @Cast("l_int32") int ncolors, @Cast("l_uint32**") @ByPtrPtr int[] parray, @ByPtrPtr PIXCMAP pcmap );
public static native PIX pixSimpleColorQuantize( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor, @Cast("l_int32") int ncolors );
public static native NUMA pixGetRGBHistogram( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int factor );
public static native @Cast("l_ok") int makeRGBIndexTables( @Cast("l_uint32**") PointerPointer prtab, @Cast("l_uint32**") PointerPointer pgtab, @Cast("l_uint32**") PointerPointer pbtab, @Cast("l_int32") int sigbits );
public static native @Cast("l_ok") int makeRGBIndexTables( @Cast("l_uint32**") @ByPtrPtr IntPointer prtab, @Cast("l_uint32**") @ByPtrPtr IntPointer pgtab, @Cast("l_uint32**") @ByPtrPtr IntPointer pbtab, @Cast("l_int32") int sigbits );
public static native @Cast("l_ok") int makeRGBIndexTables( @Cast("l_uint32**") @ByPtrPtr IntBuffer prtab, @Cast("l_uint32**") @ByPtrPtr IntBuffer pgtab, @Cast("l_uint32**") @ByPtrPtr IntBuffer pbtab, @Cast("l_int32") int sigbits );
public static native @Cast("l_ok") int makeRGBIndexTables( @Cast("l_uint32**") @ByPtrPtr int[] prtab, @Cast("l_uint32**") @ByPtrPtr int[] pgtab, @Cast("l_uint32**") @ByPtrPtr int[] pbtab, @Cast("l_int32") int sigbits );
public static native @Cast("l_ok") int getRGBFromIndex( @Cast("l_uint32") int index, @Cast("l_int32") int sigbits, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int getRGBFromIndex( @Cast("l_uint32") int index, @Cast("l_int32") int sigbits, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int getRGBFromIndex( @Cast("l_uint32") int index, @Cast("l_int32") int sigbits, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native @Cast("l_ok") int pixHasHighlightRed( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float minfract, @Cast("l_float32") float fthresh, @Cast("l_int32*") IntPointer phasred, @Cast("l_float32*") FloatPointer pratio, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int pixHasHighlightRed( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float minfract, @Cast("l_float32") float fthresh, @Cast("l_int32*") IntPointer phasred, @Cast("l_float32*") FloatPointer pratio, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixHasHighlightRed( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float minfract, @Cast("l_float32") float fthresh, @Cast("l_int32*") IntBuffer phasred, @Cast("l_float32*") FloatBuffer pratio, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixHasHighlightRed( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float minfract, @Cast("l_float32") float fthresh, @Cast("l_int32*") int[] phasred, @Cast("l_float32*") float[] pratio, @ByPtrPtr PIX ppixdb );
public static native L_COLORFILL l_colorfillCreate( PIX pixs, @Cast("l_int32") int nx, @Cast("l_int32") int ny );
public static native void l_colorfillDestroy( @Cast("L_COLORFILL**") PointerPointer pcf );
public static native void l_colorfillDestroy( @ByPtrPtr L_COLORFILL pcf );
public static native @Cast("l_ok") int pixColorContentByLocation( L_COLORFILL cf, @Cast("l_int32") int rref, @Cast("l_int32") int gref, @Cast("l_int32") int bref, @Cast("l_int32") int minmax, @Cast("l_int32") int maxdiff, @Cast("l_int32") int minarea, @Cast("l_int32") int smooth, @Cast("l_int32") int debug );
public static native PIX pixColorFill( PIX pixs, @Cast("l_int32") int minmax, @Cast("l_int32") int maxdiff, @Cast("l_int32") int smooth, @Cast("l_int32") int minarea, @Cast("l_int32") int debug );
public static native PIXA makeColorfillTestData( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int nseeds, @Cast("l_int32") int range );
public static native PIX pixColorGrayRegions( PIX pixs, BOXA boxa, @Cast("l_int32") int type, @Cast("l_int32") int thresh, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixColorGray( PIX pixs, BOX box, @Cast("l_int32") int type, @Cast("l_int32") int thresh, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native PIX pixColorGrayMasked( PIX pixs, PIX pixm, @Cast("l_int32") int type, @Cast("l_int32") int thresh, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native PIX pixSnapColor( PIX pixd, PIX pixs, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval, @Cast("l_int32") int diff );
public static native PIX pixSnapColorCmap( PIX pixd, PIX pixs, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval, @Cast("l_int32") int diff );
public static native PIX pixLinearMapToTargetColor( PIX pixd, PIX pixs, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval );
public static native @Cast("l_ok") int pixelLinearMapToTargetColor( @Cast("l_uint32") int scolor, @Cast("l_uint32") int srcmap, @Cast("l_uint32") int dstmap, @Cast("l_uint32*") IntPointer pdcolor );
public static native @Cast("l_ok") int pixelLinearMapToTargetColor( @Cast("l_uint32") int scolor, @Cast("l_uint32") int srcmap, @Cast("l_uint32") int dstmap, @Cast("l_uint32*") IntBuffer pdcolor );
public static native @Cast("l_ok") int pixelLinearMapToTargetColor( @Cast("l_uint32") int scolor, @Cast("l_uint32") int srcmap, @Cast("l_uint32") int dstmap, @Cast("l_uint32*") int[] pdcolor );
public static native PIX pixShiftByComponent( PIX pixd, PIX pixs, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval );
public static native @Cast("l_ok") int pixelShiftByComponent( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval, @Cast("l_uint32*") IntPointer ppixel );
public static native @Cast("l_ok") int pixelShiftByComponent( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval, @Cast("l_uint32*") IntBuffer ppixel );
public static native @Cast("l_ok") int pixelShiftByComponent( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval, @Cast("l_uint32*") int[] ppixel );
public static native @Cast("l_ok") int pixelFractionalShift( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32") float fract, @Cast("l_uint32*") IntPointer ppixel );
public static native @Cast("l_ok") int pixelFractionalShift( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32") float fract, @Cast("l_uint32*") IntBuffer ppixel );
public static native @Cast("l_ok") int pixelFractionalShift( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32") float fract, @Cast("l_uint32*") int[] ppixel );
public static native PIX pixMapWithInvariantHue( PIX pixd, PIX pixs, @Cast("l_uint32") int srcval, @Cast("l_float32") float fract );
public static native PIXCMAP pixcmapCreate( @Cast("l_int32") int depth );
public static native PIXCMAP pixcmapCreateRandom( @Cast("l_int32") int depth, @Cast("l_int32") int hasblack, @Cast("l_int32") int haswhite );
public static native PIXCMAP pixcmapCreateLinear( @Cast("l_int32") int d, @Cast("l_int32") int nlevels );
public static native PIXCMAP pixcmapCopy( @Const PIXCMAP cmaps );
public static native void pixcmapDestroy( @Cast("PIXCMAP**") PointerPointer pcmap );
public static native void pixcmapDestroy( @ByPtrPtr PIXCMAP pcmap );
public static native @Cast("l_ok") int pixcmapIsValid( @Const PIXCMAP cmap, PIX pix, @Cast("l_int32*") IntPointer pvalid );
public static native @Cast("l_ok") int pixcmapIsValid( @Const PIXCMAP cmap, PIX pix, @Cast("l_int32*") IntBuffer pvalid );
public static native @Cast("l_ok") int pixcmapIsValid( @Const PIXCMAP cmap, PIX pix, @Cast("l_int32*") int[] pvalid );
public static native @Cast("l_ok") int pixcmapAddColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixcmapAddRGBA( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int aval );
public static native @Cast("l_ok") int pixcmapAddNewColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapAddNewColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapAddNewColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapAddNearestColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapAddNearestColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapAddNearestColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapUsableColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pusable );
public static native @Cast("l_ok") int pixcmapUsableColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pusable );
public static native @Cast("l_ok") int pixcmapUsableColor( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pusable );
public static native @Cast("l_ok") int pixcmapAddBlackOrWhite( PIXCMAP cmap, @Cast("l_int32") int color, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapAddBlackOrWhite( PIXCMAP cmap, @Cast("l_int32") int color, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapAddBlackOrWhite( PIXCMAP cmap, @Cast("l_int32") int color, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapSetBlackAndWhite( PIXCMAP cmap, @Cast("l_int32") int setblack, @Cast("l_int32") int setwhite );
public static native @Cast("l_int32") int pixcmapGetCount( @Const PIXCMAP cmap );
public static native @Cast("l_int32") int pixcmapGetFreeCount( PIXCMAP cmap );
public static native @Cast("l_int32") int pixcmapGetDepth( PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapGetMinDepth( PIXCMAP cmap, @Cast("l_int32*") IntPointer pmindepth );
public static native @Cast("l_ok") int pixcmapGetMinDepth( PIXCMAP cmap, @Cast("l_int32*") IntBuffer pmindepth );
public static native @Cast("l_ok") int pixcmapGetMinDepth( PIXCMAP cmap, @Cast("l_int32*") int[] pmindepth );
public static native @Cast("l_ok") int pixcmapClear( PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapGetColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int pixcmapGetColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int pixcmapGetColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native @Cast("l_ok") int pixcmapGetColor32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") IntPointer pval32 );
public static native @Cast("l_ok") int pixcmapGetColor32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") IntBuffer pval32 );
public static native @Cast("l_ok") int pixcmapGetColor32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") int[] pval32 );
public static native @Cast("l_ok") int pixcmapGetRGBA( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval, @Cast("l_int32*") IntPointer paval );
public static native @Cast("l_ok") int pixcmapGetRGBA( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval, @Cast("l_int32*") IntBuffer paval );
public static native @Cast("l_ok") int pixcmapGetRGBA( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval, @Cast("l_int32*") int[] paval );
public static native @Cast("l_ok") int pixcmapGetRGBA32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") IntPointer pval32 );
public static native @Cast("l_ok") int pixcmapGetRGBA32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") IntBuffer pval32 );
public static native @Cast("l_ok") int pixcmapGetRGBA32( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_uint32*") int[] pval32 );
public static native @Cast("l_ok") int pixcmapResetColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixcmapSetAlpha( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32") int aval );
public static native @Cast("l_int32") int pixcmapGetIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_int32") int pixcmapGetIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_int32") int pixcmapGetIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapHasColor( PIXCMAP cmap, @Cast("l_int32*") IntPointer pcolor );
public static native @Cast("l_ok") int pixcmapHasColor( PIXCMAP cmap, @Cast("l_int32*") IntBuffer pcolor );
public static native @Cast("l_ok") int pixcmapHasColor( PIXCMAP cmap, @Cast("l_int32*") int[] pcolor );
public static native @Cast("l_ok") int pixcmapIsOpaque( PIXCMAP cmap, @Cast("l_int32*") IntPointer popaque );
public static native @Cast("l_ok") int pixcmapIsOpaque( PIXCMAP cmap, @Cast("l_int32*") IntBuffer popaque );
public static native @Cast("l_ok") int pixcmapIsOpaque( PIXCMAP cmap, @Cast("l_int32*") int[] popaque );
public static native @Cast("l_ok") int pixcmapNonOpaqueColorsInfo( PIXCMAP cmap, @Cast("l_int32*") IntPointer pntrans, @Cast("l_int32*") IntPointer pmax_trans, @Cast("l_int32*") IntPointer pmin_opaque );
public static native @Cast("l_ok") int pixcmapNonOpaqueColorsInfo( PIXCMAP cmap, @Cast("l_int32*") IntBuffer pntrans, @Cast("l_int32*") IntBuffer pmax_trans, @Cast("l_int32*") IntBuffer pmin_opaque );
public static native @Cast("l_ok") int pixcmapNonOpaqueColorsInfo( PIXCMAP cmap, @Cast("l_int32*") int[] pntrans, @Cast("l_int32*") int[] pmax_trans, @Cast("l_int32*") int[] pmin_opaque );
public static native @Cast("l_ok") int pixcmapIsBlackAndWhite( PIXCMAP cmap, @Cast("l_int32*") IntPointer pblackwhite );
public static native @Cast("l_ok") int pixcmapIsBlackAndWhite( PIXCMAP cmap, @Cast("l_int32*") IntBuffer pblackwhite );
public static native @Cast("l_ok") int pixcmapIsBlackAndWhite( PIXCMAP cmap, @Cast("l_int32*") int[] pblackwhite );
public static native @Cast("l_ok") int pixcmapCountGrayColors( PIXCMAP cmap, @Cast("l_int32*") IntPointer pngray );
public static native @Cast("l_ok") int pixcmapCountGrayColors( PIXCMAP cmap, @Cast("l_int32*") IntBuffer pngray );
public static native @Cast("l_ok") int pixcmapCountGrayColors( PIXCMAP cmap, @Cast("l_int32*") int[] pngray );
public static native @Cast("l_ok") int pixcmapGetRankIntensity( PIXCMAP cmap, @Cast("l_float32") float rankval, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapGetRankIntensity( PIXCMAP cmap, @Cast("l_float32") float rankval, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapGetRankIntensity( PIXCMAP cmap, @Cast("l_float32") float rankval, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapGetNearestIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapGetNearestIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapGetNearestIndex( PIXCMAP cmap, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapGetNearestGrayIndex( PIXCMAP cmap, @Cast("l_int32") int val, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixcmapGetNearestGrayIndex( PIXCMAP cmap, @Cast("l_int32") int val, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixcmapGetNearestGrayIndex( PIXCMAP cmap, @Cast("l_int32") int val, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixcmapGetDistanceToColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pdist );
public static native @Cast("l_ok") int pixcmapGetDistanceToColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pdist );
public static native @Cast("l_ok") int pixcmapGetDistanceToColor( PIXCMAP cmap, @Cast("l_int32") int index, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pdist );
public static native @Cast("l_ok") int pixcmapGetRangeValues( PIXCMAP cmap, @Cast("l_int32") int select, @Cast("l_int32*") IntPointer pminval, @Cast("l_int32*") IntPointer pmaxval, @Cast("l_int32*") IntPointer pminindex, @Cast("l_int32*") IntPointer pmaxindex );
public static native @Cast("l_ok") int pixcmapGetRangeValues( PIXCMAP cmap, @Cast("l_int32") int select, @Cast("l_int32*") IntBuffer pminval, @Cast("l_int32*") IntBuffer pmaxval, @Cast("l_int32*") IntBuffer pminindex, @Cast("l_int32*") IntBuffer pmaxindex );
public static native @Cast("l_ok") int pixcmapGetRangeValues( PIXCMAP cmap, @Cast("l_int32") int select, @Cast("l_int32*") int[] pminval, @Cast("l_int32*") int[] pmaxval, @Cast("l_int32*") int[] pminindex, @Cast("l_int32*") int[] pmaxindex );
public static native PIXCMAP pixcmapGrayToFalseColor( @Cast("l_float32") float gamma );
public static native PIXCMAP pixcmapGrayToColor( @Cast("l_uint32") int color );
public static native PIXCMAP pixcmapColorToGray( PIXCMAP cmaps, @Cast("l_float32") float rwt, @Cast("l_float32") float gwt, @Cast("l_float32") float bwt );
public static native PIXCMAP pixcmapConvertTo4( PIXCMAP cmaps );
public static native PIXCMAP pixcmapConvertTo8( PIXCMAP cmaps );
public static native PIXCMAP pixcmapRead( @Cast("const char*") BytePointer filename );
public static native PIXCMAP pixcmapRead( String filename );
public static native PIXCMAP pixcmapReadStream( @Cast("FILE*") Pointer fp );
public static native PIXCMAP pixcmapReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIXCMAP pixcmapReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIXCMAP pixcmapReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixcmapWrite( @Cast("const char*") BytePointer filename, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWrite( String filename, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWriteStream( @Cast("FILE*") Pointer fp, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, @Const PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapToArrays( @Const PIXCMAP cmap, @Cast("l_int32**") PointerPointer prmap, @Cast("l_int32**") PointerPointer pgmap, @Cast("l_int32**") PointerPointer pbmap, @Cast("l_int32**") PointerPointer pamap );
public static native @Cast("l_ok") int pixcmapToArrays( @Const PIXCMAP cmap, @Cast("l_int32**") @ByPtrPtr IntPointer prmap, @Cast("l_int32**") @ByPtrPtr IntPointer pgmap, @Cast("l_int32**") @ByPtrPtr IntPointer pbmap, @Cast("l_int32**") @ByPtrPtr IntPointer pamap );
public static native @Cast("l_ok") int pixcmapToArrays( @Const PIXCMAP cmap, @Cast("l_int32**") @ByPtrPtr IntBuffer prmap, @Cast("l_int32**") @ByPtrPtr IntBuffer pgmap, @Cast("l_int32**") @ByPtrPtr IntBuffer pbmap, @Cast("l_int32**") @ByPtrPtr IntBuffer pamap );
public static native @Cast("l_ok") int pixcmapToArrays( @Const PIXCMAP cmap, @Cast("l_int32**") @ByPtrPtr int[] prmap, @Cast("l_int32**") @ByPtrPtr int[] pgmap, @Cast("l_int32**") @ByPtrPtr int[] pbmap, @Cast("l_int32**") @ByPtrPtr int[] pamap );
public static native @Cast("l_ok") int pixcmapToRGBTable( PIXCMAP cmap, @Cast("l_uint32**") PointerPointer ptab, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixcmapToRGBTable( PIXCMAP cmap, @Cast("l_uint32**") @ByPtrPtr IntPointer ptab, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixcmapToRGBTable( PIXCMAP cmap, @Cast("l_uint32**") @ByPtrPtr IntBuffer ptab, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixcmapToRGBTable( PIXCMAP cmap, @Cast("l_uint32**") @ByPtrPtr int[] ptab, @Cast("l_int32*") int[] pncolors );
public static native @Cast("l_ok") int pixcmapSerializeToMemory( PIXCMAP cmap, @Cast("l_int32") int cpc, @Cast("l_int32*") IntPointer pncolors, @Cast("l_uint8**") PointerPointer pdata );
public static native @Cast("l_ok") int pixcmapSerializeToMemory( PIXCMAP cmap, @Cast("l_int32") int cpc, @Cast("l_int32*") IntPointer pncolors, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata );
public static native @Cast("l_ok") int pixcmapSerializeToMemory( PIXCMAP cmap, @Cast("l_int32") int cpc, @Cast("l_int32*") IntBuffer pncolors, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata );
public static native @Cast("l_ok") int pixcmapSerializeToMemory( PIXCMAP cmap, @Cast("l_int32") int cpc, @Cast("l_int32*") int[] pncolors, @Cast("l_uint8**") @ByPtrPtr byte[] pdata );
public static native PIXCMAP pixcmapDeserializeFromMemory( @Cast("l_uint8*") BytePointer data, @Cast("l_int32") int cpc, @Cast("l_int32") int ncolors );
public static native PIXCMAP pixcmapDeserializeFromMemory( @Cast("l_uint8*") ByteBuffer data, @Cast("l_int32") int cpc, @Cast("l_int32") int ncolors );
public static native PIXCMAP pixcmapDeserializeFromMemory( @Cast("l_uint8*") byte[] data, @Cast("l_int32") int cpc, @Cast("l_int32") int ncolors );
public static native @Cast("char*") BytePointer pixcmapConvertToHex( @Cast("l_uint8*") BytePointer data, @Cast("l_int32") int ncolors );
public static native @Cast("char*") ByteBuffer pixcmapConvertToHex( @Cast("l_uint8*") ByteBuffer data, @Cast("l_int32") int ncolors );
public static native @Cast("char*") byte[] pixcmapConvertToHex( @Cast("l_uint8*") byte[] data, @Cast("l_int32") int ncolors );
public static native @Cast("l_ok") int pixcmapGammaTRC( PIXCMAP cmap, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native @Cast("l_ok") int pixcmapContrastTRC( PIXCMAP cmap, @Cast("l_float32") float factor );
public static native @Cast("l_ok") int pixcmapShiftIntensity( PIXCMAP cmap, @Cast("l_float32") float fraction );
public static native @Cast("l_ok") int pixcmapShiftByComponent( PIXCMAP cmap, @Cast("l_uint32") int srcval, @Cast("l_uint32") int dstval );
public static native PIX pixColorMorph( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOctreeColorQuant( PIX pixs, @Cast("l_int32") int colors, @Cast("l_int32") int ditherflag );
public static native PIX pixOctreeColorQuantGeneral( PIX pixs, @Cast("l_int32") int colors, @Cast("l_int32") int ditherflag, @Cast("l_float32") float validthresh, @Cast("l_float32") float colorthresh );
public static native @Cast("l_ok") int makeRGBToIndexTables( @Cast("l_int32") int cqlevels, @Cast("l_uint32**") PointerPointer prtab, @Cast("l_uint32**") PointerPointer pgtab, @Cast("l_uint32**") PointerPointer pbtab );
public static native @Cast("l_ok") int makeRGBToIndexTables( @Cast("l_int32") int cqlevels, @Cast("l_uint32**") @ByPtrPtr IntPointer prtab, @Cast("l_uint32**") @ByPtrPtr IntPointer pgtab, @Cast("l_uint32**") @ByPtrPtr IntPointer pbtab );
public static native @Cast("l_ok") int makeRGBToIndexTables( @Cast("l_int32") int cqlevels, @Cast("l_uint32**") @ByPtrPtr IntBuffer prtab, @Cast("l_uint32**") @ByPtrPtr IntBuffer pgtab, @Cast("l_uint32**") @ByPtrPtr IntBuffer pbtab );
public static native @Cast("l_ok") int makeRGBToIndexTables( @Cast("l_int32") int cqlevels, @Cast("l_uint32**") @ByPtrPtr int[] prtab, @Cast("l_uint32**") @ByPtrPtr int[] pgtab, @Cast("l_uint32**") @ByPtrPtr int[] pbtab );
public static native void getOctcubeIndexFromRGB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") IntPointer rtab, @Cast("l_uint32*") IntPointer gtab, @Cast("l_uint32*") IntPointer btab, @Cast("l_uint32*") IntPointer pindex );
public static native void getOctcubeIndexFromRGB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") IntBuffer rtab, @Cast("l_uint32*") IntBuffer gtab, @Cast("l_uint32*") IntBuffer btab, @Cast("l_uint32*") IntBuffer pindex );
public static native void getOctcubeIndexFromRGB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") int[] rtab, @Cast("l_uint32*") int[] gtab, @Cast("l_uint32*") int[] btab, @Cast("l_uint32*") int[] pindex );
public static native PIX pixOctreeQuantByPopulation( PIX pixs, @Cast("l_int32") int level, @Cast("l_int32") int ditherflag );
public static native PIX pixOctreeQuantNumColors( PIX pixs, @Cast("l_int32") int maxcolors, @Cast("l_int32") int subsample );
public static native PIX pixOctcubeQuantMixedWithGray( PIX pixs, @Cast("l_int32") int depth, @Cast("l_int32") int graylevels, @Cast("l_int32") int delta );
public static native PIX pixFixedOctcubeQuant256( PIX pixs, @Cast("l_int32") int ditherflag );
public static native PIX pixFewColorsOctcubeQuant1( PIX pixs, @Cast("l_int32") int level );
public static native PIX pixFewColorsOctcubeQuant2( PIX pixs, @Cast("l_int32") int level, NUMA na, @Cast("l_int32") int ncolors, @Cast("l_int32*") IntPointer pnerrors );
public static native PIX pixFewColorsOctcubeQuant2( PIX pixs, @Cast("l_int32") int level, NUMA na, @Cast("l_int32") int ncolors, @Cast("l_int32*") IntBuffer pnerrors );
public static native PIX pixFewColorsOctcubeQuant2( PIX pixs, @Cast("l_int32") int level, NUMA na, @Cast("l_int32") int ncolors, @Cast("l_int32*") int[] pnerrors );
public static native PIX pixFewColorsOctcubeQuantMixed( PIX pixs, @Cast("l_int32") int level, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh, @Cast("l_float32") float minfract, @Cast("l_int32") int maxspan );
public static native PIX pixFixedOctcubeQuantGenRGB( PIX pixs, @Cast("l_int32") int level );
public static native PIX pixQuantFromCmap( PIX pixs, PIXCMAP cmap, @Cast("l_int32") int mindepth, @Cast("l_int32") int level, @Cast("l_int32") int metric );
public static native PIX pixOctcubeQuantFromCmap( PIX pixs, PIXCMAP cmap, @Cast("l_int32") int mindepth, @Cast("l_int32") int level, @Cast("l_int32") int metric );
public static native NUMA pixOctcubeHistogram( PIX pixs, @Cast("l_int32") int level, @Cast("l_int32*") IntPointer pncolors );
public static native NUMA pixOctcubeHistogram( PIX pixs, @Cast("l_int32") int level, @Cast("l_int32*") IntBuffer pncolors );
public static native NUMA pixOctcubeHistogram( PIX pixs, @Cast("l_int32") int level, @Cast("l_int32*") int[] pncolors );
public static native @Cast("l_int32*") IntPointer pixcmapToOctcubeLUT( PIXCMAP cmap, @Cast("l_int32") int level, @Cast("l_int32") int metric );
public static native @Cast("l_ok") int pixRemoveUnusedColors( PIX pixs );
public static native @Cast("l_ok") int pixNumberOccupiedOctcubes( PIX pix, @Cast("l_int32") int level, @Cast("l_int32") int mincount, @Cast("l_float32") float minfract, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixNumberOccupiedOctcubes( PIX pix, @Cast("l_int32") int level, @Cast("l_int32") int mincount, @Cast("l_float32") float minfract, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixNumberOccupiedOctcubes( PIX pix, @Cast("l_int32") int level, @Cast("l_int32") int mincount, @Cast("l_float32") float minfract, @Cast("l_int32*") int[] pncolors );
public static native PIX pixMedianCutQuant( PIX pixs, @Cast("l_int32") int ditherflag );
public static native PIX pixMedianCutQuantGeneral( PIX pixs, @Cast("l_int32") int ditherflag, @Cast("l_int32") int outdepth, @Cast("l_int32") int maxcolors, @Cast("l_int32") int sigbits, @Cast("l_int32") int maxsub, @Cast("l_int32") int checkbw );
public static native PIX pixMedianCutQuantMixed( PIX pixs, @Cast("l_int32") int ncolor, @Cast("l_int32") int ngray, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh );
public static native PIX pixFewColorsMedianCutQuantMixed( PIX pixs, @Cast("l_int32") int ncolor, @Cast("l_int32") int ngray, @Cast("l_int32") int maxncolors, @Cast("l_int32") int darkthresh, @Cast("l_int32") int lightthresh, @Cast("l_int32") int diffthresh );
public static native @Cast("l_int32*") IntPointer pixMedianCutHisto( PIX pixs, @Cast("l_int32") int sigbits, @Cast("l_int32") int subsample );
public static native PIX pixColorSegment( PIX pixs, @Cast("l_int32") int maxdist, @Cast("l_int32") int maxcolors, @Cast("l_int32") int selsize, @Cast("l_int32") int finalcolors, @Cast("l_int32") int debugflag );
public static native PIX pixColorSegmentCluster( PIX pixs, @Cast("l_int32") int maxdist, @Cast("l_int32") int maxcolors, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixAssignToNearestColor( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int level, @Cast("l_int32*") IntPointer countarray );
public static native @Cast("l_ok") int pixAssignToNearestColor( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int level, @Cast("l_int32*") IntBuffer countarray );
public static native @Cast("l_ok") int pixAssignToNearestColor( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int level, @Cast("l_int32*") int[] countarray );
public static native @Cast("l_ok") int pixColorSegmentClean( PIX pixs, @Cast("l_int32") int selsize, @Cast("l_int32*") IntPointer countarray );
public static native @Cast("l_ok") int pixColorSegmentClean( PIX pixs, @Cast("l_int32") int selsize, @Cast("l_int32*") IntBuffer countarray );
public static native @Cast("l_ok") int pixColorSegmentClean( PIX pixs, @Cast("l_int32") int selsize, @Cast("l_int32*") int[] countarray );
public static native @Cast("l_ok") int pixColorSegmentRemoveColors( PIX pixd, PIX pixs, @Cast("l_int32") int finalcolors );
public static native PIX pixConvertRGBToHSV( PIX pixd, PIX pixs );
public static native PIX pixConvertHSVToRGB( PIX pixd, PIX pixs );
public static native @Cast("l_ok") int convertRGBToHSV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer phval, @Cast("l_int32*") IntPointer psval, @Cast("l_int32*") IntPointer pvval );
public static native @Cast("l_ok") int convertRGBToHSV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer phval, @Cast("l_int32*") IntBuffer psval, @Cast("l_int32*") IntBuffer pvval );
public static native @Cast("l_ok") int convertRGBToHSV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] phval, @Cast("l_int32*") int[] psval, @Cast("l_int32*") int[] pvval );
public static native @Cast("l_ok") int convertHSVToRGB( @Cast("l_int32") int hval, @Cast("l_int32") int sval, @Cast("l_int32") int vval, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int convertHSVToRGB( @Cast("l_int32") int hval, @Cast("l_int32") int sval, @Cast("l_int32") int vval, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int convertHSVToRGB( @Cast("l_int32") int hval, @Cast("l_int32") int sval, @Cast("l_int32") int vval, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native @Cast("l_ok") int pixcmapConvertRGBToHSV( PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapConvertHSVToRGB( PIXCMAP cmap );
public static native PIX pixConvertRGBToHue( PIX pixs );
public static native PIX pixConvertRGBToSaturation( PIX pixs );
public static native PIX pixConvertRGBToValue( PIX pixs );
public static native PIX pixMakeRangeMaskHS( PIX pixs, @Cast("l_int32") int huecenter, @Cast("l_int32") int huehw, @Cast("l_int32") int satcenter, @Cast("l_int32") int sathw, @Cast("l_int32") int regionflag );
public static native PIX pixMakeRangeMaskHV( PIX pixs, @Cast("l_int32") int huecenter, @Cast("l_int32") int huehw, @Cast("l_int32") int valcenter, @Cast("l_int32") int valhw, @Cast("l_int32") int regionflag );
public static native PIX pixMakeRangeMaskSV( PIX pixs, @Cast("l_int32") int satcenter, @Cast("l_int32") int sathw, @Cast("l_int32") int valcenter, @Cast("l_int32") int valhw, @Cast("l_int32") int regionflag );
public static native PIX pixMakeHistoHS( PIX pixs, @Cast("l_int32") int factor, @Cast("NUMA**") PointerPointer pnahue, @Cast("NUMA**") PointerPointer pnasat );
public static native PIX pixMakeHistoHS( PIX pixs, @Cast("l_int32") int factor, @ByPtrPtr NUMA pnahue, @ByPtrPtr NUMA pnasat );
public static native PIX pixMakeHistoHV( PIX pixs, @Cast("l_int32") int factor, @Cast("NUMA**") PointerPointer pnahue, @Cast("NUMA**") PointerPointer pnaval );
public static native PIX pixMakeHistoHV( PIX pixs, @Cast("l_int32") int factor, @ByPtrPtr NUMA pnahue, @ByPtrPtr NUMA pnaval );
public static native PIX pixMakeHistoSV( PIX pixs, @Cast("l_int32") int factor, @Cast("NUMA**") PointerPointer pnasat, @Cast("NUMA**") PointerPointer pnaval );
public static native PIX pixMakeHistoSV( PIX pixs, @Cast("l_int32") int factor, @ByPtrPtr NUMA pnasat, @ByPtrPtr NUMA pnaval );
public static native @Cast("l_ok") int pixFindHistoPeaksHSV( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int npeaks, @Cast("l_float32") float erasefactor, @Cast("PTA**") PointerPointer ppta, @Cast("NUMA**") PointerPointer pnatot, @Cast("PIXA**") PointerPointer ppixa );
public static native @Cast("l_ok") int pixFindHistoPeaksHSV( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int npeaks, @Cast("l_float32") float erasefactor, @ByPtrPtr PTA ppta, @ByPtrPtr NUMA pnatot, @ByPtrPtr PIXA ppixa );
public static native PIX displayHSVColorRange( @Cast("l_int32") int hval, @Cast("l_int32") int sval, @Cast("l_int32") int vval, @Cast("l_int32") int huehw, @Cast("l_int32") int sathw, @Cast("l_int32") int nsamp, @Cast("l_int32") int factor );
public static native PIX pixConvertRGBToYUV( PIX pixd, PIX pixs );
public static native PIX pixConvertYUVToRGB( PIX pixd, PIX pixs );
public static native @Cast("l_ok") int convertRGBToYUV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntPointer pyval, @Cast("l_int32*") IntPointer puval, @Cast("l_int32*") IntPointer pvval );
public static native @Cast("l_ok") int convertRGBToYUV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") IntBuffer pyval, @Cast("l_int32*") IntBuffer puval, @Cast("l_int32*") IntBuffer pvval );
public static native @Cast("l_ok") int convertRGBToYUV( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32*") int[] pyval, @Cast("l_int32*") int[] puval, @Cast("l_int32*") int[] pvval );
public static native @Cast("l_ok") int convertYUVToRGB( @Cast("l_int32") int yval, @Cast("l_int32") int uval, @Cast("l_int32") int vval, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int convertYUVToRGB( @Cast("l_int32") int yval, @Cast("l_int32") int uval, @Cast("l_int32") int vval, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int convertYUVToRGB( @Cast("l_int32") int yval, @Cast("l_int32") int uval, @Cast("l_int32") int vval, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native @Cast("l_ok") int pixcmapConvertRGBToYUV( PIXCMAP cmap );
public static native @Cast("l_ok") int pixcmapConvertYUVToRGB( PIXCMAP cmap );
public static native FPIXA pixConvertRGBToXYZ( PIX pixs );
public static native PIX fpixaConvertXYZToRGB( FPIXA fpixa );
public static native @Cast("l_ok") int convertRGBToXYZ( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") FloatPointer pfxval, @Cast("l_float32*") FloatPointer pfyval, @Cast("l_float32*") FloatPointer pfzval );
public static native @Cast("l_ok") int convertRGBToXYZ( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") FloatBuffer pfxval, @Cast("l_float32*") FloatBuffer pfyval, @Cast("l_float32*") FloatBuffer pfzval );
public static native @Cast("l_ok") int convertRGBToXYZ( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") float[] pfxval, @Cast("l_float32*") float[] pfyval, @Cast("l_float32*") float[] pfzval );
public static native @Cast("l_ok") int convertXYZToRGB( @Cast("l_float32") float fxval, @Cast("l_float32") float fyval, @Cast("l_float32") float fzval, @Cast("l_int32") int blackout, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int convertXYZToRGB( @Cast("l_float32") float fxval, @Cast("l_float32") float fyval, @Cast("l_float32") float fzval, @Cast("l_int32") int blackout, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int convertXYZToRGB( @Cast("l_float32") float fxval, @Cast("l_float32") float fyval, @Cast("l_float32") float fzval, @Cast("l_int32") int blackout, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native FPIXA fpixaConvertXYZToLAB( FPIXA fpixas );
public static native FPIXA fpixaConvertLABToXYZ( FPIXA fpixas );
public static native @Cast("l_ok") int convertXYZToLAB( @Cast("l_float32") float xval, @Cast("l_float32") float yval, @Cast("l_float32") float zval, @Cast("l_float32*") FloatPointer plval, @Cast("l_float32*") FloatPointer paval, @Cast("l_float32*") FloatPointer pbval );
public static native @Cast("l_ok") int convertXYZToLAB( @Cast("l_float32") float xval, @Cast("l_float32") float yval, @Cast("l_float32") float zval, @Cast("l_float32*") FloatBuffer plval, @Cast("l_float32*") FloatBuffer paval, @Cast("l_float32*") FloatBuffer pbval );
public static native @Cast("l_ok") int convertXYZToLAB( @Cast("l_float32") float xval, @Cast("l_float32") float yval, @Cast("l_float32") float zval, @Cast("l_float32*") float[] plval, @Cast("l_float32*") float[] paval, @Cast("l_float32*") float[] pbval );
public static native @Cast("l_ok") int convertLABToXYZ( @Cast("l_float32") float lval, @Cast("l_float32") float aval, @Cast("l_float32") float bval, @Cast("l_float32*") FloatPointer pxval, @Cast("l_float32*") FloatPointer pyval, @Cast("l_float32*") FloatPointer pzval );
public static native @Cast("l_ok") int convertLABToXYZ( @Cast("l_float32") float lval, @Cast("l_float32") float aval, @Cast("l_float32") float bval, @Cast("l_float32*") FloatBuffer pxval, @Cast("l_float32*") FloatBuffer pyval, @Cast("l_float32*") FloatBuffer pzval );
public static native @Cast("l_ok") int convertLABToXYZ( @Cast("l_float32") float lval, @Cast("l_float32") float aval, @Cast("l_float32") float bval, @Cast("l_float32*") float[] pxval, @Cast("l_float32*") float[] pyval, @Cast("l_float32*") float[] pzval );
public static native FPIXA pixConvertRGBToLAB( PIX pixs );
public static native PIX fpixaConvertLABToRGB( FPIXA fpixa );
public static native @Cast("l_ok") int convertRGBToLAB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") FloatPointer pflval, @Cast("l_float32*") FloatPointer pfaval, @Cast("l_float32*") FloatPointer pfbval );
public static native @Cast("l_ok") int convertRGBToLAB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") FloatBuffer pflval, @Cast("l_float32*") FloatBuffer pfaval, @Cast("l_float32*") FloatBuffer pfbval );
public static native @Cast("l_ok") int convertRGBToLAB( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32*") float[] pflval, @Cast("l_float32*") float[] pfaval, @Cast("l_float32*") float[] pfbval );
public static native @Cast("l_ok") int convertLABToRGB( @Cast("l_float32") float flval, @Cast("l_float32") float faval, @Cast("l_float32") float fbval, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int convertLABToRGB( @Cast("l_float32") float flval, @Cast("l_float32") float faval, @Cast("l_float32") float fbval, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int convertLABToRGB( @Cast("l_float32") float flval, @Cast("l_float32") float faval, @Cast("l_float32") float fbval, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native PIX pixMakeGamutRGB( @Cast("l_int32") int scale );
public static native @Cast("l_ok") int pixEqual( PIX pix1, PIX pix2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixEqual( PIX pix1, PIX pix2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int pixEqual( PIX pix1, PIX pix2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int pixEqualWithAlpha( PIX pix1, PIX pix2, @Cast("l_int32") int use_alpha, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixEqualWithAlpha( PIX pix1, PIX pix2, @Cast("l_int32") int use_alpha, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int pixEqualWithAlpha( PIX pix1, PIX pix2, @Cast("l_int32") int use_alpha, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int pixEqualWithCmap( PIX pix1, PIX pix2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixEqualWithCmap( PIX pix1, PIX pix2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int pixEqualWithCmap( PIX pix1, PIX pix2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int cmapEqual( PIXCMAP cmap1, PIXCMAP cmap2, @Cast("l_int32") int ncomps, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int cmapEqual( PIXCMAP cmap1, PIXCMAP cmap2, @Cast("l_int32") int ncomps, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int cmapEqual( PIXCMAP cmap1, PIXCMAP cmap2, @Cast("l_int32") int ncomps, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int pixUsesCmapColor( PIX pixs, @Cast("l_int32*") IntPointer pcolor );
public static native @Cast("l_ok") int pixUsesCmapColor( PIX pixs, @Cast("l_int32*") IntBuffer pcolor );
public static native @Cast("l_ok") int pixUsesCmapColor( PIX pixs, @Cast("l_int32*") int[] pcolor );
public static native @Cast("l_ok") int pixCorrelationBinary( PIX pix1, PIX pix2, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int pixCorrelationBinary( PIX pix1, PIX pix2, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int pixCorrelationBinary( PIX pix1, PIX pix2, @Cast("l_float32*") float[] pval );
public static native PIX pixDisplayDiffBinary( PIX pix1, PIX pix2 );
public static native @Cast("l_ok") int pixCompareBinary( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_float32*") FloatPointer pfract, @Cast("PIX**") PointerPointer ppixdiff );
public static native @Cast("l_ok") int pixCompareBinary( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_float32*") FloatPointer pfract, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareBinary( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_float32*") FloatBuffer pfract, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareBinary( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_float32*") float[] pfract, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGrayOrRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @Cast("PIX**") PointerPointer ppixdiff );
public static native @Cast("l_ok") int pixCompareGrayOrRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGrayOrRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntBuffer psame, @Cast("l_float32*") FloatBuffer pdiff, @Cast("l_float32*") FloatBuffer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGrayOrRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") int[] psame, @Cast("l_float32*") float[] pdiff, @Cast("l_float32*") float[] prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGray( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @Cast("PIX**") PointerPointer ppixdiff );
public static native @Cast("l_ok") int pixCompareGray( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGray( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntBuffer psame, @Cast("l_float32*") FloatBuffer pdiff, @Cast("l_float32*") FloatBuffer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareGray( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") int[] psame, @Cast("l_float32*") float[] pdiff, @Cast("l_float32*") float[] prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @Cast("PIX**") PointerPointer ppixdiff );
public static native @Cast("l_ok") int pixCompareRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntPointer psame, @Cast("l_float32*") FloatPointer pdiff, @Cast("l_float32*") FloatPointer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") IntBuffer psame, @Cast("l_float32*") FloatBuffer pdiff, @Cast("l_float32*") FloatBuffer prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareRGB( PIX pix1, PIX pix2, @Cast("l_int32") int comptype, @Cast("l_int32") int plottype, @Cast("l_int32*") int[] psame, @Cast("l_float32*") float[] pdiff, @Cast("l_float32*") float[] prmsdiff, @ByPtrPtr PIX ppixdiff );
public static native @Cast("l_ok") int pixCompareTiled( PIX pix1, PIX pix2, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int type, @Cast("PIX**") PointerPointer ppixdiff );
public static native @Cast("l_ok") int pixCompareTiled( PIX pix1, PIX pix2, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int type, @ByPtrPtr PIX ppixdiff );
public static native NUMA pixCompareRankDifference( PIX pix1, PIX pix2, @Cast("l_int32") int factor );
public static native @Cast("l_ok") int pixTestForSimilarity( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32") float maxfract, @Cast("l_float32") float maxave, @Cast("l_int32*") IntPointer psimilar, @Cast("l_int32") int details );
public static native @Cast("l_ok") int pixTestForSimilarity( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32") float maxfract, @Cast("l_float32") float maxave, @Cast("l_int32*") IntBuffer psimilar, @Cast("l_int32") int details );
public static native @Cast("l_ok") int pixTestForSimilarity( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32") float maxfract, @Cast("l_float32") float maxave, @Cast("l_int32*") int[] psimilar, @Cast("l_int32") int details );
public static native @Cast("l_ok") int pixGetDifferenceStats( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32*") FloatPointer pfractdiff, @Cast("l_float32*") FloatPointer pavediff, @Cast("l_int32") int details );
public static native @Cast("l_ok") int pixGetDifferenceStats( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32*") FloatBuffer pfractdiff, @Cast("l_float32*") FloatBuffer pavediff, @Cast("l_int32") int details );
public static native @Cast("l_ok") int pixGetDifferenceStats( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_int32") int mindiff, @Cast("l_float32*") float[] pfractdiff, @Cast("l_float32*") float[] pavediff, @Cast("l_int32") int details );
public static native NUMA pixGetDifferenceHistogram( PIX pix1, PIX pix2, @Cast("l_int32") int factor );
public static native @Cast("l_ok") int pixGetPerceptualDiff( PIX pixs1, PIX pixs2, @Cast("l_int32") int sampling, @Cast("l_int32") int dilation, @Cast("l_int32") int mindiff, @Cast("l_float32*") FloatPointer pfract, @Cast("PIX**") PointerPointer ppixdiff1, @Cast("PIX**") PointerPointer ppixdiff2 );
public static native @Cast("l_ok") int pixGetPerceptualDiff( PIX pixs1, PIX pixs2, @Cast("l_int32") int sampling, @Cast("l_int32") int dilation, @Cast("l_int32") int mindiff, @Cast("l_float32*") FloatPointer pfract, @ByPtrPtr PIX ppixdiff1, @ByPtrPtr PIX ppixdiff2 );
public static native @Cast("l_ok") int pixGetPerceptualDiff( PIX pixs1, PIX pixs2, @Cast("l_int32") int sampling, @Cast("l_int32") int dilation, @Cast("l_int32") int mindiff, @Cast("l_float32*") FloatBuffer pfract, @ByPtrPtr PIX ppixdiff1, @ByPtrPtr PIX ppixdiff2 );
public static native @Cast("l_ok") int pixGetPerceptualDiff( PIX pixs1, PIX pixs2, @Cast("l_int32") int sampling, @Cast("l_int32") int dilation, @Cast("l_int32") int mindiff, @Cast("l_float32*") float[] pfract, @ByPtrPtr PIX ppixdiff1, @ByPtrPtr PIX ppixdiff2 );
public static native @Cast("l_ok") int pixGetPSNR( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_float32*") FloatPointer ppsnr );
public static native @Cast("l_ok") int pixGetPSNR( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_float32*") FloatBuffer ppsnr );
public static native @Cast("l_ok") int pixGetPSNR( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("l_float32*") float[] ppsnr );
public static native @Cast("l_ok") int pixaComparePhotoRegionsByHisto( PIXA pixa, @Cast("l_float32") float minratio, @Cast("l_float32") float textthresh, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32") float simthresh, @Cast("NUMA**") PointerPointer pnai, @Cast("l_float32**") PointerPointer pscores, @Cast("PIX**") PointerPointer ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixaComparePhotoRegionsByHisto( PIXA pixa, @Cast("l_float32") float minratio, @Cast("l_float32") float textthresh, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32") float simthresh, @ByPtrPtr NUMA pnai, @Cast("l_float32**") @ByPtrPtr FloatPointer pscores, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixaComparePhotoRegionsByHisto( PIXA pixa, @Cast("l_float32") float minratio, @Cast("l_float32") float textthresh, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32") float simthresh, @ByPtrPtr NUMA pnai, @Cast("l_float32**") @ByPtrPtr FloatBuffer pscores, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixaComparePhotoRegionsByHisto( PIXA pixa, @Cast("l_float32") float minratio, @Cast("l_float32") float textthresh, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32") float simthresh, @ByPtrPtr NUMA pnai, @Cast("l_float32**") @ByPtrPtr float[] pscores, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixComparePhotoRegionsByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixComparePhotoRegionsByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") FloatBuffer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixComparePhotoRegionsByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") float[] pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixGenPhotoHistos( PIX pixs, BOX box, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @Cast("NUMAA**") PointerPointer pnaa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32") int debugindex );
public static native @Cast("l_ok") int pixGenPhotoHistos( PIX pixs, BOX box, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @ByPtrPtr NUMAA pnaa, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32") int debugindex );
public static native @Cast("l_ok") int pixGenPhotoHistos( PIX pixs, BOX box, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @ByPtrPtr NUMAA pnaa, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32") int debugindex );
public static native @Cast("l_ok") int pixGenPhotoHistos( PIX pixs, BOX box, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @ByPtrPtr NUMAA pnaa, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32") int debugindex );
public static native PIX pixPadToCenterCentroid( PIX pixs, @Cast("l_int32") int factor );
public static native @Cast("l_ok") int pixCentroid8( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") FloatPointer pcx, @Cast("l_float32*") FloatPointer pcy );
public static native @Cast("l_ok") int pixCentroid8( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") FloatBuffer pcx, @Cast("l_float32*") FloatBuffer pcy );
public static native @Cast("l_ok") int pixCentroid8( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") float[] pcx, @Cast("l_float32*") float[] pcy );
public static native @Cast("l_ok") int pixDecideIfPhotoImage( PIX pix, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @Cast("NUMAA**") PointerPointer pnaa, PIXA pixadebug );
public static native @Cast("l_ok") int pixDecideIfPhotoImage( PIX pix, @Cast("l_int32") int factor, @Cast("l_float32") float thresh, @Cast("l_int32") int n, @ByPtrPtr NUMAA pnaa, PIXA pixadebug );
public static native @Cast("l_ok") int compareTilesByHisto( NUMAA naa1, NUMAA naa2, @Cast("l_float32") float minratio, @Cast("l_int32") int w1, @Cast("l_int32") int h1, @Cast("l_int32") int w2, @Cast("l_int32") int h2, @Cast("l_float32*") FloatPointer pscore, PIXA pixadebug );
public static native @Cast("l_ok") int compareTilesByHisto( NUMAA naa1, NUMAA naa2, @Cast("l_float32") float minratio, @Cast("l_int32") int w1, @Cast("l_int32") int h1, @Cast("l_int32") int w2, @Cast("l_int32") int h2, @Cast("l_float32*") FloatBuffer pscore, PIXA pixadebug );
public static native @Cast("l_ok") int compareTilesByHisto( NUMAA naa1, NUMAA naa2, @Cast("l_float32") float minratio, @Cast("l_int32") int w1, @Cast("l_int32") int h1, @Cast("l_int32") int w2, @Cast("l_int32") int h2, @Cast("l_float32*") float[] pscore, PIXA pixadebug );
public static native @Cast("l_ok") int pixCompareGrayByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int maxgray, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixCompareGrayByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int maxgray, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") FloatBuffer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixCompareGrayByHisto( PIX pix1, PIX pix2, BOX box1, BOX box2, @Cast("l_float32") float minratio, @Cast("l_int32") int maxgray, @Cast("l_int32") int factor, @Cast("l_int32") int n, @Cast("l_float32*") float[] pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixCropAlignedToCentroid( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @Cast("BOX**") PointerPointer pbox1, @Cast("BOX**") PointerPointer pbox2 );
public static native @Cast("l_ok") int pixCropAlignedToCentroid( PIX pix1, PIX pix2, @Cast("l_int32") int factor, @ByPtrPtr BOX pbox1, @ByPtrPtr BOX pbox2 );
public static native @Cast("l_uint8*") BytePointer l_compressGrayHistograms( NUMAA naa, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("size_t*") SizeTPointer psize );
public static native NUMAA l_uncompressGrayHistograms( @Cast("l_uint8*") BytePointer bytea, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native NUMAA l_uncompressGrayHistograms( @Cast("l_uint8*") ByteBuffer bytea, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native NUMAA l_uncompressGrayHistograms( @Cast("l_uint8*") byte[] bytea, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int pixCompareWithTranslation( PIX pix1, PIX pix2, @Cast("l_int32") int thresh, @Cast("l_int32*") IntPointer pdelx, @Cast("l_int32*") IntPointer pdely, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixCompareWithTranslation( PIX pix1, PIX pix2, @Cast("l_int32") int thresh, @Cast("l_int32*") IntBuffer pdelx, @Cast("l_int32*") IntBuffer pdely, @Cast("l_float32*") FloatBuffer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixCompareWithTranslation( PIX pix1, PIX pix2, @Cast("l_int32") int thresh, @Cast("l_int32*") int[] pdelx, @Cast("l_int32*") int[] pdely, @Cast("l_float32*") float[] pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixBestCorrelation( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int etransx, @Cast("l_int32") int etransy, @Cast("l_int32") int maxshift, @Cast("l_int32*") IntPointer tab8, @Cast("l_int32*") IntPointer pdelx, @Cast("l_int32*") IntPointer pdely, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixBestCorrelation( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int etransx, @Cast("l_int32") int etransy, @Cast("l_int32") int maxshift, @Cast("l_int32*") IntBuffer tab8, @Cast("l_int32*") IntBuffer pdelx, @Cast("l_int32*") IntBuffer pdely, @Cast("l_float32*") FloatBuffer pscore, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixBestCorrelation( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int etransx, @Cast("l_int32") int etransy, @Cast("l_int32") int maxshift, @Cast("l_int32*") int[] tab8, @Cast("l_int32*") int[] pdelx, @Cast("l_int32*") int[] pdely, @Cast("l_float32*") float[] pscore, @Cast("l_int32") int debugflag );
public static native BOXA pixConnComp( PIX pixs, @Cast("PIXA**") PointerPointer ppixa, @Cast("l_int32") int connectivity );
public static native BOXA pixConnComp( PIX pixs, @ByPtrPtr PIXA ppixa, @Cast("l_int32") int connectivity );
public static native BOXA pixConnCompPixa( PIX pixs, @Cast("PIXA**") PointerPointer ppixa, @Cast("l_int32") int connectivity );
public static native BOXA pixConnCompPixa( PIX pixs, @ByPtrPtr PIXA ppixa, @Cast("l_int32") int connectivity );
public static native BOXA pixConnCompBB( PIX pixs, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixCountConnComp( PIX pixs, @Cast("l_int32") int connectivity, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int pixCountConnComp( PIX pixs, @Cast("l_int32") int connectivity, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int pixCountConnComp( PIX pixs, @Cast("l_int32") int connectivity, @Cast("l_int32*") int[] pcount );
public static native @Cast("l_int32") int nextOnPixelInRaster( PIX pixs, @Cast("l_int32") int xstart, @Cast("l_int32") int ystart, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py );
public static native @Cast("l_int32") int nextOnPixelInRaster( PIX pixs, @Cast("l_int32") int xstart, @Cast("l_int32") int ystart, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py );
public static native @Cast("l_int32") int nextOnPixelInRaster( PIX pixs, @Cast("l_int32") int xstart, @Cast("l_int32") int ystart, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py );
public static native BOX pixSeedfillBB( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int connectivity );
public static native BOX pixSeedfill4BB( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native BOX pixSeedfill8BB( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixSeedfill( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixSeedfill4( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixSeedfill8( PIX pixs, L_STACK stack, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int convertFilesTo1bpp( @Cast("const char*") BytePointer dirin, @Cast("const char*") BytePointer substr, @Cast("l_int32") int upscaling, @Cast("l_int32") int thresh, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, @Cast("const char*") BytePointer dirout, @Cast("l_int32") int outformat );
public static native @Cast("l_ok") int convertFilesTo1bpp( String dirin, String substr, @Cast("l_int32") int upscaling, @Cast("l_int32") int thresh, @Cast("l_int32") int firstpage, @Cast("l_int32") int npages, String dirout, @Cast("l_int32") int outformat );
public static native PIX pixBlockconv( PIX pix, @Cast("l_int32") int wc, @Cast("l_int32") int hc );
public static native PIX pixBlockconvGray( PIX pixs, PIX pixacc, @Cast("l_int32") int wc, @Cast("l_int32") int hc );
public static native PIX pixBlockconvAccum( PIX pixs );
public static native PIX pixBlockconvGrayUnnormalized( PIX pixs, @Cast("l_int32") int wc, @Cast("l_int32") int hc );
public static native PIX pixBlockconvTiled( PIX pix, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int nx, @Cast("l_int32") int ny );
public static native PIX pixBlockconvGrayTile( PIX pixs, PIX pixacc, @Cast("l_int32") int wc, @Cast("l_int32") int hc );
public static native @Cast("l_ok") int pixWindowedStats( PIX pixs, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int hasborder, @Cast("PIX**") PointerPointer ppixm, @Cast("PIX**") PointerPointer ppixms, @Cast("FPIX**") PointerPointer pfpixv, @Cast("FPIX**") PointerPointer pfpixrv );
public static native @Cast("l_ok") int pixWindowedStats( PIX pixs, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int hasborder, @ByPtrPtr PIX ppixm, @ByPtrPtr PIX ppixms, @ByPtrPtr FPIX pfpixv, @ByPtrPtr FPIX pfpixrv );
public static native PIX pixWindowedMean( PIX pixs, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int hasborder, @Cast("l_int32") int normflag );
public static native PIX pixWindowedMeanSquare( PIX pixs, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_int32") int hasborder );
public static native @Cast("l_ok") int pixWindowedVariance( PIX pixm, PIX pixms, @Cast("FPIX**") PointerPointer pfpixv, @Cast("FPIX**") PointerPointer pfpixrv );
public static native @Cast("l_ok") int pixWindowedVariance( PIX pixm, PIX pixms, @ByPtrPtr FPIX pfpixv, @ByPtrPtr FPIX pfpixrv );
public static native DPIX pixMeanSquareAccum( PIX pixs );
public static native PIX pixBlockrank( PIX pixs, PIX pixacc, @Cast("l_int32") int wc, @Cast("l_int32") int hc, @Cast("l_float32") float rank );
public static native PIX pixBlocksum( PIX pixs, PIX pixacc, @Cast("l_int32") int wc, @Cast("l_int32") int hc );
public static native PIX pixCensusTransform( PIX pixs, @Cast("l_int32") int halfsize, PIX pixacc );
public static native PIX pixConvolve( PIX pixs, L_KERNEL kel, @Cast("l_int32") int outdepth, @Cast("l_int32") int normflag );
public static native PIX pixConvolveSep( PIX pixs, L_KERNEL kelx, L_KERNEL kely, @Cast("l_int32") int outdepth, @Cast("l_int32") int normflag );
public static native PIX pixConvolveRGB( PIX pixs, L_KERNEL kel );
public static native PIX pixConvolveRGBSep( PIX pixs, L_KERNEL kelx, L_KERNEL kely );
public static native FPIX fpixConvolve( FPIX fpixs, L_KERNEL kel, @Cast("l_int32") int normflag );
public static native FPIX fpixConvolveSep( FPIX fpixs, L_KERNEL kelx, L_KERNEL kely, @Cast("l_int32") int normflag );
public static native PIX pixConvolveWithBias( PIX pixs, L_KERNEL kel1, L_KERNEL kel2, @Cast("l_int32") int force8, @Cast("l_int32*") IntPointer pbias );
public static native PIX pixConvolveWithBias( PIX pixs, L_KERNEL kel1, L_KERNEL kel2, @Cast("l_int32") int force8, @Cast("l_int32*") IntBuffer pbias );
public static native PIX pixConvolveWithBias( PIX pixs, L_KERNEL kel1, L_KERNEL kel2, @Cast("l_int32") int force8, @Cast("l_int32*") int[] pbias );
public static native void l_setConvolveSampling( @Cast("l_int32") int xfact, @Cast("l_int32") int yfact );
public static native PIX pixAddGaussianNoise( PIX pixs, @Cast("l_float32") float stdev );
public static native @Cast("l_float32") float gaussDistribSampling( );
public static native @Cast("l_ok") int pixCorrelationScore( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pscore );
public static native @Cast("l_ok") int pixCorrelationScore( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pscore );
public static native @Cast("l_ok") int pixCorrelationScore( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pscore );
public static native @Cast("l_int32") int pixCorrelationScoreThresholded( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntPointer tab, @Cast("l_int32*") IntPointer downcount, @Cast("l_float32") float score_threshold );
public static native @Cast("l_int32") int pixCorrelationScoreThresholded( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntBuffer tab, @Cast("l_int32*") IntBuffer downcount, @Cast("l_float32") float score_threshold );
public static native @Cast("l_int32") int pixCorrelationScoreThresholded( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") int[] tab, @Cast("l_int32*") int[] downcount, @Cast("l_float32") float score_threshold );
public static native @Cast("l_ok") int pixCorrelationScoreSimple( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pscore );
public static native @Cast("l_ok") int pixCorrelationScoreSimple( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pscore );
public static native @Cast("l_ok") int pixCorrelationScoreSimple( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pscore );
public static native @Cast("l_ok") int pixCorrelationScoreShifted( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pscore );
public static native @Cast("l_ok") int pixCorrelationScoreShifted( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pscore );
public static native @Cast("l_ok") int pixCorrelationScoreShifted( PIX pix1, PIX pix2, @Cast("l_int32") int area1, @Cast("l_int32") int area2, @Cast("l_int32") int delx, @Cast("l_int32") int dely, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pscore );
public static native L_DEWARP dewarpCreate( PIX pixs, @Cast("l_int32") int pageno );
public static native L_DEWARP dewarpCreateRef( @Cast("l_int32") int pageno, @Cast("l_int32") int refpage );
public static native void dewarpDestroy( @Cast("L_DEWARP**") PointerPointer pdew );
public static native void dewarpDestroy( @ByPtrPtr L_DEWARP pdew );
public static native L_DEWARPA dewarpaCreate( @Cast("l_int32") int nptrs, @Cast("l_int32") int sampling, @Cast("l_int32") int redfactor, @Cast("l_int32") int minlines, @Cast("l_int32") int maxdist );
public static native L_DEWARPA dewarpaCreateFromPixacomp( PIXAC pixac, @Cast("l_int32") int useboth, @Cast("l_int32") int sampling, @Cast("l_int32") int minlines, @Cast("l_int32") int maxdist );
public static native void dewarpaDestroy( @Cast("L_DEWARPA**") PointerPointer pdewa );
public static native void dewarpaDestroy( @ByPtrPtr L_DEWARPA pdewa );
public static native @Cast("l_ok") int dewarpaDestroyDewarp( L_DEWARPA dewa, @Cast("l_int32") int pageno );
public static native @Cast("l_ok") int dewarpaInsertDewarp( L_DEWARPA dewa, L_DEWARP dew );
public static native L_DEWARP dewarpaGetDewarp( L_DEWARPA dewa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int dewarpaSetCurvatures( L_DEWARPA dewa, @Cast("l_int32") int max_linecurv, @Cast("l_int32") int min_diff_linecurv, @Cast("l_int32") int max_diff_linecurv, @Cast("l_int32") int max_edgecurv, @Cast("l_int32") int max_diff_edgecurv, @Cast("l_int32") int max_edgeslope );
public static native @Cast("l_ok") int dewarpaUseBothArrays( L_DEWARPA dewa, @Cast("l_int32") int useboth );
public static native @Cast("l_ok") int dewarpaSetCheckColumns( L_DEWARPA dewa, @Cast("l_int32") int check_columns );
public static native @Cast("l_ok") int dewarpaSetMaxDistance( L_DEWARPA dewa, @Cast("l_int32") int maxdist );
public static native L_DEWARP dewarpRead( @Cast("const char*") BytePointer filename );
public static native L_DEWARP dewarpRead( String filename );
public static native L_DEWARP dewarpReadStream( @Cast("FILE*") Pointer fp );
public static native L_DEWARP dewarpReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_DEWARP dewarpReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_DEWARP dewarpReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int dewarpWrite( @Cast("const char*") BytePointer filename, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWrite( String filename, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWriteStream( @Cast("FILE*") Pointer fp, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARP dew );
public static native @Cast("l_ok") int dewarpWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARP dew );
public static native L_DEWARPA dewarpaRead( @Cast("const char*") BytePointer filename );
public static native L_DEWARPA dewarpaRead( String filename );
public static native L_DEWARPA dewarpaReadStream( @Cast("FILE*") Pointer fp );
public static native L_DEWARPA dewarpaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_DEWARPA dewarpaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_DEWARPA dewarpaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int dewarpaWrite( @Cast("const char*") BytePointer filename, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWrite( String filename, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWriteStream( @Cast("FILE*") Pointer fp, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpBuildPageModel( L_DEWARP dew, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpBuildPageModel( L_DEWARP dew, String debugfile );
public static native @Cast("l_ok") int dewarpFindVertDisparity( L_DEWARP dew, PTAA ptaa, @Cast("l_int32") int rotflag );
public static native @Cast("l_ok") int dewarpFindHorizDisparity( L_DEWARP dew, PTAA ptaa );
public static native PTAA dewarpGetTextlineCenters( PIX pixs, @Cast("l_int32") int debugflag );
public static native PTAA dewarpRemoveShortLines( PIX pixs, PTAA ptaas, @Cast("l_float32") float fract, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int dewarpFindHorizSlopeDisparity( L_DEWARP dew, PIX pixb, @Cast("l_float32") float fractthresh, @Cast("l_int32") int parity );
public static native @Cast("l_ok") int dewarpBuildLineModel( L_DEWARP dew, @Cast("l_int32") int opensize, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpBuildLineModel( L_DEWARP dew, @Cast("l_int32") int opensize, String debugfile );
public static native @Cast("l_ok") int dewarpaModelStatus( L_DEWARPA dewa, @Cast("l_int32") int pageno, @Cast("l_int32*") IntPointer pvsuccess, @Cast("l_int32*") IntPointer phsuccess );
public static native @Cast("l_ok") int dewarpaModelStatus( L_DEWARPA dewa, @Cast("l_int32") int pageno, @Cast("l_int32*") IntBuffer pvsuccess, @Cast("l_int32*") IntBuffer phsuccess );
public static native @Cast("l_ok") int dewarpaModelStatus( L_DEWARPA dewa, @Cast("l_int32") int pageno, @Cast("l_int32*") int[] pvsuccess, @Cast("l_int32*") int[] phsuccess );
public static native @Cast("l_ok") int dewarpaApplyDisparity( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, @Cast("l_int32") int grayin, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("PIX**") PointerPointer ppixd, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpaApplyDisparity( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, @Cast("l_int32") int grayin, @Cast("l_int32") int x, @Cast("l_int32") int y, @ByPtrPtr PIX ppixd, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpaApplyDisparity( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, @Cast("l_int32") int grayin, @Cast("l_int32") int x, @Cast("l_int32") int y, @ByPtrPtr PIX ppixd, String debugfile );
public static native @Cast("l_ok") int dewarpaApplyDisparityBoxa( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, BOXA boxas, @Cast("l_int32") int mapdir, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("BOXA**") PointerPointer pboxad, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpaApplyDisparityBoxa( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, BOXA boxas, @Cast("l_int32") int mapdir, @Cast("l_int32") int x, @Cast("l_int32") int y, @ByPtrPtr BOXA pboxad, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int dewarpaApplyDisparityBoxa( L_DEWARPA dewa, @Cast("l_int32") int pageno, PIX pixs, BOXA boxas, @Cast("l_int32") int mapdir, @Cast("l_int32") int x, @Cast("l_int32") int y, @ByPtrPtr BOXA pboxad, String debugfile );
public static native @Cast("l_ok") int dewarpMinimize( L_DEWARP dew );
public static native @Cast("l_ok") int dewarpPopulateFullRes( L_DEWARP dew, PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int dewarpSinglePage( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32") int adaptive, @Cast("l_int32") int useboth, @Cast("l_int32") int check_columns, @Cast("PIX**") PointerPointer ppixd, @Cast("L_DEWARPA**") PointerPointer pdewa, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpSinglePage( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32") int adaptive, @Cast("l_int32") int useboth, @Cast("l_int32") int check_columns, @ByPtrPtr PIX ppixd, @ByPtrPtr L_DEWARPA pdewa, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpSinglePageInit( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32") int adaptive, @Cast("l_int32") int useboth, @Cast("l_int32") int check_columns, @Cast("PIX**") PointerPointer ppixb, @Cast("L_DEWARPA**") PointerPointer pdewa );
public static native @Cast("l_ok") int dewarpSinglePageInit( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32") int adaptive, @Cast("l_int32") int useboth, @Cast("l_int32") int check_columns, @ByPtrPtr PIX ppixb, @ByPtrPtr L_DEWARPA pdewa );
public static native @Cast("l_ok") int dewarpSinglePageRun( PIX pixs, PIX pixb, L_DEWARPA dewa, @Cast("PIX**") PointerPointer ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpSinglePageRun( PIX pixs, PIX pixb, L_DEWARPA dewa, @ByPtrPtr PIX ppixd, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpaListPages( L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaSetValidModels( L_DEWARPA dewa, @Cast("l_int32") int notests, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpaInsertRefModels( L_DEWARPA dewa, @Cast("l_int32") int notests, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int dewarpaStripRefModels( L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaRestoreModels( L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaInfo( @Cast("FILE*") Pointer fp, L_DEWARPA dewa );
public static native @Cast("l_ok") int dewarpaModelStats( L_DEWARPA dewa, @Cast("l_int32*") IntPointer pnnone, @Cast("l_int32*") IntPointer pnvsuccess, @Cast("l_int32*") IntPointer pnvvalid, @Cast("l_int32*") IntPointer pnhsuccess, @Cast("l_int32*") IntPointer pnhvalid, @Cast("l_int32*") IntPointer pnref );
public static native @Cast("l_ok") int dewarpaModelStats( L_DEWARPA dewa, @Cast("l_int32*") IntBuffer pnnone, @Cast("l_int32*") IntBuffer pnvsuccess, @Cast("l_int32*") IntBuffer pnvvalid, @Cast("l_int32*") IntBuffer pnhsuccess, @Cast("l_int32*") IntBuffer pnhvalid, @Cast("l_int32*") IntBuffer pnref );
public static native @Cast("l_ok") int dewarpaModelStats( L_DEWARPA dewa, @Cast("l_int32*") int[] pnnone, @Cast("l_int32*") int[] pnvsuccess, @Cast("l_int32*") int[] pnvvalid, @Cast("l_int32*") int[] pnhsuccess, @Cast("l_int32*") int[] pnhvalid, @Cast("l_int32*") int[] pnref );
public static native @Cast("l_ok") int dewarpaShowArrays( L_DEWARPA dewa, @Cast("l_float32") float scalefact, @Cast("l_int32") int first, @Cast("l_int32") int last );
public static native @Cast("l_ok") int dewarpDebug( L_DEWARP dew, @Cast("const char*") BytePointer subdirs, @Cast("l_int32") int index );
public static native @Cast("l_ok") int dewarpDebug( L_DEWARP dew, String subdirs, @Cast("l_int32") int index );
public static native @Cast("l_ok") int dewarpShowResults( L_DEWARPA dewa, SARRAY sa, BOXA boxa, @Cast("l_int32") int firstpage, @Cast("l_int32") int lastpage, @Cast("const char*") BytePointer pdfout );
public static native @Cast("l_ok") int dewarpShowResults( L_DEWARPA dewa, SARRAY sa, BOXA boxa, @Cast("l_int32") int firstpage, @Cast("l_int32") int lastpage, String pdfout );
public static native L_DNA l_dnaCreate( @Cast("l_int32") int n );
public static native L_DNA l_dnaCreateFromIArray( @Cast("l_int32*") IntPointer iarray, @Cast("l_int32") int size );
public static native L_DNA l_dnaCreateFromIArray( @Cast("l_int32*") IntBuffer iarray, @Cast("l_int32") int size );
public static native L_DNA l_dnaCreateFromIArray( @Cast("l_int32*") int[] iarray, @Cast("l_int32") int size );
public static native L_DNA l_dnaCreateFromDArray( @Cast("l_float64*") DoublePointer darray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native L_DNA l_dnaCreateFromDArray( @Cast("l_float64*") DoubleBuffer darray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native L_DNA l_dnaCreateFromDArray( @Cast("l_float64*") double[] darray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native L_DNA l_dnaMakeSequence( @Cast("l_float64") double startval, @Cast("l_float64") double increment, @Cast("l_int32") int size );
public static native void l_dnaDestroy( @Cast("L_DNA**") PointerPointer pda );
public static native void l_dnaDestroy( @ByPtrPtr L_DNA pda );
public static native L_DNA l_dnaCopy( L_DNA da );
public static native L_DNA l_dnaClone( L_DNA da );
public static native @Cast("l_ok") int l_dnaEmpty( L_DNA da );
public static native @Cast("l_ok") int l_dnaAddNumber( L_DNA da, @Cast("l_float64") double val );
public static native @Cast("l_ok") int l_dnaInsertNumber( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64") double val );
public static native @Cast("l_ok") int l_dnaRemoveNumber( L_DNA da, @Cast("l_int32") int index );
public static native @Cast("l_ok") int l_dnaReplaceNumber( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64") double val );
public static native @Cast("l_int32") int l_dnaGetCount( L_DNA da );
public static native @Cast("l_ok") int l_dnaSetCount( L_DNA da, @Cast("l_int32") int newcount );
public static native @Cast("l_ok") int l_dnaGetDValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64*") DoublePointer pval );
public static native @Cast("l_ok") int l_dnaGetDValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64*") DoubleBuffer pval );
public static native @Cast("l_ok") int l_dnaGetDValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64*") double[] pval );
public static native @Cast("l_ok") int l_dnaGetIValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer pival );
public static native @Cast("l_ok") int l_dnaGetIValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer pival );
public static native @Cast("l_ok") int l_dnaGetIValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_int32*") int[] pival );
public static native @Cast("l_ok") int l_dnaSetValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64") double val );
public static native @Cast("l_ok") int l_dnaShiftValue( L_DNA da, @Cast("l_int32") int index, @Cast("l_float64") double diff );
public static native @Cast("l_int32*") IntPointer l_dnaGetIArray( L_DNA da );
public static native @Cast("l_float64*") DoublePointer l_dnaGetDArray( L_DNA da, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int l_dnaGetRefcount( L_DNA da );
public static native @Cast("l_ok") int l_dnaChangeRefcount( L_DNA da, @Cast("l_int32") int delta );
public static native @Cast("l_ok") int l_dnaGetParameters( L_DNA da, @Cast("l_float64*") DoublePointer pstartx, @Cast("l_float64*") DoublePointer pdelx );
public static native @Cast("l_ok") int l_dnaGetParameters( L_DNA da, @Cast("l_float64*") DoubleBuffer pstartx, @Cast("l_float64*") DoubleBuffer pdelx );
public static native @Cast("l_ok") int l_dnaGetParameters( L_DNA da, @Cast("l_float64*") double[] pstartx, @Cast("l_float64*") double[] pdelx );
public static native @Cast("l_ok") int l_dnaSetParameters( L_DNA da, @Cast("l_float64") double startx, @Cast("l_float64") double delx );
public static native @Cast("l_ok") int l_dnaCopyParameters( L_DNA dad, L_DNA das );
public static native L_DNA l_dnaRead( @Cast("const char*") BytePointer filename );
public static native L_DNA l_dnaRead( String filename );
public static native L_DNA l_dnaReadStream( @Cast("FILE*") Pointer fp );
public static native L_DNA l_dnaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_DNA l_dnaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_DNA l_dnaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int l_dnaWrite( @Cast("const char*") BytePointer filename, L_DNA da );
public static native @Cast("l_ok") int l_dnaWrite( String filename, L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteStream( @Cast("FILE*") Pointer fp, L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteStderr( L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, L_DNA da );
public static native @Cast("l_ok") int l_dnaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, L_DNA da );
public static native L_DNAA l_dnaaCreate( @Cast("l_int32") int n );
public static native L_DNAA l_dnaaCreateFull( @Cast("l_int32") int nptr, @Cast("l_int32") int n );
public static native @Cast("l_ok") int l_dnaaTruncate( L_DNAA daa );
public static native void l_dnaaDestroy( @Cast("L_DNAA**") PointerPointer pdaa );
public static native void l_dnaaDestroy( @ByPtrPtr L_DNAA pdaa );
public static native @Cast("l_ok") int l_dnaaAddDna( L_DNAA daa, L_DNA da, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int l_dnaaGetCount( L_DNAA daa );
public static native @Cast("l_int32") int l_dnaaGetDnaCount( L_DNAA daa, @Cast("l_int32") int index );
public static native @Cast("l_int32") int l_dnaaGetNumberCount( L_DNAA daa );
public static native L_DNA l_dnaaGetDna( L_DNAA daa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native @Cast("l_ok") int l_dnaaReplaceDna( L_DNAA daa, @Cast("l_int32") int index, L_DNA da );
public static native @Cast("l_ok") int l_dnaaGetValue( L_DNAA daa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float64*") DoublePointer pval );
public static native @Cast("l_ok") int l_dnaaGetValue( L_DNAA daa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float64*") DoubleBuffer pval );
public static native @Cast("l_ok") int l_dnaaGetValue( L_DNAA daa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float64*") double[] pval );
public static native @Cast("l_ok") int l_dnaaAddNumber( L_DNAA daa, @Cast("l_int32") int index, @Cast("l_float64") double val );
public static native L_DNAA l_dnaaRead( @Cast("const char*") BytePointer filename );
public static native L_DNAA l_dnaaRead( String filename );
public static native L_DNAA l_dnaaReadStream( @Cast("FILE*") Pointer fp );
public static native L_DNAA l_dnaaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_DNAA l_dnaaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_DNAA l_dnaaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int l_dnaaWrite( @Cast("const char*") BytePointer filename, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWrite( String filename, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWriteStream( @Cast("FILE*") Pointer fp, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, L_DNAA daa );
public static native @Cast("l_ok") int l_dnaJoin( L_DNA dad, L_DNA das, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native L_DNA l_dnaaFlattenToDna( L_DNAA daa );
public static native L_DNA l_dnaSelectRange( L_DNA das, @Cast("l_int32") int first, @Cast("l_int32") int last );
public static native NUMA l_dnaConvertToNuma( L_DNA da );
public static native L_DNA numaConvertToDna( NUMA na );
public static native L_DNA pixConvertDataToDna( PIX pix );
public static native L_ASET l_asetCreateFromDna( L_DNA da );
public static native @Cast("l_ok") int l_dnaRemoveDupsByAset( L_DNA das, @Cast("L_DNA**") PointerPointer pdad );
public static native @Cast("l_ok") int l_dnaRemoveDupsByAset( L_DNA das, @ByPtrPtr L_DNA pdad );
public static native @Cast("l_ok") int l_dnaUnionByAset( L_DNA da1, L_DNA da2, @Cast("L_DNA**") PointerPointer pdad );
public static native @Cast("l_ok") int l_dnaUnionByAset( L_DNA da1, L_DNA da2, @ByPtrPtr L_DNA pdad );
public static native @Cast("l_ok") int l_dnaIntersectionByAset( L_DNA da1, L_DNA da2, @Cast("L_DNA**") PointerPointer pdad );
public static native @Cast("l_ok") int l_dnaIntersectionByAset( L_DNA da1, L_DNA da2, @ByPtrPtr L_DNA pdad );
public static native L_HASHMAP l_hmapCreateFromDna( L_DNA da );
public static native @Cast("l_ok") int l_dnaRemoveDupsByHmap( L_DNA das, @Cast("L_DNA**") PointerPointer pdad, @Cast("L_HASHMAP**") PointerPointer phmap );
public static native @Cast("l_ok") int l_dnaRemoveDupsByHmap( L_DNA das, @ByPtrPtr L_DNA pdad, @ByPtrPtr L_HASHMAP phmap );
public static native @Cast("l_ok") int l_dnaUnionByHmap( L_DNA da1, L_DNA da2, @Cast("L_DNA**") PointerPointer pdad );
public static native @Cast("l_ok") int l_dnaUnionByHmap( L_DNA da1, L_DNA da2, @ByPtrPtr L_DNA pdad );
public static native @Cast("l_ok") int l_dnaIntersectionByHmap( L_DNA da1, L_DNA da2, @Cast("L_DNA**") PointerPointer pdad );
public static native @Cast("l_ok") int l_dnaIntersectionByHmap( L_DNA da1, L_DNA da2, @ByPtrPtr L_DNA pdad );
public static native @Cast("l_ok") int l_dnaMakeHistoByHmap( L_DNA das, @Cast("L_DNA**") PointerPointer pdav, @Cast("L_DNA**") PointerPointer pdac );
public static native @Cast("l_ok") int l_dnaMakeHistoByHmap( L_DNA das, @ByPtrPtr L_DNA pdav, @ByPtrPtr L_DNA pdac );
public static native L_DNA l_dnaDiffAdjValues( L_DNA das );
public static native L_DNAHASH l_dnaHashCreate( @Cast("l_int32") int nbuckets, @Cast("l_int32") int initsize );
public static native void l_dnaHashDestroy( @Cast("L_DNAHASH**") PointerPointer pdahash );
public static native void l_dnaHashDestroy( @ByPtrPtr L_DNAHASH pdahash );
public static native L_DNA l_dnaHashGetDna( L_DNAHASH dahash, @Cast("l_uint64") long key, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int l_dnaHashAdd( L_DNAHASH dahash, @Cast("l_uint64") long key, @Cast("l_float64") double value );
public static native PIX pixMorphDwa_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") BytePointer selname );
public static native PIX pixMorphDwa_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") ByteBuffer selname );
public static native PIX pixMorphDwa_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") byte[] selname );
public static native PIX pixFMorphopGen_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") BytePointer selname );
public static native PIX pixFMorphopGen_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") ByteBuffer selname );
public static native PIX pixFMorphopGen_2( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") byte[] selname );
public static native @Cast("l_int32") int fmorphopgen_low_2( @Cast("l_uint32*") IntPointer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fmorphopgen_low_2( @Cast("l_uint32*") IntBuffer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fmorphopgen_low_2( @Cast("l_uint32*") int[] datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native PIX pixSobelEdgeFilter( PIX pixs, @Cast("l_int32") int orientflag );
public static native PIX pixTwoSidedEdgeFilter( PIX pixs, @Cast("l_int32") int orientflag );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") FloatPointer pjpl, @Cast("l_float32*") FloatPointer pjspl, @Cast("l_float32*") FloatPointer prpl, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") FloatBuffer pjpl, @Cast("l_float32*") FloatBuffer pjspl, @Cast("l_float32*") FloatBuffer prpl, String debugfile );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") float[] pjpl, @Cast("l_float32*") float[] pjspl, @Cast("l_float32*") float[] prpl, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") FloatPointer pjpl, @Cast("l_float32*") FloatPointer pjspl, @Cast("l_float32*") FloatPointer prpl, String debugfile );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") FloatBuffer pjpl, @Cast("l_float32*") FloatBuffer pjspl, @Cast("l_float32*") FloatBuffer prpl, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int pixMeasureEdgeSmoothness( PIX pixs, @Cast("l_int32") int side, @Cast("l_int32") int minjump, @Cast("l_int32") int minreversal, @Cast("l_float32*") float[] pjpl, @Cast("l_float32*") float[] pjspl, @Cast("l_float32*") float[] prpl, String debugfile );
public static native NUMA pixGetEdgeProfile( PIX pixs, @Cast("l_int32") int side, @Cast("const char*") BytePointer debugfile );
public static native NUMA pixGetEdgeProfile( PIX pixs, @Cast("l_int32") int side, String debugfile );
public static native @Cast("l_ok") int pixGetLastOffPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_ok") int pixGetLastOffPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_ok") int pixGetLastOffPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") int[] ploc );
public static native @Cast("l_int32") int pixGetLastOnPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_int32") int pixGetLastOnPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_int32") int pixGetLastOnPixelInRun( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int direction, @Cast("l_int32*") int[] ploc );
public static native @Cast("char*") BytePointer encodeBase64( @Cast("const l_uint8*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntPointer poutsize );
public static native @Cast("char*") ByteBuffer encodeBase64( @Cast("const l_uint8*") ByteBuffer inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntBuffer poutsize );
public static native @Cast("char*") byte[] encodeBase64( @Cast("const l_uint8*") byte[] inarray, @Cast("l_int32") int insize, @Cast("l_int32*") int[] poutsize );
public static native @Cast("l_uint8*") BytePointer decodeBase64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntPointer poutsize );
public static native @Cast("l_uint8*") ByteBuffer decodeBase64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntBuffer poutsize );
public static native @Cast("l_uint8*") byte[] decodeBase64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32*") int[] poutsize );
public static native @Cast("l_uint8*") BytePointer decodeBase64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntPointer poutsize );
public static native @Cast("l_uint8*") ByteBuffer decodeBase64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32*") IntBuffer poutsize );
public static native @Cast("l_uint8*") byte[] decodeBase64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32*") int[] poutsize );
public static native @Cast("char*") BytePointer encodeAscii85( @Cast("const l_uint8*") BytePointer inarray, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") ByteBuffer encodeAscii85( @Cast("const l_uint8*") ByteBuffer inarray, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") byte[] encodeAscii85( @Cast("const l_uint8*") byte[] inarray, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("l_uint8*") BytePointer decodeAscii85( @Cast("const char*") BytePointer inarray, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("l_uint8*") ByteBuffer decodeAscii85( String inarray, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") BytePointer encodeAscii85WithComp( @Cast("const l_uint8*") BytePointer indata, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") ByteBuffer encodeAscii85WithComp( @Cast("const l_uint8*") ByteBuffer indata, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") byte[] encodeAscii85WithComp( @Cast("const l_uint8*") byte[] indata, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("l_uint8*") BytePointer decodeAscii85WithComp( @Cast("const char*") BytePointer instr, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("l_uint8*") ByteBuffer decodeAscii85WithComp( String instr, @Cast("size_t") long insize, @Cast("size_t*") SizeTPointer poutsize );
public static native @Cast("char*") BytePointer reformatPacked64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") IntPointer poutsize );
public static native @Cast("char*") ByteBuffer reformatPacked64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") IntBuffer poutsize );
public static native @Cast("char*") byte[] reformatPacked64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") int[] poutsize );
public static native @Cast("char*") BytePointer reformatPacked64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") IntPointer poutsize );
public static native @Cast("char*") ByteBuffer reformatPacked64( @Cast("const char*") BytePointer inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") IntBuffer poutsize );
public static native @Cast("char*") byte[] reformatPacked64( String inarray, @Cast("l_int32") int insize, @Cast("l_int32") int leadspace, @Cast("l_int32") int linechars, @Cast("l_int32") int addquotes, @Cast("l_int32*") int[] poutsize );
public static native PIX pixGammaTRC( PIX pixd, PIX pixs, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native PIX pixGammaTRCMasked( PIX pixd, PIX pixs, PIX pixm, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native PIX pixGammaTRCWithAlpha( PIX pixd, PIX pixs, @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native NUMA numaGammaTRC( @Cast("l_float32") float gamma, @Cast("l_int32") int minval, @Cast("l_int32") int maxval );
public static native PIX pixContrastTRC( PIX pixd, PIX pixs, @Cast("l_float32") float factor );
public static native PIX pixContrastTRCMasked( PIX pixd, PIX pixs, PIX pixm, @Cast("l_float32") float factor );
public static native NUMA numaContrastTRC( @Cast("l_float32") float factor );
public static native PIX pixEqualizeTRC( PIX pixd, PIX pixs, @Cast("l_float32") float fract, @Cast("l_int32") int factor );
public static native NUMA numaEqualizeTRC( PIX pix, @Cast("l_float32") float fract, @Cast("l_int32") int factor );
public static native @Cast("l_int32") int pixTRCMap( PIX pixs, PIX pixm, NUMA na );
public static native @Cast("l_int32") int pixTRCMapGeneral( PIX pixs, PIX pixm, NUMA nar, NUMA nag, NUMA nab );
public static native PIX pixUnsharpMasking( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract );
public static native PIX pixUnsharpMaskingGray( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract );
public static native PIX pixUnsharpMaskingFast( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract, @Cast("l_int32") int direction );
public static native PIX pixUnsharpMaskingGrayFast( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract, @Cast("l_int32") int direction );
public static native PIX pixUnsharpMaskingGray1D( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract, @Cast("l_int32") int direction );
public static native PIX pixUnsharpMaskingGray2D( PIX pixs, @Cast("l_int32") int halfwidth, @Cast("l_float32") float fract );
public static native PIX pixModifyHue( PIX pixd, PIX pixs, @Cast("l_float32") float fract );
public static native PIX pixModifySaturation( PIX pixd, PIX pixs, @Cast("l_float32") float fract );
public static native @Cast("l_int32") int pixMeasureSaturation( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") FloatPointer psat );
public static native @Cast("l_int32") int pixMeasureSaturation( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") FloatBuffer psat );
public static native @Cast("l_int32") int pixMeasureSaturation( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32*") float[] psat );
public static native PIX pixModifyBrightness( PIX pixd, PIX pixs, @Cast("l_float32") float fract );
public static native PIX pixMosaicColorShiftRGB( PIX pixs, @Cast("l_float32") float roff, @Cast("l_float32") float goff, @Cast("l_float32") float boff, @Cast("l_float32") float delta, @Cast("l_int32") int nincr );
public static native PIX pixColorShiftRGB( PIX pixs, @Cast("l_float32") float rfract, @Cast("l_float32") float gfract, @Cast("l_float32") float bfract );
public static native PIX pixDarkenGray( PIX pixd, PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32") int satlimit );
public static native PIX pixMultConstantColor( PIX pixs, @Cast("l_float32") float rfact, @Cast("l_float32") float gfact, @Cast("l_float32") float bfact );
public static native PIX pixMultMatrixColor( PIX pixs, L_KERNEL kel );
public static native PIX pixHalfEdgeByBandpass( PIX pixs, @Cast("l_int32") int sm1h, @Cast("l_int32") int sm1v, @Cast("l_int32") int sm2h, @Cast("l_int32") int sm2v );
public static native @Cast("l_ok") int fhmtautogen( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int fhmtautogen( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native @Cast("l_ok") int fhmtautogen1( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int fhmtautogen1( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native @Cast("l_ok") int fhmtautogen2( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int fhmtautogen2( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native PIX pixHMTDwa_1( PIX pixd, PIX pixs, @Cast("const char*") BytePointer selname );
public static native PIX pixHMTDwa_1( PIX pixd, PIX pixs, String selname );
public static native PIX pixFHMTGen_1( PIX pixd, PIX pixs, @Cast("const char*") BytePointer selname );
public static native PIX pixFHMTGen_1( PIX pixd, PIX pixs, String selname );
public static native @Cast("l_int32") int fhmtgen_low_1( @Cast("l_uint32*") IntPointer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fhmtgen_low_1( @Cast("l_uint32*") IntBuffer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fhmtgen_low_1( @Cast("l_uint32*") int[] datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_ok") int pixItalicWords( PIX pixs, BOXA boxaw, PIX pixw, @Cast("BOXA**") PointerPointer pboxa, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int pixItalicWords( PIX pixs, BOXA boxaw, PIX pixw, @ByPtrPtr BOXA pboxa, @Cast("l_int32") int debugflag );
public static native PIX pixOrientCorrect( PIX pixs, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_float32*") FloatPointer pupconf, @Cast("l_float32*") FloatPointer pleftconf, @Cast("l_int32*") IntPointer protation, @Cast("l_int32") int debug );
public static native PIX pixOrientCorrect( PIX pixs, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_float32*") FloatBuffer pupconf, @Cast("l_float32*") FloatBuffer pleftconf, @Cast("l_int32*") IntBuffer protation, @Cast("l_int32") int debug );
public static native PIX pixOrientCorrect( PIX pixs, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_float32*") float[] pupconf, @Cast("l_float32*") float[] pleftconf, @Cast("l_int32*") int[] protation, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixOrientDetect( PIX pixs, @Cast("l_float32*") FloatPointer pupconf, @Cast("l_float32*") FloatPointer pleftconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixOrientDetect( PIX pixs, @Cast("l_float32*") FloatBuffer pupconf, @Cast("l_float32*") FloatBuffer pleftconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixOrientDetect( PIX pixs, @Cast("l_float32*") float[] pupconf, @Cast("l_float32*") float[] pleftconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int makeOrientDecision( @Cast("l_float32") float upconf, @Cast("l_float32") float leftconf, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_int32*") IntPointer porient, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int makeOrientDecision( @Cast("l_float32") float upconf, @Cast("l_float32") float leftconf, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_int32*") IntBuffer porient, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int makeOrientDecision( @Cast("l_float32") float upconf, @Cast("l_float32") float leftconf, @Cast("l_float32") float minupconf, @Cast("l_float32") float minratio, @Cast("l_int32*") int[] porient, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixUpDownDetect( PIX pixs, @Cast("l_float32*") FloatPointer pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int npixels, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixUpDownDetect( PIX pixs, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int npixels, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixUpDownDetect( PIX pixs, @Cast("l_float32*") float[] pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int npixels, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixMirrorDetect( PIX pixs, @Cast("l_float32*") FloatPointer pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixMirrorDetect( PIX pixs, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixMirrorDetect( PIX pixs, @Cast("l_float32*") float[] pconf, @Cast("l_int32") int mincount, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int fmorphautogen( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int fmorphautogen( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native @Cast("l_ok") int fmorphautogen1( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int fmorphautogen1( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native @Cast("l_int32") int fmorphautogen2( SELA sela, @Cast("l_int32") int fileindex, @Cast("const char*") BytePointer filename );
public static native @Cast("l_int32") int fmorphautogen2( SELA sela, @Cast("l_int32") int fileindex, String filename );
public static native PIX pixMorphDwa_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") BytePointer selname );
public static native PIX pixMorphDwa_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") ByteBuffer selname );
public static native PIX pixMorphDwa_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") byte[] selname );
public static native PIX pixFMorphopGen_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") BytePointer selname );
public static native PIX pixFMorphopGen_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") ByteBuffer selname );
public static native PIX pixFMorphopGen_1( PIX pixd, PIX pixs, @Cast("l_int32") int operation, @Cast("char*") byte[] selname );
public static native @Cast("l_int32") int fmorphopgen_low_1( @Cast("l_uint32*") IntPointer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fmorphopgen_low_1( @Cast("l_uint32*") IntBuffer datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native @Cast("l_int32") int fmorphopgen_low_1( @Cast("l_uint32*") int[] datad, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int wpld, @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpls, @Cast("l_int32") int index );
public static native FPIX fpixCreate( @Cast("l_int32") int width, @Cast("l_int32") int height );
public static native FPIX fpixCreateTemplate( FPIX fpixs );
public static native FPIX fpixClone( FPIX fpix );
public static native FPIX fpixCopy( FPIX fpixs );
public static native void fpixDestroy( @Cast("FPIX**") PointerPointer pfpix );
public static native void fpixDestroy( @ByPtrPtr FPIX pfpix );
public static native @Cast("l_ok") int fpixGetDimensions( FPIX fpix, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int fpixGetDimensions( FPIX fpix, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int fpixGetDimensions( FPIX fpix, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int fpixSetDimensions( FPIX fpix, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native @Cast("l_int32") int fpixGetWpl( FPIX fpix );
public static native @Cast("l_ok") int fpixSetWpl( FPIX fpix, @Cast("l_int32") int wpl );
public static native @Cast("l_int32") int fpixGetRefcount( FPIX fpix );
public static native @Cast("l_ok") int fpixChangeRefcount( FPIX fpix, @Cast("l_int32") int delta );
public static native @Cast("l_ok") int fpixGetResolution( FPIX fpix, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_ok") int fpixGetResolution( FPIX fpix, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_ok") int fpixGetResolution( FPIX fpix, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int fpixSetResolution( FPIX fpix, @Cast("l_int32") int xres, @Cast("l_int32") int yres );
public static native @Cast("l_ok") int fpixCopyResolution( FPIX fpixd, FPIX fpixs );
public static native @Cast("l_float32*") FloatPointer fpixGetData( FPIX fpix );
public static native @Cast("l_ok") int fpixSetData( FPIX fpix, @Cast("l_float32*") FloatPointer data );
public static native @Cast("l_ok") int fpixSetData( FPIX fpix, @Cast("l_float32*") FloatBuffer data );
public static native @Cast("l_ok") int fpixSetData( FPIX fpix, @Cast("l_float32*") float[] data );
public static native @Cast("l_ok") int fpixGetPixel( FPIX fpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int fpixGetPixel( FPIX fpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int fpixGetPixel( FPIX fpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int fpixSetPixel( FPIX fpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float val );
public static native FPIXA fpixaCreate( @Cast("l_int32") int n );
public static native FPIXA fpixaCopy( FPIXA fpixa, @Cast("l_int32") int copyflag );
public static native void fpixaDestroy( @Cast("FPIXA**") PointerPointer pfpixa );
public static native void fpixaDestroy( @ByPtrPtr FPIXA pfpixa );
public static native @Cast("l_ok") int fpixaAddFPix( FPIXA fpixa, FPIX fpix, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int fpixaGetCount( FPIXA fpixa );
public static native @Cast("l_ok") int fpixaChangeRefcount( FPIXA fpixa, @Cast("l_int32") int delta );
public static native FPIX fpixaGetFPix( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32") int accesstype );
public static native @Cast("l_ok") int fpixaGetFPixDimensions( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int fpixaGetFPixDimensions( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int fpixaGetFPixDimensions( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_float32*") FloatPointer fpixaGetData( FPIXA fpixa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int fpixaGetPixel( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int fpixaGetPixel( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int fpixaGetPixel( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int fpixaSetPixel( FPIXA fpixa, @Cast("l_int32") int index, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float val );
public static native DPIX dpixCreate( @Cast("l_int32") int width, @Cast("l_int32") int height );
public static native DPIX dpixCreateTemplate( DPIX dpixs );
public static native DPIX dpixClone( DPIX dpix );
public static native DPIX dpixCopy( DPIX dpixs );
public static native void dpixDestroy( @Cast("DPIX**") PointerPointer pdpix );
public static native void dpixDestroy( @ByPtrPtr DPIX pdpix );
public static native @Cast("l_ok") int dpixGetDimensions( DPIX dpix, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int dpixGetDimensions( DPIX dpix, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int dpixGetDimensions( DPIX dpix, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int dpixSetDimensions( DPIX dpix, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native @Cast("l_int32") int dpixGetWpl( DPIX dpix );
public static native @Cast("l_ok") int dpixSetWpl( DPIX dpix, @Cast("l_int32") int wpl );
public static native @Cast("l_int32") int dpixGetRefcount( DPIX dpix );
public static native @Cast("l_ok") int dpixChangeRefcount( DPIX dpix, @Cast("l_int32") int delta );
public static native @Cast("l_ok") int dpixGetResolution( DPIX dpix, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_ok") int dpixGetResolution( DPIX dpix, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_ok") int dpixGetResolution( DPIX dpix, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int dpixSetResolution( DPIX dpix, @Cast("l_int32") int xres, @Cast("l_int32") int yres );
public static native @Cast("l_ok") int dpixCopyResolution( DPIX dpixd, DPIX dpixs );
public static native @Cast("l_float64*") DoublePointer dpixGetData( DPIX dpix );
public static native @Cast("l_ok") int dpixSetData( DPIX dpix, @Cast("l_float64*") DoublePointer data );
public static native @Cast("l_ok") int dpixSetData( DPIX dpix, @Cast("l_float64*") DoubleBuffer data );
public static native @Cast("l_ok") int dpixSetData( DPIX dpix, @Cast("l_float64*") double[] data );
public static native @Cast("l_ok") int dpixGetPixel( DPIX dpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float64*") DoublePointer pval );
public static native @Cast("l_ok") int dpixGetPixel( DPIX dpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float64*") DoubleBuffer pval );
public static native @Cast("l_ok") int dpixGetPixel( DPIX dpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float64*") double[] pval );
public static native @Cast("l_ok") int dpixSetPixel( DPIX dpix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float64") double val );
public static native FPIX fpixRead( @Cast("const char*") BytePointer filename );
public static native FPIX fpixRead( String filename );
public static native FPIX fpixReadStream( @Cast("FILE*") Pointer fp );
public static native FPIX fpixReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native FPIX fpixReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native FPIX fpixReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int fpixWrite( @Cast("const char*") BytePointer filename, FPIX fpix );
public static native @Cast("l_ok") int fpixWrite( String filename, FPIX fpix );
public static native @Cast("l_ok") int fpixWriteStream( @Cast("FILE*") Pointer fp, FPIX fpix );
public static native @Cast("l_ok") int fpixWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, FPIX fpix );
public static native @Cast("l_ok") int fpixWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, FPIX fpix );
public static native @Cast("l_ok") int fpixWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, FPIX fpix );
public static native @Cast("l_ok") int fpixWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, FPIX fpix );
public static native FPIX fpixEndianByteSwap( FPIX fpixd, FPIX fpixs );
public static native DPIX dpixRead( @Cast("const char*") BytePointer filename );
public static native DPIX dpixRead( String filename );
public static native DPIX dpixReadStream( @Cast("FILE*") Pointer fp );
public static native DPIX dpixReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native DPIX dpixReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native DPIX dpixReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int dpixWrite( @Cast("const char*") BytePointer filename, DPIX dpix );
public static native @Cast("l_ok") int dpixWrite( String filename, DPIX dpix );
public static native @Cast("l_ok") int dpixWriteStream( @Cast("FILE*") Pointer fp, DPIX dpix );
public static native @Cast("l_ok") int dpixWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, DPIX dpix );
public static native @Cast("l_ok") int dpixWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, DPIX dpix );
public static native @Cast("l_ok") int dpixWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, DPIX dpix );
public static native @Cast("l_ok") int dpixWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, DPIX dpix );
public static native DPIX dpixEndianByteSwap( DPIX dpixd, DPIX dpixs );
public static native @Cast("l_ok") int fpixPrintStream( @Cast("FILE*") Pointer fp, FPIX fpix, @Cast("l_int32") int factor );
public static native FPIX pixConvertToFPix( PIX pixs, @Cast("l_int32") int ncomps );
public static native DPIX pixConvertToDPix( PIX pixs, @Cast("l_int32") int ncomps );
public static native PIX fpixConvertToPix( FPIX fpixs, @Cast("l_int32") int outdepth, @Cast("l_int32") int negvals, @Cast("l_int32") int errorflag );
public static native PIX fpixDisplayMaxDynamicRange( FPIX fpixs );
public static native DPIX fpixConvertToDPix( FPIX fpix );
public static native PIX dpixConvertToPix( DPIX dpixs, @Cast("l_int32") int outdepth, @Cast("l_int32") int negvals, @Cast("l_int32") int errorflag );
public static native FPIX dpixConvertToFPix( DPIX dpix );
public static native @Cast("l_ok") int fpixGetMin( FPIX fpix, @Cast("l_float32*") FloatPointer pminval, @Cast("l_int32*") IntPointer pxminloc, @Cast("l_int32*") IntPointer pyminloc );
public static native @Cast("l_ok") int fpixGetMin( FPIX fpix, @Cast("l_float32*") FloatBuffer pminval, @Cast("l_int32*") IntBuffer pxminloc, @Cast("l_int32*") IntBuffer pyminloc );
public static native @Cast("l_ok") int fpixGetMin( FPIX fpix, @Cast("l_float32*") float[] pminval, @Cast("l_int32*") int[] pxminloc, @Cast("l_int32*") int[] pyminloc );
public static native @Cast("l_ok") int fpixGetMax( FPIX fpix, @Cast("l_float32*") FloatPointer pmaxval, @Cast("l_int32*") IntPointer pxmaxloc, @Cast("l_int32*") IntPointer pymaxloc );
public static native @Cast("l_ok") int fpixGetMax( FPIX fpix, @Cast("l_float32*") FloatBuffer pmaxval, @Cast("l_int32*") IntBuffer pxmaxloc, @Cast("l_int32*") IntBuffer pymaxloc );
public static native @Cast("l_ok") int fpixGetMax( FPIX fpix, @Cast("l_float32*") float[] pmaxval, @Cast("l_int32*") int[] pxmaxloc, @Cast("l_int32*") int[] pymaxloc );
public static native @Cast("l_ok") int dpixGetMin( DPIX dpix, @Cast("l_float64*") DoublePointer pminval, @Cast("l_int32*") IntPointer pxminloc, @Cast("l_int32*") IntPointer pyminloc );
public static native @Cast("l_ok") int dpixGetMin( DPIX dpix, @Cast("l_float64*") DoubleBuffer pminval, @Cast("l_int32*") IntBuffer pxminloc, @Cast("l_int32*") IntBuffer pyminloc );
public static native @Cast("l_ok") int dpixGetMin( DPIX dpix, @Cast("l_float64*") double[] pminval, @Cast("l_int32*") int[] pxminloc, @Cast("l_int32*") int[] pyminloc );
public static native @Cast("l_ok") int dpixGetMax( DPIX dpix, @Cast("l_float64*") DoublePointer pmaxval, @Cast("l_int32*") IntPointer pxmaxloc, @Cast("l_int32*") IntPointer pymaxloc );
public static native @Cast("l_ok") int dpixGetMax( DPIX dpix, @Cast("l_float64*") DoubleBuffer pmaxval, @Cast("l_int32*") IntBuffer pxmaxloc, @Cast("l_int32*") IntBuffer pymaxloc );
public static native @Cast("l_ok") int dpixGetMax( DPIX dpix, @Cast("l_float64*") double[] pmaxval, @Cast("l_int32*") int[] pxmaxloc, @Cast("l_int32*") int[] pymaxloc );
public static native FPIX fpixScaleByInteger( FPIX fpixs, @Cast("l_int32") int factor );
public static native DPIX dpixScaleByInteger( DPIX dpixs, @Cast("l_int32") int factor );
public static native FPIX fpixLinearCombination( FPIX fpixd, FPIX fpixs1, FPIX fpixs2, @Cast("l_float32") float a, @Cast("l_float32") float b );
public static native @Cast("l_ok") int fpixAddMultConstant( FPIX fpix, @Cast("l_float32") float addc, @Cast("l_float32") float multc );
public static native DPIX dpixLinearCombination( DPIX dpixd, DPIX dpixs1, DPIX dpixs2, @Cast("l_float32") float a, @Cast("l_float32") float b );
public static native @Cast("l_ok") int dpixAddMultConstant( DPIX dpix, @Cast("l_float64") double addc, @Cast("l_float64") double multc );
public static native @Cast("l_ok") int fpixSetAllArbitrary( FPIX fpix, @Cast("l_float32") float inval );
public static native @Cast("l_ok") int dpixSetAllArbitrary( DPIX dpix, @Cast("l_float64") double inval );
public static native FPIX fpixAddBorder( FPIX fpixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native FPIX fpixRemoveBorder( FPIX fpixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native FPIX fpixAddMirroredBorder( FPIX fpixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native FPIX fpixAddContinuedBorder( FPIX fpixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native FPIX fpixAddSlopeBorder( FPIX fpixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native @Cast("l_ok") int fpixRasterop( FPIX fpixd, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, FPIX fpixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native FPIX fpixRotateOrth( FPIX fpixs, @Cast("l_int32") int quads );
public static native FPIX fpixRotate180( FPIX fpixd, FPIX fpixs );
public static native FPIX fpixRotate90( FPIX fpixs, @Cast("l_int32") int direction );
public static native FPIX fpixFlipLR( FPIX fpixd, FPIX fpixs );
public static native FPIX fpixFlipTB( FPIX fpixd, FPIX fpixs );
public static native FPIX fpixAffinePta( FPIX fpixs, PTA ptad, PTA ptas, @Cast("l_int32") int border, @Cast("l_float32") float inval );
public static native FPIX fpixAffine( FPIX fpixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_float32") float inval );
public static native FPIX fpixAffine( FPIX fpixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_float32") float inval );
public static native FPIX fpixAffine( FPIX fpixs, @Cast("l_float32*") float[] vc, @Cast("l_float32") float inval );
public static native FPIX fpixProjectivePta( FPIX fpixs, PTA ptad, PTA ptas, @Cast("l_int32") int border, @Cast("l_float32") float inval );
public static native FPIX fpixProjective( FPIX fpixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_float32") float inval );
public static native FPIX fpixProjective( FPIX fpixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_float32") float inval );
public static native FPIX fpixProjective( FPIX fpixs, @Cast("l_float32*") float[] vc, @Cast("l_float32") float inval );
public static native @Cast("l_ok") int linearInterpolatePixelFloat( @Cast("l_float32*") FloatPointer datas, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_float32") float inval, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int linearInterpolatePixelFloat( @Cast("l_float32*") FloatBuffer datas, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_float32") float inval, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int linearInterpolatePixelFloat( @Cast("l_float32*") float[] datas, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_float32") float inval, @Cast("l_float32*") float[] pval );
public static native PIX fpixThresholdToPix( FPIX fpix, @Cast("l_float32") float thresh );
public static native FPIX pixComponentFunction( PIX pix, @Cast("l_float32") float rnum, @Cast("l_float32") float gnum, @Cast("l_float32") float bnum, @Cast("l_float32") float rdenom, @Cast("l_float32") float gdenom, @Cast("l_float32") float bdenom );
public static native PIX pixReadStreamGif( @Cast("FILE*") Pointer fp );
public static native PIX pixReadMemGif( @Cast("const l_uint8*") BytePointer cdata, @Cast("size_t") long size );
public static native PIX pixReadMemGif( @Cast("const l_uint8*") ByteBuffer cdata, @Cast("size_t") long size );
public static native PIX pixReadMemGif( @Cast("const l_uint8*") byte[] cdata, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixWriteStreamGif( @Cast("FILE*") Pointer fp, PIX pix );
public static native @Cast("l_ok") int pixWriteMemGif( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemGif( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemGif( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemGif( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native GPLOT gplotCreate( @Cast("const char*") BytePointer rootname, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer xlabel, @Cast("const char*") BytePointer ylabel );
public static native GPLOT gplotCreate( String rootname, @Cast("l_int32") int outformat, String title, String xlabel, String ylabel );
public static native void gplotDestroy( @Cast("GPLOT**") PointerPointer pgplot );
public static native void gplotDestroy( @ByPtrPtr GPLOT pgplot );
public static native @Cast("l_ok") int gplotAddPlot( GPLOT gplot, NUMA nax, NUMA nay, @Cast("l_int32") int plotstyle, @Cast("const char*") BytePointer plotlabel );
public static native @Cast("l_ok") int gplotAddPlot( GPLOT gplot, NUMA nax, NUMA nay, @Cast("l_int32") int plotstyle, String plotlabel );
public static native @Cast("l_ok") int gplotSetScaling( GPLOT gplot, @Cast("l_int32") int scaling );
public static native PIX gplotMakeOutputPix( GPLOT gplot );
public static native @Cast("l_ok") int gplotMakeOutput( GPLOT gplot );
public static native @Cast("l_ok") int gplotGenCommandFile( GPLOT gplot );
public static native @Cast("l_ok") int gplotGenDataFiles( GPLOT gplot );
public static native @Cast("l_ok") int gplotSimple1( NUMA na, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int gplotSimple1( NUMA na, @Cast("l_int32") int outformat, String outroot, String title );
public static native @Cast("l_ok") int gplotSimple2( NUMA na1, NUMA na2, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int gplotSimple2( NUMA na1, NUMA na2, @Cast("l_int32") int outformat, String outroot, String title );
public static native @Cast("l_ok") int gplotSimpleN( NUMAA naa, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int gplotSimpleN( NUMAA naa, @Cast("l_int32") int outformat, String outroot, String title );
public static native PIX gplotSimplePix1( NUMA na, @Cast("const char*") BytePointer title );
public static native PIX gplotSimplePix1( NUMA na, String title );
public static native PIX gplotSimplePix2( NUMA na1, NUMA na2, @Cast("const char*") BytePointer title );
public static native PIX gplotSimplePix2( NUMA na1, NUMA na2, String title );
public static native PIX gplotSimplePixN( NUMAA naa, @Cast("const char*") BytePointer title );
public static native PIX gplotSimplePixN( NUMAA naa, String title );
public static native GPLOT gplotSimpleXY1( NUMA nax, NUMA nay, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native GPLOT gplotSimpleXY1( NUMA nax, NUMA nay, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, String outroot, String title );
public static native GPLOT gplotSimpleXY2( NUMA nax, NUMA nay1, NUMA nay2, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native GPLOT gplotSimpleXY2( NUMA nax, NUMA nay1, NUMA nay2, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, String outroot, String title );
public static native GPLOT gplotSimpleXYN( NUMA nax, NUMAA naay, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer title );
public static native GPLOT gplotSimpleXYN( NUMA nax, NUMAA naay, @Cast("l_int32") int plotstyle, @Cast("l_int32") int outformat, String outroot, String title );
public static native PIX gplotGeneralPix1( NUMA na, @Cast("l_int32") int plotstyle, @Cast("const char*") BytePointer rootname, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer xlabel, @Cast("const char*") BytePointer ylabel );
public static native PIX gplotGeneralPix1( NUMA na, @Cast("l_int32") int plotstyle, String rootname, String title, String xlabel, String ylabel );
public static native PIX gplotGeneralPix2( NUMA na1, NUMA na2, @Cast("l_int32") int plotstyle, @Cast("const char*") BytePointer rootname, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer xlabel, @Cast("const char*") BytePointer ylabel );
public static native PIX gplotGeneralPix2( NUMA na1, NUMA na2, @Cast("l_int32") int plotstyle, String rootname, String title, String xlabel, String ylabel );
public static native PIX gplotGeneralPixN( NUMA nax, NUMAA naay, @Cast("l_int32") int plotstyle, @Cast("const char*") BytePointer rootname, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer xlabel, @Cast("const char*") BytePointer ylabel );
public static native PIX gplotGeneralPixN( NUMA nax, NUMAA naay, @Cast("l_int32") int plotstyle, String rootname, String title, String xlabel, String ylabel );
public static native GPLOT gplotRead( @Cast("const char*") BytePointer filename );
public static native GPLOT gplotRead( String filename );
public static native @Cast("l_ok") int gplotWrite( @Cast("const char*") BytePointer filename, GPLOT gplot );
public static native @Cast("l_ok") int gplotWrite( String filename, GPLOT gplot );
public static native PTA generatePtaLine( @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2 );
public static native PTA generatePtaWideLine( @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int width );
public static native PTA generatePtaBox( BOX box, @Cast("l_int32") int width );
public static native PTA generatePtaBoxa( BOXA boxa, @Cast("l_int32") int width, @Cast("l_int32") int removedups );
public static native PTA generatePtaHashBox( BOX box, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline );
public static native PTA generatePtaHashBoxa( BOXA boxa, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int removedups );
public static native PTAA generatePtaaBoxa( BOXA boxa );
public static native PTAA generatePtaaHashBoxa( BOXA boxa, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline );
public static native PTA generatePtaPolyline( PTA ptas, @Cast("l_int32") int width, @Cast("l_int32") int closeflag, @Cast("l_int32") int removedups );
public static native PTA generatePtaGrid( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int width );
public static native PTA convertPtaLineTo4cc( PTA ptas );
public static native PTA generatePtaFilledCircle( @Cast("l_int32") int radius );
public static native PTA generatePtaFilledSquare( @Cast("l_int32") int side );
public static native PTA generatePtaLineFromPt( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float64") double length, @Cast("l_float64") double radang );
public static native @Cast("l_ok") int locatePtRadially( @Cast("l_int32") int xr, @Cast("l_int32") int yr, @Cast("l_float64") double dist, @Cast("l_float64") double radang, @Cast("l_float64*") DoublePointer px, @Cast("l_float64*") DoublePointer py );
public static native @Cast("l_ok") int locatePtRadially( @Cast("l_int32") int xr, @Cast("l_int32") int yr, @Cast("l_float64") double dist, @Cast("l_float64") double radang, @Cast("l_float64*") DoubleBuffer px, @Cast("l_float64*") DoubleBuffer py );
public static native @Cast("l_ok") int locatePtRadially( @Cast("l_int32") int xr, @Cast("l_int32") int yr, @Cast("l_float64") double dist, @Cast("l_float64") double radang, @Cast("l_float64*") double[] px, @Cast("l_float64*") double[] py );
public static native @Cast("l_ok") int pixRenderPlotFromNuma( @Cast("PIX**") PointerPointer ppix, NUMA na, @Cast("l_int32") int plotloc, @Cast("l_int32") int linewidth, @Cast("l_int32") int max, @Cast("l_uint32") int color );
public static native @Cast("l_ok") int pixRenderPlotFromNuma( @ByPtrPtr PIX ppix, NUMA na, @Cast("l_int32") int plotloc, @Cast("l_int32") int linewidth, @Cast("l_int32") int max, @Cast("l_uint32") int color );
public static native PTA makePlotPtaFromNuma( NUMA na, @Cast("l_int32") int size, @Cast("l_int32") int plotloc, @Cast("l_int32") int linewidth, @Cast("l_int32") int max );
public static native @Cast("l_ok") int pixRenderPlotFromNumaGen( @Cast("PIX**") PointerPointer ppix, NUMA na, @Cast("l_int32") int orient, @Cast("l_int32") int linewidth, @Cast("l_int32") int refpos, @Cast("l_int32") int max, @Cast("l_int32") int drawref, @Cast("l_uint32") int color );
public static native @Cast("l_ok") int pixRenderPlotFromNumaGen( @ByPtrPtr PIX ppix, NUMA na, @Cast("l_int32") int orient, @Cast("l_int32") int linewidth, @Cast("l_int32") int refpos, @Cast("l_int32") int max, @Cast("l_int32") int drawref, @Cast("l_uint32") int color );
public static native PTA makePlotPtaFromNumaGen( NUMA na, @Cast("l_int32") int orient, @Cast("l_int32") int linewidth, @Cast("l_int32") int refpos, @Cast("l_int32") int max, @Cast("l_int32") int drawref );
public static native @Cast("l_ok") int pixRenderPta( PIX pix, PTA pta, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderPtaArb( PIX pix, PTA pta, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval );
public static native @Cast("l_ok") int pixRenderPtaBlend( PIX pix, PTA pta, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixRenderLine( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int width, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderLineArb( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval );
public static native @Cast("l_ok") int pixRenderLineBlend( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixRenderBox( PIX pix, BOX box, @Cast("l_int32") int width, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderBoxArb( PIX pix, BOX box, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval );
public static native @Cast("l_ok") int pixRenderBoxBlend( PIX pix, BOX box, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixRenderBoxa( PIX pix, BOXA boxa, @Cast("l_int32") int width, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderBoxaArb( PIX pix, BOXA boxa, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval );
public static native @Cast("l_ok") int pixRenderBoxaBlend( PIX pix, BOXA boxa, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_float32") float fract, @Cast("l_int32") int removedups );
public static native @Cast("l_ok") int pixRenderHashBox( PIX pix, BOX box, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderHashBoxArb( PIX pix, BOX box, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixRenderHashBoxBlend( PIX pix, BOX box, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixRenderHashMaskArb( PIX pix, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixRenderHashBoxa( PIX pix, BOXA boxa, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixRenderHashBoxaArb( PIX pix, BOXA boxa, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixRenderHashBoxaBlend( PIX pix, BOXA boxa, @Cast("l_int32") int spacing, @Cast("l_int32") int width, @Cast("l_int32") int orient, @Cast("l_int32") int outline, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixRenderPolyline( PIX pix, PTA ptas, @Cast("l_int32") int width, @Cast("l_int32") int op, @Cast("l_int32") int closeflag );
public static native @Cast("l_ok") int pixRenderPolylineArb( PIX pix, PTA ptas, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_int32") int closeflag );
public static native @Cast("l_ok") int pixRenderPolylineBlend( PIX pix, PTA ptas, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval, @Cast("l_float32") float fract, @Cast("l_int32") int closeflag, @Cast("l_int32") int removedups );
public static native @Cast("l_ok") int pixRenderGridArb( PIX pix, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int width, @Cast("l_uint8") byte rval, @Cast("l_uint8") byte gval, @Cast("l_uint8") byte bval );
public static native PIX pixRenderRandomCmapPtaa( PIX pix, PTAA ptaa, @Cast("l_int32") int polyflag, @Cast("l_int32") int width, @Cast("l_int32") int closeflag );
public static native PIX pixRenderPolygon( PTA ptas, @Cast("l_int32") int width, @Cast("l_int32*") IntPointer pxmin, @Cast("l_int32*") IntPointer pymin );
public static native PIX pixRenderPolygon( PTA ptas, @Cast("l_int32") int width, @Cast("l_int32*") IntBuffer pxmin, @Cast("l_int32*") IntBuffer pymin );
public static native PIX pixRenderPolygon( PTA ptas, @Cast("l_int32") int width, @Cast("l_int32*") int[] pxmin, @Cast("l_int32*") int[] pymin );
public static native PIX pixFillPolygon( PIX pixs, PTA pta, @Cast("l_int32") int xmin, @Cast("l_int32") int ymin );
public static native PIX pixRenderContours( PIX pixs, @Cast("l_int32") int startval, @Cast("l_int32") int incr, @Cast("l_int32") int outdepth );
public static native PIX fpixAutoRenderContours( FPIX fpix, @Cast("l_int32") int ncontours );
public static native PIX fpixRenderContours( FPIX fpixs, @Cast("l_float32") float incr, @Cast("l_float32") float proxim );
public static native PTA pixGeneratePtaBoundary( PIX pixs, @Cast("l_int32") int width );
public static native PIX pixErodeGray( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixDilateGray( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenGray( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseGray( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeGray3( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixDilateGray3( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenGray3( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseGray3( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixDitherToBinary( PIX pixs );
public static native PIX pixDitherToBinarySpec( PIX pixs, @Cast("l_int32") int lowerclip, @Cast("l_int32") int upperclip );
public static native void ditherToBinaryLineLow( @Cast("l_uint32*") IntPointer lined, @Cast("l_int32") int w, @Cast("l_uint32*") IntPointer bufs1, @Cast("l_uint32*") IntPointer bufs2, @Cast("l_int32") int lowerclip, @Cast("l_int32") int upperclip, @Cast("l_int32") int lastlineflag );
public static native void ditherToBinaryLineLow( @Cast("l_uint32*") IntBuffer lined, @Cast("l_int32") int w, @Cast("l_uint32*") IntBuffer bufs1, @Cast("l_uint32*") IntBuffer bufs2, @Cast("l_int32") int lowerclip, @Cast("l_int32") int upperclip, @Cast("l_int32") int lastlineflag );
public static native void ditherToBinaryLineLow( @Cast("l_uint32*") int[] lined, @Cast("l_int32") int w, @Cast("l_uint32*") int[] bufs1, @Cast("l_uint32*") int[] bufs2, @Cast("l_int32") int lowerclip, @Cast("l_int32") int upperclip, @Cast("l_int32") int lastlineflag );
public static native PIX pixThresholdToBinary( PIX pixs, @Cast("l_int32") int thresh );
public static native void thresholdToBinaryLineLow( @Cast("l_uint32*") IntPointer lined, @Cast("l_int32") int w, @Cast("l_uint32*") IntPointer lines, @Cast("l_int32") int d, @Cast("l_int32") int thresh );
public static native void thresholdToBinaryLineLow( @Cast("l_uint32*") IntBuffer lined, @Cast("l_int32") int w, @Cast("l_uint32*") IntBuffer lines, @Cast("l_int32") int d, @Cast("l_int32") int thresh );
public static native void thresholdToBinaryLineLow( @Cast("l_uint32*") int[] lined, @Cast("l_int32") int w, @Cast("l_uint32*") int[] lines, @Cast("l_int32") int d, @Cast("l_int32") int thresh );
public static native PIX pixVarThresholdToBinary( PIX pixs, PIX pixg );
public static native PIX pixAdaptThresholdToBinary( PIX pixs, PIX pixm, @Cast("l_float32") float gamma );
public static native PIX pixAdaptThresholdToBinaryGen( PIX pixs, PIX pixm, @Cast("l_float32") float gamma, @Cast("l_int32") int blackval, @Cast("l_int32") int whiteval, @Cast("l_int32") int thresh );
public static native PIX pixGenerateMaskByValue( PIX pixs, @Cast("l_int32") int val, @Cast("l_int32") int usecmap );
public static native PIX pixGenerateMaskByBand( PIX pixs, @Cast("l_int32") int lower, @Cast("l_int32") int upper, @Cast("l_int32") int inband, @Cast("l_int32") int usecmap );
public static native PIX pixDitherTo2bpp( PIX pixs, @Cast("l_int32") int cmapflag );
public static native PIX pixDitherTo2bppSpec( PIX pixs, @Cast("l_int32") int lowerclip, @Cast("l_int32") int upperclip, @Cast("l_int32") int cmapflag );
public static native PIX pixThresholdTo2bpp( PIX pixs, @Cast("l_int32") int nlevels, @Cast("l_int32") int cmapflag );
public static native PIX pixThresholdTo4bpp( PIX pixs, @Cast("l_int32") int nlevels, @Cast("l_int32") int cmapflag );
public static native PIX pixThresholdOn8bpp( PIX pixs, @Cast("l_int32") int nlevels, @Cast("l_int32") int cmapflag );
public static native PIX pixThresholdGrayArb( PIX pixs, @Cast("const char*") BytePointer edgevals, @Cast("l_int32") int outdepth, @Cast("l_int32") int use_average, @Cast("l_int32") int setblack, @Cast("l_int32") int setwhite );
public static native PIX pixThresholdGrayArb( PIX pixs, String edgevals, @Cast("l_int32") int outdepth, @Cast("l_int32") int use_average, @Cast("l_int32") int setblack, @Cast("l_int32") int setwhite );
public static native @Cast("l_int32*") IntPointer makeGrayQuantIndexTable( @Cast("l_int32") int nlevels );
public static native @Cast("l_ok") int makeGrayQuantTableArb( NUMA na, @Cast("l_int32") int outdepth, @Cast("l_int32**") PointerPointer ptab, @Cast("PIXCMAP**") PointerPointer pcmap );
public static native @Cast("l_ok") int makeGrayQuantTableArb( NUMA na, @Cast("l_int32") int outdepth, @Cast("l_int32**") @ByPtrPtr IntPointer ptab, @ByPtrPtr PIXCMAP pcmap );
public static native @Cast("l_ok") int makeGrayQuantTableArb( NUMA na, @Cast("l_int32") int outdepth, @Cast("l_int32**") @ByPtrPtr IntBuffer ptab, @ByPtrPtr PIXCMAP pcmap );
public static native @Cast("l_ok") int makeGrayQuantTableArb( NUMA na, @Cast("l_int32") int outdepth, @Cast("l_int32**") @ByPtrPtr int[] ptab, @ByPtrPtr PIXCMAP pcmap );
public static native PIX pixGenerateMaskByBand32( PIX pixs, @Cast("l_uint32") int refval, @Cast("l_int32") int delm, @Cast("l_int32") int delp, @Cast("l_float32") float fractm, @Cast("l_float32") float fractp );
public static native PIX pixGenerateMaskByDiscr32( PIX pixs, @Cast("l_uint32") int refval1, @Cast("l_uint32") int refval2, @Cast("l_int32") int distflag );
public static native PIX pixGrayQuantFromHisto( PIX pixd, PIX pixs, PIX pixm, @Cast("l_float32") float minfract, @Cast("l_int32") int maxsize );
public static native PIX pixGrayQuantFromCmap( PIX pixs, PIXCMAP cmap, @Cast("l_int32") int mindepth );
public static native L_HASHMAP l_hmapCreate( @Cast("l_int32") int ninit, @Cast("l_int32") int maxocc );
public static native void l_hmapDestroy( @Cast("L_HASHMAP**") PointerPointer phmap );
public static native void l_hmapDestroy( @ByPtrPtr L_HASHMAP phmap );
public static native L_HASHITEM l_hmapLookup( L_HASHMAP hmap, @Cast("l_uint64") long key, @Cast("l_uint64") long val, @Cast("l_int32") int op );
public static native @Cast("l_ok") int l_hmapRehash( L_HASHMAP hmap );
public static native L_HEAP lheapCreate( @Cast("l_int32") int n, @Cast("l_int32") int direction );
public static native void lheapDestroy( @Cast("L_HEAP**") PointerPointer plh, @Cast("l_int32") int freeflag );
public static native void lheapDestroy( @ByPtrPtr L_HEAP plh, @Cast("l_int32") int freeflag );
public static native @Cast("l_ok") int lheapAdd( L_HEAP lh, Pointer item );
public static native Pointer lheapRemove( L_HEAP lh );
public static native @Cast("l_int32") int lheapGetCount( L_HEAP lh );
public static native Pointer lheapGetElement( L_HEAP lh, @Cast("l_int32") int index );
public static native @Cast("l_ok") int lheapSort( L_HEAP lh );
public static native @Cast("l_ok") int lheapSortStrictOrder( L_HEAP lh );
public static native @Cast("l_ok") int lheapPrint( @Cast("FILE*") Pointer fp, L_HEAP lh );
public static native JBCLASSER jbRankHausInit( @Cast("l_int32") int components, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_int32") int size, @Cast("l_float32") float rank );
public static native JBCLASSER jbCorrelationInit( @Cast("l_int32") int components, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_float32") float thresh, @Cast("l_float32") float weightfactor );
public static native JBCLASSER jbCorrelationInitWithoutComponents( @Cast("l_int32") int components, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("l_float32") float thresh, @Cast("l_float32") float weightfactor );
public static native @Cast("l_ok") int jbAddPages( JBCLASSER classer, SARRAY safiles );
public static native @Cast("l_ok") int jbAddPage( JBCLASSER classer, PIX pixs );
public static native @Cast("l_ok") int jbAddPageComponents( JBCLASSER classer, PIX pixs, BOXA boxas, PIXA pixas );
public static native @Cast("l_ok") int jbClassifyRankHaus( JBCLASSER classer, BOXA boxa, PIXA pixas );
public static native @Cast("l_int32") int pixHaustest( PIX pix1, PIX pix2, PIX pix3, PIX pix4, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh );
public static native @Cast("l_int32") int pixRankHaustest( PIX pix1, PIX pix2, PIX pix3, PIX pix4, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32") int area1, @Cast("l_int32") int area3, @Cast("l_float32") float rank, @Cast("l_int32*") IntPointer tab8 );
public static native @Cast("l_int32") int pixRankHaustest( PIX pix1, PIX pix2, PIX pix3, PIX pix4, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32") int area1, @Cast("l_int32") int area3, @Cast("l_float32") float rank, @Cast("l_int32*") IntBuffer tab8 );
public static native @Cast("l_int32") int pixRankHaustest( PIX pix1, PIX pix2, PIX pix3, PIX pix4, @Cast("l_float32") float delx, @Cast("l_float32") float dely, @Cast("l_int32") int maxdiffw, @Cast("l_int32") int maxdiffh, @Cast("l_int32") int area1, @Cast("l_int32") int area3, @Cast("l_float32") float rank, @Cast("l_int32*") int[] tab8 );
public static native @Cast("l_ok") int jbClassifyCorrelation( JBCLASSER classer, BOXA boxa, PIXA pixas );
public static native @Cast("l_ok") int jbGetComponents( PIX pixs, @Cast("l_int32") int components, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("BOXA**") PointerPointer pboxad, @Cast("PIXA**") PointerPointer ppixad );
public static native @Cast("l_ok") int jbGetComponents( PIX pixs, @Cast("l_int32") int components, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxad, @ByPtrPtr PIXA ppixad );
public static native @Cast("l_ok") int pixWordMaskByDilation( PIX pixs, @Cast("PIX**") PointerPointer ppixm, @Cast("l_int32*") IntPointer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordMaskByDilation( PIX pixs, @ByPtrPtr PIX ppixm, @Cast("l_int32*") IntPointer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordMaskByDilation( PIX pixs, @ByPtrPtr PIX ppixm, @Cast("l_int32*") IntBuffer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordMaskByDilation( PIX pixs, @ByPtrPtr PIX ppixm, @Cast("l_int32*") int[] psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordBoxesByDilation( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @Cast("BOXA**") PointerPointer pboxa, @Cast("l_int32*") IntPointer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordBoxesByDilation( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxa, @Cast("l_int32*") IntPointer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordBoxesByDilation( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxa, @Cast("l_int32*") IntBuffer psize, PIXA pixadb );
public static native @Cast("l_ok") int pixWordBoxesByDilation( PIX pixs, @Cast("l_int32") int minwidth, @Cast("l_int32") int minheight, @Cast("l_int32") int maxwidth, @Cast("l_int32") int maxheight, @ByPtrPtr BOXA pboxa, @Cast("l_int32*") int[] psize, PIXA pixadb );
public static native PIXA jbAccumulateComposites( PIXAA pixaa, @Cast("NUMA**") PointerPointer pna, @Cast("PTA**") PointerPointer pptat );
public static native PIXA jbAccumulateComposites( PIXAA pixaa, @ByPtrPtr NUMA pna, @ByPtrPtr PTA pptat );
public static native PIXA jbTemplatesFromComposites( PIXA pixac, NUMA na );
public static native JBCLASSER jbClasserCreate( @Cast("l_int32") int method, @Cast("l_int32") int components );
public static native void jbClasserDestroy( @Cast("JBCLASSER**") PointerPointer pclasser );
public static native void jbClasserDestroy( @ByPtrPtr JBCLASSER pclasser );
public static native JBDATA jbDataSave( JBCLASSER classer );
public static native void jbDataDestroy( @Cast("JBDATA**") PointerPointer pdata );
public static native void jbDataDestroy( @ByPtrPtr JBDATA pdata );
public static native @Cast("l_ok") int jbDataWrite( @Cast("const char*") BytePointer rootout, JBDATA jbdata );
public static native @Cast("l_ok") int jbDataWrite( String rootout, JBDATA jbdata );
public static native JBDATA jbDataRead( @Cast("const char*") BytePointer rootname );
public static native JBDATA jbDataRead( String rootname );
public static native PIXA jbDataRender( JBDATA data, @Cast("l_int32") int debugflag );
public static native @Cast("l_ok") int jbGetULCorners( JBCLASSER classer, PIX pixs, BOXA boxa );
public static native @Cast("l_ok") int jbGetLLCorners( JBCLASSER classer );
public static native @Cast("l_ok") int readHeaderJp2k( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pcodec );
public static native @Cast("l_ok") int readHeaderJp2k( String filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pcodec );
public static native @Cast("l_ok") int readHeaderJp2k( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pcodec );
public static native @Cast("l_ok") int readHeaderJp2k( String filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pcodec );
public static native @Cast("l_ok") int readHeaderJp2k( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pcodec );
public static native @Cast("l_ok") int readHeaderJp2k( String filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pcodec );
public static native @Cast("l_ok") int freadHeaderJp2k( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pcodec );
public static native @Cast("l_ok") int freadHeaderJp2k( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pcodec );
public static native @Cast("l_ok") int freadHeaderJp2k( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pcodec );
public static native @Cast("l_ok") int readHeaderMemJp2k( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pcodec );
public static native @Cast("l_ok") int readHeaderMemJp2k( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pcodec );
public static native @Cast("l_ok") int readHeaderMemJp2k( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pcodec );
public static native @Cast("l_int32") int fgetJp2kResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_int32") int fgetJp2kResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_int32") int fgetJp2kResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native PIX pixReadJp2k( @Cast("const char*") BytePointer filename, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadJp2k( String filename, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadStreamJp2k( @Cast("FILE*") Pointer fp, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteJp2k( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteJp2k( String filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteStreamJp2k( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int codec, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadMemJp2k( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadMemJp2k( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadMemJp2k( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_uint32") int reduction, BOX box, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteMemJp2k( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteMemJp2k( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteMemJp2k( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixWriteMemJp2k( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int nlevels, @Cast("l_int32") int hint, @Cast("l_int32") int debug );
public static native PIX pixReadJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntPointer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadJpeg( String filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntBuffer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") int[] pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadJpeg( String filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntPointer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntBuffer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadJpeg( String filename, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") int[] pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadStreamJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntPointer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadStreamJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntBuffer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadStreamJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32") int cmapflag, @Cast("l_int32") int reduction, @Cast("l_int32*") int[] pnwarn, @Cast("l_int32") int hint );
public static native @Cast("l_ok") int readHeaderJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pycck, @Cast("l_int32*") IntPointer pcmyk );
public static native @Cast("l_ok") int readHeaderJpeg( String filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pycck, @Cast("l_int32*") IntBuffer pcmyk );
public static native @Cast("l_ok") int readHeaderJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pycck, @Cast("l_int32*") int[] pcmyk );
public static native @Cast("l_ok") int readHeaderJpeg( String filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pycck, @Cast("l_int32*") IntPointer pcmyk );
public static native @Cast("l_ok") int readHeaderJpeg( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pycck, @Cast("l_int32*") IntBuffer pcmyk );
public static native @Cast("l_ok") int readHeaderJpeg( String filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pycck, @Cast("l_int32*") int[] pcmyk );
public static native @Cast("l_ok") int freadHeaderJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pycck, @Cast("l_int32*") IntPointer pcmyk );
public static native @Cast("l_ok") int freadHeaderJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pycck, @Cast("l_int32*") IntBuffer pcmyk );
public static native @Cast("l_ok") int freadHeaderJpeg( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pycck, @Cast("l_int32*") int[] pcmyk );
public static native @Cast("l_int32") int fgetJpegResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_int32") int fgetJpegResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_int32") int fgetJpegResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_int32") int fgetJpegComment( @Cast("FILE*") Pointer fp, @Cast("l_uint8**") PointerPointer pcomment );
public static native @Cast("l_int32") int fgetJpegComment( @Cast("FILE*") Pointer fp, @Cast("l_uint8**") @ByPtrPtr BytePointer pcomment );
public static native @Cast("l_int32") int fgetJpegComment( @Cast("FILE*") Pointer fp, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pcomment );
public static native @Cast("l_int32") int fgetJpegComment( @Cast("FILE*") Pointer fp, @Cast("l_uint8**") @ByPtrPtr byte[] pcomment );
public static native @Cast("l_ok") int pixWriteJpeg( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteJpeg( String filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteStreamJpeg( @Cast("FILE*") Pointer fp, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native PIX pixReadMemJpeg( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32") int cmflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntPointer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadMemJpeg( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32") int cmflag, @Cast("l_int32") int reduction, @Cast("l_int32*") IntBuffer pnwarn, @Cast("l_int32") int hint );
public static native PIX pixReadMemJpeg( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32") int cmflag, @Cast("l_int32") int reduction, @Cast("l_int32*") int[] pnwarn, @Cast("l_int32") int hint );
public static native @Cast("l_ok") int readHeaderMemJpeg( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pycck, @Cast("l_int32*") IntPointer pcmyk );
public static native @Cast("l_ok") int readHeaderMemJpeg( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pycck, @Cast("l_int32*") IntBuffer pcmyk );
public static native @Cast("l_ok") int readHeaderMemJpeg( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pycck, @Cast("l_int32*") int[] pcmyk );
public static native @Cast("l_ok") int readResolutionMemJpeg( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_ok") int readResolutionMemJpeg( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_ok") int readResolutionMemJpeg( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int pixWriteMemJpeg( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteMemJpeg( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteMemJpeg( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteMemJpeg( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixSetChromaSampling( PIX pix, @Cast("l_int32") int sampling );
public static native L_KERNEL kernelCreate( @Cast("l_int32") int height, @Cast("l_int32") int width );
public static native void kernelDestroy( @Cast("L_KERNEL**") PointerPointer pkel );
public static native void kernelDestroy( @ByPtrPtr L_KERNEL pkel );
public static native L_KERNEL kernelCopy( L_KERNEL kels );
public static native @Cast("l_ok") int kernelGetElement( L_KERNEL kel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int kernelGetElement( L_KERNEL kel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int kernelGetElement( L_KERNEL kel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int kernelSetElement( L_KERNEL kel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_float32") float val );
public static native @Cast("l_ok") int kernelGetParameters( L_KERNEL kel, @Cast("l_int32*") IntPointer psy, @Cast("l_int32*") IntPointer psx, @Cast("l_int32*") IntPointer pcy, @Cast("l_int32*") IntPointer pcx );
public static native @Cast("l_ok") int kernelGetParameters( L_KERNEL kel, @Cast("l_int32*") IntBuffer psy, @Cast("l_int32*") IntBuffer psx, @Cast("l_int32*") IntBuffer pcy, @Cast("l_int32*") IntBuffer pcx );
public static native @Cast("l_ok") int kernelGetParameters( L_KERNEL kel, @Cast("l_int32*") int[] psy, @Cast("l_int32*") int[] psx, @Cast("l_int32*") int[] pcy, @Cast("l_int32*") int[] pcx );
public static native @Cast("l_ok") int kernelSetOrigin( L_KERNEL kel, @Cast("l_int32") int cy, @Cast("l_int32") int cx );
public static native @Cast("l_ok") int kernelGetSum( L_KERNEL kel, @Cast("l_float32*") FloatPointer psum );
public static native @Cast("l_ok") int kernelGetSum( L_KERNEL kel, @Cast("l_float32*") FloatBuffer psum );
public static native @Cast("l_ok") int kernelGetSum( L_KERNEL kel, @Cast("l_float32*") float[] psum );
public static native @Cast("l_ok") int kernelGetMinMax( L_KERNEL kel, @Cast("l_float32*") FloatPointer pmin, @Cast("l_float32*") FloatPointer pmax );
public static native @Cast("l_ok") int kernelGetMinMax( L_KERNEL kel, @Cast("l_float32*") FloatBuffer pmin, @Cast("l_float32*") FloatBuffer pmax );
public static native @Cast("l_ok") int kernelGetMinMax( L_KERNEL kel, @Cast("l_float32*") float[] pmin, @Cast("l_float32*") float[] pmax );
public static native L_KERNEL kernelNormalize( L_KERNEL kels, @Cast("l_float32") float normsum );
public static native L_KERNEL kernelInvert( L_KERNEL kels );
public static native @Cast("l_float32**") PointerPointer create2dFloatArray( @Cast("l_int32") int sy, @Cast("l_int32") int sx );
public static native L_KERNEL kernelRead( @Cast("const char*") BytePointer fname );
public static native L_KERNEL kernelRead( String fname );
public static native L_KERNEL kernelReadStream( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int kernelWrite( @Cast("const char*") BytePointer fname, L_KERNEL kel );
public static native @Cast("l_ok") int kernelWrite( String fname, L_KERNEL kel );
public static native @Cast("l_ok") int kernelWriteStream( @Cast("FILE*") Pointer fp, L_KERNEL kel );
public static native L_KERNEL kernelCreateFromString( @Cast("l_int32") int h, @Cast("l_int32") int w, @Cast("l_int32") int cy, @Cast("l_int32") int cx, @Cast("const char*") BytePointer kdata );
public static native L_KERNEL kernelCreateFromString( @Cast("l_int32") int h, @Cast("l_int32") int w, @Cast("l_int32") int cy, @Cast("l_int32") int cx, String kdata );
public static native L_KERNEL kernelCreateFromFile( @Cast("const char*") BytePointer filename );
public static native L_KERNEL kernelCreateFromFile( String filename );
public static native L_KERNEL kernelCreateFromPix( PIX pix, @Cast("l_int32") int cy, @Cast("l_int32") int cx );
public static native PIX kernelDisplayInPix( L_KERNEL kel, @Cast("l_int32") int size, @Cast("l_int32") int gthick );
public static native NUMA parseStringForNumbers( @Cast("const char*") BytePointer str, @Cast("const char*") BytePointer seps );
public static native NUMA parseStringForNumbers( String str, String seps );
public static native L_KERNEL makeFlatKernel( @Cast("l_int32") int height, @Cast("l_int32") int width, @Cast("l_int32") int cy, @Cast("l_int32") int cx );
public static native L_KERNEL makeGaussianKernel( @Cast("l_int32") int halfh, @Cast("l_int32") int halfw, @Cast("l_float32") float stdev, @Cast("l_float32") float max );
public static native @Cast("l_ok") int makeGaussianKernelSep( @Cast("l_int32") int halfh, @Cast("l_int32") int halfw, @Cast("l_float32") float stdev, @Cast("l_float32") float max, @Cast("L_KERNEL**") PointerPointer pkelx, @Cast("L_KERNEL**") PointerPointer pkely );
public static native @Cast("l_ok") int makeGaussianKernelSep( @Cast("l_int32") int halfh, @Cast("l_int32") int halfw, @Cast("l_float32") float stdev, @Cast("l_float32") float max, @ByPtrPtr L_KERNEL pkelx, @ByPtrPtr L_KERNEL pkely );
public static native L_KERNEL makeDoGKernel( @Cast("l_int32") int halfh, @Cast("l_int32") int halfw, @Cast("l_float32") float stdev, @Cast("l_float32") float ratio );
public static native @Cast("char*") BytePointer getImagelibVersions( );
public static native void listDestroy( @Cast("DLLIST**") PointerPointer phead );
public static native void listDestroy( @ByPtrPtr DLLIST phead );
public static native @Cast("l_ok") int listAddToHead( @Cast("DLLIST**") PointerPointer phead, Pointer data );
public static native @Cast("l_ok") int listAddToHead( @ByPtrPtr DLLIST phead, Pointer data );
public static native @Cast("l_ok") int listAddToTail( @Cast("DLLIST**") PointerPointer phead, @Cast("DLLIST**") PointerPointer ptail, Pointer data );
public static native @Cast("l_ok") int listAddToTail( @ByPtrPtr DLLIST phead, @ByPtrPtr DLLIST ptail, Pointer data );
public static native @Cast("l_ok") int listInsertBefore( @Cast("DLLIST**") PointerPointer phead, DLLIST elem, Pointer data );
public static native @Cast("l_ok") int listInsertBefore( @ByPtrPtr DLLIST phead, DLLIST elem, Pointer data );
public static native @Cast("l_ok") int listInsertAfter( @Cast("DLLIST**") PointerPointer phead, DLLIST elem, Pointer data );
public static native @Cast("l_ok") int listInsertAfter( @ByPtrPtr DLLIST phead, DLLIST elem, Pointer data );
public static native Pointer listRemoveElement( @Cast("DLLIST**") PointerPointer phead, DLLIST elem );
public static native Pointer listRemoveElement( @ByPtrPtr DLLIST phead, DLLIST elem );
public static native Pointer listRemoveFromHead( @Cast("DLLIST**") PointerPointer phead );
public static native Pointer listRemoveFromHead( @ByPtrPtr DLLIST phead );
public static native Pointer listRemoveFromTail( @Cast("DLLIST**") PointerPointer phead, @Cast("DLLIST**") PointerPointer ptail );
public static native Pointer listRemoveFromTail( @ByPtrPtr DLLIST phead, @ByPtrPtr DLLIST ptail );
public static native DLLIST listFindElement( DLLIST head, Pointer data );
public static native DLLIST listFindTail( DLLIST head );
public static native @Cast("l_int32") int listGetCount( DLLIST head );
public static native @Cast("l_ok") int listReverse( @Cast("DLLIST**") PointerPointer phead );
public static native @Cast("l_ok") int listReverse( @ByPtrPtr DLLIST phead );
public static native @Cast("l_ok") int listJoin( @Cast("DLLIST**") PointerPointer phead1, @Cast("DLLIST**") PointerPointer phead2 );
public static native @Cast("l_ok") int listJoin( @ByPtrPtr DLLIST phead1, @ByPtrPtr DLLIST phead2 );
public static native L_AMAP l_amapCreate( @Cast("l_int32") int keytype );
public static native RB_TYPE l_amapFind( L_AMAP m, @ByVal RB_TYPE key );
public static native void l_amapInsert( L_AMAP m, @ByVal RB_TYPE key, @ByVal RB_TYPE value );
public static native void l_amapDelete( L_AMAP m, @ByVal RB_TYPE key );
public static native void l_amapDestroy( @Cast("L_AMAP**") PointerPointer pm );
public static native void l_amapDestroy( @ByPtrPtr L_AMAP pm );
public static native L_AMAP_NODE l_amapGetFirst( L_AMAP m );
public static native L_AMAP_NODE l_amapGetNext( L_AMAP_NODE n );
public static native L_AMAP_NODE l_amapGetLast( L_AMAP m );
public static native L_AMAP_NODE l_amapGetPrev( L_AMAP_NODE n );
public static native @Cast("l_int32") int l_amapSize( L_AMAP m );
public static native L_ASET l_asetCreate( @Cast("l_int32") int keytype );
public static native RB_TYPE l_asetFind( L_ASET s, @ByVal RB_TYPE key );
public static native void l_asetInsert( L_ASET s, @ByVal RB_TYPE key );
public static native void l_asetDelete( L_ASET s, @ByVal RB_TYPE key );
public static native void l_asetDestroy( @Cast("L_ASET**") PointerPointer ps );
public static native void l_asetDestroy( @ByPtrPtr L_ASET ps );
public static native L_ASET_NODE l_asetGetFirst( L_ASET s );
public static native L_ASET_NODE l_asetGetNext( L_ASET_NODE n );
public static native L_ASET_NODE l_asetGetLast( L_ASET s );
public static native L_ASET_NODE l_asetGetPrev( L_ASET_NODE n );
public static native @Cast("l_int32") int l_asetSize( L_ASET s );
public static native PIX generateBinaryMaze( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int xi, @Cast("l_int32") int yi, @Cast("l_float32") float wallps, @Cast("l_float32") float ranis );
public static native PTA pixSearchBinaryMaze( PIX pixs, @Cast("l_int32") int xi, @Cast("l_int32") int yi, @Cast("l_int32") int xf, @Cast("l_int32") int yf, @Cast("PIX**") PointerPointer ppixd );
public static native PTA pixSearchBinaryMaze( PIX pixs, @Cast("l_int32") int xi, @Cast("l_int32") int yi, @Cast("l_int32") int xf, @Cast("l_int32") int yf, @ByPtrPtr PIX ppixd );
public static native PTA pixSearchGrayMaze( PIX pixs, @Cast("l_int32") int xi, @Cast("l_int32") int yi, @Cast("l_int32") int xf, @Cast("l_int32") int yf, @Cast("PIX**") PointerPointer ppixd );
public static native PTA pixSearchGrayMaze( PIX pixs, @Cast("l_int32") int xi, @Cast("l_int32") int yi, @Cast("l_int32") int xf, @Cast("l_int32") int yf, @ByPtrPtr PIX ppixd );
public static native PIX pixDilate( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixErode( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixHMT( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixOpen( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixClose( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixCloseSafe( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixOpenGeneralized( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixCloseGeneralized( PIX pixd, PIX pixs, SEL sel );
public static native PIX pixDilateBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseSafeBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native @Cast("l_int32") int selectComposableSels( @Cast("l_int32") int size, @Cast("l_int32") int direction, @Cast("SEL**") PointerPointer psel1, @Cast("SEL**") PointerPointer psel2 );
public static native @Cast("l_int32") int selectComposableSels( @Cast("l_int32") int size, @Cast("l_int32") int direction, @ByPtrPtr SEL psel1, @ByPtrPtr SEL psel2 );
public static native @Cast("l_ok") int selectComposableSizes( @Cast("l_int32") int size, @Cast("l_int32*") IntPointer pfactor1, @Cast("l_int32*") IntPointer pfactor2 );
public static native @Cast("l_ok") int selectComposableSizes( @Cast("l_int32") int size, @Cast("l_int32*") IntBuffer pfactor1, @Cast("l_int32*") IntBuffer pfactor2 );
public static native @Cast("l_ok") int selectComposableSizes( @Cast("l_int32") int size, @Cast("l_int32*") int[] pfactor1, @Cast("l_int32*") int[] pfactor2 );
public static native PIX pixDilateCompBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeCompBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenCompBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseCompBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseSafeCompBrick( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native void resetMorphBoundaryCondition( @Cast("l_int32") int bc );
public static native @Cast("l_uint32") int getMorphBorderPixelColor( @Cast("l_int32") int type, @Cast("l_int32") int depth );
public static native PIX pixExtractBoundary( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixMorphSequenceMasked( PIX pixs, PIX pixm, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphSequenceMasked( PIX pixs, PIX pixm, String sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphSequenceByComponent( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @Cast("BOXA**") PointerPointer pboxa );
public static native PIX pixMorphSequenceByComponent( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @ByPtrPtr BOXA pboxa );
public static native PIX pixMorphSequenceByComponent( PIX pixs, String sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @ByPtrPtr BOXA pboxa );
public static native PIXA pixaMorphSequenceByComponent( PIXA pixas, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native PIXA pixaMorphSequenceByComponent( PIXA pixas, String sequence, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native PIX pixMorphSequenceByRegion( PIX pixs, PIX pixm, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @Cast("BOXA**") PointerPointer pboxa );
public static native PIX pixMorphSequenceByRegion( PIX pixs, PIX pixm, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @ByPtrPtr BOXA pboxa );
public static native PIX pixMorphSequenceByRegion( PIX pixs, PIX pixm, String sequence, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @ByPtrPtr BOXA pboxa );
public static native PIXA pixaMorphSequenceByRegion( PIX pixs, PIXA pixam, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native PIXA pixaMorphSequenceByRegion( PIX pixs, PIXA pixam, String sequence, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native PIX pixUnionOfMorphOps( PIX pixs, SELA sela, @Cast("l_int32") int type );
public static native PIX pixIntersectionOfMorphOps( PIX pixs, SELA sela, @Cast("l_int32") int type );
public static native PIX pixSelectiveConnCompFill( PIX pixs, @Cast("l_int32") int connectivity, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native @Cast("l_ok") int pixRemoveMatchedPattern( PIX pixs, PIX pixp, PIX pixe, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int dsize );
public static native PIX pixDisplayMatchedPattern( PIX pixs, PIX pixp, PIX pixe, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_uint32") int color, @Cast("l_float32") float scale, @Cast("l_int32") int nlevels );
public static native PIXA pixaExtendByMorph( PIXA pixas, @Cast("l_int32") int type, @Cast("l_int32") int niters, SEL sel, @Cast("l_int32") int include );
public static native PIXA pixaExtendByScaling( PIXA pixas, NUMA nasc, @Cast("l_int32") int type, @Cast("l_int32") int include );
public static native PIX pixSeedfillMorph( PIX pixs, PIX pixm, @Cast("l_int32") int maxiters, @Cast("l_int32") int connectivity );
public static native NUMA pixRunHistogramMorph( PIX pixs, @Cast("l_int32") int runtype, @Cast("l_int32") int direction, @Cast("l_int32") int maxsize );
public static native PIX pixTophat( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize, @Cast("l_int32") int type );
public static native PIX pixHDome( PIX pixs, @Cast("l_int32") int height, @Cast("l_int32") int connectivity );
public static native PIX pixFastTophat( PIX pixs, @Cast("l_int32") int xsize, @Cast("l_int32") int ysize, @Cast("l_int32") int type );
public static native PIX pixMorphGradient( PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize, @Cast("l_int32") int smoothing );
public static native PTA pixaCentroids( PIXA pixa );
public static native @Cast("l_ok") int pixCentroid( PIX pix, @Cast("l_int32*") IntPointer centtab, @Cast("l_int32*") IntPointer sumtab, @Cast("l_float32*") FloatPointer pxave, @Cast("l_float32*") FloatPointer pyave );
public static native @Cast("l_ok") int pixCentroid( PIX pix, @Cast("l_int32*") IntBuffer centtab, @Cast("l_int32*") IntBuffer sumtab, @Cast("l_float32*") FloatBuffer pxave, @Cast("l_float32*") FloatBuffer pyave );
public static native @Cast("l_ok") int pixCentroid( PIX pix, @Cast("l_int32*") int[] centtab, @Cast("l_int32*") int[] sumtab, @Cast("l_float32*") float[] pxave, @Cast("l_float32*") float[] pyave );
public static native PIX pixDilateBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixDilateCompBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeCompBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenCompBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseCompBrickDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixDilateCompBrickExtendDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixErodeCompBrickExtendDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixOpenCompBrickExtendDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native PIX pixCloseCompBrickExtendDwa( PIX pixd, PIX pixs, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native @Cast("l_ok") int getExtendedCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") IntPointer pn, @Cast("l_int32*") IntPointer pextra, @Cast("l_int32*") IntPointer pactualsize );
public static native @Cast("l_ok") int getExtendedCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") IntBuffer pn, @Cast("l_int32*") IntBuffer pextra, @Cast("l_int32*") IntBuffer pactualsize );
public static native @Cast("l_ok") int getExtendedCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") int[] pn, @Cast("l_int32*") int[] pextra, @Cast("l_int32*") int[] pactualsize );
public static native PIX pixMorphSequence( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphSequence( PIX pixs, String sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphCompSequence( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphCompSequence( PIX pixs, String sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphSequenceDwa( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphSequenceDwa( PIX pixs, String sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphCompSequenceDwa( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep );
public static native PIX pixMorphCompSequenceDwa( PIX pixs, String sequence, @Cast("l_int32") int dispsep );
public static native @Cast("l_int32") int morphSequenceVerify( SARRAY sa );
public static native PIX pixGrayMorphSequence( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep, @Cast("l_int32") int dispy );
public static native PIX pixGrayMorphSequence( PIX pixs, String sequence, @Cast("l_int32") int dispsep, @Cast("l_int32") int dispy );
public static native PIX pixColorMorphSequence( PIX pixs, @Cast("const char*") BytePointer sequence, @Cast("l_int32") int dispsep, @Cast("l_int32") int dispy );
public static native PIX pixColorMorphSequence( PIX pixs, String sequence, @Cast("l_int32") int dispsep, @Cast("l_int32") int dispy );
public static native NUMA numaCreate( @Cast("l_int32") int n );
public static native NUMA numaCreateFromIArray( @Cast("l_int32*") IntPointer iarray, @Cast("l_int32") int size );
public static native NUMA numaCreateFromIArray( @Cast("l_int32*") IntBuffer iarray, @Cast("l_int32") int size );
public static native NUMA numaCreateFromIArray( @Cast("l_int32*") int[] iarray, @Cast("l_int32") int size );
public static native NUMA numaCreateFromFArray( @Cast("l_float32*") FloatPointer farray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native NUMA numaCreateFromFArray( @Cast("l_float32*") FloatBuffer farray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native NUMA numaCreateFromFArray( @Cast("l_float32*") float[] farray, @Cast("l_int32") int size, @Cast("l_int32") int copyflag );
public static native NUMA numaCreateFromString( @Cast("const char*") BytePointer str );
public static native NUMA numaCreateFromString( String str );
public static native void numaDestroy( @Cast("NUMA**") PointerPointer pna );
public static native void numaDestroy( @ByPtrPtr NUMA pna );
public static native NUMA numaCopy( NUMA na );
public static native NUMA numaClone( NUMA na );
public static native @Cast("l_ok") int numaEmpty( NUMA na );
public static native @Cast("l_ok") int numaAddNumber( NUMA na, @Cast("l_float32") float val );
public static native @Cast("l_ok") int numaInsertNumber( NUMA na, @Cast("l_int32") int index, @Cast("l_float32") float val );
public static native @Cast("l_ok") int numaRemoveNumber( NUMA na, @Cast("l_int32") int index );
public static native @Cast("l_ok") int numaReplaceNumber( NUMA na, @Cast("l_int32") int index, @Cast("l_float32") float val );
public static native @Cast("l_int32") int numaGetCount( NUMA na );
public static native @Cast("l_ok") int numaSetCount( NUMA na, @Cast("l_int32") int newcount );
public static native @Cast("l_ok") int numaGetFValue( NUMA na, @Cast("l_int32") int index, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int numaGetFValue( NUMA na, @Cast("l_int32") int index, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int numaGetFValue( NUMA na, @Cast("l_int32") int index, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int numaGetIValue( NUMA na, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer pival );
public static native @Cast("l_ok") int numaGetIValue( NUMA na, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer pival );
public static native @Cast("l_ok") int numaGetIValue( NUMA na, @Cast("l_int32") int index, @Cast("l_int32*") int[] pival );
public static native @Cast("l_ok") int numaSetValue( NUMA na, @Cast("l_int32") int index, @Cast("l_float32") float val );
public static native @Cast("l_ok") int numaShiftValue( NUMA na, @Cast("l_int32") int index, @Cast("l_float32") float diff );
public static native @Cast("l_int32*") IntPointer numaGetIArray( NUMA na );
public static native @Cast("l_float32*") FloatPointer numaGetFArray( NUMA na, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int numaGetRefcount( NUMA na );
public static native @Cast("l_ok") int numaChangeRefcount( NUMA na, @Cast("l_int32") int delta );
public static native @Cast("l_ok") int numaGetParameters( NUMA na, @Cast("l_float32*") FloatPointer pstartx, @Cast("l_float32*") FloatPointer pdelx );
public static native @Cast("l_ok") int numaGetParameters( NUMA na, @Cast("l_float32*") FloatBuffer pstartx, @Cast("l_float32*") FloatBuffer pdelx );
public static native @Cast("l_ok") int numaGetParameters( NUMA na, @Cast("l_float32*") float[] pstartx, @Cast("l_float32*") float[] pdelx );
public static native @Cast("l_ok") int numaSetParameters( NUMA na, @Cast("l_float32") float startx, @Cast("l_float32") float delx );
public static native @Cast("l_ok") int numaCopyParameters( NUMA nad, NUMA nas );
public static native SARRAY numaConvertToSarray( NUMA na, @Cast("l_int32") int size1, @Cast("l_int32") int size2, @Cast("l_int32") int addzeros, @Cast("l_int32") int type );
public static native NUMA numaRead( @Cast("const char*") BytePointer filename );
public static native NUMA numaRead( String filename );
public static native NUMA numaReadStream( @Cast("FILE*") Pointer fp );
public static native NUMA numaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native NUMA numaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native NUMA numaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int numaWriteDebug( @Cast("const char*") BytePointer filename, NUMA na );
public static native @Cast("l_ok") int numaWriteDebug( String filename, NUMA na );
public static native @Cast("l_ok") int numaWrite( @Cast("const char*") BytePointer filename, NUMA na );
public static native @Cast("l_ok") int numaWrite( String filename, NUMA na );
public static native @Cast("l_ok") int numaWriteStream( @Cast("FILE*") Pointer fp, NUMA na );
public static native @Cast("l_ok") int numaWriteStderr( NUMA na );
public static native @Cast("l_ok") int numaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, NUMA na );
public static native @Cast("l_ok") int numaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, NUMA na );
public static native @Cast("l_ok") int numaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, NUMA na );
public static native @Cast("l_ok") int numaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, NUMA na );
public static native NUMAA numaaCreate( @Cast("l_int32") int n );
public static native NUMAA numaaCreateFull( @Cast("l_int32") int nptr, @Cast("l_int32") int n );
public static native @Cast("l_ok") int numaaTruncate( NUMAA naa );
public static native void numaaDestroy( @Cast("NUMAA**") PointerPointer pnaa );
public static native void numaaDestroy( @ByPtrPtr NUMAA pnaa );
public static native @Cast("l_ok") int numaaAddNuma( NUMAA naa, NUMA na, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int numaaGetCount( NUMAA naa );
public static native @Cast("l_int32") int numaaGetNumaCount( NUMAA naa, @Cast("l_int32") int index );
public static native @Cast("l_int32") int numaaGetNumberCount( NUMAA naa );
public static native @Cast("NUMA**") PointerPointer numaaGetPtrArray( NUMAA naa );
public static native NUMA numaaGetNuma( NUMAA naa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native @Cast("l_ok") int numaaReplaceNuma( NUMAA naa, @Cast("l_int32") int index, NUMA na );
public static native @Cast("l_ok") int numaaGetValue( NUMAA naa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float32*") FloatPointer pfval, @Cast("l_int32*") IntPointer pival );
public static native @Cast("l_ok") int numaaGetValue( NUMAA naa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float32*") FloatBuffer pfval, @Cast("l_int32*") IntBuffer pival );
public static native @Cast("l_ok") int numaaGetValue( NUMAA naa, @Cast("l_int32") int i, @Cast("l_int32") int j, @Cast("l_float32*") float[] pfval, @Cast("l_int32*") int[] pival );
public static native @Cast("l_ok") int numaaAddNumber( NUMAA naa, @Cast("l_int32") int index, @Cast("l_float32") float val );
public static native NUMAA numaaRead( @Cast("const char*") BytePointer filename );
public static native NUMAA numaaRead( String filename );
public static native NUMAA numaaReadStream( @Cast("FILE*") Pointer fp );
public static native NUMAA numaaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native NUMAA numaaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native NUMAA numaaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int numaaWrite( @Cast("const char*") BytePointer filename, NUMAA naa );
public static native @Cast("l_ok") int numaaWrite( String filename, NUMAA naa );
public static native @Cast("l_ok") int numaaWriteStream( @Cast("FILE*") Pointer fp, NUMAA naa );
public static native @Cast("l_ok") int numaaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, NUMAA naa );
public static native @Cast("l_ok") int numaaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, NUMAA naa );
public static native @Cast("l_ok") int numaaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, NUMAA naa );
public static native @Cast("l_ok") int numaaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, NUMAA naa );
public static native NUMA numaArithOp( NUMA nad, NUMA na1, NUMA na2, @Cast("l_int32") int op );
public static native NUMA numaLogicalOp( NUMA nad, NUMA na1, NUMA na2, @Cast("l_int32") int op );
public static native NUMA numaInvert( NUMA nad, NUMA nas );
public static native @Cast("l_int32") int numaSimilar( NUMA na1, NUMA na2, @Cast("l_float32") float maxdiff, @Cast("l_int32*") IntPointer psimilar );
public static native @Cast("l_int32") int numaSimilar( NUMA na1, NUMA na2, @Cast("l_float32") float maxdiff, @Cast("l_int32*") IntBuffer psimilar );
public static native @Cast("l_int32") int numaSimilar( NUMA na1, NUMA na2, @Cast("l_float32") float maxdiff, @Cast("l_int32*") int[] psimilar );
public static native @Cast("l_ok") int numaAddToNumber( NUMA na, @Cast("l_int32") int index, @Cast("l_float32") float val );
public static native @Cast("l_ok") int numaGetMin( NUMA na, @Cast("l_float32*") FloatPointer pminval, @Cast("l_int32*") IntPointer piminloc );
public static native @Cast("l_ok") int numaGetMin( NUMA na, @Cast("l_float32*") FloatBuffer pminval, @Cast("l_int32*") IntBuffer piminloc );
public static native @Cast("l_ok") int numaGetMin( NUMA na, @Cast("l_float32*") float[] pminval, @Cast("l_int32*") int[] piminloc );
public static native @Cast("l_ok") int numaGetMax( NUMA na, @Cast("l_float32*") FloatPointer pmaxval, @Cast("l_int32*") IntPointer pimaxloc );
public static native @Cast("l_ok") int numaGetMax( NUMA na, @Cast("l_float32*") FloatBuffer pmaxval, @Cast("l_int32*") IntBuffer pimaxloc );
public static native @Cast("l_ok") int numaGetMax( NUMA na, @Cast("l_float32*") float[] pmaxval, @Cast("l_int32*") int[] pimaxloc );
public static native @Cast("l_ok") int numaGetSum( NUMA na, @Cast("l_float32*") FloatPointer psum );
public static native @Cast("l_ok") int numaGetSum( NUMA na, @Cast("l_float32*") FloatBuffer psum );
public static native @Cast("l_ok") int numaGetSum( NUMA na, @Cast("l_float32*") float[] psum );
public static native NUMA numaGetPartialSums( NUMA na );
public static native @Cast("l_ok") int numaGetSumOnInterval( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") FloatPointer psum );
public static native @Cast("l_ok") int numaGetSumOnInterval( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") FloatBuffer psum );
public static native @Cast("l_ok") int numaGetSumOnInterval( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") float[] psum );
public static native @Cast("l_ok") int numaHasOnlyIntegers( NUMA na, @Cast("l_int32*") IntPointer pallints );
public static native @Cast("l_ok") int numaHasOnlyIntegers( NUMA na, @Cast("l_int32*") IntBuffer pallints );
public static native @Cast("l_ok") int numaHasOnlyIntegers( NUMA na, @Cast("l_int32*") int[] pallints );
public static native @Cast("l_ok") int numaGetMean( NUMA na, @Cast("l_float32*") FloatPointer pave );
public static native @Cast("l_ok") int numaGetMean( NUMA na, @Cast("l_float32*") FloatBuffer pave );
public static native @Cast("l_ok") int numaGetMean( NUMA na, @Cast("l_float32*") float[] pave );
public static native @Cast("l_ok") int numaGetMeanAbsval( NUMA na, @Cast("l_float32*") FloatPointer paveabs );
public static native @Cast("l_ok") int numaGetMeanAbsval( NUMA na, @Cast("l_float32*") FloatBuffer paveabs );
public static native @Cast("l_ok") int numaGetMeanAbsval( NUMA na, @Cast("l_float32*") float[] paveabs );
public static native NUMA numaSubsample( NUMA nas, @Cast("l_int32") int subfactor );
public static native NUMA numaMakeDelta( NUMA nas );
public static native NUMA numaMakeSequence( @Cast("l_float32") float startval, @Cast("l_float32") float increment, @Cast("l_int32") int size );
public static native NUMA numaMakeConstant( @Cast("l_float32") float val, @Cast("l_int32") int size );
public static native NUMA numaMakeAbsval( NUMA nad, NUMA nas );
public static native NUMA numaAddBorder( NUMA nas, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_float32") float val );
public static native NUMA numaAddSpecifiedBorder( NUMA nas, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int type );
public static native NUMA numaRemoveBorder( NUMA nas, @Cast("l_int32") int left, @Cast("l_int32") int right );
public static native @Cast("l_ok") int numaCountNonzeroRuns( NUMA na, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int numaCountNonzeroRuns( NUMA na, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int numaCountNonzeroRuns( NUMA na, @Cast("l_int32*") int[] pcount );
public static native @Cast("l_ok") int numaGetNonzeroRange( NUMA na, @Cast("l_float32") float eps, @Cast("l_int32*") IntPointer pfirst, @Cast("l_int32*") IntPointer plast );
public static native @Cast("l_ok") int numaGetNonzeroRange( NUMA na, @Cast("l_float32") float eps, @Cast("l_int32*") IntBuffer pfirst, @Cast("l_int32*") IntBuffer plast );
public static native @Cast("l_ok") int numaGetNonzeroRange( NUMA na, @Cast("l_float32") float eps, @Cast("l_int32*") int[] pfirst, @Cast("l_int32*") int[] plast );
public static native @Cast("l_ok") int numaGetCountRelativeToZero( NUMA na, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int numaGetCountRelativeToZero( NUMA na, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int numaGetCountRelativeToZero( NUMA na, @Cast("l_int32") int type, @Cast("l_int32*") int[] pcount );
public static native NUMA numaClipToInterval( NUMA nas, @Cast("l_int32") int first, @Cast("l_int32") int last );
public static native NUMA numaMakeThresholdIndicator( NUMA nas, @Cast("l_float32") float thresh, @Cast("l_int32") int type );
public static native NUMA numaUniformSampling( NUMA nas, @Cast("l_int32") int nsamp );
public static native NUMA numaReverse( NUMA nad, NUMA nas );
public static native NUMA numaLowPassIntervals( NUMA nas, @Cast("l_float32") float thresh, @Cast("l_float32") float maxn );
public static native NUMA numaThresholdEdges( NUMA nas, @Cast("l_float32") float thresh1, @Cast("l_float32") float thresh2, @Cast("l_float32") float maxn );
public static native @Cast("l_int32") int numaGetSpanValues( NUMA na, @Cast("l_int32") int span, @Cast("l_int32*") IntPointer pstart, @Cast("l_int32*") IntPointer pend );
public static native @Cast("l_int32") int numaGetSpanValues( NUMA na, @Cast("l_int32") int span, @Cast("l_int32*") IntBuffer pstart, @Cast("l_int32*") IntBuffer pend );
public static native @Cast("l_int32") int numaGetSpanValues( NUMA na, @Cast("l_int32") int span, @Cast("l_int32*") int[] pstart, @Cast("l_int32*") int[] pend );
public static native @Cast("l_int32") int numaGetEdgeValues( NUMA na, @Cast("l_int32") int edge, @Cast("l_int32*") IntPointer pstart, @Cast("l_int32*") IntPointer pend, @Cast("l_int32*") IntPointer psign );
public static native @Cast("l_int32") int numaGetEdgeValues( NUMA na, @Cast("l_int32") int edge, @Cast("l_int32*") IntBuffer pstart, @Cast("l_int32*") IntBuffer pend, @Cast("l_int32*") IntBuffer psign );
public static native @Cast("l_int32") int numaGetEdgeValues( NUMA na, @Cast("l_int32") int edge, @Cast("l_int32*") int[] pstart, @Cast("l_int32*") int[] pend, @Cast("l_int32*") int[] psign );
public static native @Cast("l_ok") int numaInterpolateEqxVal( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") FloatPointer pyval );
public static native @Cast("l_ok") int numaInterpolateEqxVal( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") FloatBuffer pyval );
public static native @Cast("l_ok") int numaInterpolateEqxVal( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") float[] pyval );
public static native @Cast("l_ok") int numaInterpolateArbxVal( NUMA nax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") FloatPointer pyval );
public static native @Cast("l_ok") int numaInterpolateArbxVal( NUMA nax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") FloatBuffer pyval );
public static native @Cast("l_ok") int numaInterpolateArbxVal( NUMA nax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float xval, @Cast("l_float32*") float[] pyval );
public static native @Cast("l_ok") int numaInterpolateEqxInterval( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nasy, @Cast("l_int32") int type, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("NUMA**") PointerPointer pnax, @Cast("NUMA**") PointerPointer pnay );
public static native @Cast("l_ok") int numaInterpolateEqxInterval( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nasy, @Cast("l_int32") int type, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @ByPtrPtr NUMA pnax, @ByPtrPtr NUMA pnay );
public static native @Cast("l_ok") int numaInterpolateArbxInterval( NUMA nax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("NUMA**") PointerPointer pnadx, @Cast("NUMA**") PointerPointer pnady );
public static native @Cast("l_ok") int numaInterpolateArbxInterval( NUMA nax, NUMA nay, @Cast("l_int32") int type, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @ByPtrPtr NUMA pnadx, @ByPtrPtr NUMA pnady );
public static native @Cast("l_ok") int numaFitMax( NUMA na, @Cast("l_float32*") FloatPointer pmaxval, NUMA naloc, @Cast("l_float32*") FloatPointer pmaxloc );
public static native @Cast("l_ok") int numaFitMax( NUMA na, @Cast("l_float32*") FloatBuffer pmaxval, NUMA naloc, @Cast("l_float32*") FloatBuffer pmaxloc );
public static native @Cast("l_ok") int numaFitMax( NUMA na, @Cast("l_float32*") float[] pmaxval, NUMA naloc, @Cast("l_float32*") float[] pmaxloc );
public static native @Cast("l_ok") int numaDifferentiateInterval( NUMA nax, NUMA nay, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("NUMA**") PointerPointer pnadx, @Cast("NUMA**") PointerPointer pnady );
public static native @Cast("l_ok") int numaDifferentiateInterval( NUMA nax, NUMA nay, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @ByPtrPtr NUMA pnadx, @ByPtrPtr NUMA pnady );
public static native @Cast("l_ok") int numaIntegrateInterval( NUMA nax, NUMA nay, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("l_float32*") FloatPointer psum );
public static native @Cast("l_ok") int numaIntegrateInterval( NUMA nax, NUMA nay, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("l_float32*") FloatBuffer psum );
public static native @Cast("l_ok") int numaIntegrateInterval( NUMA nax, NUMA nay, @Cast("l_float32") float x0, @Cast("l_float32") float x1, @Cast("l_int32") int npts, @Cast("l_float32*") float[] psum );
public static native @Cast("l_ok") int numaSortGeneral( NUMA na, @Cast("NUMA**") PointerPointer pnasort, @Cast("NUMA**") PointerPointer pnaindex, @Cast("NUMA**") PointerPointer pnainvert, @Cast("l_int32") int sortorder, @Cast("l_int32") int sorttype );
public static native @Cast("l_ok") int numaSortGeneral( NUMA na, @ByPtrPtr NUMA pnasort, @ByPtrPtr NUMA pnaindex, @ByPtrPtr NUMA pnainvert, @Cast("l_int32") int sortorder, @Cast("l_int32") int sorttype );
public static native NUMA numaSortAutoSelect( NUMA nas, @Cast("l_int32") int sortorder );
public static native NUMA numaSortIndexAutoSelect( NUMA nas, @Cast("l_int32") int sortorder );
public static native @Cast("l_int32") int numaChooseSortType( NUMA nas );
public static native NUMA numaSort( NUMA naout, NUMA nain, @Cast("l_int32") int sortorder );
public static native NUMA numaBinSort( NUMA nas, @Cast("l_int32") int sortorder );
public static native NUMA numaGetSortIndex( NUMA na, @Cast("l_int32") int sortorder );
public static native NUMA numaGetBinSortIndex( NUMA nas, @Cast("l_int32") int sortorder );
public static native NUMA numaSortByIndex( NUMA nas, NUMA naindex );
public static native @Cast("l_int32") int numaIsSorted( NUMA nas, @Cast("l_int32") int sortorder, @Cast("l_int32*") IntPointer psorted );
public static native @Cast("l_int32") int numaIsSorted( NUMA nas, @Cast("l_int32") int sortorder, @Cast("l_int32*") IntBuffer psorted );
public static native @Cast("l_int32") int numaIsSorted( NUMA nas, @Cast("l_int32") int sortorder, @Cast("l_int32*") int[] psorted );
public static native @Cast("l_ok") int numaSortPair( NUMA nax, NUMA nay, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnasx, @Cast("NUMA**") PointerPointer pnasy );
public static native @Cast("l_ok") int numaSortPair( NUMA nax, NUMA nay, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnasx, @ByPtrPtr NUMA pnasy );
public static native NUMA numaInvertMap( NUMA nas );
public static native @Cast("l_ok") int numaAddSorted( NUMA na, @Cast("l_float32") float val );
public static native @Cast("l_ok") int numaFindSortedLoc( NUMA na, @Cast("l_float32") float val, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int numaFindSortedLoc( NUMA na, @Cast("l_float32") float val, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int numaFindSortedLoc( NUMA na, @Cast("l_float32") float val, @Cast("l_int32*") int[] pindex );
public static native NUMA numaPseudorandomSequence( @Cast("l_int32") int size, @Cast("l_int32") int seed );
public static native NUMA numaRandomPermutation( NUMA nas, @Cast("l_int32") int seed );
public static native @Cast("l_ok") int numaGetRankValue( NUMA na, @Cast("l_float32") float fract, NUMA nasort, @Cast("l_int32") int usebins, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int numaGetRankValue( NUMA na, @Cast("l_float32") float fract, NUMA nasort, @Cast("l_int32") int usebins, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int numaGetRankValue( NUMA na, @Cast("l_float32") float fract, NUMA nasort, @Cast("l_int32") int usebins, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int numaGetMedian( NUMA na, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int numaGetMedian( NUMA na, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int numaGetMedian( NUMA na, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int numaGetBinnedMedian( NUMA na, @Cast("l_int32*") IntPointer pval );
public static native @Cast("l_ok") int numaGetBinnedMedian( NUMA na, @Cast("l_int32*") IntBuffer pval );
public static native @Cast("l_ok") int numaGetBinnedMedian( NUMA na, @Cast("l_int32*") int[] pval );
public static native @Cast("l_ok") int numaGetMeanDevFromMedian( NUMA na, @Cast("l_float32") float med, @Cast("l_float32*") FloatPointer pdev );
public static native @Cast("l_ok") int numaGetMeanDevFromMedian( NUMA na, @Cast("l_float32") float med, @Cast("l_float32*") FloatBuffer pdev );
public static native @Cast("l_ok") int numaGetMeanDevFromMedian( NUMA na, @Cast("l_float32") float med, @Cast("l_float32*") float[] pdev );
public static native @Cast("l_ok") int numaGetMedianDevFromMedian( NUMA na, @Cast("l_float32*") FloatPointer pmed, @Cast("l_float32*") FloatPointer pdev );
public static native @Cast("l_ok") int numaGetMedianDevFromMedian( NUMA na, @Cast("l_float32*") FloatBuffer pmed, @Cast("l_float32*") FloatBuffer pdev );
public static native @Cast("l_ok") int numaGetMedianDevFromMedian( NUMA na, @Cast("l_float32*") float[] pmed, @Cast("l_float32*") float[] pdev );
public static native @Cast("l_ok") int numaGetMode( NUMA na, @Cast("l_float32*") FloatPointer pval, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int numaGetMode( NUMA na, @Cast("l_float32*") FloatBuffer pval, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int numaGetMode( NUMA na, @Cast("l_float32*") float[] pval, @Cast("l_int32*") int[] pcount );
public static native @Cast("l_ok") int numaJoin( NUMA nad, NUMA nas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native @Cast("l_ok") int numaaJoin( NUMAA naad, NUMAA naas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native NUMA numaaFlattenToNuma( NUMAA naa );
public static native NUMA numaErode( NUMA nas, @Cast("l_int32") int size );
public static native NUMA numaDilate( NUMA nas, @Cast("l_int32") int size );
public static native NUMA numaOpen( NUMA nas, @Cast("l_int32") int size );
public static native NUMA numaClose( NUMA nas, @Cast("l_int32") int size );
public static native NUMA numaTransform( NUMA nas, @Cast("l_float32") float shift, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int numaSimpleStats( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") FloatPointer pmean, @Cast("l_float32*") FloatPointer pvar, @Cast("l_float32*") FloatPointer prvar );
public static native @Cast("l_ok") int numaSimpleStats( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") FloatBuffer pmean, @Cast("l_float32*") FloatBuffer pvar, @Cast("l_float32*") FloatBuffer prvar );
public static native @Cast("l_ok") int numaSimpleStats( NUMA na, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_float32*") float[] pmean, @Cast("l_float32*") float[] pvar, @Cast("l_float32*") float[] prvar );
public static native @Cast("l_ok") int numaWindowedStats( NUMA nas, @Cast("l_int32") int wc, @Cast("NUMA**") PointerPointer pnam, @Cast("NUMA**") PointerPointer pnams, @Cast("NUMA**") PointerPointer pnav, @Cast("NUMA**") PointerPointer pnarv );
public static native @Cast("l_ok") int numaWindowedStats( NUMA nas, @Cast("l_int32") int wc, @ByPtrPtr NUMA pnam, @ByPtrPtr NUMA pnams, @ByPtrPtr NUMA pnav, @ByPtrPtr NUMA pnarv );
public static native NUMA numaWindowedMean( NUMA nas, @Cast("l_int32") int wc );
public static native NUMA numaWindowedMeanSquare( NUMA nas, @Cast("l_int32") int wc );
public static native @Cast("l_ok") int numaWindowedVariance( NUMA nam, NUMA nams, @Cast("NUMA**") PointerPointer pnav, @Cast("NUMA**") PointerPointer pnarv );
public static native @Cast("l_ok") int numaWindowedVariance( NUMA nam, NUMA nams, @ByPtrPtr NUMA pnav, @ByPtrPtr NUMA pnarv );
public static native NUMA numaWindowedMedian( NUMA nas, @Cast("l_int32") int halfwin );
public static native NUMA numaConvertToInt( NUMA nas );
public static native NUMA numaMakeHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_int32*") IntPointer pbinsize, @Cast("l_int32*") IntPointer pbinstart );
public static native NUMA numaMakeHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_int32*") IntBuffer pbinsize, @Cast("l_int32*") IntBuffer pbinstart );
public static native NUMA numaMakeHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_int32*") int[] pbinsize, @Cast("l_int32*") int[] pbinstart );
public static native NUMA numaMakeHistogramAuto( NUMA na, @Cast("l_int32") int maxbins );
public static native NUMA numaMakeHistogramClipped( NUMA na, @Cast("l_float32") float binsize, @Cast("l_float32") float maxsize );
public static native NUMA numaRebinHistogram( NUMA nas, @Cast("l_int32") int newsize );
public static native NUMA numaNormalizeHistogram( NUMA nas, @Cast("l_float32") float tsum );
public static native @Cast("l_ok") int numaGetStatsUsingHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_float32*") FloatPointer pmin, @Cast("l_float32*") FloatPointer pmax, @Cast("l_float32*") FloatPointer pmean, @Cast("l_float32*") FloatPointer pvariance, @Cast("l_float32*") FloatPointer pmedian, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer prval, @Cast("NUMA**") PointerPointer phisto );
public static native @Cast("l_ok") int numaGetStatsUsingHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_float32*") FloatPointer pmin, @Cast("l_float32*") FloatPointer pmax, @Cast("l_float32*") FloatPointer pmean, @Cast("l_float32*") FloatPointer pvariance, @Cast("l_float32*") FloatPointer pmedian, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer prval, @ByPtrPtr NUMA phisto );
public static native @Cast("l_ok") int numaGetStatsUsingHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_float32*") FloatBuffer pmin, @Cast("l_float32*") FloatBuffer pmax, @Cast("l_float32*") FloatBuffer pmean, @Cast("l_float32*") FloatBuffer pvariance, @Cast("l_float32*") FloatBuffer pmedian, @Cast("l_float32") float rank, @Cast("l_float32*") FloatBuffer prval, @ByPtrPtr NUMA phisto );
public static native @Cast("l_ok") int numaGetStatsUsingHistogram( NUMA na, @Cast("l_int32") int maxbins, @Cast("l_float32*") float[] pmin, @Cast("l_float32*") float[] pmax, @Cast("l_float32*") float[] pmean, @Cast("l_float32*") float[] pvariance, @Cast("l_float32*") float[] pmedian, @Cast("l_float32") float rank, @Cast("l_float32*") float[] prval, @ByPtrPtr NUMA phisto );
public static native @Cast("l_ok") int numaGetHistogramStats( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_float32*") FloatPointer pxmean, @Cast("l_float32*") FloatPointer pxmedian, @Cast("l_float32*") FloatPointer pxmode, @Cast("l_float32*") FloatPointer pxvariance );
public static native @Cast("l_ok") int numaGetHistogramStats( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_float32*") FloatBuffer pxmean, @Cast("l_float32*") FloatBuffer pxmedian, @Cast("l_float32*") FloatBuffer pxmode, @Cast("l_float32*") FloatBuffer pxvariance );
public static native @Cast("l_ok") int numaGetHistogramStats( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_float32*") float[] pxmean, @Cast("l_float32*") float[] pxmedian, @Cast("l_float32*") float[] pxmode, @Cast("l_float32*") float[] pxvariance );
public static native @Cast("l_ok") int numaGetHistogramStatsOnInterval( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_int32") int ifirst, @Cast("l_int32") int ilast, @Cast("l_float32*") FloatPointer pxmean, @Cast("l_float32*") FloatPointer pxmedian, @Cast("l_float32*") FloatPointer pxmode, @Cast("l_float32*") FloatPointer pxvariance );
public static native @Cast("l_ok") int numaGetHistogramStatsOnInterval( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_int32") int ifirst, @Cast("l_int32") int ilast, @Cast("l_float32*") FloatBuffer pxmean, @Cast("l_float32*") FloatBuffer pxmedian, @Cast("l_float32*") FloatBuffer pxmode, @Cast("l_float32*") FloatBuffer pxvariance );
public static native @Cast("l_ok") int numaGetHistogramStatsOnInterval( NUMA nahisto, @Cast("l_float32") float startx, @Cast("l_float32") float deltax, @Cast("l_int32") int ifirst, @Cast("l_int32") int ilast, @Cast("l_float32*") float[] pxmean, @Cast("l_float32*") float[] pxmedian, @Cast("l_float32*") float[] pxmode, @Cast("l_float32*") float[] pxvariance );
public static native @Cast("l_ok") int numaMakeRankFromHistogram( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nasy, @Cast("l_int32") int npts, @Cast("NUMA**") PointerPointer pnax, @Cast("NUMA**") PointerPointer pnay );
public static native @Cast("l_ok") int numaMakeRankFromHistogram( @Cast("l_float32") float startx, @Cast("l_float32") float deltax, NUMA nasy, @Cast("l_int32") int npts, @ByPtrPtr NUMA pnax, @ByPtrPtr NUMA pnay );
public static native @Cast("l_ok") int numaHistogramGetRankFromVal( NUMA na, @Cast("l_float32") float rval, @Cast("l_float32*") FloatPointer prank );
public static native @Cast("l_ok") int numaHistogramGetRankFromVal( NUMA na, @Cast("l_float32") float rval, @Cast("l_float32*") FloatBuffer prank );
public static native @Cast("l_ok") int numaHistogramGetRankFromVal( NUMA na, @Cast("l_float32") float rval, @Cast("l_float32*") float[] prank );
public static native @Cast("l_ok") int numaHistogramGetValFromRank( NUMA na, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer prval );
public static native @Cast("l_ok") int numaHistogramGetValFromRank( NUMA na, @Cast("l_float32") float rank, @Cast("l_float32*") FloatBuffer prval );
public static native @Cast("l_ok") int numaHistogramGetValFromRank( NUMA na, @Cast("l_float32") float rank, @Cast("l_float32*") float[] prval );
public static native @Cast("l_ok") int numaDiscretizeSortedInBins( NUMA na, @Cast("l_int32") int nbins, @Cast("NUMA**") PointerPointer pnabinval );
public static native @Cast("l_ok") int numaDiscretizeSortedInBins( NUMA na, @Cast("l_int32") int nbins, @ByPtrPtr NUMA pnabinval );
public static native @Cast("l_ok") int numaDiscretizeHistoInBins( NUMA na, @Cast("l_int32") int nbins, @Cast("NUMA**") PointerPointer pnabinval, @Cast("NUMA**") PointerPointer pnarank );
public static native @Cast("l_ok") int numaDiscretizeHistoInBins( NUMA na, @Cast("l_int32") int nbins, @ByPtrPtr NUMA pnabinval, @ByPtrPtr NUMA pnarank );
public static native @Cast("l_ok") int numaGetRankBinValues( NUMA na, @Cast("l_int32") int nbins, @Cast("NUMA**") PointerPointer pnam );
public static native @Cast("l_ok") int numaGetRankBinValues( NUMA na, @Cast("l_int32") int nbins, @ByPtrPtr NUMA pnam );
public static native NUMA numaGetUniformBinSizes( @Cast("l_int32") int ntotal, @Cast("l_int32") int nbins );
public static native @Cast("l_ok") int numaSplitDistribution( NUMA na, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntPointer psplitindex, @Cast("l_float32*") FloatPointer pave1, @Cast("l_float32*") FloatPointer pave2, @Cast("l_float32*") FloatPointer pnum1, @Cast("l_float32*") FloatPointer pnum2, @Cast("NUMA**") PointerPointer pnascore );
public static native @Cast("l_ok") int numaSplitDistribution( NUMA na, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntPointer psplitindex, @Cast("l_float32*") FloatPointer pave1, @Cast("l_float32*") FloatPointer pave2, @Cast("l_float32*") FloatPointer pnum1, @Cast("l_float32*") FloatPointer pnum2, @ByPtrPtr NUMA pnascore );
public static native @Cast("l_ok") int numaSplitDistribution( NUMA na, @Cast("l_float32") float scorefract, @Cast("l_int32*") IntBuffer psplitindex, @Cast("l_float32*") FloatBuffer pave1, @Cast("l_float32*") FloatBuffer pave2, @Cast("l_float32*") FloatBuffer pnum1, @Cast("l_float32*") FloatBuffer pnum2, @ByPtrPtr NUMA pnascore );
public static native @Cast("l_ok") int numaSplitDistribution( NUMA na, @Cast("l_float32") float scorefract, @Cast("l_int32*") int[] psplitindex, @Cast("l_float32*") float[] pave1, @Cast("l_float32*") float[] pave2, @Cast("l_float32*") float[] pnum1, @Cast("l_float32*") float[] pnum2, @ByPtrPtr NUMA pnascore );
public static native @Cast("l_ok") int grayHistogramsToEMD( NUMAA naa1, NUMAA naa2, @Cast("NUMA**") PointerPointer pnad );
public static native @Cast("l_ok") int grayHistogramsToEMD( NUMAA naa1, NUMAA naa2, @ByPtrPtr NUMA pnad );
public static native @Cast("l_ok") int numaEarthMoverDistance( NUMA na1, NUMA na2, @Cast("l_float32*") FloatPointer pdist );
public static native @Cast("l_ok") int numaEarthMoverDistance( NUMA na1, NUMA na2, @Cast("l_float32*") FloatBuffer pdist );
public static native @Cast("l_ok") int numaEarthMoverDistance( NUMA na1, NUMA na2, @Cast("l_float32*") float[] pdist );
public static native @Cast("l_ok") int grayInterHistogramStats( NUMAA naa, @Cast("l_int32") int wc, @Cast("NUMA**") PointerPointer pnam, @Cast("NUMA**") PointerPointer pnams, @Cast("NUMA**") PointerPointer pnav, @Cast("NUMA**") PointerPointer pnarv );
public static native @Cast("l_ok") int grayInterHistogramStats( NUMAA naa, @Cast("l_int32") int wc, @ByPtrPtr NUMA pnam, @ByPtrPtr NUMA pnams, @ByPtrPtr NUMA pnav, @ByPtrPtr NUMA pnarv );
public static native NUMA numaFindPeaks( NUMA nas, @Cast("l_int32") int nmax, @Cast("l_float32") float fract1, @Cast("l_float32") float fract2 );
public static native NUMA numaFindExtrema( NUMA nas, @Cast("l_float32") float delta, @Cast("NUMA**") PointerPointer pnav );
public static native NUMA numaFindExtrema( NUMA nas, @Cast("l_float32") float delta, @ByPtrPtr NUMA pnav );
public static native @Cast("l_ok") int numaFindLocForThreshold( NUMA na, @Cast("l_int32") int skip, @Cast("l_int32*") IntPointer pthresh, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int numaFindLocForThreshold( NUMA na, @Cast("l_int32") int skip, @Cast("l_int32*") IntBuffer pthresh, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int numaFindLocForThreshold( NUMA na, @Cast("l_int32") int skip, @Cast("l_int32*") int[] pthresh, @Cast("l_float32*") float[] pfract );
public static native @Cast("l_ok") int numaCountReversals( NUMA nas, @Cast("l_float32") float minreversal, @Cast("l_int32*") IntPointer pnr, @Cast("l_float32*") FloatPointer prd );
public static native @Cast("l_ok") int numaCountReversals( NUMA nas, @Cast("l_float32") float minreversal, @Cast("l_int32*") IntBuffer pnr, @Cast("l_float32*") FloatBuffer prd );
public static native @Cast("l_ok") int numaCountReversals( NUMA nas, @Cast("l_float32") float minreversal, @Cast("l_int32*") int[] pnr, @Cast("l_float32*") float[] prd );
public static native @Cast("l_ok") int numaSelectCrossingThreshold( NUMA nax, NUMA nay, @Cast("l_float32") float estthresh, @Cast("l_float32*") FloatPointer pbestthresh );
public static native @Cast("l_ok") int numaSelectCrossingThreshold( NUMA nax, NUMA nay, @Cast("l_float32") float estthresh, @Cast("l_float32*") FloatBuffer pbestthresh );
public static native @Cast("l_ok") int numaSelectCrossingThreshold( NUMA nax, NUMA nay, @Cast("l_float32") float estthresh, @Cast("l_float32*") float[] pbestthresh );
public static native NUMA numaCrossingsByThreshold( NUMA nax, NUMA nay, @Cast("l_float32") float thresh );
public static native NUMA numaCrossingsByPeaks( NUMA nax, NUMA nay, @Cast("l_float32") float delta );
public static native @Cast("l_ok") int numaEvalBestHaarParameters( NUMA nas, @Cast("l_float32") float relweight, @Cast("l_int32") int nwidth, @Cast("l_int32") int nshift, @Cast("l_float32") float minwidth, @Cast("l_float32") float maxwidth, @Cast("l_float32*") FloatPointer pbestwidth, @Cast("l_float32*") FloatPointer pbestshift, @Cast("l_float32*") FloatPointer pbestscore );
public static native @Cast("l_ok") int numaEvalBestHaarParameters( NUMA nas, @Cast("l_float32") float relweight, @Cast("l_int32") int nwidth, @Cast("l_int32") int nshift, @Cast("l_float32") float minwidth, @Cast("l_float32") float maxwidth, @Cast("l_float32*") FloatBuffer pbestwidth, @Cast("l_float32*") FloatBuffer pbestshift, @Cast("l_float32*") FloatBuffer pbestscore );
public static native @Cast("l_ok") int numaEvalBestHaarParameters( NUMA nas, @Cast("l_float32") float relweight, @Cast("l_int32") int nwidth, @Cast("l_int32") int nshift, @Cast("l_float32") float minwidth, @Cast("l_float32") float maxwidth, @Cast("l_float32*") float[] pbestwidth, @Cast("l_float32*") float[] pbestshift, @Cast("l_float32*") float[] pbestscore );
public static native @Cast("l_ok") int numaEvalHaarSum( NUMA nas, @Cast("l_float32") float width, @Cast("l_float32") float shift, @Cast("l_float32") float relweight, @Cast("l_float32*") FloatPointer pscore );
public static native @Cast("l_ok") int numaEvalHaarSum( NUMA nas, @Cast("l_float32") float width, @Cast("l_float32") float shift, @Cast("l_float32") float relweight, @Cast("l_float32*") FloatBuffer pscore );
public static native @Cast("l_ok") int numaEvalHaarSum( NUMA nas, @Cast("l_float32") float width, @Cast("l_float32") float shift, @Cast("l_float32") float relweight, @Cast("l_float32*") float[] pscore );
public static native NUMA genConstrainedNumaInRange( @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int nmax, @Cast("l_int32") int use_pairs );
public static native @Cast("l_ok") int pixGetRegionsBinary( PIX pixs, @Cast("PIX**") PointerPointer ppixhm, @Cast("PIX**") PointerPointer ppixtm, @Cast("PIX**") PointerPointer ppixtb, PIXA pixadb );
public static native @Cast("l_ok") int pixGetRegionsBinary( PIX pixs, @ByPtrPtr PIX ppixhm, @ByPtrPtr PIX ppixtm, @ByPtrPtr PIX ppixtb, PIXA pixadb );
public static native PIX pixGenHalftoneMask( PIX pixs, @Cast("PIX**") PointerPointer ppixtext, @Cast("l_int32*") IntPointer phtfound, @Cast("l_int32") int debug );
public static native PIX pixGenHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") IntPointer phtfound, @Cast("l_int32") int debug );
public static native PIX pixGenHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") IntBuffer phtfound, @Cast("l_int32") int debug );
public static native PIX pixGenHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") int[] phtfound, @Cast("l_int32") int debug );
public static native PIX pixGenerateHalftoneMask( PIX pixs, @Cast("PIX**") PointerPointer ppixtext, @Cast("l_int32*") IntPointer phtfound, PIXA pixadb );
public static native PIX pixGenerateHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") IntPointer phtfound, PIXA pixadb );
public static native PIX pixGenerateHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") IntBuffer phtfound, PIXA pixadb );
public static native PIX pixGenerateHalftoneMask( PIX pixs, @ByPtrPtr PIX ppixtext, @Cast("l_int32*") int[] phtfound, PIXA pixadb );
public static native PIX pixGenTextlineMask( PIX pixs, @Cast("PIX**") PointerPointer ppixvws, @Cast("l_int32*") IntPointer ptlfound, PIXA pixadb );
public static native PIX pixGenTextlineMask( PIX pixs, @ByPtrPtr PIX ppixvws, @Cast("l_int32*") IntPointer ptlfound, PIXA pixadb );
public static native PIX pixGenTextlineMask( PIX pixs, @ByPtrPtr PIX ppixvws, @Cast("l_int32*") IntBuffer ptlfound, PIXA pixadb );
public static native PIX pixGenTextlineMask( PIX pixs, @ByPtrPtr PIX ppixvws, @Cast("l_int32*") int[] ptlfound, PIXA pixadb );
public static native PIX pixGenTextblockMask( PIX pixs, PIX pixvws, PIXA pixadb );
public static native BOX pixFindPageForeground( PIX pixs, @Cast("l_int32") int threshold, @Cast("l_int32") int mindist, @Cast("l_int32") int erasedist, @Cast("l_int32") int showmorph, PIXAC pixac );
public static native @Cast("l_ok") int pixSplitIntoCharacters( PIX pixs, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @Cast("BOXA**") PointerPointer pboxa, @Cast("PIXA**") PointerPointer ppixa, @Cast("PIX**") PointerPointer ppixdebug );
public static native @Cast("l_ok") int pixSplitIntoCharacters( PIX pixs, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @ByPtrPtr BOXA pboxa, @ByPtrPtr PIXA ppixa, @ByPtrPtr PIX ppixdebug );
public static native BOXA pixSplitComponentWithProfile( PIX pixs, @Cast("l_int32") int delta, @Cast("l_int32") int mindel, @Cast("PIX**") PointerPointer ppixdebug );
public static native BOXA pixSplitComponentWithProfile( PIX pixs, @Cast("l_int32") int delta, @Cast("l_int32") int mindel, @ByPtrPtr PIX ppixdebug );
public static native PIXA pixExtractTextlines( PIX pixs, @Cast("l_int32") int maxw, @Cast("l_int32") int maxh, @Cast("l_int32") int minw, @Cast("l_int32") int minh, @Cast("l_int32") int adjw, @Cast("l_int32") int adjh, PIXA pixadb );
public static native PIXA pixExtractRawTextlines( PIX pixs, @Cast("l_int32") int maxw, @Cast("l_int32") int maxh, @Cast("l_int32") int adjw, @Cast("l_int32") int adjh, PIXA pixadb );
public static native @Cast("l_ok") int pixCountTextColumns( PIX pixs, @Cast("l_float32") float deltafract, @Cast("l_float32") float peakfract, @Cast("l_float32") float clipfract, @Cast("l_int32*") IntPointer pncols, PIXA pixadb );
public static native @Cast("l_ok") int pixCountTextColumns( PIX pixs, @Cast("l_float32") float deltafract, @Cast("l_float32") float peakfract, @Cast("l_float32") float clipfract, @Cast("l_int32*") IntBuffer pncols, PIXA pixadb );
public static native @Cast("l_ok") int pixCountTextColumns( PIX pixs, @Cast("l_float32") float deltafract, @Cast("l_float32") float peakfract, @Cast("l_float32") float clipfract, @Cast("l_int32*") int[] pncols, PIXA pixadb );
public static native @Cast("l_ok") int pixDecideIfText( PIX pixs, BOX box, @Cast("l_int32*") IntPointer pistext, PIXA pixadb );
public static native @Cast("l_ok") int pixDecideIfText( PIX pixs, BOX box, @Cast("l_int32*") IntBuffer pistext, PIXA pixadb );
public static native @Cast("l_ok") int pixDecideIfText( PIX pixs, BOX box, @Cast("l_int32*") int[] pistext, PIXA pixadb );
public static native @Cast("l_ok") int pixFindThreshFgExtent( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") IntPointer ptop, @Cast("l_int32*") IntPointer pbot );
public static native @Cast("l_ok") int pixFindThreshFgExtent( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") IntBuffer ptop, @Cast("l_int32*") IntBuffer pbot );
public static native @Cast("l_ok") int pixFindThreshFgExtent( PIX pixs, @Cast("l_int32") int thresh, @Cast("l_int32*") int[] ptop, @Cast("l_int32*") int[] pbot );
public static native @Cast("l_ok") int pixDecideIfTable( PIX pixs, BOX box, @Cast("l_int32") int orient, @Cast("l_int32*") IntPointer pscore, PIXA pixadb );
public static native @Cast("l_ok") int pixDecideIfTable( PIX pixs, BOX box, @Cast("l_int32") int orient, @Cast("l_int32*") IntBuffer pscore, PIXA pixadb );
public static native @Cast("l_ok") int pixDecideIfTable( PIX pixs, BOX box, @Cast("l_int32") int orient, @Cast("l_int32*") int[] pscore, PIXA pixadb );
public static native PIX pixPrepare1bpp( PIX pixs, BOX box, @Cast("l_float32") float cropfract, @Cast("l_int32") int outres );
public static native @Cast("l_ok") int pixEstimateBackground( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_float32") float edgecrop, @Cast("l_int32*") IntPointer pbg );
public static native @Cast("l_ok") int pixEstimateBackground( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_float32") float edgecrop, @Cast("l_int32*") IntBuffer pbg );
public static native @Cast("l_ok") int pixEstimateBackground( PIX pixs, @Cast("l_int32") int darkthresh, @Cast("l_float32") float edgecrop, @Cast("l_int32*") int[] pbg );
public static native @Cast("l_ok") int pixFindLargeRectangles( PIX pixs, @Cast("l_int32") int polarity, @Cast("l_int32") int nrect, @Cast("BOXA**") PointerPointer pboxa, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int pixFindLargeRectangles( PIX pixs, @Cast("l_int32") int polarity, @Cast("l_int32") int nrect, @ByPtrPtr BOXA pboxa, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixFindLargestRectangle( PIX pixs, @Cast("l_int32") int polarity, @Cast("BOX**") PointerPointer pbox, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int pixFindLargestRectangle( PIX pixs, @Cast("l_int32") int polarity, @ByPtrPtr BOX pbox, @ByPtrPtr PIX ppixdb );
public static native BOX pixFindRectangleInCC( PIX pixs, BOX boxs, @Cast("l_float32") float fract, @Cast("l_int32") int dir, @Cast("l_int32") int select, @Cast("l_int32") int debug );
public static native PIX pixAutoPhotoinvert( PIX pixs, @Cast("l_int32") int thresh, @Cast("PIX**") PointerPointer ppixm, PIXA pixadb );
public static native PIX pixAutoPhotoinvert( PIX pixs, @Cast("l_int32") int thresh, @ByPtrPtr PIX ppixm, PIXA pixadb );
public static native @Cast("l_ok") int pixSetSelectCmap( PIX pixs, BOX box, @Cast("l_int32") int sindex, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixColorGrayRegionsCmap( PIX pixs, BOXA boxa, @Cast("l_int32") int type, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixColorGrayCmap( PIX pixs, BOX box, @Cast("l_int32") int type, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixColorGrayMaskedCmap( PIX pixs, PIX pixm, @Cast("l_int32") int type, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int addColorizedGrayToCmap( PIXCMAP cmap, @Cast("l_int32") int type, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("NUMA**") PointerPointer pna );
public static native @Cast("l_ok") int addColorizedGrayToCmap( PIXCMAP cmap, @Cast("l_int32") int type, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @ByPtrPtr NUMA pna );
public static native @Cast("l_ok") int pixSetSelectMaskedCmap( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int sindex, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixSetMaskedCmap( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("char*") BytePointer parseForProtos( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer prestring );
public static native @Cast("char*") ByteBuffer parseForProtos( String filein, String prestring );
public static native @Cast("l_ok") int partifyFiles( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int nparts, @Cast("const char*") BytePointer outroot, @Cast("const char*") BytePointer debugfile );
public static native @Cast("l_ok") int partifyFiles( String dirname, String substr, @Cast("l_int32") int nparts, String outroot, String debugfile );
public static native @Cast("l_ok") int partifyPixac( PIXAC pixac, @Cast("l_int32") int nparts, @Cast("const char*") BytePointer outroot, PIXA pixadb );
public static native @Cast("l_ok") int partifyPixac( PIXAC pixac, @Cast("l_int32") int nparts, String outroot, PIXA pixadb );
public static native BOXA boxaGetWhiteblocks( BOXA boxas, BOX box, @Cast("l_int32") int sortflag, @Cast("l_int32") int maxboxes, @Cast("l_float32") float maxoverlap, @Cast("l_int32") int maxperim, @Cast("l_float32") float fract, @Cast("l_int32") int maxpops );
public static native BOXA boxaPruneSortedOnOverlap( BOXA boxas, @Cast("l_float32") float maxoverlap );
public static native @Cast("l_ok") int convertFilesToPdf( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertFilesToPdf( String dirname, String substr, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, String fileout );
public static native @Cast("l_ok") int saConvertFilesToPdf( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int saConvertFilesToPdf( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, String fileout );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertFilesToPdfData( SARRAY sa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int selectDefaultPdfEncoding( PIX pix, @Cast("l_int32*") IntPointer ptype );
public static native @Cast("l_ok") int selectDefaultPdfEncoding( PIX pix, @Cast("l_int32*") IntBuffer ptype );
public static native @Cast("l_ok") int selectDefaultPdfEncoding( PIX pix, @Cast("l_int32*") int[] ptype );
public static native @Cast("l_ok") int convertUnscaledFilesToPdf( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertUnscaledFilesToPdf( String dirname, String substr, String title, String fileout );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdf( SARRAY sa, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdf( SARRAY sa, String title, String fileout );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConvertUnscaledFilesToPdfData( SARRAY sa, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( @Cast("const char*") BytePointer fname, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( @Cast("const char*") BytePointer fname, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( String fname, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( @Cast("const char*") BytePointer fname, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( String fname, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( @Cast("const char*") BytePointer fname, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertUnscaledToPdfData( String fname, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdf( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixaConvertToPdf( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, String fileout );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixaConvertToPdfData( PIXA pixa, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdf( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdf( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdf( String filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, String fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") ByteBuffer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, String fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") byte[] imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, String fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") ByteBuffer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdf( @Cast("l_uint8*") byte[] imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, String fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( String filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( String filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( @Cast("const char*") BytePointer filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertToPdfData( String filein, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") ByteBuffer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") byte[] imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") BytePointer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") ByteBuffer imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int convertImageDataToPdfData( @Cast("l_uint8*") byte[] imdata, @Cast("size_t") long size, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdf( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdf( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdf( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, String fileout, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixWriteStreamPdf( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int res, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixWriteStreamPdf( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int res, String title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, String title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, String title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixWriteMemPdf( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, PIX pix, @Cast("l_int32") int res, String title );
public static native @Cast("l_ok") int convertSegmentedFilesToPdf( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXAA baa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertSegmentedFilesToPdf( String dirname, String substr, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXAA baa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, String fileout );
public static native BOXAA convertNumberedMasksToBoxaa( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost );
public static native BOXAA convertNumberedMasksToBoxaa( String dirname, String substr, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost );
public static native @Cast("l_ok") int convertToPdfSegmented( @Cast("const char*") BytePointer filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertToPdfSegmented( String filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, String fileout );
public static native @Cast("l_ok") int pixConvertToPdfSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixConvertToPdfSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, String fileout );
public static native @Cast("l_ok") int convertToPdfDataSegmented( @Cast("const char*") BytePointer filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( @Cast("const char*") BytePointer filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( String filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( @Cast("const char*") BytePointer filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( String filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( @Cast("const char*") BytePointer filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertToPdfDataSegmented( String filein, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfDataSegmented( PIX pixs, @Cast("l_int32") int res, @Cast("l_int32") int type, @Cast("l_int32") int thresh, BOXA boxa, @Cast("l_int32") int quality, @Cast("l_float32") float scalefactor, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdf( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int concatenatePdf( String dirname, String substr, String fileout );
public static native @Cast("l_ok") int saConcatenatePdf( SARRAY sa, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int saConcatenatePdf( SARRAY sa, String fileout );
public static native @Cast("l_ok") int ptraConcatenatePdf( L_PTRA pa, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int ptraConcatenatePdf( L_PTRA pa, String fileout );
public static native @Cast("l_ok") int concatenatePdfToData( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( String dirname, String substr, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( String dirname, String substr, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int concatenatePdfToData( String dirname, String substr, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConcatenatePdfToData( SARRAY sa, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConcatenatePdfToData( SARRAY sa, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConcatenatePdfToData( SARRAY sa, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int saConcatenatePdfToData( SARRAY sa, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @Cast("L_PDF_DATA**") PointerPointer plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("const char*") BytePointer title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int pixConvertToPdfData( PIX pix, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, String title, @ByPtrPtr L_PDF_DATA plpd, @Cast("l_int32") int _position );
public static native @Cast("l_ok") int ptraConcatenatePdfToData( L_PTRA pa_data, SARRAY sa, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int ptraConcatenatePdfToData( L_PTRA pa_data, SARRAY sa, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int ptraConcatenatePdfToData( L_PTRA pa_data, SARRAY sa, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int ptraConcatenatePdfToData( L_PTRA pa_data, SARRAY sa, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int convertTiffMultipageToPdf( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertTiffMultipageToPdf( String filein, String fileout );
public static native @Cast("l_ok") int l_generateCIDataForPdf( @Cast("const char*") BytePointer fname, PIX pix, @Cast("l_int32") int quality, @Cast("L_COMP_DATA**") PointerPointer pcid );
public static native @Cast("l_ok") int l_generateCIDataForPdf( @Cast("const char*") BytePointer fname, PIX pix, @Cast("l_int32") int quality, @ByPtrPtr L_COMP_DATA pcid );
public static native @Cast("l_ok") int l_generateCIDataForPdf( String fname, PIX pix, @Cast("l_int32") int quality, @ByPtrPtr L_COMP_DATA pcid );
public static native @Cast("l_ok") int l_generateCIData( @Cast("const char*") BytePointer fname, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_int32") int ascii85, @Cast("L_COMP_DATA**") PointerPointer pcid );
public static native @Cast("l_ok") int l_generateCIData( @Cast("const char*") BytePointer fname, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_int32") int ascii85, @ByPtrPtr L_COMP_DATA pcid );
public static native @Cast("l_ok") int l_generateCIData( String fname, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_int32") int ascii85, @ByPtrPtr L_COMP_DATA pcid );
public static native L_COMP_DATA l_generateFlateDataPdf( @Cast("const char*") BytePointer fname, PIX pixs );
public static native L_COMP_DATA l_generateFlateDataPdf( String fname, PIX pixs );
public static native L_COMP_DATA l_generateJpegData( @Cast("const char*") BytePointer fname, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateJpegData( String fname, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateJpegDataMem( @Cast("l_uint8*") BytePointer data, @Cast("size_t") long nbytes, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateJpegDataMem( @Cast("l_uint8*") ByteBuffer data, @Cast("size_t") long nbytes, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateJpegDataMem( @Cast("l_uint8*") byte[] data, @Cast("size_t") long nbytes, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateG4Data( @Cast("const char*") BytePointer fname, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateG4Data( String fname, @Cast("l_int32") int ascii85flag );
public static native @Cast("l_ok") int pixGenerateCIData( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_int32") int ascii85, @Cast("L_COMP_DATA**") PointerPointer pcid );
public static native @Cast("l_ok") int pixGenerateCIData( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_int32") int ascii85, @ByPtrPtr L_COMP_DATA pcid );
public static native L_COMP_DATA l_generateFlateData( @Cast("const char*") BytePointer fname, @Cast("l_int32") int ascii85flag );
public static native L_COMP_DATA l_generateFlateData( String fname, @Cast("l_int32") int ascii85flag );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int cidConvertToPdfData( L_COMP_DATA cid, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native void l_CIDataDestroy( @Cast("L_COMP_DATA**") PointerPointer pcid );
public static native void l_CIDataDestroy( @ByPtrPtr L_COMP_DATA pcid );
public static native void l_pdfSetG4ImageMask( @Cast("l_int32") int flag );
public static native void l_pdfSetDateAndVersion( @Cast("l_int32") int flag );
public static native void setPixMemoryManager( alloc_fn allocator, dealloc_fn deallocator );
public static native PIX pixCreate( @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int depth );
public static native PIX pixCreateNoInit( @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int depth );
public static native PIX pixCreateTemplate( @Const PIX pixs );
public static native PIX pixCreateTemplateNoInit( @Const PIX pixs );
public static native PIX pixCreateWithCmap( @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int depth, @Cast("l_int32") int initcolor );
public static native PIX pixCreateHeader( @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int depth );
public static native PIX pixClone( PIX pixs );
public static native void pixDestroy( @Cast("PIX**") PointerPointer ppix );
public static native void pixDestroy( @ByPtrPtr PIX ppix );
public static native PIX pixCopy( PIX pixd, @Const PIX pixs );
public static native @Cast("l_ok") int pixResizeImageData( PIX pixd, @Const PIX pixs );
public static native @Cast("l_ok") int pixCopyColormap( PIX pixd, @Const PIX pixs );
public static native @Cast("l_ok") int pixTransferAllData( PIX pixd, @Cast("PIX**") PointerPointer ppixs, @Cast("l_int32") int copytext, @Cast("l_int32") int copyformat );
public static native @Cast("l_ok") int pixTransferAllData( PIX pixd, @ByPtrPtr PIX ppixs, @Cast("l_int32") int copytext, @Cast("l_int32") int copyformat );
public static native @Cast("l_ok") int pixSwapAndDestroy( @Cast("PIX**") PointerPointer ppixd, @Cast("PIX**") PointerPointer ppixs );
public static native @Cast("l_ok") int pixSwapAndDestroy( @ByPtrPtr PIX ppixd, @ByPtrPtr PIX ppixs );
public static native @Cast("l_int32") int pixGetWidth( @Const PIX pix );
public static native @Cast("l_int32") int pixSetWidth( PIX pix, @Cast("l_int32") int width );
public static native @Cast("l_int32") int pixGetHeight( @Const PIX pix );
public static native @Cast("l_int32") int pixSetHeight( PIX pix, @Cast("l_int32") int height );
public static native @Cast("l_int32") int pixGetDepth( @Const PIX pix );
public static native @Cast("l_int32") int pixSetDepth( PIX pix, @Cast("l_int32") int depth );
public static native @Cast("l_ok") int pixGetDimensions( @Const PIX pix, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd );
public static native @Cast("l_ok") int pixGetDimensions( @Const PIX pix, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd );
public static native @Cast("l_ok") int pixGetDimensions( @Const PIX pix, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd );
public static native @Cast("l_ok") int pixSetDimensions( PIX pix, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int d );
public static native @Cast("l_ok") int pixCopyDimensions( PIX pixd, @Const PIX pixs );
public static native @Cast("l_int32") int pixGetSpp( @Const PIX pix );
public static native @Cast("l_int32") int pixSetSpp( PIX pix, @Cast("l_int32") int spp );
public static native @Cast("l_ok") int pixCopySpp( PIX pixd, @Const PIX pixs );
public static native @Cast("l_int32") int pixGetWpl( @Const PIX pix );
public static native @Cast("l_int32") int pixSetWpl( PIX pix, @Cast("l_int32") int wpl );
public static native @Cast("l_int32") int pixGetRefcount( @Const PIX pix );
public static native @Cast("l_int32") int pixChangeRefcount( PIX pix, @Cast("l_int32") int delta );
public static native @Cast("l_int32") int pixGetXRes( @Const PIX pix );
public static native @Cast("l_int32") int pixSetXRes( PIX pix, @Cast("l_int32") int res );
public static native @Cast("l_int32") int pixGetYRes( @Const PIX pix );
public static native @Cast("l_int32") int pixSetYRes( PIX pix, @Cast("l_int32") int res );
public static native @Cast("l_ok") int pixGetResolution( @Const PIX pix, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_ok") int pixGetResolution( @Const PIX pix, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_ok") int pixGetResolution( @Const PIX pix, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int pixSetResolution( PIX pix, @Cast("l_int32") int xres, @Cast("l_int32") int yres );
public static native @Cast("l_int32") int pixCopyResolution( PIX pixd, @Const PIX pixs );
public static native @Cast("l_int32") int pixScaleResolution( PIX pix, @Cast("l_float32") float xscale, @Cast("l_float32") float yscale );
public static native @Cast("l_int32") int pixGetInputFormat( @Const PIX pix );
public static native @Cast("l_int32") int pixSetInputFormat( PIX pix, @Cast("l_int32") int informat );
public static native @Cast("l_int32") int pixCopyInputFormat( PIX pixd, @Const PIX pixs );
public static native @Cast("l_int32") int pixSetSpecial( PIX pix, @Cast("l_int32") int special );
public static native @Cast("char*") BytePointer pixGetText( PIX pix );
public static native @Cast("l_ok") int pixSetText( PIX pix, @Cast("const char*") BytePointer textstring );
public static native @Cast("l_ok") int pixSetText( PIX pix, String textstring );
public static native @Cast("l_ok") int pixAddText( PIX pix, @Cast("const char*") BytePointer textstring );
public static native @Cast("l_ok") int pixAddText( PIX pix, String textstring );
public static native @Cast("l_int32") int pixCopyText( PIX pixd, @Const PIX pixs );
public static native @Cast("l_uint8*") BytePointer pixGetTextCompNew( PIX pix, @Cast("size_t*") SizeTPointer psize );
public static native @Cast("l_ok") int pixSetTextCompNew( PIX pix, @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixSetTextCompNew( PIX pix, @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixSetTextCompNew( PIX pix, @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native PIXCMAP pixGetColormap( PIX pix );
public static native @Cast("l_ok") int pixSetColormap( PIX pix, PIXCMAP colormap );
public static native @Cast("l_ok") int pixDestroyColormap( PIX pix );
public static native @Cast("l_uint32*") IntPointer pixGetData( PIX pix );
public static native @Cast("l_int32") int pixSetData( PIX pix, @Cast("l_uint32*") IntPointer data );
public static native @Cast("l_int32") int pixSetData( PIX pix, @Cast("l_uint32*") IntBuffer data );
public static native @Cast("l_int32") int pixSetData( PIX pix, @Cast("l_uint32*") int[] data );
public static native @Cast("l_uint32*") IntPointer pixExtractData( PIX pixs );
public static native @Cast("l_int32") int pixFreeData( PIX pix );
public static native @Cast("void**") PointerPointer pixGetLinePtrs( PIX pix, @Cast("l_int32*") IntPointer psize );
public static native @Cast("void**") @ByPtrPtr Pointer pixGetLinePtrs( PIX pix, @Cast("l_int32*") IntBuffer psize );
public static native @Cast("void**") @ByPtrPtr Pointer pixGetLinePtrs( PIX pix, @Cast("l_int32*") int[] psize );
public static native @Cast("l_int32") int pixSizesEqual( @Const PIX pix1, @Const PIX pix2 );
public static native @Cast("l_ok") int pixMaxAspectRatio( PIX pixs, @Cast("l_float32*") FloatPointer pratio );
public static native @Cast("l_ok") int pixMaxAspectRatio( PIX pixs, @Cast("l_float32*") FloatBuffer pratio );
public static native @Cast("l_ok") int pixMaxAspectRatio( PIX pixs, @Cast("l_float32*") float[] pratio );
public static native @Cast("l_ok") int pixPrintStreamInfo( @Cast("FILE*") Pointer fp, @Const PIX pix, @Cast("const char*") BytePointer text );
public static native @Cast("l_ok") int pixPrintStreamInfo( @Cast("FILE*") Pointer fp, @Const PIX pix, String text );
public static native @Cast("l_ok") int pixGetPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32*") IntPointer pval );
public static native @Cast("l_ok") int pixGetPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32*") IntBuffer pval );
public static native @Cast("l_ok") int pixGetPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32*") int[] pval );
public static native @Cast("l_ok") int pixSetPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixGetRGBPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native @Cast("l_ok") int pixGetRGBPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native @Cast("l_ok") int pixGetRGBPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native @Cast("l_ok") int pixSetRGBPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixSetCmapPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval );
public static native @Cast("l_ok") int pixGetRandomPixel( PIX pix, @Cast("l_uint32*") IntPointer pval, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py );
public static native @Cast("l_ok") int pixGetRandomPixel( PIX pix, @Cast("l_uint32*") IntBuffer pval, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py );
public static native @Cast("l_ok") int pixGetRandomPixel( PIX pix, @Cast("l_uint32*") int[] pval, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py );
public static native @Cast("l_ok") int pixClearPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixFlipPixel( PIX pix, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native void setPixelLow( @Cast("l_uint32*") IntPointer line, @Cast("l_int32") int x, @Cast("l_int32") int depth, @Cast("l_uint32") int val );
public static native void setPixelLow( @Cast("l_uint32*") IntBuffer line, @Cast("l_int32") int x, @Cast("l_int32") int depth, @Cast("l_uint32") int val );
public static native void setPixelLow( @Cast("l_uint32*") int[] line, @Cast("l_int32") int x, @Cast("l_int32") int depth, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixGetBlackOrWhiteVal( PIX pixs, @Cast("l_int32") int op, @Cast("l_uint32*") IntPointer pval );
public static native @Cast("l_ok") int pixGetBlackOrWhiteVal( PIX pixs, @Cast("l_int32") int op, @Cast("l_uint32*") IntBuffer pval );
public static native @Cast("l_ok") int pixGetBlackOrWhiteVal( PIX pixs, @Cast("l_int32") int op, @Cast("l_uint32*") int[] pval );
public static native @Cast("l_ok") int pixClearAll( PIX pix );
public static native @Cast("l_ok") int pixSetAll( PIX pix );
public static native @Cast("l_ok") int pixSetAllGray( PIX pix, @Cast("l_int32") int grayval );
public static native @Cast("l_ok") int pixSetAllArbitrary( PIX pix, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixSetBlackOrWhite( PIX pixs, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixSetComponentArbitrary( PIX pix, @Cast("l_int32") int comp, @Cast("l_int32") int val );
public static native @Cast("l_ok") int pixClearInRect( PIX pix, BOX box );
public static native @Cast("l_ok") int pixSetInRect( PIX pix, BOX box );
public static native @Cast("l_ok") int pixSetInRectArbitrary( PIX pix, BOX box, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixBlendInRect( PIX pixs, BOX box, @Cast("l_uint32") int val, @Cast("l_float32") float fract );
public static native @Cast("l_ok") int pixSetPadBits( PIX pix, @Cast("l_int32") int val );
public static native @Cast("l_ok") int pixSetPadBitsBand( PIX pix, @Cast("l_int32") int by, @Cast("l_int32") int bh, @Cast("l_int32") int val );
public static native @Cast("l_ok") int pixSetOrClearBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixSetBorderVal( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixSetBorderRingVal( PIX pixs, @Cast("l_int32") int dist, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixSetMirroredBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixCopyBorder( PIX pixd, PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixAddBorder( PIX pixs, @Cast("l_int32") int npix, @Cast("l_uint32") int val );
public static native PIX pixAddBlackOrWhiteBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot, @Cast("l_int32") int op );
public static native PIX pixAddBorderGeneral( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot, @Cast("l_uint32") int val );
public static native PIX pixRemoveBorder( PIX pixs, @Cast("l_int32") int npix );
public static native PIX pixRemoveBorderGeneral( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixRemoveBorderToSize( PIX pixs, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIX pixAddMirroredBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixAddRepeatedBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixAddMixedBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native PIX pixAddContinuedBorder( PIX pixs, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot );
public static native @Cast("l_ok") int pixShiftAndTransferAlpha( PIX pixd, PIX pixs, @Cast("l_float32") float shiftx, @Cast("l_float32") float shifty );
public static native PIX pixDisplayLayersRGBA( PIX pixs, @Cast("l_uint32") int val, @Cast("l_int32") int maxw );
public static native PIX pixCreateRGBImage( PIX pixr, PIX pixg, PIX pixb );
public static native PIX pixGetRGBComponent( PIX pixs, @Cast("l_int32") int comp );
public static native @Cast("l_ok") int pixSetRGBComponent( PIX pixd, PIX pixs, @Cast("l_int32") int comp );
public static native PIX pixGetRGBComponentCmap( PIX pixs, @Cast("l_int32") int comp );
public static native @Cast("l_ok") int pixCopyRGBComponent( PIX pixd, PIX pixs, @Cast("l_int32") int comp );
public static native @Cast("l_ok") int composeRGBPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") IntPointer ppixel );
public static native @Cast("l_ok") int composeRGBPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") IntBuffer ppixel );
public static native @Cast("l_ok") int composeRGBPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_uint32*") int[] ppixel );
public static native @Cast("l_ok") int composeRGBAPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int aval, @Cast("l_uint32*") IntPointer ppixel );
public static native @Cast("l_ok") int composeRGBAPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int aval, @Cast("l_uint32*") IntBuffer ppixel );
public static native @Cast("l_ok") int composeRGBAPixel( @Cast("l_int32") int rval, @Cast("l_int32") int gval, @Cast("l_int32") int bval, @Cast("l_int32") int aval, @Cast("l_uint32*") int[] ppixel );
public static native void extractRGBValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval );
public static native void extractRGBValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval );
public static native void extractRGBValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval );
public static native void extractRGBAValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval, @Cast("l_int32*") IntPointer paval );
public static native void extractRGBAValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval, @Cast("l_int32*") IntBuffer paval );
public static native void extractRGBAValues( @Cast("l_uint32") int pixel, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval, @Cast("l_int32*") int[] paval );
public static native @Cast("l_int32") int extractMinMaxComponent( @Cast("l_uint32") int pixel, @Cast("l_int32") int type );
public static native @Cast("l_ok") int pixGetRGBLine( PIX pixs, @Cast("l_int32") int row, @Cast("l_uint8*") BytePointer bufr, @Cast("l_uint8*") BytePointer bufg, @Cast("l_uint8*") BytePointer bufb );
public static native @Cast("l_ok") int pixGetRGBLine( PIX pixs, @Cast("l_int32") int row, @Cast("l_uint8*") ByteBuffer bufr, @Cast("l_uint8*") ByteBuffer bufg, @Cast("l_uint8*") ByteBuffer bufb );
public static native @Cast("l_ok") int pixGetRGBLine( PIX pixs, @Cast("l_int32") int row, @Cast("l_uint8*") byte[] bufr, @Cast("l_uint8*") byte[] bufg, @Cast("l_uint8*") byte[] bufb );
public static native @Cast("l_ok") int setLineDataVal( @Cast("l_uint32*") IntPointer line, @Cast("l_int32") int j, @Cast("l_int32") int d, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int setLineDataVal( @Cast("l_uint32*") IntBuffer line, @Cast("l_int32") int j, @Cast("l_int32") int d, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int setLineDataVal( @Cast("l_uint32*") int[] line, @Cast("l_int32") int j, @Cast("l_int32") int d, @Cast("l_uint32") int val );
public static native PIX pixEndianByteSwapNew( PIX pixs );
public static native @Cast("l_ok") int pixEndianByteSwap( PIX pixs );
public static native @Cast("l_int32") int lineEndianByteSwap( @Cast("l_uint32*") IntPointer datad, @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int wpl );
public static native @Cast("l_int32") int lineEndianByteSwap( @Cast("l_uint32*") IntBuffer datad, @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int wpl );
public static native @Cast("l_int32") int lineEndianByteSwap( @Cast("l_uint32*") int[] datad, @Cast("l_uint32*") int[] datas, @Cast("l_int32") int wpl );
public static native PIX pixEndianTwoByteSwapNew( PIX pixs );
public static native @Cast("l_ok") int pixEndianTwoByteSwap( PIX pixs );
public static native @Cast("l_ok") int pixGetRasterData( PIX pixs, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixGetRasterData( PIX pixs, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixGetRasterData( PIX pixs, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixGetRasterData( PIX pixs, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixInferResolution( PIX pix, @Cast("l_float32") float longside, @Cast("l_int32*") IntPointer pres );
public static native @Cast("l_ok") int pixInferResolution( PIX pix, @Cast("l_float32") float longside, @Cast("l_int32*") IntBuffer pres );
public static native @Cast("l_ok") int pixInferResolution( PIX pix, @Cast("l_float32") float longside, @Cast("l_int32*") int[] pres );
public static native @Cast("l_ok") int pixAlphaIsOpaque( PIX pix, @Cast("l_int32*") IntPointer popaque );
public static native @Cast("l_ok") int pixAlphaIsOpaque( PIX pix, @Cast("l_int32*") IntBuffer popaque );
public static native @Cast("l_ok") int pixAlphaIsOpaque( PIX pix, @Cast("l_int32*") int[] popaque );
public static native @Cast("l_uint8**") PointerPointer pixSetupByteProcessing( PIX pix, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_uint8**") @ByPtrPtr ByteBuffer pixSetupByteProcessing( PIX pix, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_uint8**") @ByPtrPtr byte[] pixSetupByteProcessing( PIX pix, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int pixCleanupByteProcessing( PIX pix, @Cast("l_uint8**") PointerPointer lineptrs );
public static native @Cast("l_ok") int pixCleanupByteProcessing( PIX pix, @Cast("l_uint8**") @ByPtrPtr BytePointer lineptrs );
public static native @Cast("l_ok") int pixCleanupByteProcessing( PIX pix, @Cast("l_uint8**") @ByPtrPtr ByteBuffer lineptrs );
public static native @Cast("l_ok") int pixCleanupByteProcessing( PIX pix, @Cast("l_uint8**") @ByPtrPtr byte[] lineptrs );
public static native void l_setAlphaMaskBorder( @Cast("l_float32") float val1, @Cast("l_float32") float val2 );
public static native @Cast("l_ok") int pixSetMasked( PIX pixd, PIX pixm, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixSetMaskedGeneral( PIX pixd, PIX pixm, @Cast("l_uint32") int val, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixCombineMasked( PIX pixd, PIX pixs, PIX pixm );
public static native @Cast("l_ok") int pixCombineMaskedGeneral( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixPaintThroughMask( PIX pixd, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32") int val );
public static native PIX pixCopyWithBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int background );
public static native @Cast("l_ok") int pixPaintSelfThroughMask( PIX pixd, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int searchdir, @Cast("l_int32") int mindist, @Cast("l_int32") int tilesize, @Cast("l_int32") int ntiles, @Cast("l_int32") int distblend );
public static native PIX pixMakeMaskFromVal( PIX pixs, @Cast("l_int32") int val );
public static native PIX pixMakeMaskFromLUT( PIX pixs, @Cast("l_int32*") IntPointer tab );
public static native PIX pixMakeMaskFromLUT( PIX pixs, @Cast("l_int32*") IntBuffer tab );
public static native PIX pixMakeMaskFromLUT( PIX pixs, @Cast("l_int32*") int[] tab );
public static native PIX pixMakeArbMaskFromRGB( PIX pixs, @Cast("l_float32") float rc, @Cast("l_float32") float gc, @Cast("l_float32") float bc, @Cast("l_float32") float thresh );
public static native PIX pixSetUnderTransparency( PIX pixs, @Cast("l_uint32") int val, @Cast("l_int32") int debug );
public static native PIX pixMakeAlphaFromMask( PIX pixs, @Cast("l_int32") int dist, @Cast("BOX**") PointerPointer pbox );
public static native PIX pixMakeAlphaFromMask( PIX pixs, @Cast("l_int32") int dist, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int pixGetColorNearMaskBoundary( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int dist, @Cast("l_uint32*") IntPointer pval, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixGetColorNearMaskBoundary( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int dist, @Cast("l_uint32*") IntBuffer pval, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixGetColorNearMaskBoundary( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int dist, @Cast("l_uint32*") int[] pval, @Cast("l_int32") int debug );
public static native PIX pixDisplaySelectedPixels( PIX pixs, PIX pixm, SEL sel, @Cast("l_uint32") int val );
public static native PIX pixInvert( PIX pixd, PIX pixs );
public static native PIX pixOr( PIX pixd, PIX pixs1, PIX pixs2 );
public static native PIX pixAnd( PIX pixd, PIX pixs1, PIX pixs2 );
public static native PIX pixXor( PIX pixd, PIX pixs1, PIX pixs2 );
public static native PIX pixSubtract( PIX pixd, PIX pixs1, PIX pixs2 );
public static native @Cast("l_ok") int pixZero( PIX pix, @Cast("l_int32*") IntPointer pempty );
public static native @Cast("l_ok") int pixZero( PIX pix, @Cast("l_int32*") IntBuffer pempty );
public static native @Cast("l_ok") int pixZero( PIX pix, @Cast("l_int32*") int[] pempty );
public static native @Cast("l_ok") int pixForegroundFraction( PIX pix, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixForegroundFraction( PIX pix, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixForegroundFraction( PIX pix, @Cast("l_float32*") float[] pfract );
public static native NUMA pixaCountPixels( PIXA pixa );
public static native @Cast("l_ok") int pixCountPixels( PIX pixs, @Cast("l_int32*") IntPointer pcount, @Cast("l_int32*") IntPointer tab8 );
public static native @Cast("l_ok") int pixCountPixels( PIX pixs, @Cast("l_int32*") IntBuffer pcount, @Cast("l_int32*") IntBuffer tab8 );
public static native @Cast("l_ok") int pixCountPixels( PIX pixs, @Cast("l_int32*") int[] pcount, @Cast("l_int32*") int[] tab8 );
public static native @Cast("l_ok") int pixCountPixelsInRect( PIX pixs, BOX box, @Cast("l_int32*") IntPointer pcount, @Cast("l_int32*") IntPointer tab8 );
public static native @Cast("l_ok") int pixCountPixelsInRect( PIX pixs, BOX box, @Cast("l_int32*") IntBuffer pcount, @Cast("l_int32*") IntBuffer tab8 );
public static native @Cast("l_ok") int pixCountPixelsInRect( PIX pixs, BOX box, @Cast("l_int32*") int[] pcount, @Cast("l_int32*") int[] tab8 );
public static native NUMA pixCountByRow( PIX pix, BOX box );
public static native NUMA pixCountByColumn( PIX pix, BOX box );
public static native NUMA pixCountPixelsByRow( PIX pix, @Cast("l_int32*") IntPointer tab8 );
public static native NUMA pixCountPixelsByRow( PIX pix, @Cast("l_int32*") IntBuffer tab8 );
public static native NUMA pixCountPixelsByRow( PIX pix, @Cast("l_int32*") int[] tab8 );
public static native NUMA pixCountPixelsByColumn( PIX pix );
public static native @Cast("l_ok") int pixCountPixelsInRow( PIX pix, @Cast("l_int32") int row, @Cast("l_int32*") IntPointer pcount, @Cast("l_int32*") IntPointer tab8 );
public static native @Cast("l_ok") int pixCountPixelsInRow( PIX pix, @Cast("l_int32") int row, @Cast("l_int32*") IntBuffer pcount, @Cast("l_int32*") IntBuffer tab8 );
public static native @Cast("l_ok") int pixCountPixelsInRow( PIX pix, @Cast("l_int32") int row, @Cast("l_int32*") int[] pcount, @Cast("l_int32*") int[] tab8 );
public static native NUMA pixGetMomentByColumn( PIX pix, @Cast("l_int32") int order );
public static native @Cast("l_ok") int pixThresholdPixelSum( PIX pix, @Cast("l_int32") int thresh, @Cast("l_int32*") IntPointer pabove, @Cast("l_int32*") IntPointer tab8 );
public static native @Cast("l_ok") int pixThresholdPixelSum( PIX pix, @Cast("l_int32") int thresh, @Cast("l_int32*") IntBuffer pabove, @Cast("l_int32*") IntBuffer tab8 );
public static native @Cast("l_ok") int pixThresholdPixelSum( PIX pix, @Cast("l_int32") int thresh, @Cast("l_int32*") int[] pabove, @Cast("l_int32*") int[] tab8 );
public static native @Cast("l_int32*") IntPointer makePixelSumTab8( );
public static native @Cast("l_int32*") IntPointer makePixelCentroidTab8( );
public static native NUMA pixAverageByRow( PIX pix, BOX box, @Cast("l_int32") int type );
public static native NUMA pixAverageByColumn( PIX pix, BOX box, @Cast("l_int32") int type );
public static native @Cast("l_ok") int pixAverageInRect( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int minval, @Cast("l_int32") int maxval, @Cast("l_int32") int subsamp, @Cast("l_float32*") FloatPointer pave );
public static native @Cast("l_ok") int pixAverageInRect( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int minval, @Cast("l_int32") int maxval, @Cast("l_int32") int subsamp, @Cast("l_float32*") FloatBuffer pave );
public static native @Cast("l_ok") int pixAverageInRect( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int minval, @Cast("l_int32") int maxval, @Cast("l_int32") int subsamp, @Cast("l_float32*") float[] pave );
public static native @Cast("l_ok") int pixAverageInRectRGB( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int subsamp, @Cast("l_uint32*") IntPointer pave );
public static native @Cast("l_ok") int pixAverageInRectRGB( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int subsamp, @Cast("l_uint32*") IntBuffer pave );
public static native @Cast("l_ok") int pixAverageInRectRGB( PIX pixs, PIX pixm, BOX box, @Cast("l_int32") int subsamp, @Cast("l_uint32*") int[] pave );
public static native NUMA pixVarianceByRow( PIX pix, BOX box );
public static native NUMA pixVarianceByColumn( PIX pix, BOX box );
public static native @Cast("l_ok") int pixVarianceInRect( PIX pix, BOX box, @Cast("l_float32*") FloatPointer prootvar );
public static native @Cast("l_ok") int pixVarianceInRect( PIX pix, BOX box, @Cast("l_float32*") FloatBuffer prootvar );
public static native @Cast("l_ok") int pixVarianceInRect( PIX pix, BOX box, @Cast("l_float32*") float[] prootvar );
public static native NUMA pixAbsDiffByRow( PIX pix, BOX box );
public static native NUMA pixAbsDiffByColumn( PIX pix, BOX box );
public static native @Cast("l_ok") int pixAbsDiffInRect( PIX pix, BOX box, @Cast("l_int32") int dir, @Cast("l_float32*") FloatPointer pabsdiff );
public static native @Cast("l_ok") int pixAbsDiffInRect( PIX pix, BOX box, @Cast("l_int32") int dir, @Cast("l_float32*") FloatBuffer pabsdiff );
public static native @Cast("l_ok") int pixAbsDiffInRect( PIX pix, BOX box, @Cast("l_int32") int dir, @Cast("l_float32*") float[] pabsdiff );
public static native @Cast("l_ok") int pixAbsDiffOnLine( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_float32*") FloatPointer pabsdiff );
public static native @Cast("l_ok") int pixAbsDiffOnLine( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_float32*") FloatBuffer pabsdiff );
public static native @Cast("l_ok") int pixAbsDiffOnLine( PIX pix, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_float32*") float[] pabsdiff );
public static native @Cast("l_int32") int pixCountArbInRect( PIX pixs, BOX box, @Cast("l_int32") int val, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_int32") int pixCountArbInRect( PIX pixs, BOX box, @Cast("l_int32") int val, @Cast("l_int32") int factor, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_int32") int pixCountArbInRect( PIX pixs, BOX box, @Cast("l_int32") int val, @Cast("l_int32") int factor, @Cast("l_int32*") int[] pcount );
public static native PIX pixMirroredTiling( PIX pixs, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native @Cast("l_ok") int pixFindRepCloseTile( PIX pixs, BOX box, @Cast("l_int32") int searchdir, @Cast("l_int32") int mindist, @Cast("l_int32") int tsize, @Cast("l_int32") int ntiles, @Cast("BOX**") PointerPointer pboxtile, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixFindRepCloseTile( PIX pixs, BOX box, @Cast("l_int32") int searchdir, @Cast("l_int32") int mindist, @Cast("l_int32") int tsize, @Cast("l_int32") int ntiles, @ByPtrPtr BOX pboxtile, @Cast("l_int32") int debug );
public static native NUMA pixGetGrayHistogram( PIX pixs, @Cast("l_int32") int factor );
public static native NUMA pixGetGrayHistogramMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor );
public static native NUMA pixGetGrayHistogramInRect( PIX pixs, BOX box, @Cast("l_int32") int factor );
public static native NUMAA pixGetGrayHistogramTiled( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int nx, @Cast("l_int32") int ny );
public static native @Cast("l_ok") int pixGetColorHistogram( PIX pixs, @Cast("l_int32") int factor, @Cast("NUMA**") PointerPointer pnar, @Cast("NUMA**") PointerPointer pnag, @Cast("NUMA**") PointerPointer pnab );
public static native @Cast("l_ok") int pixGetColorHistogram( PIX pixs, @Cast("l_int32") int factor, @ByPtrPtr NUMA pnar, @ByPtrPtr NUMA pnag, @ByPtrPtr NUMA pnab );
public static native @Cast("l_ok") int pixGetColorHistogramMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("NUMA**") PointerPointer pnar, @Cast("NUMA**") PointerPointer pnag, @Cast("NUMA**") PointerPointer pnab );
public static native @Cast("l_ok") int pixGetColorHistogramMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @ByPtrPtr NUMA pnar, @ByPtrPtr NUMA pnag, @ByPtrPtr NUMA pnab );
public static native NUMA pixGetCmapHistogram( PIX pixs, @Cast("l_int32") int factor );
public static native NUMA pixGetCmapHistogramMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor );
public static native NUMA pixGetCmapHistogramInRect( PIX pixs, BOX box, @Cast("l_int32") int factor );
public static native @Cast("l_ok") int pixCountRGBColorsByHash( PIX pixs, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixCountRGBColorsByHash( PIX pixs, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixCountRGBColorsByHash( PIX pixs, @Cast("l_int32*") int[] pncolors );
public static native @Cast("l_ok") int pixCountRGBColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pncolors );
public static native @Cast("l_ok") int pixCountRGBColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") IntBuffer pncolors );
public static native @Cast("l_ok") int pixCountRGBColors( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32*") int[] pncolors );
public static native L_AMAP pixGetColorAmapHistogram( PIX pixs, @Cast("l_int32") int factor );
public static native @Cast("l_int32") int amapGetCountForColor( L_AMAP amap, @Cast("l_uint32") int val );
public static native @Cast("l_ok") int pixGetRankValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_uint32*") IntPointer pvalue );
public static native @Cast("l_ok") int pixGetRankValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_uint32*") IntBuffer pvalue );
public static native @Cast("l_ok") int pixGetRankValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_uint32*") int[] pvalue );
public static native @Cast("l_ok") int pixGetRankValueMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer prval, @Cast("l_float32*") FloatPointer pgval, @Cast("l_float32*") FloatPointer pbval );
public static native @Cast("l_ok") int pixGetRankValueMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") FloatBuffer prval, @Cast("l_float32*") FloatBuffer pgval, @Cast("l_float32*") FloatBuffer pbval );
public static native @Cast("l_ok") int pixGetRankValueMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") float[] prval, @Cast("l_float32*") float[] pgval, @Cast("l_float32*") float[] pbval );
public static native @Cast("l_ok") int pixGetRankValueMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer pval, @Cast("NUMA**") PointerPointer pna );
public static native @Cast("l_ok") int pixGetRankValueMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") FloatPointer pval, @ByPtrPtr NUMA pna );
public static native @Cast("l_ok") int pixGetRankValueMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") FloatBuffer pval, @ByPtrPtr NUMA pna );
public static native @Cast("l_ok") int pixGetRankValueMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_float32") float rank, @Cast("l_float32*") float[] pval, @ByPtrPtr NUMA pna );
public static native @Cast("l_ok") int pixGetPixelAverage( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_uint32*") IntPointer pval );
public static native @Cast("l_ok") int pixGetPixelAverage( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_uint32*") IntBuffer pval );
public static native @Cast("l_ok") int pixGetPixelAverage( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_uint32*") int[] pval );
public static native @Cast("l_ok") int pixGetPixelStats( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_uint32*") IntPointer pvalue );
public static native @Cast("l_ok") int pixGetPixelStats( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_uint32*") IntBuffer pvalue );
public static native @Cast("l_ok") int pixGetPixelStats( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_uint32*") int[] pvalue );
public static native @Cast("l_ok") int pixGetAverageMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") FloatPointer prval, @Cast("l_float32*") FloatPointer pgval, @Cast("l_float32*") FloatPointer pbval );
public static native @Cast("l_ok") int pixGetAverageMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") FloatBuffer prval, @Cast("l_float32*") FloatBuffer pgval, @Cast("l_float32*") FloatBuffer pbval );
public static native @Cast("l_ok") int pixGetAverageMaskedRGB( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") float[] prval, @Cast("l_float32*") float[] pgval, @Cast("l_float32*") float[] pbval );
public static native @Cast("l_ok") int pixGetAverageMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int pixGetAverageMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int pixGetAverageMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int pixGetAverageTiledRGB( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int type, @Cast("PIX**") PointerPointer ppixr, @Cast("PIX**") PointerPointer ppixg, @Cast("PIX**") PointerPointer ppixb );
public static native @Cast("l_ok") int pixGetAverageTiledRGB( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int type, @ByPtrPtr PIX ppixr, @ByPtrPtr PIX ppixg, @ByPtrPtr PIX ppixb );
public static native PIX pixGetAverageTiled( PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy, @Cast("l_int32") int type );
public static native @Cast("l_int32") int pixRowStats( PIX pixs, BOX box, @Cast("NUMA**") PointerPointer pnamean, @Cast("NUMA**") PointerPointer pnamedian, @Cast("NUMA**") PointerPointer pnamode, @Cast("NUMA**") PointerPointer pnamodecount, @Cast("NUMA**") PointerPointer pnavar, @Cast("NUMA**") PointerPointer pnarootvar );
public static native @Cast("l_int32") int pixRowStats( PIX pixs, BOX box, @ByPtrPtr NUMA pnamean, @ByPtrPtr NUMA pnamedian, @ByPtrPtr NUMA pnamode, @ByPtrPtr NUMA pnamodecount, @ByPtrPtr NUMA pnavar, @ByPtrPtr NUMA pnarootvar );
public static native @Cast("l_int32") int pixColumnStats( PIX pixs, BOX box, @Cast("NUMA**") PointerPointer pnamean, @Cast("NUMA**") PointerPointer pnamedian, @Cast("NUMA**") PointerPointer pnamode, @Cast("NUMA**") PointerPointer pnamodecount, @Cast("NUMA**") PointerPointer pnavar, @Cast("NUMA**") PointerPointer pnarootvar );
public static native @Cast("l_int32") int pixColumnStats( PIX pixs, BOX box, @ByPtrPtr NUMA pnamean, @ByPtrPtr NUMA pnamedian, @ByPtrPtr NUMA pnamode, @ByPtrPtr NUMA pnamodecount, @ByPtrPtr NUMA pnavar, @ByPtrPtr NUMA pnarootvar );
public static native @Cast("l_ok") int pixGetRangeValues( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") IntPointer pminval, @Cast("l_int32*") IntPointer pmaxval );
public static native @Cast("l_ok") int pixGetRangeValues( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") IntBuffer pminval, @Cast("l_int32*") IntBuffer pmaxval );
public static native @Cast("l_ok") int pixGetRangeValues( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") int[] pminval, @Cast("l_int32*") int[] pmaxval );
public static native @Cast("l_ok") int pixGetExtremeValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer prval, @Cast("l_int32*") IntPointer pgval, @Cast("l_int32*") IntPointer pbval, @Cast("l_int32*") IntPointer pgrayval );
public static native @Cast("l_ok") int pixGetExtremeValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer prval, @Cast("l_int32*") IntBuffer pgval, @Cast("l_int32*") IntBuffer pbval, @Cast("l_int32*") IntBuffer pgrayval );
public static native @Cast("l_ok") int pixGetExtremeValue( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int type, @Cast("l_int32*") int[] prval, @Cast("l_int32*") int[] pgval, @Cast("l_int32*") int[] pbval, @Cast("l_int32*") int[] pgrayval );
public static native @Cast("l_ok") int pixGetMaxValueInRect( PIX pixs, BOX box, @Cast("l_uint32*") IntPointer pmaxval, @Cast("l_int32*") IntPointer pxmax, @Cast("l_int32*") IntPointer pymax );
public static native @Cast("l_ok") int pixGetMaxValueInRect( PIX pixs, BOX box, @Cast("l_uint32*") IntBuffer pmaxval, @Cast("l_int32*") IntBuffer pxmax, @Cast("l_int32*") IntBuffer pymax );
public static native @Cast("l_ok") int pixGetMaxValueInRect( PIX pixs, BOX box, @Cast("l_uint32*") int[] pmaxval, @Cast("l_int32*") int[] pxmax, @Cast("l_int32*") int[] pymax );
public static native @Cast("l_ok") int pixGetMaxColorIndex( PIX pixs, @Cast("l_int32*") IntPointer pmaxindex );
public static native @Cast("l_ok") int pixGetMaxColorIndex( PIX pixs, @Cast("l_int32*") IntBuffer pmaxindex );
public static native @Cast("l_ok") int pixGetMaxColorIndex( PIX pixs, @Cast("l_int32*") int[] pmaxindex );
public static native @Cast("l_ok") int pixGetBinnedComponentRange( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") IntPointer pminval, @Cast("l_int32*") IntPointer pmaxval, @Cast("l_uint32**") PointerPointer pcarray, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetBinnedComponentRange( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") IntPointer pminval, @Cast("l_int32*") IntPointer pmaxval, @Cast("l_uint32**") @ByPtrPtr IntPointer pcarray, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetBinnedComponentRange( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") IntBuffer pminval, @Cast("l_int32*") IntBuffer pmaxval, @Cast("l_uint32**") @ByPtrPtr IntBuffer pcarray, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetBinnedComponentRange( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int factor, @Cast("l_int32") int color, @Cast("l_int32*") int[] pminval, @Cast("l_int32*") int[] pmaxval, @Cast("l_uint32**") @ByPtrPtr int[] pcarray, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetRankColorArray( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int type, @Cast("l_int32") int factor, @Cast("l_uint32**") PointerPointer pcarray, PIXA pixadb, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetRankColorArray( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int type, @Cast("l_int32") int factor, @Cast("l_uint32**") @ByPtrPtr IntPointer pcarray, PIXA pixadb, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetRankColorArray( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int type, @Cast("l_int32") int factor, @Cast("l_uint32**") @ByPtrPtr IntBuffer pcarray, PIXA pixadb, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetRankColorArray( PIX pixs, @Cast("l_int32") int nbins, @Cast("l_int32") int type, @Cast("l_int32") int factor, @Cast("l_uint32**") @ByPtrPtr int[] pcarray, PIXA pixadb, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixGetBinnedColor( PIX pixs, PIX pixg, @Cast("l_int32") int factor, @Cast("l_int32") int nbins, @Cast("l_uint32**") PointerPointer pcarray, PIXA pixadb );
public static native @Cast("l_ok") int pixGetBinnedColor( PIX pixs, PIX pixg, @Cast("l_int32") int factor, @Cast("l_int32") int nbins, @Cast("l_uint32**") @ByPtrPtr IntPointer pcarray, PIXA pixadb );
public static native @Cast("l_ok") int pixGetBinnedColor( PIX pixs, PIX pixg, @Cast("l_int32") int factor, @Cast("l_int32") int nbins, @Cast("l_uint32**") @ByPtrPtr IntBuffer pcarray, PIXA pixadb );
public static native @Cast("l_ok") int pixGetBinnedColor( PIX pixs, PIX pixg, @Cast("l_int32") int factor, @Cast("l_int32") int nbins, @Cast("l_uint32**") @ByPtrPtr int[] pcarray, PIXA pixadb );
public static native PIX pixDisplayColorArray( @Cast("l_uint32*") IntPointer carray, @Cast("l_int32") int ncolors, @Cast("l_int32") int side, @Cast("l_int32") int ncols, @Cast("l_int32") int fontsize );
public static native PIX pixDisplayColorArray( @Cast("l_uint32*") IntBuffer carray, @Cast("l_int32") int ncolors, @Cast("l_int32") int side, @Cast("l_int32") int ncols, @Cast("l_int32") int fontsize );
public static native PIX pixDisplayColorArray( @Cast("l_uint32*") int[] carray, @Cast("l_int32") int ncolors, @Cast("l_int32") int side, @Cast("l_int32") int ncols, @Cast("l_int32") int fontsize );
public static native PIX pixRankBinByStrip( PIX pixs, @Cast("l_int32") int direction, @Cast("l_int32") int size, @Cast("l_int32") int nbins, @Cast("l_int32") int type );
public static native PIX pixaGetAlignedStats( PIXA pixa, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh );
public static native @Cast("l_ok") int pixaExtractColumnFromEachPix( PIXA pixa, @Cast("l_int32") int col, PIX pixd );
public static native @Cast("l_ok") int pixGetRowStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatPointer colvect );
public static native @Cast("l_ok") int pixGetRowStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatBuffer colvect );
public static native @Cast("l_ok") int pixGetRowStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") float[] colvect );
public static native @Cast("l_ok") int pixGetColumnStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatPointer rowvect );
public static native @Cast("l_ok") int pixGetColumnStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatBuffer rowvect );
public static native @Cast("l_ok") int pixGetColumnStats( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int nbins, @Cast("l_int32") int thresh, @Cast("l_float32*") float[] rowvect );
public static native @Cast("l_ok") int pixSetPixelColumn( PIX pix, @Cast("l_int32") int col, @Cast("l_float32*") FloatPointer colvect );
public static native @Cast("l_ok") int pixSetPixelColumn( PIX pix, @Cast("l_int32") int col, @Cast("l_float32*") FloatBuffer colvect );
public static native @Cast("l_ok") int pixSetPixelColumn( PIX pix, @Cast("l_int32") int col, @Cast("l_float32*") float[] colvect );
public static native @Cast("l_ok") int pixThresholdForFgBg( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int thresh, @Cast("l_int32*") IntPointer pfgval, @Cast("l_int32*") IntPointer pbgval );
public static native @Cast("l_ok") int pixThresholdForFgBg( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int thresh, @Cast("l_int32*") IntBuffer pfgval, @Cast("l_int32*") IntBuffer pbgval );
public static native @Cast("l_ok") int pixThresholdForFgBg( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int thresh, @Cast("l_int32*") int[] pfgval, @Cast("l_int32*") int[] pbgval );
public static native @Cast("l_ok") int pixSplitDistributionFgBg( PIX pixs, @Cast("l_float32") float scorefract, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pthresh, @Cast("l_int32*") IntPointer pfgval, @Cast("l_int32*") IntPointer pbgval, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int pixSplitDistributionFgBg( PIX pixs, @Cast("l_float32") float scorefract, @Cast("l_int32") int factor, @Cast("l_int32*") IntPointer pthresh, @Cast("l_int32*") IntPointer pfgval, @Cast("l_int32*") IntPointer pbgval, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixSplitDistributionFgBg( PIX pixs, @Cast("l_float32") float scorefract, @Cast("l_int32") int factor, @Cast("l_int32*") IntBuffer pthresh, @Cast("l_int32*") IntBuffer pfgval, @Cast("l_int32*") IntBuffer pbgval, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixSplitDistributionFgBg( PIX pixs, @Cast("l_float32") float scorefract, @Cast("l_int32") int factor, @Cast("l_int32*") int[] pthresh, @Cast("l_int32*") int[] pfgval, @Cast("l_int32*") int[] pbgval, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int pixaFindDimensions( PIXA pixa, @Cast("NUMA**") PointerPointer pnaw, @Cast("NUMA**") PointerPointer pnah );
public static native @Cast("l_ok") int pixaFindDimensions( PIXA pixa, @ByPtrPtr NUMA pnaw, @ByPtrPtr NUMA pnah );
public static native @Cast("l_ok") int pixFindAreaPerimRatio( PIX pixs, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFindAreaPerimRatio( PIX pixs, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFindAreaPerimRatio( PIX pixs, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pfract );
public static native NUMA pixaFindPerimToAreaRatio( PIXA pixa );
public static native @Cast("l_ok") int pixFindPerimToAreaRatio( PIX pixs, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFindPerimToAreaRatio( PIX pixs, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFindPerimToAreaRatio( PIX pixs, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pfract );
public static native NUMA pixaFindPerimSizeRatio( PIXA pixa );
public static native @Cast("l_ok") int pixFindPerimSizeRatio( PIX pixs, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pratio );
public static native @Cast("l_ok") int pixFindPerimSizeRatio( PIX pixs, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pratio );
public static native @Cast("l_ok") int pixFindPerimSizeRatio( PIX pixs, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pratio );
public static native NUMA pixaFindAreaFraction( PIXA pixa );
public static native @Cast("l_ok") int pixFindAreaFraction( PIX pixs, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFindAreaFraction( PIX pixs, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFindAreaFraction( PIX pixs, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pfract );
public static native NUMA pixaFindAreaFractionMasked( PIXA pixa, PIX pixm, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixFindAreaFractionMasked( PIX pixs, BOX box, PIX pixm, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFindAreaFractionMasked( PIX pixs, BOX box, PIX pixm, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFindAreaFractionMasked( PIX pixs, BOX box, PIX pixm, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pfract );
public static native NUMA pixaFindWidthHeightRatio( PIXA pixa );
public static native NUMA pixaFindWidthHeightProduct( PIXA pixa );
public static native @Cast("l_ok") int pixFindOverlapFraction( PIX pixs1, PIX pixs2, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32*") IntPointer tab, @Cast("l_float32*") FloatPointer pratio, @Cast("l_int32*") IntPointer pnoverlap );
public static native @Cast("l_ok") int pixFindOverlapFraction( PIX pixs1, PIX pixs2, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32*") IntBuffer tab, @Cast("l_float32*") FloatBuffer pratio, @Cast("l_int32*") IntBuffer pnoverlap );
public static native @Cast("l_ok") int pixFindOverlapFraction( PIX pixs1, PIX pixs2, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32*") int[] tab, @Cast("l_float32*") float[] pratio, @Cast("l_int32*") int[] pnoverlap );
public static native BOXA pixFindRectangleComps( PIX pixs, @Cast("l_int32") int dist, @Cast("l_int32") int minw, @Cast("l_int32") int minh );
public static native @Cast("l_ok") int pixConformsToRectangle( PIX pixs, BOX box, @Cast("l_int32") int dist, @Cast("l_int32*") IntPointer pconforms );
public static native @Cast("l_ok") int pixConformsToRectangle( PIX pixs, BOX box, @Cast("l_int32") int dist, @Cast("l_int32*") IntBuffer pconforms );
public static native @Cast("l_ok") int pixConformsToRectangle( PIX pixs, BOX box, @Cast("l_int32") int dist, @Cast("l_int32*") int[] pconforms );
public static native PIXA pixClipRectangles( PIX pixs, BOXA boxa );
public static native PIX pixClipRectangle( PIX pixs, BOX box, @Cast("BOX**") PointerPointer pboxc );
public static native PIX pixClipRectangle( PIX pixs, BOX box, @ByPtrPtr BOX pboxc );
public static native PIX pixClipRectangleWithBorder( PIX pixs, BOX box, @Cast("l_int32") int maxbord, @Cast("BOX**") PointerPointer pboxn );
public static native PIX pixClipRectangleWithBorder( PIX pixs, BOX box, @Cast("l_int32") int maxbord, @ByPtrPtr BOX pboxn );
public static native PIX pixClipMasked( PIX pixs, PIX pixm, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint32") int outval );
public static native @Cast("l_ok") int pixCropToMatch( PIX pixs1, PIX pixs2, @Cast("PIX**") PointerPointer ppixd1, @Cast("PIX**") PointerPointer ppixd2 );
public static native @Cast("l_ok") int pixCropToMatch( PIX pixs1, PIX pixs2, @ByPtrPtr PIX ppixd1, @ByPtrPtr PIX ppixd2 );
public static native PIX pixCropToSize( PIX pixs, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixResizeToMatch( PIX pixs, PIX pixt, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixSelectComponentBySize( PIX pixs, @Cast("l_int32") int rankorder, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @Cast("BOX**") PointerPointer pbox );
public static native PIX pixSelectComponentBySize( PIX pixs, @Cast("l_int32") int rankorder, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @ByPtrPtr BOX pbox );
public static native PIX pixFilterComponentBySize( PIX pixs, @Cast("l_int32") int rankorder, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @Cast("BOX**") PointerPointer pbox );
public static native PIX pixFilterComponentBySize( PIX pixs, @Cast("l_int32") int rankorder, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @ByPtrPtr BOX pbox );
public static native PIX pixMakeSymmetricMask( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float hf, @Cast("l_float32") float vf, @Cast("l_int32") int type );
public static native PIX pixMakeFrameMask( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float hf1, @Cast("l_float32") float hf2, @Cast("l_float32") float vf1, @Cast("l_float32") float vf2 );
public static native PIX pixMakeCoveringOfRectangles( PIX pixs, @Cast("l_int32") int maxiters );
public static native @Cast("l_ok") int pixFractionFgInMask( PIX pix1, PIX pix2, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFractionFgInMask( PIX pix1, PIX pix2, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFractionFgInMask( PIX pix1, PIX pix2, @Cast("l_float32*") float[] pfract );
public static native @Cast("l_ok") int pixClipToForeground( PIX pixs, @Cast("PIX**") PointerPointer ppixd, @Cast("BOX**") PointerPointer pbox );
public static native @Cast("l_ok") int pixClipToForeground( PIX pixs, @ByPtrPtr PIX ppixd, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int pixTestClipToForeground( PIX pixs, @Cast("l_int32*") IntPointer pcanclip );
public static native @Cast("l_ok") int pixTestClipToForeground( PIX pixs, @Cast("l_int32*") IntBuffer pcanclip );
public static native @Cast("l_ok") int pixTestClipToForeground( PIX pixs, @Cast("l_int32*") int[] pcanclip );
public static native @Cast("l_ok") int pixClipBoxToForeground( PIX pixs, BOX boxs, @Cast("PIX**") PointerPointer ppixd, @Cast("BOX**") PointerPointer pboxd );
public static native @Cast("l_ok") int pixClipBoxToForeground( PIX pixs, BOX boxs, @ByPtrPtr PIX ppixd, @ByPtrPtr BOX pboxd );
public static native @Cast("l_ok") int pixScanForForeground( PIX pixs, BOX box, @Cast("l_int32") int scanflag, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_ok") int pixScanForForeground( PIX pixs, BOX box, @Cast("l_int32") int scanflag, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_ok") int pixScanForForeground( PIX pixs, BOX box, @Cast("l_int32") int scanflag, @Cast("l_int32*") int[] ploc );
public static native @Cast("l_ok") int pixClipBoxToEdges( PIX pixs, BOX boxs, @Cast("l_int32") int lowthresh, @Cast("l_int32") int highthresh, @Cast("l_int32") int maxwidth, @Cast("l_int32") int factor, @Cast("PIX**") PointerPointer ppixd, @Cast("BOX**") PointerPointer pboxd );
public static native @Cast("l_ok") int pixClipBoxToEdges( PIX pixs, BOX boxs, @Cast("l_int32") int lowthresh, @Cast("l_int32") int highthresh, @Cast("l_int32") int maxwidth, @Cast("l_int32") int factor, @ByPtrPtr PIX ppixd, @ByPtrPtr BOX pboxd );
public static native @Cast("l_ok") int pixScanForEdge( PIX pixs, BOX box, @Cast("l_int32") int lowthresh, @Cast("l_int32") int highthresh, @Cast("l_int32") int maxwidth, @Cast("l_int32") int factor, @Cast("l_int32") int scanflag, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_ok") int pixScanForEdge( PIX pixs, BOX box, @Cast("l_int32") int lowthresh, @Cast("l_int32") int highthresh, @Cast("l_int32") int maxwidth, @Cast("l_int32") int factor, @Cast("l_int32") int scanflag, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_ok") int pixScanForEdge( PIX pixs, BOX box, @Cast("l_int32") int lowthresh, @Cast("l_int32") int highthresh, @Cast("l_int32") int maxwidth, @Cast("l_int32") int factor, @Cast("l_int32") int scanflag, @Cast("l_int32*") int[] ploc );
public static native NUMA pixExtractOnLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int factor );
public static native @Cast("l_float32") float pixAverageOnLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int factor );
public static native NUMA pixAverageIntensityProfile( PIX pixs, @Cast("l_float32") float fract, @Cast("l_int32") int dir, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int factor1, @Cast("l_int32") int factor2 );
public static native NUMA pixReversalProfile( PIX pixs, @Cast("l_float32") float fract, @Cast("l_int32") int dir, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int minreversal, @Cast("l_int32") int factor1, @Cast("l_int32") int factor2 );
public static native @Cast("l_ok") int pixWindowedVarianceOnLine( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int loc, @Cast("l_int32") int c1, @Cast("l_int32") int c2, @Cast("l_int32") int size, @Cast("NUMA**") PointerPointer pnad );
public static native @Cast("l_ok") int pixWindowedVarianceOnLine( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int loc, @Cast("l_int32") int c1, @Cast("l_int32") int c2, @Cast("l_int32") int size, @ByPtrPtr NUMA pnad );
public static native @Cast("l_ok") int pixMinMaxNearLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int dist, @Cast("l_int32") int direction, @Cast("NUMA**") PointerPointer pnamin, @Cast("NUMA**") PointerPointer pnamax, @Cast("l_float32*") FloatPointer pminave, @Cast("l_float32*") FloatPointer pmaxave );
public static native @Cast("l_ok") int pixMinMaxNearLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int dist, @Cast("l_int32") int direction, @ByPtrPtr NUMA pnamin, @ByPtrPtr NUMA pnamax, @Cast("l_float32*") FloatPointer pminave, @Cast("l_float32*") FloatPointer pmaxave );
public static native @Cast("l_ok") int pixMinMaxNearLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int dist, @Cast("l_int32") int direction, @ByPtrPtr NUMA pnamin, @ByPtrPtr NUMA pnamax, @Cast("l_float32*") FloatBuffer pminave, @Cast("l_float32*") FloatBuffer pmaxave );
public static native @Cast("l_ok") int pixMinMaxNearLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2, @Cast("l_int32") int dist, @Cast("l_int32") int direction, @ByPtrPtr NUMA pnamin, @ByPtrPtr NUMA pnamax, @Cast("l_float32*") float[] pminave, @Cast("l_float32*") float[] pmaxave );
public static native PIX pixRankRowTransform( PIX pixs );
public static native PIX pixRankColumnTransform( PIX pixs );
public static native PIXA pixaCreate( @Cast("l_int32") int n );
public static native PIXA pixaCreateFromPix( PIX pixs, @Cast("l_int32") int n, @Cast("l_int32") int cellw, @Cast("l_int32") int cellh );
public static native PIXA pixaCreateFromBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int start, @Cast("l_int32") int num, @Cast("l_int32*") IntPointer pcropwarn );
public static native PIXA pixaCreateFromBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int start, @Cast("l_int32") int num, @Cast("l_int32*") IntBuffer pcropwarn );
public static native PIXA pixaCreateFromBoxa( PIX pixs, BOXA boxa, @Cast("l_int32") int start, @Cast("l_int32") int num, @Cast("l_int32*") int[] pcropwarn );
public static native PIXA pixaSplitPix( PIX pixs, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int borderwidth, @Cast("l_uint32") int bordercolor );
public static native void pixaDestroy( @Cast("PIXA**") PointerPointer ppixa );
public static native void pixaDestroy( @ByPtrPtr PIXA ppixa );
public static native PIXA pixaCopy( PIXA pixa, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaAddPix( PIXA pixa, PIX pix, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaAddBox( PIXA pixa, BOX box, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaExtendArrayToSize( PIXA pixa, @Cast("size_t") long size );
public static native @Cast("l_int32") int pixaGetCount( PIXA pixa );
public static native @Cast("l_ok") int pixaChangeRefcount( PIXA pixa, @Cast("l_int32") int delta );
public static native PIX pixaGetPix( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32") int accesstype );
public static native @Cast("l_ok") int pixaGetPixDimensions( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd );
public static native @Cast("l_ok") int pixaGetPixDimensions( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd );
public static native @Cast("l_ok") int pixaGetPixDimensions( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd );
public static native BOXA pixaGetBoxa( PIXA pixa, @Cast("l_int32") int accesstype );
public static native @Cast("l_int32") int pixaGetBoxaCount( PIXA pixa );
public static native BOX pixaGetBox( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32") int accesstype );
public static native @Cast("l_ok") int pixaGetBoxGeometry( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int pixaGetBoxGeometry( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int pixaGetBoxGeometry( PIXA pixa, @Cast("l_int32") int index, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_ok") int pixaSetBoxa( PIXA pixa, BOXA boxa, @Cast("l_int32") int accesstype );
public static native @Cast("PIX**") PointerPointer pixaGetPixArray( PIXA pixa );
public static native @Cast("l_ok") int pixaVerifyDepth( PIXA pixa, @Cast("l_int32*") IntPointer psame, @Cast("l_int32*") IntPointer pmaxd );
public static native @Cast("l_ok") int pixaVerifyDepth( PIXA pixa, @Cast("l_int32*") IntBuffer psame, @Cast("l_int32*") IntBuffer pmaxd );
public static native @Cast("l_ok") int pixaVerifyDepth( PIXA pixa, @Cast("l_int32*") int[] psame, @Cast("l_int32*") int[] pmaxd );
public static native @Cast("l_ok") int pixaVerifyDimensions( PIXA pixa, @Cast("l_int32*") IntPointer psame, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int pixaVerifyDimensions( PIXA pixa, @Cast("l_int32*") IntBuffer psame, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int pixaVerifyDimensions( PIXA pixa, @Cast("l_int32*") int[] psame, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native @Cast("l_ok") int pixaIsFull( PIXA pixa, @Cast("l_int32*") IntPointer pfullpa, @Cast("l_int32*") IntPointer pfullba );
public static native @Cast("l_ok") int pixaIsFull( PIXA pixa, @Cast("l_int32*") IntBuffer pfullpa, @Cast("l_int32*") IntBuffer pfullba );
public static native @Cast("l_ok") int pixaIsFull( PIXA pixa, @Cast("l_int32*") int[] pfullpa, @Cast("l_int32*") int[] pfullba );
public static native @Cast("l_ok") int pixaCountText( PIXA pixa, @Cast("l_int32*") IntPointer pntext );
public static native @Cast("l_ok") int pixaCountText( PIXA pixa, @Cast("l_int32*") IntBuffer pntext );
public static native @Cast("l_ok") int pixaCountText( PIXA pixa, @Cast("l_int32*") int[] pntext );
public static native @Cast("l_ok") int pixaSetText( PIXA pixa, @Cast("const char*") BytePointer text, SARRAY sa );
public static native @Cast("l_ok") int pixaSetText( PIXA pixa, String text, SARRAY sa );
public static native @Cast("void***") @ByPtrPtr PointerPointer pixaGetLinePtrs( PIXA pixa, @Cast("l_int32*") IntPointer psize );
public static native @Cast("void***") @ByPtrPtr PointerPointer pixaGetLinePtrs( PIXA pixa, @Cast("l_int32*") IntBuffer psize );
public static native @Cast("void***") @ByPtrPtr PointerPointer pixaGetLinePtrs( PIXA pixa, @Cast("l_int32*") int[] psize );
public static native @Cast("l_ok") int pixaWriteStreamInfo( @Cast("FILE*") Pointer fp, PIXA pixa );
public static native @Cast("l_ok") int pixaReplacePix( PIXA pixa, @Cast("l_int32") int index, PIX pix, BOX box );
public static native @Cast("l_ok") int pixaInsertPix( PIXA pixa, @Cast("l_int32") int index, PIX pixs, BOX box );
public static native @Cast("l_ok") int pixaRemovePix( PIXA pixa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int pixaRemovePixAndSave( PIXA pixa, @Cast("l_int32") int index, @Cast("PIX**") PointerPointer ppix, @Cast("BOX**") PointerPointer pbox );
public static native @Cast("l_ok") int pixaRemovePixAndSave( PIXA pixa, @Cast("l_int32") int index, @ByPtrPtr PIX ppix, @ByPtrPtr BOX pbox );
public static native @Cast("l_ok") int pixaRemoveSelected( PIXA pixa, NUMA naindex );
public static native @Cast("l_ok") int pixaInitFull( PIXA pixa, PIX pix, BOX box );
public static native @Cast("l_ok") int pixaClear( PIXA pixa );
public static native @Cast("l_ok") int pixaJoin( PIXA pixad, PIXA pixas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native PIXA pixaInterleave( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaaJoin( PIXAA paad, PIXAA paas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native PIXAA pixaaCreate( @Cast("l_int32") int n );
public static native PIXAA pixaaCreateFromPixa( PIXA pixa, @Cast("l_int32") int n, @Cast("l_int32") int type, @Cast("l_int32") int copyflag );
public static native void pixaaDestroy( @Cast("PIXAA**") PointerPointer ppaa );
public static native void pixaaDestroy( @ByPtrPtr PIXAA ppaa );
public static native @Cast("l_ok") int pixaaAddPixa( PIXAA paa, PIXA pixa, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaaAddPix( PIXAA paa, @Cast("l_int32") int index, PIX pix, BOX box, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaaAddBox( PIXAA paa, BOX box, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int pixaaGetCount( PIXAA paa, @Cast("NUMA**") PointerPointer pna );
public static native @Cast("l_int32") int pixaaGetCount( PIXAA paa, @ByPtrPtr NUMA pna );
public static native PIXA pixaaGetPixa( PIXAA paa, @Cast("l_int32") int index, @Cast("l_int32") int accesstype );
public static native BOXA pixaaGetBoxa( PIXAA paa, @Cast("l_int32") int accesstype );
public static native PIX pixaaGetPix( PIXAA paa, @Cast("l_int32") int index, @Cast("l_int32") int ipix, @Cast("l_int32") int accessflag );
public static native @Cast("l_ok") int pixaaVerifyDepth( PIXAA paa, @Cast("l_int32*") IntPointer psame, @Cast("l_int32*") IntPointer pmaxd );
public static native @Cast("l_ok") int pixaaVerifyDepth( PIXAA paa, @Cast("l_int32*") IntBuffer psame, @Cast("l_int32*") IntBuffer pmaxd );
public static native @Cast("l_ok") int pixaaVerifyDepth( PIXAA paa, @Cast("l_int32*") int[] psame, @Cast("l_int32*") int[] pmaxd );
public static native @Cast("l_ok") int pixaaVerifyDimensions( PIXAA paa, @Cast("l_int32*") IntPointer psame, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int pixaaVerifyDimensions( PIXAA paa, @Cast("l_int32*") IntBuffer psame, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int pixaaVerifyDimensions( PIXAA paa, @Cast("l_int32*") int[] psame, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native @Cast("l_int32") int pixaaIsFull( PIXAA paa, @Cast("l_int32*") IntPointer pfull );
public static native @Cast("l_int32") int pixaaIsFull( PIXAA paa, @Cast("l_int32*") IntBuffer pfull );
public static native @Cast("l_int32") int pixaaIsFull( PIXAA paa, @Cast("l_int32*") int[] pfull );
public static native @Cast("l_ok") int pixaaInitFull( PIXAA paa, PIXA pixa );
public static native @Cast("l_ok") int pixaaReplacePixa( PIXAA paa, @Cast("l_int32") int index, PIXA pixa );
public static native @Cast("l_ok") int pixaaClear( PIXAA paa );
public static native @Cast("l_ok") int pixaaTruncate( PIXAA paa );
public static native PIXA pixaRead( @Cast("const char*") BytePointer filename );
public static native PIXA pixaRead( String filename );
public static native PIXA pixaReadStream( @Cast("FILE*") Pointer fp );
public static native PIXA pixaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIXA pixaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIXA pixaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixaWriteDebug( @Cast("const char*") BytePointer fname, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteDebug( String fname, PIXA pixa );
public static native @Cast("l_ok") int pixaWrite( @Cast("const char*") BytePointer filename, PIXA pixa );
public static native @Cast("l_ok") int pixaWrite( String filename, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteStream( @Cast("FILE*") Pointer fp, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native PIXA pixaReadBoth( @Cast("const char*") BytePointer filename );
public static native PIXA pixaReadBoth( String filename );
public static native PIXAA pixaaReadFromFiles( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native PIXAA pixaaReadFromFiles( String dirname, String substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native PIXAA pixaaRead( @Cast("const char*") BytePointer filename );
public static native PIXAA pixaaRead( String filename );
public static native PIXAA pixaaReadStream( @Cast("FILE*") Pointer fp );
public static native PIXAA pixaaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIXAA pixaaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIXAA pixaaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixaaWrite( @Cast("const char*") BytePointer filename, PIXAA paa );
public static native @Cast("l_ok") int pixaaWrite( String filename, PIXAA paa );
public static native @Cast("l_ok") int pixaaWriteStream( @Cast("FILE*") Pointer fp, PIXAA paa );
public static native @Cast("l_ok") int pixaaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIXAA paa );
public static native @Cast("l_ok") int pixaaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIXAA paa );
public static native @Cast("l_ok") int pixaaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIXAA paa );
public static native @Cast("l_ok") int pixaaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIXAA paa );
public static native PIXACC pixaccCreate( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int negflag );
public static native PIXACC pixaccCreateFromPix( PIX pix, @Cast("l_int32") int negflag );
public static native void pixaccDestroy( @Cast("PIXACC**") PointerPointer ppixacc );
public static native void pixaccDestroy( @ByPtrPtr PIXACC ppixacc );
public static native PIX pixaccFinal( PIXACC pixacc, @Cast("l_int32") int outdepth );
public static native PIX pixaccGetPix( PIXACC pixacc );
public static native @Cast("l_int32") int pixaccGetOffset( PIXACC pixacc );
public static native @Cast("l_ok") int pixaccAdd( PIXACC pixacc, PIX pix );
public static native @Cast("l_ok") int pixaccSubtract( PIXACC pixacc, PIX pix );
public static native @Cast("l_ok") int pixaccMultConst( PIXACC pixacc, @Cast("l_float32") float factor );
public static native @Cast("l_ok") int pixaccMultConstAccumulate( PIXACC pixacc, PIX pix, @Cast("l_float32") float factor );
public static native PIX pixSelectBySize( PIX pixs, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectBySize( PIX pixs, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectBySize( PIX pixs, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectBySize( PIXA pixas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectBySize( PIXA pixas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectBySize( PIXA pixas, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation, @Cast("l_int32*") int[] pchanged );
public static native NUMA pixaMakeSizeIndicator( PIXA pixa, @Cast("l_int32") int width, @Cast("l_int32") int height, @Cast("l_int32") int type, @Cast("l_int32") int relation );
public static native PIX pixSelectByPerimToAreaRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectByPerimToAreaRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectByPerimToAreaRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByPerimToAreaRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByPerimToAreaRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByPerimToAreaRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIX pixSelectByPerimSizeRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectByPerimSizeRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectByPerimSizeRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByPerimSizeRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByPerimSizeRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByPerimSizeRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIX pixSelectByAreaFraction( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectByAreaFraction( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectByAreaFraction( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByAreaFraction( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByAreaFraction( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByAreaFraction( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIX pixSelectByArea( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectByArea( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectByArea( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByArea( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByArea( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByArea( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIX pixSelectByWidthHeightRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIX pixSelectByWidthHeightRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIX pixSelectByWidthHeightRatio( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int connectivity, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByWidthHeightRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByWidthHeightRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByWidthHeightRatio( PIXA pixas, @Cast("l_float32") float thresh, @Cast("l_int32") int type, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectByNumConnComp( PIXA pixas, @Cast("l_int32") int nmin, @Cast("l_int32") int nmax, @Cast("l_int32") int connectivity, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectByNumConnComp( PIXA pixas, @Cast("l_int32") int nmin, @Cast("l_int32") int nmax, @Cast("l_int32") int connectivity, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectByNumConnComp( PIXA pixas, @Cast("l_int32") int nmin, @Cast("l_int32") int nmax, @Cast("l_int32") int connectivity, @Cast("l_int32*") int[] pchanged );
public static native PIXA pixaSelectWithIndicator( PIXA pixas, NUMA na, @Cast("l_int32*") IntPointer pchanged );
public static native PIXA pixaSelectWithIndicator( PIXA pixas, NUMA na, @Cast("l_int32*") IntBuffer pchanged );
public static native PIXA pixaSelectWithIndicator( PIXA pixas, NUMA na, @Cast("l_int32*") int[] pchanged );
public static native @Cast("l_ok") int pixRemoveWithIndicator( PIX pixs, PIXA pixa, NUMA na );
public static native @Cast("l_ok") int pixAddWithIndicator( PIX pixs, PIXA pixa, NUMA na );
public static native PIXA pixaSelectWithString( PIXA pixas, @Cast("const char*") BytePointer str, @Cast("l_int32*") IntPointer perror );
public static native PIXA pixaSelectWithString( PIXA pixas, String str, @Cast("l_int32*") IntBuffer perror );
public static native PIXA pixaSelectWithString( PIXA pixas, @Cast("const char*") BytePointer str, @Cast("l_int32*") int[] perror );
public static native PIXA pixaSelectWithString( PIXA pixas, String str, @Cast("l_int32*") IntPointer perror );
public static native PIXA pixaSelectWithString( PIXA pixas, @Cast("const char*") BytePointer str, @Cast("l_int32*") IntBuffer perror );
public static native PIXA pixaSelectWithString( PIXA pixas, String str, @Cast("l_int32*") int[] perror );
public static native PIX pixaRenderComponent( PIX pixs, PIXA pixa, @Cast("l_int32") int index );
public static native PIXA pixaSort( PIXA pixas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32") int copyflag );
public static native PIXA pixaSort( PIXA pixas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex, @Cast("l_int32") int copyflag );
public static native PIXA pixaBinSort( PIXA pixas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32") int copyflag );
public static native PIXA pixaBinSort( PIXA pixas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex, @Cast("l_int32") int copyflag );
public static native PIXA pixaSortByIndex( PIXA pixas, NUMA naindex, @Cast("l_int32") int copyflag );
public static native PIXAA pixaSort2dByIndex( PIXA pixas, NUMAA naa, @Cast("l_int32") int copyflag );
public static native PIXA pixaSelectRange( PIXA pixas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int copyflag );
public static native PIXAA pixaaSelectRange( PIXAA paas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int copyflag );
public static native PIXAA pixaaScaleToSize( PIXAA paas, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIXAA pixaaScaleToSizeVar( PIXAA paas, NUMA nawd, NUMA nahd );
public static native PIXA pixaScaleToSize( PIXA pixas, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIXA pixaScaleToSizeRel( PIXA pixas, @Cast("l_int32") int delw, @Cast("l_int32") int delh );
public static native PIXA pixaScale( PIXA pixas, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIXA pixaScaleBySampling( PIXA pixas, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIXA pixaRotate( PIXA pixas, @Cast("l_float32") float angle, @Cast("l_int32") int type, @Cast("l_int32") int incolor, @Cast("l_int32") int width, @Cast("l_int32") int height );
public static native PIXA pixaRotateOrth( PIXA pixas, @Cast("l_int32") int rotation );
public static native PIXA pixaTranslate( PIXA pixas, @Cast("l_int32") int hshift, @Cast("l_int32") int vshift, @Cast("l_int32") int incolor );
public static native PIXA pixaAddBorderGeneral( PIXA pixad, PIXA pixas, @Cast("l_int32") int left, @Cast("l_int32") int right, @Cast("l_int32") int top, @Cast("l_int32") int bot, @Cast("l_uint32") int val );
public static native PIXA pixaaFlattenToPixa( PIXAA paa, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32") int copyflag );
public static native PIXA pixaaFlattenToPixa( PIXAA paa, @ByPtrPtr NUMA pnaindex, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaaSizeRange( PIXAA paa, @Cast("l_int32*") IntPointer pminw, @Cast("l_int32*") IntPointer pminh, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int pixaaSizeRange( PIXAA paa, @Cast("l_int32*") IntBuffer pminw, @Cast("l_int32*") IntBuffer pminh, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int pixaaSizeRange( PIXAA paa, @Cast("l_int32*") int[] pminw, @Cast("l_int32*") int[] pminh, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native @Cast("l_ok") int pixaSizeRange( PIXA pixa, @Cast("l_int32*") IntPointer pminw, @Cast("l_int32*") IntPointer pminh, @Cast("l_int32*") IntPointer pmaxw, @Cast("l_int32*") IntPointer pmaxh );
public static native @Cast("l_ok") int pixaSizeRange( PIXA pixa, @Cast("l_int32*") IntBuffer pminw, @Cast("l_int32*") IntBuffer pminh, @Cast("l_int32*") IntBuffer pmaxw, @Cast("l_int32*") IntBuffer pmaxh );
public static native @Cast("l_ok") int pixaSizeRange( PIXA pixa, @Cast("l_int32*") int[] pminw, @Cast("l_int32*") int[] pminh, @Cast("l_int32*") int[] pmaxw, @Cast("l_int32*") int[] pmaxh );
public static native PIXA pixaClipToPix( PIXA pixas, PIX pixs );
public static native @Cast("l_ok") int pixaClipToForeground( PIXA pixas, @Cast("PIXA**") PointerPointer ppixad, @Cast("BOXA**") PointerPointer pboxa );
public static native @Cast("l_ok") int pixaClipToForeground( PIXA pixas, @ByPtrPtr PIXA ppixad, @ByPtrPtr BOXA pboxa );
public static native @Cast("l_ok") int pixaGetRenderingDepth( PIXA pixa, @Cast("l_int32*") IntPointer pdepth );
public static native @Cast("l_ok") int pixaGetRenderingDepth( PIXA pixa, @Cast("l_int32*") IntBuffer pdepth );
public static native @Cast("l_ok") int pixaGetRenderingDepth( PIXA pixa, @Cast("l_int32*") int[] pdepth );
public static native @Cast("l_ok") int pixaHasColor( PIXA pixa, @Cast("l_int32*") IntPointer phascolor );
public static native @Cast("l_ok") int pixaHasColor( PIXA pixa, @Cast("l_int32*") IntBuffer phascolor );
public static native @Cast("l_ok") int pixaHasColor( PIXA pixa, @Cast("l_int32*") int[] phascolor );
public static native @Cast("l_ok") int pixaAnyColormaps( PIXA pixa, @Cast("l_int32*") IntPointer phascmap );
public static native @Cast("l_ok") int pixaAnyColormaps( PIXA pixa, @Cast("l_int32*") IntBuffer phascmap );
public static native @Cast("l_ok") int pixaAnyColormaps( PIXA pixa, @Cast("l_int32*") int[] phascmap );
public static native @Cast("l_ok") int pixaGetDepthInfo( PIXA pixa, @Cast("l_int32*") IntPointer pmaxdepth, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixaGetDepthInfo( PIXA pixa, @Cast("l_int32*") IntBuffer pmaxdepth, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int pixaGetDepthInfo( PIXA pixa, @Cast("l_int32*") int[] pmaxdepth, @Cast("l_int32*") int[] psame );
public static native PIXA pixaConvertToSameDepth( PIXA pixas );
public static native PIXA pixaConvertToGivenDepth( PIXA pixas, @Cast("l_int32") int depth );
public static native @Cast("l_ok") int pixaEqual( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int maxdist, @Cast("NUMA**") PointerPointer pnaindex, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixaEqual( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int pixaEqual( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int pixaEqual( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int maxdist, @ByPtrPtr NUMA pnaindex, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int pixaSetFullSizeBoxa( PIXA pixa );
public static native PIX pixaDisplay( PIXA pixa, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixaDisplayRandomCmap( PIXA pixa, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixaDisplayLinearly( PIXA pixas, @Cast("l_int32") int direction, @Cast("l_float32") float scalefactor, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("BOXA**") PointerPointer pboxa );
public static native PIX pixaDisplayLinearly( PIXA pixas, @Cast("l_int32") int direction, @Cast("l_float32") float scalefactor, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @ByPtrPtr BOXA pboxa );
public static native PIX pixaDisplayOnLattice( PIXA pixa, @Cast("l_int32") int cellw, @Cast("l_int32") int cellh, @Cast("l_int32*") IntPointer pncols, @Cast("BOXA**") PointerPointer pboxa );
public static native PIX pixaDisplayOnLattice( PIXA pixa, @Cast("l_int32") int cellw, @Cast("l_int32") int cellh, @Cast("l_int32*") IntPointer pncols, @ByPtrPtr BOXA pboxa );
public static native PIX pixaDisplayOnLattice( PIXA pixa, @Cast("l_int32") int cellw, @Cast("l_int32") int cellh, @Cast("l_int32*") IntBuffer pncols, @ByPtrPtr BOXA pboxa );
public static native PIX pixaDisplayOnLattice( PIXA pixa, @Cast("l_int32") int cellw, @Cast("l_int32") int cellh, @Cast("l_int32*") int[] pncols, @ByPtrPtr BOXA pboxa );
public static native PIX pixaDisplayUnsplit( PIXA pixa, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int borderwidth, @Cast("l_uint32") int bordercolor );
public static native PIX pixaDisplayTiled( PIXA pixa, @Cast("l_int32") int maxwidth, @Cast("l_int32") int background, @Cast("l_int32") int spacing );
public static native PIX pixaDisplayTiledInRows( PIXA pixa, @Cast("l_int32") int outdepth, @Cast("l_int32") int maxwidth, @Cast("l_float32") float scalefactor, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native PIX pixaDisplayTiledInColumns( PIXA pixas, @Cast("l_int32") int nx, @Cast("l_float32") float scalefactor, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native PIX pixaDisplayTiledAndScaled( PIXA pixa, @Cast("l_int32") int outdepth, @Cast("l_int32") int tilewidth, @Cast("l_int32") int ncols, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native PIX pixaDisplayTiledWithText( PIXA pixa, @Cast("l_int32") int maxwidth, @Cast("l_float32") float scalefactor, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, @Cast("l_uint32") int textcolor );
public static native PIX pixaDisplayTiledByIndex( PIXA pixa, NUMA na, @Cast("l_int32") int width, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, @Cast("l_uint32") int textcolor );
public static native PIX pixaDisplayPairTiledInColumns( PIXA pixas1, PIXA pixas2, @Cast("l_int32") int nx, @Cast("l_float32") float scalefactor, @Cast("l_int32") int spacing1, @Cast("l_int32") int spacing2, @Cast("l_int32") int border1, @Cast("l_int32") int border2, @Cast("l_int32") int fontsize, @Cast("l_int32") int startindex, SARRAY sa );
public static native PIX pixaaDisplay( PIXAA paa, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixaaDisplayByPixa( PIXAA paa, @Cast("l_int32") int maxnx, @Cast("l_float32") float scalefactor, @Cast("l_int32") int hspacing, @Cast("l_int32") int vspacing, @Cast("l_int32") int border );
public static native PIXA pixaaDisplayTiledAndScaled( PIXAA paa, @Cast("l_int32") int outdepth, @Cast("l_int32") int tilewidth, @Cast("l_int32") int ncols, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native PIXA pixaConvertTo1( PIXA pixas, @Cast("l_int32") int thresh );
public static native PIXA pixaConvertTo8( PIXA pixas, @Cast("l_int32") int cmapflag );
public static native PIXA pixaConvertTo8Colormap( PIXA pixas, @Cast("l_int32") int dither );
public static native PIXA pixaConvertTo32( PIXA pixas );
public static native PIXA pixaConstrainedSelect( PIXA pixas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int nmax, @Cast("l_int32") int use_pairs, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixaSelectToPdf( PIXA pixas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint32") int color, @Cast("l_int32") int fontsize, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixaSelectToPdf( PIXA pixas, @Cast("l_int32") int first, @Cast("l_int32") int last, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("l_uint32") int color, @Cast("l_int32") int fontsize, String fileout );
public static native PIXA pixaMakeFromTiledPixa( PIXA pixas, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int nsamp );
public static native PIXA pixaMakeFromTiledPix( PIX pixs, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int start, @Cast("l_int32") int num, BOXA boxa );
public static native @Cast("l_ok") int pixGetTileCount( PIX pix, @Cast("l_int32*") IntPointer pn );
public static native @Cast("l_ok") int pixGetTileCount( PIX pix, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("l_ok") int pixGetTileCount( PIX pix, @Cast("l_int32*") int[] pn );
public static native PIXA pixaDisplayMultiTiled( PIXA pixas, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int maxw, @Cast("l_int32") int maxh, @Cast("l_float32") float scalefactor, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native @Cast("l_ok") int pixaSplitIntoFiles( PIXA pixas, @Cast("l_int32") int nsplit, @Cast("l_float32") float scale, @Cast("l_int32") int outwidth, @Cast("l_int32") int write_pixa, @Cast("l_int32") int write_pix, @Cast("l_int32") int write_pdf );
public static native @Cast("l_ok") int convertToNUpFiles( @Cast("const char*") BytePointer dir, @Cast("const char*") BytePointer substr, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, @Cast("const char*") BytePointer outdir );
public static native @Cast("l_ok") int convertToNUpFiles( String dir, String substr, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, String outdir );
public static native PIXA convertToNUpPixa( @Cast("const char*") BytePointer dir, @Cast("const char*") BytePointer substr, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize );
public static native PIXA convertToNUpPixa( String dir, String substr, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize );
public static native PIXA pixaConvertToNUpPixa( PIXA pixas, SARRAY sa, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize );
public static native @Cast("l_ok") int pixaCompareInPdf( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixaCompareInPdf( PIXA pixa1, PIXA pixa2, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int tw, @Cast("l_int32") int spacing, @Cast("l_int32") int border, @Cast("l_int32") int fontsize, String fileout );
public static native @Cast("l_ok") int pmsCreate( @Cast("size_t") long minsize, @Cast("size_t") long smallest, NUMA numalloc, @Cast("const char*") BytePointer logfile );
public static native @Cast("l_ok") int pmsCreate( @Cast("size_t") long minsize, @Cast("size_t") long smallest, NUMA numalloc, String logfile );
public static native void pmsDestroy( );
public static native Pointer pmsCustomAlloc( @Cast("size_t") long nbytes );
public static native void pmsCustomDealloc( Pointer data );
public static native Pointer pmsGetAlloc( @Cast("size_t") long nbytes );
public static native @Cast("l_ok") int pmsGetLevelForAlloc( @Cast("size_t") long nbytes, @Cast("l_int32*") IntPointer plevel );
public static native @Cast("l_ok") int pmsGetLevelForAlloc( @Cast("size_t") long nbytes, @Cast("l_int32*") IntBuffer plevel );
public static native @Cast("l_ok") int pmsGetLevelForAlloc( @Cast("size_t") long nbytes, @Cast("l_int32*") int[] plevel );
public static native @Cast("l_ok") int pmsGetLevelForDealloc( Pointer data, @Cast("l_int32*") IntPointer plevel );
public static native @Cast("l_ok") int pmsGetLevelForDealloc( Pointer data, @Cast("l_int32*") IntBuffer plevel );
public static native @Cast("l_ok") int pmsGetLevelForDealloc( Pointer data, @Cast("l_int32*") int[] plevel );
public static native void pmsLogInfo( );
public static native @Cast("l_ok") int pixAddConstantGray( PIX pixs, @Cast("l_int32") int val );
public static native @Cast("l_ok") int pixMultConstantGray( PIX pixs, @Cast("l_float32") float val );
public static native PIX pixAddGray( PIX pixd, PIX pixs1, PIX pixs2 );
public static native PIX pixSubtractGray( PIX pixd, PIX pixs1, PIX pixs2 );
public static native PIX pixMultiplyGray( PIX pixs, PIX pixg, @Cast("l_float32") float norm );
public static native PIX pixThresholdToValue( PIX pixd, PIX pixs, @Cast("l_int32") int threshval, @Cast("l_int32") int setval );
public static native PIX pixInitAccumulate( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_uint32") int offset );
public static native PIX pixFinalAccumulate( PIX pixs, @Cast("l_uint32") int offset, @Cast("l_int32") int depth );
public static native PIX pixFinalAccumulateThreshold( PIX pixs, @Cast("l_uint32") int offset, @Cast("l_uint32") int threshold );
public static native @Cast("l_ok") int pixAccumulate( PIX pixd, PIX pixs, @Cast("l_int32") int op );
public static native @Cast("l_ok") int pixMultConstAccumulate( PIX pixs, @Cast("l_float32") float factor, @Cast("l_uint32") int offset );
public static native PIX pixAbsDifference( PIX pixs1, PIX pixs2 );
public static native PIX pixAddRGB( PIX pixs1, PIX pixs2 );
public static native PIX pixMinOrMax( PIX pixd, PIX pixs1, PIX pixs2, @Cast("l_int32") int type );
public static native PIX pixMaxDynamicRange( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixMaxDynamicRangeRGB( PIX pixs, @Cast("l_int32") int type );
public static native @Cast("l_uint32") int linearScaleRGBVal( @Cast("l_uint32") int sval, @Cast("l_float32") float factor );
public static native @Cast("l_uint32") int logScaleRGBVal( @Cast("l_uint32") int sval, @Cast("l_float32*") FloatPointer tab, @Cast("l_float32") float factor );
public static native @Cast("l_uint32") int logScaleRGBVal( @Cast("l_uint32") int sval, @Cast("l_float32*") FloatBuffer tab, @Cast("l_float32") float factor );
public static native @Cast("l_uint32") int logScaleRGBVal( @Cast("l_uint32") int sval, @Cast("l_float32*") float[] tab, @Cast("l_float32") float factor );
public static native @Cast("l_float32*") FloatPointer makeLogBase2Tab( );
public static native @Cast("l_float32") float getLogBase2( @Cast("l_int32") int val, @Cast("l_float32*") FloatPointer logtab );
public static native @Cast("l_float32") float getLogBase2( @Cast("l_int32") int val, @Cast("l_float32*") FloatBuffer logtab );
public static native @Cast("l_float32") float getLogBase2( @Cast("l_int32") int val, @Cast("l_float32*") float[] logtab );
public static native PIXC pixcompCreateFromPix( PIX pix, @Cast("l_int32") int comptype );
public static native PIXC pixcompCreateFromString( @Cast("l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32") int copyflag );
public static native PIXC pixcompCreateFromString( @Cast("l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32") int copyflag );
public static native PIXC pixcompCreateFromString( @Cast("l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32") int copyflag );
public static native PIXC pixcompCreateFromFile( @Cast("const char*") BytePointer filename, @Cast("l_int32") int comptype );
public static native PIXC pixcompCreateFromFile( String filename, @Cast("l_int32") int comptype );
public static native void pixcompDestroy( @Cast("PIXC**") PointerPointer ppixc );
public static native void pixcompDestroy( @ByPtrPtr PIXC ppixc );
public static native PIXC pixcompCopy( PIXC pixcs );
public static native @Cast("l_ok") int pixcompGetDimensions( PIXC pixc, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd );
public static native @Cast("l_ok") int pixcompGetDimensions( PIXC pixc, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd );
public static native @Cast("l_ok") int pixcompGetDimensions( PIXC pixc, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd );
public static native @Cast("l_ok") int pixcompGetParameters( PIXC pixc, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres, @Cast("l_int32*") IntPointer pcomptype, @Cast("l_int32*") IntPointer pcmapflag );
public static native @Cast("l_ok") int pixcompGetParameters( PIXC pixc, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres, @Cast("l_int32*") IntBuffer pcomptype, @Cast("l_int32*") IntBuffer pcmapflag );
public static native @Cast("l_ok") int pixcompGetParameters( PIXC pixc, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres, @Cast("l_int32*") int[] pcomptype, @Cast("l_int32*") int[] pcmapflag );
public static native @Cast("l_ok") int pixcompDetermineFormat( @Cast("l_int32") int comptype, @Cast("l_int32") int d, @Cast("l_int32") int cmapflag, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int pixcompDetermineFormat( @Cast("l_int32") int comptype, @Cast("l_int32") int d, @Cast("l_int32") int cmapflag, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int pixcompDetermineFormat( @Cast("l_int32") int comptype, @Cast("l_int32") int d, @Cast("l_int32") int cmapflag, @Cast("l_int32*") int[] pformat );
public static native PIX pixCreateFromPixcomp( PIXC pixc );
public static native PIXAC pixacompCreate( @Cast("l_int32") int n );
public static native PIXAC pixacompCreateWithInit( @Cast("l_int32") int n, @Cast("l_int32") int offset, PIX pix, @Cast("l_int32") int comptype );
public static native PIXAC pixacompCreateFromPixa( PIXA pixa, @Cast("l_int32") int comptype, @Cast("l_int32") int accesstype );
public static native PIXAC pixacompCreateFromFiles( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int comptype );
public static native PIXAC pixacompCreateFromFiles( String dirname, String substr, @Cast("l_int32") int comptype );
public static native PIXAC pixacompCreateFromSA( SARRAY sa, @Cast("l_int32") int comptype );
public static native void pixacompDestroy( @Cast("PIXAC**") PointerPointer ppixac );
public static native void pixacompDestroy( @ByPtrPtr PIXAC ppixac );
public static native @Cast("l_ok") int pixacompAddPix( PIXAC pixac, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixacompAddPixcomp( PIXAC pixac, PIXC pixc, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int pixacompReplacePix( PIXAC pixac, @Cast("l_int32") int index, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixacompReplacePixcomp( PIXAC pixac, @Cast("l_int32") int index, PIXC pixc );
public static native @Cast("l_ok") int pixacompAddBox( PIXAC pixac, BOX box, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int pixacompGetCount( PIXAC pixac );
public static native PIXC pixacompGetPixcomp( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32") int copyflag );
public static native PIX pixacompGetPix( PIXAC pixac, @Cast("l_int32") int index );
public static native @Cast("l_ok") int pixacompGetPixDimensions( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd );
public static native @Cast("l_ok") int pixacompGetPixDimensions( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd );
public static native @Cast("l_ok") int pixacompGetPixDimensions( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd );
public static native BOXA pixacompGetBoxa( PIXAC pixac, @Cast("l_int32") int accesstype );
public static native @Cast("l_int32") int pixacompGetBoxaCount( PIXAC pixac );
public static native BOX pixacompGetBox( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32") int accesstype );
public static native @Cast("l_ok") int pixacompGetBoxGeometry( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int pixacompGetBoxGeometry( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int pixacompGetBoxGeometry( PIXAC pixac, @Cast("l_int32") int index, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native @Cast("l_int32") int pixacompGetOffset( PIXAC pixac );
public static native @Cast("l_ok") int pixacompSetOffset( PIXAC pixac, @Cast("l_int32") int offset );
public static native PIXA pixaCreateFromPixacomp( PIXAC pixac, @Cast("l_int32") int accesstype );
public static native @Cast("l_ok") int pixacompJoin( PIXAC pixacd, PIXAC pixacs, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native PIXAC pixacompInterleave( PIXAC pixac1, PIXAC pixac2 );
public static native PIXAC pixacompRead( @Cast("const char*") BytePointer filename );
public static native PIXAC pixacompRead( String filename );
public static native PIXAC pixacompReadStream( @Cast("FILE*") Pointer fp );
public static native PIXAC pixacompReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIXAC pixacompReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIXAC pixacompReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixacompWrite( @Cast("const char*") BytePointer filename, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWrite( String filename, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWriteStream( @Cast("FILE*") Pointer fp, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIXAC pixac );
public static native @Cast("l_ok") int pixacompWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIXAC pixac );
public static native @Cast("l_ok") int pixacompConvertToPdf( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixacompConvertToPdf( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, String fileout );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompConvertToPdfData( PIXAC pixac, @Cast("l_int32") int res, @Cast("l_float32") float scalefactor, @Cast("l_int32") int type, @Cast("l_int32") int quality, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, @Cast("const char*") BytePointer title, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, String title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, String title, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, @Cast("const char*") BytePointer title, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompFastConvertToPdfData( PIXAC pixac, String title, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixacompWriteStreamInfo( @Cast("FILE*") Pointer fp, PIXAC pixac, @Cast("const char*") BytePointer text );
public static native @Cast("l_ok") int pixacompWriteStreamInfo( @Cast("FILE*") Pointer fp, PIXAC pixac, String text );
public static native @Cast("l_ok") int pixcompWriteStreamInfo( @Cast("FILE*") Pointer fp, PIXC pixc, @Cast("const char*") BytePointer text );
public static native @Cast("l_ok") int pixcompWriteStreamInfo( @Cast("FILE*") Pointer fp, PIXC pixc, String text );
public static native PIX pixacompDisplayTiledAndScaled( PIXAC pixac, @Cast("l_int32") int outdepth, @Cast("l_int32") int tilewidth, @Cast("l_int32") int ncols, @Cast("l_int32") int background, @Cast("l_int32") int spacing, @Cast("l_int32") int border );
public static native @Cast("l_ok") int pixacompWriteFiles( PIXAC pixac, @Cast("const char*") BytePointer subdir );
public static native @Cast("l_ok") int pixacompWriteFiles( PIXAC pixac, String subdir );
public static native @Cast("l_ok") int pixcompWriteFile( @Cast("const char*") BytePointer rootname, PIXC pixc );
public static native @Cast("l_ok") int pixcompWriteFile( String rootname, PIXC pixc );
public static native PIX pixThreshold8( PIX pixs, @Cast("l_int32") int d, @Cast("l_int32") int nlevels, @Cast("l_int32") int cmapflag );
public static native PIX pixRemoveColormapGeneral( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int ifnocmap );
public static native PIX pixRemoveColormap( PIX pixs, @Cast("l_int32") int type );
public static native @Cast("l_ok") int pixAddGrayColormap8( PIX pixs );
public static native PIX pixAddMinimalGrayColormap8( PIX pixs );
public static native PIX pixConvertRGBToLuminance( PIX pixs );
public static native PIX pixConvertRGBToGrayGeneral( PIX pixs, @Cast("l_int32") int type, @Cast("l_float32") float rwt, @Cast("l_float32") float gwt, @Cast("l_float32") float bwt );
public static native PIX pixConvertRGBToGray( PIX pixs, @Cast("l_float32") float rwt, @Cast("l_float32") float gwt, @Cast("l_float32") float bwt );
public static native PIX pixConvertRGBToGrayFast( PIX pixs );
public static native PIX pixConvertRGBToGrayMinMax( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixConvertRGBToGraySatBoost( PIX pixs, @Cast("l_int32") int refval );
public static native PIX pixConvertRGBToGrayArb( PIX pixs, @Cast("l_float32") float rc, @Cast("l_float32") float gc, @Cast("l_float32") float bc );
public static native PIX pixConvertRGBToBinaryArb( PIX pixs, @Cast("l_float32") float rc, @Cast("l_float32") float gc, @Cast("l_float32") float bc, @Cast("l_int32") int thresh, @Cast("l_int32") int relation );
public static native PIX pixConvertGrayToColormap( PIX pixs );
public static native PIX pixConvertGrayToColormap8( PIX pixs, @Cast("l_int32") int mindepth );
public static native PIX pixColorizeGray( PIX pixs, @Cast("l_uint32") int color, @Cast("l_int32") int cmapflag );
public static native PIX pixConvertRGBToColormap( PIX pixs, @Cast("l_int32") int ditherflag );
public static native PIX pixConvertCmapTo1( PIX pixs );
public static native @Cast("l_ok") int pixQuantizeIfFewColors( PIX pixs, @Cast("l_int32") int maxcolors, @Cast("l_int32") int mingraycolors, @Cast("l_int32") int octlevel, @Cast("PIX**") PointerPointer ppixd );
public static native @Cast("l_ok") int pixQuantizeIfFewColors( PIX pixs, @Cast("l_int32") int maxcolors, @Cast("l_int32") int mingraycolors, @Cast("l_int32") int octlevel, @ByPtrPtr PIX ppixd );
public static native PIX pixConvert16To8( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixConvertGrayToFalseColor( PIX pixs, @Cast("l_float32") float gamma );
public static native PIX pixUnpackBinary( PIX pixs, @Cast("l_int32") int depth, @Cast("l_int32") int invert );
public static native PIX pixConvert1To16( PIX pixd, PIX pixs, @Cast("l_uint16") short val0, @Cast("l_uint16") short val1 );
public static native PIX pixConvert1To32( PIX pixd, PIX pixs, @Cast("l_uint32") int val0, @Cast("l_uint32") int val1 );
public static native PIX pixConvert1To2Cmap( PIX pixs );
public static native PIX pixConvert1To2( PIX pixd, PIX pixs, @Cast("l_int32") int val0, @Cast("l_int32") int val1 );
public static native PIX pixConvert1To4Cmap( PIX pixs );
public static native PIX pixConvert1To4( PIX pixd, PIX pixs, @Cast("l_int32") int val0, @Cast("l_int32") int val1 );
public static native PIX pixConvert1To8Cmap( PIX pixs );
public static native PIX pixConvert1To8( PIX pixd, PIX pixs, @Cast("l_uint8") byte val0, @Cast("l_uint8") byte val1 );
public static native PIX pixConvert2To8( PIX pixs, @Cast("l_uint8") byte val0, @Cast("l_uint8") byte val1, @Cast("l_uint8") byte val2, @Cast("l_uint8") byte val3, @Cast("l_int32") int cmapflag );
public static native PIX pixConvert4To8( PIX pixs, @Cast("l_int32") int cmapflag );
public static native PIX pixConvert8To16( PIX pixs, @Cast("l_int32") int leftshift );
public static native PIX pixConvertTo2( PIX pixs );
public static native PIX pixConvert8To2( PIX pix );
public static native PIX pixConvertTo4( PIX pixs );
public static native PIX pixConvert8To4( PIX pix );
public static native PIX pixConvertTo1Adaptive( PIX pixs );
public static native PIX pixConvertTo1( PIX pixs, @Cast("l_int32") int threshold );
public static native PIX pixConvertTo1BySampling( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int threshold );
public static native PIX pixConvertTo8( PIX pixs, @Cast("l_int32") int cmapflag );
public static native PIX pixConvertTo8BySampling( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int cmapflag );
public static native PIX pixConvertTo8Colormap( PIX pixs, @Cast("l_int32") int dither );
public static native PIX pixConvertTo16( PIX pixs );
public static native PIX pixConvertTo32( PIX pixs );
public static native PIX pixConvertTo32BySampling( PIX pixs, @Cast("l_int32") int factor );
public static native PIX pixConvert8To32( PIX pixs );
public static native PIX pixConvertTo8Or32( PIX pixs, @Cast("l_int32") int copyflag, @Cast("l_int32") int warnflag );
public static native PIX pixConvert24To32( PIX pixs );
public static native PIX pixConvert32To24( PIX pixs );
public static native PIX pixConvert32To16( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixConvert32To8( PIX pixs, @Cast("l_int32") int type16, @Cast("l_int32") int type8 );
public static native PIX pixRemoveAlpha( PIX pixs );
public static native PIX pixAddAlphaTo1bpp( PIX pixd, PIX pixs );
public static native PIX pixConvertLossless( PIX pixs, @Cast("l_int32") int d );
public static native PIX pixConvertForPSWrap( PIX pixs );
public static native PIX pixConvertToSubpixelRGB( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_int32") int order );
public static native PIX pixConvertGrayToSubpixelRGB( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_int32") int order );
public static native PIX pixConvertColorToSubpixelRGB( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_int32") int order );
public static native void l_setNeutralBoostVal( @Cast("l_int32") int val );
public static native PIX pixConnCompTransform( PIX pixs, @Cast("l_int32") int connect, @Cast("l_int32") int depth );
public static native PIX pixConnCompAreaTransform( PIX pixs, @Cast("l_int32") int connect );
public static native @Cast("l_ok") int pixConnCompIncrInit( PIX pixs, @Cast("l_int32") int conn, @Cast("PIX**") PointerPointer ppixd, @Cast("PTAA**") PointerPointer pptaa, @Cast("l_int32*") IntPointer pncc );
public static native @Cast("l_ok") int pixConnCompIncrInit( PIX pixs, @Cast("l_int32") int conn, @ByPtrPtr PIX ppixd, @ByPtrPtr PTAA pptaa, @Cast("l_int32*") IntPointer pncc );
public static native @Cast("l_ok") int pixConnCompIncrInit( PIX pixs, @Cast("l_int32") int conn, @ByPtrPtr PIX ppixd, @ByPtrPtr PTAA pptaa, @Cast("l_int32*") IntBuffer pncc );
public static native @Cast("l_ok") int pixConnCompIncrInit( PIX pixs, @Cast("l_int32") int conn, @ByPtrPtr PIX ppixd, @ByPtrPtr PTAA pptaa, @Cast("l_int32*") int[] pncc );
public static native @Cast("l_int32") int pixConnCompIncrAdd( PIX pixs, PTAA ptaa, @Cast("l_int32*") IntPointer pncc, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int debug );
public static native @Cast("l_int32") int pixConnCompIncrAdd( PIX pixs, PTAA ptaa, @Cast("l_int32*") IntBuffer pncc, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int debug );
public static native @Cast("l_int32") int pixConnCompIncrAdd( PIX pixs, PTAA ptaa, @Cast("l_int32*") int[] pncc, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int pixGetSortedNeighborValues( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int conn, @Cast("l_int32**") PointerPointer pneigh, @Cast("l_int32*") IntPointer pnvals );
public static native @Cast("l_ok") int pixGetSortedNeighborValues( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int conn, @Cast("l_int32**") @ByPtrPtr IntPointer pneigh, @Cast("l_int32*") IntPointer pnvals );
public static native @Cast("l_ok") int pixGetSortedNeighborValues( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int conn, @Cast("l_int32**") @ByPtrPtr IntBuffer pneigh, @Cast("l_int32*") IntBuffer pnvals );
public static native @Cast("l_ok") int pixGetSortedNeighborValues( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int conn, @Cast("l_int32**") @ByPtrPtr int[] pneigh, @Cast("l_int32*") int[] pnvals );
public static native PIX pixLocToColorTransform( PIX pixs );
public static native PIXTILING pixTilingCreate( PIX pixs, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int xoverlap, @Cast("l_int32") int yoverlap );
public static native void pixTilingDestroy( @Cast("PIXTILING**") PointerPointer ppt );
public static native void pixTilingDestroy( @ByPtrPtr PIXTILING ppt );
public static native @Cast("l_ok") int pixTilingGetCount( PIXTILING pt, @Cast("l_int32*") IntPointer pnx, @Cast("l_int32*") IntPointer pny );
public static native @Cast("l_ok") int pixTilingGetCount( PIXTILING pt, @Cast("l_int32*") IntBuffer pnx, @Cast("l_int32*") IntBuffer pny );
public static native @Cast("l_ok") int pixTilingGetCount( PIXTILING pt, @Cast("l_int32*") int[] pnx, @Cast("l_int32*") int[] pny );
public static native @Cast("l_ok") int pixTilingGetSize( PIXTILING pt, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph );
public static native @Cast("l_ok") int pixTilingGetSize( PIXTILING pt, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph );
public static native @Cast("l_ok") int pixTilingGetSize( PIXTILING pt, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph );
public static native PIX pixTilingGetTile( PIXTILING pt, @Cast("l_int32") int i, @Cast("l_int32") int j );
public static native @Cast("l_ok") int pixTilingNoStripOnPaint( PIXTILING pt );
public static native @Cast("l_ok") int pixTilingPaintTile( PIX pixd, @Cast("l_int32") int i, @Cast("l_int32") int j, PIX pixs, PIXTILING pt );
public static native PIX pixReadStreamPng( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int readHeaderPng( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int readHeaderPng( String filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int readHeaderPng( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int readHeaderPng( String filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int readHeaderPng( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int readHeaderPng( String filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int freadHeaderPng( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int freadHeaderPng( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int freadHeaderPng( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int readHeaderMemPng( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int readHeaderMemPng( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int readHeaderMemPng( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_int32") int fgetPngResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_int32") int fgetPngResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_int32") int fgetPngResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int isPngInterlaced( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pinterlaced );
public static native @Cast("l_ok") int isPngInterlaced( String filename, @Cast("l_int32*") IntBuffer pinterlaced );
public static native @Cast("l_ok") int isPngInterlaced( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pinterlaced );
public static native @Cast("l_ok") int isPngInterlaced( String filename, @Cast("l_int32*") IntPointer pinterlaced );
public static native @Cast("l_ok") int isPngInterlaced( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pinterlaced );
public static native @Cast("l_ok") int isPngInterlaced( String filename, @Cast("l_int32*") int[] pinterlaced );
public static native @Cast("l_ok") int fgetPngColormapInfo( @Cast("FILE*") Pointer fp, @Cast("PIXCMAP**") PointerPointer pcmap, @Cast("l_int32*") IntPointer ptransparency );
public static native @Cast("l_ok") int fgetPngColormapInfo( @Cast("FILE*") Pointer fp, @ByPtrPtr PIXCMAP pcmap, @Cast("l_int32*") IntPointer ptransparency );
public static native @Cast("l_ok") int fgetPngColormapInfo( @Cast("FILE*") Pointer fp, @ByPtrPtr PIXCMAP pcmap, @Cast("l_int32*") IntBuffer ptransparency );
public static native @Cast("l_ok") int fgetPngColormapInfo( @Cast("FILE*") Pointer fp, @ByPtrPtr PIXCMAP pcmap, @Cast("l_int32*") int[] ptransparency );
public static native @Cast("l_ok") int pixWritePng( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixWritePng( String filename, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixWriteStreamPng( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixSetZlibCompression( PIX pix, @Cast("l_int32") int compval );
public static native void l_pngSetReadStrip16To8( @Cast("l_int32") int flag );
public static native PIX pixReadMemPng( @Cast("const l_uint8*") BytePointer filedata, @Cast("size_t") long filesize );
public static native PIX pixReadMemPng( @Cast("const l_uint8*") ByteBuffer filedata, @Cast("size_t") long filesize );
public static native PIX pixReadMemPng( @Cast("const l_uint8*") byte[] filedata, @Cast("size_t") long filesize );
public static native @Cast("l_ok") int pixWriteMemPng( @Cast("l_uint8**") PointerPointer pfiledata, @Cast("size_t*") SizeTPointer pfilesize, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixWriteMemPng( @Cast("l_uint8**") @ByPtrPtr BytePointer pfiledata, @Cast("size_t*") SizeTPointer pfilesize, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixWriteMemPng( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pfiledata, @Cast("size_t*") SizeTPointer pfilesize, PIX pix, @Cast("l_float32") float gamma );
public static native @Cast("l_ok") int pixWriteMemPng( @Cast("l_uint8**") @ByPtrPtr byte[] pfiledata, @Cast("size_t*") SizeTPointer pfilesize, PIX pix, @Cast("l_float32") float gamma );
public static native PIX pixReadStreamPnm( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int readHeaderPnm( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd, @Cast("l_int32*") IntPointer ptype, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderPnm( String filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd, @Cast("l_int32*") IntBuffer ptype, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderPnm( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd, @Cast("l_int32*") int[] ptype, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int readHeaderPnm( String filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd, @Cast("l_int32*") IntPointer ptype, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderPnm( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd, @Cast("l_int32*") IntBuffer ptype, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderPnm( String filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd, @Cast("l_int32*") int[] ptype, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int freadHeaderPnm( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd, @Cast("l_int32*") IntPointer ptype, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int freadHeaderPnm( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd, @Cast("l_int32*") IntBuffer ptype, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int freadHeaderPnm( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd, @Cast("l_int32*") int[] ptype, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int pixWriteStreamPnm( @Cast("FILE*") Pointer fp, PIX pix );
public static native @Cast("l_ok") int pixWriteStreamAsciiPnm( @Cast("FILE*") Pointer fp, PIX pix );
public static native @Cast("l_ok") int pixWriteStreamPam( @Cast("FILE*") Pointer fp, PIX pix );
public static native PIX pixReadMemPnm( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIX pixReadMemPnm( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIX pixReadMemPnm( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int readHeaderMemPnm( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pd, @Cast("l_int32*") IntPointer ptype, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderMemPnm( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pd, @Cast("l_int32*") IntBuffer ptype, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderMemPnm( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pd, @Cast("l_int32*") int[] ptype, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int pixWriteMemPnm( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPnm( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPnm( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPnm( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPam( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPam( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPam( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemPam( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native PIX pixProjectiveSampledPta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixProjectiveSampled( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixProjectiveSampled( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixProjectiveSampled( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixProjectivePta( PIX pixs, PTA ptad, PTA ptas, @Cast("l_int32") int incolor );
public static native PIX pixProjective( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int incolor );
public static native PIX pixProjective( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int incolor );
public static native PIX pixProjective( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_int32") int incolor );
public static native PIX pixProjectivePtaColor( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint32") int colorval );
public static native PIX pixProjectiveColor( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint32") int colorval );
public static native PIX pixProjectiveColor( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint32") int colorval );
public static native PIX pixProjectiveColor( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint32") int colorval );
public static native PIX pixProjectivePtaGray( PIX pixs, PTA ptad, PTA ptas, @Cast("l_uint8") byte grayval );
public static native PIX pixProjectiveGray( PIX pixs, @Cast("l_float32*") FloatPointer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixProjectiveGray( PIX pixs, @Cast("l_float32*") FloatBuffer vc, @Cast("l_uint8") byte grayval );
public static native PIX pixProjectiveGray( PIX pixs, @Cast("l_float32*") float[] vc, @Cast("l_uint8") byte grayval );
public static native PIX pixProjectivePtaWithAlpha( PIX pixs, PTA ptad, PTA ptas, PIX pixg, @Cast("l_float32") float fract, @Cast("l_int32") int border );
public static native @Cast("l_ok") int getProjectiveXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") PointerPointer pvc );
public static native @Cast("l_ok") int getProjectiveXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatPointer pvc );
public static native @Cast("l_ok") int getProjectiveXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr FloatBuffer pvc );
public static native @Cast("l_ok") int getProjectiveXformCoeffs( PTA ptas, PTA ptad, @Cast("l_float32**") @ByPtrPtr float[] pvc );
public static native @Cast("l_ok") int projectiveXformSampledPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer pxp, @Cast("l_int32*") IntPointer pyp );
public static native @Cast("l_ok") int projectiveXformSampledPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer pxp, @Cast("l_int32*") IntBuffer pyp );
public static native @Cast("l_ok") int projectiveXformSampledPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") int[] pxp, @Cast("l_int32*") int[] pyp );
public static native @Cast("l_ok") int projectiveXformPt( @Cast("l_float32*") FloatPointer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pxp, @Cast("l_float32*") FloatPointer pyp );
public static native @Cast("l_ok") int projectiveXformPt( @Cast("l_float32*") FloatBuffer vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pxp, @Cast("l_float32*") FloatBuffer pyp );
public static native @Cast("l_ok") int projectiveXformPt( @Cast("l_float32*") float[] vc, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pxp, @Cast("l_float32*") float[] pyp );
public static native @Cast("l_ok") int convertFilesToPS( @Cast("const char*") BytePointer dirin, @Cast("const char*") BytePointer substr, @Cast("l_int32") int res, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertFilesToPS( String dirin, String substr, @Cast("l_int32") int res, String fileout );
public static native @Cast("l_ok") int sarrayConvertFilesToPS( SARRAY sa, @Cast("l_int32") int res, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int sarrayConvertFilesToPS( SARRAY sa, @Cast("l_int32") int res, String fileout );
public static native @Cast("l_ok") int convertFilesFittedToPS( @Cast("const char*") BytePointer dirin, @Cast("const char*") BytePointer substr, @Cast("l_float32") float xpts, @Cast("l_float32") float ypts, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertFilesFittedToPS( String dirin, String substr, @Cast("l_float32") float xpts, @Cast("l_float32") float ypts, String fileout );
public static native @Cast("l_ok") int sarrayConvertFilesFittedToPS( SARRAY sa, @Cast("l_float32") float xpts, @Cast("l_float32") float ypts, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int sarrayConvertFilesFittedToPS( SARRAY sa, @Cast("l_float32") float xpts, @Cast("l_float32") float ypts, String fileout );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( String filein, String fileout, @Cast("l_int32") int res, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( String filein, String fileout, @Cast("l_int32") int res, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int writeImageCompressedToPSFile( String filein, String fileout, @Cast("l_int32") int res, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int convertSegmentedPagesToPS( @Cast("const char*") BytePointer pagedir, @Cast("const char*") BytePointer pagestr, @Cast("l_int32") int page_numpre, @Cast("const char*") BytePointer maskdir, @Cast("const char*") BytePointer maskstr, @Cast("l_int32") int mask_numpre, @Cast("l_int32") int numpost, @Cast("l_int32") int maxnum, @Cast("l_float32") float textscale, @Cast("l_float32") float imagescale, @Cast("l_int32") int threshold, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertSegmentedPagesToPS( String pagedir, String pagestr, @Cast("l_int32") int page_numpre, String maskdir, String maskstr, @Cast("l_int32") int mask_numpre, @Cast("l_int32") int numpost, @Cast("l_int32") int maxnum, @Cast("l_float32") float textscale, @Cast("l_float32") float imagescale, @Cast("l_int32") int threshold, String fileout );
public static native @Cast("l_ok") int pixWriteSegmentedPageToPS( PIX pixs, PIX pixm, @Cast("l_float32") float textscale, @Cast("l_float32") float imagescale, @Cast("l_int32") int threshold, @Cast("l_int32") int pageno, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixWriteSegmentedPageToPS( PIX pixs, PIX pixm, @Cast("l_float32") float textscale, @Cast("l_float32") float imagescale, @Cast("l_int32") int threshold, @Cast("l_int32") int pageno, String fileout );
public static native @Cast("l_ok") int pixWriteMixedToPS( PIX pixb, PIX pixc, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixWriteMixedToPS( PIX pixb, PIX pixc, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, String fileout );
public static native @Cast("l_ok") int convertToPSEmbed( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int level );
public static native @Cast("l_ok") int convertToPSEmbed( String filein, String fileout, @Cast("l_int32") int level );
public static native @Cast("l_ok") int pixaWriteCompressedToPS( PIXA pixa, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32") int level );
public static native @Cast("l_ok") int pixaWriteCompressedToPS( PIXA pixa, String fileout, @Cast("l_int32") int res, @Cast("l_int32") int level );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, String fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, String fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, @Cast("const char*") BytePointer fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int pixWriteCompressedToPS( PIX pix, String fileout, @Cast("l_int32") int res, @Cast("l_int32") int level, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int pixWritePSEmbed( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int pixWritePSEmbed( String filein, String fileout );
public static native @Cast("l_ok") int pixWriteStreamPS( @Cast("FILE*") Pointer fp, PIX pix, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("char*") BytePointer pixWriteStringPS( PIX pixs, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("char*") BytePointer generateUncompressedPS( @Cast("char*") BytePointer hexdata, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int d, @Cast("l_int32") int psbpl, @Cast("l_int32") int bps, @Cast("l_float32") float xpt, @Cast("l_float32") float ypt, @Cast("l_float32") float wpt, @Cast("l_float32") float hpt, @Cast("l_int32") int boxflag );
public static native @Cast("char*") ByteBuffer generateUncompressedPS( @Cast("char*") ByteBuffer hexdata, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int d, @Cast("l_int32") int psbpl, @Cast("l_int32") int bps, @Cast("l_float32") float xpt, @Cast("l_float32") float ypt, @Cast("l_float32") float wpt, @Cast("l_float32") float hpt, @Cast("l_int32") int boxflag );
public static native @Cast("char*") byte[] generateUncompressedPS( @Cast("char*") byte[] hexdata, @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int d, @Cast("l_int32") int psbpl, @Cast("l_int32") int bps, @Cast("l_float32") float xpt, @Cast("l_float32") float ypt, @Cast("l_float32") float wpt, @Cast("l_float32") float hpt, @Cast("l_int32") int boxflag );
public static native @Cast("l_ok") int convertJpegToPSEmbed( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertJpegToPSEmbed( String filein, String fileout );
public static native @Cast("l_ok") int convertJpegToPS( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("const char*") BytePointer operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int convertJpegToPS( String filein, String fileout, String operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int convertG4ToPSEmbed( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertG4ToPSEmbed( String filein, String fileout );
public static native @Cast("l_ok") int convertG4ToPS( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("const char*") BytePointer operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int maskflag, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int convertG4ToPS( String filein, String fileout, String operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int maskflag, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int convertTiffMultipageToPS( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("l_float32") float fillfract );
public static native @Cast("l_ok") int convertTiffMultipageToPS( String filein, String fileout, @Cast("l_float32") float fillfract );
public static native @Cast("l_ok") int convertFlateToPSEmbed( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int convertFlateToPSEmbed( String filein, String fileout );
public static native @Cast("l_ok") int convertFlateToPS( @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer fileout, @Cast("const char*") BytePointer operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int convertFlateToPS( String filein, String fileout, String operation, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int res, @Cast("l_float32") float scale, @Cast("l_int32") int pageno, @Cast("l_int32") int endpage );
public static native @Cast("l_ok") int pixWriteMemPS( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int pixWriteMemPS( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int pixWriteMemPS( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int pixWriteMemPS( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, BOX box, @Cast("l_int32") int res, @Cast("l_float32") float scale );
public static native @Cast("l_int32") int getResLetterPage( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float fillfract );
public static native @Cast("l_int32") int getResA4Page( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_float32") float fillfract );
public static native void l_psWriteBoundingBox( @Cast("l_int32") int flag );
public static native PTA ptaCreate( @Cast("l_int32") int n );
public static native PTA ptaCreateFromNuma( NUMA nax, NUMA nay );
public static native void ptaDestroy( @Cast("PTA**") PointerPointer ppta );
public static native void ptaDestroy( @ByPtrPtr PTA ppta );
public static native PTA ptaCopy( PTA pta );
public static native PTA ptaCopyRange( PTA ptas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native PTA ptaClone( PTA pta );
public static native @Cast("l_ok") int ptaEmpty( PTA pta );
public static native @Cast("l_ok") int ptaAddPt( PTA pta, @Cast("l_float32") float x, @Cast("l_float32") float y );
public static native @Cast("l_ok") int ptaInsertPt( PTA pta, @Cast("l_int32") int index, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int ptaRemovePt( PTA pta, @Cast("l_int32") int index );
public static native @Cast("l_int32") int ptaGetRefcount( PTA pta );
public static native @Cast("l_int32") int ptaChangeRefcount( PTA pta, @Cast("l_int32") int delta );
public static native @Cast("l_int32") int ptaGetCount( PTA pta );
public static native @Cast("l_ok") int ptaGetPt( PTA pta, @Cast("l_int32") int index, @Cast("l_float32*") FloatPointer px, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int ptaGetPt( PTA pta, @Cast("l_int32") int index, @Cast("l_float32*") FloatBuffer px, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int ptaGetPt( PTA pta, @Cast("l_int32") int index, @Cast("l_float32*") float[] px, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int ptaGetIPt( PTA pta, @Cast("l_int32") int index, @Cast("l_int32*") IntPointer px, @Cast("l_int32*") IntPointer py );
public static native @Cast("l_ok") int ptaGetIPt( PTA pta, @Cast("l_int32") int index, @Cast("l_int32*") IntBuffer px, @Cast("l_int32*") IntBuffer py );
public static native @Cast("l_ok") int ptaGetIPt( PTA pta, @Cast("l_int32") int index, @Cast("l_int32*") int[] px, @Cast("l_int32*") int[] py );
public static native @Cast("l_ok") int ptaSetPt( PTA pta, @Cast("l_int32") int index, @Cast("l_float32") float x, @Cast("l_float32") float y );
public static native @Cast("l_ok") int ptaGetArrays( PTA pta, @Cast("NUMA**") PointerPointer pnax, @Cast("NUMA**") PointerPointer pnay );
public static native @Cast("l_ok") int ptaGetArrays( PTA pta, @ByPtrPtr NUMA pnax, @ByPtrPtr NUMA pnay );
public static native PTA ptaRead( @Cast("const char*") BytePointer filename );
public static native PTA ptaRead( String filename );
public static native PTA ptaReadStream( @Cast("FILE*") Pointer fp );
public static native PTA ptaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PTA ptaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PTA ptaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int ptaWriteDebug( @Cast("const char*") BytePointer filename, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteDebug( String filename, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWrite( @Cast("const char*") BytePointer filename, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWrite( String filename, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteStream( @Cast("FILE*") Pointer fp, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PTA pta, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PTA pta, @Cast("l_int32") int type );
public static native PTAA ptaaCreate( @Cast("l_int32") int n );
public static native void ptaaDestroy( @Cast("PTAA**") PointerPointer pptaa );
public static native void ptaaDestroy( @ByPtrPtr PTAA pptaa );
public static native @Cast("l_ok") int ptaaAddPta( PTAA ptaa, PTA pta, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int ptaaGetCount( PTAA ptaa );
public static native PTA ptaaGetPta( PTAA ptaa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native @Cast("l_ok") int ptaaGetPt( PTAA ptaa, @Cast("l_int32") int ipta, @Cast("l_int32") int jpt, @Cast("l_float32*") FloatPointer px, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int ptaaGetPt( PTAA ptaa, @Cast("l_int32") int ipta, @Cast("l_int32") int jpt, @Cast("l_float32*") FloatBuffer px, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int ptaaGetPt( PTAA ptaa, @Cast("l_int32") int ipta, @Cast("l_int32") int jpt, @Cast("l_float32*") float[] px, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int ptaaInitFull( PTAA ptaa, PTA pta );
public static native @Cast("l_ok") int ptaaReplacePta( PTAA ptaa, @Cast("l_int32") int index, PTA pta );
public static native @Cast("l_ok") int ptaaAddPt( PTAA ptaa, @Cast("l_int32") int ipta, @Cast("l_float32") float x, @Cast("l_float32") float y );
public static native @Cast("l_ok") int ptaaTruncate( PTAA ptaa );
public static native PTAA ptaaRead( @Cast("const char*") BytePointer filename );
public static native PTAA ptaaRead( String filename );
public static native PTAA ptaaReadStream( @Cast("FILE*") Pointer fp );
public static native PTAA ptaaReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PTAA ptaaReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PTAA ptaaReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int ptaaWriteDebug( @Cast("const char*") BytePointer filename, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteDebug( String filename, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWrite( @Cast("const char*") BytePointer filename, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWrite( String filename, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteStream( @Cast("FILE*") Pointer fp, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PTAA ptaa, @Cast("l_int32") int type );
public static native @Cast("l_ok") int ptaaWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PTAA ptaa, @Cast("l_int32") int type );
public static native PTA ptaSubsample( PTA ptas, @Cast("l_int32") int subfactor );
public static native @Cast("l_ok") int ptaJoin( PTA ptad, PTA ptas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native @Cast("l_ok") int ptaaJoin( PTAA ptaad, PTAA ptaas, @Cast("l_int32") int istart, @Cast("l_int32") int iend );
public static native PTA ptaReverse( PTA ptas, @Cast("l_int32") int type );
public static native PTA ptaTranspose( PTA ptas );
public static native PTA ptaCyclicPerm( PTA ptas, @Cast("l_int32") int xs, @Cast("l_int32") int ys );
public static native PTA ptaSelectRange( PTA ptas, @Cast("l_int32") int first, @Cast("l_int32") int last );
public static native BOX ptaGetBoundingRegion( PTA pta );
public static native @Cast("l_ok") int ptaGetRange( PTA pta, @Cast("l_float32*") FloatPointer pminx, @Cast("l_float32*") FloatPointer pmaxx, @Cast("l_float32*") FloatPointer pminy, @Cast("l_float32*") FloatPointer pmaxy );
public static native @Cast("l_ok") int ptaGetRange( PTA pta, @Cast("l_float32*") FloatBuffer pminx, @Cast("l_float32*") FloatBuffer pmaxx, @Cast("l_float32*") FloatBuffer pminy, @Cast("l_float32*") FloatBuffer pmaxy );
public static native @Cast("l_ok") int ptaGetRange( PTA pta, @Cast("l_float32*") float[] pminx, @Cast("l_float32*") float[] pmaxx, @Cast("l_float32*") float[] pminy, @Cast("l_float32*") float[] pmaxy );
public static native PTA ptaGetInsideBox( PTA ptas, BOX box );
public static native PTA pixFindCornerPixels( PIX pixs );
public static native @Cast("l_int32") int ptaContainsPt( PTA pta, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_int32") int ptaTestIntersection( PTA pta1, PTA pta2 );
public static native PTA ptaTransform( PTA ptas, @Cast("l_int32") int shiftx, @Cast("l_int32") int shifty, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native @Cast("l_int32") int ptaPtInsidePolygon( PTA pta, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") IntPointer pinside );
public static native @Cast("l_int32") int ptaPtInsidePolygon( PTA pta, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") IntBuffer pinside );
public static native @Cast("l_int32") int ptaPtInsidePolygon( PTA pta, @Cast("l_float32") float x, @Cast("l_float32") float y, @Cast("l_int32*") int[] pinside );
public static native @Cast("l_float32") float l_angleBetweenVectors( @Cast("l_float32") float x1, @Cast("l_float32") float y1, @Cast("l_float32") float x2, @Cast("l_float32") float y2 );
public static native @Cast("l_int32") int ptaPolygonIsConvex( PTA pta, @Cast("l_int32*") IntPointer pisconvex );
public static native @Cast("l_int32") int ptaPolygonIsConvex( PTA pta, @Cast("l_int32*") IntBuffer pisconvex );
public static native @Cast("l_int32") int ptaPolygonIsConvex( PTA pta, @Cast("l_int32*") int[] pisconvex );
public static native @Cast("l_ok") int ptaGetMinMax( PTA pta, @Cast("l_float32*") FloatPointer pxmin, @Cast("l_float32*") FloatPointer pymin, @Cast("l_float32*") FloatPointer pxmax, @Cast("l_float32*") FloatPointer pymax );
public static native @Cast("l_ok") int ptaGetMinMax( PTA pta, @Cast("l_float32*") FloatBuffer pxmin, @Cast("l_float32*") FloatBuffer pymin, @Cast("l_float32*") FloatBuffer pxmax, @Cast("l_float32*") FloatBuffer pymax );
public static native @Cast("l_ok") int ptaGetMinMax( PTA pta, @Cast("l_float32*") float[] pxmin, @Cast("l_float32*") float[] pymin, @Cast("l_float32*") float[] pxmax, @Cast("l_float32*") float[] pymax );
public static native PTA ptaSelectByValue( PTA ptas, @Cast("l_float32") float xth, @Cast("l_float32") float yth, @Cast("l_int32") int type, @Cast("l_int32") int relation );
public static native PTA ptaCropToMask( PTA ptas, PIX pixm );
public static native @Cast("l_ok") int ptaGetLinearLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaGetLinearLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetLinearLSF( PTA pta, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetLinearLSF( PTA pta, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuadraticLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaGetQuadraticLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuadraticLSF( PTA pta, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_float32*") FloatBuffer pc, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuadraticLSF( PTA pta, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_float32*") float[] pc, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetCubicLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pd, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaGetCubicLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pd, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetCubicLSF( PTA pta, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_float32*") FloatBuffer pc, @Cast("l_float32*") FloatBuffer pd, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetCubicLSF( PTA pta, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_float32*") float[] pc, @Cast("l_float32*") float[] pd, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuarticLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pd, @Cast("l_float32*") FloatPointer pe, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaGetQuarticLSF( PTA pta, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pd, @Cast("l_float32*") FloatPointer pe, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuarticLSF( PTA pta, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_float32*") FloatBuffer pc, @Cast("l_float32*") FloatBuffer pd, @Cast("l_float32*") FloatBuffer pe, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaGetQuarticLSF( PTA pta, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_float32*") float[] pc, @Cast("l_float32*") float[] pd, @Cast("l_float32*") float[] pe, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyLinearLSF( PTA pta, @Cast("l_float32") float factor, @Cast("PTA**") PointerPointer pptad, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pmederr, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaNoisyLinearLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyLinearLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_float32*") FloatBuffer pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyLinearLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_float32*") float[] pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyQuadraticLSF( PTA pta, @Cast("l_float32") float factor, @Cast("PTA**") PointerPointer pptad, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pmederr, @Cast("NUMA**") PointerPointer pnafit );
public static native @Cast("l_ok") int ptaNoisyQuadraticLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") FloatPointer pa, @Cast("l_float32*") FloatPointer pb, @Cast("l_float32*") FloatPointer pc, @Cast("l_float32*") FloatPointer pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyQuadraticLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") FloatBuffer pa, @Cast("l_float32*") FloatBuffer pb, @Cast("l_float32*") FloatBuffer pc, @Cast("l_float32*") FloatBuffer pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int ptaNoisyQuadraticLSF( PTA pta, @Cast("l_float32") float factor, @ByPtrPtr PTA pptad, @Cast("l_float32*") float[] pa, @Cast("l_float32*") float[] pb, @Cast("l_float32*") float[] pc, @Cast("l_float32*") float[] pmederr, @ByPtrPtr NUMA pnafit );
public static native @Cast("l_ok") int applyLinearFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float x, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int applyLinearFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float x, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int applyLinearFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float x, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int applyQuadraticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float x, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int applyQuadraticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float x, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int applyQuadraticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float x, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int applyCubicFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float x, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int applyCubicFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float x, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int applyCubicFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float x, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int applyQuarticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float e, @Cast("l_float32") float x, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_ok") int applyQuarticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float e, @Cast("l_float32") float x, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_ok") int applyQuarticFit( @Cast("l_float32") float a, @Cast("l_float32") float b, @Cast("l_float32") float c, @Cast("l_float32") float d, @Cast("l_float32") float e, @Cast("l_float32") float x, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int pixPlotAlongPta( PIX pixs, PTA pta, @Cast("l_int32") int outformat, @Cast("const char*") BytePointer title );
public static native @Cast("l_ok") int pixPlotAlongPta( PIX pixs, PTA pta, @Cast("l_int32") int outformat, String title );
public static native PTA ptaGetPixelsFromPix( PIX pixs, BOX box );
public static native PIX pixGenerateFromPta( PTA pta, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PTA ptaGetBoundaryPixels( PIX pixs, @Cast("l_int32") int type );
public static native PTAA ptaaGetBoundaryPixels( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @Cast("BOXA**") PointerPointer pboxa, @Cast("PIXA**") PointerPointer ppixa );
public static native PTAA ptaaGetBoundaryPixels( PIX pixs, @Cast("l_int32") int type, @Cast("l_int32") int connectivity, @ByPtrPtr BOXA pboxa, @ByPtrPtr PIXA ppixa );
public static native PTAA ptaaIndexLabeledPixels( PIX pixs, @Cast("l_int32*") IntPointer pncc );
public static native PTAA ptaaIndexLabeledPixels( PIX pixs, @Cast("l_int32*") IntBuffer pncc );
public static native PTAA ptaaIndexLabeledPixels( PIX pixs, @Cast("l_int32*") int[] pncc );
public static native PTA ptaGetNeighborPixLocs( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int conn );
public static native PTA numaConvertToPta1( NUMA na );
public static native PTA numaConvertToPta2( NUMA nax, NUMA nay );
public static native @Cast("l_ok") int ptaConvertToNuma( PTA pta, @Cast("NUMA**") PointerPointer pnax, @Cast("NUMA**") PointerPointer pnay );
public static native @Cast("l_ok") int ptaConvertToNuma( PTA pta, @ByPtrPtr NUMA pnax, @ByPtrPtr NUMA pnay );
public static native PIX pixDisplayPta( PIX pixd, PIX pixs, PTA pta );
public static native PIX pixDisplayPtaaPattern( PIX pixd, PIX pixs, PTAA ptaa, PIX pixp, @Cast("l_int32") int cx, @Cast("l_int32") int cy );
public static native PIX pixDisplayPtaPattern( PIX pixd, PIX pixs, PTA pta, PIX pixp, @Cast("l_int32") int cx, @Cast("l_int32") int cy, @Cast("l_uint32") int color );
public static native PTA ptaReplicatePattern( PTA ptas, PIX pixp, PTA ptap, @Cast("l_int32") int cx, @Cast("l_int32") int cy, @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX pixDisplayPtaa( PIX pixs, PTAA ptaa );
public static native PTA ptaSort( PTA ptas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex );
public static native PTA ptaSort( PTA ptas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex );
public static native @Cast("l_ok") int ptaGetSortIndex( PTA ptas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @Cast("NUMA**") PointerPointer pnaindex );
public static native @Cast("l_ok") int ptaGetSortIndex( PTA ptas, @Cast("l_int32") int sorttype, @Cast("l_int32") int sortorder, @ByPtrPtr NUMA pnaindex );
public static native PTA ptaSortByIndex( PTA ptas, NUMA naindex );
public static native PTAA ptaaSortByIndex( PTAA ptaas, NUMA naindex );
public static native @Cast("l_ok") int ptaGetRankValue( PTA pta, @Cast("l_float32") float fract, PTA ptasort, @Cast("l_int32") int sorttype, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int ptaGetRankValue( PTA pta, @Cast("l_float32") float fract, PTA ptasort, @Cast("l_int32") int sorttype, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int ptaGetRankValue( PTA pta, @Cast("l_float32") float fract, PTA ptasort, @Cast("l_int32") int sorttype, @Cast("l_float32*") float[] pval );
public static native PTA ptaSort2d( PTA pta );
public static native @Cast("l_ok") int ptaEqual( PTA pta1, PTA pta2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int ptaEqual( PTA pta1, PTA pta2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int ptaEqual( PTA pta1, PTA pta2, @Cast("l_int32*") int[] psame );
public static native L_ASET l_asetCreateFromPta( PTA pta );
public static native @Cast("l_ok") int ptaRemoveDupsByAset( PTA ptas, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int ptaRemoveDupsByAset( PTA ptas, @ByPtrPtr PTA pptad );
public static native @Cast("l_ok") int ptaUnionByAset( PTA pta1, PTA pta2, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int ptaUnionByAset( PTA pta1, PTA pta2, @ByPtrPtr PTA pptad );
public static native @Cast("l_ok") int ptaIntersectionByAset( PTA pta1, PTA pta2, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int ptaIntersectionByAset( PTA pta1, PTA pta2, @ByPtrPtr PTA pptad );
public static native L_HASHMAP l_hmapCreateFromPta( PTA pta );
public static native @Cast("l_ok") int ptaRemoveDupsByHmap( PTA ptas, @Cast("PTA**") PointerPointer pptad, @Cast("L_HASHMAP**") PointerPointer phmap );
public static native @Cast("l_ok") int ptaRemoveDupsByHmap( PTA ptas, @ByPtrPtr PTA pptad, @ByPtrPtr L_HASHMAP phmap );
public static native @Cast("l_ok") int ptaUnionByHmap( PTA pta1, PTA pta2, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int ptaUnionByHmap( PTA pta1, PTA pta2, @ByPtrPtr PTA pptad );
public static native @Cast("l_ok") int ptaIntersectionByHmap( PTA pta1, PTA pta2, @Cast("PTA**") PointerPointer pptad );
public static native @Cast("l_ok") int ptaIntersectionByHmap( PTA pta1, PTA pta2, @ByPtrPtr PTA pptad );
public static native L_PTRA ptraCreate( @Cast("l_int32") int n );
public static native void ptraDestroy( @Cast("L_PTRA**") PointerPointer ppa, @Cast("l_int32") int freeflag, @Cast("l_int32") int warnflag );
public static native void ptraDestroy( @ByPtrPtr L_PTRA ppa, @Cast("l_int32") int freeflag, @Cast("l_int32") int warnflag );
public static native @Cast("l_ok") int ptraAdd( L_PTRA pa, Pointer item );
public static native @Cast("l_ok") int ptraInsert( L_PTRA pa, @Cast("l_int32") int index, Pointer item, @Cast("l_int32") int shiftflag );
public static native Pointer ptraRemove( L_PTRA pa, @Cast("l_int32") int index, @Cast("l_int32") int flag );
public static native Pointer ptraRemoveLast( L_PTRA pa );
public static native Pointer ptraReplace( L_PTRA pa, @Cast("l_int32") int index, Pointer item, @Cast("l_int32") int freeflag );
public static native @Cast("l_ok") int ptraSwap( L_PTRA pa, @Cast("l_int32") int index1, @Cast("l_int32") int index2 );
public static native @Cast("l_ok") int ptraCompactArray( L_PTRA pa );
public static native @Cast("l_ok") int ptraReverse( L_PTRA pa );
public static native @Cast("l_ok") int ptraJoin( L_PTRA pa1, L_PTRA pa2 );
public static native @Cast("l_ok") int ptraGetMaxIndex( L_PTRA pa, @Cast("l_int32*") IntPointer pmaxindex );
public static native @Cast("l_ok") int ptraGetMaxIndex( L_PTRA pa, @Cast("l_int32*") IntBuffer pmaxindex );
public static native @Cast("l_ok") int ptraGetMaxIndex( L_PTRA pa, @Cast("l_int32*") int[] pmaxindex );
public static native @Cast("l_ok") int ptraGetActualCount( L_PTRA pa, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_ok") int ptraGetActualCount( L_PTRA pa, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_ok") int ptraGetActualCount( L_PTRA pa, @Cast("l_int32*") int[] pcount );
public static native Pointer ptraGetPtrToItem( L_PTRA pa, @Cast("l_int32") int index );
public static native L_PTRAA ptraaCreate( @Cast("l_int32") int n );
public static native void ptraaDestroy( @Cast("L_PTRAA**") PointerPointer ppaa, @Cast("l_int32") int freeflag, @Cast("l_int32") int warnflag );
public static native void ptraaDestroy( @ByPtrPtr L_PTRAA ppaa, @Cast("l_int32") int freeflag, @Cast("l_int32") int warnflag );
public static native @Cast("l_ok") int ptraaGetSize( L_PTRAA paa, @Cast("l_int32*") IntPointer psize );
public static native @Cast("l_ok") int ptraaGetSize( L_PTRAA paa, @Cast("l_int32*") IntBuffer psize );
public static native @Cast("l_ok") int ptraaGetSize( L_PTRAA paa, @Cast("l_int32*") int[] psize );
public static native @Cast("l_ok") int ptraaInsertPtra( L_PTRAA paa, @Cast("l_int32") int index, L_PTRA pa );
public static native L_PTRA ptraaGetPtra( L_PTRAA paa, @Cast("l_int32") int index, @Cast("l_int32") int accessflag );
public static native L_PTRA ptraaFlattenToPtra( L_PTRAA paa );
public static native @Cast("l_ok") int pixQuadtreeMean( PIX pixs, @Cast("l_int32") int nlevels, PIX pix_ma, @Cast("FPIXA**") PointerPointer pfpixa );
public static native @Cast("l_ok") int pixQuadtreeMean( PIX pixs, @Cast("l_int32") int nlevels, PIX pix_ma, @ByPtrPtr FPIXA pfpixa );
public static native @Cast("l_ok") int pixQuadtreeVariance( PIX pixs, @Cast("l_int32") int nlevels, PIX pix_ma, DPIX dpix_msa, @Cast("FPIXA**") PointerPointer pfpixa_v, @Cast("FPIXA**") PointerPointer pfpixa_rv );
public static native @Cast("l_ok") int pixQuadtreeVariance( PIX pixs, @Cast("l_int32") int nlevels, PIX pix_ma, DPIX dpix_msa, @ByPtrPtr FPIXA pfpixa_v, @ByPtrPtr FPIXA pfpixa_rv );
public static native @Cast("l_ok") int pixMeanInRectangle( PIX pixs, BOX box, PIX pixma, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int pixMeanInRectangle( PIX pixs, BOX box, PIX pixma, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int pixMeanInRectangle( PIX pixs, BOX box, PIX pixma, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int pixVarianceInRectangle( PIX pixs, BOX box, PIX pix_ma, DPIX dpix_msa, @Cast("l_float32*") FloatPointer pvar, @Cast("l_float32*") FloatPointer prvar );
public static native @Cast("l_ok") int pixVarianceInRectangle( PIX pixs, BOX box, PIX pix_ma, DPIX dpix_msa, @Cast("l_float32*") FloatBuffer pvar, @Cast("l_float32*") FloatBuffer prvar );
public static native @Cast("l_ok") int pixVarianceInRectangle( PIX pixs, BOX box, PIX pix_ma, DPIX dpix_msa, @Cast("l_float32*") float[] pvar, @Cast("l_float32*") float[] prvar );
public static native BOXAA boxaaQuadtreeRegions( @Cast("l_int32") int w, @Cast("l_int32") int h, @Cast("l_int32") int nlevels );
public static native @Cast("l_ok") int quadtreeGetParent( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pval );
public static native @Cast("l_ok") int quadtreeGetParent( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pval );
public static native @Cast("l_ok") int quadtreeGetParent( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pval );
public static native @Cast("l_ok") int quadtreeGetChildren( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatPointer pval00, @Cast("l_float32*") FloatPointer pval10, @Cast("l_float32*") FloatPointer pval01, @Cast("l_float32*") FloatPointer pval11 );
public static native @Cast("l_ok") int quadtreeGetChildren( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") FloatBuffer pval00, @Cast("l_float32*") FloatBuffer pval10, @Cast("l_float32*") FloatBuffer pval01, @Cast("l_float32*") FloatBuffer pval11 );
public static native @Cast("l_ok") int quadtreeGetChildren( FPIXA fpixa, @Cast("l_int32") int level, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32*") float[] pval00, @Cast("l_float32*") float[] pval10, @Cast("l_float32*") float[] pval01, @Cast("l_float32*") float[] pval11 );
public static native @Cast("l_int32") int quadtreeMaxLevels( @Cast("l_int32") int w, @Cast("l_int32") int h );
public static native PIX fpixaDisplayQuadtree( FPIXA fpixa, @Cast("l_int32") int factor, @Cast("l_int32") int fontsize );
public static native L_QUEUE lqueueCreate( @Cast("l_int32") int nalloc );
public static native void lqueueDestroy( @Cast("L_QUEUE**") PointerPointer plq, @Cast("l_int32") int freeflag );
public static native void lqueueDestroy( @ByPtrPtr L_QUEUE plq, @Cast("l_int32") int freeflag );
public static native @Cast("l_ok") int lqueueAdd( L_QUEUE lq, Pointer item );
public static native Pointer lqueueRemove( L_QUEUE lq );
public static native @Cast("l_int32") int lqueueGetCount( L_QUEUE lq );
public static native @Cast("l_ok") int lqueuePrint( @Cast("FILE*") Pointer fp, L_QUEUE lq );
public static native PIX pixRankFilter( PIX pixs, @Cast("l_int32") int wf, @Cast("l_int32") int hf, @Cast("l_float32") float rank );
public static native PIX pixRankFilterRGB( PIX pixs, @Cast("l_int32") int wf, @Cast("l_int32") int hf, @Cast("l_float32") float rank );
public static native PIX pixRankFilterGray( PIX pixs, @Cast("l_int32") int wf, @Cast("l_int32") int hf, @Cast("l_float32") float rank );
public static native PIX pixMedianFilter( PIX pixs, @Cast("l_int32") int wf, @Cast("l_int32") int hf );
public static native PIX pixRankFilterWithScaling( PIX pixs, @Cast("l_int32") int wf, @Cast("l_int32") int hf, @Cast("l_float32") float rank, @Cast("l_float32") float scalefactor );
public static native L_RBTREE l_rbtreeCreate( @Cast("l_int32") int keytype );
public static native RB_TYPE l_rbtreeLookup( L_RBTREE t, @ByVal RB_TYPE key );
public static native void l_rbtreeInsert( L_RBTREE t, @ByVal RB_TYPE key, @ByVal RB_TYPE value );
public static native void l_rbtreeDelete( L_RBTREE t, @ByVal RB_TYPE key );
public static native void l_rbtreeDestroy( @Cast("L_RBTREE**") PointerPointer pt );
public static native void l_rbtreeDestroy( @ByPtrPtr L_RBTREE pt );
public static native L_RBTREE_NODE l_rbtreeGetFirst( L_RBTREE t );
public static native L_RBTREE_NODE l_rbtreeGetNext( L_RBTREE_NODE n );
public static native L_RBTREE_NODE l_rbtreeGetLast( L_RBTREE t );
public static native L_RBTREE_NODE l_rbtreeGetPrev( L_RBTREE_NODE n );
public static native @Cast("l_int32") int l_rbtreeGetCount( L_RBTREE t );
public static native void l_rbtreePrint( @Cast("FILE*") Pointer fp, L_RBTREE t );
public static native SARRAY pixProcessBarcodes( PIX pixs, @Cast("l_int32") int format, @Cast("l_int32") int method, @Cast("SARRAY**") PointerPointer psaw, @Cast("l_int32") int debugflag );
public static native SARRAY pixProcessBarcodes( PIX pixs, @Cast("l_int32") int format, @Cast("l_int32") int method, @ByPtrPtr SARRAY psaw, @Cast("l_int32") int debugflag );
public static native PIXA pixExtractBarcodes( PIX pixs, @Cast("l_int32") int debugflag );
public static native SARRAY pixReadBarcodes( PIXA pixa, @Cast("l_int32") int format, @Cast("l_int32") int method, @Cast("SARRAY**") PointerPointer psaw, @Cast("l_int32") int debugflag );
public static native SARRAY pixReadBarcodes( PIXA pixa, @Cast("l_int32") int format, @Cast("l_int32") int method, @ByPtrPtr SARRAY psaw, @Cast("l_int32") int debugflag );
public static native NUMA pixReadBarcodeWidths( PIX pixs, @Cast("l_int32") int method, @Cast("l_int32") int debugflag );
public static native BOXA pixLocateBarcodes( PIX pixs, @Cast("l_int32") int thresh, @Cast("PIX**") PointerPointer ppixb, @Cast("PIX**") PointerPointer ppixm );
public static native BOXA pixLocateBarcodes( PIX pixs, @Cast("l_int32") int thresh, @ByPtrPtr PIX ppixb, @ByPtrPtr PIX ppixm );
public static native PIX pixDeskewBarcode( PIX pixs, PIX pixb, BOX box, @Cast("l_int32") int margin, @Cast("l_int32") int threshold, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf );
public static native PIX pixDeskewBarcode( PIX pixs, PIX pixb, BOX box, @Cast("l_int32") int margin, @Cast("l_int32") int threshold, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf );
public static native PIX pixDeskewBarcode( PIX pixs, PIX pixb, BOX box, @Cast("l_int32") int margin, @Cast("l_int32") int threshold, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf );
public static native NUMA pixExtractBarcodeWidths1( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32") float binfract, @Cast("NUMA**") PointerPointer pnaehist, @Cast("NUMA**") PointerPointer pnaohist, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeWidths1( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32") float binfract, @ByPtrPtr NUMA pnaehist, @ByPtrPtr NUMA pnaohist, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeWidths2( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32*") FloatPointer pwidth, @Cast("NUMA**") PointerPointer pnac, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeWidths2( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32*") FloatPointer pwidth, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeWidths2( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32*") FloatBuffer pwidth, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeWidths2( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_float32*") float[] pwidth, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native NUMA pixExtractBarcodeCrossings( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWidth( NUMA nas, @Cast("l_float32") float binfract, @Cast("NUMA**") PointerPointer pnaehist, @Cast("NUMA**") PointerPointer pnaohist, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWidth( NUMA nas, @Cast("l_float32") float binfract, @ByPtrPtr NUMA pnaehist, @ByPtrPtr NUMA pnaohist, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWindow( NUMA nas, @Cast("l_float32") float ratio, @Cast("l_float32*") FloatPointer pwidth, @Cast("l_float32*") FloatPointer pfirstloc, @Cast("NUMA**") PointerPointer pnac, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWindow( NUMA nas, @Cast("l_float32") float ratio, @Cast("l_float32*") FloatPointer pwidth, @Cast("l_float32*") FloatPointer pfirstloc, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWindow( NUMA nas, @Cast("l_float32") float ratio, @Cast("l_float32*") FloatBuffer pwidth, @Cast("l_float32*") FloatBuffer pfirstloc, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native NUMA numaQuantizeCrossingsByWindow( NUMA nas, @Cast("l_float32") float ratio, @Cast("l_float32*") float[] pwidth, @Cast("l_float32*") float[] pfirstloc, @ByPtrPtr NUMA pnac, @Cast("l_int32") int debugflag );
public static native PIXA pixaReadFiles( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr );
public static native PIXA pixaReadFiles( String dirname, String substr );
public static native PIXA pixaReadFilesSA( SARRAY sa );
public static native PIX pixRead( @Cast("const char*") BytePointer filename );
public static native PIX pixRead( String filename );
public static native PIX pixReadWithHint( @Cast("const char*") BytePointer filename, @Cast("l_int32") int hint );
public static native PIX pixReadWithHint( String filename, @Cast("l_int32") int hint );
public static native PIX pixReadIndexed( SARRAY sa, @Cast("l_int32") int index );
public static native PIX pixReadStream( @Cast("FILE*") Pointer fp, @Cast("l_int32") int hint );
public static native @Cast("l_ok") int pixReadHeader( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pformat, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int pixReadHeader( String filename, @Cast("l_int32*") IntBuffer pformat, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int pixReadHeader( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pformat, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int pixReadHeader( String filename, @Cast("l_int32*") IntPointer pformat, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int pixReadHeader( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pformat, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int pixReadHeader( String filename, @Cast("l_int32*") int[] pformat, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int findFileFormat( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int findFileFormat( String filename, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int findFileFormat( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int findFileFormat( String filename, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int findFileFormat( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int findFileFormat( String filename, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int findFileFormatStream( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int findFileFormatStream( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int findFileFormatStream( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int findFileFormatBuffer( @Cast("const l_uint8*") BytePointer buf, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int findFileFormatBuffer( @Cast("const l_uint8*") ByteBuffer buf, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int findFileFormatBuffer( @Cast("const l_uint8*") byte[] buf, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_int32") int fileFormatIsTiff( @Cast("FILE*") Pointer fp );
public static native PIX pixReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIX pixReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIX pixReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixReadHeaderMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pformat, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int pixReadHeaderMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pformat, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int pixReadHeaderMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pformat, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int writeImageFileInfo( @Cast("const char*") BytePointer filename, @Cast("FILE*") Pointer fpout, @Cast("l_int32") int headeronly );
public static native @Cast("l_ok") int writeImageFileInfo( String filename, @Cast("FILE*") Pointer fpout, @Cast("l_int32") int headeronly );
public static native @Cast("l_ok") int ioFormatTest( @Cast("const char*") BytePointer filename );
public static native @Cast("l_ok") int ioFormatTest( String filename );
public static native L_RECOG recogCreateFromRecog( L_RECOG recs, @Cast("l_int32") int scalew, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew, @Cast("l_int32") int threshold, @Cast("l_int32") int maxyshift );
public static native L_RECOG recogCreateFromPixa( PIXA pixa, @Cast("l_int32") int scalew, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew, @Cast("l_int32") int threshold, @Cast("l_int32") int maxyshift );
public static native L_RECOG recogCreateFromPixaNoFinish( PIXA pixa, @Cast("l_int32") int scalew, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew, @Cast("l_int32") int threshold, @Cast("l_int32") int maxyshift );
public static native L_RECOG recogCreate( @Cast("l_int32") int scalew, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew, @Cast("l_int32") int threshold, @Cast("l_int32") int maxyshift );
public static native void recogDestroy( @Cast("L_RECOG**") PointerPointer precog );
public static native void recogDestroy( @ByPtrPtr L_RECOG precog );
public static native @Cast("l_int32") int recogGetCount( L_RECOG recog );
public static native @Cast("l_ok") int recogSetParams( L_RECOG recog, @Cast("l_int32") int type, @Cast("l_int32") int min_nopad, @Cast("l_float32") float max_wh_ratio, @Cast("l_float32") float max_ht_ratio );
public static native @Cast("l_int32") int recogGetClassIndex( L_RECOG recog, @Cast("l_int32") int val, @Cast("char*") BytePointer text, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_int32") int recogGetClassIndex( L_RECOG recog, @Cast("l_int32") int val, @Cast("char*") ByteBuffer text, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_int32") int recogGetClassIndex( L_RECOG recog, @Cast("l_int32") int val, @Cast("char*") byte[] text, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_ok") int recogStringToIndex( L_RECOG recog, @Cast("char*") BytePointer text, @Cast("l_int32*") IntPointer pindex );
public static native @Cast("l_ok") int recogStringToIndex( L_RECOG recog, @Cast("char*") ByteBuffer text, @Cast("l_int32*") IntBuffer pindex );
public static native @Cast("l_ok") int recogStringToIndex( L_RECOG recog, @Cast("char*") byte[] text, @Cast("l_int32*") int[] pindex );
public static native @Cast("l_int32") int recogGetClassString( L_RECOG recog, @Cast("l_int32") int index, @Cast("char**") PointerPointer pcharstr );
public static native @Cast("l_int32") int recogGetClassString( L_RECOG recog, @Cast("l_int32") int index, @Cast("char**") @ByPtrPtr BytePointer pcharstr );
public static native @Cast("l_int32") int recogGetClassString( L_RECOG recog, @Cast("l_int32") int index, @Cast("char**") @ByPtrPtr ByteBuffer pcharstr );
public static native @Cast("l_int32") int recogGetClassString( L_RECOG recog, @Cast("l_int32") int index, @Cast("char**") @ByPtrPtr byte[] pcharstr );
public static native @Cast("l_ok") int l_convertCharstrToInt( @Cast("const char*") BytePointer str, @Cast("l_int32*") IntPointer pval );
public static native @Cast("l_ok") int l_convertCharstrToInt( String str, @Cast("l_int32*") IntBuffer pval );
public static native @Cast("l_ok") int l_convertCharstrToInt( @Cast("const char*") BytePointer str, @Cast("l_int32*") int[] pval );
public static native @Cast("l_ok") int l_convertCharstrToInt( String str, @Cast("l_int32*") IntPointer pval );
public static native @Cast("l_ok") int l_convertCharstrToInt( @Cast("const char*") BytePointer str, @Cast("l_int32*") IntBuffer pval );
public static native @Cast("l_ok") int l_convertCharstrToInt( String str, @Cast("l_int32*") int[] pval );
public static native L_RECOG recogRead( @Cast("const char*") BytePointer filename );
public static native L_RECOG recogRead( String filename );
public static native L_RECOG recogReadStream( @Cast("FILE*") Pointer fp );
public static native L_RECOG recogReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native L_RECOG recogReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native L_RECOG recogReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int recogWrite( @Cast("const char*") BytePointer filename, L_RECOG recog );
public static native @Cast("l_ok") int recogWrite( String filename, L_RECOG recog );
public static native @Cast("l_ok") int recogWriteStream( @Cast("FILE*") Pointer fp, L_RECOG recog );
public static native @Cast("l_ok") int recogWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, L_RECOG recog );
public static native @Cast("l_ok") int recogWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, L_RECOG recog );
public static native @Cast("l_ok") int recogWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, L_RECOG recog );
public static native @Cast("l_ok") int recogWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, L_RECOG recog );
public static native PIXA recogExtractPixa( L_RECOG recog );
public static native BOXA recogDecode( L_RECOG recog, PIX pixs, @Cast("l_int32") int nlevels, @Cast("PIX**") PointerPointer ppixdb );
public static native BOXA recogDecode( L_RECOG recog, PIX pixs, @Cast("l_int32") int nlevels, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogCreateDid( L_RECOG recog, PIX pixs );
public static native @Cast("l_ok") int recogDestroyDid( L_RECOG recog );
public static native @Cast("l_int32") int recogDidExists( L_RECOG recog );
public static native L_RDID recogGetDid( L_RECOG recog );
public static native @Cast("l_ok") int recogSetChannelParams( L_RECOG recog, @Cast("l_int32") int nlevels );
public static native @Cast("l_ok") int recogIdentifyMultiple( L_RECOG recog, PIX pixs, @Cast("l_int32") int minh, @Cast("l_int32") int skipsplit, @Cast("BOXA**") PointerPointer pboxa, @Cast("PIXA**") PointerPointer ppixa, @Cast("PIX**") PointerPointer ppixdb, @Cast("l_int32") int debugsplit );
public static native @Cast("l_ok") int recogIdentifyMultiple( L_RECOG recog, PIX pixs, @Cast("l_int32") int minh, @Cast("l_int32") int skipsplit, @ByPtrPtr BOXA pboxa, @ByPtrPtr PIXA ppixa, @ByPtrPtr PIX ppixdb, @Cast("l_int32") int debugsplit );
public static native @Cast("l_ok") int recogSplitIntoCharacters( L_RECOG recog, PIX pixs, @Cast("l_int32") int minh, @Cast("l_int32") int skipsplit, @Cast("BOXA**") PointerPointer pboxa, @Cast("PIXA**") PointerPointer ppixa, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogSplitIntoCharacters( L_RECOG recog, PIX pixs, @Cast("l_int32") int minh, @Cast("l_int32") int skipsplit, @ByPtrPtr BOXA pboxa, @ByPtrPtr PIXA ppixa, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogCorrelationBestRow( L_RECOG recog, PIX pixs, @Cast("BOXA**") PointerPointer pboxa, @Cast("NUMA**") PointerPointer pnascore, @Cast("NUMA**") PointerPointer pnaindex, @Cast("SARRAY**") PointerPointer psachar, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogCorrelationBestRow( L_RECOG recog, PIX pixs, @ByPtrPtr BOXA pboxa, @ByPtrPtr NUMA pnascore, @ByPtrPtr NUMA pnaindex, @ByPtrPtr SARRAY psachar, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogCorrelationBestChar( L_RECOG recog, PIX pixs, @Cast("BOX**") PointerPointer pbox, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32*") IntPointer pindex, @Cast("char**") PointerPointer pcharstr, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int recogCorrelationBestChar( L_RECOG recog, PIX pixs, @ByPtrPtr BOX pbox, @Cast("l_float32*") FloatPointer pscore, @Cast("l_int32*") IntPointer pindex, @Cast("char**") @ByPtrPtr BytePointer pcharstr, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogCorrelationBestChar( L_RECOG recog, PIX pixs, @ByPtrPtr BOX pbox, @Cast("l_float32*") FloatBuffer pscore, @Cast("l_int32*") IntBuffer pindex, @Cast("char**") @ByPtrPtr ByteBuffer pcharstr, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogCorrelationBestChar( L_RECOG recog, PIX pixs, @ByPtrPtr BOX pbox, @Cast("l_float32*") float[] pscore, @Cast("l_int32*") int[] pindex, @Cast("char**") @ByPtrPtr byte[] pcharstr, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogIdentifyPixa( L_RECOG recog, PIXA pixa, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int recogIdentifyPixa( L_RECOG recog, PIXA pixa, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogIdentifyPix( L_RECOG recog, PIX pixs, @Cast("PIX**") PointerPointer ppixdb );
public static native @Cast("l_ok") int recogIdentifyPix( L_RECOG recog, PIX pixs, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogSkipIdentify( L_RECOG recog );
public static native void rchaDestroy( @Cast("L_RCHA**") PointerPointer prcha );
public static native void rchaDestroy( @ByPtrPtr L_RCHA prcha );
public static native void rchDestroy( @Cast("L_RCH**") PointerPointer prch );
public static native void rchDestroy( @ByPtrPtr L_RCH prch );
public static native @Cast("l_ok") int rchaExtract( L_RCHA rcha, @Cast("NUMA**") PointerPointer pnaindex, @Cast("NUMA**") PointerPointer pnascore, @Cast("SARRAY**") PointerPointer psatext, @Cast("NUMA**") PointerPointer pnasample, @Cast("NUMA**") PointerPointer pnaxloc, @Cast("NUMA**") PointerPointer pnayloc, @Cast("NUMA**") PointerPointer pnawidth );
public static native @Cast("l_ok") int rchaExtract( L_RCHA rcha, @ByPtrPtr NUMA pnaindex, @ByPtrPtr NUMA pnascore, @ByPtrPtr SARRAY psatext, @ByPtrPtr NUMA pnasample, @ByPtrPtr NUMA pnaxloc, @ByPtrPtr NUMA pnayloc, @ByPtrPtr NUMA pnawidth );
public static native @Cast("l_ok") int rchExtract( L_RCH rch, @Cast("l_int32*") IntPointer pindex, @Cast("l_float32*") FloatPointer pscore, @Cast("char**") PointerPointer ptext, @Cast("l_int32*") IntPointer psample, @Cast("l_int32*") IntPointer pxloc, @Cast("l_int32*") IntPointer pyloc, @Cast("l_int32*") IntPointer pwidth );
public static native @Cast("l_ok") int rchExtract( L_RCH rch, @Cast("l_int32*") IntPointer pindex, @Cast("l_float32*") FloatPointer pscore, @Cast("char**") @ByPtrPtr BytePointer ptext, @Cast("l_int32*") IntPointer psample, @Cast("l_int32*") IntPointer pxloc, @Cast("l_int32*") IntPointer pyloc, @Cast("l_int32*") IntPointer pwidth );
public static native @Cast("l_ok") int rchExtract( L_RCH rch, @Cast("l_int32*") IntBuffer pindex, @Cast("l_float32*") FloatBuffer pscore, @Cast("char**") @ByPtrPtr ByteBuffer ptext, @Cast("l_int32*") IntBuffer psample, @Cast("l_int32*") IntBuffer pxloc, @Cast("l_int32*") IntBuffer pyloc, @Cast("l_int32*") IntBuffer pwidth );
public static native @Cast("l_ok") int rchExtract( L_RCH rch, @Cast("l_int32*") int[] pindex, @Cast("l_float32*") float[] pscore, @Cast("char**") @ByPtrPtr byte[] ptext, @Cast("l_int32*") int[] psample, @Cast("l_int32*") int[] pxloc, @Cast("l_int32*") int[] pyloc, @Cast("l_int32*") int[] pwidth );
public static native PIX recogProcessToIdentify( L_RECOG recog, PIX pixs, @Cast("l_int32") int pad );
public static native SARRAY recogExtractNumbers( L_RECOG recog, BOXA boxas, @Cast("l_float32") float scorethresh, @Cast("l_int32") int spacethresh, @Cast("BOXAA**") PointerPointer pbaa, @Cast("NUMAA**") PointerPointer pnaa );
public static native SARRAY recogExtractNumbers( L_RECOG recog, BOXA boxas, @Cast("l_float32") float scorethresh, @Cast("l_int32") int spacethresh, @ByPtrPtr BOXAA pbaa, @ByPtrPtr NUMAA pnaa );
public static native PIXA showExtractNumbers( PIX pixs, SARRAY sa, BOXAA baa, NUMAA naa, @Cast("PIX**") PointerPointer ppixdb );
public static native PIXA showExtractNumbers( PIX pixs, SARRAY sa, BOXAA baa, NUMAA naa, @ByPtrPtr PIX ppixdb );
public static native @Cast("l_ok") int recogTrainLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") BytePointer text, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogTrainLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") ByteBuffer text, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogTrainLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") byte[] text, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogProcessLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") BytePointer text, @Cast("PIX**") PointerPointer ppix );
public static native @Cast("l_ok") int recogProcessLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") BytePointer text, @ByPtrPtr PIX ppix );
public static native @Cast("l_ok") int recogProcessLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") ByteBuffer text, @ByPtrPtr PIX ppix );
public static native @Cast("l_ok") int recogProcessLabeled( L_RECOG recog, PIX pixs, BOX box, @Cast("char*") byte[] text, @ByPtrPtr PIX ppix );
public static native @Cast("l_ok") int recogAddSample( L_RECOG recog, PIX pix, @Cast("l_int32") int debug );
public static native PIX recogModifyTemplate( L_RECOG recog, PIX pixs );
public static native @Cast("l_int32") int recogAverageSamples( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_int32") int debug );
public static native @Cast("l_int32") int recogAverageSamples( @ByPtrPtr L_RECOG precog, @Cast("l_int32") int debug );
public static native @Cast("l_int32") int pixaAccumulateSamples( PIXA pixa, PTA pta, @Cast("PIX**") PointerPointer ppixd, @Cast("l_float32*") FloatPointer px, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_int32") int pixaAccumulateSamples( PIXA pixa, PTA pta, @ByPtrPtr PIX ppixd, @Cast("l_float32*") FloatPointer px, @Cast("l_float32*") FloatPointer py );
public static native @Cast("l_int32") int pixaAccumulateSamples( PIXA pixa, PTA pta, @ByPtrPtr PIX ppixd, @Cast("l_float32*") FloatBuffer px, @Cast("l_float32*") FloatBuffer py );
public static native @Cast("l_int32") int pixaAccumulateSamples( PIXA pixa, PTA pta, @ByPtrPtr PIX ppixd, @Cast("l_float32*") float[] px, @Cast("l_float32*") float[] py );
public static native @Cast("l_ok") int recogTrainingFinished( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_int32") int modifyflag, @Cast("l_int32") int minsize, @Cast("l_float32") float minfract );
public static native @Cast("l_ok") int recogTrainingFinished( @ByPtrPtr L_RECOG precog, @Cast("l_int32") int modifyflag, @Cast("l_int32") int minsize, @Cast("l_float32") float minfract );
public static native PIXA recogFilterPixaBySize( PIXA pixas, @Cast("l_int32") int setsize, @Cast("l_int32") int maxkeep, @Cast("l_float32") float max_ht_ratio, @Cast("NUMA**") PointerPointer pna );
public static native PIXA recogFilterPixaBySize( PIXA pixas, @Cast("l_int32") int setsize, @Cast("l_int32") int maxkeep, @Cast("l_float32") float max_ht_ratio, @ByPtrPtr NUMA pna );
public static native PIXAA recogSortPixaByClass( PIXA pixa, @Cast("l_int32") int setsize );
public static native @Cast("l_ok") int recogRemoveOutliers1( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_float32") float minscore, @Cast("l_int32") int mintarget, @Cast("l_int32") int minsize, @Cast("PIX**") PointerPointer ppixsave, @Cast("PIX**") PointerPointer ppixrem );
public static native @Cast("l_ok") int recogRemoveOutliers1( @ByPtrPtr L_RECOG precog, @Cast("l_float32") float minscore, @Cast("l_int32") int mintarget, @Cast("l_int32") int minsize, @ByPtrPtr PIX ppixsave, @ByPtrPtr PIX ppixrem );
public static native PIXA pixaRemoveOutliers1( PIXA pixas, @Cast("l_float32") float minscore, @Cast("l_int32") int mintarget, @Cast("l_int32") int minsize, @Cast("PIX**") PointerPointer ppixsave, @Cast("PIX**") PointerPointer ppixrem );
public static native PIXA pixaRemoveOutliers1( PIXA pixas, @Cast("l_float32") float minscore, @Cast("l_int32") int mintarget, @Cast("l_int32") int minsize, @ByPtrPtr PIX ppixsave, @ByPtrPtr PIX ppixrem );
public static native @Cast("l_ok") int recogRemoveOutliers2( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_float32") float minscore, @Cast("l_int32") int minsize, @Cast("PIX**") PointerPointer ppixsave, @Cast("PIX**") PointerPointer ppixrem );
public static native @Cast("l_ok") int recogRemoveOutliers2( @ByPtrPtr L_RECOG precog, @Cast("l_float32") float minscore, @Cast("l_int32") int minsize, @ByPtrPtr PIX ppixsave, @ByPtrPtr PIX ppixrem );
public static native PIXA pixaRemoveOutliers2( PIXA pixas, @Cast("l_float32") float minscore, @Cast("l_int32") int minsize, @Cast("PIX**") PointerPointer ppixsave, @Cast("PIX**") PointerPointer ppixrem );
public static native PIXA pixaRemoveOutliers2( PIXA pixas, @Cast("l_float32") float minscore, @Cast("l_int32") int minsize, @ByPtrPtr PIX ppixsave, @ByPtrPtr PIX ppixrem );
public static native PIXA recogTrainFromBoot( L_RECOG recogboot, PIXA pixas, @Cast("l_float32") float minscore, @Cast("l_int32") int threshold, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogPadDigitTrainingSet( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew );
public static native @Cast("l_ok") int recogPadDigitTrainingSet( @ByPtrPtr L_RECOG precog, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew );
public static native @Cast("l_int32") int recogIsPaddingNeeded( L_RECOG recog, @Cast("SARRAY**") PointerPointer psa );
public static native @Cast("l_int32") int recogIsPaddingNeeded( L_RECOG recog, @ByPtrPtr SARRAY psa );
public static native PIXA recogAddDigitPadTemplates( L_RECOG recog, SARRAY sa );
public static native L_RECOG recogMakeBootDigitRecog( @Cast("l_int32") int nsamp, @Cast("l_int32") int scaleh, @Cast("l_int32") int linew, @Cast("l_int32") int maxyshift, @Cast("l_int32") int debug );
public static native PIXA recogMakeBootDigitTemplates( @Cast("l_int32") int nsamp, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogShowContent( @Cast("FILE*") Pointer fp, L_RECOG recog, @Cast("l_int32") int index, @Cast("l_int32") int display );
public static native @Cast("l_ok") int recogDebugAverages( @Cast("L_RECOG**") PointerPointer precog, @Cast("l_int32") int debug );
public static native @Cast("l_ok") int recogDebugAverages( @ByPtrPtr L_RECOG precog, @Cast("l_int32") int debug );
public static native @Cast("l_int32") int recogShowAverageTemplates( L_RECOG recog );
public static native @Cast("l_ok") int recogShowMatchesInRange( L_RECOG recog, PIXA pixa, @Cast("l_float32") float minscore, @Cast("l_float32") float maxscore, @Cast("l_int32") int display );
public static native PIX recogShowMatch( L_RECOG recog, PIX pix1, PIX pix2, BOX box, @Cast("l_int32") int index, @Cast("l_float32") float score );
public static native @Cast("l_ok") int regTestSetup( @Cast("l_int32") int argc, @Cast("char**") PointerPointer argv, @Cast("L_REGPARAMS**") PointerPointer prp );
public static native @Cast("l_ok") int regTestSetup( @Cast("l_int32") int argc, @Cast("char**") @ByPtrPtr BytePointer argv, @ByPtrPtr L_REGPARAMS prp );
public static native @Cast("l_ok") int regTestSetup( @Cast("l_int32") int argc, @Cast("char**") @ByPtrPtr ByteBuffer argv, @ByPtrPtr L_REGPARAMS prp );
public static native @Cast("l_ok") int regTestSetup( @Cast("l_int32") int argc, @Cast("char**") @ByPtrPtr byte[] argv, @ByPtrPtr L_REGPARAMS prp );
public static native @Cast("l_ok") int regTestCleanup( L_REGPARAMS rp );
public static native @Cast("l_ok") int regTestCompareValues( L_REGPARAMS rp, @Cast("l_float32") float val1, @Cast("l_float32") float val2, @Cast("l_float32") float delta );
public static native @Cast("l_ok") int regTestCompareStrings( L_REGPARAMS rp, @Cast("l_uint8*") BytePointer string1, @Cast("size_t") long bytes1, @Cast("l_uint8*") BytePointer string2, @Cast("size_t") long bytes2 );
public static native @Cast("l_ok") int regTestCompareStrings( L_REGPARAMS rp, @Cast("l_uint8*") ByteBuffer string1, @Cast("size_t") long bytes1, @Cast("l_uint8*") ByteBuffer string2, @Cast("size_t") long bytes2 );
public static native @Cast("l_ok") int regTestCompareStrings( L_REGPARAMS rp, @Cast("l_uint8*") byte[] string1, @Cast("size_t") long bytes1, @Cast("l_uint8*") byte[] string2, @Cast("size_t") long bytes2 );
public static native @Cast("l_ok") int regTestComparePix( L_REGPARAMS rp, PIX pix1, PIX pix2 );
public static native @Cast("l_ok") int regTestCompareSimilarPix( L_REGPARAMS rp, PIX pix1, PIX pix2, @Cast("l_int32") int mindiff, @Cast("l_float32") float maxfract, @Cast("l_int32") int printstats );
public static native @Cast("l_ok") int regTestCheckFile( L_REGPARAMS rp, @Cast("const char*") BytePointer localname );
public static native @Cast("l_ok") int regTestCheckFile( L_REGPARAMS rp, String localname );
public static native @Cast("l_ok") int regTestCompareFiles( L_REGPARAMS rp, @Cast("l_int32") int index1, @Cast("l_int32") int index2 );
public static native @Cast("l_ok") int regTestWritePixAndCheck( L_REGPARAMS rp, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int regTestWriteDataAndCheck( L_REGPARAMS rp, Pointer data, @Cast("size_t") long nbytes, @Cast("const char*") BytePointer ext );
public static native @Cast("l_ok") int regTestWriteDataAndCheck( L_REGPARAMS rp, Pointer data, @Cast("size_t") long nbytes, String ext );
public static native @Cast("char*") BytePointer regTestGenLocalFilename( L_REGPARAMS rp, @Cast("l_int32") int index, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixRasterop( PIX pixd, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op, PIX pixs, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native @Cast("l_ok") int pixRasteropVip( PIX pixd, @Cast("l_int32") int bx, @Cast("l_int32") int bw, @Cast("l_int32") int vshift, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixRasteropHip( PIX pixd, @Cast("l_int32") int by, @Cast("l_int32") int bh, @Cast("l_int32") int hshift, @Cast("l_int32") int incolor );
public static native PIX pixTranslate( PIX pixd, PIX pixs, @Cast("l_int32") int hshift, @Cast("l_int32") int vshift, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixRasteropIP( PIX pixd, @Cast("l_int32") int hshift, @Cast("l_int32") int vshift, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixRasteropFullImage( PIX pixd, PIX pixs, @Cast("l_int32") int op );
public static native void rasteropUniLow( @Cast("l_uint32*") IntPointer datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op );
public static native void rasteropUniLow( @Cast("l_uint32*") IntBuffer datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op );
public static native void rasteropUniLow( @Cast("l_uint32*") int[] datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op );
public static native void rasteropLow( @Cast("l_uint32*") IntPointer datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op, @Cast("l_uint32*") IntPointer datas, @Cast("l_int32") int spixw, @Cast("l_int32") int spixh, @Cast("l_int32") int swpl, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native void rasteropLow( @Cast("l_uint32*") IntBuffer datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op, @Cast("l_uint32*") IntBuffer datas, @Cast("l_int32") int spixw, @Cast("l_int32") int spixh, @Cast("l_int32") int swpl, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native void rasteropLow( @Cast("l_uint32*") int[] datad, @Cast("l_int32") int dpixw, @Cast("l_int32") int dpixh, @Cast("l_int32") int depth, @Cast("l_int32") int dwpl, @Cast("l_int32") int dx, @Cast("l_int32") int dy, @Cast("l_int32") int dw, @Cast("l_int32") int dh, @Cast("l_int32") int op, @Cast("l_uint32*") int[] datas, @Cast("l_int32") int spixw, @Cast("l_int32") int spixh, @Cast("l_int32") int swpl, @Cast("l_int32") int sx, @Cast("l_int32") int sy );
public static native void rasteropVipLow( @Cast("l_uint32*") IntPointer data, @Cast("l_int32") int pixw, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int x, @Cast("l_int32") int w, @Cast("l_int32") int shift );
public static native void rasteropVipLow( @Cast("l_uint32*") IntBuffer data, @Cast("l_int32") int pixw, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int x, @Cast("l_int32") int w, @Cast("l_int32") int shift );
public static native void rasteropVipLow( @Cast("l_uint32*") int[] data, @Cast("l_int32") int pixw, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int x, @Cast("l_int32") int w, @Cast("l_int32") int shift );
public static native void rasteropHipLow( @Cast("l_uint32*") IntPointer data, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int y, @Cast("l_int32") int h, @Cast("l_int32") int shift );
public static native void rasteropHipLow( @Cast("l_uint32*") IntBuffer data, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int y, @Cast("l_int32") int h, @Cast("l_int32") int shift );
public static native void rasteropHipLow( @Cast("l_uint32*") int[] data, @Cast("l_int32") int pixh, @Cast("l_int32") int depth, @Cast("l_int32") int wpl, @Cast("l_int32") int y, @Cast("l_int32") int h, @Cast("l_int32") int shift );
public static native PIX pixRotate( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int type, @Cast("l_int32") int incolor, @Cast("l_int32") int width, @Cast("l_int32") int height );
public static native PIX pixEmbedForRotation( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor, @Cast("l_int32") int width, @Cast("l_int32") int height );
public static native PIX pixRotateBySampling( PIX pixs, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotateBinaryNice( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotateWithAlpha( PIX pixs, @Cast("l_float32") float angle, PIX pixg, @Cast("l_float32") float fract );
public static native PIX pixRotateAM( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotateAMColor( PIX pixs, @Cast("l_float32") float angle, @Cast("l_uint32") int colorval );
public static native PIX pixRotateAMGray( PIX pixs, @Cast("l_float32") float angle, @Cast("l_uint8") byte grayval );
public static native PIX pixRotateAMCorner( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotateAMColorCorner( PIX pixs, @Cast("l_float32") float angle, @Cast("l_uint32") int fillval );
public static native PIX pixRotateAMGrayCorner( PIX pixs, @Cast("l_float32") float angle, @Cast("l_uint8") byte grayval );
public static native PIX pixRotateAMColorFast( PIX pixs, @Cast("l_float32") float angle, @Cast("l_uint32") int colorval );
public static native PIX pixRotateOrth( PIX pixs, @Cast("l_int32") int quads );
public static native PIX pixRotate180( PIX pixd, PIX pixs );
public static native PIX pixRotate90( PIX pixs, @Cast("l_int32") int direction );
public static native PIX pixFlipLR( PIX pixd, PIX pixs );
public static native PIX pixFlipTB( PIX pixd, PIX pixs );
public static native PIX pixRotateShear( PIX pixs, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotate2Shear( PIX pixs, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotate3Shear( PIX pixs, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixRotateShearIP( PIX pixs, @Cast("l_int32") int xcen, @Cast("l_int32") int ycen, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixRotateShearCenter( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixRotateShearCenterIP( PIX pixs, @Cast("l_float32") float angle, @Cast("l_int32") int incolor );
public static native PIX pixStrokeWidthTransform( PIX pixs, @Cast("l_int32") int color, @Cast("l_int32") int depth, @Cast("l_int32") int nangles );
public static native PIX pixRunlengthTransform( PIX pixs, @Cast("l_int32") int color, @Cast("l_int32") int direction, @Cast("l_int32") int depth );
public static native @Cast("l_ok") int pixFindHorizontalRuns( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer xstart, @Cast("l_int32*") IntPointer xend, @Cast("l_int32*") IntPointer pn );
public static native @Cast("l_ok") int pixFindHorizontalRuns( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer xstart, @Cast("l_int32*") IntBuffer xend, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("l_ok") int pixFindHorizontalRuns( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") int[] xstart, @Cast("l_int32*") int[] xend, @Cast("l_int32*") int[] pn );
public static native @Cast("l_ok") int pixFindVerticalRuns( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") IntPointer ystart, @Cast("l_int32*") IntPointer yend, @Cast("l_int32*") IntPointer pn );
public static native @Cast("l_ok") int pixFindVerticalRuns( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") IntBuffer ystart, @Cast("l_int32*") IntBuffer yend, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("l_ok") int pixFindVerticalRuns( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") int[] ystart, @Cast("l_int32*") int[] yend, @Cast("l_int32*") int[] pn );
public static native NUMA pixFindMaxRuns( PIX pix, @Cast("l_int32") int direction, @Cast("NUMA**") PointerPointer pnastart );
public static native NUMA pixFindMaxRuns( PIX pix, @Cast("l_int32") int direction, @ByPtrPtr NUMA pnastart );
public static native @Cast("l_ok") int pixFindMaxHorizontalRunOnLine( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer pxstart, @Cast("l_int32*") IntPointer psize );
public static native @Cast("l_ok") int pixFindMaxHorizontalRunOnLine( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer pxstart, @Cast("l_int32*") IntBuffer psize );
public static native @Cast("l_ok") int pixFindMaxHorizontalRunOnLine( PIX pix, @Cast("l_int32") int y, @Cast("l_int32*") int[] pxstart, @Cast("l_int32*") int[] psize );
public static native @Cast("l_ok") int pixFindMaxVerticalRunOnLine( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") IntPointer pystart, @Cast("l_int32*") IntPointer psize );
public static native @Cast("l_ok") int pixFindMaxVerticalRunOnLine( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") IntBuffer pystart, @Cast("l_int32*") IntBuffer psize );
public static native @Cast("l_ok") int pixFindMaxVerticalRunOnLine( PIX pix, @Cast("l_int32") int x, @Cast("l_int32*") int[] pystart, @Cast("l_int32*") int[] psize );
public static native @Cast("l_ok") int runlengthMembershipOnLine( @Cast("l_int32*") IntPointer buffer, @Cast("l_int32") int size, @Cast("l_int32") int depth, @Cast("l_int32*") IntPointer start, @Cast("l_int32*") IntPointer end, @Cast("l_int32") int n );
public static native @Cast("l_ok") int runlengthMembershipOnLine( @Cast("l_int32*") IntBuffer buffer, @Cast("l_int32") int size, @Cast("l_int32") int depth, @Cast("l_int32*") IntBuffer start, @Cast("l_int32*") IntBuffer end, @Cast("l_int32") int n );
public static native @Cast("l_ok") int runlengthMembershipOnLine( @Cast("l_int32*") int[] buffer, @Cast("l_int32") int size, @Cast("l_int32") int depth, @Cast("l_int32*") int[] start, @Cast("l_int32*") int[] end, @Cast("l_int32") int n );
public static native @Cast("l_int32*") IntPointer makeMSBitLocTab( @Cast("l_int32") int bitval );
public static native SARRAY sarrayCreate( @Cast("l_int32") int n );
public static native SARRAY sarrayCreateInitialized( @Cast("l_int32") int n, @Cast("const char*") BytePointer initstr );
public static native SARRAY sarrayCreateInitialized( @Cast("l_int32") int n, String initstr );
public static native SARRAY sarrayCreateWordsFromString( @Cast("const char*") BytePointer string );
public static native SARRAY sarrayCreateWordsFromString( String string );
public static native SARRAY sarrayCreateLinesFromString( @Cast("const char*") BytePointer string, @Cast("l_int32") int blankflag );
public static native SARRAY sarrayCreateLinesFromString( String string, @Cast("l_int32") int blankflag );
public static native void sarrayDestroy( @Cast("SARRAY**") PointerPointer psa );
public static native void sarrayDestroy( @ByPtrPtr SARRAY psa );
public static native SARRAY sarrayCopy( SARRAY sa );
public static native SARRAY sarrayClone( SARRAY sa );
public static native @Cast("l_ok") int sarrayAddString( SARRAY sa, @Cast("const char*") BytePointer string, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int sarrayAddString( SARRAY sa, String string, @Cast("l_int32") int copyflag );
public static native @Cast("char*") BytePointer sarrayRemoveString( SARRAY sa, @Cast("l_int32") int index );
public static native @Cast("l_ok") int sarrayReplaceString( SARRAY sa, @Cast("l_int32") int index, @Cast("char*") BytePointer newstr, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int sarrayReplaceString( SARRAY sa, @Cast("l_int32") int index, @Cast("char*") ByteBuffer newstr, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int sarrayReplaceString( SARRAY sa, @Cast("l_int32") int index, @Cast("char*") byte[] newstr, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int sarrayClear( SARRAY sa );
public static native @Cast("l_int32") int sarrayGetCount( SARRAY sa );
public static native @Cast("char**") PointerPointer sarrayGetArray( SARRAY sa, @Cast("l_int32*") IntPointer pnalloc, @Cast("l_int32*") IntPointer pn );
public static native @Cast("char**") @ByPtrPtr ByteBuffer sarrayGetArray( SARRAY sa, @Cast("l_int32*") IntBuffer pnalloc, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("char**") @ByPtrPtr byte[] sarrayGetArray( SARRAY sa, @Cast("l_int32*") int[] pnalloc, @Cast("l_int32*") int[] pn );
public static native @Cast("char*") BytePointer sarrayGetString( SARRAY sa, @Cast("l_int32") int index, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int sarrayGetRefcount( SARRAY sa );
public static native @Cast("l_ok") int sarrayChangeRefcount( SARRAY sa, @Cast("l_int32") int delta );
public static native @Cast("char*") BytePointer sarrayToString( SARRAY sa, @Cast("l_int32") int addnlflag );
public static native @Cast("char*") BytePointer sarrayToStringRange( SARRAY sa, @Cast("l_int32") int first, @Cast("l_int32") int nstrings, @Cast("l_int32") int addnlflag );
public static native SARRAY sarrayConcatUniformly( SARRAY sa, @Cast("l_int32") int n, @Cast("l_int32") int addnlflag );
public static native @Cast("l_ok") int sarrayJoin( SARRAY sa1, SARRAY sa2 );
public static native @Cast("l_ok") int sarrayAppendRange( SARRAY sa1, SARRAY sa2, @Cast("l_int32") int start, @Cast("l_int32") int end );
public static native @Cast("l_ok") int sarrayPadToSameSize( SARRAY sa1, SARRAY sa2, @Cast("const char*") BytePointer padstring );
public static native @Cast("l_ok") int sarrayPadToSameSize( SARRAY sa1, SARRAY sa2, String padstring );
public static native SARRAY sarrayConvertWordsToLines( SARRAY sa, @Cast("l_int32") int linesize );
public static native @Cast("l_int32") int sarraySplitString( SARRAY sa, @Cast("const char*") BytePointer str, @Cast("const char*") BytePointer separators );
public static native @Cast("l_int32") int sarraySplitString( SARRAY sa, String str, String separators );
public static native SARRAY sarraySelectBySubstring( SARRAY sain, @Cast("const char*") BytePointer substr );
public static native SARRAY sarraySelectBySubstring( SARRAY sain, String substr );
public static native SARRAY sarraySelectRange( SARRAY sain, @Cast("l_int32") int first, @Cast("l_int32") int last );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") IntPointer pactualstart, @Cast("l_int32*") IntPointer pend, @Cast("l_int32*") IntPointer pnewstart, @Cast("const char*") BytePointer substr, @Cast("l_int32") int loc );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") IntBuffer pactualstart, @Cast("l_int32*") IntBuffer pend, @Cast("l_int32*") IntBuffer pnewstart, String substr, @Cast("l_int32") int loc );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") int[] pactualstart, @Cast("l_int32*") int[] pend, @Cast("l_int32*") int[] pnewstart, @Cast("const char*") BytePointer substr, @Cast("l_int32") int loc );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") IntPointer pactualstart, @Cast("l_int32*") IntPointer pend, @Cast("l_int32*") IntPointer pnewstart, String substr, @Cast("l_int32") int loc );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") IntBuffer pactualstart, @Cast("l_int32*") IntBuffer pend, @Cast("l_int32*") IntBuffer pnewstart, @Cast("const char*") BytePointer substr, @Cast("l_int32") int loc );
public static native @Cast("l_int32") int sarrayParseRange( SARRAY sa, @Cast("l_int32") int start, @Cast("l_int32*") int[] pactualstart, @Cast("l_int32*") int[] pend, @Cast("l_int32*") int[] pnewstart, String substr, @Cast("l_int32") int loc );
public static native SARRAY sarrayRead( @Cast("const char*") BytePointer filename );
public static native SARRAY sarrayRead( String filename );
public static native SARRAY sarrayReadStream( @Cast("FILE*") Pointer fp );
public static native SARRAY sarrayReadMem( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native SARRAY sarrayReadMem( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native SARRAY sarrayReadMem( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int sarrayWrite( @Cast("const char*") BytePointer filename, SARRAY sa );
public static native @Cast("l_ok") int sarrayWrite( String filename, SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteStream( @Cast("FILE*") Pointer fp, SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteStderr( SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, SARRAY sa );
public static native @Cast("l_ok") int sarrayWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, SARRAY sa );
public static native @Cast("l_ok") int sarrayAppend( @Cast("const char*") BytePointer filename, SARRAY sa );
public static native @Cast("l_ok") int sarrayAppend( String filename, SARRAY sa );
public static native SARRAY getNumberedPathnamesInDirectory( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost, @Cast("l_int32") int maxnum );
public static native SARRAY getNumberedPathnamesInDirectory( String dirname, String substr, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost, @Cast("l_int32") int maxnum );
public static native SARRAY getSortedPathnamesInDirectory( @Cast("const char*") BytePointer dirname, @Cast("const char*") BytePointer substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native SARRAY getSortedPathnamesInDirectory( String dirname, String substr, @Cast("l_int32") int first, @Cast("l_int32") int nfiles );
public static native SARRAY convertSortedToNumberedPathnames( SARRAY sa, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost, @Cast("l_int32") int maxnum );
public static native SARRAY getFilenamesInDirectory( @Cast("const char*") BytePointer dirname );
public static native SARRAY getFilenamesInDirectory( String dirname );
public static native SARRAY sarraySort( SARRAY saout, SARRAY sain, @Cast("l_int32") int sortorder );
public static native SARRAY sarraySortByIndex( SARRAY sain, NUMA naindex );
public static native @Cast("l_int32") int stringCompareLexical( @Cast("const char*") BytePointer str1, @Cast("const char*") BytePointer str2 );
public static native @Cast("l_int32") int stringCompareLexical( String str1, String str2 );
public static native L_ASET l_asetCreateFromSarray( SARRAY sa );
public static native @Cast("l_ok") int sarrayRemoveDupsByAset( SARRAY sas, @Cast("SARRAY**") PointerPointer psad );
public static native @Cast("l_ok") int sarrayRemoveDupsByAset( SARRAY sas, @ByPtrPtr SARRAY psad );
public static native @Cast("l_ok") int sarrayUnionByAset( SARRAY sa1, SARRAY sa2, @Cast("SARRAY**") PointerPointer psad );
public static native @Cast("l_ok") int sarrayUnionByAset( SARRAY sa1, SARRAY sa2, @ByPtrPtr SARRAY psad );
public static native @Cast("l_ok") int sarrayIntersectionByAset( SARRAY sa1, SARRAY sa2, @Cast("SARRAY**") PointerPointer psad );
public static native @Cast("l_ok") int sarrayIntersectionByAset( SARRAY sa1, SARRAY sa2, @ByPtrPtr SARRAY psad );
public static native L_HASHMAP l_hmapCreateFromSarray( SARRAY sa );
public static native @Cast("l_ok") int sarrayRemoveDupsByHmap( SARRAY sas, @Cast("SARRAY**") PointerPointer psad, @Cast("L_HASHMAP**") PointerPointer phmap );
public static native @Cast("l_ok") int sarrayRemoveDupsByHmap( SARRAY sas, @ByPtrPtr SARRAY psad, @ByPtrPtr L_HASHMAP phmap );
public static native @Cast("l_ok") int sarrayUnionByHmap( SARRAY sa1, SARRAY sa2, @Cast("SARRAY**") PointerPointer psad );
public static native @Cast("l_ok") int sarrayUnionByHmap( SARRAY sa1, SARRAY sa2, @ByPtrPtr SARRAY psad );
public static native @Cast("l_ok") int sarrayIntersectionByHmap( SARRAY sa1, SARRAY sa2, @Cast("SARRAY**") PointerPointer psad );
public static native @Cast("l_ok") int sarrayIntersectionByHmap( SARRAY sa1, SARRAY sa2, @ByPtrPtr SARRAY psad );
public static native SARRAY sarrayGenerateIntegers( @Cast("l_int32") int n );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, @Cast("const char*") BytePointer keystring, @Cast("char**") PointerPointer pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, @Cast("const char*") BytePointer keystring, @Cast("char**") @ByPtrPtr BytePointer pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, String keystring, @Cast("char**") @ByPtrPtr ByteBuffer pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, @Cast("const char*") BytePointer keystring, @Cast("char**") @ByPtrPtr byte[] pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, String keystring, @Cast("char**") @ByPtrPtr BytePointer pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, @Cast("const char*") BytePointer keystring, @Cast("char**") @ByPtrPtr ByteBuffer pvalstring );
public static native @Cast("l_ok") int sarrayLookupCSKV( SARRAY sa, String keystring, @Cast("char**") @ByPtrPtr byte[] pvalstring );
public static native PIX pixScale( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleToSizeRel( PIX pixs, @Cast("l_int32") int delw, @Cast("l_int32") int delh );
public static native PIX pixScaleToSize( PIX pixs, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIX pixScaleToResolution( PIX pixs, @Cast("l_float32") float target, @Cast("l_float32") float assumed, @Cast("l_float32*") FloatPointer pscalefact );
public static native PIX pixScaleToResolution( PIX pixs, @Cast("l_float32") float target, @Cast("l_float32") float assumed, @Cast("l_float32*") FloatBuffer pscalefact );
public static native PIX pixScaleToResolution( PIX pixs, @Cast("l_float32") float target, @Cast("l_float32") float assumed, @Cast("l_float32*") float[] pscalefact );
public static native PIX pixScaleGeneral( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, @Cast("l_float32") float sharpfract, @Cast("l_int32") int sharpwidth );
public static native PIX pixScaleLI( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleColorLI( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleColor2xLI( PIX pixs );
public static native PIX pixScaleColor4xLI( PIX pixs );
public static native PIX pixScaleGrayLI( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleGray2xLI( PIX pixs );
public static native PIX pixScaleGray4xLI( PIX pixs );
public static native PIX pixScaleGray2xLIThresh( PIX pixs, @Cast("l_int32") int thresh );
public static native PIX pixScaleGray2xLIDither( PIX pixs );
public static native PIX pixScaleGray4xLIThresh( PIX pixs, @Cast("l_int32") int thresh );
public static native PIX pixScaleGray4xLIDither( PIX pixs );
public static native PIX pixScaleBySampling( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleBySamplingToSize( PIX pixs, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIX pixScaleByIntSampling( PIX pixs, @Cast("l_int32") int factor );
public static native PIX pixScaleRGBToGrayFast( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int color );
public static native PIX pixScaleRGBToBinaryFast( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int thresh );
public static native PIX pixScaleGrayToBinaryFast( PIX pixs, @Cast("l_int32") int factor, @Cast("l_int32") int thresh );
public static native PIX pixScaleSmooth( PIX pix, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleSmoothToSize( PIX pixs, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIX pixScaleRGBToGray2( PIX pixs, @Cast("l_float32") float rwt, @Cast("l_float32") float gwt, @Cast("l_float32") float bwt );
public static native PIX pixScaleAreaMap( PIX pix, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleAreaMap2( PIX pix );
public static native PIX pixScaleAreaMapToSize( PIX pixs, @Cast("l_int32") int wd, @Cast("l_int32") int hd );
public static native PIX pixScaleBinary( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleToGray( PIX pixs, @Cast("l_float32") float scalefactor );
public static native PIX pixScaleToGrayFast( PIX pixs, @Cast("l_float32") float scalefactor );
public static native PIX pixScaleToGray2( PIX pixs );
public static native PIX pixScaleToGray3( PIX pixs );
public static native PIX pixScaleToGray4( PIX pixs );
public static native PIX pixScaleToGray6( PIX pixs );
public static native PIX pixScaleToGray8( PIX pixs );
public static native PIX pixScaleToGray16( PIX pixs );
public static native PIX pixScaleToGrayMipmap( PIX pixs, @Cast("l_float32") float scalefactor );
public static native PIX pixScaleMipmap( PIX pixs1, PIX pixs2, @Cast("l_float32") float scale );
public static native PIX pixExpandReplicate( PIX pixs, @Cast("l_int32") int factor );
public static native PIX pixScaleGrayMinMax( PIX pixs, @Cast("l_int32") int xfact, @Cast("l_int32") int yfact, @Cast("l_int32") int type );
public static native PIX pixScaleGrayMinMax2( PIX pixs, @Cast("l_int32") int type );
public static native PIX pixScaleGrayRankCascade( PIX pixs, @Cast("l_int32") int level1, @Cast("l_int32") int level2, @Cast("l_int32") int level3, @Cast("l_int32") int level4 );
public static native PIX pixScaleGrayRank2( PIX pixs, @Cast("l_int32") int rank );
public static native @Cast("l_ok") int pixScaleAndTransferAlpha( PIX pixd, PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley );
public static native PIX pixScaleWithAlpha( PIX pixs, @Cast("l_float32") float scalex, @Cast("l_float32") float scaley, PIX pixg, @Cast("l_float32") float fract );
public static native PIX pixSeedfillBinary( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int connectivity );
public static native PIX pixSeedfillBinaryRestricted( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int connectivity, @Cast("l_int32") int xmax, @Cast("l_int32") int ymax );
public static native PIX pixHolesByFilling( PIX pixs, @Cast("l_int32") int connectivity );
public static native PIX pixFillClosedBorders( PIX pixs, @Cast("l_int32") int connectivity );
public static native PIX pixExtractBorderConnComps( PIX pixs, @Cast("l_int32") int connectivity );
public static native PIX pixRemoveBorderConnComps( PIX pixs, @Cast("l_int32") int connectivity );
public static native PIX pixFillBgFromBorder( PIX pixs, @Cast("l_int32") int connectivity );
public static native PIX pixFillHolesToBoundingRect( PIX pixs, @Cast("l_int32") int minsize, @Cast("l_float32") float maxhfract, @Cast("l_float32") float minfgfract );
public static native @Cast("l_ok") int pixSeedfillGray( PIX pixs, PIX pixm, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixSeedfillGrayInv( PIX pixs, PIX pixm, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixSeedfillGraySimple( PIX pixs, PIX pixm, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixSeedfillGrayInvSimple( PIX pixs, PIX pixm, @Cast("l_int32") int connectivity );
public static native PIX pixSeedfillGrayBasin( PIX pixb, PIX pixm, @Cast("l_int32") int delta, @Cast("l_int32") int connectivity );
public static native PIX pixDistanceFunction( PIX pixs, @Cast("l_int32") int connectivity, @Cast("l_int32") int outdepth, @Cast("l_int32") int boundcond );
public static native PIX pixSeedspread( PIX pixs, @Cast("l_int32") int connectivity );
public static native @Cast("l_ok") int pixLocalExtrema( PIX pixs, @Cast("l_int32") int maxmin, @Cast("l_int32") int minmax, @Cast("PIX**") PointerPointer ppixmin, @Cast("PIX**") PointerPointer ppixmax );
public static native @Cast("l_ok") int pixLocalExtrema( PIX pixs, @Cast("l_int32") int maxmin, @Cast("l_int32") int minmax, @ByPtrPtr PIX ppixmin, @ByPtrPtr PIX ppixmax );
public static native @Cast("l_ok") int pixSelectedLocalExtrema( PIX pixs, @Cast("l_int32") int mindist, @Cast("PIX**") PointerPointer ppixmin, @Cast("PIX**") PointerPointer ppixmax );
public static native @Cast("l_ok") int pixSelectedLocalExtrema( PIX pixs, @Cast("l_int32") int mindist, @ByPtrPtr PIX ppixmin, @ByPtrPtr PIX ppixmax );
public static native PIX pixFindEqualValues( PIX pixs1, PIX pixs2 );
public static native @Cast("l_ok") int pixSelectMinInConnComp( PIX pixs, PIX pixm, @Cast("PTA**") PointerPointer ppta, @Cast("NUMA**") PointerPointer pnav );
public static native @Cast("l_ok") int pixSelectMinInConnComp( PIX pixs, PIX pixm, @ByPtrPtr PTA ppta, @ByPtrPtr NUMA pnav );
public static native PIX pixRemoveSeededComponents( PIX pixd, PIX pixs, PIX pixm, @Cast("l_int32") int connectivity, @Cast("l_int32") int bordersize );
public static native SELA selaCreate( @Cast("l_int32") int n );
public static native void selaDestroy( @Cast("SELA**") PointerPointer psela );
public static native void selaDestroy( @ByPtrPtr SELA psela );
public static native SEL selCreate( @Cast("l_int32") int height, @Cast("l_int32") int width, @Cast("const char*") BytePointer name );
public static native SEL selCreate( @Cast("l_int32") int height, @Cast("l_int32") int width, String name );
public static native void selDestroy( @Cast("SEL**") PointerPointer psel );
public static native void selDestroy( @ByPtrPtr SEL psel );
public static native SEL selCopy( SEL sel );
public static native SEL selCreateBrick( @Cast("l_int32") int h, @Cast("l_int32") int w, @Cast("l_int32") int cy, @Cast("l_int32") int cx, @Cast("l_int32") int type );
public static native SEL selCreateComb( @Cast("l_int32") int factor1, @Cast("l_int32") int factor2, @Cast("l_int32") int direction );
public static native @Cast("l_int32**") PointerPointer create2dIntArray( @Cast("l_int32") int sy, @Cast("l_int32") int sx );
public static native @Cast("l_ok") int selaAddSel( SELA sela, SEL sel, @Cast("const char*") BytePointer selname, @Cast("l_int32") int copyflag );
public static native @Cast("l_ok") int selaAddSel( SELA sela, SEL sel, String selname, @Cast("l_int32") int copyflag );
public static native @Cast("l_int32") int selaGetCount( SELA sela );
public static native SEL selaGetSel( SELA sela, @Cast("l_int32") int i );
public static native @Cast("char*") BytePointer selGetName( SEL sel );
public static native @Cast("l_ok") int selSetName( SEL sel, @Cast("const char*") BytePointer name );
public static native @Cast("l_ok") int selSetName( SEL sel, String name );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, @Cast("const char*") BytePointer name, @Cast("l_int32*") IntPointer pindex, @Cast("SEL**") PointerPointer psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, @Cast("const char*") BytePointer name, @Cast("l_int32*") IntPointer pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, String name, @Cast("l_int32*") IntBuffer pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, @Cast("const char*") BytePointer name, @Cast("l_int32*") int[] pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, String name, @Cast("l_int32*") IntPointer pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, @Cast("const char*") BytePointer name, @Cast("l_int32*") IntBuffer pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selaFindSelByName( SELA sela, String name, @Cast("l_int32*") int[] pindex, @ByPtrPtr SEL psel );
public static native @Cast("l_ok") int selGetElement( SEL sel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_int32*") IntPointer ptype );
public static native @Cast("l_ok") int selGetElement( SEL sel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_int32*") IntBuffer ptype );
public static native @Cast("l_ok") int selGetElement( SEL sel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_int32*") int[] ptype );
public static native @Cast("l_ok") int selSetElement( SEL sel, @Cast("l_int32") int row, @Cast("l_int32") int col, @Cast("l_int32") int type );
public static native @Cast("l_ok") int selGetParameters( SEL sel, @Cast("l_int32*") IntPointer psy, @Cast("l_int32*") IntPointer psx, @Cast("l_int32*") IntPointer pcy, @Cast("l_int32*") IntPointer pcx );
public static native @Cast("l_ok") int selGetParameters( SEL sel, @Cast("l_int32*") IntBuffer psy, @Cast("l_int32*") IntBuffer psx, @Cast("l_int32*") IntBuffer pcy, @Cast("l_int32*") IntBuffer pcx );
public static native @Cast("l_ok") int selGetParameters( SEL sel, @Cast("l_int32*") int[] psy, @Cast("l_int32*") int[] psx, @Cast("l_int32*") int[] pcy, @Cast("l_int32*") int[] pcx );
public static native @Cast("l_ok") int selSetOrigin( SEL sel, @Cast("l_int32") int cy, @Cast("l_int32") int cx );
public static native @Cast("l_ok") int selGetTypeAtOrigin( SEL sel, @Cast("l_int32*") IntPointer ptype );
public static native @Cast("l_ok") int selGetTypeAtOrigin( SEL sel, @Cast("l_int32*") IntBuffer ptype );
public static native @Cast("l_ok") int selGetTypeAtOrigin( SEL sel, @Cast("l_int32*") int[] ptype );
public static native @Cast("char*") BytePointer selaGetBrickName( SELA sela, @Cast("l_int32") int hsize, @Cast("l_int32") int vsize );
public static native @Cast("char*") BytePointer selaGetCombName( SELA sela, @Cast("l_int32") int size, @Cast("l_int32") int direction );
public static native @Cast("l_ok") int getCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") IntPointer psize1, @Cast("l_int32*") IntPointer psize2, @Cast("char**") PointerPointer pnameh1, @Cast("char**") PointerPointer pnameh2, @Cast("char**") PointerPointer pnamev1, @Cast("char**") PointerPointer pnamev2 );
public static native @Cast("l_ok") int getCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") IntPointer psize1, @Cast("l_int32*") IntPointer psize2, @Cast("char**") @ByPtrPtr BytePointer pnameh1, @Cast("char**") @ByPtrPtr BytePointer pnameh2, @Cast("char**") @ByPtrPtr BytePointer pnamev1, @Cast("char**") @ByPtrPtr BytePointer pnamev2 );
public static native @Cast("l_ok") int getCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") IntBuffer psize1, @Cast("l_int32*") IntBuffer psize2, @Cast("char**") @ByPtrPtr ByteBuffer pnameh1, @Cast("char**") @ByPtrPtr ByteBuffer pnameh2, @Cast("char**") @ByPtrPtr ByteBuffer pnamev1, @Cast("char**") @ByPtrPtr ByteBuffer pnamev2 );
public static native @Cast("l_ok") int getCompositeParameters( @Cast("l_int32") int size, @Cast("l_int32*") int[] psize1, @Cast("l_int32*") int[] psize2, @Cast("char**") @ByPtrPtr byte[] pnameh1, @Cast("char**") @ByPtrPtr byte[] pnameh2, @Cast("char**") @ByPtrPtr byte[] pnamev1, @Cast("char**") @ByPtrPtr byte[] pnamev2 );
public static native SARRAY selaGetSelnames( SELA sela );
public static native @Cast("l_ok") int selFindMaxTranslations( SEL sel, @Cast("l_int32*") IntPointer pxp, @Cast("l_int32*") IntPointer pyp, @Cast("l_int32*") IntPointer pxn, @Cast("l_int32*") IntPointer pyn );
public static native @Cast("l_ok") int selFindMaxTranslations( SEL sel, @Cast("l_int32*") IntBuffer pxp, @Cast("l_int32*") IntBuffer pyp, @Cast("l_int32*") IntBuffer pxn, @Cast("l_int32*") IntBuffer pyn );
public static native @Cast("l_ok") int selFindMaxTranslations( SEL sel, @Cast("l_int32*") int[] pxp, @Cast("l_int32*") int[] pyp, @Cast("l_int32*") int[] pxn, @Cast("l_int32*") int[] pyn );
public static native SEL selRotateOrth( SEL sel, @Cast("l_int32") int quads );
public static native SELA selaRead( @Cast("const char*") BytePointer fname );
public static native SELA selaRead( String fname );
public static native SELA selaReadStream( @Cast("FILE*") Pointer fp );
public static native SEL selRead( @Cast("const char*") BytePointer fname );
public static native SEL selRead( String fname );
public static native SEL selReadStream( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int selaWrite( @Cast("const char*") BytePointer fname, SELA sela );
public static native @Cast("l_ok") int selaWrite( String fname, SELA sela );
public static native @Cast("l_ok") int selaWriteStream( @Cast("FILE*") Pointer fp, SELA sela );
public static native @Cast("l_ok") int selWrite( @Cast("const char*") BytePointer fname, SEL sel );
public static native @Cast("l_ok") int selWrite( String fname, SEL sel );
public static native @Cast("l_ok") int selWriteStream( @Cast("FILE*") Pointer fp, SEL sel );
public static native SEL selCreateFromString( @Cast("const char*") BytePointer text, @Cast("l_int32") int h, @Cast("l_int32") int w, @Cast("const char*") BytePointer name );
public static native SEL selCreateFromString( String text, @Cast("l_int32") int h, @Cast("l_int32") int w, String name );
public static native @Cast("char*") BytePointer selPrintToString( SEL sel );
public static native SELA selaCreateFromFile( @Cast("const char*") BytePointer filename );
public static native SELA selaCreateFromFile( String filename );
public static native SEL selCreateFromPta( PTA pta, @Cast("l_int32") int cy, @Cast("l_int32") int cx, @Cast("const char*") BytePointer name );
public static native SEL selCreateFromPta( PTA pta, @Cast("l_int32") int cy, @Cast("l_int32") int cx, String name );
public static native SEL selCreateFromPix( PIX pix, @Cast("l_int32") int cy, @Cast("l_int32") int cx, @Cast("const char*") BytePointer name );
public static native SEL selCreateFromPix( PIX pix, @Cast("l_int32") int cy, @Cast("l_int32") int cx, String name );
public static native SEL selReadFromColorImage( @Cast("const char*") BytePointer pathname );
public static native SEL selReadFromColorImage( String pathname );
public static native SEL selCreateFromColorPix( PIX pixs, @Cast("const char*") BytePointer selname );
public static native SEL selCreateFromColorPix( PIX pixs, String selname );
public static native SELA selaCreateFromColorPixa( PIXA pixa, SARRAY sa );
public static native PIX selDisplayInPix( SEL sel, @Cast("l_int32") int size, @Cast("l_int32") int gthick );
public static native PIX selaDisplayInPix( SELA sela, @Cast("l_int32") int size, @Cast("l_int32") int gthick, @Cast("l_int32") int spacing, @Cast("l_int32") int ncols );
public static native SELA selaAddBasic( SELA sela );
public static native SELA selaAddHitMiss( SELA sela );
public static native SELA selaAddDwaLinear( SELA sela );
public static native SELA selaAddDwaCombs( SELA sela );
public static native SELA selaAddCrossJunctions( SELA sela, @Cast("l_float32") float hlsize, @Cast("l_float32") float mdist, @Cast("l_int32") int norient, @Cast("l_int32") int debugflag );
public static native SELA selaAddTJunctions( SELA sela, @Cast("l_float32") float hlsize, @Cast("l_float32") float mdist, @Cast("l_int32") int norient, @Cast("l_int32") int debugflag );
public static native SELA sela4ccThin( SELA sela );
public static native SELA sela8ccThin( SELA sela );
public static native SELA sela4and8ccThin( SELA sela );
public static native SEL selMakePlusSign( @Cast("l_int32") int size, @Cast("l_int32") int linewidth );
public static native SEL pixGenerateSelWithRuns( PIX pixs, @Cast("l_int32") int nhlines, @Cast("l_int32") int nvlines, @Cast("l_int32") int distance, @Cast("l_int32") int minlength, @Cast("l_int32") int toppix, @Cast("l_int32") int botpix, @Cast("l_int32") int leftpix, @Cast("l_int32") int rightpix, @Cast("PIX**") PointerPointer ppixe );
public static native SEL pixGenerateSelWithRuns( PIX pixs, @Cast("l_int32") int nhlines, @Cast("l_int32") int nvlines, @Cast("l_int32") int distance, @Cast("l_int32") int minlength, @Cast("l_int32") int toppix, @Cast("l_int32") int botpix, @Cast("l_int32") int leftpix, @Cast("l_int32") int rightpix, @ByPtrPtr PIX ppixe );
public static native SEL pixGenerateSelRandom( PIX pixs, @Cast("l_float32") float hitfract, @Cast("l_float32") float missfract, @Cast("l_int32") int distance, @Cast("l_int32") int toppix, @Cast("l_int32") int botpix, @Cast("l_int32") int leftpix, @Cast("l_int32") int rightpix, @Cast("PIX**") PointerPointer ppixe );
public static native SEL pixGenerateSelRandom( PIX pixs, @Cast("l_float32") float hitfract, @Cast("l_float32") float missfract, @Cast("l_int32") int distance, @Cast("l_int32") int toppix, @Cast("l_int32") int botpix, @Cast("l_int32") int leftpix, @Cast("l_int32") int rightpix, @ByPtrPtr PIX ppixe );
public static native SEL pixGenerateSelBoundary( PIX pixs, @Cast("l_int32") int hitdist, @Cast("l_int32") int missdist, @Cast("l_int32") int hitskip, @Cast("l_int32") int missskip, @Cast("l_int32") int topflag, @Cast("l_int32") int botflag, @Cast("l_int32") int leftflag, @Cast("l_int32") int rightflag, @Cast("PIX**") PointerPointer ppixe );
public static native SEL pixGenerateSelBoundary( PIX pixs, @Cast("l_int32") int hitdist, @Cast("l_int32") int missdist, @Cast("l_int32") int hitskip, @Cast("l_int32") int missskip, @Cast("l_int32") int topflag, @Cast("l_int32") int botflag, @Cast("l_int32") int leftflag, @Cast("l_int32") int rightflag, @ByPtrPtr PIX ppixe );
public static native NUMA pixGetRunCentersOnLine( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32") int minlength );
public static native NUMA pixGetRunsOnLine( PIX pixs, @Cast("l_int32") int x1, @Cast("l_int32") int y1, @Cast("l_int32") int x2, @Cast("l_int32") int y2 );
public static native PTA pixSubsampleBoundaryPixels( PIX pixs, @Cast("l_int32") int skip );
public static native @Cast("l_int32") int adjacentOnPixelInRaster( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntPointer pxa, @Cast("l_int32*") IntPointer pya );
public static native @Cast("l_int32") int adjacentOnPixelInRaster( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") IntBuffer pxa, @Cast("l_int32*") IntBuffer pya );
public static native @Cast("l_int32") int adjacentOnPixelInRaster( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_int32*") int[] pxa, @Cast("l_int32*") int[] pya );
public static native PIX pixDisplayHitMissSel( PIX pixs, SEL sel, @Cast("l_int32") int scalefactor, @Cast("l_uint32") int hitcolor, @Cast("l_uint32") int misscolor );
public static native PIX pixHShear( PIX pixd, PIX pixs, @Cast("l_int32") int yloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixVShear( PIX pixd, PIX pixs, @Cast("l_int32") int xloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixHShearCorner( PIX pixd, PIX pixs, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixVShearCorner( PIX pixd, PIX pixs, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixHShearCenter( PIX pixd, PIX pixs, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixVShearCenter( PIX pixd, PIX pixs, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixHShearIP( PIX pixs, @Cast("l_int32") int yloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native @Cast("l_ok") int pixVShearIP( PIX pixs, @Cast("l_int32") int xloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixHShearLI( PIX pixs, @Cast("l_int32") int yloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixVShearLI( PIX pixs, @Cast("l_int32") int xloc, @Cast("l_float32") float radang, @Cast("l_int32") int incolor );
public static native PIX pixDeskewBoth( PIX pixs, @Cast("l_int32") int redsearch );
public static native PIX pixDeskew( PIX pixs, @Cast("l_int32") int redsearch );
public static native PIX pixFindSkewAndDeskew( PIX pixs, @Cast("l_int32") int redsearch, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf );
public static native PIX pixFindSkewAndDeskew( PIX pixs, @Cast("l_int32") int redsearch, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf );
public static native PIX pixFindSkewAndDeskew( PIX pixs, @Cast("l_int32") int redsearch, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf );
public static native PIX pixDeskewGeneral( PIX pixs, @Cast("l_int32") int redsweep, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_int32") int redsearch, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf );
public static native PIX pixDeskewGeneral( PIX pixs, @Cast("l_int32") int redsweep, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_int32") int redsearch, @Cast("l_int32") int thresh, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf );
public static native PIX pixDeskewGeneral( PIX pixs, @Cast("l_int32") int redsweep, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_int32") int redsearch, @Cast("l_int32") int thresh, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf );
public static native @Cast("l_ok") int pixFindSkew( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf );
public static native @Cast("l_ok") int pixFindSkew( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf );
public static native @Cast("l_ok") int pixFindSkew( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf );
public static native @Cast("l_ok") int pixFindSkewSweep( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_int32") int reduction, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta );
public static native @Cast("l_ok") int pixFindSkewSweep( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_int32") int reduction, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta );
public static native @Cast("l_ok") int pixFindSkewSweep( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_int32") int reduction, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearch( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearch( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearch( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScore( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf, @Cast("l_float32*") FloatPointer pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScore( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_float32*") FloatBuffer pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScore( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf, @Cast("l_float32*") float[] pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScorePivot( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf, @Cast("l_float32*") FloatPointer pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_int32") int pivot );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScorePivot( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_float32*") FloatBuffer pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_int32") int pivot );
public static native @Cast("l_ok") int pixFindSkewSweepAndSearchScorePivot( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf, @Cast("l_float32*") float[] pendscore, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweepcenter, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_int32") int pivot );
public static native @Cast("l_int32") int pixFindSkewOrthogonalRange( PIX pixs, @Cast("l_float32*") FloatPointer pangle, @Cast("l_float32*") FloatPointer pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32") float confprior );
public static native @Cast("l_int32") int pixFindSkewOrthogonalRange( PIX pixs, @Cast("l_float32*") FloatBuffer pangle, @Cast("l_float32*") FloatBuffer pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32") float confprior );
public static native @Cast("l_int32") int pixFindSkewOrthogonalRange( PIX pixs, @Cast("l_float32*") float[] pangle, @Cast("l_float32*") float[] pconf, @Cast("l_int32") int redsweep, @Cast("l_int32") int redsearch, @Cast("l_float32") float sweeprange, @Cast("l_float32") float sweepdelta, @Cast("l_float32") float minbsdelta, @Cast("l_float32") float confprior );
public static native @Cast("l_ok") int pixFindDifferentialSquareSum( PIX pixs, @Cast("l_float32*") FloatPointer psum );
public static native @Cast("l_ok") int pixFindDifferentialSquareSum( PIX pixs, @Cast("l_float32*") FloatBuffer psum );
public static native @Cast("l_ok") int pixFindDifferentialSquareSum( PIX pixs, @Cast("l_float32*") float[] psum );
public static native @Cast("l_ok") int pixFindNormalizedSquareSum( PIX pixs, @Cast("l_float32*") FloatPointer phratio, @Cast("l_float32*") FloatPointer pvratio, @Cast("l_float32*") FloatPointer pfract );
public static native @Cast("l_ok") int pixFindNormalizedSquareSum( PIX pixs, @Cast("l_float32*") FloatBuffer phratio, @Cast("l_float32*") FloatBuffer pvratio, @Cast("l_float32*") FloatBuffer pfract );
public static native @Cast("l_ok") int pixFindNormalizedSquareSum( PIX pixs, @Cast("l_float32*") float[] phratio, @Cast("l_float32*") float[] pvratio, @Cast("l_float32*") float[] pfract );
public static native PIX pixReadStreamSpix( @Cast("FILE*") Pointer fp );
public static native @Cast("l_ok") int readHeaderSpix( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer pheight, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int readHeaderSpix( String filename, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer pheight, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int readHeaderSpix( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] pheight, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int readHeaderSpix( String filename, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer pheight, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int readHeaderSpix( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer pheight, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int readHeaderSpix( String filename, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] pheight, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int freadHeaderSpix( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer pheight, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int freadHeaderSpix( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer pheight, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int freadHeaderSpix( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] pheight, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int sreadHeaderSpix( @Cast("const l_uint32*") IntPointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer pheight, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer piscmap );
public static native @Cast("l_ok") int sreadHeaderSpix( @Cast("const l_uint32*") IntBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer pheight, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer piscmap );
public static native @Cast("l_ok") int sreadHeaderSpix( @Cast("const l_uint32*") int[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] pheight, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] piscmap );
public static native @Cast("l_ok") int pixWriteStreamSpix( @Cast("FILE*") Pointer fp, PIX pix );
public static native PIX pixReadMemSpix( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIX pixReadMemSpix( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIX pixReadMemSpix( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixWriteMemSpix( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemSpix( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemSpix( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixWriteMemSpix( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix );
public static native @Cast("l_ok") int pixSerializeToMemory( PIX pixs, @Cast("l_uint32**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixSerializeToMemory( PIX pixs, @Cast("l_uint32**") @ByPtrPtr IntPointer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixSerializeToMemory( PIX pixs, @Cast("l_uint32**") @ByPtrPtr IntBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_ok") int pixSerializeToMemory( PIX pixs, @Cast("l_uint32**") @ByPtrPtr int[] pdata, @Cast("size_t*") SizeTPointer pnbytes );
public static native PIX pixDeserializeFromMemory( @Cast("const l_uint32*") IntPointer data, @Cast("size_t") long nbytes );
public static native PIX pixDeserializeFromMemory( @Cast("const l_uint32*") IntBuffer data, @Cast("size_t") long nbytes );
public static native PIX pixDeserializeFromMemory( @Cast("const l_uint32*") int[] data, @Cast("size_t") long nbytes );
public static native L_STACK lstackCreate( @Cast("l_int32") int n );
public static native void lstackDestroy( @Cast("L_STACK**") PointerPointer plstack, @Cast("l_int32") int freeflag );
public static native void lstackDestroy( @ByPtrPtr L_STACK plstack, @Cast("l_int32") int freeflag );
public static native @Cast("l_ok") int lstackAdd( L_STACK lstack, Pointer item );
public static native Pointer lstackRemove( L_STACK lstack );
public static native @Cast("l_int32") int lstackGetCount( L_STACK lstack );
public static native @Cast("l_ok") int lstackPrint( @Cast("FILE*") Pointer fp, L_STACK lstack );
public static native L_STRCODE strcodeCreate( @Cast("l_int32") int fileno );
public static native @Cast("l_ok") int strcodeCreateFromFile( @Cast("const char*") BytePointer filein, @Cast("l_int32") int fileno, @Cast("const char*") BytePointer outdir );
public static native @Cast("l_ok") int strcodeCreateFromFile( String filein, @Cast("l_int32") int fileno, String outdir );
public static native @Cast("l_ok") int strcodeGenerate( L_STRCODE strcode, @Cast("const char*") BytePointer filein, @Cast("const char*") BytePointer type );
public static native @Cast("l_ok") int strcodeGenerate( L_STRCODE strcode, String filein, String type );
public static native @Cast("l_int32") int strcodeFinalize( @Cast("L_STRCODE**") PointerPointer pstrcode, @Cast("const char*") BytePointer outdir );
public static native @Cast("l_int32") int strcodeFinalize( @ByPtrPtr L_STRCODE pstrcode, @Cast("const char*") BytePointer outdir );
public static native @Cast("l_int32") int strcodeFinalize( @ByPtrPtr L_STRCODE pstrcode, String outdir );
public static native @Cast("l_int32") int l_getStructStrFromFile( @Cast("const char*") BytePointer filename, @Cast("l_int32") int field, @Cast("char**") PointerPointer pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( @Cast("const char*") BytePointer filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr BytePointer pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( String filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr ByteBuffer pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( @Cast("const char*") BytePointer filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr byte[] pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( String filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr BytePointer pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( @Cast("const char*") BytePointer filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr ByteBuffer pstr );
public static native @Cast("l_int32") int l_getStructStrFromFile( String filename, @Cast("l_int32") int field, @Cast("char**") @ByPtrPtr byte[] pstr );
public static native @Cast("l_ok") int pixFindStrokeLength( PIX pixs, @Cast("l_int32*") IntPointer tab8, @Cast("l_int32*") IntPointer plength );
public static native @Cast("l_ok") int pixFindStrokeLength( PIX pixs, @Cast("l_int32*") IntBuffer tab8, @Cast("l_int32*") IntBuffer plength );
public static native @Cast("l_ok") int pixFindStrokeLength( PIX pixs, @Cast("l_int32*") int[] tab8, @Cast("l_int32*") int[] plength );
public static native @Cast("l_ok") int pixFindStrokeWidth( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32*") IntPointer tab8, @Cast("l_float32*") FloatPointer pwidth, @Cast("NUMA**") PointerPointer pnahisto );
public static native @Cast("l_ok") int pixFindStrokeWidth( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32*") IntPointer tab8, @Cast("l_float32*") FloatPointer pwidth, @ByPtrPtr NUMA pnahisto );
public static native @Cast("l_ok") int pixFindStrokeWidth( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32*") IntBuffer tab8, @Cast("l_float32*") FloatBuffer pwidth, @ByPtrPtr NUMA pnahisto );
public static native @Cast("l_ok") int pixFindStrokeWidth( PIX pixs, @Cast("l_float32") float thresh, @Cast("l_int32*") int[] tab8, @Cast("l_float32*") float[] pwidth, @ByPtrPtr NUMA pnahisto );
public static native NUMA pixaFindStrokeWidth( PIXA pixa, @Cast("l_float32") float thresh, @Cast("l_int32*") IntPointer tab8, @Cast("l_int32") int debug );
public static native NUMA pixaFindStrokeWidth( PIXA pixa, @Cast("l_float32") float thresh, @Cast("l_int32*") IntBuffer tab8, @Cast("l_int32") int debug );
public static native NUMA pixaFindStrokeWidth( PIXA pixa, @Cast("l_float32") float thresh, @Cast("l_int32*") int[] tab8, @Cast("l_int32") int debug );
public static native PIXA pixaModifyStrokeWidth( PIXA pixas, @Cast("l_float32") float targetw );
public static native PIX pixModifyStrokeWidth( PIX pixs, @Cast("l_float32") float width, @Cast("l_float32") float targetw );
public static native PIXA pixaSetStrokeWidth( PIXA pixas, @Cast("l_int32") int width, @Cast("l_int32") int thinfirst, @Cast("l_int32") int connectivity );
public static native PIX pixSetStrokeWidth( PIX pixs, @Cast("l_int32") int width, @Cast("l_int32") int thinfirst, @Cast("l_int32") int connectivity );
public static native @Cast("l_int32*") IntPointer sudokuReadFile( @Cast("const char*") BytePointer filename );
public static native @Cast("l_int32*") IntBuffer sudokuReadFile( String filename );
public static native @Cast("l_int32*") IntPointer sudokuReadString( @Cast("const char*") BytePointer str );
public static native @Cast("l_int32*") IntBuffer sudokuReadString( String str );
public static native L_SUDOKU sudokuCreate( @Cast("l_int32*") IntPointer array );
public static native L_SUDOKU sudokuCreate( @Cast("l_int32*") IntBuffer array );
public static native L_SUDOKU sudokuCreate( @Cast("l_int32*") int[] array );
public static native void sudokuDestroy( @Cast("L_SUDOKU**") PointerPointer psud );
public static native void sudokuDestroy( @ByPtrPtr L_SUDOKU psud );
public static native @Cast("l_int32") int sudokuSolve( L_SUDOKU sud );
public static native @Cast("l_ok") int sudokuTestUniqueness( @Cast("l_int32*") IntPointer array, @Cast("l_int32*") IntPointer punique );
public static native @Cast("l_ok") int sudokuTestUniqueness( @Cast("l_int32*") IntBuffer array, @Cast("l_int32*") IntBuffer punique );
public static native @Cast("l_ok") int sudokuTestUniqueness( @Cast("l_int32*") int[] array, @Cast("l_int32*") int[] punique );
public static native L_SUDOKU sudokuGenerate( @Cast("l_int32*") IntPointer array, @Cast("l_int32") int seed, @Cast("l_int32") int minelems, @Cast("l_int32") int maxtries );
public static native L_SUDOKU sudokuGenerate( @Cast("l_int32*") IntBuffer array, @Cast("l_int32") int seed, @Cast("l_int32") int minelems, @Cast("l_int32") int maxtries );
public static native L_SUDOKU sudokuGenerate( @Cast("l_int32*") int[] array, @Cast("l_int32") int seed, @Cast("l_int32") int minelems, @Cast("l_int32") int maxtries );
public static native @Cast("l_int32") int sudokuOutput( L_SUDOKU sud, @Cast("l_int32") int arraytype );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") IntPointer poverflow );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") IntBuffer poverflow );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") int[] poverflow );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") IntPointer poverflow );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") IntBuffer poverflow );
public static native PIX pixAddSingleTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location, @Cast("l_int32*") int[] poverflow );
public static native PIX pixAddTextlines( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native PIX pixAddTextlines( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntPointer poverflow );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntBuffer poverflow );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") int[] poverflow );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntPointer poverflow );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntBuffer poverflow );
public static native @Cast("l_ok") int pixSetTextblock( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32") int wtext, @Cast("l_int32") int firstindent, @Cast("l_int32*") int[] poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") IntPointer pwidth, @Cast("l_int32*") IntPointer poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") IntBuffer pwidth, @Cast("l_int32*") IntBuffer poverflow );
public static native @Cast("l_ok") int pixSetTextline( PIX pixs, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int x0, @Cast("l_int32") int y0, @Cast("l_int32*") int[] pwidth, @Cast("l_int32*") int[] poverflow );
public static native PIXA pixaAddTextNumber( PIXA pixas, L_BMF bmf, NUMA na, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native PIXA pixaAddTextlines( PIXA pixas, L_BMF bmf, SARRAY sa, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native @Cast("l_ok") int pixaAddPixWithText( PIXA pixa, PIX pixs, @Cast("l_int32") int reduction, L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native @Cast("l_ok") int pixaAddPixWithText( PIXA pixa, PIX pixs, @Cast("l_int32") int reduction, L_BMF bmf, String textstr, @Cast("l_uint32") int val, @Cast("l_int32") int location );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntPointer ph );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, String textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntBuffer ph );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") int[] ph );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, String textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntPointer ph );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") IntBuffer ph );
public static native SARRAY bmfGetLineStrings( L_BMF bmf, String textstr, @Cast("l_int32") int maxw, @Cast("l_int32") int firstindent, @Cast("l_int32*") int[] ph );
public static native NUMA bmfGetWordWidths( L_BMF bmf, @Cast("const char*") BytePointer textstr, SARRAY sa );
public static native NUMA bmfGetWordWidths( L_BMF bmf, String textstr, SARRAY sa );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32*") IntPointer pw );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, String textstr, @Cast("l_int32*") IntBuffer pw );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32*") int[] pw );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, String textstr, @Cast("l_int32*") IntPointer pw );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, @Cast("const char*") BytePointer textstr, @Cast("l_int32*") IntBuffer pw );
public static native @Cast("l_ok") int bmfGetStringWidth( L_BMF bmf, String textstr, @Cast("l_int32*") int[] pw );
public static native SARRAY splitStringToParagraphs( @Cast("char*") BytePointer textstr, @Cast("l_int32") int splitflag );
public static native SARRAY splitStringToParagraphs( @Cast("char*") ByteBuffer textstr, @Cast("l_int32") int splitflag );
public static native SARRAY splitStringToParagraphs( @Cast("char*") byte[] textstr, @Cast("l_int32") int splitflag );
public static native PIX pixReadTiff( @Cast("const char*") BytePointer filename, @Cast("l_int32") int n );
public static native PIX pixReadTiff( String filename, @Cast("l_int32") int n );
public static native PIX pixReadStreamTiff( @Cast("FILE*") Pointer fp, @Cast("l_int32") int n );
public static native @Cast("l_ok") int pixWriteTiff( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_int32") int comptype, @Cast("const char*") BytePointer modestr );
public static native @Cast("l_ok") int pixWriteTiff( String filename, PIX pix, @Cast("l_int32") int comptype, String modestr );
public static native @Cast("l_ok") int pixWriteTiffCustom( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_int32") int comptype, @Cast("const char*") BytePointer modestr, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_ok") int pixWriteTiffCustom( String filename, PIX pix, @Cast("l_int32") int comptype, String modestr, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_ok") int pixWriteStreamTiff( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixWriteStreamTiffWA( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int comptype, @Cast("const char*") BytePointer modestr );
public static native @Cast("l_ok") int pixWriteStreamTiffWA( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int comptype, String modestr );
public static native PIX pixReadFromMultipageTiff( @Cast("const char*") BytePointer fname, @Cast("size_t*") SizeTPointer poffset );
public static native PIX pixReadFromMultipageTiff( String fname, @Cast("size_t*") SizeTPointer poffset );
public static native PIXA pixaReadMultipageTiff( @Cast("const char*") BytePointer filename );
public static native PIXA pixaReadMultipageTiff( String filename );
public static native @Cast("l_ok") int pixaWriteMultipageTiff( @Cast("const char*") BytePointer fname, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMultipageTiff( String fname, PIXA pixa );
public static native @Cast("l_ok") int writeMultipageTiff( @Cast("const char*") BytePointer dirin, @Cast("const char*") BytePointer substr, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int writeMultipageTiff( String dirin, String substr, String fileout );
public static native @Cast("l_ok") int writeMultipageTiffSA( SARRAY sa, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int writeMultipageTiffSA( SARRAY sa, String fileout );
public static native @Cast("l_ok") int fprintTiffInfo( @Cast("FILE*") Pointer fpout, @Cast("const char*") BytePointer tiffile );
public static native @Cast("l_ok") int fprintTiffInfo( @Cast("FILE*") Pointer fpout, String tiffile );
public static native @Cast("l_ok") int tiffGetCount( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pn );
public static native @Cast("l_ok") int tiffGetCount( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pn );
public static native @Cast("l_ok") int tiffGetCount( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pn );
public static native @Cast("l_ok") int getTiffResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pxres, @Cast("l_int32*") IntPointer pyres );
public static native @Cast("l_ok") int getTiffResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pxres, @Cast("l_int32*") IntBuffer pyres );
public static native @Cast("l_ok") int getTiffResolution( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pxres, @Cast("l_int32*") int[] pyres );
public static native @Cast("l_ok") int readHeaderTiff( @Cast("const char*") BytePointer filename, @Cast("l_int32") int n, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pres, @Cast("l_int32*") IntPointer pcmap, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int readHeaderTiff( String filename, @Cast("l_int32") int n, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pres, @Cast("l_int32*") IntBuffer pcmap, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int readHeaderTiff( @Cast("const char*") BytePointer filename, @Cast("l_int32") int n, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pres, @Cast("l_int32*") int[] pcmap, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int readHeaderTiff( String filename, @Cast("l_int32") int n, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pres, @Cast("l_int32*") IntPointer pcmap, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int readHeaderTiff( @Cast("const char*") BytePointer filename, @Cast("l_int32") int n, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pres, @Cast("l_int32*") IntBuffer pcmap, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int readHeaderTiff( String filename, @Cast("l_int32") int n, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pres, @Cast("l_int32*") int[] pcmap, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int freadHeaderTiff( @Cast("FILE*") Pointer fp, @Cast("l_int32") int n, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pres, @Cast("l_int32*") IntPointer pcmap, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int freadHeaderTiff( @Cast("FILE*") Pointer fp, @Cast("l_int32") int n, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pres, @Cast("l_int32*") IntBuffer pcmap, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int freadHeaderTiff( @Cast("FILE*") Pointer fp, @Cast("l_int32") int n, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pres, @Cast("l_int32*") int[] pcmap, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int readHeaderMemTiff( @Cast("const l_uint8*") BytePointer cdata, @Cast("size_t") long size, @Cast("l_int32") int n, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pbps, @Cast("l_int32*") IntPointer pspp, @Cast("l_int32*") IntPointer pres, @Cast("l_int32*") IntPointer pcmap, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int readHeaderMemTiff( @Cast("const l_uint8*") ByteBuffer cdata, @Cast("size_t") long size, @Cast("l_int32") int n, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pbps, @Cast("l_int32*") IntBuffer pspp, @Cast("l_int32*") IntBuffer pres, @Cast("l_int32*") IntBuffer pcmap, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int readHeaderMemTiff( @Cast("const l_uint8*") byte[] cdata, @Cast("size_t") long size, @Cast("l_int32") int n, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pbps, @Cast("l_int32*") int[] pspp, @Cast("l_int32*") int[] pres, @Cast("l_int32*") int[] pcmap, @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int findTiffCompression( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntPointer pcomptype );
public static native @Cast("l_ok") int findTiffCompression( @Cast("FILE*") Pointer fp, @Cast("l_int32*") IntBuffer pcomptype );
public static native @Cast("l_ok") int findTiffCompression( @Cast("FILE*") Pointer fp, @Cast("l_int32*") int[] pcomptype );
public static native @Cast("l_ok") int extractG4DataFromFile( @Cast("const char*") BytePointer filein, @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( @Cast("const char*") BytePointer filein, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( String filein, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( @Cast("const char*") BytePointer filein, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( String filein, @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( @Cast("const char*") BytePointer filein, @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pminisblack );
public static native @Cast("l_ok") int extractG4DataFromFile( String filein, @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer pnbytes, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pminisblack );
public static native PIX pixReadMemTiff( @Cast("const l_uint8*") BytePointer cdata, @Cast("size_t") long size, @Cast("l_int32") int n );
public static native PIX pixReadMemTiff( @Cast("const l_uint8*") ByteBuffer cdata, @Cast("size_t") long size, @Cast("l_int32") int n );
public static native PIX pixReadMemTiff( @Cast("const l_uint8*") byte[] cdata, @Cast("size_t") long size, @Cast("l_int32") int n );
public static native PIX pixReadMemFromMultipageTiff( @Cast("const l_uint8*") BytePointer cdata, @Cast("size_t") long size, @Cast("size_t*") SizeTPointer poffset );
public static native PIX pixReadMemFromMultipageTiff( @Cast("const l_uint8*") ByteBuffer cdata, @Cast("size_t") long size, @Cast("size_t*") SizeTPointer poffset );
public static native PIX pixReadMemFromMultipageTiff( @Cast("const l_uint8*") byte[] cdata, @Cast("size_t") long size, @Cast("size_t*") SizeTPointer poffset );
public static native PIXA pixaReadMemMultipageTiff( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native PIXA pixaReadMemMultipageTiff( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native PIXA pixaReadMemMultipageTiff( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("l_ok") int pixaWriteMemMultipageTiff( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMemMultipageTiff( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMemMultipageTiff( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixaWriteMemMultipageTiff( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIXA pixa );
public static native @Cast("l_ok") int pixWriteMemTiff( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixWriteMemTiff( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixWriteMemTiff( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixWriteMemTiff( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype );
public static native @Cast("l_ok") int pixWriteMemTiffCustom( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_ok") int pixWriteMemTiffCustom( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_ok") int pixWriteMemTiffCustom( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_ok") int pixWriteMemTiffCustom( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int comptype, NUMA natags, SARRAY savals, SARRAY satypes, NUMA nasizes );
public static native @Cast("l_int32") int setMsgSeverity( @Cast("l_int32") int newsev );
public static native @Cast("l_int32") int returnErrorInt( @Cast("const char*") BytePointer msg, @Cast("const char*") BytePointer procname, @Cast("l_int32") int ival );
public static native @Cast("l_int32") int returnErrorInt( String msg, String procname, @Cast("l_int32") int ival );
public static native @Cast("l_float32") float returnErrorFloat( @Cast("const char*") BytePointer msg, @Cast("const char*") BytePointer procname, @Cast("l_float32") float fval );
public static native @Cast("l_float32") float returnErrorFloat( String msg, String procname, @Cast("l_float32") float fval );
public static native Pointer returnErrorPtr( @Cast("const char*") BytePointer msg, @Cast("const char*") BytePointer procname, Pointer pval );
public static native Pointer returnErrorPtr( String msg, String procname, Pointer pval );
// Targeting ..\Handler_BytePointer.java


public static native void leptSetStderrHandler( Handler_BytePointer handler );
// Targeting ..\Handler_String.java


public static native void leptSetStderrHandler( Handler_String handler );
public static native void lept_stderr( @Cast("const char*") BytePointer fmt );
public static native void lept_stderr( String fmt );
public static native @Cast("l_ok") int filesAreIdentical( @Cast("const char*") BytePointer fname1, @Cast("const char*") BytePointer fname2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int filesAreIdentical( String fname1, String fname2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int filesAreIdentical( @Cast("const char*") BytePointer fname1, @Cast("const char*") BytePointer fname2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int filesAreIdentical( String fname1, String fname2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int filesAreIdentical( @Cast("const char*") BytePointer fname1, @Cast("const char*") BytePointer fname2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int filesAreIdentical( String fname1, String fname2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_uint16") short convertOnLittleEnd16( @Cast("l_uint16") short shortin );
public static native @Cast("l_uint16") short convertOnBigEnd16( @Cast("l_uint16") short shortin );
public static native @Cast("l_uint32") int convertOnLittleEnd32( @Cast("l_uint32") int wordin );
public static native @Cast("l_uint32") int convertOnBigEnd32( @Cast("l_uint32") int wordin );
public static native @Cast("l_ok") int fileCorruptByDeletion( @Cast("const char*") BytePointer filein, @Cast("l_float32") float loc, @Cast("l_float32") float size, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int fileCorruptByDeletion( String filein, @Cast("l_float32") float loc, @Cast("l_float32") float size, String fileout );
public static native @Cast("l_ok") int fileCorruptByMutation( @Cast("const char*") BytePointer filein, @Cast("l_float32") float loc, @Cast("l_float32") float size, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int fileCorruptByMutation( String filein, @Cast("l_float32") float loc, @Cast("l_float32") float size, String fileout );
public static native @Cast("l_ok") int fileReplaceBytes( @Cast("const char*") BytePointer filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") BytePointer newdata, @Cast("size_t") long newsize, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int fileReplaceBytes( String filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") ByteBuffer newdata, @Cast("size_t") long newsize, String fileout );
public static native @Cast("l_ok") int fileReplaceBytes( @Cast("const char*") BytePointer filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") byte[] newdata, @Cast("size_t") long newsize, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int fileReplaceBytes( String filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") BytePointer newdata, @Cast("size_t") long newsize, String fileout );
public static native @Cast("l_ok") int fileReplaceBytes( @Cast("const char*") BytePointer filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") ByteBuffer newdata, @Cast("size_t") long newsize, @Cast("const char*") BytePointer fileout );
public static native @Cast("l_ok") int fileReplaceBytes( String filein, @Cast("l_int32") int start, @Cast("l_int32") int nbytes, @Cast("l_uint8*") byte[] newdata, @Cast("size_t") long newsize, String fileout );
public static native @Cast("l_ok") int genRandomIntOnInterval( @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int seed, @Cast("l_int32*") IntPointer pval );
public static native @Cast("l_ok") int genRandomIntOnInterval( @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int seed, @Cast("l_int32*") IntBuffer pval );
public static native @Cast("l_ok") int genRandomIntOnInterval( @Cast("l_int32") int start, @Cast("l_int32") int end, @Cast("l_int32") int seed, @Cast("l_int32*") int[] pval );
public static native @Cast("l_int32") int lept_roundftoi( @Cast("l_float32") float fval );
public static native @Cast("l_ok") int l_hashStringToUint64( @Cast("const char*") BytePointer str, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashStringToUint64( String str, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashStringToUint64( @Cast("const char*") BytePointer str, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int l_hashStringToUint64( String str, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashStringToUint64( @Cast("const char*") BytePointer str, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashStringToUint64( String str, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( @Cast("const char*") BytePointer str, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( String str, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( @Cast("const char*") BytePointer str, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( String str, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( @Cast("const char*") BytePointer str, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashStringToUint64Fast( String str, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int l_hashPtToUint64( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashPtToUint64( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashPtToUint64( @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int l_hashFloat64ToUint64( @Cast("l_float64") double val, @Cast("l_uint64*") LongPointer phash );
public static native @Cast("l_ok") int l_hashFloat64ToUint64( @Cast("l_float64") double val, @Cast("l_uint64*") LongBuffer phash );
public static native @Cast("l_ok") int l_hashFloat64ToUint64( @Cast("l_float64") double val, @Cast("l_uint64*") long[] phash );
public static native @Cast("l_ok") int findNextLargerPrime( @Cast("l_int32") int start, @Cast("l_uint32*") IntPointer pprime );
public static native @Cast("l_ok") int findNextLargerPrime( @Cast("l_int32") int start, @Cast("l_uint32*") IntBuffer pprime );
public static native @Cast("l_ok") int findNextLargerPrime( @Cast("l_int32") int start, @Cast("l_uint32*") int[] pprime );
public static native @Cast("l_ok") int lept_isPrime( @Cast("l_uint64") long n, @Cast("l_int32*") IntPointer pis_prime, @Cast("l_uint32*") IntPointer pfactor );
public static native @Cast("l_ok") int lept_isPrime( @Cast("l_uint64") long n, @Cast("l_int32*") IntBuffer pis_prime, @Cast("l_uint32*") IntBuffer pfactor );
public static native @Cast("l_ok") int lept_isPrime( @Cast("l_uint64") long n, @Cast("l_int32*") int[] pis_prime, @Cast("l_uint32*") int[] pfactor );
public static native @Cast("l_uint32") int convertIntToGrayCode( @Cast("l_uint32") int val );
public static native @Cast("l_uint32") int convertGrayCodeToInt( @Cast("l_uint32") int val );
public static native @Cast("char*") BytePointer getLeptonicaVersion( );
public static native void startTimer( );
public static native @Cast("l_float32") float stopTimer( );
public static native L_TIMER startTimerNested( );
public static native @Cast("l_float32") float stopTimerNested( L_TIMER rusage_start );
public static native void l_getCurrentTime( @Cast("l_int32*") IntPointer sec, @Cast("l_int32*") IntPointer usec );
public static native void l_getCurrentTime( @Cast("l_int32*") IntBuffer sec, @Cast("l_int32*") IntBuffer usec );
public static native void l_getCurrentTime( @Cast("l_int32*") int[] sec, @Cast("l_int32*") int[] usec );
public static native L_WALLTIMER startWallTimer( );
public static native @Cast("l_float32") float stopWallTimer( @Cast("L_WALLTIMER**") PointerPointer ptimer );
public static native @Cast("l_float32") float stopWallTimer( @ByPtrPtr L_WALLTIMER ptimer );
public static native @Cast("char*") BytePointer l_getFormattedDate( );
public static native @Cast("char*") BytePointer stringNew( @Cast("const char*") BytePointer src );
public static native @Cast("char*") ByteBuffer stringNew( String src );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") BytePointer dest, @Cast("const char*") BytePointer src, @Cast("l_int32") int n );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") ByteBuffer dest, String src, @Cast("l_int32") int n );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") byte[] dest, @Cast("const char*") BytePointer src, @Cast("l_int32") int n );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") BytePointer dest, String src, @Cast("l_int32") int n );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") ByteBuffer dest, @Cast("const char*") BytePointer src, @Cast("l_int32") int n );
public static native @Cast("l_ok") int stringCopy( @Cast("char*") byte[] dest, String src, @Cast("l_int32") int n );
public static native @Cast("char*") BytePointer stringCopySegment( @Cast("const char*") BytePointer src, @Cast("l_int32") int start, @Cast("l_int32") int nbytes );
public static native @Cast("char*") ByteBuffer stringCopySegment( String src, @Cast("l_int32") int start, @Cast("l_int32") int nbytes );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") PointerPointer pdest, @Cast("const char*") BytePointer src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr BytePointer pdest, @Cast("const char*") BytePointer src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr ByteBuffer pdest, String src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr byte[] pdest, @Cast("const char*") BytePointer src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr BytePointer pdest, String src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr ByteBuffer pdest, @Cast("const char*") BytePointer src );
public static native @Cast("l_ok") int stringReplace( @Cast("char**") @ByPtrPtr byte[] pdest, String src );
public static native @Cast("l_int32") int stringLength( @Cast("const char*") BytePointer src, @Cast("size_t") long size );
public static native @Cast("l_int32") int stringLength( String src, @Cast("size_t") long size );
public static native @Cast("l_int32") int stringCat( @Cast("char*") BytePointer dest, @Cast("size_t") long size, @Cast("const char*") BytePointer src );
public static native @Cast("l_int32") int stringCat( @Cast("char*") ByteBuffer dest, @Cast("size_t") long size, String src );
public static native @Cast("l_int32") int stringCat( @Cast("char*") byte[] dest, @Cast("size_t") long size, @Cast("const char*") BytePointer src );
public static native @Cast("l_int32") int stringCat( @Cast("char*") BytePointer dest, @Cast("size_t") long size, String src );
public static native @Cast("l_int32") int stringCat( @Cast("char*") ByteBuffer dest, @Cast("size_t") long size, @Cast("const char*") BytePointer src );
public static native @Cast("l_int32") int stringCat( @Cast("char*") byte[] dest, @Cast("size_t") long size, String src );
public static native @Cast("char*") BytePointer stringConcatNew( @Cast("const char*") BytePointer first );
public static native @Cast("char*") ByteBuffer stringConcatNew( String first );
public static native @Cast("char*") BytePointer stringJoin( @Cast("const char*") BytePointer src1, @Cast("const char*") BytePointer src2 );
public static native @Cast("char*") ByteBuffer stringJoin( String src1, String src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") PointerPointer psrc1, @Cast("const char*") BytePointer src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr BytePointer psrc1, @Cast("const char*") BytePointer src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr ByteBuffer psrc1, String src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr byte[] psrc1, @Cast("const char*") BytePointer src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr BytePointer psrc1, String src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr ByteBuffer psrc1, @Cast("const char*") BytePointer src2 );
public static native @Cast("l_ok") int stringJoinIP( @Cast("char**") @ByPtrPtr byte[] psrc1, String src2 );
public static native @Cast("char*") BytePointer stringReverse( @Cast("const char*") BytePointer src );
public static native @Cast("char*") ByteBuffer stringReverse( String src );
public static native @Cast("char*") BytePointer strtokSafe( @Cast("char*") BytePointer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") PointerPointer psaveptr );
public static native @Cast("char*") BytePointer strtokSafe( @Cast("char*") BytePointer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr BytePointer psaveptr );
public static native @Cast("char*") ByteBuffer strtokSafe( @Cast("char*") ByteBuffer cstr, String seps, @Cast("char**") @ByPtrPtr ByteBuffer psaveptr );
public static native @Cast("char*") byte[] strtokSafe( @Cast("char*") byte[] cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr byte[] psaveptr );
public static native @Cast("char*") BytePointer strtokSafe( @Cast("char*") BytePointer cstr, String seps, @Cast("char**") @ByPtrPtr BytePointer psaveptr );
public static native @Cast("char*") ByteBuffer strtokSafe( @Cast("char*") ByteBuffer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr ByteBuffer psaveptr );
public static native @Cast("char*") byte[] strtokSafe( @Cast("char*") byte[] cstr, String seps, @Cast("char**") @ByPtrPtr byte[] psaveptr );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") BytePointer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") PointerPointer phead, @Cast("char**") PointerPointer ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") BytePointer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr BytePointer phead, @Cast("char**") @ByPtrPtr BytePointer ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") ByteBuffer cstr, String seps, @Cast("char**") @ByPtrPtr ByteBuffer phead, @Cast("char**") @ByPtrPtr ByteBuffer ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") byte[] cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr byte[] phead, @Cast("char**") @ByPtrPtr byte[] ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") BytePointer cstr, String seps, @Cast("char**") @ByPtrPtr BytePointer phead, @Cast("char**") @ByPtrPtr BytePointer ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") ByteBuffer cstr, @Cast("const char*") BytePointer seps, @Cast("char**") @ByPtrPtr ByteBuffer phead, @Cast("char**") @ByPtrPtr ByteBuffer ptail );
public static native @Cast("l_ok") int stringSplitOnToken( @Cast("char*") byte[] cstr, String seps, @Cast("char**") @ByPtrPtr byte[] phead, @Cast("char**") @ByPtrPtr byte[] ptail );
public static native @Cast("l_ok") int stringCheckForChars( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer chars, @Cast("l_int32*") IntPointer pfound );
public static native @Cast("l_ok") int stringCheckForChars( String src, String chars, @Cast("l_int32*") IntBuffer pfound );
public static native @Cast("l_ok") int stringCheckForChars( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer chars, @Cast("l_int32*") int[] pfound );
public static native @Cast("l_ok") int stringCheckForChars( String src, String chars, @Cast("l_int32*") IntPointer pfound );
public static native @Cast("l_ok") int stringCheckForChars( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer chars, @Cast("l_int32*") IntBuffer pfound );
public static native @Cast("l_ok") int stringCheckForChars( String src, String chars, @Cast("l_int32*") int[] pfound );
public static native @Cast("char*") BytePointer stringRemoveChars( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer remchars );
public static native @Cast("char*") ByteBuffer stringRemoveChars( String src, String remchars );
public static native @Cast("char*") BytePointer stringReplaceEachSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("char*") ByteBuffer stringReplaceEachSubstr( String src, String sub1, String sub2, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("char*") byte[] stringReplaceEachSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") int[] pcount );
public static native @Cast("char*") BytePointer stringReplaceEachSubstr( String src, String sub1, String sub2, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("char*") ByteBuffer stringReplaceEachSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("char*") byte[] stringReplaceEachSubstr( String src, String sub1, String sub2, @Cast("l_int32*") int[] pcount );
public static native @Cast("char*") BytePointer stringReplaceSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") IntPointer ploc, @Cast("l_int32*") IntPointer pfound );
public static native @Cast("char*") ByteBuffer stringReplaceSubstr( String src, String sub1, String sub2, @Cast("l_int32*") IntBuffer ploc, @Cast("l_int32*") IntBuffer pfound );
public static native @Cast("char*") byte[] stringReplaceSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") int[] ploc, @Cast("l_int32*") int[] pfound );
public static native @Cast("char*") BytePointer stringReplaceSubstr( String src, String sub1, String sub2, @Cast("l_int32*") IntPointer ploc, @Cast("l_int32*") IntPointer pfound );
public static native @Cast("char*") ByteBuffer stringReplaceSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub1, @Cast("const char*") BytePointer sub2, @Cast("l_int32*") IntBuffer ploc, @Cast("l_int32*") IntBuffer pfound );
public static native @Cast("char*") byte[] stringReplaceSubstr( String src, String sub1, String sub2, @Cast("l_int32*") int[] ploc, @Cast("l_int32*") int[] pfound );
public static native L_DNA stringFindEachSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub );
public static native L_DNA stringFindEachSubstr( String src, String sub );
public static native @Cast("l_int32") int stringFindSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_int32") int stringFindSubstr( String src, String sub, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_int32") int stringFindSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub, @Cast("l_int32*") int[] ploc );
public static native @Cast("l_int32") int stringFindSubstr( String src, String sub, @Cast("l_int32*") IntPointer ploc );
public static native @Cast("l_int32") int stringFindSubstr( @Cast("const char*") BytePointer src, @Cast("const char*") BytePointer sub, @Cast("l_int32*") IntBuffer ploc );
public static native @Cast("l_int32") int stringFindSubstr( String src, String sub, @Cast("l_int32*") int[] ploc );
public static native @Cast("l_uint8*") BytePointer arrayReplaceEachSequence( @Cast("const l_uint8*") BytePointer datas, @Cast("size_t") long dataslen, @Cast("const l_uint8*") BytePointer seq, @Cast("size_t") long seqlen, @Cast("const l_uint8*") BytePointer newseq, @Cast("size_t") long newseqlen, @Cast("size_t*") SizeTPointer pdatadlen, @Cast("l_int32*") IntPointer pcount );
public static native @Cast("l_uint8*") ByteBuffer arrayReplaceEachSequence( @Cast("const l_uint8*") ByteBuffer datas, @Cast("size_t") long dataslen, @Cast("const l_uint8*") ByteBuffer seq, @Cast("size_t") long seqlen, @Cast("const l_uint8*") ByteBuffer newseq, @Cast("size_t") long newseqlen, @Cast("size_t*") SizeTPointer pdatadlen, @Cast("l_int32*") IntBuffer pcount );
public static native @Cast("l_uint8*") byte[] arrayReplaceEachSequence( @Cast("const l_uint8*") byte[] datas, @Cast("size_t") long dataslen, @Cast("const l_uint8*") byte[] seq, @Cast("size_t") long seqlen, @Cast("const l_uint8*") byte[] newseq, @Cast("size_t") long newseqlen, @Cast("size_t*") SizeTPointer pdatadlen, @Cast("l_int32*") int[] pcount );
public static native L_DNA arrayFindEachSequence( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long datalen, @Cast("const l_uint8*") BytePointer sequence, @Cast("size_t") long seqlen );
public static native L_DNA arrayFindEachSequence( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long datalen, @Cast("const l_uint8*") ByteBuffer sequence, @Cast("size_t") long seqlen );
public static native L_DNA arrayFindEachSequence( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long datalen, @Cast("const l_uint8*") byte[] sequence, @Cast("size_t") long seqlen );
public static native @Cast("l_ok") int arrayFindSequence( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long datalen, @Cast("const l_uint8*") BytePointer sequence, @Cast("size_t") long seqlen, @Cast("l_int32*") IntPointer poffset, @Cast("l_int32*") IntPointer pfound );
public static native @Cast("l_ok") int arrayFindSequence( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long datalen, @Cast("const l_uint8*") ByteBuffer sequence, @Cast("size_t") long seqlen, @Cast("l_int32*") IntBuffer poffset, @Cast("l_int32*") IntBuffer pfound );
public static native @Cast("l_ok") int arrayFindSequence( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long datalen, @Cast("const l_uint8*") byte[] sequence, @Cast("size_t") long seqlen, @Cast("l_int32*") int[] poffset, @Cast("l_int32*") int[] pfound );
public static native Pointer reallocNew( @Cast("void**") PointerPointer pindata, @Cast("size_t") long oldsize, @Cast("size_t") long newsize );
public static native Pointer reallocNew( @Cast("void**") @ByPtrPtr Pointer pindata, @Cast("size_t") long oldsize, @Cast("size_t") long newsize );
public static native @Cast("l_uint8*") BytePointer l_binaryRead( @Cast("const char*") BytePointer filename, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_uint8*") ByteBuffer l_binaryRead( String filename, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_uint8*") BytePointer l_binaryReadStream( @Cast("FILE*") Pointer fp, @Cast("size_t*") SizeTPointer pnbytes );
public static native @Cast("l_uint8*") BytePointer l_binaryReadSelect( @Cast("const char*") BytePointer filename, @Cast("size_t") long start, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnread );
public static native @Cast("l_uint8*") ByteBuffer l_binaryReadSelect( String filename, @Cast("size_t") long start, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnread );
public static native @Cast("l_uint8*") BytePointer l_binaryReadSelectStream( @Cast("FILE*") Pointer fp, @Cast("size_t") long start, @Cast("size_t") long nbytes, @Cast("size_t*") SizeTPointer pnread );
public static native @Cast("l_ok") int l_binaryWrite( @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer operation, @Const Pointer data, @Cast("size_t") long nbytes );
public static native @Cast("l_ok") int l_binaryWrite( String filename, String operation, @Const Pointer data, @Cast("size_t") long nbytes );
public static native @Cast("size_t") long nbytesInFile( @Cast("const char*") BytePointer filename );
public static native @Cast("size_t") long nbytesInFile( String filename );
public static native @Cast("size_t") long fnbytesInFile( @Cast("FILE*") Pointer fp );
public static native @Cast("l_uint8*") BytePointer l_binaryCopy( @Cast("const l_uint8*") BytePointer datas, @Cast("size_t") long size );
public static native @Cast("l_uint8*") ByteBuffer l_binaryCopy( @Cast("const l_uint8*") ByteBuffer datas, @Cast("size_t") long size );
public static native @Cast("l_uint8*") byte[] l_binaryCopy( @Cast("const l_uint8*") byte[] datas, @Cast("size_t") long size );
public static native @Cast("l_ok") int l_binaryCompare( @Cast("const l_uint8*") BytePointer data1, @Cast("size_t") long size1, @Cast("const l_uint8*") BytePointer data2, @Cast("size_t") long size2, @Cast("l_int32*") IntPointer psame );
public static native @Cast("l_ok") int l_binaryCompare( @Cast("const l_uint8*") ByteBuffer data1, @Cast("size_t") long size1, @Cast("const l_uint8*") ByteBuffer data2, @Cast("size_t") long size2, @Cast("l_int32*") IntBuffer psame );
public static native @Cast("l_ok") int l_binaryCompare( @Cast("const l_uint8*") byte[] data1, @Cast("size_t") long size1, @Cast("const l_uint8*") byte[] data2, @Cast("size_t") long size2, @Cast("l_int32*") int[] psame );
public static native @Cast("l_ok") int fileCopy( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newfile );
public static native @Cast("l_ok") int fileCopy( String srcfile, String newfile );
public static native @Cast("l_ok") int fileConcatenate( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer destfile );
public static native @Cast("l_ok") int fileConcatenate( String srcfile, String destfile );
public static native @Cast("l_ok") int fileAppendString( @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer str );
public static native @Cast("l_ok") int fileAppendString( String filename, String str );
public static native @Cast("l_ok") int fileSplitLinesUniform( @Cast("const char*") BytePointer filename, @Cast("l_int32") int n, @Cast("l_int32") int save_empty, @Cast("const char*") BytePointer rootpath, @Cast("const char*") BytePointer ext );
public static native @Cast("l_ok") int fileSplitLinesUniform( String filename, @Cast("l_int32") int n, @Cast("l_int32") int save_empty, String rootpath, String ext );
public static native @Cast("FILE*") Pointer fopenReadStream( @Cast("const char*") BytePointer filename );
public static native @Cast("FILE*") Pointer fopenReadStream( String filename );
public static native @Cast("FILE*") Pointer fopenWriteStream( @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer modestring );
public static native @Cast("FILE*") Pointer fopenWriteStream( String filename, String modestring );
public static native @Cast("FILE*") Pointer fopenReadFromMemory( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size );
public static native @Cast("FILE*") Pointer fopenReadFromMemory( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size );
public static native @Cast("FILE*") Pointer fopenReadFromMemory( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size );
public static native @Cast("FILE*") Pointer fopenWriteWinTempfile( );
public static native @Cast("FILE*") Pointer lept_fopen( @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer mode );
public static native @Cast("FILE*") Pointer lept_fopen( String filename, String mode );
public static native @Cast("l_ok") int lept_fclose( @Cast("FILE*") Pointer fp );
public static native Pointer lept_calloc( @Cast("size_t") long nmemb, @Cast("size_t") long size );
public static native void lept_free( Pointer ptr );
public static native @Cast("l_int32") int lept_mkdir( @Cast("const char*") BytePointer subdir );
public static native @Cast("l_int32") int lept_mkdir( String subdir );
public static native @Cast("l_int32") int lept_rmdir( @Cast("const char*") BytePointer subdir );
public static native @Cast("l_int32") int lept_rmdir( String subdir );
public static native void lept_direxists( @Cast("const char*") BytePointer dir, @Cast("l_int32*") IntPointer pexists );
public static native void lept_direxists( String dir, @Cast("l_int32*") IntBuffer pexists );
public static native void lept_direxists( @Cast("const char*") BytePointer dir, @Cast("l_int32*") int[] pexists );
public static native void lept_direxists( String dir, @Cast("l_int32*") IntPointer pexists );
public static native void lept_direxists( @Cast("const char*") BytePointer dir, @Cast("l_int32*") IntBuffer pexists );
public static native void lept_direxists( String dir, @Cast("l_int32*") int[] pexists );
public static native @Cast("l_int32") int lept_rm_match( @Cast("const char*") BytePointer subdir, @Cast("const char*") BytePointer substr );
public static native @Cast("l_int32") int lept_rm_match( String subdir, String substr );
public static native @Cast("l_int32") int lept_rm( @Cast("const char*") BytePointer subdir, @Cast("const char*") BytePointer tail );
public static native @Cast("l_int32") int lept_rm( String subdir, String tail );
public static native @Cast("l_int32") int lept_rmfile( @Cast("const char*") BytePointer filepath );
public static native @Cast("l_int32") int lept_rmfile( String filepath );
public static native @Cast("l_int32") int lept_mv( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") PointerPointer pnewpath );
public static native @Cast("l_int32") int lept_mv( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr BytePointer pnewpath );
public static native @Cast("l_int32") int lept_mv( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr ByteBuffer pnewpath );
public static native @Cast("l_int32") int lept_mv( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr byte[] pnewpath );
public static native @Cast("l_int32") int lept_mv( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr BytePointer pnewpath );
public static native @Cast("l_int32") int lept_mv( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr ByteBuffer pnewpath );
public static native @Cast("l_int32") int lept_mv( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr byte[] pnewpath );
public static native @Cast("l_int32") int lept_cp( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") PointerPointer pnewpath );
public static native @Cast("l_int32") int lept_cp( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr BytePointer pnewpath );
public static native @Cast("l_int32") int lept_cp( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr ByteBuffer pnewpath );
public static native @Cast("l_int32") int lept_cp( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr byte[] pnewpath );
public static native @Cast("l_int32") int lept_cp( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr BytePointer pnewpath );
public static native @Cast("l_int32") int lept_cp( @Cast("const char*") BytePointer srcfile, @Cast("const char*") BytePointer newdir, @Cast("const char*") BytePointer newtail, @Cast("char**") @ByPtrPtr ByteBuffer pnewpath );
public static native @Cast("l_int32") int lept_cp( String srcfile, String newdir, String newtail, @Cast("char**") @ByPtrPtr byte[] pnewpath );
public static native void callSystemDebug( @Cast("const char*") BytePointer cmd );
public static native void callSystemDebug( String cmd );
public static native @Cast("l_ok") int splitPathAtDirectory( @Cast("const char*") BytePointer pathname, @Cast("char**") PointerPointer pdir, @Cast("char**") PointerPointer ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr BytePointer pdir, @Cast("char**") @ByPtrPtr BytePointer ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( String pathname, @Cast("char**") @ByPtrPtr ByteBuffer pdir, @Cast("char**") @ByPtrPtr ByteBuffer ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr byte[] pdir, @Cast("char**") @ByPtrPtr byte[] ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( String pathname, @Cast("char**") @ByPtrPtr BytePointer pdir, @Cast("char**") @ByPtrPtr BytePointer ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr ByteBuffer pdir, @Cast("char**") @ByPtrPtr ByteBuffer ptail );
public static native @Cast("l_ok") int splitPathAtDirectory( String pathname, @Cast("char**") @ByPtrPtr byte[] pdir, @Cast("char**") @ByPtrPtr byte[] ptail );
public static native @Cast("l_ok") int splitPathAtExtension( @Cast("const char*") BytePointer pathname, @Cast("char**") PointerPointer pbasename, @Cast("char**") PointerPointer pextension );
public static native @Cast("l_ok") int splitPathAtExtension( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr BytePointer pbasename, @Cast("char**") @ByPtrPtr BytePointer pextension );
public static native @Cast("l_ok") int splitPathAtExtension( String pathname, @Cast("char**") @ByPtrPtr ByteBuffer pbasename, @Cast("char**") @ByPtrPtr ByteBuffer pextension );
public static native @Cast("l_ok") int splitPathAtExtension( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr byte[] pbasename, @Cast("char**") @ByPtrPtr byte[] pextension );
public static native @Cast("l_ok") int splitPathAtExtension( String pathname, @Cast("char**") @ByPtrPtr BytePointer pbasename, @Cast("char**") @ByPtrPtr BytePointer pextension );
public static native @Cast("l_ok") int splitPathAtExtension( @Cast("const char*") BytePointer pathname, @Cast("char**") @ByPtrPtr ByteBuffer pbasename, @Cast("char**") @ByPtrPtr ByteBuffer pextension );
public static native @Cast("l_ok") int splitPathAtExtension( String pathname, @Cast("char**") @ByPtrPtr byte[] pbasename, @Cast("char**") @ByPtrPtr byte[] pextension );
public static native @Cast("char*") BytePointer pathJoin( @Cast("const char*") BytePointer dir, @Cast("const char*") BytePointer fname );
public static native @Cast("char*") ByteBuffer pathJoin( String dir, String fname );
public static native @Cast("char*") BytePointer appendSubdirs( @Cast("const char*") BytePointer basedir, @Cast("const char*") BytePointer subdirs );
public static native @Cast("char*") ByteBuffer appendSubdirs( String basedir, String subdirs );
public static native @Cast("l_ok") int convertSepCharsInPath( @Cast("char*") BytePointer path, @Cast("l_int32") int type );
public static native @Cast("l_ok") int convertSepCharsInPath( @Cast("char*") ByteBuffer path, @Cast("l_int32") int type );
public static native @Cast("l_ok") int convertSepCharsInPath( @Cast("char*") byte[] path, @Cast("l_int32") int type );
public static native @Cast("char*") BytePointer genPathname( @Cast("const char*") BytePointer dir, @Cast("const char*") BytePointer fname );
public static native @Cast("char*") ByteBuffer genPathname( String dir, String fname );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") BytePointer result, @Cast("size_t") long nbytes, @Cast("const char*") BytePointer subdir );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") ByteBuffer result, @Cast("size_t") long nbytes, String subdir );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") byte[] result, @Cast("size_t") long nbytes, @Cast("const char*") BytePointer subdir );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") BytePointer result, @Cast("size_t") long nbytes, String subdir );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") ByteBuffer result, @Cast("size_t") long nbytes, @Cast("const char*") BytePointer subdir );
public static native @Cast("l_ok") int makeTempDirname( @Cast("char*") byte[] result, @Cast("size_t") long nbytes, String subdir );
public static native @Cast("l_ok") int modifyTrailingSlash( @Cast("char*") BytePointer path, @Cast("size_t") long nbytes, @Cast("l_int32") int flag );
public static native @Cast("l_ok") int modifyTrailingSlash( @Cast("char*") ByteBuffer path, @Cast("size_t") long nbytes, @Cast("l_int32") int flag );
public static native @Cast("l_ok") int modifyTrailingSlash( @Cast("char*") byte[] path, @Cast("size_t") long nbytes, @Cast("l_int32") int flag );
public static native @Cast("char*") BytePointer l_makeTempFilename( );
public static native @Cast("l_int32") int extractNumberFromFilename( @Cast("const char*") BytePointer fname, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost );
public static native @Cast("l_int32") int extractNumberFromFilename( String fname, @Cast("l_int32") int numpre, @Cast("l_int32") int numpost );
public static native PIX pixSimpleCaptcha( PIX pixs, @Cast("l_int32") int border, @Cast("l_int32") int nterms, @Cast("l_uint32") int seed, @Cast("l_uint32") int color, @Cast("l_int32") int cmapflag );
public static native PIX pixRandomHarmonicWarp( PIX pixs, @Cast("l_float32") float xmag, @Cast("l_float32") float ymag, @Cast("l_float32") float xfreq, @Cast("l_float32") float yfreq, @Cast("l_int32") int nx, @Cast("l_int32") int ny, @Cast("l_uint32") int seed, @Cast("l_int32") int grayval );
public static native PIX pixWarpStereoscopic( PIX pixs, @Cast("l_int32") int zbend, @Cast("l_int32") int zshiftt, @Cast("l_int32") int zshiftb, @Cast("l_int32") int ybendt, @Cast("l_int32") int ybendb, @Cast("l_int32") int redleft );
public static native PIX pixStretchHorizontal( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int type, @Cast("l_int32") int hmax, @Cast("l_int32") int operation, @Cast("l_int32") int incolor );
public static native PIX pixStretchHorizontalSampled( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int type, @Cast("l_int32") int hmax, @Cast("l_int32") int incolor );
public static native PIX pixStretchHorizontalLI( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int type, @Cast("l_int32") int hmax, @Cast("l_int32") int incolor );
public static native PIX pixQuadraticVShear( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int vmaxt, @Cast("l_int32") int vmaxb, @Cast("l_int32") int operation, @Cast("l_int32") int incolor );
public static native PIX pixQuadraticVShearSampled( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int vmaxt, @Cast("l_int32") int vmaxb, @Cast("l_int32") int incolor );
public static native PIX pixQuadraticVShearLI( PIX pixs, @Cast("l_int32") int dir, @Cast("l_int32") int vmaxt, @Cast("l_int32") int vmaxb, @Cast("l_int32") int incolor );
public static native PIX pixStereoFromPair( PIX pix1, PIX pix2, @Cast("l_float32") float rwt, @Cast("l_float32") float gwt, @Cast("l_float32") float bwt );
public static native L_WSHED wshedCreate( PIX pixs, PIX pixm, @Cast("l_int32") int mindepth, @Cast("l_int32") int debugflag );
public static native void wshedDestroy( @Cast("L_WSHED**") PointerPointer pwshed );
public static native void wshedDestroy( @ByPtrPtr L_WSHED pwshed );
public static native @Cast("l_ok") int wshedApply( L_WSHED wshed );
public static native @Cast("l_ok") int wshedBasins( L_WSHED wshed, @Cast("PIXA**") PointerPointer ppixa, @Cast("NUMA**") PointerPointer pnalevels );
public static native @Cast("l_ok") int wshedBasins( L_WSHED wshed, @ByPtrPtr PIXA ppixa, @ByPtrPtr NUMA pnalevels );
public static native PIX wshedRenderFill( L_WSHED wshed );
public static native PIX wshedRenderColors( L_WSHED wshed );
public static native @Cast("l_ok") int pixaWriteWebPAnim( @Cast("const char*") BytePointer filename, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteWebPAnim( String filename, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteStreamWebPAnim( @Cast("FILE*") Pointer fp, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteMemWebPAnim( @Cast("l_uint8**") PointerPointer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteMemWebPAnim( @Cast("l_uint8**") @ByPtrPtr BytePointer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteMemWebPAnim( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixaWriteMemWebPAnim( @Cast("l_uint8**") @ByPtrPtr byte[] pencdata, @Cast("size_t*") SizeTPointer pencsize, PIXA pixa, @Cast("l_int32") int loopcount, @Cast("l_int32") int duration, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native PIX pixReadStreamWebP( @Cast("FILE*") Pointer fp );
public static native PIX pixReadMemWebP( @Cast("const l_uint8*") BytePointer filedata, @Cast("size_t") long filesize );
public static native PIX pixReadMemWebP( @Cast("const l_uint8*") ByteBuffer filedata, @Cast("size_t") long filesize );
public static native PIX pixReadMemWebP( @Cast("const l_uint8*") byte[] filedata, @Cast("size_t") long filesize );
public static native @Cast("l_ok") int readHeaderWebP( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderWebP( String filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderWebP( @Cast("const char*") BytePointer filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int readHeaderWebP( String filename, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderWebP( @Cast("const char*") BytePointer filename, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderWebP( String filename, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int readHeaderMemWebP( @Cast("const l_uint8*") BytePointer data, @Cast("size_t") long size, @Cast("l_int32*") IntPointer pw, @Cast("l_int32*") IntPointer ph, @Cast("l_int32*") IntPointer pspp );
public static native @Cast("l_ok") int readHeaderMemWebP( @Cast("const l_uint8*") ByteBuffer data, @Cast("size_t") long size, @Cast("l_int32*") IntBuffer pw, @Cast("l_int32*") IntBuffer ph, @Cast("l_int32*") IntBuffer pspp );
public static native @Cast("l_ok") int readHeaderMemWebP( @Cast("const l_uint8*") byte[] data, @Cast("size_t") long size, @Cast("l_int32*") int[] pw, @Cast("l_int32*") int[] ph, @Cast("l_int32*") int[] pspp );
public static native @Cast("l_ok") int pixWriteWebP( @Cast("const char*") BytePointer filename, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteWebP( String filename, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteStreamWebP( @Cast("FILE*") Pointer fp, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteMemWebP( @Cast("l_uint8**") PointerPointer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteMemWebP( @Cast("l_uint8**") @ByPtrPtr BytePointer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteMemWebP( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pencdata, @Cast("size_t*") SizeTPointer pencsize, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_ok") int pixWriteMemWebP( @Cast("l_uint8**") @ByPtrPtr byte[] pencdata, @Cast("size_t*") SizeTPointer pencsize, PIX pixs, @Cast("l_int32") int quality, @Cast("l_int32") int lossless );
public static native @Cast("l_int32") int l_jpegSetQuality( @Cast("l_int32") int new_quality );
public static native void setLeptDebugOK( @Cast("l_int32") int allow );
public static native @Cast("l_ok") int pixaWriteFiles( @Cast("const char*") BytePointer rootname, PIXA pixa, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixaWriteFiles( String rootname, PIXA pixa, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteDebug( @Cast("const char*") BytePointer fname, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteDebug( String fname, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWrite( @Cast("const char*") BytePointer fname, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWrite( String fname, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteAutoFormat( @Cast("const char*") BytePointer filename, PIX pix );
public static native @Cast("l_ok") int pixWriteAutoFormat( String filename, PIX pix );
public static native @Cast("l_ok") int pixWriteStream( @Cast("FILE*") Pointer fp, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteImpliedFormat( @Cast("const char*") BytePointer filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_ok") int pixWriteImpliedFormat( String filename, PIX pix, @Cast("l_int32") int quality, @Cast("l_int32") int progressive );
public static native @Cast("l_int32") int pixChooseOutputFormat( PIX pix );
public static native @Cast("l_int32") int getImpliedFileFormat( @Cast("const char*") BytePointer filename );
public static native @Cast("l_int32") int getImpliedFileFormat( String filename );
public static native @Cast("l_ok") int pixGetAutoFormat( PIX pix, @Cast("l_int32*") IntPointer pformat );
public static native @Cast("l_ok") int pixGetAutoFormat( PIX pix, @Cast("l_int32*") IntBuffer pformat );
public static native @Cast("l_ok") int pixGetAutoFormat( PIX pix, @Cast("l_int32*") int[] pformat );
public static native @Cast("const char*") BytePointer getFormatExtension( @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteMem( @Cast("l_uint8**") PointerPointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteMem( @Cast("l_uint8**") @ByPtrPtr BytePointer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteMem( @Cast("l_uint8**") @ByPtrPtr ByteBuffer pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int pixWriteMem( @Cast("l_uint8**") @ByPtrPtr byte[] pdata, @Cast("size_t*") SizeTPointer psize, PIX pix, @Cast("l_int32") int format );
public static native @Cast("l_ok") int l_fileDisplay( @Cast("const char*") BytePointer fname, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int l_fileDisplay( String fname, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("l_float32") float scale );
public static native @Cast("l_ok") int pixDisplay( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y );
public static native @Cast("l_ok") int pixDisplayWithTitle( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, @Cast("const char*") BytePointer title, @Cast("l_int32") int dispflag );
public static native @Cast("l_ok") int pixDisplayWithTitle( PIX pixs, @Cast("l_int32") int x, @Cast("l_int32") int y, String title, @Cast("l_int32") int dispflag );
public static native PIX pixMakeColorSquare( @Cast("l_uint32") int color, @Cast("l_int32") int size, @Cast("l_int32") int addlabel, @Cast("l_int32") int location, @Cast("l_uint32") int textcolor );
public static native void l_chooseDisplayProg( @Cast("l_int32") int selection );
public static native void changeFormatForMissingLib( @Cast("l_int32*") IntPointer pformat );
public static native void changeFormatForMissingLib( @Cast("l_int32*") IntBuffer pformat );
public static native void changeFormatForMissingLib( @Cast("l_int32*") int[] pformat );
public static native @Cast("l_ok") int pixDisplayWrite( PIX pixs, @Cast("l_int32") int reduction );
public static native @Cast("l_uint8*") BytePointer zlibCompress( @Cast("const l_uint8*") BytePointer datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_uint8*") ByteBuffer zlibCompress( @Cast("const l_uint8*") ByteBuffer datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_uint8*") byte[] zlibCompress( @Cast("const l_uint8*") byte[] datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_uint8*") BytePointer zlibUncompress( @Cast("const l_uint8*") BytePointer datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_uint8*") ByteBuffer zlibUncompress( @Cast("const l_uint8*") ByteBuffer datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );
public static native @Cast("l_uint8*") byte[] zlibUncompress( @Cast("const l_uint8*") byte[] datain, @Cast("size_t") long nin, @Cast("size_t*") SizeTPointer pnout );

// #ifdef __cplusplus
// #endif  /* __cplusplus */
// #endif /* NO_PROTOS */


// #endif /* LEPTONICA_ALLHEADERS_H */



}
