// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.libdc1394;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.libdc1394.global.dc1394.*;


/**
 * Video frame structure.
 *
 * dc1394video_frame_t is the structure returned by the capture functions. It contains the captured image as well as a number of
 * information. 
 *
 * In general this structure should be calloc'ed so that members such as "allocated size"
 * are properly set to zero. Don't forget to free the "image" member before freeing the struct itself.
 */
@Properties(inherit = org.bytedeco.libdc1394.presets.dc1394.class)
public class dc1394video_frame_t extends dc1394video_frame_t_abstract {
    static { Loader.load(); }
    /** Default native constructor. */
    public dc1394video_frame_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public dc1394video_frame_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public dc1394video_frame_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public dc1394video_frame_t position(long position) {
        return (dc1394video_frame_t)super.position(position);
    }
    @Override public dc1394video_frame_t getPointer(long i) {
        return new dc1394video_frame_t(this).position(position + i);
    }

    public native @Cast("unsigned char*") BytePointer image(); public native dc1394video_frame_t image(BytePointer setter);                 /* the image. May contain padding data too (vendor specific). Read/write allowed. Free NOT allowed if
						       returned by dc1394_capture_dequeue() */
    public native @Cast("uint32_t") int size(int i); public native dc1394video_frame_t size(int i, int setter);
    @MemberGetter public native @Cast("uint32_t*") IntPointer size();               /* the image size [width, height] */
    public native @Cast("uint32_t") @Name("position") int _position(int i); public native dc1394video_frame_t _position(int i, int setter);
    @MemberGetter public native @Cast("uint32_t*") @Name("position") IntPointer _position();           /* the WOI/ROI position [horizontal, vertical] == [0,0] for full frame */
    public native @Cast("dc1394color_coding_t") int color_coding(); public native dc1394video_frame_t color_coding(int setter);          /* the color coding used. This field is valid for all video modes. */
    public native @Cast("dc1394color_filter_t") int color_filter(); public native dc1394video_frame_t color_filter(int setter);          /* the color filter used. This field is valid only for RAW modes and IIDC 1.31 */
    public native @Cast("uint32_t") int yuv_byte_order(); public native dc1394video_frame_t yuv_byte_order(int setter);        /* the order of the fields for 422 formats: YUYV or UYVY */
    public native @Cast("uint32_t") int data_depth(); public native dc1394video_frame_t data_depth(int setter);            /* the number of bits per pixel. The number of grayscale levels is 2^(this_number).
                                                       This is independent from the colour coding */
    public native @Cast("uint32_t") int stride(); public native dc1394video_frame_t stride(int setter);                /* the number of bytes per image line */
    public native @Cast("dc1394video_mode_t") int video_mode(); public native dc1394video_frame_t video_mode(int setter);            /* the video mode used for capturing this frame */
    public native @Cast("uint64_t") long total_bytes(); public native dc1394video_frame_t total_bytes(long setter);           /* the total size of the frame buffer in bytes. May include packet-
                                                       multiple padding and intentional padding (vendor specific) */
    public native @Cast("uint32_t") int image_bytes(); public native dc1394video_frame_t image_bytes(int setter);           /* the number of bytes used for the image (image data only, no padding) */
    public native @Cast("uint32_t") int padding_bytes(); public native dc1394video_frame_t padding_bytes(int setter);         /* the number of extra bytes, i.e. total_bytes-image_bytes.  */
    public native @Cast("uint32_t") int packet_size(); public native dc1394video_frame_t packet_size(int setter);           /* the size of a packet in bytes. (IIDC data) */
    public native @Cast("uint32_t") int packets_per_frame(); public native dc1394video_frame_t packets_per_frame(int setter);     /* the number of packets per frame. (IIDC data) */
    public native @Cast("uint64_t") long timestamp(); public native dc1394video_frame_t timestamp(long setter);             /* the unix time [microseconds] at which the frame was captured in
                                                       the video1394 ringbuffer */
    public native @Cast("uint32_t") int frames_behind(); public native dc1394video_frame_t frames_behind(int setter);         /* the number of frames in the ring buffer that are yet to be accessed by the user */
    public native dc1394camera_t camera(); public native dc1394video_frame_t camera(dc1394camera_t setter);               /* the parent camera of this frame */
    public native @Cast("uint32_t") int id(); public native dc1394video_frame_t id(int setter);                    /* the frame position in the ring buffer */
    public native @Cast("uint64_t") long allocated_image_bytes(); public native dc1394video_frame_t allocated_image_bytes(long setter); /* amount of memory allocated in for the *image field. */
    public native @Cast("dc1394bool_t") int little_endian(); public native dc1394video_frame_t little_endian(int setter);         /* DC1394_TRUE if little endian (16bpp modes only),
                                                       DC1394_FALSE otherwise */
    public native @Cast("dc1394bool_t") int data_in_padding(); public native dc1394video_frame_t data_in_padding(int setter);       /* DC1394_TRUE if data is present in the padding bytes in IIDC 1.32 format,
                                                       DC1394_FALSE otherwise */
}
