// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.libraw.global;

import org.bytedeco.libraw.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class LibRaw extends org.bytedeco.libraw.presets.LibRaw {
    static { Loader.load(); }

// Parsed from libraw/libraw_const.h

/* -*- C++ -*-
 * File: libraw_const.h
 * Copyright 2008-2021 LibRaw LLC (info@libraw.org)
 * Created: Sat Mar  8 , 2008
 * LibRaw error codes
LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
   (See file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
   (See file LICENSE.CDDL provided in LibRaw distribution archive for details).

 */

// #ifndef _LIBRAW_ERRORS_H
// #define _LIBRAW_ERRORS_H

public static final double LIBRAW_DEFAULT_ADJUST_MAXIMUM_THRESHOLD = 0.75f;
public static final double LIBRAW_DEFAULT_AUTO_BRIGHTNESS_THRESHOLD = 0.01f;
/* limit allocation size, default is 2Gb */
// #ifndef LIBRAW_MAX_ALLOC_MB_DEFAULT
public static final long LIBRAW_MAX_ALLOC_MB_DEFAULT = 2048L;
// #endif

// #ifndef LIBRAW_MAX_NONDNG_RAW_FILE_SIZE
public static final long LIBRAW_MAX_NONDNG_RAW_FILE_SIZE = 2147483647L;
// #endif

// #ifndef LIBRAW_MAX_DNG_RAW_FILE_SIZE
// #ifdef USE_DNGSDK
// #else
public static final long LIBRAW_MAX_DNG_RAW_FILE_SIZE = 2147483647L;
// #endif
// #endif


/* limit thumbnail size, default is 512Mb*/
// #ifndef LIBRAW_MAX_THUMBNAIL_MB
public static final long LIBRAW_MAX_THUMBNAIL_MB = 512L;
// #endif

/* Check if enough file space exists before tag read */
// #ifndef LIBRAW_NO_IOSPACE_CHECK
// #define LIBRAW_IOSPACE_CHECK
// #endif
// #ifndef LIBRAW_NO_CR3_MEMPOOL
// #define LIBRAW_CR3_MEMPOOL
// #endif



/* LibRaw uses own memory pool management, with LIBRAW_MSIZE (512)
entries. It is enough for parsing/decoding non-damaged files, but
may overflow on specially crafted files (eg. with many string values
like XMP blocks.
LIBRAW_MEMPOOL_CHECK define will result in error on pool overflow */
// #ifndef LIBRAW_NO_MEMPOOL_CHECK
// #define LIBRAW_MEMPOOL_CHECK
// #endif

public static final int LIBRAW_MAX_METADATA_BLOCKS = 1024;
public static final int LIBRAW_CBLACK_SIZE = 4104;
public static final int LIBRAW_IFD_MAXCOUNT = 10;
public static final int LIBRAW_THUMBNAIL_MAXCOUNT = 8;
public static final int LIBRAW_CRXTRACKS_MAXCOUNT = 16;
public static final int LIBRAW_AFDATA_MAXCOUNT = 4;

public static final int LIBRAW_AHD_TILE = 512;

// #ifndef LIBRAW_NO_IOSTREAMS_DATASTREAM
// #endif

public enum LibRaw_openbayer_patterns {
  LIBRAW_OPENBAYER_RGGB(0x94),
  LIBRAW_OPENBAYER_BGGR(0x16),
  LIBRAW_OPENBAYER_GRBG(0x61),
  LIBRAW_OPENBAYER_GBRG(0x49);

    public final int value;
    private LibRaw_openbayer_patterns(int v) { this.value = v; }
    private LibRaw_openbayer_patterns(LibRaw_openbayer_patterns e) { this.value = e.value; }
    public LibRaw_openbayer_patterns intern() { for (LibRaw_openbayer_patterns e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_dngfields_marks {
  LIBRAW_DNGFM_FORWARDMATRIX(1),
  LIBRAW_DNGFM_ILLUMINANT(1 << 1),
  LIBRAW_DNGFM_COLORMATRIX(1 << 2),
  LIBRAW_DNGFM_CALIBRATION(1 << 3),
  LIBRAW_DNGFM_ANALOGBALANCE(1 << 4),
  LIBRAW_DNGFM_BLACK(1 << 5),
  LIBRAW_DNGFM_WHITE(1 << 6),
  LIBRAW_DNGFM_OPCODE2(1 << 7),
  LIBRAW_DNGFM_LINTABLE(1 << 8),
  LIBRAW_DNGFM_CROPORIGIN(1 << 9),
  LIBRAW_DNGFM_CROPSIZE(1 << 10),
  LIBRAW_DNGFM_PREVIEWCS(1 << 11),
  LIBRAW_DNGFM_ASSHOTNEUTRAL(1 << 12),
  LIBRAW_DNGFM_BASELINEEXPOSURE(1 << 13),
  LIBRAW_DNGFM_LINEARRESPONSELIMIT(1 << 14),
  LIBRAW_DNGFM_USERCROP(1 << 15),
  LIBRAW_DNGFM_OPCODE1(1 << 16),
  LIBRAW_DNGFM_OPCODE3(1 << 17);

    public final int value;
    private LibRaw_dngfields_marks(int v) { this.value = v; }
    private LibRaw_dngfields_marks(LibRaw_dngfields_marks e) { this.value = e.value; }
    public LibRaw_dngfields_marks intern() { for (LibRaw_dngfields_marks e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_As_Shot_WB_Applied_codes {
  LIBRAW_ASWB_APPLIED(1),
  LIBRAW_ASWB_CANON(2),
  LIBRAW_ASWB_NIKON(4),
  LIBRAW_ASWB_NIKON_SRAW(8),
  LIBRAW_ASWB_PENTAX(16);

    public final int value;
    private LibRaw_As_Shot_WB_Applied_codes(int v) { this.value = v; }
    private LibRaw_As_Shot_WB_Applied_codes(LibRaw_As_Shot_WB_Applied_codes e) { this.value = e.value; }
    public LibRaw_As_Shot_WB_Applied_codes intern() { for (LibRaw_As_Shot_WB_Applied_codes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// #define tagtypeIs(typex) (type == typex)
public enum LibRaw_ExifTagTypes {
  LIBRAW_EXIFTAG_TYPE_UNKNOWN  (0),
  LIBRAW_EXIFTAG_TYPE_BYTE     (1),
  LIBRAW_EXIFTAG_TYPE_ASCII    (2),
  LIBRAW_EXIFTAG_TYPE_SHORT    (3),
  LIBRAW_EXIFTAG_TYPE_LONG     (4),
  LIBRAW_EXIFTAG_TYPE_RATIONAL (5),
  LIBRAW_EXIFTAG_TYPE_SBYTE    (6),
  LIBRAW_EXIFTAG_TYPE_UNDEFINED(7),
  LIBRAW_EXIFTAG_TYPE_SSHORT   (8),
  LIBRAW_EXIFTAG_TYPE_SLONG    (9),
  LIBRAW_EXIFTAG_TYPE_SRATIONAL(10),
  LIBRAW_EXIFTAG_TYPE_FLOAT    (11),
  LIBRAW_EXIFTAG_TYPE_DOUBLE   (12),
  LIBRAW_EXIFTAG_TYPE_IFD      (13),
  LIBRAW_EXIFTAG_TYPE_UNICODE  (14),
  LIBRAW_EXIFTAG_TYPE_COMPLEX  (15),
  LIBRAW_EXIFTAG_TYPE_LONG8    (16),
  LIBRAW_EXIFTAG_TYPE_SLONG8   (17),
  LIBRAW_EXIFTAG_TYPE_IFD8     (18);

    public final int value;
    private LibRaw_ExifTagTypes(int v) { this.value = v; }
    private LibRaw_ExifTagTypes(LibRaw_ExifTagTypes e) { this.value = e.value; }
    public LibRaw_ExifTagTypes intern() { for (LibRaw_ExifTagTypes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// #define LIBRAW_EXIFTOOLTAGTYPE_int8u       LIBRAW_EXIFTAG_TYPE_BYTE
// #define LIBRAW_EXIFTOOLTAGTYPE_string      LIBRAW_EXIFTAG_TYPE_ASCII
// #define LIBRAW_EXIFTOOLTAGTYPE_int16u      LIBRAW_EXIFTAG_TYPE_SHORT
// #define LIBRAW_EXIFTOOLTAGTYPE_int32u      LIBRAW_EXIFTAG_TYPE_LONG
// #define LIBRAW_EXIFTOOLTAGTYPE_rational64u LIBRAW_EXIFTAG_TYPE_RATIONAL
// #define LIBRAW_EXIFTOOLTAGTYPE_int8s       LIBRAW_EXIFTAG_TYPE_SBYTE
// #define LIBRAW_EXIFTOOLTAGTYPE_undef       LIBRAW_EXIFTAG_TYPE_UNDEFINED
// #define LIBRAW_EXIFTOOLTAGTYPE_binary      LIBRAW_EXIFTAG_TYPE_UNDEFINED
// #define LIBRAW_EXIFTOOLTAGTYPE_int16s      LIBRAW_EXIFTAG_TYPE_SSHORT
// #define LIBRAW_EXIFTOOLTAGTYPE_int32s      LIBRAW_EXIFTAG_TYPE_SLONG
// #define LIBRAW_EXIFTOOLTAGTYPE_rational64s LIBRAW_EXIFTAG_TYPE_SRATIONAL
// #define LIBRAW_EXIFTOOLTAGTYPE_float       LIBRAW_EXIFTAG_TYPE_FLOAT
// #define LIBRAW_EXIFTOOLTAGTYPE_double      LIBRAW_EXIFTAG_TYPE_DOUBLE
// #define LIBRAW_EXIFTOOLTAGTYPE_ifd         LIBRAW_EXIFTAG_TYPE_IFD
// #define LIBRAW_EXIFTOOLTAGTYPE_unicode     LIBRAW_EXIFTAG_TYPE_UNICODE
// #define LIBRAW_EXIFTOOLTAGTYPE_complex     LIBRAW_EXIFTAG_TYPE_COMPLEX
// #define LIBRAW_EXIFTOOLTAGTYPE_int64u      LIBRAW_EXIFTAG_TYPE_LONG8
// #define LIBRAW_EXIFTOOLTAGTYPE_int64s      LIBRAW_EXIFTAG_TYPE_SLONG8
// #define LIBRAW_EXIFTOOLTAGTYPE_ifd64       LIBRAW_EXIFTAG_TYPE_IFD8

public static final long LIBRAW_LENS_NOT_SET = 0xffffffffffffffffL;

public enum LibRaw_whitebalance_code {
// clang-format off
  /*
      EXIF light sources
      12 = FL-D; Daylight fluorescent (D 5700K – 7100K) (F1,F5)
      13 = FL-N; Day white fluorescent (N 4600K – 5400K) (F7,F8)
      14 = FL-W; Cool white fluorescent (W 3900K – 4500K) (F2,F6, office, store, warehouse)
      15 = FL-WW; White fluorescent (WW 3200K – 3700K) (F3, residential)
      16 = FL-L; Soft/Warm white fluorescent (L 2600K - 3250K) (F4, kitchen, bath)
  */
//clang-format on
  LIBRAW_WBI_Unknown(0),
  LIBRAW_WBI_Daylight(1),
  LIBRAW_WBI_Fluorescent(2),
  LIBRAW_WBI_Tungsten(3),
  LIBRAW_WBI_Flash(4),
  LIBRAW_WBI_FineWeather(9),
  LIBRAW_WBI_Cloudy(10),
  LIBRAW_WBI_Shade(11),
  LIBRAW_WBI_FL_D(12),
  LIBRAW_WBI_FL_N(13),
  LIBRAW_WBI_FL_W(14),
  LIBRAW_WBI_FL_WW(15),
  LIBRAW_WBI_FL_L(16),
  LIBRAW_WBI_Ill_A(17),
  LIBRAW_WBI_Ill_B(18),
  LIBRAW_WBI_Ill_C(19),
  LIBRAW_WBI_D55(20),
  LIBRAW_WBI_D65(21),
  LIBRAW_WBI_D75(22),
  LIBRAW_WBI_D50(23),
  LIBRAW_WBI_StudioTungsten(24),
  LIBRAW_WBI_Sunset(64),
  LIBRAW_WBI_Underwater(65),
  LIBRAW_WBI_FluorescentHigh(66),
  LIBRAW_WBI_HT_Mercury(67),
  LIBRAW_WBI_AsShot(81),
  LIBRAW_WBI_Auto(82),
  LIBRAW_WBI_Custom(83),
  LIBRAW_WBI_Auto1(85),
  LIBRAW_WBI_Auto2(86),
  LIBRAW_WBI_Auto3(87),
  LIBRAW_WBI_Auto4(88),
  LIBRAW_WBI_Custom1(90),
  LIBRAW_WBI_Custom2(91),
  LIBRAW_WBI_Custom3(92),
  LIBRAW_WBI_Custom4(93),
  LIBRAW_WBI_Custom5(94),
  LIBRAW_WBI_Custom6(95),
  LIBRAW_WBI_PC_Set1(96),
  LIBRAW_WBI_PC_Set2(97),
  LIBRAW_WBI_PC_Set3(98),
  LIBRAW_WBI_PC_Set4(99),
  LIBRAW_WBI_PC_Set5(100),
  LIBRAW_WBI_Measured(110),
  LIBRAW_WBI_BW(120),
  LIBRAW_WBI_Kelvin(254),
  LIBRAW_WBI_Other(255),
  LIBRAW_WBI_None(0xffff);

    public final int value;
    private LibRaw_whitebalance_code(int v) { this.value = v; }
    private LibRaw_whitebalance_code(LibRaw_whitebalance_code e) { this.value = e.value; }
    public LibRaw_whitebalance_code intern() { for (LibRaw_whitebalance_code e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_MultiExposure_related {
  LIBRAW_ME_NONE(0),
  LIBRAW_ME_SIMPLE(1),
  LIBRAW_ME_OVERLAY(2),
  LIBRAW_ME_HDR(3);

    public final int value;
    private LibRaw_MultiExposure_related(int v) { this.value = v; }
    private LibRaw_MultiExposure_related(LibRaw_MultiExposure_related e) { this.value = e.value; }
    public LibRaw_MultiExposure_related intern() { for (LibRaw_MultiExposure_related e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_dng_processing {
  LIBRAW_DNG_NONE(0),
  LIBRAW_DNG_FLOAT(1),
  LIBRAW_DNG_LINEAR(2),
  LIBRAW_DNG_DEFLATE(4),
  LIBRAW_DNG_XTRANS(8),
  LIBRAW_DNG_OTHER(16),
  LIBRAW_DNG_8BIT(32);

    public final int value;
    private LibRaw_dng_processing(int v) { this.value = v; }
    private LibRaw_dng_processing(LibRaw_dng_processing e) { this.value = e.value; }
    public LibRaw_dng_processing intern() { for (LibRaw_dng_processing e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_output_flags {
    LIBRAW_OUTPUT_FLAGS_NONE(0),
    LIBRAW_OUTPUT_FLAGS_PPMMETA(1);

    public final int value;
    private LibRaw_output_flags(int v) { this.value = v; }
    private LibRaw_output_flags(LibRaw_output_flags e) { this.value = e.value; }
    public LibRaw_output_flags intern() { for (LibRaw_output_flags e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_runtime_capabilities {
  LIBRAW_CAPS_RAWSPEED(1),
  LIBRAW_CAPS_DNGSDK(1<<1),
  LIBRAW_CAPS_GPRSDK(1<<2),
  LIBRAW_CAPS_UNICODEPATHS(1<<3),
  LIBRAW_CAPS_X3FTOOLS(1<<4),
  LIBRAW_CAPS_RPI6BY9(1<<5),
  LIBRAW_CAPS_ZLIB(1<<6),
  LIBRAW_CAPS_JPEG(1<<7),
  LIBRAW_CAPS_RAWSPEED3(1<<8),
  LIBRAW_CAPS_RAWSPEED_BITS(1<<9);

    public final int value;
    private LibRaw_runtime_capabilities(int v) { this.value = v; }
    private LibRaw_runtime_capabilities(LibRaw_runtime_capabilities e) { this.value = e.value; }
    public LibRaw_runtime_capabilities intern() { for (LibRaw_runtime_capabilities e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_colorspace {
  LIBRAW_COLORSPACE_NotFound(0),
  LIBRAW_COLORSPACE_sRGB(1),
  LIBRAW_COLORSPACE_AdobeRGB(2),
  LIBRAW_COLORSPACE_WideGamutRGB(3),
  LIBRAW_COLORSPACE_ProPhotoRGB(4),
  LIBRAW_COLORSPACE_ICC(5),
  LIBRAW_COLORSPACE_Uncalibrated(6), // Tag 0x0001 InteropIndex containing "R03" + LIBRAW_COLORSPACE_Uncalibrated = Adobe RGB
  LIBRAW_COLORSPACE_CameraLinearUniWB(7),
  LIBRAW_COLORSPACE_CameraLinear(8),
  LIBRAW_COLORSPACE_CameraGammaUniWB(9),
  LIBRAW_COLORSPACE_CameraGamma(10),
  LIBRAW_COLORSPACE_MonochromeLinear(11),
  LIBRAW_COLORSPACE_MonochromeGamma(12),
  LIBRAW_COLORSPACE_Unknown(255);

    public final int value;
    private LibRaw_colorspace(int v) { this.value = v; }
    private LibRaw_colorspace(LibRaw_colorspace e) { this.value = e.value; }
    public LibRaw_colorspace intern() { for (LibRaw_colorspace e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_cameramaker_index {
  LIBRAW_CAMERAMAKER_Unknown(0),
  LIBRAW_CAMERAMAKER_Agfa(1),
  LIBRAW_CAMERAMAKER_Alcatel(2),
  LIBRAW_CAMERAMAKER_Apple(3),
  LIBRAW_CAMERAMAKER_Aptina(4),
  LIBRAW_CAMERAMAKER_AVT(5),
  LIBRAW_CAMERAMAKER_Baumer(6),
  LIBRAW_CAMERAMAKER_Broadcom(7),
  LIBRAW_CAMERAMAKER_Canon(8),
  LIBRAW_CAMERAMAKER_Casio(9),
  LIBRAW_CAMERAMAKER_CINE(10),
  LIBRAW_CAMERAMAKER_Clauss(11),
  LIBRAW_CAMERAMAKER_Contax(12),
  LIBRAW_CAMERAMAKER_Creative(13),
  LIBRAW_CAMERAMAKER_DJI(14),
  LIBRAW_CAMERAMAKER_DXO(15),
  LIBRAW_CAMERAMAKER_Epson(16),
  LIBRAW_CAMERAMAKER_Foculus(17),
  LIBRAW_CAMERAMAKER_Fujifilm(18),
  LIBRAW_CAMERAMAKER_Generic(19),
  LIBRAW_CAMERAMAKER_Gione(20),
  LIBRAW_CAMERAMAKER_GITUP(21),
  LIBRAW_CAMERAMAKER_Google(22),
  LIBRAW_CAMERAMAKER_GoPro(23),
  LIBRAW_CAMERAMAKER_Hasselblad(24),
  LIBRAW_CAMERAMAKER_HTC(25),
  LIBRAW_CAMERAMAKER_I_Mobile(26),
  LIBRAW_CAMERAMAKER_Imacon(27),
  LIBRAW_CAMERAMAKER_JK_Imaging(28),
  LIBRAW_CAMERAMAKER_Kodak(29),
  LIBRAW_CAMERAMAKER_Konica(30),
  LIBRAW_CAMERAMAKER_Leaf(31),
  LIBRAW_CAMERAMAKER_Leica(32),
  LIBRAW_CAMERAMAKER_Lenovo(33),
  LIBRAW_CAMERAMAKER_LG(34),
  LIBRAW_CAMERAMAKER_Logitech(35),
  LIBRAW_CAMERAMAKER_Mamiya(36),
  LIBRAW_CAMERAMAKER_Matrix(37),
  LIBRAW_CAMERAMAKER_Meizu(38),
  LIBRAW_CAMERAMAKER_Micron(39),
  LIBRAW_CAMERAMAKER_Minolta(40),
  LIBRAW_CAMERAMAKER_Motorola(41),
  LIBRAW_CAMERAMAKER_NGM(42),
  LIBRAW_CAMERAMAKER_Nikon(43),
  LIBRAW_CAMERAMAKER_Nokia(44),
  LIBRAW_CAMERAMAKER_Olympus(45),
  LIBRAW_CAMERAMAKER_OmniVison(46),
  LIBRAW_CAMERAMAKER_Panasonic(47),
  LIBRAW_CAMERAMAKER_Parrot(48),
  LIBRAW_CAMERAMAKER_Pentax(49),
  LIBRAW_CAMERAMAKER_PhaseOne(50),
  LIBRAW_CAMERAMAKER_PhotoControl(51),
  LIBRAW_CAMERAMAKER_Photron(52),
  LIBRAW_CAMERAMAKER_Pixelink(53),
  LIBRAW_CAMERAMAKER_Polaroid(54),
  LIBRAW_CAMERAMAKER_RED(55),
  LIBRAW_CAMERAMAKER_Ricoh(56),
  LIBRAW_CAMERAMAKER_Rollei(57),
  LIBRAW_CAMERAMAKER_RoverShot(58),
  LIBRAW_CAMERAMAKER_Samsung(59),
  LIBRAW_CAMERAMAKER_Sigma(60),
  LIBRAW_CAMERAMAKER_Sinar(61),
  LIBRAW_CAMERAMAKER_SMaL(62),
  LIBRAW_CAMERAMAKER_Sony(63),
  LIBRAW_CAMERAMAKER_ST_Micro(64),
  LIBRAW_CAMERAMAKER_THL(65),
  LIBRAW_CAMERAMAKER_VLUU(66),
  LIBRAW_CAMERAMAKER_Xiaomi(67),
  LIBRAW_CAMERAMAKER_XIAOYI(68),
  LIBRAW_CAMERAMAKER_YI(69),
  LIBRAW_CAMERAMAKER_Yuneec(70),
  LIBRAW_CAMERAMAKER_Zeiss(71),
  LIBRAW_CAMERAMAKER_OnePlus(72),
  LIBRAW_CAMERAMAKER_ISG(73),
  LIBRAW_CAMERAMAKER_VIVO(74),
  LIBRAW_CAMERAMAKER_HMD_Global(75),
  LIBRAW_CAMERAMAKER_HUAWEI(76),
  LIBRAW_CAMERAMAKER_RaspberryPi(77),
  LIBRAW_CAMERAMAKER_OmDigital(78),

  // Insert additional indexes here
  LIBRAW_CAMERAMAKER_TheLastOne(79);

    public final int value;
    private LibRaw_cameramaker_index(int v) { this.value = v; }
    private LibRaw_cameramaker_index(LibRaw_cameramaker_index e) { this.value = e.value; }
    public LibRaw_cameramaker_index intern() { for (LibRaw_cameramaker_index e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_camera_mounts {
  LIBRAW_MOUNT_Unknown(0),
  LIBRAW_MOUNT_Alpa(1),
  LIBRAW_MOUNT_C(2),              /* C-mount */
  LIBRAW_MOUNT_Canon_EF_M(3),
  LIBRAW_MOUNT_Canon_EF_S(4),
  LIBRAW_MOUNT_Canon_EF(5),
  LIBRAW_MOUNT_Canon_RF(6),
  LIBRAW_MOUNT_Contax_N(7),
  LIBRAW_MOUNT_Contax645(8),
  LIBRAW_MOUNT_FT(9),             /* original 4/3 */
  LIBRAW_MOUNT_mFT(10),            /* micro 4/3 */
  LIBRAW_MOUNT_Fuji_GF(11),        /* Fujifilm GFX cameras, G mount */
  LIBRAW_MOUNT_Fuji_GX(12),        /* Fujifilm GX680 */
  LIBRAW_MOUNT_Fuji_X(13),
  LIBRAW_MOUNT_Hasselblad_H(14),   /* Hasselblad Hn cameras, HC & HCD lenses */
  LIBRAW_MOUNT_Hasselblad_V(15),
  LIBRAW_MOUNT_Hasselblad_XCD(16), /* Hasselblad Xn cameras, XCD lenses */
  LIBRAW_MOUNT_Leica_M(17),        /* Leica rangefinder bayonet */
  LIBRAW_MOUNT_Leica_R(18),        /* Leica SLRs, 'R' for reflex */
  LIBRAW_MOUNT_Leica_S(19),        /* LIBRAW_FORMAT_LeicaS 'MF' */
  LIBRAW_MOUNT_Leica_SL(20),       /* lens, mounts on 'L' throat, FF */
  LIBRAW_MOUNT_Leica_TL(21),       /* lens, mounts on 'L' throat, APS-C */
  LIBRAW_MOUNT_LPS_L(22),          /* Leica/Panasonic/Sigma camera mount, takes L, SL and TL lenses */
  LIBRAW_MOUNT_Mamiya67(23),       /* Mamiya RB67, RZ67 */
  LIBRAW_MOUNT_Mamiya645(24),
  LIBRAW_MOUNT_Minolta_A(25),
  LIBRAW_MOUNT_Nikon_CX(26),       /* used in 'Nikon 1' series */
  LIBRAW_MOUNT_Nikon_F(27),
  LIBRAW_MOUNT_Nikon_Z(28),
  LIBRAW_MOUNT_PhaseOne_iXM_MV(29),
  LIBRAW_MOUNT_PhaseOne_iXM_RS(30),
  LIBRAW_MOUNT_PhaseOne_iXM(31),
  LIBRAW_MOUNT_Pentax_645(32),
  LIBRAW_MOUNT_Pentax_K(33),
  LIBRAW_MOUNT_Pentax_Q(34),
  LIBRAW_MOUNT_RicohModule(35),
  LIBRAW_MOUNT_Rollei_bayonet(36), /* Rollei Hy-6: Leaf AFi, Sinar Hy6- models */
  LIBRAW_MOUNT_Samsung_NX_M(37),
  LIBRAW_MOUNT_Samsung_NX(38),
  LIBRAW_MOUNT_Sigma_X3F(39),
  LIBRAW_MOUNT_Sony_E(40),
  LIBRAW_MOUNT_LF(41),
  LIBRAW_MOUNT_DigitalBack(42),
  LIBRAW_MOUNT_FixedLens(43),
  LIBRAW_MOUNT_IL_UM(44),          /* Interchangeable lens, mount unknown */
  LIBRAW_MOUNT_TheLastOne(45);

    public final int value;
    private LibRaw_camera_mounts(int v) { this.value = v; }
    private LibRaw_camera_mounts(LibRaw_camera_mounts e) { this.value = e.value; }
    public LibRaw_camera_mounts intern() { for (LibRaw_camera_mounts e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_camera_formats {
  LIBRAW_FORMAT_Unknown(0),
  LIBRAW_FORMAT_APSC(1),
  LIBRAW_FORMAT_FF(2),
  LIBRAW_FORMAT_MF(3),
  LIBRAW_FORMAT_APSH(4),
  LIBRAW_FORMAT_1INCH(5),
  LIBRAW_FORMAT_1div2p3INCH(6),  /* 1/2.3" */
  LIBRAW_FORMAT_1div1p7INCH(7),  /* 1/1.7" */
  LIBRAW_FORMAT_FT(8),           /* sensor size in FT & mFT cameras */
  LIBRAW_FORMAT_CROP645(9),      /* 44x33mm */
  LIBRAW_FORMAT_LeicaS(10),       /* 'MF' Leicas */
  LIBRAW_FORMAT_645(11),
  LIBRAW_FORMAT_66(12),
  LIBRAW_FORMAT_69(13),
  LIBRAW_FORMAT_LF(14),
  LIBRAW_FORMAT_Leica_DMR(15),
  LIBRAW_FORMAT_67(16),
  LIBRAW_FORMAT_SigmaAPSC(17),    /* DP1, DP2, SD15, SD14, SD10, SD9 */
  LIBRAW_FORMAT_SigmaMerrill(18), /* SD1,  'SD1 Merrill',  'DP1 Merrill',  'DP2 Merrill' */
  LIBRAW_FORMAT_SigmaAPSH(19),    /* 'sd Quattro H' */
  LIBRAW_FORMAT_3648(20),         /* DALSA FTF4052C (Mamiya ZD) */
  LIBRAW_FORMAT_68(21),           /* Fujifilm GX680 */
  LIBRAW_FORMAT_TheLastOne(22);

    public final int value;
    private LibRaw_camera_formats(int v) { this.value = v; }
    private LibRaw_camera_formats(LibRaw_camera_formats e) { this.value = e.value; }
    public LibRaw_camera_formats intern() { for (LibRaw_camera_formats e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRawImageAspects {
  LIBRAW_IMAGE_ASPECT_UNKNOWN(0),
  LIBRAW_IMAGE_ASPECT_OTHER(1),
  LIBRAW_IMAGE_ASPECT_MINIMAL_REAL_ASPECT_VALUE(99), /* 1:10*/
  LIBRAW_IMAGE_ASPECT_MAXIMAL_REAL_ASPECT_VALUE(10000), /* 10: 1*/
  // Value:  width / height * 1000
  LIBRAW_IMAGE_ASPECT_3to2( (1000 * 3)/2),
  LIBRAW_IMAGE_ASPECT_1to1(1000),
  LIBRAW_IMAGE_ASPECT_4to3( (1000 * 4)/ 3),
  LIBRAW_IMAGE_ASPECT_16to9((1000 * 16) / 9),
  //LIBRAW_IMAGE_ASPECT_6to6, // what is the difference with 1:1 ?
  LIBRAW_IMAGE_ASPECT_5to4((1000 * 5) / 4),
  LIBRAW_IMAGE_ASPECT_7to6((1000 * 7) / 6),
  LIBRAW_IMAGE_ASPECT_6to5((1000 * 6) / 5),
  LIBRAW_IMAGE_ASPECT_7to5((1000 * 7) / 5);

    public final int value;
    private LibRawImageAspects(int v) { this.value = v; }
    private LibRawImageAspects(LibRawImageAspects e) { this.value = e.value; }
    public LibRawImageAspects intern() { for (LibRawImageAspects e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_lens_focal_types {
  LIBRAW_FT_UNDEFINED(0),
  LIBRAW_FT_PRIME_LENS(1),
  LIBRAW_FT_ZOOM_LENS(2),
  LIBRAW_FT_ZOOM_LENS_CONSTANT_APERTURE(3),
  LIBRAW_FT_ZOOM_LENS_VARIABLE_APERTURE(4);

    public final int value;
    private LibRaw_lens_focal_types(int v) { this.value = v; }
    private LibRaw_lens_focal_types(LibRaw_lens_focal_types e) { this.value = e.value; }
    public LibRaw_lens_focal_types intern() { for (LibRaw_lens_focal_types e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_Canon_RecordModes {
  LIBRAW_Canon_RecordMode_UNDEFINED(0),
  LIBRAW_Canon_RecordMode_JPEG(1),
  LIBRAW_Canon_RecordMode_CRW_THM(2),
  LIBRAW_Canon_RecordMode_AVI_THM(3),
  LIBRAW_Canon_RecordMode_TIF(4),
  LIBRAW_Canon_RecordMode_TIF_JPEG(5),
  LIBRAW_Canon_RecordMode_CR2(6),
  LIBRAW_Canon_RecordMode_CR2_JPEG(7),
  LIBRAW_Canon_RecordMode_UNKNOWN(8),
  LIBRAW_Canon_RecordMode_MOV(9),
  LIBRAW_Canon_RecordMode_MP4(10),
  LIBRAW_Canon_RecordMode_CRM(11),
  LIBRAW_Canon_RecordMode_CR3(12),
  LIBRAW_Canon_RecordMode_CR3_JPEG(13),
  LIBRAW_Canon_RecordMode_HEIF(14),
  LIBRAW_Canon_RecordMode_CR3_HEIF(15),
  LIBRAW_Canon_RecordMode_TheLastOne(16);

    public final int value;
    private LibRaw_Canon_RecordModes(int v) { this.value = v; }
    private LibRaw_Canon_RecordModes(LibRaw_Canon_RecordModes e) { this.value = e.value; }
    public LibRaw_Canon_RecordModes intern() { for (LibRaw_Canon_RecordModes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_minolta_storagemethods {
  LIBRAW_MINOLTA_UNPACKED(0x52),
  LIBRAW_MINOLTA_PACKED  (0x59);

    public final int value;
    private LibRaw_minolta_storagemethods(int v) { this.value = v; }
    private LibRaw_minolta_storagemethods(LibRaw_minolta_storagemethods e) { this.value = e.value; }
    public LibRaw_minolta_storagemethods intern() { for (LibRaw_minolta_storagemethods e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_minolta_bayerpatterns {
  LIBRAW_MINOLTA_RGGB  (0x01),
  LIBRAW_MINOLTA_G2BRG1(0x04);

    public final int value;
    private LibRaw_minolta_bayerpatterns(int v) { this.value = v; }
    private LibRaw_minolta_bayerpatterns(LibRaw_minolta_bayerpatterns e) { this.value = e.value; }
    public LibRaw_minolta_bayerpatterns intern() { for (LibRaw_minolta_bayerpatterns e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_sony_cameratypes {
  LIBRAW_SONY_DSC (1),
  LIBRAW_SONY_DSLR(2),
  LIBRAW_SONY_NEX (3),
  LIBRAW_SONY_SLT (4),
  LIBRAW_SONY_ILCE(5),
  LIBRAW_SONY_ILCA(6),
  LIBRAW_SONY_CameraType_UNKNOWN(0xffff);

    public final int value;
    private LibRaw_sony_cameratypes(int v) { this.value = v; }
    private LibRaw_sony_cameratypes(LibRaw_sony_cameratypes e) { this.value = e.value; }
    public LibRaw_sony_cameratypes intern() { for (LibRaw_sony_cameratypes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_Sony_0x2010_Type {
  LIBRAW_SONY_Tag2010None(0),
  LIBRAW_SONY_Tag2010a(1),
  LIBRAW_SONY_Tag2010b(2),
  LIBRAW_SONY_Tag2010c(3),
  LIBRAW_SONY_Tag2010d(4),
  LIBRAW_SONY_Tag2010e(5),
  LIBRAW_SONY_Tag2010f(6),
  LIBRAW_SONY_Tag2010g(7),
  LIBRAW_SONY_Tag2010h(8),
  LIBRAW_SONY_Tag2010i(9);

    public final int value;
    private LibRaw_Sony_0x2010_Type(int v) { this.value = v; }
    private LibRaw_Sony_0x2010_Type(LibRaw_Sony_0x2010_Type e) { this.value = e.value; }
    public LibRaw_Sony_0x2010_Type intern() { for (LibRaw_Sony_0x2010_Type e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
public enum LibRaw_Sony_0x9050_Type {
  LIBRAW_SONY_Tag9050None(0),
  LIBRAW_SONY_Tag9050a(1),
  LIBRAW_SONY_Tag9050b(2),
  LIBRAW_SONY_Tag9050c(3);

    public final int value;
    private LibRaw_Sony_0x9050_Type(int v) { this.value = v; }
    private LibRaw_Sony_0x9050_Type(LibRaw_Sony_0x9050_Type e) { this.value = e.value; }
    public LibRaw_Sony_0x9050_Type intern() { for (LibRaw_Sony_0x9050_Type e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LIBRAW_SONY_FOCUSMODEmodes {
  LIBRAW_SONY_FOCUSMODE_MF    (0),
  LIBRAW_SONY_FOCUSMODE_AF_S  (2),
  LIBRAW_SONY_FOCUSMODE_AF_C  (3),
  LIBRAW_SONY_FOCUSMODE_AF_A  (4),
  LIBRAW_SONY_FOCUSMODE_DMF   (6),
  LIBRAW_SONY_FOCUSMODE_AF_D  (7),
  LIBRAW_SONY_FOCUSMODE_AF          (101),
  LIBRAW_SONY_FOCUSMODE_PERMANENT_AF(104),
  LIBRAW_SONY_FOCUSMODE_SEMI_MF     (105),
  LIBRAW_SONY_FOCUSMODE_UNKNOWN     (-1);

    public final int value;
    private LIBRAW_SONY_FOCUSMODEmodes(int v) { this.value = v; }
    private LIBRAW_SONY_FOCUSMODEmodes(LIBRAW_SONY_FOCUSMODEmodes e) { this.value = e.value; }
    public LIBRAW_SONY_FOCUSMODEmodes intern() { for (LIBRAW_SONY_FOCUSMODEmodes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_KodakSensors {
  LIBRAW_Kodak_UnknownSensor(0),
  LIBRAW_Kodak_M1(1),
  LIBRAW_Kodak_M15(2),
  LIBRAW_Kodak_M16(3),
  LIBRAW_Kodak_M17(4),
  LIBRAW_Kodak_M2(5),
  LIBRAW_Kodak_M23(6),
  LIBRAW_Kodak_M24(7),
  LIBRAW_Kodak_M3(8),
  LIBRAW_Kodak_M5(9),
  LIBRAW_Kodak_M6(10),
  LIBRAW_Kodak_C14(11),
  LIBRAW_Kodak_X14(12),
  LIBRAW_Kodak_M11(13);

    public final int value;
    private LibRaw_KodakSensors(int v) { this.value = v; }
    private LibRaw_KodakSensors(LibRaw_KodakSensors e) { this.value = e.value; }
    public LibRaw_KodakSensors intern() { for (LibRaw_KodakSensors e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_HasselbladFormatCodes {
  LIBRAW_HF_Unknown(0),
  LIBRAW_HF_3FR(1),
  LIBRAW_HF_FFF(2),
  LIBRAW_HF_Imacon(3),
  LIBRAW_HF_HasselbladDNG(4),
  LIBRAW_HF_AdobeDNG(5),
  LIBRAW_HF_AdobeDNG_fromPhocusDNG(6);

    public final int value;
    private LibRaw_HasselbladFormatCodes(int v) { this.value = v; }
    private LibRaw_HasselbladFormatCodes(LibRaw_HasselbladFormatCodes e) { this.value = e.value; }
    public LibRaw_HasselbladFormatCodes intern() { for (LibRaw_HasselbladFormatCodes e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_rawspecial_t {
    LIBRAW_RAWSPECIAL_SONYARW2_NONE(0),
    LIBRAW_RAWSPECIAL_SONYARW2_BASEONLY(1),
    LIBRAW_RAWSPECIAL_SONYARW2_DELTAONLY(1 << 1),
    LIBRAW_RAWSPECIAL_SONYARW2_DELTAZEROBASE(1 << 2),
    LIBRAW_RAWSPECIAL_SONYARW2_DELTATOVALUE(1 << 3),
    LIBRAW_RAWSPECIAL_SONYARW2_ALLFLAGS(
    LIBRAW_RAWSPECIAL_SONYARW2_BASEONLY.value +
    LIBRAW_RAWSPECIAL_SONYARW2_DELTAONLY.value +
    LIBRAW_RAWSPECIAL_SONYARW2_DELTAZEROBASE.value +
    LIBRAW_RAWSPECIAL_SONYARW2_DELTATOVALUE.value),
    LIBRAW_RAWSPECIAL_NODP2Q_INTERPOLATERG(1<<4),
    LIBRAW_RAWSPECIAL_NODP2Q_INTERPOLATEAF(1 << 5),
    LIBRAW_RAWSPECIAL_SRAW_NO_RGB(1 << 6),
    LIBRAW_RAWSPECIAL_SRAW_NO_INTERPOLATE(1 << 7);

    public final int value;
    private LibRaw_rawspecial_t(int v) { this.value = v; }
    private LibRaw_rawspecial_t(LibRaw_rawspecial_t e) { this.value = e.value; }
    public LibRaw_rawspecial_t intern() { for (LibRaw_rawspecial_t e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_rawspeed_bits_t {
    LIBRAW_RAWSPEEDV1_USE(1),
    LIBRAW_RAWSPEEDV1_FAILONUNKNOWN(1 << 1),
    LIBRAW_RAWSPEEDV1_IGNOREERRORS(1 << 2),
    /*  bits 3-7 are reserved*/
    LIBRAW_RAWSPEEDV3_USE(1 << 8),
    LIBRAW_RAWSPEEDV3_FAILONUNKNOWN(1 << 9),
    LIBRAW_RAWSPEEDV3_IGNOREERRORS(1 << 10);

    public final int value;
    private LibRaw_rawspeed_bits_t(int v) { this.value = v; }
    private LibRaw_rawspeed_bits_t(LibRaw_rawspeed_bits_t e) { this.value = e.value; }
    public LibRaw_rawspeed_bits_t intern() { for (LibRaw_rawspeed_bits_t e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}



public enum LibRaw_decoder_flags {
  LIBRAW_DECODER_HASCURVE(1 << 4),
  LIBRAW_DECODER_SONYARW2(1 << 5),
  LIBRAW_DECODER_TRYRAWSPEED(1 << 6),
  LIBRAW_DECODER_OWNALLOC(1 << 7),
  LIBRAW_DECODER_FIXEDMAXC(1 << 8),
  LIBRAW_DECODER_ADOBECOPYPIXEL(1 << 9),
  LIBRAW_DECODER_LEGACY_WITH_MARGINS(1 << 10),
  LIBRAW_DECODER_3CHANNEL(1 << 11),
  LIBRAW_DECODER_SINAR4SHOT(1 << 11),
  LIBRAW_DECODER_FLATDATA(1 << 12),
  LIBRAW_DECODER_FLAT_BG2_SWAPPED(1<<13),
  LIBRAW_DECODER_UNSUPPORTED_FORMAT(1 << 14),
  LIBRAW_DECODER_NOTSET(1 << 15),
  LIBRAW_DECODER_TRYRAWSPEED3(1 << 16);

    public final int value;
    private LibRaw_decoder_flags(int v) { this.value = v; }
    private LibRaw_decoder_flags(LibRaw_decoder_flags e) { this.value = e.value; }
    public LibRaw_decoder_flags intern() { for (LibRaw_decoder_flags e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public static final int LIBRAW_XTRANS = 9;

public enum LibRaw_constructor_flags {
  LIBRAW_OPTIONS_NONE(0),
  LIBRAW_OPTIONS_NO_DATAERR_CALLBACK(1 << 1),
  /* Compatibility w/ years old typo */
  LIBRAW_OPIONS_NO_DATAERR_CALLBACK(LIBRAW_OPTIONS_NO_DATAERR_CALLBACK.value);

    public final int value;
    private LibRaw_constructor_flags(int v) { this.value = v; }
    private LibRaw_constructor_flags(LibRaw_constructor_flags e) { this.value = e.value; }
    public LibRaw_constructor_flags intern() { for (LibRaw_constructor_flags e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_warnings {
  LIBRAW_WARN_NONE(0),
  LIBRAW_WARN_BAD_CAMERA_WB(1 << 2),
  LIBRAW_WARN_NO_METADATA(1 << 3),
  LIBRAW_WARN_NO_JPEGLIB(1 << 4),
  LIBRAW_WARN_NO_EMBEDDED_PROFILE(1 << 5),
  LIBRAW_WARN_NO_INPUT_PROFILE(1 << 6),
  LIBRAW_WARN_BAD_OUTPUT_PROFILE(1 << 7),
  LIBRAW_WARN_NO_BADPIXELMAP(1 << 8),
  LIBRAW_WARN_BAD_DARKFRAME_FILE(1 << 9),
  LIBRAW_WARN_BAD_DARKFRAME_DIM(1 << 10),
// #ifdef LIBRAW_OLD_VIDEO_SUPPORT
// #endif
  LIBRAW_WARN_RAWSPEED_PROBLEM(1 << 12),
  LIBRAW_WARN_RAWSPEED_UNSUPPORTED(1 << 13),
  LIBRAW_WARN_RAWSPEED_PROCESSED(1 << 14),
  LIBRAW_WARN_FALLBACK_TO_AHD(1 << 15),
  LIBRAW_WARN_PARSEFUJI_PROCESSED(1 << 16),
  LIBRAW_WARN_DNGSDK_PROCESSED(1 << 17),
  LIBRAW_WARN_DNG_IMAGES_REORDERED(1 << 18),
  LIBRAW_WARN_DNG_STAGE2_APPLIED(1 << 19),
  LIBRAW_WARN_DNG_STAGE3_APPLIED(1 << 20),
  LIBRAW_WARN_RAWSPEED3_PROBLEM(1 << 21),
  LIBRAW_WARN_RAWSPEED3_UNSUPPORTED(1 << 22),
  LIBRAW_WARN_RAWSPEED3_PROCESSED(1 << 23),
  LIBRAW_WARN_RAWSPEED3_NOTLISTED(1 << 24);

    public final int value;
    private LibRaw_warnings(int v) { this.value = v; }
    private LibRaw_warnings(LibRaw_warnings e) { this.value = e.value; }
    public LibRaw_warnings intern() { for (LibRaw_warnings e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_exceptions {
  LIBRAW_EXCEPTION_NONE(0),
  LIBRAW_EXCEPTION_ALLOC(1),
  LIBRAW_EXCEPTION_DECODE_RAW(2),
  LIBRAW_EXCEPTION_DECODE_JPEG(3),
  LIBRAW_EXCEPTION_IO_EOF(4),
  LIBRAW_EXCEPTION_IO_CORRUPT(5),
  LIBRAW_EXCEPTION_CANCELLED_BY_CALLBACK(6),
  LIBRAW_EXCEPTION_BAD_CROP(7),
  LIBRAW_EXCEPTION_IO_BADFILE(8),
  LIBRAW_EXCEPTION_DECODE_JPEG2000(9),
  LIBRAW_EXCEPTION_TOOBIG(10),
  LIBRAW_EXCEPTION_MEMPOOL(11),
  LIBRAW_EXCEPTION_UNSUPPORTED_FORMAT(12);

    public final int value;
    private LibRaw_exceptions(int v) { this.value = v; }
    private LibRaw_exceptions(LibRaw_exceptions e) { this.value = e.value; }
    public LibRaw_exceptions intern() { for (LibRaw_exceptions e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_progress {
  LIBRAW_PROGRESS_START(0),
  LIBRAW_PROGRESS_OPEN(1),
  LIBRAW_PROGRESS_IDENTIFY(1 << 1),
  LIBRAW_PROGRESS_SIZE_ADJUST(1 << 2),
  LIBRAW_PROGRESS_LOAD_RAW(1 << 3),
  LIBRAW_PROGRESS_RAW2_IMAGE(1 << 4),
  LIBRAW_PROGRESS_REMOVE_ZEROES(1 << 5),
  LIBRAW_PROGRESS_BAD_PIXELS(1 << 6),
  LIBRAW_PROGRESS_DARK_FRAME(1 << 7),
  LIBRAW_PROGRESS_FOVEON_INTERPOLATE(1 << 8),
  LIBRAW_PROGRESS_SCALE_COLORS(1 << 9),
  LIBRAW_PROGRESS_PRE_INTERPOLATE(1 << 10),
  LIBRAW_PROGRESS_INTERPOLATE(1 << 11),
  LIBRAW_PROGRESS_MIX_GREEN(1 << 12),
  LIBRAW_PROGRESS_MEDIAN_FILTER(1 << 13),
  LIBRAW_PROGRESS_HIGHLIGHTS(1 << 14),
  LIBRAW_PROGRESS_FUJI_ROTATE(1 << 15),
  LIBRAW_PROGRESS_FLIP(1 << 16),
  LIBRAW_PROGRESS_APPLY_PROFILE(1 << 17),
  LIBRAW_PROGRESS_CONVERT_RGB(1 << 18),
  LIBRAW_PROGRESS_STRETCH(1 << 19),
  /* reserved */
  LIBRAW_PROGRESS_STAGE20(1 << 20),
  LIBRAW_PROGRESS_STAGE21(1 << 21),
  LIBRAW_PROGRESS_STAGE22(1 << 22),
  LIBRAW_PROGRESS_STAGE23(1 << 23),
  LIBRAW_PROGRESS_STAGE24(1 << 24),
  LIBRAW_PROGRESS_STAGE25(1 << 25),
  LIBRAW_PROGRESS_STAGE26(1 << 26),
  LIBRAW_PROGRESS_STAGE27(1 << 27),

  LIBRAW_PROGRESS_THUMB_LOAD(1 << 28),
  LIBRAW_PROGRESS_TRESERVED1(1 << 29),
  LIBRAW_PROGRESS_TRESERVED2(1 << 30);

    public final int value;
    private LibRaw_progress(int v) { this.value = v; }
    private LibRaw_progress(LibRaw_progress e) { this.value = e.value; }
    public LibRaw_progress intern() { for (LibRaw_progress e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
public static final int LIBRAW_PROGRESS_THUMB_MASK = 0x0fffffff;

public enum LibRaw_errors {
  LIBRAW_SUCCESS(0),
  LIBRAW_UNSPECIFIED_ERROR(-1),
  LIBRAW_FILE_UNSUPPORTED(-2),
  LIBRAW_REQUEST_FOR_NONEXISTENT_IMAGE(-3),
  LIBRAW_OUT_OF_ORDER_CALL(-4),
  LIBRAW_NO_THUMBNAIL(-5),
  LIBRAW_UNSUPPORTED_THUMBNAIL(-6),
  LIBRAW_INPUT_CLOSED(-7),
  LIBRAW_NOT_IMPLEMENTED(-8),
  LIBRAW_REQUEST_FOR_NONEXISTENT_THUMBNAIL(-9),
  LIBRAW_UNSUFFICIENT_MEMORY(-100007),
  LIBRAW_DATA_ERROR(-100008),
  LIBRAW_IO_ERROR(-100009),
  LIBRAW_CANCELLED_BY_CALLBACK(-100010),
  LIBRAW_BAD_CROP(-100011),
  LIBRAW_TOO_BIG(-100012),
  LIBRAW_MEMPOOL_OVERFLOW(-100013);

    public final int value;
    private LibRaw_errors(int v) { this.value = v; }
    private LibRaw_errors(LibRaw_errors e) { this.value = e.value; }
    public LibRaw_errors intern() { for (LibRaw_errors e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// #define LIBRAW_FATAL_ERROR(ec) ((ec) < -100000)

public enum LibRaw_internal_thumbnail_formats {
    LIBRAW_INTERNAL_THUMBNAIL_UNKNOWN(0),
    LIBRAW_INTERNAL_THUMBNAIL_KODAK_THUMB(1),
    LIBRAW_INTERNAL_THUMBNAIL_KODAK_YCBCR(2),
    LIBRAW_INTERNAL_THUMBNAIL_KODAK_RGB(3),
    LIBRAW_INTERNAL_THUMBNAIL_JPEG(4),
    LIBRAW_INTERNAL_THUMBNAIL_LAYER(5),
    LIBRAW_INTERNAL_THUMBNAIL_ROLLEI(6),
    LIBRAW_INTERNAL_THUMBNAIL_PPM(7),
    LIBRAW_INTERNAL_THUMBNAIL_PPM16(8),
    LIBRAW_INTERNAL_THUMBNAIL_X3F(9);

    public final int value;
    private LibRaw_internal_thumbnail_formats(int v) { this.value = v; }
    private LibRaw_internal_thumbnail_formats(LibRaw_internal_thumbnail_formats e) { this.value = e.value; }
    public LibRaw_internal_thumbnail_formats intern() { for (LibRaw_internal_thumbnail_formats e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}


public enum LibRaw_thumbnail_formats {
  LIBRAW_THUMBNAIL_UNKNOWN(0),
  LIBRAW_THUMBNAIL_JPEG(1),
  LIBRAW_THUMBNAIL_BITMAP(2),
  LIBRAW_THUMBNAIL_BITMAP16(3),
  LIBRAW_THUMBNAIL_LAYER(4),
  LIBRAW_THUMBNAIL_ROLLEI(5),
  LIBRAW_THUMBNAIL_H265(6);

    public final int value;
    private LibRaw_thumbnail_formats(int v) { this.value = v; }
    private LibRaw_thumbnail_formats(LibRaw_thumbnail_formats e) { this.value = e.value; }
    public LibRaw_thumbnail_formats intern() { for (LibRaw_thumbnail_formats e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

public enum LibRaw_image_formats {
  LIBRAW_IMAGE_JPEG(1),
  LIBRAW_IMAGE_BITMAP(2);

    public final int value;
    private LibRaw_image_formats(int v) { this.value = v; }
    private LibRaw_image_formats(LibRaw_image_formats e) { this.value = e.value; }
    public LibRaw_image_formats intern() { for (LibRaw_image_formats e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// #endif


// Parsed from libraw/libraw_version.h

/* -*- C++ -*-
 * File: libraw_version.h
 * Copyright 2008-2021 LibRaw LLC (info@libraw.org)
 * Created: Mon Sept  8, 2008
 *
 * LibRaw C++ interface
 *

LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
(See the file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
(See the file LICENSE.CDDL provided in LibRaw distribution archive for details).

 */

// #ifndef __VERSION_H
// #define __VERSION_H

public static final int LIBRAW_MAJOR_VERSION = 0;
public static final int LIBRAW_MINOR_VERSION = 21;
public static final int LIBRAW_PATCH_VERSION = 1;
// #define LIBRAW_VERSION_TAIL Release

public static final int LIBRAW_SHLIB_CURRENT = 23;
public static final int LIBRAW_SHLIB_REVISION = 0;
public static final int LIBRAW_SHLIB_AGE = 0;

// #define _LIBRAW_VERSION_MAKE(a, b, c, d) #a "." #b "." #c "-" #d
// #define LIBRAW_VERSION_MAKE(a, b, c, d) _LIBRAW_VERSION_MAKE(a, b, c, d)

// #define LIBRAW_VERSION_STR
//   LIBRAW_VERSION_MAKE(LIBRAW_MAJOR_VERSION, LIBRAW_MINOR_VERSION,
//                       LIBRAW_PATCH_VERSION, LIBRAW_VERSION_TAIL)

// #define LIBRAW_MAKE_VERSION(major, minor, patch)
//   (((major) << 16) | ((minor) << 8) | (patch))

// #define LIBRAW_VERSION
//   LIBRAW_MAKE_VERSION(LIBRAW_MAJOR_VERSION, LIBRAW_MINOR_VERSION,
//                       LIBRAW_PATCH_VERSION)

// #define LIBRAW_CHECK_VERSION(major, minor, patch)
//   (LibRaw::versionNumber() >= LIBRAW_MAKE_VERSION(major, minor, patch))

// #define LIBRAW_RUNTIME_CHECK_VERSION_EXACT()
//   ((LibRaw::versionNumber() & 0xffff00) ==
//    LIBRAW_MAKE_VERSION(LIBRAW_MAJOR_VERSION, LIBRAW_MINOR_VERSION, 0))

// #define LIBRAW_RUNTIME_CHECK_VERSION_NOTLESS()
//   ((LibRaw::versionNumber() & 0xffff00) >=
//    LIBRAW_MAKE_VERSION(LIBRAW_MAJOR_VERSION, LIBRAW_MINOR_VERSION, 0))

// #define LIBRAW_COMPILE_CHECK_VERSION(major, minor)
//   (LIBRAW_MAKE_VERSION(major, minor, 0) == (LIBRAW_VERSION & 0xffff00))

// #define LIBRAW_COMPILE_CHECK_VERSION_NOTLESS(major, minor)
//   (LIBRAW_MAKE_VERSION(major, minor, 0) <= (LIBRAW_VERSION & 0xffff00))

// #endif


// Parsed from libraw/libraw_types.h

/* -*- C++ -*-
 * File: libraw_types.h
 * Copyright 2008-2021 LibRaw LLC (info@libraw.org)
 * Created: Sat Mar  8 , 2008
 *
 * LibRaw C data structures
 *

LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
   (See file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
   (See file LICENSE.CDDL provided in LibRaw distribution archive for details).

 */

// #ifndef _LIBRAW_TYPES_H
// #define _LIBRAW_TYPES_H

// #include <sys/types.h>
// #ifndef _WIN32
// #include <sys/time.h>
// #endif

// #include <stdio.h>

// #if defined(_WIN32)
// #if defined(_MSC_VER) && (_MSC_VER <= 1500)
// #else /* WIN32, but not old MSVC */
// #include <stdint.h>
// #endif /* _WIN32 */
// #include <sys/types.h>
// #else
// #include <inttypes.h>
// #endif

// #if defined(_OPENMP)

// #if defined(LIBRAW_FORCE_OPENMP)
// #define LIBRAW_USE_OPENMP
// #else
// #if defined(_WIN32)
// #if defined(_MSC_VER) &&
//     (_MSC_VER >= 1600 || (_MSC_VER == 1500 && _MSC_FULL_VER >= 150030729))
/* VS2010+ : OpenMP works OK, VS2008: have tested by cgilles */
// #define LIBRAW_USE_OPENMP
// #elif defined(__INTEL_COMPILER) && (__INTEL_COMPILER >= 910)
/*  Have not tested on 9.x and 10.x, but Intel documentation claims OpenMP 2.5
 * support in 9.1 */
// #define LIBRAW_USE_OPENMP
// #else
// #undef LIBRAW_USE_OPENMP
// #endif
/* Not Win32 */
// #elif (defined(__APPLE__) || defined(__MACOSX__)) && defined(_REENTRANT)
/* Latest XCode works with OpenMP, need to recheck here */
// #undef LIBRAW_USE_OPENMP
// #else
// #define LIBRAW_USE_OPENMP
// #endif
// #endif
// #endif

// #ifdef LIBRAW_USE_OPENMP
// #endif

// #ifdef __cplusplus
// #endif

// #if defined(USE_LCMS)
// #include <lcms.h>
// #elif defined(USE_LCMS2)
// #include <lcms2.h>
// #else
// #define NO_LCMS
// #endif

// #include "libraw_const.h"
// #include "libraw_version.h"

// #ifdef _WIN32
// #else
// #endif

// #ifdef LIBRAW_WIN32_DLLDEFS
// #else
// #define DllDef
// Targeting ..\libraw_decoder_info_t.java


// Targeting ..\libraw_internal_output_params_t.java


// Targeting ..\memory_callback.java


// Targeting ..\exif_parser_callback.java


// Targeting ..\data_callback.java



  public static native void default_data_callback(Pointer data, @Cast("const char*") BytePointer file,
                                      int offset);
  public static native void default_data_callback(Pointer data, String file,
                                      int offset);
// Targeting ..\progress_callback.java


// Targeting ..\pre_identify_callback.java


// Targeting ..\post_identify_callback.java


// Targeting ..\process_step_callback.java


// Targeting ..\libraw_callbacks_t.java


// Targeting ..\libraw_processed_image_t.java


// Targeting ..\libraw_iparams_t.java


// Targeting ..\libraw_raw_inset_crop_t.java


// Targeting ..\libraw_image_sizes_t.java


// Targeting ..\libraw_area_t.java


// Targeting ..\ph1_t.java


// Targeting ..\libraw_dng_color_t.java


// Targeting ..\libraw_dng_levels_t.java


// Targeting ..\libraw_P1_color_t.java


// Targeting ..\libraw_canon_makernotes_t.java


// Targeting ..\libraw_hasselblad_makernotes_t.java


// Targeting ..\libraw_fuji_info_t.java


// Targeting ..\libraw_sensor_highspeed_crop_t.java


// Targeting ..\libraw_nikon_makernotes_t.java


// Targeting ..\libraw_olympus_makernotes_t.java


// Targeting ..\libraw_panasonic_makernotes_t.java


// Targeting ..\libraw_pentax_makernotes_t.java


// Targeting ..\libraw_ricoh_makernotes_t.java


// Targeting ..\libraw_samsung_makernotes_t.java


// Targeting ..\libraw_kodak_makernotes_t.java


// Targeting ..\libraw_p1_makernotes_t.java


// Targeting ..\libraw_sony_info_t.java


// Targeting ..\libraw_colordata_t.java


// Targeting ..\libraw_thumbnail_t.java


// Targeting ..\libraw_thumbnail_item_t.java


// Targeting ..\libraw_thumbnail_list_t.java


// Targeting ..\libraw_gps_info_t.java


// Targeting ..\libraw_imgother_t.java


// Targeting ..\libraw_afinfo_item_t.java


// Targeting ..\libraw_metadata_common_t.java


// Targeting ..\libraw_output_params_t.java


// Targeting ..\libraw_raw_unpack_params_t.java


// Targeting ..\libraw_rawdata_t.java


// Targeting ..\libraw_makernotes_lens_t.java


// Targeting ..\libraw_nikonlens_t.java


// Targeting ..\libraw_dnglens_t.java


// Targeting ..\libraw_lensinfo_t.java


// Targeting ..\libraw_makernotes_t.java


// Targeting ..\libraw_shootinginfo_t.java


// Targeting ..\libraw_custom_camera_t.java


// Targeting ..\libraw_data_t.java


// Targeting ..\fuji_q_table.java


// Targeting ..\fuji_compressed_params.java



// #ifdef __cplusplus
// #endif

// #if defined (LIBRAW_LIBRARY_BUILD) && defined(__cplusplus)

// #endif


/* Byte order */
// #if defined(__POWERPC__)
public static final int LibRawBigEndian = 1;

// #elif defined(__INTEL__)

// #elif defined(_M_IX86) || defined(__i386__)

// #elif defined(_M_X64) || defined(__amd64__) || defined(__x86_64__)

// #elif defined(__LITTLE_ENDIAN__)

// #elif defined(__BIG_ENDIAN__)
// #elif defined(_ARM_)

// #elif __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__

// #elif __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
// #else
// #ifndef qXCodeRez
// #error Unable to figure out byte order.
// #endif
// #endif

// #endif


// Parsed from libraw/libraw_datastream.h

/* -*- C -*-
 * File: libraw_datastream.h
 * Copyright 2008-2021 LibRaw LLC (info@libraw.org)
 * Created: Sun Jan 18 13:07:35 2009
 *
 * LibRaw Data stream interface

LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
   (See file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
   (See file LICENSE.CDDL provided in LibRaw distribution archive for details).

 */

// #ifndef __LIBRAW_DATASTREAM_H
// #define __LIBRAW_DATASTREAM_H

// #include <stdio.h>
// #include <sys/types.h>
// #include <errno.h>
// #include <string.h>

// #ifndef __cplusplus

// #else /* __cplusplus */
// #if defined _WIN32
// #ifndef LIBRAW_NO_WINSOCK2
// #include <winsock2.h>
// #endif
// #endif
/* No unique_ptr on Apple ?? */
// #if __cplusplus >= 201103L || (defined(_CPPLIB_VER) && _CPPLIB_VER >= 520) ||
//     (defined(_MSC_VER) && _MSVC_LANG >= 201103L)
/* OK - use unique_ptr unless LIBRAW_USE_AUTOPTR defined externally*/
// #else
/* Force to use auto_ptr */
// #ifndef LIBRAW_USE_AUTOPTR
// #define LIBRAW_USE_AUTOPTR
// #endif
// #endif

// #include "libraw_const.h"
// #include "libraw_types.h"
// #include <fstream>
// #include <memory>
// #include <vector>

// #if defined(_WIN32) && (_MSC_VER) >= 1500
// #define WIN32SECURECALLS
// #endif

// #ifdef USE_DNGSDK
// #endif /* DNGSDK */

// #define IOERROR()
//   do
//   {
//     throw LIBRAW_EXCEPTION_IO_EOF;
//   } while (0)
// Targeting ..\LibRaw_bit_buffer.java


// Targeting ..\LibRaw_abstract_datastream.java


// Targeting ..\LibRaw_buffer_datastream.java


// Targeting ..\LibRaw_bigfile_datastream.java



// #ifdef LIBRAW_WIN32_CALLS

// #endif

// #ifdef USE_DNGSDK

// #endif

// #endif /* cplusplus */

// #endif


// Parsed from libraw/libraw.h

/* -*- C++ -*-
 * File: libraw.h
 * Copyright 2008-2021 LibRaw LLC (info@libraw.org)
 * Created: Sat Mar  8, 2008
 *
 * LibRaw C++ interface
 *

LibRaw is free software; you can redistribute it and/or modify
it under the terms of the one of two licenses as you choose:

1. GNU LESSER GENERAL PUBLIC LICENSE version 2.1
   (See file LICENSE.LGPL provided in LibRaw distribution archive for details).

2. COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Version 1.0
   (See file LICENSE.CDDL provided in LibRaw distribution archive for details).

*/

// #ifndef _LIBRAW_CLASS_H
// #define _LIBRAW_CLASS_H

// #ifdef __linux__
public static final int _FILE_OFFSET_BITS = 64;
// #endif

// Enable use old cinema cameras if USE_OLD_VIDEOCAMS defined
// #ifdef USE_OLD_VIDEOCAMS
// #define LIBRAW_OLD_VIDEO_SUPPORT
// #endif

// #ifndef LIBRAW_USE_DEPRECATED_IOSTREAMS_DATASTREAM
// #define LIBRAW_NO_IOSTREAMS_DATASTREAM
// #endif

// #ifndef LIBRAW_NO_IOSTREAMS_DATASTREAM
// #endif

// #include <limits.h>
// #include <memory.h>
// #include <stdio.h>
// #include <stdlib.h>
// #include <math.h>

/* better WIN32 defines */

/* better WIN32 defines */

// #if defined(WIN32) || defined(_WIN32)

/* Win32 API */
// #  ifndef LIBRAW_WIN32_CALLS
// #   define LIBRAW_WIN32_CALLS
// #  endif

/* DLLs: Microsoft or Intel compiler */
// # if defined(_MSC_VER) || defined(__INTEL_COMPILER)
// # ifndef LIBRAW_WIN32_DLLDEFS
// #  define LIBRAW_WIN32_DLLDEFS
// # endif
// #endif

/* wchar_t* API for std::filebuf */
// # if (defined(_MSC_VER)  && (_MSC_VER > 1310)) || (defined(__INTEL_COMPILER) && (__INTEL_COMPILER >= 910))
// #  ifndef LIBRAW_WIN32_UNICODEPATHS
// #   define LIBRAW_WIN32_UNICODEPATHS
// #  endif
// # elif _GLIBCXX_HAVE__WFOPEN && _GLIBCXX_USE_WCHAR_T
// #  ifndef LIBRAW_WIN32_UNICODEPATHS
// #    define LIBRAW_WIN32_UNICODEPATHS
// #  endif
// # elif defined(_LIBCPP_HAS_OPEN_WITH_WCHAR)
// #  ifndef LIBRAW_WIN32_UNICODEPATHS
// #    define LIBRAW_WIN32_UNICODEPATHS
// #  endif
// # endif

// #endif

// #include "libraw_datastream.h"
// #include "libraw_types.h"
// #include "libraw_const.h"
// #include "libraw_internal.h"
// #include "libraw_alloc.h"

// #ifdef __cplusplus
// #endif
  public static native @Cast("const char*") BytePointer libraw_strerror(int errorcode);
  public static native @Cast("const char*") BytePointer libraw_strprogress(LibRaw_progress arg0);
  public static native String libraw_strprogress(@Cast("LibRaw_progress") int arg0);
  /* LibRaw C API */
  public static native libraw_data_t libraw_init(@Cast("unsigned int") int flags);
  public static native int libraw_open_file(libraw_data_t arg0, @Cast("const char*") BytePointer arg1);
  public static native int libraw_open_file(libraw_data_t arg0, String arg1);
// #ifndef LIBRAW_NO_IOSTREAMS_DATASTREAM
// #endif
// #if defined(_WIN32) || defined(WIN32)
// #endif

  public static native int libraw_open_buffer(libraw_data_t arg0, @Const Pointer buffer, @Cast("size_t") long size);
  public static native int libraw_open_bayer(libraw_data_t lr, @Cast("unsigned char*") BytePointer data,
                                 @Cast("unsigned") int datalen, @Cast("ushort") short _raw_width,
                                 @Cast("ushort") short _raw_height, @Cast("ushort") short _left_margin,
                                 @Cast("ushort") short _top_margin, @Cast("ushort") short _right_margin,
                                 @Cast("ushort") short _bottom_margin, @Cast("unsigned char") byte procflags,
                                 @Cast("unsigned char") byte bayer_battern,
                                 @Cast("unsigned") int unused_bits, @Cast("unsigned") int otherflags,
                                 @Cast("unsigned") int black_level);
  public static native int libraw_open_bayer(libraw_data_t lr, @Cast("unsigned char*") ByteBuffer data,
                                 @Cast("unsigned") int datalen, @Cast("ushort") short _raw_width,
                                 @Cast("ushort") short _raw_height, @Cast("ushort") short _left_margin,
                                 @Cast("ushort") short _top_margin, @Cast("ushort") short _right_margin,
                                 @Cast("ushort") short _bottom_margin, @Cast("unsigned char") byte procflags,
                                 @Cast("unsigned char") byte bayer_battern,
                                 @Cast("unsigned") int unused_bits, @Cast("unsigned") int otherflags,
                                 @Cast("unsigned") int black_level);
  public static native int libraw_open_bayer(libraw_data_t lr, @Cast("unsigned char*") byte[] data,
                                 @Cast("unsigned") int datalen, @Cast("ushort") short _raw_width,
                                 @Cast("ushort") short _raw_height, @Cast("ushort") short _left_margin,
                                 @Cast("ushort") short _top_margin, @Cast("ushort") short _right_margin,
                                 @Cast("ushort") short _bottom_margin, @Cast("unsigned char") byte procflags,
                                 @Cast("unsigned char") byte bayer_battern,
                                 @Cast("unsigned") int unused_bits, @Cast("unsigned") int otherflags,
                                 @Cast("unsigned") int black_level);
  public static native int libraw_unpack(libraw_data_t arg0);
  public static native int libraw_unpack_thumb(libraw_data_t arg0);
  public static native int libraw_unpack_thumb_ex(libraw_data_t arg0,int arg1);
  public static native void libraw_recycle_datastream(libraw_data_t arg0);
  public static native void libraw_recycle(libraw_data_t arg0);
  public static native void libraw_close(libraw_data_t arg0);
  public static native void libraw_subtract_black(libraw_data_t arg0);
  public static native int libraw_raw2image(libraw_data_t arg0);
  public static native void libraw_free_image(libraw_data_t arg0);
  /* version helpers */
  public static native @Cast("const char*") BytePointer libraw_version();
  public static native int libraw_versionNumber();
  /* Camera list */
  public static native @Cast("const char**") PointerPointer libraw_cameraList();
  public static native int libraw_cameraCount();

  /* helpers */
  public static native void libraw_set_exifparser_handler(libraw_data_t arg0,
                                              exif_parser_callback cb,
                                              Pointer datap);
  public static native void libraw_set_dataerror_handler(libraw_data_t arg0, data_callback func,
                                             Pointer datap);
  public static native void libraw_set_progress_handler(libraw_data_t arg0, progress_callback cb,
                                            Pointer datap);
  public static native @Cast("const char*") BytePointer libraw_unpack_function_name(libraw_data_t lr);
  public static native int libraw_get_decoder_info(libraw_data_t lr,
                                       libraw_decoder_info_t d);
  public static native int libraw_COLOR(libraw_data_t arg0, int row, int col);
  public static native @Cast("unsigned") int libraw_capabilities();

  /* DCRAW compatibility */
  public static native int libraw_adjust_sizes_info_only(libraw_data_t arg0);
  public static native int libraw_dcraw_ppm_tiff_writer(libraw_data_t lr,
                                            @Cast("const char*") BytePointer filename);
  public static native int libraw_dcraw_ppm_tiff_writer(libraw_data_t lr,
                                            String filename);
  public static native int libraw_dcraw_thumb_writer(libraw_data_t lr, @Cast("const char*") BytePointer fname);
  public static native int libraw_dcraw_thumb_writer(libraw_data_t lr, String fname);
  public static native int libraw_dcraw_process(libraw_data_t lr);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_image(libraw_data_t lr, IntPointer errc);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_image(libraw_data_t lr, IntBuffer errc);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_image(libraw_data_t lr, int[] errc);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_thumb(libraw_data_t lr, IntPointer errc);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_thumb(libraw_data_t lr, IntBuffer errc);
  public static native libraw_processed_image_t libraw_dcraw_make_mem_thumb(libraw_data_t lr, int[] errc);
  public static native void libraw_dcraw_clear_mem(libraw_processed_image_t arg0);
  /* getters/setters used by 3DLut Creator */
  public static native void libraw_set_demosaic(libraw_data_t lr, int value);
  public static native void libraw_set_output_color(libraw_data_t lr, int value);
  public static native void libraw_set_adjust_maximum_thr(libraw_data_t lr, float value);
  public static native void libraw_set_user_mul(libraw_data_t lr, int index, float val);
  public static native void libraw_set_output_bps(libraw_data_t lr, int value);
  public static native void libraw_set_gamma(libraw_data_t lr, int index, float value);
  public static native void libraw_set_no_auto_bright(libraw_data_t lr, int value);
  public static native void libraw_set_bright(libraw_data_t lr, float value);
  public static native void libraw_set_highlight(libraw_data_t lr, int value);
  public static native void libraw_set_fbdd_noiserd(libraw_data_t lr, int value);
  public static native int libraw_get_raw_height(libraw_data_t lr);
  public static native int libraw_get_raw_width(libraw_data_t lr);
  public static native int libraw_get_iheight(libraw_data_t lr);
  public static native int libraw_get_iwidth(libraw_data_t lr);
  public static native float libraw_get_cam_mul(libraw_data_t lr, int index);
  public static native float libraw_get_pre_mul(libraw_data_t lr, int index);
  public static native float libraw_get_rgb_cam(libraw_data_t lr, int index1, int index2);
  public static native int libraw_get_color_maximum(libraw_data_t lr);
  public static native void libraw_set_output_tif(libraw_data_t lr, int value);
  public static native libraw_iparams_t libraw_get_iparams(libraw_data_t lr);
  public static native libraw_lensinfo_t libraw_get_lensinfo(libraw_data_t lr);
  public static native libraw_imgother_t libraw_get_imgother(libraw_data_t lr);

// #ifdef __cplusplus
// Targeting ..\LibRaw.java



// #ifdef LIBRAW_LIBRARY_BUILD
// #endif


// #ifdef LIBRAW_LIBRARY_BUILD
// #endif

// #endif /* __cplusplus */

// #endif /* _LIBRAW_CLASS_H */


}
