// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.librealsense2.global;

import org.bytedeco.librealsense2.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class realsense2 extends org.bytedeco.librealsense2.presets.realsense2 {
    static { Loader.load(); }

// Parsed from librealsense2/h/rs_types.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_types.h
* \brief
* Exposes RealSense structs
*/

// #ifndef LIBREALSENSE_RS2_TYPES_H
// #define LIBREALSENSE_RS2_TYPES_H

// #ifdef __cplusplus
// #endif

/** \brief Category of the librealsense notification. */
/** enum rs2_notification_category */
public static final int
    /** Frames didn't arrived within 5 seconds */
    RS2_NOTIFICATION_CATEGORY_FRAMES_TIMEOUT = 0,
    /** Received partial/incomplete frame */
    RS2_NOTIFICATION_CATEGORY_FRAME_CORRUPTED = 1,
    /** Error reported from the device */
    RS2_NOTIFICATION_CATEGORY_HARDWARE_ERROR = 2,
    /** General Hardeware notification that is not an error */
    RS2_NOTIFICATION_CATEGORY_HARDWARE_EVENT = 3,
    /** Received unknown error from the device */
    RS2_NOTIFICATION_CATEGORY_UNKNOWN_ERROR = 4,
    /** Current firmware version installed is not the latest available */
    RS2_NOTIFICATION_CATEGORY_FIRMWARE_UPDATE_RECOMMENDED = 5,
    /** A relocalization event has updated the pose provided by a pose sensor */
    RS2_NOTIFICATION_CATEGORY_POSE_RELOCALIZATION = 6,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_NOTIFICATION_CATEGORY_COUNT = 7;
public static native @Cast("const char*") BytePointer rs2_notification_category_to_string(@Cast("rs2_notification_category") int category);

/** \brief Exception types are the different categories of errors that RealSense API might return. */
/** enum rs2_exception_type */
public static final int
    RS2_EXCEPTION_TYPE_UNKNOWN = 0,
    /** Device was disconnected, this can be caused by outside intervention, by internal firmware error or due to insufficient power */
    RS2_EXCEPTION_TYPE_CAMERA_DISCONNECTED = 1,
    /** Error was returned from the underlying OS-specific layer */
    RS2_EXCEPTION_TYPE_BACKEND = 2,
    /** Invalid value was passed to the API */
    RS2_EXCEPTION_TYPE_INVALID_VALUE = 3,
    /** Function precondition was violated */
    RS2_EXCEPTION_TYPE_WRONG_API_CALL_SEQUENCE = 4,
    /** The method is not implemented at this point */
    RS2_EXCEPTION_TYPE_NOT_IMPLEMENTED = 5,
    /** Device is in recovery mode and might require firmware update */
    RS2_EXCEPTION_TYPE_DEVICE_IN_RECOVERY_MODE = 6,
    /** IO Device failure */
    RS2_EXCEPTION_TYPE_IO = 7,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_EXCEPTION_TYPE_COUNT = 8;
public static native @Cast("const char*") BytePointer rs2_exception_type_to_string(@Cast("rs2_exception_type") int type);

/** \brief Distortion model: defines how pixel coordinates should be mapped to sensor coordinates. */
/** enum rs2_distortion */
public static final int
    /** Rectilinear images. No distortion compensation required. */
    RS2_DISTORTION_NONE = 0,
    /** Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points */
    RS2_DISTORTION_MODIFIED_BROWN_CONRADY = 1,
    /** Equivalent to Brown-Conrady distortion, except undistorts image instead of distorting it */
    RS2_DISTORTION_INVERSE_BROWN_CONRADY = 2,
    /** F-Theta fish-eye distortion model */
    RS2_DISTORTION_FTHETA = 3,
    /** Unmodified Brown-Conrady distortion model */
    RS2_DISTORTION_BROWN_CONRADY = 4,
    /** Four parameter Kannala Brandt distortion model */
    RS2_DISTORTION_KANNALA_BRANDT4 = 5,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_DISTORTION_COUNT = 6;
public static native @Cast("const char*") BytePointer rs2_distortion_to_string(@Cast("rs2_distortion") int distortion);
// Targeting ../rs2_intrinsics.java



/** \brief Video DSM (Digital Sync Module) parameters for calibration (same layout as in FW ac_depth_params)
    This is the block in MC that converts angles to dimensionless integers reported to MA (using "DSM coefficients").
*/
// #pragma pack( push, 1 )
// Targeting ../rs2_dsm_params.java


// #pragma pack( pop )

/** enum rs2_dsm_correction_model */
public static final int
    /** hFactor and hOffset are not used, and no artificial error is induced */
    RS2_DSM_CORRECTION_NONE = 0,
    /** Aging-over-thermal (default); aging-induced error is uniform across temperature */
    RS2_DSM_CORRECTION_AOT = 1,
    /** Thermal-over-aging; aging-induced error changes alongside temperature */
    RS2_DSM_CORRECTION_TOA = 2,
    RS2_DSM_CORRECTION_COUNT = 3;
// Targeting ../rs2_motion_device_intrinsic.java


// Targeting ../rs2_vertex.java


// Targeting ../rs2_pixel.java


// Targeting ../rs2_vector.java


// Targeting ../rs2_quaternion.java


// Targeting ../rs2_pose.java



/** \brief Severity of the librealsense logger. */
/** enum rs2_log_severity */
public static final int
    /** Detailed information about ordinary operations */
    RS2_LOG_SEVERITY_DEBUG = 0,
    /** Terse information about ordinary operations */
    RS2_LOG_SEVERITY_INFO = 1,
    /** Indication of possible failure */
    RS2_LOG_SEVERITY_WARN = 2,
    /** Indication of definite failure */
    RS2_LOG_SEVERITY_ERROR = 3,
    /** Indication of unrecoverable failure */
    RS2_LOG_SEVERITY_FATAL = 4,
    /** No logging will occur */
    RS2_LOG_SEVERITY_NONE = 5,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_LOG_SEVERITY_COUNT = 6,
    /** Include any/all log messages */
    RS2_LOG_SEVERITY_ALL = RS2_LOG_SEVERITY_DEBUG;
public static native @Cast("const char*") BytePointer rs2_log_severity_to_string(@Cast("rs2_log_severity") int info);

/** \brief Specifies advanced interfaces (capabilities) objects may implement. */
/** enum rs2_extension */
public static final int
    RS2_EXTENSION_UNKNOWN = 0,
    RS2_EXTENSION_DEBUG = 1,
    RS2_EXTENSION_INFO = 2,
    RS2_EXTENSION_MOTION = 3,
    RS2_EXTENSION_OPTIONS = 4,
    RS2_EXTENSION_VIDEO = 5,
    RS2_EXTENSION_ROI = 6,
    RS2_EXTENSION_DEPTH_SENSOR = 7,
    RS2_EXTENSION_VIDEO_FRAME = 8,
    RS2_EXTENSION_MOTION_FRAME = 9,
    RS2_EXTENSION_COMPOSITE_FRAME = 10,
    RS2_EXTENSION_POINTS = 11,
    RS2_EXTENSION_DEPTH_FRAME = 12,
    RS2_EXTENSION_ADVANCED_MODE = 13,
    RS2_EXTENSION_RECORD = 14,
    RS2_EXTENSION_VIDEO_PROFILE = 15,
    RS2_EXTENSION_PLAYBACK = 16,
    RS2_EXTENSION_DEPTH_STEREO_SENSOR = 17,
    RS2_EXTENSION_DISPARITY_FRAME = 18,
    RS2_EXTENSION_MOTION_PROFILE = 19,
    RS2_EXTENSION_POSE_FRAME = 20,
    RS2_EXTENSION_POSE_PROFILE = 21,
    RS2_EXTENSION_TM2 = 22,
    RS2_EXTENSION_SOFTWARE_DEVICE = 23,
    RS2_EXTENSION_SOFTWARE_SENSOR = 24,
    RS2_EXTENSION_DECIMATION_FILTER = 25,
    RS2_EXTENSION_THRESHOLD_FILTER = 26,
    RS2_EXTENSION_DISPARITY_FILTER = 27,
    RS2_EXTENSION_SPATIAL_FILTER = 28,
    RS2_EXTENSION_TEMPORAL_FILTER = 29,
    RS2_EXTENSION_HOLE_FILLING_FILTER = 30,
    RS2_EXTENSION_ZERO_ORDER_FILTER = 31,
    RS2_EXTENSION_RECOMMENDED_FILTERS = 32,
    RS2_EXTENSION_POSE = 33,
    RS2_EXTENSION_POSE_SENSOR = 34,
    RS2_EXTENSION_WHEEL_ODOMETER = 35,
    RS2_EXTENSION_GLOBAL_TIMER = 36,
    RS2_EXTENSION_UPDATABLE = 37,
    RS2_EXTENSION_UPDATE_DEVICE = 38,
    RS2_EXTENSION_L500_DEPTH_SENSOR = 39,
    RS2_EXTENSION_TM2_SENSOR = 40,
    RS2_EXTENSION_AUTO_CALIBRATED_DEVICE = 41,
    RS2_EXTENSION_COLOR_SENSOR = 42,
    RS2_EXTENSION_MOTION_SENSOR = 43,
    RS2_EXTENSION_FISHEYE_SENSOR = 44,
    RS2_EXTENSION_DEPTH_HUFFMAN_DECODER = 45,
    RS2_EXTENSION_SERIALIZABLE = 46,
    RS2_EXTENSION_FW_LOGGER = 47,
    RS2_EXTENSION_AUTO_CALIBRATION_FILTER = 48,
    RS2_EXTENSION_DEVICE_CALIBRATION = 49,
    RS2_EXTENSION_CALIBRATED_SENSOR = 50,
    RS2_EXTENSION_HDR_MERGE = 51,
    RS2_EXTENSION_SEQUENCE_ID_FILTER = 52,
    RS2_EXTENSION_MAX_USABLE_RANGE_SENSOR = 53,
    RS2_EXTENSION_DEBUG_STREAM_SENSOR = 54,
    RS2_EXTENSION_CALIBRATION_CHANGE_DEVICE = 55,
    RS2_EXTENSION_COUNT = 56;
public static native @Cast("const char*") BytePointer rs2_extension_type_to_string(@Cast("rs2_extension") int type);
public static native @Cast("const char*") BytePointer rs2_extension_to_string(@Cast("rs2_extension") int type);

/** \brief Specifies types of different matchers */
/** enum rs2_matchers */
public static final int
   RS2_MATCHER_DI = 0,      //compare depth and ir based on frame number

   RS2_MATCHER_DI_C = 1,    //compare depth and ir based on frame number,
                        //compare the pair of corresponding depth and ir with color based on closest timestamp,
                        //commonly used by SR300

   RS2_MATCHER_DLR_C = 2,   //compare depth, left and right ir based on frame number,
                        //compare the set of corresponding depth, left and right with color based on closest timestamp,
                        //commonly used by RS415, RS435

   RS2_MATCHER_DLR = 3,     //compare depth, left and right ir based on frame number,
                        //commonly used by RS400, RS405, RS410, RS420, RS430

   RS2_MATCHER_DIC = 4,     //compare depth, ir and confidence based on frame number used by RS500

   RS2_MATCHER_DIC_C = 5,    //compare depth, ir and confidence based on frame number,
                         //compare the set of corresponding depth, ir and confidence with color based on closest timestamp,
                         //commonly used by RS515

   RS2_MATCHER_DEFAULT = 6, //the default matcher compare all the streams based on closest timestamp

   RS2_MATCHER_COUNT = 7;
public static native @Cast("const char*") BytePointer rs2_matchers_to_string(@Cast("rs2_matchers") int stream);
// Targeting ../rs2_device_info.java


// Targeting ../rs2_device.java


// Targeting ../rs2_error.java


// Targeting ../rs2_log_message.java


// Targeting ../rs2_raw_data_buffer.java


// Targeting ../rs2_frame.java


// Targeting ../rs2_frame_queue.java


// Targeting ../rs2_pipeline.java


// Targeting ../rs2_pipeline_profile.java


// Targeting ../rs2_config.java


// Targeting ../rs2_device_list.java


// Targeting ../rs2_stream_profile_list.java


// Targeting ../rs2_processing_block_list.java


// Targeting ../rs2_stream_profile.java


// Targeting ../rs2_frame_callback.java


// Targeting ../rs2_log_callback.java


// Targeting ../rs2_syncer.java


// Targeting ../rs2_device_serializer.java


// Targeting ../rs2_source.java


// Targeting ../rs2_processing_block.java


// Targeting ../rs2_frame_processor_callback.java


// Targeting ../rs2_playback_status_changed_callback.java


// Targeting ../rs2_update_progress_callback.java


// Targeting ../rs2_context.java


// Targeting ../rs2_device_hub.java


// Targeting ../rs2_sensor_list.java


// Targeting ../rs2_sensor.java


// Targeting ../rs2_options.java


// Targeting ../rs2_options_list.java


// Targeting ../rs2_devices_changed_callback.java


// Targeting ../rs2_notification.java


// Targeting ../rs2_notifications_callback.java


// Targeting ../rs2_firmware_log_message.java


// Targeting ../rs2_firmware_log_parsed_message.java


// Targeting ../rs2_firmware_log_parser.java


// Targeting ../rs2_terminal_parser.java


// Targeting ../rs2_log_callback_ptr.java


// Targeting ../rs2_notification_callback_ptr.java


// Targeting ../rs2_software_device_destruction_callback_ptr.java


// Targeting ../rs2_devices_changed_callback_ptr.java


// Targeting ../rs2_frame_callback_ptr.java


// Targeting ../rs2_frame_processor_callback_ptr.java


// Targeting ../rs2_update_progress_callback_ptr.java



/** Timestamp format. units are milliseconds */
/** Metadata attribute type is defined as 64 bit signed integer*/

public static native rs2_error rs2_create_error(@Cast("const char*") BytePointer what, @Cast("const char*") BytePointer name, @Cast("const char*") BytePointer args, @Cast("rs2_exception_type") int type);
public static native rs2_error rs2_create_error(String what, String name, String args, @Cast("rs2_exception_type") int type);
public static native @Cast("rs2_exception_type") int rs2_get_librealsense_exception_type(@Const rs2_error error);
public static native @Cast("const char*") BytePointer rs2_get_failed_function(@Const rs2_error error);
public static native @Cast("const char*") BytePointer rs2_get_failed_args(@Const rs2_error error);
public static native @Cast("const char*") BytePointer rs2_get_error_message(@Const rs2_error error);
public static native void rs2_free_error(rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_context.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_context.h
* \brief Exposes RealSense context functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_CONTEXT_H
// #define LIBREALSENSE_RS2_CONTEXT_H

// #ifdef __cplusplus
// #endif
// #include "rs_types.h"

/**
* \brief Creates RealSense context that is required for the rest of the API.
* @param api_version [in] Users are expected to pass their version of \c RS2_API_VERSION to make sure they are running the correct librealsense version.
* @param error [out]  If non-null, receives any error that occurs during this call, otherwise, errors are ignored.
* @return            Context object
*/
public static native rs2_context rs2_create_context(int api_version, @Cast("rs2_error**") PointerPointer error);
public static native rs2_context rs2_create_context(int api_version, @ByPtrPtr rs2_error error);

/**
* \brief Frees the relevant context object.
* @param context [in] Object that is no longer needed
*/
public static native void rs2_delete_context(rs2_context context);

/**
* set callback to get devices changed events
* these events will be raised by the context whenever new RealSense device is connected or existing device gets disconnected
* @param context     Object representing librealsense session
* @param callback [in] callback object created from c++ application. ownership over the callback object is moved into the context
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_devices_changed_callback_cpp(rs2_context context, rs2_devices_changed_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_devices_changed_callback_cpp(rs2_context context, rs2_devices_changed_callback callback, @ByPtrPtr rs2_error error);

/**
* set callback to get devices changed events
* these events will be raised by the context whenever new RealSense device is connected or existing device gets disconnected
* @param context     Object representing librealsense session
* @param callback [in] function pointer to register as per-notifications callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_devices_changed_callback(@Const rs2_context context, rs2_devices_changed_callback_ptr callback, Pointer user, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_devices_changed_callback(@Const rs2_context context, rs2_devices_changed_callback_ptr callback, Pointer user, @ByPtrPtr rs2_error error);

/**
 * Create a new device and add it to the context
 * @param ctx   The context to which the new device will be added
 * @param file  The file from which the device should be created
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return  A pointer to a device that plays data from the file, or null in case of failure
 */
public static native rs2_device rs2_context_add_device(rs2_context ctx, @Cast("const char*") BytePointer file, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_context_add_device(rs2_context ctx, @Cast("const char*") BytePointer file, @ByPtrPtr rs2_error error);
public static native rs2_device rs2_context_add_device(rs2_context ctx, String file, @ByPtrPtr rs2_error error);

/**
 * Add an instance of software device to the context
 * @param ctx   The context to which the new device will be added
 * @param dev   Instance of software device to register into the context
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_context_add_software_device(rs2_context ctx, rs2_device dev, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_context_add_software_device(rs2_context ctx, rs2_device dev, @ByPtrPtr rs2_error error);

/**
 * Removes a playback device from the context, if exists
 * @param ctx [in]       The context from which the device should be removed
 * @param file [in]      The file name that was used to add the device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_context_remove_device(rs2_context ctx, @Cast("const char*") BytePointer file, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_context_remove_device(rs2_context ctx, @Cast("const char*") BytePointer file, @ByPtrPtr rs2_error error);
public static native void rs2_context_remove_device(rs2_context ctx, String file, @ByPtrPtr rs2_error error);

/**
 * Removes tracking module.
 * function query_devices() locks the tracking module in the tm_context object.
 * If the tracking module device is not used it should be removed using this function, so that other applications could find it.
 * This function can be used both before the call to query_device() to prevent enabling tracking modules or afterwards to
 * release them.
 */
public static native void rs2_context_unload_tracking_module(rs2_context ctx, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_context_unload_tracking_module(rs2_context ctx, @ByPtrPtr rs2_error error);

/**
* create a static snapshot of all connected devices at the time of the call
* @param context     Object representing librealsense session
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the list of devices, should be released by rs2_delete_device_list
*/
public static native rs2_device_list rs2_query_devices(@Const rs2_context context, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device_list rs2_query_devices(@Const rs2_context context, @ByPtrPtr rs2_error error);

public static final int RS2_PRODUCT_LINE_ANY =            0xff;
public static final int RS2_PRODUCT_LINE_ANY_INTEL =      0xfe;
public static final int RS2_PRODUCT_LINE_NON_INTEL =      0x01;
public static final int RS2_PRODUCT_LINE_D400 =           0x02;
public static final int RS2_PRODUCT_LINE_SR300 =          0x04;
public static final int RS2_PRODUCT_LINE_L500 =           0x08;
public static final int RS2_PRODUCT_LINE_T200 =           0x10;
public static final int RS2_PRODUCT_LINE_DEPTH =      (RS2_PRODUCT_LINE_L500 | RS2_PRODUCT_LINE_SR300 | RS2_PRODUCT_LINE_D400);
public static final int RS2_PRODUCT_LINE_TRACKING =   RS2_PRODUCT_LINE_T200;

/**
* create a static snapshot of all connected devices at the time of the call
* @param context     Object representing librealsense session
* @param product_mask Controls what kind of devices will be returned
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the list of devices, should be released by rs2_delete_device_list
*/
public static native rs2_device_list rs2_query_devices_ex(@Const rs2_context context, int product_mask, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device_list rs2_query_devices_ex(@Const rs2_context context, int product_mask, @ByPtrPtr rs2_error error);

/**
* \brief Creates RealSense device_hub .
* @param context [in] The context for the device hub
* @param error [out]  If non-null, receives any error that occurs during this call, otherwise, errors are ignored.
* @return            Device hub object
*/
public static native rs2_device_hub rs2_create_device_hub(@Const rs2_context context, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device_hub rs2_create_device_hub(@Const rs2_context context, @ByPtrPtr rs2_error error);

/**
* \brief Frees the relevant device hub object.
* @param hub [in] Object that is no longer needed
*/
public static native void rs2_delete_device_hub(@Const rs2_device_hub hub);

/**
* If any device is connected return it, otherwise wait until next RealSense device connects.
* Calling this method multiple times will cycle through connected devices
* @param ctx [in] The context to creat the device
* @param hub [in] The device hub object
* @param error [out]  If non-null, receives any error that occurs during this call, otherwise, errors are ignored.
* @return            device object
*/
public static native rs2_device rs2_device_hub_wait_for_device(@Const rs2_device_hub hub, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_device_hub_wait_for_device(@Const rs2_device_hub hub, @ByPtrPtr rs2_error error);

/**
* Checks if device is still connected
* @param hub [in] The device hub object
* @param device [in] The device
* @param error [out]  If non-null, receives any error that occurs during this call, otherwise, errors are ignored.
* @return            1 if the device is connected, 0 otherwise
*/
public static native int rs2_device_hub_is_device_connected(@Const rs2_device_hub hub, @Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_device_hub_is_device_connected(@Const rs2_device_hub hub, @Const rs2_device device, @ByPtrPtr rs2_error error);


// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_device.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_device.h
* \brief Exposes RealSense device functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_DEVICE_H
// #define LIBREALSENSE_RS2_DEVICE_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"
// #include "rs_sensor.h"

/**
* Determines number of devices in a list.
* @param info_list [in] The list of connected devices captured using rs2_query_devices
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Device count
*/
public static native int rs2_get_device_count(@Const rs2_device_list info_list, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_device_count(@Const rs2_device_list info_list, @ByPtrPtr rs2_error error);

/**
* Deletes device list, any devices created using this list will remain unaffected.
* @param info_list [in] List to delete
*/
public static native void rs2_delete_device_list(rs2_device_list info_list);

/**
* Checks if a specific device is contained inside a device list.
* @param info_list [in] The list of devices to check in
* @param device [in]    RealSense device to check for
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               True if the device is in the list and false otherwise
*/
public static native int rs2_device_list_contains(@Const rs2_device_list info_list, @Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_device_list_contains(@Const rs2_device_list info_list, @Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Creates a device by index. The device object represents a physical camera and provides the means to manipulate it.
* @param info_list [in] the list containing the device to retrieve
* @param index [in]     The zero based index of device to retrieve
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               The requested device, should be released by rs2_delete_device
*/
public static native rs2_device rs2_create_device(@Const rs2_device_list info_list, int index, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_create_device(@Const rs2_device_list info_list, int index, @ByPtrPtr rs2_error error);

/**
* Delete RealSense device
* @param device [in]    Realsense device to delete
*/
public static native void rs2_delete_device(rs2_device device);

/**
* Retrieve camera specific information, like versions of various internal components.
* @param device [in]    The RealSense device
* @param info [in]      Camera info type to retrieve
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               The requested camera info string, in a format specific to the device model
*/
public static native @Cast("const char*") BytePointer rs2_get_device_info(@Const rs2_device device, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_get_device_info(@Const rs2_device device, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
* Check if a camera supports a specific camera info type.
* @param device [in]    The RealSense device to check
* @param info [in]      The parameter to check for support
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               True if the parameter both exist and well-defined for the specific device
*/
public static native int rs2_supports_device_info(@Const rs2_device device, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_supports_device_info(@Const rs2_device device, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
 * Send hardware reset request to the device. The actual reset is asynchronous.
 * Note: Invalidates all handles to this device.
 * @param device [in]   The RealSense device to reset
 * @param error [out]    If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_hardware_reset(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_hardware_reset(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Send raw data to device
* @param device [in]                    RealSense device to send data to
* @param raw_data_to_send [in]          Raw data to be sent to device
* @param size_of_raw_data_to_send [in]  Size of raw_data_to_send in bytes
* @param error [out]                     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                               Device's response in a rs2_raw_data_buffer, which should be released by rs2_delete_raw_data
*/
public static native @Const rs2_raw_data_buffer rs2_send_and_receive_raw_data(rs2_device device, Pointer raw_data_to_send, @Cast("unsigned") int size_of_raw_data_to_send, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_send_and_receive_raw_data(rs2_device device, Pointer raw_data_to_send, @Cast("unsigned") int size_of_raw_data_to_send, @ByPtrPtr rs2_error error);

/**
* Test if the given device can be extended to the requested extension.
* @param device [in]    Realsense device
* @param extension [in] The extension to which the device should be tested if it is extendable
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Non-zero value iff the device can be extended to the given extension
*/
public static native int rs2_is_device_extendable_to(@Const rs2_device device, @Cast("rs2_extension") int extension, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_is_device_extendable_to(@Const rs2_device device, @Cast("rs2_extension") int extension, @ByPtrPtr rs2_error error);

/**
* Create a static snapshot of all connected sensors within a specific device.
* @param device [in]    Specific RealSense device
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               The list of sensors, should be released by rs2_delete_sensor_list
*/
public static native rs2_sensor_list rs2_query_sensors(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native rs2_sensor_list rs2_query_sensors(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Enter the given device into loopback operation mode that uses the given file as input for raw data
* @param device [in]     Device to enter into loopback operation mode
* @param from_file [in]  Path to bag file with raw data for loopback
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_loopback_enable(@Const rs2_device device, @Cast("const char*") BytePointer from_file, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_loopback_enable(@Const rs2_device device, @Cast("const char*") BytePointer from_file, @ByPtrPtr rs2_error error);
public static native void rs2_loopback_enable(@Const rs2_device device, String from_file, @ByPtrPtr rs2_error error);

/**
* Restores the given device into normal operation mode
* @param device [in]     Device to restore to normal operation mode
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_loopback_disable(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_loopback_disable(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Checks if the device is in loopback mode or not
* @param device [in]     Device to check for operation mode
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return true if the device is in loopback operation mode
*/
public static native int rs2_loopback_is_enabled(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_loopback_is_enabled(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Connects to a given tm2 controller
* @param device [in]     Device to connect to the controller
* @param mac_addr [in]   The MAC address of the desired controller
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_connect_tm2_controller(@Const rs2_device device, @Cast("const unsigned char*") BytePointer mac_addr, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_connect_tm2_controller(@Const rs2_device device, @Cast("const unsigned char*") BytePointer mac_addr, @ByPtrPtr rs2_error error);
public static native void rs2_connect_tm2_controller(@Const rs2_device device, @Cast("const unsigned char*") ByteBuffer mac_addr, @ByPtrPtr rs2_error error);
public static native void rs2_connect_tm2_controller(@Const rs2_device device, @Cast("const unsigned char*") byte[] mac_addr, @ByPtrPtr rs2_error error);

/**
* Disconnects a given tm2 controller
* @param device [in]     Device to disconnect the controller from
* @param id [in]         The ID of the desired controller
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_disconnect_tm2_controller(@Const rs2_device device, int id, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_disconnect_tm2_controller(@Const rs2_device device, int id, @ByPtrPtr rs2_error error);


/**
* Reset device to factory calibration
* @param device [in]       The RealSense device
* @param error [out]       If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_reset_to_factory_calibration(@Const rs2_device device, @Cast("rs2_error**") PointerPointer e);
public static native void rs2_reset_to_factory_calibration(@Const rs2_device device, @ByPtrPtr rs2_error e);

/**
* Write calibration to device's EEPROM
* @param device [in]       The RealSense device
* @param error [out]       If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_write_calibration(@Const rs2_device device, @Cast("rs2_error**") PointerPointer e);
public static native void rs2_write_calibration(@Const rs2_device device, @ByPtrPtr rs2_error e);

/**
* Update device to the provided firmware, the device must be extendable to RS2_EXTENSION_UPDATABLE.
* This call is executed on the caller's thread and it supports progress notifications via the optional callback.
* @param device [in]        Device to update
* @param fw_image [in]      Firmware image buffer
* @param fw_image_size [in] Firmware image buffer size
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_update_firmware_cpp(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_update_firmware_cpp(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback callback, @ByPtrPtr rs2_error error);

/**
* Update device to the provided firmware, the device must be extendable to RS2_EXTENSION_UPDATABLE.
* This call is executed on the caller's thread and it supports progress notifications via the optional callback.
* @param device [in]        Device to update
* @param fw_image [in]      Firmware image buffer
* @param fw_image_size [in] Firmware image buffer size
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in]   Optional client data for the callback
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_update_firmware(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_update_firmware(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);

/**
* Create backup of camera flash memory. Such backup does not constitute valid firmware image, and cannot be
* loaded back to the device, but it does contain all calibration and device information.
* @param device [in]        Device to update
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native @Const rs2_raw_data_buffer rs2_create_flash_backup_cpp(@Const rs2_device device, rs2_update_progress_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_create_flash_backup_cpp(@Const rs2_device device, rs2_update_progress_callback callback, @ByPtrPtr rs2_error error);

/**
* Create backup of camera flash memory. Such backup does not constitute valid firmware image, and cannot be
* loaded back to the device, but it does contain all calibration and device information.
* @param device [in]        Device to update
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in]   Optional client data for the callback
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native @Const rs2_raw_data_buffer rs2_create_flash_backup(@Const rs2_device device, rs2_update_progress_callback_ptr callback, Pointer client_data, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_create_flash_backup(@Const rs2_device device, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);

public static final int RS2_UNSIGNED_UPDATE_MODE_UPDATE =     0;
public static final int RS2_UNSIGNED_UPDATE_MODE_READ_ONLY =  1;
public static final int RS2_UNSIGNED_UPDATE_MODE_FULL =       2;

/**
* Update device to the provided firmware by writing raw data directly to the flash, this command can be executed only on unlocked camera.
* The device must be extendable to RS2_EXTENSION_UPDATABLE.
* This call is executed on the caller's thread and it supports progress notifications via the optional callback.
* @param device [in]        Device to update
* @param fw_image [in]      Firmware image buffer
* @param fw_image_size [in] Firmware image buffer size
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param update_mode [in]   Select one of RS2_UNSIGNED_UPDATE_MODE, WARNING!!! setting to any option other than RS2_UNSIGNED_UPDATE_MODE_UPDATE will make this call unsafe and might damage the camera
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_update_firmware_unsigned_cpp(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback callback, int update_mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_update_firmware_unsigned_cpp(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback callback, int update_mode, @ByPtrPtr rs2_error error);

/**
* Checks if the device and the provided firmware image are compatible
* @param device [in]        Device to update
* @param fw_image [in]      Firmware image buffer
* @param fw_image_size [in] Firmware image buffer size in bytes
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                   Non-zero if the firmware is compatible with the device and 0 otherwise
*/
public static native int rs2_check_firmware_compatibility(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_check_firmware_compatibility(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, @ByPtrPtr rs2_error error);

/**
* Update device to the provided firmware by writing raw data directly to the flash, this command can be executed only on unlocked camera.
* The device must be extendable to RS2_EXTENSION_UPDATABLE.
* This call is executed on the caller's thread and it supports progress notifications via the optional callback.
* @param device [in]        Device to update
* @param fw_image [in]      Firmware image buffer
* @param fw_image_size [in] Firmware image buffer size
* @param callback [in]      Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in]   Optional client data for the callback
* @param update_mode [in]   Select one of RS2_UNSIGNED_UPDATE_MODE, WARNING!!! setting to any option other than RS2_UNSIGNED_UPDATE_MODE_UPDATE will make this call unsafe and might damage the camera
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_update_firmware_unsigned(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback_ptr callback, Pointer client_data, int update_mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_update_firmware_unsigned(@Const rs2_device device, @Const Pointer fw_image, int fw_image_size, rs2_update_progress_callback_ptr callback, Pointer client_data, int update_mode, @ByPtrPtr rs2_error error);

/**
* Enter the device to update state, this will cause the updatable device to disconnect and reconnect as update device.
* @param device [in]     Device to update
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_enter_update_state(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_enter_update_state(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* This will improve the depth noise.
* @param json_content [in]       Json string to configure regular speed on chip calibration parameters:
                                    {
                                      "calib type" : 0,
                                      "speed": 3,
                                      "scan parameter": 0,
                                      "adjust both sides": 0,
                                      "white wall mode": 0
                                    }
                                    calib_type - calibraton type: 0 = regular, 1 = focal length, 2 = both regular and focal length in order
                                    speed - for regular calibration. value can be one of: Very fast = 0, Fast = 1, Medium = 2, Slow = 3, White wall = 4, default is Slow for type 0 and Fast for type 2
                                    scan_parameter - for regular calibration. value can be one of: Py scan (default) = 0, Rx scan = 1
                                    adjust_both_sides - for focal length calibration. value can be one of: 0 = adjust right only, 1 = adjust both sides
                                    white_wall_mode - white wall mode: 0 for normal mode and 1 for white wall mode
                                    if json is nullptr it will be ignored and calibration will use the default parameters
* @param health [out]            The absolute value of regular calibration Health-Check captures how far camera calibration is from the optimal one
                                    [0, 0.25) - Good
                                    [0.25, 0.75) - Can be Improved
                                    [0.75, ) - Requires Calibration
                                The absolute value of focal length calibration Health-Check captures how far camera calibration is from the optimal one
                                    [0, 0.15) - Good
                                    [0.15, 0.75) - Can be Improved
                                    [0.75, ) - Requires Calibration
                                The two health numbers are encoded in one integer as follows for calib_type 2:
                                    Regular health number times 1000 are bits 0 to 11
                                    Regular health number is negative if bit 24 is 1
                                    Focal length health number times 1000 are bits 12 to 23
                                    Focal length health number is negative if bit 25 is 1
* @param callback [in]           Optional callback to get progress notifications
* @param timeout_ms [in]         Timeout in ms (use 5000 msec unless instructed otherwise)
* @return                       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration_cpp(rs2_device device, @Const Pointer json_content, int content_size, FloatPointer health, rs2_update_progress_callback progress_callback, int timeout_ms, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration_cpp(rs2_device device, @Const Pointer json_content, int content_size, FloatPointer health, rs2_update_progress_callback progress_callback, int timeout_ms, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration_cpp(rs2_device device, @Const Pointer json_content, int content_size, FloatBuffer health, rs2_update_progress_callback progress_callback, int timeout_ms, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration_cpp(rs2_device device, @Const Pointer json_content, int content_size, float[] health, rs2_update_progress_callback progress_callback, int timeout_ms, @ByPtrPtr rs2_error error);

/**
* This will improve the depth noise.
* @param json_content [in]       Json string to configure regular speed on chip calibration parameters:
                                    {
                                      "calib type" : 0,
                                      "speed": 3,
                                      "scan parameter": 0,
                                      "adjust both sides": 0,
                                      "white wall mode": 0
                                    }
                                    calib_type - calibraton type: 0 = regular, 1 = focal length, 2 = both regular and focal length in order
                                    speed - for regular calibration, value can be one of: Very fast = 0, Fast = 1, Medium = 2, Slow = 3, White wall = 4, default is Slow for type 0 and Fast for type 2
                                    scan_parameter - for regular calibration. value can be one of: Py scan (default) = 0, Rx scan = 1
                                    adjust_both_sides - for focal length calibration. value can be one of: 0 = adjust right only, 1 = adjust both sides
                                    white_wall_mode - white wall mode: 0 for normal mode and 1 for white wall mode
                                    if json is nullptr it will be ignored and calibration will use the default parameters
* @param health [out]            The absolute value of regular calibration Health-Check captures how far camera calibration is from the optimal one
                                    [0, 0.25) - Good
                                    [0.25, 0.75) - Can be Improved
                                    [0.75, ) - Requires Calibration
                                The absolute value of focal length calibration Health-Check captures how far camera calibration is from the optimal one
                                    [0, 0.15) - Good
                                    [0.15, 0.75) - Can be Improved
                                    [0.75, ) - Requires Calibration
                                The two health numbers are encoded in one integer as follows for calib_type 2:
                                    Regular health number times 1000 are bits 0 to 11
                                    Regular health number is negative if bit 24 is 1
                                    Focal length health number times 1000 are bits 12 to 23
                                    Focal length health number is negative if bit 25 is 1
* @param callback [in]           Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in]        Optional client data for the callback
* @param timeout_ms [in]         Timeout in ms (use 5000 msec unless instructed otherwise)
* @return                       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration(rs2_device device, @Const Pointer json_content, int content_size, FloatPointer health, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration(rs2_device device, @Const Pointer json_content, int content_size, FloatPointer health, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration(rs2_device device, @Const Pointer json_content, int content_size, FloatBuffer health, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_on_chip_calibration(rs2_device device, @Const Pointer json_content, int content_size, float[] health, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @ByPtrPtr rs2_error error);

/**
* This will adjust camera absolute distance to flat target. User needs to enter the known ground truth.
* @param ground_truth_mm [in]     Ground truth in mm must be between 60 and 10000
* @param json_content [in]        Json string to configure tare calibration parameters:
                                    {
                                      "average step count": 20,
                                      "step count": 20,
                                      "accuracy": 2,
                                      "scan parameter": 0,
                                      "data sampling": 0
                                    }
                                    average step count - number of frames to average, must be between 1 - 30, default = 20
                                    step count - max iteration steps, must be between 5 - 30, default = 10
                                    accuracy - Subpixel accuracy level, value can be one of: Very high = 0 (0.025%), High = 1 (0.05%), Medium = 2 (0.1%), Low = 3 (0.2%), Default = Very high (0.025%), default is Medium
                                    scan_parameter - value can be one of: Py scan (default) = 0, Rx scan = 1
                                    data_sampling - value can be one of:polling data sampling = 0, interrupt data sampling = 1
                                    if json is nullptr it will be ignored and calibration will use the default parameters
* @param content_size [in]       Json string size if its 0 the json will be ignored and calibration will use the default parameters
* @param callback [in]           Optional callback to get progress notifications
* @param timeout_ms [in]         Timeout in ms (use 5000 msec unless instructed otherwise)
* @return                        New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_tare_calibration_cpp(rs2_device dev, float ground_truth_mm, @Const Pointer json_content, int content_size, rs2_update_progress_callback progress_callback, int timeout_ms, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_tare_calibration_cpp(rs2_device dev, float ground_truth_mm, @Const Pointer json_content, int content_size, rs2_update_progress_callback progress_callback, int timeout_ms, @ByPtrPtr rs2_error error);


/**
 * Used in device_calibration; enumerates the different calibration types
 * available for that extension.
 */
/** enum rs2_calibration_type */
public static final int
    RS2_CALIBRATION_AUTO_DEPTH_TO_RGB = 0,
    RS2_CALIBRATION_MANUAL_DEPTH_TO_RGB = 1,
    RS2_CALIBRATION_THERMAL = 2,
    RS2_CALIBRATION_TYPE_COUNT = 3;
public static native @Cast("const char*") BytePointer rs2_calibration_type_to_string( @Cast("rs2_calibration_type") int arg0 );

/**
 * Used in device_calibration with rs2_calibration_change_callback
 */
/** enum rs2_calibration_status */
public static final int
    // Anything >= 0 is not an issue
    RS2_CALIBRATION_TRIGGERED      = 0,  // AC triggered and is active; conditions are valid
    RS2_CALIBRATION_SPECIAL_FRAME  = 1,  // Special frame received; expect a frame-drop!
    RS2_CALIBRATION_STARTED        = 2,  // Have all frames in hand; starting processing
    RS2_CALIBRATION_NOT_NEEDED     = 3,  // Finished; existing calibration within tolerances; nothing done!
    RS2_CALIBRATION_SUCCESSFUL     = 4,  // Finished; have new calibration in-hand

    RS2_CALIBRATION_RETRY          = -1,  // Initiating retry (asked for a new special frame)
    RS2_CALIBRATION_FAILED         = -2,  // Unexpected: exception, device removed, stream stopped, etc.
    RS2_CALIBRATION_SCENE_INVALID  = -3,  // Scene was not good enough for calibration; will retry
    RS2_CALIBRATION_BAD_RESULT     = -4,  // Calibration finished, but results aren't good; will retry
    RS2_CALIBRATION_BAD_CONDITIONS = -5,  // Trigger was attempted but conditions (temp/APD) were invalid (still inactive)

    RS2_CALIBRATION_STATUS_FIRST   = -5,
    RS2_CALIBRATION_STATUS_LAST    = 4,
    RS2_CALIBRATION_STATUS_COUNT = RS2_CALIBRATION_STATUS_LAST - RS2_CALIBRATION_STATUS_FIRST + 1;
public static native @Cast("const char*") BytePointer rs2_calibration_status_to_string( @Cast("rs2_calibration_status") int arg0 );
// Targeting ../rs2_calibration_change_callback.java


// Targeting ../rs2_calibration_change_callback_ptr.java



/**
 * Adds a callback for a sensor that gets called when calibration (intrinsics) changes, e.g. due to auto-calibration
 * @param sensor [in]        the sensor
 * @param callback [in]      the C callback function that gets called
 * @param user [in]          user argument that gets passed to the callback function
 * @param error [out]        if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_register_calibration_change_callback( rs2_device dev, rs2_calibration_change_callback_ptr callback, Pointer user, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_register_calibration_change_callback( rs2_device dev, rs2_calibration_change_callback_ptr callback, Pointer user, @ByPtrPtr rs2_error error );

/**
 * Adds a callback for a sensor that gets called when calibration (intrinsics) changes, e.g. due to auto-calibration
 * @param sensor [in]        the sensor
 * @param callback [in]      the C++ callback interface that gets called
 * @param error [out]        if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_register_calibration_change_callback_cpp( rs2_device dev, rs2_calibration_change_callback callback, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_register_calibration_change_callback_cpp( rs2_device dev, rs2_calibration_change_callback callback, @ByPtrPtr rs2_error error );

/**
 * Triggers calibration of the given type
 * @param dev [in]           the device
 * @param type [in]          the type of calibration requested
 * @param error [out]        if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_trigger_device_calibration( rs2_device dev, @Cast("rs2_calibration_type") int type, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_trigger_device_calibration( rs2_device dev, @Cast("rs2_calibration_type") int type, @ByPtrPtr rs2_error error );

/**
* This will adjust camera absolute distance to flat target. User needs to enter the known ground truth.
* @param ground_truth_mm [in]     Ground truth in mm must be between 60 and 10000
* @param json_content [in]        Json string to configure tare calibration parameters:
                                    {
                                      "average_step_count": 20,
                                      "step count": 20,
                                      "accuracy": 2,
                                      "scan parameter": 0,
                                      "data sampling": 0
                                    }
                                    average step count - number of frames to average, must be between 1 - 30, default = 20
                                    step count - max iteration steps, must be between 5 - 30, default = 10
                                    accuracy - Subpixel accuracy level, value can be one of: Very high = 0 (0.025%), High = 1 (0.05%), Medium = 2 (0.1%), Low = 3 (0.2%), Default = Very high (0.025%), default is Medium
                                    scan_parameter - value can be one of: Py scan (default) = 0, Rx scan = 1
                                    data_sampling - value can be one of:polling data sampling = 0, interrupt data sampling = 1
                                    if json is nullptr it will be ignored and calibration will use the default parameters
* @param content_size [in]       Json string size if its 0 the json will be ignored and calibration will use the default parameters
* @param callback [in]           Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in]        Optional client data for the callback
* @param timeout_ms [in]          Timeout in ms (use 5000 msec unless instructed otherwise)
* @return                        New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_tare_calibration(rs2_device dev, float ground_truth_mm, @Const Pointer json_content, int content_size, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_tare_calibration(rs2_device dev, float ground_truth_mm, @Const Pointer json_content, int content_size, rs2_update_progress_callback_ptr callback, Pointer client_data, int timeout_ms, @ByPtrPtr rs2_error error);

/**
*  Read current calibration table from flash.
* @return    Calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_get_calibration_table(@Const rs2_device dev, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_get_calibration_table(@Const rs2_device dev, @ByPtrPtr rs2_error error);

/**
*  Set current table to dynamic area.
* @param Calibration [in] table
*/
public static native void rs2_set_calibration_table(@Const rs2_device device, @Const Pointer calibration, int calibration_size, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_calibration_table(@Const rs2_device device, @Const Pointer calibration, int calibration_size, @ByPtrPtr rs2_error error);

/* Serialize JSON content, returns ASCII-serialized JSON string on success. otherwise nullptr */
public static native rs2_raw_data_buffer rs2_serialize_json(rs2_device dev, @Cast("rs2_error**") PointerPointer error);
public static native rs2_raw_data_buffer rs2_serialize_json(rs2_device dev, @ByPtrPtr rs2_error error);

/* Load JSON and apply advanced-mode controls */
public static native void rs2_load_json(rs2_device dev, @Const Pointer json_content, @Cast("unsigned") int content_size, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_load_json(rs2_device dev, @Const Pointer json_content, @Cast("unsigned") int content_size, @ByPtrPtr rs2_error error);

/**
*  Run target-based focal length calibration
* @param device [in] : device to calibrate
* @param left_queue [in] : container for left IR frames with resoluton of  1280x720 and the target in the center of 320x240 pixels ROI.
* @param right_queue [in] : container for right IR frames with resoluton of  1280x720 and the target in the center of 320x240 pixels ROI
* @param target_width [in] : the rectangle width in mm on the target
* @param target_height [in] : the rectangle height in mm on the target
* @param adjust_both_sides [in] : 1 for adjusting both left and right camera calibration tables, and 0 for adjusting right camera calibraion table only
* @param ratio [out] : the corrected ratio from the calibration
* @param angle [out] : the target's tilt angle
* @param callback [in] : Optional callback for update progress notifications, the progress value is normailzed to 1
* @return       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatPointer ratio, FloatPointer angle, rs2_update_progress_callback progress_callback, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatPointer ratio, FloatPointer angle, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatBuffer ratio, FloatBuffer angle, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    float[] ratio, float[] angle, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);

/**
*  Run target-based focal length calibration
* @param device [in] : device to calibrate
* @param left_queue [in] : container for left IR frames with resoluton of  1280x720 and the target in the center of 320x240 pixels ROI.
* @param right_queue [in] : container for right IR frames with resoluton of  1280x720 and the target in the center of 320x240 pixels ROI
* @param target_width [in] : the rectangle width in mm on the target
* @param target_height [in] : the rectangle height in mm on the target
* @param adjust_both_sides [in] : 1 for adjusting both left and right camera calibration tables, and 0 for adjusting right camera calibraion table only
* @param ratio [out] : the corrected ratio from the calibration
* @param angle [out] : the target's tilt angle
* @param callback [in] : Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in] : Optional client data for the callback
* @return       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatPointer ratio, FloatPointer angle, rs2_update_progress_callback_ptr callback, Pointer client_data, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatPointer ratio, FloatPointer angle, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    FloatBuffer ratio, FloatBuffer angle, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_focal_length_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue right_queue, float target_width, float target_height, int adjust_both_sides,
    float[] ratio, float[] angle, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);

/**
*  Depth-RGB UV-Map calibration. Applicable for D400 cameras
* @param device [in] : device to calibrate
* @param left_queue [in] : the frame queue for left IR frames with resoluton of 1280x720 and the target captured in the center of 320x240 pixels ROI.
* @param color_queue [in] : the frame queue for RGB frames with resoluton of 1280x720 and the target in the center of 320x240 pixels ROI
* @param depth_queue [in] : the frame queue for Depth frames with resoluton of 1280x720
* @param py_px_only [in] : 1 for calibrating color camera py and px only, 1 for calibrating color camera py, px, fy, and fx.
* @param health [out] : The four health check numbers in order of px, py, fx, fy for the calibration
* @param health_size [in] : number of health check numbers, which is 4 by default
* @param callback [in] : Optional callback for update progress notifications, the progress value is normailzed to 1
* @return       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue, int py_px_only,
    FloatPointer health, int health_size, rs2_update_progress_callback progress_callback, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue, int py_px_only,
    FloatPointer health, int health_size, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue, int py_px_only,
    FloatBuffer health, int health_size, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration_cpp(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue, int py_px_only,
    float[] health, int health_size, rs2_update_progress_callback progress_callback, @ByPtrPtr rs2_error error);

/**
*  Depth-RGB UV-Map calibration. Applicable for D400 cameras
* @param device [in] : device to calibrate
* @param left_queue [in] : the frame queue for left IR frames with resoluton of 1280x720 and the target captured in the center of 320x240 pixels ROI.
* @param color_queue [in] : the frame queue for RGB frames with resoluton of 1280x720 and the target in the center of 320x240 pixels ROI
* @param depth_queue [in] : the frame queue for Depth frames with resoluton of 1280x720
* @param py_px_only [in] : 1 for calibrating color camera py and px only, 1 for calibrating color camera py, px, fy, and fx.
* @param health [out] : The four health check numbers in order of px, py, fx, fy for the calibration
* @param health_size [in] : number of health check numbers, which is 4 by default
* @param callback [in] : Optional callback for update progress notifications, the progress value is normailzed to 1
* @param client_data [in] : Optional client data for the callback
* @return       New calibration table
*/
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue,
    int py_px_only, FloatPointer health, int health_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue,
    int py_px_only, FloatPointer health, int health_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue,
    int py_px_only, FloatBuffer health, int health_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);
public static native @Const rs2_raw_data_buffer rs2_run_uv_map_calibration(rs2_device device, rs2_frame_queue left_queue, rs2_frame_queue color_queue, rs2_frame_queue depth_queue,
    int py_px_only, float[] health, int health_size, rs2_update_progress_callback_ptr callback, Pointer client_data, @ByPtrPtr rs2_error error);

/**
* Calculate Z for calibration target - distance to the target's plane
* @param queue [in] 1-3: A frame queue of raw images used to calculate and extract the distance to a predefined target pattern.
* For D400 the indexes 1-3 correspond to Left IR, Right IR and Depth with only the Left IR being used
* @param target_width [in] : Expected target's horizontal dimension in mm
* @param target_height [in] : Expected target's vertical dimension in mm
* @param callback [in] : Optional callback for reporting progress status
* @return       Calculated distance (Z) to target in millimeter, or negative number if failed
*/
public static native float rs2_calculate_target_z_cpp(rs2_device device, rs2_frame_queue queue1, rs2_frame_queue queue2, rs2_frame_queue queue3,
    float target_width, float target_height,
    rs2_update_progress_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_calculate_target_z_cpp(rs2_device device, rs2_frame_queue queue1, rs2_frame_queue queue2, rs2_frame_queue queue3,
    float target_width, float target_height,
    rs2_update_progress_callback callback, @ByPtrPtr rs2_error error);

/**
* Calculate Z for calibration target - distance to the target's plane
* @param queue [in] 1-3: A frame queue of raw images used to calculate and extract the distance to a predefined target pattern.
* For D400 the indexes 1-3 correspond to Left IR, Right IR and Depth with only the Left IR being used
* @param target_width [in] : Expected target's horizontal dimension in mm
* @param target_height [in] : Expected target's vertical dimension in mm
* @param callback [in] : Optional callback for reporting progress status
* @param client_data [in] : Optional client data for the callback
* @return       Calculated distance (Z) to target in millimeter, or negative number if failed
*/
public static native float rs2_calculate_target_z(rs2_device device, rs2_frame_queue queue1, rs2_frame_queue queue2, rs2_frame_queue queue3,
    float target_width, float target_height, rs2_update_progress_callback_ptr progress_callback, Pointer client_data, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_calculate_target_z(rs2_device device, rs2_frame_queue queue1, rs2_frame_queue queue2, rs2_frame_queue queue3,
    float target_width, float target_height, rs2_update_progress_callback_ptr progress_callback, Pointer client_data, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_frame.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_frame.h
* \brief
* Exposes RealSense frame functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_FRAME_H
// #define LIBREALSENSE_RS2_FRAME_H

// #ifdef __cplusplus
// #endif
// #include "rs_types.h"

/** \brief Specifies the clock in relation to which the frame timestamp was measured. */
/** enum rs2_timestamp_domain */
public static final int
    /** Frame timestamp was measured in relation to the camera clock */
    RS2_TIMESTAMP_DOMAIN_HARDWARE_CLOCK = 0,
    /** Frame timestamp was measured in relation to the OS system clock */
    RS2_TIMESTAMP_DOMAIN_SYSTEM_TIME = 1,
    /** Frame timestamp was measured in relation to the camera clock and converted to OS system clock by constantly measure the difference*/
    RS2_TIMESTAMP_DOMAIN_GLOBAL_TIME = 2,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_TIMESTAMP_DOMAIN_COUNT = 3;
public static native @Cast("const char*") BytePointer rs2_timestamp_domain_to_string(@Cast("rs2_timestamp_domain") int info);

/** \brief Per-Frame-Metadata is the set of read-only properties that might be exposed for each individual frame. */
/** enum rs2_frame_metadata_value */
public static final int
    /** A sequential index managed per-stream. Integer value*/
    RS2_FRAME_METADATA_FRAME_COUNTER = 0,
    /** Timestamp set by device clock when data readout and transmit commence. usec*/
    RS2_FRAME_METADATA_FRAME_TIMESTAMP = 1,
    /** Timestamp of the middle of sensor's exposure calculated by device. usec*/
    RS2_FRAME_METADATA_SENSOR_TIMESTAMP = 2,
    /** Sensor's exposure width. When Auto Exposure (AE) is on the value is controlled by firmware. usec*/
    RS2_FRAME_METADATA_ACTUAL_EXPOSURE = 3,
    /** A relative value increasing which will increase the Sensor's gain factor. \
                                                              When AE is set On, the value is controlled by firmware. Integer value*/
    RS2_FRAME_METADATA_GAIN_LEVEL = 4,
    /** Auto Exposure Mode indicator. Zero corresponds to AE switched off. */
    RS2_FRAME_METADATA_AUTO_EXPOSURE = 5,
    /** White Balance setting as a color temperature. Kelvin degrees*/
    RS2_FRAME_METADATA_WHITE_BALANCE = 6,
    /** Time of arrival in system clock */
    RS2_FRAME_METADATA_TIME_OF_ARRIVAL = 7,
    /** Temperature of the device, measured at the time of the frame capture. Celsius degrees */
    RS2_FRAME_METADATA_TEMPERATURE = 8,
    /** Timestamp get from uvc driver. usec*/
    RS2_FRAME_METADATA_BACKEND_TIMESTAMP = 9,
    /** Actual fps */
    RS2_FRAME_METADATA_ACTUAL_FPS = 10,
    /** Laser power value 0-360. */
    RS2_FRAME_METADATA_FRAME_LASER_POWER = 11,
    /** Laser power mode. Zero corresponds to Laser power switched off and one for switched on. deprecated, replaced by RS2_FRAME_METADATA_FRAME_EMITTER_MODE*/
    RS2_FRAME_METADATA_FRAME_LASER_POWER_MODE = 12,
    /** Exposure priority. */
    RS2_FRAME_METADATA_EXPOSURE_PRIORITY = 13,
    /** Left region of interest for the auto exposure Algorithm. */
    RS2_FRAME_METADATA_EXPOSURE_ROI_LEFT = 14,
    /** Right region of interest for the auto exposure Algorithm. */
    RS2_FRAME_METADATA_EXPOSURE_ROI_RIGHT = 15,
    /** Top region of interest for the auto exposure Algorithm. */
    RS2_FRAME_METADATA_EXPOSURE_ROI_TOP = 16,
    /** Bottom region of interest for the auto exposure Algorithm. */
    RS2_FRAME_METADATA_EXPOSURE_ROI_BOTTOM = 17,
    /** Color image brightness. */
    RS2_FRAME_METADATA_BRIGHTNESS = 18,
    /** Color image contrast. */
    RS2_FRAME_METADATA_CONTRAST = 19,
    /** Color image saturation. */
    RS2_FRAME_METADATA_SATURATION = 20,
    /** Color image sharpness. */
    RS2_FRAME_METADATA_SHARPNESS = 21,
    /** Auto white balance temperature Mode indicator. Zero corresponds to automatic mode switched off. */
    RS2_FRAME_METADATA_AUTO_WHITE_BALANCE_TEMPERATURE = 22,
    /** Color backlight compensation. Zero corresponds to switched off. */
    RS2_FRAME_METADATA_BACKLIGHT_COMPENSATION = 23,
    /** Color image hue. */
    RS2_FRAME_METADATA_HUE = 24,
    /** Color image gamma. */
    RS2_FRAME_METADATA_GAMMA = 25,
    /** Color image white balance. */
    RS2_FRAME_METADATA_MANUAL_WHITE_BALANCE = 26,
    /** Power Line Frequency for anti-flickering Off/50Hz/60Hz/Auto. */
    RS2_FRAME_METADATA_POWER_LINE_FREQUENCY = 27,
    /** Color lowlight compensation. Zero corresponds to switched off. */
    RS2_FRAME_METADATA_LOW_LIGHT_COMPENSATION = 28,
    /** Emitter mode: 0 - all emitters disabled. 1 - laser enabled. 2 - auto laser enabled (opt). 3 - LED enabled (opt).*/
    RS2_FRAME_METADATA_FRAME_EMITTER_MODE = 29,
    /** Led power value 0-360. */
    RS2_FRAME_METADATA_FRAME_LED_POWER = 30,
    /** The number of transmitted payload bytes, not including metadata */
    RS2_FRAME_METADATA_RAW_FRAME_SIZE = 31,
    /** GPIO input data */
    RS2_FRAME_METADATA_GPIO_INPUT_DATA = 32,
    /** sub-preset id */
    RS2_FRAME_METADATA_SEQUENCE_NAME = 33,
    /** sub-preset sequence id */
    RS2_FRAME_METADATA_SEQUENCE_ID = 34,
    /** sub-preset sequence size */
    RS2_FRAME_METADATA_SEQUENCE_SIZE = 35,
    RS2_FRAME_METADATA_COUNT = 36;
public static native @Cast("const char*") BytePointer rs2_frame_metadata_to_string(@Cast("rs2_frame_metadata_value") int metadata);
public static native @Cast("const char*") BytePointer rs2_frame_metadata_value_to_string(@Cast("rs2_frame_metadata_value") int metadata);

/** \brief Calibration target type. */
/** enum rs2_calib_target_type */
public static final int
    /** Flat rectangle with vertices as the centers of Gaussian dots */
    RS2_CALIB_TARGET_RECT_GAUSSIAN_DOT_VERTICES = 0,
    /** Flat rectangle with vertices as the centers of Gaussian dots with target inside the ROI */
    RS2_CALIB_TARGET_ROI_RECT_GAUSSIAN_DOT_VERTICES = 1,
    /** Positions of vertices as the centers of Gaussian dots with target inside the ROI */
    RS2_CALIB_TARGET_POS_GAUSSIAN_DOT_VERTICES = 2,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_CALIB_TARGET_COUNT = 3;
public static native @Cast("const char*") BytePointer rs2_calib_target_type_to_string(@Cast("rs2_calib_target_type") int type);

/**
* retrieve metadata from frame handle
* @param frame [in]      handle returned from a callback
* @param frame_metadata [in]  the rs2_frame_metadata whose latest frame we are interested in
* @param error [out]         if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the metadata value
*/
public static native @Cast("rs2_metadata_type") long rs2_get_frame_metadata(@Const rs2_frame frame, @Cast("rs2_frame_metadata_value") int frame_metadata, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_metadata_type") long rs2_get_frame_metadata(@Const rs2_frame frame, @Cast("rs2_frame_metadata_value") int frame_metadata, @ByPtrPtr rs2_error error);

/**
* determine device metadata
* @param frame [in]             handle returned from a callback
* @param frame_metadata [in]    the metadata to check for support
* @param error [out]         if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                true if device has this metadata
*/
public static native int rs2_supports_frame_metadata(@Const rs2_frame frame, @Cast("rs2_frame_metadata_value") int frame_metadata, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_supports_frame_metadata(@Const rs2_frame frame, @Cast("rs2_frame_metadata_value") int frame_metadata, @ByPtrPtr rs2_error error);

/**
* retrieve timestamp domain from frame handle. timestamps can only be comparable if they are in common domain
* (for example, depth timestamp might come from system time while color timestamp might come from the device)
* this method is used to check if two timestamp values are comparable (generated from the same clock)
* @param frameset [in]   handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the timestamp domain of the frame (camera / microcontroller / system time)
*/
public static native @Cast("rs2_timestamp_domain") int rs2_get_frame_timestamp_domain(@Const rs2_frame frameset, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_timestamp_domain") int rs2_get_frame_timestamp_domain(@Const rs2_frame frameset, @ByPtrPtr rs2_error error);

/**
* retrieve timestamp from frame handle in milliseconds
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the timestamp of the frame in milliseconds
*/
public static native @Cast("rs2_time_t") double rs2_get_frame_timestamp(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_time_t") double rs2_get_frame_timestamp(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve frame parent sensor from frame handle
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the parent sensor of the frame
*/
public static native rs2_sensor rs2_get_frame_sensor(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native rs2_sensor rs2_get_frame_sensor(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve frame number from frame handle
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the frame nubmer of the frame, in milliseconds since the device was started
*/
public static native @Cast("unsigned long long") long rs2_get_frame_number(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("unsigned long long") long rs2_get_frame_number(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve data size from frame handle
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the size of the frame data
*/
public static native int rs2_get_frame_data_size(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_data_size(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve data from frame handle
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the pointer to the start of the frame data
*/
public static native @Const Pointer rs2_get_frame_data(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native @Const Pointer rs2_get_frame_data(@Const rs2_frame frame, @ByPtrPtr rs2_error error);
public static native @Cast("const void*") @Name("rs2_get_frame_data") long rs2_get_frame_data_address(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const void*") @Name("rs2_get_frame_data") long rs2_get_frame_data_address(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve frame width in pixels
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               frame width in pixels
*/
public static native int rs2_get_frame_width(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_width(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve frame height in pixels
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               frame height in pixels
*/
public static native int rs2_get_frame_height(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_height(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve the scaling factor to use when converting a depth frame's get_data() units to meters
* @return float - depth, in meters, per 1 unit stored in the frame data
*/
public static native float rs2_depth_frame_get_units( @Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error );
public static native float rs2_depth_frame_get_units( @Const rs2_frame frame, @ByPtrPtr rs2_error error );

/**
* retrieve frame stride in bytes (number of bytes from start of line N to start of line N+1)
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               stride in bytes
*/
public static native int rs2_get_frame_stride_in_bytes(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_stride_in_bytes(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* retrieve bits per pixels in the frame image
* (note that bits per pixel is not necessarily divided by 8, as in 12bpp)
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               bits per pixel
*/
public static native int rs2_get_frame_bits_per_pixel(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_bits_per_pixel(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* create additional reference to a frame without duplicating frame data
* @param frame [in]      handle returned from a callback
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               new frame reference, has to be released by rs2_release_frame
*/
public static native void rs2_frame_add_ref(rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_frame_add_ref(rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* relases the frame handle
* @param frame [in] handle returned from a callback
*/
public static native void rs2_release_frame(rs2_frame frame);

/**
* communicate to the library you intend to keep the frame alive for a while
* this will remove the frame from the regular count of the frame pool
* once this function is called, the SDK can no longer guarantee 0-allocations during frame cycling
* @param frame [in] handle returned from a callback
*/
public static native void rs2_keep_frame(rs2_frame frame);

/**
* When called on Points frame type, this method returns a pointer to an array of 3D vertices of the model
* The coordinate system is: X right, Y up, Z away from the camera. Units: Meters
* @param frame [in]       Points frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                Pointer to an array of vertices, lifetime is managed by the frame
*/
public static native rs2_vertex rs2_get_frame_vertices(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native rs2_vertex rs2_get_frame_vertices(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* When called on Points frame type, this method creates a ply file of the model with the given file name.
* @param frame [in]       Points frame
* @param fname [in]       The name for the ply file
* @param texture [in]     Texture frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_export_to_ply(@Const rs2_frame frame, @Cast("const char*") BytePointer fname, rs2_frame texture, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_export_to_ply(@Const rs2_frame frame, @Cast("const char*") BytePointer fname, rs2_frame texture, @ByPtrPtr rs2_error error);
public static native void rs2_export_to_ply(@Const rs2_frame frame, String fname, rs2_frame texture, @ByPtrPtr rs2_error error);

/**
* When called on Points frame type, this method returns a pointer to an array of texture coordinates per vertex
* Each coordinate represent a (u,v) pair within [0,1] range, to be mapped to texture image
* @param frame [in]       Points frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                Pointer to an array of texture coordinates, lifetime is managed by the frame
*/
public static native rs2_pixel rs2_get_frame_texture_coordinates(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native rs2_pixel rs2_get_frame_texture_coordinates(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* When called on Points frame type, this method returns the number of vertices in the frame
* @param frame [in]       Points frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                Number of vertices
*/
public static native int rs2_get_frame_points_count(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_frame_points_count(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* Returns the stream profile that was used to start the stream of this frame
* @param frame [in]       frame reference, owned by the user
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                Pointer to the stream profile object, lifetime is managed elsewhere
*/
public static native @Const rs2_stream_profile rs2_get_frame_stream_profile(@Const rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_stream_profile rs2_get_frame_stream_profile(@Const rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* Test if the given frame can be extended to the requested extension
* @param frame [in]             Realsense frame
* @param extension_type [in]    The extension to which the frame should be tested if it is extendable
* @param error [out]             If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return non-zero value iff the frame can be extended to the given extension
*/
public static native int rs2_is_frame_extendable_to(@Const rs2_frame frame, @Cast("rs2_extension") int extension_type, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_is_frame_extendable_to(@Const rs2_frame frame, @Cast("rs2_extension") int extension_type, @ByPtrPtr rs2_error error);

/**
* Allocate new video frame using a frame-source provided form a processing block
* @param source [in]      Frame pool to allocate the frame from
* @param new_stream [in]  New stream profile to assign to newly created frame
* @param original [in]    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)
* @param new_bpp [in]     New value for bits per pixel for the allocated frame
* @param new_width [in]   New value for width for the allocated frame
* @param new_height [in]  New value for height for the allocated frame
* @param new_stride [in]  New value for stride in bytes for the allocated frame
* @param frame_type [in]  New value for frame type for the allocated frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                reference to a newly allocated frame, must be released with release_frame
*                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store
*/
public static native rs2_frame rs2_allocate_synthetic_video_frame(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original,
    int new_bpp, int new_width, int new_height, int new_stride, @Cast("rs2_extension") int frame_type, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_allocate_synthetic_video_frame(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original,
    int new_bpp, int new_width, int new_height, int new_stride, @Cast("rs2_extension") int frame_type, @ByPtrPtr rs2_error error);

/**
* Allocate new motion frame using a frame-source provided form a processing block
* @param source [in]      Frame pool to allocate the frame from
* @param new_stream [in]  New stream profile to assign to newly created frame
* @param original [in]    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)
* @param frame_type [in]  New value for frame type for the allocated frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                reference to a newly allocated frame, must be released with release_frame
*                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store
*/
public static native rs2_frame rs2_allocate_synthetic_motion_frame(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original,
    @Cast("rs2_extension") int frame_type, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_allocate_synthetic_motion_frame(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original,
    @Cast("rs2_extension") int frame_type, @ByPtrPtr rs2_error error);

/**
* Allocate new points frame using a frame-source provided from a processing block
* @param source [in]      Frame pool to allocate the frame from
* @param new_stream [in]  New stream profile to assign to newly created frame
* @param original [in]    A reference frame that can be used to fill in auxilary information like format, width, height, bpp, stride (if applicable)
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                reference to a newly allocated frame, must be released with release_frame
*                        memory for the frame is likely to be re-used from previous frame, but in lack of available frames in the pool will be allocated from the free store
*/
public static native rs2_frame rs2_allocate_points(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_allocate_points(rs2_source source, @Const rs2_stream_profile new_stream, rs2_frame original, @ByPtrPtr rs2_error error);

/**
* Allocate new composite frame, aggregating a set of existing frames
* @param source [in]      Frame pool to allocate the frame from
* @param frames [in]      Array of existing frames
* @param count [in]       Number of input frames
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                reference to a newly allocated frame, must be released with release_frame
*                        when composite frame gets released it will automatically release all of the input frames
*/
public static native rs2_frame rs2_allocate_composite_frame(rs2_source source, @Cast("rs2_frame**") PointerPointer frames, int count, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_allocate_composite_frame(rs2_source source, @ByPtrPtr rs2_frame frames, int count, @ByPtrPtr rs2_error error);

/**
* Extract frame from within a composite frame
* @param composite [in]   Composite frame
* @param index [in]       Index of the frame to extract within the composite frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                returns reference to a frame existing within the composite frame
*                        If you wish to keep this frame after the composite is released, you need to call acquire_ref
*                        Otherwise the resulting frame lifetime is bound by owning composite frame
*/
public static native rs2_frame rs2_extract_frame(rs2_frame composite, int index, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_extract_frame(rs2_frame composite, int index, @ByPtrPtr rs2_error error);

/**
* Get number of frames embedded within a composite frame
* @param composite [in]   Composite input frame
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                Number of embedded frames
*/
public static native int rs2_embedded_frames_count(rs2_frame composite, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_embedded_frames_count(rs2_frame composite, @ByPtrPtr rs2_error error);

/**
* This method will dispatch frame callback on a frame
* @param source [in]      Frame pool provided by the processing block
* @param frame [in]       Frame to dispatch, frame ownership is passed to this function, so you don't have to call release_frame after it
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_synthetic_frame_ready(rs2_source source, rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_synthetic_frame_ready(rs2_source source, rs2_frame frame, @ByPtrPtr rs2_error error);


/**
* When called on Pose frame type, this method returns the transformation represented by the pose data
* @param frame [in]       Pose frame
* @param pose [out]       Pointer to a user allocated struct, which contains the pose info after a successful return
* @param error [out]      If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_pose_frame_get_pose_data(@Const rs2_frame frame, rs2_pose pose, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_pose_frame_get_pose_data(@Const rs2_frame frame, rs2_pose pose, @ByPtrPtr rs2_error error);

/**
* Extract the target dimensions on the specific target
* @param frame [in]            Left or right camera frame of specified size based on the target type
* @param calib_type [in]       Calibration target type
* @param target_dims [out]     The array to hold the result target dimensions calculated.
                              For type RS2_CALIB_TARGET_RECT_GAUSSIAN_DOT_VERTICES and RS2_CALIB_TARGET_ROI_RECT_GAUSSIAN_DOT_VERTICES, the four rectangle side sizes in pixels with the order of top, bottom, left, and right
                              For type RS2_CALIB_TARGET_POS_GAUSSIAN_DOT_VERTICES, the four vertices coordinates in pixels with the order of top, bottom, left, and right
* @param target_dims_size [in] Target dimension array size. 4 for RS2_CALIB_TARGET_RECT_GAUSSIAN_DOT_VERTICES and 8 for RS2_CALIB_TARGET_POS_GAUSSIAN_DOT_VERTICES.
* @param error [out]           If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_extract_target_dimensions(@Const rs2_frame frame, @Cast("rs2_calib_target_type") int calib_type, FloatPointer target_dims, @Cast("unsigned int") int target_dims_size, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_extract_target_dimensions(@Const rs2_frame frame, @Cast("rs2_calib_target_type") int calib_type, FloatPointer target_dims, @Cast("unsigned int") int target_dims_size, @ByPtrPtr rs2_error error);
public static native void rs2_extract_target_dimensions(@Const rs2_frame frame, @Cast("rs2_calib_target_type") int calib_type, FloatBuffer target_dims, @Cast("unsigned int") int target_dims_size, @ByPtrPtr rs2_error error);
public static native void rs2_extract_target_dimensions(@Const rs2_frame frame, @Cast("rs2_calib_target_type") int calib_type, float[] target_dims, @Cast("unsigned int") int target_dims_size, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_option.h

/* License: Apache 2.0. See LICENSE file in root directory.
Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_option.h
* \brief
* Exposes sensor options functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_OPTION_H
// #define LIBREALSENSE_RS2_OPTION_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"

    /** \brief Defines general configuration controls.
    These can generally be mapped to camera UVC controls, and can be set / queried at any time unless stated otherwise.
    */
    /** enum rs2_option */
    public static final int
        /** Enable / disable color backlight compensation*/
        RS2_OPTION_BACKLIGHT_COMPENSATION = 0,
        /** Color image brightness*/
        RS2_OPTION_BRIGHTNESS = 1,
        /** Color image contrast*/
        RS2_OPTION_CONTRAST = 2,
        /** Controls exposure time of color camera. Setting any value will disable auto exposure*/
        RS2_OPTION_EXPOSURE = 3,
        /** Color image gain*/
        RS2_OPTION_GAIN = 4,
        /** Color image gamma setting*/
        RS2_OPTION_GAMMA = 5,
        /** Color image hue*/
        RS2_OPTION_HUE = 6,
        /** Color image saturation setting*/
        RS2_OPTION_SATURATION = 7,
        /** Color image sharpness setting*/
        RS2_OPTION_SHARPNESS = 8,
        /** Controls white balance of color image. Setting any value will disable auto white balance*/
        RS2_OPTION_WHITE_BALANCE = 9,
        /** Enable / disable color image auto-exposure*/
        RS2_OPTION_ENABLE_AUTO_EXPOSURE = 10,
        /** Enable / disable color image auto-white-balance*/
        RS2_OPTION_ENABLE_AUTO_WHITE_BALANCE = 11,
        /** Provide access to several recommend sets of option presets for the depth camera */
        RS2_OPTION_VISUAL_PRESET = 12,
        /** Power of the laser emitter, with 0 meaning projector off*/
        RS2_OPTION_LASER_POWER = 13,
        /** Set the number of patterns projected per frame. The higher the accuracy value the more patterns projected. Increasing the number of patterns help to achieve better accuracy. Note that this control is affecting the Depth FPS */
        RS2_OPTION_ACCURACY = 14,
        /** Motion vs. Range trade-off, with lower values allowing for better motion sensitivity and higher values allowing for better depth range*/
        RS2_OPTION_MOTION_RANGE = 15,
        /** Set the filter to apply to each depth frame. Each one of the filter is optimized per the application requirements*/
        RS2_OPTION_FILTER_OPTION = 16,
        /** The confidence level threshold used by the Depth algorithm pipe to set whether a pixel will get a valid range or will be marked with invalid range*/
        RS2_OPTION_CONFIDENCE_THRESHOLD = 17,
        /** Emitter select: 0 – disable all emitters. 1 – enable laser. 2 – enable auto laser. 3 – enable LED.*/
        RS2_OPTION_EMITTER_ENABLED = 18,
        /** Number of frames the user is allowed to keep per stream. Trying to hold-on to more frames will cause frame-drops.*/
        RS2_OPTION_FRAMES_QUEUE_SIZE = 19,
        /** Total number of detected frame drops from all streams */
        RS2_OPTION_TOTAL_FRAME_DROPS = 20,
        /** Auto-Exposure modes: Static, Anti-Flicker and Hybrid */
        RS2_OPTION_AUTO_EXPOSURE_MODE = 21,
        /** Power Line Frequency control for anti-flickering Off/50Hz/60Hz/Auto */
        RS2_OPTION_POWER_LINE_FREQUENCY = 22,
        /** Current Asic Temperature */
        RS2_OPTION_ASIC_TEMPERATURE = 23,
        /** disable error handling */
        RS2_OPTION_ERROR_POLLING_ENABLED = 24,
        /** Current Projector Temperature */
        RS2_OPTION_PROJECTOR_TEMPERATURE = 25,
        /** Enable / disable trigger to be outputed from the camera to any external device on every depth frame */
        RS2_OPTION_OUTPUT_TRIGGER_ENABLED = 26,
        /** Current Motion-Module Temperature */
        RS2_OPTION_MOTION_MODULE_TEMPERATURE = 27,
        /** Number of meters represented by a single depth unit */
        RS2_OPTION_DEPTH_UNITS = 28,
        /** Enable/Disable automatic correction of the motion data */
        RS2_OPTION_ENABLE_MOTION_CORRECTION = 29,
        /** Allows sensor to dynamically ajust the frame rate depending on lighting conditions */
        RS2_OPTION_AUTO_EXPOSURE_PRIORITY = 30,
        /** Color scheme for data visualization */
        RS2_OPTION_COLOR_SCHEME = 31,
        /** Perform histogram equalization post-processing on the depth data */
        RS2_OPTION_HISTOGRAM_EQUALIZATION_ENABLED = 32,
        /** Minimal distance to the target */
        RS2_OPTION_MIN_DISTANCE = 33,
        /** Maximum distance to the target */
        RS2_OPTION_MAX_DISTANCE = 34,
        /** Texture mapping stream unique ID */
        RS2_OPTION_TEXTURE_SOURCE = 35,
        /** The 2D-filter effect. The specific interpretation is given within the context of the filter */
        RS2_OPTION_FILTER_MAGNITUDE = 36,
        /** 2D-filter parameter controls the weight/radius for smoothing.*/
        RS2_OPTION_FILTER_SMOOTH_ALPHA = 37,
        /** 2D-filter range/validity threshold*/
        RS2_OPTION_FILTER_SMOOTH_DELTA = 38,
        /** Enhance depth data post-processing with holes filling where appropriate*/
        RS2_OPTION_HOLES_FILL = 39,
        /** The distance in mm between the first and the second imagers in stereo-based depth cameras*/
        RS2_OPTION_STEREO_BASELINE = 40,
        /** Allows dynamically ajust the converge step value of the target exposure in Auto-Exposure algorithm*/
        RS2_OPTION_AUTO_EXPOSURE_CONVERGE_STEP = 41,
        /** Impose Inter-camera HW synchronization mode. Applicable for D400/L500/Rolling Shutter SKUs */
        RS2_OPTION_INTER_CAM_SYNC_MODE = 42,
        /** Select a stream to process */
        RS2_OPTION_STREAM_FILTER = 43,
        /** Select a stream format to process */
        RS2_OPTION_STREAM_FORMAT_FILTER = 44,
        /** Select a stream index to process */
        RS2_OPTION_STREAM_INDEX_FILTER = 45,
        /** When supported, this option make the camera to switch the emitter state every frame. 0 for disabled, 1 for enabled */
        RS2_OPTION_EMITTER_ON_OFF = 46,
        /** Deprecated!!! - Zero order point x*/
        RS2_OPTION_ZERO_ORDER_POINT_X = 47,
        /** Deprecated!!! - Zero order point y*/
        RS2_OPTION_ZERO_ORDER_POINT_Y = 48,
        /** LDD temperature*/
        RS2_OPTION_LLD_TEMPERATURE = 49,
        /** MC temperature*/
        RS2_OPTION_MC_TEMPERATURE = 50,
        /** MA temperature*/
        RS2_OPTION_MA_TEMPERATURE = 51,
        /** Hardware stream configuration */
        RS2_OPTION_HARDWARE_PRESET = 52,
        /** disable global time  */
        RS2_OPTION_GLOBAL_TIME_ENABLED = 53,
        /** APD temperature*/
        RS2_OPTION_APD_TEMPERATURE = 54,
        /** Enable an internal map */
        RS2_OPTION_ENABLE_MAPPING = 55,
        /** Enable appearance based relocalization */
        RS2_OPTION_ENABLE_RELOCALIZATION = 56,
        /** Enable position jumping */
        RS2_OPTION_ENABLE_POSE_JUMPING = 57,
        /** Enable dynamic calibration */
        RS2_OPTION_ENABLE_DYNAMIC_CALIBRATION = 58,
        /** Offset from sensor to depth origin in millimetrers*/
        RS2_OPTION_DEPTH_OFFSET = 59,
        /** Power of the LED (light emitting diode), with 0 meaning LED off*/
        RS2_OPTION_LED_POWER = 60,
        /** DEPRECATED! - Toggle Zero-Order mode */
        RS2_OPTION_ZERO_ORDER_ENABLED = 61,
        /** Preserve previous map when starting */
        RS2_OPTION_ENABLE_MAP_PRESERVATION = 62,
        /** Enable/disable sensor shutdown when a free-fall is detected (on by default) */
        RS2_OPTION_FREEFALL_DETECTION_ENABLED = 63,
        /** Changes the exposure time of Avalanche Photo Diode in the receiver */
        RS2_OPTION_AVALANCHE_PHOTO_DIODE = 64,
        /** Changes the amount of sharpening in the post-processed image */
        RS2_OPTION_POST_PROCESSING_SHARPENING = 65,
        /** Changes the amount of sharpening in the pre-processed image */
        RS2_OPTION_PRE_PROCESSING_SHARPENING = 66,
        /** Control edges and background noise */
        RS2_OPTION_NOISE_FILTERING = 67,
        /** Enable\disable pixel invalidation */
        RS2_OPTION_INVALIDATION_BYPASS = 68,
        /** DEPRECATED! - Use RS2_OPTION_DIGITAL_GAIN instead. */
        RS2_OPTION_AMBIENT_LIGHT = 69,
        /** Change the depth digital gain see rs2_digital_gain for values */
        RS2_OPTION_DIGITAL_GAIN = RS2_OPTION_AMBIENT_LIGHT,
        /** The resolution mode: see rs2_sensor_mode for values */
        RS2_OPTION_SENSOR_MODE = RS2_OPTION_AMBIENT_LIGHT + 1,
        /** Enable Laser On constantly (GS SKU Only) */
        RS2_OPTION_EMITTER_ALWAYS_ON = RS2_OPTION_AMBIENT_LIGHT + 2,
        /** Depth Thermal Compensation for selected D400 SKUs */
        RS2_OPTION_THERMAL_COMPENSATION = RS2_OPTION_AMBIENT_LIGHT + 3,
        /** DEPRECATED as of 2.46! */
        RS2_OPTION_TRIGGER_CAMERA_ACCURACY_HEALTH = RS2_OPTION_AMBIENT_LIGHT + 4,
        /** DEPRECATED as of 2.46! */
        RS2_OPTION_RESET_CAMERA_ACCURACY_HEALTH = RS2_OPTION_AMBIENT_LIGHT + 5,
        /** Set host performance mode to optimize device settings so host can keep up with workload, for example, USB transaction granularity, setting option to low performance host leads to larger USB transaction size and reduced number of transactions which improves performance and stability if host is relatively weak as compared to workload */
        RS2_OPTION_HOST_PERFORMANCE = RS2_OPTION_AMBIENT_LIGHT + 6,
        /** Enable / disable HDR */
        RS2_OPTION_HDR_ENABLED = RS2_OPTION_AMBIENT_LIGHT + 7,
        /** HDR Sequence name */
        RS2_OPTION_SEQUENCE_NAME = RS2_OPTION_AMBIENT_LIGHT + 8,
        /** HDR Sequence size */
        RS2_OPTION_SEQUENCE_SIZE = RS2_OPTION_AMBIENT_LIGHT + 9,
        /** HDR Sequence ID - 0 is not HDR; sequence ID for HDR configuration starts from 1 */
        RS2_OPTION_SEQUENCE_ID = RS2_OPTION_AMBIENT_LIGHT + 10,
        /** Humidity temperature [Deg Celsius]*/
        RS2_OPTION_HUMIDITY_TEMPERATURE = RS2_OPTION_AMBIENT_LIGHT + 11,
        /** Turn on/off the maximum usable depth sensor range given the amount of ambient light in the scene */
        RS2_OPTION_ENABLE_MAX_USABLE_RANGE = RS2_OPTION_AMBIENT_LIGHT + 12,
        /** Turn on/off the alternate IR, When enabling alternate IR, the IR image is holding the amplitude of the depth correlation. */
        RS2_OPTION_ALTERNATE_IR = RS2_OPTION_AMBIENT_LIGHT + 13,
        /** Noise estimation - indicates the noise on the IR image */
        RS2_OPTION_NOISE_ESTIMATION = RS2_OPTION_AMBIENT_LIGHT + 14,
        /** Enables data collection for calculating IR pixel reflectivity  */
        RS2_OPTION_ENABLE_IR_REFLECTIVITY = RS2_OPTION_AMBIENT_LIGHT + 15,
        /** Set and get auto exposure limit in microseconds. Default is 0 which means full exposure range. If the requested exposure limit is greater than frame time, it will be set to frame time at runtime. Setting will not take effect until next streaming session. */
        RS2_OPTION_AUTO_EXPOSURE_LIMIT = RS2_OPTION_AMBIENT_LIGHT + 16,
        /** Set and get auto gain limits ranging from 16 to 248. Default is 0 which means full gain. If the requested gain limit is less than 16, it will be set to 16. If the requested gain limit is greater than 248, it will be set to 248. Setting will not take effect until next streaming session. */
        RS2_OPTION_AUTO_GAIN_LIMIT = RS2_OPTION_AMBIENT_LIGHT + 17,
        /** Enable receiver sensitivity according to ambient light, bounded by the Receiver Gain control. */
        RS2_OPTION_AUTO_RX_SENSITIVITY = RS2_OPTION_AMBIENT_LIGHT + 18,
        /**changes the transmitter frequencies increasing effective range over sharpness. */
        RS2_OPTION_TRANSMITTER_FREQUENCY = RS2_OPTION_AMBIENT_LIGHT + 19,
        /** Enables vertical binning which increases the maximal sensed distance. */
        RS2_OPTION_VERTICAL_BINNING = RS2_OPTION_AMBIENT_LIGHT + 20,
        /** Control receiver sensitivity to incoming light, both projected and ambient (same as APD on L515). */
        RS2_OPTION_RECEIVER_SENSITIVITY = RS2_OPTION_AMBIENT_LIGHT + 21,
        /** Enable / disable color image auto-exposure*/
        RS2_OPTION_AUTO_EXPOSURE_LIMIT_TOGGLE = RS2_OPTION_AMBIENT_LIGHT + 22,
        /** Enable / disable color image auto-gain*/
        RS2_OPTION_AUTO_GAIN_LIMIT_TOGGLE = RS2_OPTION_AMBIENT_LIGHT + 23,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_OPTION_COUNT = RS2_OPTION_AMBIENT_LIGHT + 24;

    // This function is being deprecated. For existing options it will return option name, but for future API additions the user should call rs2_get_option_name instead.
    public static native @Cast("const char*") BytePointer rs2_option_to_string(@Cast("rs2_option") int option);

    /** \brief For SR300 devices: provides optimized settings (presets) for specific types of usage. */
    /** enum rs2_sr300_visual_preset */
    public static final int
        /** Preset for short range */
        RS2_SR300_VISUAL_PRESET_SHORT_RANGE = 0,
        /** Preset for long range */
        RS2_SR300_VISUAL_PRESET_LONG_RANGE = 1,
        /** Preset for background segmentation */
        RS2_SR300_VISUAL_PRESET_BACKGROUND_SEGMENTATION = 2,
        /** Preset for gesture recognition */
        RS2_SR300_VISUAL_PRESET_GESTURE_RECOGNITION = 3,
        /** Preset for object scanning */
        RS2_SR300_VISUAL_PRESET_OBJECT_SCANNING = 4,
        /** Preset for face analytics */
        RS2_SR300_VISUAL_PRESET_FACE_ANALYTICS = 5,
        /** Preset for face login */
        RS2_SR300_VISUAL_PRESET_FACE_LOGIN = 6,
        /** Preset for GR cursor */
        RS2_SR300_VISUAL_PRESET_GR_CURSOR = 7,
        /** Camera default settings */
        RS2_SR300_VISUAL_PRESET_DEFAULT = 8,
        /** Preset for mid-range */
        RS2_SR300_VISUAL_PRESET_MID_RANGE = 9,
        /** Preset for IR only */
        RS2_SR300_VISUAL_PRESET_IR_ONLY = 10,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_SR300_VISUAL_PRESET_COUNT = 11;
    public static native @Cast("const char*") BytePointer rs2_sr300_visual_preset_to_string(@Cast("rs2_sr300_visual_preset") int preset);

    /** \brief For RS400 devices: provides optimized settings (presets) for specific types of usage. */
    /** enum rs2_rs400_visual_preset */
    public static final int
        RS2_RS400_VISUAL_PRESET_CUSTOM = 0,
        RS2_RS400_VISUAL_PRESET_DEFAULT = 1,
        RS2_RS400_VISUAL_PRESET_HAND = 2,
        RS2_RS400_VISUAL_PRESET_HIGH_ACCURACY = 3,
        RS2_RS400_VISUAL_PRESET_HIGH_DENSITY = 4,
        RS2_RS400_VISUAL_PRESET_MEDIUM_DENSITY = 5,
        RS2_RS400_VISUAL_PRESET_REMOVE_IR_PATTERN = 6,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_RS400_VISUAL_PRESET_COUNT = 7;
    public static native @Cast("const char*") BytePointer rs2_rs400_visual_preset_to_string(@Cast("rs2_rs400_visual_preset") int preset);

    /** \brief For L500 devices: provides optimized settings (presets) for specific types of usage. */
    /** enum rs2_l500_visual_preset */
    public static final int
        RS2_L500_VISUAL_PRESET_CUSTOM = 0,
        RS2_L500_VISUAL_PRESET_DEFAULT = 1,
        RS2_L500_VISUAL_PRESET_NO_AMBIENT = 2,
        RS2_L500_VISUAL_PRESET_LOW_AMBIENT = 3,
        RS2_L500_VISUAL_PRESET_MAX_RANGE = 4,
        RS2_L500_VISUAL_PRESET_SHORT_RANGE = 5,
        RS2_L500_VISUAL_PRESET_AUTOMATIC = 6,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_L500_VISUAL_PRESET_COUNT = 7;
    public static native @Cast("const char*") BytePointer rs2_l500_visual_preset_to_string(@Cast("rs2_l500_visual_preset") int preset);

    /** \brief For setting the camera_mode option */
    /** enum rs2_sensor_mode */
    public static final int
        RS2_SENSOR_MODE_VGA = 0,
        RS2_SENSOR_MODE_XGA = 1,
        RS2_SENSOR_MODE_QVGA = 2,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_SENSOR_MODE_COUNT = 3;
    public static native @Cast("const char*") BytePointer rs2_sensor_mode_to_string(@Cast("rs2_sensor_mode") int preset);

    /** \brief  DEPRECATED! - Use RS2_OPTION_DIGITAL_GAIN instead. */
    /** enum rs2_ambient_light */
    public static final int
        RS2_AMBIENT_LIGHT_NO_AMBIENT = 1,
        RS2_AMBIENT_LIGHT_LOW_AMBIENT = 2;
    

    /** \brief digital gain for RS2_OPTION_DIGITAL_GAIN option. */
    /** enum rs2_digital_gain */
    public static final int
        RS2_DIGITAL_GAIN_AUTO = 0,
        RS2_DIGITAL_GAIN_HIGH = 1,
        RS2_DIGITAL_GAIN_LOW = 2;
    

    /** \brief values for RS2_OPTION_HOST_PERFORMANCE option. */
    /** enum rs2_host_perf_mode */
    public static final int
        /** no change in settings, use device defaults */
        RS2_HOST_PERF_DEFAULT = 0,
        /** low performance host mode, if host cannot keep up with workload, this option may improve stability, for example, it sets larger USB transaction granularity, reduces number of transactions and improve performance and stability on relatively weak hosts as compared to the workload */
        RS2_HOST_PERF_LOW = 1,
        /** high performance host mode, if host is strong as compared to the work and can handle workload without delay, this option sets smaller USB transactions granularity and as result larger number of transactions and workload on host, but reduces chance in device frame drops */
        RS2_HOST_PERF_HIGH = 2,
        /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
        RS2_HOST_PERF_COUNT = 3;
    public static native @Cast("const char*") BytePointer rs2_host_perf_mode_to_string( @Cast("rs2_host_perf_mode") int perf );

    /**
    * check if an option is read-only
    * @param options [in]  the options container
    * @param option [in]   option id to be checked
    * @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return true if option is read-only
    */
    public static native int rs2_is_option_read_only(@Const rs2_options options, @Cast("rs2_option") int option, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_is_option_read_only(@Const rs2_options options, @Cast("rs2_option") int option, @ByPtrPtr rs2_error error);

    /**
    * read option value from the sensor
    * @param options [in]  the options container
    * @param option [in]   option id to be queried
    * @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return value of the option
    */
    public static native float rs2_get_option(@Const rs2_options options, @Cast("rs2_option") int option, @Cast("rs2_error**") PointerPointer error);
    public static native float rs2_get_option(@Const rs2_options options, @Cast("rs2_option") int option, @ByPtrPtr rs2_error error);

    /**
    * write new value to sensor option
    * @param options [in]    the options container
    * @param option [in]     option id to be queried
    * @param value [in]      new value for the option
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_set_option(@Const rs2_options options, @Cast("rs2_option") int option, float value, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_set_option(@Const rs2_options options, @Cast("rs2_option") int option, float value, @ByPtrPtr rs2_error error);

   /**
   * get the list of supported options of options container
   * @param options [in]    the options container
   * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
   */
    public static native rs2_options_list rs2_get_options_list(@Const rs2_options options, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_options_list rs2_get_options_list(@Const rs2_options options, @ByPtrPtr rs2_error error);

    /**
   * get the size of options list
   * @param options [in]    the option list
   * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
   */
    public static native int rs2_get_options_list_size(@Const rs2_options_list options, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_get_options_list_size(@Const rs2_options_list options, @ByPtrPtr rs2_error error);

    /**
    * get option name
    * @param options [in]    the options container
    * @param option [in]     option id to be checked
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return human-readable option name
    */
    public static native @Cast("const char*") BytePointer rs2_get_option_name(@Const rs2_options options, @Cast("rs2_option") int option, @Cast("rs2_error**") PointerPointer error);
    public static native @Cast("const char*") BytePointer rs2_get_option_name(@Const rs2_options options, @Cast("rs2_option") int option, @ByPtrPtr rs2_error error);

    /**
   * get the specific option from options list
   * @param i [in]    the index of the option
   * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
   */
    public static native @Cast("rs2_option") int rs2_get_option_from_list(@Const rs2_options_list options, int i, @Cast("rs2_error**") PointerPointer error);
    public static native @Cast("rs2_option") int rs2_get_option_from_list(@Const rs2_options_list options, int i, @ByPtrPtr rs2_error error);

    /**
    * Deletes options list
    * @param list [in] list to delete
    */
    public static native void rs2_delete_options_list(rs2_options_list list);

    /**
    * check if particular option is supported by a subdevice
    * @param options [in]    the options container
    * @param option [in]     option id to be checked
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return true if option is supported
    */
    public static native int rs2_supports_option(@Const rs2_options options, @Cast("rs2_option") int option, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_supports_option(@Const rs2_options options, @Cast("rs2_option") int option, @ByPtrPtr rs2_error error);

    /**
    * retrieve the available range of values of a supported option
    * @param sensor [in]  the RealSense device
    * @param option [in]  the option whose range should be queried
    * @param min [out]    the minimum value which will be accepted for this option
    * @param max [out]    the maximum value which will be accepted for this option
    * @param step [out]   the granularity of options which accept discrete values, or zero if the option accepts continuous values
    * @param def [out]    the default value of the option
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_get_option_range(@Const rs2_options sensor, @Cast("rs2_option") int option, FloatPointer min, FloatPointer max, FloatPointer step, FloatPointer def, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_get_option_range(@Const rs2_options sensor, @Cast("rs2_option") int option, FloatPointer min, FloatPointer max, FloatPointer step, FloatPointer def, @ByPtrPtr rs2_error error);
    public static native void rs2_get_option_range(@Const rs2_options sensor, @Cast("rs2_option") int option, FloatBuffer min, FloatBuffer max, FloatBuffer step, FloatBuffer def, @ByPtrPtr rs2_error error);
    public static native void rs2_get_option_range(@Const rs2_options sensor, @Cast("rs2_option") int option, float[] min, float[] max, float[] step, float[] def, @ByPtrPtr rs2_error error);

    /**
    * get option description
    * @param options [in]    the options container
    * @param option [in]     option id to be checked
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return human-readable option description
    */
    public static native @Cast("const char*") BytePointer rs2_get_option_description(@Const rs2_options options, @Cast("rs2_option") int option, @Cast("rs2_error**") PointerPointer error);
    public static native @Cast("const char*") BytePointer rs2_get_option_description(@Const rs2_options options, @Cast("rs2_option") int option, @ByPtrPtr rs2_error error);

    /**
    * get option value description (in case specific option value hold special meaning)
    * @param options [in]    the options container
    * @param option [in]     option id to be checked
    * @param value [in]      value of the option
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return human-readable description of a specific value of an option or null if no special meaning
    */
    public static native @Cast("const char*") BytePointer rs2_get_option_value_description(@Const rs2_options options, @Cast("rs2_option") int option, float value, @Cast("rs2_error**") PointerPointer error);
    public static native @Cast("const char*") BytePointer rs2_get_option_value_description(@Const rs2_options options, @Cast("rs2_option") int option, float value, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_processing.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_processing.h
* \brief
* Exposes RealSense processing-block functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_PROCESSING_H
// #define LIBREALSENSE_RS2_PROCESSING_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"
// #include "rs_sensor.h"
// #include "rs_option.h"

/**
* Creates Depth-Colorizer processing block that can be used to quickly visualize the depth data
* This block will accept depth frames as input and replace them by depth frames with format RGB8
* Non-depth frames are passed through
* Further customization will be added soon (format, color-map, histogram equalization control)
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_colorizer(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_colorizer(@ByPtrPtr rs2_error error);

/**
* Creates Sync processing block. This block accepts arbitrary frames and output composite frames of best matches
* Some frames may be released within the syncer if they are waiting for match for too long
* Syncronization is done (mostly) based on timestamps so good hardware timestamps are a pre-condition
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_sync_processing_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_sync_processing_block(@ByPtrPtr rs2_error error);

/**
* Creates Point-Cloud processing block. This block accepts depth frames and outputs Points frames
* In addition, given non-depth frame, the block will align texture coordinate to the non-depth stream
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_pointcloud(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_pointcloud(@ByPtrPtr rs2_error error);

/**
* Creates YUY decoder processing block. This block accepts raw YUY frames and outputs frames of other formats.
* YUY is a common video format used by a variety of web-cams. It benefits from packing pixels into 2 bytes per pixel
* without signficant quality drop. YUY representation can be converted back to more usable RGB form,
* but this requires somewhat costly conversion.
* The SDK will automatically try to use SSE2 and AVX instructions and CUDA where available to get
* best performance. Other implementations (using GLSL, OpenCL, Neon and NCS) should follow.
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_yuy_decoder(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_yuy_decoder(@ByPtrPtr rs2_error error);

/**
* Creates y411 decoder processing block. This block accepts raw y411 frames and outputs frames in RGB8.
*     https://www.fourcc.org/pixel-format/yuv-y411/
* Y411 is disguised as NV12 to allow Linux compatibility. Both are 12bpp encodings that allow high-resolution
* modes in the camera to still fit within the USB3 limits (YUY wasn't enough).
*
* The SDK will automatically try to use SSE2 and AVX instructions and CUDA where available to get
* best performance. Other implementations (using GLSL, OpenCL, Neon and NCS) should follow.
*
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/


/**
* Creates depth thresholding processing block
* By controlling min and max options on the block, one could filter out depth values
* that are either too large or too small, as a software post-processing step
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_threshold(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_threshold(@ByPtrPtr rs2_error error);

/**
* Creates depth units transformation processing block
* All of the pixels are transformed from depth units into meters.
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_units_transform(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_units_transform(@ByPtrPtr rs2_error error);

/**
* This method creates new custom processing block. This lets the users pass frames between module boundaries for processing
* This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as sync, colorizer, etc..
* @param proc       Processing function to be applied to every frame entering the block
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return           new processing block, to be released by rs2_delete_processing_block
*/
public static native rs2_processing_block rs2_create_processing_block(rs2_frame_processor_callback proc, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_processing_block(rs2_frame_processor_callback proc, @ByPtrPtr rs2_error error);

/**
* This method creates new custom processing block from function pointer. This lets the users pass frames between module boundaries for processing
* This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as sync, colorizer, etc..
* @param proc       Processing function pointer to be applied to every frame entering the block
* @param context    User context (can be anything or null) to be passed later as ctx param of the callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return           new processing block, to be released by rs2_delete_processing_block
*/
public static native rs2_processing_block rs2_create_processing_block_fptr(rs2_frame_processor_callback_ptr proc, Pointer context, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_processing_block_fptr(rs2_frame_processor_callback_ptr proc, Pointer context, @ByPtrPtr rs2_error error);

/**
* This method adds a custom option to a custom processing block. This is a simple float that can be accessed via rs2_set_option and rs2_get_option
* This is an infrastructure function aimed at middleware developers, and also used by provided blocks such as save_to_ply, etc..
* @param block [in]      Processing block
* @param option_id [in]  an int ID for referencing the option
* @param min [in]     the minimum value which will be accepted for this option
* @param max [in]     the maximum value which will be accepted for this option
* @param step [in]    the granularity of options which accept discrete values, or zero if the option accepts continuous values
* @param def [in]     the default value of the option. This will be the initial value.
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            true if adding the option succeeds. false if it fails e.g. an option with this id is already registered
*/
public static native int rs2_processing_block_register_simple_option(rs2_processing_block block, @Cast("rs2_option") int option_id, float min, float max, float step, float def, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_processing_block_register_simple_option(rs2_processing_block block, @Cast("rs2_option") int option_id, float min, float max, float step, float def, @ByPtrPtr rs2_error error);

/**
* This method is used to direct the output from the processing block to some callback or sink object
* @param block [in]          Processing block
* @param on_frame [in]       Callback to be invoked every time the processing block calls frame_ready
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start_processing(rs2_processing_block block, rs2_frame_callback on_frame, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start_processing(rs2_processing_block block, rs2_frame_callback on_frame, @ByPtrPtr rs2_error error);

/**
* This method is used to direct the output from the processing block to some callback or sink object
* @param block [in]          Processing block
* @param on_frame [in]       Callback function to be invoked every time the processing block calls frame_ready
* @param user [in]           User context for the callback (can be anything or null)
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start_processing_fptr(rs2_processing_block block, rs2_frame_callback_ptr on_frame, Pointer user, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start_processing_fptr(rs2_processing_block block, rs2_frame_callback_ptr on_frame, Pointer user, @ByPtrPtr rs2_error error);

/**
* This method is used to direct the output from the processing block to a dedicated queue object
* @param block [in]          Processing block
* @param queue [in]          Queue to place the processed frames to
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start_processing_queue(rs2_processing_block block, rs2_frame_queue queue, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start_processing_queue(rs2_processing_block block, rs2_frame_queue queue, @ByPtrPtr rs2_error error);

/**
* This method is used to pass frame into a processing block
* @param block [in]          Processing block
* @param frame [in]          Frame to process, ownership is moved to the block object
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_process_frame(rs2_processing_block block, rs2_frame frame, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_process_frame(rs2_processing_block block, rs2_frame frame, @ByPtrPtr rs2_error error);

/**
* Deletes the processing block
* @param block [in]          Processing block
*/
public static native void rs2_delete_processing_block(rs2_processing_block block);

/**
* create frame queue. frame queues are the simplest x-platform synchronization primitive provided by librealsense
* to help developers who are not using async APIs
* @param capacity [in] max number of frames to allow to be stored in the queue before older frames will start to get dropped
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return handle to the frame queue, must be released using rs2_delete_frame_queue
*/
public static native rs2_frame_queue rs2_create_frame_queue(int _capacity, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame_queue rs2_create_frame_queue(int _capacity, @ByPtrPtr rs2_error error);

/**
* deletes frame queue and releases all frames inside it
* @param queue [in] queue to delete
*/
public static native void rs2_delete_frame_queue(rs2_frame_queue queue);

/**
* queries the number of frames
* @param queue [in] to delete
* @return the number of frames currently stored in queue
*/
public static native int rs2_frame_queue_size(rs2_frame_queue queue, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_frame_queue_size(rs2_frame_queue queue, @ByPtrPtr rs2_error error);

/**
* wait until new frame becomes available in the queue and dequeue it
* @param queue [in] the frame queue data structure
* @param timeout_ms [in]   max time in milliseconds to wait until an exception will be thrown
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return frame handle to be released using rs2_release_frame
*/
public static native rs2_frame rs2_wait_for_frame(rs2_frame_queue queue, @Cast("unsigned int") int timeout_ms, @Cast("rs2_error**") PointerPointer error);
public static native rs2_frame rs2_wait_for_frame(rs2_frame_queue queue, @Cast("unsigned int") int timeout_ms, @ByPtrPtr rs2_error error);

/**
* poll if a new frame is available and dequeue if it is
* @param queue [in] the frame queue data structure
* @param output_frame [out] frame handle to be released using rs2_release_frame
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return true if new frame was stored to output_frame
*/
public static native int rs2_poll_for_frame(rs2_frame_queue queue, @Cast("rs2_frame**") PointerPointer output_frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_poll_for_frame(rs2_frame_queue queue, @ByPtrPtr rs2_frame output_frame, @ByPtrPtr rs2_error error);

/**
* wait until new frame becomes available in the queue and dequeue it
* @param queue [in]          the frame queue data structure
* @param timeout_ms [in]     max time in milliseconds to wait until a frame becomes available
* @param output_frame [out]  frame handle to be released using rs2_release_frame
* @param error [out]         if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return true if new frame was stored to output_frame
*/
public static native int rs2_try_wait_for_frame(rs2_frame_queue queue, @Cast("unsigned int") int timeout_ms, @Cast("rs2_frame**") PointerPointer output_frame, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_try_wait_for_frame(rs2_frame_queue queue, @Cast("unsigned int") int timeout_ms, @ByPtrPtr rs2_frame output_frame, @ByPtrPtr rs2_error error);

/**
* enqueue new frame into a queue
* @param frame [in] frame handle to enqueue (this operation passed ownership to the queue)
* @param queue [in] the frame queue data structure
*/
public static native void rs2_enqueue_frame(rs2_frame frame, Pointer queue);

/**
* Creates Align processing block.
* @param align_to [in]   stream type to be used as the target of frameset alignment
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_align(@Cast("rs2_stream") int align_to, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_align(@Cast("rs2_stream") int align_to, @ByPtrPtr rs2_error error);

/**
* Creates Depth post-processing filter block. This block accepts depth frames, applies decimation filter and plots modified prames
* Note that due to the modifiedframe size, the decimated frame repaces the original one
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_decimation_filter_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_decimation_filter_block(@ByPtrPtr rs2_error error);

/**
* Creates Depth post-processing filter block. This block accepts depth frames, applies temporal filter
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_temporal_filter_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_temporal_filter_block(@ByPtrPtr rs2_error error);

/**
* Creates Depth post-processing spatial filter block. This block accepts depth frames, applies spatial filters and plots modified prames
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_spatial_filter_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_spatial_filter_block(@ByPtrPtr rs2_error error);

/**
* Creates a post processing block that provides for depth<->disparity domain transformation for stereo-based depth modules
* @param transform_to_disparity [in] flag select the transform direction:  true = depth->disparity, and vice versa
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_disparity_transform_block(@Cast("unsigned char") byte transform_to_disparity, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_disparity_transform_block(@Cast("unsigned char") byte transform_to_disparity, @ByPtrPtr rs2_error error);

/**
* Creates Depth post-processing hole filling block. The filter replaces empty pixels with data from adjacent pixels based on the method selected
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_hole_filling_filter_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_hole_filling_filter_block(@ByPtrPtr rs2_error error);

/**
* Creates a rates printer block. The printer prints the actual FPS of the invoked frame stream.
* The block ignores reapiting frames and calculats the FPS only if the frame number of the relevant frame was changed.
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_rates_printer_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_rates_printer_block(@ByPtrPtr rs2_error error);

/**
* Creates Depth post-processing zero order fix block. The filter invalidates pixels that has a wrong value due to zero order effect
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               zero order fix processing block
*/
public static native rs2_processing_block rs2_create_zero_order_invalidation_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_zero_order_invalidation_block(@ByPtrPtr rs2_error error);

/**
* Creates Depth frame decompression module. Decoded frames compressed and transmitted with Z16H variable-lenght Huffman code to
* standartized Z16 Depth data format. Using the compression allows to reduce the Depth frames bandwidth by more than 50 percent
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Huffman-code decompression processing block
*/
public static native rs2_processing_block rs2_create_huffman_depth_decompress_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_huffman_depth_decompress_block(@ByPtrPtr rs2_error error);

/**
* Creates a hdr_merge processing block.
* The block merges between two depth frames with different exposure values
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_hdr_merge_processing_block(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_hdr_merge_processing_block(@ByPtrPtr rs2_error error);

/**
* Creates a sequence_id_filter processing block.
* The block lets frames with the selected sequence id pass and blocks frames with other values
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native rs2_processing_block rs2_create_sequence_id_filter(@Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_create_sequence_id_filter(@ByPtrPtr rs2_error error);

/**
* Retrieve processing block specific information, like name.
* @param block [in]     The processing block
* @param info [in]      processing block info type to retrieve
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               The requested processing block info string, in a format specific to the device model
*/
public static native @Cast("const char*") BytePointer rs2_get_processing_block_info(@Const rs2_processing_block block, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_get_processing_block_info(@Const rs2_processing_block block, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
* Check if a processing block supports a specific info type.
* @param block [in]     The processing block to check
* @param info [in]      The parameter to check for support
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               True if the parameter both exist and well-defined for the specific device
*/
public static native int rs2_supports_processing_block_info(@Const rs2_processing_block block, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_supports_processing_block_info(@Const rs2_processing_block block, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
 * Test if the given processing block can be extended to the requested extension
 * @param block [in] processing block
 * @param extension [in] The extension to which the sensor should be tested if it is extendable
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return non-zero value iff the processing block can be extended to the given extension
 */
public static native int rs2_is_processing_block_extendable_to(@Const rs2_processing_block block, @Cast("rs2_extension") int extension_type, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_is_processing_block_extendable_to(@Const rs2_processing_block block, @Cast("rs2_extension") int extension_type, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_record_playback.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_record_playback.h
* \brief
* Exposes record and playback functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_RECORD_PLAYBACK_H
// #define LIBREALSENSE_RS2_RECORD_PLAYBACK_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"

/** enum rs2_playback_status */
public static final int
    /** Unknown state */
    RS2_PLAYBACK_STATUS_UNKNOWN = 0,
    /** One or more sensors were started, playback is reading and raising data */
    RS2_PLAYBACK_STATUS_PLAYING = 1,
    /** One or more sensors were started, but playback paused reading and paused raising data*/
    RS2_PLAYBACK_STATUS_PAUSED = 2,
    /** All sensors were stopped, or playback has ended (all data was read). This is the initial playback status*/
    RS2_PLAYBACK_STATUS_STOPPED = 3,
    RS2_PLAYBACK_STATUS_COUNT = 4;

public static native @Cast("const char*") BytePointer rs2_playback_status_to_string(@Cast("rs2_playback_status") int status);
// Targeting ../rs2_playback_status_changed_callback_ptr.java



/**
 * Creates a recording device to record the given device and save it to the given file
 * @param device [in]    The device to record
 * @param file [in]      The desired path to which the recorder should save the data
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return A pointer to a device that records its data to file, or null in case of failure
 */
public static native rs2_device rs2_create_record_device(@Const rs2_device device, @Cast("const char*") BytePointer file, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_create_record_device(@Const rs2_device device, @Cast("const char*") BytePointer file, @ByPtrPtr rs2_error error);
public static native rs2_device rs2_create_record_device(@Const rs2_device device, String file, @ByPtrPtr rs2_error error);

/**
* Creates a recording device to record the given device and save it to the given file
* @param device [in]                The device to record
* @param file [in]                  The desired path to which the recorder should save the data
* @param compression_enabled [in]   Indicates if compression is enabled, 0 means false, otherwise true
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return A pointer to a device that records its data to file, or null in case of failure
*/
public static native rs2_device rs2_create_record_device_ex(@Const rs2_device device, @Cast("const char*") BytePointer file, int compression_enabled, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_create_record_device_ex(@Const rs2_device device, @Cast("const char*") BytePointer file, int compression_enabled, @ByPtrPtr rs2_error error);
public static native rs2_device rs2_create_record_device_ex(@Const rs2_device device, String file, int compression_enabled, @ByPtrPtr rs2_error error);

/**
* Pause the recording device without stopping the actual device from streaming.
* Pausing will cause the device to stop writing new data to the file, in particular, frames and changes to extensions
* @param device [in]    A recording device
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_record_device_pause(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_record_device_pause(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Unpause the recording device. Resume will cause the device to continue writing new data to the file, in particular, frames and changes to extensions
* @param device [in]    A recording device
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_record_device_resume(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_record_device_resume(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Gets the name of the file to which the recorder is writing
* @param device [in]    A recording device
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return The  name of the file to which the recorder is writing
*/
public static native @Cast("const char*") BytePointer rs2_record_device_filename(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_record_device_filename(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
* Creates a playback device to play the content of the given file
* @param file [in]      Path to the file to play
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return A pointer to a device that plays data from the file, or null in case of failure
*/


/**
 * Gets the path of the file used by the playback device
 * @param device [in] A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return Path to the file used by the playback device
 */
public static native @Cast("const char*") BytePointer rs2_playback_device_get_file_path(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_playback_device_get_file_path(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Gets the total duration of the file in units of nanoseconds
 * @param device [in]     A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return Total duration of the file in units of nanoseconds
 */
public static native @Cast("unsigned long long int") long rs2_playback_get_duration(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("unsigned long long int") long rs2_playback_get_duration(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Set the playback to a specified time point of the played data
 * @param device [in]     A playback device.
 * @param time [in]       The time point to which playback should seek, expressed in units of nanoseconds (zero value = start)
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_seek(@Const rs2_device device, long time, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_seek(@Const rs2_device device, long time, @ByPtrPtr rs2_error error);

/**
 * Gets the current position of the playback in the file in terms of time. Units are expressed in nanoseconds
 * @param device [in]     A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return Current position of the playback in the file in terms of time. Units are expressed in nanoseconds
 */
public static native @Cast("unsigned long long int") long rs2_playback_get_position(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("unsigned long long int") long rs2_playback_get_position(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Pauses the playback
 * Calling pause() in "Paused" status does nothing
 * If pause() is called while playback status is "Playing" or "Stopped", the playback will not play until resume() is called
 * @param device [in] A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_device_resume(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_resume(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Un-pauses the playback
 * Calling resume() while playback status is "Playing" or "Stopped" does nothing
 * @param device [in] A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_device_pause(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_pause(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Set the playback to work in real time or non real time
 *
 * In real time mode, playback will play the same way the file was recorded.
 * In real time mode if the application takes too long to handle the callback, frames may be dropped.
 * In non real time mode, playback will wait for each callback to finish handling the data before
 * reading the next frame. In this mode no frames will be dropped, and the application controls the
 * frame rate of the playback (according to the callback handler duration).
 * @param device [in] A playback device
 * @param real_time [in]  Indicates if real time is requested, 0 means false, otherwise true
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_device_set_real_time(@Const rs2_device device, int real_time, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_set_real_time(@Const rs2_device device, int real_time, @ByPtrPtr rs2_error error);

/**
 * Indicates if playback is in real time mode or non real time
 * @param device [in] A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return True iff playback is in real time mode. 0 means false, otherwise true
 */
public static native int rs2_playback_device_is_real_time(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_playback_device_is_real_time(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Register to receive callback from playback device upon its status changes
 *
 * Callbacks are invoked from the reading thread, any heavy processing in the callback handler will affect
 * the reading thread and may cause frame drops\ high latency
 * @param device [in]     A playback device
 * @param callback [in]   A callback handler that will be invoked when the playback status changes
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_device_set_status_changed_callback(@Const rs2_device device, rs2_playback_status_changed_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_set_status_changed_callback(@Const rs2_device device, rs2_playback_status_changed_callback callback, @ByPtrPtr rs2_error error);

/**
 * Returns the current state of the playback device
 * @param device [in]     A playback device
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return Current state of the playback
 */
public static native @Cast("rs2_playback_status") int rs2_playback_device_get_current_status(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_playback_status") int rs2_playback_device_get_current_status(@Const rs2_device device, @ByPtrPtr rs2_error error);

/**
 * Set the playing speed
 *
 * @param device [in] A playback device
 * @param speed [in]  Indicates a multiplication of the speed to play (e.g: 1 = normal, 0.5 twice as slow)
 * @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_playback_device_set_playback_speed(@Const rs2_device device, float speed, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_set_playback_speed(@Const rs2_device device, float speed, @ByPtrPtr rs2_error error);

/**
* Stops the playback
* Calling stop() will stop all streaming playbakc sensors and will reset the playback (returning to beginning of file)
* @param device [in] A playback device
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_playback_device_stop(@Const rs2_device device, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_playback_device_stop(@Const rs2_device device, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_sensor.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_sensor.h
* \brief
* Exposes RealSense sensor functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_SENSOR_H
// #define LIBREALSENSE_RS2_SENSOR_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"

/** \brief Read-only strings that can be queried from the device.
   Not all information attributes are available on all camera types.
   This information is mainly available for camera debug and troubleshooting and should not be used in applications. */
/** enum rs2_camera_info */
public static final int
    /** Friendly name */
    RS2_CAMERA_INFO_NAME = 0,
    /** Device serial number */
    RS2_CAMERA_INFO_SERIAL_NUMBER = 1,
    /** Primary firmware version */
    RS2_CAMERA_INFO_FIRMWARE_VERSION = 2,
    /** Recommended firmware version */
    RS2_CAMERA_INFO_RECOMMENDED_FIRMWARE_VERSION = 3,
    /** Unique identifier of the port the device is connected to (platform specific) */
    RS2_CAMERA_INFO_PHYSICAL_PORT = 4,
    /** If device supports firmware logging, this is the command to send to get logs from firmware */
    RS2_CAMERA_INFO_DEBUG_OP_CODE = 5,
    /** True iff the device is in advanced mode */
    RS2_CAMERA_INFO_ADVANCED_MODE = 6,
    /** Product ID as reported in the USB descriptor */
    RS2_CAMERA_INFO_PRODUCT_ID = 7,
    /** True iff EEPROM is locked */
    RS2_CAMERA_INFO_CAMERA_LOCKED = 8,
    /** Designated USB specification: USB2/USB3 */
    RS2_CAMERA_INFO_USB_TYPE_DESCRIPTOR = 9,
    /** Device product line D400/SR300/L500/T200 */
    RS2_CAMERA_INFO_PRODUCT_LINE = 10,
    /** ASIC serial number */
    RS2_CAMERA_INFO_ASIC_SERIAL_NUMBER = 11,
    /** Firmware update ID */
    RS2_CAMERA_INFO_FIRMWARE_UPDATE_ID = 12,
    /** IP address for remote camera. */
    RS2_CAMERA_INFO_IP_ADDRESS = 13,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_CAMERA_INFO_COUNT = 14;
public static native @Cast("const char*") BytePointer rs2_camera_info_to_string(@Cast("rs2_camera_info") int info);

/** \brief Streams are different types of data provided by RealSense devices. */
/** enum rs2_stream */
public static final int
    RS2_STREAM_ANY = 0,
    /** Native stream of depth data produced by RealSense device */
    RS2_STREAM_DEPTH = 1,
    /** Native stream of color data captured by RealSense device */
    RS2_STREAM_COLOR = 2,
    /** Native stream of infrared data captured by RealSense device */
    RS2_STREAM_INFRARED = 3,
    /** Native stream of fish-eye (wide) data captured from the dedicate motion camera */
    RS2_STREAM_FISHEYE = 4,
    /** Native stream of gyroscope motion data produced by RealSense device */
    RS2_STREAM_GYRO = 5,
    /** Native stream of accelerometer motion data produced by RealSense device */
    RS2_STREAM_ACCEL = 6,
    /** Signals from external device connected through GPIO */
    RS2_STREAM_GPIO = 7,
    /** 6 Degrees of Freedom pose data, calculated by RealSense device */
    RS2_STREAM_POSE = 8,
    /** 4 bit per-pixel depth confidence level */
    RS2_STREAM_CONFIDENCE = 9,
    RS2_STREAM_COUNT = 10;
public static native @Cast("const char*") BytePointer rs2_stream_to_string(@Cast("rs2_stream") int stream);

/** \brief A stream's format identifies how binary data is encoded within a frame. */
/** enum rs2_format */
public static final int
    /** When passed to enable stream, librealsense will try to provide best suited format */
    RS2_FORMAT_ANY = 0,
    /** 16-bit linear depth values. The depth is meters is equal to depth scale * pixel value. */
    RS2_FORMAT_Z16 = 1,
    /** 16-bit float-point disparity values. Depth->Disparity conversion : Disparity = Baseline*FocalLength/Depth. */
    RS2_FORMAT_DISPARITY16 = 2,
    /** 32-bit floating point 3D coordinates. */
    RS2_FORMAT_XYZ32F = 3,
    /** 32-bit y0, u, y1, v data for every two pixels. Similar to YUV422 but packed in a different order - https://en.wikipedia.org/wiki/YUV */
    RS2_FORMAT_YUYV = 4,
    /** 8-bit red, green and blue channels */
    RS2_FORMAT_RGB8 = 5,
    /** 8-bit blue, green, and red channels -- suitable for OpenCV */
    RS2_FORMAT_BGR8 = 6,
    /** 8-bit red, green and blue channels + constant alpha channel equal to FF */
    RS2_FORMAT_RGBA8 = 7,
    /** 8-bit blue, green, and red channels + constant alpha channel equal to FF */
    RS2_FORMAT_BGRA8 = 8,
    /** 8-bit per-pixel grayscale image */
    RS2_FORMAT_Y8 = 9,
    /** 16-bit per-pixel grayscale image */
    RS2_FORMAT_Y16 = 10,
    /** Four 10 bits per pixel luminance values packed into a 5-byte macropixel */
    RS2_FORMAT_RAW10 = 11,
    /** 16-bit raw image */
    RS2_FORMAT_RAW16 = 12,
    /** 8-bit raw image */
    RS2_FORMAT_RAW8 = 13,
    /** Similar to the standard YUYV pixel format, but packed in a different order */
    RS2_FORMAT_UYVY = 14,
    /** Raw data from the motion sensor */
    RS2_FORMAT_MOTION_RAW = 15,
    /** Motion data packed as 3 32-bit float values, for X, Y, and Z axis */
    RS2_FORMAT_MOTION_XYZ32F = 16,
    /** Raw data from the external sensors hooked to one of the GPIO's */
    RS2_FORMAT_GPIO_RAW = 17,
    /** Pose data packed as floats array, containing translation vector, rotation quaternion and prediction velocities and accelerations vectors */
    RS2_FORMAT_6DOF = 18,
    /** 32-bit float-point disparity values. Depth->Disparity conversion : Disparity = Baseline*FocalLength/Depth */
    RS2_FORMAT_DISPARITY32 = 19,
    /** 16-bit per-pixel grayscale image unpacked from 10 bits per pixel packed ([8:8:8:8:2222]) grey-scale image. The data is unpacked to LSB and padded with 6 zero bits */
    RS2_FORMAT_Y10BPACK = 20,
    /** 32-bit float-point depth distance value.  */
    RS2_FORMAT_DISTANCE = 21,
    /** Bitstream encoding for video in which an image of each frame is encoded as JPEG-DIB   */
    RS2_FORMAT_MJPEG = 22,
    /** 8-bit per pixel interleaved. 8-bit left, 8-bit right.  */
    RS2_FORMAT_Y8I = 23,
    /** 12-bit per pixel interleaved. 12-bit left, 12-bit right. Each pixel is stored in a 24-bit word in little-endian order. */
    RS2_FORMAT_Y12I = 24,
    /** multi-planar Depth 16bit + IR 10bit.  */
    RS2_FORMAT_INZI = 25,
    /** 8-bit IR stream.  */
    RS2_FORMAT_INVI = 26,
    /** Grey-scale image as a bit-packed array. 4 pixel data stream taking 5 bytes */
    RS2_FORMAT_W10 = 27,
    /** Variable-length Huffman-compressed 16-bit depth values. */
    RS2_FORMAT_Z16H = 28,
    /** 16-bit per-pixel frame grabber format. */
    RS2_FORMAT_FG = 29,
    /** 12-bit per-pixel. */
    RS2_FORMAT_Y411 = 30,
    /** Number of enumeration values. Not a valid input: intended to be used in for-loops. */
    RS2_FORMAT_COUNT = 31;
public static native @Cast("const char*") BytePointer rs2_format_to_string(@Cast("rs2_format") int format);
// Targeting ../rs2_extrinsics.java



/**
* Deletes sensors list, any sensors created from this list will remain unaffected
* @param info_list [in] list to delete
*/
public static native void rs2_delete_sensor_list(rs2_sensor_list info_list);

/**
* Determines number of sensors in a list
* @param info_list [in] The list of connected sensors captured using rs2_query_sensors
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            Sensors count
*/
public static native int rs2_get_sensors_count(@Const rs2_sensor_list info_list, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_sensors_count(@Const rs2_sensor_list info_list, @ByPtrPtr rs2_error error);

/**
* delete relasense sensor
* @param sensor [in] realsense sensor to delete
*/
public static native void rs2_delete_sensor(rs2_sensor sensor);

/**
* create sensor by index
* @param index [in]   the zero based index of sensor to retrieve
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the requested sensor, should be released by rs2_delete_sensor
*/
public static native rs2_sensor rs2_create_sensor(@Const rs2_sensor_list list, int index, @Cast("rs2_error**") PointerPointer error);
public static native rs2_sensor rs2_create_sensor(@Const rs2_sensor_list list, int index, @ByPtrPtr rs2_error error);

/**
* This is a helper function allowing the user to discover the device from one of its sensors
* @param sensor [in]     Pointer to a sensor
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               new device wrapper for the device of the sensor. Needs to be released by delete_device
*/
public static native rs2_device rs2_create_device_from_sensor(@Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native rs2_device rs2_create_device_from_sensor(@Const rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* retrieve sensor specific information, like versions of various internal components
* @param sensor [in]     the RealSense sensor
* @param info [in]       camera info type to retrieve
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               the requested camera info string, in a format specific to the device model
*/
public static native @Cast("const char*") BytePointer rs2_get_sensor_info(@Const rs2_sensor sensor, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_get_sensor_info(@Const rs2_sensor sensor, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
* check if specific sensor info is supported
* @param info [in]    the parameter to check for support
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                true if the parameter both exist and well-defined for the specific device
*/
public static native int rs2_supports_sensor_info(@Const rs2_sensor sensor, @Cast("rs2_camera_info") int info, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_supports_sensor_info(@Const rs2_sensor sensor, @Cast("rs2_camera_info") int info, @ByPtrPtr rs2_error error);

/**
 * Test if the given sensor can be extended to the requested extension
 * @param sensor [in]  Realsense sensor
 * @param extension [in] The extension to which the sensor should be tested if it is extendable
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return non-zero value iff the sensor can be extended to the given extension
 */
public static native int rs2_is_sensor_extendable_to(@Const rs2_sensor sensor, @Cast("rs2_extension") int extension, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_is_sensor_extendable_to(@Const rs2_sensor sensor, @Cast("rs2_extension") int extension, @ByPtrPtr rs2_error error);

/** When called on a depth sensor, this method will return the number of meters represented by a single depth unit
* @param sensor [in]      depth sensor
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                the number of meters represented by a single depth unit
*/
public static native float rs2_get_depth_scale(rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_get_depth_scale(rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* Retrieve the stereoscopic baseline value from frame. Applicable to stereo-based depth modules
* @param float [out]  Stereoscopic baseline in millimeters
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native float rs2_depth_stereo_frame_get_baseline(@Const rs2_frame frame_ref, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_depth_stereo_frame_get_baseline(@Const rs2_frame frame_ref, @ByPtrPtr rs2_error error);

/**
* Retrieve the stereoscopic baseline value from sensor. Applicable to stereo-based depth modules
* @param float [out]  Stereoscopic baseline in millimeters
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native float rs2_get_stereo_baseline(rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_get_stereo_baseline(rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
 * \brief sets the active region of interest to be used by auto-exposure algorithm
 * @param sensor [in]     the RealSense sensor
 * @param min_x [in]      lower horizontal bound in pixels
 * @param min_y [in]      lower vertical bound in pixels
 * @param max_x [in]      upper horizontal bound in pixels
 * @param max_y [in]      upper vertical bound in pixels
 * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_set_region_of_interest(@Const rs2_sensor sensor, int min_x, int min_y, int max_x, int max_y, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_region_of_interest(@Const rs2_sensor sensor, int min_x, int min_y, int max_x, int max_y, @ByPtrPtr rs2_error error);

/**
 * \brief gets the active region of interest to be used by auto-exposure algorithm
 * @param sensor [in]     the RealSense sensor
 * @param min_x [out]     lower horizontal bound in pixels
 * @param min_y [out]     lower vertical bound in pixels
 * @param max_x [out]     upper horizontal bound in pixels
 * @param max_y [out]     upper vertical bound in pixels
 * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_get_region_of_interest(@Const rs2_sensor sensor, IntPointer min_x, IntPointer min_y, IntPointer max_x, IntPointer max_y, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_region_of_interest(@Const rs2_sensor sensor, IntPointer min_x, IntPointer min_y, IntPointer max_x, IntPointer max_y, @ByPtrPtr rs2_error error);
public static native void rs2_get_region_of_interest(@Const rs2_sensor sensor, IntBuffer min_x, IntBuffer min_y, IntBuffer max_x, IntBuffer max_y, @ByPtrPtr rs2_error error);
public static native void rs2_get_region_of_interest(@Const rs2_sensor sensor, int[] min_x, int[] min_y, int[] max_x, int[] max_y, @ByPtrPtr rs2_error error);

/**
* open subdevice for exclusive access, by committing to a configuration
* @param device [in] relevant RealSense device
* @param profile [in]    stream profile that defines single stream configuration
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_open(rs2_sensor device, @Const rs2_stream_profile profile, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_open(rs2_sensor device, @Const rs2_stream_profile profile, @ByPtrPtr rs2_error error);

/**
* open subdevice for exclusive access, by committing to composite configuration, specifying one or more stream profiles
* this method should be used for interdependent  streams, such as depth and infrared, that have to be configured together
* @param device [in] relevant RealSense device
* @param profiles [in]  list of stream profiles discovered by get_stream_profiles
* @param count [in]      number of simultaneous  stream profiles to configure
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_open_multiple(rs2_sensor device, @Cast("const rs2_stream_profile**") PointerPointer profiles, int count, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_open_multiple(rs2_sensor device, @Const @ByPtrPtr rs2_stream_profile profiles, int count, @ByPtrPtr rs2_error error);

/**
* stop any streaming from specified subdevice
* @param sensor [in]     RealSense device
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_close(@Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_close(@Const rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* start streaming from specified configured sensor
* @param sensor [in]  RealSense device
* @param on_frame [in] function pointer to register as per-frame callback
* @param user [in] auxiliary  data the user wishes to receive together with every frame callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start(@Const rs2_sensor sensor, rs2_frame_callback_ptr on_frame, Pointer user, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start(@Const rs2_sensor sensor, rs2_frame_callback_ptr on_frame, Pointer user, @ByPtrPtr rs2_error error);

/**
* start streaming from specified configured sensor
* @param sensor [in]  RealSense device
* @param callback [in] callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start_cpp(@Const rs2_sensor sensor, rs2_frame_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start_cpp(@Const rs2_sensor sensor, rs2_frame_callback callback, @ByPtrPtr rs2_error error);

/**
* start streaming from specified configured sensor of specific stream to frame queue
* @param sensor [in]  RealSense Sensor
* @param queue [in]   frame-queue to store new frames into
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_start_queue(@Const rs2_sensor sensor, rs2_frame_queue queue, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_start_queue(@Const rs2_sensor sensor, rs2_frame_queue queue, @ByPtrPtr rs2_error error);

/**
* stops streaming from specified configured device
* @param sensor [in]  RealSense sensor
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_stop(@Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_stop(@Const rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* set callback to get notifications from specified sensor
* @param sensor [in]          RealSense device
* @param on_notification [in] function pointer to register as per-notifications callback
* @param error [out]          if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_notifications_callback(@Const rs2_sensor sensor, rs2_notification_callback_ptr on_notification, Pointer user, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_notifications_callback(@Const rs2_sensor sensor, rs2_notification_callback_ptr on_notification, Pointer user, @ByPtrPtr rs2_error error);

/**
* set callback to get notifications from specified device
* @param sensor [in]  RealSense sensor
* @param callback [in] callback object created from c++ application. ownership over the callback object is moved into the relevant subdevice lock
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_notifications_callback_cpp(@Const rs2_sensor sensor, rs2_notifications_callback callback, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_notifications_callback_cpp(@Const rs2_sensor sensor, rs2_notifications_callback callback, @ByPtrPtr rs2_error error);

/**
* retrieve description from notification handle
* @param notification [in]      handle returned from a callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the notification description
*/
public static native @Cast("const char*") BytePointer rs2_get_notification_description(rs2_notification notification, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_get_notification_description(rs2_notification notification, @ByPtrPtr rs2_error error);

/**
* retrieve timestamp from notification handle
* @param notification [in]      handle returned from a callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the notification timestamp
*/
public static native @Cast("rs2_time_t") double rs2_get_notification_timestamp(rs2_notification notification, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_time_t") double rs2_get_notification_timestamp(rs2_notification notification, @ByPtrPtr rs2_error error);

/**
* retrieve severity from notification handle
* @param notification [in]      handle returned from a callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the notification severity
*/
public static native @Cast("rs2_log_severity") int rs2_get_notification_severity(rs2_notification notification, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_log_severity") int rs2_get_notification_severity(rs2_notification notification, @ByPtrPtr rs2_error error);

/**
* retrieve category from notification handle
* @param notification [in]      handle returned from a callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the notification category
*/
public static native @Cast("rs2_notification_category") int rs2_get_notification_category(rs2_notification notification, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_notification_category") int rs2_get_notification_category(rs2_notification notification, @ByPtrPtr rs2_error error);

/**
* retrieve serialized data from notification handle
* @param notification [in]      handle returned from a callback
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the serialized data (in JSON format)
*/
public static native @Cast("const char*") BytePointer rs2_get_notification_serialized_data(rs2_notification notification, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const char*") BytePointer rs2_get_notification_serialized_data(rs2_notification notification, @ByPtrPtr rs2_error error);

/**
* check if physical subdevice is supported
* @param sensor [in]  input RealSense subdevice
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            list of stream profiles that given subdevice can provide, should be released by rs2_delete_profiles_list
*/
public static native rs2_stream_profile_list rs2_get_stream_profiles(rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native rs2_stream_profile_list rs2_get_stream_profiles(rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* retrieve list of debug stream profiles that given subdevice can provide
* @param sensor [in]  input RealSense subdevice
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            list of debug stream profiles that given subdevice can provide, should be released by rs2_delete_profiles_list
*/
public static native rs2_stream_profile_list rs2_get_debug_stream_profiles( rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error );
public static native rs2_stream_profile_list rs2_get_debug_stream_profiles( rs2_sensor sensor, @ByPtrPtr rs2_error error );

/**
* check how subdevice is streaming
* @param sensor [in]  input RealSense subdevice
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            list of stream profiles that given subdevice is currently streaming, should be released by rs2_delete_profiles_list
*/
public static native rs2_stream_profile_list rs2_get_active_streams(rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native rs2_stream_profile_list rs2_get_active_streams(rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* Get pointer to specific stream profile
* @param list [in]        the list of supported profiles returned by rs2_get_supported_profiles
* @param index [in]       the zero based index of the streaming mode
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native @Const rs2_stream_profile rs2_get_stream_profile(@Const rs2_stream_profile_list list, int index, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_stream_profile rs2_get_stream_profile(@Const rs2_stream_profile_list list, int index, @ByPtrPtr rs2_error error);

/**
* Extract common parameters of a stream profiles
* @param mode [in]        input stream profile
* @param stream [out]     stream type of the input profile
* @param format [out]     binary data format of the input profile
* @param index [out]      stream index the input profile in case there are multiple streams of the same type
* @param unique_id [out]  identifier for the stream profile, unique within the application
* @param framerate [out]  expected rate for data frames to arrive, meaning expected number of frames per second
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_get_stream_profile_data(@Const rs2_stream_profile mode, @Cast("rs2_stream*") IntPointer stream, @Cast("rs2_format*") IntPointer format, IntPointer index, IntPointer unique_id, IntPointer framerate, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_stream_profile_data(@Const rs2_stream_profile mode, @Cast("rs2_stream*") IntPointer stream, @Cast("rs2_format*") IntPointer format, IntPointer index, IntPointer unique_id, IntPointer framerate, @ByPtrPtr rs2_error error);
public static native void rs2_get_stream_profile_data(@Const rs2_stream_profile mode, @Cast("rs2_stream*") IntBuffer stream, @Cast("rs2_format*") IntBuffer format, IntBuffer index, IntBuffer unique_id, IntBuffer framerate, @ByPtrPtr rs2_error error);
public static native void rs2_get_stream_profile_data(@Const rs2_stream_profile mode, @Cast("rs2_stream*") int[] stream, @Cast("rs2_format*") int[] format, int[] index, int[] unique_id, int[] framerate, @ByPtrPtr rs2_error error);

/**
* Override some of the parameters of the stream profile
* @param mode [in]        input stream profile
* @param stream [in]      stream type for the profile
* @param format [in]      binary data format of the profile
* @param index [in]       stream index the profile in case there are multiple streams of the same type
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_stream_profile_data(rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_stream_profile_data(rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, @ByPtrPtr rs2_error error);

/**
* Creates a copy of stream profile, assigning new values to some of the fields
* @param mode [in]        input stream profile
* @param stream [in]      stream type for the profile
* @param format [in]      binary data format of the profile
* @param index [in]       stream index the profile in case there are multiple streams of the same type
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                new stream profile, must be deleted by rs2_delete_stream_profile
*/
public static native rs2_stream_profile rs2_clone_stream_profile(@Const rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, @Cast("rs2_error**") PointerPointer error);
public static native rs2_stream_profile rs2_clone_stream_profile(@Const rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, @ByPtrPtr rs2_error error);

/**
* Creates a copy of stream profile, assigning new values to some of the fields
* @param mode [in]        input stream profile
* @param stream [in]      stream type for the profile
* @param format [in]      binary data format of the profile
* @param width [in]       new width for the profile
* @param height [in]      new height for the profile
* @param intr [in]        new intrinsics for the profile
* @param index [in]       stream index the profile in case there are multiple streams of the same type
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                new stream profile, must be deleted by rs2_delete_stream_profile
*/
public static native rs2_stream_profile rs2_clone_video_stream_profile(@Const rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, int width, int height, @Const rs2_intrinsics intr, @Cast("rs2_error**") PointerPointer error);
public static native rs2_stream_profile rs2_clone_video_stream_profile(@Const rs2_stream_profile mode, @Cast("rs2_stream") int stream, int index, @Cast("rs2_format") int format, int width, int height, @Const rs2_intrinsics intr, @ByPtrPtr rs2_error error);


/**
* Delete stream profile allocated by rs2_clone_stream_profile
* Should not be called on stream profiles returned by the device
* @param mode [in]        input stream profile
*/
public static native void rs2_delete_stream_profile(rs2_stream_profile mode);

/**
* Try to extend stream profile to an extension type
* @param mode [in]        input stream profile
* @param type [in]        extension type, for example RS2_EXTENSION_VIDEO_STREAM_PROFILE
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                non-zero if profile is extendable to specified extension, zero otherwise
*/
public static native int rs2_stream_profile_is(@Const rs2_stream_profile mode, @Cast("rs2_extension") int type, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_stream_profile_is(@Const rs2_stream_profile mode, @Cast("rs2_extension") int type, @ByPtrPtr rs2_error error);

/**
* When called on a video stream profile, will return the width and the height of the stream
* @param mode [in]        input stream profile
* @param width [out]      width in pixels of the video stream
* @param height [out]     height in pixels of the video stream
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_get_video_stream_resolution(@Const rs2_stream_profile mode, IntPointer width, IntPointer height, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_video_stream_resolution(@Const rs2_stream_profile mode, IntPointer width, IntPointer height, @ByPtrPtr rs2_error error);
public static native void rs2_get_video_stream_resolution(@Const rs2_stream_profile mode, IntBuffer width, IntBuffer height, @ByPtrPtr rs2_error error);
public static native void rs2_get_video_stream_resolution(@Const rs2_stream_profile mode, int[] width, int[] height, @ByPtrPtr rs2_error error);

/**
* Obtain the intrinsics of a specific stream configuration from the device.
* @param mode [in]          input stream profile
* @param intrinsics [out]   Pointer to the struct to store the data in
* @param error [out]        If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_get_motion_intrinsics(@Const rs2_stream_profile mode, rs2_motion_device_intrinsic intrinsics, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_motion_intrinsics(@Const rs2_stream_profile mode, rs2_motion_device_intrinsic intrinsics, @ByPtrPtr rs2_error error);

/**
* Returns non-zero if selected profile is recommended for the sensor
* This is an optional hint we offer to suggest profiles with best performance-quality tradeof
* @param mode [in]        input stream profile
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                non-zero if selected profile is recommended for the sensor
*/
public static native int rs2_is_stream_profile_default(@Const rs2_stream_profile mode, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_is_stream_profile_default(@Const rs2_stream_profile mode, @ByPtrPtr rs2_error error);

/**
* get the number of supported stream profiles
* @param list [in]        the list of supported profiles returned by rs2_get_supported_profiles
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return number of supported subdevice profiles
*/
public static native int rs2_get_stream_profiles_count(@Const rs2_stream_profile_list list, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_stream_profiles_count(@Const rs2_stream_profile_list list, @ByPtrPtr rs2_error error);

/**
* delete stream profiles list
* @param list [in]        the list of supported profiles returned by rs2_get_supported_profiles
*/
public static native void rs2_delete_stream_profiles_list(rs2_stream_profile_list list);

/**
 * @param from [in]          origin stream profile
 * @param to [in]            target stream profile
 * @param extrin [out]       extrinsics from origin to target
 * @param error [out]        if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_get_extrinsics(@Const rs2_stream_profile from,
                        @Const rs2_stream_profile to,
                        rs2_extrinsics extrin, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_extrinsics(@Const rs2_stream_profile from,
                        @Const rs2_stream_profile to,
                        rs2_extrinsics extrin, @ByPtrPtr rs2_error error);

/**
* @param from [in]          origin stream profile
* @param to [in]            target stream profile
* @param extrin [out]       extrinsics from origin to target
* @param error [out]        if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_register_extrinsics(@Const rs2_stream_profile from,
    @Const rs2_stream_profile to,
    @ByVal rs2_extrinsics extrin, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_register_extrinsics(@Const rs2_stream_profile from,
    @Const rs2_stream_profile to,
    @ByVal rs2_extrinsics extrin, @ByPtrPtr rs2_error error);

/**
 * \brief Override extrinsics of a given sensor that supports calibrated_sensor.
 *
 * This will affect extrinsics at the source device and may affect multiple profiles. Used for DEPTH_TO_RGB calibration.
 *
* @param sensor [in]       The sensor
* @param extrinsics [in]   Extrinsics from Depth to the named sensor
* @param error [out]       If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_override_extrinsics( @Const rs2_sensor sensor, @Const rs2_extrinsics extrinsics, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_override_extrinsics( @Const rs2_sensor sensor, @Const rs2_extrinsics extrinsics, @ByPtrPtr rs2_error error );

/**
 * When called on a video profile, returns the intrinsics of specific stream configuration
 * @param mode [in]          input stream profile
 * @param intrinsics [out]   resulting intrinsics for the video profile
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_get_video_stream_intrinsics(@Const rs2_stream_profile mode, rs2_intrinsics intrinsics, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_video_stream_intrinsics(@Const rs2_stream_profile mode, rs2_intrinsics intrinsics, @ByPtrPtr rs2_error error);

/**
 * Returns the list of recommended processing blocks for a specific sensor.
 * Order and configuration of the blocks are decided by the sensor
 * @param sensor [in]          input sensor
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return list of supported sensor recommended processing blocks
*/
public static native rs2_processing_block_list rs2_get_recommended_processing_blocks(rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block_list rs2_get_recommended_processing_blocks(rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* Returns specific processing blocks from processing blocks list
* @param list [in]           the processing blocks list
* @param index [in]          the requested processing block
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return processing block
*/
public static native rs2_processing_block rs2_get_processing_block(@Const rs2_processing_block_list list, int index, @Cast("rs2_error**") PointerPointer error);
public static native rs2_processing_block rs2_get_processing_block(@Const rs2_processing_block_list list, int index, @ByPtrPtr rs2_error error);

/**
* Returns the processing blocks list size
* @param list [in]           the processing blocks list
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return the processing block list size
*/
public static native int rs2_get_recommended_processing_blocks_count(@Const rs2_processing_block_list list, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_recommended_processing_blocks_count(@Const rs2_processing_block_list list, @ByPtrPtr rs2_error error);

/**
* Deletes processing blocks list
* @param list [in] list to delete
*/
public static native void rs2_delete_recommended_processing_blocks(rs2_processing_block_list list);

/**
* Imports a localization map from file to tm2 tracking device
* @param sensor [in]        TM2 position-tracking sensor
* @param lmap_blob [in]     Localization map raw buffer, serialized
* @param blob_size [in]     The buffer's size in bytes
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                   Non-zero if succeeded, otherwise 0
*/
public static native int rs2_import_localization_map(@Const rs2_sensor sensor, @Cast("const unsigned char*") BytePointer lmap_blob, @Cast("unsigned int") int blob_size, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_import_localization_map(@Const rs2_sensor sensor, @Cast("const unsigned char*") BytePointer lmap_blob, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);
public static native int rs2_import_localization_map(@Const rs2_sensor sensor, @Cast("const unsigned char*") ByteBuffer lmap_blob, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);
public static native int rs2_import_localization_map(@Const rs2_sensor sensor, @Cast("const unsigned char*") byte[] lmap_blob, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);

/**
* Extract and store the localization map of tm2 tracking device to file
* @param sensor [in]        TM2 position-tracking sensor
* @param lmap_fname [in]    The file name of the localization map
* @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                   Device's response in a rs2_raw_data_buffer, which should be released by rs2_delete_raw_data
*/
//void rs2_export_localization_map(const rs2_sensor* sensor, const char* lmap_fname, rs2_error** error);
public static native @Const rs2_raw_data_buffer rs2_export_localization_map(@Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native @Const rs2_raw_data_buffer rs2_export_localization_map(@Const rs2_sensor sensor, @ByPtrPtr rs2_error error);

/**
* Create a named location tag
* @param sensor [in]    T2xx position-tracking sensor
* @param guid [in]      Null-terminated string of up to 127 characters
* @param pos [in]       Position in meters, relative to the current tracking session
* @param orient [in]    Quaternion orientation, expressed the the coordinate system of the current tracking session
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Non-zero if succeeded, otherwise 0
*/
public static native int rs2_set_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, @Const @ByVal rs2_vector pos, @Const @ByVal rs2_quaternion orient, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_set_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, @Const @ByVal rs2_vector pos, @Const @ByVal rs2_quaternion orient, @ByPtrPtr rs2_error error);
public static native int rs2_set_static_node(@Const rs2_sensor sensor, String guid, @Const @ByVal rs2_vector pos, @Const @ByVal rs2_quaternion orient, @ByPtrPtr rs2_error error);

/**
* Retrieve a named location tag
* @param sensor [in]    T2xx position-tracking sensor
* @param guid [in]      Null-terminated string of up to 127 characters
* @param pos [out]       Position in meters of the tagged (stored) location
* @param orient [out]    Quaternion orientation of the tagged (stored) location
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Non-zero if succeeded, otherwise 0
*/
public static native int rs2_get_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, rs2_vector pos, rs2_quaternion orient, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, rs2_vector pos, rs2_quaternion orient, @ByPtrPtr rs2_error error);
public static native int rs2_get_static_node(@Const rs2_sensor sensor, String guid, rs2_vector pos, rs2_quaternion orient, @ByPtrPtr rs2_error error);

/**
* Remove a named location tag
* @param sensor [in]    T2xx position-tracking sensor
* @param guid [in]      Null-terminated string of up to 127 characters
* @param error [out]     If non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return               Non-zero if succeeded, otherwise 0
*/
public static native int rs2_remove_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_remove_static_node(@Const rs2_sensor sensor, @Cast("const char*") BytePointer guid, @ByPtrPtr rs2_error error);
public static native int rs2_remove_static_node(@Const rs2_sensor sensor, String guid, @ByPtrPtr rs2_error error);

/** Load Wheel odometer settings from host to device
* @param odometry_config_buf [in]   odometer configuration/calibration blob serialized from jsom file
* @return true on success
*/
public static native int rs2_load_wheel_odometry_config(@Const rs2_sensor sensor, @Cast("const unsigned char*") BytePointer odometry_config_buf, @Cast("unsigned int") int blob_size, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_load_wheel_odometry_config(@Const rs2_sensor sensor, @Cast("const unsigned char*") BytePointer odometry_config_buf, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);
public static native int rs2_load_wheel_odometry_config(@Const rs2_sensor sensor, @Cast("const unsigned char*") ByteBuffer odometry_config_buf, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);
public static native int rs2_load_wheel_odometry_config(@Const rs2_sensor sensor, @Cast("const unsigned char*") byte[] odometry_config_buf, @Cast("unsigned int") int blob_size, @ByPtrPtr rs2_error error);

/** Send wheel odometry data for each individual sensor (wheel)
* @param wo_sensor_id [in]       - Zero-based index of (wheel) sensor with the same type within device
* @param frame_num [in]          - Monotonocally increasing frame number, managed per sensor.
* @param translational_velocity [in]   - Translational velocity of the wheel sensor [meter/sec]
* @return true on success
*/
public static native int rs2_send_wheel_odometry(@Const rs2_sensor sensor, @Cast("char") byte wo_sensor_id, @Cast("unsigned int") int frame_num,
    @Const @ByVal rs2_vector translational_velocity, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_send_wheel_odometry(@Const rs2_sensor sensor, @Cast("char") byte wo_sensor_id, @Cast("unsigned int") int frame_num,
    @Const @ByVal rs2_vector translational_velocity, @ByPtrPtr rs2_error error);

/**
* Set intrinsics of a given sensor
* @param sensor [in]       The RealSense device
* @param profile [in]      Target stream profile
* @param intrinsics [in]   Intrinsics value to be written to the device
* @param error [out]       If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_intrinsics(@Const rs2_sensor sensor, @Const rs2_stream_profile profile, @Const rs2_intrinsics intrinsics, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_intrinsics(@Const rs2_sensor sensor, @Const rs2_stream_profile profile, @Const rs2_intrinsics intrinsics, @ByPtrPtr rs2_error error);

/**
 * \brief Override intrinsics of a given sensor that supports calibrated_sensor.
 *
 * This will affect intrinsics at the source and may affect multiple profiles. Used for DEPTH_TO_RGB calibration.
 *
* @param sensor [in]       The RealSense device
* @param intrinsics [in]   Intrinsics value to be written to the sensor
* @param error [out]       If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_override_intrinsics( @Const rs2_sensor sensor, @Const rs2_intrinsics intrinsics, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_override_intrinsics( @Const rs2_sensor sensor, @Const rs2_intrinsics intrinsics, @ByPtrPtr rs2_error error );

/**
 * Set extrinsics between two sensors
 * @param from_sensor [in]  Origin sensor
 * @param from_profile [in] Origin profile
 * @param to_sensor [in]    Target sensor
 * @param to_profile [in]   Target profile
 * @param extrinsics [out]   Extrinsics from origin to target
 * @param error [out]        If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_set_extrinsics(@Const rs2_sensor from_sensor, @Const rs2_stream_profile from_profile, rs2_sensor to_sensor, @Const rs2_stream_profile to_profile, @Const rs2_extrinsics extrinsics, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_extrinsics(@Const rs2_sensor from_sensor, @Const rs2_stream_profile from_profile, rs2_sensor to_sensor, @Const rs2_stream_profile to_profile, @Const rs2_extrinsics extrinsics, @ByPtrPtr rs2_error error);

/**
 * Get the DSM parameters for a sensor
 * @param sensor [in]        Sensor that supports the CALIBRATED_SENSOR extension
 * @param p_params_out [out]  Pointer to the structure that will get the DSM parameters
 * @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_get_dsm_params( @Const rs2_sensor sensor, rs2_dsm_params p_params_out, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_get_dsm_params( @Const rs2_sensor sensor, rs2_dsm_params p_params_out, @ByPtrPtr rs2_error error );

/**
 * Set the sensor DSM parameters
 * This should ideally be done when the stream is NOT running. If it is, the
 * parameters may not take effect immediately.
 * @param sensor [in]        Sensor that supports the CALIBRATED_SENSOR extension
 * @param p_params [out]      Pointer to the structure that contains the DSM parameters
 * @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_override_dsm_params( @Const rs2_sensor sensor, @Const rs2_dsm_params p_params, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_override_dsm_params( @Const rs2_sensor sensor, @Const rs2_dsm_params p_params, @ByPtrPtr rs2_error error );

/**
 * Reset the sensor DSM parameters
 * This should ideally be done when the stream is NOT running. May not take effect immediately.
 * @param sensor [in]        Sensor that supports the CALIBRATED_SENSOR extension
 * @param error [out]         If non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_reset_sensor_calibration( @Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_reset_sensor_calibration( @Const rs2_sensor sensor, @ByPtrPtr rs2_error error );

/**
* Set motion device intrinsics
* @param sensor [in]       Motion sensor 
* @param profile [in]      Motion stream profile
* @param intrinsics [out]   Pointer to the struct to store the data in
* @param error [out]        If non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_set_motion_device_intrinsics(@Const rs2_sensor sensor, @Const rs2_stream_profile profile, @Const rs2_motion_device_intrinsic intrinsics, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_motion_device_intrinsics(@Const rs2_sensor sensor, @Const rs2_stream_profile profile, @Const rs2_motion_device_intrinsic intrinsics, @ByPtrPtr rs2_error error);

/** When called on a depth sensor, this method will return the maximum range of the camera given the amount of ambient light in the scene
* @param sensor [in]      depth sensor
* @param error [out]      if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return                the max usable range in meters
*/
public static native float rs2_get_max_usable_depth_range(@Const rs2_sensor sensor, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_get_max_usable_depth_range(@Const rs2_sensor sensor, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif  // LIBREALSENSE_RS2_SENSOR_H


// Parsed from librealsense2/h/rs_config.h

/* License: Apache 2.0. See LICENSE file in root directory.
Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_pipeline.h
* \brief
* Exposes RealSense processing-block functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_CONFIG_H
// #define LIBREALSENSE_RS2_CONFIG_H

public static final int RS2_DEFAULT_TIMEOUT = 15000;

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"
// #include "rs_sensor.h"

    /**
    * Create a config instance
    * The config allows pipeline users to request filters for the pipeline streams and device selection and configuration.
    * This is an optional step in pipeline creation, as the pipeline resolves its streaming device internally.
    * Config provides its users a way to set the filters and test if there is no conflict with the pipeline requirements
    * from the device. It also allows the user to find a matching device for the config filters and the pipeline, in order to
    * select a device explicitly, and modify its controls before streaming starts.
    *
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return rs2_config*  A pointer to a new config instance
    */
    public static native rs2_config rs2_create_config(@Cast("rs2_error**") PointerPointer error);
    public static native rs2_config rs2_create_config(@ByPtrPtr rs2_error error);

    /**
    * Deletes an instance of a config
    *
    * @param config [in]    A pointer to an instance of a config
    */
    public static native void rs2_delete_config(rs2_config config);

    /**
    * Enable a device stream explicitly, with selected stream parameters.
    * The method allows the application to request a stream with specific configuration. If no stream is explicitly enabled, the pipeline
    * configures the device and its streams according to the attached computer vision modules and processing blocks requirements, or
    * default configuration for the first available device.
    * The application can configure any of the input stream parameters according to its requirement, or set to 0 for don't care value.
    * The config accumulates the application calls for enable configuration methods, until the configuration is applied. Multiple enable
    * stream calls for the same stream with conflicting parameters override each other, and the last call is maintained.
    * Upon calling \c resolve(), the config checks for conflicts between the application configuration requests and the attached computer
    * vision modules and processing blocks requirements, and fails if conflicts are found. Before \c resolve() is called, no conflict
    * check is done.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param stream [in]    Stream type to be enabled
    * @param index [in]     Stream index, used for multiple streams of the same type. -1 indicates any.
    * @param width [in]     Stream image width - for images streams. 0 indicates any.
    * @param height [in]    Stream image height - for images streams. 0 indicates any.
    * @param format [in]    Stream data format - pixel format for images streams, of data type for other streams. RS2_FORMAT_ANY indicates any.
    * @param framerate [in] Stream frames per second. 0 indicates any.
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_stream(rs2_config config,
            @Cast("rs2_stream") int stream,
            int index,
            int width,
            int height,
            @Cast("rs2_format") int format,
            int framerate,
            @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_stream(rs2_config config,
            @Cast("rs2_stream") int stream,
            int index,
            int width,
            int height,
            @Cast("rs2_format") int format,
            int framerate,
            @ByPtrPtr rs2_error error);

    /**
    * Enable all device streams explicitly.
    * The conditions and behavior of this method are similar to those of \c enable_stream().
    * This filter enables all raw streams of the selected device. The device is either selected explicitly by the application,
    * or by the pipeline requirements or default. The list of streams is device dependent.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_all_stream(rs2_config config, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_all_stream(rs2_config config, @ByPtrPtr rs2_error error);

    /**
    * Select a specific device explicitly by its serial number, to be used by the pipeline.
    * The conditions and behavior of this method are similar to those of \c enable_stream().
    * This method is required if the application needs to set device or sensor settings prior to pipeline streaming, to enforce
    * the pipeline to use the configured device.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param serial [in] device serial number, as returned by RS2_CAMERA_INFO_SERIAL_NUMBER
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_device(rs2_config config, @Cast("const char*") BytePointer serial, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_device(rs2_config config, @Cast("const char*") BytePointer serial, @ByPtrPtr rs2_error error);
    public static native void rs2_config_enable_device(rs2_config config, String serial, @ByPtrPtr rs2_error error);

    /**
    * Select a recorded device from a file, to be used by the pipeline through playback.
    * The device available streams are as recorded to the file, and \c resolve() considers only this device and configuration
    * as available.
    * This request cannot be used if enable_record_to_file() is called for the current config, and vise versa
    * By default, playback is repeated once the file ends. To control this, see 'rs2_config_enable_device_from_file_repeat_option'.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param file [in]      The playback file of the device
    * @param error [out]    if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_device_from_file(rs2_config config, @Cast("const char*") BytePointer file, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_device_from_file(rs2_config config, @Cast("const char*") BytePointer file, @ByPtrPtr rs2_error error);
    public static native void rs2_config_enable_device_from_file(rs2_config config, String file, @ByPtrPtr rs2_error error);

    /**
    * Select a recorded device from a file, to be used by the pipeline through playback.
    * The device available streams are as recorded to the file, and \c resolve() considers only this device and configuration
    * as available.
    * This request cannot be used if enable_record_to_file() is called for the current config, and vise versa
    *
    * @param config [in]           A pointer to an instance of a config
    * @param file [in]             The playback file of the device
    * @param repeat_playback [in]  if true, when file ends the playback starts again, in an infinite loop;
                                  if false, when file ends playback does not start again, and should by stopped manually by the user.
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_device_from_file_repeat_option(rs2_config config, @Cast("const char*") BytePointer file, int repeat_playback, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_device_from_file_repeat_option(rs2_config config, @Cast("const char*") BytePointer file, int repeat_playback, @ByPtrPtr rs2_error error);
    public static native void rs2_config_enable_device_from_file_repeat_option(rs2_config config, String file, int repeat_playback, @ByPtrPtr rs2_error error);

    /**
    * Requires that the resolved device would be recorded to file
    * This request cannot be used if enable_device_from_file() is called for the current config, and vise versa
    *
    * @param config [in]    A pointer to an instance of a config
    * @param file [in]      The desired file for the output record
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_enable_record_to_file(rs2_config config, @Cast("const char*") BytePointer file, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_enable_record_to_file(rs2_config config, @Cast("const char*") BytePointer file, @ByPtrPtr rs2_error error);
    public static native void rs2_config_enable_record_to_file(rs2_config config, String file, @ByPtrPtr rs2_error error);


    /**
    * Disable a device stream explicitly, to remove any requests on this stream type.
    * The stream can still be enabled due to pipeline computer vision module request. This call removes any filter on the
    * stream configuration.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param stream [in]    Stream type, for which the filters are cleared
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_disable_stream(rs2_config config, @Cast("rs2_stream") int stream, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_disable_stream(rs2_config config, @Cast("rs2_stream") int stream, @ByPtrPtr rs2_error error);

    /**
    * Disable a device stream explicitly, to remove any requests on this stream profile.
    * The stream can still be enabled due to pipeline computer vision module request. This call removes any filter on the
    * stream configuration.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param stream [in]    Stream type, for which the filters are cleared
    * @param index [in]     Stream index, for which the filters are cleared
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_disable_indexed_stream(rs2_config config, @Cast("rs2_stream") int stream, int index, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_disable_indexed_stream(rs2_config config, @Cast("rs2_stream") int stream, int index, @ByPtrPtr rs2_error error);

    /**
    * Disable all device stream explicitly, to remove any requests on the streams profiles.
    * The streams can still be enabled due to pipeline computer vision module request. This call removes any filter on the
    * streams configuration.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_config_disable_all_streams(rs2_config config, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_config_disable_all_streams(rs2_config config, @ByPtrPtr rs2_error error);

    /**
    * Resolve the configuration filters, to find a matching device and streams profiles.
    * The method resolves the user configuration filters for the device and streams, and combines them with the requirements of
    * the computer vision modules and processing blocks attached to the pipeline. If there are no conflicts of requests, it looks
    * for an available device, which can satisfy all requests, and selects the first matching streams configuration. In the absence
    * of any request, the rs2::config selects the first available device and the first color and depth streams configuration.
    * The pipeline profile selection during \c start() follows the same method. Thus, the selected profile is the same, if no
    * change occurs to the available devices occurs.
    * Resolving the pipeline configuration provides the application access to the pipeline selected device for advanced control.
    * The returned configuration is not applied to the device, so the application doesn't own the device sensors. However, the
    * application can call \c enable_device(), to enforce the device returned by this method is selected by pipeline \c start(),
    * and configure the device and sensors options or extensions before streaming starts.
    *
    * @param config [in]    A pointer to an instance of a config
    * @param pipe [in]  The pipeline for which the selected filters are applied
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return       A matching device and streams profile, which satisfies the filters and pipeline requests.
    */
    public static native rs2_pipeline_profile rs2_config_resolve(rs2_config config, rs2_pipeline pipe, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_config_resolve(rs2_config config, rs2_pipeline pipe, @ByPtrPtr rs2_error error);

    /**
    * Check if the config can resolve the configuration filters, to find a matching device and streams profiles.
    * The resolution conditions are as described in \c resolve().
    *
    * @param config [in]    A pointer to an instance of a config
    * @param pipe [in]  The pipeline for which the selected filters are applied
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return       True if a valid profile selection exists, false if no selection can be found under the config filters and the available devices.
    */
    public static native int rs2_config_can_resolve(rs2_config config, rs2_pipeline pipe, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_config_can_resolve(rs2_config config, rs2_pipeline pipe, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_pipeline.h

/* License: Apache 2.0. See LICENSE file in root directory.
Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs_pipeline.h
* \brief
* Exposes RealSense processing-block functionality for C compilers
*/


// #ifndef LIBREALSENSE_RS2_PIPELINE_H
// #define LIBREALSENSE_RS2_PIPELINE_H

// #ifdef __cplusplus
// #endif

// #include "rs_types.h"
// #include "rs_sensor.h"
// #include "rs_config.h"

    /**
    * Create a pipeline instance
    * The pipeline simplifies the user interaction with the device and computer vision processing modules.
    * The class abstracts the camera configuration and streaming, and the vision modules triggering and threading.
    * It lets the application focus on the computer vision output of the modules, or the device output data.
    * The pipeline can manage computer vision modules, which are implemented as a processing blocks.
    * The pipeline is the consumer of the processing block interface, while the application consumes the
    * computer vision interface.
    * @param ctx [in]    context
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native rs2_pipeline rs2_create_pipeline(rs2_context ctx, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline rs2_create_pipeline(rs2_context ctx, @ByPtrPtr rs2_error error);

    /**
    * Stop the pipeline streaming.
    * The pipeline stops delivering samples to the attached computer vision modules and processing blocks, stops the device streaming
    * and releases the device resources used by the pipeline. It is the application's responsibility to release any frame reference it owns.
    * The method takes effect only after \c start() was called, otherwise an exception is raised.
    * @param pipe [in]  pipeline
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    */
    public static native void rs2_pipeline_stop(rs2_pipeline pipe, @Cast("rs2_error**") PointerPointer error);
    public static native void rs2_pipeline_stop(rs2_pipeline pipe, @ByPtrPtr rs2_error error);

    /**
    * Wait until a new set of frames becomes available.
    * The frames set includes time-synchronized frames of each enabled stream in the pipeline.
    * The method blocks the calling thread, and fetches the latest unread frames set.
    * Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called
    * as fast as the device frame rate.
    * The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device
    * may lack memory resources to produce new frames, and the following call to this method shall fail to retrieve new frames, until resources
    * are retained.
    * @param pipe [in] the pipeline
    * @param timeout_ms [in]   Max time in milliseconds to wait until an exception will be thrown
    * @param error [out]         if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return Set of coherent frames
    */
    public static native rs2_frame rs2_pipeline_wait_for_frames(rs2_pipeline pipe, @Cast("unsigned int") int timeout_ms, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_frame rs2_pipeline_wait_for_frames(rs2_pipeline pipe, @Cast("unsigned int") int timeout_ms, @ByPtrPtr rs2_error error);

    /**
    * Check if a new set of frames is available and retrieve the latest undelivered set.
    * The frames set includes time-synchronized frames of each enabled stream in the pipeline.
    * The method returns without blocking the calling thread, with status of new frames available or not. If available, it fetches the
    * latest frames set.
    * Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called
    * as fast as the device frame rate.
    * The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device
    * may lack memory resources to produce new frames, and the following calls to this method shall return no new frames, until resources are
    * retained.
    * @param pipe [in] the pipeline
    * @param output_frame [out] frame handle to be released using rs2_release_frame
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return true if new frame was stored to output_frame
    */
    public static native int rs2_pipeline_poll_for_frames(rs2_pipeline pipe, @Cast("rs2_frame**") PointerPointer output_frame, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_pipeline_poll_for_frames(rs2_pipeline pipe, @ByPtrPtr rs2_frame output_frame, @ByPtrPtr rs2_error error);

    /**
    * Wait until a new set of frames becomes available.
    * The frames set includes time-synchronized frames of each enabled stream in the pipeline.
    * The method blocks the calling thread, and fetches the latest unread frames set.
    * Device frames, which were produced while the function wasn't called, are dropped. To avoid frame drops, this method should be called
    * as fast as the device frame rate.
    * The application can maintain the frames handles to defer processing. However, if the application maintains too long history, the device
    * may lack memory resources to produce new frames, and the following call to this method shall fail to retrieve new frames, until resources
    * are retained.
    * @param pipe [in]           the pipeline
    * @param timeout_ms [in]     max time in milliseconds to wait until a frame becomes available
    * @param output_frame [out]  frame handle to be released using rs2_release_frame
    * @param error [out]         if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return true if new frame was stored to output_frame
    */
    public static native int rs2_pipeline_try_wait_for_frames(rs2_pipeline pipe, @Cast("rs2_frame**") PointerPointer output_frame, @Cast("unsigned int") int timeout_ms, @Cast("rs2_error**") PointerPointer error);
    public static native int rs2_pipeline_try_wait_for_frames(rs2_pipeline pipe, @ByPtrPtr rs2_frame output_frame, @Cast("unsigned int") int timeout_ms, @ByPtrPtr rs2_error error);

    /**
    * Delete a pipeline instance.
    * Upon destruction, the pipeline will implicitly stop itself
    * @param pipe [in] to delete
    */
    public static native void rs2_delete_pipeline(rs2_pipeline pipe);

    /**
    * Start the pipeline streaming with its default configuration.
    * The pipeline streaming loop captures samples from the device, and delivers them to the attached computer vision modules
    * and processing blocks, according to each module requirements and threading model.
    * During the loop execution, the application can access the camera streams by calling \c wait_for_frames() or \c poll_for_frames().
    * The streaming loop runs until the pipeline is stopped.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    *
    * @param pipe [in]    a pointer to an instance of the pipeline
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start(rs2_pipeline pipe, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start(rs2_pipeline pipe, @ByPtrPtr rs2_error error);

    /**
    * Start the pipeline streaming according to the configuraion.
    * The pipeline streaming loop captures samples from the device, and delivers them to the attached computer vision modules
    * and processing blocks, according to each module requirements and threading model.
    * During the loop execution, the application can access the camera streams by calling \c wait_for_frames() or \c poll_for_frames().
    * The streaming loop runs until the pipeline is stopped.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    * The pipeline selects and activates the device upon start, according to configuration or a default configuration.
    * When the rs2::config is provided to the method, the pipeline tries to activate the config \c resolve() result. If the application
    * requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails.
    * Available configurations and devices may change between config \c resolve() call and pipeline start, in case devices are connected
    * or disconnected, or another application acquires ownership of a device.
    *
    * @param pipe [in]    a pointer to an instance of the pipeline
    * @param config [in]   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied.
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config(rs2_pipeline pipe, rs2_config config, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config(rs2_pipeline pipe, rs2_config config, @ByPtrPtr rs2_error error);

    /**
    * Start the pipeline streaming with its default configuration.
    * The pipeline captures samples from the device, and delivers them to the through the provided frame callback.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    * When starting the pipeline with a callback both \c wait_for_frames() or \c poll_for_frames() will throw exception.
    *
    * @param pipe [in]     A pointer to an instance of the pipeline
    * @param on_frame [in] function pointer to register as per-frame callback
    * @param user [in] auxiliary  data the user wishes to receive together with every frame callback
    * @param error [out]   If non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start_with_callback(rs2_pipeline pipe, rs2_frame_callback_ptr on_frame, Pointer user, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start_with_callback(rs2_pipeline pipe, rs2_frame_callback_ptr on_frame, Pointer user, @ByPtrPtr rs2_error error);

    /**
    * Start the pipeline streaming with its default configuration.
    * The pipeline captures samples from the device, and delivers them to the through the provided frame callback.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    * When starting the pipeline with a callback both \c wait_for_frames() or \c poll_for_frames() will throw exception.
    *
    * @param pipe [in]     A pointer to an instance of the pipeline
    * @param callback [in] callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock
    * @param error [out]   If non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start_with_callback_cpp(rs2_pipeline pipe, rs2_frame_callback callback, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start_with_callback_cpp(rs2_pipeline pipe, rs2_frame_callback callback, @ByPtrPtr rs2_error error);

    /**
    * Start the pipeline streaming according to the configuraion.
    * The pipeline captures samples from the device, and delivers them to the through the provided frame callback.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    * When starting the pipeline with a callback both \c wait_for_frames() or \c poll_for_frames() will throw exception.
    * The pipeline selects and activates the device upon start, according to configuration or a default configuration.
    * When the rs2::config is provided to the method, the pipeline tries to activate the config \c resolve() result. If the application
    * requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails.
    * Available configurations and devices may change between config \c resolve() call and pipeline start, in case devices are connected
    * or disconnected, or another application acquires ownership of a device.
    *
    * @param pipe [in]     A pointer to an instance of the pipeline
    * @param config [in]   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied.
    * @param on_frame [in] function pointer to register as per-frame callback
    * @param user [in] auxiliary  data the user wishes to receive together with every frame callback
    * @param error [out]   If non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config_and_callback(rs2_pipeline pipe, rs2_config config, rs2_frame_callback_ptr on_frame, Pointer user, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config_and_callback(rs2_pipeline pipe, rs2_config config, rs2_frame_callback_ptr on_frame, Pointer user, @ByPtrPtr rs2_error error);

    /**
    * Start the pipeline streaming according to the configuraion.
    * The pipeline captures samples from the device, and delivers them to the through the provided frame callback.
    * Starting the pipeline is possible only when it is not started. If the pipeline was started, an exception is raised.
    * When starting the pipeline with a callback both \c wait_for_frames() or \c poll_for_frames() will throw exception.
    * The pipeline selects and activates the device upon start, according to configuration or a default configuration.
    * When the rs2::config is provided to the method, the pipeline tries to activate the config \c resolve() result. If the application
    * requests are conflicting with pipeline computer vision modules or no matching device is available on the platform, the method fails.
    * Available configurations and devices may change between config \c resolve() call and pipeline start, in case devices are connected
    * or disconnected, or another application acquires ownership of a device.
    *
    * @param pipe [in]     A pointer to an instance of the pipeline
    * @param config [in]   A rs2::config with requested filters on the pipeline configuration. By default no filters are applied.
    * @param callback [in] callback object created from c++ application. ownership over the callback object is moved into the relevant streaming lock
    * @param error [out]   If non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return             The actual pipeline device and streams profile, which was successfully configured to the streaming device.
    */
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config_and_callback_cpp(rs2_pipeline pipe, rs2_config config, rs2_frame_callback callback, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_start_with_config_and_callback_cpp(rs2_pipeline pipe, rs2_config config, rs2_frame_callback callback, @ByPtrPtr rs2_error error);

    /**
    * Return the active device and streams profiles, used by the pipeline.
    * The pipeline streams profiles are selected during \c start(). The method returns a valid result only when the pipeline is active -
    * between calls to \c start() and \c stop().
    * After \c stop() is called, the pipeline doesn't own the device, thus, the pipeline selected device may change in subsequent activations.
    *
    * @param pipe [in]    a pointer to an instance of the pipeline
    * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return  The actual pipeline device and streams profile, which was successfully configured to the streaming device on start.
    */
    public static native rs2_pipeline_profile rs2_pipeline_get_active_profile(rs2_pipeline pipe, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_pipeline_profile rs2_pipeline_get_active_profile(rs2_pipeline pipe, @ByPtrPtr rs2_error error);

    /**
    * Retrieve the device used by the pipeline.
    * The device class provides the application access to control camera additional settings -
    * get device information, sensor options information, options value query and set, sensor specific extensions.
    * Since the pipeline controls the device streams configuration, activation state and frames reading, calling
    * the device API functions, which execute those operations, results in unexpected behavior.
    * The pipeline streaming device is selected during pipeline \c start(). Devices of profiles, which are not returned by
    * pipeline \c start() or \c get_active_profile(), are not guaranteed to be used by the pipeline.
    *
    * @param profile [in]    A pointer to an instance of a pipeline profile
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return rs2_device* The pipeline selected device
    */
    public static native rs2_device rs2_pipeline_profile_get_device(rs2_pipeline_profile profile, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_device rs2_pipeline_profile_get_device(rs2_pipeline_profile profile, @ByPtrPtr rs2_error error);

    /**
    * Return the selected streams profiles, which are enabled in this profile.
    *
    * @param profile [in]    A pointer to an instance of a pipeline profile
    * @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
    * @return   list of stream profiles
    */
    public static native rs2_stream_profile_list rs2_pipeline_profile_get_streams(rs2_pipeline_profile profile, @Cast("rs2_error**") PointerPointer error);
    public static native rs2_stream_profile_list rs2_pipeline_profile_get_streams(rs2_pipeline_profile profile, @ByPtrPtr rs2_error error);

    /**
    * Deletes an instance of a pipeline profile
    *
    * @param profile [in]    A pointer to an instance of a pipeline profile
    */
    public static native void rs2_delete_pipeline_profile(rs2_pipeline_profile profile);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/h/rs_advanced_mode_command.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/**
 * \file   rs_advanced_mode_command.h
 * \brief  Advanced Mode Commands header file
 */

// #ifndef RS2_ADVANCED_MODE_COMMAND_H
// #define RS2_ADVANCED_MODE_COMMAND_H

// #include <stdint.h>
// Targeting ../STDepthControlGroup.java


// Targeting ../STRsm.java


// Targeting ../STRauSupportVectorControl.java


// Targeting ../STColorControl.java


// Targeting ../STRauColorThresholdsControl.java


// Targeting ../STSloColorThresholdsControl.java


// Targeting ../STSloPenaltyControl.java


// Targeting ../STHdad.java


// Targeting ../STColorCorrection.java


// Targeting ../STAEControl.java


// Targeting ../STDepthTableControl.java


// Targeting ../STCensusRadius.java


// Targeting ../STAFactor.java



// #ifdef __cplusplus
// #endif


// #ifdef __cplusplus
// #endif

// #endif /*RS2_ADVANCED_MODE_COMMAND_H*/


// Parsed from librealsense2/rs.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

/** \file rs.h
* \brief
* Exposes librealsense functionality for C compilers
*/

// #ifndef LIBREALSENSE_RS2_H
// #define LIBREALSENSE_RS2_H

// #ifdef __cplusplus
// #endif

// #include "rsutil.h"
// #include "h/rs_types.h"
// #include "h/rs_context.h"
// #include "h/rs_device.h"
// #include "h/rs_frame.h"
// #include "h/rs_option.h"
// #include "h/rs_processing.h"
// #include "h/rs_record_playback.h"
// #include "h/rs_sensor.h"

public static final int RS2_API_MAJOR_VERSION =    2;
public static final int RS2_API_MINOR_VERSION =    50;
public static final int RS2_API_PATCH_VERSION =    0;
public static final int RS2_API_BUILD_VERSION =    0;

// #ifndef STRINGIFY
// #define STRINGIFY(arg) #arg
// #endif
// #ifndef VAR_ARG_STRING
// #define VAR_ARG_STRING(arg) STRINGIFY(arg)
// #endif

/* Versioning rules            : For each release at least one of [MJR/MNR/PTCH] triple is promoted                                             */
/*                             : Versions that differ by RS2_API_PATCH_VERSION only are interface-compatible, i.e. no user-code changes required */
/*                             : Versions that differ by MAJOR/MINOR VERSION component can introduce API changes                                */
/* Version in encoded integer format (1,9,x) -> 01090x. note that each component is limited into [0-99] range by design                         */
public static final int RS2_API_VERSION =  (((RS2_API_MAJOR_VERSION) * 10000) + ((RS2_API_MINOR_VERSION) * 100) + (RS2_API_PATCH_VERSION));
/* Return version in "X.Y.Z" format */
public static native @MemberGetter String RS2_API_VERSION_STR();
public static final String RS2_API_VERSION_STR = RS2_API_VERSION_STR();
public static native @MemberGetter String RS2_API_FULL_VERSION_STR();
public static final String RS2_API_FULL_VERSION_STR = RS2_API_FULL_VERSION_STR();

/**
* get the size of rs2_raw_data_buffer
* @param buffer [in]  pointer to rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return size of rs2_raw_data_buffer
*/
public static native int rs2_get_raw_data_size(@Const rs2_raw_data_buffer buffer, @Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_raw_data_size(@Const rs2_raw_data_buffer buffer, @ByPtrPtr rs2_error error);

/**
* Delete rs2_raw_data_buffer
* @param buffer [in]        rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data
*/
public static native void rs2_delete_raw_data(@Const rs2_raw_data_buffer buffer);

/**
* Retrieve char array from rs2_raw_data_buffer
* @param buffer [in]   rs2_raw_data_buffer returned by rs2_send_and_receive_raw_data
* @param error [out]   if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return raw data
*/
public static native @Cast("const unsigned char*") BytePointer rs2_get_raw_data(@Const rs2_raw_data_buffer buffer, @Cast("rs2_error**") PointerPointer error);
public static native @Cast("const unsigned char*") BytePointer rs2_get_raw_data(@Const rs2_raw_data_buffer buffer, @ByPtrPtr rs2_error error);

/**
 * Retrieve the API version from the source code. Evaluate that the value is conformant to the established policies
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 * @return            the version API encoded into integer value "1.9.3" -> 10903
 */
public static native int rs2_get_api_version(@Cast("rs2_error**") PointerPointer error);
public static native int rs2_get_api_version(@ByPtrPtr rs2_error error);

public static native void rs2_log_to_console(@Cast("rs2_log_severity") int min_severity, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_log_to_console(@Cast("rs2_log_severity") int min_severity, @ByPtrPtr rs2_error error);

public static native void rs2_log_to_file(@Cast("rs2_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_log_to_file(@Cast("rs2_log_severity") int min_severity, @Cast("const char*") BytePointer file_path, @ByPtrPtr rs2_error error);
public static native void rs2_log_to_file(@Cast("rs2_log_severity") int min_severity, String file_path, @ByPtrPtr rs2_error error);

public static native void rs2_log_to_callback_cpp( @Cast("rs2_log_severity") int min_severity, rs2_log_callback callback, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_log_to_callback_cpp( @Cast("rs2_log_severity") int min_severity, rs2_log_callback callback, @ByPtrPtr rs2_error error );

public static native void rs2_log_to_callback( @Cast("rs2_log_severity") int min_severity, rs2_log_callback_ptr callback, Pointer arg, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_log_to_callback( @Cast("rs2_log_severity") int min_severity, rs2_log_callback_ptr callback, Pointer arg, @ByPtrPtr rs2_error error );

public static native void rs2_reset_logger( @Cast("rs2_error**") PointerPointer error);
public static native void rs2_reset_logger( @ByPtrPtr rs2_error error);

/**
* Enable rolling log file when used with rs2_log_to_file:
* Upon reaching (max_size/2) bytes, the log will be renamed with an ".old" suffix and a new log created. Any
* previous .old file will be erased.
* Must have permissions to remove/rename files in log file directory.
* @param max_size [in]   max file size in megabytes
* @param error [out]     if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native void rs2_enable_rolling_log_file( @Cast("unsigned") int max_size, @Cast("rs2_error**") PointerPointer error );
public static native void rs2_enable_rolling_log_file( @Cast("unsigned") int max_size, @ByPtrPtr rs2_error error );


public static native @Cast("unsigned") int rs2_get_log_message_line_number( @Const rs2_log_message msg, @Cast("rs2_error**") PointerPointer error );
public static native @Cast("unsigned") int rs2_get_log_message_line_number( @Const rs2_log_message msg, @ByPtrPtr rs2_error error );
public static native @Cast("const char*") BytePointer rs2_get_log_message_filename( @Const rs2_log_message msg, @Cast("rs2_error**") PointerPointer error );
public static native @Cast("const char*") BytePointer rs2_get_log_message_filename( @Const rs2_log_message msg, @ByPtrPtr rs2_error error );
public static native @Cast("const char*") BytePointer rs2_get_raw_log_message( @Const rs2_log_message msg, @Cast("rs2_error**") PointerPointer error );
public static native @Cast("const char*") BytePointer rs2_get_raw_log_message( @Const rs2_log_message msg, @ByPtrPtr rs2_error error );
public static native @Cast("const char*") BytePointer rs2_get_full_log_message( @Const rs2_log_message msg, @Cast("rs2_error**") PointerPointer error );
public static native @Cast("const char*") BytePointer rs2_get_full_log_message( @Const rs2_log_message msg, @ByPtrPtr rs2_error error );

/**
 * Add custom message into librealsense log
 * @param severity [in]  The log level for the message to be written under
 * @param message [in]   Message to be logged
 * @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
 */
public static native void rs2_log(@Cast("rs2_log_severity") int severity, @Cast("const char*") BytePointer message, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_log(@Cast("rs2_log_severity") int severity, @Cast("const char*") BytePointer message, @ByPtrPtr rs2_error error);
public static native void rs2_log(@Cast("rs2_log_severity") int severity, String message, @ByPtrPtr rs2_error error);

/**
* Given the 2D depth coordinate (x,y) provide the corresponding depth in metric units
* @param frame_ref [in]  2D depth pixel coordinates (Left-Upper corner origin)
* @param x [in] ,y  2D depth pixel coordinates (Left-Upper corner origin)
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
*/
public static native float rs2_depth_frame_get_distance(@Const rs2_frame frame_ref, int x, int y, @Cast("rs2_error**") PointerPointer error);
public static native float rs2_depth_frame_get_distance(@Const rs2_frame frame_ref, int x, int y, @ByPtrPtr rs2_error error);

/**
* return the time at specific time point
* @param error [out]  if non-null, receives any error that occurs during this call, otherwise, errors are ignored
* @return            the time at specific time point, in live and record mode it will return the system time and in playback mode it will return the recorded time
*/
public static native @Cast("rs2_time_t") double rs2_get_time( @Cast("rs2_error**") PointerPointer error);
public static native @Cast("rs2_time_t") double rs2_get_time( @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/rs_advanced_mode.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2017 Intel Corporation. All Rights Reserved. */

// #ifndef RS400_ADVANCED_MODE_H
// #define RS400_ADVANCED_MODE_H

// #define RS400_ADVANCED_MODE_HPP
// #include "h/rs_advanced_mode_command.h"
// #undef RS400_ADVANCED_MODE_HPP

// #include "h/rs_types.h"

// #ifdef __cplusplus
// #endif

/* Enable/Disable Advanced-Mode */
public static native void rs2_toggle_advanced_mode(rs2_device dev, int enable, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_toggle_advanced_mode(rs2_device dev, int enable, @ByPtrPtr rs2_error error);

/* Check if Advanced-Mode is enabled */
public static native void rs2_is_enabled(rs2_device dev, IntPointer enabled, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_is_enabled(rs2_device dev, IntPointer enabled, @ByPtrPtr rs2_error error);
public static native void rs2_is_enabled(rs2_device dev, IntBuffer enabled, @ByPtrPtr rs2_error error);
public static native void rs2_is_enabled(rs2_device dev, int[] enabled, @ByPtrPtr rs2_error error);

/* Sets new values for Depth Control Group, returns 0 if success */
public static native void rs2_set_depth_control(rs2_device dev, @Const STDepthControlGroup group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_depth_control(rs2_device dev, @Const STDepthControlGroup group, @ByPtrPtr rs2_error error);

/* Gets new values for Depth Control Group, returns 0 if success */
public static native void rs2_get_depth_control(rs2_device dev, STDepthControlGroup group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_depth_control(rs2_device dev, STDepthControlGroup group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for RSM Group, returns 0 if success */
public static native void rs2_set_rsm(rs2_device dev, @Const STRsm group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_rsm(rs2_device dev, @Const STRsm group, @ByPtrPtr rs2_error error);

/* Gets new values for RSM Group, returns 0 if success */
public static native void rs2_get_rsm(rs2_device dev, STRsm group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_rsm(rs2_device dev, STRsm group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STRauSupportVectorControl, returns 0 if success */
public static native void rs2_set_rau_support_vector_control(rs2_device dev, @Const STRauSupportVectorControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_rau_support_vector_control(rs2_device dev, @Const STRauSupportVectorControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STRauSupportVectorControl, returns 0 if success */
public static native void rs2_get_rau_support_vector_control(rs2_device dev, STRauSupportVectorControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_rau_support_vector_control(rs2_device dev, STRauSupportVectorControl group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STColorControl, returns 0 if success */
public static native void rs2_set_color_control(rs2_device dev, @Const STColorControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_color_control(rs2_device dev, @Const STColorControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STColorControl, returns 0 if success */
public static native void rs2_get_color_control(rs2_device dev, STColorControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_color_control(rs2_device dev, STColorControl group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STRauColorThresholdsControl, returns 0 if success */
public static native void rs2_set_rau_thresholds_control(rs2_device dev, @Const STRauColorThresholdsControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_rau_thresholds_control(rs2_device dev, @Const STRauColorThresholdsControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STRauColorThresholdsControl, returns 0 if success */
public static native void rs2_get_rau_thresholds_control(rs2_device dev, STRauColorThresholdsControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_rau_thresholds_control(rs2_device dev, STRauColorThresholdsControl group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STSloColorThresholdsControl, returns 0 if success */
public static native void rs2_set_slo_color_thresholds_control(rs2_device dev, @Const STSloColorThresholdsControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_slo_color_thresholds_control(rs2_device dev, @Const STSloColorThresholdsControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STRauColorThresholdsControl, returns 0 if success */
public static native void rs2_get_slo_color_thresholds_control(rs2_device dev, STSloColorThresholdsControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_slo_color_thresholds_control(rs2_device dev, STSloColorThresholdsControl group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STSloPenaltyControl, returns 0 if success */
public static native void rs2_set_slo_penalty_control(rs2_device dev, @Const STSloPenaltyControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_slo_penalty_control(rs2_device dev, @Const STSloPenaltyControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STSloPenaltyControl, returns 0 if success */
public static native void rs2_get_slo_penalty_control(rs2_device dev, STSloPenaltyControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_slo_penalty_control(rs2_device dev, STSloPenaltyControl group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STHdad, returns 0 if success */
public static native void rs2_set_hdad(rs2_device dev, @Const STHdad group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_hdad(rs2_device dev, @Const STHdad group, @ByPtrPtr rs2_error error);

/* Gets new values for STHdad, returns 0 if success */
public static native void rs2_get_hdad(rs2_device dev, STHdad group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_hdad(rs2_device dev, STHdad group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STColorCorrection, returns 0 if success */
public static native void rs2_set_color_correction(rs2_device dev, @Const STColorCorrection group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_color_correction(rs2_device dev, @Const STColorCorrection group, @ByPtrPtr rs2_error error);

/* Gets new values for STColorCorrection, returns 0 if success */
public static native void rs2_get_color_correction(rs2_device dev, STColorCorrection group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_color_correction(rs2_device dev, STColorCorrection group, int mode, @ByPtrPtr rs2_error error);

/* Sets new values for STDepthTableControl, returns 0 if success */
public static native void rs2_set_depth_table(rs2_device dev, @Const STDepthTableControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_depth_table(rs2_device dev, @Const STDepthTableControl group, @ByPtrPtr rs2_error error);

/* Gets new values for STDepthTableControl, returns 0 if success */
public static native void rs2_get_depth_table(rs2_device dev, STDepthTableControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_depth_table(rs2_device dev, STDepthTableControl group, int mode, @ByPtrPtr rs2_error error);

public static native void rs2_set_ae_control(rs2_device dev, @Const STAEControl group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_ae_control(rs2_device dev, @Const STAEControl group, @ByPtrPtr rs2_error error);

public static native void rs2_get_ae_control(rs2_device dev, STAEControl group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_ae_control(rs2_device dev, STAEControl group, int mode, @ByPtrPtr rs2_error error);

public static native void rs2_set_census(rs2_device dev, @Const STCensusRadius group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_census(rs2_device dev, @Const STCensusRadius group, @ByPtrPtr rs2_error error);

public static native void rs2_get_census(rs2_device dev, STCensusRadius group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_census(rs2_device dev, STCensusRadius group, int mode, @ByPtrPtr rs2_error error);

public static native void rs2_set_amp_factor(rs2_device dev, @Const STAFactor group, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_set_amp_factor(rs2_device dev, @Const STAFactor group, @ByPtrPtr rs2_error error);

/* Gets new values for STAFactor, returns 0 if success */
public static native void rs2_get_amp_factor(rs2_device dev, STAFactor group, int mode, @Cast("rs2_error**") PointerPointer error);
public static native void rs2_get_amp_factor(rs2_device dev, STAFactor group, int mode, @ByPtrPtr rs2_error error);

// #ifdef __cplusplus
// #endif
// #endif


// Parsed from librealsense2/rsutil.h

/* License: Apache 2.0. See LICENSE file in root directory.
   Copyright(c) 2015 Intel Corporation. All Rights Reserved. */

// #ifndef LIBREALSENSE_RSUTIL2_H
// #define LIBREALSENSE_RSUTIL2_H

// #include <stdlib.h>
// #include <stdbool.h>
// #include <stdint.h>
// #include <math.h>
// #include <float.h>
// #include "h/rs_types.h"
// #include "h/rs_sensor.h"

// #ifdef __cplusplus
// #endif

/* Given a point in 3D space, compute the corresponding pixel coordinates in an image with no distortion or forward distortion coefficients produced by the same camera */
public static native void rs2_project_point_to_pixel(FloatPointer pixel, @Const rs2_intrinsics intrin, @Const FloatPointer point);
public static native void rs2_project_point_to_pixel(FloatBuffer pixel, @Const rs2_intrinsics intrin, @Const FloatBuffer point);
public static native void rs2_project_point_to_pixel(float[] pixel, @Const rs2_intrinsics intrin, @Const float[] point);

/* Given pixel coordinates and depth in an image with no distortion or inverse distortion coefficients, compute the corresponding point in 3D space relative to the same camera */
public static native void rs2_deproject_pixel_to_point(FloatPointer point, @Const rs2_intrinsics intrin, @Const FloatPointer pixel, float depth);
public static native void rs2_deproject_pixel_to_point(FloatBuffer point, @Const rs2_intrinsics intrin, @Const FloatBuffer pixel, float depth);
public static native void rs2_deproject_pixel_to_point(float[] point, @Const rs2_intrinsics intrin, @Const float[] pixel, float depth);

/* Transform 3D coordinates relative to one sensor to 3D coordinates relative to another viewpoint */
public static native void rs2_transform_point_to_point(FloatPointer to_point, @Const rs2_extrinsics extrin, @Const FloatPointer from_point);
public static native void rs2_transform_point_to_point(FloatBuffer to_point, @Const rs2_extrinsics extrin, @Const FloatBuffer from_point);
public static native void rs2_transform_point_to_point(float[] to_point, @Const rs2_extrinsics extrin, @Const float[] from_point);

/* Calculate horizontal and vertical feild of view, based on video intrinsics */
public static native void rs2_fov(@Const rs2_intrinsics intrin, FloatPointer to_fov);
public static native void rs2_fov(@Const rs2_intrinsics intrin, FloatBuffer to_fov);
public static native void rs2_fov(@Const rs2_intrinsics intrin, float[] to_fov);

/* Find projected pixel with unknown depth search along line. */
public static native void rs2_project_color_pixel_to_depth_pixel(FloatPointer to_pixel,
    @Cast("const uint16_t*") ShortPointer data, float depth_scale,
    float depth_min, float depth_max,
    @Const rs2_intrinsics depth_intrin,
    @Const rs2_intrinsics color_intrin,
    @Const rs2_extrinsics color_to_depth,
    @Const rs2_extrinsics depth_to_color,
    @Const FloatPointer from_pixel);
public static native void rs2_project_color_pixel_to_depth_pixel(FloatBuffer to_pixel,
    @Cast("const uint16_t*") ShortBuffer data, float depth_scale,
    float depth_min, float depth_max,
    @Const rs2_intrinsics depth_intrin,
    @Const rs2_intrinsics color_intrin,
    @Const rs2_extrinsics color_to_depth,
    @Const rs2_extrinsics depth_to_color,
    @Const FloatBuffer from_pixel);
public static native void rs2_project_color_pixel_to_depth_pixel(float[] to_pixel,
    @Cast("const uint16_t*") short[] data, float depth_scale,
    float depth_min, float depth_max,
    @Const rs2_intrinsics depth_intrin,
    @Const rs2_intrinsics color_intrin,
    @Const rs2_extrinsics color_to_depth,
    @Const rs2_extrinsics depth_to_color,
    @Const float[] from_pixel);


// #ifdef __cplusplus
// #endif

// #endif // LIBREALSENSE_RSUTIL2_H


}
