// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** The class manages contact between two shapes. A contact exists for each overlapping
 *  AABB in the broad-phase (except if filtered). Therefore a contact object may exist
 *  that has no contact points. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2Contact extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2Contact(Pointer p) { super(p); }


	/** Get the contact manifold. Do not modify the manifold unless you understand the
	 *  internals of Box2D. */
	public native b2Manifold GetManifold();

	/** Get the world manifold. */
	public native void GetWorldManifold(b2WorldManifold worldManifold);

	/** Is this contact touching? */
	public native @Cast("bool") boolean IsTouching();

	/** Enable/disable this contact. This can be used inside the pre-solve
	 *  contact listener. The contact is only disabled for the current
	 *  time step (or sub-step in continuous collisions). */
	public native void SetEnabled(@Cast("bool") boolean flag);

	/** Has this contact been disabled? */
	public native @Cast("bool") boolean IsEnabled();

	/** Get the next contact in the world's contact list. */
	public native b2Contact GetNext();

	/** Get fixture A in this contact. */
	public native b2Fixture GetFixtureA();

	/** Get the child primitive index for fixture A. */
	public native @Cast("int32") int GetChildIndexA();

	/** Get fixture B in this contact. */
	public native b2Fixture GetFixtureB();

	/** Get the child primitive index for fixture B. */
	public native @Cast("int32") int GetChildIndexB();

	/** Override the default friction mixture. You can call this in b2ContactListener::PreSolve.
	 *  This value persists until set or reset. */
	public native void SetFriction(@Cast("float32") float friction);

	/** Get the friction. */
	public native @Cast("float32") float GetFriction();

	/** Reset the friction mixture to the default value. */
	public native void ResetFriction();

	/** Override the default restitution mixture. You can call this in b2ContactListener::PreSolve.
	 *  The value persists until you set or reset. */
	public native void SetRestitution(@Cast("float32") float restitution);

	/** Get the restitution. */
	public native @Cast("float32") float GetRestitution();

	/** Reset the restitution to the default value. */
	public native void ResetRestitution();

	/** Set the desired tangent speed for a conveyor belt behavior. In meters per second. */
	public native void SetTangentSpeed(@Cast("float32") float speed);

	/** Get the desired tangent speed. In meters per second. */
	public native @Cast("float32") float GetTangentSpeed();

	/** Evaluate this contact with your own manifold and transforms. */
	public native void Evaluate(b2Manifold manifold, @Const @ByRef b2Transform xfA, @Const @ByRef b2Transform xfB);
}
