// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A dynamic AABB tree broad-phase, inspired by Nathanael Presson's btDbvt.
 *  A dynamic tree arranges data in a binary tree to accelerate
 *  queries such as volume queries and ray casts. Leafs are proxies
 *  with an AABB. In the tree we expand the proxy AABB by b2_fatAABBFactor
 *  so that the proxy AABB is bigger than the client object. This allows the client
 *  object to move by small amounts without triggering a tree update.
 * 
 *  Nodes are pooled and relocatable, so we use node indices rather than pointers. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2DynamicTree extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2DynamicTree(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2DynamicTree(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2DynamicTree position(long position) {
        return (b2DynamicTree)super.position(position);
    }

	/** Constructing the tree initializes the node pool. */
	public b2DynamicTree() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** Destroy the tree, freeing the node pool. */

	/** Create a proxy. Provide a tight fitting AABB and a userData pointer. */
	public native @Cast("int32") int CreateProxy(@Const @ByRef b2AABB aabb, Pointer userData);

	/** Destroy a proxy. This asserts if the id is invalid. */
	public native void DestroyProxy(@Cast("int32") int proxyId);

	/** Move a proxy with a swepted AABB. If the proxy has moved outside of its fattened AABB,
	 *  then the proxy is removed from the tree and re-inserted. Otherwise
	 *  the function returns immediately.
	 *  @return true if the proxy was re-inserted. */
	public native @Cast("bool") boolean MoveProxy(@Cast("int32") int proxyId, @Const @ByRef b2AABB aabb1, @Const @ByRef b2Vec2 displacement);

	/** Get proxy user data.
	 *  @return the proxy user data or 0 if the id is invalid. */
	public native Pointer GetUserData(@Cast("int32") int proxyId);

	/** Get the fat AABB for a proxy. */
	public native @Const @ByRef b2AABB GetFatAABB(@Cast("int32") int proxyId);

	/** Query an AABB for overlapping proxies. The callback class
	 *  is called for each proxy that overlaps the supplied AABB. */
	public native void Query(b2DynamicTreeQueryCallback callback, @Const @ByRef b2AABB aabb);

	/** Ray-cast against the proxies in the tree. This relies on the callback
	 *  to perform a exact ray-cast in the case were the proxy contains a shape.
	 *  The callback also performs the any collision filtering. This has performance
	 *  roughly equal to k * log(n), where k is the number of collisions and n is the
	 *  number of proxies in the tree.
	 *  @param input the ray-cast input data. The ray extends from p1 to p1 + maxFraction * (p2 - p1).
	 *  @param callback a callback class that is called for each proxy that is hit by the ray. */
	public native void RayCast(b2DynamicTreeRayCastCallback callback, @Const @ByRef b2RayCastInput input);

	/** Validate this tree. For testing. */
	public native void Validate();

	/** Compute the height of the binary tree in O(N) time. Should not be
	 *  called often. */
	public native @Cast("int32") int GetHeight();

	/** Get the maximum balance of an node in the tree. The balance is the difference
	 *  in height of the two children of a node. */
	public native @Cast("int32") int GetMaxBalance();

	/** Get the ratio of the sum of the node areas to the root area. */
	public native @Cast("float32") float GetAreaRatio();

	/** Build an optimal tree. Very expensive. For testing. */
	public native void RebuildBottomUp();

	/** Shift the world origin. Useful for large worlds.
	 *  The shift formula is: position -= newOrigin
	 *  @param newOrigin the new origin with respect to the old origin */
	public native void ShiftOrigin(@Const @ByRef b2Vec2 newOrigin);
}
