// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A line segment (edge) shape. These can be connected in chains or loops
 *  to other edge shapes. The connectivity information is used to ensure
 *  correct contact normals. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2EdgeShape extends b2Shape {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2EdgeShape(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2EdgeShape(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2EdgeShape position(long position) {
        return (b2EdgeShape)super.position(position);
    }

	public b2EdgeShape() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** Set this as an isolated edge. */
	public native void Set(@Const @ByRef b2Vec2 v1, @Const @ByRef b2Vec2 v2);

	/** Implement b2Shape. */
	public native b2Shape Clone(b2BlockAllocator allocator);

	/** @see b2Shape::GetChildCount */
	public native @Cast("int32") int GetChildCount();

	/** @see b2Shape::TestPoint */
	public native @Cast("bool") boolean TestPoint(@Const @ByRef b2Transform transform, @Const @ByRef b2Vec2 p);

	// @see b2Shape::ComputeDistance
	public native void ComputeDistance(@Const @ByRef b2Transform xf, @Const @ByRef b2Vec2 p, @Cast("float32*") FloatPointer distance, b2Vec2 normal, @Cast("int32") int childIndex);
	public native void ComputeDistance(@Const @ByRef b2Transform xf, @Const @ByRef b2Vec2 p, @Cast("float32*") FloatBuffer distance, b2Vec2 normal, @Cast("int32") int childIndex);
	public native void ComputeDistance(@Const @ByRef b2Transform xf, @Const @ByRef b2Vec2 p, @Cast("float32*") float[] distance, b2Vec2 normal, @Cast("int32") int childIndex);

	/** Implement b2Shape. */
	public native @Cast("bool") boolean RayCast(b2RayCastOutput output, @Const @ByRef b2RayCastInput input,
					@Const @ByRef b2Transform transform, @Cast("int32") int childIndex);

	/** @see b2Shape::ComputeAABB */
	public native void ComputeAABB(b2AABB aabb, @Const @ByRef b2Transform transform, @Cast("int32") int childIndex);

	/** @see b2Shape::ComputeMass */
	public native void ComputeMass(b2MassData massData, @Cast("float32") float density);
	/** Set this as an isolated edge, with direct floats. */
	public native void Set(@Cast("float32") float vx1, @Cast("float32") float vy1, @Cast("float32") float vx2, @Cast("float32") float vy2);
// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

	/** These are the edge vertices */
	public native @ByRef b2Vec2 m_vertex1(); public native b2EdgeShape m_vertex1(b2Vec2 setter);
	public native @ByRef b2Vec2 m_vertex2(); public native b2EdgeShape m_vertex2(b2Vec2 setter);

	/** Optional adjacent vertices. These are used for smooth collision. */
	public native @ByRef b2Vec2 m_vertex0(); public native b2EdgeShape m_vertex0(b2Vec2 setter);
	public native @ByRef b2Vec2 m_vertex3(); public native b2EdgeShape m_vertex3(b2Vec2 setter);
	public native @Cast("bool") boolean m_hasVertex0(); public native b2EdgeShape m_hasVertex0(boolean setter);
	public native @Cast("bool") boolean m_hasVertex3(); public native b2EdgeShape m_hasVertex3(boolean setter);
}
