// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** Small color object for each particle */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2ParticleColor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2ParticleColor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2ParticleColor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2ParticleColor position(long position) {
        return (b2ParticleColor)super.position(position);
    }

	public b2ParticleColor() { super((Pointer)null); allocate(); }
	private native void allocate();
	/** Constructor with four elements: r (red), g (green), b (blue), and a
	 *  (opacity).
	 *  Each element can be specified 0 to 255. */
	public b2ParticleColor(@Cast("uint8") short r, @Cast("uint8") short g, @Cast("uint8") short b, @Cast("uint8") short a) { super((Pointer)null); allocate(r, g, b, a); }
	private native void allocate(@Cast("uint8") short r, @Cast("uint8") short g, @Cast("uint8") short b, @Cast("uint8") short a);

	/** Constructor that initializes the above four elements with the value of
	 *  the b2Color object. */
	
	///
	public b2ParticleColor(@Const @ByRef b2Color color) { super((Pointer)null); allocate(color); }
	private native void allocate(@Const @ByRef b2Color color);

	/** True when all four color elements equal 0. When true, a particle color
	 *  buffer isn't allocated by CreateParticle().
	 *  */
	
	///
	public native @Cast("bool") boolean IsZero();

	/** Used internally to convert the value of b2Color.
	 *  */
	
	///
	public native @ByVal b2Color GetColor();

	/** Sets color for current object using the four elements described above.
	 *  */
	
	///
	public native void Set(@Cast("uint8") short r_, @Cast("uint8") short g_, @Cast("uint8") short b_, @Cast("uint8") short a_);

	/** Initializes the object with the value of the b2Color.
	 *  */
	public native void Set(@Const @ByRef b2Color color);

	/** Assign a b2ParticleColor to this instance. */
	public native @ByRef @Name("operator =") b2ParticleColor put(@Const @ByRef b2ParticleColor color);

	/** Multiplies r, g, b, a members by s where s is a value between 0.0
	 *  and 1.0. */
	public native @ByRef @Name("operator *=") b2ParticleColor multiplyPut(@Cast("float32") float s);

	/** Scales r, g, b, a members by s where s is a value between 0 and 255. */
	public native @ByRef @Name("operator *=") b2ParticleColor multiplyPut(@Cast("uint8") short s);

	/** Scales r, g, b, a members by s returning the modified b2ParticleColor. */
	public native @ByVal @Name("operator *") b2ParticleColor multiply(@Cast("float32") float s);

	/** Scales r, g, b, a members by s returning the modified b2ParticleColor. */
	public native @ByVal @Name("operator *") b2ParticleColor multiply(@Cast("uint8") short s);

	/** Add two colors.  This is a non-saturating addition so values
	 *  overflows will wrap. */
	public native @ByRef @Name("operator +=") b2ParticleColor addPut(@Const @ByRef b2ParticleColor color);

	/** Add two colors.  This is a non-saturating addition so values
	 *  overflows will wrap. */
	public native @ByVal @Name("operator +") b2ParticleColor add(@Const @ByRef b2ParticleColor color);

	/** Subtract a color from this color.  This is a subtraction without
	 *  saturation so underflows will wrap. */
	public native @ByRef @Name("operator -=") b2ParticleColor subtractPut(@Const @ByRef b2ParticleColor color);

	/** Subtract a color from this color returning the result.  This is a
	 *  subtraction without saturation so underflows will wrap. */
	public native @ByVal @Name("operator -") b2ParticleColor subtract(@Const @ByRef b2ParticleColor color);

	/** Compare this color with the specified color. */
	public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b2ParticleColor color);

	/** Mix mixColor with this color using strength to control how much of
	 *  mixColor is mixed with this color and vice versa.  The range of
	 *  strength is 0..128 where 0 results in no color mixing and 128 results
	 *  in an equal mix of both colors.  strength 0..128 is analogous to an
	 *  alpha channel value between 0.0f..0.5f. */
	public native void Mix(b2ParticleColor mixColor, @Cast("const int32") int strength);

	/** Mix colorA with colorB using strength to control how much of
	 *  colorA is mixed with colorB and vice versa.  The range of
	 *  strength is 0..128 where 0 results in no color mixing and 128 results
	 *  in an equal mix of both colors.  strength 0..128 is analogous to an
	 *  alpha channel value between 0.0f..0.5f. */
	public static native void MixColors(b2ParticleColor colorA,
								 b2ParticleColor colorB,
								 @Cast("const int32") int strength);
	public native @Cast("uint8") short r(); public native b2ParticleColor r(short setter);
	public native @Cast("uint8") short g(); public native b2ParticleColor g(short setter);
	public native @Cast("uint8") short b(); public native b2ParticleColor b(short setter);
	public native @Cast("uint8") short a(); public native b2ParticleColor a(short setter);
}
