// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A particle group definition holds all the data needed to construct a
 *  particle group.  You can safely re-use these definitions. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2ParticleGroupDef extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2ParticleGroupDef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2ParticleGroupDef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2ParticleGroupDef position(long position) {
        return (b2ParticleGroupDef)super.position(position);
    }


	public b2ParticleGroupDef() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** The particle-behavior flags (See #b2ParticleFlag). */
	public native @Cast("uint32") long flags(); public native b2ParticleGroupDef flags(long setter);

	/** The group-construction flags (See #b2ParticleGroupFlag). */
	public native @Cast("uint32") long groupFlags(); public native b2ParticleGroupDef groupFlags(long setter);

	/** The world position of the group.
	 *  Moves the group's shape a distance equal to the value of position. */
	public native @ByRef @Name("position") b2Vec2 _position(); public native b2ParticleGroupDef _position(b2Vec2 setter);

	/** The world angle of the group in radians.
	 *  Rotates the shape by an angle equal to the value of angle. */
	public native @Cast("float32") float angle(); public native b2ParticleGroupDef angle(float setter);

	/** The linear velocity of the group's origin in world co-ordinates. */
	public native @ByRef b2Vec2 linearVelocity(); public native b2ParticleGroupDef linearVelocity(b2Vec2 setter);

	/** The angular velocity of the group. */
	public native @Cast("float32") float angularVelocity(); public native b2ParticleGroupDef angularVelocity(float setter);

	/** The color of all particles in the group. */
	public native @ByRef b2ParticleColor color(); public native b2ParticleGroupDef color(b2ParticleColor setter);

	/** The strength of cohesion among the particles in a group with flag
	 *  b2_elasticParticle or b2_springParticle. */
	public native @Cast("float32") float strength(); public native b2ParticleGroupDef strength(float setter);

	/** The shape where particles will be added. */
	@MemberGetter public native @Const b2Shape shape();
	@MemberSetter public native b2ParticleGroupDef shape(@Const b2Shape shape);

	/** A array of shapes where particles will be added. */
	@MemberGetter public native @Cast("const b2Shape*const*") PointerPointer shapes();
	@MemberSetter public native b2ParticleGroupDef shapes(@Cast("const b2Shape*const*") PointerPointer shapes);

	/** The number of shapes. */
	public native @Cast("int32") int shapeCount(); public native b2ParticleGroupDef shapeCount(int setter);

	/** The interval of particles in the shape.
	 *  If it is 0, b2_particleStride * particleDiameter is used instead. */
	public native @Cast("float32") float stride(); public native b2ParticleGroupDef stride(float setter);

	/** The number of particles in addition to ones added in the shape. */
	public native @Cast("int32") int particleCount(); public native b2ParticleGroupDef particleCount(int setter);

	/** The initial positions of the particleCount particles. */
	@MemberGetter public native @Const b2Vec2 positionData();
	@MemberSetter public native b2ParticleGroupDef positionData(@Const b2Vec2 positionData);

	/** Lifetime of the particle group in seconds.  A value <= 0.0f indicates a
	 *  particle group with infinite lifetime. */
	public native @Cast("float32") float lifetime(); public native b2ParticleGroupDef lifetime(float setter);

	/** Use this to store application-specific group data. */
	public native Pointer userData(); public native b2ParticleGroupDef userData(Pointer setter);

	/** An existing particle group to which the particles will be added. */
	public native b2ParticleGroup group(); public native b2ParticleGroupDef group(b2ParticleGroup setter);

// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API
	/** Storage for constructed CircleShapes from an incoming vertex list */
	public native @Const b2CircleShape circleShapes(); public native b2ParticleGroupDef circleShapes(b2CircleShape setter);

	/** True if we create the shapes array internally. */
	public native @Cast("bool") boolean ownShapesArray(); public native b2ParticleGroupDef ownShapesArray(boolean setter);

	/** Clean up all memory associated with SetCircleShapesFromVertexList */
	public native void FreeShapesMemory();

	/** From a vertex list created by an external language API, construct
	 *  a list of circle shapes that can be used to create a b2ParticleGroup
	 *  This eliminates cumbersome array-interfaces between languages. */
	public native void SetCircleShapesFromVertexList(Pointer inBuf,
										   int numShapes,
										   float radius);

	/** Set position with direct floats. */
	public native void SetPosition(@Cast("float32") float x, @Cast("float32") float y);

	/** Set color with direct ints. */
	public native void SetColor(@Cast("int32") int r, @Cast("int32") int g, @Cast("int32") int b, @Cast("int32") int a);
// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API
}
