// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A prismatic joint. This joint provides one degree of freedom: translation
 *  along an axis fixed in bodyA. Relative rotation is prevented. You can
 *  use a joint limit to restrict the range of motion and a joint motor to
 *  drive the motion or to model joint friction. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2PrismaticJoint extends b2Joint {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2PrismaticJoint(Pointer p) { super(p); }

	public native @ByVal b2Vec2 GetAnchorA();
	public native @ByVal b2Vec2 GetAnchorB();

	public native @ByVal b2Vec2 GetReactionForce(@Cast("float32") float inv_dt);
	public native @Cast("float32") float GetReactionTorque(@Cast("float32") float inv_dt);

	/** The local anchor point relative to bodyA's origin. */
	public native @Const @ByRef b2Vec2 GetLocalAnchorA();

	/** The local anchor point relative to bodyB's origin. */
	public native @Const @ByRef b2Vec2 GetLocalAnchorB();

	/** The local joint axis relative to bodyA. */
	public native @Const @ByRef b2Vec2 GetLocalAxisA();

	/** Get the reference angle. */
	public native @Cast("float32") float GetReferenceAngle();

	/** Get the current joint translation, usually in meters. */
	public native @Cast("float32") float GetJointTranslation();

	/** Get the current joint translation speed, usually in meters per second. */
	public native @Cast("float32") float GetJointSpeed();

	/** Is the joint limit enabled? */
	public native @Cast("bool") boolean IsLimitEnabled();

	/** Enable/disable the joint limit. */
	public native void EnableLimit(@Cast("bool") boolean flag);

	/** Get the lower joint limit, usually in meters. */
	public native @Cast("float32") float GetLowerLimit();

	/** Get the upper joint limit, usually in meters. */
	public native @Cast("float32") float GetUpperLimit();

	/** Set the joint limits, usually in meters. */
	public native void SetLimits(@Cast("float32") float lower, @Cast("float32") float upper);

	/** Is the joint motor enabled? */
	public native @Cast("bool") boolean IsMotorEnabled();

	/** Enable/disable the joint motor. */
	public native void EnableMotor(@Cast("bool") boolean flag);

	/** Set the motor speed, usually in meters per second. */
	public native void SetMotorSpeed(@Cast("float32") float speed);

	/** Get the motor speed, usually in meters per second. */
	public native @Cast("float32") float GetMotorSpeed();

	/** Set the maximum motor force, usually in N. */
	public native void SetMaxMotorForce(@Cast("float32") float force);
	public native @Cast("float32") float GetMaxMotorForce();

	/** Get the current motor force given the inverse time step, usually in N. */
	public native @Cast("float32") float GetMotorForce(@Cast("float32") float inv_dt);

	/** Dump to b2Log */
	public native void Dump();
}
