// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A wheel joint. This joint provides two degrees of freedom: translation
 *  along an axis fixed in bodyA and rotation in the plane. You can use a
 *  joint limit to restrict the range of motion and a joint motor to drive
 *  the rotation or to model rotational friction.
 *  This joint is designed for vehicle suspensions. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2WheelJoint extends b2Joint {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2WheelJoint(Pointer p) { super(p); }

	public native @ByVal b2Vec2 GetAnchorA();
	public native @ByVal b2Vec2 GetAnchorB();

	public native @ByVal b2Vec2 GetReactionForce(@Cast("float32") float inv_dt);
	public native @Cast("float32") float GetReactionTorque(@Cast("float32") float inv_dt);

	/** The local anchor point relative to bodyA's origin. */
	public native @Const @ByRef b2Vec2 GetLocalAnchorA();

	/** The local anchor point relative to bodyB's origin. */
	public native @Const @ByRef b2Vec2 GetLocalAnchorB();

	/** The local joint axis relative to bodyA. */
	public native @Const @ByRef b2Vec2 GetLocalAxisA();

	/** Get the current joint translation, usually in meters. */
	public native @Cast("float32") float GetJointTranslation();

	/** Get the current joint translation speed, usually in meters per second. */
	public native @Cast("float32") float GetJointSpeed();

	/** Is the joint motor enabled? */
	public native @Cast("bool") boolean IsMotorEnabled();

	/** Enable/disable the joint motor. */
	public native void EnableMotor(@Cast("bool") boolean flag);

	/** Set the motor speed, usually in radians per second. */
	public native void SetMotorSpeed(@Cast("float32") float speed);

	/** Get the motor speed, usually in radians per second. */
	public native @Cast("float32") float GetMotorSpeed();

	/** Set/Get the maximum motor force, usually in N-m. */
	public native void SetMaxMotorTorque(@Cast("float32") float torque);
	public native @Cast("float32") float GetMaxMotorTorque();

	/** Get the current motor torque given the inverse time step, usually in N-m. */
	public native @Cast("float32") float GetMotorTorque(@Cast("float32") float inv_dt);

	/** Set/Get the spring frequency in hertz. Setting the frequency to zero disables the spring. */
	public native void SetSpringFrequencyHz(@Cast("float32") float hz);
	public native @Cast("float32") float GetSpringFrequencyHz();

	/** Set/Get the spring damping ratio */
	public native void SetSpringDampingRatio(@Cast("float32") float ratio);
	public native @Cast("float32") float GetSpringDampingRatio();

	/** Dump to b2Log */
	public native void Dump();
}
