// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** Prismatic joint definition. This requires defining a line of
 *  motion using an axis and an anchor point. The definition uses local
 *  anchor points and a local axis so that the initial configuration
 *  can violate the constraint slightly. The joint translation is zero
 *  when the local anchor points coincide in world space. Using local
 *  anchors and a local axis helps when saving and loading a game. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2PrismaticJointDef extends b2JointDef {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2PrismaticJointDef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2PrismaticJointDef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2PrismaticJointDef position(long position) {
        return (b2PrismaticJointDef)super.position(position);
    }

	public b2PrismaticJointDef() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** Initialize the bodies, anchors, axis, and reference angle using the world
	 *  anchor and unit world axis. */
	public native void Initialize(b2Body bodyA, b2Body bodyB, @Const @ByRef b2Vec2 anchor, @Const @ByRef b2Vec2 axis);

	/** The local anchor point relative to bodyA's origin. */
	public native @ByRef b2Vec2 localAnchorA(); public native b2PrismaticJointDef localAnchorA(b2Vec2 setter);

	/** The local anchor point relative to bodyB's origin. */
	public native @ByRef b2Vec2 localAnchorB(); public native b2PrismaticJointDef localAnchorB(b2Vec2 setter);

	/** The local translation unit axis in bodyA. */
	public native @ByRef b2Vec2 localAxisA(); public native b2PrismaticJointDef localAxisA(b2Vec2 setter);

	/** The constrained angle between the bodies: bodyB_angle - bodyA_angle. */
	public native @Cast("float32") float referenceAngle(); public native b2PrismaticJointDef referenceAngle(float setter);

	/** Enable/disable the joint limit. */
	public native @Cast("bool") boolean enableLimit(); public native b2PrismaticJointDef enableLimit(boolean setter);

	/** The lower translation limit, usually in meters. */
	public native @Cast("float32") float lowerTranslation(); public native b2PrismaticJointDef lowerTranslation(float setter);

	/** The upper translation limit, usually in meters. */
	public native @Cast("float32") float upperTranslation(); public native b2PrismaticJointDef upperTranslation(float setter);

	/** Enable/disable the joint motor. */
	public native @Cast("bool") boolean enableMotor(); public native b2PrismaticJointDef enableMotor(boolean setter);

	/** The maximum motor torque, usually in N-m. */
	public native @Cast("float32") float maxMotorForce(); public native b2PrismaticJointDef maxMotorForce(float setter);

	/** The desired motor speed in radians per second. */
	public native @Cast("float32") float motorSpeed(); public native b2PrismaticJointDef motorSpeed(float setter);
}
