// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** Callback class for ray casts.
 *  See b2World::RayCast */
@Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2RayCastCallback extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public b2RayCastCallback() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2RayCastCallback(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2RayCastCallback(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public b2RayCastCallback position(long position) {
        return (b2RayCastCallback)super.position(position);
    }


	/** Called for each fixture found in the query. You control how the ray cast
	 *  proceeds by returning a float:
	 *  return -1: ignore this fixture and continue
	 *  return 0: terminate the ray cast
	 *  return fraction: clip the ray to this point
	 *  return 1: don't clip the ray and continue
	 *  @param fixture the fixture hit by the ray
	 *  @param point the point of initial intersection
	 *  @param normal the normal vector at the point of intersection
	 *  @return -1 to filter, 0 to terminate, fraction to clip the ray for
	 *  closest hit, 1 to continue */
	@Virtual(true) public native @Cast("float32") float ReportFixture(	b2Fixture fixture, @Const @ByRef b2Vec2 point,
										@Const @ByRef b2Vec2 normal, @Cast("float32") float fraction);

	/** Called for each particle found in the query. You control how the ray
	 *  cast proceeds by returning a float:
	 *  return <=0: ignore the remaining particles in this particle system
	 *  return fraction: ignore particles that are 'fraction' percent farther
	 *    along the line from 'point1' to 'point2'. Note that 'point1' and
	 *    'point2' are parameters to b2World::RayCast.
	 *  @param particleSystem the particle system containing the particle
	 *  @param index the index of the particle in particleSystem
	 *  @param point the point of intersection bt the ray and the particle
	 *  @param normal the normal vector at the point of intersection
	 *  @param fraction percent (0.0~1.0) from 'point0' to 'point1' along the
	 *    ray. Note that 'point1' and 'point2' are parameters to
	 *    b2World::RayCast.
	 *  @return <=0 to ignore rest of particle system, fraction to ignore
	 *  particles that are farther away. */
	@Virtual public native @Cast("float32") float ReportParticle(@Const b2ParticleSystem particleSystem,
									   @Cast("int32") int index, @Const @ByRef b2Vec2 point,
									   @Const @ByRef b2Vec2 normal, @Cast("float32") float fraction);

	/** Cull an entire particle system from b2World::RayCast. Ignored in
	 *  b2ParticleSystem::RayCast.
	 *  @return true if you want to include particleSystem in the RayCast, or
	 *  false to cull particleSystem from the RayCast. */
	@Virtual public native @Cast("bool") boolean ShouldQueryParticleSystem(
			@Const b2ParticleSystem particleSystem);
}
