// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** Callback class for AABB queries.
 *  See b2World::Query */
@Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2QueryCallback extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public b2QueryCallback() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2QueryCallback(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2QueryCallback(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public b2QueryCallback position(long position) {
        return (b2QueryCallback)super.position(position);
    }
    @Override public b2QueryCallback getPointer(long i) {
        return new b2QueryCallback((Pointer)this).position(position + i);
    }


	/** Called for each fixture found in the query AABB.
	 *  @return false to terminate the query. */
	@Virtual(true) public native @Cast("bool") boolean ReportFixture(b2Fixture fixture);

	/** Called for each particle found in the query AABB.
	 *  @return false to terminate the query. */
	@Virtual public native @Cast("bool") boolean ReportParticle(@Const b2ParticleSystem particleSystem,
									@Cast("int32") int index);

	/** Cull an entire particle system from b2World::QueryAABB. Ignored for
	 *  b2ParticleSystem::QueryAABB.
	 *  @return true if you want to include particleSystem in the AABB query,
	 *  or false to cull particleSystem from the AABB query. */
	@Virtual public native @Cast("bool") boolean ShouldQueryParticleSystem(
			@Const b2ParticleSystem particleSystem);
}
