// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun.global;

import org.bytedeco.liquidfun.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class liquidfun extends org.bytedeco.liquidfun.presets.liquidfun {
    static { Loader.load(); }

// Parsed from <Box2D/Common/b2Settings.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_SETTINGS_H
// #define B2_SETTINGS_H

// #include <stddef.h>
// #include <assert.h>
// #include <float.h>

// #define B2_NOT_USED(x) ((void)(x))
// #if DEBUG && !defined(NDEBUG)
// #define b2Assert(A) assert(A)
public static final int B2_ASSERT_ENABLED = 1;
// #else
// #define b2Assert(A)
// #endif

// Statement which is compiled out when DEBUG isn't defined.
// #if DEBUG
// #define B2_DEBUG_STATEMENT(A) A
// #else
// #define B2_DEBUG_STATEMENT(A)
// #endif  // DEBUG

// Calculate the size of a static array.
// #define B2_ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

// #ifdef WIN32
// #else // !WIN32
// #endif

// #define	b2_maxFloat		FLT_MAX
// #define	b2_epsilon		FLT_EPSILON
public static final double b2_pi =			3.14159265359f;

// #if !defined(b2Inline)
// #if defined(__GNUC__)
// #define b2Inline __attribute__((always_inline))
// #else
// #define b2Inline inline
// #endif // defined(__GNUC__)
// #endif // !defined(b2Inline)

// We expand the API so that other languages (e.g. Java) can call into
// our C++ more easily. Only set if when the flag is not externally defined.
// #if !defined(LIQUIDFUN_EXTERNAL_LANGUAGE_API)
// #if defined(SWIG) || defined(LIQUIDFUN_UNIT_TESTS)
public static final int LIQUIDFUN_EXTERNAL_LANGUAGE_API = 1;
// #else
// #endif
// #endif

/** \file
 *  Global tuning constants based on meters-kilograms-seconds (MKS) units.
 *  */

// Collision

/** The maximum number of contact points between two convex shapes. Do
/** not change this value. */
public static final int b2_maxManifoldPoints =	2;

/** The maximum number of vertices on a convex polygon. You cannot increase
 *  this too much because b2BlockAllocator has a maximum object size. */
public static final int b2_maxPolygonVertices =	8;

/** This is used to fatten AABBs in the dynamic tree. This allows proxies
 *  to move by a small amount without triggering a tree adjustment.
 *  This is in meters. */
public static final double b2_aabbExtension =		0.1f;

/** This is used to fatten AABBs in the dynamic tree. This is used to predict
 *  the future position based on the current displacement.
 *  This is a dimensionless multiplier. */
public static final double b2_aabbMultiplier =		2.0f;

/** A small length used as a collision and constraint tolerance. Usually it is
 *  chosen to be numerically significant, but visually insignificant. */
public static final double b2_linearSlop =			0.005f;

/** A small angle used as a collision and constraint tolerance. Usually it is
 *  chosen to be numerically significant, but visually insignificant. */
public static final double b2_angularSlop =			(2.0f / 180.0f * b2_pi);

/** The radius of the polygon/edge shape skin. This should not be modified. Making
 *  this smaller means polygons will have an insufficient buffer for continuous collision.
 *  Making it larger may create artifacts for vertex collision. */
public static final double b2_polygonRadius =		(2.0f * b2_linearSlop);

/** Maximum number of sub-steps per contact in continuous physics simulation. */
public static final int b2_maxSubSteps =			8;


// Dynamics

/** Maximum number of contacts to be handled to solve a TOI impact. */
public static final int b2_maxTOIContacts =			32;

/** A velocity threshold for elastic collisions. Any collision with a relative linear
 *  velocity below this threshold will be treated as inelastic. */
public static final double b2_velocityThreshold =		1.0f;

/** The maximum linear position correction used when solving constraints. This helps to
 *  prevent overshoot. */
public static final double b2_maxLinearCorrection =		0.2f;

/** The maximum angular position correction used when solving constraints. This helps to
 *  prevent overshoot. */
public static final double b2_maxAngularCorrection =		(8.0f / 180.0f * b2_pi);

/** The maximum linear velocity of a body. This limit is very large and is used
 *  to prevent numerical problems. You shouldn't need to adjust this. */
public static final double b2_maxTranslation =			2.0f;
// #define b2_maxTranslationSquared	(b2_maxTranslation * b2_maxTranslation)

/** The maximum angular velocity of a body. This limit is very large and is used
 *  to prevent numerical problems. You shouldn't need to adjust this. */
public static final double b2_maxRotation =				(0.5f * b2_pi);
// #define b2_maxRotationSquared		(b2_maxRotation * b2_maxRotation)

/** This scale factor controls how fast overlap is resolved. Ideally this would be 1 so
 *  that overlap is removed in one time step. However using values close to 1 often lead
 *  to overshoot. */
public static final double b2_baumgarte =				0.2f;
public static final double b2_toiBaugarte =				0.75f;


// Particle

/** NEON SIMD requires 16-bit particle indices */
// #if !defined(B2_USE_16_BIT_PARTICLE_INDICES) && defined(LIQUIDFUN_SIMD_NEON)
// #define B2_USE_16_BIT_PARTICLE_INDICES
// #endif

/** A symbolic constant that stands for particle allocation error. */
public static final int b2_invalidParticleIndex =		(-1);

// #ifdef B2_USE_16_BIT_PARTICLE_INDICES
// #else
public static final int b2_maxParticleIndex =			0x7FFFFFFF;
// #endif

/** The default distance between particles, multiplied by the particle diameter. */
public static final double b2_particleStride =			0.75f;

/** The minimum particle weight that produces pressure. */
public static final double b2_minParticleWeight =			1.0f;

/** The upper limit for particle pressure. */
public static final double b2_maxParticlePressure =		0.25f;

/** The upper limit for force between particles. */
public static final double b2_maxParticleForce =		0.5f;

/** The maximum distance between particles in a triad, multiplied by the
 *  particle diameter. */
public static final int b2_maxTriadDistance =			2;
public static final int b2_maxTriadDistanceSquared =		(b2_maxTriadDistance * b2_maxTriadDistance);

/** The initial size of particle data buffers. */
public static final int b2_minParticleSystemBufferCapacity =	256;

/** The time into the future that collisions against barrier particles will be detected. */
public static final double b2_barrierCollisionTime = 2.5f;

// Sleep

/** The time that a body must be still before it will go to sleep. */
public static final double b2_timeToSleep =				0.5f;

/** A body cannot sleep if its linear velocity is above this tolerance. */
public static final double b2_linearSleepTolerance =		0.01f;

/** A body cannot sleep if its angular velocity is above this tolerance. */
public static final double b2_angularSleepTolerance =	(2.0f / 180.0f * b2_pi);

// Memory Allocation

/** Implement this function to use your own memory allocator. */
public static native Pointer b2Alloc(@Cast("int32") int size);

/** If you implement b2Alloc, you should also implement this function. */
public static native void b2Free(Pointer mem);
// Targeting ../b2AllocFunction.java


// Targeting ../b2FreeFunction.java



/** Set alloc and free callbacks to override the default behavior of using
 *  malloc() and free() for dynamic memory allocation.
 *  Set allocCallback and freeCallback to NULL to restore the default
 *  allocator (malloc / free). */
public static native void b2SetAllocFreeCallbacks(b2AllocFunction allocCallback,
							 b2FreeFunction freeCallback,
							 Pointer callbackData);

/** Set the number of calls to b2Alloc minus the number of calls to b2Free.
 *  This can be used to disable the empty heap check in
 *  b2SetAllocFreeCallbacks() which can be useful for testing. */
public static native void b2SetNumAllocs(@Cast("const int32") int numAllocs);

/** Get number of calls to b2Alloc minus number of calls to b2Free. */
public static native @Cast("int32") int b2GetNumAllocs();

/** Logging function. */
public static native void b2Log(@Cast("const char*") BytePointer string);
public static native void b2Log(String string);
// Targeting ../b2Version.java



/** Current version.
 *  Version of Box2D, LiquidFun is based upon. */
public static native @ByRef b2Version b2_version(); public static native void b2_version(b2Version setter);

/** Global variable is used to identify the version of LiquidFun. */
@MemberGetter public static native @Const @ByRef b2Version b2_liquidFunVersion();
/** String which identifies the current version of LiquidFun.
 *  b2_liquidFunVersionString is used by Google developers to identify which
 *  applications uploaded to Google Play are using this library.  This allows
 *  the development team at Google to determine the popularity of the library.
 *  How it works: Applications that are uploaded to the Google Play Store are
 *  scanned for this version string.  We track which applications are using it
 *  to measure popularity.  You are free to remove it (of course) but we would
 *  appreciate if you left it in. */
public static native @Cast("const char*") BytePointer b2_liquidFunVersionString(); public static native void b2_liquidFunVersionString(BytePointer setter);

// #endif


// Parsed from <Box2D/Common/b2Math.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_MATH_H
// #define B2_MATH_H

// #include <Box2D/Common/b2Settings.h>
// #include <math.h>

/** This function is used to ensure that a floating point number is not a NaN or infinity. */
public static native @Cast("bool") boolean b2IsValid(@Cast("float32") float x);

/** This is a approximate yet fast inverse square-root. */
public static native @Cast("float32") float b2InvSqrt(@Cast("float32") float x);

// #define	b2Sqrt(x)	sqrtf(x)
// #define	b2Atan2(y, x)	atan2f(y, x)
// Targeting ../b2Vec2.java



/** Add a float to a vector. */
public static native @ByVal @Name("operator +") b2Vec2 add(@Const @ByRef b2Vec2 v, float f);

/** Substract a float from a vector. */
public static native @ByVal @Name("operator -") b2Vec2 subtract(@Const @ByRef b2Vec2 v, float f);

/** Multiply a float with a vector. */
public static native @ByVal @Name("operator *") b2Vec2 multiply(@Const @ByRef b2Vec2 v, float f);

/** Divide a vector by a float. */
public static native @ByVal @Name("operator /") b2Vec2 divide(@Const @ByRef b2Vec2 v, float f);
// Targeting ../b2Vec3.java


// Targeting ../b2Vec4.java


// Targeting ../b2Mat22.java


// Targeting ../b2Mat33.java


// Targeting ../b2Rot.java


// Targeting ../b2Transform.java


// Targeting ../b2Sweep.java



/** Useful constant */
@MemberGetter public static native @Const @ByRef b2Vec2 b2Vec2_zero();

/** Perform the dot product on two vectors. */
public static native @Cast("float32") float b2Dot(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

/** Perform the cross product on two vectors. In 2D this produces a scalar. */
public static native @Cast("float32") float b2Cross(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

/** Perform the cross product on a vector and a scalar. In 2D this produces
 *  a vector. */
public static native @ByVal b2Vec2 b2Cross(@Const @ByRef b2Vec2 a, @Cast("float32") float s);

/** Perform the cross product on a scalar and a vector. In 2D this produces
 *  a vector. */
public static native @ByVal b2Vec2 b2Cross(@Cast("float32") float s, @Const @ByRef b2Vec2 a);

/** Multiply a matrix times a vector. If a rotation matrix is provided,
 *  then this transforms the vector from one frame to another. */
public static native @ByVal b2Vec2 b2Mul(@Const @ByRef b2Mat22 A, @Const @ByRef b2Vec2 v);

/** Multiply a matrix transpose times a vector. If a rotation matrix is provided,
 *  then this transforms the vector from one frame to another (inverse transform). */
public static native @ByVal b2Vec2 b2MulT(@Const @ByRef b2Mat22 A, @Const @ByRef b2Vec2 v);

/** Add two vectors component-wise. */
public static native @ByVal @Name("operator +") b2Vec2 add(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

/** Subtract two vectors component-wise. */
public static native @ByVal @Name("operator -") b2Vec2 subtract(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @ByVal @Name("operator *") b2Vec2 multiply(@Cast("float32") float s, @Const @ByRef b2Vec2 a);

public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @Cast("float32") float b2Distance(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @Cast("float32") float b2DistanceSquared(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @ByVal @Name("operator *") b2Vec3 multiply(@Cast("float32") float s, @Const @ByRef b2Vec3 a);

/** Add two vectors component-wise. */
public static native @ByVal @Name("operator +") b2Vec3 add(@Const @ByRef b2Vec3 a, @Const @ByRef b2Vec3 b);

/** Subtract two vectors component-wise. */
public static native @ByVal @Name("operator -") b2Vec3 subtract(@Const @ByRef b2Vec3 a, @Const @ByRef b2Vec3 b);

/** Perform the dot product on two vectors. */
public static native @Cast("float32") float b2Dot(@Const @ByRef b2Vec3 a, @Const @ByRef b2Vec3 b);

/** Perform the cross product on two vectors. */
public static native @ByVal b2Vec3 b2Cross(@Const @ByRef b2Vec3 a, @Const @ByRef b2Vec3 b);

public static native @ByVal @Name("operator +") b2Mat22 add(@Const @ByRef b2Mat22 A, @Const @ByRef b2Mat22 B);

// A * B
public static native @ByVal b2Mat22 b2Mul(@Const @ByRef b2Mat22 A, @Const @ByRef b2Mat22 B);

// A^T * B
public static native @ByVal b2Mat22 b2MulT(@Const @ByRef b2Mat22 A, @Const @ByRef b2Mat22 B);

/** Multiply a matrix times a vector. */
public static native @ByVal b2Vec3 b2Mul(@Const @ByRef b2Mat33 A, @Const @ByRef b2Vec3 v);

/** Multiply a matrix times a vector. */
public static native @ByVal b2Vec2 b2Mul22(@Const @ByRef b2Mat33 A, @Const @ByRef b2Vec2 v);

/** Multiply two rotations: q * r */
public static native @ByVal b2Rot b2Mul(@Const @ByRef b2Rot q, @Const @ByRef b2Rot r);

/** Transpose multiply two rotations: qT * r */
public static native @ByVal b2Rot b2MulT(@Const @ByRef b2Rot q, @Const @ByRef b2Rot r);

/** Rotate a vector */
public static native @ByVal b2Vec2 b2Mul(@Const @ByRef b2Rot q, @Const @ByRef b2Vec2 v);

/** Inverse rotate a vector */
public static native @ByVal b2Vec2 b2MulT(@Const @ByRef b2Rot q, @Const @ByRef b2Vec2 v);

public static native @ByVal b2Vec2 b2Mul(@Const @ByRef b2Transform T, @Const @ByRef b2Vec2 v);

public static native @ByVal b2Vec2 b2MulT(@Const @ByRef b2Transform T, @Const @ByRef b2Vec2 v);

// v2 = A.q.Rot(B.q.Rot(v1) + B.p) + A.p
//    = (A.q * B.q).Rot(v1) + A.q.Rot(B.p) + A.p
public static native @ByVal b2Transform b2Mul(@Const @ByRef b2Transform A, @Const @ByRef b2Transform B);

// v2 = A.q' * (B.q * v1 + B.p - A.p)
//    = A.q' * B.q * v1 + A.q' * (B.p - A.p)
public static native @ByVal b2Transform b2MulT(@Const @ByRef b2Transform A, @Const @ByRef b2Transform B);

public static native @ByVal b2Vec2 b2Abs(@Const @ByRef b2Vec2 a);

public static native @ByVal b2Mat22 b2Abs(@Const @ByRef b2Mat22 A);

public static native @ByVal b2Vec2 b2Min(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @ByVal b2Vec2 b2Max(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 b);

public static native @ByVal b2Vec2 b2Clamp(@Const @ByRef b2Vec2 a, @Const @ByRef b2Vec2 low, @Const @ByRef b2Vec2 high);

/** "Next Largest Power of 2
 *  Given a binary integer value x, the next largest power of 2 can be computed by a SWAR algorithm
 *  that recursively "folds" the upper bits into the lower bits. This process yields a bit vector with
 *  the same most significant 1 as x, but all 1's below it. Adding 1 to that value yields the next
 *  largest power of 2. For a 32-bit value:" */
public static native @Cast("uint32") long b2NextPowerOfTwo(@Cast("uint32") long x);

public static native @Cast("bool") boolean b2IsPowerOfTwo(@Cast("uint32") long x);





/** Normalize an angle in radians to be between -pi and pi */


// #endif


// Parsed from <Box2D/Common/b2Draw.h>

/*
* Copyright (c) 2011 Erin Catto http://box2d.org
* Copyright (c) 2014 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_DRAW_H
// #define B2_DRAW_H

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Particle/b2Particle.h>
// Targeting ../b2Color.java


// Targeting ../b2Draw.java



// #endif


// Parsed from <Box2D/Common/b2IntrusiveList.h>

/*
* Copyright (c) 2014 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef B2_INTRUSIVE_LIST
// #define B2_INTRUSIVE_LIST

// #include <Box2D/Common/b2Settings.h>

// Whether to enable b2IntrusiveList::ValidateList().
// Be careful when enabling this since this changes the size of
// b2IntrusiveListNode so make sure *all* projects that include Box2D.h
// also define this value in the same way to avoid data corruption.
// #ifndef B2_INTRUSIVE_LIST_VALIDATE

///
///
///
public static final int B2_INTRUSIVE_LIST_VALIDATE = 0;
// Targeting ../b2IntrusiveListNode.java



/** Declares the member function GetListNode() of Class to retrieve a pointer
 *  to NodeMemberName.
 *  See #B2_INTRUSIVE_LIST_NODE_GET_CLASS_ACCESSOR() */
// #define B2_INTRUSIVE_LIST_GET_NODE(NodeMemberName)
// 	b2IntrusiveListNode* GetListNode() { return &NodeMemberName; }
// 	const b2IntrusiveListNode* GetListNode() const { return &NodeMemberName; }

/** Declares the member function FunctionName of Class to retrieve a pointer
 *  to a Class instance from a list node pointer.   NodeMemberName references
 *  the name of the b2IntrusiveListNode member of Class. */
// #define B2_INTRUSIVE_LIST_NODE_GET_CLASS_ACCESSOR(
// 	Class, NodeMemberName, FunctionName)
// 	static Class* FunctionName(b2IntrusiveListNode *node)
// 	{
// 		Class *cls = NULL;
// 		/* This effectively performs offsetof(Class, NodeMemberName) */
// 		/* which ends up in the undefined behavior realm of C++ but in */
// 		/* practice this works with most compilers. */
// 		return reinterpret_cast<Class*>((uint8*)(node) -
// 										(uint8*)(&cls->NodeMemberName));
// 	}
// 
// 	static const Class* FunctionName(const b2IntrusiveListNode *node)
// 	{
// 		return FunctionName(const_cast<b2IntrusiveListNode*>(node));
// 	}

/** Declares the member function GetInstanceFromListNode() of Class to retrieve
 *  a pointer to a Class instance from a list node pointer.  NodeMemberName
 *  reference the name of the b2IntrusiveListNode member of Class. */

///
///
///
// #define B2_INTRUSIVE_LIST_NODE_GET_CLASS(Class, NodeMemberName)
// 	B2_INTRUSIVE_LIST_NODE_GET_CLASS_ACCESSOR(Class, NodeMemberName,
// 											  GetInstanceFromListNode)
// Targeting ../ParticleHandleListNode.java



// #endif // B2_INTRUSIVE_LIST



// Parsed from <Box2D/Collision/Shapes/b2Shape.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_SHAPE_H
// #define B2_SHAPE_H

// #include <Box2D/Common/b2BlockAllocator.h>
// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Collision/b2Collision.h>
// Targeting ../b2MassData.java


// Targeting ../b2Shape.java





// #endif


// Parsed from <Box2D/Collision/Shapes/b2CircleShape.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_CIRCLE_SHAPE_H
// #define B2_CIRCLE_SHAPE_H

// #include <Box2D/Collision/Shapes/b2Shape.h>
// Targeting ../b2CircleShape.java











// #endif


// Parsed from <Box2D/Collision/Shapes/b2EdgeShape.h>

/*
* Copyright (c) 2006-2010 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_EDGE_SHAPE_H
// #define B2_EDGE_SHAPE_H

// #include <Box2D/Collision/Shapes/b2Shape.h>
// Targeting ../b2EdgeShape.java





// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API


// #endif


// Parsed from <Box2D/Collision/Shapes/b2ChainShape.h>

/*
* Copyright (c) 2006-2010 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_CHAIN_SHAPE_H
// #define B2_CHAIN_SHAPE_H

// #include <Box2D/Collision/Shapes/b2Shape.h>
// Targeting ../b2ChainShape.java





// #endif


// Parsed from <Box2D/Collision/Shapes/b2PolygonShape.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_POLYGON_SHAPE_H
// #define B2_POLYGON_SHAPE_H

// #include <Box2D/Collision/Shapes/b2Shape.h>
// Targeting ../b2PolygonShape.java







// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API



// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif


// Parsed from <Box2D/Collision/b2Collision.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_COLLISION_H
// #define B2_COLLISION_H

// #include <Box2D/Common/b2Math.h>
// #include <limits.h>

/** \file
 *  Structures and functions used for computing contact points, distance
 *  queries, and TOI queries. */

@MemberGetter public static native @Cast("const uint8") short b2_nullFeature();
// Targeting ../b2ContactFeature.java


// Targeting ../b2ContactID.java


// Targeting ../b2ManifoldPoint.java


// Targeting ../b2Manifold.java


// Targeting ../b2WorldManifold.java



/** This is used for determining the state of contact points. */
/** enum b2PointState */
public static final int
	/** point does not exist */
	b2_nullState = 0,
	/** point was added in the update */
	b2_addState = 1,
	/** point persisted across the update */
	b2_persistState = 2,
	/** point was removed in the update */
	b2_removeState = 3;

/** Compute the point states given two manifolds. The states pertain to the transition from manifold1
 *  to manifold2. So state1 is either persist or remove while state2 is either add or persist. */
public static native void b2GetPointStates(@Cast("b2PointState*") IntPointer state1, @Cast("b2PointState*") IntPointer state2,
					  @Const b2Manifold manifold1, @Const b2Manifold manifold2);
public static native void b2GetPointStates(@Cast("b2PointState*") IntBuffer state1, @Cast("b2PointState*") IntBuffer state2,
					  @Const b2Manifold manifold1, @Const b2Manifold manifold2);
public static native void b2GetPointStates(@Cast("b2PointState*") int[] state1, @Cast("b2PointState*") int[] state2,
					  @Const b2Manifold manifold1, @Const b2Manifold manifold2);
// Targeting ../b2ClipVertex.java


// Targeting ../b2RayCastInput.java


// Targeting ../b2RayCastOutput.java


// Targeting ../b2AABB.java



/** Compute the collision manifold between two circles. */
public static native void b2CollideCircles(b2Manifold manifold,
					  @Const b2CircleShape circleA, @Const @ByRef b2Transform xfA,
					  @Const b2CircleShape circleB, @Const @ByRef b2Transform xfB);

/** Compute the collision manifold between a polygon and a circle. */
public static native void b2CollidePolygonAndCircle(b2Manifold manifold,
							   @Const b2PolygonShape polygonA, @Const @ByRef b2Transform xfA,
							   @Const b2CircleShape circleB, @Const @ByRef b2Transform xfB);

/** Compute the collision manifold between two polygons. */
public static native void b2CollidePolygons(b2Manifold manifold,
					   @Const b2PolygonShape polygonA, @Const @ByRef b2Transform xfA,
					   @Const b2PolygonShape polygonB, @Const @ByRef b2Transform xfB);

/** Compute the collision manifold between an edge and a circle. */
public static native void b2CollideEdgeAndCircle(b2Manifold manifold,
							   @Const b2EdgeShape polygonA, @Const @ByRef b2Transform xfA,
							   @Const b2CircleShape circleB, @Const @ByRef b2Transform xfB);

/** Compute the collision manifold between an edge and a circle. */
public static native void b2CollideEdgeAndPolygon(b2Manifold manifold,
							   @Const b2EdgeShape edgeA, @Const @ByRef b2Transform xfA,
							   @Const b2PolygonShape circleB, @Const @ByRef b2Transform xfB);

/** Clipping for contact manifolds. */
public static native @Cast("int32") int b2ClipSegmentToLine(b2ClipVertex vOut, @Const b2ClipVertex vIn,
							@Const @ByRef b2Vec2 normal, @Cast("float32") float offset, @Cast("int32") int vertexIndexA);

/** Determine if two generic shapes overlap. */
public static native @Cast("bool") boolean b2TestOverlap(	@Const b2Shape shapeA, @Cast("int32") int indexA,
					@Const b2Shape shapeB, @Cast("int32") int indexB,
					@Const @ByRef b2Transform xfA, @Const @ByRef b2Transform xfB);

// ---------------- Inline Functions ------------------------------------------



public static native @Cast("bool") boolean b2TestOverlap(@Const @ByRef b2AABB a, @Const @ByRef b2AABB b);

// #endif


// Parsed from <Box2D/Collision/b2BroadPhase.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_BROAD_PHASE_H
// #define B2_BROAD_PHASE_H

// #include <Box2D/Common/b2Settings.h>
// #include <Box2D/Collision/b2Collision.h>
// #include <Box2D/Collision/b2DynamicTree.h>
// #include <algorithm>
// Targeting ../b2Pair.java


// Targeting ../b2BroadPhase.java



/** This is used to sort pairs. */
public static native @Cast("bool") boolean b2PairLessThan(@Const @ByRef b2Pair pair1, @Const @ByRef b2Pair pair2);























// #endif


// Parsed from <Box2D/Collision/b2Distance.h>


/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_DISTANCE_H
// #define B2_DISTANCE_H

// #include <Box2D/Common/b2Math.h>
// Targeting ../b2DistanceProxy.java


// Targeting ../b2SimplexCache.java


// Targeting ../b2DistanceInput.java


// Targeting ../b2DistanceOutput.java



/** Compute the closest points between two shapes. Supports any combination of:
 *  b2CircleShape, b2PolygonShape, b2EdgeShape. The simplex cache is input/output.
 *  On the first call set b2SimplexCache.count to zero. */
public static native void b2Distance(b2DistanceOutput output,
				b2SimplexCache cache, 
				@Const b2DistanceInput input);


//////////////////////////////////////////////////////////////////////////









// #endif


// Parsed from <Box2D/Collision/b2DynamicTree.h>

/*
* Copyright (c) 2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_DYNAMIC_TREE_H
// #define B2_DYNAMIC_TREE_H

// #include <Box2D/Collision/b2Collision.h>
// #include <Box2D/Common/b2GrowableStack.h>

public static final int b2_nullNode = (-1);
// Targeting ../b2TreeNode.java


// Targeting ../b2DynamicTree.java











// #endif


// Parsed from <Box2D/Collision/b2TimeOfImpact.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_TIME_OF_IMPACT_H
// #define B2_TIME_OF_IMPACT_H

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Collision/b2Distance.h>
// Targeting ../b2TOIInput.java


// Targeting ../b2TOIOutput.java



/** Compute the upper bound on time before two shapes penetrate. Time is represented as
 *  a fraction between [0,tMax]. This uses a swept separating axis and may miss some intermediate,
 *  non-tunneling collision. If you change the time interval, you should call this function
 *  again.
 *  Note: use b2Distance to compute the contact point and normal at the time of impact. */
public static native void b2TimeOfImpact(b2TOIOutput output, @Const b2TOIInput input);

// #endif


// Parsed from <Box2D/Dynamics/b2Body.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_BODY_H
// #define B2_BODY_H

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Collision/Shapes/b2Shape.h>
// #include <memory>
// Targeting ../b2Controller.java



/** The body type.
 *  static: zero mass, zero velocity, may be manually moved
 *  kinematic: zero mass, non-zero velocity set by user, moved by solver
 *  dynamic: positive mass, non-zero velocity determined by forces, moved by solver */
/** enum b2BodyType */
public static final int
	b2_staticBody = 0,
	b2_kinematicBody = 1,
	b2_dynamicBody = 2;

	// TODO_ERIN
	//b2_bulletBody,
// Targeting ../b2BodyDef.java


// Targeting ../b2Body.java











































































































// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API



// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif


// Parsed from <Box2D/Dynamics/b2Fixture.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_FIXTURE_H
// #define B2_FIXTURE_H

// #include <Box2D/Dynamics/b2Body.h>
// #include <Box2D/Collision/b2Collision.h>
// #include <Box2D/Collision/Shapes/b2Shape.h>
// Targeting ../b2BlockAllocator.java


// Targeting ../b2Filter.java


// Targeting ../b2FixtureDef.java


// Targeting ../b2FixtureProxy.java


// Targeting ../b2Fixture.java















































// #endif


// Parsed from <Box2D/Dynamics/b2WorldCallbacks.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_WORLD_CALLBACKS_H
// #define B2_WORLD_CALLBACKS_H

// #include <Box2D/Common/b2Settings.h>
// Targeting ../b2ContactResult.java


// Targeting ../b2DestructionListener.java


// Targeting ../b2ContactFilter.java


// Targeting ../b2ContactImpulse.java


// Targeting ../b2ContactListener.java


// Targeting ../b2QueryCallback.java


// Targeting ../b2RayCastCallback.java



// #endif


// Parsed from <Box2D/Dynamics/b2TimeStep.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
* Copyright (c) 2014 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_TIME_STEP_H
// #define B2_TIME_STEP_H

// #include <Box2D/Common/b2Math.h>
// Targeting ../b2Profile.java


// Targeting ../b2TimeStep.java


// Targeting ../b2Position.java


// Targeting ../b2Velocity.java


// Targeting ../b2SolverData.java



// #endif


// Parsed from <Box2D/Dynamics/b2World.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_WORLD_H
// #define B2_WORLD_H

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Common/b2BlockAllocator.h>
// #include <Box2D/Common/b2StackAllocator.h>
// #include <Box2D/Dynamics/b2ContactManager.h>
// #include <Box2D/Dynamics/b2WorldCallbacks.h>
// #include <Box2D/Dynamics/b2TimeStep.h>
// #include <Box2D/Particle/b2ParticleSystem.h>
// Targeting ../b2World.java

































/** Get the flag that controls automatic clearing of forces after each time step. */






// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API



// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif


// Parsed from <Box2D/Dynamics/b2ContactManager.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_CONTACT_MANAGER_H
// #define B2_CONTACT_MANAGER_H

// #include <Box2D/Collision/b2BroadPhase.h>
// Targeting ../b2ContactManager.java



// #endif


// Parsed from <Box2D/Dynamics/Contacts/b2Contact.h>

/*
* Copyright (c) 2006-2009 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_CONTACT_H
// #define B2_CONTACT_H

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Collision/b2Collision.h>
// #include <Box2D/Collision/Shapes/b2Shape.h>
// #include <Box2D/Dynamics/b2Fixture.h>
// Targeting ../b2StackAllocator.java



/** Friction mixing law. The idea is to allow either fixture to drive the restitution to zero.
 *  For example, anything slides on ice. */
public static native @Cast("float32") float b2MixFriction(@Cast("float32") float friction1, @Cast("float32") float friction2);

/** Restitution mixing law. The idea is allow for anything to bounce off an inelastic surface.
 *  For example, a superball bounces on anything. */
public static native @Cast("float32") float b2MixRestitution(@Cast("float32") float restitution1, @Cast("float32") float restitution2);
// Targeting ../b2ContactCreateFcn.java


// Targeting ../b2ContactDestroyFcn.java


// Targeting ../b2ContactRegister.java


// Targeting ../b2ContactEdge.java


// Targeting ../b2Contact.java

















































// #endif


// Parsed from <Box2D/Dynamics/Joints/b2Joint.h>

/*
* Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_JOINT_H
// #define B2_JOINT_H

// #include <Box2D/Common/b2Math.h>

/** enum b2JointType */
public static final int
	e_unknownJoint = 0,
	e_revoluteJoint = 1,
	e_prismaticJoint = 2,
	e_distanceJoint = 3,
	e_pulleyJoint = 4,
	e_mouseJoint = 5,
	e_gearJoint = 6,
	e_wheelJoint = 7,
    e_weldJoint = 8,
	e_frictionJoint = 9,
	e_ropeJoint = 10,
	e_motorJoint = 11;

/** enum b2LimitState */
public static final int
	e_inactiveLimit = 0,
	e_atLowerLimit = 1,
	e_atUpperLimit = 2,
	e_equalLimits = 3;
// Targeting ../b2Jacobian.java


// Targeting ../b2JointEdge.java


// Targeting ../b2JointDef.java


// Targeting ../b2Joint.java



















// #endif


// Parsed from <Box2D/Dynamics/Joints/b2DistanceJoint.h>

/*
* Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_DISTANCE_JOINT_H
// #define B2_DISTANCE_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2DistanceJointDef.java


// Targeting ../b2DistanceJoint.java















// #endif


// Parsed from <Box2D/Dynamics/Joints/b2FrictionJoint.h>

/*
* Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_FRICTION_JOINT_H
// #define B2_FRICTION_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2FrictionJointDef.java


// Targeting ../b2FrictionJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2GearJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_GEAR_JOINT_H
// #define B2_GEAR_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2GearJointDef.java


// Targeting ../b2GearJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2MotorJoint.h>

/*
* Copyright (c) 2006-2012 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_MOTOR_JOINT_H
// #define B2_MOTOR_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2MotorJointDef.java


// Targeting ../b2MotorJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2MouseJoint.h>

/*
* Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_MOUSE_JOINT_H
// #define B2_MOUSE_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2MouseJointDef.java


// Targeting ../b2MouseJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2PrismaticJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_PRISMATIC_JOINT_H
// #define B2_PRISMATIC_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2PrismaticJointDef.java


// Targeting ../b2PrismaticJoint.java





// #endif


// Parsed from <Box2D/Dynamics/Joints/b2PulleyJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_PULLEY_JOINT_H
// #define B2_PULLEY_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>

@MemberGetter public static native @Cast("const float32") float b2_minPulleyLength();
// Targeting ../b2PulleyJointDef.java


// Targeting ../b2PulleyJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2RevoluteJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_REVOLUTE_JOINT_H
// #define B2_REVOLUTE_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2RevoluteJointDef.java


// Targeting ../b2RevoluteJoint.java





// #endif


// Parsed from <Box2D/Dynamics/Joints/b2RopeJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_ROPE_JOINT_H
// #define B2_ROPE_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2RopeJointDef.java


// Targeting ../b2RopeJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2WeldJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_WELD_JOINT_H
// #define B2_WELD_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2WeldJointDef.java


// Targeting ../b2WeldJoint.java



// #endif


// Parsed from <Box2D/Dynamics/Joints/b2WheelJoint.h>

/*
* Copyright (c) 2006-2011 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef B2_WHEEL_JOINT_H
// #define B2_WHEEL_JOINT_H

// #include <Box2D/Dynamics/Joints/b2Joint.h>
// Targeting ../b2WheelJointDef.java


// Targeting ../b2WheelJoint.java















// #endif


// Parsed from <Box2D/Particle/b2Particle.h>

/*
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef B2_PARTICLE
// #define B2_PARTICLE

// #include <Box2D/Common/b2Math.h>
// #include <Box2D/Common/b2Settings.h>
// #include <Box2D/Common/b2IntrusiveList.h>

/** \file
 <p>
 *  The particle type. Can be combined with the | operator. */
/** enum b2ParticleFlag */
public static final int
	/** Water particle. */
	b2_waterParticle = 0,
	/** Removed after next simulation step. */
	b2_zombieParticle = 1 << 1,
	/** Zero velocity. */
	b2_wallParticle = 1 << 2,
	/** With restitution from stretching. */
	b2_springParticle = 1 << 3,
	/** With restitution from deformation. */
	b2_elasticParticle = 1 << 4,
	/** With viscosity. */
	b2_viscousParticle = 1 << 5,
	/** Without isotropic pressure. */
	b2_powderParticle = 1 << 6,
	/** With surface tension. */
	b2_tensileParticle = 1 << 7,
	/** Mix color between contacting particles. */
	b2_colorMixingParticle = 1 << 8,
	/** Call b2DestructionListener on destruction. */
	b2_destructionListenerParticle = 1 << 9,
	/** Prevents other particles from leaking. */
	b2_barrierParticle = 1 << 10,
	/** Less compressibility. */
	b2_staticPressureParticle = 1 << 11,
	/** Makes pairs or triads with other particles. */
	b2_reactiveParticle = 1 << 12,
	/** With high repulsive force. */
	b2_repulsiveParticle = 1 << 13,
	/** Call b2ContactListener when this particle is about to interact with
	 *  a rigid body or stops interacting with a rigid body.
	 *  This results in an expensive operation compared to using
	 *  b2_fixtureContactFilterParticle to detect collisions between
	 *  particles. */
	b2_fixtureContactListenerParticle = 1 << 14,
	/** Call b2ContactListener when this particle is about to interact with
	 *  another particle or stops interacting with another particle.
	 *  This results in an expensive operation compared to using
	 *  b2_particleContactFilterParticle to detect collisions between
	 *  particles. */
	b2_particleContactListenerParticle = 1 << 15,
	/** Call b2ContactFilter when this particle interacts with rigid bodies. */
	b2_fixtureContactFilterParticle = 1 << 16,
	/** Call b2ContactFilter when this particle interacts with other
	 *  particles. */
	b2_particleContactFilterParticle = 1 << 17;
// Targeting ../b2ParticleColor.java



public static native @ByRef b2ParticleColor b2ParticleColor_zero(); public static native void b2ParticleColor_zero(b2ParticleColor setter);
// Targeting ../b2ParticleDef.java



/** A helper function to calculate the optimal number of iterations. */
public static native @Cast("int32") int b2CalculateParticleIterations(
	@Cast("float32") float gravity, @Cast("float32") float radius, @Cast("float32") float timeStep);
// Targeting ../b2ParticleHandle.java



// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API



// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif


// Parsed from <Box2D/Particle/b2ParticleGroup.h>

/*
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef B2_PARTICLE_GROUP
// #define B2_PARTICLE_GROUP

// #include <Box2D/Particle/b2Particle.h>
// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API
// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

/** \file
 <p>
 *  The particle group type.  Can be combined with the | operator. */
/** enum b2ParticleGroupFlag */
public static final int
	/** Prevents overlapping or leaking. */
	b2_solidParticleGroup = 1 << 0,
	/** Keeps its shape. */
	b2_rigidParticleGroup = 1 << 1,
	/** Won't be destroyed if it gets empty. */
	b2_particleGroupCanBeEmpty = 1 << 2,
	/** Will be destroyed on next simulation step. */
	b2_particleGroupWillBeDestroyed = 1 << 3,
	/** Updates depth data on next simulation step. */
	b2_particleGroupNeedsUpdateDepth = 1 << 4,
	b2_particleGroupInternalMask = 
		b2_particleGroupWillBeDestroyed |
		b2_particleGroupNeedsUpdateDepth;
// Targeting ../b2ParticleGroupDef.java


// Targeting ../b2ParticleGroup.java













































// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API



// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API


// #endif


// Parsed from <Box2D/Particle/b2ParticleSystem.h>

/*
* Copyright (c) 2013 Google, Inc.
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef B2_PARTICLE_SYSTEM_H
// #define B2_PARTICLE_SYSTEM_H

// #include <Box2D/Common/b2SlabAllocator.h>
// #include <Box2D/Common/b2GrowableBuffer.h>
// #include <Box2D/Particle/b2Particle.h>
// #include <Box2D/Dynamics/b2TimeStep.h>

// #ifdef LIQUIDFUN_UNIT_TESTS
// #include <gtest/gtest.h>
// #endif // LIQUIDFUN_UNIT_TESTS

// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API
// #include <cstring>
// Targeting ../b2ParticlePairSet.java


// Targeting ../FixtureParticleSet.java


// Targeting ../FindContactInput.java


// Targeting ../FindContactCheck.java


// Targeting ../b2ParticleContact.java


// Targeting ../b2ParticleBodyContact.java


// Targeting ../b2ParticlePair.java


// Targeting ../b2ParticleTriad.java


// Targeting ../b2ParticleSystemDef.java


// Targeting ../b2ParticleSystem.java








// The reciprocal sqrt function differs between SIMD and non-SIMD, but they
// should create approximately equal results.

















































































































// Note: These functions must go in the header so the unit tests will compile
// them. b2ParticleSystem.cpp does not compile with this #define.
// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API















// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

// #endif



// Parsed from liquidfun_adapters.h

// #include <Box2D/Common/b2Settings.h>
// Targeting ../b2DynamicTreeQueryCallback.java


// Targeting ../b2DynamicTreeRayCastCallback.java




}
