// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** The broad-phase is used for computing pairs and performing volume queries and ray casts.
 *  This broad-phase does not persist pairs. Instead, this reports potentially new pairs.
 *  It is up to the client to consume the new pairs and to track subsequent overlap. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2BroadPhase extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2BroadPhase(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2BroadPhase(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2BroadPhase position(long position) {
        return (b2BroadPhase)super.position(position);
    }
    @Override public b2BroadPhase getPointer(long i) {
        return new b2BroadPhase((Pointer)this).offsetAddress(i);
    }


	/** enum b2BroadPhase:: */
	public static final int
		e_nullProxy = -1;

	public b2BroadPhase() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** Create a proxy with an initial AABB. Pairs are not reported until
	 *  UpdatePairs is called. */
	public native @Cast("int32") int CreateProxy(@Const @ByRef b2AABB aabb, Pointer userData);

	/** Destroy a proxy. It is up to the client to remove any pairs. */
	public native void DestroyProxy(@Cast("int32") int proxyId);

	/** Call MoveProxy as many times as you like, then when you are done
	 *  call UpdatePairs to finalized the proxy pairs (for your time step). */
	public native void MoveProxy(@Cast("int32") int proxyId, @Const @ByRef b2AABB aabb, @Const @ByRef b2Vec2 displacement);

	/** Call to trigger a re-processing of it's pairs on the next call to UpdatePairs. */
	public native void TouchProxy(@Cast("int32") int proxyId);

	/** Get the fat AABB for a proxy. */
	public native @Const @ByRef b2AABB GetFatAABB(@Cast("int32") int proxyId);

	/** Get user data from a proxy. Returns NULL if the id is invalid. */
	public native Pointer GetUserData(@Cast("int32") int proxyId);

	/** Test overlap of fat AABBs. */
	public native @Cast("bool") boolean TestOverlap(@Cast("int32") int proxyIdA, @Cast("int32") int proxyIdB);

	/** Get the number of proxies. */
	public native @Cast("int32") int GetProxyCount();

	/** Update the pairs. This results in pair callbacks. This can only add pairs. */

	/** Query an AABB for overlapping proxies. The callback class
	 *  is called for each proxy that overlaps the supplied AABB. */

	/** Ray-cast against the proxies in the tree. This relies on the callback
	 *  to perform a exact ray-cast in the case were the proxy contains a shape.
	 *  The callback also performs the any collision filtering. This has performance
	 *  roughly equal to k * log(n), where k is the number of collisions and n is the
	 *  number of proxies in the tree.
	 *  @param input the ray-cast input data. The ray extends from p1 to p1 + maxFraction * (p2 - p1).
	 *  @param callback a callback class that is called for each proxy that is hit by the ray. */

	/** Get the height of the embedded tree. */
	public native @Cast("int32") int GetTreeHeight();

	/** Get the balance of the embedded tree. */
	public native @Cast("int32") int GetTreeBalance();

	/** Get the quality metric of the embedded tree. */
	public native @Cast("float32") float GetTreeQuality();

	/** Shift the world origin. Useful for large worlds.
	 *  The shift formula is: position -= newOrigin
	 *  @param newOrigin the new origin with respect to the old origin */
	public native void ShiftOrigin(@Const @ByRef b2Vec2 newOrigin);
}
