// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** Handle to a particle. Particle indices are ephemeral: the same index might
 *  refer to a different particle, from frame-to-frame. If you need to keep a
 *  reference to a particular particle across frames, you should acquire a
 *  b2ParticleHandle. Use #b2ParticleSystem::GetParticleHandleFromIndex() to
 *  retrieve the b2ParticleHandle of a particle from the particle system. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2ParticleHandle extends ParticleHandleListNode {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2ParticleHandle(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2ParticleHandle(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2ParticleHandle position(long position) {
        return (b2ParticleHandle)super.position(position);
    }
    @Override public b2ParticleHandle getPointer(long i) {
        return new b2ParticleHandle((Pointer)this).offsetAddress(i);
    }

	/** Initialize the index associated with the handle to an invalid index. */
	public b2ParticleHandle() { super((Pointer)null); allocate(); }
	private native void allocate();
	/** Empty destructor. */

	/** Get the index of the particle associated with this handle. */
	public native @Cast("int32") int GetIndex();
}
