// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A 3D column vector with 3 elements. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2Vec3 extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2Vec3(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2Vec3(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2Vec3 position(long position) {
        return (b2Vec3)super.position(position);
    }
    @Override public b2Vec3 getPointer(long i) {
        return new b2Vec3((Pointer)this).offsetAddress(i);
    }

	/** Default constructor does nothing (for performance). */
	public b2Vec3() { super((Pointer)null); allocate(); }
	private native void allocate();

	/** Construct using coordinates. */
	public b2Vec3(@Cast("float32") float x, @Cast("float32") float y, @Cast("float32") float z) { super((Pointer)null); allocate(x, y, z); }
	private native void allocate(@Cast("float32") float x, @Cast("float32") float y, @Cast("float32") float z);

	/** Set this vector to all zeros. */
	public native void SetZero();

	/** Set this vector to some specified coordinates. */
	public native void Set(@Cast("float32") float x_, @Cast("float32") float y_, @Cast("float32") float z_);

	/** Negate this vector. */
	public native @ByVal @Name("operator -") b2Vec3 subtract();

	/** Add a vector to this vector. */
	public native @Name("operator +=") void addPut(@Const @ByRef b2Vec3 v);

	/** Subtract a vector from this vector. */
	public native @Name("operator -=") void subtractPut(@Const @ByRef b2Vec3 v);

	/** Multiply this vector by a scalar. */
	public native @Name("operator *=") void multiplyPut(@Cast("float32") float s);

		/** Get the length of this vector (the norm). */
	public native @Cast("float32") float Length();

	/** Convert this vector into a unit vector. Returns the length. */
	public native @Cast("float32") float Normalize();

	public native @Cast("float32") float x(); public native b2Vec3 x(float setter);
	public native @Cast("float32") float y(); public native b2Vec3 y(float setter);
	public native @Cast("float32") float z(); public native b2Vec3 z(float setter);
}
