// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A particle definition holds all the data needed to construct a particle.
 *  You can safely re-use these definitions. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2ParticleDef extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2ParticleDef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b2ParticleDef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b2ParticleDef position(long position) {
        return (b2ParticleDef)super.position(position);
    }

	public b2ParticleDef() { super((Pointer)null); allocate(); }
	private native void allocate();

// #if LIQUIDFUN_EXTERNAL_LANGUAGE_API
	/** Set position with direct floats */
	public native void SetPosition(@Cast("float32") float x, @Cast("float32") float y);

	/** Set color with direct ints. */
	
	///
	public native void SetColor(@Cast("int32") int r, @Cast("int32") int g, @Cast("int32") int b, @Cast("int32") int a);
// #endif // LIQUIDFUN_EXTERNAL_LANGUAGE_API

	/** \brief Specifies the type of particle (see #b2ParticleFlag).
	 * 
	 *  A particle may be more than one type.
	 *  Multiple types are chained by logical sums, for example:
	 *  pd.flags = b2_elasticParticle | b2_viscousParticle */
	public native @Cast("uint32") long flags(); public native b2ParticleDef flags(long setter);

	/** The world position of the particle. */
	public native @ByRef @Name("position") b2Vec2 _position(); public native b2ParticleDef _position(b2Vec2 setter);

	/** The linear velocity of the particle in world co-ordinates. */
	public native @ByRef b2Vec2 velocity(); public native b2ParticleDef velocity(b2Vec2 setter);

	/** The color of the particle. */
	public native @ByRef b2ParticleColor color(); public native b2ParticleDef color(b2ParticleColor setter);

	/** Lifetime of the particle in seconds.  A value <= 0.0f indicates a
	 *  particle with infinite lifetime. */
	public native @Cast("float32") float lifetime(); public native b2ParticleDef lifetime(float setter);

	/** Use this to store application-specific body data. */
	public native Pointer userData(); public native b2ParticleDef userData(Pointer setter);

	/** An existing particle group to which the particle will be added. */
	public native b2ParticleGroup group(); public native b2ParticleDef group(b2ParticleGroup setter);

}
