// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.liquidfun;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.liquidfun.global.liquidfun.*;


/** A group of particles. b2ParticleGroup::CreateParticleGroup creates these. */
@NoOffset @Properties(inherit = org.bytedeco.liquidfun.presets.liquidfun.class)
public class b2ParticleGroup extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b2ParticleGroup(Pointer p) { super(p); }


	/** Get the next particle group from the list in b2_World. */
	public native b2ParticleGroup GetNext();

	/** Get the particle system that holds this particle group. */
	public native b2ParticleSystem GetParticleSystem();

	/** Get the number of particles. */
	public native @Cast("int32") int GetParticleCount();

	/** Get the offset of this group in the global particle buffer */
	public native @Cast("int32") int GetBufferIndex();

	/** Does this group contain the particle. */
	public native @Cast("bool") boolean ContainsParticle(@Cast("int32") int index);

	/** Get the logical sum of particle flags. */
	public native @Cast("uint32") long GetAllParticleFlags();

	/** Get the construction flags for the group. */
	public native @Cast("uint32") long GetGroupFlags();

	/** Set the construction flags for the group. */
	public native void SetGroupFlags(@Cast("uint32") long flags);

	/** Get the total mass of the group: the sum of all particles in it. */
	public native @Cast("float32") float GetMass();

	/** Get the moment of inertia for the group. */
	public native @Cast("float32") float GetInertia();

	/** Get the center of gravity for the group. */
	public native @ByVal b2Vec2 GetCenter();

	/** Get the linear velocity of the group. */
	public native @ByVal b2Vec2 GetLinearVelocity();

	/** Get the angular velocity of the group. */
	public native @Cast("float32") float GetAngularVelocity();

	/** Get the position of the group's origin and rotation.
	 *  Used only with groups of rigid particles. */
	public native @Const @ByRef b2Transform GetTransform();

	/** Get position of the particle group as a whole.
	 *  Used only with groups of rigid particles. */
	public native @Const @ByRef b2Vec2 GetPosition();

	/** Get the rotational angle of the particle group as a whole.
	 *  Used only with groups of rigid particles. */
	public native @Cast("float32") float GetAngle();

	/** Get the world linear velocity of a world point, from the average linear
	 *  and angular velocities of the particle group.
	 *  @param a point in world coordinates.
	 *  @return the world velocity of a point. */
	public native @ByVal b2Vec2 GetLinearVelocityFromWorldPoint(@Const @ByRef b2Vec2 worldPoint);

	/** Get the user data pointer that was provided in the group definition. */
	public native Pointer GetUserData();

	/** Set the user data. Use this to store your application specific data. */
	public native void SetUserData(Pointer data);

	/** Call b2ParticleSystem::ApplyForce for every particle in the group. */
	public native void ApplyForce(@Const @ByRef b2Vec2 force);

	/** Call b2ParticleSystem::ApplyLinearImpulse for every particle in the
	 *  group. */
	public native void ApplyLinearImpulse(@Const @ByRef b2Vec2 impulse);

	/** Destroy all the particles in this group.
	 *  This function is locked during callbacks.
	 *  @param Whether to call the world b2DestructionListener for each
	 *  particle is destroyed.
	 *  \warning This function is locked during callbacks. */
	public native void DestroyParticles(@Cast("bool") boolean callDestructionListener);

	/** Destroy all particles in this group without enabling the destruction
	 *  callback for destroyed particles.
	 *  This function is locked during callbacks.
	 *  \warning This function is locked during callbacks. */
	public native void DestroyParticles();

}
