// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.lz4;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.lz4.global.lz4.*;
    /* v1.8.3+ */

/** LZ4F_preferences_t :
 *  makes it possible to supply advanced compression instructions to streaming interface.
 *  Structure must be first init to 0, using memset() or LZ4F_INIT_PREFERENCES,
 *  setting all parameters to default.
 *  All reserved fields must be set to zero. */
@Name("LZ4F_preferences_t") @Properties(inherit = org.bytedeco.lz4.presets.lz4.class)
public class LZ4FPreferences extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public LZ4FPreferences() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LZ4FPreferences(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LZ4FPreferences(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public LZ4FPreferences position(long position) {
        return (LZ4FPreferences)super.position(position);
    }
    @Override public LZ4FPreferences getPointer(long i) {
        return new LZ4FPreferences((Pointer)this).offsetAddress(i);
    }

  public native @ByRef LZ4FFrameInfo frameInfo(); public native LZ4FPreferences frameInfo(LZ4FFrameInfo setter);
  public native int compressionLevel(); public native LZ4FPreferences compressionLevel(int setter);    /* 0: default (fast mode); values > LZ4HC_CLEVEL_MAX count as LZ4HC_CLEVEL_MAX; values < 0 trigger "fast acceleration" */
  public native @Cast("unsigned") int autoFlush(); public native LZ4FPreferences autoFlush(int setter);           /* 1: always flush; reduces usage of internal buffers */
  public native @Cast("unsigned") int favorDecSpeed(); public native LZ4FPreferences favorDecSpeed(int setter);       /* 1: parser favors decompression speed vs compression ratio. Only works for high compression modes (>= LZ4HC_CLEVEL_OPT_MIN) */  /* v1.8.2+ */
  public native @Cast("unsigned") int reserved(int i); public native LZ4FPreferences reserved(int i, int setter);
  @MemberGetter public native @Cast("unsigned*") IntPointer reserved();         /* must be zero for forward compatibility */
}
