// Targeted by JavaCPP version 1.5: DO NOT EDIT THIS FILE

package org.bytedeco.mkldnn.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class mklml extends org.bytedeco.mkldnn.presets.mklml {
    static { Loader.load(); }

// Parsed from mkl.h

/*******************************************************************************
* Copyright (c) 2018-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*   Intel(R) Math Kernel Library (Intel(R) MKL) interface */

// #ifndef _MKL_H_
// #define _MKL_H_

// #include "mkl_blas.h"
// #include "mkl_cblas.h"
// #include "mkl_dnn.h"
// #include "mkl_lapack.h"
// #include "mkl_lapacke.h"
// #include "mkl_service.h"
// #include "mkl_trans.h"
// #include "mkl_types.h"
// #include "mkl_version.h"
// #include "mkl_vml.h"
// #include "mkl_vsl.h"
// #include "mkl_direct_call.h"

// #endif /*_MKL_H_*/


// Parsed from mkl_version.h

// #if 0
// #endif

// #if 0
// #endif

// #ifndef _MKL_VERSION_H_
// #define _MKL_VERSION_H_

public static final int __INTEL_MKL_BUILD_DATE = 20190220;

public static final int __INTEL_MKL__ = 2019;
public static final int __INTEL_MKL_MINOR__ = 0;
public static final int __INTEL_MKL_UPDATE__ = 3;

public static final int INTEL_MKL_VERSION = 20190003;

// #endif


// Parsed from mkl_types.h

/*******************************************************************************
* Copyright (c) 1999-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*
! Content:
!      Intel(R) Math Kernel Library (Intel(R) MKL) types definition
!****************************************************************************/

// #ifndef _MKL_TYPES_H_
// #define _MKL_TYPES_H_

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* Intel(R) MKL Complex type for single precision */
// #ifndef MKL_Complex8
public static class MKL_Complex8 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public MKL_Complex8() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MKL_Complex8(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MKL_Complex8(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MKL_Complex8 position(long position) {
        return (MKL_Complex8)super.position(position);
    }

    public native float real(); public native MKL_Complex8 real(float setter);
    public native float imag(); public native MKL_Complex8 imag(float setter);
}
// #endif

/* Intel(R) MKL Complex type for double precision */
// #ifndef MKL_Complex16
public static class MKL_Complex16 extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public MKL_Complex16() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MKL_Complex16(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MKL_Complex16(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MKL_Complex16 position(long position) {
        return (MKL_Complex16)super.position(position);
    }

    public native double real(); public native MKL_Complex16 real(double setter);
    public native double imag(); public native MKL_Complex16 imag(double setter);
}
// #endif

/* Intel(R) MKL Version type */
public static class MKLVersion extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public MKLVersion() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MKLVersion(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MKLVersion(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MKLVersion position(long position) {
        return (MKLVersion)super.position(position);
    }

    public native int MajorVersion(); public native MKLVersion MajorVersion(int setter);
    public native int MinorVersion(); public native MKLVersion MinorVersion(int setter);
    public native int UpdateVersion(); public native MKLVersion UpdateVersion(int setter);
    public native @Cast("char*") BytePointer ProductStatus(); public native MKLVersion ProductStatus(BytePointer setter);
    public native @Cast("char*") BytePointer Build(); public native MKLVersion Build(BytePointer setter);
    public native @Cast("char*") BytePointer Processor(); public native MKLVersion Processor(BytePointer setter);
    public native @Cast("char*") BytePointer Platform(); public native MKLVersion Platform(BytePointer setter);
}

/* Intel(R) MKL integer types for LP64 and ILP64 */
// #if (!defined(__INTEL_COMPILER)) & defined(_MSC_VER)
//     #define MKL_INT64 __int64
//     #define MKL_UINT64 unsigned __int64
// #else
//     #define MKL_INT64 long long int
//     #define MKL_UINT64 unsigned long long int
// #endif

// #ifdef MKL_ILP64

/* Intel(R) MKL ILP64 integer types */
// #ifndef MKL_INT
//     #define MKL_INT MKL_INT64
// #endif
// #ifndef MKL_UINT
//     #define MKL_UINT MKL_UINT64
// #endif
// #define MKL_LONG MKL_INT64

// #else

/* Intel(R) MKL LP64 integer types */
// #ifndef MKL_INT
//     #define MKL_INT int
// #endif
// #ifndef MKL_UINT
//     #define MKL_UINT unsigned int
// #endif
// #define MKL_LONG long int

// #endif

/* Intel(R) MKL integer types */
// #ifndef MKL_UINT8
//     #define MKL_UINT8 unsigned char
// #endif
// #ifndef MKL_INT8
//     #define MKL_INT8 char
// #endif
// #ifndef MKL_INT16
//     #define MKL_INT16 short
// #endif
// #ifndef MKL_INT32
//     #define MKL_INT32 int
// #endif

/* Intel(R) MKL domain names */
public static final int MKL_DOMAIN_ALL =      0;
public static final int MKL_DOMAIN_BLAS =     1;
public static final int MKL_DOMAIN_FFT =      2;
public static final int MKL_DOMAIN_VML =      3;
public static final int MKL_DOMAIN_PARDISO =  4;

/* Intel(R) MKL CBWR */

/* mkl_cbwr_get options */
public static final int MKL_CBWR_BRANCH = 1;
public static final int MKL_CBWR_ALL =   ~0;

/* flag specific values */
public static final int MKL_CBWR_STRICT =    0x10000;

/* branch specific values */
public static native @MemberGetter int MKL_CBWR_UNSET_ALL();
public static final int MKL_CBWR_UNSET_ALL = MKL_CBWR_UNSET_ALL();
public static final int MKL_CBWR_OFF =            0;
public static final int MKL_CBWR_BRANCH_OFF =     1;
public static final int MKL_CBWR_AUTO =           2;
public static final int MKL_CBWR_COMPATIBLE =     3;
public static final int MKL_CBWR_SSE2 =           4;
public static final int MKL_CBWR_SSSE3 =          6;
public static final int MKL_CBWR_SSE4_1 =         7;
public static final int MKL_CBWR_SSE4_2 =         8;
public static final int MKL_CBWR_AVX =            9;
public static final int MKL_CBWR_AVX2 =          10;
public static final int MKL_CBWR_AVX512_MIC =    11;
public static final int MKL_CBWR_AVX512 =        12;
public static final int MKL_CBWR_AVX512_MIC_E1 = 13;
public static final int MKL_CBWR_AVX512_E1 =     14;

/* error codes */
public static final int MKL_CBWR_SUCCESS =                   0;
public static final int MKL_CBWR_ERR_INVALID_SETTINGS =     -1;
public static final int MKL_CBWR_ERR_INVALID_INPUT =        -2;
public static final int MKL_CBWR_ERR_UNSUPPORTED_BRANCH =   -3;
public static final int MKL_CBWR_ERR_UNKNOWN_BRANCH =       -4;
public static final int MKL_CBWR_ERR_MODE_CHANGE_FAILURE =  -8;

/* obsolete */
public static final int MKL_CBWR_SSE3 =           5;

/** enum MKL_LAYOUT */
public static final int
    MKL_ROW_MAJOR = 101,
    MKL_COL_MAJOR = 102;

/** enum MKL_TRANSPOSE */
public static final int
    MKL_NOTRANS = 111,
    MKL_TRANS = 112,
    MKL_CONJTRANS = 113;

/** enum MKL_UPLO */
public static final int
    MKL_UPPER = 121,
    MKL_LOWER = 122;

/** enum MKL_DIAG */
public static final int
    MKL_NONUNIT = 131,
    MKL_UNIT = 132;

/** enum MKL_SIDE */
public static final int
    MKL_LEFT = 141,
    MKL_RIGHT = 142;

/** enum MKL_COMPACT_PACK */
public static final int
    MKL_COMPACT_SSE = 181,
    MKL_COMPACT_AVX = 182,
    MKL_COMPACT_AVX512 = 183;

public static class sgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    sgemm_jit_kernel_t(Pointer p) { super(p); }
    protected sgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, FloatPointer arg1,         FloatPointer arg2,         FloatPointer arg3);
}
public static class dgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    dgemm_jit_kernel_t(Pointer p) { super(p); }
    protected dgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, DoublePointer arg1,        DoublePointer arg2,        DoublePointer arg3);
}
public static class cgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    cgemm_jit_kernel_t(Pointer p) { super(p); }
    protected cgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, MKL_Complex8 arg1,  MKL_Complex8 arg2,  MKL_Complex8 arg3);
}
public static class zgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    zgemm_jit_kernel_t(Pointer p) { super(p); }
    protected zgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, MKL_Complex16 arg1, MKL_Complex16 arg2, MKL_Complex16 arg3);
}

/** enum mkl_jit_status_t */
public static final int
    MKL_JIT_SUCCESS = 0,
    MKL_NO_JIT = 1,
    MKL_JIT_ERROR = 2;

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _MKL_TYPES_H_ */


// Parsed from mkl_trans.h

/*******************************************************************************
* Copyright (c) 2007-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*
!  Content:
!      Intel(R) Math Kernel Library (Intel(R) MKL) include for transposition routines
!******************************************************************************/

// #if !defined(_MKL_TRANS_H)
// #define _MKL_TRANS_H

/* for size_t */
// #include <stddef.h>
// #include "mkl_types.h"

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* In-place transposition routines */

// #define mkl_simatcopy MKL_Simatcopy


// #define mkl_dimatcopy MKL_Dimatcopy


// #define mkl_cimatcopy MKL_Cimatcopy


// #define mkl_zimatcopy MKL_Zimatcopy


/* Out-of-place transposition routines */

// #define mkl_somatcopy MKL_Somatcopy
public static native void MKL_Somatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha,
    @Const FloatPointer A, @Cast("size_t") long lda,
    FloatPointer B, @Cast("size_t") long ldb);
public static native void MKL_Somatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha,
    @Const FloatBuffer A, @Cast("size_t") long lda,
    FloatBuffer B, @Cast("size_t") long ldb);
public static native void MKL_Somatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha,
    @Const float[] A, @Cast("size_t") long lda,
    float[] B, @Cast("size_t") long ldb);

// #define mkl_domatcopy MKL_Domatcopy
public static native void MKL_Domatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha,
    @Const DoublePointer A, @Cast("size_t") long lda,
    DoublePointer B, @Cast("size_t") long ldb);
public static native void MKL_Domatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha,
    @Const DoubleBuffer A, @Cast("size_t") long lda,
    DoubleBuffer B, @Cast("size_t") long ldb);
public static native void MKL_Domatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha,
    @Const double[] A, @Cast("size_t") long lda,
    double[] B, @Cast("size_t") long ldb);

// #define mkl_comatcopy MKL_Comatcopy
public static native void MKL_Comatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @Const @ByVal MKL_Complex8 alpha,
    @Const MKL_Complex8 A, @Cast("size_t") long lda,
    MKL_Complex8 B, @Cast("size_t") long ldb);

// #define mkl_zomatcopy MKL_Zomatcopy
public static native void MKL_Zomatcopy(
    @Cast("char") byte ordering, @Cast("char") byte trans,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @Const @ByVal MKL_Complex16 alpha,
    @Const MKL_Complex16 A, @Cast("size_t") long lda,
    MKL_Complex16 B, @Cast("size_t") long ldb);

/* Out-of-place transposition routines (all-strided case) */

// #define mkl_somatcopy2 MKL_Somatcopy2


// #define mkl_domatcopy2 MKL_Domatcopy2


// #define mkl_comatcopy2 MKL_Comatcopy2


// #define mkl_zomatcopy2 MKL_Zomatcopy2


/* Out-of-place memory movement routines */

// #define mkl_somatadd MKL_Somatadd


// #define mkl_domatadd MKL_Domatadd


// #define mkl_comatadd MKL_Comatadd


// #define mkl_zomatadd MKL_Zomatadd


// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _MKL_TRANS_H */


// Parsed from mkl_cblas.h

/*******************************************************************************
* Copyright (c) 1999-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

/*
!  Content:
!      Intel(R) Math Kernel Library (Intel(R) MKL) CBLAS interface
!******************************************************************************/

// #ifndef __MKL_CBLAS_H__
// #define __MKL_CBLAS_H__
// #include <stddef.h>

// #include "mkl_types.h"


// #ifdef __GNUC__
// #define MKL_DEPRECATED_C __attribute__((deprecated))
// #elif defined(_MSC_VER)
// #ifdef _WIN32
// #define MKL_DEPRECATED_C __declspec(deprecated, dllexport)
// #else
// #define MKL_DEPRECATED_C __declspec(deprecated)
// #endif
// #else
// #pragma message("WARNING: MKL {S,D}GEMM_ALLOC and {S,D}GEMM_FREE were declared deprecated. Use MKL {S,D}GEMM_PACK_GET_SIZE, MKL_MALLOC and MKL_FREE instead")
// #define MKL_DEPRECATED_C
// #endif

// #ifdef __cplusplus            /* Assume C declarations for C++ */
// #endif /* __cplusplus */

// #ifndef MKL_DECLSPEC
// #ifdef _WIN32
// #define MKL_DECLSPEC __declspec(dllexport)
// #else
// #define MKL_DECLSPEC
// #endif
// #endif
/*
 * Enumerated and derived types
 */
// #define CBLAS_INDEX size_t  /* this may vary between platforms */

/** enum CBLAS_LAYOUT */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
/** enum CBLAS_STORAGE */
public static final int CblasPacked = 151;
/** enum CBLAS_IDENTIFIER */
public static final int CblasAMatrix = 161, CblasBMatrix = 162;
/** enum CBLAS_OFFSET */
public static final int CblasRowOffset = 171, CblasColOffset = 172, CblasFixOffset = 173; /* this for backward compatibility with CBLAS_ORDER */

/*
 * ===========================================================================
 * Prototypes for level 1 BLAS functions (complex are recast as routines)
 * ===========================================================================
 */


public static native double cblas_dcabs1(@Const Pointer z);
public static native float cblas_scabs1(@Const Pointer c);

public static native float cblas_sdot(int N, @Const FloatPointer X, int incX,
                  @Const FloatPointer Y, int incY);
public static native float cblas_sdot(int N, @Const FloatBuffer X, int incX,
                  @Const FloatBuffer Y, int incY);
public static native float cblas_sdot(int N, @Const float[] X, int incX,
                  @Const float[] Y, int incY);
public static native float cblas_sdoti(int N, @Const FloatPointer X, @Const IntPointer indx,
                   @Const FloatPointer Y);
public static native float cblas_sdoti(int N, @Const FloatBuffer X, @Const IntBuffer indx,
                   @Const FloatBuffer Y);
public static native float cblas_sdoti(int N, @Const float[] X, @Const int[] indx,
                   @Const float[] Y);
public static native double cblas_ddot(int N, @Const DoublePointer X, int incX,
                  @Const DoublePointer Y, int incY);
public static native double cblas_ddot(int N, @Const DoubleBuffer X, int incX,
                  @Const DoubleBuffer Y, int incY);
public static native double cblas_ddot(int N, @Const double[] X, int incX,
                  @Const double[] Y, int incY);
public static native double cblas_ddoti(int N, @Const DoublePointer X, @Const IntPointer indx,
                   @Const DoublePointer Y);
public static native double cblas_ddoti(int N, @Const DoubleBuffer X, @Const IntBuffer indx,
                   @Const DoubleBuffer Y);
public static native double cblas_ddoti(int N, @Const double[] X, @Const int[] indx,
                   @Const double[] Y);


public static native double cblas_dsdot(int N, @Const FloatPointer X, int incX,
                  @Const FloatPointer Y, int incY);
public static native double cblas_dsdot(int N, @Const FloatBuffer X, int incX,
                  @Const FloatBuffer Y, int incY);
public static native double cblas_dsdot(int N, @Const float[] X, int incX,
                  @Const float[] Y, int incY);

public static native float cblas_sdsdot(int N, float sb, @Const FloatPointer X,
		    int incX, @Const FloatPointer Y, int incY);
public static native float cblas_sdsdot(int N, float sb, @Const FloatBuffer X,
		    int incX, @Const FloatBuffer Y, int incY);
public static native float cblas_sdsdot(int N, float sb, @Const float[] X,
		    int incX, @Const float[] Y, int incY);

/*
 * Functions having prefixes Z and C only
 */
public static native void cblas_cdotu_sub(int N, @Const Pointer X, int incX,
                       @Const Pointer Y, int incY, Pointer dotu);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const IntPointer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const int[] indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotc_sub(int N, @Const Pointer X, int incX,
                       @Const Pointer Y, int incY, Pointer dotc);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const IntPointer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const int[] indx,
                        @Const Pointer Y, Pointer dotui);

public static native void cblas_zdotu_sub(int N, @Const Pointer X, int incX,
                       @Const Pointer Y, int incY, Pointer dotu);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const IntPointer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const int[] indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotc_sub(int N, @Const Pointer X, int incX,
                       @Const Pointer Y, int incY, Pointer dotc);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const IntPointer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                        @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const int[] indx,
                        @Const Pointer Y, Pointer dotui);

/*
 * Functions having prefixes S D SC DZ
 */
public static native float cblas_snrm2(int N, @Const FloatPointer X, int incX);
public static native float cblas_snrm2(int N, @Const FloatBuffer X, int incX);
public static native float cblas_snrm2(int N, @Const float[] X, int incX);
public static native float cblas_sasum(int N, @Const FloatPointer X, int incX);
public static native float cblas_sasum(int N, @Const FloatBuffer X, int incX);
public static native float cblas_sasum(int N, @Const float[] X, int incX);

public static native double cblas_dnrm2(int N, @Const DoublePointer X, int incX);
public static native double cblas_dnrm2(int N, @Const DoubleBuffer X, int incX);
public static native double cblas_dnrm2(int N, @Const double[] X, int incX);
public static native double cblas_dasum(int N, @Const DoublePointer X, int incX);
public static native double cblas_dasum(int N, @Const DoubleBuffer X, int incX);
public static native double cblas_dasum(int N, @Const double[] X, int incX);

public static native float cblas_scnrm2(int N, @Const Pointer X, int incX);
public static native float cblas_scasum(int N, @Const Pointer X, int incX);

public static native double cblas_dznrm2(int N, @Const Pointer X, int incX);
public static native double cblas_dzasum(int N, @Const Pointer X, int incX);


/*
 * Functions having standard 4 prefixes (S D C Z)
 */
public static native @Cast("size_t") long cblas_isamax(int N, @Const FloatPointer X, int incX);
public static native @Cast("size_t") long cblas_isamax(int N, @Const FloatBuffer X, int incX);
public static native @Cast("size_t") long cblas_isamax(int N, @Const float[] X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const DoublePointer X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const DoubleBuffer X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const double[] X, int incX);
public static native @Cast("size_t") long cblas_icamax(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_izamax(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const FloatPointer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const FloatBuffer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const float[] X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const DoublePointer X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const DoubleBuffer X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const double[] X, int incX);
public static native @Cast("size_t") long cblas_icamin(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_izamin(int N, @Const Pointer X, int incX);

/*
 * ===========================================================================
 * Prototypes for level 1 BLAS routines
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (s, d, c, z)
 */
public static native void cblas_sswap(int N, FloatPointer X, int incX,
                 FloatPointer Y, int incY);
public static native void cblas_sswap(int N, FloatBuffer X, int incX,
                 FloatBuffer Y, int incY);
public static native void cblas_sswap(int N, float[] X, int incX,
                 float[] Y, int incY);
public static native void cblas_scopy(int N, @Const FloatPointer X, int incX,
                 FloatPointer Y, int incY);
public static native void cblas_scopy(int N, @Const FloatBuffer X, int incX,
                 FloatBuffer Y, int incY);
public static native void cblas_scopy(int N, @Const float[] X, int incX,
                 float[] Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const FloatPointer X,
                 int incX, FloatPointer Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const FloatBuffer X,
                 int incX, FloatBuffer Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const float[] X,
                 int incX, float[] Y, int incY);
public static native void cblas_saxpby(int N, float alpha, @Const FloatPointer X,
                 int incX, float beta, FloatPointer Y, int incY);
public static native void cblas_saxpby(int N, float alpha, @Const FloatBuffer X,
                 int incX, float beta, FloatBuffer Y, int incY);
public static native void cblas_saxpby(int N, float alpha, @Const float[] X,
                 int incX, float beta, float[] Y, int incY);
public static native void cblas_saxpyi(int N, float alpha, @Const FloatPointer X,
                 @Const IntPointer indx, FloatPointer Y);
public static native void cblas_saxpyi(int N, float alpha, @Const FloatBuffer X,
                 @Const IntBuffer indx, FloatBuffer Y);
public static native void cblas_saxpyi(int N, float alpha, @Const float[] X,
                 @Const int[] indx, float[] Y);
public static native void cblas_sgthr(int N, @Const FloatPointer Y, FloatPointer X,
                                 @Const IntPointer indx);
public static native void cblas_sgthr(int N, @Const FloatBuffer Y, FloatBuffer X,
                                 @Const IntBuffer indx);
public static native void cblas_sgthr(int N, @Const float[] Y, float[] X,
                                 @Const int[] indx);
public static native void cblas_sgthrz(int N, FloatPointer Y, FloatPointer X,
                                 @Const IntPointer indx);
public static native void cblas_sgthrz(int N, FloatBuffer Y, FloatBuffer X,
                                 @Const IntBuffer indx);
public static native void cblas_sgthrz(int N, float[] Y, float[] X,
                                 @Const int[] indx);
public static native void cblas_ssctr(int N, @Const FloatPointer X, @Const IntPointer indx,
                                 FloatPointer Y);
public static native void cblas_ssctr(int N, @Const FloatBuffer X, @Const IntBuffer indx,
                                 FloatBuffer Y);
public static native void cblas_ssctr(int N, @Const float[] X, @Const int[] indx,
                                 float[] Y);
public static native void cblas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native void cblas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native void cblas_srotg(float[] a, float[] b, float[] c, float[] s);

public static native void cblas_dswap(int N, DoublePointer X, int incX,
                 DoublePointer Y, int incY);
public static native void cblas_dswap(int N, DoubleBuffer X, int incX,
                 DoubleBuffer Y, int incY);
public static native void cblas_dswap(int N, double[] X, int incX,
                 double[] Y, int incY);
public static native void cblas_dcopy(int N, @Const DoublePointer X, int incX,
                 DoublePointer Y, int incY);
public static native void cblas_dcopy(int N, @Const DoubleBuffer X, int incX,
                 DoubleBuffer Y, int incY);
public static native void cblas_dcopy(int N, @Const double[] X, int incX,
                 double[] Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const DoublePointer X,
                 int incX, DoublePointer Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const DoubleBuffer X,
                 int incX, DoubleBuffer Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const double[] X,
                 int incX, double[] Y, int incY);
public static native void cblas_daxpby(int N, double alpha, @Const DoublePointer X,
                 int incX, double beta, DoublePointer Y, int incY);
public static native void cblas_daxpby(int N, double alpha, @Const DoubleBuffer X,
                 int incX, double beta, DoubleBuffer Y, int incY);
public static native void cblas_daxpby(int N, double alpha, @Const double[] X,
                 int incX, double beta, double[] Y, int incY);
public static native void cblas_daxpyi(int N, double alpha, @Const DoublePointer X,
                 @Const IntPointer indx, DoublePointer Y);
public static native void cblas_daxpyi(int N, double alpha, @Const DoubleBuffer X,
                 @Const IntBuffer indx, DoubleBuffer Y);
public static native void cblas_daxpyi(int N, double alpha, @Const double[] X,
                 @Const int[] indx, double[] Y);
public static native void cblas_dgthr(int N, @Const DoublePointer Y, DoublePointer X,
                                 @Const IntPointer indx);
public static native void cblas_dgthr(int N, @Const DoubleBuffer Y, DoubleBuffer X,
                                 @Const IntBuffer indx);
public static native void cblas_dgthr(int N, @Const double[] Y, double[] X,
                                 @Const int[] indx);
public static native void cblas_dgthrz(int N, DoublePointer Y, DoublePointer X,
                                 @Const IntPointer indx);
public static native void cblas_dgthrz(int N, DoubleBuffer Y, DoubleBuffer X,
                                 @Const IntBuffer indx);
public static native void cblas_dgthrz(int N, double[] Y, double[] X,
                                 @Const int[] indx);
public static native void cblas_dsctr(int N, @Const DoublePointer X, @Const IntPointer indx,
                                 DoublePointer Y);
public static native void cblas_dsctr(int N, @Const DoubleBuffer X, @Const IntBuffer indx,
                                 DoubleBuffer Y);
public static native void cblas_dsctr(int N, @Const double[] X, @Const int[] indx,
                                 double[] Y);
public static native void cblas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native void cblas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native void cblas_drotg(double[] a, double[] b, double[] c, double[] s);

public static native void cblas_cswap(int N, Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_ccopy(int N, @Const Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_caxpy(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, Pointer Y, int incY);
public static native void cblas_caxpby(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const IntPointer indx, Pointer Y);
public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const IntBuffer indx, Pointer Y);
public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const int[] indx, Pointer Y);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const IntPointer indx);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const IntBuffer indx);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const int[] indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                                 @Const IntPointer indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                                 @Const IntBuffer indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                                 @Const int[] indx);
public static native void cblas_csctr(int N, @Const Pointer X, @Const IntPointer indx,
                                 Pointer Y);
public static native void cblas_csctr(int N, @Const Pointer X, @Const IntBuffer indx,
                                 Pointer Y);
public static native void cblas_csctr(int N, @Const Pointer X, @Const int[] indx,
                                 Pointer Y);
public static native void cblas_crotg(Pointer a, @Const Pointer b, FloatPointer c, Pointer s);
public static native void cblas_crotg(Pointer a, @Const Pointer b, FloatBuffer c, Pointer s);
public static native void cblas_crotg(Pointer a, @Const Pointer b, float[] c, Pointer s);

public static native void cblas_zswap(int N, Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_zcopy(int N, @Const Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_zaxpy(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, Pointer Y, int incY);
public static native void cblas_zaxpby(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const IntPointer indx, Pointer Y);
public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const IntBuffer indx, Pointer Y);
public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                 @Const int[] indx, Pointer Y);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const IntPointer indx);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const IntBuffer indx);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                                 @Const int[] indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                                 @Const IntPointer indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                                 @Const IntBuffer indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                                 @Const int[] indx);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const IntPointer indx,
                                 Pointer Y);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const IntBuffer indx,
                                 Pointer Y);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const int[] indx,
                                 Pointer Y);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, DoublePointer c, Pointer s);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, DoubleBuffer c, Pointer s);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, double[] c, Pointer s);

/*
 * Routines with S and D prefix only
 */
public static native void cblas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native void cblas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native void cblas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);
public static native void cblas_srot(int N, FloatPointer X, int incX,
                FloatPointer Y, int incY, float c, float s);
public static native void cblas_srot(int N, FloatBuffer X, int incX,
                FloatBuffer Y, int incY, float c, float s);
public static native void cblas_srot(int N, float[] X, int incX,
                float[] Y, int incY, float c, float s);
public static native void cblas_sroti(int N, FloatPointer X, @Const IntPointer indx,
                FloatPointer Y, float c, float s);
public static native void cblas_sroti(int N, FloatBuffer X, @Const IntBuffer indx,
                FloatBuffer Y, float c, float s);
public static native void cblas_sroti(int N, float[] X, @Const int[] indx,
                float[] Y, float c, float s);
public static native void cblas_srotm(int N, FloatPointer X, int incX,
                FloatPointer Y, int incY, @Const FloatPointer P);
public static native void cblas_srotm(int N, FloatBuffer X, int incX,
                FloatBuffer Y, int incY, @Const FloatBuffer P);
public static native void cblas_srotm(int N, float[] X, int incX,
                float[] Y, int incY, @Const float[] P);

public static native void cblas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1, double b2, DoublePointer P);
public static native void cblas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1, double b2, DoubleBuffer P);
public static native void cblas_drotmg(double[] d1, double[] d2, double[] b1, double b2, double[] P);
public static native void cblas_drot(int N, DoublePointer X, int incX,
                DoublePointer Y, int incY, double c, double s);
public static native void cblas_drot(int N, DoubleBuffer X, int incX,
                DoubleBuffer Y, int incY, double c, double s);
public static native void cblas_drot(int N, double[] X, int incX,
                double[] Y, int incY, double c, double s);
public static native void cblas_drotm(int N, DoublePointer X, int incX,
                DoublePointer Y, int incY, @Const DoublePointer P);
public static native void cblas_drotm(int N, DoubleBuffer X, int incX,
                DoubleBuffer Y, int incY, @Const DoubleBuffer P);
public static native void cblas_drotm(int N, double[] X, int incX,
                double[] Y, int incY, @Const double[] P);
public static native void cblas_droti(int N, DoublePointer X, @Const IntPointer indx,
                DoublePointer Y, double c, double s);
public static native void cblas_droti(int N, DoubleBuffer X, @Const IntBuffer indx,
                DoubleBuffer Y, double c, double s);
public static native void cblas_droti(int N, double[] X, @Const int[] indx,
                double[] Y, double c, double s);

/*
 * Routines with CS and ZD prefix only
 */
public static native void cblas_csrot(int N, Pointer X, int incX,
                 Pointer Y, int incY, float c, float s);
public static native void cblas_zdrot(int N, Pointer X, int incX,
                 Pointer Y, int incY, double c, double s);

/*
 * Routines with S D C Z CS and ZD prefixes
 */
public static native void cblas_sscal(int N, float alpha, FloatPointer X, int incX);
public static native void cblas_sscal(int N, float alpha, FloatBuffer X, int incX);
public static native void cblas_sscal(int N, float alpha, float[] X, int incX);
public static native void cblas_dscal(int N, double alpha, DoublePointer X, int incX);
public static native void cblas_dscal(int N, double alpha, DoubleBuffer X, int incX);
public static native void cblas_dscal(int N, double alpha, double[] X, int incX);
public static native void cblas_cscal(int N, @Const Pointer alpha, Pointer X, int incX);
public static native void cblas_zscal(int N, @Const Pointer alpha, Pointer X, int incX);
public static native void cblas_csscal(int N, float alpha, Pointer X, int incX);
public static native void cblas_zdscal(int N, double alpha, Pointer X, int incX);

/*
 * ===========================================================================
 * Prototypes for level 2 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 @Const FloatPointer X, int incX, float beta,
                 FloatPointer Y, int incY);
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 @Const FloatBuffer X, int incX, float beta,
                 FloatBuffer Y, int incY);
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 @Const float[] X, int incX, float beta,
                 float[] Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const FloatPointer A, int lda, @Const FloatPointer X,
                 int incX, float beta, FloatPointer Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const FloatBuffer A, int lda, @Const FloatBuffer X,
                 int incX, float beta, FloatBuffer Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const float[] A, int lda, @Const float[] X,
                 int incX, float beta, float[] Y, int incY);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer Ap, FloatPointer X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer Ap, FloatBuffer X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] Ap, float[] X, int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer A, int lda, FloatPointer X,
                 int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer A, int lda, FloatBuffer X,
                 int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] A, int lda, float[] X,
                 int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer Ap, FloatPointer X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer Ap, FloatBuffer X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] Ap, float[] X, int incX);

public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 @Const DoublePointer X, int incX, double beta,
                 DoublePointer Y, int incY);
public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 @Const DoubleBuffer X, int incX, double beta,
                 DoubleBuffer Y, int incY);
public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 @Const double[] X, int incX, double beta,
                 double[] Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const DoublePointer A, int lda, @Const DoublePointer X,
                 int incX, double beta, DoublePointer Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const DoubleBuffer A, int lda, @Const DoubleBuffer X,
                 int incX, double beta, DoubleBuffer Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const double[] A, int lda, @Const double[] X,
                 int incX, double beta, double[] Y, int incY);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer Ap, DoublePointer X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer Ap, DoubleBuffer X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] Ap, double[] X, int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer A, int lda, DoublePointer X,
                 int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer A, int lda, DoubleBuffer X,
                 int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] A, int lda, double[] X,
                 int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer Ap, DoublePointer X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer Ap, DoubleBuffer X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] Ap, double[] X, int incX);

public static native void cblas_cgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer X, int incX, @Const Pointer beta,
                 Pointer Y, int incY);
public static native void cblas_cgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, @Const Pointer alpha,
                 @Const Pointer A, int lda, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_ctrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);
public static native void cblas_ctrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda, Pointer X,
                 int incX);
public static native void cblas_ctbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);

public static native void cblas_zgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer X, int incX, @Const Pointer beta,
                 Pointer Y, int incY);
public static native void cblas_zgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, @Const Pointer alpha,
                 @Const Pointer A, int lda, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_ztrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);
public static native void cblas_ztrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda, Pointer X,
                 int incX);
public static native void cblas_ztbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);


/*
 * Routines with S and D prefixes only
 */
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] A,
                 int lda, @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const float[] A,
                 int lda, @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer Ap,
                 @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer Ap,
                 @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] Ap,
                 @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const FloatPointer X, int incX,
                @Const FloatPointer Y, int incY, FloatPointer A, int lda);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const FloatBuffer X, int incX,
                @Const FloatBuffer Y, int incY, FloatBuffer A, int lda);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const float[] X, int incX,
                @Const float[] Y, int incY, float[] A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, FloatPointer A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, FloatBuffer A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, float[] A, int lda);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, FloatPointer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, FloatBuffer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, float[] Ap);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, @Const FloatPointer Y, int incY, FloatPointer A,
                int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, @Const FloatBuffer Y, int incY, FloatBuffer A,
                int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, @Const float[] Y, int incY, float[] A,
                int lda);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, @Const FloatPointer Y, int incY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, @Const FloatBuffer Y, int incY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, @Const float[] Y, int incY, float[] A);

public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] A,
                 int lda, @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const double[] A,
                 int lda, @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer Ap,
                 @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer Ap,
                 @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] Ap,
                 @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const DoublePointer X, int incX,
                @Const DoublePointer Y, int incY, DoublePointer A, int lda);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const DoubleBuffer X, int incX,
                @Const DoubleBuffer Y, int incY, DoubleBuffer A, int lda);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const double[] X, int incX,
                @Const double[] Y, int incY, double[] A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, DoublePointer A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, DoubleBuffer A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, double[] A, int lda);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, DoublePointer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, DoubleBuffer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, double[] Ap);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, @Const DoublePointer Y, int incY, DoublePointer A,
                int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, @Const DoubleBuffer Y, int incY, DoubleBuffer A,
                int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, @Const double[] Y, int incY, double[] A,
                int lda);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, @Const DoublePointer Y, int incY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, @Const DoubleBuffer Y, int incY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, @Const double[] Y, int incY, double[] A);

/*
 * Routines with C and Z prefixes only
 */
public static native void cblas_chemv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_chbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_chpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer Ap,
                 @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_cgeru(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_cgerc(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_cher(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const Pointer X, int incX,
                Pointer A, int lda);
public static native void cblas_chpr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const Pointer X,
                int incX, Pointer A);
public static native void cblas_cher2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                @Const Pointer alpha, @Const Pointer X, int incX,
                @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_chpr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                @Const Pointer alpha, @Const Pointer X, int incX,
                @Const Pointer Y, int incY, Pointer Ap);

public static native void cblas_zhemv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zhbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zhpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer Ap,
                 @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zgeru(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zgerc(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zher(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const Pointer X, int incX,
                Pointer A, int lda);
public static native void cblas_zhpr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const Pointer X,
                int incX, Pointer A);
public static native void cblas_zher2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                @Const Pointer alpha, @Const Pointer X, int incX,
                @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zhpr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                @Const Pointer alpha, @Const Pointer X, int incX,
                @Const Pointer Y, int incY, Pointer Ap);

/*
 * ===========================================================================
 * Prototypes for level 3 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer B, int ldb,
                 float beta, FloatPointer C, int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer B, int ldb,
                 float beta, FloatBuffer C, int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const float[] A,
                 int lda, @Const float[] B, int ldb,
                 float beta, float[] C, int ldc);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const FloatPointer alpha_Array, @Cast("const float**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const float**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const FloatPointer beta_Array, @Cast("float**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const FloatPointer alpha_Array, @Const @ByPtrPtr FloatPointer A_Array,
                       @Const IntPointer lda_Array, @Const @ByPtrPtr FloatPointer B_Array, @Const IntPointer ldb_Array,
                       @Const FloatPointer beta_Array, @ByPtrPtr FloatPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const FloatBuffer alpha_Array, @Const @ByPtrPtr FloatBuffer A_Array,
                       @Const IntBuffer lda_Array, @Const @ByPtrPtr FloatBuffer B_Array, @Const IntBuffer ldb_Array,
                       @Const FloatBuffer beta_Array, @ByPtrPtr FloatBuffer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const float[] alpha_Array, @Const @ByPtrPtr float[] A_Array,
                       @Const int[] lda_Array, @Const @ByPtrPtr float[] B_Array, @Const int[] ldb_Array,
                       @Const float[] beta_Array, @ByPtrPtr float[] C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  float alpha, @Const FloatPointer A, int lda,
                  @Const FloatPointer B, int ldb, float beta,
                  FloatPointer C, int ldc);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  float alpha, @Const FloatBuffer A, int lda,
                  @Const FloatBuffer B, int ldb, float beta,
                  FloatBuffer C, int ldc);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  float alpha, @Const float[] A, int lda,
                  @Const float[] B, int ldb, float beta,
                  float[] C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 @Const FloatPointer B, int ldb, float beta,
                 FloatPointer C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 @Const FloatBuffer B, int ldb, float beta,
                 FloatBuffer C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 @Const float[] B, int ldb, float beta,
                 float[] C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatPointer A, int lda,
                 float beta, FloatPointer C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatBuffer A, int lda,
                 float beta, FloatBuffer C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const float[] A, int lda,
                 float beta, float[] C, int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const FloatPointer A, int lda,
                  @Const FloatPointer B, int ldb, float beta,
                  FloatPointer C, int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const FloatBuffer A, int lda,
                  @Const FloatBuffer B, int ldb, float beta,
                  FloatBuffer C, int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const float[] A, int lda,
                  @Const float[] B, int ldb, float beta,
                  float[] C, int ldc);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 FloatPointer B, int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 FloatBuffer B, int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 float[] B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 FloatPointer B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 FloatBuffer B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 float[] B, int ldb);


public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer B, int ldb,
                 double beta, DoublePointer C, int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer B, int ldb,
                 double beta, DoubleBuffer C, int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const double[] A,
                 int lda, @Const double[] B, int ldb,
                 double beta, double[] C, int ldc);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const DoublePointer alpha_Array, @Cast("const double**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const double**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const DoublePointer beta_Array, @Cast("double**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const DoublePointer alpha_Array, @Const @ByPtrPtr DoublePointer A_Array,
                       @Const IntPointer lda_Array, @Const @ByPtrPtr DoublePointer B_Array, @Const IntPointer ldb_Array,
                       @Const DoublePointer beta_Array, @ByPtrPtr DoublePointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const DoubleBuffer alpha_Array, @Const @ByPtrPtr DoubleBuffer A_Array,
                       @Const IntBuffer lda_Array, @Const @ByPtrPtr DoubleBuffer B_Array, @Const IntBuffer ldb_Array,
                       @Const DoubleBuffer beta_Array, @ByPtrPtr DoubleBuffer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const double[] alpha_Array, @Const @ByPtrPtr double[] A_Array,
                       @Const int[] lda_Array, @Const @ByPtrPtr double[] B_Array, @Const int[] ldb_Array,
                       @Const double[] beta_Array, @ByPtrPtr double[] C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  double alpha, @Const DoublePointer A, int lda,
                  @Const DoublePointer B, int ldb, double beta,
                  DoublePointer C, int ldc);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  double alpha, @Const DoubleBuffer A, int lda,
                  @Const DoubleBuffer B, int ldb, double beta,
                  DoubleBuffer C, int ldc);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  double alpha, @Const double[] A, int lda,
                  @Const double[] B, int ldb, double beta,
                  double[] C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 @Const DoublePointer B, int ldb, double beta,
                 DoublePointer C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 @Const DoubleBuffer B, int ldb, double beta,
                 DoubleBuffer C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 @Const double[] B, int ldb, double beta,
                 double[] C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoublePointer A, int lda,
                 double beta, DoublePointer C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoubleBuffer A, int lda,
                 double beta, DoubleBuffer C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const double[] A, int lda,
                 double beta, double[] C, int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const DoublePointer A, int lda,
                  @Const DoublePointer B, int ldb, double beta,
                  DoublePointer C, int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const DoubleBuffer A, int lda,
                  @Const DoubleBuffer B, int ldb, double beta,
                  DoubleBuffer C, int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const double[] A, int lda,
                  @Const double[] B, int ldb, double beta,
                  double[] C, int ldc);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 DoublePointer B, int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 DoubleBuffer B, int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 double[] B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 DoublePointer B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 DoubleBuffer B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 double[] B, int ldb);


public static native void cblas_cgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_cgemm3m(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                         @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                         int group_count, @Const IntBuffer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                         @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                         int group_count, @Const int[] group_size);
public static native void cblas_cgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_csymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_csyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_csyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_ctrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ctrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);


public static native void cblas_zgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zgemm3m(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                         @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                         int group_count, @Const IntBuffer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                         @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                         int group_count, @Const int[] group_size);
public static native void cblas_zgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
		          int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_zsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_zsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_ztrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ztrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);


/*
 * Routines with prefixes C and Z only
 */
public static native void cblas_chemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_cherk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const Pointer A, int lda,
                 float beta, Pointer C, int ldc);
public static native void cblas_cher2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, float beta,
                  Pointer C, int ldc);

public static native void cblas_zhemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_zherk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const Pointer A, int lda,
                 double beta, Pointer C, int ldc);
public static native void cblas_zher2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, double beta,
                  Pointer C, int ldc);

/*
 * Routines with prefixes S and D only
 */
public static native @Deprecated FloatPointer cblas_sgemm_alloc(@Cast("const CBLAS_IDENTIFIER") int identifier,
                 int M, int N, int K);

public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, float alpha, @Const FloatPointer src,
                 int ld, FloatPointer dest);
public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, float alpha, @Const FloatBuffer src,
                 int ld, FloatBuffer dest);
public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, float alpha, @Const float[] src,
                 int ld, float[] dest);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const FloatPointer A,
                 int lda, @Const FloatPointer B, int ldb,
                 float beta, FloatPointer C, int ldc);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer B, int ldb,
                 float beta, FloatBuffer C, int ldc);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const float[] A,
                 int lda, @Const float[] B, int ldb,
                 float beta, float[] C, int ldc);
public static native @Deprecated void cblas_sgemm_free(FloatPointer dest);
public static native @Deprecated void cblas_sgemm_free(FloatBuffer dest);
public static native @Deprecated void cblas_sgemm_free(float[] dest);
public static native @Deprecated DoublePointer cblas_dgemm_alloc(@Cast("const CBLAS_IDENTIFIER") int identifier,
                 int M, int N, int K);

public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, double alpha, @Const DoublePointer src,
                 int ld, DoublePointer dest);
public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, double alpha, @Const DoubleBuffer src,
                 int ld, DoubleBuffer dest);
public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                 int K, double alpha, @Const double[] src,
                 int ld, double[] dest);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const DoublePointer A,
                 int lda, @Const DoublePointer B, int ldb,
                 double beta, DoublePointer C, int ldc);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer B, int ldb,
                 double beta, DoubleBuffer C, int ldc);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                 int TransB, int M, int N,
                 int K, @Const double[] A,
                 int lda, @Const double[] B, int ldb,
                 double beta, double[] C, int ldc);
public static native @Deprecated void cblas_dgemm_free(DoublePointer dest);
public static native @Deprecated void cblas_dgemm_free(DoubleBuffer dest);
public static native @Deprecated void cblas_dgemm_free(double[] dest);

/*
 * Integer Routines
 */
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const ShortPointer A, int lda, short ao,
                          @Const ShortPointer B, int ldb, short bo, float beta,
                          IntPointer C, int ldc, @Const IntPointer cb);
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const ShortBuffer A, int lda, short ao,
                          @Const ShortBuffer B, int ldb, short bo, float beta,
                          IntBuffer C, int ldc, @Const IntBuffer cb);
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const short[] A, int lda, short ao,
                          @Const short[] B, int ldb, short bo, float beta,
                          int[] C, int ldc, @Const int[] cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const Pointer A, int lda, byte ao,
                          @Const Pointer B, int ldb, byte bo, float beta,
                          IntPointer C, int ldc, @Const IntPointer cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const Pointer A, int lda, byte ao,
                          @Const Pointer B, int ldb, byte bo, float beta,
                          IntBuffer C, int ldc, @Const IntBuffer cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const Pointer A, int lda, byte ao,
                          @Const Pointer B, int ldb, byte bo, float beta,
                          int[] C, int ldc, @Const int[] cb);










/*
 * Jit routines
 */ 
// #ifndef mkl_jit_create_dgemm
// #define mkl_jit_create_dgemm mkl_cblas_jit_create_dgemm
// #endif


// #ifndef mkl_jit_create_sgemm
// #define mkl_jit_create_sgemm mkl_cblas_jit_create_sgemm
// #endif

// #ifndef mkl_jit_create_cgemm
// #define mkl_jit_create_cgemm mkl_cblas_jit_create_cgemm
// #endif


// #ifndef mkl_jit_create_zgemm
// #define mkl_jit_create_zgemm mkl_cblas_jit_create_zgemm
// #endif











// #ifdef __cplusplus
// #endif    /* __cplusplus */

// #endif    /* __MKL_CBLAS_H__ */


// Parsed from mkl_dnn_types.h

/*******************************************************************************
* Copyright (c) 2015-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

// #ifndef _MKL_DNN_TYPES_H
// #define _MKL_DNN_TYPES_H

// #include <stdlib.h>

// #if defined(__cplusplus_cli)
@Opaque public static class _uniPrimitive_s extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public _uniPrimitive_s() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public _uniPrimitive_s(Pointer p) { super(p); }
}
@Opaque public static class _dnnLayout_s extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public _dnnLayout_s() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public _dnnLayout_s(Pointer p) { super(p); }
}
// #endif
@Namespace @Name("void") @Opaque public static class dnnPrimitiveAttributes_t extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public dnnPrimitiveAttributes_t() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public dnnPrimitiveAttributes_t(Pointer p) { super(p); }
}

public static final int DNN_MAX_DIMENSION =       32;
public static final int DNN_QUERY_MAX_LENGTH =    128;

/** enum dnnError_t */
public static final int
    E_SUCCESS                   = 0,
    E_INCORRECT_INPUT_PARAMETER = -1,
    E_UNEXPECTED_NULL_POINTER   = -2,
    E_MEMORY_ERROR              = -3,
    E_UNSUPPORTED_DIMENSION     = -4,
    E_UNIMPLEMENTED             = -127;

/** enum dnnAlgorithm_t */
public static final int
    /** GEMM base convolution (unimplemented) */
    dnnAlgorithmConvolutionGemm = 0,
    /** Direct convolution */
    dnnAlgorithmConvolutionDirect = 1,
    /** FFT based convolution (unimplemented) */
    dnnAlgorithmConvolutionFFT = 2,
    /** Maximum pooling */
    dnnAlgorithmPoolingMax = 3,
    /** Minimum pooling */
    dnnAlgorithmPoolingMin = 4,
    /** Average pooling (padded values are not taken into account) */
    dnnAlgorithmPoolingAvgExcludePadding = 5,
    /** Alias for average pooling (padded values are not taken into account) */
    dnnAlgorithmPoolingAvg = dnnAlgorithmPoolingAvgExcludePadding,
    /** Average pooling (padded values are taken into account) */
    dnnAlgorithmPoolingAvgIncludePadding = dnnAlgorithmPoolingAvgExcludePadding + 1;

/** enum dnnResourceType_t */
public static final int
    dnnResourceSrc            = 0,
    dnnResourceFrom           = 0,
    dnnResourceDst            = 1,
    dnnResourceTo             = 1,
    dnnResourceFilter         = 2,
    dnnResourceScaleShift     = 2,
    dnnResourceBias           = 3,
    dnnResourceMean           = 3,
    dnnResourceDiffSrc        = 4,
    dnnResourceDiffFilter     = 5,
    dnnResourceDiffScaleShift = 5,
    dnnResourceDiffBias       = 6,
    dnnResourceVariance       = 6,
    dnnResourceDiffDst        = 7,
    dnnResourceWorkspace      = 8,
    dnnResourceMultipleSrc    = 16,
    dnnResourceMultipleDst    = 24,
    dnnResourceNumber         = 32;

/** enum dnnBorder_t */
public static final int
    dnnBorderZeros          = 0x0,
    dnnBorderZerosAsymm     = 0x100,
    dnnBorderExtrapolation  = 0x3;

/** enum dnnBatchNormalizationFlag_t */
public static final int
    dnnUseInputMeanVariance = 0x1,
    dnnUseScaleShift        = 0x2;

// #endif


// Parsed from mkl_dnn.h

/*******************************************************************************
* Copyright (c) 2015-2019, Intel Corporation
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*       this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of Intel Corporation nor the names of its contributors
*       may be used to endorse or promote products derived from this software
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

// #ifndef _MKL_DNN_H
// #define _MKL_DNN_H

// #include <stdarg.h>
// #include <stddef.h>

// #include "mkl_dnn_types.h"

// #ifdef __cplusplus
// #endif

/*******************************************************************************
 * F32 section: single precision
 ******************************************************************************/

public static native @Cast("dnnError_t") int dnnLayoutCreate_F32(
        @ByPtrPtr _dnnLayout_s pLayout, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer size, @Cast("const size_t*") SizeTPointer strides);
public static native @Cast("dnnError_t") int dnnLayoutCreateFromPrimitive_F32(
        @ByPtrPtr _dnnLayout_s pLayout, _uniPrimitive_s primitive, @Cast("dnnResourceType_t") int type);

/** Returns the size of buffer required to serialize dnnLayout_t structure. */
public static native @Cast("size_t") long dnnLayoutSerializationBufferSize_F32();

/** Serializes given \p layout into buffer \p buf. User-provided buffer \p buf
 * should have enough space to store dnnLayout_t structure.
 * @see dnnLayoutSerializationBufferSize_F32 */
public static native @Cast("dnnError_t") int dnnLayoutSerialize_F32(_dnnLayout_s layout, Pointer buf);

/** Creates new layout restored from previously serialized one. */
public static native @Cast("dnnError_t") int dnnLayoutDeserialize_F32(@ByPtrPtr _dnnLayout_s pLayout, @Const Pointer buf);

public static native @Cast("size_t") long dnnLayoutGetMemorySize_F32(
        _dnnLayout_s layout);
public static native int dnnLayoutCompare_F32(
        _dnnLayout_s l1, _dnnLayout_s l2);
public static native @Cast("dnnError_t") int dnnAllocateBuffer_F32(
        @Cast("void**") PointerPointer pPtr, _dnnLayout_s layout);
public static native @Cast("dnnError_t") int dnnAllocateBuffer_F32(
        @Cast("void**") @ByPtrPtr Pointer pPtr, _dnnLayout_s layout);
public static native @Cast("dnnError_t") int dnnReleaseBuffer_F32(
        Pointer ptr);
public static native @Cast("dnnError_t") int dnnLayoutDelete_F32(
        _dnnLayout_s layout);

public static native @Cast("dnnError_t") int dnnPrimitiveAttributesCreate_F32(
        @ByPtrPtr dnnPrimitiveAttributes_t attributes);
public static native @Cast("dnnError_t") int dnnPrimitiveAttributesDestroy_F32(
        dnnPrimitiveAttributes_t attributes);
public static native @Cast("dnnError_t") int dnnPrimitiveGetAttributes_F32(
        _uniPrimitive_s primitive,
        @ByPtrPtr dnnPrimitiveAttributes_t attributes);

public static native @Cast("dnnError_t") int dnnExecute_F32(
        _uniPrimitive_s primitive, @Cast("void**") PointerPointer resources);
public static native @Cast("dnnError_t") int dnnExecute_F32(
        _uniPrimitive_s primitive, @Cast("void**") @ByPtrPtr Pointer resources);
public static native @Cast("dnnError_t") int dnnExecuteAsync_F32(
        _uniPrimitive_s primitive, @Cast("void**") PointerPointer resources);
public static native @Cast("dnnError_t") int dnnExecuteAsync_F32(
        _uniPrimitive_s primitive, @Cast("void**") @ByPtrPtr Pointer resources);
public static native @Cast("dnnError_t") int dnnWaitFor_F32(
        _uniPrimitive_s primitive);
public static native @Cast("dnnError_t") int dnnDelete_F32(
        _uniPrimitive_s primitive);

public static native @Cast("dnnError_t") int dnnConversionCreate_F32(
        @ByPtrPtr _uniPrimitive_s pConversion, _dnnLayout_s from, _dnnLayout_s to);
public static native @Cast("dnnError_t") int dnnConversionExecute_F32(
        _uniPrimitive_s conversion, Pointer from, Pointer to);

public static native @Cast("dnnError_t") int dnnSumCreate_F32(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, FloatPointer coefficients);
public static native @Cast("dnnError_t") int dnnSumCreate_F32(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, FloatBuffer coefficients);
public static native @Cast("dnnError_t") int dnnSumCreate_F32(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, float[] coefficients);
public static native @Cast("dnnError_t") int dnnConcatCreate_F32(
        @ByPtrPtr _uniPrimitive_s pConcat, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSrcTensors, @ByPtrPtr _dnnLayout_s src);
public static native @Cast("dnnError_t") int dnnSplitCreate_F32(
        @ByPtrPtr _uniPrimitive_s pSplit, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nDstTensors,
        _dnnLayout_s layout, @Cast("size_t*") SizeTPointer dstChannelSize);
public static native @Cast("dnnError_t") int dnnScaleCreate_F32(
        @ByPtrPtr _uniPrimitive_s pScale,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float alpha);

public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer dstSize);

public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer dstSize);

public static native @Cast("dnnError_t") int dnnReLUCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pRelu,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float negativeSlope);
public static native @Cast("dnnError_t") int dnnReLUCreateBackward_F32(
        @ByPtrPtr _uniPrimitive_s pRelu,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s diffLayout, _dnnLayout_s dataLayout, float negativeSlope);

public static native @Cast("dnnError_t") int dnnLRNCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pLrn,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, @Cast("size_t") long kernel_size, float alpha, float beta, float k);
public static native @Cast("dnnError_t") int dnnLRNCreateBackward_F32(
        @ByPtrPtr _uniPrimitive_s pLrn,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s diffLayout, _dnnLayout_s dataLayout, @Cast("size_t") long kernel_size, float alpha, float beta, float k);

public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float eps);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackwardScaleShift_F32(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float eps);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float eps);

public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateForward_v2_F32(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float eps,
        @Cast("unsigned int") int flags);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackward_v2_F32(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, float eps,
        @Cast("unsigned int") int flags);

public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F32(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);

public static native @Cast("dnnError_t") int dnnInnerProductCreateForward_F32(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateForwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardData_F32(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardFilter_F32(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardBias_F32(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer dstSize);

/*******************************************************************************
 * F64 section: double precision
 ******************************************************************************/

public static native @Cast("dnnError_t") int dnnLayoutCreate_F64(
        @ByPtrPtr _dnnLayout_s pLayout, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer size, @Cast("const size_t*") SizeTPointer strides);
public static native @Cast("dnnError_t") int dnnLayoutCreateFromPrimitive_F64(
        @ByPtrPtr _dnnLayout_s pLayout, _uniPrimitive_s primitive, @Cast("dnnResourceType_t") int type);

/** Returns the size of buffer required to serialize dnnLayout_t structure. */
public static native @Cast("size_t") long dnnLayoutSerializationBufferSize_F64();

/** Serializes given \p layout into buffer \p buf. User-provided buffer \p buf
 * should have enough space to store dnnLayout_t structure.
 * @see dnnLayoutSerializationBufferSize_F64 */
public static native @Cast("dnnError_t") int dnnLayoutSerialize_F64(_dnnLayout_s layout, Pointer buf);

/** Creates new layout restored from previously serialized one. */
public static native @Cast("dnnError_t") int dnnLayoutDeserialize_F64(@ByPtrPtr _dnnLayout_s pLayout, @Const Pointer buf);

public static native @Cast("size_t") long dnnLayoutGetMemorySize_F64(
        _dnnLayout_s layout);
public static native int dnnLayoutCompare_F64(
        _dnnLayout_s l1, _dnnLayout_s l2);
public static native @Cast("dnnError_t") int dnnAllocateBuffer_F64(
        @Cast("void**") PointerPointer pPtr, _dnnLayout_s layout);
public static native @Cast("dnnError_t") int dnnAllocateBuffer_F64(
        @Cast("void**") @ByPtrPtr Pointer pPtr, _dnnLayout_s layout);
public static native @Cast("dnnError_t") int dnnReleaseBuffer_F64(
        Pointer ptr);
public static native @Cast("dnnError_t") int dnnLayoutDelete_F64(
        _dnnLayout_s layout);

public static native @Cast("dnnError_t") int dnnPrimitiveAttributesCreate_F64(
        @ByPtrPtr dnnPrimitiveAttributes_t attributes);
public static native @Cast("dnnError_t") int dnnPrimitiveAttributesDestroy_F64(
        dnnPrimitiveAttributes_t attributes);
public static native @Cast("dnnError_t") int dnnPrimitiveGetAttributes_F64(
        _uniPrimitive_s primitive,
        @ByPtrPtr dnnPrimitiveAttributes_t attributes);

public static native @Cast("dnnError_t") int dnnExecute_F64(
        _uniPrimitive_s primitive, @Cast("void**") PointerPointer resources);
public static native @Cast("dnnError_t") int dnnExecute_F64(
        _uniPrimitive_s primitive, @Cast("void**") @ByPtrPtr Pointer resources);
public static native @Cast("dnnError_t") int dnnExecuteAsync_F64(
        _uniPrimitive_s primitive, @Cast("void**") PointerPointer resources);
public static native @Cast("dnnError_t") int dnnExecuteAsync_F64(
        _uniPrimitive_s primitive, @Cast("void**") @ByPtrPtr Pointer resources);
public static native @Cast("dnnError_t") int dnnWaitFor_F64(
        _uniPrimitive_s primitive);
public static native @Cast("dnnError_t") int dnnDelete_F64(
        _uniPrimitive_s primitive);

public static native @Cast("dnnError_t") int dnnConversionCreate_F64(
        @ByPtrPtr _uniPrimitive_s pConversion, _dnnLayout_s from, _dnnLayout_s to);
public static native @Cast("dnnError_t") int dnnConversionExecute_F64(
        _uniPrimitive_s conversion, Pointer from, Pointer to);

public static native @Cast("dnnError_t") int dnnSumCreate_F64(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, DoublePointer coefficients);
public static native @Cast("dnnError_t") int dnnSumCreate_F64(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, DoubleBuffer coefficients);
public static native @Cast("dnnError_t") int dnnSumCreate_F64(
        @ByPtrPtr _uniPrimitive_s pSum, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSummands,
        _dnnLayout_s layout, double[] coefficients);
public static native @Cast("dnnError_t") int dnnConcatCreate_F64(
         @ByPtrPtr _uniPrimitive_s pConcat, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nSrcTensors, @ByPtrPtr _dnnLayout_s src);
public static native @Cast("dnnError_t") int dnnSplitCreate_F64(
        @ByPtrPtr _uniPrimitive_s pSplit, dnnPrimitiveAttributes_t attributes, @Cast("const size_t") long nDstTensors,
        _dnnLayout_s layout, @Cast("size_t*") SizeTPointer dstChannelSize);
public static native @Cast("dnnError_t") int dnnScaleCreate_F64(
        @ByPtrPtr _uniPrimitive_s pScale,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double alpha);

public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnConvolutionCreateBackwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer dstSize);

public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer srcSize, @Cast("const size_t*") SizeTPointer dstSize, @Cast("const size_t*") SizeTPointer filterSize,
        @Cast("const size_t*") SizeTPointer convolutionStrides, @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnGroupsConvolutionCreateBackwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pConvolution,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int algorithm,
        @Cast("size_t") long groups, @Cast("size_t") long dimension, @Cast("const size_t*") SizeTPointer dstSize);

public static native @Cast("dnnError_t") int dnnReLUCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pRelu,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double negativeSlope);
public static native @Cast("dnnError_t") int dnnReLUCreateBackward_F64(
        @ByPtrPtr _uniPrimitive_s pRelu,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s diffLayout, _dnnLayout_s dataLayout, double negativeSlope);

public static native @Cast("dnnError_t") int dnnLRNCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pLrn,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, @Cast("size_t") long kernel_size, double alpha, double beta, double k);
public static native @Cast("dnnError_t") int dnnLRNCreateBackward_F64(
        @ByPtrPtr _uniPrimitive_s pLrn,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s diffLayout, _dnnLayout_s dataLayout, @Cast("size_t") long kernel_size, double alpha, double beta, double k);

public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double eps);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackwardScaleShift_F64(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double eps);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double eps);

public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateForward_v2_F64(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double eps,
        @Cast("unsigned int") int flags);
public static native @Cast("dnnError_t") int dnnBatchNormalizationCreateBackward_v2_F64(
        @ByPtrPtr _uniPrimitive_s pBatchNormalization,
        dnnPrimitiveAttributes_t attributes,
        _dnnLayout_s dataLayout, double eps,
        @Cast("unsigned int") int flags);

public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntPointer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const IntBuffer inputOffset, @Cast("const dnnBorder_t") int borderType);
public static native @Cast("dnnError_t") int dnnPoolingCreateBackward_F64(
        @ByPtrPtr _uniPrimitive_s pPooling,
        dnnPrimitiveAttributes_t attributes,
        @Cast("dnnAlgorithm_t") int op,
        _dnnLayout_s srcLayout,
        @Cast("const size_t*") SizeTPointer kernelSize, @Cast("const size_t*") SizeTPointer kernelStride,
        @Const int[] inputOffset, @Cast("const dnnBorder_t") int borderType);

public static native @Cast("dnnError_t") int dnnInnerProductCreateForward_F64(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateForwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardData_F64(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardFilter_F64(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer srcSize,
        @Cast("size_t") long outputChannels);
public static native @Cast("dnnError_t") int dnnInnerProductCreateBackwardBias_F64(
        @ByPtrPtr _uniPrimitive_s pInnerProduct,
        dnnPrimitiveAttributes_t attributes,
        @Cast("size_t") long dimensions,
        @Cast("const size_t*") SizeTPointer dstSize);

// #ifdef __cplusplus
// #endif

// #endif


}
