/*******************************************************************************
* Copyright 2006-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

#ifndef _MKL_VML_OMP_VARIANT_H_
#define _MKL_VML_OMP_VARIANT_H_ 1

#include "mkl_types.h"
#include "mkl_omp_variant.h"

#ifdef __cplusplus
extern "C" {
#endif

void MKL_VARIANT_NAME(vm, vsabs)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdabs)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcabs)(const MKL_INT n, const MKL_Complex8 * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzabs)(const MKL_INT n, const MKL_Complex16 * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsabs)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdabs)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcabs)(const MKL_INT n, const MKL_Complex8 * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzabs)(const MKL_INT n, const MKL_Complex16 * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsacos)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdacos)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcacos)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzacos)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsacos)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdacos)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcacos)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzacos)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsacosh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdacosh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcacosh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzacosh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsacosh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdacosh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcacosh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzacosh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsacospi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdacospi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsacospi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdacospi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsadd)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdadd)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcadd)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzadd)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsadd)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdadd)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcadd)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzadd)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vcarg)(const MKL_INT n, const MKL_Complex8 * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzarg)(const MKL_INT n, const MKL_Complex16 * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcarg)(const MKL_INT n, const MKL_Complex8 * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzarg)(const MKL_INT n, const MKL_Complex16 * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsasin)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdasin)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcasin)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzasin)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsasin)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdasin)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcasin)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzasin)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsasinh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdasinh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcasinh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzasinh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsasinh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdasinh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcasinh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzasinh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsasinpi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdasinpi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsasinpi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdasinpi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsatan)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdatan)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcatan)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzatan)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsatan)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdatan)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcatan)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzatan)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsatan2)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdatan2)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsatan2)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdatan2)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsatan2pi)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdatan2pi)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsatan2pi)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdatan2pi)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsatanh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdatanh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcatanh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzatanh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsatanh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdatanh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcatanh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzatanh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsatanpi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdatanpi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsatanpi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdatanpi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscbrt)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcbrt)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscbrt)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcbrt)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscdfnorm)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcdfnorm)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscdfnorm)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcdfnorm)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscdfnorminv)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcdfnorminv)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscdfnorminv)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcdfnorminv)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsceil)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdceil)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsceil)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdceil)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vccis)(const MKL_INT n, const float * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzcis)(const MKL_INT n, const double * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmccis)(const MKL_INT n, const float * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzcis)(const MKL_INT n, const double * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vcconj)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzconj)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcconj)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzconj)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscopysign)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcopysign)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscopysign)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcopysign)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscos)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcos)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vccos)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzcos)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscos)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcos)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmccos)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzcos)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscosd)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcosd)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscosd)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcosd)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscosh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcosh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vccosh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzcosh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscosh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcosh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmccosh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzcosh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vscospi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdcospi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmscospi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdcospi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsdiv)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vddiv)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcdiv)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzdiv)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsdiv)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmddiv)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcdiv)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzdiv)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vserf)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vderf)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmserf)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmderf)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vserfc)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vderfc)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmserfc)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmderfc)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vserfcinv)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vderfcinv)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmserfcinv)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmderfcinv)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vserfinv)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vderfinv)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmserfinv)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmderfinv)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsexp)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdexp)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcexp)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzexp)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsexp)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdexp)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcexp)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzexp)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsexp10)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdexp10)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsexp10)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdexp10)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsexp2)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdexp2)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsexp2)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdexp2)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsexpint1)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdexpint1)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsexpint1)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdexpint1)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsexpm1)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdexpm1)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsexpm1)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdexpm1)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfdim)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfdim)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfdim)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfdim)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfloor)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfloor)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfloor)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfloor)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfmax)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfmax)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfmax)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfmax)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfmin)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfmin)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfmin)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfmin)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfmod)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfmod)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfmod)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfmod)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsfrac)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdfrac)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsfrac)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdfrac)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vshypot)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdhypot)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmshypot)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdhypot)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsinv)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdinv)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsinv)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdinv)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsinvcbrt)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdinvcbrt)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsinvcbrt)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdinvcbrt)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsinvsqrt)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdinvsqrt)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsinvsqrt)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdinvsqrt)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslgamma)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlgamma)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslgamma)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlgamma)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslinearfrac)(const MKL_INT n, const float * a, const float * b, const float c, const float d, const float e, const float f, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlinearfrac)(const MKL_INT n, const double * a, const double * b, const double c, const double d, const double e, const double f, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslinearfrac)(const MKL_INT n, const float * a, const float * b, const float c, const float d, const float e, const float f, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlinearfrac)(const MKL_INT n, const double * a, const double * b, const double c, const double d, const double e, const double f, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsln)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdln)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcln)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzln)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsln)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdln)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcln)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzln)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslog10)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlog10)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vclog10)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzlog10)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslog10)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlog10)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmclog10)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzlog10)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslog1p)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlog1p)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslog1p)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlog1p)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslog2)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlog2)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslog2)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlog2)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vslogb)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdlogb)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmslogb)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdlogb)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsmaxmag)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdmaxmag)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsmaxmag)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdmaxmag)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsminmag)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdminmag)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsminmag)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdminmag)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsmodf)(const MKL_INT n, const float * a, float * y, float * z) NOTHROW;
void MKL_VARIANT_NAME(vm, vdmodf)(const MKL_INT n, const double * a, double * y, double * z) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsmodf)(const MKL_INT n, const float * a, float * y, float * z, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdmodf)(const MKL_INT n, const double * a, double * y, double * z, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsmul)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdmul)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcmul)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzmul)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsmul)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdmul)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcmul)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzmul)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vcmulbyconj)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzmulbyconj)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcmulbyconj)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzmulbyconj)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsnearbyint)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdnearbyint)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsnearbyint)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdnearbyint)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsnextafter)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdnextafter)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsnextafter)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdnextafter)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vspow)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdpow)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcpow)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzpow)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmspow)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdpow)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcpow)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzpow)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vspow2o3)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdpow2o3)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmspow2o3)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdpow2o3)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vspow3o2)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdpow3o2)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmspow3o2)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdpow3o2)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vspowr)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdpowr)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmspowr)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdpowr)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vspowx)(const MKL_INT n, const float * a, const float b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdpowx)(const MKL_INT n, const double * a, const double b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcpowx)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzpowx)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmspowx)(const MKL_INT n, const float * a, const float b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdpowx)(const MKL_INT n, const double * a, const double b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcpowx)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzpowx)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsremainder)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdremainder)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsremainder)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdremainder)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsrint)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdrint)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsrint)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdrint)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vsround)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdround)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmsround)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdround)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssin)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsin)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcsin)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzsin)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssin)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsin)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcsin)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzsin)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssincos)(const MKL_INT n, const float * a, float * y, float * z) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsincos)(const MKL_INT n, const double * a, double * y, double * z) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssincos)(const MKL_INT n, const float * a, float * y, float * z, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsincos)(const MKL_INT n, const double * a, double * y, double * z, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssind)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsind)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssind)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsind)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssinh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsinh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcsinh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzsinh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssinh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsinh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcsinh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzsinh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssinpi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsinpi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssinpi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsinpi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssqr)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsqr)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssqr)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsqr)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssqrt)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsqrt)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcsqrt)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzsqrt)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssqrt)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsqrt)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcsqrt)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzsqrt)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vssub)(const MKL_INT n, const float * a, const float * b, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdsub)(const MKL_INT n, const double * a, const double * b, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vcsub)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vzsub)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmssub)(const MKL_INT n, const float * a, const float * b, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdsub)(const MKL_INT n, const double * a, const double * b, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmcsub)(const MKL_INT n, const MKL_Complex8 * a, const MKL_Complex8 * b, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmzsub)(const MKL_INT n, const MKL_Complex16 * a, const MKL_Complex16 * b, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstan)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtan)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vctan)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vztan)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstan)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtan)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmctan)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmztan)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstand)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtand)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstand)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtand)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstanh)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtanh)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vctanh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vztanh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstanh)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtanh)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmctanh)(const MKL_INT n, const MKL_Complex8 * a, MKL_Complex8 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmztanh)(const MKL_INT n, const MKL_Complex16 * a, MKL_Complex16 * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstanpi)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtanpi)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstanpi)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtanpi)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstgamma)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtgamma)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstgamma)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtgamma)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vstrunc)(const MKL_INT n, const float * a, float * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vdtrunc)(const MKL_INT n, const double * a, double * y) NOTHROW;
void MKL_VARIANT_NAME(vm, vmstrunc)(const MKL_INT n, const float * a, float * y, MKL_INT64 mode) NOTHROW;
void MKL_VARIANT_NAME(vm, vmdtrunc)(const MKL_INT n, const double * a, double * y, MKL_INT64 mode) NOTHROW;

#ifdef __cplusplus
} /* extern "C" */
#endif
#endif /* ifndef _MKL_VML_OMP_VARIANT_H_ */
