/*******************************************************************************
* Copyright 2020-2021 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

#ifndef _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_
#define _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_

namespace oneapi {
namespace mkl {
namespace rng {
namespace device {
namespace detail {
namespace mrg32k3a_impl {

static const std::uint32_t skip_ahead_table[2][193][3][3] = {
    // Matrices for the first part of SkipAhead procedure
    // Matrix for nskip = 2^0:

    { { { 0, 1, 0 }, { 0, 0, 1 }, { 4294156359, 1403580, 0 } },

      // Matrix for nskip = 2^1:

      { { 0, 0, 1 }, { 4294156359, 1403580, 0 }, { 0, 4294156359, 1403580 } },

      // Matrix for nskip = 2^2:

      { { 0, 4294156359, 1403580 },
        { 244671815, 2941890554, 4294156359 },
        { 149925673, 489343630, 2941890554 } },

      // Matrix for nskip = 2^3:

      { { 1527363550, 2758233149, 1831234280 },
        { 4072640363, 939574583, 2758233149 },
        { 2064391165, 3228066636, 939574583 } },

      // Matrix for nskip = 2^4:

      { { 736416029, 2961816100, 342112271 },
        { 387300998, 1062452522, 2961816100 },
        { 2955879160, 340793741, 1062452522 } },

      // Matrix for nskip = 2^5:

      { { 1243502014, 2218748291, 1709215645 },
        { 2019641772, 3847560959, 2218748291 },
        { 3866010231, 2305448679, 3847560959 } },

      // Matrix for nskip = 2^6:

      { { 3241775219, 3453352062, 3721871040 },
        { 4062454730, 3015754, 3453352062 },
        { 919711945, 613405362, 3015754 } },

      // Matrix for nskip = 2^7:

      { { 1955221006, 1414472808, 1746037714 },
        { 3653507277, 1644962013, 1414472808 },
        { 3501544776, 2336229602, 1644962013 } },

      // Matrix for nskip = 2^8:

      { { 1170096663, 49135452, 3441537107 },
        { 1857945175, 1649398389, 49135452 },
        { 333002869, 3109147376, 1649398389 } },

      // Matrix for nskip = 2^9:

      { { 2299034194, 2297111910, 862649200 },
        { 1399961132, 996706937, 2297111910 },
        { 3439056503, 1481993076, 996706937 } },

      // Matrix for nskip = 2^10:

      { { 4146310528, 458782589, 1007330283 },
        { 4241015765, 3979619964, 458782589 },
        { 553886495, 2186897562, 3979619964 } },

      // Matrix for nskip = 2^11:

      { { 3630027893, 2130448350, 292773857 },
        { 1392525159, 1299285967, 2130448350 },
        { 2589171163, 1217405758, 1299285967 } },

      // Matrix for nskip = 2^12:

      { { 892409263, 1999175811, 2979225418 },
        { 1996163538, 2148702503, 1999175811 },
        { 3922720782, 103819730, 2148702503 } },

      // Matrix for nskip = 2^13:

      { { 1586003016, 2114210471, 3240775579 },
        { 2777288607, 1400478398, 2114210471 },
        { 3018215420, 535326008, 1400478398 } },

      // Matrix for nskip = 2^14:

      { { 2188531273, 1783231160, 3576659343 },
        { 1908318389, 379210133, 1783231160 },
        { 554369329, 250053591, 379210133 } },

      // Matrix for nskip = 2^15:

      { { 4022841636, 3951951872, 2143424240 },
        { 1046219306, 1591992468, 3951951872 },
        { 1510277444, 381333958, 1591992468 } },

      // Matrix for nskip = 2^16:

      { { 2256493727, 3715182130, 642697923 },
        { 3615342722, 3975008370, 3715182130 },
        { 2405650329, 754337639, 3975008370 } },

      // Matrix for nskip = 2^17:

      { { 1286664224, 627406673, 963516608 },
        { 1541344588, 460768826, 627406673 },
        { 1089892553, 2717717970, 460768826 } },

      // Matrix for nskip = 2^18:

      { { 2956342842, 3471097641, 2353092905 },
        { 2996150472, 420480221, 3471097641 },
        { 2221681883, 372736411, 420480221 } },

      // Matrix for nskip = 2^19:

      { { 420492906, 153526651, 3499730988 },
        { 2662640502, 3278195133, 153526651 },
        { 4086436419, 2510762118, 3278195133 } },

      // Matrix for nskip = 2^20:

      { { 3310184147, 2228376089, 823220763 },
        { 3992771814, 1693168425, 2228376089 },
        { 2295790366, 1401872772, 1693168425 } },

      // Matrix for nskip = 2^21:

      { { 2529428830, 1497104068, 4253248635 },
        { 3746310018, 630867741, 1497104068 },
        { 627043435, 721725795, 630867741 } },

      // Matrix for nskip = 2^22:

      { { 2571072593, 3039669025, 1591031831 },
        { 526054481, 661344445, 3039669025 },
        { 4246010312, 735391270, 661344445 } },

      // Matrix for nskip = 2^23:

      { { 1847312821, 4042890210, 4241772463 },
        { 606605705, 2644799309, 4042890210 },
        { 2658402822, 1342278931, 2644799309 } },

      // Matrix for nskip = 2^24:

      { { 2409846784, 1096138313, 1416249993 },
        { 1501878241, 138013862, 1096138313 },
        { 1617749306, 1975136163, 138013862 } },

      // Matrix for nskip = 2^25:

      { { 599453422, 73950522, 2965395603 },
        { 55354701, 3855242202, 73950522 },
        { 3981734504, 3354399019, 3855242202 } },

      // Matrix for nskip = 2^26:

      { { 4271076381, 813410089, 3461955319 },
        { 1044920137, 3029005516, 813410089 },
        { 3501837362, 3321539504, 3029005516 } },

      // Matrix for nskip = 2^27:

      { { 3058183515, 941408572, 1783998098 },
        { 1546486080, 4116985007, 941408572 },
        { 2247500745, 1460625377, 4116985007 } },

      // Matrix for nskip = 2^28:

      { { 4216782514, 3352801941, 2315095646 },
        { 639029973, 94451952, 3352801941 },
        { 1242898773, 3964593332, 94451952 } },

      // Matrix for nskip = 2^29:

      { { 2264905138, 1926285644, 1108147171 },
        { 2390706911, 385258225, 1926285644 },
        { 3569882325, 3728744670, 385258225 } },

      // Matrix for nskip = 2^30:

      { { 270679073, 1065683096, 2992662885 },
        { 4196917281, 2886425156, 1065683096 },
        { 749134119, 1849148167, 2886425156 } },

      // Matrix for nskip = 2^31:

      { { 35689930, 1378151623, 951629713 },
        { 673810920, 948843427, 1378151623 },
        { 3808868984, 927013635, 948843427 } },

      // Matrix for nskip = 2^32:

      { { 1891490872, 1130489594, 3734864133 },
        { 1457450350, 3362920032, 1130489594 },
        { 638998846, 1401175590, 3362920032 } },

      // Matrix for nskip = 2^33:

      { { 2254459023, 2384691454, 1730098031 },
        { 2844861718, 1807491073, 2384691454 },
        { 351423668, 1570264155, 1807491073 } },

      // Matrix for nskip = 2^34:

      { { 3047429268, 4245359555, 2449575498 },
        { 1797081212, 1237196477, 4245359555 },
        { 143400628, 3663731096, 1237196477 } },

      // Matrix for nskip = 2^35:

      { { 3313321106, 4263819658, 1047529624 },
        { 3719941673, 3155049403, 4263819658 },
        { 1981313839, 4281524426, 3155049403 } },

      // Matrix for nskip = 2^36:

      { { 2005252417, 3263186729, 1535805957 },
        { 2951515865, 1729281525, 3263186729 },
        { 1141249417, 2268963059, 1729281525 } },

      // Matrix for nskip = 2^37:

      { { 2367065164, 83908466, 4294308508 },
        { 1352516724, 1416676049, 83908466 },
        { 1040867745, 1304732377, 1416676049 } },

      // Matrix for nskip = 2^38:

      { { 3214147257, 1434230503, 2944821434 },
        { 2753040912, 4041536918, 1434230503 },
        { 1317260239, 338830578, 4041536918 } },

      // Matrix for nskip = 2^39:

      { { 300628476, 2054743463, 1499597869 },
        { 1762244284, 1422043015, 2054743463 },
        { 3581125669, 1207561803, 1422043015 } },

      // Matrix for nskip = 2^40:

      { { 4171745404, 4064983592, 1934508265 },
        { 3049723261, 1744636487, 4064983592 },
        { 947753516, 3952135907, 1744636487 } },

      // Matrix for nskip = 2^41:

      { { 1625369148, 3577024659, 2778677259 },
        { 1729967818, 1049600974, 3577024659 },
        { 2089137344, 1569794605, 1049600974 } },

      // Matrix for nskip = 2^42:

      { { 1373068765, 3958611830, 569117280 },
        { 410042396, 3551255470, 3958611830 },
        { 869476379, 1680625376, 3551255470 } },

      // Matrix for nskip = 2^43:

      { { 2108618602, 2543645250, 913717833 },
        { 2111984988, 1012482542, 2543645250 },
        { 2545745615, 3141042890, 1012482542 } },

      // Matrix for nskip = 2^44:

      { { 1157293598, 584852249, 2272893205 },
        { 1631801979, 3013855247, 584852249 },
        { 3977310441, 82049263, 3013855247 } },

      // Matrix for nskip = 2^45:

      { { 3580234334, 3137526662, 2403875621 },
        { 3580869206, 3670086228, 3137526662 },
        { 656744553, 1764904195, 3670086228 } },

      // Matrix for nskip = 2^46:

      { { 2792496861, 3634185196, 3887031679 },
        { 3601823850, 3464838365, 3634185196 },
        { 3136165138, 2842987937, 3464838365 } },

      // Matrix for nskip = 2^47:

      { { 1362557480, 3230022138, 4278720212 },
        { 3427386258, 3848976950, 3230022138 },
        { 2109817045, 2441486578, 3848976950 } },

      // Matrix for nskip = 2^48:

      { { 1198519135, 2007945401, 3868481 },
        { 3335076429, 2082683147, 2007945401 },
        { 2341088247, 888193479, 2082683147 } },

      // Matrix for nskip = 2^49:

      { { 3473925387, 3193380570, 565138859 },
        { 307060547, 782210925, 3193380570 },
        { 167617770, 2180014252, 782210925 } },

      // Matrix for nskip = 2^50:

      { { 3811588895, 3303532086, 2766583698 },
        { 908630605, 2665400165, 3303532086 },
        { 2499994113, 3316180851, 2665400165 } },

      // Matrix for nskip = 2^51:

      { { 4288926968, 3033075037, 1505732852 },
        { 1531633406, 645804125, 3033075037 },
        { 2942690261, 2205365640, 645804125 } },

      // Matrix for nskip = 2^52:

      { { 3976196483, 3651411522, 1652430357 },
        { 1690405883, 1294990760, 3651411522 },
        { 209339647, 3088484327, 1294990760 } },

      // Matrix for nskip = 2^53:

      { { 3171589548, 2291131070, 2093793287 },
        { 2997812074, 4093879780, 2291131070 },
        { 3255666800, 858124816, 4093879780 } },

      // Matrix for nskip = 2^54:

      { { 4113016361, 2999667479, 3995043314 },
        { 1333973326, 4007774239, 2999667479 },
        { 3322921863, 4278103786, 4007774239 } },

      // Matrix for nskip = 2^55:

      { { 925786347, 2109676036, 1879981040 },
        { 1701566570, 1489702270, 2109676036 },
        { 2719807628, 158549605, 1489702270 } },

      // Matrix for nskip = 2^56:

      { { 2255405265, 3460246357, 218033453 },
        { 2135115875, 359516994, 3460246357 },
        { 3568862459, 3114762683, 359516994 } },

      // Matrix for nskip = 2^57:

      { { 773148471, 4117539411, 3073622315 },
        { 3807175775, 186466108, 4117539411 },
        { 2842197411, 651334129, 186466108 } },

      // Matrix for nskip = 2^58:

      { { 615242951, 1475251263, 3586439101 },
        { 1693917167, 3058812486, 1475251263 },
        { 568701600, 1164226398, 3058812486 } },

      // Matrix for nskip = 2^59:

      { { 1632636204, 15370275, 2061555515 },
        { 4187505695, 1741164221, 15370275 },
        { 2882176274, 3978412194, 1741164221 } },

      // Matrix for nskip = 2^60:

      { { 3446066703, 344820524, 74213775 },
        { 1008543583, 2579620192, 344820524 },
        { 3753911358, 1538453821, 2579620192 } },

      // Matrix for nskip = 2^61:

      { { 3600859892, 1269921024, 4069458760 },
        { 2050939727, 2222725697, 1269921024 },
        { 3208347646, 690898125, 2222725697 } },

      // Matrix for nskip = 2^62:

      { { 599407451, 2806239788, 1742216102 },
        { 975123999, 764869161, 2806239788 },
        { 2729710367, 1845257036, 764869161 } },

      // Matrix for nskip = 2^63:

      { { 967330218, 3464884028, 3444447102 },
        { 580449578, 1343714307, 3464884028 },
        { 1775329096, 4027221761, 1343714307 } },

      // Matrix for nskip = 2^64:

      { { 3426136514, 4123590610, 2477690850 },
        { 1284315665, 1604068527, 4123590610 },
        { 1818147893, 320435440, 1604068527 } },

      // Matrix for nskip = 2^65:

      { { 2678132557, 89090276, 2719996384 },
        { 607972119, 3383659282, 89090276 },
        { 480221151, 2265789281, 3383659282 } },

      // Matrix for nskip = 2^66:

      { { 1827237091, 2290099491, 614471834 },
        { 3711385978, 2748163602, 2290099491 },
        { 2067064347, 1071954219, 2748163602 } },

      // Matrix for nskip = 2^67:

      { { 3894793123, 921712152, 596236860 },
        { 4038673596, 4279784147, 921712152 },
        { 1999065039, 859801225, 4279784147 } },

      // Matrix for nskip = 2^68:

      { { 7276915, 3205297712, 1204204130 },
        { 2667672243, 2737282292, 3205297712 },
        { 2282864144, 2305990443, 2737282292 } },

      // Matrix for nskip = 2^69:

      { { 935922304, 2428000499, 510672020 },
        { 1541887892, 92472822, 2428000499 },
        { 4146892220, 1307489118, 92472822 } },

      // Matrix for nskip = 2^70:

      { { 690398653, 3787391292, 1705516721 },
        { 2953871718, 4173917861, 3787391292 },
        { 817556203, 3090114656, 4173917861 } },

      // Matrix for nskip = 2^71:

      { { 476867729, 1917800003, 1740083735 },
        { 3167988201, 1286715218, 1917800003 },
        { 2579365599, 4173763431, 1286715218 } },

      // Matrix for nskip = 2^72:

      { { 4092801160, 3749431174, 542781592 },
        { 1208313783, 217808460, 3749431174 },
        { 2708923752, 348848516, 217808460 } },

      // Matrix for nskip = 2^73:

      { { 381829350, 1732869179, 3638540651 },
        { 2509789412, 1114357536, 1732869179 },
        { 2465372475, 350550480, 1114357536 } },

      // Matrix for nskip = 2^74:

      { { 3712059912, 1698887908, 3706277064 },
        { 2152325130, 232741719, 1698887908 },
        { 4114351745, 170237153, 232741719 } },

      // Matrix for nskip = 2^75:

      { { 993804379, 905755330, 1717718779 },
        { 1712994855, 2713148271, 905755330 },
        { 2200585411, 111258429, 2713148271 } },

      // Matrix for nskip = 2^76:

      { { 82758667, 1871391091, 4127413238 },
        { 3672831523, 69195019, 1871391091 },
        { 3672091415, 3528743235, 69195019 } },

      // Matrix for nskip = 2^77:

      { { 3361372532, 2329303404, 99651939 },
        { 2008671965, 2931758910, 2329303404 },
        { 1113529483, 2374097189, 2931758910 } },

      // Matrix for nskip = 2^78:

      { { 1831590873, 1588259595, 1314332382 },
        { 2385989343, 2508077280, 1588259595 },
        { 1787615788, 661437137, 2508077280 } },

      // Matrix for nskip = 2^79:

      { { 2326052247, 4183591379, 4049009082 },
        { 2604529491, 1453913233, 4183591379 },
        { 2311925423, 1805360390, 1453913233 } },

      // Matrix for nskip = 2^80:

      { { 3956367490, 604461629, 1257432102 },
        { 794711716, 1155867175, 604461629 },
        { 1777070788, 429445904, 1155867175 } },

      // Matrix for nskip = 2^81:

      { { 1686241617, 1257046062, 1427609439 },
        { 490376081, 387798431, 1257046062 },
        { 235551485, 1312672615, 387798431 } },

      // Matrix for nskip = 2^82:

      { { 2362447880, 3445363024, 3160262066 },
        { 2426867845, 4194339866, 3445363024 },
        { 1046144413, 4177893681, 4194339866 } },

      // Matrix for nskip = 2^83:

      { { 4251175413, 3559576374, 3107663662 },
        { 697539134, 1909472435, 3559576374 },
        { 280754246, 375835695, 1909472435 } },

      // Matrix for nskip = 2^84:

      { { 1099512970, 712404985, 1571467521 },
        { 546519870, 1135109300, 712404985 },
        { 3325312332, 2352874613, 1135109300 } },

      // Matrix for nskip = 2^85:

      { { 1945425936, 1653045514, 381988982 },
        { 3733376326, 414410025, 1653045514 },
        { 1181583679, 1185848176, 414410025 } },

      // Matrix for nskip = 2^86:

      { { 2526336124, 3019211015, 4215964965 },
        { 2683163472, 4188191530, 3019211015 },
        { 2964651598, 293801056, 4188191530 } },

      // Matrix for nskip = 2^87:

      { { 1444052678, 2253324417, 39719589 },
        { 1880267534, 2391992038, 2253324417 },
        { 987740265, 3691889508, 2391992038 } },

      // Matrix for nskip = 2^88:

      { { 166599066, 2335494420, 1232261118 },
        { 2227597731, 2570600780, 2335494420 },
        { 2700034538, 3460843234, 2570600780 } },

      // Matrix for nskip = 2^89:

      { { 2511338360, 1188954576, 1251401239 },
        { 2511664974, 292276982, 1188954576 },
        { 697844082, 3093661552, 292276982 } },

      // Matrix for nskip = 2^90:

      { { 3624650744, 51993077, 3540268009 },
        { 3252828938, 3710319575, 51993077 },
        { 2858628849, 3910069381, 3710319575 } },

      // Matrix for nskip = 2^91:

      { { 655966702, 754002362, 1646581402 },
        { 1958331075, 475572423, 754002362 },
        { 3248619000, 3228514800, 475572423 } },

      // Matrix for nskip = 2^92:

      { { 2760311307, 4166372813, 741596417 },
        { 2282679206, 3090782630, 4166372813 },
        { 3242468721, 1628442374, 3090782630 } },

      // Matrix for nskip = 2^93:

      { { 4265279407, 3532111852, 1754687396 },
        { 500404765, 2603727025, 3532111852 },
        { 1428367254, 3149485478, 2603727025 } },

      // Matrix for nskip = 2^94:

      { { 2873769531, 2081104178, 596284397 },
        { 4153800443, 1261269623, 2081104178 },
        { 3967600061, 1830023157, 1261269623 } },

      // Matrix for nskip = 2^95:

      { { 278611533, 2229285304, 3443204327 },
        { 3110641420, 77498444, 2229285304 },
        { 3904070810, 1070507239, 77498444 } },

      // Matrix for nskip = 2^96:

      { { 544639534, 568528663, 2177189807 },
        { 2475829068, 121482268, 568528663 },
        { 876978915, 3116647617, 121482268 } },

      // Matrix for nskip = 2^97:

      { { 1547862823, 2404658587, 4191448009 },
        { 2158188804, 2976916793, 2404658587 },
        { 168571747, 1691884706, 2976916793 } },

      // Matrix for nskip = 2^98:

      { { 3208213311, 4212638780, 3235157352 },
        { 671148556, 2951207765, 4212638780 },
        { 2075145516, 2395485231, 2951207765 } },

      // Matrix for nskip = 2^99:

      { { 4080517315, 2133433101, 4043998180 },
        { 2044221845, 867670560, 2133433101 },
        { 834432416, 3613001199, 867670560 } },

      // Matrix for nskip = 2^100:

      { { 4102885735, 1319434267, 2678775073 },
        { 740092580, 607380970, 1319434267 },
        { 2198271844, 2610193258, 607380970 } },

      // Matrix for nskip = 2^101:

      { { 1165218048, 1317690360, 1189150958 },
        { 399240205, 2507168618, 1317690360 },
        { 2988334517, 2687593413, 2507168618 } },

      // Matrix for nskip = 2^102:

      { { 1028861702, 4082006648, 338232527 },
        { 1888486946, 1842080991, 4082006648 },
        { 3903826366, 3109935091, 1842080991 } },

      // Matrix for nskip = 2^103:

      { { 614134826, 2261996505, 2888080641 },
        { 710199359, 2773979788, 2261996505 },
        { 1144301620, 2554371815, 2773979788 } },

      // Matrix for nskip = 2^104:

      { { 4056173823, 1285620078, 357420018 },
        { 2423072612, 2309408315, 1285620078 },
        { 1533175115, 2760088020, 2309408315 } },

      // Matrix for nskip = 2^105:

      { { 4264130267, 815015434, 3142242173 },
        { 180649975, 2500813569, 815015434 },
        { 3378723563, 829683767, 2500813569 } },

      // Matrix for nskip = 2^106:

      { { 4174387531, 1030729435, 2812778314 },
        { 1752988797, 4044178729, 1030729435 },
        { 467969301, 554748104, 4044178729 } },

      // Matrix for nskip = 2^107:

      { { 1348429235, 2928743274, 3776082629 },
        { 3607529209, 3069812185, 2928743274 },
        { 2542432347, 3208181168, 3069812185 } },

      // Matrix for nskip = 2^108:

      { { 4064845753, 668285756, 3816217625 },
        { 3713143233, 1380634204, 668285756 },
        { 3533700508, 1192551435, 1380634204 } },

      // Matrix for nskip = 2^109:

      { { 1515684518, 1706771705, 728123349 },
        { 3174850469, 2057456462, 1706771705 },
        { 3410402985, 2897339640, 2057456462 } },

      // Matrix for nskip = 2^110:

      { { 3082272717, 531091457, 1390161328 },
        { 3895139973, 2171402857, 531091457 },
        { 4030688141, 3049703400, 2171402857 } },

      // Matrix for nskip = 2^111:

      { { 1241147206, 3193892819, 1244284192 },
        { 65180262, 4065669017, 3193892819 },
        { 1484817937, 3661081858, 4065669017 } },

      // Matrix for nskip = 2^112:

      { { 1438760812, 3491341751, 3414470157 },
        { 2805337292, 272266053, 3491341751 },
        { 824109230, 3202556526, 272266053 } },

      // Matrix for nskip = 2^113:

      { { 135412706, 3627115412, 2345042216 },
        { 1565169824, 2166856449, 3627115412 },
        { 1026946745, 3467845248, 2166856449 } },

      // Matrix for nskip = 2^114:

      { { 1889419951, 3256876154, 1240505488 },
        { 1254783743, 989966800, 3256876154 },
        { 1995297400, 3692472918, 989966800 } },

      // Matrix for nskip = 2^115:

      { { 3206226875, 285700890, 496017472 },
        { 2515316194, 2129675196, 285700890 },
        { 1863853990, 2673457552, 2129675196 } },

      // Matrix for nskip = 2^116:

      { { 4163770641, 255160418, 772100749 },
        { 1987092456, 3237660221, 255160418 },
        { 1394381051, 4216039401, 3237660221 } },

      // Matrix for nskip = 2^117:

      { { 2133915627, 2713747584, 627765421 },
        { 2300605925, 35690583, 2713747584 },
        { 2918902946, 2638220304, 35690583 } },

      // Matrix for nskip = 2^118:

      { { 2587549655, 998684270, 4292130625 },
        { 1791772791, 2820705344, 998684270 },
        { 124590158, 3831143549, 2820705344 } },

      // Matrix for nskip = 2^119:

      { { 978482299, 3200877282, 497605289 },
        { 3717741518, 3737164414, 3200877282 },
        { 4046686626, 861393946, 3737164414 } },

      // Matrix for nskip = 2^120:

      { { 2665561897, 300934584, 3179822945 },
        { 893043137, 2031413512, 300934584 },
        { 3806926970, 2413249929, 2031413512 } },

      // Matrix for nskip = 2^121:

      { { 1417581911, 3071835354, 2575196237 },
        { 4101127251, 1375339216, 3071835354 },
        { 847617977, 3632503316, 1375339216 } },

      // Matrix for nskip = 2^122:

      { { 2747488994, 3296604805, 898095468 },
        { 1742777145, 219265369, 3296604805 },
        { 823714885, 667779292, 219265369 } },

      // Matrix for nskip = 2^123:

      { { 2640209692, 3040506537, 3626115220 },
        { 161827078, 852668118, 3040506537 },
        { 3856381322, 3360242076, 852668118 } },

      // Matrix for nskip = 2^124:

      { { 3734246393, 4151553160, 4177051283 },
        { 266522866, 1731798531, 4151553160 },
        { 632196679, 3864297722, 1731798531 } },

      // Matrix for nskip = 2^125:

      { { 1694175127, 1087914338, 2384195794 },
        { 2764925057, 505782858, 1087914338 },
        { 3235634082, 807915248, 505782858 } },

      // Matrix for nskip = 2^126:

      { { 2402749950, 2353776151, 75909174 },
        { 890570951, 1752665661, 2353776151 },
        { 3120241607, 3862435696, 1752665661 } },

      // Matrix for nskip = 2^127:

      { { 2427906178, 3580155704, 949770784 },
        { 226153695, 1230515664, 3580155704 },
        { 1988835001, 986791581, 1230515664 } },

      // Matrix for nskip = 2^128:

      { { 1774047142, 3199155377, 3106427820 },
        { 1901920839, 4290900039, 3199155377 },
        { 4178980191, 280623348, 4290900039 } },

      // Matrix for nskip = 2^129:

      { { 3567524348, 1934119675, 3188270128 },
        { 2997767678, 826363896, 1934119675 },
        { 262952343, 614326610, 826363896 } },

      // Matrix for nskip = 2^130:

      { { 1625613062, 4288164505, 2481284279 },
        { 4273461426, 1177260757, 4288164505 },
        { 305959988, 4017252267, 1177260757 } },

      // Matrix for nskip = 2^131:

      { { 337929267, 333342539, 418300166 },
        { 2944208672, 379097734, 333342539 },
        { 2084056909, 3625475947, 379097734 } },

      // Matrix for nskip = 2^132:

      { { 1189899255, 1307754719, 1214919992 },
        { 3736721708, 3514751918, 1307754719 },
        { 732435953, 2021244538, 3514751918 } },

      // Matrix for nskip = 2^133:

      { { 4089172695, 1533534334, 525643282 },
        { 1497577018, 1335684482, 1533534334 },
        { 2079007086, 3977541427, 1335684482 } },

      // Matrix for nskip = 2^134:

      { { 3075256652, 2762754934, 3846844247 },
        { 3057872364, 3274545167, 2762754934 },
        { 4028573983, 938934351, 3274545167 } },

      // Matrix for nskip = 2^135:

      { { 2597859300, 2880151048, 2523330453 },
        { 1121709186, 175667448, 2880151048 },
        { 4182510911, 1723133625, 175667448 } },

      // Matrix for nskip = 2^136:

      { { 484148868, 1404283933, 2982534313 },
        { 3736767353, 3179865161, 1404283933 },
        { 391120388, 3758716888, 3179865161 } },

      // Matrix for nskip = 2^137:

      { { 2138867468, 1128973399, 2133702321 },
        { 1613561693, 3622350766, 1128973399 },
        { 1500151924, 3759983985, 3622350766 } },

      // Matrix for nskip = 2^138:

      { { 3027706760, 3786576552, 2698781808 },
        { 2810527099, 90498489, 3786576552 },
        { 4220122612, 1855245979, 90498489 } },

      // Matrix for nskip = 2^139:

      { { 3739389517, 1110440720, 917457922 },
        { 2163873618, 3707591763, 1110440720 },
        { 2667061910, 2533383962, 3707591763 } },

      // Matrix for nskip = 2^140:

      { { 1545226000, 1812182123, 3693349190 },
        { 3422065122, 3291428549, 1812182123 },
        { 1193168720, 2072837757, 3291428549 } },

      // Matrix for nskip = 2^141:

      { { 3230096243, 2131723358, 3262178024 },
        { 2882890127, 4088518247, 2131723358 },
        { 3991553306, 1282224087, 4088518247 } },

      // Matrix for nskip = 2^142:

      { { 301207261, 1722796810, 3697719854 },
        { 3350228505, 3410986694, 1722796810 },
        { 3684514720, 2846958957, 3410986694 } },

      // Matrix for nskip = 2^143:

      { { 1532963114, 4236235786, 3871128158 },
        { 3540401964, 1285250577, 4236235786 },
        { 1105070646, 2764245175, 1285250577 } },

      // Matrix for nskip = 2^144:

      { { 210906218, 3068599594, 3034582784 },
        { 340633153, 4004365908, 3068599594 },
        { 4238928187, 2299166464, 4004365908 } },

      // Matrix for nskip = 2^145:

      { { 2274701639, 3955606166, 3081246407 },
        { 3199954992, 3948054919, 3955606166 },
        { 2399101442, 3438340286, 3948054919 } },

      // Matrix for nskip = 2^146:

      { { 504137100, 1182303684, 201533985 },
        { 4188299661, 3042453580, 1182303684 },
        { 2578519273, 2674782930, 3042453580 } },

      // Matrix for nskip = 2^147:

      { { 1382964588, 2578452047, 3140440866 },
        { 261861891, 1076783073, 2578452047 },
        { 1634588989, 164438428, 1076783073 } },

      // Matrix for nskip = 2^148:

      { { 2529186343, 526867394, 3102803247 },
        { 2687252475, 2908898908, 526867394 },
        { 1213100579, 86050422, 2908898908 } },

      // Matrix for nskip = 2^149:

      { { 2690118316, 538108523, 790337895 },
        { 4193870709, 1053552056, 538108523 },
        { 1635227281, 4002399925, 1053552056 } },

      // Matrix for nskip = 2^150:

      { { 2123712957, 4205383007, 1812304090 },
        { 1095349745, 166243972, 4205383007 },
        { 428569070, 2128782357, 166243972 } },

      // Matrix for nskip = 2^151:

      { { 1330151766, 3569679412, 4107175982 },
        { 3808641551, 3621125056, 3569679412 },
        { 4262164578, 1927692878, 3621125056 } },

      // Matrix for nskip = 2^152:

      { { 3606295184, 2442739556, 3894922338 },
        { 1629626641, 2729678535, 2442739556 },
        { 3379124758, 4279360935, 2729678535 } },

      // Matrix for nskip = 2^153:

      { { 1052092278, 4249024666, 919210106 },
        { 3253349463, 3629539480, 4249024666 },
        { 852514024, 4025926501, 3629539480 } },

      // Matrix for nskip = 2^154:

      { { 12394571, 1252747620, 2133571953 },
        { 4227339509, 3197545170, 1252747620 },
        { 1884529704, 1976203831, 3197545170 } },

      // Matrix for nskip = 2^155:

      { { 2986331025, 2671019282, 2847338542 },
        { 3173738401, 3542657885, 2671019282 },
        { 745203060, 1546667401, 3542657885 } },

      // Matrix for nskip = 2^156:

      { { 2613012997, 2311336951, 2911336433 },
        { 1493974713, 92565032, 2311336951 },
        { 2786645250, 257065974, 92565032 } },

      // Matrix for nskip = 2^157:

      { { 3424925004, 2776053372, 2204068573 },
        { 3770626858, 2509257810, 2776053372 },
        { 2979919489, 1146336783, 2509257810 } },

      // Matrix for nskip = 2^158:

      { { 1474384834, 827894421, 515339473 },
        { 1373055755, 1949809417, 827894421 },
        { 3088339524, 1194193824, 1949809417 } },

      // Matrix for nskip = 2^159:

      { { 1825805135, 1289872272, 3700877161 },
        { 3433422861, 4062509844, 1289872272 },
        { 3019008744, 2060641859, 4062509844 } },

      // Matrix for nskip = 2^160:

      { { 3842597153, 4253338264, 3424495942 },
        { 698444416, 60268595, 4253338264 },
        { 4096010585, 47309624, 60268595 } },

      // Matrix for nskip = 2^161:

      { { 2662288323, 2043518992, 1593435980 },
        { 1330201507, 3618850300, 2043518992 },
        { 2538793204, 271787962, 3618850300 } },

      // Matrix for nskip = 2^162:

      { { 741020448, 997594656, 2398808739 },
        { 1160477043, 1522130854, 997594656 },
        { 3036916315, 2847712653, 1522130854 } },

      // Matrix for nskip = 2^163:

      { { 2654964886, 1889728930, 53329096 },
        { 2042322941, 1621136330, 1889728930 },
        { 1553642730, 784545882, 1621136330 } },

      // Matrix for nskip = 2^164:

      { { 1715219514, 2831829177, 929124824 },
        { 997274536, 404228189, 2831829177 },
        { 1386575385, 4107238699, 404228189 } },

      // Matrix for nskip = 2^165:

      { { 3928131551, 2912523524, 1840499723 },
        { 4216003022, 2970489088, 2912523524 },
        { 1158689953, 1425511081, 2970489088 } },

      // Matrix for nskip = 2^166:

      { { 2807004452, 2510299562, 271603006 },
        { 2505735035, 2370490899, 2510299562 },
        { 10873814, 2450376936, 2370490899 } },

      // Matrix for nskip = 2^167:

      { { 2000734342, 1113679064, 2502160539 },
        { 1475266926, 2787925323, 1113679064 },
        { 1475797635, 3044470744, 2787925323 } },

      // Matrix for nskip = 2^168:

      { { 1457157056, 1252556678, 3073232607 },
        { 1926798761, 3639907189, 1252556678 },
        { 2067740348, 2256217204, 3639907189 } },

      // Matrix for nskip = 2^169:

      { { 3740999688, 1035400458, 3162437311 },
        { 4126312242, 686702830, 1035400458 },
        { 1699805291, 667792040, 686702830 } },

      // Matrix for nskip = 2^170:

      { { 2422495016, 3203768688, 1858240466 },
        { 848719394, 4092709154, 3203768688 },
        { 659945473, 1863075174, 4092709154 } },

      // Matrix for nskip = 2^171:

      { { 246817944, 871751352, 2834051003 },
        { 3976202597, 3721214025, 871751352 },
        { 783929942, 745295675, 3721214025 } },

      // Matrix for nskip = 2^172:

      { { 3811740424, 3603608092, 2365398362 },
        { 3826150877, 2906557036, 3603608092 },
        { 2300510686, 966815948, 2906557036 } },

      // Matrix for nskip = 2^173:

      { { 2816329160, 18201123, 3367710570 },
        { 437309679, 2220769388, 18201123 },
        { 1346863388, 705296543, 2220769388 } },

      // Matrix for nskip = 2^174:

      { { 3310028953, 1662315499, 132645114 },
        { 2572908401, 3105849797, 1662315499 },
        { 1937586849, 1735620028, 3105849797 } },

      // Matrix for nskip = 2^175:

      { { 461386353, 1359675853, 3599822966 },
        { 106675209, 2044154050, 1359675853 },
        { 1787730088, 1149892630, 2044154050 } },

      // Matrix for nskip = 2^176:

      { { 3303902397, 345146034, 1417149696 },
        { 2231869247, 1116882637, 345146034 },
        { 1846832385, 79626976, 1116882637 } },

      // Matrix for nskip = 2^177:

      { { 2765049417, 3117782790, 1805260159 },
        { 3796182890, 1101141726, 3117782790 },
        { 224270120, 1004001443, 1101141726 } },

      // Matrix for nskip = 2^178:

      { { 89118668, 2494198515, 1356989069 },
        { 2490435731, 997151755, 2494198515 },
        { 1175528637, 3444341166, 997151755 } },

      // Matrix for nskip = 2^179:

      { { 2340639019, 510225634, 286119182 },
        { 2045217287, 1194574818, 510225634 },
        { 2662281592, 1728500627, 1194574818 } },

      // Matrix for nskip = 2^180:

      { { 210787847, 1189120688, 2848040407 },
        { 1087786165, 2343328484, 1189120688 },
        { 3465141330, 2893041005, 2343328484 } },

      // Matrix for nskip = 2^181:

      { { 3438170226, 3236285682, 962036916 },
        { 2873263091, 215280489, 3236285682 },
        { 730413847, 1474823842, 215280489 } },

      // Matrix for nskip = 2^182:

      { { 1566461658, 133010024, 2886695328 },
        { 2835827516, 653809404, 133010024 },
        { 3082882924, 3710942807, 653809404 } },

      // Matrix for nskip = 2^183:

      { { 4201558916, 1263786956, 326001602 },
        { 762846463, 621546357, 1263786956 },
        { 2697142404, 1156650856, 621546357 } },

      // Matrix for nskip = 2^184:

      { { 2655768102, 2339029465, 2430211448 },
        { 2669906627, 403962847, 2339029465 },
        { 1483118807, 639660658, 403962847 } },

      // Matrix for nskip = 2^185:

      { { 3508595200, 4228486662, 754946994 },
        { 1913148390, 3500531602, 4228486662 },
        { 24637, 3773159052, 3500531602 } },

      // Matrix for nskip = 2^186:

      { { 4024866227, 1143874914, 3205058469 },
        { 2970344133, 2873927273, 1143874914 },
        { 2167114735, 4095476435, 2873927273 } },

      // Matrix for nskip = 2^187:

      { { 1479401095, 2958366486, 3027708794 },
        { 2704486034, 3574053987, 2958366486 },
        { 3630964515, 1276667706, 3574053987 } },

      // Matrix for nskip = 2^188:

      { { 2035927380, 1363628533, 818363998 },
        { 3023327955, 3968427114, 1363628533 },
        { 1284825950, 2871663372, 3968427114 } },

      // Matrix for nskip = 2^189:

      { { 3827747418, 3897287251, 4106993377 },
        { 1527779946, 3221052941, 3897287251 },
        { 4178727866, 4281160673, 3221052941 } },

      // Matrix for nskip = 2^190:

      { { 1174358892, 2835476193, 959978619 },
        { 850076464, 3774782533, 2835476193 },
        { 3880910680, 3237990203, 3774782533 } },

      // Matrix for nskip = 2^191:

      { { 3128011728, 1998893251, 1400155768 },
        { 1430713735, 2850730926, 1998893251 },
        { 1073801764, 2374744218, 2850730926 } },

      // Matrix for nskip = 2^192:

      { { 364496809, 3951443831, 2338985995 },
        { 2365728271, 1745134545, 3951443831 },
        { 1076500940, 1589192585, 1745134545 } }

    },

    // Matrices for the second part of SkipAhead procedure
    // Matrix for nskip = 2^0:

    { { { 0, 1, 0 }, { 0, 0, 1 }, { 4293573854, 0, 527612 } },

      // Matrix for nskip = 2^1:

      { { 0, 0, 1 }, { 4293573854, 0, 527612 }, { 2706407399, 4293573854, 3497978192 } },

      // Matrix for nskip = 2^2:

      { { 2706407399, 4293573854, 3497978192 },
        { 1431525864, 2706407399, 3281754271 },
        { 97673890, 1431525864, 1673476130 } },

      // Matrix for nskip = 2^3:

      { { 3405842137, 2680076935, 893509979 },
        { 4035147174, 3405842137, 3280220074 },
        { 2623373296, 4035147174, 361718588 } },

      // Matrix for nskip = 2^4:

      { { 818368950, 3790774567, 3542344109 },
        { 1817134745, 818368950, 3321940838 },
        { 3493477402, 1817134745, 2854655037 } },

      // Matrix for nskip = 2^5:

      { { 498682467, 2928649385, 811441367 },
        { 1777037472, 498682467, 479207863 },
        { 3058260025, 1777037472, 1528225099 } },

      // Matrix for nskip = 2^6:

      { { 3893311647, 3140922085, 64039185 },
        { 82107183, 3893311647, 2655465224 },
        { 1674879036, 82107183, 1089381262 } },

      // Matrix for nskip = 2^7:

      { { 28639152, 3496041927, 2231910770 },
        { 3174683233, 28639152, 2828785870 },
        { 3681140872, 3174683233, 3910194649 } },

      // Matrix for nskip = 2^8:

      { { 1463826069, 300842059, 3313769518 },
        { 1799677538, 1463826069, 3174861078 },
        { 1882279394, 1799677538, 3509975160 } },

      // Matrix for nskip = 2^9:

      { { 2092194020, 184076987, 2202401252 },
        { 3103629604, 2092194020, 3409560232 },
        { 4257445059, 3103629604, 2390202783 } },

      // Matrix for nskip = 2^10:

      { { 812917091, 2574011276, 4168802395 },
        { 209817750, 812917091, 2974870628 },
        { 3238802184, 209817750, 3692836406 } },

      // Matrix for nskip = 2^11:

      { { 477309738, 3314523413, 3442242150 },
        { 2755731404, 477309738, 2782713347 },
        { 1606221490, 2755731404, 1033463096 } },

      // Matrix for nskip = 2^12:

      { { 2155469603, 3326516116, 3843369786 },
        { 288604458, 2155469603, 571673571 },
        { 1501677614, 288604458, 2928213494 } },

      // Matrix for nskip = 2^13:

      { { 2082469029, 749754403, 3963963316 },
        { 2764859700, 2082469029, 3576428059 },
        { 2840894706, 2764859700, 1782279859 } },

      // Matrix for nskip = 2^14:

      { { 3760163766, 1041986082, 1799196192 },
        { 1022129134, 3760163766, 1332558840 },
        { 276873446, 1022129134, 3979423632 } },

      // Matrix for nskip = 2^15:

      { { 1021313167, 1312544548, 1716381787 },
        { 3037868518, 1021313167, 199085085 },
        { 2582787611, 3037868518, 3539882179 } },

      // Matrix for nskip = 2^16:

      { { 2569413030, 1631336015, 2594942403 },
        { 1030618503, 2569413030, 3467650326 },
        { 1998739584, 1030618503, 3174552073 } },

      // Matrix for nskip = 2^17:

      { { 2334639309, 3114094203, 601680947 },
        { 2110199318, 2334639309, 678342865 },
        { 1649523168, 2110199318, 2154948056 } },

      // Matrix for nskip = 2^18:

      { { 563657176, 191330473, 1641595774 },
        { 780563537, 563657176, 3029522338 },
        { 2037330914, 780563537, 2084602709 } },

      // Matrix for nskip = 2^19:

      { { 3414769923, 1968799026, 2238126504 },
        { 832866376, 3414769923, 3754780168 },
        { 2165145850, 832866376, 1594768331 } },

      // Matrix for nskip = 2^20:

      { { 1646861218, 2317984620, 2301581548 },
        { 2672536210, 1646861218, 359763062 },
        { 2391283983, 2672536210, 1885870777 } },

      // Matrix for nskip = 2^21:

      { { 841254072, 3765813448, 1635365181 },
        { 2013240130, 841254072, 605925849 },
        { 3743932305, 2013240130, 400681955 } },

      // Matrix for nskip = 2^22:

      { { 1930213004, 2072952279, 3077694794 },
        { 3579956569, 1930213004, 2478539210 },
        { 1960229502, 3579956569, 1455652656 } },

      // Matrix for nskip = 2^23:

      { { 1097613522, 1784540933, 1194440107 },
        { 321747515, 1097613522, 1225209584 },
        { 74521379, 321747515, 4288531000 } },

      // Matrix for nskip = 2^24:

      { { 143812745, 3254530816, 3514348856 },
        { 769295000, 143812745, 2468210728 },
        { 1927161272, 769295000, 522705580 } },

      // Matrix for nskip = 2^25:

      { { 2692035063, 2596905012, 1643240704 },
        { 1103432342, 2692035063, 1446182108 },
        { 4161111774, 1103432342, 3076435551 } },

      // Matrix for nskip = 2^26:

      { { 2375319030, 1391532370, 3742334018 },
        { 1202100604, 2375319030, 4098434768 },
        { 2327872488, 1202100604, 1471526950 } },

      // Matrix for nskip = 2^27:

      { { 4269164791, 2795313144, 2507855960 },
        { 4245372460, 4269164791, 4094914553 },
        { 3873219634, 4245372460, 1473695507 } },

      // Matrix for nskip = 2^28:

      { { 513890845, 1208902926, 2870530442 },
        { 1984873167, 513890845, 1257532340 },
        { 1212627640, 1984873167, 2354363842 } },

      // Matrix for nskip = 2^29:

      { { 1848364568, 1552116673, 3496528455 },
        { 4160778291, 1848364568, 141769900 },
        { 3611019106, 4160778291, 596424080 } },

      // Matrix for nskip = 2^30:

      { { 364070020, 3520039729, 837362349 },
        { 2544671570, 364070020, 2188646679 },
        { 163978331, 2544671570, 672947816 } },

      // Matrix for nskip = 2^31:

      { { 1192700714, 3968150021, 298357363 },
        { 635565666, 1192700714, 2589432341 },
        { 2548654227, 635565666, 3531570992 } },

      // Matrix for nskip = 2^32:

      { { 2709640529, 676525399, 875361870 },
        { 1315499519, 2709640529, 3842690720 },
        { 3300994644, 1315499519, 2446760804 } },

      // Matrix for nskip = 2^33:

      { { 2742149264, 1410604392, 3032350755 },
        { 3774935330, 2742149264, 597633965 },
        { 4085935803, 3774935330, 3952463556 } },

      // Matrix for nskip = 2^34:

      { { 3878579563, 845297523, 1721916511 },
        { 2077922420, 3878579563, 3651360351 },
        { 2177255734, 2077922420, 3791239282 } },

      // Matrix for nskip = 2^35:

      { { 1570315355, 4252790045, 3522351060 },
        { 2324624266, 1570315355, 3594939336 },
        { 1725087354, 2324624266, 1338343327 } },

      // Matrix for nskip = 2^36:

      { { 2305761589, 381933244, 3663579047 },
        { 1355307047, 2305761589, 313617972 },
        { 992174375, 1355307047, 3881593435 } },

      // Matrix for nskip = 2^37:

      { { 1667857811, 1564715297, 2263851601 },
        { 3791771273, 1667857811, 4196134923 },
        { 3347975047, 3791771273, 615040705 } },

      // Matrix for nskip = 2^38:

      { { 4093947334, 3454015638, 2815567716 },
        { 4261953004, 4093947334, 3973733876 },
        { 2979573134, 4261953004, 3757047667 } },

      // Matrix for nskip = 2^39:

      { { 250120061, 570149551, 1513430926 },
        { 3178644752, 250120061, 1701869032 },
        { 4172515680, 3178644752, 4213855850 } },

      // Matrix for nskip = 2^40:

      { { 4158106802, 3062358456, 1815738463 },
        { 1379176112, 4158106802, 3926509890 },
        { 2842564878, 1379176112, 2852219546 } },

      // Matrix for nskip = 2^41:

      { { 931848746, 256263523, 2633569246 },
        { 3284646837, 931848746, 2567084715 },
        { 415258465, 3284646837, 2017565947 } },

      // Matrix for nskip = 2^42:

      { { 1648005210, 1032291296, 3987397422 },
        { 1831496020, 1648005210, 2829448427 },
        { 1821082272, 1831496020, 2917140265 } },

      // Matrix for nskip = 2^43:

      { { 4161327077, 489964129, 3870847744 },
        { 1669447863, 4161327077, 4292947198 },
        { 1522417114, 1669447863, 2652286672 } },

      // Matrix for nskip = 2^44:

      { { 1270934555, 3136631324, 505612043 },
        { 2981474723, 1270934555, 2528619024 },
        { 625182639, 2981474723, 1008985039 } },

      // Matrix for nskip = 2^45:

      { { 280996820, 143706137, 3013099060 },
        { 1797675893, 280996820, 3743985508 },
        { 1123794455, 1797675893, 2460119169 } },

      // Matrix for nskip = 2^46:

      { { 919218027, 4154920441, 1125672685 },
        { 3933041881, 919218027, 474242849 },
        { 564891116, 3933041881, 2263904321 } },

      // Matrix for nskip = 2^47:

      { { 2920112852, 1965329198, 1177141043 },
        { 2135250851, 2920112852, 969184056 },
        { 296035385, 2135250851, 4267827987 } },

      // Matrix for nskip = 2^48:

      { { 1481142942, 4120754772, 1088557292 },
        { 265491023, 1481142942, 2860005744 },
        { 301796252, 265491023, 1935975979 } },

      // Matrix for nskip = 2^49:

      { { 2111859033, 2813610100, 1001476468 },
        { 73849832, 2111859033, 3980799998 },
        { 3330206241, 73849832, 1933943506 } },

      // Matrix for nskip = 2^50:

      { { 1781286360, 3661231931, 3509383709 },
        { 2753158871, 1781286360, 3119883109 },
        { 3576525143, 2753158871, 551079002 } },

      // Matrix for nskip = 2^51:

      { { 1185024844, 587779104, 1004942725 },
        { 3763632860, 1185024844, 947424568 },
        { 3811666068, 3763632860, 2352253462 } },

      // Matrix for nskip = 2^52:

      { { 1310227170, 218138208, 3172947233 },
        { 766129426, 1310227170, 1808643264 },
        { 2226659371, 766129426, 3853798112 } },

      // Matrix for nskip = 2^53:

      { { 2230902378, 4243560874, 2491962392 },
        { 3836629116, 2230902378, 3637515403 },
        { 2846140932, 3836629116, 3083355464 } },

      // Matrix for nskip = 2^54:

      { { 999448569, 1464488480, 3344426626 },
        { 946166795, 999448569, 340856814 },
        { 3686999436, 946166795, 3231079441 } },

      // Matrix for nskip = 2^55:

      { { 1226155368, 3477563770, 550006884 },
        { 2378667355, 1226155368, 1493409040 },
        { 260364836, 2378667355, 4133888397 } },

      // Matrix for nskip = 2^56:

      { { 1277901832, 310796286, 2818511068 },
        { 3088910653, 1277901832, 3303406025 },
        { 2507911914, 3088910653, 3712928074 } },

      // Matrix for nskip = 2^57:

      { { 481918378, 339570348, 1728801469 },
        { 1623163429, 481918378, 2209094694 },
        { 3146982514, 1623163429, 508445538 } },

      // Matrix for nskip = 2^58:

      { { 3138921230, 2381863183, 1992357430 },
        { 1024510915, 3138921230, 2122851650 },
        { 1453455184, 1024510915, 941946604 } },

      // Matrix for nskip = 2^59:

      { { 2465372719, 1391015357, 3328905025 },
        { 1821933605, 2465372719, 1343489680 },
        { 3648970313, 1821933605, 1816599716 } },

      // Matrix for nskip = 2^60:

      { { 118634664, 3358712512, 2492792220 },
        { 348833376, 118634664, 2495544591 },
        { 3235582254, 348833376, 4043157504 } },

      // Matrix for nskip = 2^61:

      { { 2303067090, 3371139074, 1967771133 },
        { 598630070, 2303067090, 1819012637 },
        { 2049250561, 598630070, 4093044926 } },

      // Matrix for nskip = 2^62:

      { { 3035321857, 3971176093, 226779704 },
        { 3361614254, 3035321857, 2807125404 },
        { 326640887, 3361614254, 3147308542 } },

      // Matrix for nskip = 2^63:

      { { 1774298149, 4179629947, 3145006948 },
        { 1688753503, 1774298149, 94869516 },
        { 2327946901, 1688753503, 2786835219 } },

      // Matrix for nskip = 2^64:

      { { 185429251, 88142322, 3372328450 },
        { 1198432931, 185429251, 1527068783 },
        { 2880072915, 1198432931, 2782214191 } },

      // Matrix for nskip = 2^65:

      { { 127447080, 487724245, 2942566616 },
        { 2180042365, 127447080, 1722814040 },
        { 288658537, 2180042365, 4036691926 } },

      // Matrix for nskip = 2^66:

      { { 1614979968, 1486547157, 1122661217 },
        { 3976346810, 1614979968, 2343603502 },
        { 3049605934, 3976346810, 440737492 } },

      // Matrix for nskip = 2^67:

      { { 613698149, 3416334823, 3832821180 },
        { 1308958254, 613698149, 1338381534 },
        { 4058246217, 1308958254, 2070907998 } },

      // Matrix for nskip = 2^68:

      { { 2575546527, 1033712257, 125034191 },
        { 2091411644, 2575546527, 226649669 },
        { 1198488263, 2091411644, 1522580506 } },

      // Matrix for nskip = 2^69:

      { { 1051614737, 227719572, 3725579556 },
        { 3910426444, 1051614737, 2075080920 },
        { 3357426062, 3910426444, 1473179318 } },

      // Matrix for nskip = 2^70:

      { { 2999155498, 2971093563, 2685380188 },
        { 93938118, 2999155498, 4035265564 },
        { 3853931650, 93938118, 2034180250 } },

      // Matrix for nskip = 2^71:

      { { 1253368368, 2860152458, 2836784419 },
        { 1656084047, 1253368368, 646811031 },
        { 3103367928, 1656084047, 3114448889 } },

      // Matrix for nskip = 2^72:

      { { 2962469315, 4021086500, 2670244515 },
        { 299199825, 2962469315, 3624275162 },
        { 3634541206, 299199825, 1684552227 } },

      // Matrix for nskip = 2^73:

      { { 804213223, 438999528, 3143925885 },
        { 1625976775, 804213223, 1494982903 },
        { 3498104358, 1625976775, 881729466 } },

      // Matrix for nskip = 2^74:

      { { 1547173514, 490999994, 918013965 },
        { 1312079237, 1547173514, 1905431135 },
        { 3784344293, 1312079237, 3643511238 } },

      // Matrix for nskip = 2^75:

      { { 3846994569, 2894966137, 1130633118 },
        { 4115190113, 3846994569, 777098754 },
        { 3088495692, 4115190113, 2193427908 } },

      // Matrix for nskip = 2^76:

      { { 1511326704, 3759209742, 1610795712 },
        { 4292754251, 1511326704, 3889917532 },
        { 3859662829, 4292754251, 3708466080 } },

      // Matrix for nskip = 2^77:

      { { 972103006, 964807713, 878035866 },
        { 4248550197, 972103006, 1926628839 },
        { 1448629089, 4248550197, 3196114006 } },

      // Matrix for nskip = 2^78:

      { { 3497384788, 3174249442, 3182508868 },
        { 3864816447, 3497384788, 3038399593 },
        { 2546884738, 3864816447, 2980208068 } },

      // Matrix for nskip = 2^79:

      { { 1776335558, 1189944887, 4095757548 },
        { 3813600746, 1776335558, 789475914 },
        { 4119698302, 3813600746, 2145357457 } },

      // Matrix for nskip = 2^80:

      { { 4022832294, 4130146837, 1942923647 },
        { 1675130777, 4022832294, 916677004 },
        { 4089786548, 1675130777, 116540512 } },

      // Matrix for nskip = 2^81:

      { { 165639584, 1205513289, 2037453462 },
        { 1444587280, 165639584, 161923120 },
        { 2617085459, 1444587280, 2006913311 } },

      // Matrix for nskip = 2^82:

      { { 3458099202, 3062421748, 4052486999 },
        { 1064270720, 3458099202, 230768332 },
        { 4056228301, 1064270720, 2219267779 } },

      // Matrix for nskip = 2^83:

      { { 296275263, 3452455838, 2081462173 },
        { 1789143993, 296275263, 3463234943 },
        { 2097389984, 1789143993, 3447191459 } },

      // Matrix for nskip = 2^84:

      { { 2828288883, 3866690251, 410553827 },
        { 1587005542, 2828288883, 1469478670 },
        { 2766486018, 1587005542, 2627363449 } },

      // Matrix for nskip = 2^85:

      { { 3288027530, 412403981, 2458742268 },
        { 4267121909, 3288027530, 138566505 },
        { 420803572, 4267121909, 4094554844 } },

      // Matrix for nskip = 2^86:

      { { 3844599430, 2430152838, 3283485436 },
        { 2486244684, 3844599430, 4252427633 },
        { 3560842909, 2486244684, 3960267499 } },

      // Matrix for nskip = 2^87:

      { { 67933059, 1294996291, 2657888382 },
        { 513233413, 67933059, 1379805031 },
        { 44564058, 513233413, 86971645 } },

      // Matrix for nskip = 2^88:

      { { 2732588524, 1866530072, 818237694 },
        { 2540507736, 2732588524, 3257104212 },
        { 1164400003, 2540507736, 1124501551 } },

      // Matrix for nskip = 2^89:

      { { 4199239222, 3155848463, 2121388468 },
        { 1135554501, 4199239222, 2056492193 },
        { 3251740389, 1135554501, 2343537248 } },

      // Matrix for nskip = 2^90:

      { { 550710036, 500329021, 1075236085 },
        { 356444753, 550710036, 1634965500 },
        { 58733535, 356444753, 1261552815 } },

      // Matrix for nskip = 2^91:

      { { 708689546, 419139045, 2012018174 },
        { 706488081, 708689546, 1113760995 },
        { 585555005, 706488081, 76092226 } },

      // Matrix for nskip = 2^92:

      { { 1293182265, 3168473803, 366230236 },
        { 3319068849, 1293182265, 1085259665 },
        { 1675229290, 3319068849, 3912300371 } },

      // Matrix for nskip = 2^93:

      { { 3186089068, 4188864734, 1211781402 },
        { 756122322, 3186089068, 578262892 },
        { 2518961174, 756122322, 1658665581 } },

      // Matrix for nskip = 2^94:

      { { 1347291439, 2050427676, 736113023 },
        { 4102191254, 1347291439, 878627148 },
        { 1293500383, 4102191254, 745646810 } },

      // Matrix for nskip = 2^95:

      { { 4196897331, 3436564969, 1900167098 },
        { 3108887846, 4196897331, 2697923227 },
        { 1405263476, 3108887846, 314631094 } },

      // Matrix for nskip = 2^96:

      { { 958383622, 3694638688, 1150087061 },
        { 3770009830, 958383622, 793326651 },
        { 533700213, 3770009830, 1513734026 } },

      // Matrix for nskip = 2^97:

      { { 4119603367, 3479396923, 3534176399 },
        { 3765397477, 4119603367, 1458031003 },
        { 3380901602, 3765397477, 2684083587 } },

      // Matrix for nskip = 2^98:

      { { 980937351, 2094378936, 448446028 },
        { 1421333909, 980937351, 3405683645 },
        { 323724368, 1421333909, 338680738 } },

      // Matrix for nskip = 2^99:

      { { 2942968846, 4293637338, 3549906544 },
        { 527851489, 2942968846, 3852871282 },
        { 4209198933, 527851489, 1091268872 } },

      // Matrix for nskip = 2^100:

      { { 1975983015, 2092556693, 611187071 },
        { 3982652344, 1975983015, 3001736262 },
        { 2055073597, 3982652344, 1875181995 } },

      // Matrix for nskip = 2^101:

      { { 2970221269, 880904779, 2447465272 },
        { 2888742196, 2970221269, 3521651749 },
        { 3019977656, 2888742196, 2712717326 } },

      // Matrix for nskip = 2^102:

      { { 419134859, 2976059897, 747864206 },
        { 4101695717, 419134859, 4264593116 },
        { 2657991148, 4101695717, 2542621682 } },

      // Matrix for nskip = 2^103:

      { { 4043135299, 1612983166, 1149778656 },
        { 1267010518, 4043135299, 3496325546 },
        { 3094232897, 1267010518, 2949176293 } },

      // Matrix for nskip = 2^104:

      { { 3949395794, 1774568686, 2123036003 },
        { 2182983404, 3949395794, 2355671350 },
        { 2820933455, 2182983404, 513963325 } },

      // Matrix for nskip = 2^105:

      { { 3046911698, 2576744453, 2492729814 },
        { 4277866093, 3046911698, 3146977604 },
        { 2249371766, 4277866093, 3622293976 } },

      // Matrix for nskip = 2^106:

      { { 1391529818, 423458502, 2587125255 },
        { 3536237833, 1391529818, 985347517 },
        { 157623850, 3536237833, 1015566287 } },

      // Matrix for nskip = 2^107:

      { { 48329260, 2599277669, 821961664 },
        { 902187690, 48329260, 1716556555 },
        { 4019658974, 902187690, 950730510 } },

      // Matrix for nskip = 2^108:

      { { 1318489562, 1530977112, 3713577419 },
        { 4270158447, 1318489562, 1654940598 },
        { 2679964938, 4270158447, 1337075195 } },

      // Matrix for nskip = 2^109:

      { { 770600793, 3249576224, 3578552768 },
        { 2710443459, 770600793, 2990852339 },
        { 3098163705, 2710443459, 522138188 } },

      // Matrix for nskip = 2^110:

      { { 2803285489, 1922250286, 3164022812 },
        { 477609731, 2803285489, 2140252218 },
        { 2252852611, 477609731, 3058519788 } },

      // Matrix for nskip = 2^111:

      { { 208329741, 3633562083, 3548346666 },
        { 3892091460, 208329741, 516833304 },
        { 3440632377, 3892091460, 1638833719 } },

      // Matrix for nskip = 2^112:

      { { 1816075033, 3570111203, 959489356 },
        { 3482051486, 1816075033, 861657108 },
        { 3119495098, 3482051486, 2576849579 } },

      // Matrix for nskip = 2^113:

      { { 4240216888, 2891584407, 2102314945 },
        { 4064489450, 4240216888, 1427441010 },
        { 2441164913, 4064489450, 3558527186 } },

      // Matrix for nskip = 2^114:

      { { 2918371295, 65155283, 3469357011 },
        { 3579773554, 2918371295, 3494391959 },
        { 3266584309, 3579773554, 3837485479 } },

      // Matrix for nskip = 2^115:

      { { 2959420453, 1365016881, 4082486022 },
        { 236489012, 2959420453, 3802558529 },
        { 2687043642, 236489012, 2547086826 } },

      // Matrix for nskip = 2^116:

      { { 4185325422, 2762854843, 3200044912 },
        { 3664909559, 4185325422, 3543921700 },
        { 4240262918, 3664909559, 2853212443 } },

      // Matrix for nskip = 2^117:

      { { 2618500928, 4237264351, 1470046497 },
        { 1893990098, 2618500928, 2982567031 },
        { 3017062825, 1893990098, 3195556801 } },

      // Matrix for nskip = 2^118:

      { { 1868464655, 3407681142, 1652841784 },
        { 1678569574, 1868464655, 4162480901 },
        { 1477016185, 1678569574, 4145063890 } },

      // Matrix for nskip = 2^119:

      { { 792188465, 4251338402, 2219407026 },
        { 3840340879, 792188465, 3493367465 },
        { 2979958414, 3840340879, 2338974139 } },

      // Matrix for nskip = 2^120:

      { { 478845700, 2378167062, 882114621 },
        { 1674533845, 478845700, 3572905305 },
        { 3571222880, 1674533845, 1242316901 } },

      // Matrix for nskip = 2^121:

      { { 2636090868, 1972761498, 71690719 },
        { 1228103463, 2636090868, 1280685025 },
        { 3741735502, 1228103463, 994061750 } },

      // Matrix for nskip = 2^122:

      { { 1156725261, 1100755307, 221922891 },
        { 2892200461, 1156725261, 1505716533 },
        { 2287613563, 2892200461, 3689457190 } },

      // Matrix for nskip = 2^123:

      { { 1387244644, 3135090808, 1243609165 },
        { 1724967466, 1387244644, 3296353235 },
        { 1064364031, 1724967466, 2107521044 } },

      // Matrix for nskip = 2^124:

      { { 2822471992, 2034317853, 2071407475 },
        { 170903528, 2822471992, 1322162887 },
        { 2524982332, 170903528, 2656231333 } },

      // Matrix for nskip = 2^125:

      { { 3653936868, 3893194049, 2484299328 },
        { 1313746234, 3653936868, 1705346273 },
        { 1397638018, 1313746234, 4015529545 } },

      // Matrix for nskip = 2^126:

      { { 4129760842, 1671665759, 1677834656 },
        { 3200005334, 4129760842, 3486207172 },
        { 2850728736, 3200005334, 3076201597 } },

      // Matrix for nskip = 2^127:

      { { 1464411153, 277697599, 1610723613 },
        { 32183930, 1464411153, 1022607788 },
        { 2824425944, 32183930, 2093834863 } },

      // Matrix for nskip = 2^128:

      { { 3492361727, 1027004383, 3167429889 },
        { 3674905362, 3492361727, 3572939265 },
        { 4270409313, 3674905362, 698814233 } },

      // Matrix for nskip = 2^129:

      { { 880482061, 205175925, 4070445105 },
        { 2208329119, 880482061, 1933248566 },
        { 3741227945, 2208329119, 3962062826 } },

      // Matrix for nskip = 2^130:

      { { 4184605179, 1189429800, 567967482 },
        { 107217966, 4184605179, 784865788 },
        { 549462420, 107217966, 3134382704 } },

      // Matrix for nskip = 2^131:

      { { 2732536445, 1231107067, 3374588386 },
        { 409954030, 2732536445, 1044831206 },
        { 3398162498, 409954030, 3505648581 } },

      // Matrix for nskip = 2^132:

      { { 2169560691, 1076348534, 637306236 },
        { 3704346564, 2169560691, 293694496 },
        { 632453145, 3704346564, 1609425246 } },

      // Matrix for nskip = 2^133:

      { { 372115891, 3928812480, 2830541169 },
        { 3056527841, 372115891, 1924239834 },
        { 3044937468, 3056527841, 547142630 } },

      // Matrix for nskip = 2^134:

      { { 1660852083, 3635660815, 1389092450 },
        { 1025573319, 1660852083, 3276803366 },
        { 4036331438, 1025573319, 4092197741 } },

      // Matrix for nskip = 2^135:

      { { 1360732901, 2887812973, 4101068693 },
        { 52572783, 1360732901, 112458461 },
        { 2636566855, 52572783, 1136777988 } },

      // Matrix for nskip = 2^136:

      { { 3455696508, 536919193, 3978804036 },
        { 3094157668, 3455696508, 3821833900 },
        { 2278849016, 3094157668, 2531965909 } },

      // Matrix for nskip = 2^137:

      { { 2125991744, 890897326, 3790557569 },
        { 1433592392, 2125991744, 3671109604 },
        { 808215503, 1433592392, 2446306581 } },

      // Matrix for nskip = 2^138:

      { { 3524411799, 932865240, 1838275365 },
        { 1789634890, 3524411799, 4130736474 },
        { 2252266098, 1789634890, 3048775967 } },

      // Matrix for nskip = 2^139:

      { { 1773339925, 948403862, 1999624391 },
        { 983864203, 1773339925, 3734776305 },
        { 314407045, 983864203, 2648614071 } },

      // Matrix for nskip = 2^140:

      { { 321802921, 1099164995, 2112167358 },
        { 3760936985, 321802921, 1003573324 },
        { 3758858458, 3760936985, 4014658840 } },

      // Matrix for nskip = 2^141:

      { { 2196438580, 805386227, 4266375092 },
        { 4124675351, 2196438580, 2527961345 },
        { 94452540, 4124675351, 2825656399 } },

      // Matrix for nskip = 2^142:

      { { 66735368, 2228005807, 4186703168 },
        { 2624855312, 66735368, 2708679078 },
        { 4098470056, 2624855312, 1773862183 } },

      // Matrix for nskip = 2^143:

      { { 3072642883, 2746897053, 2690305546 },
        { 1105106652, 3072642883, 4047666135 },
        { 2862886282, 1105106652, 3597347398 } },

      // Matrix for nskip = 2^144:

      { { 232906611, 3873338256, 4051554873 },
        { 3027413363, 232906611, 3159432673 },
        { 3872967050, 3027413363, 987156327 } },

      // Matrix for nskip = 2^145:

      { { 1160686753, 3676603152, 1635979789 },
        { 1447386846, 1160686753, 2670438424 },
        { 816212890, 1447386846, 4288868534 } },

      // Matrix for nskip = 2^146:

      { { 3825238244, 1445162354, 2362389441 },
        { 3440193648, 3825238244, 3520937545 },
        { 2652790808, 3440193648, 405299994 } },

      // Matrix for nskip = 2^147:

      { { 1984094858, 532165989, 2027397575 },
        { 1455977136, 1984094858, 2433255524 },
        { 1039994763, 1455977136, 2069333087 } },

      // Matrix for nskip = 2^148:

      { { 3680843319, 2332949611, 3516795313 },
        { 2033851810, 3680843319, 3843367307 },
        { 3686294589, 2033851810, 3912995069 } },

      // Matrix for nskip = 2^149:

      { { 967423689, 1724183394, 635932799 },
        { 641380480, 967423689, 2145297779 },
        { 1723000412, 641380480, 455633660 } },

      // Matrix for nskip = 2^150:

      { { 2130938335, 1534972306, 2511584766 },
        { 273828453, 2130938335, 3112810093 },
        { 4084843716, 273828453, 1399334152 } },

      // Matrix for nskip = 2^151:

      { { 168278549, 541167592, 190177712 },
        { 403188859, 168278549, 2092073970 },
        { 58789558, 403188859, 2777887189 } },

      // Matrix for nskip = 2^152:

      { { 634843389, 4082275720, 2092828966 },
        { 351187677, 634843389, 1312056270 },
        { 3347241070, 351187677, 2417192332 } },

      // Matrix for nskip = 2^153:

      { { 443276110, 1113643788, 271102234 },
        { 3083745876, 443276110, 3370743767 },
        { 4200577503, 3083745876, 3298601960 } },

      // Matrix for nskip = 2^154:

      { { 3533393557, 764977733, 3400275098 },
        { 144639933, 3533393557, 2646475951 },
        { 77963866, 144639933, 3794766611 } },

      // Matrix for nskip = 2^155:

      { { 4064854722, 1198665008, 2872196602 },
        { 3274748603, 4064854722, 4164637970 },
        { 4238693771, 3274748603, 1981721347 } },

      // Matrix for nskip = 2^156:

      { { 2279220396, 2355957139, 1417574285 },
        { 885864931, 2279220396, 1344421653 },
        { 1895527787, 885864931, 3726919367 } },

      // Matrix for nskip = 2^157:

      { { 2898100178, 2427331008, 348923199 },
        { 3175444953, 2898100178, 4290541487 },
        { 246118669, 3175444953, 3410622769 } },

      // Matrix for nskip = 2^158:

      { { 284442065, 4064194676, 2295560707 },
        { 4182706556, 284442065, 3696899246 },
        { 1201342255, 4182706556, 1145356382 } },

      // Matrix for nskip = 2^159:

      { { 656615546, 442908965, 3724738272 },
        { 1624967553, 656615546, 798014134 },
        { 1157949454, 1624967553, 496247378 } },

      // Matrix for nskip = 2^160:

      { { 265689579, 675056541, 3009083380 },
        { 3820679930, 265689579, 2961990151 },
        { 562287964, 3820679930, 1853486796 } },

      // Matrix for nskip = 2^161:

      { { 1675739167, 2319843005, 760605578 },
        { 4161492847, 1675739167, 226142150 },
        { 1017447188, 4161492847, 3431158427 } },

      // Matrix for nskip = 2^162:

      { { 1759873736, 2334568602, 2154570180 },
        { 1812793060, 1759873736, 2111094408 },
        { 1168460586, 1812793060, 2495653141 } },

      // Matrix for nskip = 2^163:

      { { 317621194, 868104288, 664971082 },
        { 2340275074, 317621194, 2168960688 },
        { 725706104, 2340275074, 3532023115 } },

      // Matrix for nskip = 2^164:

      { { 3926931954, 2907684453, 615601328 },
        { 1132340715, 3926931954, 676995757 },
        { 1154819290, 1132340715, 1662727700 } },

      // Matrix for nskip = 2^165:

      { { 3921782078, 3376494857, 2969567377 },
        { 475345024, 3921782078, 4206379953 },
        { 1795936544, 475345024, 934679595 } },

      // Matrix for nskip = 2^166:

      { { 3119292228, 741613041, 2083352304 },
        { 1047885963, 3119292228, 1581078542 },
        { 1065969969, 1047885963, 661718928 } },

      // Matrix for nskip = 2^167:

      { { 3643472111, 2870554228, 3995474529 },
        { 3804264051, 3643472111, 1366457944 },
        { 1246805564, 3804264051, 993186530 } },

      // Matrix for nskip = 2^168:

      { { 796711791, 3878204845, 3160293932 },
        { 255632881, 796711791, 3778927111 },
        { 3472564181, 255632881, 388382377 } },

      // Matrix for nskip = 2^169:

      { { 1776984101, 1742284034, 3449763933 },
        { 1349354417, 1776984101, 1264780832 },
        { 715722511, 1349354417, 1213319489 } },

      // Matrix for nskip = 2^170:

      { { 4261866865, 1914382786, 201872335 },
        { 614207188, 4261866865, 1853554849 },
        { 2046042882, 614207188, 3193186353 } },

      // Matrix for nskip = 2^171:

      { { 2210205512, 2847073169, 3324925707 },
        { 1251969297, 2210205512, 3491451503 },
        { 470400916, 1251969297, 2184392547 } },

      // Matrix for nskip = 2^172:

      { { 1523590942, 2391111113, 68341529 },
        { 295466806, 1523590942, 4143310876 },
        { 3527253079, 295466806, 4059123142 } },

      // Matrix for nskip = 2^173:

      { { 1406902110, 3735012720, 1774518130 },
        { 1814959027, 1406902110, 1560544267 },
        { 346472965, 1814959027, 964257199 } },

      // Matrix for nskip = 2^174:

      { { 855309653, 4208503105, 1518467541 },
        { 2025248418, 855309653, 4148125749 },
        { 1349947330, 2025248418, 1168504873 } },

      // Matrix for nskip = 2^175:

      { { 2375338156, 3629519168, 409696181 },
        { 252401654, 2375338156, 3992097193 },
        { 2793725401, 252401654, 1350184085 } },

      // Matrix for nskip = 2^176:

      { { 873141039, 3885583138, 361604799 },
        { 3554143374, 873141039, 894746180 },
        { 1919765327, 3554143374, 876210854 } },

      // Matrix for nskip = 2^177:

      { { 246368794, 1703793169, 2317362874 },
        { 2300930144, 246368794, 2560214589 },
        { 2016163623, 2300930144, 1504276775 } },

      // Matrix for nskip = 2^178:

      { { 1574610921, 2147546631, 4103450226 },
        { 107416526, 1574610921, 1773803959 },
        { 1402542742, 107416526, 550063800 } },

      // Matrix for nskip = 2^179:

      { { 363388665, 592194244, 1746615522 },
        { 2637234667, 363388665, 4031408742 },
        { 2895130475, 2637234667, 296510335 } },

      // Matrix for nskip = 2^180:

      { { 3997368560, 3047771871, 3178383826 },
        { 1160174754, 3997368560, 4027094919 },
        { 1234984211, 1160174754, 4226264344 } },

      // Matrix for nskip = 2^181:

      { { 3303179301, 4243968063, 3235964171 },
        { 1776841674, 3303179301, 2867287469 },
        { 1500495759, 1776841674, 1708226553 } },

      // Matrix for nskip = 2^182:

      { { 1482944153, 3192311574, 354466071 },
        { 3932773012, 1482944153, 389193591 },
        { 3350181058, 3932773012, 3398059015 } },

      // Matrix for nskip = 2^183:

      { { 640968550, 3226860971, 922372912 },
        { 1254989667, 640968550, 2383815228 },
        { 2027371896, 1254989667, 2925300409 } },

      // Matrix for nskip = 2^184:

      { { 2313146046, 3910187183, 1377591475 },
        { 1689291784, 2313146046, 4255405993 },
        { 1650609719, 1689291784, 1897624297 } },

      // Matrix for nskip = 2^185:

      { { 3656310954, 882924050, 2702189958 },
        { 3185020283, 3656310954, 1923190496 },
        { 2449669145, 3185020283, 4235849984 } },

      // Matrix for nskip = 2^186:

      { { 377232416, 1498446142, 4229103619 },
        { 3926377906, 377232416, 600268838 },
        { 511317726, 3926377906, 216160452 } },

      // Matrix for nskip = 2^187:

      { { 1969399344, 3273966859, 4220943579 },
        { 3952111894, 1969399344, 575096961 },
        { 3815277103, 3952111894, 792177412 } },

      // Matrix for nskip = 2^188:

      { { 2957238169, 1410010554, 1523740068 },
        { 3949237584, 2957238169, 74149658 },
        { 2564746147, 3949237584, 2557663578 } },

      // Matrix for nskip = 2^189:

      { { 3377318569, 1927835240, 2556102508 },
        { 3022040116, 3377318569, 2549406364 },
        { 2387074241, 3022040116, 1477293711 } },

      // Matrix for nskip = 2^190:

      { { 257306870, 1748489735, 547809226 },
        { 3708493374, 257306870, 4183546362 },
        { 4435502, 3708493374, 1607696753 } },

      // Matrix for nskip = 2^191:

      { { 4076910933, 930542270, 3433720143 },
        { 675898567, 4076910933, 892406741 },
        { 5625977, 675898567, 2412946221 } },

      // Matrix for nskip = 2^192:

      { { 2146755704, 2635194649, 1512299181 },
        { 3860948634, 2146755704, 3641948767 },
        { 3872596381, 3860948634, 1350534123 } } }
};

} // namespace mrg32k3a_impl
} // namespace detail
} // namespace device
} // namespace rng
} // namespace mkl
} // namespace oneapi

#endif // _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_
