// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.mkl.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class mkl_rt extends org.bytedeco.mkl.presets.mkl_rt {
    static { Loader.load(); }

// Parsed from mkl.h

/*******************************************************************************
* Copyright 1999-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) interface
!******************************************************************************/

// #ifndef _MKL_H_
// #define _MKL_H_

// #if defined(__MIC__) || defined(__TARGET_ARCH_MIC)
// #   define MKL_CALL_CONV
// #else
// #   define MKL_CALL_CONV __cdecl
// #endif

// #define _Mkl_Api(rtype,name,arg)   extern rtype MKL_CALL_CONV   name    arg;
// #define _mkl_api(rtype,name,arg)   extern rtype MKL_CALL_CONV   name    arg;
// #define _MKL_API(rtype,name,arg)   extern rtype MKL_CALL_CONV   name    arg;

// #include "mkl_version.h"
// #include "mkl_types.h"
// #include "mkl_blas.h"
// #include "mkl_trans.h"
// #include "mkl_cblas.h"
// #include "mkl_spblas.h"
// #include "mkl_lapack.h"
// #include "mkl_lapacke.h"
// #include "mkl_pardiso.h"
// #include "mkl_sparse_handle.h"
// #include "mkl_dss.h"
// #include "mkl_rci.h"
// #include "mkl_vml.h"
// #include "mkl_vsl.h"
// #include "mkl_df.h"
// #include "mkl_service.h"
// #include "mkl_dfti.h"
// #include "mkl_trig_transforms.h"
// #include "mkl_poisson.h"
// #include "mkl_solvers_ee.h"
// #include "mkl_direct_call.h"
// #include "mkl_compact.h"
// #include "mkl_graph.h"
// #include "mkl_sparse_qr.h"

// #endif /* _MKL_H_ */


// Parsed from mkl_version.h

// #if 0
// #endif

// #if 0
// #endif

// #ifndef _MKL_VERSION_H_
// #define _MKL_VERSION_H_

public static final int __INTEL_MKL_BUILD_DATE = 20220804;


public static final int __INTEL_MKL__ =          2022;

public static final int __INTEL_MKL_MINOR__ =    0;
public static final int __INTEL_MKL_UPDATE__ =   2;


public static final int INTEL_MKL_VERSION =      20220002;


// #endif


// Parsed from mkl_types.h

/*******************************************************************************
* Copyright 1999-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
! Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) types definition
!****************************************************************************/

// #ifndef _MKL_TYPES_H_
// #define _MKL_TYPES_H_

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* oneMKL Complex type for single precision */
// #ifndef MKL_Complex8
// #endif

/* oneMKL Complex type for double precision */
// #ifndef MKL_Complex16
// #endif

/* oneMKL Version type */
public static class MKLVersion extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public MKLVersion() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MKLVersion(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MKLVersion(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public MKLVersion position(long position) {
        return (MKLVersion)super.position(position);
    }
    @Override public MKLVersion getPointer(long i) {
        return new MKLVersion((Pointer)this).offsetAddress(i);
    }

    public native int MajorVersion(); public native MKLVersion MajorVersion(int setter);
    public native int MinorVersion(); public native MKLVersion MinorVersion(int setter);
    public native int UpdateVersion(); public native MKLVersion UpdateVersion(int setter);
    public native @Cast("char*") BytePointer ProductStatus(); public native MKLVersion ProductStatus(BytePointer setter);
    public native @Cast("char*") BytePointer Build(); public native MKLVersion Build(BytePointer setter);
    public native @Cast("char*") BytePointer Processor(); public native MKLVersion Processor(BytePointer setter);
    public native @Cast("char*") BytePointer Platform(); public native MKLVersion Platform(BytePointer setter);
}

/* oneMKL integer types for LP64 and ILP64 */
// #if (!defined(__INTEL_COMPILER)) & defined(_MSC_VER)
//     #define MKL_INT64 __int64
//     #define MKL_UINT64 unsigned __int64
// #else
//     #define MKL_INT64 long long int
//     #define MKL_UINT64 unsigned long long int
// #endif

// #ifdef MKL_ILP64

/* oneMKL ILP64 integer types */
// #ifndef MKL_INT
//     #define MKL_INT MKL_INT64
// #endif
// #ifndef MKL_UINT
//     #define MKL_UINT MKL_UINT64
// #endif
// #define MKL_LONG MKL_INT64

// #else

/* oneMKL LP64 integer types */
// #ifndef MKL_INT
//     #define MKL_INT int
// #endif
// #ifndef MKL_UINT
//     #define MKL_UINT unsigned int
// #endif
// #define MKL_LONG long int

// #endif

/* oneMKL integer types */
// #ifndef MKL_UINT8
//     #define MKL_UINT8 unsigned char
// #endif
// #ifndef MKL_INT8
//     #define MKL_INT8 char
// #endif
// #ifndef MKL_INT16
//     #define MKL_INT16 short
// #endif
// #ifndef MKL_BF16
//     #define MKL_BF16 unsigned short
// #endif
// #ifndef MKL_INT32
//     #define MKL_INT32 int
// #endif
// #ifndef MKL_F16
//     #define MKL_F16 unsigned short
// #endif

/* oneMKL domain names */
public static final int MKL_DOMAIN_ALL =      0;
public static final int MKL_DOMAIN_BLAS =     1;
public static final int MKL_DOMAIN_FFT =      2;
public static final int MKL_DOMAIN_VML =      3;
public static final int MKL_DOMAIN_PARDISO =  4;
public static final int MKL_DOMAIN_LAPACK =   5;

/* oneMKL CBWR */

/* mkl_cbwr_get options */
public static final int MKL_CBWR_BRANCH = 1;
public static final int MKL_CBWR_ALL =   ~0;

/* flag specific values */
public static final int MKL_CBWR_STRICT =    0x10000;

/* branch specific values */
public static native @MemberGetter int MKL_CBWR_UNSET_ALL();
public static final int MKL_CBWR_UNSET_ALL = MKL_CBWR_UNSET_ALL();
public static final int MKL_CBWR_OFF =            0;
public static final int MKL_CBWR_BRANCH_OFF =     1;
public static final int MKL_CBWR_AUTO =           2;
public static final int MKL_CBWR_COMPATIBLE =     3;
public static final int MKL_CBWR_SSE2 =           4;
public static final int MKL_CBWR_SSSE3 =          6;
public static final int MKL_CBWR_SSE4_1 =         7;
public static final int MKL_CBWR_SSE4_2 =         8;
public static final int MKL_CBWR_AVX =            9;
public static final int MKL_CBWR_AVX2 =          10;
public static final int MKL_CBWR_AVX512_MIC =    11;
public static final int MKL_CBWR_AVX512 =        12;
public static final int MKL_CBWR_AVX512_MIC_E1 = 13;
public static final int MKL_CBWR_AVX512_E1 =     14;

/* error codes */
public static final int MKL_CBWR_SUCCESS =                   0;
public static final int MKL_CBWR_ERR_INVALID_SETTINGS =     -1;
public static final int MKL_CBWR_ERR_INVALID_INPUT =        -2;
public static final int MKL_CBWR_ERR_UNSUPPORTED_BRANCH =   -3;
public static final int MKL_CBWR_ERR_UNKNOWN_BRANCH =       -4;
public static final int MKL_CBWR_ERR_MODE_CHANGE_FAILURE =  -8;

/* obsolete */
public static final int MKL_CBWR_SSE3 =           5;

/** enum MKL_LAYOUT */
public static final int
    MKL_ROW_MAJOR = 101,
    MKL_COL_MAJOR = 102;

/** enum MKL_TRANSPOSE */
public static final int
    MKL_NOTRANS = 111,
    MKL_TRANS = 112,
    MKL_CONJTRANS = 113,
    MKL_CONJ = 114;

/** enum MKL_UPLO */
public static final int
    MKL_UPPER = 121,
    MKL_LOWER = 122;

/** enum MKL_DIAG */
public static final int
    MKL_NONUNIT = 131,
    MKL_UNIT = 132;

/** enum MKL_SIDE */
public static final int
    MKL_LEFT = 141,
    MKL_RIGHT = 142;

/** enum MKL_COMPACT_PACK */
public static final int
    MKL_COMPACT_SSE = 181,
    MKL_COMPACT_AVX = 182,
    MKL_COMPACT_AVX512 = 183;

public static class sgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    sgemm_jit_kernel_t(Pointer p) { super(p); }
    protected sgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, FloatPointer arg1,         FloatPointer arg2,         FloatPointer arg3);
}
public static class dgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    dgemm_jit_kernel_t(Pointer p) { super(p); }
    protected dgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, DoublePointer arg1,        DoublePointer arg2,        DoublePointer arg3);
}
public static class cgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    cgemm_jit_kernel_t(Pointer p) { super(p); }
    protected cgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, @Cast("MKL_Complex8*") FloatPointer arg1,  @Cast("MKL_Complex8*") FloatPointer arg2,  @Cast("MKL_Complex8*") FloatPointer arg3);
}
public static class zgemm_jit_kernel_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    zgemm_jit_kernel_t(Pointer p) { super(p); }
    protected zgemm_jit_kernel_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0, @Cast("MKL_Complex16*") DoublePointer arg1, @Cast("MKL_Complex16*") DoublePointer arg2, @Cast("MKL_Complex16*") DoublePointer arg3);
}

/** enum mkl_jit_status_t */
public static final int
    MKL_JIT_SUCCESS = 0,
    MKL_NO_JIT = 1,
    MKL_JIT_ERROR = 2;

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _MKL_TYPES_H_ */


// Parsed from mkl_trans.h

/*******************************************************************************
* Copyright 2007-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) include for transposition routines
!******************************************************************************/

// #if !defined(_MKL_TRANS_H)
// #define _MKL_TRANS_H

/* for size_t */
// #include <stddef.h>
// #include "mkl_types.h"
// #include "mkl_trans_names.h"

// #ifdef __cplusplus
// #if __cplusplus > 199711L
// #define NOTHROW noexcept
// #else
// #define NOTHROW throw()
// #endif
// #else
// #define NOTHROW
// #endif

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* In-place transposition routines */

/* Out-of-place transposition routines */

/* Out-of-place transposition routines (all-strided case) */

/* Out-of-place memory movement routines */


/* Batch routines */

public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @Cast("float**") PointerPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @ByPtrPtr FloatPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatBuffer alpha_array,
    @ByPtrPtr FloatBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const float[] alpha_array,
    @ByPtrPtr float[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @ByPtrPtr FloatPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatBuffer alpha_array,
    @ByPtrPtr FloatBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_simatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const float[] alpha_array,
    @ByPtrPtr float[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @Cast("double**") PointerPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @ByPtrPtr DoublePointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoubleBuffer alpha_array,
    @ByPtrPtr DoubleBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const double[] alpha_array,
    @ByPtrPtr double[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @ByPtrPtr DoublePointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoubleBuffer alpha_array,
    @ByPtrPtr DoubleBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_dimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const double[] alpha_array,
    @ByPtrPtr double[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("MKL_Complex8**") PointerPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatBuffer alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") float[] alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr float[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatBuffer alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_cimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") float[] alpha_array,
    @Cast("MKL_Complex8**") @ByPtrPtr float[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("MKL_Complex16**") PointerPointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoublePointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoubleBuffer alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoubleBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") double[] alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr double[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoublePointer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoubleBuffer alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoubleBuffer AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zimatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") double[] alpha_array,
    @Cast("MKL_Complex16**") @ByPtrPtr double[] AB_array, @Cast("const size_t*") SizeTPointer lda_array, @Cast("const size_t*") SizeTPointer ldb_array,
    @Cast("size_t") long group_count, @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @Cast("const float**") PointerPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("float**") PointerPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @Const @ByPtrPtr FloatPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr FloatPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatBuffer alpha_array,
    @Const @ByPtrPtr FloatBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr FloatBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const float[] alpha_array,
    @Const @ByPtrPtr float[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr float[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatPointer alpha_array,
    @Const @ByPtrPtr FloatPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr FloatPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const FloatBuffer alpha_array,
    @Const @ByPtrPtr FloatBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr FloatBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_somatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const float[] alpha_array,
    @Const @ByPtrPtr float[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr float[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @Cast("const double**") PointerPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("double**") PointerPointer B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @Const @ByPtrPtr DoublePointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr DoublePointer B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoubleBuffer alpha_array,
    @Const @ByPtrPtr DoubleBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr DoubleBuffer B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const double[] alpha_array,
    @Const @ByPtrPtr double[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr double[] B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoublePointer alpha_array,
    @Const @ByPtrPtr DoublePointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr DoublePointer B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const DoubleBuffer alpha_array,
    @Const @ByPtrPtr DoubleBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr DoubleBuffer B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_domatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Const double[] alpha_array,
    @Const @ByPtrPtr double[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @ByPtrPtr double[] B_array, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("const MKL_Complex8**") PointerPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") PointerPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr FloatPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatBuffer alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr FloatBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") float[] alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr float[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr float[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatPointer alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr FloatPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") FloatBuffer alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr FloatBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr FloatBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_comatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex8*") float[] alpha_array,
    @Cast("const MKL_Complex8**") @ByPtrPtr float[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex8**") @ByPtrPtr float[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("const MKL_Complex16**") PointerPointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") PointerPointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr DoublePointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoublePointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoubleBuffer alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr DoubleBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoubleBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") double[] alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr double[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr double[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoublePointer alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr DoublePointer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoublePointer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, @Cast("const char*") BytePointer trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") DoubleBuffer alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr DoubleBuffer A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr DoubleBuffer B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);
public static native void mkl_zomatcopy_batch(
    @Cast("char") byte ordering, String trans_array,
    @Cast("const size_t*") SizeTPointer rows_array, @Cast("const size_t*") SizeTPointer cols_array,
    @Cast("const MKL_Complex16*") double[] alpha_array,
    @Cast("const MKL_Complex16**") @ByPtrPtr double[] A_array, @Cast("const size_t*") SizeTPointer lda_array,
    @Cast("MKL_Complex16**") @ByPtrPtr double[] B, @Cast("const size_t*") SizeTPointer ldb_array, @Cast("size_t") long group_count,
    @Cast("const size_t*") SizeTPointer group_size);

public static native void mkl_somatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha, @Const FloatPointer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    float beta, @Const FloatPointer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    FloatPointer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_somatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha, @Const FloatBuffer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    float beta, @Const FloatBuffer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    FloatBuffer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_somatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    float alpha, @Const float[] A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    float beta, @Const float[] B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    float[] C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);

public static native void mkl_domatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha, @Const DoublePointer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    double beta, @Const DoublePointer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    DoublePointer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_domatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha, @Const DoubleBuffer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    double beta, @Const DoubleBuffer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    DoubleBuffer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_domatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    double alpha, @Const double[] A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    double beta, @Const double[] B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    double[] C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);

public static native void mkl_comatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const MKL_Complex8*") FloatPointer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("const MKL_Complex8*") FloatPointer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex8*") FloatPointer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_comatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const MKL_Complex8*") FloatBuffer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("const MKL_Complex8*") FloatBuffer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex8*") FloatBuffer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_comatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex8*") float[] alpha, @Cast("const MKL_Complex8*") float[] A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex8*") float[] beta, @Cast("const MKL_Complex8*") float[] B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex8*") float[] C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);

public static native void mkl_zomatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const MKL_Complex16*") DoublePointer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("const MKL_Complex16*") DoublePointer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex16*") DoublePointer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_zomatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const MKL_Complex16*") DoubleBuffer A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("const MKL_Complex16*") DoubleBuffer B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex16*") DoubleBuffer C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);
public static native void mkl_zomatadd_batch_strided(
    @Cast("char") byte ordering, @Cast("char") byte transa, @Cast("char") byte transb,
    @Cast("size_t") long rows, @Cast("size_t") long cols,
    @ByVal @Cast("const MKL_Complex16*") double[] alpha, @Cast("const MKL_Complex16*") double[] A, @Cast("size_t") long lda, @Cast("size_t") long stridea,
    @ByVal @Cast("const MKL_Complex16*") double[] beta, @Cast("const MKL_Complex16*") double[] B, @Cast("size_t") long ldb, @Cast("size_t") long strideb,
    @Cast("MKL_Complex16*") double[] C, @Cast("size_t") long ldc, @Cast("size_t") long stridec, @Cast("size_t") long batch_size);

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _MKL_TRANS_H */


// Parsed from mkl_cblas.h

/*******************************************************************************
* Copyright 1999-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!      Intel(R) oneAPI Math Kernel Library (oneMKL) CBLAS interface
!******************************************************************************/

// #ifndef __MKL_CBLAS_H__
// #define __MKL_CBLAS_H__
// #include <stddef.h>

// #include "mkl_types.h"

// #ifdef __cplusplus
// #if __cplusplus > 199711L
// #define NOTHROW noexcept
// #else
// #define NOTHROW throw()
// #endif
// #else
// #define NOTHROW
// #endif

// #ifdef __cplusplus /* Assume C declarations for C++ */
// #endif /* __cplusplus */

// #ifndef MKL_DECLSPEC
// #ifdef _WIN32
// #define MKL_DECLSPEC __declspec(dllexport)
// #else
// #define MKL_DECLSPEC
// #endif
// #endif
/*
 * Enumerated and derived types
 */
// #define CBLAS_INDEX size_t /* this may vary between platforms */

/** enum CBLAS_LAYOUT */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
/** enum CBLAS_STORAGE */
public static final int CblasPacked = 151;
/** enum CBLAS_IDENTIFIER */
public static final int CblasAMatrix = 161, CblasBMatrix = 162;
/** enum CBLAS_OFFSET */
public static final int CblasRowOffset = 171, CblasColOffset = 172, CblasFixOffset = 173; /* this for backward compatibility with CBLAS_ORDER */

/*
 * ===========================================================================
 * Prototypes for level 1 BLAS functions (complex are recast as routines)
 * ===========================================================================
 */


public static native double cblas_dcabs1(@Const Pointer z);
public static native float cblas_scabs1(@Const Pointer c);

public static native float cblas_sdot(int N, @Const FloatPointer X, int incX,
                 @Const FloatPointer Y, int incY);
public static native float cblas_sdot(int N, @Const FloatBuffer X, int incX,
                 @Const FloatBuffer Y, int incY);
public static native float cblas_sdot(int N, @Const float[] X, int incX,
                 @Const float[] Y, int incY);
public static native float cblas_sdoti(int N, @Const FloatPointer X, @Const IntPointer indx,
                  @Const FloatPointer Y);
public static native float cblas_sdoti(int N, @Const FloatBuffer X, @Const IntBuffer indx,
                  @Const FloatBuffer Y);
public static native float cblas_sdoti(int N, @Const float[] X, @Const int[] indx,
                  @Const float[] Y);
public static native double cblas_ddot(int N, @Const DoublePointer X, int incX,
                  @Const DoublePointer Y, int incY);
public static native double cblas_ddot(int N, @Const DoubleBuffer X, int incX,
                  @Const DoubleBuffer Y, int incY);
public static native double cblas_ddot(int N, @Const double[] X, int incX,
                  @Const double[] Y, int incY);
public static native double cblas_ddoti(int N, @Const DoublePointer X, @Const IntPointer indx,
                   @Const DoublePointer Y);
public static native double cblas_ddoti(int N, @Const DoubleBuffer X, @Const IntBuffer indx,
                   @Const DoubleBuffer Y);
public static native double cblas_ddoti(int N, @Const double[] X, @Const int[] indx,
                   @Const double[] Y);


public static native double cblas_dsdot(int N, @Const FloatPointer X, int incX,
                   @Const FloatPointer Y, int incY);
public static native double cblas_dsdot(int N, @Const FloatBuffer X, int incX,
                   @Const FloatBuffer Y, int incY);
public static native double cblas_dsdot(int N, @Const float[] X, int incX,
                   @Const float[] Y, int incY);

public static native float cblas_sdsdot(int N, float sb, @Const FloatPointer X,
                   int incX, @Const FloatPointer Y, int incY);
public static native float cblas_sdsdot(int N, float sb, @Const FloatBuffer X,
                   int incX, @Const FloatBuffer Y, int incY);
public static native float cblas_sdsdot(int N, float sb, @Const float[] X,
                   int incX, @Const float[] Y, int incY);

/*
 * Functions having prefixes Z and C only
 */
public static native void cblas_cdotu_sub(int N, @Const Pointer X, int incX,
                     @Const Pointer Y, int incY, Pointer dotu);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const IntPointer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotui_sub(int N, @Const Pointer X, @Const int[] indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotc_sub(int N, @Const Pointer X, int incX,
                     @Const Pointer Y, int incY, Pointer dotc);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const IntPointer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_cdotci_sub(int N, @Const Pointer X, @Const int[] indx,
                      @Const Pointer Y, Pointer dotui);

public static native void cblas_zdotu_sub(int N, @Const Pointer X, int incX,
                     @Const Pointer Y, int incY, Pointer dotu);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const IntPointer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotui_sub(int N, @Const Pointer X, @Const int[] indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotc_sub(int N, @Const Pointer X, int incX,
                     @Const Pointer Y, int incY, Pointer dotc);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const IntPointer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const IntBuffer indx,
                      @Const Pointer Y, Pointer dotui);
public static native void cblas_zdotci_sub(int N, @Const Pointer X, @Const int[] indx,
                      @Const Pointer Y, Pointer dotui);

/*
 * Functions having prefixes S D SC DZ
 */
public static native float cblas_snrm2(int N, @Const FloatPointer X, int incX);
public static native float cblas_snrm2(int N, @Const FloatBuffer X, int incX);
public static native float cblas_snrm2(int N, @Const float[] X, int incX);
public static native float cblas_sasum(int N, @Const FloatPointer X, int incX);
public static native float cblas_sasum(int N, @Const FloatBuffer X, int incX);
public static native float cblas_sasum(int N, @Const float[] X, int incX);

public static native double cblas_dnrm2(int N, @Const DoublePointer X, int incX);
public static native double cblas_dnrm2(int N, @Const DoubleBuffer X, int incX);
public static native double cblas_dnrm2(int N, @Const double[] X, int incX);
public static native double cblas_dasum(int N, @Const DoublePointer X, int incX);
public static native double cblas_dasum(int N, @Const DoubleBuffer X, int incX);
public static native double cblas_dasum(int N, @Const double[] X, int incX);

public static native float cblas_scnrm2(int N, @Const Pointer X, int incX);
public static native float cblas_scasum(int N, @Const Pointer X, int incX);

public static native double cblas_dznrm2(int N, @Const Pointer X, int incX);
public static native double cblas_dzasum(int N, @Const Pointer X, int incX);


/*
 * Functions having standard 4 prefixes (S D C Z)
 */
public static native @Cast("size_t") long cblas_isamax(int N, @Const FloatPointer X, int incX);
public static native @Cast("size_t") long cblas_isamax(int N, @Const FloatBuffer X, int incX);
public static native @Cast("size_t") long cblas_isamax(int N, @Const float[] X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const DoublePointer X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const DoubleBuffer X, int incX);
public static native @Cast("size_t") long cblas_idamax(int N, @Const double[] X, int incX);
public static native @Cast("size_t") long cblas_icamax(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_izamax(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const FloatPointer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const FloatBuffer X, int incX);
public static native @Cast("size_t") long cblas_isamin(int N, @Const float[] X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const DoublePointer X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const DoubleBuffer X, int incX);
public static native @Cast("size_t") long cblas_idamin(int N, @Const double[] X, int incX);
public static native @Cast("size_t") long cblas_icamin(int N, @Const Pointer X, int incX);
public static native @Cast("size_t") long cblas_izamin(int N, @Const Pointer X, int incX);

/*
 * ===========================================================================
 * Prototypes for level 1 BLAS routines
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (s, d, c, z)
 */
public static native void cblas_sswap(int N, FloatPointer X, int incX,
                 FloatPointer Y, int incY);
public static native void cblas_sswap(int N, FloatBuffer X, int incX,
                 FloatBuffer Y, int incY);
public static native void cblas_sswap(int N, float[] X, int incX,
                 float[] Y, int incY);
public static native void cblas_scopy(int N, @Const FloatPointer X, int incX,
                 FloatPointer Y, int incY);
public static native void cblas_scopy(int N, @Const FloatBuffer X, int incX,
                 FloatBuffer Y, int incY);
public static native void cblas_scopy(int N, @Const float[] X, int incX,
                 float[] Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const FloatPointer X,
                 int incX, FloatPointer Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const FloatBuffer X,
                 int incX, FloatBuffer Y, int incY);
public static native void cblas_saxpy(int N, float alpha, @Const float[] X,
                 int incX, float[] Y, int incY);

public static native void cblas_saxpyi(int N, float alpha, @Const FloatPointer X,
                  @Const IntPointer indx, FloatPointer Y);
public static native void cblas_saxpyi(int N, float alpha, @Const FloatBuffer X,
                  @Const IntBuffer indx, FloatBuffer Y);
public static native void cblas_saxpyi(int N, float alpha, @Const float[] X,
                  @Const int[] indx, float[] Y);
public static native void cblas_sgthr(int N, @Const FloatPointer Y, FloatPointer X,
                 @Const IntPointer indx);
public static native void cblas_sgthr(int N, @Const FloatBuffer Y, FloatBuffer X,
                 @Const IntBuffer indx);
public static native void cblas_sgthr(int N, @Const float[] Y, float[] X,
                 @Const int[] indx);
public static native void cblas_sgthrz(int N, FloatPointer Y, FloatPointer X,
                  @Const IntPointer indx);
public static native void cblas_sgthrz(int N, FloatBuffer Y, FloatBuffer X,
                  @Const IntBuffer indx);
public static native void cblas_sgthrz(int N, float[] Y, float[] X,
                  @Const int[] indx);
public static native void cblas_ssctr(int N, @Const FloatPointer X, @Const IntPointer indx,
                 FloatPointer Y);
public static native void cblas_ssctr(int N, @Const FloatBuffer X, @Const IntBuffer indx,
                 FloatBuffer Y);
public static native void cblas_ssctr(int N, @Const float[] X, @Const int[] indx,
                 float[] Y);
public static native void cblas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native void cblas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native void cblas_srotg(float[] a, float[] b, float[] c, float[] s);

public static native void cblas_dswap(int N, DoublePointer X, int incX,
                 DoublePointer Y, int incY);
public static native void cblas_dswap(int N, DoubleBuffer X, int incX,
                 DoubleBuffer Y, int incY);
public static native void cblas_dswap(int N, double[] X, int incX,
                 double[] Y, int incY);
public static native void cblas_dcopy(int N, @Const DoublePointer X, int incX,
                 DoublePointer Y, int incY);
public static native void cblas_dcopy(int N, @Const DoubleBuffer X, int incX,
                 DoubleBuffer Y, int incY);
public static native void cblas_dcopy(int N, @Const double[] X, int incX,
                 double[] Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const DoublePointer X,
                 int incX, DoublePointer Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const DoubleBuffer X,
                 int incX, DoubleBuffer Y, int incY);
public static native void cblas_daxpy(int N, double alpha, @Const double[] X,
                 int incX, double[] Y, int incY);

public static native void cblas_daxpyi(int N, double alpha, @Const DoublePointer X,
                  @Const IntPointer indx, DoublePointer Y);
public static native void cblas_daxpyi(int N, double alpha, @Const DoubleBuffer X,
                  @Const IntBuffer indx, DoubleBuffer Y);
public static native void cblas_daxpyi(int N, double alpha, @Const double[] X,
                  @Const int[] indx, double[] Y);
public static native void cblas_dgthr(int N, @Const DoublePointer Y, DoublePointer X,
                 @Const IntPointer indx);
public static native void cblas_dgthr(int N, @Const DoubleBuffer Y, DoubleBuffer X,
                 @Const IntBuffer indx);
public static native void cblas_dgthr(int N, @Const double[] Y, double[] X,
                 @Const int[] indx);
public static native void cblas_dgthrz(int N, DoublePointer Y, DoublePointer X,
                  @Const IntPointer indx);
public static native void cblas_dgthrz(int N, DoubleBuffer Y, DoubleBuffer X,
                  @Const IntBuffer indx);
public static native void cblas_dgthrz(int N, double[] Y, double[] X,
                  @Const int[] indx);
public static native void cblas_dsctr(int N, @Const DoublePointer X, @Const IntPointer indx,
                 DoublePointer Y);
public static native void cblas_dsctr(int N, @Const DoubleBuffer X, @Const IntBuffer indx,
                 DoubleBuffer Y);
public static native void cblas_dsctr(int N, @Const double[] X, @Const int[] indx,
                 double[] Y);
public static native void cblas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native void cblas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native void cblas_drotg(double[] a, double[] b, double[] c, double[] s);

public static native void cblas_cswap(int N, Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_ccopy(int N, @Const Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_caxpy(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, Pointer Y, int incY);

public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const IntPointer indx, Pointer Y);
public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const IntBuffer indx, Pointer Y);
public static native void cblas_caxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const int[] indx, Pointer Y);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                 @Const IntPointer indx);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                 @Const IntBuffer indx);
public static native void cblas_cgthr(int N, @Const Pointer Y, Pointer X,
                 @Const int[] indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                  @Const IntPointer indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                  @Const IntBuffer indx);
public static native void cblas_cgthrz(int N, Pointer Y, Pointer X,
                  @Const int[] indx);
public static native void cblas_csctr(int N, @Const Pointer X, @Const IntPointer indx,
                 Pointer Y);
public static native void cblas_csctr(int N, @Const Pointer X, @Const IntBuffer indx,
                 Pointer Y);
public static native void cblas_csctr(int N, @Const Pointer X, @Const int[] indx,
                 Pointer Y);
public static native void cblas_crotg(Pointer a, @Const Pointer b, FloatPointer c, Pointer s);
public static native void cblas_crotg(Pointer a, @Const Pointer b, FloatBuffer c, Pointer s);
public static native void cblas_crotg(Pointer a, @Const Pointer b, float[] c, Pointer s);

public static native void cblas_zswap(int N, Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_zcopy(int N, @Const Pointer X, int incX,
                 Pointer Y, int incY);
public static native void cblas_zaxpy(int N, @Const Pointer alpha, @Const Pointer X,
                 int incX, Pointer Y, int incY);

public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const IntPointer indx, Pointer Y);
public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const IntBuffer indx, Pointer Y);
public static native void cblas_zaxpyi(int N, @Const Pointer alpha, @Const Pointer X,
                  @Const int[] indx, Pointer Y);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                 @Const IntPointer indx);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                 @Const IntBuffer indx);
public static native void cblas_zgthr(int N, @Const Pointer Y, Pointer X,
                 @Const int[] indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                  @Const IntPointer indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                  @Const IntBuffer indx);
public static native void cblas_zgthrz(int N, Pointer Y, Pointer X,
                  @Const int[] indx);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const IntPointer indx,
                 Pointer Y);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const IntBuffer indx,
                 Pointer Y);
public static native void cblas_zsctr(int N, @Const Pointer X, @Const int[] indx,
                 Pointer Y);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, DoublePointer c, Pointer s);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, DoubleBuffer c, Pointer s);
public static native void cblas_zrotg(Pointer a, @Const Pointer b, double[] c, Pointer s);

/*
 * Routines with S and D prefix only
 */
public static native void cblas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native void cblas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native void cblas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);

public static native void cblas_sroti(int N, FloatPointer X, @Const IntPointer indx,
                 FloatPointer Y, float c, float s);
public static native void cblas_sroti(int N, FloatBuffer X, @Const IntBuffer indx,
                 FloatBuffer Y, float c, float s);
public static native void cblas_sroti(int N, float[] X, @Const int[] indx,
                 float[] Y, float c, float s);
public static native void cblas_srotm(int N, FloatPointer X, int incX,
                 FloatPointer Y, int incY, @Const FloatPointer P);
public static native void cblas_srotm(int N, FloatBuffer X, int incX,
                 FloatBuffer Y, int incY, @Const FloatBuffer P);
public static native void cblas_srotm(int N, float[] X, int incX,
                 float[] Y, int incY, @Const float[] P);

public static native void cblas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1, double b2, DoublePointer P);
public static native void cblas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1, double b2, DoubleBuffer P);
public static native void cblas_drotmg(double[] d1, double[] d2, double[] b1, double b2, double[] P);
public static native void cblas_drotm(int N, DoublePointer X, int incX,
                 DoublePointer Y, int incY, @Const DoublePointer P);
public static native void cblas_drotm(int N, DoubleBuffer X, int incX,
                 DoubleBuffer Y, int incY, @Const DoubleBuffer P);
public static native void cblas_drotm(int N, double[] X, int incX,
                 double[] Y, int incY, @Const double[] P);
public static native void cblas_droti(int N, DoublePointer X, @Const IntPointer indx,
                 DoublePointer Y, double c, double s);
public static native void cblas_droti(int N, DoubleBuffer X, @Const IntBuffer indx,
                 DoubleBuffer Y, double c, double s);
public static native void cblas_droti(int N, double[] X, @Const int[] indx,
                 double[] Y, double c, double s);

/*
 * Routines with S D C Z CS and ZD prefixes
 */
public static native void cblas_sscal(int N, float alpha, FloatPointer X, int incX);
public static native void cblas_sscal(int N, float alpha, FloatBuffer X, int incX);
public static native void cblas_sscal(int N, float alpha, float[] X, int incX);
public static native void cblas_dscal(int N, double alpha, DoublePointer X, int incX);
public static native void cblas_dscal(int N, double alpha, DoubleBuffer X, int incX);
public static native void cblas_dscal(int N, double alpha, double[] X, int incX);
public static native void cblas_cscal(int N, @Const Pointer alpha, Pointer X, int incX);
public static native void cblas_zscal(int N, @Const Pointer alpha, Pointer X, int incX);
public static native void cblas_csscal(int N, float alpha, Pointer X, int incX);
public static native void cblas_zdscal(int N, double alpha, Pointer X, int incX);

public static native void cblas_srot(int N, FloatPointer X, int incX,
                FloatPointer Y, int incY, float c, float s);
public static native void cblas_srot(int N, FloatBuffer X, int incX,
                FloatBuffer Y, int incY, float c, float s);
public static native void cblas_srot(int N, float[] X, int incX,
                float[] Y, int incY, float c, float s);
public static native void cblas_drot(int N, DoublePointer X, int incX,
                DoublePointer Y, int incY, double c, double s);
public static native void cblas_drot(int N, DoubleBuffer X, int incX,
                DoubleBuffer Y, int incY, double c, double s);
public static native void cblas_drot(int N, double[] X, int incX,
                double[] Y, int incY, double c, double s);
public static native void cblas_crot(int N, Pointer X, int incX,
                 Pointer Y, int incY, float c, @Const Pointer s);
public static native void cblas_zrot(int N, Pointer X, int incX,
                 Pointer Y, int incY, double c, @Const Pointer s);
public static native void cblas_csrot(int N, Pointer X, int incX,
                 Pointer Y, int incY, float c, float s);
public static native void cblas_zdrot(int N, Pointer X, int incX,
                 Pointer Y, int incY, double c, double s);

/*
 * ===========================================================================
 * Prototypes for level 2 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 @Const FloatPointer X, int incX, float beta,
                 FloatPointer Y, int incY);
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 @Const FloatBuffer X, int incX, float beta,
                 FloatBuffer Y, int incY);
public static native void cblas_sgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 @Const float[] X, int incX, float beta,
                 float[] Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const FloatPointer A, int lda, @Const FloatPointer X,
                 int incX, float beta, FloatPointer Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const FloatBuffer A, int lda, @Const FloatBuffer X,
                 int incX, float beta, FloatBuffer Y, int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, float alpha,
                 @Const float[] A, int lda, @Const float[] X,
                 int incX, float beta, float[] Y, int incY);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_strmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer Ap, FloatPointer X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer Ap, FloatBuffer X, int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] Ap, float[] X, int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer A, int lda, FloatPointer X,
                 int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer A, int lda, FloatBuffer X,
                 int incX);
public static native void cblas_strsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] A, int lda, float[] X,
                 int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatPointer A, int lda,
                 FloatPointer X, int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const FloatBuffer A, int lda,
                 FloatBuffer X, int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const float[] A, int lda,
                 float[] X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatPointer Ap, FloatPointer X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const FloatBuffer Ap, FloatBuffer X, int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const float[] Ap, float[] X, int incX);

public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 @Const DoublePointer X, int incX, double beta,
                 DoublePointer Y, int incY);
public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 @Const DoubleBuffer X, int incX, double beta,
                 DoubleBuffer Y, int incY);
public static native void cblas_dgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 @Const double[] X, int incX, double beta,
                 double[] Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const DoublePointer A, int lda, @Const DoublePointer X,
                 int incX, double beta, DoublePointer Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const DoubleBuffer A, int lda, @Const DoubleBuffer X,
                 int incX, double beta, DoubleBuffer Y, int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, double alpha,
                 @Const double[] A, int lda, @Const double[] X,
                 int incX, double beta, double[] Y, int incY);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer Ap, DoublePointer X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer Ap, DoubleBuffer X, int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] Ap, double[] X, int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer A, int lda, DoublePointer X,
                 int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer A, int lda, DoubleBuffer X,
                 int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] A, int lda, double[] X,
                 int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoublePointer A, int lda,
                 DoublePointer X, int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const DoubleBuffer A, int lda,
                 DoubleBuffer X, int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const double[] A, int lda,
                 double[] X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoublePointer Ap, DoublePointer X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const DoubleBuffer Ap, DoubleBuffer X, int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const double[] Ap, double[] X, int incX);

public static native void cblas_cgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer X, int incX, @Const Pointer beta,
                 Pointer Y, int incY);
public static native void cblas_cgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, @Const Pointer alpha,
                 @Const Pointer A, int lda, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_ctrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);
public static native void cblas_ctrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda, Pointer X,
                 int incX);
public static native void cblas_ctbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ctpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);

public static native void cblas_zgemv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer X, int incX, @Const Pointer beta,
                 Pointer Y, int incY);
public static native void cblas_zgbmv(@Cast("const CBLAS_LAYOUT") int Layout,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                 int KL, int KU, @Const Pointer alpha,
                 @Const Pointer A, int lda, @Const Pointer X,
                 int incX, @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_ztrmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);
public static native void cblas_ztrsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer A, int lda, Pointer X,
                 int incX);
public static native void cblas_ztbsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, int K, @Const Pointer A, int lda,
                 Pointer X, int incX);
public static native void cblas_ztpsv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 int N, @Const Pointer Ap, Pointer X, int incX);


/*
 * Routines with S and D prefixes only
 */
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] A,
                 int lda, @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, float alpha, @Const float[] A,
                 int lda, @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer Ap,
                 @Const FloatPointer X, int incX,
                 float beta, FloatPointer Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer Ap,
                 @Const FloatBuffer X, int incX,
                 float beta, FloatBuffer Y, int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] Ap,
                 @Const float[] X, int incX,
                 float beta, float[] Y, int incY);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const FloatPointer X, int incX,
                @Const FloatPointer Y, int incY, FloatPointer A, int lda);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const FloatBuffer X, int incX,
                @Const FloatBuffer Y, int incY, FloatBuffer A, int lda);
public static native void cblas_sger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                float alpha, @Const float[] X, int incX,
                @Const float[] Y, int incY, float[] A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, FloatPointer A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, FloatBuffer A, int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, float[] A, int lda);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatPointer X,
                int incX, FloatPointer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const FloatBuffer X,
                int incX, FloatBuffer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const float[] X,
                int incX, float[] Ap);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer X,
                 int incX, @Const FloatPointer Y, int incY, FloatPointer A,
                 int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer X,
                 int incX, @Const FloatBuffer Y, int incY, FloatBuffer A,
                 int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] X,
                 int incX, @Const float[] Y, int incY, float[] A,
                 int lda);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatPointer X,
                 int incX, @Const FloatPointer Y, int incY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const FloatBuffer X,
                 int incX, @Const FloatBuffer Y, int incY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, float alpha, @Const float[] X,
                 int incX, @Const float[] Y, int incY, float[] A);

public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] A,
                 int lda, @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, double alpha, @Const double[] A,
                 int lda, @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer Ap,
                 @Const DoublePointer X, int incX,
                 double beta, DoublePointer Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer Ap,
                 @Const DoubleBuffer X, int incX,
                 double beta, DoubleBuffer Y, int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] Ap,
                 @Const double[] X, int incX,
                 double beta, double[] Y, int incY);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const DoublePointer X, int incX,
                @Const DoublePointer Y, int incY, DoublePointer A, int lda);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const DoubleBuffer X, int incX,
                @Const DoubleBuffer Y, int incY, DoubleBuffer A, int lda);
public static native void cblas_dger(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                double alpha, @Const double[] X, int incX,
                @Const double[] Y, int incY, double[] A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, DoublePointer A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, DoubleBuffer A, int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, double[] A, int lda);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoublePointer X,
                int incX, DoublePointer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const DoubleBuffer X,
                int incX, DoubleBuffer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const double[] X,
                int incX, double[] Ap);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer X,
                 int incX, @Const DoublePointer Y, int incY, DoublePointer A,
                 int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer X,
                 int incX, @Const DoubleBuffer Y, int incY, DoubleBuffer A,
                 int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] X,
                 int incX, @Const double[] Y, int incY, double[] A,
                 int lda);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoublePointer X,
                 int incX, @Const DoublePointer Y, int incY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const DoubleBuffer X,
                 int incX, @Const DoubleBuffer Y, int incY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, double alpha, @Const double[] X,
                 int incX, @Const double[] Y, int incY, double[] A);

/*
 * Routines with C and Z prefixes only
 */
public static native void cblas_chemv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_chbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_chpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer Ap,
                 @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_cgeru(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_cgerc(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_cher(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const Pointer X, int incX,
                Pointer A, int lda);
public static native void cblas_chpr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, float alpha, @Const Pointer X,
                int incX, Pointer A);
public static native void cblas_cher2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_chpr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer Ap);

public static native void cblas_zhemv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zhbmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zhpmv(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 int N, @Const Pointer alpha, @Const Pointer Ap,
                 @Const Pointer X, int incX,
                 @Const Pointer beta, Pointer Y, int incY);
public static native void cblas_zgeru(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zgerc(@Cast("const CBLAS_LAYOUT") int Layout, int M, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zher(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const Pointer X, int incX,
                Pointer A, int lda);
public static native void cblas_zhpr(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                int N, double alpha, @Const Pointer X,
                int incX, Pointer A);
public static native void cblas_zher2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer A, int lda);
public static native void cblas_zhpr2(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo, int N,
                 @Const Pointer alpha, @Const Pointer X, int incX,
                 @Const Pointer Y, int incY, Pointer Ap);

/*
 * ===========================================================================
 * Prototypes for level 3 BLAS
 * ===========================================================================
 */

/*
 * Routines with standard 4 prefixes (S, D, C, Z)
 */
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const FloatPointer A,
                 int lda, @Const FloatPointer B, int ldb,
                 float beta, FloatPointer C, int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const FloatBuffer A,
                 int lda, @Const FloatBuffer B, int ldb,
                 float beta, FloatBuffer C, int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, float alpha, @Const float[] A,
                 int lda, @Const float[] B, int ldb,
                 float beta, float[] C, int ldc);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const FloatPointer alpha_Array, @Cast("const float**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const float**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const FloatPointer beta_Array, @Cast("float**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const FloatPointer alpha_Array, @Const @ByPtrPtr FloatPointer A_Array,
                       @Const IntPointer lda_Array, @Const @ByPtrPtr FloatPointer B_Array, @Const IntPointer ldb_Array,
                       @Const FloatPointer beta_Array, @ByPtrPtr FloatPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const FloatBuffer alpha_Array, @Const @ByPtrPtr FloatBuffer A_Array,
                       @Const IntBuffer lda_Array, @Const @ByPtrPtr FloatBuffer B_Array, @Const IntBuffer ldb_Array,
                       @Const FloatBuffer beta_Array, @ByPtrPtr FloatBuffer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_sgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const float[] alpha_Array, @Const @ByPtrPtr float[] A_Array,
                       @Const int[] lda_Array, @Const @ByPtrPtr float[] B_Array, @Const int[] ldb_Array,
                       @Const float[] beta_Array, @ByPtrPtr float[] C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_sgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, float alpha, @Const FloatPointer A,
                               int lda, int stridea,
                               @Const FloatPointer B, int ldb, int strideb,
                               float beta, FloatPointer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_sgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, float alpha, @Const FloatBuffer A,
                               int lda, int stridea,
                               @Const FloatBuffer B, int ldb, int strideb,
                               float beta, FloatBuffer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_sgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, float alpha, @Const float[] A,
                               int lda, int stridea,
                               @Const float[] B, int ldb, int strideb,
                               float beta, float[] C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  float alpha, @Const FloatPointer A, int lda,
                  @Const FloatPointer B, int ldb, float beta,
                  FloatPointer C, int ldc);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  float alpha, @Const FloatBuffer A, int lda,
                  @Const FloatBuffer B, int ldb, float beta,
                  FloatBuffer C, int ldc);
public static native void cblas_sgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  float alpha, @Const float[] A, int lda,
                  @Const float[] B, int ldb, float beta,
                  float[] C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 @Const FloatPointer B, int ldb, float beta,
                 FloatPointer C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 @Const FloatBuffer B, int ldb, float beta,
                 FloatBuffer C, int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 @Const float[] B, int ldb, float beta,
                 float[] C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatPointer A, int lda,
                 float beta, FloatPointer C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatBuffer A, int lda,
                 float beta, FloatBuffer C, int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const float[] A, int lda,
                 float beta, float[] C, int ldc);
public static native void cblas_ssyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatPointer A, int lda, int stridea,
                 float beta, FloatPointer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_ssyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const FloatBuffer A, int lda, int stridea,
                 float beta, FloatBuffer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_ssyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const float[] A, int lda, int stridea,
                 float beta, float[] C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_ssyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const FloatPointer alpha_array, @Cast("const float**") PointerPointer A_array, @Const IntPointer lda_array,
                 @Const FloatPointer beta_array, @Cast("float**") PointerPointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_ssyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const FloatPointer alpha_array, @Const @ByPtrPtr FloatPointer A_array, @Const IntPointer lda_array,
                 @Const FloatPointer beta_array, @ByPtrPtr FloatPointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_ssyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntBuffer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntBuffer Trans_array, @Const IntBuffer N_array, @Const IntBuffer K_array,
                 @Const FloatBuffer alpha_array, @Const @ByPtrPtr FloatBuffer A_array, @Const IntBuffer lda_array,
                 @Const FloatBuffer beta_array, @ByPtrPtr FloatBuffer C_array, @Const IntBuffer ldc_array,
                 int group_count, @Const IntBuffer group_size);
public static native void cblas_ssyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") int[] Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") int[] Trans_array, @Const int[] N_array, @Const int[] K_array,
                 @Const float[] alpha_array, @Const @ByPtrPtr float[] A_array, @Const int[] lda_array,
                 @Const float[] beta_array, @ByPtrPtr float[] C_array, @Const int[] ldc_array,
                 int group_count, @Const int[] group_size);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const FloatPointer A, int lda,
                  @Const FloatPointer B, int ldb, float beta,
                  FloatPointer C, int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const FloatBuffer A, int lda,
                  @Const FloatBuffer B, int ldb, float beta,
                  FloatBuffer C, int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  float alpha, @Const float[] A, int lda,
                  @Const float[] B, int ldb, float beta,
                  float[] C, int ldc);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 FloatPointer B, int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 FloatBuffer B, int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 float[] B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatPointer A, int lda,
                 FloatPointer B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const FloatBuffer A, int lda,
                 FloatBuffer B, int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 float alpha, @Const float[] A, int lda,
                 float[] B, int ldb);
public static native void cblas_strsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const FloatPointer alpha_Array,
                       @Cast("const float**") PointerPointer A_Array, @Const IntPointer lda_Array,
                       @Cast("float**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_strsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const FloatPointer alpha_Array,
                       @Const @ByPtrPtr FloatPointer A_Array, @Const IntPointer lda_Array,
                       @ByPtrPtr FloatPointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_strsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntBuffer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntBuffer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_DIAG*") IntBuffer Diag_Array, @Const IntBuffer M_Array,
                       @Const IntBuffer N_Array, @Const FloatBuffer alpha_Array,
                       @Const @ByPtrPtr FloatBuffer A_Array, @Const IntBuffer lda_Array,
                       @ByPtrPtr FloatBuffer B_Array, @Const IntBuffer ldb_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_strsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") int[] Side_Array,
                       @Cast("const CBLAS_UPLO*") int[] Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_DIAG*") int[] Diag_Array, @Const int[] M_Array,
                       @Const int[] N_Array, @Const float[] alpha_Array,
                       @Const @ByPtrPtr float[] A_Array, @Const int[] lda_Array,
                       @ByPtrPtr float[] B_Array, @Const int[] ldb_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_strsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, float alpha,
                       @Const FloatPointer A, int lda, int stridea,
                       FloatPointer B, int ldb, int strideb,
                       int batch_size);
public static native void cblas_strsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, float alpha,
                       @Const FloatBuffer A, int lda, int stridea,
                       FloatBuffer B, int ldb, int strideb,
                       int batch_size);
public static native void cblas_strsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, float alpha,
                       @Const float[] A, int lda, int stridea,
                       float[] B, int ldb, int strideb,
                       int batch_size);

public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const DoublePointer A,
                 int lda, @Const DoublePointer B, int ldb,
                 double beta, DoublePointer C, int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const DoubleBuffer A,
                 int lda, @Const DoubleBuffer B, int ldb,
                 double beta, DoubleBuffer C, int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, double alpha, @Const double[] A,
                 int lda, @Const double[] B, int ldb,
                 double beta, double[] C, int ldc);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const DoublePointer alpha_Array, @Cast("const double**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const double**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const DoublePointer beta_Array, @Cast("double**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const DoublePointer alpha_Array, @Const @ByPtrPtr DoublePointer A_Array,
                       @Const IntPointer lda_Array, @Const @ByPtrPtr DoublePointer B_Array, @Const IntPointer ldb_Array,
                       @Const DoublePointer beta_Array, @ByPtrPtr DoublePointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const DoubleBuffer alpha_Array, @Const @ByPtrPtr DoubleBuffer A_Array,
                       @Const IntBuffer lda_Array, @Const @ByPtrPtr DoubleBuffer B_Array, @Const IntBuffer ldb_Array,
                       @Const DoubleBuffer beta_Array, @ByPtrPtr DoubleBuffer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_dgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const double[] alpha_Array, @Const @ByPtrPtr double[] A_Array,
                       @Const int[] lda_Array, @Const @ByPtrPtr double[] B_Array, @Const int[] ldb_Array,
                       @Const double[] beta_Array, @ByPtrPtr double[] C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_dgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, double alpha, @Const DoublePointer A,
                               int lda, int stridea,
                               @Const DoublePointer B, int ldb, int strideb,
                               double beta, DoublePointer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_dgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, double alpha, @Const DoubleBuffer A,
                               int lda, int stridea,
                               @Const DoubleBuffer B, int ldb, int strideb,
                               double beta, DoubleBuffer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_dgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, double alpha, @Const double[] A,
                               int lda, int stridea,
                               @Const double[] B, int ldb, int strideb,
                               double beta, double[] C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  double alpha, @Const DoublePointer A, int lda,
                  @Const DoublePointer B, int ldb, double beta,
                  DoublePointer C, int ldc);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  double alpha, @Const DoubleBuffer A, int lda,
                  @Const DoubleBuffer B, int ldb, double beta,
                  DoubleBuffer C, int ldc);
public static native void cblas_dgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  double alpha, @Const double[] A, int lda,
                  @Const double[] B, int ldb, double beta,
                  double[] C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 @Const DoublePointer B, int ldb, double beta,
                 DoublePointer C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 @Const DoubleBuffer B, int ldb, double beta,
                 DoubleBuffer C, int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 @Const double[] B, int ldb, double beta,
                 double[] C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoublePointer A, int lda,
                 double beta, DoublePointer C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoubleBuffer A, int lda,
                 double beta, DoubleBuffer C, int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const double[] A, int lda,
                 double beta, double[] C, int ldc);
public static native void cblas_dsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const DoublePointer alpha_array, @Cast("const double**") PointerPointer A_array, @Const IntPointer lda_array,
                 @Const DoublePointer beta_array, @Cast("double**") PointerPointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_dsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const DoublePointer alpha_array, @Const @ByPtrPtr DoublePointer A_array, @Const IntPointer lda_array,
                 @Const DoublePointer beta_array, @ByPtrPtr DoublePointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_dsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntBuffer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntBuffer Trans_array, @Const IntBuffer N_array, @Const IntBuffer K_array,
                 @Const DoubleBuffer alpha_array, @Const @ByPtrPtr DoubleBuffer A_array, @Const IntBuffer lda_array,
                 @Const DoubleBuffer beta_array, @ByPtrPtr DoubleBuffer C_array, @Const IntBuffer ldc_array,
                 int group_count, @Const IntBuffer group_size);
public static native void cblas_dsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") int[] Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") int[] Trans_array, @Const int[] N_array, @Const int[] K_array,
                 @Const double[] alpha_array, @Const @ByPtrPtr double[] A_array, @Const int[] lda_array,
                 @Const double[] beta_array, @ByPtrPtr double[] C_array, @Const int[] ldc_array,
                 int group_count, @Const int[] group_size);
public static native void cblas_dsyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoublePointer A, int lda, int stridea,
                 double beta, DoublePointer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_dsyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const DoubleBuffer A, int lda, int stridea,
                 double beta, DoubleBuffer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_dsyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const double[] A, int lda, int stridea,
                 double beta, double[] C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const DoublePointer A, int lda,
                  @Const DoublePointer B, int ldb, double beta,
                  DoublePointer C, int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const DoubleBuffer A, int lda,
                  @Const DoubleBuffer B, int ldb, double beta,
                  DoubleBuffer C, int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  double alpha, @Const double[] A, int lda,
                  @Const double[] B, int ldb, double beta,
                  double[] C, int ldc);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 DoublePointer B, int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 DoubleBuffer B, int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 double[] B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoublePointer A, int lda,
                 DoublePointer B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const DoubleBuffer A, int lda,
                 DoubleBuffer B, int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 double alpha, @Const double[] A, int lda,
                 double[] B, int ldb);
public static native void cblas_dtrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const DoublePointer alpha_Array,
                       @Cast("const double**") PointerPointer A_Array, @Const IntPointer lda_Array,
                       @Cast("double**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dtrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const DoublePointer alpha_Array,
                       @Const @ByPtrPtr DoublePointer A_Array, @Const IntPointer lda_Array,
                       @ByPtrPtr DoublePointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dtrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntBuffer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntBuffer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntBuffer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntBuffer Diag_Array, @Const IntBuffer M_Array,
                       @Const IntBuffer N_Array, @Const DoubleBuffer alpha_Array,
                       @Const @ByPtrPtr DoubleBuffer A_Array, @Const IntBuffer lda_Array,
                       @ByPtrPtr DoubleBuffer B_Array, @Const IntBuffer ldb_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_dtrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") int[] Side_Array,
                       @Cast("const CBLAS_UPLO*") int[] Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") int[] Transa_Array,
                       @Cast("const CBLAS_DIAG*") int[] Diag_Array, @Const int[] M_Array,
                       @Const int[] N_Array, @Const double[] alpha_Array,
                       @Const @ByPtrPtr double[] A_Array, @Const int[] lda_Array,
                       @ByPtrPtr double[] B_Array, @Const int[] ldb_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_dtrsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, double alpha,
                       @Const DoublePointer A, int lda, int stridea,
                       DoublePointer B, int ldb, int strideb,
                       int batch_size);
public static native void cblas_dtrsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, double alpha,
                       @Const DoubleBuffer A, int lda, int stridea,
                       DoubleBuffer B, int ldb, int strideb,
                       int batch_size);
public static native void cblas_dtrsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, double alpha,
                       @Const double[] A, int lda, int stridea,
                       double[] B, int ldb, int strideb,
                       int batch_size);

public static native void cblas_cgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_cgemm3m(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                   @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                   int K, @Const Pointer alpha, @Const Pointer A,
                   int lda, @Const Pointer B, int ldb,
                   @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_cgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_cgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, @Const Pointer alpha, @Const Pointer A,
                               int lda, int stridea,
                               @Const Pointer B, int ldb, int strideb,
                               @Const Pointer beta, Pointer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                         @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                         int group_count, @Const IntBuffer group_size);
public static native void cblas_cgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                         @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                         int group_count, @Const int[] group_size);
public static native void cblas_cgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_csymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_csyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_csyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") PointerPointer A_array, @Const IntPointer lda_array,
                 @Const Pointer beta_array, @Cast("void**") PointerPointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_csyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const IntPointer lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_csyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntBuffer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntBuffer Trans_array, @Const IntBuffer N_array, @Const IntBuffer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const IntBuffer lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const IntBuffer ldc_array,
                 int group_count, @Const IntBuffer group_size);
public static native void cblas_csyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") int[] Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") int[] Trans_array, @Const int[] N_array, @Const int[] K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const int[] lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const int[] ldc_array,
                 int group_count, @Const int[] group_size);
public static native void cblas_csyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda, int stridea,
                 @Const Pointer beta, Pointer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_csyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_ctrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ctrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ctrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") PointerPointer A_Array, @Const IntPointer lda_Array,
                       @Cast("void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ctrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const IntPointer lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ctrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntBuffer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntBuffer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntBuffer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntBuffer Diag_Array, @Const IntBuffer M_Array,
                       @Const IntBuffer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const IntBuffer lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_ctrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") int[] Side_Array,
                       @Cast("const CBLAS_UPLO*") int[] Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") int[] Transa_Array,
                       @Cast("const CBLAS_DIAG*") int[] Diag_Array, @Const int[] M_Array,
                       @Const int[] N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const int[] lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_ctrsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, @Const Pointer alpha,
                       @Const Pointer A, int lda, int stridea,
                       Pointer B, int ldb, int strideb,
                       int batch_size);

public static native void cblas_zgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                 int K, @Const Pointer alpha, @Const Pointer A,
                 int lda, @Const Pointer B, int ldb,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zgemm3m(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                   @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                   int K, @Const Pointer alpha, @Const Pointer A,
                   int lda, @Const Pointer B, int ldb,
                   @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                       @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                       @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zgemm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                       @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                       @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_zgemm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                               @Cast("const CBLAS_TRANSPOSE") int TransB, int M, int N,
                               int K, @Const Pointer alpha, @Const Pointer A,
                               int lda, int stridea,
                               @Const Pointer B, int ldb, int strideb,
                               @Const Pointer beta, Pointer C, int ldc, int stridec,
                               int batch_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") PointerPointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") PointerPointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntPointer TransB_Array, @Const IntPointer M_Array, @Const IntPointer N_Array,
                         @Const IntPointer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntPointer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntPointer ldc_Array,
                         int group_count, @Const IntPointer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransB_Array, @Const IntBuffer M_Array, @Const IntBuffer N_Array,
                         @Const IntBuffer K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const IntBuffer lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const IntBuffer ldc_Array,
                         int group_count, @Const IntBuffer group_size);
public static native void cblas_zgemm3m_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE*") int[] TransA_Array,
                         @Cast("const CBLAS_TRANSPOSE*") int[] TransB_Array, @Const int[] M_Array, @Const int[] N_Array,
                         @Const int[] K_Array, @Const Pointer alpha_Array, @Cast("const void**") @ByPtrPtr Pointer A_Array,
                         @Const int[] lda_Array, @Cast("const void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                         @Const Pointer beta_Array, @Cast("void**") @ByPtrPtr Pointer C_Array, @Const int[] ldc_Array,
                         int group_count, @Const int[] group_size);
public static native void cblas_zgemmt(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB,
                  int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_zsymm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_zsyrk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer beta, Pointer C, int ldc);
public static native void cblas_zsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") PointerPointer A_array, @Const IntPointer lda_array,
                 @Const Pointer beta_array, @Cast("void**") PointerPointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_zsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntPointer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntPointer Trans_array, @Const IntPointer N_array, @Const IntPointer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const IntPointer lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const IntPointer ldc_array,
                 int group_count, @Const IntPointer group_size);
public static native void cblas_zsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") IntBuffer Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") IntBuffer Trans_array, @Const IntBuffer N_array, @Const IntBuffer K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const IntBuffer lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const IntBuffer ldc_array,
                 int group_count, @Const IntBuffer group_size);
public static native void cblas_zsyrk_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO*") int[] Uplo_array,
                 @Cast("const CBLAS_TRANSPOSE*") int[] Trans_array, @Const int[] N_array, @Const int[] K_array,
                 @Const Pointer alpha_array, @Cast("const void**") @ByPtrPtr Pointer A_array, @Const int[] lda_array,
                 @Const Pointer beta_array, @Cast("void**") @ByPtrPtr Pointer C_array, @Const int[] ldc_array,
                 int group_count, @Const int[] group_size);
public static native void cblas_zsyrk_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 @Const Pointer alpha, @Const Pointer A, int lda, int stridea,
                 @Const Pointer beta, Pointer C, int ldc, int stridec,
                 int batch_size);
public static native void cblas_zsyr2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, @Const Pointer beta,
                  Pointer C, int ldc);
public static native void cblas_ztrmm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ztrsm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 Pointer B, int ldb);
public static native void cblas_ztrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") PointerPointer A_Array, @Const IntPointer lda_Array,
                       @Cast("void**") PointerPointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ztrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntPointer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntPointer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntPointer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntPointer Diag_Array, @Const IntPointer M_Array,
                       @Const IntPointer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const IntPointer lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const IntPointer ldb_Array,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ztrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") IntBuffer Side_Array,
                       @Cast("const CBLAS_UPLO*") IntBuffer Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") IntBuffer Transa_Array,
                       @Cast("const CBLAS_DIAG*") IntBuffer Diag_Array, @Const IntBuffer M_Array,
                       @Const IntBuffer N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const IntBuffer lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const IntBuffer ldb_Array,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_ztrsm_batch(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE*") int[] Side_Array,
                       @Cast("const CBLAS_UPLO*") int[] Uplo_Array, @Cast("const CBLAS_TRANSPOSE*") int[] Transa_Array,
                       @Cast("const CBLAS_DIAG*") int[] Diag_Array, @Const int[] M_Array,
                       @Const int[] N_Array, @Const Pointer alpha_Array,
                       @Cast("const void**") @ByPtrPtr Pointer A_Array, @Const int[] lda_Array,
                       @Cast("void**") @ByPtrPtr Pointer B_Array, @Const int[] ldb_Array,
                       int group_count, @Const int[] group_size);
public static native void cblas_ztrsm_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                       @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                       @Cast("const CBLAS_DIAG") int Diag, int M,
                       int N, @Const Pointer alpha,
                       @Const Pointer A, int lda, int stridea,
                       Pointer B, int ldb, int strideb,
                       int batch_size);

/*
 * Routines with prefixes C and Z only
 */
public static native void cblas_chemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_cherk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 float alpha, @Const Pointer A, int lda,
                 float beta, Pointer C, int ldc);
public static native void cblas_cher2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, float beta,
                  Pointer C, int ldc);

public static native void cblas_zhemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_SIDE") int Side,
                 @Cast("const CBLAS_UPLO") int Uplo, int M, int N,
                 @Const Pointer alpha, @Const Pointer A, int lda,
                 @Const Pointer B, int ldb, @Const Pointer beta,
                 Pointer C, int ldc);
public static native void cblas_zherk(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                 @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                 double alpha, @Const Pointer A, int lda,
                 double beta, Pointer C, int ldc);
public static native void cblas_zher2k(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_UPLO") int Uplo,
                  @Cast("const CBLAS_TRANSPOSE") int Trans, int N, int K,
                  @Const Pointer alpha, @Const Pointer A, int lda,
                  @Const Pointer B, int ldb, double beta,
                  Pointer C, int ldc);

/*
 * Routines with prefixes S and D only
 */
public static native @Cast("size_t") long cblas_sgemm_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                 int M, int N, int K);
public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, float alpha, @Const FloatPointer src,
                      int ld, FloatPointer dest);
public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, float alpha, @Const FloatBuffer src,
                      int ld, FloatBuffer dest);
public static native void cblas_sgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, float alpha, @Const float[] src,
                      int ld, float[] dest);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const FloatPointer A,
                         int lda, @Const FloatPointer B, int ldb,
                         float beta, FloatPointer C, int ldc);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const FloatBuffer A,
                         int lda, @Const FloatBuffer B, int ldb,
                         float beta, FloatBuffer C, int ldc);
public static native void cblas_sgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const float[] A,
                         int lda, @Const float[] B, int ldb,
                         float beta, float[] C, int ldc);
public static native @Cast("size_t") long cblas_dgemm_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                 int M, int N, int K);
public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, double alpha, @Const DoublePointer src,
                      int ld, DoublePointer dest);
public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, double alpha, @Const DoubleBuffer src,
                      int ld, DoubleBuffer dest);
public static native void cblas_dgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N,
                      int K, double alpha, @Const double[] src,
                      int ld, double[] dest);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const DoublePointer A,
                         int lda, @Const DoublePointer B, int ldb,
                         double beta, DoublePointer C, int ldc);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const DoubleBuffer A,
                         int lda, @Const DoubleBuffer B, int ldb,
                         double beta, DoubleBuffer C, int ldc);
public static native void cblas_dgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB, int M, int N,
                         int K, @Const double[] A,
                         int lda, @Const double[] B, int ldb,
                         double beta, double[] C, int ldc);

public static native void cblas_hgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB,
                 int M, int N, int K,
                 @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") ShortPointer A, int lda,
                 @Cast("const unsigned short*") ShortPointer B, int ldb, @Cast("const unsigned short") short beta,
                 @Cast("unsigned short*") ShortPointer C, int ldc);
public static native void cblas_hgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB,
                 int M, int N, int K,
                 @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") ShortBuffer A, int lda,
                 @Cast("const unsigned short*") ShortBuffer B, int ldb, @Cast("const unsigned short") short beta,
                 @Cast("unsigned short*") ShortBuffer C, int ldc);
public static native void cblas_hgemm(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_TRANSPOSE") int TransB,
                 int M, int N, int K,
                 @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") short[] A, int lda,
                 @Cast("const unsigned short*") short[] B, int ldb, @Cast("const unsigned short") short beta,
                 @Cast("unsigned short*") short[] C, int ldc);
public static native @Cast("size_t") long cblas_hgemm_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                 int M, int N, int K);
public static native void cblas_hgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                      @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") ShortPointer src, int ld, @Cast("unsigned short*") ShortPointer dest);
public static native void cblas_hgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                      @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") ShortBuffer src, int ld, @Cast("unsigned short*") ShortBuffer dest);
public static native void cblas_hgemm_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                      @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                      @Cast("const unsigned short") short alpha, @Cast("const unsigned short*") short[] src, int ld, @Cast("unsigned short*") short[] dest);
public static native void cblas_hgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB,
                         int M, int N, int K,
                         @Cast("const unsigned short*") ShortPointer A, int lda,
                         @Cast("const unsigned short*") ShortPointer B, int ldb,
                         @Cast("const unsigned short") short beta,
                         @Cast("unsigned short*") ShortPointer C, int ldc);
public static native void cblas_hgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB,
                         int M, int N, int K,
                         @Cast("const unsigned short*") ShortBuffer A, int lda,
                         @Cast("const unsigned short*") ShortBuffer B, int ldb,
                         @Cast("const unsigned short") short beta,
                         @Cast("unsigned short*") ShortBuffer C, int ldc);
public static native void cblas_hgemm_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                         int TransB,
                         int M, int N, int K,
                         @Cast("const unsigned short*") short[] A, int lda,
                         @Cast("const unsigned short*") short[] B, int ldb,
                         @Cast("const unsigned short") short beta,
                         @Cast("unsigned short*") short[] C, int ldc);

/*
 * Integer Routines
 */
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const ShortPointer A, int lda, short ao,
                          @Const ShortPointer B, int ldb, short bo, float beta,
                          IntPointer C, int ldc, @Const IntPointer cb);
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const ShortBuffer A, int lda, short ao,
                          @Const ShortBuffer B, int ldb, short bo, float beta,
                          IntBuffer C, int ldc, @Const IntBuffer cb);
public static native void cblas_gemm_s16s16s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                          @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                          int M, int N, int K,
                          float alpha, @Const short[] A, int lda, short ao,
                          @Const short[] B, int ldb, short bo, float beta,
                          int[] C, int ldc, @Const int[] cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                        @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                        int M, int N, int K,
                        float alpha, @Const Pointer A, int lda, @Cast("const char") byte ao,
                        @Const Pointer B, int ldb, @Cast("const char") byte bo, float beta,
                        IntPointer C, int ldc, @Const IntPointer cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                        @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                        int M, int N, int K,
                        float alpha, @Const Pointer A, int lda, @Cast("const char") byte ao,
                        @Const Pointer B, int ldb, @Cast("const char") byte bo, float beta,
                        IntBuffer C, int ldc, @Const IntBuffer cb);
public static native void cblas_gemm_s8u8s32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                        @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const CBLAS_OFFSET") int OffsetC,
                        int M, int N, int K,
                        float alpha, @Const Pointer A, int lda, @Cast("const char") byte ao,
                        @Const Pointer B, int ldb, @Cast("const char") byte bo, float beta,
                        int[] C, int ldc, @Const int[] cb);
public static native void cblas_gemm_bf16bf16f32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                            @Cast("const CBLAS_TRANSPOSE") int TransB,
                            int M, int N, int K,
                            float alpha, @Cast("const unsigned short*") ShortPointer A, int lda,
                            @Cast("const unsigned short*") ShortPointer B, int ldb, float beta,
                            FloatPointer C, int ldc);
public static native void cblas_gemm_bf16bf16f32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                            @Cast("const CBLAS_TRANSPOSE") int TransB,
                            int M, int N, int K,
                            float alpha, @Cast("const unsigned short*") ShortBuffer A, int lda,
                            @Cast("const unsigned short*") ShortBuffer B, int ldb, float beta,
                            FloatBuffer C, int ldc);
public static native void cblas_gemm_bf16bf16f32(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_TRANSPOSE") int TransA,
                            @Cast("const CBLAS_TRANSPOSE") int TransB,
                            int M, int N, int K,
                            float alpha, @Cast("const unsigned short*") short[] A, int lda,
                            @Cast("const unsigned short*") short[] B, int ldb, float beta,
                            float[] C, int ldc);

public static native @Cast("size_t") long cblas_gemm_s8u8s32_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                        int M, int N, int K);
public static native @Cast("size_t") long cblas_gemm_s16s16s32_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                          int M, int N, int K);
public static native @Cast("size_t") long cblas_gemm_bf16bf16f32_pack_get_size(@Cast("const CBLAS_IDENTIFIER") int identifier,
                                          int M, int N, int K);

public static native void cblas_gemm_s8u8s32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                              @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                              @Const Pointer src, int ld, Pointer dest);
public static native void cblas_gemm_s16s16s32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Const ShortPointer src, int ld, ShortPointer dest);
public static native void cblas_gemm_s16s16s32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Const ShortBuffer src, int ld, ShortBuffer dest);
public static native void cblas_gemm_s16s16s32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Const short[] src, int ld, short[] dest);
public static native void cblas_gemm_bf16bf16f32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Cast("const unsigned short*") ShortPointer src, int ld, @Cast("unsigned short*") ShortPointer dest);
public static native void cblas_gemm_bf16bf16f32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Cast("const unsigned short*") ShortBuffer src, int ld, @Cast("unsigned short*") ShortBuffer dest);
public static native void cblas_gemm_bf16bf16f32_pack(@Cast("const CBLAS_LAYOUT") int Layout, @Cast("const CBLAS_IDENTIFIER") int identifier,
                               @Cast("const CBLAS_TRANSPOSE") int Trans, int M, int N, int K,
                               @Cast("const unsigned short*") short[] src, int ld, @Cast("unsigned short*") short[] dest);

public static native void cblas_gemm_s8u8s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                 int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                 int M, int N, int K,
                                 float alpha,
                                 @Const Pointer A, int lda, @Cast("const char") byte ao,
                                 @Const Pointer B, int ldb, @Cast("const char") byte bo,
                                 float beta,
                                 IntPointer C, int ldc, @Const IntPointer co);
public static native void cblas_gemm_s8u8s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                 int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                 int M, int N, int K,
                                 float alpha,
                                 @Const Pointer A, int lda, @Cast("const char") byte ao,
                                 @Const Pointer B, int ldb, @Cast("const char") byte bo,
                                 float beta,
                                 IntBuffer C, int ldc, @Const IntBuffer co);
public static native void cblas_gemm_s8u8s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                 int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                 int M, int N, int K,
                                 float alpha,
                                 @Const Pointer A, int lda, @Cast("const char") byte ao,
                                 @Const Pointer B, int ldb, @Cast("const char") byte bo,
                                 float beta,
                                 int[] C, int ldc, @Const int[] co);
public static native void cblas_gemm_s16s16s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                  int M, int N, int K,
                                  float alpha,
                                  @Const ShortPointer A, int lda, short ao,
                                  @Const ShortPointer B, int ldb, short bo,
                                  float beta,
                                  IntPointer C, int ldc, @Const IntPointer co);
public static native void cblas_gemm_s16s16s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                  int M, int N, int K,
                                  float alpha,
                                  @Const ShortBuffer A, int lda, short ao,
                                  @Const ShortBuffer B, int ldb, short bo,
                                  float beta,
                                  IntBuffer C, int ldc, @Const IntBuffer co);
public static native void cblas_gemm_s16s16s32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB, @Cast("const CBLAS_OFFSET") int offsetc,
                                  int M, int N, int K,
                                  float alpha,
                                  @Const short[] A, int lda, short ao,
                                  @Const short[] B, int ldb, short bo,
                                  float beta,
                                  int[] C, int ldc, @Const int[] co);
public static native void cblas_gemm_bf16bf16f32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB,
                                  int M, int N, int K,
                                  float alpha,
                                  @Cast("const unsigned short*") ShortPointer A, int lda,
                                  @Cast("const unsigned short*") ShortPointer B, int ldb,
                                  float beta,
                                  FloatPointer C, int ldc);
public static native void cblas_gemm_bf16bf16f32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB,
                                  int M, int N, int K,
                                  float alpha,
                                  @Cast("const unsigned short*") ShortBuffer A, int lda,
                                  @Cast("const unsigned short*") ShortBuffer B, int ldb,
                                  float beta,
                                  FloatBuffer C, int ldc);
public static native void cblas_gemm_bf16bf16f32_compute(@Cast("const CBLAS_LAYOUT") int Layout, int TransA,
                                  int TransB,
                                  int M, int N, int K,
                                  float alpha,
                                  @Cast("const unsigned short*") short[] A, int lda,
                                  @Cast("const unsigned short*") short[] B, int ldb,
                                  float beta,
                                  float[] C, int ldc);

/*
 * Jit routines
 */
// #ifndef mkl_jit_create_dgemm
// #define mkl_jit_create_dgemm mkl_cblas_jit_create_dgemm
// #endif
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_dgemm(@Cast("void**") PointerPointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            double alpha, int lda, int ldb,
                                            double beta, int ldc);
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_dgemm(@Cast("void**") @ByPtrPtr Pointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            double alpha, int lda, int ldb,
                                            double beta, int ldc);

// #ifndef mkl_jit_create_sgemm
// #define mkl_jit_create_sgemm mkl_cblas_jit_create_sgemm
// #endif
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_sgemm(@Cast("void**") PointerPointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            float alpha, int lda, int ldb,
                                            float beta, int ldc);
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_sgemm(@Cast("void**") @ByPtrPtr Pointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            float alpha, int lda, int ldb,
                                            float beta, int ldc);
// #ifndef mkl_jit_create_cgemm
// #define mkl_jit_create_cgemm mkl_cblas_jit_create_cgemm
// #endif
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_cgemm(@Cast("void**") PointerPointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            @Const Pointer alpha, int lda, int ldb,
                                            @Const Pointer beta, int ldc);
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_cgemm(@Cast("void**") @ByPtrPtr Pointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            @Const Pointer alpha, int lda, int ldb,
                                            @Const Pointer beta, int ldc);

// #ifndef mkl_jit_create_zgemm
// #define mkl_jit_create_zgemm mkl_cblas_jit_create_zgemm
// #endif
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_zgemm(@Cast("void**") PointerPointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            @Const Pointer alpha, int lda, int ldb,
                                            @Const Pointer beta, int ldc);
public static native @Cast("mkl_jit_status_t") int mkl_cblas_jit_create_zgemm(@Cast("void**") @ByPtrPtr Pointer jitter, @Cast("const MKL_LAYOUT") int layout, @Cast("const MKL_TRANSPOSE") int transa, @Cast("const MKL_TRANSPOSE") int transb,
                                            int m, int n, int k,
                                            @Const Pointer alpha, int lda, int ldb,
                                            @Const Pointer beta, int ldc);



public static native dgemm_jit_kernel_t mkl_jit_get_dgemm_ptr(@Const Pointer jitter);
public static native sgemm_jit_kernel_t mkl_jit_get_sgemm_ptr(@Const Pointer jitter);
public static native cgemm_jit_kernel_t mkl_jit_get_cgemm_ptr(@Const Pointer jitter);
public static native zgemm_jit_kernel_t mkl_jit_get_zgemm_ptr(@Const Pointer jitter);

public static native @Cast("mkl_jit_status_t") int mkl_jit_destroy(Pointer jitter);

/* Level1 BLAS batch API */

public static native void cblas_saxpy_batch(@Const IntPointer n, @Const FloatPointer alpha,
                       @Cast("const float**") PointerPointer x, @Const IntPointer incx,
                       @Cast("float**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_saxpy_batch(@Const IntPointer n, @Const FloatPointer alpha,
                       @Const @ByPtrPtr FloatPointer x, @Const IntPointer incx,
                       @ByPtrPtr FloatPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_saxpy_batch(@Const IntBuffer n, @Const FloatBuffer alpha,
                       @Const @ByPtrPtr FloatBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr FloatBuffer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_saxpy_batch(@Const int[] n, @Const float[] alpha,
                       @Const @ByPtrPtr float[] x, @Const int[] incx,
                       @ByPtrPtr float[] y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_daxpy_batch(@Const IntPointer n, @Const DoublePointer alpha,
                       @Cast("const double**") PointerPointer x, @Const IntPointer incx,
                       @Cast("double**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_daxpy_batch(@Const IntPointer n, @Const DoublePointer alpha,
                       @Const @ByPtrPtr DoublePointer x, @Const IntPointer incx,
                       @ByPtrPtr DoublePointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_daxpy_batch(@Const IntBuffer n, @Const DoubleBuffer alpha,
                       @Const @ByPtrPtr DoubleBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr DoubleBuffer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_daxpy_batch(@Const int[] n, @Const double[] alpha,
                       @Const @ByPtrPtr double[] x, @Const int[] incx,
                       @ByPtrPtr double[] y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_caxpy_batch(@Const IntPointer n, @Const Pointer alpha,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_caxpy_batch(@Const IntPointer n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_caxpy_batch(@Const IntBuffer n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_caxpy_batch(@Const int[] n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_zaxpy_batch(@Const IntPointer n, @Const Pointer alpha,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zaxpy_batch(@Const IntPointer n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zaxpy_batch(@Const IntBuffer n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zaxpy_batch(@Const int[] n, @Const Pointer alpha,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_saxpy_batch_strided(int N, float alpha,
                               @Const FloatPointer X, int incX, int stridex,
                               FloatPointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_saxpy_batch_strided(int N, float alpha,
                               @Const FloatBuffer X, int incX, int stridex,
                               FloatBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_saxpy_batch_strided(int N, float alpha,
                               @Const float[] X, int incX, int stridex,
                               float[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_daxpy_batch_strided(int N, double alpha,
                               @Const DoublePointer X, int incX, int stridex,
                               DoublePointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_daxpy_batch_strided(int N, double alpha,
                               @Const DoubleBuffer X, int incX, int stridex,
                               DoubleBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_daxpy_batch_strided(int N, double alpha,
                               @Const double[] X, int incX, int stridex,
                               double[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_caxpy_batch_strided(int N, @Const Pointer alpha,
                               @Const Pointer X, int incX, int stridex,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_zaxpy_batch_strided(int N, @Const Pointer alpha,
                               @Const Pointer X, int incX, int stridex,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_scopy_batch(@Const IntPointer n,
                       @Cast("const float**") PointerPointer x, @Const IntPointer incx,
                       @Cast("float**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_scopy_batch(@Const IntPointer n,
                       @Const @ByPtrPtr FloatPointer x, @Const IntPointer incx,
                       @ByPtrPtr FloatPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_scopy_batch(@Const IntBuffer n,
                       @Const @ByPtrPtr FloatBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr FloatBuffer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_scopy_batch(@Const int[] n,
                       @Const @ByPtrPtr float[] x, @Const int[] incx,
                       @ByPtrPtr float[] y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_dcopy_batch(@Const IntPointer n,
                       @Cast("const double**") PointerPointer x, @Const IntPointer incx,
                       @Cast("double**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dcopy_batch(@Const IntPointer n,
                       @Const @ByPtrPtr DoublePointer x, @Const IntPointer incx,
                       @ByPtrPtr DoublePointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dcopy_batch(@Const IntBuffer n,
                       @Const @ByPtrPtr DoubleBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr DoubleBuffer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_dcopy_batch(@Const int[] n,
                       @Const @ByPtrPtr double[] x, @Const int[] incx,
                       @ByPtrPtr double[] y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_ccopy_batch(@Const IntPointer n,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ccopy_batch(@Const IntPointer n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ccopy_batch(@Const IntBuffer n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_ccopy_batch(@Const int[] n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_zcopy_batch(@Const IntPointer n,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zcopy_batch(@Const IntPointer n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntPointer incy,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zcopy_batch(@Const IntBuffer n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const IntBuffer incy,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zcopy_batch(@Const int[] n,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer y, @Const int[] incy,
                       int group_count, @Const int[] group_size);

public static native void cblas_scopy_batch_strided(int N,
                               @Const FloatPointer X, int incX, int stridex,
                               FloatPointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_scopy_batch_strided(int N,
                               @Const FloatBuffer X, int incX, int stridex,
                               FloatBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_scopy_batch_strided(int N,
                               @Const float[] X, int incX, int stridex,
                               float[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_dcopy_batch_strided(int N,
                               @Const DoublePointer X, int incX, int stridex,
                               DoublePointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_dcopy_batch_strided(int N,
                               @Const DoubleBuffer X, int incX, int stridex,
                               DoubleBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_dcopy_batch_strided(int N,
                               @Const double[] X, int incX, int stridex,
                               double[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_ccopy_batch_strided(int N,
                               @Const Pointer X, int incX, int stridex,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_zcopy_batch_strided(int N,
                               @Const Pointer X, int incX, int stridex,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

/* Level2 BLAS batch API */

public static native void cblas_sgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const FloatPointer alpha, @Cast("const float**") PointerPointer A, @Const IntPointer lda,
                       @Cast("const float**") PointerPointer X, @Const IntPointer incX, @Const FloatPointer beta,
                       @Cast("float**") PointerPointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const FloatPointer alpha, @Const @ByPtrPtr FloatPointer A, @Const IntPointer lda,
                       @Const @ByPtrPtr FloatPointer X, @Const IntPointer incX, @Const FloatPointer beta,
                       @ByPtrPtr FloatPointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA, @Const IntBuffer M, @Const IntBuffer N,
                       @Const FloatBuffer alpha, @Const @ByPtrPtr FloatBuffer A, @Const IntBuffer lda,
                       @Const @ByPtrPtr FloatBuffer X, @Const IntBuffer incX, @Const FloatBuffer beta,
                       @ByPtrPtr FloatBuffer Y, @Const IntBuffer incY,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_sgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransA, @Const int[] M, @Const int[] N,
                       @Const float[] alpha, @Const @ByPtrPtr float[] A, @Const int[] lda,
                       @Const @ByPtrPtr float[] X, @Const int[] incX, @Const float[] beta,
                       @ByPtrPtr float[] Y, @Const int[] incY,
                       int group_count, @Const int[] group_size);

public static native void cblas_sgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               float alpha, @Const FloatPointer A, int lda, int stridea,
                               @Const FloatPointer X, int incX, int stridex, float beta,
                               FloatPointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_sgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               float alpha, @Const FloatBuffer A, int lda, int stridea,
                               @Const FloatBuffer X, int incX, int stridex, float beta,
                               FloatBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_sgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               float alpha, @Const float[] A, int lda, int stridea,
                               @Const float[] X, int incX, int stridex, float beta,
                               float[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_dgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const DoublePointer alpha, @Cast("const double**") PointerPointer A, @Const IntPointer lda,
                       @Cast("const double**") PointerPointer X, @Const IntPointer incX, @Const DoublePointer beta,
                       @Cast("double**") PointerPointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const DoublePointer alpha, @Const @ByPtrPtr DoublePointer A, @Const IntPointer lda,
                       @Const @ByPtrPtr DoublePointer X, @Const IntPointer incX, @Const DoublePointer beta,
                       @ByPtrPtr DoublePointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_dgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA, @Const IntBuffer M, @Const IntBuffer N,
                       @Const DoubleBuffer alpha, @Const @ByPtrPtr DoubleBuffer A, @Const IntBuffer lda,
                       @Const @ByPtrPtr DoubleBuffer X, @Const IntBuffer incX, @Const DoubleBuffer beta,
                       @ByPtrPtr DoubleBuffer Y, @Const IntBuffer incY,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_dgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransA, @Const int[] M, @Const int[] N,
                       @Const double[] alpha, @Const @ByPtrPtr double[] A, @Const int[] lda,
                       @Const @ByPtrPtr double[] X, @Const int[] incX, @Const double[] beta,
                       @ByPtrPtr double[] Y, @Const int[] incY,
                       int group_count, @Const int[] group_size);

public static native void cblas_dgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               double alpha, @Const DoublePointer A, int lda, int stridea,
                               @Const DoublePointer X, int incX, int stridex, double beta,
                               DoublePointer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_dgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               double alpha, @Const DoubleBuffer A, int lda, int stridea,
                               @Const DoubleBuffer X, int incX, int stridex, double beta,
                               DoubleBuffer Y, int incY, int stridey,
                               int batch_size);
public static native void cblas_dgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               double alpha, @Const double[] A, int lda, int stridea,
                               @Const double[] X, int incX, int stridex, double beta,
                               double[] Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_cgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const Pointer alpha, @Cast("const void**") PointerPointer A, @Const IntPointer lda,
                       @Cast("const void**") PointerPointer X, @Const IntPointer incX, @Const Pointer beta,
                       @Cast("void**") PointerPointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const IntPointer lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const IntPointer incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA, @Const IntBuffer M, @Const IntBuffer N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const IntBuffer lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const IntBuffer incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const IntBuffer incY,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_cgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransA, @Const int[] M, @Const int[] N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const int[] lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const int[] incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const int[] incY,
                       int group_count, @Const int[] group_size);

public static native void cblas_cgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               @Const Pointer alpha, @Const Pointer A, int lda, int stridea,
                               @Const Pointer X, int incX, int stridex, @Const Pointer beta,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_zgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const Pointer alpha, @Cast("const void**") PointerPointer A, @Const IntPointer lda,
                       @Cast("const void**") PointerPointer X, @Const IntPointer incX, @Const Pointer beta,
                       @Cast("void**") PointerPointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntPointer TransA, @Const IntPointer M, @Const IntPointer N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const IntPointer lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const IntPointer incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const IntPointer incY,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") IntBuffer TransA, @Const IntBuffer M, @Const IntBuffer N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const IntBuffer lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const IntBuffer incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const IntBuffer incY,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zgemv_batch(@Cast("const CBLAS_LAYOUT") int Layout,
                       @Cast("const CBLAS_TRANSPOSE*") int[] TransA, @Const int[] M, @Const int[] N,
                       @Const Pointer alpha, @Cast("const void**") @ByPtrPtr Pointer A, @Const int[] lda,
                       @Cast("const void**") @ByPtrPtr Pointer X, @Const int[] incX, @Const Pointer beta,
                       @Cast("void**") @ByPtrPtr Pointer Y, @Const int[] incY,
                       int group_count, @Const int[] group_size);

public static native void cblas_zgemv_batch_strided(@Cast("const CBLAS_LAYOUT") int Layout,
                               @Cast("const CBLAS_TRANSPOSE") int TransA, int M, int N,
                               @Const Pointer alpha, @Const Pointer A, int lda, int stridea,
                               @Const Pointer X, int incX, int stridex, @Const Pointer beta,
                               Pointer Y, int incY, int stridey,
                               int batch_size);

public static native void cblas_sdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const float**") PointerPointer a, @Const IntPointer lda,
                       @Cast("const float**") PointerPointer x, @Const IntPointer incx,
                       @Cast("float**") PointerPointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Const @ByPtrPtr FloatPointer a, @Const IntPointer lda,
                       @Const @ByPtrPtr FloatPointer x, @Const IntPointer incx,
                       @ByPtrPtr FloatPointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_sdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntBuffer side, @Const IntBuffer m, @Const IntBuffer n,
                       @Const @ByPtrPtr FloatBuffer a, @Const IntBuffer lda,
                       @Const @ByPtrPtr FloatBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr FloatBuffer c, @Const IntBuffer ldc,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_sdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") int[] side, @Const int[] m, @Const int[] n,
                       @Const @ByPtrPtr float[] a, @Const int[] lda,
                       @Const @ByPtrPtr float[] x, @Const int[] incx,
                       @ByPtrPtr float[] c, @Const int[] ldc,
                       int group_count, @Const int[] group_size);

public static native void cblas_sdgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const FloatPointer a, int lda, int stridea,
                               @Const FloatPointer x, int incx, int stridex,
                               FloatPointer c, int ldc, int stridec,
                               int batch_size);
public static native void cblas_sdgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const FloatBuffer a, int lda, int stridea,
                               @Const FloatBuffer x, int incx, int stridex,
                               FloatBuffer c, int ldc, int stridec,
                               int batch_size);
public static native void cblas_sdgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const float[] a, int lda, int stridea,
                               @Const float[] x, int incx, int stridex,
                               float[] c, int ldc, int stridec,
                               int batch_size);

public static native void cblas_ddgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const double**") PointerPointer a, @Const IntPointer lda,
                       @Cast("const double**") PointerPointer x, @Const IntPointer incx,
                       @Cast("double**") PointerPointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ddgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Const @ByPtrPtr DoublePointer a, @Const IntPointer lda,
                       @Const @ByPtrPtr DoublePointer x, @Const IntPointer incx,
                       @ByPtrPtr DoublePointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_ddgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntBuffer side, @Const IntBuffer m, @Const IntBuffer n,
                       @Const @ByPtrPtr DoubleBuffer a, @Const IntBuffer lda,
                       @Const @ByPtrPtr DoubleBuffer x, @Const IntBuffer incx,
                       @ByPtrPtr DoubleBuffer c, @Const IntBuffer ldc,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_ddgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") int[] side, @Const int[] m, @Const int[] n,
                       @Const @ByPtrPtr double[] a, @Const int[] lda,
                       @Const @ByPtrPtr double[] x, @Const int[] incx,
                       @ByPtrPtr double[] c, @Const int[] ldc,
                       int group_count, @Const int[] group_size);

public static native void cblas_ddgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const DoublePointer a, int lda, int stridea,
                               @Const DoublePointer x, int incx, int stridex,
                               DoublePointer c, int ldc, int stridec,
                               int batch_size);
public static native void cblas_ddgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const DoubleBuffer a, int lda, int stridea,
                               @Const DoubleBuffer x, int incx, int stridex,
                               DoubleBuffer c, int ldc, int stridec,
                               int batch_size);
public static native void cblas_ddgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const double[] a, int lda, int stridea,
                               @Const double[] x, int incx, int stridex,
                               double[] c, int ldc, int stridec,
                               int batch_size);

public static native void cblas_cdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const void**") PointerPointer a, @Const IntPointer lda,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const IntPointer lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_cdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntBuffer side, @Const IntBuffer m, @Const IntBuffer n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const IntBuffer lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const IntBuffer ldc,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_cdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") int[] side, @Const int[] m, @Const int[] n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const int[] lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const int[] ldc,
                       int group_count, @Const int[] group_size);

public static native void cblas_cdgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const Pointer a, int lda, int stridea,
                               @Const Pointer x, int incx, int stridex,
                               Pointer c, int ldc, int stridec,
                               int batch_size);

public static native void cblas_zdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const void**") PointerPointer a, @Const IntPointer lda,
                       @Cast("const void**") PointerPointer x, @Const IntPointer incx,
                       @Cast("void**") PointerPointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntPointer side, @Const IntPointer m, @Const IntPointer n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const IntPointer lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntPointer incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const IntPointer ldc,
                       int group_count, @Const IntPointer group_size);
public static native void cblas_zdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") IntBuffer side, @Const IntBuffer m, @Const IntBuffer n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const IntBuffer lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const IntBuffer incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const IntBuffer ldc,
                       int group_count, @Const IntBuffer group_size);
public static native void cblas_zdgmm_batch(@Cast("const CBLAS_LAYOUT") int layout,
                       @Cast("const CBLAS_SIDE*") int[] side, @Const int[] m, @Const int[] n,
                       @Cast("const void**") @ByPtrPtr Pointer a, @Const int[] lda,
                       @Cast("const void**") @ByPtrPtr Pointer x, @Const int[] incx,
                       @Cast("void**") @ByPtrPtr Pointer c, @Const int[] ldc,
                       int group_count, @Const int[] group_size);

public static native void cblas_zdgmm_batch_strided(@Cast("const CBLAS_LAYOUT") int layout,
                               @Cast("const CBLAS_SIDE") int side, int m, int n,
                               @Const Pointer a, int lda, int stridea,
                               @Const Pointer x, int incx, int stridex,
                               Pointer c, int ldc, int stridec,
                               int batch_size);


// #ifdef __cplusplus
// #endif /* __cplusplus */

// #include "mkl_cblas_64.h"

// #endif /* __MKL_CBLAS_H__ */


// Parsed from mkl_spblas.h

/*******************************************************************************
* Copyright 2005-2022 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
! Content:
!  Intel(R) oneAPI Math Kernel Library (oneMKL) interface for Sparse BLAS
!  level 2,3 routines
!
!******************************************************************************/

// #ifndef _MKL_SPBLAS_H_
// #define _MKL_SPBLAS_H_

// #include "mkl_types.h"

// #ifdef __GNUC__
// #define MKL_DEPRECATED __attribute__((deprecated))
// #elif defined(_MSC_VER)
// #define MKL_DEPRECATED __declspec(deprecated)
// #else
// #pragma message("WARNING: MKL SpBLAS was declared deprecated. Use MKL IE SpBLAS instead")
// #define MKL_DEPRECATED
// #endif

// #ifdef __cplusplus
// #endif /* __cplusplus */

/* Float */
/* Sparse BLAS Level2 lower case */
public static native @Deprecated void mkl_scsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scsrmv(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrsv(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrsv(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrsv(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrgemv(String transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrgemv(String transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrgemv(String transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrgemv(String transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrgemv(String transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrgemv(String transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrsymv(String uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrsymv(String uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrsymv(String uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrsymv(String uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrsymv(String uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrsymv(String uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);

public static native @Deprecated void mkl_scscmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scscmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scscmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scscmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scscmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scscmv(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scscsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scscsv(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scscsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scscsv(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scscsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scscsv(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);

public static native @Deprecated void mkl_scoomv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scoomv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scoomv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scoomv(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_scoomv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_scoomv(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_scoosv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoosv(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoosv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scoosv(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoosv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoosv(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoogemv(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scoogemv(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoogemv(String transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scoogemv(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scoogemv(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scoogemv(String transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoosymv(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scoosymv(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scoosymv(String uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scoosymv(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scoosymv(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scoosymv(String uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_scootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_scootrsv(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_scootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_scootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_scootrsv(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);

public static native @Deprecated void mkl_sdiamv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sdiamv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sdiamv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sdiamv(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sdiamv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sdiamv(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sdiasv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiasv(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiasv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiasv(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiasv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiasv(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiagemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiagemv(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiagemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiagemv(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiagemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiagemv(String transa, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiasymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiasymv(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiasymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiasymv(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiasymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiasymv(String uplo, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiatrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sdiatrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sdiatrsv(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);

public static native @Deprecated void mkl_sskymv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sskymv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sskymv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sskymv(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sskymv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sskymv(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sskysv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sskysv(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sskysv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sskysv(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sskysv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sskysv(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, float[] y);

public static native @Deprecated void mkl_sbsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sbsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sbsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sbsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void mkl_sbsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void mkl_sbsrmv(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void mkl_sbsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrsv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrsv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrsv(String transa, @Const int[] m, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_sbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_sbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void mkl_cspblas_sbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);

/* Sparse BLAS Level3 lower case */
public static native @Deprecated void mkl_scsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scsrsm(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_scscmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scscmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scscmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scscmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scscmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scscmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scscsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scscsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scscsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scscsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scscsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scscsm(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_scoomm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scoomm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scoomm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scoomm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scoomm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scoomm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scoosm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scoosm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scoosm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_scoosm(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_scoosm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_scoosm(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_sdiamm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sdiamm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sdiamm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sdiamm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sdiamm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sdiamm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sdiasm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sdiasm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sdiasm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sdiasm(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sdiasm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sdiasm(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_sskysm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sskysm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sskysm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sskysm(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sskysm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sskysm(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sskymm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sskymm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sskymm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sskymm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sskymm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sskymm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_sbsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sbsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sbsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sbsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sbsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sbsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sbsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sbsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sbsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_sbsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_sbsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_sbsrsm(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

/* Upper case declaration */
/* Sparse BLAS Level2 upper case */
public static native @Deprecated void MKL_SCSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCSRMV(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRSV(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRSV(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRSV(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRGEMV(String transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRGEMV(String transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRGEMV(String transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(String transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(String transa, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRGEMV(String transa, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRSYMV(String uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRSYMV(String uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRSYMV(String uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(String uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(String uplo, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRSYMV(String uplo, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);

public static native @Deprecated void MKL_SCSCMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCSCMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCSCMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCSCMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCSCMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCSCMV(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCSCSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSCSV(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSCSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCSCSV(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCSCSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCSCSV(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);

public static native @Deprecated void MKL_SCOOMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCOOMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCOOMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCOOMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SCOOMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SCOOMV(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SCOOSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOSV(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOSV(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOSV(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOGEMV(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOGEMV(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOGEMV(String transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOGEMV(String transa, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOSYMV(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOSYMV(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOSYMV(String uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOSYMV(String uplo, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] x, float[] y);

public static native @Deprecated void MKL_SDIAMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SDIAMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SDIAMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SDIAMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SDIAMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SDIAMV(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SDIASV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIASV(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIASV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIASV(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIASV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIASV(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIAGEMV(String transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIAGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIAGEMV(String transa, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIAGEMV(String transa, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIASYMV(String uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIASYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIASYMV(String uplo, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIASYMV(String uplo, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIATRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SDIATRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SDIATRSV(String uplo, String transa, String diag, @Const int[] m, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] x, float[] y);

public static native @Deprecated void MKL_SSKYMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SSKYMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SSKYMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SSKYMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SSKYMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SSKYMV(String transa, @Const int[] m, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SSKYSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SSKYSV(String transa, @Const IntBuffer m, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SSKYSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SSKYSV(String transa, @Const IntPointer m, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SSKYSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SSKYSV(String transa, @Const int[] m, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] x, float[] y);

public static native @Deprecated void MKL_SBSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SBSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SBSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SBSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, @Const FloatPointer beta, FloatPointer y);
public static native @Deprecated void MKL_SBSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, @Const FloatBuffer beta, FloatBuffer y);
public static native @Deprecated void MKL_SBSRMV(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, @Const float[] beta, float[] y);
public static native @Deprecated void MKL_SBSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRSV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRSV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRSV(String transa, @Const int[] m, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_SBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_SBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Const FloatPointer x, FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const FloatBuffer x, FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_SBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const float[] a, @Const int[] ia, @Const int[] ja, @Const float[] x, float[] y);

/* Sparse BLAS Level3 upper case */
public static native @Deprecated void MKL_SCSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSRSM(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_SCSCMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSCMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSCMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSCMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSCMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSCMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSCSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSCSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSCSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCSCSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCSCSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCSCSM(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_SCOOMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCOOMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCOOMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCOOMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCOOMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCOOMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCOOSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCOOSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCOOSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SCOOSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SCOOSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SCOOSM(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_SDIAMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SDIAMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SDIAMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SDIAMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SDIAMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SDIAMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SDIASM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SDIASM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SDIASM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SDIASM(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SDIASM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SDIASM(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_SSKYSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SSKYSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SSKYSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SSKYSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SSKYSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SSKYSM(String transa, @Const int[] m, @Const int[] n, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SSKYMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SSKYMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SSKYMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SSKYMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer pntr, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SSKYMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer pntr, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SSKYMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] pntr, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_SBSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SBSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SBSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SBSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, @Const FloatPointer beta, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SBSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, @Const FloatBuffer beta, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SBSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, @Const float[] beta, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SBSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SBSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const FloatBuffer alpha, String matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SBSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const float[] alpha, @Cast("const char*") BytePointer matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_SBSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const FloatPointer alpha, String matdescra, @Const FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const FloatPointer b, @Const IntPointer ldb, FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_SBSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const FloatBuffer b, @Const IntBuffer ldb, FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_SBSRSM(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const float[] alpha, String matdescra, @Const float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const float[] b, @Const int[] ldb, float[] c, @Const int[] ldc);

/* Double */
/* Sparse BLAS Level2 lower case */
public static native @Deprecated void mkl_dcsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrmv(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrsv(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrsv(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrsv(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrgemv(String transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrgemv(String transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrgemv(String transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(String transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(String transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrgemv(String transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrsymv(String uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrsymv(String uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrsymv(String uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(String uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(String uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrsymv(String uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);

public static native @Deprecated void mkl_dcscmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcscmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcscmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcscmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcscmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcscmv(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcscsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcscsv(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcscsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcscsv(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcscsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcscsv(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);

public static native @Deprecated void mkl_dcoomv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcoomv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcoomv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcoomv(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dcoomv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dcoomv(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dcoosv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoosv(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoosv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcoosv(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoosv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoosv(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoogemv(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcoogemv(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoogemv(String transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcoogemv(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcoogemv(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcoogemv(String transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoosymv(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcoosymv(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcoosymv(String uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcoosymv(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcoosymv(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcoosymv(String uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dcootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dcootrsv(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dcootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dcootrsv(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);

public static native @Deprecated void mkl_ddiamv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_ddiamv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_ddiamv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_ddiamv(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_ddiamv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_ddiamv(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_ddiasv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiasv(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiasv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiasv(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiasv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiasv(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiagemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiagemv(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiagemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiagemv(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiagemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiagemv(String transa, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiasymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiasymv(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiasymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiasymv(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiasymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiasymv(String uplo, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiatrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void mkl_ddiatrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_ddiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_ddiatrsv(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);

public static native @Deprecated void mkl_dskymv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dskymv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dskymv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dskymv(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dskymv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dskymv(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dskysv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dskysv(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dskysv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dskysv(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dskysv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dskysv(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, double[] y);

public static native @Deprecated void mkl_dbsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dbsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dbsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void mkl_dbsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrmv(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void mkl_dbsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrsv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrsv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrsv(String transa, @Const int[] m, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_dbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_dbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_dbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);

/* Sparse BLAS Level3 lower case */
public static native @Deprecated void mkl_dcsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcsrsm(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_dcscmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcscmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcscmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcscmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcscmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcscmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcscsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcscsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcscsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcscsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcscsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcscsm(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_dcoomm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcoomm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcoomm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcoomm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcoomm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcoomm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcoosm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcoosm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcoosm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dcoosm(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dcoosm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dcoosm(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_ddiamm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ddiamm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ddiamm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ddiamm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ddiamm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ddiamm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ddiasm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ddiasm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ddiasm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ddiasm(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ddiasm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ddiasm(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_dskysm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dskysm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dskysm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dskysm(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dskysm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dskysm(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dskymm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dskymm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dskymm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dskymm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dskymm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dskymm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_dbsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dbsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dbsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dbsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dbsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dbsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dbsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dbsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dbsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_dbsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_dbsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_dbsrsm(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

/* Upper case declaration */
/* Sparse BLAS Level2 upper case */
public static native @Deprecated void MKL_DCSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRMV(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRSV(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRSV(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRSV(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRGEMV(String transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRGEMV(String transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRGEMV(String transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(String transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(String transa, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRGEMV(String transa, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRSYMV(String uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRSYMV(String uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRSYMV(String uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(String uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(String uplo, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRSYMV(String uplo, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);

public static native @Deprecated void MKL_DCSCMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCSCMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCSCMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCSCMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCSCMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCSCMV(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCSCSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSCSV(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSCSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCSCSV(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCSCSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCSCSV(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);

public static native @Deprecated void MKL_DCOOMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCOOMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCOOMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DCOOMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOMV(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DCOOSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOSV(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOSV(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOSV(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOGEMV(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOGEMV(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOGEMV(String transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOGEMV(String transa, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOSYMV(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOSYMV(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOSYMV(String uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOSYMV(String uplo, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] x, double[] y);

public static native @Deprecated void MKL_DDIAMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DDIAMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DDIAMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DDIAMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DDIAMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DDIAMV(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DDIASV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIASV(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIASV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIASV(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIASV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIASV(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIAGEMV(String transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIAGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIAGEMV(String transa, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIAGEMV(String transa, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIASYMV(String uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIASYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIASYMV(String uplo, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIASYMV(String uplo, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIATRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DDIATRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DDIATRSV(String uplo, String transa, String diag, @Const int[] m, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] x, double[] y);

public static native @Deprecated void MKL_DSKYMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DSKYMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DSKYMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DSKYMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DSKYMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DSKYMV(String transa, @Const int[] m, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DSKYSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DSKYSV(String transa, @Const IntBuffer m, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DSKYSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DSKYSV(String transa, @Const IntPointer m, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DSKYSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DSKYSV(String transa, @Const int[] m, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] x, double[] y);

public static native @Deprecated void MKL_DBSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DBSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DBSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, @Const DoublePointer beta, DoublePointer y);
public static native @Deprecated void MKL_DBSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, @Const DoubleBuffer beta, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRMV(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, @Const double[] beta, double[] y);
public static native @Deprecated void MKL_DBSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRSV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRSV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRSV(String transa, @Const int[] m, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_DBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_DBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Const DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Const DoublePointer x, DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Const DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Const DoubleBuffer x, DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_DBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Const double[] a, @Const int[] ia, @Const int[] ja, @Const double[] x, double[] y);

/* Sparse BLAS Level3 upper case */
public static native @Deprecated void MKL_DCSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSRSM(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_DCSCMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSCMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSCMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSCMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSCMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSCMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSCSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSCSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSCSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCSCSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCSCSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCSCSM(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_DCOOMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCOOMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCOOMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCOOMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCOOMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCOOMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCOOSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCOOSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCOOSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DCOOSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DCOOSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DCOOSM(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_DDIAMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DDIAMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DDIAMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DDIAMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DDIAMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DDIAMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DDIASM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DDIASM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DDIASM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DDIASM(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DDIASM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DDIASM(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_DSKYSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DSKYSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DSKYSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DSKYSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DSKYSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DSKYSM(String transa, @Const int[] m, @Const int[] n, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DSKYMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DSKYMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DSKYMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DSKYMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer pntr, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DSKYMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer pntr, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DSKYMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] pntr, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_DBSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DBSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DBSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DBSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, @Const DoublePointer beta, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DBSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, @Const DoubleBuffer beta, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DBSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, @Const double[] beta, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DBSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DBSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const DoubleBuffer alpha, String matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DBSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const double[] alpha, @Cast("const char*") BytePointer matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_DBSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Const DoublePointer alpha, String matdescra, @Const DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Const DoublePointer b, @Const IntPointer ldb, DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_DBSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Const DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Const DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Const DoubleBuffer b, @Const IntBuffer ldb, DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_DBSRSM(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Const double[] alpha, String matdescra, @Const double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Const double[] b, @Const int[] ldb, double[] c, @Const int[] ldc);

/* MKL_Complex8 */
/* Sparse BLAS Level2 lower case */
public static native @Deprecated void mkl_ccsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrmv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrsv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrsv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrsv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrgemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrgemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrgemv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrgemv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrsymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrsymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrsymv(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrsymv(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void mkl_ccscmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccscmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccscmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccscmv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccscmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccscmv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccscsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccscsv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccscsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccscsv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccscsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccscsv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void mkl_ccoomv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoomv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoomv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoomv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoomv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoomv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoosv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoosv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoosv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoosv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoosv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoosv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoogemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoogemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoogemv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccoogemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccoogemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccoogemv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoosymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccoosymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccoosymv(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccoosymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccoosymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccoosymv(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_ccootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_ccootrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_ccootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_ccootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_ccootrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void mkl_cdiamv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiamv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiamv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiamv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiamv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiamv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiasv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiasv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiasv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiasv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiasv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiasv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiagemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiagemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiagemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiagemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiagemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiagemv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiasymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiasymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiasymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiasymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiasymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiasymv(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiatrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cdiatrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cdiatrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void mkl_cskymv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cskymv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cskymv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cskymv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cskymv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cskymv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cskysv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cskysv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cskysv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cskysv(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cskysv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cskysv(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void mkl_cbsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrmv(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrsv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrsv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrsv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void mkl_cspblas_cbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

/* Sparse BLAS Level3 lower case */
public static native @Deprecated void mkl_ccsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccsrsm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_ccscmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccscmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccscmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccscmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccscmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccscmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccscsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccscsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccscsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccscsm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccscsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccscsm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_ccoomm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccoomm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccoomm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccoomm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccoomm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccoomm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccoosm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccoosm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccoosm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_ccoosm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_ccoosm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_ccoosm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_cdiamm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cdiamm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cdiamm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cdiamm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cdiamm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cdiamm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cdiasm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cdiasm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cdiasm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cdiasm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cdiasm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cdiasm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_cskysm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cskysm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cskysm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cskysm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cskysm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cskysm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cskymm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cskymm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cskymm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cskymm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cskymm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cskymm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void mkl_cbsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cbsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cbsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cbsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cbsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cbsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cbsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cbsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cbsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void mkl_cbsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_cbsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_cbsrsm(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

/* Upper case declaration */
/* Sparse BLAS Level2 upper case */
public static native @Deprecated void MKL_CCSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRSV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void MKL_CCSCMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSCMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSCMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSCMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSCMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSCMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSCSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSCSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSCSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCSCSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCSCSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCSCSV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void MKL_CCOOMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOSV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void MKL_CDIAMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIAMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIAMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIAMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIAMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIAMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIASV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIASV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIASV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIASV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIASV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIASV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIAGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIAGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIAGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIAGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIASYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIASYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIASYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIASYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIATRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CDIATRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CDIATRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void MKL_CSKYMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSKYMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSKYMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSKYMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSKYMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSKYMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSKYSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSKYSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSKYSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSKYSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSKYSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSKYSV(String transa, @Const int[] m, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

public static native @Deprecated void MKL_CBSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRMV(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRSV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRSV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRSV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex8*") FloatPointer x, @Cast("MKL_Complex8*") FloatPointer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex8*") FloatBuffer x, @Cast("MKL_Complex8*") FloatBuffer y);
public static native @Deprecated void MKL_CSPBLAS_CBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex8*") float[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex8*") float[] x, @Cast("MKL_Complex8*") float[] y);

/* Sparse BLAS Level3 upper case */
public static native @Deprecated void MKL_CCSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSRSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_CCSCMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSCMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSCMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSCMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSCMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSCMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSCSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSCSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSCSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCSCSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCSCSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCSCSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_CCOOMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCOOMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCOOMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCOOMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCOOMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCOOMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCOOSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCOOSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCOOSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CCOOSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CCOOSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CCOOSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_CDIAMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CDIAMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CDIAMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CDIAMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CDIAMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CDIAMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CDIASM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CDIASM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CDIASM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CDIASM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CDIASM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CDIASM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_CSKYSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CSKYSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CSKYSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CSKYSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CSKYSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CSKYSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CSKYMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CSKYMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CSKYMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CSKYMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer pntr, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CSKYMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CSKYMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] pntr, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

public static native @Deprecated void MKL_CBSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CBSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CBSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CBSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("const MKL_Complex8*") FloatPointer beta, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CBSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex8*") FloatBuffer beta, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CBSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("const MKL_Complex8*") float[] beta, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CBSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CBSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CBSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);
public static native @Deprecated void MKL_CBSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex8*") FloatPointer alpha, String matdescra, @Cast("const MKL_Complex8*") FloatPointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex8*") FloatPointer b, @Const IntPointer ldb, @Cast("MKL_Complex8*") FloatPointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_CBSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex8*") FloatBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex8*") FloatBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex8*") FloatBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex8*") FloatBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_CBSRSM(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex8*") float[] alpha, String matdescra, @Cast("const MKL_Complex8*") float[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex8*") float[] b, @Const int[] ldb, @Cast("MKL_Complex8*") float[] c, @Const int[] ldc);

/* MKL_Complex16 */
/* Sparse BLAS Level2 lower case */
public static native @Deprecated void mkl_zcsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrmv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrsv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrsv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrsv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrgemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrgemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrgemv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrgemv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrsymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrsymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrsymv(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrsymv(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void mkl_zcscmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcscmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcscmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcscmv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcscmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcscmv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcscsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcscsv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcscsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcscsv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcscsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcscsv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void mkl_zcoomv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoomv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoomv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoomv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoomv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoomv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoosv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoosv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoosv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoosv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoosv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoosv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoogemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoogemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoogemv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcoogemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcoogemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcoogemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcoogemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcoogemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcoogemv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoosymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcoosymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcoosymv(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcoosymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcoosymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcoosymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcoosymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcoosymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcoosymv(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zcootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zcootrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcootrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zcootrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zcootrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zcootrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void mkl_zdiamv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiamv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiamv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiamv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiamv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiamv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiasv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiasv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiasv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiasv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiasv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiasv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiagemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiagemv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiagemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiagemv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiagemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiagemv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiasymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiasymv(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiasymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiasymv(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiasymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiasymv(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiatrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zdiatrsv(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zdiatrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zdiatrsv(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void mkl_zskymv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zskymv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zskymv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zskymv(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zskymv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zskymv(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zskysv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zskysv(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zskysv(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zskysv(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zskysv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zskysv(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void mkl_zbsrmv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrmv(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrmv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrmv(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrmv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrmv(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrsv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrsv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrsv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrsv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrsv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrsv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrgemv(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrsymv(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_zbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_zbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void mkl_cspblas_zbsrtrsv(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

/* Sparse BLAS Level3 lower case */
public static native @Deprecated void mkl_zcsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcsrsm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_zcscmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcscmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcscmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcscmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcscmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcscmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcscsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcscsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcscsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcscsm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcscsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcscsm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_zcoomm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcoomm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcoomm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcoomm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcoomm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcoomm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcoosm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcoosm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcoosm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zcoosm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zcoosm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zcoosm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_zdiamm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zdiamm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zdiamm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zdiamm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zdiamm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zdiamm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zdiasm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zdiasm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zdiasm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zdiasm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zdiasm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zdiasm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_zskysm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zskysm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zskysm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zskysm(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zskysm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zskysm(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zskymm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zskymm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zskymm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zskymm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zskymm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zskymm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void mkl_zbsrmm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zbsrmm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zbsrmm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zbsrmm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zbsrmm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zbsrmm(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zbsrsm(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zbsrsm(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zbsrsm(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void mkl_zbsrsm(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void mkl_zbsrsm(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void mkl_zbsrsm(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

/* Upper case declaration */
/* Sparse BLAS Level2 upper case */
public static native @Deprecated void MKL_ZCSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRSV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void MKL_ZCSCMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSCMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSCMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSCMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSCMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSCMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSCSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSCSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSCSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCSCSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCSCSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCSCSV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void MKL_ZCOOMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOSV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOSYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZCOOTRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void MKL_ZDIAMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIAMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIAMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIAMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIAMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIAMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIASV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIASV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIASV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIASV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIASV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIASV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIAGEMV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIAGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIAGEMV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIAGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIAGEMV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIASYMV(String uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIASYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIASYMV(String uplo, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIASYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIASYMV(String uplo, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIATRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZDIATRSV(String uplo, String transa, String diag, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZDIATRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZDIATRSV(String uplo, String transa, String diag, @Const int[] m, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void MKL_ZSKYMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZSKYMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZSKYMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZSKYMV(String transa, @Const IntPointer m, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZSKYMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZSKYMV(String transa, @Const int[] m, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZSKYSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZSKYSV(String transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZSKYSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZSKYSV(String transa, @Const IntPointer m, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZSKYSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZSKYSV(String transa, @Const int[] m, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

public static native @Deprecated void MKL_ZBSRMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRMV(String transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRMV(String transa, @Const IntPointer m, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRMV(String transa, @Const int[] m, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRSV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRSV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRSV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRSV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRSV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRSV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(String transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(String transa, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRGEMV(String transa, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(String uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(String uplo, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(@Cast("const char*") BytePointer uplo, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRSYMV(String uplo, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_ZBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_ZBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(String uplo, String transa, String diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(String uplo, String transa, String diag, @Const IntPointer m, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer a, @Const IntPointer ia, @Const IntPointer ja, @Cast("const MKL_Complex16*") DoublePointer x, @Cast("MKL_Complex16*") DoublePointer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(@Cast("const char*") BytePointer uplo, @Cast("const char*") BytePointer transa, @Cast("const char*") BytePointer diag, @Const IntBuffer m, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer a, @Const IntBuffer ia, @Const IntBuffer ja, @Cast("const MKL_Complex16*") DoubleBuffer x, @Cast("MKL_Complex16*") DoubleBuffer y);
public static native @Deprecated void MKL_CSPBLAS_ZBSRTRSV(String uplo, String transa, String diag, @Const int[] m, @Const int[] lb, @Cast("const MKL_Complex16*") double[] a, @Const int[] ia, @Const int[] ja, @Cast("const MKL_Complex16*") double[] x, @Cast("MKL_Complex16*") double[] y);

/* Sparse BLAS Level3 upper case */
public static native @Deprecated void MKL_ZCSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSRSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_ZCSCMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSCMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSCMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSCMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSCMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSCMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSCSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSCSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSCSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCSCSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCSCSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCSCSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_ZCOOMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCOOMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCOOMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCOOMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCOOMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCOOMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCOOSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCOOSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCOOSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZCOOSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer rowind, @Const IntPointer colind, @Const IntPointer nnz, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZCOOSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer rowind, @Const IntBuffer colind, @Const IntBuffer nnz, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZCOOSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] rowind, @Const int[] colind, @Const int[] nnz, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_ZDIAMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZDIAMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZDIAMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZDIAMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZDIAMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZDIAMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZDIASM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZDIASM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZDIASM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZDIASM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer lval, @Const IntPointer idiag, @Const IntPointer ndiag, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZDIASM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer lval, @Const IntBuffer idiag, @Const IntBuffer ndiag, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZDIASM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] lval, @Const int[] idiag, @Const int[] ndiag, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_ZSKYSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZSKYSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZSKYSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZSKYSM(String transa, @Const IntPointer m, @Const IntPointer n, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZSKYSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZSKYSM(String transa, @Const int[] m, @Const int[] n, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZSKYMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZSKYMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZSKYMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZSKYMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer pntr, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZSKYMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer pntr, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZSKYMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] pntr, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

public static native @Deprecated void MKL_ZBSRMM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZBSRMM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZBSRMM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZBSRMM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer k, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("const MKL_Complex16*") DoublePointer beta, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZBSRMM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer k, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("const MKL_Complex16*") DoubleBuffer beta, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZBSRMM(String transa, @Const int[] m, @Const int[] n, @Const int[] k, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("const MKL_Complex16*") double[] beta, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZBSRSM(@Cast("const char*") BytePointer transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZBSRSM(String transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, String matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZBSRSM(@Cast("const char*") BytePointer transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);
public static native @Deprecated void MKL_ZBSRSM(String transa, @Const IntPointer m, @Const IntPointer n, @Const IntPointer lb, @Cast("const MKL_Complex16*") DoublePointer alpha, String matdescra, @Cast("const MKL_Complex16*") DoublePointer val, @Const IntPointer indx, @Const IntPointer pntrb, @Const IntPointer pntre, @Cast("const MKL_Complex16*") DoublePointer b, @Const IntPointer ldb, @Cast("MKL_Complex16*") DoublePointer c, @Const IntPointer ldc);
public static native @Deprecated void MKL_ZBSRSM(@Cast("const char*") BytePointer transa, @Const IntBuffer m, @Const IntBuffer n, @Const IntBuffer lb, @Cast("const MKL_Complex16*") DoubleBuffer alpha, @Cast("const char*") BytePointer matdescra, @Cast("const MKL_Complex16*") DoubleBuffer val, @Const IntBuffer indx, @Const IntBuffer pntrb, @Const IntBuffer pntre, @Cast("const MKL_Complex16*") DoubleBuffer b, @Const IntBuffer ldb, @Cast("MKL_Complex16*") DoubleBuffer c, @Const IntBuffer ldc);
public static native @Deprecated void MKL_ZBSRSM(String transa, @Const int[] m, @Const int[] n, @Const int[] lb, @Cast("const MKL_Complex16*") double[] alpha, String matdescra, @Cast("const MKL_Complex16*") double[] val, @Const int[] indx, @Const int[] pntrb, @Const int[] pntre, @Cast("const MKL_Complex16*") double[] b, @Const int[] ldb, @Cast("MKL_Complex16*") double[] c, @Const int[] ldc);

/*Converters lower case*/
public static native @Deprecated void mkl_dcsrbsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, DoublePointer Acsr, IntPointer AJ, IntPointer AI, DoublePointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void mkl_dcsrbsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, DoubleBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void mkl_dcsrbsr(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, double[] Acsr, int[] AJ, int[] AI, double[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void mkl_dcsrcoo(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, DoublePointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void mkl_dcsrcoo(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, DoubleBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void mkl_dcsrcoo(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJR, int[] AIR, int[] nnz, double[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void mkl_ddnscsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, DoublePointer Adns, @Const IntPointer lda, DoublePointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void mkl_ddnscsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, DoubleBuffer Adns, @Const IntBuffer lda, DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void mkl_ddnscsr(@Const int[] job, @Const int[] m, @Const int[] n, double[] Adns, @Const int[] lda, double[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void mkl_dcsrcsc(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, DoublePointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void mkl_dcsrcsc(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, DoubleBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void mkl_dcsrcsc(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0, double[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void mkl_dcsrdia(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, DoublePointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, DoublePointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void mkl_dcsrdia(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, DoubleBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, DoubleBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void mkl_dcsrdia(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0, double[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, double[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void mkl_dcsrsky(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0,  DoublePointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void mkl_dcsrsky(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  DoubleBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void mkl_dcsrsky(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0,  double[] Asky, int[] pointers, int[] info);

public static native @Deprecated void mkl_scsrbsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, FloatPointer Acsr, IntPointer AJ, IntPointer AI, FloatPointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void mkl_scsrbsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, FloatBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void mkl_scsrbsr(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, float[] Acsr, int[] AJ, int[] AI, float[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void mkl_scsrcoo(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, FloatPointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void mkl_scsrcoo(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, FloatBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void mkl_scsrcoo(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJR, int[] AIR, int[] nnz, float[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void mkl_sdnscsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, FloatPointer Adns, @Const IntPointer lda, FloatPointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void mkl_sdnscsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, FloatBuffer Adns, @Const IntBuffer lda, FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void mkl_sdnscsr(@Const int[] job, @Const int[] m, @Const int[] n, float[] Adns, @Const int[] lda, float[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void mkl_scsrcsc(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, FloatPointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void mkl_scsrcsc(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, FloatBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void mkl_scsrcsc(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0, float[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void mkl_scsrdia(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, FloatPointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, FloatPointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void mkl_scsrdia(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, FloatBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, FloatBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void mkl_scsrdia(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0, float[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, float[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void mkl_scsrsky(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0,  FloatPointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void mkl_scsrsky(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  FloatBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void mkl_scsrsky(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0,  float[] Asky, int[] pointers, int[] info);

public static native @Deprecated void mkl_ccsrbsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ, IntPointer AI, @Cast("MKL_Complex8*") FloatPointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void mkl_ccsrbsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, @Cast("MKL_Complex8*") FloatBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void mkl_ccsrbsr(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ, int[] AI, @Cast("MKL_Complex8*") float[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void mkl_ccsrcoo(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, @Cast("MKL_Complex8*") FloatPointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void mkl_ccsrcoo(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, @Cast("MKL_Complex8*") FloatBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void mkl_ccsrcoo(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJR, int[] AIR, int[] nnz, @Cast("MKL_Complex8*") float[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void mkl_cdnscsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Adns, @Const IntPointer lda, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void mkl_cdnscsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Adns, @Const IntBuffer lda, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void mkl_cdnscsr(@Const int[] job, @Const int[] m, @Const int[] n, @Cast("MKL_Complex8*") float[] Adns, @Const int[] lda, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void mkl_ccsrcsc(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex8*") FloatPointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void mkl_ccsrcsc(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex8*") FloatBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void mkl_ccsrcsc(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex8*") float[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void mkl_ccsrdia(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex8*") FloatPointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, @Cast("MKL_Complex8*") FloatPointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void mkl_ccsrdia(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex8*") FloatBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, @Cast("MKL_Complex8*") FloatBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void mkl_ccsrdia(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex8*") float[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, @Cast("MKL_Complex8*") float[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void mkl_ccsrsky(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0,  @Cast("MKL_Complex8*") FloatPointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void mkl_ccsrsky(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  @Cast("MKL_Complex8*") FloatBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void mkl_ccsrsky(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0,  @Cast("MKL_Complex8*") float[] Asky, int[] pointers, int[] info);

public static native @Deprecated void mkl_zcsrbsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ, IntPointer AI, @Cast("MKL_Complex16*") DoublePointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void mkl_zcsrbsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, @Cast("MKL_Complex16*") DoubleBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void mkl_zcsrbsr(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ, int[] AI, @Cast("MKL_Complex16*") double[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void mkl_zcsrcoo(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, @Cast("MKL_Complex16*") DoublePointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void mkl_zcsrcoo(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, @Cast("MKL_Complex16*") DoubleBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void mkl_zcsrcoo(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJR, int[] AIR, int[] nnz, @Cast("MKL_Complex16*") double[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void mkl_zdnscsr(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Adns, @Const IntPointer lda, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void mkl_zdnscsr(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Adns, @Const IntBuffer lda, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void mkl_zdnscsr(@Const int[] job, @Const int[] m, @Const int[] n, @Cast("MKL_Complex16*") double[] Adns, @Const int[] lda, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void mkl_zcsrcsc(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex16*") DoublePointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void mkl_zcsrcsc(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex16*") DoubleBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void mkl_zcsrcsc(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex16*") double[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void mkl_zcsrdia(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex16*") DoublePointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, @Cast("MKL_Complex16*") DoublePointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void mkl_zcsrdia(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex16*") DoubleBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, @Cast("MKL_Complex16*") DoubleBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void mkl_zcsrdia(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex16*") double[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, @Cast("MKL_Complex16*") double[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void mkl_zcsrsky(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0,  @Cast("MKL_Complex16*") DoublePointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void mkl_zcsrsky(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  @Cast("MKL_Complex16*") DoubleBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void mkl_zcsrsky(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0,  @Cast("MKL_Complex16*") double[] Asky, int[] pointers, int[] info);

/*Converters upper case*/
public static native @Deprecated void MKL_DCSRBSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, DoublePointer Acsr, IntPointer AJ, IntPointer AI, DoublePointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void MKL_DCSRBSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, DoubleBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void MKL_DCSRBSR(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, double[] Acsr, int[] AJ, int[] AI, double[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void MKL_DCSRCOO(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, DoublePointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void MKL_DCSRCOO(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, DoubleBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void MKL_DCSRCOO(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJR, int[] AIR, int[] nnz, double[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void MKL_DDNSCSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, DoublePointer Adns, @Const IntPointer lda, DoublePointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void MKL_DDNSCSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, DoubleBuffer Adns, @Const IntBuffer lda, DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void MKL_DDNSCSR(@Const int[] job, @Const int[] m, @Const int[] n, double[] Adns, @Const int[] lda, double[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void MKL_DCSRCSC(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, DoublePointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void MKL_DCSRCSC(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, DoubleBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void MKL_DCSRCSC(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0, double[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void MKL_DCSRDIA(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, DoublePointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, DoublePointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void MKL_DCSRDIA(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, DoubleBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, DoubleBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void MKL_DCSRDIA(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0, double[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, double[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void MKL_DCSRSKY(@Const IntPointer job, @Const IntPointer n, DoublePointer Acsr, IntPointer AJ0, IntPointer AI0,  DoublePointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void MKL_DCSRSKY(@Const IntBuffer job, @Const IntBuffer n, DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  DoubleBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void MKL_DCSRSKY(@Const int[] job, @Const int[] n, double[] Acsr, int[] AJ0, int[] AI0,  double[] Asky, int[] pointers, int[] info);

public static native @Deprecated void MKL_SCSRBSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, FloatPointer Acsr, IntPointer AJ, IntPointer AI, FloatPointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void MKL_SCSRBSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, FloatBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void MKL_SCSRBSR(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, float[] Acsr, int[] AJ, int[] AI, float[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void MKL_SCSRCOO(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, FloatPointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void MKL_SCSRCOO(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, FloatBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void MKL_SCSRCOO(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJR, int[] AIR, int[] nnz, float[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void MKL_SDNSCSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, FloatPointer Adns, @Const IntPointer lda, FloatPointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void MKL_SDNSCSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, FloatBuffer Adns, @Const IntBuffer lda, FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void MKL_SDNSCSR(@Const int[] job, @Const int[] m, @Const int[] n, float[] Adns, @Const int[] lda, float[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void MKL_SCSRCSC(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, FloatPointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void MKL_SCSRCSC(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, FloatBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void MKL_SCSRCSC(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0, float[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void MKL_SCSRDIA(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, FloatPointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, FloatPointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void MKL_SCSRDIA(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, FloatBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, FloatBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void MKL_SCSRDIA(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0, float[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, float[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void MKL_SCSRSKY(@Const IntPointer job, @Const IntPointer n, FloatPointer Acsr, IntPointer AJ0, IntPointer AI0,  FloatPointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void MKL_SCSRSKY(@Const IntBuffer job, @Const IntBuffer n, FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  FloatBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void MKL_SCSRSKY(@Const int[] job, @Const int[] n, float[] Acsr, int[] AJ0, int[] AI0,  float[] Asky, int[] pointers, int[] info);

public static native @Deprecated void MKL_CCSRBSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ, IntPointer AI, @Cast("MKL_Complex8*") FloatPointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void MKL_CCSRBSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, @Cast("MKL_Complex8*") FloatBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void MKL_CCSRBSR(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ, int[] AI, @Cast("MKL_Complex8*") float[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void MKL_CCSRCOO(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, @Cast("MKL_Complex8*") FloatPointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void MKL_CCSRCOO(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, @Cast("MKL_Complex8*") FloatBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void MKL_CCSRCOO(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJR, int[] AIR, int[] nnz, @Cast("MKL_Complex8*") float[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void MKL_CDNSCSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Adns, @Const IntPointer lda, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void MKL_CDNSCSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Adns, @Const IntBuffer lda, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void MKL_CDNSCSR(@Const int[] job, @Const int[] m, @Const int[] n, @Cast("MKL_Complex8*") float[] Adns, @Const int[] lda, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void MKL_CCSRCSC(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex8*") FloatPointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void MKL_CCSRCSC(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex8*") FloatBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void MKL_CCSRCSC(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex8*") float[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void MKL_CCSRDIA(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex8*") FloatPointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, @Cast("MKL_Complex8*") FloatPointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void MKL_CCSRDIA(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex8*") FloatBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, @Cast("MKL_Complex8*") FloatBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void MKL_CCSRDIA(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex8*") float[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, @Cast("MKL_Complex8*") float[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void MKL_CCSRSKY(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex8*") FloatPointer Acsr, IntPointer AJ0, IntPointer AI0,  @Cast("MKL_Complex8*") FloatPointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void MKL_CCSRSKY(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex8*") FloatBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  @Cast("MKL_Complex8*") FloatBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void MKL_CCSRSKY(@Const int[] job, @Const int[] n, @Cast("MKL_Complex8*") float[] Acsr, int[] AJ0, int[] AI0,  @Cast("MKL_Complex8*") float[] Asky, int[] pointers, int[] info);

public static native @Deprecated void MKL_ZCSRBSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer mblk, @Const IntPointer ldAbsr, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ, IntPointer AI, @Cast("MKL_Complex16*") DoublePointer Absr,  IntPointer AJB,  IntPointer AIB,  IntPointer info);
public static native @Deprecated void MKL_ZCSRBSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer mblk, @Const IntBuffer ldAbsr, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, @Cast("MKL_Complex16*") DoubleBuffer Absr,  IntBuffer AJB,  IntBuffer AIB,  IntBuffer info);
public static native @Deprecated void MKL_ZCSRBSR(@Const int[] job, @Const int[] m, @Const int[] mblk, @Const int[] ldAbsr, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ, int[] AI, @Cast("MKL_Complex16*") double[] Absr,  int[] AJB,  int[] AIB,  int[] info);
public static native @Deprecated void MKL_ZCSRCOO(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJR, IntPointer AIR, IntPointer nnz, @Cast("MKL_Complex16*") DoublePointer Acoo,  IntPointer ir,  IntPointer jc,  IntPointer info);
public static native @Deprecated void MKL_ZCSRCOO(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJR, IntBuffer AIR, IntBuffer nnz, @Cast("MKL_Complex16*") DoubleBuffer Acoo,  IntBuffer ir,  IntBuffer jc,  IntBuffer info);
public static native @Deprecated void MKL_ZCSRCOO(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJR, int[] AIR, int[] nnz, @Cast("MKL_Complex16*") double[] Acoo,  int[] ir,  int[] jc,  int[] info);
public static native @Deprecated void MKL_ZDNSCSR(@Const IntPointer job, @Const IntPointer m, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Adns, @Const IntPointer lda, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ, IntPointer AI, IntPointer info);
public static native @Deprecated void MKL_ZDNSCSR(@Const IntBuffer job, @Const IntBuffer m, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Adns, @Const IntBuffer lda, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ, IntBuffer AI, IntBuffer info);
public static native @Deprecated void MKL_ZDNSCSR(@Const int[] job, @Const int[] m, @Const int[] n, @Cast("MKL_Complex16*") double[] Adns, @Const int[] lda, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ, int[] AI, int[] info);
public static native @Deprecated void MKL_ZCSRCSC(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex16*") DoublePointer Acsc, IntPointer AJ1, IntPointer AI1, IntPointer info);
public static native @Deprecated void MKL_ZCSRCSC(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex16*") DoubleBuffer Acsc, IntBuffer AJ1, IntBuffer AI1, IntBuffer info);
public static native @Deprecated void MKL_ZCSRCSC(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex16*") double[] Acsc, int[] AJ1, int[] AI1, int[] info);
public static native @Deprecated void MKL_ZCSRDIA(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0, @Cast("MKL_Complex16*") DoublePointer Adia, @Const IntPointer ndiag, IntPointer distance, IntPointer idiag, @Cast("MKL_Complex16*") DoublePointer Acsr_rem, IntPointer AJ0_rem, IntPointer AI0_rem, IntPointer info);
public static native @Deprecated void MKL_ZCSRDIA(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0, @Cast("MKL_Complex16*") DoubleBuffer Adia, @Const IntBuffer ndiag, IntBuffer distance, IntBuffer idiag, @Cast("MKL_Complex16*") DoubleBuffer Acsr_rem, IntBuffer AJ0_rem, IntBuffer AI0_rem, IntBuffer info);
public static native @Deprecated void MKL_ZCSRDIA(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0, @Cast("MKL_Complex16*") double[] Adia, @Const int[] ndiag, int[] distance, int[] idiag, @Cast("MKL_Complex16*") double[] Acsr_rem, int[] AJ0_rem, int[] AI0_rem, int[] info);
public static native @Deprecated void MKL_ZCSRSKY(@Const IntPointer job, @Const IntPointer n, @Cast("MKL_Complex16*") DoublePointer Acsr, IntPointer AJ0, IntPointer AI0,  @Cast("MKL_Complex16*") DoublePointer Asky, IntPointer pointers, IntPointer info);
public static native @Deprecated void MKL_ZCSRSKY(@Const IntBuffer job, @Const IntBuffer n, @Cast("MKL_Complex16*") DoubleBuffer Acsr, IntBuffer AJ0, IntBuffer AI0,  @Cast("MKL_Complex16*") DoubleBuffer Asky, IntBuffer pointers, IntBuffer info);
public static native @Deprecated void MKL_ZCSRSKY(@Const int[] job, @Const int[] n, @Cast("MKL_Complex16*") double[] Acsr, int[] AJ0, int[] AI0,  @Cast("MKL_Complex16*") double[] Asky, int[] pointers, int[] info);


/*Sparse BLAS Level2 (CSR-CSR or CSR-DNS) lower case */
public static native @Deprecated void mkl_dcsrmultcsr(@Cast("const char*") BytePointer transa,  @Const IntPointer job,  @Const IntPointer sort,  @Const IntPointer m,  @Const IntPointer n,  @Const IntPointer k, DoublePointer a,  IntPointer ja, IntPointer ia, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer jc,  IntPointer ic,  @Const IntPointer nnzmax,  IntPointer ierr);
public static native @Deprecated void mkl_dcsrmultcsr(String transa,  @Const IntBuffer job,  @Const IntBuffer sort,  @Const IntBuffer m,  @Const IntBuffer n,  @Const IntBuffer k, DoubleBuffer a,  IntBuffer ja, IntBuffer ia, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer jc,  IntBuffer ic,  @Const IntBuffer nnzmax,  IntBuffer ierr);
public static native @Deprecated void mkl_dcsrmultcsr(@Cast("const char*") BytePointer transa,  @Const int[] job,  @Const int[] sort,  @Const int[] m,  @Const int[] n,  @Const int[] k, double[] a,  int[] ja, int[] ia, double[] b, int[] jb, int[] ib,  double[] c,  int[] jc,  int[] ic,  @Const int[] nnzmax,  int[] ierr);
public static native @Deprecated void mkl_dcsrmultcsr(String transa,  @Const IntPointer job,  @Const IntPointer sort,  @Const IntPointer m,  @Const IntPointer n,  @Const IntPointer k, DoublePointer a,  IntPointer ja, IntPointer ia, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer jc,  IntPointer ic,  @Const IntPointer nnzmax,  IntPointer ierr);
public static native @Deprecated void mkl_dcsrmultcsr(@Cast("const char*") BytePointer transa,  @Const IntBuffer job,  @Const IntBuffer sort,  @Const IntBuffer m,  @Const IntBuffer n,  @Const IntBuffer k, DoubleBuffer a,  IntBuffer ja, IntBuffer ia, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer jc,  IntBuffer ic,  @Const IntBuffer nnzmax,  IntBuffer ierr);
public static native @Deprecated void mkl_dcsrmultcsr(String transa,  @Const int[] job,  @Const int[] sort,  @Const int[] m,  @Const int[] n,  @Const int[] k, double[] a,  int[] ja, int[] ia, double[] b, int[] jb, int[] ib,  double[] c,  int[] jc,  int[] ic,  @Const int[] nnzmax,  int[] ierr);
public static native @Deprecated void mkl_dcsrmultd(@Cast("const char*") BytePointer transa,   @Const IntPointer m,  @Const IntPointer n,  @Const IntPointer k, DoublePointer a, IntPointer ja, IntPointer ia, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer ldc);
public static native @Deprecated void mkl_dcsrmultd(String transa,   @Const IntBuffer m,  @Const IntBuffer n,  @Const IntBuffer k, DoubleBuffer a, IntBuffer ja, IntBuffer ia, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer ldc);
public static native @Deprecated void mkl_dcsrmultd(@Cast("const char*") BytePointer transa,   @Const int[] m,  @Const int[] n,  @Const int[] k, double[] a, int[] ja, int[] ia, double[] b, int[] jb, int[] ib,  double[] c,  int[] ldc);
public static native @Deprecated void mkl_dcsrmultd(String transa,   @Const IntPointer m,  @Const IntPointer n,  @Const IntPointer k, DoublePointer a, IntPointer ja, IntPointer ia, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer ldc);
public static native @Deprecated void mkl_dcsrmultd(@Cast("const char*") BytePointer transa,   @Const IntBuffer m,  @Const IntBuffer n,  @Const IntBuffer k, DoubleBuffer a, IntBuffer ja, IntBuffer ia, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer ldc);
public static native @Deprecated void mkl_dcsrmultd(String transa,   @Const int[] m,  @Const int[] n,  @Const int[] k, double[] a, int[] ja, int[] ia, double[] b, int[] jb, int[] ib,  double[] c,  int[] ldc);
public static native @Deprecated void mkl_dcsradd(@Cast("const char*") BytePointer transa,  @Const IntPointer job,  @Const IntPointer sort,  @Const IntPointer m,  @Const IntPointer n, DoublePointer a, IntPointer ja, IntPointer ia,  @Const DoublePointer beta, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer jc,  IntPointer ic,  @Const IntPointer nnzmax,  IntPointer ierr);
public static native @Deprecated void mkl_dcsradd(String transa,  @Const IntBuffer job,  @Const IntBuffer sort,  @Const IntBuffer m,  @Const IntBuffer n, DoubleBuffer a, IntBuffer ja, IntBuffer ia,  @Const DoubleBuffer beta, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer jc,  IntBuffer ic,  @Const IntBuffer nnzmax,  IntBuffer ierr);
public static native @Deprecated void mkl_dcsradd(@Cast("const char*") BytePointer transa,  @Const int[] job,  @Const int[] sort,  @Const int[] m,  @Const int[] n, double[] a, int[] ja, int[] ia,  @Const double[] beta, double[] b, int[] jb, int[] ib,  double[] c,  int[] jc,  int[] ic,  @Const int[] nnzmax,  int[] ierr);
public static native @Deprecated void mkl_dcsradd(String transa,  @Const IntPointer job,  @Const IntPointer sort,  @Const IntPointer m,  @Const IntPointer n, DoublePointer a, IntPointer ja, IntPointer ia,  @Const DoublePointer beta, DoublePointer b, IntPointer jb, IntPointer ib,  DoublePointer c,  IntPointer jc,  IntPointer ic,  @Const IntPointer nnzmax,  IntPointer ierr);
public static native @Deprecated void mkl_dcsradd(@Cast("const char*") BytePointer transa,  @Const IntBuffer job,  @Const IntBuffer sort,  @Const IntBuffer m,  @Const IntBuffer n, DoubleBuffer a, IntBuffer ja, IntBuffer ia,  @Const DoubleBuffer beta, DoubleBuffer b, IntBuffer jb, IntBuffer ib,  DoubleBuffer c,  IntBuffer jc,  IntBuffer ic,  @Const IntBuffer nnzmax,  IntBuffer ierr);
public static native @Deprecated void mkl_dcsradd(String transa,  @Const int[] job,  @Const int[] sort,  @Const int[] m,  @Const int[] n, double[] a, int[] ja, int[] ia,  @Const double[] beta, double[] b, int[] jb, int[] ib,  double[] c,  int[] jc,  int[] ic,  @Const int[] nnzmax,  int[] ierr);

public static native @Deprecated void mkl_scsrmultcsr(@Cast("const char*") BytePointer transa,  @Const IntPointer job,  @Const IntPointer sort,  @Const IntPointer m,  @Const IntPointer n,  @Const IntPointer k, FloatPointer a, IntPointer ja, IntPointer ia, FloatPointer b, IntPointer jb, IntPointer ib,  FloatPointer c,  IntPointer jc,  IntPointer ic,  @Co