// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.onnx;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.onnx.global.onnx.*;


// We use data propagation to perform partial evaluation of the model, to compute statically
// known information about tensor values. It is intended to improve the precision of shape
// inference. We reuse TensorShapeProto to represent the statically known values. One
// limitation of this is that TensorShapeProto can represent only integer values.
// As an example, data-propagation is intended to handle code-fragments like below:
//   shape = Shape(X)
//   batchsize = Slice(shape, [0], [1])
//   newshape = Concat (batchsize, [1024, 1024])
//   Z = Reshape(Y, newshape)
// If the shape of X is statically known, then data-propagation should be able to determine
// the value of newshape, as well as the shape of Z.
@Namespace("onnx") @Properties(inherit = org.bytedeco.onnx.presets.onnx.class)
public class DataPropagationContext extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataPropagationContext(Pointer p) { super(p); }

  public native @Const AttributeProto getAttribute(@StdString BytePointer name);
  public native @Const AttributeProto getAttribute(@StdString String name);
  public native @Cast("size_t") long getNumInputs();
  public native @Const TypeProto getInputType(@Cast("size_t") long index);
  public native @Cast("size_t") long getNumOutputs();
  public native @Const TypeProto getOutputType(@Cast("size_t") long index);
  public native @Const TensorShapeProto getInputData(@Cast("size_t") long index);
  public native void addOutputData(@Cast("size_t") long index, @ByRef(true) TensorShapeProto tp);
}
